// Copyright 2022-2024 Advanced Micro Devices, Inc. All Rights Reserved.
////////////////////////////////////////////////////////////////////////
#pragma once
#include <cstring>
#include <filesystem>
#include <fstream>
#include <iostream>
#include <string>
#include <vector>

#include <cstdint>
#include <sstream>
#include <iomanip>
#include "xrt/xrt_kernel.h"
namespace waic_runner {
	static const size_t MAX_INSTR_BUFSZ = 50331648ULL; // 48MB
	constexpr auto KERNEL_NAME = "DPU";
	constexpr auto KERNEL_NAME_ELF = "DPU_ELF";
	constexpr std::uint64_t DDR_AIE_ADDR_OFFSET = std::uint64_t{ 0x80000000 };
	constexpr std::uint64_t OPCODE = std::uint64_t{ 2 };
	constexpr std::uint64_t ELF_OPCODE = std::uint64_t{ 3 };
	static constexpr uint32_t HOST_BO_GROUP_ID = 0;
	using bfloat16 = int16_t;
	static constexpr size_t XRT_BO_MIN_SIZE = 4096; // Bytes
	static constexpr size_t XRT_BO_INIT_VALUE = 0;

	static constexpr size_t TENSOR_PACK_ALIGNMENT = 4; // Bytes
#ifdef _WIN32
    std::string make_long_path(const std::filesystem::path& file_path);
#endif

	std::vector<uint8_t> ReadBinaryFile(const std::string& filename, bool verbose);
	void ApplyCtrlPktPatch(uint8_t* pCtrlPktBuf, size_t offset, uint64_t fm_ddr_addr, uint64_t ext_buf_ddr_offset, bool verbose);

	size_t readDataFromFile(const char* fileName, std::vector<uint32_t>& tensor, bool verbose);
	//void writeDataToFile(const char *fileName, uint32_t *buf, const size_t bufSize);
	void read_bin_file(std::string filename, char* data);
	void write_bin_file(std::string filename, char* data, size_t size);

	size_t align_to_next(size_t n, size_t alignment);
	size_t get_size_of_type(const std::string& type);

	FILE* create_tmpfile();
	void dump_to_tmpfile(FILE* file, char* data, size_t size);
	void save_tmpfile_on_disk(const std::filesystem::path& path, FILE* file, const char* mode);
	void save_tmpfile_in_vec(FILE* file, std::vector<uint8_t> &bo);

	bool check_elf_flow(const std::string& xclbin_path, bool flag_compile = false);
	bool check_elf_flow(const xrt::xclbin& xclbin, bool flag_compile = false);

	std::string get_env_var(const std::string& var,
		const std::string& default_val);
}
