#include <fstream>
#include <iostream>

#include "meta_utils.hpp"

#include "passes.hpp"
namespace waic_runner {
    Metadata insert_pm_load_nodes(const Metadata& meta) {
        Metadata new_meta = meta;
        new_meta.partitions.clear();
        new_meta.op_list.clear();

        for (size_t part = 0; part < meta.partitions.size(); part++) {
            const auto& partition = meta.partitions.at(part);

            const std::string op_name = "pm_load_part_" + std::to_string(part);

            const auto pdi_id = partition.pdi_id;

            const uint8_t pm_id = pdi_id;

            std::map<std::string, std::any> attr;
            attr["pm_id"] = pm_id;

            Metadata::OpInfo pm_load_op = { op_name, "PM_LOAD", {},   {},    {},
                                             {},      {},           attr, pdi_id };

            std::size_t new_op_start = new_meta.op_list.size();
            new_meta.op_list.emplace_back(pm_load_op);

            new_meta.op_list.insert(new_meta.op_list.end(),
                meta.op_list.begin() + partition.op_range.first,
                meta.op_list.begin() + partition.op_range.second);

            std::size_t new_op_end = new_meta.op_list.size();

            auto new_partition = partition;
            new_partition.op_range.first = new_op_start;
            new_partition.op_range.second = new_op_end;

            new_meta.partitions.emplace_back(new_partition);
        }

        return new_meta;
    }
}
