#include <fstream>
#include <iostream>

#include "meta_utils.hpp"

#include "passes.hpp"
namespace waic_runner {
    static void insert_preemption_op_in_meta(Metadata& meta,
        const std::string& op_name,
        uint8_t pdi_id) {

        std::map<std::string, std::any> attr;
        // attr["op_name"] = op_name;
        Metadata::OpInfo preempt_info = { op_name, "PREEMPTION", {},   {},    {},
                                         {},      {},           attr, pdi_id };
        meta.op_list.emplace_back(preempt_info);
    }

    Metadata insert_preemption_nodes(const Metadata& meta) {
        Metadata preemption_meta = meta;
        preemption_meta.op_list.clear();

        // iterate over pdi partitions and insert profile points
        for (size_t part = 0; part < meta.partitions.size(); part++) {

            const auto& partition = meta.partitions.at(part);

            const auto& op2 = meta.op_list.at(meta.partitions.at(part).op_range.first);
            auto part_end = meta.partitions.at(part).op_range.second;
            for (size_t i = meta.partitions.at(part).op_range.first; i < part_end;
                ++i) {
                auto op = meta.op_list.at(i);
                op.attr["preemption"] = (uint32_t)1;
                // json op_prop = get_op_prop(meta, op);
                preemption_meta.op_list.emplace_back(op);

                // Skipping last preemption in the current partition.
                if ((op.type != "PM_LOAD") && (part_end - 1 != i)) {
                    insert_preemption_op_in_meta(preemption_meta,
                        ("preemption_op_" + op.name), op.pdi_id);
                }
            }
        }

        return preemption_meta;
    }
}