#!/bin/env python3

'''
This script is to extact exception from the log file with some context around
the exception. In the mean time it associate the exception with line number
in the original log.
'''

import argparse
import re

def parse_args():
    parser = argparse.ArgumentParser(description="Batch process")
    parser.add_argument("-f", "--file", type=str, help="input file", required=True)
    args = parser.parse_args()
    return args

traceback_start_re = re.compile("^Traceback")

args = parse_args()
with open(args.file) as f:
  prev_line = ""
  in_block = False
  line_no = 0
  for line in f:
    line_no = line_no + 1     # corresponds to the origin log
    if in_block is True:
      print(line, end="")
      if "Error" in line:
        in_block = False
        prev_line = ""
        print("")
      continue

    if traceback_start_re.search(line):
      print(f"#{line_no} {prev_line}", end="")
      print(line, end="")
      in_block = True
      continue

    prev_line = line
