import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import sys

r = sys.argv[1]
file = pd.read_csv('outputs.csv')
file = file[file['m']%2 == int(r)]

p = file[file['result']=='PASS']
p = p.drop_duplicates()
f = file[file['result']=='FAIL']
f = f.drop_duplicates()

fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')

ax.scatter3D(np.log(p['m']), np.log(p['n']), np.log(p['k']), c='blue')
ax.scatter3D(np.log(f['m']), np.log(f['n']), np.log(f['k']), c='red')
ax.set_xlabel('m - log2')
ax.set_ylabel('n - log2')
ax.set_zlabel('k - log2')
plt.show()
