#ifndef COMMON_HPP
#define COMMON_HPP

#include <stdlib.h>
#include <iostream>
#include <iomanip> 
#include <ios>
#include <fstream>
#include <cstdint>

#include <stdlib.h>
#include <math.h>
#include <numeric>
#include <vector>

using Telem = uint16_t;
using Welem = int32_t;

//======================== Debugging and FileStream Utilities ========================
void dump_vec_to_hextxt(uint16_t* Y, int size_y, std::string filename){
    std::ofstream cpu_Y_file(filename);
    for (int r = 0; r < size_y; r++)
    {
        cpu_Y_file << std::hex << std::setw(4) << std::setfill('0') << static_cast<unsigned int>(Y[r]) << std::endl;
    }
    cpu_Y_file.close();
}

template<typename T>
void dump_vec_to_inttxt(T* Y, int size_y, std::string filename){
    std::ofstream cpu_Y_file(filename);
    for (int r = 0; r < size_y; r++)
    {
        T r1 = Y[r];
        cpu_Y_file << r1 << std::endl;
    }
    cpu_Y_file.close();
}

void read_bin_file(std::string filename, char* data, size_t size)
{
    std::fstream file;
    file.open(filename, std::ios::in | std::ios::binary);
    file.read(data, size);
}

void write_bin_file(std::string filename, char* data, size_t size) {
    std::fstream file;
    file.open(filename, std::ios::out | std::ios::binary);
    file.write(data, size);
}

//======================== DataType Conversion Utilities ========================

struct bfloat16_t
{
    uint16_t value;
};

inline uint32_t float_to_uint(float f)
{
    uint32_t i = 0;
    char* ptr_f = reinterpret_cast<char*>(&f);
    char* ptr_i = reinterpret_cast<char*>(&i);
    ptr_i[0] = ptr_f[0];
    ptr_i[1] = ptr_f[1];
    ptr_i[2] = ptr_f[2];
    ptr_i[3] = ptr_f[3];
    return i;
}

inline bfloat16_t float_to_bfloat16(float fp)
{
    uint32_t bits = float_to_uint(fp);
    uint32_t lsb = (bits >> 16) & 0x1;
    uint32_t bias = 0x7FFF + lsb;
    uint32_t rnd = bits + bias;
    return bfloat16_t{uint16_t(rnd >> 16)};
}

inline float uint_to_float(uint32_t i)
{
    float f = 0;
    char* ptr_f = reinterpret_cast<char*>(&f);
    char* ptr_i = reinterpret_cast<char*>(&i);
    ptr_f[0] = ptr_i[0];
    ptr_f[1] = ptr_i[1];
    ptr_f[2] = ptr_i[2];
    ptr_f[3] = ptr_i[3];
    return f;
}
inline float bfloat16_to_float(uint16_t bf)
{
    return uint_to_float(uint32_t(bf) << 16);
}

void convert_bfloat16_to_int16(Telem* in_mat, int h_in, int w_in, int c_in)
{
    for (int i = 0; i < h_in; ++i) {
        for (int j = 0; j < w_in; ++j) {
            for (int c = 0; c < c_in; ++c) { 
                float value_as_float = bfloat16_to_float(in_mat[(i * w_in * c_in) + (j * c_in) + c]);
                in_mat[(i * w_in * c_in) + (j * c_in) + c] = static_cast<int16_t>(value_as_float);
                // std::cout<< "in_mat: [" << i << ", " << j << ", " << c <<"]: "<<value_as_float<<" = "<<static_cast<int16_t>(value_as_float)<<std::endl;
            }
        }
    }
}


//======================== Debugging Utilities ========================
void dump_vec_to_txt(uint16_t* Y, int H, int W, std::string filename){
    std::ofstream cpu_Y_file(filename);
    for (int r = 0; r < H; r++)
    {
        for(int c = 0; c < W; c++)
        {
            cpu_Y_file << std::hex << std::setw(4) << std::setfill('0') << static_cast<unsigned int>(Y[r*W+c]) << std::endl;
        }
    }
    cpu_Y_file.close();
}

//======================== Tensor Data Layout Utilities ========================


#endif // COMMON_HPP