/*
 * Decompiled with CFR 0.152.
 */
package directededitor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.joda.time.DateTime;

public class cUtilities {
    public boolean delay(int secs) {
        try {
            Thread.sleep(secs * 1000);
            return true;
        }
        catch (InterruptedException ex) {
            System.err.println("Couldn't sleep! cUtilities.delay()");
            return false;
        }
    }

    public int stringToInt(String s) {
        try {
            int i = Integer.parseInt(s.trim());
            return i;
        }
        catch (NumberFormatException e) {
            String message = "cUtilities: cannot convert " + s + " to an integer";
            System.err.println(message);
            return 0;
        }
    }

    public String listToString(ArrayList<String> s) {
        String returnString = "";
        for (int i = 0; i < s.size(); ++i) {
            returnString = returnString + s.get(i);
            if (i >= s.size() - 1) continue;
            returnString = returnString + ",";
        }
        return returnString;
    }

    public ArrayList<String> arrayToList(String[] s) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < s.length; ++i) {
            list.add(s[i]);
        }
        return list;
    }

    public ArrayList<String> stringToList(String sList, String separator) {
        String thisElement;
        ArrayList<String> list = new ArrayList<String>();
        int pos = sList.indexOf(separator);
        int lastPos = 0;
        while (pos != -1) {
            thisElement = sList.substring(lastPos, pos);
            lastPos = pos + 1;
            pos = sList.indexOf(separator, lastPos);
            list.add(thisElement.trim());
        }
        thisElement = sList.substring(lastPos, sList.length()).trim();
        if (thisElement.length() != 0) {
            list.add(thisElement.trim());
        }
        return list;
    }

    public int nOccurrences(String s, String target) {
        int count = 0;
        int pos = s.indexOf(target);
        while (pos != -1) {
            ++count;
            pos = s.indexOf(target, pos + 1);
        }
        return count;
    }

    public String toShortDate(DateTime d) {
        DateTime thisDecade = new DateTime(2010, 1, 1, 0, 0);
        if (d.isBefore(thisDecade)) {
            return "??/??/??";
        }
        return d.toString("MM/dd/yyyy");
    }

    public String nl2commas(String s) {
        String lastS = s;
        do {
            lastS = s;
        } while ((s = s.replace('\n', ',')).compareToIgnoreCase(lastS) != 0);
        return s;
    }

    public String commas2nl(String s) {
        s = s.replace(',', '\n');
        return s;
    }

    public String arrayList2List(ArrayList<String> list, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString().trim();
    }

    public String getMonthOfYear(int month) {
        switch (month) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "???";
    }

    public String getMilitaryMonthOfYear(int month) {
        switch (month) {
            case 1: {
                return "JAN";
            }
            case 2: {
                return "FEB";
            }
            case 3: {
                return "MAR";
            }
            case 4: {
                return "APR";
            }
            case 5: {
                return "MAY";
            }
            case 6: {
                return "JUN";
            }
            case 7: {
                return "JUL";
            }
            case 8: {
                return "AUG";
            }
            case 9: {
                return "SEP";
            }
            case 10: {
                return "OCT";
            }
            case 11: {
                return "NOV";
            }
            case 12: {
                return "DEC";
            }
        }
        return "???";
    }

    public String getNiceTimeDateStamp() {
        String dayOfMonth = new SimpleDateFormat("dd").format(Calendar.getInstance().getTime());
        String month = new SimpleDateFormat("M").format(Calendar.getInstance().getTime());
        String year = new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime());
        int m = this.stringToInt(month);
        month = this.getMilitaryMonthOfYear(m);
        String dateStamp = new SimpleDateFormat("dd M yyyy").format(Calendar.getInstance().getTime());
        String timeStamp = new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime());
        return dayOfMonth + " " + month + " " + year + " at " + timeStamp;
    }

    public String getTimeDateStamp() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
        return timeStamp;
    }

    public String getSQLtimeDateStamp() {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
        return timeStamp;
    }

    public String isTrue(Boolean b) {
        if (b.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public String stripHTMLtags(String s) {
        boolean keepGoing = true;
        while (keepGoing) {
            int openAngleBracket = s.indexOf(60);
            int closeAngleBracket = s.indexOf(62, openAngleBracket);
            if (openAngleBracket != -1 && closeAngleBracket != -1) {
                String HTMLtag = s.substring(openAngleBracket, closeAngleBracket + 1);
                s = s.substring(0, openAngleBracket) + s.substring(closeAngleBracket + 1, s.length());
                keepGoing = true;
                continue;
            }
            keepGoing = false;
        }
        return s;
    }

    public String stripWhiteSpace(String s) {
        String thisLine = s;
        thisLine = thisLine.replace('\r', ' ');
        thisLine = thisLine.replace('\t', ' ');
        String lastLine = thisLine = thisLine.replace('\n', ' ');
        while ((lastLine = (thisLine = lastLine).replace("  ", " ")).compareTo(thisLine) != 0) {
        }
        return thisLine;
    }

    public int howManyCharsUsedByHTMLcodes(String s) {
        int originalLength = s.length();
        int nCodes = 0;
        int ampersandPos = s.indexOf(38);
        while (ampersandPos != -1) {
            ++nCodes;
            int nextSemicolonPos = s.indexOf(59, ampersandPos);
            String codeToReplace = s.substring(ampersandPos, nextSemicolonPos + 1);
            String replacementString = this.convertHTMLsymbol(codeToReplace);
            s = s.replace(codeToReplace, replacementString);
            ampersandPos = s.indexOf(38);
        }
        return originalLength - s.length() - nCodes;
    }

    public String convertHTMLsymbolInLine(String s) {
        int ampersandPos = s.indexOf(38);
        while (ampersandPos != -1) {
            int nextSemicolonPos = s.indexOf(59, ampersandPos);
            String codeToReplace = s.substring(ampersandPos, nextSemicolonPos + 1);
            String replacementString = this.convertHTMLsymbol(codeToReplace);
            s = s.replace(codeToReplace, replacementString);
            ampersandPos = s.indexOf(38);
        }
        return s;
    }

    public String convertHTMLsymbol(String s) {
        if (s.compareToIgnoreCase("&quot;") == 0) {
            return "\"";
        }
        if (s.compareToIgnoreCase("&amp;") == 0) {
            return "&";
        }
        if (s.compareToIgnoreCase("&lt;") == 0) {
            return "<";
        }
        if (s.compareToIgnoreCase("&gt;") == 0) {
            return ">";
        }
        if (s.compareToIgnoreCase("&nbsp;") == 0) {
            return " ";
        }
        return "??";
    }
}

