/*
 * Decompiled with CFR 0.152.
 */
package objDump_helper;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import objDump_helper.FileBrowser;
import objDump_helper.cFileUtilities;
import objDump_helper.cMessage;
import objDump_helper.cUtilities;

public final class objdump_helper_GUI
extends JDialog {
    private final String copyrightString = "(c) AMD, Inc. 2015-23";
    private final String versionString = "2023/02/10";
    private final String errorIcon = "icons\\Red X Mark.png";
    private final String successIcon = "icons\\Green Check Mark.png";
    private final String thisOS = System.getProperty("os.name").toLowerCase();
    private final cFileUtilities fu = new cFileUtilities();
    private final cUtilities utils = new cUtilities();
    private JPanel containerPanel;
    private JButton copyrightDisclaimerButton;
    private JButton elfBrowseButton;
    private JLabel elfLabel;
    private JTextField elfTextField;
    private JButton goButton;
    private JPanel lowerContainerPane;
    private JButton objBrowseButton;
    private JLabel objDumpLabel;
    private JTextField objTextField;
    private JScrollPane reportScrollPane;
    private JTextArea reportTextArea;
    private JLabel titleLabel;
    private JLabel versionLabel;

    public objdump_helper_GUI(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.versionLabel.setText("2023/02/10");
        String hierarchySeparator = "\\";
        String OSsel = "nt";
        String executableExtension = ".exe";
        String trainingDir = System.getenv("TRAINING_PATH");
        trainingDir = trainingDir.replace("/", "\\");
        if (this.thisOS.contains("inux")) {
            hierarchySeparator = "/";
            OSsel = "lin";
            executableExtension = "";
            trainingDir = trainingDir.replace("\\", "/");
        }
        String pathToXilinx = "";
        String version = "";
        if (this.fu.fileExists(trainingDir + hierarchySeparator + "CustEdLoader.sh")) {
            this.fu.openForReading(trainingDir + hierarchySeparator + "CustEdLoader.sh");
            while (!this.fu.atEOF()) {
                String line = this.fu.read();
                if (line.contains("CustEd_VERSION")) {
                    version = line.substring(line.indexOf("=") + 1, line.length());
                }
                if (!line.contains("CustEd_INSTALL")) continue;
                pathToXilinx = line.substring(line.indexOf("=") + 1, line.length());
            }
            this.fu.closeFile();
        }
        if (pathToXilinx.contains("/") && this.thisOS.contains("indow")) {
            pathToXilinx = "\\Xilinx";
        }
        String startSearchLoc = pathToXilinx + hierarchySeparator + "Vitis" + hierarchySeparator + version + hierarchySeparator + "gnu" + hierarchySeparator + "aarch64" + hierarchySeparator + OSsel + hierarchySeparator + "aarch64-none" + hierarchySeparator + "bin" + hierarchySeparator;
        ArrayList<File> foundFiles = this.fu.buildFileList(startSearchLoc, true, this.thisOS);
        String pathToObjDump = "";
        for (File thisElement : foundFiles) {
            if (!thisElement.getAbsolutePath().contains("objdump") || !thisElement.getAbsolutePath().endsWith(executableExtension)) continue;
            pathToObjDump = thisElement.getAbsolutePath();
            break;
        }
        if (pathToObjDump.length() == 0) {
            pathToObjDump = "Unknown, please navigate to objdump";
        }
        this.objTextField.setText(pathToObjDump);
        this.elfTextField.setText(trainingDir);
        this.objTextField.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : droppedFiles) {
                        objdump_helper_GUI.this.objTextField.setText(file.getAbsolutePath());
                    }
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
            }
        });
        this.elfTextField.setDropTarget(new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    for (File file : droppedFiles) {
                        objdump_helper_GUI.this.elfTextField.setText(file.getAbsolutePath());
                    }
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
            }
        });
    }

    protected String getWindowsObjDump() {
        String startSearchLoc = System.getenv("XILINX_PATH") + "\\Vivado\\" + System.getenv("VERSION") + "\\tps\\win64";
        ArrayList<File> foundFiles = this.fu.buildFileList(startSearchLoc, false, this.thisOS);
        String latestVersion = "";
        for (File thisFileOrDirectory : foundFiles) {
            if (thisFileOrDirectory.isFile()) continue;
            String thisDirectoryName = thisFileOrDirectory.getAbsolutePath();
            String target = "c:\\Xilinx";
            if (thisDirectoryName.compareTo("c:\\Xilinx") != 0) continue;
            String searchPath = target = target + "\\Vivado";
            foundFiles = this.fu.buildFileList(searchPath, false, this.thisOS);
            ArrayList<String> XilinxVersions = new ArrayList<String>();
            for (File thisDir : foundFiles) {
                String thisVersion = thisDir.getName();
                if (this.thisOS.contains("win")) {
                    XilinxVersions.add(thisVersion.substring(thisVersion.lastIndexOf("\\") + 1, thisVersion.length()));
                    continue;
                }
                XilinxVersions.add(thisVersion.substring(thisVersion.lastIndexOf("/") + 1, thisVersion.length()));
            }
            for (int j = 0; j < XilinxVersions.size(); ++j) {
                if (latestVersion.compareToIgnoreCase((String)XilinxVersions.get(j)) >= 0) continue;
                latestVersion = (String)XilinxVersions.get(j);
            }
        }
        String searchPath = "C:\\Xilinx\\Vivado\\" + latestVersion + "\\msys64\\mingw64\\bin\\objdump.exe";
        return searchPath;
    }

    protected ArrayList<String> readELFheader(String ELFname) {
        ArrayList<String> info = new ArrayList<String>();
        long fileSize = new File(ELFname).length();
        byte[] allBytes = new byte[(int)fileSize];
        try (FileInputStream iStr = new FileInputStream(ELFname);){
            int nBytesRead = ((InputStream)iStr).read(allBytes);
            if ((long)nBytesRead != fileSize) {
                System.err.println("Didn't read the entire file!");
            }
        }
        catch (IOException e) {
            System.err.println("Ran into a problem when reading " + ELFname + ": " + e.toString());
            return null;
        }
        if (allBytes[0] == 127 && allBytes[1] == 69 && allBytes[2] == 76 && allBytes[3] == 70) {
            if (allBytes[18] == 40) {
                info.add("AArch32");
            } else if (allBytes[18] == 183) {
                info.add("AArch64");
            }
        }
        return info;
    }

    protected String getLinuxObjDump() {
        String searchStartingPoint = "/opt/Xilinx/Vivado";
        ArrayList<File> foundFiles = this.fu.buildFileList(searchStartingPoint, false, this.thisOS);
        String latestVersion = "";
        for (File thisFileOrDirectory : foundFiles) {
            if (thisFileOrDirectory.isFile()) continue;
            foundFiles = this.fu.buildFileList(searchStartingPoint, false, this.thisOS);
            ArrayList<String> XilinxVersions = new ArrayList<String>();
            for (File thisDir : foundFiles) {
                String thisVersion = thisDir.getName();
                XilinxVersions.add(thisVersion.substring(thisVersion.lastIndexOf("/") + 1, thisVersion.length()));
            }
            for (int j = 0; j < XilinxVersions.size(); ++j) {
                if (latestVersion.compareToIgnoreCase((String)XilinxVersions.get(j)) >= 0) continue;
                latestVersion = (String)XilinxVersions.get(j);
            }
        }
        return searchStartingPoint + "/" + latestVersion + "/tps/lnx64/binutils-2.26/bin/objdump";
    }

    protected void positionGUI() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        int x = (screenWidth - this.getWidth()) / 2;
        int y = (screenHeight - this.getHeight()) / 3;
        this.setLocation(x, y);
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.reportScrollPane = new JScrollPane();
        this.reportTextArea = new JTextArea();
        this.containerPanel = new JPanel();
        this.goButton = new JButton();
        this.elfLabel = new JLabel();
        this.elfTextField = new JTextField();
        this.elfBrowseButton = new JButton();
        this.objBrowseButton = new JButton();
        this.objTextField = new JTextField();
        this.objDumpLabel = new JLabel();
        this.lowerContainerPane = new JPanel();
        this.versionLabel = new JLabel();
        this.copyrightDisclaimerButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.titleLabel.setFont(new Font("Papyrus", 3, 18));
        this.titleLabel.setForeground(new Color(0, 0, 204));
        this.titleLabel.setHorizontalAlignment(0);
        this.titleLabel.setText("objdump Helper");
        this.reportTextArea.setEditable(false);
        this.reportTextArea.setColumns(20);
        this.reportTextArea.setRows(5);
        this.reportScrollPane.setViewportView(this.reportTextArea);
        this.goButton.setText("Run objDump and Show Results");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                objdump_helper_GUI.this.goButtonActionPerformed(evt);
            }
        });
        this.elfLabel.setText("ELF:");
        this.elfTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                objdump_helper_GUI.this.elfTextFieldActionPerformed(evt);
            }
        });
        this.elfBrowseButton.setText("...");
        this.elfBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                objdump_helper_GUI.this.elfBrowseButtonActionPerformed(evt);
            }
        });
        this.objBrowseButton.setText("...");
        this.objBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                objdump_helper_GUI.this.objBrowseButtonActionPerformed(evt);
            }
        });
        this.objTextField.setText("C:\\Xilinx\\Vivado\\2015.1\\tps\\mingw\\4.4.3\\win64.o\\nt64\\bin\\objdump.exe");
        this.objTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                objdump_helper_GUI.this.objTextFieldActionPerformed(evt);
            }
        });
        this.objDumpLabel.setText("objdump@");
        GroupLayout containerPanelLayout = new GroupLayout(this.containerPanel);
        this.containerPanel.setLayout(containerPanelLayout);
        containerPanelLayout.setHorizontalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.goButton, -1, 472, Short.MAX_VALUE).addGroup(containerPanelLayout.createSequentialGroup().addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.elfLabel).addGap(49, 49, 49)).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.objDumpLabel, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18))).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.elfTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.elfBrowseButton)).addGroup(GroupLayout.Alignment.TRAILING, containerPanelLayout.createSequentialGroup().addComponent(this.objTextField, -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.objBrowseButton)))));
        containerPanelLayout.setVerticalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, containerPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.objBrowseButton).addComponent(this.objTextField, -2, -1, -2).addComponent(this.objDumpLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.elfLabel).addComponent(this.elfTextField, -2, -1, -2).addComponent(this.elfBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.goButton)));
        this.versionLabel.setText("jLabel1");
        GroupLayout lowerContainerPaneLayout = new GroupLayout(this.lowerContainerPane);
        this.lowerContainerPane.setLayout(lowerContainerPaneLayout);
        lowerContainerPaneLayout.setHorizontalGroup(lowerContainerPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, lowerContainerPaneLayout.createSequentialGroup().addContainerGap(249, Short.MAX_VALUE).addComponent(this.versionLabel)));
        lowerContainerPaneLayout.setVerticalGroup(lowerContainerPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, lowerContainerPaneLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.versionLabel)));
        this.copyrightDisclaimerButton.setText("Copyright/Disclaimer");
        this.copyrightDisclaimerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                objdump_helper_GUI.this.copyrightDisclaimerButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titleLabel, -1, -1, Short.MAX_VALUE).addComponent(this.reportScrollPane, GroupLayout.Alignment.TRAILING).addComponent(this.containerPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.copyrightDisclaimerButton, -2, 180, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lowerContainerPane, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.containerPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reportScrollPane, -1, 149, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lowerContainerPane, -2, -1, -2).addComponent(this.copyrightDisclaimerButton))));
        this.pack();
    }

    private void objBrowseButtonActionPerformed(ActionEvent evt) {
        String startingLocation = this.objTextField.getText();
        if (startingLocation.length() == 0) {
            startingLocation = "C:\\";
        }
        FileBrowser fb = new FileBrowser();
        fb.setFilter(".exe");
        fb.setDescription("executable file");
        String fileName = fb.getStuff(startingLocation, true, false);
        this.objTextField.setText(fileName);
    }

    private void elfBrowseButtonActionPerformed(ActionEvent evt) {
        String startingLocation = this.elfTextField.getText();
        if (startingLocation.length() == 0) {
            startingLocation = "";
        }
        FileBrowser fb = new FileBrowser();
        fb.setFilter(".elf");
        fb.setDescription("Executable and Load Format files");
        String fileName = fb.getStuff(startingLocation, true, false);
        this.elfTextField.setText(fileName);
    }

    private void objTextFieldActionPerformed(ActionEvent evt) {
    }

    private void elfTextFieldActionPerformed(ActionEvent evt) {
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        this.reportTextArea.setText("");
        String elfFileName = this.elfTextField.getText();
        if (elfFileName.length() > 0) {
            elfFileName = elfFileName.trim();
        }
        if (!elfFileName.endsWith(".elf")) {
            elfFileName = elfFileName + ".elf";
        }
        if (!this.fu.fileExists(elfFileName)) {
            cMessage cMsg = new cMessage(null, true, "", "ELF file does not exist!");
            return;
        }
        String objDumpExecutableFileName = this.objTextField.getText();
        if (objDumpExecutableFileName.length() > 0) {
            objDumpExecutableFileName = objDumpExecutableFileName.trim();
        }
        if (!this.fu.fileExists(objDumpExecutableFileName)) {
            cMessage cMsg = new cMessage(null, true, "", "Object Dump utility not found at specified location!");
            return;
        }
        if (this.thisOS.contains("indo") && !objDumpExecutableFileName.endsWith(".exe")) {
            objDumpExecutableFileName = objDumpExecutableFileName + ".exe";
        }
        if (!this.fu.fileExists(objDumpExecutableFileName)) {
            cMessage cMsg = new cMessage(null, true, "", "objDump file does not exist!");
            return;
        }
        String cmd = objDumpExecutableFileName + " -t " + elfFileName;
        this.utils.execString(cmd);
        String execOutput = this.utils.getInputStream();
        String execError = this.utils.getErrorStream();
        System.out.println("Dump of Stdout Stream: " + execOutput);
        System.out.println("Dump of Error Stream: " + execError);
        int startPos = execOutput.indexOf("SYMBOL TABLE:");
        execOutput = execOutput.substring(startPos + 13).trim();
        ArrayList<String> segmentList = new ArrayList<String>();
        boolean done = false;
        int startOfLine = 0;
        int endOfLine = execOutput.indexOf("\n");
        while (!done) {
            int markerPos;
            String thisLine = execOutput.substring(startOfLine, endOfLine);
            thisLine = thisLine.replace("\t", " ");
            startOfLine = endOfLine + 1;
            if ((endOfLine = execOutput.indexOf("\n", startOfLine)) == -1) {
                done = true;
                endOfLine = execOutput.length();
            }
            if ((markerPos = thisLine.indexOf("*")) == -1) {
                markerPos = thisLine.indexOf(".");
            }
            if (markerPos != -1) {
                int nextSpace = (thisLine = thisLine.substring(markerPos, thisLine.length())).indexOf(" ");
                if (nextSpace == -1) {
                    nextSpace = thisLine.indexOf("\t");
                }
                if (segmentList.contains(thisLine = thisLine.substring(0, nextSpace).trim())) continue;
                segmentList.add(thisLine);
                continue;
            }
            System.out.println("oops!");
        }
        segmentList = this.utils.sortArrayListAlphabetically(segmentList);
        for (int i = 0; i < segmentList.size(); ++i) {
            this.reportTextArea.append(segmentList.get(i) + "\n");
        }
    }

    private void copyrightDisclaimerButtonActionPerformed(ActionEvent evt) {
        String copyrightAndDisclaimer = "Copyright AMD/Xilinx 2015-2023 all rights reserved, no warrentee implied, see full disclaimer";
        StringBuilder wholeCopyrightAndDisclaimerText = new StringBuilder();
        String fileName = "icons\\CopyrightAndDisclaimer.txt";
        String os = System.getProperty("os.name");
        if (os.compareToIgnoreCase("Linux") == 0) {
            fileName = fileName.replace("\\", "/");
            fileName = "/home/amd/training/tools/" + fileName;
        }
        if (this.fu.openForReading(fileName)) {
            while (!this.fu.atEOF()) {
                wholeCopyrightAndDisclaimerText.append(this.fu.read()).append("\n");
            }
            this.fu.closeFile();
            String first = "[first_year]";
            int firstIndex = wholeCopyrightAndDisclaimerText.indexOf(first);
            int firstEndIndex = wholeCopyrightAndDisclaimerText.indexOf(first) + first.length();
            String latest = "[latest_year]";
            int latestIndex = wholeCopyrightAndDisclaimerText.indexOf(latest);
            int latestEndIndex = wholeCopyrightAndDisclaimerText.indexOf(latest) + latest.length();
            if (wholeCopyrightAndDisclaimerText.indexOf(first) > 0 && wholeCopyrightAndDisclaimerText.indexOf(latest) > 0) {
                wholeCopyrightAndDisclaimerText.replace(latestIndex, latestEndIndex, "2023");
                wholeCopyrightAndDisclaimerText.replace(firstIndex, firstEndIndex, "2015");
                copyrightAndDisclaimer = this.utils.centerStringInField(wholeCopyrightAndDisclaimerText.toString(), 80, "");
            } else {
                System.err.println("couldn't find one of the copyright date targets");
            }
        } else {
            cMessage cMessage2 = new cMessage(null, true, "objDump_helper", "icons\\Red X Mark.png", "Could not find the full Copyright and Disclaimer which should be in the icons directory included with this jar");
        }
        cMessage msg = new cMessage(null, true, "objDump_helper", "icons\\Green Check Mark.png", copyrightAndDisclaimer);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(objdump_helper_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(objdump_helper_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(objdump_helper_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(objdump_helper_GUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                objdump_helper_GUI dialog = new objdump_helper_GUI((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

