//-----------------------------------------------------------------------------
//
// 
//<copyright-disclaimer-start>
//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
//<copyright-disclaimer-end>
// 
// history
//    2012 - initial
//----------------------------------------------------------------------------

`timescale 1ns/1ps
module axi_traffic_gen_0_tb_top ();

//Clock Generation:
//Clock period 10 nano-seconds(10ns)
parameter EXDES_CLK_PERIOD = 10 ;
reg axi_aclk;
wire done  ;
wire [31:0]  status;

always begin
  axi_aclk = 0;
  forever #(EXDES_CLK_PERIOD/2) axi_aclk = ~axi_aclk;
end

//Reset Generation:
reg reset;
initial begin
 reset = 1'b0;
 #100;
 reset = 1'b1;
end

//Example Design Instantiation:
ATG_wrapper ATG_wrapper_i (
  .s_axi_aclk     (axi_aclk),
  .s_axi_aresetn  (reset),         
  .done           (done),
  .status         (status)
);


//Pass/Fail Check:
always @(posedge axi_aclk) begin
 if(reset == 1'b1 && done == 1'b1) begin
   $display("EXDES:Done Received");
   $display("Test Status :%d",status[1:0]);
  
   if(status[1:0] == 2'b01) begin
     $display("Test Completed Successfully");
   end else if(status[1:0] == 2'b11 )begin
     $display("ERROR:Test did not complete (timed-out)");
   end else begin
     $display("ERROR:Test Failed");
   end
   $finish;
 end
end
  
initial begin
     #10000;
     $display("Test Failed !! Test Timed Out");
     $finish;
end

endmodule

