#*******************************************************************************************************************************************
#
# helper_time.tcl
#    contains many time related supporting procs particularly w.r.t. formatting
#
# Formatting Notes:
#    setFormat - sets the format for time use
#       %a . . . . Abbreviated weekday name (Mon, Tue, etc.)
#       %A . . . . Full weekday name (Monday, Tuesday, etc.)
#       %b . . . . Abbreviated month name (Jan, Feb, etc.)
#       %B . . . . Full month name (January, February, etc.)
#       %d . . . . Day of month
#       %j . . . . Julian day of year
#       %m . . . . Month number (01-12)
#       %y . . . . Year in century
#       %Y . . . . Year with 4 digits
#       %H . . . . Hour (00-23)
#       %I . . . . Hour (00-12)
#       %M . . . . Minutes (00-59)
#       %S . . . . Seconds(00-59)
#       %p . . . . PM or AM
#       %D . . . . Date as %m/%d/%y
#       %r . . . . Time as %I:%M:%S %p
#       %R . . . . Time as %H:%M
#       %T . . . . Time as %H:%M:%S
#       %Z . . . . Time Zone Name
#
#
#<copyright-disclaimer-start>
#  ************************************************************************************************************
#  * © Copyright 2021-2022 Xilinx, Inc. All rights reserved.                                                  *
#  * This file contains confidential and proprietary information of Xilinx, Inc. and                          *
#  * is protected under U.S. and international copyright and other intellectual property laws.                *
#  * DISCLAIMER                                                                                               *
#  * This disclaimer is not a license and does not grant any rights to the materials distributed              *
#  * herewith. Except as otherwise provided in a valid license issued to you by Xilinx, and to the            *
#  * maximum extent permitted by applicable law: (1) THESE MATERIALS ARE MADE AVAILABLE "AS IS"               *
#  * AND WITH ALL FAULTS, AND XILINX HEREBY DISCLAIMS ALL WARRANTIES AND CONDITIONS, EXPRESS,                 *
#  * IMPLIED, OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT,     *
#  * OR FITNESS FOR ANY PARTICULAR PURPOSE; and (2) Xilinx shall not be liable (whether in contract or tort,  *
#  * including negligence, or under any other theory of liability) for any loss or damage of any kind or      *
#  * nature related to, arising under or in connection with these materials, including for any direct, or     *
#  * any indirect, special, incidental, or consequential loss or damage (including loss of data, profits,     *
#  * goodwill, or any type of loss or damage suffered as a result of any action brought by a third party)     *
#  * even if such damage or loss was reasonably foreseeable or Xilinx had been advised of the possibility     *
#  * of the same.                                                                                             *
#  * CRITICAL APPLICATIONS                                                                                    *
#  * Xilinx products are not designed or intended to be fail-safe, or for use in any application requiring    *
#  * fail-safe performance, such as life-support or safety devices or systems, Class III medical devices,     *
#  * nuclear facilities, applications related to the deployment of airbags, or any other applications that    *
#  * could lead to death, personal injury, or severe property or environmental damage (individually and       *
#  * collectively, "Critical Applications"). Customer assumes the sole risk and liability of any use of       *
#  * Xilinx products in Critical Applications, subject only to applicable laws and regulations governing      *
#  * limitations on product liability.                                                                        *
#  * THIS COPYRIGHT NOTICE AND DISCLAIMER MUST BE RETAINED AS PART OF THIS FILE AT ALL TIMES.                 *
#  *                                                                                                          *
#  ************************************************************************************************************
#<copyright-disclaimer-end>
#
# history
#    2022/01/20 - WK - 2021.2 - updated for Doxygen compatibility
#
#*******************************************************************************************************************************************

variable timeFormatString {%H:%M:%S};
variable timerFormatString {%H:%M:%S};
proc timeFormat { str } {
   variable timeFormatString;
   set timeFormatString str;
}
##
# get time - returns current time in the specified format
# @return returns the current system time in the selected format specified in timeFormatString
proc getTime {} {
   variable timeFormatString;
   set now [clock seconds];
   set formattedTime [clock format $now -format $timeFormatString];
   return $formattedTime;
}
##
# getRawTime
# @return returns the current system time in seconds from the epoch
proc getRawTime {} {
   return [clock seconds];
}
variable startTime;
variable endTime;
proc timerStart {} { variable startTime [clock milliseconds]; }
proc timerStop  {} { variable endTime   [clock milliseconds]; }
proc getRawElapsedTime {} { 
   variable startTime;
   variable endTime;
   return [expr $endTime - $startTime];
}
proc getElapsedTime {} {
   variable startTime;
   variable endTime;
   variable timerFormatString;
   set rawElapsedTime [expr $endTime - $startTime];
   set milliseconds [expr $rawElapsedTime % 1000];     # lowest three digits will always be milliseconds
   set rawElapsedTime [expr $rawElapsedTime / 1000];   # now strip off the milliseconds
   set hours [expr $rawElapsedTime / 3600];            # integer portion represents hours
   set rawElapsedTime [expr $rawElapsedTime - ($hours * 3600)];
   set minutes [expr $rawElapsedTime / 60];
   set rawElapsedTime [expr $rawElapsedTime - ($minutes * 60)];
   set seconds $rawElapsedTime;
   set elapsedTimeString "";
   append elapsedTimeString $hours : [twoPlaces $minutes] : [twoPlaces $seconds] . $milliseconds;
   return $elapsedTimeString;
}

# todo: return warning if more than 2 places
proc twoPlaces { x } {
   if { $x > 9 } { 
      return $x; 
   } else {
      set str 0;
      append str $x;
      return $str;
   }
}

