#
# #####################################################################################
#
# FSBL_building_demo_completer.tcl
#
# History:
#    2023/09/10 - WK - 2023.1 - removed environment variable loader in favor of variableReplacer <!!> variables
#    2021/11/04 - WK - 2021.2 - updated with pseudo environment variable loader, general cleanup
#    2020/09/19 - WK - environment based path to script fixed
#    2019/02/14 - WK - name change
#    2018/05/30 - WK - initial cut
#
# debug helper
# cd /training/FSBL_building/support; source FSBL_building_demo_completer.tcl;
#
# #####################################################################################
#
set badEnv 0;
if {[catch {variable trainingPath $::env(TRAINING_PATH)} emsg]} {
   puts "ERROR!!! TRAINING_PATH environment variable not defined!";
    set badEnv 1;
} else {
   regsub -all {\\} $trainingPath / trainingPath;
}

# load the helper script
source -quiet $::env(TRAINING_PATH)/tools/completer_helper.tcl

# project constants
set tcName			   FSBL_intro
set labName          $tcName
set projName         $tcName
set demoOrLab        demo
set verbose          1
set blockDesignName  blkDsgn
set periphName       ???
set verbose          1

set stepList {{projectCreate blockDesignCreate processorAdd processorConfig addRFdc connectAndAutomate }\
              {shiftToSoftware closeVivado}
             }
variable MPSoCactivePeripheralList {CONFIG.PSU__USE__M_AXI_GP2                 1 
                                    CONFIG.PSU__USE__M_AXI_GP0                 1
                                    CONFIG.PSU__USE__S_AXI_GP2                 1
                                    CONFIG.PSU__MAXIGP2__DATA_WIDTH           64
                                    CONFIG.PSU__GPIO_EMIO__PERIPHERAL__ENABLE  1
									         CONFIG.PSU__GPIO_EMIO__PERIPHERAL__IO     32
									         CONFIG.PSU__FPGA_PL0_ENABLE                1
									         CONFIG.PSU__USE__FABRIC__RST               1
								            CONFIG.PSU__QSPI__PERIPHERAL__ENABLE       1
									         CONFIG.PSU__UART0__PERIPHERAL__ENABLE      1	
                                    CONFIG.PSU__USE__IRQ0                      1
                                   }	
        
# must be defined after the peripheral list as the list is needed when the processor is specified        
use vhdl
use RFSoC                                   
 
proc buildStartingPoint {} {
   global verbose   
   if {$verbose == 1} { puts "ADC_driver_demo_completer.buildStartingPoint"; }
   
   make 1
   
   markLastStep buildStartingPoint
}

proc shiftToSoftware {} {
   global verbose   
   if {$verbose == 1} { puts "shiftToSoftware"; }

   generate_target all [get_files  C:/training/RFSoC_ADC_SW/demo/RFSoC_ADC_sw_demo.srcs/sources_1/bd/blkDsgn/blkDsgn.bd]
   export_simulation -of_objects [get_files C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.srcs/sources_1/bd/blkDsgn/blkDsgn.bd] -directory C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.ip_user_files/sim_scripts -ip_user_files_dir C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.ip_user_files -ipstatic_source_dir C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.ip_user_files/ipstatic -lib_map_path [list {modelsim=C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.cache/compile_simlib/modelsim} {questa=C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.cache/compile_simlib/questa} {riviera=C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.cache/compile_simlib/riviera} {activehdl=C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.cache/compile_simlib/activehdl}] -use_ip_compiled_libs -force -quiet
   file mkdir C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.sdk
   write_hwdef -force  -file C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.sdk/blkDsgn_wrapper.hdf
   launch_sdk -workspace C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.sdk -hwspec C:/training/RFSoC_ADC_demo/demo/RFSoC_ADC_demo.sdk/blkDsgn_wrapper.hdf
   
   markLastStep shiftToSoftware
}

#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
