#
# ***********************************************************************
#
# script for completing the demo design used for the clock_demo
#
# History
#    2024/02/04 - DY - 2023.2 - Updated loading helper script command
#    2023/09/10 - WK - 2023.1 - removed environment variable loader in favor of variableReplacer <!!> variables
#    2021/11/04 - WK    - 2021.2 - updated with pseudo environment variable loader, general cleanup
#    2016/02/12 - WK/SC - 2016.1 - initial cut
#
# ***********************************************************************
#


set badEnv 0;
if {[catch {variable trainingPath $::env(TRAINING_PATH)} emsg]} {
   puts "ERROR!!! TRAINING_PATH environment variable not defined!";
    set badEnv 1;
} else {
   regsub -all {\\} $trainingPath / trainingPath;
}

# load the helper script
source $trainingPath/CustEdIP/completer_helper.tcl;

# project constants
set tcName           MPSoC_clocks;
set demoName         $tcName;
set blockDesignName  embd_dsgn;
set demoOrLab        demo;
set verbose          1;
set labName          $tcName;

# identify the parameters for the PS
set activePSperipheralsList { CONFIG.PSU__USE__M_AXI_GP2                 1
                              CONFIG.PSU__MAXIGP2__DATA_WIDTH            32
                              CONFIG.PSU__FPGA_PL0_ENABLE                1
                              CONFIG.PSU__CRL_APB__PL0_REF_CTRL__SRCSEL  IOPLL
                              CONFIG.PSU__CRL_APB__PL0_REF_CTRL__FREQMHZ 300
                              CONFIG.PSU__GPIO_EMIO__PERIPHERAL__ENABLE  1
                            }

proc doTheGPIO {} {
   # remove anything having to do with the GPIO if it already exists
   set gpioList [get_bd_cells -quiet {*GPIO*}]
   if {[llength $gpioList] > 0} { delete_bd_objs -quiet $gpioList }
   set gpioList [get_bd_intf_ports -quiet {GPIO*}]
   if {[llength $gpioList] > 0} { delete_bd_objs -quiet $gpioList }

  # Create instance: axi_gpio_0, and set properties
  create_bd_cell -type ip -vlnv [latestVersion xilinx.com:ip:axi_gpio:2.0] axi_gpio_0
  set_property -dict [list CONFIG.C_GPIO_WIDTH {8} CONFIG.C_ALL_OUTPUTS {1}] [get_bd_cells axi_gpio_0]

  # create and connect external port for GPIO
  create_bd_intf_port -mode Master -vlnv xilinx.com:interface:gpio_rtl:1.0 GPIO
  connect_bd_intf_net [get_bd_intf_pins axi_gpio_0/GPIO] [get_bd_intf_ports GPIO]
}

# takes the EMIO GPIO output, pulls the MSb from it, and uses it as an external reset
proc sliceAdd {} {
   # Create instance: xlslice_0, and set properties
   set xlslice_0 [ create_bd_cell -type ip -vlnv [latestVersion xilinx.com:ip:xlslice:1.0] pullMSb ]
   set_property -dict [ list CONFIG.DIN_FROM {95} CONFIG.DIN_TO {95} CONFIG.DIN_WIDTH {96} CONFIG.DOUT_WIDTH {1} ] $xlslice_0
   connect_bd_net [get_bd_pins zynq_ultra_ps_e_0/emio_gpio_o] [get_bd_pins pullMSb/Din]
    connect_bd_net [get_bd_pins pullMSb/Dout] [get_bd_pins rst_ps8_0_96M/aux_reset_in]
  # connect_bd_net [get_bd_pins pullMSb/Dout] [get_bd_pins rst_ps8_0_300M/ext_reset_in]

}

proc automationsRunCustom {} {
   apply_bd_automation -rule xilinx.com:bd_rule:zynq_ultra_ps_e -config {apply_board_preset "1" }  [get_bd_cells zynq_ultra_ps_e_0]
   #apply_bd_automation -rule xilinx.com:bd_rule:axi4 -config {Master "/zynq_ultra_ps_e_0/M_AXI_HPM0_LPD" Clk "Auto" }  [get_bd_intf_pins axi_gpio_0/S_AXI]
   #apply_bd_automation -rule xilinx.com:bd_rule:board -config {Board_Interface "reset ( FPGA Reset ) " }  [get_bd_pins rst_ps8_0_300M/ext_reset_in]
}

proc config {} {
   set_property -dict [list CONFIG.PSU__GPIO_EMIO__PERIPHERAL__ENABLE {1} CONFIG.PSU__GPIO0_MIO__PERIPHERAL__ENABLE {1}] [get_bd_cells zynq_ultra_ps_e_0]
}

proc runAutomation {} {
   apply_bd_automation -rule xilinx.com:bd_rule:axi4 -config { Clk_master {Auto} Clk_slave {Auto} Clk_xbar {Auto} Master {/zynq_ultra_ps_e_0/M_AXI_HPM0_LPD} Slave {/axi_gpio_0/S_AXI} intc_ip {New AXI Interconnect} master_apm {0}}  [get_bd_intf_pins axi_gpio_0/S_AXI]
}

#
# *** More sophisticated Make which will build up to a certain level
#
proc make {stopAt} {
   set steps [list S1_Make_Project S2_Add_IP S3_Custom S4_Connect S5_IOs S6_Hierarchy S7_Processors S8_Automation S9a_peripherals]
   switch $stopAt {
      buildStartingPoint { projectCreate; blockDesignCreate; processorAdd; config; doTheGPIO; runAutomation; sliceAdd; regenerate_bd_layout; boxedMsg "Done with Step Building Starting Point"; }
      S1  { make buildStartingPoint; boxedMsg "Done with Step 1"; }
      S2  { make S1;  addBRAMcontroller; boxedMsg "Done with Step 2"; }
      All { make S4 }
      default {
         puts "Specify the level to which you want the lab re-built to:";
         puts "   S1 - builds to the end of Step 1"
         puts "   S2 - builds to the end of Step 2"
         puts "   All - builds all steps"
      }
   }
}




#<copyright-disclaimer-start>
#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
#<copyright-disclaimer-end>
