#
# *******************************************************************************
#
# 1_setup.sh
#    script to configure the working environment for QEMU on a Linux platform
#
# History:
#   2021/10/01 - WK - now uses absolute path based on env var and checks for file existance
#   04/23/2020 - WK - commented out A53 support
#   05/10/2018 - AM - Copy power_controller app
#   09/23/2016 - SC - Modified for updated topic cluster folder structure
#   12/17/2015 - SC - updated with latest Virtual Machine folder layouts.
#					  This will be located in the /home/xilinx/training/... directory
#   12/11/2015 - WK - updated for new user name
#   12/10/2015 - SC - created
#
#
#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
#
# *******************************************************************************
#

#This script is supposed to be executed from the support directory
workingPath=$TRAINING_PATH/PMU_sysArch
cd $workingPath/support

#Make the temp directory for the QEMU instances (if it already exists, then remove it and recreate it)
if [[ -d "qemu-tmp" ]]
then
    echo "qemu-tmp exists on your filesystem - removing it."
    rm -r qemu-tmp
fi
mkdir $workingPath/support/qemu-tmp

#Copy the PMU_firmware_app.elf if it exists, else barf
elf=$workingPath/lab/powerManagement_plat/export/powerManagement_plat/sw/qemu/pmufw.elf
if [[ ! -f $elf ]]
then
    read -p "$elf does not exist on your filesystem; therefore, this script can't continue. Press a key to exit..."
    exit;
fi
cp $elf $workingPath/support/qemu-tmp

# copy the app
APP=$workingPath/lab/powerManagement_r5_app/build/powerManagement_r5_app.elf
if [[ ! -f $APP ]]
then
    read -p "$APP wasn't found; therefore, this script can't continue. Press a key to exit..."
    exit
fi
cp $workingPath/lab/powerManagement_r5_app/build/powerManagement_r5_app.elf $workingPath/support/qemu-tmp

#Execute the script
./2_launch_vm.sh $1

