#
# *******************************************************************************
#
# 2_launch.sh
#    script to open two terminal windows and launch the ARM and uB QEMU emulators
#    followed by the launching the the uB's GDB
#
# History:
#    2023/06/07 - WK - 2023.1 - removed support of custEd_Loader in favor of the variableReplacer technique
#    2023/02/16 - SB - 2022.2 - updated QEMU path, ROM=$CustEdIP/pmu_rom_qemu_sha3.elf
#    2022/08/09 - WK - 2022.1 - fixed QEMU path
#    2021/04/26 - LR - 2021.2 - Fixed Path to ROM=$CustEdIP/linux_boot_MPSoC/pmu_rom_qemu_sha3.elf
#    2021/11/09 - WK - 2021.2 - updated environment variable usage
#    2021/10/01 - WK - 2021.1 - heavy duty cleanup to detect missing files, updated variable usage
#    04/27/2020 - AM - Added instruction to use RPU in Split mode
#    04/23/2020 - WK - update for 2019.2 - removed hard path to QEMU - attempted to add color to backgrounds of the windows - commented out A53 support
#    07/19/2019 - AM - Adding the Sourcing of SDK for using QEMU toolchain for 2019.1
#    09/23/2016 - SC - modifications for 2016.3
#                     Updated folder structure. Removed release versions from the
#                     dtbs. Should make easier to maintain in future
#    12/11/2015 - WK - updated for new user name
#    12/10/2015 - SC - created
#
#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
#
# *******************************************************************************
#

# the VITIS_PATH variable points to the installation directory for the current version of Vitis.
# the following path is valid for the CustEd VM and CloudShare environments. If you are using
# this on another platform, you will need to modify the following line of code to point to the installation
VITIS_PATH=/opt/amd/Vitis/2024.2
workingPath=$TRAINING_PATH/PMU_sysArch

# generic path based on environment variables
QEMU_ver=qemu
QEMU_ZYNQMP=$VITIS_PATH/data/emulation/qemu/comp/$QEMU_ver/sysroots/x86_64-petalinux-linux/usr/bin
FSBL_ELF=$TRAINING_PATH/MPSoC_boot_config/lab/powerManagement_plat/export/powerManagement_plat/sw/boot/fsbl.elf
tools=$TRAINING_PATH/tools
CustEdIP=$TRAINING_PATH/CustEdIP

# check that the QEMU executable for the microblaze exist before calling
uB=$QEMU_ZYNQMP/qemu-system-microblazeel
if [[ ! -f $uB ]]
then
   read -p "$uB wasn't found in the Vitis installation path. Can't continue. Press a key to exit..."
   exit
fi

# check that the QEMU executable for the microblaze exist before calling
ARM64=$QEMU_ZYNQMP/qemu-system-aarch64
if [[ ! -f $ARM64 ]]
then
   read -p "$ARM64 wasn't found in the Vitis installation path. Can't continue..."
   exit
fi

# check that the device tree blob for the multiarchitecture PMU QEMU run is available
PMU_DTB=$tools/zynqmp-qemu-multiarch-pmu.dtb
if [[ ! -f $PMU_DTB ]]
then
   read -p "$PMU_DTB wasn't found in the tools path. Can't continue. Press a key to exit..."
   exit
fi

# check that the device tree blob for the multiarchitecture ARM QEMU run is available
ARM_DTB=$tools/zynqmp-qemu-multiarch-arm.dtb
if [[ ! -f $ARM_DTB ]]
then
   read -p "$ARM_DTB wasn't found in the tools path. Can't continue..."
   exit
fi

# check that the PMU ROM image is available for booting
ROM=$CustEdIP/pmu_rom_qemu_sha3.elf
if [[ ! -f $ROM ]]
then
   read -p "$ROM wasn't found in the CustEdIP path. Can't continue. Press a key to exit..."
   exit
fi

# check that the PMU firmware is available to continue booting after the PMU ROM image completes
PMU_ELF=$workingPath/support/qemu-tmp/pmufw.elf
if [[ ! -f $PMU_ELF ]]
then
   read -p "$PMU_ELF wasn't found in the CustEdIP path. Can't continue. Press a key to exit..."
   exit
fi

#prime the environment
$VITIS_PATH/settings64.sh

# construct a terminal for the PMU view
#029 represent a sea-green color
xterm -hold -e "echo -e '\033]2;'PMU'\007\e[48;5;029m'
$uB -M microblaze-fdt -nographic \
-dtb $PMU_DTB \
-kernel $ROM \
-device loader,file=$PMU_ELF \
-machine-path qemu-tmp -gdb tcp::6667
" &

# construct a terminal for the ARM processor view
#206 represents a fushia color
xterm -hold -e "echo -e '\033]2;'ARM'\007\e[48;5;206m'
$ARM64 -M arm-generic-fdt -nographic \
-dtb $ARM_DTB \
-device loader,addr=0xff5e023c,data=0x80008fdc,data-len=4 \
-device loader,addr=0xff9a0000,data=0x80000218,data-len=4 \
-machine-path qemu-tmp -gdb tcp::6668
"&

# launch the GDB for the uB
cd $workingPath/lab/powerManagement_r5_app/build
$VITIS_PATH/bin/xsdb

