/******************************************************************************
 *
 * 
 * <copyright-disclaimer-start>>
 *   **************************************************************************************************************
 *   * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
 *   * DISCLAIMER                                                                                                 *
 *   * The information contained herein is for informational purposes only, and is subject to change              *
 *   * without notice. While every precaution has been taken in the preparation of this document, it              *
 *   * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
 *   * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
 *   * no representations or warranties with respect to the accuracy or completeness of the contents of           *
 *   * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
 *   * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
 *   * hardware, software or other products described herein.  No license, including implied or                   *
 *   * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
 *   * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
 *   * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
 *   *                                                                                                            *
 *   **************************************************************************************************************
 *
 * <copyright-disclaimer-end>>
 *
 * history
 *    2008 - initial
 *
 *****************************************************************************
 *
 * History:
 * 0.2 		- S.C. 	Modification for 2016.1 release
 * 					Added Xilinx PM Library V2.0 initialization routine
 * 0.1		- S.C. Initial file, for 2015.4 release
 * Cortex R5_0 program to control power to other Processing Units (excluding the PMU)
 *   ps7_uart    115200 (configured by bootrom/bsp)
 */

#include <stdio.h>
#include <stdlib.h>
#include <xparameters.h>
#include "platform.h"
#include "pm_api_sys.h"
#include "pm_client.h"


#define IPI_INT_ID	XPAR_XIPIPSU_0_INTERRUPTS
#define TEST_CHANNEL_ID	XPAR_XIPIPSU_0_BASEADDR

static XIpiPsu IpiInst;

static XStatus IpiConfigure(XIpiPsu *const IpiInstPtr)
{
	XStatus Status;
	XIpiPsu_Config *IpiCfgPtr;

	/* Look Up the config data */
	IpiCfgPtr = XIpiPsu_LookupConfig(TEST_CHANNEL_ID);
	if (NULL == IpiCfgPtr) {
		Status = XST_FAILURE;
		pm_dbg("%s ERROR in getting CfgPtr\n", __func__);
		return Status;
	}

	/* Init with the Cfg Data */
	Status = XIpiPsu_CfgInitialize(IpiInstPtr, IpiCfgPtr, IpiCfgPtr->BaseAddress);
	if (XST_SUCCESS != Status) {
		pm_dbg("%s ERROR #%d in configuring IPI\n", __func__, Status);
		return Status;
	}
	return Status;
}
extern void *_vector_table;


int main() {

	init_platform();

	//Initialize the Power Management
	if (XST_SUCCESS != IpiConfigure(&IpiInst)) {
		pm_dbg("Exiting main...\n");
		return XST_FAILURE;
	}

	if (XST_SUCCESS != XPm_InitXilpm(&IpiInst)) {
		pm_dbg("Exiting main...\n");
		return XST_FAILURE;
	}

	statemachine();

	cleanup_platform();

	return 0;
}

