/******************************************************************************
 *
 * 
 * <copyright-disclaimer-start>>
 *   **************************************************************************************************************
 *   * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
 *   * DISCLAIMER                                                                                                 *
 *   * The information contained herein is for informational purposes only, and is subject to change              *
 *   * without notice. While every precaution has been taken in the preparation of this document, it              *
 *   * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
 *   * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
 *   * no representations or warranties with respect to the accuracy or completeness of the contents of           *
 *   * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
 *   * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
 *   * hardware, software or other products described herein.  No license, including implied or                   *
 *   * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
 *   * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
 *   * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
 *   *                                                                                                            *
 *   **************************************************************************************************************
 *
 * <copyright-disclaimer-end>>
 *
 * history
 *    2010 - initial
 *
 *****************************************************************************
 */

#include "xparameters.h"
#include "xil_cache.h"

#include "platform_config.h"

/*
 * Uncomment one of the following two lines, depending on the target,
 * if ps7/psu init source files are added in the source directory for
 * compiling example outside of SDK.
 */
/*#include "ps7_init.h"*/
/*#include "psu_init.h"*/

#ifdef STDOUT_IS_16550
 #include "xuartns550_l.h"

 #define UART_BAUD 9600
#endif

void
enable_caches()
{
#ifdef __PPC__
    Xil_ICacheEnableRegion(CACHEABLE_REGION_MASK);
    Xil_DCacheEnableRegion(CACHEABLE_REGION_MASK);
#elif __MICROBLAZE__
#ifdef XPAR_MICROBLAZE_USE_ICACHE
    Xil_ICacheEnable();
#endif
#ifdef XPAR_MICROBLAZE_USE_DCACHE
    Xil_DCacheEnable();
#endif
#endif
}

void
disable_caches()
{
    Xil_DCacheDisable();
    Xil_ICacheDisable();
}

void
init_uart()
{
#ifdef STDOUT_IS_16550
    XUartNs550_SetBaud(STDOUT_BASEADDR, XPAR_XUARTNS550_CLOCK_HZ, UART_BAUD);
    XUartNs550_SetLineControlReg(STDOUT_BASEADDR, XUN_LCR_8_DATA_BITS);
#endif
    /* Bootrom/BSP configures PS7/PSU UART to 115200 bps */
}

void
init_platform()
{
    /*
     * If you want to run this example outside of SDK,
     * uncomment one of the following two lines and also #include "ps7_init.h"
     * or #include "ps7_init.h" at the top, depending on the target.
     * Make sure that the ps7/psu_init.c and ps7/psu_init.h files are included
     * along with this example source files for compilation.
     */
    /* ps7_init();*/
    /* psu_init();*/
    enable_caches();
    init_uart();
}

void
cleanup_platform()
{
    disable_caches();
}

