/******************************************************************************
 *
 * 
 * <copyright-disclaimer-start>>
 *   **************************************************************************************************************
 *   * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
 *   * DISCLAIMER                                                                                                 *
 *   * The information contained herein is for informational purposes only, and is subject to change              *
 *   * without notice. While every precaution has been taken in the preparation of this document, it              *
 *   * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
 *   * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
 *   * no representations or warranties with respect to the accuracy or completeness of the contents of           *
 *   * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
 *   * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
 *   * hardware, software or other products described herein.  No license, including implied or                   *
 *   * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
 *   * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
 *   * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
 *   *                                                                                                            *
 *   **************************************************************************************************************
 *
 * <copyright-disclaimer-end>>
 *
 * history
 *    2008 - initial
 *
 *****************************************************************************
 */

#ifndef __PLATFORM_H_
#define __PLATFORM_H_

#include "platform_config.h"

enum cpuState {
	running, reset, noPower
};

struct psStatus {
	enum cpuState rpu_0;
	enum cpuState rpu_1;
	enum cpuState apu_0;
	enum cpuState apu_2;
	enum cpuState apu_3;
	enum cpuState apu_1;
};

void init_platform();
void cleanup_platform();
void statemachine();
void ccToggleRpu1();
void ccToggleApu0();
void ccToggleApu1();
void ccToggleApu2();
void ccToggleApu3();
void ccPowerDownAll();
char *ccPowerStatus();
void ccInit();

extern struct psStatus allCpus;

#endif
