#!/bin/bash
#
# QEMU_launcher.sh
#
# Runs the QEMU configured for the MPSoC devices and launches the QEMU_Bare_Metal_App's hello world application
#
# REQUIRES: user must adjust the VITIS_PATH for the machine/environment that this is being run. Typically,
#    for Linux, this is /opt/Xilinx/Vitis/<version number>
#
# History:
#    2023/06/07 - WK - 2023.1 - removed support of custEd_Loader in favor of the variableReplacer technique
#    2022/01/27 - DY - 2022.2 - changed QEMU_LOC (line 33)
#    2022/06/29 - WK - 2022.1 - changed QEMU path (line 28)
#    2021/11/09 - WK - 2021.2 - updated environment variable usage
#    2021/07/14 - WK - 2021.1 - update to remove the environment variables (except $TRAINING_PATH which is still supported)
#    pre-2021     WK - initial
#

# the VITIS_PATH variable points to the installation directory for the current version of Vitis.
# the following path is valid for the CustEd VM and CloudShare environments. If you are using
# this on another platform, you will need to modify the following line of code to point to the installation
VITIS_PATH=/opt/amd/Vitis/2024.2

# in case this is a new terminal, we need to load the settings64 script
$VITIS_PATH/settings64.sh

# specify the QEMU version - historically, the version number was omitted making script maintainence easy, but now we may need to do more updating
#QEMU_version=unified_qemu_v5_0
QEMU_version=qemu;

# since the path to the QEMU executable is so long, we're giving it a variable here to make the argument list easier to understand
QEMU_ZYNQMP=$VITIS_PATH/data/emulation/qemu/comp/$QEMU_version/sysroots/x86_64-petalinux-linux/usr/bin

# here's the name of the application in case the user didn't follow the directions precisely - instead of rebuilding the entire project with
# the correct name, one would only have to change this line
appName=hello_world_app

# similarly, the ELF is buried inside the project and this variable simplifies the argument list (by shortening it) and make it easier to understand
# what each element in the argument list is actually referring to
ELF_file=$TRAINING_PATH/QEMU_BareMetal_App/lab/$appName/build/$appName.elf

# we can now (finally) run the QEMU app with the necessary arguments
# note that the device loader's address and data is defined by the processor and it is what gets the process started. these values can change based on the processor used
$QEMU_ZYNQMP/qemu-system-aarch64 -nographic -M arm-generic-fdt -dtb $TRAINING_PATH/tools/zynqmp-qemu-arm.dtb \
-device loader,file=$ELF_file,cpu-num=0 -device loader,addr=0xfd1a0104,data=0x8000000e,data-len=4

#<copyright-disclaimer-start>
#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
#<copyright-disclaimer-end>
