#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* N should be power of 2, and larger than 8 */
#define N            1024
#define TEST_ROUNDS    10

#define GOLDEN_RESULT 357389824
float a[N],b[N];

float dot_product_1(float * __restrict pa, float *  __restrict pb, unsigned int n, unsigned int x )
{
	float sum=0.0;
    unsigned int i;

    for(i = 0; i < (n& ~3); i++)
        sum += pa[i] *pb[i];
    return sum;
}

float dot_product_2(float * __restrict pa, float *  __restrict pb, unsigned int n, unsigned int x )
{
	float sum[4]={0.0,0.0,0.0,0.0};
    unsigned int i;

    for(i = 0; i < (n& ~3); i+=4)
    {
        sum[0] += pa[i] *pb[i];
        sum[1] += pa[i+1] *pb[i+1];
        sum[2] += pa[i+2] *pb[i+2];
        sum[3] += pa[i+3] *pb[i+3];
    }
    return sum[0]+sum[1]+sum[2]+sum[3];
}

int main()
{
	unsigned int i;
	float fResult1, fResult2;

	printf("----Calling Dot Product function----\r\n");

	// We need to validate the algorithm's correctness
	for(i=0;i<N;i++)
	{
        a[i]=i;
	    b[i]=i;
	}

	fResult1 = dot_product_1(a,b,N,0);
	fResult2 = dot_product_2(a,b,N,0);

    printf("Golden Result=%d\r\n", GOLDEN_RESULT);
    printf("Result1=%f\r\n", fResult1);
    printf("Result2=%f\r\n", fResult2);

    printf("----Complete----\r\n");

	return 0;
}

//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//
//<copyright-disclaimer-end>
