/*
** ==============================================================================
**
** bootLoading_main.c
**
** Provides basic output via the serial port to show that the application
** has booted.
**
** todo:
**    2020.1 - update to use a compiler SYMBOL to blink the LEDs as a visual
**             indicator that booting was successful
**             stretch goal - use buttons to select LED blink pattern/rate
**
**    202?.? - use this with the sharedResources lab - work with Lance
**             this bootloading exercise could be valuable as a completion stage
**             to the sharedResources cluster. the downside is that it couldn't be
**             run in emulation until the PL is supported.
**
** History: 
**    2020/03/06 - WK - new for 2019.2
**
** Copyright Xilinx, 2013-2016
**
** ----------------------------------------------------------------------------
** ----------------------------------------------------------------------------
**
** Xilinx, Inc.
** XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A
** COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
** ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR
** STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION
** IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE
** FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION
** XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO
** THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO
** ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE
** FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY
** AND FITNESS FOR A PARTICULAR PURPOSE.
**
******************************************************************************/


#include <stdio.h>
#if VERSAL						        /* Versal */
    #include "platform_versal.h"
#else                                  /* all other platforms */
    #include "platform.h"
#endif
#include "stdint.h"

// function prototypes
void delay(unsigned nSec);
void delayms(unsigned nMsec);

/*** main ***/
int main()
{
   // define local variables
   unsigned           phase1_counter  =  10;
   unsigned           phase2_counter  = 500;

   // perform device initializations
   //init_platform();
   Xil_DCacheDisable();

   // give the USB uart some time to come up before writing to it
   delay(1);
   xil_printf("\n\r\nbootLoading Application started!\n\r");   // let the user know what's happening

   // Main Loop (infinite)
   while (1) {
      
      while (phase1_counter--) {
         xil_printf("WOW! we booted!\n\r");
         delayms(250);
      }
      
      while (phase2_counter--) {
         xil_printf("   %03d\n\r",phase2_counter);
         delayms(100);
      }
      
      phase1_counter =  10;
      phase2_counter = 500;
      
      break; // exit the infinite loop
      
   } // end of infinite while loop

   return 0;
}

/**
 *  delay (number of seconds)
 *
 *      loop configured to delay a certain amount to generate a 1 second pause in execution
 *      WARNING! This function is not calibrated and is only used as an example!
 *
 * @param nSec - number of seconds to delay
 * @return none
 */
void delay(unsigned nSec) {
   volatile int  delay;
   for (delay = 0; delay < 4000000 * nSec; delay++);
}

/**
 *  delayms (number of milliseconds)
 *
 *      loop configured to delay a certain amount to generate a 1 ms pause in execution
 *      WARNING! This function is not calibrated and is only used as an example!
 *
 * @param nMsec - number of milliseconds to delay
 * @return none
 */
void delayms(unsigned nSec) {
   volatile int  delay;
   for (delay = 0; delay < 40000 * nSec; delay++);
}

//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
