/*
 * utils_print.h
 *
 *  Created on: Dec 29, 2014
 *      Author: williamk
 */

#include "stdio.h"
#include "xil_types.h"
#include "xil_printf.h"


/* function prototypes */
void  		   end_line();
void		      use_only_nl();
void	         use_nl_and_cr();
void           strReverse(char s[]);
char*          intToString(int n);
char*          fltToString(float f);
char*          intToHexString(int n);
unsigned       isDigit(char c);
unsigned       is_printing_character(char c);
unsigned char  to_BCD(int x);
void check_status(int status_code, char* msg);
void check_null(void* ptr, char* msg);

/* handy macros */
#define writeStr_NL(x) xil_printf("%s",x); end_line()
#define writeStr xil_printf
#define writeNL  end_line
#define writeHex putnum
#define writeFloat(x)  writeStr(fltToString(x))
#define writeDbl(x)    xil_printf("%E",x)
#define writeInt_NL(x) xil_printf("%d",x); end_line()
#define writeInt(x)    xil_printf("%0d",x)



//<copyright-disclaimer-start>
//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
//<copyright-disclaimer-end>
