# Below is cut and paste shortcut for developers and delegates - DO NOT REMOVE
#cd C:/training/xtrig/support; source xtrig_completer.tcl; debugBuild;
#
#*******************************************************************************************************************************************
#
# script for performing the common tasks that completer scripts require
#
#   originally written to support the rapid development of both generic designs as well as the Unified Embedded Design
#
#    see Doxygen generated documentation
#
#
#<copyright-disclaimer-start>
#<copyright-disclaimer-start>
#  **************************************************************************************************************
#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#  * DISCLAIMER                                                                                                 *
#  * The information contained herein is for informational purposes only, and is subject to change              *
#  * without notice. While every precaution has been taken in the preparation of this document, it              *
#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#  * hardware, software or other products described herein.  No license, including implied or                   *
#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#  *                                                                                                            *
#  **************************************************************************************************************
#<copyright-disclaimer-end>
#<copyright-disclaimer-end>
#
# #####################################################################################
#
# xtrig_completer.tcl
#
# History
#    2024/02/12 - WK - 2023.2 - fixed for MPSoC
#    2023/09/25 - LR - 2023.1 - added "NOCactiveConfigurationList" table for user specified NOC properties, added processor sensitivity to ILAconnect. & added "resetConnect" proc for ACAP support, fixed MPS0C configuration properties 
#    2023/09/10 - WK - 2023.1 - removed environment variable loader in favor of variableReplacer <!!> variables, minor updates
#    2022/10/04 - LR - 2022.1 - Fixed misc bugs
#    2022/09/14 - WK - 2022.1 - removed es support, mapped procs to lab steps
#    2022/03/28 - WK - 2021.2 - fixed improperly structured procs
#    2022/03/18 - WK - 2021.2 - replaced "@@@" with file name for consistency with other scripts, adjusted for ZSA version
#                             - removed automatic building as this must support multiple platforms
#    2022/03/11 - RS - 2021.2 - updated for 2021.2, added a proc that adds Processor system reset and AXI interconnect
#    2022/03/16 - LR - 2021.2 - updated for Vivado and Versal - many changes
#    2022/03/16 - LR - 2021.2 - Added "@@@ - " to messages to make them easier to find debug, please do not remove
#    2021/11/04 - WK - 2021.2 - updated with pseudo environment variable loader, general cleanup
#    2020/08/13 - WK - 2020.2
#    2018/04/16 - WK - 2018.1 to "new" format
#    2016/07/27 - WK
#    2016/05/24 - SC - Tweaked scripts to target lab correctly
#    2016/04/18 - WK - 2016.1 - initial cut
#
# #####################################################################################
#
set badEnv 0;
if {[catch {variable trainingPath $::env(TRAINING_PATH)} emsg]} {
    puts "@@@ xtrig_completer.tcl: ERROR!!! TRAINING_PATH environment variable not defined!";
    set badEnv 1;
} else {
   regsub -all {\\} $trainingPath / trainingPath;
}

set target $trainingPath/CustEdIP/completer_helper.tcl;
if { [expr [file exist $target] + [file isfile $target]] != 2} {
    puts "@@@ xtrig_completer.tcl: ERROR!!! Missing $target which is requried for this script to work properly!";
    set badEnv 1;
} else {
   # load the helper script
   source  $trainingPath/CustEdIP/completer_helper.tcl;
}

if { $badEnv } {
    puts "@@@ xtrig_completer.tcl: ERROR!!! Cannot run the script in this environment - fix the problems listed above and try again!";
    exit 1
}


# enumerate the parameters of the project (used by completer_helper)
variable tcName          xtrig;
variable labName         $tcName;
variable projName        $tcName;
variable demoOrLab       lab;
variable verbose         1;
variable blockDesignName blkDsgn;
variable IPlist          {LEDs_Linear UART};

# no interrupts required in this design
variable suppressUARTinterrupt 0;
variable suppressInterrupts    0;
variable UARTdebug             1;      # adds ILA to Rx and Tx pins
variable saveProject           1;      # keeps a copy of the project (archived) after the build

use VHDL;   # langugage selection is irrelevant for this design

# supports           1-3                    1-3                    1-5       1-6,7       1-9               1-10
set stepList {{startingPointBuild constraintFilesDefaultAdd xTrigPSenable ILAconnect blockDesignWrap synthesisRun}\
              {debugLayoutOpen implementationRun bitstreamRun designExport_noPlatform}\
              { }\
              { }
             }
variable APSoCactivePeripheralList { CONFIG.PCW_USE_M_AXI_GP0                   1
                                     CONFIG.PCW_UART1_PERIPHERAL_ENABLE         1
                                     CONFIG.PCW_EN_CLK0_PORT                    1
                                     CONFIG.PCW_FPGA0_PERIPHERAL_FREQMHZ        100
                                     CONFIG.PCW_EN_RST0_PORT                    1
                                     CONFIG.PCW_QSPI_PERIPHERAL_ENABLE          1
                                     CONFIG.PCW_QSPI_GRP_SINGLE_SS_ENABLE       1
                                     CONFIG.PCW_USE_FABRIC_INTERRUPT            0
                                     CONFIG.PCW_IRQ_F2P_INTR                    0
                                   }
                                   
variable MPSoCactivePeripheralList { CONFIG.PSU__CAN1__PERIPHERAL__ENABLE        0
                                     CONFIG.PSU__DISPLAYPORT__PERIPHERAL__ENABLE 0
                                     CONFIG.PSU__ENET3__PERIPHERAL__ENABLE       0
                                     CONFIG.PSU__I2C1__PERIPHERAL__ENABLE        0
                                     CONFIG.PSU__SATA__PERIPHERAL__ENABLE        0
                                     CONFIG.PSU__SWDT0__PERIPHERAL__ENABLE       0
                                     CONFIG.PSU__SWDT1__PERIPHERAL__ENABLE       0
                                     CONFIG.PSU__TTC0__PERIPHERAL__ENABLE        0
                                     CONFIG.PSU__TTC1__PERIPHERAL__ENABLE        0
                                     CONFIG.PSU__TTC2__PERIPHERAL__ENABLE        0
                                     CONFIG.PSU__TTC3__PERIPHERAL__ENABLE        0
                                     CONFIG.PSU__USB0__PERIPHERAL__ENABLE        0
                                     CONFIG.PSU__USE__IRQ0                       0
                                     CONFIG.PSU__USE__M_AXI_GP0                  0
                                     CONFIG.PSU__USE__M_AXI_GP1                  0
                                     CONFIG.PSU__USE__M_AXI_GP2                  1
                                     CONFIG.PSU__USE__FABRIC__RST                1  
                                     CONFIG.PSU__NUM_FABRIC_RESETS               1
                                     CONFIG.PSU__I2C1__PERIPHERAL__ENABLE        1
                                     CONFIG.PSU__I2C1__PERIPHERAL__IO            "MIO 16 .. 17"
                                   }

variable APSoCactivePeripheralList { CONFIG.PCW_ENET0_PERIPHERAL_ENABLE          0
                                     CONFIG.PCW_GPIO_MIO_GPIO_ENABLE             0
                                     CONFIG.PCW_QSPI_GRP_SINGLE_SS_ENABLE        1
                                     CONFIG.PCW_TTC0_PERIPHERAL_ENABLE           0
                                     CONFIG.PCW_USB0_PERIPHERAL_ENABLE           0
                                     CONFIG.PCW_FPGA0_PERIPHERAL_FREQMHZ         100
                                   }
                                   
variable NOCactiveConfigurationList { CONFIG.NUM_CLKS                            6
                                      CONFIG.NUM_MI                              1
                                      CONFIG.NUM_SI                              6
                                    }
                     
                     
proc tester {} {
	set platforms {zc702, zcu104, vck190};   # add zed when it works
	foreach this_platform $platforms {
		puts "starting on $this_platform";
		use $this_platform;
		
		projectCreate;
		blockDesignCreate;
		processorAdd;
		processorConfigure;
		versalNocAdd;
      resetConnect;
		LEDsLinearAdd;
		xTrigPSenable;
		ILAconnect;
		regenerate_bd_layout;
		constraintFilesDefaultAdd;
		blockDesignWrap;
		synthesisRun;
		debugLayoutOpen;
		implementationRun;
		bitstreamRun;
		designExport_noPlatform;
	}
}

#proc buildStartingPoint {} { startingPointBuild; }
proc startingPointBuild {} {
   variable platform;
   variable verbose;
   if {$verbose} { puts "@@@ xtrig_completer.tcl:startingPointBuild" }

   # make certain that the platform was selected
   if {[string length $platform] == 0} {
      puts stderr "@@@ xtrig_completer.tcl: startingPointBuild: Guess who forgot to specify a platform?! - use \[ZC702 | ZED | ZCU102 | ZCU104 | ZCU111 | VMK180 | VCK190\];";
      return;
   } else {
      puts "@@@ xtrig_completer.tcl: startingPointBuild: Using platform: $platform";
   }

   projectCreate;
   blockDesignCreate;
   processorAdd;
   processorConfigure;
   versalNocAdd;
   #VIOadd;
   LEDsLinearAdd;
   resetConnect;
   regenerate_bd_layout;
   constraintFilesDefaultAdd;
   
   markLastStep startingPointBuild;
}



# just enables the xtrigger signals in the PS
# supports 1-5
proc xTrigPSenable {} {
   variable platform;
   variable processor;
   variable tcName;
   variable verbose;
   if {$verbose} { puts "@@@ xtrig_completer.tcl: xTrigPSenable";  }

   # connect to the appropriate processor
   set isVMK180  [strsame $platform VMK180];
   set isVCK190  [strsame $platform VCK190];
   set isACAP    [expr $isVCK190 || $isVMK180];
   set isUBlaze  [strsame $processor MicroBlaze];
   set isZed     [strsame $platform ZED];
   set isZC702   [strsame $platform ZC702];
   set isZ7000   [expr $isZed || $isZC702];
   set isZCU102  [strsame $platform ZCU102];
   set isZCU104  [strsame $platform ZCU104];
   set isZCU111  [strsame $platform ZCU111];
   set isMPSoC   [expr $isZCU102 || $isZCU104];
   set isRFSoC   $isZCU111;

   if {$isZ7000} {
       set_property -dict [list CONFIG.PCW_USE_CROSS_TRIGGER {1} CONFIG.PCW_FTM_CTI_IN0 {CPU0 DBG_REQ} CONFIG.PCW_FTM_CTI_OUT0 {CPU0 DBG_ACK}] [get_bd_cells processing_system7_0];
   } elseif {$isMPSoC || $isRFSoC} {
       set_property -dict [list CONFIG.PSU__FTM__CTI_IN_0 {1} CONFIG.PSU__FTM__CTI_OUT_0 {1} CONFIG.PSU__FTM__GPI {0}] [get_bd_cells zynq_ultra_ps_e_0]
   } elseif {$isACAP} {
       set_property CONFIG.PS_PMC_CONFIG { DDR_MEMORY_MODE {Connectivity to DDR via NOC} DEBUG_MODE {JTAG} PMC_USE_PMC_NOC_AXI0 {1} PS_FTM_CTI_IN0 {1} PS_FTM_CTI_OUT0 {1} PS_HSDP_EGRESS_TRAFFIC {JTAG} PS_HSDP_INGRESS_TRAFFIC {JTAG} PS_HSDP_MODE {NONE} PS_NUM_FABRIC_RESETS {1} PS_USE_FPD_CCI_NOC {1} PS_USE_FPD_CCI_NOC0 {1} PS_USE_NOC_LPD_AXI0 {1} PS_USE_PMCPL_CLK0 {1} SMON_ALARMS {Set_Alarms_On} SMON_ENABLE_TEMP_AVERAGING {0} SMON_TEMP_AVERAGING_SAMPLES {0} } [get_bd_cells versal_cips_0];
   } else {
      # at the moment, the uB is not supported
      # todo: add in uB support
      puts "@@@ xtrig_completer.tcl: Unsupported platform in xTrigPSenable: $platform";
   }
   save_bd_design;

   markLastStep xTrigPSenable
}

# supports 1-6, 7
proc ILAconnect {} {
   variable platform;
   variable processor;
   variable tcName;
   variable verbose;
   if {$verbose} { puts "@@@ xtrig_completer.tcl: ILAconnect";  }

   # connect to the appropriate processor
   set isVMK180   [strsame $platform VMK180];
   set isVCK190   [strsame $platform VCK190];
   set isACAP     [expr $isVCK190 || $isVMK180];
   set isUBlaze   [strsame $processor MicroBlaze];
   set isZed      [strsame $platform ZED];
   set isZC702    [strsame $platform ZC702];
   set isZ7000    [expr $isZed || $isZC702];
   set isZCU102   [strsame $platform ZCU102];
   set isZCU104   [strsame $platform ZCU104];
   set isZCU111   [strsame $platform ZCU111];
   set isMPSoC    [expr $isZCU102 || $isZCU104];
   set isRFSoC    $isZCU111;

   if {$isZ7000} {
       # make the first connection and the tools will generate the ILA
       apply_bd_automation -rule xilinx.com:bd_rule:trigger -config {ila_conn "Auto" }  [get_bd_intf_pins processing_system7_0/TRIGGER_IN_0];
       # rename the ILA
       set_property name Xtrig_ILA [get_bd_cells system_ila];
       # make the next connection to the ILA that was just created
       apply_bd_automation -rule xilinx.com:bd_rule:trigger -config {ila_conn "/Xtrig_ILA/TRIG_IN" }  [get_bd_intf_pins processing_system7_0/TRIGGER_OUT_0];
       connect_bd_net [get_bd_pins processing_system7_0/FCLK_CLK0] [get_bd_pins Xtrig_ILA/clk];
       connect_bd_net [get_bd_pins rst_ps7_0_100M/peripheral_aresetn] [get_bd_pins Xtrig_ILA/resetn];
       connect_bd_intf_net [get_bd_intf_pins Xtrig_ILA/SLOT_0_AXI] [get_bd_intf_pins GPIO_LEDs_linear/S_AXI];   # connect the AXI slot
   } elseif {$isMPSoC || $isRFSoC} {
       # make the first connection and the tools will generate the ILA
       apply_bd_automation -rule xilinx.com:bd_rule:trigger -config {ila_conn "Auto" }  [get_bd_intf_pins zynq_ultra_ps_e_0/PL_PS_TRIGGER_0]
       # rename the ILA
       set_property name Xtrig_ILA [get_bd_cells system_ila]
       # make the next connection to the ILA that was just created
       apply_bd_automation -rule xilinx.com:bd_rule:trigger -config {ila_conn "/Xtrig_ILA/TRIG_IN" }  [get_bd_intf_pins zynq_ultra_ps_e_0/PS_PL_TRIGGER_0]
       connect_bd_intf_net [get_bd_intf_pins Xtrig_ILA/SLOT_0_AXI] [get_bd_intf_pins GPIO_LEDs_rosetta/S_AXI]
       connect_bd_net [get_bd_pins Xtrig_ILA/clk] [get_bd_pins zynq_ultra_ps_e_0/pl_clk0]
       connect_bd_net [get_bd_pins Xtrig_ILA/resetn] [get_bd_pins rst_ps8_0_100M/peripheral_aresetn]
   } elseif {$isACAP} {
       # make the first connection and the tools will generate the ILA
       apply_bd_automation -rule xilinx.com:bd_rule:trigger -config {ila_conn "Auto" }  [get_bd_intf_pins versal_cips_0/PL_PS_TRIG0]
       # rename the ILA
       set_property name Xtrig_ILA [get_bd_cells axis_ila]
       # make the next connection to the ILA that was just created
       apply_bd_automation -rule xilinx.com:bd_rule:trigger -config {ila_conn "Auto" }  [get_bd_intf_pins versal_cips_0/PS_PL_TRIG0]
       apply_bd_automation -rule xilinx.com:bd_rule:clkrst -config { Clk {Auto} Freq {100} Ref_Clk0 {None} Ref_Clk1 {None} Ref_Clk2 {None}}  [get_bd_pins Xtrig_ILA/clk]
       set_property -dict [list CONFIG.C_BRAM_CNT {0} CONFIG.C_MON_TYPE {Interface_Monitor}] [get_bd_cells Xtrig_ILA]
       connect_bd_intf_net [get_bd_intf_pins Xtrig_ILA/SLOT_0_AXI] [get_bd_intf_pins GPIO_LEDs_rosetta_smc/M00_AXI]
       connect_bd_net [get_bd_pins Xtrig_ILA/resetn] [get_bd_pins rst_versal_cips_0_333M/peripheral_aresetn]
   } else {
      # at the moment, the uB is not supported
      # todo: add in uB support
      puts "@@@ xtrig_completer.tcl: Unsupported platform in ILAconnect: $platform";
   }
   regenerate_bd_layout
   save_bd_design;

   markLastStep ILAconnect
}

# Connect PS reset output to "processor system reset" IP controller
proc resetConnect {} {
   variable platform;
   variable processor;
   variable activeConfigurationList;
   variable verbose
   
   # what is it? makes comparisons below easier
   set isVCK190   [strsame $platform VCK190];
   set isACAP    [expr $isVCK190];
   set isZed     [strsame $platform Zed];
   set isZC702   [strsame $platform ZC702];
   set isZCU102  [strsame $platform ZCU102];
   set isZCU104  [strsame $platform ZCU104];
   set isZCU111  [strsame $platform ZCU111] ;
   set isZ7000   [expr $isZed || $isZC702];
   set isMPSoC   [expr $isZCU102 || $isZCU104 || $isZCU111];
   set isUBlaze  [strsame $processor MicroBlaze];
   set isA53     [strsame $processor A53];
   set isR5      [strsame $processor R5];
   set isA72     [strsame $processor A72];
   set isR5F     [strsame $processor R5F];

   if {$isACAP} {
     connect_bd_net [get_bd_pins versal_cips_0/pl0_resetn] [get_bd_pins rst_versal_cips_0_333M/ext_reset_in]
   } elseif {$isZ7000} {
      if {$verbose} { puts "@@@  completer_helper - NOC configuration not supported or required in $platform"; }
   } elseif {$isMPSoC} {
      if {$verbose} { puts "@@@  completer_helper - NOC configuration not supported or required in $platform"; }
   } elseif {$isUBlaze} {
      if {$verbose} { puts "@@@  completer_helper - NOC configuration not supported or required in $platform"; }
   } else {
      if {$verbose} { puts "@@@  completer_helper - NOC configuration not supported or required for undefined processor"; }
   }

   markLastStep versalNocAdd
}

set thisTcl ""
append thisTcl $tcName _completer.tcl
puts "@@@ xtrig_completer.tcl: $thisTcl sourced!\nloaded procs now available for your use as directed in the instructions"

# Below is cut and paste shortcut for developers and delegates - DO NOT REMOVE
proc debugBuild {} {
  start_gui;
#  use ZC702;
#  use Zed;
   use ZCU104;
#  use VCK190;
  startingPointBuild;
  xTrigPSenable;
  ILAconnect;
  reGenLayout;
  blockDesignWrap;
  bitstreamRun;
  designExport_noPlatform;
}

#debugBuild;
