/*
 * This file is a generated sample test application.
 *
 * This application is intended to test and/or illustrate some
 * functionality of your system.  The contents of this file may
 * vary depending on the IP in your system and may use existing
 * IP driver functions.  These drivers will be generated in your
 * SDK application project when you run the "Generate Libraries" menu item.
 *
 */


#include <stdio.h>
#include "xparameters.h"
#include "xil_cache.h"
#include "xgpio.h"

/******************* Global Variable Definitions **************************/

/*
 * The following are declared globally so they are zeroed and so they are
 * easily accessible from a debugger
 */
XGpio GpioOutput; /* The driver instance for GPIO Device configured as Output */

/************************** Constant Definitions ****************************/

/*
 * The following constant is used to wait after an LED is turned on to make
 * sure that it is visible to the human eye.  This constant might need to be
 * tuned for faster or slower processor speeds.
 */
#if defined(VCK190)
   #define DELAY_LIMIT 20000000
#elif defined(ZCU104)
   #define DELAY_LIMIT 50000000
#elif defined(ZC702) || defined(ZED)
   #define DELAY_LIMIT 1000000
#else
   #define BOARD_NOT_DEFINED
#endif

// following constant identifies which of the 2 channels of the GPIO is used
#define LED_CHANNEL 1

// loop limit for counter
#define COUNT_LIMIT 256

/*
 *  *** main() ***
 */
int main()
{
   // local variables
   unsigned int delay;
   unsigned int count;

   // enable the data and instruction caches
   Xil_ICacheEnable();
   Xil_DCacheEnable();

   // welcome the user
   print("--- Vivado Debug Exercise Program ---\n\r");

   // Initialize the GPIO driver -  XPAR parameters are defined in xparameters.h
   XGpio_Initialize(&GpioOutput, XPAR_XGPIO_0_BASEADDR);

   // Set the direction for all GPIO signals to be outputs
   XGpio_SetDataDirection(&GpioOutput, LED_CHANNEL, 0x0);

   // Initialize the GPIO outputs to low
   XGpio_DiscreteWrite(&GpioOutput, LED_CHANNEL, 0x0);

   // Infinite loop that counts through the 8 LEDs and periodically displays a message
   while (1) {
      for (count = 0x00; count < COUNT_LIMIT; count++) {
         XGpio_DiscreteWrite(&GpioOutput, LED_CHANNEL, count);
         if (count % 6 == 0) {
            printf("Count = 0x%0x\n\r", count);
         }
         if (count == 0x85) {
            printf("Special 0x85 Count Reached\n\r");
            printf("Line After Special Count 0x85 Reached\n\r");
         }
         for (delay = 0; delay < DELAY_LIMIT; delay++);         // pause so that user can see status of LEDs
      }
   }
   return 0;    // never reached
}


//<copyright-disclaimer-start>
//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
//<copyright-disclaimer-end>
