/*
 * Decompiled with CFR 0.152.
 */
package directededitor;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ArrayListViewer
extends JFrame {
    private ArrayList<String> buffer;
    private boolean runOneButtonPushed = false;
    private boolean runAllButtonPushed = false;
    private JLabel copyrightLabel;
    private JTextArea displayArea;
    private JLabel internalLineNumberLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField lastCommandTextField;
    private JTextArea mainTextArea;
    private JTextField nextCommandTextField;
    private JButton nextInstructionButton;
    private JButton runAllButton;
    private JLabel versionLabel;

    public ArrayListViewer(ArrayList<String> buf, String version, String versionDate) {
        super("Array List View for Directed Editor");
        this.buffer = buf;
        this.initComponents();
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        int x = (screenWidth - this.getWidth()) / 2;
        int y = (screenHeight - this.getHeight()) / 3;
        this.setLocation(x, y);
        this.mainTextArea.setText(this.convertToString(this.buffer));
        this.versionLabel.setText(version + " " + versionDate);
    }

    public ArrayListViewer(String title, ArrayList<String> buf, String version, String versionDate) {
        super(title);
        this.buffer = buf;
        this.initComponents();
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        int x = (screenWidth - this.getWidth()) / 2;
        int y = (screenHeight - this.getHeight()) / 3;
        this.setLocation(x, y);
        this.mainTextArea.setText(this.convertToString(this.buffer));
        this.versionLabel.setText(version + " " + versionDate);
    }

    private String convertToString(ArrayList<String> als) {
        if (als.size() == 0) {
            return "";
        }
        String returnString = this.pad("1", 3, 3) + ": " + als.get(0);
        for (int i = 1; i < als.size(); ++i) {
            returnString = returnString + "\n" + this.pad(String.valueOf(i + 1), 3, 3) + ": " + als.get(i);
        }
        return returnString;
    }

    public void setLineNumber(int lineNumber) {
        String sLineNumber = Integer.toString(lineNumber);
        this.internalLineNumberLabel.setText(sLineNumber);
    }

    public void setNextCommand(String s) {
        this.lastCommandTextField.setText(this.nextCommandTextField.getText());
        this.nextCommandTextField.setText(s);
    }

    public void updateBuffer(ArrayList<String> als) {
        this.buffer = als;
        this.mainTextArea.setText(this.convertToString(this.buffer));
    }

    private String pad(String s, int fieldSize, int justification) {
        String returnString;
        StringBuffer returnStringBuffer = new StringBuffer();
        int length = s.length();
        switch (justification) {
            case 0: {
                returnString = s;
                break;
            }
            case 1: {
                for (int i = 0; i < fieldSize - length; ++i) {
                    returnStringBuffer.append(" ");
                }
                returnStringBuffer.append(s);
                returnString = returnStringBuffer.toString();
                break;
            }
            case 2: {
                int i;
                for (i = 0; i < (fieldSize - length + 1) / 2; ++i) {
                    returnStringBuffer.append(" ");
                }
                returnStringBuffer.append(s);
                for (i = 0; i < (fieldSize - length + 1) / 2; ++i) {
                    returnStringBuffer.append(" ");
                }
                returnString = returnStringBuffer.toString();
                break;
            }
            case 3: {
                returnStringBuffer.append(s);
                for (int i = 0; i < fieldSize - length; ++i) {
                    returnStringBuffer.append(" ");
                }
                returnString = returnStringBuffer.toString();
                break;
            }
            default: {
                returnString = s;
            }
        }
        return returnString;
    }

    public boolean getNextPushed() {
        if (this.runOneButtonPushed) {
            this.runOneButtonPushed = false;
            return true;
        }
        return false;
    }

    public void addToDisplayArea(String s) {
        String currentDisplayAreaContents = this.displayArea.getText();
        boolean empty = currentDisplayAreaContents.isEmpty();
        if (empty) {
            this.displayArea.setText(s);
        } else {
            this.displayArea.setText(currentDisplayAreaContents + "\n" + s);
        }
    }

    public void setVisible(Boolean b) {
        this.setVisible(b);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainTextArea = new JTextArea();
        this.nextInstructionButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lastCommandTextField = new JTextField();
        this.nextCommandTextField = new JTextField();
        this.jScrollPane2 = new JScrollPane();
        this.displayArea = new JTextArea();
        this.runAllButton = new JButton();
        this.versionLabel = new JLabel();
        this.copyrightLabel = new JLabel();
        this.internalLineNumberLabel = new JLabel();
        this.setDefaultCloseOperation(3);
        this.mainTextArea.setColumns(20);
        this.mainTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.mainTextArea);
        this.nextInstructionButton.setText("next instruction");
        this.nextInstructionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArrayListViewer.this.nextInstructionButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("last command");
        this.jLabel2.setText("next command");
        this.displayArea.setColumns(20);
        this.displayArea.setRows(5);
        this.jScrollPane2.setViewportView(this.displayArea);
        this.runAllButton.setText("Run All");
        this.runAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ArrayListViewer.this.runAllButtonActionPerformed(evt);
            }
        });
        this.versionLabel.setText("V1.36 03 FEB 2016 - WK");
        this.copyrightLabel.setText("(c) Xilinx 2010-2022");
        this.internalLineNumberLabel.setText("-#-");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lastCommandTextField).addComponent(this.nextCommandTextField))).addComponent(this.jScrollPane2, GroupLayout.Alignment.LEADING))).addGroup(layout.createSequentialGroup().addGap(39, 39, 39).addComponent(this.nextInstructionButton, -2, 128, -2).addGap(254, 254, 254).addComponent(this.internalLineNumberLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.runAllButton, -2, 128, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.copyrightLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 633, Short.MAX_VALUE).addComponent(this.versionLabel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 254, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lastCommandTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.nextCommandTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextInstructionButton).addComponent(this.runAllButton).addComponent(this.internalLineNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 163, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 13, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionLabel).addComponent(this.copyrightLabel))));
        this.pack();
    }

    private void nextInstructionButtonActionPerformed(ActionEvent evt) {
        this.runOneButtonPushed = true;
    }

    private void runAllButtonActionPerformed(ActionEvent evt) {
        this.runAllButtonPushed = true;
    }

    protected boolean getRunAllButtonPushed() {
        return this.runAllButtonPushed;
    }
}

