/*
 * Decompiled with CFR 0.152.
 */
package directededitor;

import directededitor.cMessage;
import directededitor.cUtilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class cFileUtilities {
    private int status = 0;
    private ArrayList<String> internalErrorList = new ArrayList();
    private fileStatusValue fileStatus = fileStatusValue.UNKNOWN;
    private String fileName = "UNDEFINED";
    private FileInputStream dataFileInputStream;
    private FileWriter fOutputStream;
    private FileReader fInputStream;
    private BufferedWriter fileOutput;
    private BufferedReader fileInput;
    private final cUtilities utils = new cUtilities();

    public ArrayList<String> getErrors() {
        return this.internalErrorList;
    }

    public void clearErrors() {
        this.internalErrorList = new ArrayList();
    }

    public void useFileName(String fName) {
        this.fileName = fName;
    }

    public void setFileName(String fName) {
        this.fileName = fName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean openForWriting(String fName) {
        this.fileName = fName;
        this.fileStatus = fileStatusValue.REQUEST_TO_WRITE;
        return this.openForWriting();
    }

    public boolean openForWriting() {
        try {
            this.fileStatus = fileStatusValue.REQUEST_TO_WRITE;
            this.fOutputStream = new FileWriter(this.fileName, false);
            this.fileOutput = new BufferedWriter(this.fOutputStream);
            this.fileStatus = fileStatusValue.OPEN_FOR_WRITING;
            return true;
        }
        catch (IOException e) {
            this.internalErrorList.add("Could not openForWriting file named: " + this.fileName);
            return false;
        }
    }

    public boolean openForAppending(String fName) {
        this.fileName = fName;
        this.fileStatus = fileStatusValue.REQUEST_TO_APPEND;
        return this.openForAppending();
    }

    public boolean openForAppending() {
        try {
            this.fileStatus = fileStatusValue.REQUEST_TO_APPEND;
            this.fOutputStream = new FileWriter(this.fileName, true);
            this.fileOutput = new BufferedWriter(this.fOutputStream);
            this.fileStatus = fileStatusValue.OPEN_FOR_APPENDING;
            return true;
        }
        catch (IOException e) {
            this.internalErrorList.add("Could not openForWriting file named: " + this.fileName);
            return false;
        }
    }

    public boolean openForReading(String fName) {
        this.fileName = fName;
        this.fileStatus = fileStatusValue.REQUEST_TO_READ;
        return this.openForReading();
    }

    public boolean openForReading() {
        try {
            this.fileStatus = fileStatusValue.REQUEST_TO_READ;
            this.fInputStream = new FileReader(this.fileName);
            this.fileInput = new BufferedReader(this.fInputStream);
            this.fileStatus = fileStatusValue.OPEN_FOR_READING;
            return true;
        }
        catch (IOException e) {
            this.internalErrorList.add("Could not openForWriting file named: " + this.fileName);
            return false;
        }
    }

    public String read() {
        try {
            switch (this.fileStatus) {
                case UNKNOWN: 
                case REQUEST_TO_READ: {
                    this.internalErrorList.add("Cannot read from a file that hasn't been opened!");
                    break;
                }
                case REQUEST_TO_APPEND: {
                    this.internalErrorList.add("Cannot write to a file that hasn't been opened!");
                    break;
                }
                case REQUEST_TO_WRITE: {
                    this.internalErrorList.add("Cannot write to a file that hasn't been opened!");
                    break;
                }
                case OPEN_FOR_APPENDING: {
                    this.internalErrorList.add("Cannot read from a file that has been opened for reading!");
                    break;
                }
                case OPEN_FOR_READING: {
                    String line = this.fileInput.readLine().trim();
                    return line;
                }
                case OPEN_FOR_WRITING: {
                    this.internalErrorList.add("Cannot write to a file that has been opened for reading!");
                }
            }
        }
        catch (IOException e) {
            this.internalErrorList.add("attempted and failed to read from a file");
        }
        return null;
    }

    public boolean write(String s) {
        try {
            switch (this.fileStatus) {
                case UNKNOWN: 
                case REQUEST_TO_READ: 
                case REQUEST_TO_APPEND: 
                case REQUEST_TO_WRITE: {
                    this.internalErrorList.add("Cannot write to a file that hasn't been opened!");
                    break;
                }
                case OPEN_FOR_APPENDING: {
                    this.fileOutput.write(s);
                    return true;
                }
                case OPEN_FOR_READING: {
                    this.internalErrorList.add("Cannot write to a file that has been opened for reading!");
                    break;
                }
                case OPEN_FOR_WRITING: {
                    this.fileOutput.write(s);
                    return true;
                }
            }
        }
        catch (IOException e) {
            this.internalErrorList.add("attempted and failed to write to file");
        }
        return false;
    }

    public boolean writeln(String s) {
        try {
            switch (this.fileStatus) {
                case UNKNOWN: 
                case REQUEST_TO_READ: 
                case REQUEST_TO_APPEND: 
                case REQUEST_TO_WRITE: {
                    this.internalErrorList.add("Cannot write to a file that hasn't been opened!");
                    break;
                }
                case OPEN_FOR_APPENDING: {
                    this.fileOutput.write(s + "\n");
                    return true;
                }
                case OPEN_FOR_READING: {
                    this.internalErrorList.add("Cannot write to a file that has been opened for reading!");
                    break;
                }
                case OPEN_FOR_WRITING: {
                    this.fileOutput.write(s + "\n");
                    return true;
                }
            }
        }
        catch (IOException e) {
            this.internalErrorList.add("attempted and failed to write to file");
        }
        return false;
    }

    public void closeFile() {
        try {
            switch (this.fileStatus) {
                case UNKNOWN: 
                case REQUEST_TO_READ: 
                case REQUEST_TO_APPEND: 
                case REQUEST_TO_WRITE: {
                    this.internalErrorList.add("Cannot close a file that hasn't been opened!");
                    break;
                }
                case OPEN_FOR_APPENDING: {
                    this.fileOutput.close();
                    break;
                }
                case OPEN_FOR_READING: {
                    this.fileInput.close();
                    break;
                }
                case OPEN_FOR_WRITING: {
                    this.fileOutput.close();
                }
            }
        }
        catch (IOException e) {
            this.internalErrorList.add("could not close file");
        }
    }

    public void close() {
        this.closeFile();
    }

    public boolean delete(String fName) {
        this.fileName = fName;
        this.fileStatus = fileStatusValue.REQUEST_TO_DELETE;
        return this.delete();
    }

    public boolean delete() {
        File f = new File(this.fileName);
        return f.delete();
    }

    public boolean delete(File f) {
        return f.delete();
    }

    public boolean directoryMake(String s) {
        return this.makePath(s);
    }

    public boolean makePath(String s) {
        String directoryName = s;
        File theDir = new File(directoryName);
        boolean result = false;
        if (!theDir.exists()) {
            try {
                theDir.getParentFile().setWritable(true);
                result = theDir.mkdirs();
            }
            catch (SecurityException se) {
                cMessage m = new cMessage(null, true, "@", "could not create directory tree for: " + s);
                return false;
            }
            if (!result) {
                cMessage m = new cMessage(null, true, "@", "failed to create new directory");
                return false;
            }
        }
        return result;
    }

    public ArrayList<String> getLineList(String fName) {
        ArrayList<String> lineList = new ArrayList<String>();
        try (FileInputStream fis = new FileInputStream(fName);
             BufferedReader in = new BufferedReader(new InputStreamReader(fis));){
            while (in.ready()) {
                String line = in.readLine();
                lineList.add(line);
            }
        }
        catch (IOException e) {
            this.internalErrorList.add("IO Exception with " + fName + " (" + e.toString() + ")");
        }
        return lineList;
    }

    public boolean fileExists(String fName) {
        File f = new File(fName);
        return f.exists() && f.isFile();
    }

    public boolean directoryExists(String fName) {
        File d = new File(fName);
        return d.exists() && d.isDirectory();
    }

    public boolean atEOF() {
        switch (this.fileStatus) {
            case UNKNOWN: 
            case REQUEST_TO_READ: {
                this.internalErrorList.add("cannot check read pointer position in a file that is not open");
                break;
            }
            case REQUEST_TO_APPEND: 
            case REQUEST_TO_WRITE: {
                this.internalErrorList.add("Cannot check pointer positing in a file that hasn't been opened! Especially for writing/appending");
                break;
            }
            case OPEN_FOR_APPENDING: 
            case OPEN_FOR_WRITING: {
                this.internalErrorList.add("non-sensical operation - cannot check pointer position during write/append");
                break;
            }
            case OPEN_FOR_READING: {
                try {
                    if (!this.fileInput.ready()) {
                        return true;
                    }
                    break;
                }
                catch (IOException e) {
                    this.internalErrorList.add("problem checking EOF: " + e.toString());
                }
            }
        }
        return false;
    }

    public boolean isFile(String fName) {
        File f = new File(fName);
        return f.isFile();
    }

    public boolean hasExtension(String fName) {
        int extensionLength;
        int dotPos = fName.lastIndexOf(46);
        return dotPos != -1 && (extensionLength = fName.length() - dotPos) > 0 && extensionLength <= 4;
    }

    public String stripRootPath(String rootPath, String targetPath) {
        ArrayList<String> rootList = this.pathToArrayList(rootPath);
        ArrayList<String> targetList = this.pathToArrayList(targetPath);
        int rootIndex = 0;
        int targetIndex = 0;
        if (rootList.size() > 0 && rootList.get(rootIndex).charAt(1) == ':') {
            rootList.remove(rootIndex);
        }
        if (targetList.size() > 0 && targetList.get(targetIndex).charAt(1) == ':') {
            targetList.remove(targetIndex);
        }
        boolean matching = true;
        while (matching && rootIndex < rootList.size() && targetIndex < targetList.size()) {
            if (rootList.get(rootIndex++).compareToIgnoreCase(targetList.get(targetIndex++)) == 0) continue;
            matching = false;
        }
        if (matching && rootIndex == rootList.size()) {
            String returnString = "";
            if (targetList.size() > rootList.size()) {
                for (int i = rootIndex; i < targetList.size(); ++i) {
                    returnString = returnString + '\\' + targetList.get(i);
                }
                if (returnString.charAt(0) == '\\') {
                    returnString.substring(1, returnString.length());
                }
                return returnString;
            }
        }
        return targetPath;
    }

    public String stripFileName(String path) {
        int lastHierarchySeparator = path.lastIndexOf("\\");
        if (lastHierarchySeparator == -1) {
            return "";
        }
        return path.substring(0, lastHierarchySeparator);
    }

    public String stripPath(String path) {
        int lastHierarchySeparator = path.lastIndexOf("\\");
        if (lastHierarchySeparator == -1) {
            return path;
        }
        return path.substring(lastHierarchySeparator + 1, path.length());
    }

    public ArrayList<String> pathToArrayList(String path) {
        int posBackwardSlash;
        ArrayList<String> pathList = new ArrayList<String>();
        if (path.length() == 0) {
            return pathList;
        }
        int posForwardSlash = path.indexOf(47);
        int slashPosition = this.pickTheNonNegativeOne(posForwardSlash, posBackwardSlash = path.indexOf(92));
        if (slashPosition == -1) {
            return pathList;
        }
        int lastPosition = 0;
        boolean done = false;
        while (true) {
            String thisLevel;
            if ((thisLevel = path.substring(lastPosition, slashPosition)).length() != 0) {
                pathList.add(thisLevel);
            }
            if (done) break;
            lastPosition = slashPosition + 1;
            posForwardSlash = path.indexOf(47, lastPosition);
            if ((slashPosition = this.pickTheNonNegativeOne(posForwardSlash, posBackwardSlash = path.indexOf(92, lastPosition))) != -1) continue;
            slashPosition = path.length();
            done = true;
        }
        return pathList;
    }

    public int pickTheNonNegativeOne(int a, int b) {
        if (a > 0) {
            return a;
        }
        return b;
    }

    protected String getExtension(String fName) {
        int extensionLength;
        int dotPos = fName.lastIndexOf(46);
        if (dotPos != -1 && (extensionLength = fName.length() - dotPos - 1) > 0 && extensionLength <= 4) {
            return fName.substring(dotPos + 1, fName.length());
        }
        return "";
    }

    protected String stripExtension(String fName) {
        int extensionLength;
        int dotPos = fName.lastIndexOf(46);
        if (dotPos != -1 && (extensionLength = fName.length() - dotPos - 1) > 0 && extensionLength <= 4) {
            return fName.substring(0, dotPos);
        }
        return fName;
    }

    public ArrayList<String> stringToArrayList(String s, char separator) {
        String thisFragment;
        ArrayList<String> returnList = new ArrayList<String>();
        int lastSeparatorPos = 0;
        int separatorPos = s.indexOf(separator);
        while (separatorPos != -1) {
            thisFragment = s.substring(lastSeparatorPos, separatorPos).trim();
            if (thisFragment.length() > 0) {
                returnList.add(thisFragment);
            }
            lastSeparatorPos = separatorPos + 1;
            separatorPos = s.indexOf(separator, lastSeparatorPos);
        }
        thisFragment = s.substring(lastSeparatorPos, s.length());
        if (thisFragment.length() > 0) {
            returnList.add(thisFragment);
        }
        return returnList;
    }

    public boolean renameFile(String currentName, String newName) {
        if (this.fileExists(currentName)) {
            File current = new File(currentName);
            File newN = new File(newName);
            current.renameTo(newN);
            if (this.fileExists(newName)) {
                return true;
            }
            System.err.println("Failed to rename " + currentName + " as " + newName);
        } else {
            System.err.println("Can't rename file " + currentName + " since it doesn't exist!");
        }
        return false;
    }

    public void copyFile(String sourceName, String destName) {
        ArrayList<String> destNameElements = this.utils.stringToList(destName, "\\");
        destNameElements.remove(destNameElements.size() - 1);
        if (destNameElements.size() > 0 && destNameElements.get(0).endsWith(":")) {
            destNameElements.remove(0);
        }
        String pathToTest = "";
        for (String thisElement : destNameElements) {
            if (this.directoryExists(pathToTest = pathToTest + "\\" + thisElement)) continue;
            this.directoryMake(pathToTest);
        }
        this.copyFile(new File(sourceName), new File(destName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File sourceFile, File destFile) {
        try {
            if (!destFile.exists() && !destFile.createNewFile()) {
                System.err.println("could not create destination file: " + destFile.getName());
            }
            FileChannel source = new FileInputStream(sourceFile).getChannel();
            FileChannel destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0L, source.size());
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        catch (IOException e) {
            this.status = -1;
            System.err.println("Failed to copy: " + sourceFile + " --> " + destFile);
            System.err.println(e.toString());
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String findFile(String startingPoint, String target) {
        ArrayList<Object> masterFileList = new ArrayList();
        String topDirectoryName = startingPoint;
        File topDirectory = new File(topDirectoryName);
        if (topDirectory.isDirectory()) {
            masterFileList = this.buildFileList(topDirectory);
        }
        for (int i = 0; i < masterFileList.size(); ++i) {
            String thisFileName = ((File)masterFileList.get(i)).getName();
            if (thisFileName.compareToIgnoreCase(target) != 0) continue;
            return ((File)masterFileList.get(i)).getAbsolutePath();
        }
        return "";
    }

    public ArrayList<String> getFileNames(String directoryName) {
        File[] listOfFiles;
        ArrayList<String> list = new ArrayList<String>();
        File folder = new File(directoryName);
        for (File thisFile : listOfFiles = folder.listFiles()) {
            if (!thisFile.isFile()) continue;
            list.add(thisFile.getName());
        }
        return list;
    }

    public ArrayList<String> getFileNames(String directoryName, String startsWith) {
        File[] listOfFiles;
        ArrayList<String> list = new ArrayList<String>();
        File folder = new File(directoryName);
        for (File thisFile : listOfFiles = folder.listFiles()) {
            ArrayList<String> nameElements = this.utils.stringToList(thisFile.toString(), "\\");
            String nameOnly = nameElements.get(nameElements.size() - 1);
            if (!thisFile.isFile() || !nameOnly.startsWith(startsWith)) continue;
            list.add(thisFile.getName());
        }
        return list;
    }

    public ArrayList<String> getDirectoryNames(String directoryName) {
        File[] listOfDirectories;
        ArrayList<String> list = new ArrayList<String>();
        File folder = new File(directoryName);
        for (File thisFile : listOfDirectories = folder.listFiles()) {
            if (!thisFile.isDirectory()) continue;
            list.add(thisFile.getName());
        }
        return list;
    }

    public ArrayList<File> buildFileList(File startingPoint) {
        ArrayList<File> returnList = new ArrayList<File>();
        String path = startingPoint.getAbsolutePath();
        String[] fileNameList = startingPoint.list();
        if (fileNameList == null) {
            return returnList;
        }
        for (String fileNameList1 : fileNameList) {
            String thisFileName = fileNameList1.trim();
            File thisFile = new File(path + "\\" + thisFileName);
            if (thisFile.isHidden()) continue;
            if (thisFile.isDirectory()) {
                ArrayList<File> partialList = this.buildFileList(thisFile);
                returnList.addAll(partialList);
                continue;
            }
            returnList.add(thisFile.getAbsoluteFile());
        }
        return returnList;
    }

    public ArrayList<File> buildDirectoryList(File startingPoint, int nLevels) {
        ArrayList<File> returnList = new ArrayList<File>();
        if (nLevels < 0) {
            return returnList;
        }
        String path = startingPoint.getAbsolutePath();
        String[] dirNameList = startingPoint.list();
        if (dirNameList == null) {
            return returnList;
        }
        for (String dirNameList1 : dirNameList) {
            String thisDirName = dirNameList1.trim();
            File thisDir = new File(path + "\\" + thisDirName);
            if (thisDir.isHidden() || !thisDir.isDirectory()) continue;
            ArrayList<File> partialList = this.buildDirectoryList(thisDir, nLevels - 1);
            returnList.addAll(partialList);
            returnList.add(thisDir.getAbsoluteFile());
        }
        return returnList;
    }

    protected boolean newer(String f1, String f2) {
        return this.newer(new File(f1), new File(f2));
    }

    protected boolean newer(File f1, File f2) {
        long modStamp2;
        long modStamp1 = f1.lastModified();
        return modStamp1 > (modStamp2 = f2.lastModified());
    }

    protected ArrayList<File> reverseFileList(ArrayList<File> list) {
        for (int i = 0; i < list.size() / 2; ++i) {
            File temp = list.get(i);
            list.set(i, list.get(list.size() - i - 1));
            list.set(list.size() - i - 1, temp);
        }
        return list;
    }

    public ArrayList<File> sortFileListAlphabetically(ArrayList<File> list) {
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            for (int j = 0; j < list.size() - 1; ++j) {
                String nextPath;
                String thisPath = list.get(j).getAbsolutePath();
                if (thisPath.compareTo(nextPath = list.get(j + 1).getAbsolutePath()) <= 0) continue;
                File temp = list.get(j);
                list.set(j, list.get(j + 1));
                list.set(j + 1, temp);
                keepGoing = true;
            }
        }
        return list;
    }

    private static enum fileStatusValue {
        UNKNOWN,
        REQUEST_TO_WRITE,
        REQUEST_TO_APPEND,
        REQUEST_TO_READ,
        OPEN_FOR_READING,
        OPEN_FOR_WRITING,
        OPEN_FOR_APPENDING,
        CLOSED,
        REQUEST_TO_DELETE;

    }
}

