/*
 * Decompiled with CFR 0.152.
 */
package directededitor;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class cMessage
extends JDialog {
    public final int width = 48;
    public final int height = 48;
    private JButton closeButton;
    private JLabel iconLabel;
    private JScrollPane messageScrollPane;
    private JTextArea messageTextArea;

    public cMessage(Frame parent, boolean modal, String title, String iconFileName, String message) {
        super(parent, modal);
        this.setTitle(title);
        this.initComponents();
        ImageIcon icon = this.createImageIcon(iconFileName, "");
        if (icon == null) {
            this.iconLabel.setText("");
        } else {
            this.iconLabel.setText("");
            this.iconLabel.setIcon(icon);
            this.iconLabel.setPreferredSize(new Dimension(48, 48));
            this.iconLabel.setMaximumSize(new Dimension(48, 48));
            this.iconLabel.setMinimumSize(new Dimension(48, 48));
        }
        this.messageTextArea.setText(message);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        int x = (screenWidth - this.getWidth()) / 2;
        int y = (screenHeight - this.getHeight()) / 3;
        this.setLocation(x, y);
        this.repaint();
        this.pack();
        this.setVisible(true);
    }

    public cMessage(Frame parent, boolean modal, String iconFileName, String message) {
        super(parent, modal);
        this.initComponents();
        ImageIcon icon = this.createImageIcon(iconFileName, "");
        if (icon == null) {
            this.iconLabel.setText("");
        } else {
            this.iconLabel.setText("");
            this.iconLabel.setIcon(icon);
            this.iconLabel.setPreferredSize(new Dimension(48, 48));
            this.iconLabel.setMaximumSize(new Dimension(48, 48));
            this.iconLabel.setMinimumSize(new Dimension(48, 48));
        }
        this.messageTextArea.setText(message);
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        int x = (screenWidth - this.getWidth()) / 2;
        int y = (screenHeight - this.getHeight()) / 3;
        this.setLocation(x, y);
        this.repaint();
        this.pack();
        this.setVisible(true);
    }

    private void initComponents() {
        this.closeButton = new JButton();
        this.messageScrollPane = new JScrollPane();
        this.messageTextArea = new JTextArea();
        this.iconLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.closeButton.setText("close");
        this.closeButton.setAlignmentX(0.5f);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                cMessage.this.closeButtonActionPerformed(evt);
            }
        });
        this.messageTextArea.setColumns(20);
        this.messageTextArea.setRows(5);
        this.messageScrollPane.setViewportView(this.messageTextArea);
        this.iconLabel.setHorizontalAlignment(0);
        this.iconLabel.setText("<icon goes here>");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageScrollPane, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE).addComponent(this.iconLabel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(171, 171, 171).addComponent(this.closeButton).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.iconLabel, -1, 61, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageScrollPane, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.closeButton)));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    protected ImageIcon createImageIcon(String path, String description) {
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(path));
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            double scaleX = 48.0 / (double)imageWidth;
            double scaleY = 48.0 / (double)imageHeight;
            AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
            AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 2);
            int imageType = image.getType();
            if (imageType == 0) {
                imageType = 2;
            }
            image = bilinearScaleOp.filter(image, new BufferedImage(48, 48, imageType));
            return new ImageIcon(image);
        }
        catch (IOException e) {
            System.err.println("Couldn't find file: " + path);
        }
        catch (Exception e2) {
            System.err.println("other exception: " + e2.toString());
        }
        if (image == null) {
            return null;
        }
        return new ImageIcon(image);
    }
}

