/*
 * Decompiled with CFR 0.152.
 */
package objDump_helper;

import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import objDump_helper.FileCustomFilter;

public class FileBrowser {
    private boolean multipleSelectionEnabled = false;
    private String fullPath;
    private FileCustomFilter fcf;
    private boolean useFilter = false;

    public FileBrowser() {
        this.useFilter = false;
    }

    public FileBrowser(String ext) {
        this.useFilter = true;
        this.fcf = new FileCustomFilter(ext);
    }

    public void setDescription(String s) {
        if (this.fcf != null) {
            this.fcf.setDescription(s);
        }
    }

    public void setFilter(String ext) {
        this.useFilter = true;
        if (this.fcf == null) {
            this.fcf = new FileCustomFilter(ext);
        } else {
            this.fcf.addExtension(ext);
        }
    }

    public void multipleSelection(boolean b) {
        this.multipleSelectionEnabled = b;
    }

    public ArrayList<String> getLotsOfStuff(String startingLocation, boolean filesOK, boolean directoriesOK) {
        File[] targetList = null;
        String fullPath = "";
        ArrayList<String> returnList = new ArrayList<String>();
        JFileChooser chooser = new JFileChooser();
        if (this.useFilter) {
            chooser.addChoosableFileFilter(this.fcf);
        }
        if (this.multipleSelectionEnabled) {
            chooser.setMultiSelectionEnabled(filesOK || directoriesOK);
        }
        if (filesOK && directoriesOK) {
            chooser.setFileSelectionMode(2);
        } else if (filesOK) {
            chooser.setFileSelectionMode(0);
        } else if (directoriesOK) {
            chooser.setFileSelectionMode(1);
        } else {
            return null;
        }
        if (startingLocation == null) {
            startingLocation = "C:\\";
        }
        File sourceDirectory = new File(startingLocation);
        chooser.setSelectedFile(sourceDirectory);
        int option = chooser.showOpenDialog(null);
        if (option == 0) {
            targetList = chooser.getSelectedFiles();
            for (int index = 0; index < targetList.length; ++index) {
                returnList.add(targetList[index].toString());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Canceled!", "Open File", -1);
        }
        return returnList;
    }

    public String getStuff(String startingLocation, boolean filesOK, boolean directoriesOK) {
        JFileChooser chooser = new JFileChooser();
        if (this.useFilter) {
            chooser.addChoosableFileFilter(this.fcf);
        }
        if (filesOK && directoriesOK) {
            chooser.setFileSelectionMode(2);
        } else if (filesOK) {
            chooser.setFileSelectionMode(0);
        } else if (directoriesOK) {
            chooser.setFileSelectionMode(1);
        } else {
            return "";
        }
        if (startingLocation == null) {
            startingLocation = "C:\\";
        }
        File sourceDirectory = new File(startingLocation);
        chooser.setSelectedFile(sourceDirectory);
        int option = chooser.showOpenDialog(null);
        if (option == 0) {
            File target = chooser.getSelectedFile();
            this.fullPath = target.isDirectory() ? target.getAbsolutePath() : target.getAbsolutePath();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
        return this.fullPath;
    }
}

