/*
 * Decompiled with CFR 0.152.
 */
package objDump_helper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

public class cFileUtilities {
    private int status = 0;
    private ArrayList<String> internalErrorList = new ArrayList();
    private fileStatusValue fileStatus = fileStatusValue.UNKNOWN;
    private String fileName = "UNDEFINED";
    private FileInputStream dataFileInputStream;
    private FileWriter fOutputStream;
    private FileReader fInputStream;
    private BufferedWriter fileOutput;
    private BufferedReader fileInput;

    public ArrayList<String> getErrors() {
        return this.internalErrorList;
    }

    public void clearErrors() {
        this.internalErrorList = new ArrayList();
    }

    public void useFileName(String fName) {
        this.fileName = fName;
    }

    public void setFileName(String fName) {
        this.fileName = fName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean openForWriting(String fName) {
        this.fileName = fName;
        this.fileStatus = fileStatusValue.REQUEST_TO_WRITE;
        return this.openForWriting();
    }

    public boolean openForWriting() {
        try {
            this.fileStatus = fileStatusValue.REQUEST_TO_WRITE;
            this.fOutputStream = new FileWriter(this.fileName, false);
            this.fileOutput = new BufferedWriter(this.fOutputStream);
            this.fileStatus = fileStatusValue.OPEN_FOR_WRITING;
            return true;
        }
        catch (IOException e) {
            this.internalErrorList.add("Could not openForWriting file named: " + this.fileName);
            return false;
        }
    }

    public boolean openForAppending(String fName) {
        this.fileName = fName;
        this.fileStatus = fileStatusValue.REQUEST_TO_APPEND;
        return this.openForAppending();
    }

    public boolean openForAppending() {
        try {
            this.fileStatus = fileStatusValue.REQUEST_TO_APPEND;
            this.fOutputStream = new FileWriter(this.fileName, true);
            this.fileOutput = new BufferedWriter(this.fOutputStream);
            this.fileStatus = fileStatusValue.OPEN_FOR_APPENDING;
            return true;
        }
        catch (IOException e) {
            this.internalErrorList.add("Could not openForWriting file named: " + this.fileName);
            return false;
        }
    }

    public boolean openForReading(String fName) {
        this.fileName = fName;
        this.fileStatus = fileStatusValue.REQUEST_TO_READ;
        return this.openForReading();
    }

    public boolean openForReading() {
        try {
            this.fileStatus = fileStatusValue.REQUEST_TO_READ;
            this.fInputStream = new FileReader(this.fileName);
            this.fileInput = new BufferedReader(this.fInputStream);
            this.fileStatus = fileStatusValue.OPEN_FOR_READING;
            return true;
        }
        catch (IOException e) {
            this.internalErrorList.add("Could not openForWriting file named: " + this.fileName);
            return false;
        }
    }

    public String read() {
        try {
            switch (this.fileStatus) {
                case UNKNOWN: 
                case REQUEST_TO_READ: {
                    this.internalErrorList.add("Cannot read from a file that hasn't been opened!");
                    break;
                }
                case REQUEST_TO_APPEND: {
                    this.internalErrorList.add("Cannot write to a file that hasn't been opened!");
                    break;
                }
                case REQUEST_TO_WRITE: {
                    this.internalErrorList.add("Cannot write to a file that hasn't been opened!");
                    break;
                }
                case OPEN_FOR_APPENDING: {
                    this.internalErrorList.add("Cannot read from a file that has been opened for reading!");
                    break;
                }
                case OPEN_FOR_READING: {
                    String line = this.fileInput.readLine().trim();
                    return line;
                }
                case OPEN_FOR_WRITING: {
                    this.internalErrorList.add("Cannot write to a file that has been opened for reading!");
                }
            }
        }
        catch (IOException e) {
            this.internalErrorList.add("attempted and failed to read from a file");
        }
        return null;
    }

    public boolean write(String s) {
        try {
            switch (this.fileStatus) {
                case UNKNOWN: 
                case REQUEST_TO_READ: 
                case REQUEST_TO_APPEND: 
                case REQUEST_TO_WRITE: {
                    this.internalErrorList.add("Cannot write to a file that hasn't been opened!");
                    break;
                }
                case OPEN_FOR_APPENDING: {
                    this.fileOutput.write(s);
                    return true;
                }
                case OPEN_FOR_READING: {
                    this.internalErrorList.add("Cannot write to a file that has been opened for reading!");
                    break;
                }
                case OPEN_FOR_WRITING: {
                    this.fileOutput.write(s);
                    return true;
                }
            }
        }
        catch (IOException e) {
            this.internalErrorList.add("attempted and failed to write to file");
        }
        return false;
    }

    public void closeFile() {
        try {
            switch (this.fileStatus) {
                case UNKNOWN: 
                case REQUEST_TO_READ: 
                case REQUEST_TO_APPEND: 
                case REQUEST_TO_WRITE: {
                    this.internalErrorList.add("Cannot close a file that hasn't been opened!");
                    break;
                }
                case OPEN_FOR_APPENDING: {
                    this.fileOutput.close();
                    break;
                }
                case OPEN_FOR_READING: {
                    this.fileInput.close();
                    break;
                }
                case OPEN_FOR_WRITING: {
                    this.fileOutput.close();
                }
            }
        }
        catch (IOException e) {
            this.internalErrorList.add("could not close file");
        }
    }

    public void close() {
        this.closeFile();
    }

    public boolean delete(String fName) {
        this.fileName = fName;
        this.fileStatus = fileStatusValue.REQUEST_TO_DELETE;
        return this.delete();
    }

    public boolean delete() {
        File f = new File(this.fileName);
        return f.delete();
    }

    public ArrayList<String> getLineList(String fName) {
        ArrayList<String> lineList = new ArrayList<String>();
        try {
            FileInputStream fis = new FileInputStream(fName);
            BufferedReader in = new BufferedReader(new InputStreamReader(fis));
            while (in.ready()) {
                String line = in.readLine();
                lineList.add(line);
            }
            in.close();
            fis.close();
        }
        catch (IOException e) {
            this.internalErrorList.add("IO Exception with " + fName);
        }
        return lineList;
    }

    public boolean fileExists(String fName) {
        File f = new File(fName);
        return f.exists() && f.isFile();
    }

    public boolean atEOF() {
        switch (this.fileStatus) {
            case UNKNOWN: 
            case REQUEST_TO_READ: {
                this.internalErrorList.add("cannot check read pointer position in a file that is not open");
                break;
            }
            case REQUEST_TO_APPEND: 
            case REQUEST_TO_WRITE: {
                this.internalErrorList.add("Cannot check pointer positing in a file that hasn't been opened! Especially for writing/appending");
                break;
            }
            case OPEN_FOR_APPENDING: 
            case OPEN_FOR_WRITING: {
                this.internalErrorList.add("non-sensical operation - cannot check pointer position during write/append");
                break;
            }
            case OPEN_FOR_READING: {
                try {
                    if (!this.fileInput.ready()) {
                        return true;
                    }
                    break;
                }
                catch (IOException e) {
                    this.internalErrorList.add("problem checking EOF: " + e.toString());
                }
            }
        }
        return false;
    }

    public boolean isFile(String fName) {
        File f = new File(fName);
        return f.isFile();
    }

    public boolean hasExtension(String fName) {
        int extensionLength;
        int dotPos = fName.lastIndexOf(46);
        return dotPos != -1 && (extensionLength = fName.length() - dotPos) > 0 && extensionLength <= 4;
    }

    public String stripRootPath(String rootPath, String targetPath) {
        ArrayList<String> rootList = this.pathToArrayList(rootPath);
        ArrayList<String> targetList = this.pathToArrayList(targetPath);
        int rootIndex = 0;
        int targetIndex = 0;
        if (rootList.size() > 0 && rootList.get(rootIndex).charAt(1) == ':') {
            rootList.remove(rootIndex);
        }
        if (targetList.size() > 0 && targetList.get(targetIndex).charAt(1) == ':') {
            targetList.remove(targetIndex);
        }
        boolean matching = true;
        while (matching && rootIndex < rootList.size() && targetIndex < targetList.size()) {
            if (rootList.get(rootIndex++).compareToIgnoreCase(targetList.get(targetIndex++)) == 0) continue;
            matching = false;
        }
        if (matching && rootIndex == rootList.size()) {
            String returnString = "";
            if (targetList.size() > rootList.size()) {
                for (int i = rootIndex; i < targetList.size(); ++i) {
                    returnString = returnString + '\\' + targetList.get(i);
                }
                if (returnString.charAt(0) == '\\') {
                    returnString.substring(1, returnString.length());
                }
                return returnString;
            }
        }
        return targetPath;
    }

    public ArrayList<String> pathToArrayList(String path) {
        int posBackwardSlash;
        ArrayList<String> pathList = new ArrayList<String>();
        if (path.length() == 0) {
            return pathList;
        }
        int posForwardSlash = path.indexOf(47);
        int slashPosition = this.pickTheNonNegativeOne(posForwardSlash, posBackwardSlash = path.indexOf(92));
        if (slashPosition == -1) {
            return pathList;
        }
        int lastPosition = 0;
        boolean done = false;
        while (true) {
            String thisLevel;
            if ((thisLevel = path.substring(lastPosition, slashPosition)).length() != 0) {
                pathList.add(thisLevel);
            }
            if (done) break;
            lastPosition = slashPosition + 1;
            posForwardSlash = path.indexOf(47, lastPosition);
            if ((slashPosition = this.pickTheNonNegativeOne(posForwardSlash, posBackwardSlash = path.indexOf(92, lastPosition))) != -1) continue;
            slashPosition = path.length();
            done = true;
        }
        return pathList;
    }

    public int pickTheNonNegativeOne(int a, int b) {
        if (a > 0) {
            return a;
        }
        return b;
    }

    public ArrayList<String> stringToArrayList(String s, char separator) {
        ArrayList<String> returnList = new ArrayList<String>();
        String thisFragment = "";
        int lastSeparatorPos = 0;
        int separatorPos = s.indexOf(separator);
        while (separatorPos != -1) {
            thisFragment = s.substring(lastSeparatorPos, separatorPos).trim();
            if (thisFragment.length() > 0) {
                returnList.add(thisFragment);
            }
            lastSeparatorPos = separatorPos + 1;
            separatorPos = s.indexOf(separator, lastSeparatorPos);
        }
        thisFragment = s.substring(lastSeparatorPos, s.length());
        if (thisFragment.length() > 0) {
            returnList.add(thisFragment);
        }
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File sourceFile, File destFile) {
        FileChannel source = null;
        FileChannel destination = null;
        try {
            boolean status;
            if (!destFile.exists() && !(status = destFile.createNewFile())) {
                System.err.println("could not create destination file: " + destFile.getName());
            }
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0L, source.size());
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        catch (IOException e) {
            this.status = -1;
            System.err.println("Failed to copy: " + sourceFile + " --> " + destFile);
            System.err.println(e.toString());
        }
    }

    public int getStatus() {
        return this.status;
    }

    public int stringToInt(String s) {
        try {
            int i = Integer.parseInt(s);
            return i;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getTimeDateStamp() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
        return timeStamp;
    }

    public String findFile(String startingPoint, String target, String OS) {
        ArrayList<Object> masterFileList = new ArrayList();
        String topDirectoryName = startingPoint;
        File topDirectory = new File(topDirectoryName);
        if (topDirectory.isDirectory()) {
            masterFileList = this.buildFileList(topDirectory, true, OS);
        }
        for (int i = 0; i < masterFileList.size(); ++i) {
            String thisFileName = ((File)masterFileList.get(i)).getName();
            if (thisFileName.compareToIgnoreCase(target) != 0) continue;
            return ((File)masterFileList.get(i)).getAbsolutePath();
        }
        return "";
    }

    protected ArrayList<File> buildFileList(String startingPoint, boolean useRecursion, String OS) {
        File f = new File(startingPoint);
        return this.buildFileList(f, useRecursion, OS);
    }

    protected ArrayList<File> buildFileList(File startingPoint, boolean useRecursion, String OS) {
        String hierarchicalSeparator = "/";
        if (OS.contains("ind")) {
            hierarchicalSeparator = "\\";
        }
        ArrayList<File> returnList = new ArrayList<File>();
        String path = startingPoint.getAbsolutePath();
        String[] fileNameList = startingPoint.list(new setFilters());
        if (fileNameList == null) {
            System.err.println("Empty file name list in buildFileList");
            return returnList;
        }
        for (int i = 0; i < fileNameList.length; ++i) {
            String thisFileName = fileNameList[i].trim();
            File thisFile = new File(path + hierarchicalSeparator + thisFileName);
            if (!thisFile.isHidden()) {
                if (thisFile.isDirectory()) {
                    if (useRecursion) {
                        ArrayList<File> partialList = this.buildFileList(thisFile, useRecursion, OS);
                        returnList.addAll(partialList);
                        continue;
                    }
                    returnList.add(thisFile.getAbsoluteFile());
                    continue;
                }
                returnList.add(thisFile.getAbsoluteFile());
                continue;
            }
            System.out.println("Hidden file/directory found: " + thisFile.toString());
        }
        return returnList;
    }

    private static enum fileStatusValue {
        UNKNOWN,
        REQUEST_TO_WRITE,
        REQUEST_TO_APPEND,
        REQUEST_TO_READ,
        OPEN_FOR_READING,
        OPEN_FOR_WRITING,
        OPEN_FOR_APPENDING,
        CLOSED,
        REQUEST_TO_DELETE;

    }

    class setFilters
    implements FilenameFilter {
        setFilters() {
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean result = false;
            boolean somethingSelected = false;
            return true;
        }
    }
}

