/*
 * Decompiled with CFR 0.152.
 */
package objDump_helper;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;

public class cUtilities {
    private String inputStream;
    private String errorStream;
    private String stdoutCapture = "";
    private String stderrCapture = "";

    public boolean delay(int secs) {
        try {
            Thread.sleep(secs * 1000);
            return true;
        }
        catch (InterruptedException ex) {
            System.err.println("Couldn't sleep! cUtilities.delay()");
            return false;
        }
    }

    public double stringToDouble(String s) {
        try {
            double i = Double.parseDouble(s.trim());
            return i;
        }
        catch (NumberFormatException e) {
            String message = "cUtilities: cannot convert " + s + " to a double";
            System.err.println(message);
            return 0.0;
        }
    }

    public int stringToInt(String s) {
        try {
            int i = Integer.parseInt(s.trim());
            return i;
        }
        catch (NumberFormatException e) {
            String message = "cUtilities: cannot convert " + s + " to an integer";
            System.err.println(message);
            return 0;
        }
    }

    public String listToString(ArrayList<String> s) {
        String returnString = "";
        for (int i = 0; i < s.size(); ++i) {
            returnString = returnString + s.get(i);
            if (i >= s.size() - 1) continue;
            returnString = returnString + ",";
        }
        return returnString;
    }

    public ArrayList<String> stringToList(String sList, String separator) {
        String thisElement;
        ArrayList<String> list = new ArrayList<String>();
        int pos = sList.indexOf(separator);
        int lastPos = 0;
        while (pos != -1) {
            thisElement = sList.substring(lastPos, pos);
            lastPos = pos + 1;
            pos = sList.indexOf(separator, lastPos);
            list.add(thisElement.trim());
        }
        thisElement = sList.substring(lastPos, sList.length()).trim();
        if (thisElement.length() != 0) {
            list.add(thisElement.trim());
        }
        return list;
    }

    public ArrayList<String> sortArrayListAlphabetically(ArrayList<String> list) {
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            for (int j = 0; j < list.size() - 1; ++j) {
                if (list.get(j).compareTo(list.get(j + 1)) <= 0) continue;
                String temp = list.get(j);
                list.set(j, list.get(j + 1));
                list.set(j + 1, temp);
                keepGoing = true;
            }
        }
        return list;
    }

    public ArrayList<String> sortArrayListAlphabeticallyCaseInsensitive(ArrayList<String> list) {
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            for (int j = 0; j < list.size() - 1; ++j) {
                String nextElement;
                String thisElement = list.get(j).toLowerCase();
                if (thisElement.compareTo(nextElement = list.get(j + 1).toLowerCase()) <= 0) continue;
                String temp = list.get(j);
                list.set(j, list.get(j + 1));
                list.set(j + 1, temp);
                keepGoing = true;
            }
        }
        return list;
    }

    protected ArrayList<Object> reverseList(ArrayList<Object> list) {
        for (int i = 0; i < list.size() / 2; ++i) {
            Object temp = list.get(i);
            list.set(i, list.get(list.size() - i - 1));
            list.set(list.size() - i - 1, temp);
        }
        return list;
    }

    protected ArrayList<String> reverseStringList(ArrayList<String> list) {
        for (int i = 0; i < list.size() / 2; ++i) {
            String temp = list.get(i);
            list.set(i, list.get(list.size() - i - 1));
            list.set(list.size() - i - 1, temp);
        }
        return list;
    }

    protected String justify(String s, int width) {
        if (s.length() > width) {
            return s;
        }
        int nSpacesNeeded = width - s.length();
        return this.repeatString(" ", nSpacesNeeded) + s;
    }

    protected String repeatString(String s, int nTimes) {
        String retStr = "";
        for (int i = 0; i < nTimes; ++i) {
            retStr = retStr + s;
        }
        return retStr;
    }

    public int countNumberOfCertainCharacters(String s, char c) {
        int numberOfOccurrences = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++numberOfOccurrences;
        }
        return numberOfOccurrences;
    }

    public String nl2commas(String s) {
        String lastS = s;
        do {
            lastS = s;
        } while ((s = s.replace('\n', ',')).compareToIgnoreCase(lastS) != 0);
        return s;
    }

    public String commas2nl(String s) {
        s = s.replace(',', '\n');
        return s;
    }

    public String arrayList2List(ArrayList<String> list, String separator) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString().trim();
    }

    public String getMonthOfYear(int month) {
        switch (month) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "May";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "???";
    }

    public String getMilitaryMonthOfYear(int month) {
        switch (month) {
            case 1: {
                return "JAN";
            }
            case 2: {
                return "FEB";
            }
            case 3: {
                return "MAR";
            }
            case 4: {
                return "APR";
            }
            case 5: {
                return "MAY";
            }
            case 6: {
                return "JUN";
            }
            case 7: {
                return "JUL";
            }
            case 8: {
                return "AUG";
            }
            case 9: {
                return "SEP";
            }
            case 10: {
                return "OCT";
            }
            case 11: {
                return "NOV";
            }
            case 12: {
                return "DEC";
            }
        }
        return "???";
    }

    public String getNiceTimeDateStamp() {
        String dayOfMonth = new SimpleDateFormat("dd").format(Calendar.getInstance().getTime());
        String month = new SimpleDateFormat("M").format(Calendar.getInstance().getTime());
        String year = new SimpleDateFormat("yyyy").format(Calendar.getInstance().getTime());
        int m = this.stringToInt(month);
        month = this.getMilitaryMonthOfYear(m);
        String dateStamp = new SimpleDateFormat("dd M yyyy").format(Calendar.getInstance().getTime());
        String timeStamp = new SimpleDateFormat("HH:mm:ss").format(Calendar.getInstance().getTime());
        return dayOfMonth + " " + month + " " + year + " at " + timeStamp;
    }

    public String getTimeDateStamp() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
        return timeStamp;
    }

    public String getSQLtimeDateStamp() {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd").format(Calendar.getInstance().getTime());
        return timeStamp;
    }

    public String isTrue(Boolean b) {
        if (b.booleanValue()) {
            return "1";
        }
        return "0";
    }

    public String stripHTMLtags(String s) {
        boolean keepGoing = true;
        while (keepGoing) {
            int openAngleBracket = s.indexOf(60);
            int closeAngleBracket = s.indexOf(62, openAngleBracket);
            if (openAngleBracket != -1 && closeAngleBracket != -1) {
                String HTMLtag = s.substring(openAngleBracket, closeAngleBracket + 1);
                s = s.substring(0, openAngleBracket) + s.substring(closeAngleBracket + 1, s.length());
                keepGoing = true;
                continue;
            }
            keepGoing = false;
        }
        return s;
    }

    public String stripWhiteSpace(String s) {
        String thisLine = s;
        thisLine = thisLine.replace('\r', ' ');
        thisLine = thisLine.replace('\t', ' ');
        String lastLine = thisLine = thisLine.replace('\n', ' ');
        while ((lastLine = (thisLine = lastLine).replace("  ", " ")).compareTo(thisLine) != 0) {
        }
        return thisLine;
    }

    public int howManyCharsUsedByHTMLcodes(String s) {
        int originalLength = s.length();
        int nCodes = 0;
        int ampersandPos = s.indexOf(38);
        while (ampersandPos != -1) {
            ++nCodes;
            int nextSemicolonPos = s.indexOf(59, ampersandPos);
            String codeToReplace = s.substring(ampersandPos, nextSemicolonPos + 1);
            String replacementString = this.convertHTMLsymbol(codeToReplace);
            s = s.replace(codeToReplace, replacementString);
            ampersandPos = s.indexOf(38);
        }
        return originalLength - s.length() - nCodes;
    }

    public String convertHTMLsymbolInLine(String s) {
        int ampersandPos = s.indexOf(38);
        while (ampersandPos != -1) {
            int nextSemicolonPos = s.indexOf(59, ampersandPos);
            String codeToReplace = s.substring(ampersandPos, nextSemicolonPos + 1);
            String replacementString = this.convertHTMLsymbol(codeToReplace);
            s = s.replace(codeToReplace, replacementString);
            ampersandPos = s.indexOf(38);
        }
        return s;
    }

    public String convertHTMLsymbol(String s) {
        if (s.compareToIgnoreCase("&quot;") == 0) {
            return "\"";
        }
        if (s.compareToIgnoreCase("&amp;") == 0) {
            return "&";
        }
        if (s.compareToIgnoreCase("&lt;") == 0) {
            return "<";
        }
        if (s.compareToIgnoreCase("&gt;") == 0) {
            return ">";
        }
        if (s.compareToIgnoreCase("&nbsp;") == 0) {
            return " ";
        }
        if (s.compareToIgnoreCase("&#160;") == 0) {
            return " ";
        }
        return "??";
    }

    public String booleanTo1or0(boolean b) {
        if (b) {
            return "1";
        }
        return "0";
    }

    public String getInputStream() {
        return this.inputStream;
    }

    public String getErrorStream() {
        return this.errorStream;
    }

    public String getStdout() {
        return this.stdoutCapture;
    }

    public String getStderr() {
        return this.stderrCapture;
    }

    public void execString(String cmd) {
        this.inputStream = "";
        this.errorStream = "";
        try {
            String line;
            Runtime runtime = Runtime.getRuntime();
            System.out.println("Running: " + cmd);
            Process process = runtime.exec(cmd);
            BufferedReader bri = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader bre = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = bri.readLine()) != null) {
                this.stdoutCapture = line;
                this.inputStream = this.inputStream + line + "\n";
                System.out.println(line);
            }
            bri.close();
            while ((line = bre.readLine()) != null) {
                this.stderrCapture = line;
                this.errorStream = this.errorStream + line + "\n";
                System.out.println(line);
            }
            bre.close();
            process.waitFor();
            System.out.println("done");
            process.destroy();
        }
        catch (Exception e) {
            System.err.println("Execption thrown when exec-ing " + cmd);
            System.err.println(e.toString());
        }
    }

    protected String centerStringInField(String title, int width, String edges) {
        int firstHalf = width / 2 - edges.length() - 1 - title.length() / 2;
        int secondHalf = width / 2 - edges.length() - 1 - (title.length() - title.length() / 2);
        String sFirstHalf = edges + " " + this.repeatString(" ", firstHalf);
        String sSecondHalf = this.repeatString(" ", secondHalf) + " " + edges;
        return sFirstHalf + title + sSecondHalf;
    }

    protected StringBuilder surroundWithAsterisks(StringBuilder buffer) {
        String blankSpaces;
        int index;
        int startIndex = 0;
        int lengthOfLongestLine = 0;
        for (index = 0; index < buffer.length(); ++index) {
            if (buffer.charAt(index) != '\n') continue;
            int thisLineLength = index - startIndex;
            if (thisLineLength > lengthOfLongestLine) {
                lengthOfLongestLine = thisLineLength;
            }
            startIndex = index;
        }
        String asteriskRow = this.repeatString("*", lengthOfLongestLine + 4);
        index = 0;
        int positionInLine = 0;
        while (index < buffer.length()) {
            if (buffer.charAt(index) == '\n') {
                buffer.insert(index + 1, " * ");
                blankSpaces = this.repeatString(" ", lengthOfLongestLine - positionInLine);
                buffer.insert(index, blankSpaces + " *");
                index += lengthOfLongestLine - positionInLine + 2 + 3 + 1;
                positionInLine = 0;
            }
            ++index;
            ++positionInLine;
        }
        buffer.insert(0, " * ");
        blankSpaces = this.repeatString(" ", lengthOfLongestLine - positionInLine + 1);
        buffer.insert(buffer.length(), blankSpaces + " * ");
        buffer.insert(0, " " + asteriskRow + "\n");
        buffer.insert(buffer.length() - 1, "\n " + asteriskRow + "\n");
        return buffer;
    }
}

