
#include "window_fn_top.h" // Provides typedefs and params

// Include the entire xhls_window_fn namespace so that scope resolution --
// i.e. prepending xhls_window_fn:: to everything -- is not necessary
using namespace xhls_window_fn;

//Vivado HLS requires a top-level function definition that wraps all object
// instantiations and method calls to be synthesized as well as mapping
// the top-level I/O (function arguments) into/out of the methods/functions.
void window_fn_top(
      win_fn_out_t outdata[WIN_LEN],
      win_fn_in_t indata[WIN_LEN])
{
   // Instantiate a window_fn object - types and params defined in header file
   window_fn<win_fn_in_t,win_fn_out_t,win_fn_coef_t,
      WIN_LEN,WIN_TYPE> my_win_fn;

   // Call the apply() method - an input data set is windowed for each "call"
   // to window_fn_top()
   my_win_fn.apply(outdata, indata);
}


//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
