/*******************************************************************************
Vendor: Advanced Micro Devices, Inc. 
Associated Filename: window_fn_top.h
Purpose:Vivado HLSwindow_fn_fxpt example project
Revision History: March 13, 2012 - initial release
                                                
*******************************************************************************
 * <copyright-disclaimer-start>>
 *   **************************************************************************************************************
 *   * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
 *   * DISCLAIMER                                                                                                 *
 *   * The information contained herein is for informational purposes only, and is subject to change              *
 *   * without notice. While every precaution has been taken in the preparation of this document, it              *
 *   * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
 *   * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
 *   * no representations or warranties with respect to the accuracy or completeness of the contents of           *
 *   * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
 *   * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
 *   * hardware, software or other products described herein.  No license, including implied or                   *
 *   * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
 *   * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
 *   * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
 *   *                                                                                                            *
 *   **************************************************************************************************************
 *
 * <copyright-disclaimer-end>>

*******************************************************************************/
#ifndef WINDOW_FN_TOP_H_
#define WINDOW_FN_TOP_H_

#include "window_fn_class.h"

// Test parameters
#define WIN_TYPE xhls_window_fn::HANN
#define WIN_LEN 32

// Types and top-level function prototype
#include <ap_fixed.h>
// Define widths of fixed point fields
#define W_IN    8
#define IW_IN   8
#define W_OUT   24
#define IW_OUT  8
#define W_COEF  18
#define IW_COEF 2

// Define fixed  point types for input, output and coefficients
typedef ap_fixed<W_IN,IW_IN> win_fn_in_t;
typedef ap_fixed<W_OUT,IW_OUT> win_fn_out_t;
typedef ap_fixed<W_COEF,IW_COEF> win_fn_coef_t;

// Top level function prototype - wraps all object, method and functions for HLS
void window_fn_top(win_fn_out_t outdata[WIN_LEN], win_fn_in_t indata[WIN_LEN]);

#endif // WINDOW_FN_TOP_H_
