#include <iostream>
#include <iomanip>
#include <fstream>
using namespace std;

#include "fir.h"

int main () {
  const int    SAMPLES=600;
  FILE         *fp;

  data_t signal, output;
  coef_t taps[N] = {0,-10,-9,23,56,63,56,23,-9,-10,0,};

  int i, ramp_up;
  signal = 0;
  ramp_up = 1;
  
  fp=fopen("out.dat","w");
  for (i=0;i<=SAMPLES;i++) {
  	if (ramp_up == 1) 
  		signal = signal + 1;
  	else 
  		signal = signal - 1;

		// Execute the function with latest input
    fir(&output,signal);
    
    if ((ramp_up == 1) && (signal >= 75))
    	ramp_up = 0;
    else if ((ramp_up == 0) && (signal <= -75))
    	ramp_up = 1;
    	
		// Save the results.
    fprintf(fp,"%i %d %d\n",i,signal,output);
  }
  fclose(fp);
  
  printf ("Comparing against output data \n");
  if (system("diff -w out.dat out.gold.dat")) {
	fprintf(stdout, "*******************************************\n");
	fprintf(stdout, "FAIL: Output DOES NOT match the golden output\n");
	fprintf(stdout, "*******************************************\n");
     return 1;
  } else {
	fprintf(stdout, "*******************************************\n");
	fprintf(stdout, "PASS: The output matches the golden output!\n");
	fprintf(stdout, "*******************************************\n");
     return 0;
  }
}

//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
