/*
 * fir_test_application.c
 *
 * Updated on: 13-Aug-2021
 * 
 */

#include <stdio.h>
#include "xparameters.h"
#include "xfir_hw.h"
#include "xparameters.h"
#include "xfir.h"
#include "xil_printf.h"

void FIR_ISR(void *InstancePtr);
XFir fir_hw;
extern XFir fir_hw;
volatile static int NewResult = 0;

XFir_Config fir_config = {
		0,
		XPAR_FIR_0_BASEADDR
};

int FirSetup(){
    //Initialize the FIR IP block generated by Vivado HLS
	return XFir_Initialize(&fir_hw, XPAR_FIR_0_BASEADDR);
}

void FirStart(void *InstancePtr){
	XFir *pFir = (XFir *)InstancePtr;
	
	//Enable the local interrupt
	XFir_InterruptEnable(pFir,1);
	
	//Enable the global interrupt (GIE)
	XFir_InterruptGlobalEnable(pFir);
	
	//Start the FIR core
	XFir_Start(pFir);
}

void FIR_ISR(void *InstancePtr){
	print("ISR routine");
	XFir *pFir = (XFir *)InstancePtr;

	//Disable the GIE from the adder
	XFir_InterruptGlobalDisable(pFir);
	//Disable the local interrupt
	XFir_InterruptDisable(pFir,0xffffffff);

	// clear the local interrupt
	XFir_InterruptClear(pFir,1);

    //Set the flag to mark a new result was received
	NewResult = 1;
	// restart the core if it should run again

}

int main()
{

    int i;
    const int SAMPLES = 11;
    int output_array[11];
    int ref_output[11] = {0,-10,-9,23,56,63,56,23,-9,-10,0}; // Filter Coefficients; used to test against filter output for impulse input sequence
    int err_count = 0;
    int y_valid_status =0;

    print("FIR Application Test\r\n");
    print("====================\r\n");
    int status;
    //Setup the Adder core
    status = FirSetup();
    if(status != XST_SUCCESS){
    	print("FIR Setup Failed\r\n");
    }else{
    	print("FIR Setup Successful\r\n");
    }

    for (i=0;i<SAMPLES;i++)
    {
    	if (i==0)
    		XFir_Set_x(&fir_hw, 1);
    	else
    		XFir_Set_x(&fir_hw, 0);

    	//Launch the FIR
    	XFir_Start(&fir_hw);

    	while (!y_valid_status){
    		y_valid_status = XFir_Get_y_vld(&fir_hw);
    	}

    	output_array[i] = XFir_Get_y(&fir_hw);
    	y_valid_status = 0;

    	NewResult = 0;

    	//Get the result values from the FIR core
    	output_array[i] = XFir_Get_y(&fir_hw);
    	//xil_printf("HW Output Value = %d, Expected Output Value = %d \n",output_array[i],ref_output[i]);

    	if (ref_output[i] == output_array[i])
    		err_count = err_count ;
    	else
    		err_count = err_count + 1;
    }

    if (err_count == 0)
    	print ("Impulse response test passed\r\n");
    else
    	print ("Impulse response test failed\r\n");

    return 0;
}
 

//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
