/*******************************************************************************
 * Vendor: Xilinx 
 * Associated Filename: adders_test.c
 * Purpose: Vivado HLS tutorial example 
 * Device: All 
 * Revision History: March 1, 2013 - initial release
 *                                                 
 * *******************************************************************************
 * 
 * <copyright-disclaimer-start>>
 *   **************************************************************************************************************
 *   * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
 *   * DISCLAIMER                                                                                                 *
 *   * The information contained herein is for informational purposes only, and is subject to change              *
 *   * without notice. While every precaution has been taken in the preparation of this document, it              *
 *   * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
 *   * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
 *   * no representations or warranties with respect to the accuracy or completeness of the contents of           *
 *   * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
 *   * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
 *   * hardware, software or other products described herein.  No license, including implied or                   *
 *   * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
 *   * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
 *   * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
 *   *                                                                                                            *
 *   **************************************************************************************************************
 *
 * <copyright-disclaimer-end>>
 * 
 ******************************************************************************
 */
#include <stdio.h>

#include "adders.h"
 
int main()
{
	int inA, inB, inC;
	int sum;
	// For adders
	int refOut[5] = {60, 90, 120, 150, 180};
	int pass;
	int i;

	inA = 10;
	inB = 20;
	inC = 30;
	
	// Call the adder for 5 transactions
	for (i=0; i<5; i++)
	{
		sum = adders(inA, inB, inC);
		
		fprintf(stdout, "  %d+%d+%d=%d \n", inA, inB, inC, sum);
  
	  // Test the output against expected results
		if (sum == refOut[i])
			pass = 1;
		else 
			pass = 0;
			
		inA=inA+10;
		inB=inB+10;
		inC=inC+10;
	}

	if (pass)
	{
		fprintf(stdout, "----------Pass!------------\n");
		return 0;
	}
	else
	{
		fprintf(stderr, "----------Fail!------------\n");
		return 1;
	}
}
