/*******************************************************************************
 * Vendor: Xilinx 
 * Associated Filename: array_io_test.c
 * Purpose: Vivado HLS tutorial example 
 * Device: All 
 * Revision History: March 1, 2013 - initial release
 *                                                 
 * *******************************************************************************
 * 
 * <copyright-disclaimer-start>>
 *   **************************************************************************************************************
 *   * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
 *   * DISCLAIMER                                                                                                 *
 *   * The information contained herein is for informational purposes only, and is subject to change              *
 *   * without notice. While every precaution has been taken in the preparation of this document, it              *
 *   * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
 *   * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
 *   * no representations or warranties with respect to the accuracy or completeness of the contents of           *
 *   * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
 *   * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
 *   * hardware, software or other products described herein.  No license, including implied or                   *
 *   * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
 *   * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
 *   * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
 *   *                                                                                                            *
 *   **************************************************************************************************************
 *
 * <copyright-disclaimer-end>>
 * 
 * ******************************************************************************
 */
#include "array_io.h"
 
int main () {

	// Create input data
  din_t d_i[N] = {10, 20, 30, 40, 50, 60, 70, 80,
									11, 21, 31, 41, 51, 61, 71, 81,
									12, 22, 32, 42, 52, 62, 72, 82,
									13, 23, 33, 43, 53, 63, 73, 83};

  dout_t d_o[N];
	int i, retval=0;
	FILE        *fp;


	// Call the function to operate on the data
  array_io(d_o,d_i);

	// Save the results to a file
	fp=fopen("result.dat","w");
	fprintf(fp, "Din Dout\n");

	for (i=0;i<N;i++) {
    fprintf(fp, "%d   %d\n", d_i[i], d_o[i]);
	}
	fclose(fp);

	// Compare the results file with the golden results
	retval = system("diff --brief -w result.dat result.golden.dat");
	if (retval != 0) {
		printf("Test failed  !!!\n"); 
		retval=1;
	} else {
		printf("Test passed !\n");
  }

	// Return 0 if the test passes
  return retval;
}
