#include <stdio.h>
#include "image_aux.h"


void image_read (
      image_t *in_image
      ) {
   image_dim_t width, height;
   int x, y;
   FILE        *fp;

   fp=fopen("test_data/input.dat","r");
   int tmp;
   fscanf(fp, "%d", &tmp);
   width = tmp;
   fscanf(fp, "%d", &tmp);
   height = tmp;

   in_image->width  = width;
   in_image->height = height;
   for (x=0;x<width;x++) {
      for (y=0;y<height;y++) {
         fscanf(fp, "%d", &tmp);
         in_image->channels.ch1[x][y] = tmp;
         fscanf(fp, "%d", &tmp);
         in_image->channels.ch2[x][y] = tmp;
         fscanf(fp, "%d", &tmp);
         in_image->channels.ch3[x][y] = tmp;
      }
   }
   fclose(fp);

}


void image_write (
      image_t *out_image
      ) {
   FILE *fp;
   int x, y;
   image_dim_t width, height;
   image_pix_t tmp;

   fp=fopen("test_data/output.dat","w");

   width = out_image->width;
   fprintf(fp, "%d \n", width);

   height = out_image->height;
   fprintf(fp, "%d \n", height);

   for (y=0;y<height;y++) {
      /* Scan-line: */
      for (x=0;x<width;x++) {
         tmp = out_image->channels.ch1[x][y];
         fprintf(fp, "%d\n", tmp);
         tmp = out_image->channels.ch2[x][y];
         fprintf(fp, "%d\n", tmp);
         tmp = out_image->channels.ch3[x][y];
         fprintf(fp, "%d\n", tmp);
      }
   }
   fclose(fp);
}

//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
