#include <stdio.h>
#include <stdlib.h>
#include "yuv_filter.h"

int main () {
   // Dynamically allocate image buffers as they are rather large
   // and stack overflow may occur if statically allocated
   image_t *img_rgb = (image_t *)malloc(sizeof(image_t));
   image_t *img_restore = (image_t *)malloc(sizeof(image_t));

   // Read input image
   image_read(img_rgb);

   // Create output image
   // Scale should be <=128 (128 corresponds to a scale of 1.0)
   yuv_filter(img_rgb, img_restore, 128, 128, 128);

   // Save output image
   image_write(img_restore);

   // Compare results
   int ret = system("diff --brief -w test_data/output.dat test_data/output.golden.dat");

   if (ret != 0) {
      printf("Test failed!!!\n", ret);
      return 1;
   } else {
      printf("Test passed!\n", ret);
      return 0;
   }
}


//<copyright-disclaimer-start>
//  **************************************************************************************************************
//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
