#//<copyright-disclaimer-start>
#//  **************************************************************************************************************
#//  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
#//  * DISCLAIMER                                                                                                 *
#//  * The information contained herein is for informational purposes only, and is subject to change              *
#//  * without notice. While every precaution has been taken in the preparation of this document, it              *
#//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
#//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
#//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
#//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
#//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
#//  * hardware, software or other products described herein.  No license, including implied or                   *
#//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
#//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
#//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
#//  *                                                                                                            *
#//  **************************************************************************************************************
#//<copyright-disclaimer-end>

import vitis
import os

#cwd = os.getcwd()+'/'

# grab the one environment variable that points to the lab area
training_path = os.environ['TRAINING_PATH']
print(f"Using {training_path} as the location of the lab files")

################### *** MODIFY HERE ***################## 
# define the variables to make the generic form of this script specific
tc_name: str = "port_level_mem_interface"
lab_or_demo: str = "lab"
cfg_file_loc: str = f"{training_path}/{tc_name}/support/hls_config.cfg"
app_template: str = "empty_hls_component"
comp_name: str = "array_io"

# derived names/paths
workspace_path = f"{training_path}/{tc_name}/{lab_or_demo}"  # point to where the lab is to run
print(f"setting the workspace to: {workspace_path}")  # tell the user (debug)

################## *** DO NOT MODIFY BELOW THIS LINE!!! ***################## 

# Initialize session
client = vitis.create_client()
client.set_workspace(path=workspace_path)

# Delete the component if it already exists
if os.path.exists(f"{workspace_path}/{comp_name}"):
	client.delete_component(name=comp_name)

# Create component. Create new config file in the component folder of the workspace
comp = client.create_hls_component(name=comp_name, cfg_file = cfg_file_loc, template = app_template)

# Run flow steps
comp = client.get_component(name=comp_name)
comp.run(operation='C_SIMULATION')
#comp.run(operation='SYNTHESIS')
#comp.run(operation='CO_SIMULATION')
