/*
# Copyright (C) 2025, Advanced Micro Devices, Inc. All rights reserved.
# SPDX-License-Identifier: X11
*/

#include <cstring>
#include <iostream>

#include "hw.h"

int main(int argc, char**argv) {
    int A[N][N], B[N][N], C[N][N], D[N][N], E[N][N], F[N][N];
    int A_ref[N][N], C_ref[N][N], D_ref[N][N];

    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < N; ++j) {
            A[i][j] = i;
            B[i][j] = 1;
            C[i][j] = 0;
            D[i][j] = 0;
            E[i][j] = i+j;
            D_ref[i][j] = 2 * E[i][j];
            C_ref[i][j] = B[i][j] * E[i][j];
            A_ref[i][j] = A[i][j] + (j==0?5*15:0);
        }
    }

    top(A, B, C, D, E, F);
    int errors=0;
    if ( std::memcmp(A,A_ref,N*N*sizeof(A[0][0])) != 0 ) {errors++;}
    if ( std::memcmp(C,C_ref,N*N*sizeof(C[0][0])) != 0 ) {errors++;}
    if ( std::memcmp(D,D_ref,N*N*sizeof(D[0][0])) != 0 ) {errors++;}
    std::cout << "from " __FILE__ ": got "<<errors<<" error(s)."<<std::endl;

    return errors>0;
}
/*
//<copyright-disclaimer-start>
//  * © 2025 Advanced Micro Devices, Inc. All rights reserve
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
///////////////////////////////////////////////////////////////////////////
                                                *
//  * DISCLAIMER                                                                                                 *
//  * The information contained herein is for informational purposes only, and is subject to change              *
//  * without notice. While every precaution has been taken in the preparation of this document, it              *
//  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//  * hardware, software or other products described herein.  No license, including implied or                   *
//  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//  *                                                                                                            *
//  **************************************************************************************************************
//<copyright-disclaimer-end>
*/