

#include "FirSingleStream.h"


template <int SAMPLES,int SHIFT>
void SingleStream::FIR_SingleStream<SAMPLES,SHIFT>::filter(input_stream_cint16* sig_in,output_stream_cint16* sig_out)
{

    const int LSIZE=(SAMPLES/32);
    aie::accum<cacc48,8> acc;
    const aie::vector<cint16,8> coe[4] = {aie::load_v<8>(eq_coef),aie::load_v<8>(eq_coef+8),aie::load_v<8>(eq_coef+16),aie::load_v<8>(eq_coef+24)};
    aie::vector<cint16,32> buff=delay_line;
    for(int i=0;i<LSIZE;i++){
        //performace 1st 8 samples
        acc = aie::sliding_mul<8,8>(coe[0],0,buff,0);
        acc = aie::sliding_mac<8,8>(acc,coe[1],0,buff,8);
        buff.insert(0,readincr_v<4>(sig_in));
        buff.insert(1,readincr_v<4>(sig_in));
        acc = aie::sliding_mac<8,8>(acc,coe[2],0,buff,16);
        acc = aie::sliding_mac<8,8>(acc,coe[3],0,buff,24);
        writeincr(sig_out,acc.to_vector<cint16>(SHIFT));

        //performace 2nd 8 samples
        acc = aie::sliding_mul<8,8>(coe[0],0,buff,8);
        acc = aie::sliding_mac<8,8>(acc,coe[1],0,buff,16);
        buff.insert(2,readincr_v<4>(sig_in));
        buff.insert(3,readincr_v<4>(sig_in));
        acc = aie::sliding_mac<8,8>(acc,coe[2],0,buff,24);
        acc = aie::sliding_mac<8,8>(acc,coe[3],0,buff,0);
        writeincr(sig_out,acc.to_vector<cint16>(SHIFT));

        //performace 3rd 8 samples
        acc = aie::sliding_mul<8,8>(coe[0],0,buff,16);
        acc = aie::sliding_mac<8,8>(acc,coe[1],0,buff,24);
        buff.insert(4,readincr_v<4>(sig_in));
        buff.insert(5,readincr_v<4>(sig_in));
        acc = aie::sliding_mac<8,8>(acc,coe[2],0,buff,0);
        acc = aie::sliding_mac<8,8>(acc,coe[3],0,buff,8);
        writeincr(sig_out,acc.to_vector<cint16>(SHIFT));

        //performace 4th 8 samples
        acc = aie::sliding_mul<8,8>(coe[0],0,buff,24);
        acc = aie::sliding_mac<8,8>(acc,coe[1],0,buff,0);
        buff.insert(6,readincr_v<4>(sig_in));
        buff.insert(7,readincr_v<4>(sig_in));
        acc = aie::sliding_mac<8,8>(acc,coe[2],0,buff,8);
        acc = aie::sliding_mac<8,8>(acc,coe[3],0,buff,16);
        writeincr(sig_out,acc.to_vector<cint16>(SHIFT));
    }
    delay_line=buff;
}

template <int SAMPLES,int SHIFT>
void SingleStream::FIR_SingleStream<SAMPLES,SHIFT>::filter_init(const cint16 (&taps)[32]) {

    for(int i=0;i<32;i++)
    {
        eq_coef[i] = taps[i];
    }

    delay_line = aie::zeros<cint16, 32>();
}


   //<copyright-disclaimer-start>
//#  **************************************************************************************************************
//#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//#  * DISCLAIMER                                                                                                 *
//#  * The information contained herein is for informational purposes only, and is subject to change              *
//#  * without notice. While every precaution has been taken in the preparation of this document, it              *
//#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//#  * hardware, software or other products described herein.  No license, including implied or                   *
//#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//#  *                                                                                                            *
//#  **************************************************************************************************************
//#<copyright-disclaimer-end> 
