%
% * © 2025 Advanced Micro Devices, Inc. All rights reserved. 
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%     http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%

function Hd = ChannelFilter
%CHANNELFILTER Returns a discrete-time filter object.

% MATLAB Code
% Generated by MATLAB(R) 9.7 and Signal Processing Toolbox 8.3.
% Generated on: 23-Nov-2020 15:27:15

% FIR Window Raised-cosine filter designed using the FIRRCOS function.

% All frequency values are normalized to 1.

N    = 120;        % Order
Fc   = 0.8;        % Cutoff Frequency
TM   = 'Rolloff';  % Transition Mode
R    = 0.25;       % Rolloff
DT   = 'sqrt';     % Design Type
Beta = 1;          % Window Parameter

% Create the window vector for the design algorithm.
win = kaiser(N+1, Beta);

% Calculate the coefficients using the FIR1 function.
b  = firrcos(N, Fc, R, 2, TM, DT, [], win);
Hd = dfilt.dffir(b);

% [EOF]

%<copyright-disclaimer-start>
%  **************************************************************************************************************
%  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
%  * DISCLAIMER                                                                                                 *
%  * The information contained herein is for informational purposes only, and is subject to change              *
%  * without notice. While every precaution has been taken in the preparation of this document, it              *
%  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
%  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
%  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
%  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
%  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
%  * hardware, software or other products described herein.  No license, including implied or                   *
%  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
%  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
%  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
%  *                                                                                                            *
% **************************************************************************************************************
%<copyright-disclaimer-end>
