% * © 2025 Advanced Micro Devices, Inc. All rights reserved. 
%
% Licensed under the Apache License, Version 2.0 (the "License");
% you may not use this file except in compliance with the License.
% You may obtain a copy of the License at
%
%     http://www.apache.org/licenses/LICENSE-2.0
%
% Unless required by applicable law or agreed to in writing, software
% distributed under the License is distributed on an "AS IS" BASIS,
% WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
% See the License for the specific language governing permissions and
% limitations under the License.
%

%% Half-Band Filter 1

Shift1 = 15;
K1 = 2^Shift1;
hb = HB1;
hb1 = NormalizeHBCoef(hb.Numerator,K1/2); % Decimation so K1/2
hb1((length(hb1)+1)/2) = K1/2;
hb1_aie = hb1([ 1:2:(length(hb1)-1)/2 (length(hb1)+1)/2]);

disp('HB1');
disp(['  Center Tap: ' num2str(hb1((length(hb1)+1)/2)) ]);
disp(['Phase 1 Norm: ' num2str(sum(hb1(1:2:end)))]);
disp([' Max Phase 1: ' num2str(max(hb1(1:2:end)))]);
disp(' ');


%% Half-Band Filter 2

Shift2 = 15;
K2 =2^Shift2;
hb = HB2;
hb2 = NormalizeHBCoef(hb.Numerator,K2/2);
hb2((length(hb2)+1)/2) = K2/2;
hb2_aie = hb2([ 1:2:(length(hb2)-1)/2 (length(hb2)+1)/2]);

disp('HB2');
disp(['  Center Tap: ' num2str(hb2((length(hb2)+1)/2)) ]);
disp(['Phase 1 Norm: ' num2str(sum(hb2(1:2:end)))]);
disp([' Max Phase 1: ' num2str(max(hb2(1:2:end)))]);
disp(' ');



%% Half-Band Filter 3

Shift3 = 15;
K3 =2^Shift3;
hb = HB3;
hb3 = NormalizeHBCoef(hb.Numerator,K3/2);
hb3((length(hb3)+1)/2) = K3/2;
hb3_aie = hb3([ 1:2:(length(hb3)-1)/2 (length(hb3)+1)/2]);

disp('HB3');
disp(['  Center Tap: ' num2str(hb3((length(hb3)+1)/2)) ]);
disp(['Phase 1 Norm: ' num2str(sum(hb3(1:2:end)))]);
disp([' Max Phase 1: ' num2str(max(hb3(1:2:end)))]);
disp(' ');

%% Channel Filter

ShiftCF = 15;
Kcf =2^ShiftCF;
cf = ChannelFilter;
cfi = NormalizeCoef(cf.Numerator,Kcf);
cfi_aie = cfi(1:(length(cfi)+1)/2);

disp('CF');
disp(['Channel Filter Norm: ' num2str(sum(cfi))]);
disp(['           Max Coef: ' num2str(max(cfi))]);
disp(' ');






%<copyright-disclaimer-start>
%  **************************************************************************************************************
%  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
%  * DISCLAIMER                                                                                                 *
%  * The information contained herein is for informational purposes only, and is subject to change              *
%  * without notice. While every precaution has been taken in the preparation of this document, it              *
%  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
%  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
%  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
%  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
%  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
%  * hardware, software or other products described herein.  No license, including implied or                   *
%  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
%  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
%  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
%  *                                                                                                            *
% **************************************************************************************************************
%<copyright-disclaimer-end>
