// <copyright-disclaimer-start>
//#  **************************************************************************************************************
//#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//#  * DISCLAIMER                                                                                                 *
//#  * The information contained herein is for informational purposes only, and is subject to change              *
//#  * without notice. While every precaution has been taken in the preparation of this document, it              *
//#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//#  * hardware, software or other products described herein.  No license, including implied or                   *
//#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//#  *                                                                                                            *
//#  **************************************************************************************************************
//#<copyright-disclaimer-end>

#include "fir.h"

void fir_sw(hls::stream<int> &input_val, hls::stream<int> &output_val)
{
	int i;
	static short shift_reg[TAPS] = {0};
	const short coeff[TAPS] = {6,0,-4,-3,5,6,-6,-13,7,44,64,44,7,-13,
                                 -6,6,5,-3,-4,0,6};

	for(i=0; i < RUN_LENGTH; i++){
		int sample;
		sample = input_val.read();

		//Shift Register
		for(int j=0; j < TAPS-1; j++){
			shift_reg[j] = shift_reg[j+1];
		}
		shift_reg[TAPS-1] = sample;

		//Filter Operation
		int acc = 0;
		for(int k=0; k < TAPS; k++){
			acc += shift_reg[k] * coeff[k];
		}
		output_val.write(acc);
	}
}

int main()
{
	hls::stream<int> input_sw;
	hls::stream<int> input_hw;
	hls::stream<int> output_hw;
	hls::stream<int> output_sw;
	
	//Write the input values
	for(int i = 0; i < RUN_LENGTH; i++){
		input_sw.write(i);
		input_hw.write(i);
	}

	//Call to software model of fir
  	fir_sw(input_sw, output_sw);

	//Call to hardware model of fir
	fir_hw(input_hw, output_hw);

	for(int k=0; k < RUN_LENGTH; k++){
		int sw, hw;
		sw = output_sw.read();
		hw = output_hw.read();
		if(sw != hw){
			printf("ERROR: k = %d sw = %d hw = %d\n",k,sw,hw);
		      return 1;
		}
	}
	printf("Success! both SW and HW models match.\n");
	return 0;
}

