
#include <stdint.h>
#include "ap_int.h"
#include "imgproc/xf_magnitude.hpp"
#include "common/xf_structs.hpp"
#include "common/xf_common.hpp"

#pragma XMC INPORT inX,inY
#pragma XMC OUTPORT out
#pragma XMC SUPPORTS_STREAMING

template<int ROWS, int COLS, int NPC>
void GradientMag_XMC(uint16_t inX[ROWS][COLS], 
                     uint16_t inY[ROWS][COLS],
                     uint16_t Out[ROWS][COLS]
                    )
{  
     ap_uint<16> dataX_in;
     ap_uint<16> dataY_in;
     ap_uint<16> data_out;
   
     const int NORM_TYPE = XF_L1NORM;
     const int TYPE = XF_16SC1;
     const int height = ROWS;
     const int width = COLS;
     const bool USE_URAM = false;
     const int bufferSize = 100;
     const int bufferPrefetch = 50;
 
  
    xf::cv::Mat<TYPE,ROWS,COLS,XF_NPPC1> srcX_obj;
    #pragma HLS stream variable=srcX_obj dim=1 depth=1
    
    xf::cv::Mat<TYPE,ROWS,COLS,XF_NPPC1> srcY_obj;
    #pragma HLS stream variable=srcY_obj dim=1 depth=1
    
 
    xf::cv::Mat<TYPE,ROWS,COLS,XF_NPPC1> dst_obj;
    #pragma HLS stream variable=dst_obj dim=1 depth=1
    
    
    #pragma HLS dataflow
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
        #pragma HLS pipeline II=1
            dataX_in = inX[i][j];
            dataY_in = inY[i][j];
            srcX_obj.write(i * COLS + j,(dataX_in));
            srcY_obj.write(i * COLS + j,(dataY_in));
        }
    }
    
     xf::cv::magnitude<NORM_TYPE,XF_16SC1,XF_16SC1,height, width,NPC> (srcX_obj,srcY_obj,dst_obj);


      for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
        #pragma HLS pipeline II=1
            data_out = dst_obj.read(i * COLS + j);
            Out[i][j] = data_out;
        }
      }
     
  }
  


//<copyright-disclaimer-start>
//#  **************************************************************************************************************
//#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//#  * DISCLAIMER                                                                                                 *
//#  * The information contained herein is for informational purposes only, and is subject to change              *
//#  * without notice. While every precaution has been taken in the preparation of this document, it              *
//#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//#  * hardware, software or other products described herein.  No license, including implied or                   *
//#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//#  *                                                                                                            *
//#  **************************************************************************************************************
//#<copyright-disclaimer-end>
