

#ifndef ___XF__AXI_IO__
#define ___XF__AXI_IO__
#include "utils/x_hls_utils.h"
#include <assert.h>

namespace xf {
namespace cv {

template <int W, typename T>
void AXIGetBitFields(ap_uint<W> pix, int start, int w, T& val) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    assert(start >= 0 && start + w <= W);
    val = (T)pix(start + w - 1, start);
}

template <int W>
void AXIGetBitFields(ap_uint<W> pix, int start, int w, float& val) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    assert(w == 32 && start >= 0 && start + w <= W);
    fp_struct<float> temp((ap_uint<32>)pix(start + w - 1, start));
    val = temp.to_float();
}

template <int W>
void AXIGetBitFields(ap_uint<W> pix, int start, int w, double& val) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    assert(w == 64 && start >= 0 && start + w <= W);
    fp_struct<double> temp((ap_uint<64>)pix(start + w - 1, start));
    val = temp.to_double();
}

template <int W, typename T>
void AXIGetBitFields(ap_axiu<W, 1, 1, 1> axi, int start, int w, T& val) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    AXIGetBitFields(axi.data, start, w, val);
}

template <int W, typename T>
void AXISetBitFields(ap_uint<W>& pix, int start, int w, T val) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    assert(start >= 0 && start + w <= W);
    pix(start + w - 1, start) = val;
}

template <int W>
void AXISetBitFields(ap_uint<W>& pix, int start, int w, float val) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    assert(w == 32 && start >= 0 && start + w <= W);
    fp_struct<float> temp(val);
    pix(start + w - 1, start) = temp.data();
}

template <int W>
void AXISetBitFields(ap_uint<W>& pix, int start, int w, double val) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    assert(w == 64 && start >= 0 && start + w <= W);
    fp_struct<double> temp(val);
    pix(start + w - 1, start) = temp.data();
}

template <int W, typename T>
void AXISetBitFields(ap_axiu<W, 1, 1, 1>& axi, int start, int w, T val) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    AXISetBitFields(axi.data, start, w, val);
}

} // namespace cv
}; // namespace xf

#endif


//<copyright-disclaimer-start>
//#  **************************************************************************************************************
//#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//#  * DISCLAIMER                                                                                                 *
//#  * The information contained herein is for informational purposes only, and is subject to change              *
//#  * without notice. While every precaution has been taken in the preparation of this document, it              *
//#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//#  * hardware, software or other products described herein.  No license, including implied or                   *
//#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//#  *                                                                                                            *
//#  **************************************************************************************************************
//#<copyright-disclaimer-end>  
