
//
//M*/

/*
 * HLS Video Core Structures Header File
 */

#ifndef ___XF__VIDEO_CORE__
#define ___XF__VIDEO_CORE__

namespace xf {
namespace cv {

/* Video Format Types defined on 8-bit boundaries */
typedef struct {
    unsigned char Y;
    char UV;
} yuv422_8;

typedef struct {
    unsigned char Y;
    char U;
    char V;
} yuv444_8;

typedef struct {
    unsigned char R;
    unsigned char G;
    unsigned char B;
} rgb_8;

typedef yuv422_8 yuv420_8;

typedef struct {
    char A;
    unsigned char Y;
    char UV;
} yuva422_8;

typedef struct {
    char A;
    unsigned char Y;
    char U;
    char V;
} yuva444_8;

typedef struct {
    char A;
    unsigned char R;
    unsigned char G;
    unsigned char B;
} rgba_8;

typedef struct {
    char AUV;
    unsigned char Y;
} yuva420_8;

typedef struct {
    unsigned char D;
    unsigned char Y;
    char UV;
} yuvd422_8;

typedef struct {
    unsigned char D;
    unsigned char Y;
    char U;
    char V;
} yuvd444_8;

typedef struct {
    unsigned char D;
    unsigned char R;
    unsigned char G;
    unsigned char B;
} rgbd_8;

typedef yuvd422_8 yuvd420_8;

typedef struct { unsigned char CMY; } bayer_8;

typedef struct { unsigned char Y; } luma_8;
/* convertors for different pixel types*/

/* yuv422_8 and yuv420_8 */
template <typename T>
yuv422_8 Scalar_to_yuv422_8(Scalar<2, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    yuv422_8 pix;
    pix.Y = (unsigned char)scl.val[0];
    pix.UV = (char)scl.val[1];
    return pix;
}
template <typename T>
Scalar<2, T> yuv422_8_to_Scalar(yuv422_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<2, T> scl;
    scl.val[0] = (T)pix.Y;
    scl.val[1] = (T)pix.UV;
    return scl;
}

/* yuv444_8 */
template <typename T>
yuv444_8 Scalar_to_yuv444_8(Scalar<3, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    yuv444_8 pix;
    pix.Y = (unsigned char)scl.val[0];
    pix.U = (char)scl.val[1];
    pix.V = (char)scl.val[2];
    return pix;
}
template <typename T>
Scalar<3, T> yuv444_8_to_Scalar(yuv444_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<3, T> scl;
    scl.val[0] = (T)pix.Y;
    scl.val[1] = (T)pix.U;
    scl.val[2] = (T)pix.V;
    return scl;
}

/* rgb_8 */
template <typename T>
rgb_8 Scalar_to_rgb_8(Scalar<3, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    rgb_8 pix;
    pix.R = (unsigned char)scl.val[0];
    pix.G = (unsigned char)scl.val[1];
    pix.B = (unsigned char)scl.val[2];
    return pix;
}
template <typename T>
Scalar<3, T> rgb_8_to_Scalar(rgb_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<3, T> scl;
    scl.val[0] = (T)pix.R;
    scl.val[1] = (T)pix.G;
    scl.val[2] = (T)pix.B;
    return scl;
}

/* yuva422_8 */
template <typename T>
yuva422_8 Scalar_to_yuva422_8(Scalar<3, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    yuva422_8 pix;
    pix.A = (char)scl.val[0];
    pix.Y = (unsigned char)scl.val[1];
    pix.UV = (char)scl.val[2];
    return pix;
}
template <typename T>
Scalar<3, T> yuva422_8_to_Scalar(yuva422_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<3, T> scl;
    scl.val[0] = (T)pix.A;
    scl.val[1] = (T)pix.Y;
    scl.val[2] = (T)pix.UV;
    return scl;
}

/* yuva444_8 */
template <typename T>
yuva444_8 Scalar_to_yuva444_8(Scalar<4, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    yuva444_8 pix;
    pix.A = (char)scl.val[0];
    pix.Y = (unsigned char)scl.val[1];
    pix.U = (char)scl.val[2];
    pix.V = (char)scl.val[3];
    return pix;
}
template <typename T>
Scalar<4, T> yuva444_8_to_Scalar(yuva444_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<4, T> scl;
    scl.val[0] = (T)pix.A;
    scl.val[1] = (T)pix.Y;
    scl.val[2] = (T)pix.U;
    scl.val[3] = (T)pix.V;
    return scl;
}

/* rgba_8 */
template <typename T>
rgba_8 Scalar_to_rgba_8(Scalar<4, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    rgba_8 pix;
    pix.A = (char)scl.val[0];
    pix.R = (unsigned char)scl.val[1];
    pix.G = (unsigned char)scl.val[2];
    pix.B = (unsigned char)scl.val[3];
    return pix;
}
template <typename T>
Scalar<4, T> rgba_8_to_Scalar(rgba_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<4, T> scl;
    scl.val[0] = (T)pix.A;
    scl.val[1] = (T)pix.R;
    scl.val[2] = (T)pix.G;
    scl.val[3] = (T)pix.B;
    return scl;
}

/* yuva420_8 */
template <typename T>
yuva420_8 Scalar_to_yuva420_8(Scalar<2, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    yuva420_8 pix;
    pix.AUV = (char)scl.val[0];
    pix.Y = (unsigned char)scl.val[1];
    return pix;
}
template <typename T>
Scalar<2, T> yuva420_8_to_Scalar(yuva420_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<2, T> scl;
    scl.val[0] = (T)pix.AUV;
    scl.val[1] = (T)pix.Y;
    return scl;
}

/* yuvd422_8 and yuvd420_8*/
template <typename T>
yuvd422_8 Scalar_to_yuvd422_8(Scalar<3, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    yuvd422_8 pix;
    pix.D = (unsigned char)scl.val[0];
    pix.Y = (unsigned char)scl.val[1];
    pix.UV = (char)scl.val[2];
    return pix;
}
template <typename T>
Scalar<3, T> yuvd422_8_to_Scalar(yuvd422_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<3, T> scl;
    scl.val[0] = (T)pix.D;
    scl.val[1] = (T)pix.Y;
    scl.val[2] = (T)pix.UV;
    return scl;
}

/* yuvd444_8 */
template <typename T>
yuvd444_8 Scalar_to_yuvd444_8(Scalar<4, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    yuvd444_8 pix;
    pix.D = (unsigned char)scl.val[0];
    pix.Y = (unsigned char)scl.val[1];
    pix.U = (char)scl.val[2];
    pix.V = (char)scl.val[3];
    return pix;
}
template <typename T>
Scalar<4, T> yuvd444_8_to_Scalar(yuvd444_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<4, T> scl;
    scl.val[0] = (T)pix.D;
    scl.val[1] = (T)pix.Y;
    scl.val[2] = (T)pix.U;
    scl.val[3] = (T)pix.V;
    return scl;
}

/* rgbd_8 */
template <typename T>
rgbd_8 Scalar_to_rgbd_8(Scalar<4, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    rgbd_8 pix;
    pix.D = (unsigned char)scl.val[0];
    pix.R = (unsigned char)scl.val[1];
    pix.G = (unsigned char)scl.val[2];
    pix.B = (unsigned char)scl.val[3];
    return pix;
}
template <typename T>
Scalar<4, T> rgbd_8_to_Scalar(rgbd_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<4, T> scl;
    scl.val[0] = (T)pix.D;
    scl.val[1] = (T)pix.R;
    scl.val[2] = (T)pix.G;
    scl.val[3] = (T)pix.B;
    return scl;
}

/* bayer_8 */
template <typename T>
bayer_8 Scalar_to_bayer_8(Scalar<1, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    bayer_8 pix;
    pix.CMY = (unsigned char)scl.val[0];
    return pix;
}
template <typename T>
Scalar<1, T> bayer_8_to_Scalar(bayer_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<1, T> scl;
    scl.val[0] = (T)pix.CMY;
    return scl;
}

/* luma_8 */
template <typename T>
luma_8 Scalar_to_luma_8(Scalar<1, T> scl) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    luma_8 pix;
    pix.Y = (unsigned char)scl.val[0];
    return pix;
}
template <typename T>
Scalar<1, T> luma_8_to_Scalar(luma_8 pix) {
// clang-format off
    #pragma HLS inline
    // clang-format on
    Scalar<1, T> scl;
    scl.val[0] = (T)pix.Y;
    return scl;
}

} // namespace cv
} // namespace xf

#endif

 //<copyright-disclaimer-start>
//#  **************************************************************************************************************
//#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//#  * DISCLAIMER                                                                                                 *
//#  * The information contained herein is for informational purposes only, and is subject to change              *
//#  * without notice. While every precaution has been taken in the preparation of this document, it              *
//#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//#  * hardware, software or other products described herein.  No license, including implied or                   *
//#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//#  *                                                                                                            *
//#  **************************************************************************************************************
//#<copyright-disclaimer-end> 
