

#include <stdint.h>
#include "ap_int.h"
#include "imgproc/xf_sobel.hpp"
#include "common/xf_structs.hpp"
#include "common/xf_common.hpp"

#pragma XMC INPORT in
#pragma XMC OUTPORT video_out
#pragma XMC SUPPORTS_STREAMING

template<int ROWS, int COLS, int NPC>
void SobelFilter_XMC(uint8_t in[ROWS][COLS],  
                     uint16_t outX[ROWS][COLS],
                     uint16_t outY[ROWS][COLS]
                    )
{  
     ap_uint<16> data_in;
     ap_uint<16> data_outX;
     ap_uint<16> data_outY;
   
    
     const int FILTER_TYPE = XF_FILTER_3X3;
     const int BORDER_TYPE = XF_BORDER_CONSTANT;
     const int TYPE_IN = XF_8UC1;
     const int TYPE_OUT = XF_16SC1;
     const int height = ROWS;
     const int width = COLS;
     //const bool USE_URAM = false;
      
    xf::cv::Mat<TYPE_IN,ROWS,COLS,XF_NPPC1> src_obj;
    #pragma HLS stream variable=src_obj dim=1 depth=1
    
 
    xf::cv::Mat<TYPE_OUT,ROWS,COLS,XF_NPPC1> dstx_obj;
    #pragma HLS stream variable=dstx_obj dim=1 depth=1
    
    
    xf::cv::Mat<TYPE_OUT,ROWS,COLS,XF_NPPC1> dsty_obj;
    #pragma HLS stream variable=dsty_obj dim=1 depth=1
    
    
    #pragma HLS dataflow
    for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
        #pragma HLS pipeline II=1
            data_in = in[i][j];
            src_obj.write(i * COLS + j,(data_in));
        }
    }
    
     xf::cv::Sobel<BORDER_TYPE, FILTER_TYPE,XF_8UC1,XF_16SC1,height, width,NPC> (src_obj, dstx_obj, dsty_obj);

      for (int i = 0; i < ROWS; i++) {
        for (int j = 0; j < COLS; j++) {
        #pragma HLS pipeline II=1
            data_outX = dstx_obj.read(i * COLS + j);
            data_outY = dsty_obj.read(i * COLS + j);
            outX[i][j] = data_outX;
            outY[i][j] = data_outY;
        }
      }
     
  }
  

    //<copyright-disclaimer-start>
//#  **************************************************************************************************************
//#  * © 2025 Advanced Micro Devices, Inc. All rights reserved.                                                   *
//#  * DISCLAIMER                                                                                                 *
//#  * The information contained herein is for informational purposes only, and is subject to change              *
//#  * without notice. While every precaution has been taken in the preparation of this document, it              *
//#  * may contain technical inaccuracies, omissions and typographical errors, and AMD is under no                *
//#  * obligation to update or otherwise correct this information.  Advanced Micro Devices, Inc. makes            *
//#  * no representations or warranties with respect to the accuracy or completeness of the contents of           *
//#  * this document, and assumes no liability of any kind, including the implied warranties of noninfringement,  *
//#  * merchantability or fitness for particular purposes, with respect to the operation or use of AMD            *
//#  * hardware, software or other products described herein.  No license, including implied or                   *
//#  * arising by estoppel, to any intellectual property rights is granted by this document.  Terms and           *
//#  * limitations applicable to the purchase or use of AMD’s products are as set forth in a signed agreement     *
//#  * between the parties or in AMD's Standard Terms and Conditions of Sale. GD-18                               *
//#  *                                                                                                            *
//#  **************************************************************************************************************
//#<copyright-disclaimer-end>
