/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __LUT_SQRT_H__
#define __LUT_SQRT_H__

#include <adf.h>

alignas(__ALIGN_BYTE_SIZE__) const int16 addvals[32] = {
    16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384, 16384,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0};

alignas(__ALIGN_BYTE_SIZE__) const int8 sqrtLUT0[1024] = {
    53,   63, 54,   63, 54,   63, 55,   63, 56,   63, 57,   63, 57,   63, 58,   63, 53,   63, 54,   63, 54,   63,
    55,   63, 56,   63, 57,   63, 57,   63, 58,   63, 59,   63, 59,   63, 60,   63, 61,   63, 61,   63, 62,   63,
    63,   63, 63,   63, 59,   63, 59,   63, 60,   63, 61,   63, 61,   63, 62,   63, 63,   63, 63,   63, 64,   63,
    65,   63, 65,   63, 66,   63, 67,   63, 67,   63, 68,   63, 69,   63, 64,   63, 65,   63, 65,   63, 66,   63,
    67,   63, 67,   63, 68,   63, 69,   63, 69,   63, 70,   63, 71,   63, 71,   63, 72,   63, 72,   63, 73,   63,
    74,   63, 69,   63, 70,   63, 71,   63, 71,   63, 72,   63, 72,   63, 73,   63, 74,   63, 74,   63, 75,   63,
    76,   63, 76,   63, 77,   63, 78,   63, 78,   63, 79,   63, 74,   63, 75,   63, 76,   63, 76,   63, 77,   63,
    78,   63, 78,   63, 79,   63, 79,   63, 80,   63, 81,   63, 81,   63, 82,   63, 82,   63, 83,   63, 84,   63,
    79,   63, 80,   63, 81,   63, 81,   63, 82,   63, 82,   63, 83,   63, 84,   63, 84,   63, 85,   63, 85,   63,
    86,   63, 87,   63, 87,   63, 88,   63, 88,   63, 84,   63, 85,   63, 85,   63, 86,   63, 87,   63, 87,   63,
    88,   63, 88,   63, 89,   63, 90,   63, 90,   63, 91,   63, 91,   63, 92,   63, 93,   63, 93,   63, 89,   63,
    90,   63, 90,   63, 91,   63, 91,   63, 92,   63, 93,   63, 93,   63, 94,   63, 94,   63, 95,   63, 95,   63,
    96,   63, 97,   63, 97,   63, 98,   63, 94,   63, 94,   63, 95,   63, 95,   63, 96,   63, 97,   63, 97,   63,
    98,   63, 98,   63, 99,   63, 99,   63, 100,  63, 101,  63, 101,  63, 102,  63, 102,  63, 98,   63, 99,   63,
    99,   63, 100,  63, 101,  63, 101,  63, 102,  63, 102,  63, 103,  63, 103,  63, 104,  63, 104,  63, 105,  63,
    106,  63, 106,  63, 107,  63, 103,  63, 103,  63, 104,  63, 104,  63, 105,  63, 106,  63, 106,  63, 107,  63,
    107,  63, 108,  63, 108,  63, 109,  63, 109,  63, 110,  63, 110,  63, 111,  63, 107,  63, 108,  63, 108,  63,
    109,  63, 109,  63, 110,  63, 110,  63, 111,  63, 111,  63, 112,  63, 113,  63, 113,  63, 114,  63, 114,  63,
    115,  63, 115,  63, 111,  63, 112,  63, 113,  63, 113,  63, 114,  63, 114,  63, 115,  63, 115,  63, 116,  63,
    116,  63, 117,  63, 117,  63, 118,  63, 118,  63, 119,  63, 119,  63, 116,  63, 116,  63, 117,  63, 117,  63,
    118,  63, 118,  63, 119,  63, 119,  63, 120,  63, 120,  63, 121,  63, 121,  63, 122,  63, 122,  63, 123,  63,
    123,  63, 120,  63, 120,  63, 121,  63, 121,  63, 122,  63, 122,  63, 123,  63, 123,  63, 124,  63, 124,  63,
    125,  63, 125,  63, 126,  63, 126,  63, 127,  63, 127,  63, 124,  63, 124,  63, 125,  63, 125,  63, 126,  63,
    126,  63, 127,  63, 127,  63, -128, 63, -128, 63, -127, 63, -127, 63, -126, 63, -126, 63, -125, 63, -125, 63,
    -128, 63, -128, 63, -127, 63, -127, 63, -126, 63, -126, 63, -125, 63, -125, 63, -124, 63, -124, 63, -123, 63,
    -123, 63, -122, 63, -122, 63, -121, 63, -121, 63, -124, 63, -124, 63, -123, 63, -123, 63, -122, 63, -122, 63,
    -121, 63, -121, 63, -120, 63, -120, 63, -119, 63, -119, 63, -118, 63, -118, 63, -117, 63, -117, 63, -120, 63,
    -120, 63, -119, 63, -119, 63, -118, 63, -118, 63, -117, 63, -117, 63, -117, 63, -116, 63, -116, 63, -115, 63,
    -115, 63, -114, 63, -114, 63, -113, 63, -117, 63, -116, 63, -116, 63, -115, 63, -115, 63, -114, 63, -114, 63,
    -113, 63, -113, 63, -112, 63, -112, 63, -112, 63, -111, 63, -111, 63, -110, 63, -110, 63, -113, 63, -112, 63,
    -112, 63, -112, 63, -111, 63, -111, 63, -110, 63, -110, 63, -109, 63, -109, 63, -108, 63, -108, 63, -108, 63,
    -107, 63, -107, 63, -106, 63, -109, 63, -109, 63, -108, 63, -108, 63, -108, 63, -107, 63, -107, 63, -106, 63,
    -106, 63, -105, 63, -105, 63, -105, 63, -104, 63, -104, 63, -103, 63, -103, 63, -106, 63, -105, 63, -105, 63,
    -105, 63, -104, 63, -104, 63, -103, 63, -103, 63, -103, 63, -102, 63, -102, 63, -101, 63, -101, 63, -100, 63,
    -100, 63, -100, 63, -103, 63, -102, 63, -102, 63, -101, 63, -101, 63, -100, 63, -100, 63, -100, 63, -99,  63,
    -99,  63, -98,  63, -98,  63, -98,  63, -97,  63, -97,  63, -96,  63, -99,  63, -99,  63, -98,  63, -98,  63,
    -98,  63, -97,  63, -97,  63, -96,  63, -96,  63, -96,  63, -95,  63, -95,  63, -94,  63, -94,  63, -94,  63,
    -93,  63, -96,  63, -96,  63, -95,  63, -95,  63, -94,  63, -94,  63, -94,  63, -93,  63, -93,  63, -92,  63,
    -92,  63, -92,  63, -91,  63, -91,  63, -90,  63, -90,  63, -93,  63, -92,  63, -92,  63, -92,  63, -91,  63,
    -91,  63, -90,  63, -90,  63, -90,  63, -89,  63, -89,  63, -89,  63, -88,  63, -88,  63, -87,  63, -87,  63,
    -90,  63, -89,  63, -89,  63, -89,  63, -88,  63, -88,  63, -87,  63, -87,  63, -87,  63, -86,  63, -86,  63,
    -86,  63, -85,  63, -85,  63, -84,  63, -84,  63, -87,  63, -86,  63, -86,  63, -86,  63, -85,  63, -85,  63,
    -84,  63, -84,  63, -84,  63, -83,  63, -83,  63, -83,  63, -82,  63, -82,  63, -81,  63, -81,  63, -84,  63,
    -83,  63, -83,  63, -83,  63, -82,  63, -82,  63, -81,  63, -81,  63, -81,  63, -80,  63, -80,  63, -80,  63,
    -79,  63, -79,  63, -79,  63, -78,  63, -81,  63, -80,  63, -80,  63, -80,  63, -79,  63, -79,  63, -79,  63,
    -78,  63, -78,  63, -77,  63, -77,  63, -77,  63, -76,  63, -76,  63, -76,  63, -75,  63, -78,  63, -77,  63,
    -77,  63, -77,  63, -76,  63, -76,  63, -76,  63, -75,  63};

alignas(__ALIGN_BYTE_SIZE__) const int8 sqrtLUT1[1024] = {
    53,   63, 54,   63, 54,   63, 55,   63, 56,   63, 57,   63, 57,   63, 58,   63, 53,   63, 54,   63, 54,   63,
    55,   63, 56,   63, 57,   63, 57,   63, 58,   63, 59,   63, 59,   63, 60,   63, 61,   63, 61,   63, 62,   63,
    63,   63, 63,   63, 59,   63, 59,   63, 60,   63, 61,   63, 61,   63, 62,   63, 63,   63, 63,   63, 64,   63,
    65,   63, 65,   63, 66,   63, 67,   63, 67,   63, 68,   63, 69,   63, 64,   63, 65,   63, 65,   63, 66,   63,
    67,   63, 67,   63, 68,   63, 69,   63, 69,   63, 70,   63, 71,   63, 71,   63, 72,   63, 72,   63, 73,   63,
    74,   63, 69,   63, 70,   63, 71,   63, 71,   63, 72,   63, 72,   63, 73,   63, 74,   63, 74,   63, 75,   63,
    76,   63, 76,   63, 77,   63, 78,   63, 78,   63, 79,   63, 74,   63, 75,   63, 76,   63, 76,   63, 77,   63,
    78,   63, 78,   63, 79,   63, 79,   63, 80,   63, 81,   63, 81,   63, 82,   63, 82,   63, 83,   63, 84,   63,
    79,   63, 80,   63, 81,   63, 81,   63, 82,   63, 82,   63, 83,   63, 84,   63, 84,   63, 85,   63, 85,   63,
    86,   63, 87,   63, 87,   63, 88,   63, 88,   63, 84,   63, 85,   63, 85,   63, 86,   63, 87,   63, 87,   63,
    88,   63, 88,   63, 89,   63, 90,   63, 90,   63, 91,   63, 91,   63, 92,   63, 93,   63, 93,   63, 89,   63,
    90,   63, 90,   63, 91,   63, 91,   63, 92,   63, 93,   63, 93,   63, 94,   63, 94,   63, 95,   63, 95,   63,
    96,   63, 97,   63, 97,   63, 98,   63, 94,   63, 94,   63, 95,   63, 95,   63, 96,   63, 97,   63, 97,   63,
    98,   63, 98,   63, 99,   63, 99,   63, 100,  63, 101,  63, 101,  63, 102,  63, 102,  63, 98,   63, 99,   63,
    99,   63, 100,  63, 101,  63, 101,  63, 102,  63, 102,  63, 103,  63, 103,  63, 104,  63, 104,  63, 105,  63,
    106,  63, 106,  63, 107,  63, 103,  63, 103,  63, 104,  63, 104,  63, 105,  63, 106,  63, 106,  63, 107,  63,
    107,  63, 108,  63, 108,  63, 109,  63, 109,  63, 110,  63, 110,  63, 111,  63, 107,  63, 108,  63, 108,  63,
    109,  63, 109,  63, 110,  63, 110,  63, 111,  63, 111,  63, 112,  63, 113,  63, 113,  63, 114,  63, 114,  63,
    115,  63, 115,  63, 111,  63, 112,  63, 113,  63, 113,  63, 114,  63, 114,  63, 115,  63, 115,  63, 116,  63,
    116,  63, 117,  63, 117,  63, 118,  63, 118,  63, 119,  63, 119,  63, 116,  63, 116,  63, 117,  63, 117,  63,
    118,  63, 118,  63, 119,  63, 119,  63, 120,  63, 120,  63, 121,  63, 121,  63, 122,  63, 122,  63, 123,  63,
    123,  63, 120,  63, 120,  63, 121,  63, 121,  63, 122,  63, 122,  63, 123,  63, 123,  63, 124,  63, 124,  63,
    125,  63, 125,  63, 126,  63, 126,  63, 127,  63, 127,  63, 124,  63, 124,  63, 125,  63, 125,  63, 126,  63,
    126,  63, 127,  63, 127,  63, -128, 63, -128, 63, -127, 63, -127, 63, -126, 63, -126, 63, -125, 63, -125, 63,
    -128, 63, -128, 63, -127, 63, -127, 63, -126, 63, -126, 63, -125, 63, -125, 63, -124, 63, -124, 63, -123, 63,
    -123, 63, -122, 63, -122, 63, -121, 63, -121, 63, -124, 63, -124, 63, -123, 63, -123, 63, -122, 63, -122, 63,
    -121, 63, -121, 63, -120, 63, -120, 63, -119, 63, -119, 63, -118, 63, -118, 63, -117, 63, -117, 63, -120, 63,
    -120, 63, -119, 63, -119, 63, -118, 63, -118, 63, -117, 63, -117, 63, -117, 63, -116, 63, -116, 63, -115, 63,
    -115, 63, -114, 63, -114, 63, -113, 63, -117, 63, -116, 63, -116, 63, -115, 63, -115, 63, -114, 63, -114, 63,
    -113, 63, -113, 63, -112, 63, -112, 63, -112, 63, -111, 63, -111, 63, -110, 63, -110, 63, -113, 63, -112, 63,
    -112, 63, -112, 63, -111, 63, -111, 63, -110, 63, -110, 63, -109, 63, -109, 63, -108, 63, -108, 63, -108, 63,
    -107, 63, -107, 63, -106, 63, -109, 63, -109, 63, -108, 63, -108, 63, -108, 63, -107, 63, -107, 63, -106, 63,
    -106, 63, -105, 63, -105, 63, -105, 63, -104, 63, -104, 63, -103, 63, -103, 63, -106, 63, -105, 63, -105, 63,
    -105, 63, -104, 63, -104, 63, -103, 63, -103, 63, -103, 63, -102, 63, -102, 63, -101, 63, -101, 63, -100, 63,
    -100, 63, -100, 63, -103, 63, -102, 63, -102, 63, -101, 63, -101, 63, -100, 63, -100, 63, -100, 63, -99,  63,
    -99,  63, -98,  63, -98,  63, -98,  63, -97,  63, -97,  63, -96,  63, -99,  63, -99,  63, -98,  63, -98,  63,
    -98,  63, -97,  63, -97,  63, -96,  63, -96,  63, -96,  63, -95,  63, -95,  63, -94,  63, -94,  63, -94,  63,
    -93,  63, -96,  63, -96,  63, -95,  63, -95,  63, -94,  63, -94,  63, -94,  63, -93,  63, -93,  63, -92,  63,
    -92,  63, -92,  63, -91,  63, -91,  63, -90,  63, -90,  63, -93,  63, -92,  63, -92,  63, -92,  63, -91,  63,
    -91,  63, -90,  63, -90,  63, -90,  63, -89,  63, -89,  63, -89,  63, -88,  63, -88,  63, -87,  63, -87,  63,
    -90,  63, -89,  63, -89,  63, -89,  63, -88,  63, -88,  63, -87,  63, -87,  63, -87,  63, -86,  63, -86,  63,
    -86,  63, -85,  63, -85,  63, -84,  63, -84,  63, -87,  63, -86,  63, -86,  63, -86,  63, -85,  63, -85,  63,
    -84,  63, -84,  63, -84,  63, -83,  63, -83,  63, -83,  63, -82,  63, -82,  63, -81,  63, -81,  63, -84,  63,
    -83,  63, -83,  63, -83,  63, -82,  63, -82,  63, -81,  63, -81,  63, -81,  63, -80,  63, -80,  63, -80,  63,
    -79,  63, -79,  63, -79,  63, -78,  63, -81,  63, -80,  63, -80,  63, -80,  63, -79,  63, -79,  63, -79,  63,
    -78,  63, -78,  63, -77,  63, -77,  63, -77,  63, -76,  63, -76,  63, -76,  63, -75,  63, -78,  63, -77,  63,
    -77,  63, -77,  63, -76,  63, -76,  63, -76,  63, -75,  63};

#endif