/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __FFT_R2COMB_TWIDDLE_LUT_ALL_H__
#define __FFT_R2COMB_TWIDDLE_LUT_ALL_H__

// DO NOT HAND EDIT THIS FILE. IT WAS CREATED using ../tests/inc/twiddle_r2master.c

#include "device_defs.h"

// The values in this file were created using twiddle.c, then hand copied over.

static constexpr int kR2MasterTableSize = 32768;
// The values in this file were created using twiddle.c

static constexpr cint16 r2_twiddle_master_cint16[kR2MasterTableSize] = {
    {32767, 0},       {32767, -3},      {32767, -6},      {32767, -9},      {32767, -13},     {32767, -16},
    {32767, -19},     {32767, -22},     {32767, -25},     {32767, -28},     {32767, -31},     {32767, -35},
    {32767, -38},     {32767, -41},     {32767, -44},     {32767, -47},     {32767, -50},     {32767, -53},
    {32767, -57},     {32767, -60},     {32767, -63},     {32767, -66},     {32767, -69},     {32767, -72},
    {32767, -75},     {32767, -79},     {32767, -82},     {32767, -85},     {32767, -88},     {32767, -91},
    {32767, -94},     {32767, -97},     {32767, -101},    {32767, -104},    {32767, -107},    {32767, -110},
    {32767, -113},    {32767, -116},    {32767, -119},    {32767, -123},    {32767, -126},    {32767, -129},
    {32767, -132},    {32767, -135},    {32767, -138},    {32767, -141},    {32767, -145},    {32767, -148},
    {32767, -151},    {32767, -154},    {32767, -157},    {32767, -160},    {32767, -163},    {32767, -167},
    {32767, -170},    {32767, -173},    {32767, -176},    {32767, -179},    {32767, -182},    {32767, -185},
    {32767, -188},    {32767, -192},    {32767, -195},    {32767, -198},    {32767, -201},    {32767, -204},
    {32767, -207},    {32767, -210},    {32767, -214},    {32767, -217},    {32767, -220},    {32767, -223},
    {32767, -226},    {32767, -229},    {32767, -232},    {32767, -236},    {32767, -239},    {32767, -242},
    {32767, -245},    {32767, -248},    {32767, -251},    {32767, -254},    {32767, -258},    {32767, -261},
    {32767, -264},    {32767, -267},    {32767, -270},    {32767, -273},    {32767, -276},    {32767, -280},
    {32767, -283},    {32767, -286},    {32767, -289},    {32767, -292},    {32767, -295},    {32767, -298},
    {32767, -302},    {32767, -305},    {32767, -308},    {32767, -311},    {32766, -314},    {32766, -317},
    {32766, -320},    {32766, -324},    {32766, -327},    {32766, -330},    {32766, -333},    {32766, -336},
    {32766, -339},    {32766, -342},    {32766, -346},    {32766, -349},    {32766, -352},    {32766, -355},
    {32766, -358},    {32766, -361},    {32766, -364},    {32766, -368},    {32766, -371},    {32766, -374},
    {32766, -377},    {32766, -380},    {32766, -383},    {32766, -386},    {32766, -390},    {32766, -393},
    {32766, -396},    {32766, -399},    {32766, -402},    {32765, -405},    {32765, -408},    {32765, -412},
    {32765, -415},    {32765, -418},    {32765, -421},    {32765, -424},    {32765, -427},    {32765, -430},
    {32765, -434},    {32765, -437},    {32765, -440},    {32765, -443},    {32765, -446},    {32765, -449},
    {32765, -452},    {32765, -456},    {32765, -459},    {32765, -462},    {32765, -465},    {32765, -468},
    {32765, -471},    {32765, -474},    {32765, -478},    {32764, -481},    {32764, -484},    {32764, -487},
    {32764, -490},    {32764, -493},    {32764, -496},    {32764, -499},    {32764, -503},    {32764, -506},
    {32764, -509},    {32764, -512},    {32764, -515},    {32764, -518},    {32764, -521},    {32764, -525},
    {32764, -528},    {32764, -531},    {32764, -534},    {32764, -537},    {32764, -540},    {32763, -543},
    {32763, -547},    {32763, -550},    {32763, -553},    {32763, -556},    {32763, -559},    {32763, -562},
    {32763, -565},    {32763, -569},    {32763, -572},    {32763, -575},    {32763, -578},    {32763, -581},
    {32763, -584},    {32763, -587},    {32763, -591},    {32763, -594},    {32763, -597},    {32763, -600},
    {32762, -603},    {32762, -606},    {32762, -609},    {32762, -613},    {32762, -616},    {32762, -619},
    {32762, -622},    {32762, -625},    {32762, -628},    {32762, -631},    {32762, -635},    {32762, -638},
    {32762, -641},    {32762, -644},    {32762, -647},    {32762, -650},    {32761, -653},    {32761, -657},
    {32761, -660},    {32761, -663},    {32761, -666},    {32761, -669},    {32761, -672},    {32761, -675},
    {32761, -679},    {32761, -682},    {32761, -685},    {32761, -688},    {32761, -691},    {32761, -694},
    {32761, -697},    {32761, -701},    {32760, -704},    {32760, -707},    {32760, -710},    {32760, -713},
    {32760, -716},    {32760, -719},    {32760, -723},    {32760, -726},    {32760, -729},    {32760, -732},
    {32760, -735},    {32760, -738},    {32760, -741},    {32760, -744},    {32759, -748},    {32759, -751},
    {32759, -754},    {32759, -757},    {32759, -760},    {32759, -763},    {32759, -766},    {32759, -770},
    {32759, -773},    {32759, -776},    {32759, -779},    {32759, -782},    {32759, -785},    {32759, -788},
    {32758, -792},    {32758, -795},    {32758, -798},    {32758, -801},    {32758, -804},    {32758, -807},
    {32758, -810},    {32758, -814},    {32758, -817},    {32758, -820},    {32758, -823},    {32758, -826},
    {32758, -829},    {32757, -832},    {32757, -836},    {32757, -839},    {32757, -842},    {32757, -845},
    {32757, -848},    {32757, -851},    {32757, -854},    {32757, -858},    {32757, -861},    {32757, -864},
    {32757, -867},    {32756, -870},    {32756, -873},    {32756, -876},    {32756, -880},    {32756, -883},
    {32756, -886},    {32756, -889},    {32756, -892},    {32756, -895},    {32756, -898},    {32756, -902},
    {32756, -905},    {32755, -908},    {32755, -911},    {32755, -914},    {32755, -917},    {32755, -920},
    {32755, -924},    {32755, -927},    {32755, -930},    {32755, -933},    {32755, -936},    {32755, -939},
    {32754, -942},    {32754, -945},    {32754, -949},    {32754, -952},    {32754, -955},    {32754, -958},
    {32754, -961},    {32754, -964},    {32754, -967},    {32754, -971},    {32754, -974},    {32753, -977},
    {32753, -980},    {32753, -983},    {32753, -986},    {32753, -989},    {32753, -993},    {32753, -996},
    {32753, -999},    {32753, -1002},   {32753, -1005},   {32752, -1008},   {32752, -1011},   {32752, -1015},
    {32752, -1018},   {32752, -1021},   {32752, -1024},   {32752, -1027},   {32752, -1030},   {32752, -1033},
    {32752, -1037},   {32752, -1040},   {32751, -1043},   {32751, -1046},   {32751, -1049},   {32751, -1052},
    {32751, -1055},   {32751, -1059},   {32751, -1062},   {32751, -1065},   {32751, -1068},   {32750, -1071},
    {32750, -1074},   {32750, -1077},   {32750, -1081},   {32750, -1084},   {32750, -1087},   {32750, -1090},
    {32750, -1093},   {32750, -1096},   {32750, -1099},   {32749, -1102},   {32749, -1106},   {32749, -1109},
    {32749, -1112},   {32749, -1115},   {32749, -1118},   {32749, -1121},   {32749, -1124},   {32749, -1128},
    {32748, -1131},   {32748, -1134},   {32748, -1137},   {32748, -1140},   {32748, -1143},   {32748, -1146},
    {32748, -1150},   {32748, -1153},   {32748, -1156},   {32747, -1159},   {32747, -1162},   {32747, -1165},
    {32747, -1168},   {32747, -1172},   {32747, -1175},   {32747, -1178},   {32747, -1181},   {32747, -1184},
    {32746, -1187},   {32746, -1190},   {32746, -1194},   {32746, -1197},   {32746, -1200},   {32746, -1203},
    {32746, -1206},   {32746, -1209},   {32746, -1212},   {32745, -1216},   {32745, -1219},   {32745, -1222},
    {32745, -1225},   {32745, -1228},   {32745, -1231},   {32745, -1234},   {32745, -1237},   {32745, -1241},
    {32744, -1244},   {32744, -1247},   {32744, -1250},   {32744, -1253},   {32744, -1256},   {32744, -1259},
    {32744, -1263},   {32744, -1266},   {32743, -1269},   {32743, -1272},   {32743, -1275},   {32743, -1278},
    {32743, -1281},   {32743, -1285},   {32743, -1288},   {32743, -1291},   {32742, -1294},   {32742, -1297},
    {32742, -1300},   {32742, -1303},   {32742, -1307},   {32742, -1310},   {32742, -1313},   {32742, -1316},
    {32741, -1319},   {32741, -1322},   {32741, -1325},   {32741, -1329},   {32741, -1332},   {32741, -1335},
    {32741, -1338},   {32741, -1341},   {32740, -1344},   {32740, -1347},   {32740, -1351},   {32740, -1354},
    {32740, -1357},   {32740, -1360},   {32740, -1363},   {32740, -1366},   {32739, -1369},   {32739, -1372},
    {32739, -1376},   {32739, -1379},   {32739, -1382},   {32739, -1385},   {32739, -1388},   {32738, -1391},
    {32738, -1394},   {32738, -1398},   {32738, -1401},   {32738, -1404},   {32738, -1407},   {32738, -1410},
    {32738, -1413},   {32737, -1416},   {32737, -1420},   {32737, -1423},   {32737, -1426},   {32737, -1429},
    {32737, -1432},   {32737, -1435},   {32736, -1438},   {32736, -1442},   {32736, -1445},   {32736, -1448},
    {32736, -1451},   {32736, -1454},   {32736, -1457},   {32735, -1460},   {32735, -1463},   {32735, -1467},
    {32735, -1470},   {32735, -1473},   {32735, -1476},   {32735, -1479},   {32734, -1482},   {32734, -1485},
    {32734, -1489},   {32734, -1492},   {32734, -1495},   {32734, -1498},   {32734, -1501},   {32733, -1504},
    {32733, -1507},   {32733, -1511},   {32733, -1514},   {32733, -1517},   {32733, -1520},   {32733, -1523},
    {32732, -1526},   {32732, -1529},   {32732, -1533},   {32732, -1536},   {32732, -1539},   {32732, -1542},
    {32732, -1545},   {32731, -1548},   {32731, -1551},   {32731, -1555},   {32731, -1558},   {32731, -1561},
    {32731, -1564},   {32731, -1567},   {32730, -1570},   {32730, -1573},   {32730, -1576},   {32730, -1580},
    {32730, -1583},   {32730, -1586},   {32729, -1589},   {32729, -1592},   {32729, -1595},   {32729, -1598},
    {32729, -1602},   {32729, -1605},   {32729, -1608},   {32728, -1611},   {32728, -1614},   {32728, -1617},
    {32728, -1620},   {32728, -1624},   {32728, -1627},   {32727, -1630},   {32727, -1633},   {32727, -1636},
    {32727, -1639},   {32727, -1642},   {32727, -1646},   {32727, -1649},   {32726, -1652},   {32726, -1655},
    {32726, -1658},   {32726, -1661},   {32726, -1664},   {32726, -1667},   {32725, -1671},   {32725, -1674},
    {32725, -1677},   {32725, -1680},   {32725, -1683},   {32725, -1686},   {32724, -1689},   {32724, -1693},
    {32724, -1696},   {32724, -1699},   {32724, -1702},   {32724, -1705},   {32723, -1708},   {32723, -1711},
    {32723, -1715},   {32723, -1718},   {32723, -1721},   {32723, -1724},   {32722, -1727},   {32722, -1730},
    {32722, -1733},   {32722, -1736},   {32722, -1740},   {32722, -1743},   {32721, -1746},   {32721, -1749},
    {32721, -1752},   {32721, -1755},   {32721, -1758},   {32721, -1762},   {32720, -1765},   {32720, -1768},
    {32720, -1771},   {32720, -1774},   {32720, -1777},   {32720, -1780},   {32719, -1784},   {32719, -1787},
    {32719, -1790},   {32719, -1793},   {32719, -1796},   {32719, -1799},   {32718, -1802},   {32718, -1806},
    {32718, -1809},   {32718, -1812},   {32718, -1815},   {32718, -1818},   {32717, -1821},   {32717, -1824},
    {32717, -1827},   {32717, -1831},   {32717, -1834},   {32716, -1837},   {32716, -1840},   {32716, -1843},
    {32716, -1846},   {32716, -1849},   {32716, -1853},   {32715, -1856},   {32715, -1859},   {32715, -1862},
    {32715, -1865},   {32715, -1868},   {32715, -1871},   {32714, -1875},   {32714, -1878},   {32714, -1881},
    {32714, -1884},   {32714, -1887},   {32713, -1890},   {32713, -1893},   {32713, -1896},   {32713, -1900},
    {32713, -1903},   {32713, -1906},   {32712, -1909},   {32712, -1912},   {32712, -1915},   {32712, -1918},
    {32712, -1922},   {32711, -1925},   {32711, -1928},   {32711, -1931},   {32711, -1934},   {32711, -1937},
    {32710, -1940},   {32710, -1944},   {32710, -1947},   {32710, -1950},   {32710, -1953},   {32710, -1956},
    {32709, -1959},   {32709, -1962},   {32709, -1965},   {32709, -1969},   {32709, -1972},   {32708, -1975},
    {32708, -1978},   {32708, -1981},   {32708, -1984},   {32708, -1987},   {32707, -1991},   {32707, -1994},
    {32707, -1997},   {32707, -2000},   {32707, -2003},   {32707, -2006},   {32706, -2009},   {32706, -2012},
    {32706, -2016},   {32706, -2019},   {32706, -2022},   {32705, -2025},   {32705, -2028},   {32705, -2031},
    {32705, -2034},   {32705, -2038},   {32704, -2041},   {32704, -2044},   {32704, -2047},   {32704, -2050},
    {32704, -2053},   {32703, -2056},   {32703, -2060},   {32703, -2063},   {32703, -2066},   {32703, -2069},
    {32702, -2072},   {32702, -2075},   {32702, -2078},   {32702, -2081},   {32702, -2085},   {32701, -2088},
    {32701, -2091},   {32701, -2094},   {32701, -2097},   {32701, -2100},   {32700, -2103},   {32700, -2107},
    {32700, -2110},   {32700, -2113},   {32700, -2116},   {32699, -2119},   {32699, -2122},   {32699, -2125},
    {32699, -2129},   {32699, -2132},   {32698, -2135},   {32698, -2138},   {32698, -2141},   {32698, -2144},
    {32698, -2147},   {32697, -2150},   {32697, -2154},   {32697, -2157},   {32697, -2160},   {32697, -2163},
    {32696, -2166},   {32696, -2169},   {32696, -2172},   {32696, -2176},   {32695, -2179},   {32695, -2182},
    {32695, -2185},   {32695, -2188},   {32695, -2191},   {32694, -2194},   {32694, -2197},   {32694, -2201},
    {32694, -2204},   {32694, -2207},   {32693, -2210},   {32693, -2213},   {32693, -2216},   {32693, -2219},
    {32693, -2223},   {32692, -2226},   {32692, -2229},   {32692, -2232},   {32692, -2235},   {32691, -2238},
    {32691, -2241},   {32691, -2244},   {32691, -2248},   {32691, -2251},   {32690, -2254},   {32690, -2257},
    {32690, -2260},   {32690, -2263},   {32690, -2266},   {32689, -2270},   {32689, -2273},   {32689, -2276},
    {32689, -2279},   {32688, -2282},   {32688, -2285},   {32688, -2288},   {32688, -2291},   {32688, -2295},
    {32687, -2298},   {32687, -2301},   {32687, -2304},   {32687, -2307},   {32686, -2310},   {32686, -2313},
    {32686, -2317},   {32686, -2320},   {32686, -2323},   {32685, -2326},   {32685, -2329},   {32685, -2332},
    {32685, -2335},   {32684, -2338},   {32684, -2342},   {32684, -2345},   {32684, -2348},   {32684, -2351},
    {32683, -2354},   {32683, -2357},   {32683, -2360},   {32683, -2364},   {32682, -2367},   {32682, -2370},
    {32682, -2373},   {32682, -2376},   {32682, -2379},   {32681, -2382},   {32681, -2385},   {32681, -2389},
    {32681, -2392},   {32680, -2395},   {32680, -2398},   {32680, -2401},   {32680, -2404},   {32679, -2407},
    {32679, -2411},   {32679, -2414},   {32679, -2417},   {32679, -2420},   {32678, -2423},   {32678, -2426},
    {32678, -2429},   {32678, -2432},   {32677, -2436},   {32677, -2439},   {32677, -2442},   {32677, -2445},
    {32676, -2448},   {32676, -2451},   {32676, -2454},   {32676, -2458},   {32675, -2461},   {32675, -2464},
    {32675, -2467},   {32675, -2470},   {32675, -2473},   {32674, -2476},   {32674, -2479},   {32674, -2483},
    {32674, -2486},   {32673, -2489},   {32673, -2492},   {32673, -2495},   {32673, -2498},   {32672, -2501},
    {32672, -2505},   {32672, -2508},   {32672, -2511},   {32671, -2514},   {32671, -2517},   {32671, -2520},
    {32671, -2523},   {32670, -2526},   {32670, -2530},   {32670, -2533},   {32670, -2536},   {32669, -2539},
    {32669, -2542},   {32669, -2545},   {32669, -2548},   {32669, -2552},   {32668, -2555},   {32668, -2558},
    {32668, -2561},   {32668, -2564},   {32667, -2567},   {32667, -2570},   {32667, -2573},   {32667, -2577},
    {32666, -2580},   {32666, -2583},   {32666, -2586},   {32666, -2589},   {32665, -2592},   {32665, -2595},
    {32665, -2599},   {32665, -2602},   {32664, -2605},   {32664, -2608},   {32664, -2611},   {32664, -2614},
    {32663, -2617},   {32663, -2620},   {32663, -2624},   {32663, -2627},   {32662, -2630},   {32662, -2633},
    {32662, -2636},   {32662, -2639},   {32661, -2642},   {32661, -2645},   {32661, -2649},   {32661, -2652},
    {32660, -2655},   {32660, -2658},   {32660, -2661},   {32660, -2664},   {32659, -2667},   {32659, -2671},
    {32659, -2674},   {32658, -2677},   {32658, -2680},   {32658, -2683},   {32658, -2686},   {32657, -2689},
    {32657, -2692},   {32657, -2696},   {32657, -2699},   {32656, -2702},   {32656, -2705},   {32656, -2708},
    {32656, -2711},   {32655, -2714},   {32655, -2717},   {32655, -2721},   {32655, -2724},   {32654, -2727},
    {32654, -2730},   {32654, -2733},   {32654, -2736},   {32653, -2739},   {32653, -2743},   {32653, -2746},
    {32653, -2749},   {32652, -2752},   {32652, -2755},   {32652, -2758},   {32651, -2761},   {32651, -2764},
    {32651, -2768},   {32651, -2771},   {32650, -2774},   {32650, -2777},   {32650, -2780},   {32650, -2783},
    {32649, -2786},   {32649, -2789},   {32649, -2793},   {32649, -2796},   {32648, -2799},   {32648, -2802},
    {32648, -2805},   {32647, -2808},   {32647, -2811},   {32647, -2815},   {32647, -2818},   {32646, -2821},
    {32646, -2824},   {32646, -2827},   {32646, -2830},   {32645, -2833},   {32645, -2836},   {32645, -2840},
    {32644, -2843},   {32644, -2846},   {32644, -2849},   {32644, -2852},   {32643, -2855},   {32643, -2858},
    {32643, -2861},   {32643, -2865},   {32642, -2868},   {32642, -2871},   {32642, -2874},   {32641, -2877},
    {32641, -2880},   {32641, -2883},   {32641, -2887},   {32640, -2890},   {32640, -2893},   {32640, -2896},
    {32640, -2899},   {32639, -2902},   {32639, -2905},   {32639, -2908},   {32638, -2912},   {32638, -2915},
    {32638, -2918},   {32638, -2921},   {32637, -2924},   {32637, -2927},   {32637, -2930},   {32636, -2933},
    {32636, -2937},   {32636, -2940},   {32636, -2943},   {32635, -2946},   {32635, -2949},   {32635, -2952},
    {32634, -2955},   {32634, -2958},   {32634, -2962},   {32634, -2965},   {32633, -2968},   {32633, -2971},
    {32633, -2974},   {32632, -2977},   {32632, -2980},   {32632, -2984},   {32632, -2987},   {32631, -2990},
    {32631, -2993},   {32631, -2996},   {32630, -2999},   {32630, -3002},   {32630, -3005},   {32630, -3009},
    {32629, -3012},   {32629, -3015},   {32629, -3018},   {32628, -3021},   {32628, -3024},   {32628, -3027},
    {32628, -3030},   {32627, -3034},   {32627, -3037},   {32627, -3040},   {32626, -3043},   {32626, -3046},
    {32626, -3049},   {32626, -3052},   {32625, -3055},   {32625, -3059},   {32625, -3062},   {32624, -3065},
    {32624, -3068},   {32624, -3071},   {32623, -3074},   {32623, -3077},   {32623, -3080},   {32623, -3084},
    {32622, -3087},   {32622, -3090},   {32622, -3093},   {32621, -3096},   {32621, -3099},   {32621, -3102},
    {32621, -3106},   {32620, -3109},   {32620, -3112},   {32620, -3115},   {32619, -3118},   {32619, -3121},
    {32619, -3124},   {32618, -3127},   {32618, -3131},   {32618, -3134},   {32618, -3137},   {32617, -3140},
    {32617, -3143},   {32617, -3146},   {32616, -3149},   {32616, -3152},   {32616, -3156},   {32615, -3159},
    {32615, -3162},   {32615, -3165},   {32614, -3168},   {32614, -3171},   {32614, -3174},   {32614, -3177},
    {32613, -3181},   {32613, -3184},   {32613, -3187},   {32612, -3190},   {32612, -3193},   {32612, -3196},
    {32611, -3199},   {32611, -3202},   {32611, -3206},   {32611, -3209},   {32610, -3212},   {32610, -3215},
    {32610, -3218},   {32609, -3221},   {32609, -3224},   {32609, -3227},   {32608, -3231},   {32608, -3234},
    {32608, -3237},   {32607, -3240},   {32607, -3243},   {32607, -3246},   {32606, -3249},   {32606, -3252},
    {32606, -3256},   {32606, -3259},   {32605, -3262},   {32605, -3265},   {32605, -3268},   {32604, -3271},
    {32604, -3274},   {32604, -3277},   {32603, -3281},   {32603, -3284},   {32603, -3287},   {32602, -3290},
    {32602, -3293},   {32602, -3296},   {32601, -3299},   {32601, -3302},   {32601, -3306},   {32601, -3309},
    {32600, -3312},   {32600, -3315},   {32600, -3318},   {32599, -3321},   {32599, -3324},   {32599, -3327},
    {32598, -3331},   {32598, -3334},   {32598, -3337},   {32597, -3340},   {32597, -3343},   {32597, -3346},
    {32596, -3349},   {32596, -3352},   {32596, -3356},   {32595, -3359},   {32595, -3362},   {32595, -3365},
    {32594, -3368},   {32594, -3371},   {32594, -3374},   {32593, -3377},   {32593, -3381},   {32593, -3384},
    {32592, -3387},   {32592, -3390},   {32592, -3393},   {32592, -3396},   {32591, -3399},   {32591, -3402},
    {32591, -3406},   {32590, -3409},   {32590, -3412},   {32590, -3415},   {32589, -3418},   {32589, -3421},
    {32589, -3424},   {32588, -3427},   {32588, -3431},   {32588, -3434},   {32587, -3437},   {32587, -3440},
    {32587, -3443},   {32586, -3446},   {32586, -3449},   {32586, -3452},   {32585, -3456},   {32585, -3459},
    {32585, -3462},   {32584, -3465},   {32584, -3468},   {32584, -3471},   {32583, -3474},   {32583, -3477},
    {32583, -3481},   {32582, -3484},   {32582, -3487},   {32582, -3490},   {32581, -3493},   {32581, -3496},
    {32581, -3499},   {32580, -3502},   {32580, -3506},   {32580, -3509},   {32579, -3512},   {32579, -3515},
    {32579, -3518},   {32578, -3521},   {32578, -3524},   {32578, -3527},   {32577, -3531},   {32577, -3534},
    {32577, -3537},   {32576, -3540},   {32576, -3543},   {32576, -3546},   {32575, -3549},   {32575, -3552},
    {32575, -3556},   {32574, -3559},   {32574, -3562},   {32574, -3565},   {32573, -3568},   {32573, -3571},
    {32572, -3574},   {32572, -3577},   {32572, -3581},   {32571, -3584},   {32571, -3587},   {32571, -3590},
    {32570, -3593},   {32570, -3596},   {32570, -3599},   {32569, -3602},   {32569, -3606},   {32569, -3609},
    {32568, -3612},   {32568, -3615},   {32568, -3618},   {32567, -3621},   {32567, -3624},   {32567, -3627},
    {32566, -3630},   {32566, -3634},   {32566, -3637},   {32565, -3640},   {32565, -3643},   {32565, -3646},
    {32564, -3649},   {32564, -3652},   {32563, -3655},   {32563, -3659},   {32563, -3662},   {32562, -3665},
    {32562, -3668},   {32562, -3671},   {32561, -3674},   {32561, -3677},   {32561, -3680},   {32560, -3684},
    {32560, -3687},   {32560, -3690},   {32559, -3693},   {32559, -3696},   {32559, -3699},   {32558, -3702},
    {32558, -3705},   {32557, -3709},   {32557, -3712},   {32557, -3715},   {32556, -3718},   {32556, -3721},
    {32556, -3724},   {32555, -3727},   {32555, -3730},   {32555, -3734},   {32554, -3737},   {32554, -3740},
    {32554, -3743},   {32553, -3746},   {32553, -3749},   {32552, -3752},   {32552, -3755},   {32552, -3758},
    {32551, -3762},   {32551, -3765},   {32551, -3768},   {32550, -3771},   {32550, -3774},   {32550, -3777},
    {32549, -3780},   {32549, -3783},   {32548, -3787},   {32548, -3790},   {32548, -3793},   {32547, -3796},
    {32547, -3799},   {32547, -3802},   {32546, -3805},   {32546, -3808},   {32546, -3812},   {32545, -3815},
    {32545, -3818},   {32544, -3821},   {32544, -3824},   {32544, -3827},   {32543, -3830},   {32543, -3833},
    {32543, -3836},   {32542, -3840},   {32542, -3843},   {32542, -3846},   {32541, -3849},   {32541, -3852},
    {32540, -3855},   {32540, -3858},   {32540, -3861},   {32539, -3865},   {32539, -3868},   {32539, -3871},
    {32538, -3874},   {32538, -3877},   {32537, -3880},   {32537, -3883},   {32537, -3886},   {32536, -3890},
    {32536, -3893},   {32536, -3896},   {32535, -3899},   {32535, -3902},   {32534, -3905},   {32534, -3908},
    {32534, -3911},   {32533, -3914},   {32533, -3918},   {32533, -3921},   {32532, -3924},   {32532, -3927},
    {32531, -3930},   {32531, -3933},   {32531, -3936},   {32530, -3939},   {32530, -3943},   {32530, -3946},
    {32529, -3949},   {32529, -3952},   {32528, -3955},   {32528, -3958},   {32528, -3961},   {32527, -3964},
    {32527, -3967},   {32527, -3971},   {32526, -3974},   {32526, -3977},   {32525, -3980},   {32525, -3983},
    {32525, -3986},   {32524, -3989},   {32524, -3992},   {32523, -3996},   {32523, -3999},   {32523, -4002},
    {32522, -4005},   {32522, -4008},   {32522, -4011},   {32521, -4014},   {32521, -4017},   {32520, -4021},
    {32520, -4024},   {32520, -4027},   {32519, -4030},   {32519, -4033},   {32518, -4036},   {32518, -4039},
    {32518, -4042},   {32517, -4045},   {32517, -4049},   {32517, -4052},   {32516, -4055},   {32516, -4058},
    {32515, -4061},   {32515, -4064},   {32515, -4067},   {32514, -4070},   {32514, -4074},   {32513, -4077},
    {32513, -4080},   {32513, -4083},   {32512, -4086},   {32512, -4089},   {32511, -4092},   {32511, -4095},
    {32511, -4098},   {32510, -4102},   {32510, -4105},   {32510, -4108},   {32509, -4111},   {32509, -4114},
    {32508, -4117},   {32508, -4120},   {32508, -4123},   {32507, -4126},   {32507, -4130},   {32506, -4133},
    {32506, -4136},   {32506, -4139},   {32505, -4142},   {32505, -4145},   {32504, -4148},   {32504, -4151},
    {32504, -4155},   {32503, -4158},   {32503, -4161},   {32502, -4164},   {32502, -4167},   {32502, -4170},
    {32501, -4173},   {32501, -4176},   {32500, -4179},   {32500, -4183},   {32500, -4186},   {32499, -4189},
    {32499, -4192},   {32498, -4195},   {32498, -4198},   {32498, -4201},   {32497, -4204},   {32497, -4208},
    {32496, -4211},   {32496, -4214},   {32496, -4217},   {32495, -4220},   {32495, -4223},   {32494, -4226},
    {32494, -4229},   {32494, -4232},   {32493, -4236},   {32493, -4239},   {32492, -4242},   {32492, -4245},
    {32491, -4248},   {32491, -4251},   {32491, -4254},   {32490, -4257},   {32490, -4260},   {32489, -4264},
    {32489, -4267},   {32489, -4270},   {32488, -4273},   {32488, -4276},   {32487, -4279},   {32487, -4282},
    {32487, -4285},   {32486, -4289},   {32486, -4292},   {32485, -4295},   {32485, -4298},   {32485, -4301},
    {32484, -4304},   {32484, -4307},   {32483, -4310},   {32483, -4313},   {32482, -4317},   {32482, -4320},
    {32482, -4323},   {32481, -4326},   {32481, -4329},   {32480, -4332},   {32480, -4335},   {32480, -4338},
    {32479, -4341},   {32479, -4345},   {32478, -4348},   {32478, -4351},   {32477, -4354},   {32477, -4357},
    {32477, -4360},   {32476, -4363},   {32476, -4366},   {32475, -4369},   {32475, -4373},   {32475, -4376},
    {32474, -4379},   {32474, -4382},   {32473, -4385},   {32473, -4388},   {32472, -4391},   {32472, -4394},
    {32472, -4397},   {32471, -4401},   {32471, -4404},   {32470, -4407},   {32470, -4410},   {32469, -4413},
    {32469, -4416},   {32469, -4419},   {32468, -4422},   {32468, -4426},   {32467, -4429},   {32467, -4432},
    {32467, -4435},   {32466, -4438},   {32466, -4441},   {32465, -4444},   {32465, -4447},   {32464, -4450},
    {32464, -4454},   {32464, -4457},   {32463, -4460},   {32463, -4463},   {32462, -4466},   {32462, -4469},
    {32461, -4472},   {32461, -4475},   {32461, -4478},   {32460, -4482},   {32460, -4485},   {32459, -4488},
    {32459, -4491},   {32458, -4494},   {32458, -4497},   {32458, -4500},   {32457, -4503},   {32457, -4506},
    {32456, -4510},   {32456, -4513},   {32455, -4516},   {32455, -4519},   {32454, -4522},   {32454, -4525},
    {32454, -4528},   {32453, -4531},   {32453, -4534},   {32452, -4538},   {32452, -4541},   {32451, -4544},
    {32451, -4547},   {32451, -4550},   {32450, -4553},   {32450, -4556},   {32449, -4559},   {32449, -4562},
    {32448, -4566},   {32448, -4569},   {32448, -4572},   {32447, -4575},   {32447, -4578},   {32446, -4581},
    {32446, -4584},   {32445, -4587},   {32445, -4590},   {32444, -4594},   {32444, -4597},   {32444, -4600},
    {32443, -4603},   {32443, -4606},   {32442, -4609},   {32442, -4612},   {32441, -4615},   {32441, -4618},
    {32440, -4622},   {32440, -4625},   {32440, -4628},   {32439, -4631},   {32439, -4634},   {32438, -4637},
    {32438, -4640},   {32437, -4643},   {32437, -4646},   {32436, -4650},   {32436, -4653},   {32436, -4656},
    {32435, -4659},   {32435, -4662},   {32434, -4665},   {32434, -4668},   {32433, -4671},   {32433, -4674},
    {32432, -4678},   {32432, -4681},   {32432, -4684},   {32431, -4687},   {32431, -4690},   {32430, -4693},
    {32430, -4696},   {32429, -4699},   {32429, -4702},   {32428, -4705},   {32428, -4709},   {32427, -4712},
    {32427, -4715},   {32427, -4718},   {32426, -4721},   {32426, -4724},   {32425, -4727},   {32425, -4730},
    {32424, -4733},   {32424, -4737},   {32423, -4740},   {32423, -4743},   {32422, -4746},   {32422, -4749},
    {32422, -4752},   {32421, -4755},   {32421, -4758},   {32420, -4761},   {32420, -4765},   {32419, -4768},
    {32419, -4771},   {32418, -4774},   {32418, -4777},   {32417, -4780},   {32417, -4783},   {32417, -4786},
    {32416, -4789},   {32416, -4793},   {32415, -4796},   {32415, -4799},   {32414, -4802},   {32414, -4805},
    {32413, -4808},   {32413, -4811},   {32412, -4814},   {32412, -4817},   {32411, -4820},   {32411, -4824},
    {32411, -4827},   {32410, -4830},   {32410, -4833},   {32409, -4836},   {32409, -4839},   {32408, -4842},
    {32408, -4845},   {32407, -4848},   {32407, -4852},   {32406, -4855},   {32406, -4858},   {32405, -4861},
    {32405, -4864},   {32405, -4867},   {32404, -4870},   {32404, -4873},   {32403, -4876},   {32403, -4880},
    {32402, -4883},   {32402, -4886},   {32401, -4889},   {32401, -4892},   {32400, -4895},   {32400, -4898},
    {32399, -4901},   {32399, -4904},   {32398, -4907},   {32398, -4911},   {32397, -4914},   {32397, -4917},
    {32397, -4920},   {32396, -4923},   {32396, -4926},   {32395, -4929},   {32395, -4932},   {32394, -4935},
    {32394, -4939},   {32393, -4942},   {32393, -4945},   {32392, -4948},   {32392, -4951},   {32391, -4954},
    {32391, -4957},   {32390, -4960},   {32390, -4963},   {32389, -4966},   {32389, -4970},   {32388, -4973},
    {32388, -4976},   {32388, -4979},   {32387, -4982},   {32387, -4985},   {32386, -4988},   {32386, -4991},
    {32385, -4994},   {32385, -4998},   {32384, -5001},   {32384, -5004},   {32383, -5007},   {32383, -5010},
    {32382, -5013},   {32382, -5016},   {32381, -5019},   {32381, -5022},   {32380, -5025},   {32380, -5029},
    {32379, -5032},   {32379, -5035},   {32378, -5038},   {32378, -5041},   {32377, -5044},   {32377, -5047},
    {32376, -5050},   {32376, -5053},   {32376, -5057},   {32375, -5060},   {32375, -5063},   {32374, -5066},
    {32374, -5069},   {32373, -5072},   {32373, -5075},   {32372, -5078},   {32372, -5081},   {32371, -5084},
    {32371, -5088},   {32370, -5091},   {32370, -5094},   {32369, -5097},   {32369, -5100},   {32368, -5103},
    {32368, -5106},   {32367, -5109},   {32367, -5112},   {32366, -5115},   {32366, -5119},   {32365, -5122},
    {32365, -5125},   {32364, -5128},   {32364, -5131},   {32363, -5134},   {32363, -5137},   {32362, -5140},
    {32362, -5143},   {32361, -5147},   {32361, -5150},   {32360, -5153},   {32360, -5156},   {32359, -5159},
    {32359, -5162},   {32358, -5165},   {32358, -5168},   {32357, -5171},   {32357, -5174},   {32356, -5178},
    {32356, -5181},   {32355, -5184},   {32355, -5187},   {32354, -5190},   {32354, -5193},   {32353, -5196},
    {32353, -5199},   {32352, -5202},   {32352, -5205},   {32351, -5209},   {32351, -5212},   {32350, -5215},
    {32350, -5218},   {32349, -5221},   {32349, -5224},   {32348, -5227},   {32348, -5230},   {32347, -5233},
    {32347, -5236},   {32346, -5240},   {32346, -5243},   {32345, -5246},   {32345, -5249},   {32344, -5252},
    {32344, -5255},   {32343, -5258},   {32343, -5261},   {32342, -5264},   {32342, -5267},   {32341, -5271},
    {32341, -5274},   {32340, -5277},   {32340, -5280},   {32339, -5283},   {32339, -5286},   {32338, -5289},
    {32338, -5292},   {32337, -5295},   {32337, -5298},   {32336, -5302},   {32336, -5305},   {32335, -5308},
    {32335, -5311},   {32334, -5314},   {32334, -5317},   {32333, -5320},   {32333, -5323},   {32332, -5326},
    {32332, -5329},   {32331, -5333},   {32331, -5336},   {32330, -5339},   {32330, -5342},   {32329, -5345},
    {32329, -5348},   {32328, -5351},   {32328, -5354},   {32327, -5357},   {32327, -5360},   {32326, -5364},
    {32326, -5367},   {32325, -5370},   {32325, -5373},   {32324, -5376},   {32323, -5379},   {32323, -5382},
    {32322, -5385},   {32322, -5388},   {32321, -5391},   {32321, -5395},   {32320, -5398},   {32320, -5401},
    {32319, -5404},   {32319, -5407},   {32318, -5410},   {32318, -5413},   {32317, -5416},   {32317, -5419},
    {32316, -5422},   {32316, -5426},   {32315, -5429},   {32315, -5432},   {32314, -5435},   {32314, -5438},
    {32313, -5441},   {32313, -5444},   {32312, -5447},   {32312, -5450},   {32311, -5453},   {32310, -5457},
    {32310, -5460},   {32309, -5463},   {32309, -5466},   {32308, -5469},   {32308, -5472},   {32307, -5475},
    {32307, -5478},   {32306, -5481},   {32306, -5484},   {32305, -5488},   {32305, -5491},   {32304, -5494},
    {32304, -5497},   {32303, -5500},   {32303, -5503},   {32302, -5506},   {32302, -5509},   {32301, -5512},
    {32301, -5515},   {32300, -5518},   {32299, -5522},   {32299, -5525},   {32298, -5528},   {32298, -5531},
    {32297, -5534},   {32297, -5537},   {32296, -5540},   {32296, -5543},   {32295, -5546},   {32295, -5549},
    {32294, -5553},   {32294, -5556},   {32293, -5559},   {32293, -5562},   {32292, -5565},   {32291, -5568},
    {32291, -5571},   {32290, -5574},   {32290, -5577},   {32289, -5580},   {32289, -5584},   {32288, -5587},
    {32288, -5590},   {32287, -5593},   {32287, -5596},   {32286, -5599},   {32286, -5602},   {32285, -5605},
    {32285, -5608},   {32284, -5611},   {32283, -5614},   {32283, -5618},   {32282, -5621},   {32282, -5624},
    {32281, -5627},   {32281, -5630},   {32280, -5633},   {32280, -5636},   {32279, -5639},   {32279, -5642},
    {32278, -5645},   {32277, -5649},   {32277, -5652},   {32276, -5655},   {32276, -5658},   {32275, -5661},
    {32275, -5664},   {32274, -5667},   {32274, -5670},   {32273, -5673},   {32273, -5676},   {32272, -5679},
    {32272, -5683},   {32271, -5686},   {32270, -5689},   {32270, -5692},   {32269, -5695},   {32269, -5698},
    {32268, -5701},   {32268, -5704},   {32267, -5707},   {32267, -5710},   {32266, -5713},   {32266, -5717},
    {32265, -5720},   {32264, -5723},   {32264, -5726},   {32263, -5729},   {32263, -5732},   {32262, -5735},
    {32262, -5738},   {32261, -5741},   {32261, -5744},   {32260, -5748},   {32259, -5751},   {32259, -5754},
    {32258, -5757},   {32258, -5760},   {32257, -5763},   {32257, -5766},   {32256, -5769},   {32256, -5772},
    {32255, -5775},   {32254, -5778},   {32254, -5782},   {32253, -5785},   {32253, -5788},   {32252, -5791},
    {32252, -5794},   {32251, -5797},   {32251, -5800},   {32250, -5803},   {32249, -5806},   {32249, -5809},
    {32248, -5812},   {32248, -5816},   {32247, -5819},   {32247, -5822},   {32246, -5825},   {32246, -5828},
    {32245, -5831},   {32244, -5834},   {32244, -5837},   {32243, -5840},   {32243, -5843},   {32242, -5846},
    {32242, -5850},   {32241, -5853},   {32241, -5856},   {32240, -5859},   {32239, -5862},   {32239, -5865},
    {32238, -5868},   {32238, -5871},   {32237, -5874},   {32237, -5877},   {32236, -5880},   {32235, -5884},
    {32235, -5887},   {32234, -5890},   {32234, -5893},   {32233, -5896},   {32233, -5899},   {32232, -5902},
    {32232, -5905},   {32231, -5908},   {32230, -5911},   {32230, -5914},   {32229, -5918},   {32229, -5921},
    {32228, -5924},   {32228, -5927},   {32227, -5930},   {32226, -5933},   {32226, -5936},   {32225, -5939},
    {32225, -5942},   {32224, -5945},   {32224, -5948},   {32223, -5952},   {32222, -5955},   {32222, -5958},
    {32221, -5961},   {32221, -5964},   {32220, -5967},   {32220, -5970},   {32219, -5973},   {32218, -5976},
    {32218, -5979},   {32217, -5982},   {32217, -5985},   {32216, -5989},   {32216, -5992},   {32215, -5995},
    {32214, -5998},   {32214, -6001},   {32213, -6004},   {32213, -6007},   {32212, -6010},   {32212, -6013},
    {32211, -6016},   {32210, -6019},   {32210, -6023},   {32209, -6026},   {32209, -6029},   {32208, -6032},
    {32207, -6035},   {32207, -6038},   {32206, -6041},   {32206, -6044},   {32205, -6047},   {32205, -6050},
    {32204, -6053},   {32203, -6057},   {32203, -6060},   {32202, -6063},   {32202, -6066},   {32201, -6069},
    {32201, -6072},   {32200, -6075},   {32199, -6078},   {32199, -6081},   {32198, -6084},   {32198, -6087},
    {32197, -6090},   {32196, -6094},   {32196, -6097},   {32195, -6100},   {32195, -6103},   {32194, -6106},
    {32194, -6109},   {32193, -6112},   {32192, -6115},   {32192, -6118},   {32191, -6121},   {32191, -6124},
    {32190, -6128},   {32189, -6131},   {32189, -6134},   {32188, -6137},   {32188, -6140},   {32187, -6143},
    {32186, -6146},   {32186, -6149},   {32185, -6152},   {32185, -6155},   {32184, -6158},   {32184, -6161},
    {32183, -6165},   {32182, -6168},   {32182, -6171},   {32181, -6174},   {32181, -6177},   {32180, -6180},
    {32179, -6183},   {32179, -6186},   {32178, -6189},   {32178, -6192},   {32177, -6195},   {32176, -6198},
    {32176, -6202},   {32175, -6205},   {32175, -6208},   {32174, -6211},   {32173, -6214},   {32173, -6217},
    {32172, -6220},   {32172, -6223},   {32171, -6226},   {32170, -6229},   {32170, -6232},   {32169, -6236},
    {32169, -6239},   {32168, -6242},   {32167, -6245},   {32167, -6248},   {32166, -6251},   {32166, -6254},
    {32165, -6257},   {32164, -6260},   {32164, -6263},   {32163, -6266},   {32163, -6269},   {32162, -6273},
    {32161, -6276},   {32161, -6279},   {32160, -6282},   {32160, -6285},   {32159, -6288},   {32158, -6291},
    {32158, -6294},   {32157, -6297},   {32157, -6300},   {32156, -6303},   {32155, -6306},   {32155, -6310},
    {32154, -6313},   {32154, -6316},   {32153, -6319},   {32152, -6322},   {32152, -6325},   {32151, -6328},
    {32151, -6331},   {32150, -6334},   {32149, -6337},   {32149, -6340},   {32148, -6343},   {32148, -6346},
    {32147, -6350},   {32146, -6353},   {32146, -6356},   {32145, -6359},   {32144, -6362},   {32144, -6365},
    {32143, -6368},   {32143, -6371},   {32142, -6374},   {32141, -6377},   {32141, -6380},   {32140, -6383},
    {32140, -6387},   {32139, -6390},   {32138, -6393},   {32138, -6396},   {32137, -6399},   {32137, -6402},
    {32136, -6405},   {32135, -6408},   {32135, -6411},   {32134, -6414},   {32133, -6417},   {32133, -6420},
    {32132, -6424},   {32132, -6427},   {32131, -6430},   {32130, -6433},   {32130, -6436},   {32129, -6439},
    {32129, -6442},   {32128, -6445},   {32127, -6448},   {32127, -6451},   {32126, -6454},   {32125, -6457},
    {32125, -6460},   {32124, -6464},   {32124, -6467},   {32123, -6470},   {32122, -6473},   {32122, -6476},
    {32121, -6479},   {32120, -6482},   {32120, -6485},   {32119, -6488},   {32119, -6491},   {32118, -6494},
    {32117, -6497},   {32117, -6501},   {32116, -6504},   {32115, -6507},   {32115, -6510},   {32114, -6513},
    {32114, -6516},   {32113, -6519},   {32112, -6522},   {32112, -6525},   {32111, -6528},   {32110, -6531},
    {32110, -6534},   {32109, -6537},   {32109, -6541},   {32108, -6544},   {32107, -6547},   {32107, -6550},
    {32106, -6553},   {32105, -6556},   {32105, -6559},   {32104, -6562},   {32104, -6565},   {32103, -6568},
    {32102, -6571},   {32102, -6574},   {32101, -6577},   {32100, -6581},   {32100, -6584},   {32099, -6587},
    {32099, -6590},   {32098, -6593},   {32097, -6596},   {32097, -6599},   {32096, -6602},   {32095, -6605},
    {32095, -6608},   {32094, -6611},   {32093, -6614},   {32093, -6617},   {32092, -6621},   {32092, -6624},
    {32091, -6627},   {32090, -6630},   {32090, -6633},   {32089, -6636},   {32088, -6639},   {32088, -6642},
    {32087, -6645},   {32086, -6648},   {32086, -6651},   {32085, -6654},   {32085, -6657},   {32084, -6661},
    {32083, -6664},   {32083, -6667},   {32082, -6670},   {32081, -6673},   {32081, -6676},   {32080, -6679},
    {32079, -6682},   {32079, -6685},   {32078, -6688},   {32078, -6691},   {32077, -6694},   {32076, -6697},
    {32076, -6701},   {32075, -6704},   {32074, -6707},   {32074, -6710},   {32073, -6713},   {32072, -6716},
    {32072, -6719},   {32071, -6722},   {32070, -6725},   {32070, -6728},   {32069, -6731},   {32069, -6734},
    {32068, -6737},   {32067, -6741},   {32067, -6744},   {32066, -6747},   {32065, -6750},   {32065, -6753},
    {32064, -6756},   {32063, -6759},   {32063, -6762},   {32062, -6765},   {32061, -6768},   {32061, -6771},
    {32060, -6774},   {32059, -6777},   {32059, -6780},   {32058, -6784},   {32058, -6787},   {32057, -6790},
    {32056, -6793},   {32056, -6796},   {32055, -6799},   {32054, -6802},   {32054, -6805},   {32053, -6808},
    {32052, -6811},   {32052, -6814},   {32051, -6817},   {32050, -6820},   {32050, -6824},   {32049, -6827},
    {32048, -6830},   {32048, -6833},   {32047, -6836},   {32046, -6839},   {32046, -6842},   {32045, -6845},
    {32044, -6848},   {32044, -6851},   {32043, -6854},   {32042, -6857},   {32042, -6860},   {32041, -6863},
    {32040, -6867},   {32040, -6870},   {32039, -6873},   {32039, -6876},   {32038, -6879},   {32037, -6882},
    {32037, -6885},   {32036, -6888},   {32035, -6891},   {32035, -6894},   {32034, -6897},   {32033, -6900},
    {32033, -6903},   {32032, -6906},   {32031, -6910},   {32031, -6913},   {32030, -6916},   {32029, -6919},
    {32029, -6922},   {32028, -6925},   {32027, -6928},   {32027, -6931},   {32026, -6934},   {32025, -6937},
    {32025, -6940},   {32024, -6943},   {32023, -6946},   {32023, -6949},   {32022, -6953},   {32021, -6956},
    {32021, -6959},   {32020, -6962},   {32019, -6965},   {32019, -6968},   {32018, -6971},   {32017, -6974},
    {32017, -6977},   {32016, -6980},   {32015, -6983},   {32015, -6986},   {32014, -6989},   {32013, -6992},
    {32013, -6995},   {32012, -6999},   {32011, -7002},   {32011, -7005},   {32010, -7008},   {32009, -7011},
    {32009, -7014},   {32008, -7017},   {32007, -7020},   {32007, -7023},   {32006, -7026},   {32005, -7029},
    {32005, -7032},   {32004, -7035},   {32003, -7038},   {32002, -7042},   {32002, -7045},   {32001, -7048},
    {32000, -7051},   {32000, -7054},   {31999, -7057},   {31998, -7060},   {31998, -7063},   {31997, -7066},
    {31996, -7069},   {31996, -7072},   {31995, -7075},   {31994, -7078},   {31994, -7081},   {31993, -7084},
    {31992, -7088},   {31992, -7091},   {31991, -7094},   {31990, -7097},   {31990, -7100},   {31989, -7103},
    {31988, -7106},   {31988, -7109},   {31987, -7112},   {31986, -7115},   {31986, -7118},   {31985, -7121},
    {31984, -7124},   {31983, -7127},   {31983, -7130},   {31982, -7134},   {31981, -7137},   {31981, -7140},
    {31980, -7143},   {31979, -7146},   {31979, -7149},   {31978, -7152},   {31977, -7155},   {31977, -7158},
    {31976, -7161},   {31975, -7164},   {31975, -7167},   {31974, -7170},   {31973, -7173},   {31972, -7176},
    {31972, -7180},   {31971, -7183},   {31970, -7186},   {31970, -7189},   {31969, -7192},   {31968, -7195},
    {31968, -7198},   {31967, -7201},   {31966, -7204},   {31966, -7207},   {31965, -7210},   {31964, -7213},
    {31964, -7216},   {31963, -7219},   {31962, -7222},   {31961, -7225},   {31961, -7229},   {31960, -7232},
    {31959, -7235},   {31959, -7238},   {31958, -7241},   {31957, -7244},   {31957, -7247},   {31956, -7250},
    {31955, -7253},   {31955, -7256},   {31954, -7259},   {31953, -7262},   {31952, -7265},   {31952, -7268},
    {31951, -7271},   {31950, -7275},   {31950, -7278},   {31949, -7281},   {31948, -7284},   {31948, -7287},
    {31947, -7290},   {31946, -7293},   {31945, -7296},   {31945, -7299},   {31944, -7302},   {31943, -7305},
    {31943, -7308},   {31942, -7311},   {31941, -7314},   {31941, -7317},   {31940, -7320},   {31939, -7324},
    {31938, -7327},   {31938, -7330},   {31937, -7333},   {31936, -7336},   {31936, -7339},   {31935, -7342},
    {31934, -7345},   {31934, -7348},   {31933, -7351},   {31932, -7354},   {31931, -7357},   {31931, -7360},
    {31930, -7363},   {31929, -7366},   {31929, -7369},   {31928, -7372},   {31927, -7376},   {31926, -7379},
    {31926, -7382},   {31925, -7385},   {31924, -7388},   {31924, -7391},   {31923, -7394},   {31922, -7397},
    {31921, -7400},   {31921, -7403},   {31920, -7406},   {31919, -7409},   {31919, -7412},   {31918, -7415},
    {31917, -7418},   {31917, -7421},   {31916, -7425},   {31915, -7428},   {31914, -7431},   {31914, -7434},
    {31913, -7437},   {31912, -7440},   {31912, -7443},   {31911, -7446},   {31910, -7449},   {31909, -7452},
    {31909, -7455},   {31908, -7458},   {31907, -7461},   {31907, -7464},   {31906, -7467},   {31905, -7470},
    {31904, -7473},   {31904, -7477},   {31903, -7480},   {31902, -7483},   {31902, -7486},   {31901, -7489},
    {31900, -7492},   {31899, -7495},   {31899, -7498},   {31898, -7501},   {31897, -7504},   {31896, -7507},
    {31896, -7510},   {31895, -7513},   {31894, -7516},   {31894, -7519},   {31893, -7522},   {31892, -7525},
    {31891, -7529},   {31891, -7532},   {31890, -7535},   {31889, -7538},   {31889, -7541},   {31888, -7544},
    {31887, -7547},   {31886, -7550},   {31886, -7553},   {31885, -7556},   {31884, -7559},   {31883, -7562},
    {31883, -7565},   {31882, -7568},   {31881, -7571},   {31881, -7574},   {31880, -7577},   {31879, -7580},
    {31878, -7584},   {31878, -7587},   {31877, -7590},   {31876, -7593},   {31875, -7596},   {31875, -7599},
    {31874, -7602},   {31873, -7605},   {31873, -7608},   {31872, -7611},   {31871, -7614},   {31870, -7617},
    {31870, -7620},   {31869, -7623},   {31868, -7626},   {31867, -7629},   {31867, -7632},   {31866, -7635},
    {31865, -7639},   {31865, -7642},   {31864, -7645},   {31863, -7648},   {31862, -7651},   {31862, -7654},
    {31861, -7657},   {31860, -7660},   {31859, -7663},   {31859, -7666},   {31858, -7669},   {31857, -7672},
    {31856, -7675},   {31856, -7678},   {31855, -7681},   {31854, -7684},   {31854, -7687},   {31853, -7690},
    {31852, -7694},   {31851, -7697},   {31851, -7700},   {31850, -7703},   {31849, -7706},   {31848, -7709},
    {31848, -7712},   {31847, -7715},   {31846, -7718},   {31845, -7721},   {31845, -7724},   {31844, -7727},
    {31843, -7730},   {31842, -7733},   {31842, -7736},   {31841, -7739},   {31840, -7742},   {31839, -7745},
    {31839, -7748},   {31838, -7752},   {31837, -7755},   {31836, -7758},   {31836, -7761},   {31835, -7764},
    {31834, -7767},   {31833, -7770},   {31833, -7773},   {31832, -7776},   {31831, -7779},   {31831, -7782},
    {31830, -7785},   {31829, -7788},   {31828, -7791},   {31828, -7794},   {31827, -7797},   {31826, -7800},
    {31825, -7803},   {31825, -7806},   {31824, -7810},   {31823, -7813},   {31822, -7816},   {31822, -7819},
    {31821, -7822},   {31820, -7825},   {31819, -7828},   {31819, -7831},   {31818, -7834},   {31817, -7837},
    {31816, -7840},   {31816, -7843},   {31815, -7846},   {31814, -7849},   {31813, -7852},   {31813, -7855},
    {31812, -7858},   {31811, -7861},   {31810, -7864},   {31810, -7867},   {31809, -7871},   {31808, -7874},
    {31807, -7877},   {31806, -7880},   {31806, -7883},   {31805, -7886},   {31804, -7889},   {31803, -7892},
    {31803, -7895},   {31802, -7898},   {31801, -7901},   {31800, -7904},   {31800, -7907},   {31799, -7910},
    {31798, -7913},   {31797, -7916},   {31797, -7919},   {31796, -7922},   {31795, -7925},   {31794, -7928},
    {31794, -7931},   {31793, -7935},   {31792, -7938},   {31791, -7941},   {31791, -7944},   {31790, -7947},
    {31789, -7950},   {31788, -7953},   {31788, -7956},   {31787, -7959},   {31786, -7962},   {31785, -7965},
    {31784, -7968},   {31784, -7971},   {31783, -7974},   {31782, -7977},   {31781, -7980},   {31781, -7983},
    {31780, -7986},   {31779, -7989},   {31778, -7992},   {31778, -7995},   {31777, -7999},   {31776, -8002},
    {31775, -8005},   {31775, -8008},   {31774, -8011},   {31773, -8014},   {31772, -8017},   {31771, -8020},
    {31771, -8023},   {31770, -8026},   {31769, -8029},   {31768, -8032},   {31768, -8035},   {31767, -8038},
    {31766, -8041},   {31765, -8044},   {31764, -8047},   {31764, -8050},   {31763, -8053},   {31762, -8056},
    {31761, -8059},   {31761, -8063},   {31760, -8066},   {31759, -8069},   {31758, -8072},   {31758, -8075},
    {31757, -8078},   {31756, -8081},   {31755, -8084},   {31754, -8087},   {31754, -8090},   {31753, -8093},
    {31752, -8096},   {31751, -8099},   {31751, -8102},   {31750, -8105},   {31749, -8108},   {31748, -8111},
    {31747, -8114},   {31747, -8117},   {31746, -8120},   {31745, -8123},   {31744, -8126},   {31744, -8129},
    {31743, -8133},   {31742, -8136},   {31741, -8139},   {31740, -8142},   {31740, -8145},   {31739, -8148},
    {31738, -8151},   {31737, -8154},   {31737, -8157},   {31736, -8160},   {31735, -8163},   {31734, -8166},
    {31733, -8169},   {31733, -8172},   {31732, -8175},   {31731, -8178},   {31730, -8181},   {31729, -8184},
    {31729, -8187},   {31728, -8190},   {31727, -8193},   {31726, -8196},   {31726, -8199},   {31725, -8202},
    {31724, -8206},   {31723, -8209},   {31722, -8212},   {31722, -8215},   {31721, -8218},   {31720, -8221},
    {31719, -8224},   {31718, -8227},   {31718, -8230},   {31717, -8233},   {31716, -8236},   {31715, -8239},
    {31715, -8242},   {31714, -8245},   {31713, -8248},   {31712, -8251},   {31711, -8254},   {31711, -8257},
    {31710, -8260},   {31709, -8263},   {31708, -8266},   {31707, -8269},   {31707, -8272},   {31706, -8275},
    {31705, -8279},   {31704, -8282},   {31703, -8285},   {31703, -8288},   {31702, -8291},   {31701, -8294},
    {31700, -8297},   {31699, -8300},   {31699, -8303},   {31698, -8306},   {31697, -8309},   {31696, -8312},
    {31695, -8315},   {31695, -8318},   {31694, -8321},   {31693, -8324},   {31692, -8327},   {31691, -8330},
    {31691, -8333},   {31690, -8336},   {31689, -8339},   {31688, -8342},   {31687, -8345},   {31687, -8348},
    {31686, -8351},   {31685, -8354},   {31684, -8358},   {31683, -8361},   {31683, -8364},   {31682, -8367},
    {31681, -8370},   {31680, -8373},   {31679, -8376},   {31679, -8379},   {31678, -8382},   {31677, -8385},
    {31676, -8388},   {31675, -8391},   {31675, -8394},   {31674, -8397},   {31673, -8400},   {31672, -8403},
    {31671, -8406},   {31671, -8409},   {31670, -8412},   {31669, -8415},   {31668, -8418},   {31667, -8421},
    {31667, -8424},   {31666, -8427},   {31665, -8430},   {31664, -8433},   {31663, -8436},   {31663, -8440},
    {31662, -8443},   {31661, -8446},   {31660, -8449},   {31659, -8452},   {31658, -8455},   {31658, -8458},
    {31657, -8461},   {31656, -8464},   {31655, -8467},   {31654, -8470},   {31654, -8473},   {31653, -8476},
    {31652, -8479},   {31651, -8482},   {31650, -8485},   {31650, -8488},   {31649, -8491},   {31648, -8494},
    {31647, -8497},   {31646, -8500},   {31645, -8503},   {31645, -8506},   {31644, -8509},   {31643, -8512},
    {31642, -8515},   {31641, -8518},   {31641, -8521},   {31640, -8524},   {31639, -8528},   {31638, -8531},
    {31637, -8534},   {31637, -8537},   {31636, -8540},   {31635, -8543},   {31634, -8546},   {31633, -8549},
    {31632, -8552},   {31632, -8555},   {31631, -8558},   {31630, -8561},   {31629, -8564},   {31628, -8567},
    {31627, -8570},   {31627, -8573},   {31626, -8576},   {31625, -8579},   {31624, -8582},   {31623, -8585},
    {31623, -8588},   {31622, -8591},   {31621, -8594},   {31620, -8597},   {31619, -8600},   {31618, -8603},
    {31618, -8606},   {31617, -8609},   {31616, -8612},   {31615, -8615},   {31614, -8618},   {31613, -8621},
    {31613, -8625},   {31612, -8628},   {31611, -8631},   {31610, -8634},   {31609, -8637},   {31609, -8640},
    {31608, -8643},   {31607, -8646},   {31606, -8649},   {31605, -8652},   {31604, -8655},   {31604, -8658},
    {31603, -8661},   {31602, -8664},   {31601, -8667},   {31600, -8670},   {31599, -8673},   {31599, -8676},
    {31598, -8679},   {31597, -8682},   {31596, -8685},   {31595, -8688},   {31594, -8691},   {31594, -8694},
    {31593, -8697},   {31592, -8700},   {31591, -8703},   {31590, -8706},   {31589, -8709},   {31589, -8712},
    {31588, -8715},   {31587, -8718},   {31586, -8721},   {31585, -8725},   {31584, -8728},   {31584, -8731},
    {31583, -8734},   {31582, -8737},   {31581, -8740},   {31580, -8743},   {31579, -8746},   {31578, -8749},
    {31578, -8752},   {31577, -8755},   {31576, -8758},   {31575, -8761},   {31574, -8764},   {31573, -8767},
    {31573, -8770},   {31572, -8773},   {31571, -8776},   {31570, -8779},   {31569, -8782},   {31568, -8785},
    {31568, -8788},   {31567, -8791},   {31566, -8794},   {31565, -8797},   {31564, -8800},   {31563, -8803},
    {31563, -8806},   {31562, -8809},   {31561, -8812},   {31560, -8815},   {31559, -8818},   {31558, -8821},
    {31557, -8824},   {31557, -8827},   {31556, -8830},   {31555, -8833},   {31554, -8836},   {31553, -8840},
    {31552, -8843},   {31552, -8846},   {31551, -8849},   {31550, -8852},   {31549, -8855},   {31548, -8858},
    {31547, -8861},   {31546, -8864},   {31546, -8867},   {31545, -8870},   {31544, -8873},   {31543, -8876},
    {31542, -8879},   {31541, -8882},   {31540, -8885},   {31540, -8888},   {31539, -8891},   {31538, -8894},
    {31537, -8897},   {31536, -8900},   {31535, -8903},   {31534, -8906},   {31534, -8909},   {31533, -8912},
    {31532, -8915},   {31531, -8918},   {31530, -8921},   {31529, -8924},   {31529, -8927},   {31528, -8930},
    {31527, -8933},   {31526, -8936},   {31525, -8939},   {31524, -8942},   {31523, -8945},   {31523, -8948},
    {31522, -8951},   {31521, -8954},   {31520, -8957},   {31519, -8960},   {31518, -8963},   {31517, -8967},
    {31516, -8970},   {31516, -8973},   {31515, -8976},   {31514, -8979},   {31513, -8982},   {31512, -8985},
    {31511, -8988},   {31510, -8991},   {31510, -8994},   {31509, -8997},   {31508, -9000},   {31507, -9003},
    {31506, -9006},   {31505, -9009},   {31504, -9012},   {31504, -9015},   {31503, -9018},   {31502, -9021},
    {31501, -9024},   {31500, -9027},   {31499, -9030},   {31498, -9033},   {31498, -9036},   {31497, -9039},
    {31496, -9042},   {31495, -9045},   {31494, -9048},   {31493, -9051},   {31492, -9054},   {31491, -9057},
    {31491, -9060},   {31490, -9063},   {31489, -9066},   {31488, -9069},   {31487, -9072},   {31486, -9075},
    {31485, -9078},   {31484, -9081},   {31484, -9084},   {31483, -9087},   {31482, -9090},   {31481, -9093},
    {31480, -9096},   {31479, -9099},   {31478, -9102},   {31478, -9105},   {31477, -9108},   {31476, -9111},
    {31475, -9114},   {31474, -9117},   {31473, -9120},   {31472, -9124},   {31471, -9127},   {31471, -9130},
    {31470, -9133},   {31469, -9136},   {31468, -9139},   {31467, -9142},   {31466, -9145},   {31465, -9148},
    {31464, -9151},   {31464, -9154},   {31463, -9157},   {31462, -9160},   {31461, -9163},   {31460, -9166},
    {31459, -9169},   {31458, -9172},   {31457, -9175},   {31456, -9178},   {31456, -9181},   {31455, -9184},
    {31454, -9187},   {31453, -9190},   {31452, -9193},   {31451, -9196},   {31450, -9199},   {31449, -9202},
    {31449, -9205},   {31448, -9208},   {31447, -9211},   {31446, -9214},   {31445, -9217},   {31444, -9220},
    {31443, -9223},   {31442, -9226},   {31441, -9229},   {31441, -9232},   {31440, -9235},   {31439, -9238},
    {31438, -9241},   {31437, -9244},   {31436, -9247},   {31435, -9250},   {31434, -9253},   {31433, -9256},
    {31433, -9259},   {31432, -9262},   {31431, -9265},   {31430, -9268},   {31429, -9271},   {31428, -9274},
    {31427, -9277},   {31426, -9280},   {31425, -9283},   {31425, -9286},   {31424, -9289},   {31423, -9292},
    {31422, -9295},   {31421, -9298},   {31420, -9301},   {31419, -9304},   {31418, -9307},   {31417, -9310},
    {31417, -9313},   {31416, -9316},   {31415, -9319},   {31414, -9322},   {31413, -9325},   {31412, -9329},
    {31411, -9332},   {31410, -9335},   {31409, -9338},   {31409, -9341},   {31408, -9344},   {31407, -9347},
    {31406, -9350},   {31405, -9353},   {31404, -9356},   {31403, -9359},   {31402, -9362},   {31401, -9365},
    {31400, -9368},   {31400, -9371},   {31399, -9374},   {31398, -9377},   {31397, -9380},   {31396, -9383},
    {31395, -9386},   {31394, -9389},   {31393, -9392},   {31392, -9395},   {31391, -9398},   {31391, -9401},
    {31390, -9404},   {31389, -9407},   {31388, -9410},   {31387, -9413},   {31386, -9416},   {31385, -9419},
    {31384, -9422},   {31383, -9425},   {31382, -9428},   {31382, -9431},   {31381, -9434},   {31380, -9437},
    {31379, -9440},   {31378, -9443},   {31377, -9446},   {31376, -9449},   {31375, -9452},   {31374, -9455},
    {31373, -9458},   {31372, -9461},   {31372, -9464},   {31371, -9467},   {31370, -9470},   {31369, -9473},
    {31368, -9476},   {31367, -9479},   {31366, -9482},   {31365, -9485},   {31364, -9488},   {31363, -9491},
    {31362, -9494},   {31362, -9497},   {31361, -9500},   {31360, -9503},   {31359, -9506},   {31358, -9509},
    {31357, -9512},   {31356, -9515},   {31355, -9518},   {31354, -9521},   {31353, -9524},   {31352, -9527},
    {31352, -9530},   {31351, -9533},   {31350, -9536},   {31349, -9539},   {31348, -9542},   {31347, -9545},
    {31346, -9548},   {31345, -9551},   {31344, -9554},   {31343, -9557},   {31342, -9560},   {31341, -9563},
    {31341, -9566},   {31340, -9569},   {31339, -9572},   {31338, -9575},   {31337, -9578},   {31336, -9581},
    {31335, -9584},   {31334, -9587},   {31333, -9590},   {31332, -9593},   {31331, -9596},   {31330, -9599},
    {31330, -9602},   {31329, -9605},   {31328, -9608},   {31327, -9611},   {31326, -9614},   {31325, -9617},
    {31324, -9620},   {31323, -9623},   {31322, -9626},   {31321, -9629},   {31320, -9632},   {31319, -9635},
    {31318, -9638},   {31318, -9641},   {31317, -9644},   {31316, -9647},   {31315, -9650},   {31314, -9653},
    {31313, -9656},   {31312, -9659},   {31311, -9662},   {31310, -9665},   {31309, -9668},   {31308, -9671},
    {31307, -9674},   {31306, -9677},   {31305, -9680},   {31305, -9683},   {31304, -9686},   {31303, -9689},
    {31302, -9692},   {31301, -9695},   {31300, -9698},   {31299, -9701},   {31298, -9704},   {31297, -9707},
    {31296, -9710},   {31295, -9713},   {31294, -9716},   {31293, -9719},   {31292, -9722},   {31292, -9725},
    {31291, -9728},   {31290, -9731},   {31289, -9734},   {31288, -9737},   {31287, -9740},   {31286, -9743},
    {31285, -9746},   {31284, -9749},   {31283, -9752},   {31282, -9755},   {31281, -9758},   {31280, -9761},
    {31279, -9764},   {31278, -9767},   {31278, -9770},   {31277, -9773},   {31276, -9776},   {31275, -9779},
    {31274, -9782},   {31273, -9785},   {31272, -9788},   {31271, -9791},   {31270, -9794},   {31269, -9797},
    {31268, -9800},   {31267, -9803},   {31266, -9806},   {31265, -9809},   {31264, -9812},   {31263, -9815},
    {31263, -9818},   {31262, -9821},   {31261, -9824},   {31260, -9827},   {31259, -9830},   {31258, -9833},
    {31257, -9836},   {31256, -9839},   {31255, -9842},   {31254, -9845},   {31253, -9848},   {31252, -9851},
    {31251, -9854},   {31250, -9857},   {31249, -9860},   {31248, -9863},   {31247, -9866},   {31246, -9869},
    {31246, -9872},   {31245, -9875},   {31244, -9878},   {31243, -9881},   {31242, -9884},   {31241, -9887},
    {31240, -9890},   {31239, -9893},   {31238, -9896},   {31237, -9899},   {31236, -9902},   {31235, -9905},
    {31234, -9908},   {31233, -9911},   {31232, -9914},   {31231, -9917},   {31230, -9920},   {31229, -9923},
    {31228, -9926},   {31227, -9929},   {31227, -9932},   {31226, -9935},   {31225, -9938},   {31224, -9941},
    {31223, -9944},   {31222, -9947},   {31221, -9950},   {31220, -9953},   {31219, -9956},   {31218, -9959},
    {31217, -9962},   {31216, -9965},   {31215, -9968},   {31214, -9971},   {31213, -9974},   {31212, -9977},
    {31211, -9980},   {31210, -9983},   {31209, -9986},   {31208, -9989},   {31207, -9992},   {31206, -9995},
    {31206, -9998},   {31205, -10001},  {31204, -10004},  {31203, -10007},  {31202, -10010},  {31201, -10013},
    {31200, -10016},  {31199, -10019},  {31198, -10022},  {31197, -10025},  {31196, -10028},  {31195, -10031},
    {31194, -10034},  {31193, -10037},  {31192, -10040},  {31191, -10043},  {31190, -10046},  {31189, -10049},
    {31188, -10052},  {31187, -10055},  {31186, -10058},  {31185, -10061},  {31184, -10064},  {31183, -10067},
    {31182, -10070},  {31181, -10073},  {31180, -10076},  {31180, -10079},  {31179, -10082},  {31178, -10085},
    {31177, -10088},  {31176, -10091},  {31175, -10094},  {31174, -10097},  {31173, -10100},  {31172, -10103},
    {31171, -10106},  {31170, -10109},  {31169, -10112},  {31168, -10115},  {31167, -10118},  {31166, -10120},
    {31165, -10123},  {31164, -10126},  {31163, -10129},  {31162, -10132},  {31161, -10135},  {31160, -10138},
    {31159, -10141},  {31158, -10144},  {31157, -10147},  {31156, -10150},  {31155, -10153},  {31154, -10156},
    {31153, -10159},  {31152, -10162},  {31151, -10165},  {31150, -10168},  {31149, -10171},  {31148, -10174},
    {31147, -10177},  {31147, -10180},  {31146, -10183},  {31145, -10186},  {31144, -10189},  {31143, -10192},
    {31142, -10195},  {31141, -10198},  {31140, -10201},  {31139, -10204},  {31138, -10207},  {31137, -10210},
    {31136, -10213},  {31135, -10216},  {31134, -10219},  {31133, -10222},  {31132, -10225},  {31131, -10228},
    {31130, -10231},  {31129, -10234},  {31128, -10237},  {31127, -10240},  {31126, -10243},  {31125, -10246},
    {31124, -10249},  {31123, -10252},  {31122, -10255},  {31121, -10258},  {31120, -10261},  {31119, -10264},
    {31118, -10267},  {31117, -10270},  {31116, -10273},  {31115, -10276},  {31114, -10279},  {31113, -10282},
    {31112, -10285},  {31111, -10288},  {31110, -10291},  {31109, -10294},  {31108, -10297},  {31107, -10300},
    {31106, -10303},  {31105, -10306},  {31104, -10309},  {31103, -10312},  {31102, -10315},  {31101, -10317},
    {31100, -10320},  {31099, -10323},  {31098, -10326},  {31097, -10329},  {31096, -10332},  {31095, -10335},
    {31094, -10338},  {31093, -10341},  {31092, -10344},  {31091, -10347},  {31090, -10350},  {31089, -10353},
    {31088, -10356},  {31087, -10359},  {31086, -10362},  {31085, -10365},  {31084, -10368},  {31083, -10371},
    {31082, -10374},  {31081, -10377},  {31080, -10380},  {31079, -10383},  {31078, -10386},  {31077, -10389},
    {31076, -10392},  {31075, -10395},  {31074, -10398},  {31073, -10401},  {31072, -10404},  {31072, -10407},
    {31071, -10410},  {31070, -10413},  {31069, -10416},  {31068, -10419},  {31067, -10422},  {31066, -10425},
    {31065, -10428},  {31064, -10431},  {31063, -10434},  {31062, -10437},  {31061, -10440},  {31060, -10443},
    {31059, -10446},  {31058, -10449},  {31057, -10452},  {31055, -10455},  {31054, -10458},  {31053, -10461},
    {31052, -10463},  {31051, -10466},  {31050, -10469},  {31049, -10472},  {31048, -10475},  {31047, -10478},
    {31046, -10481},  {31045, -10484},  {31044, -10487},  {31043, -10490},  {31042, -10493},  {31041, -10496},
    {31040, -10499},  {31039, -10502},  {31038, -10505},  {31037, -10508},  {31036, -10511},  {31035, -10514},
    {31034, -10517},  {31033, -10520},  {31032, -10523},  {31031, -10526},  {31030, -10529},  {31029, -10532},
    {31028, -10535},  {31027, -10538},  {31026, -10541},  {31025, -10544},  {31024, -10547},  {31023, -10550},
    {31022, -10553},  {31021, -10556},  {31020, -10559},  {31019, -10562},  {31018, -10565},  {31017, -10568},
    {31016, -10571},  {31015, -10574},  {31014, -10577},  {31013, -10580},  {31012, -10582},  {31011, -10585},
    {31010, -10588},  {31009, -10591},  {31008, -10594},  {31007, -10597},  {31006, -10600},  {31005, -10603},
    {31004, -10606},  {31003, -10609},  {31002, -10612},  {31001, -10615},  {31000, -10618},  {30999, -10621},
    {30998, -10624},  {30997, -10627},  {30996, -10630},  {30995, -10633},  {30994, -10636},  {30993, -10639},
    {30992, -10642},  {30991, -10645},  {30990, -10648},  {30989, -10651},  {30988, -10654},  {30987, -10657},
    {30986, -10660},  {30985, -10663},  {30984, -10666},  {30983, -10669},  {30982, -10672},  {30981, -10675},
    {30980, -10678},  {30978, -10681},  {30977, -10684},  {30976, -10687},  {30975, -10689},  {30974, -10692},
    {30973, -10695},  {30972, -10698},  {30971, -10701},  {30970, -10704},  {30969, -10707},  {30968, -10710},
    {30967, -10713},  {30966, -10716},  {30965, -10719},  {30964, -10722},  {30963, -10725},  {30962, -10728},
    {30961, -10731},  {30960, -10734},  {30959, -10737},  {30958, -10740},  {30957, -10743},  {30956, -10746},
    {30955, -10749},  {30954, -10752},  {30953, -10755},  {30952, -10758},  {30951, -10761},  {30950, -10764},
    {30949, -10767},  {30948, -10770},  {30947, -10773},  {30946, -10776},  {30945, -10779},  {30944, -10781},
    {30942, -10784},  {30941, -10787},  {30940, -10790},  {30939, -10793},  {30938, -10796},  {30937, -10799},
    {30936, -10802},  {30935, -10805},  {30934, -10808},  {30933, -10811},  {30932, -10814},  {30931, -10817},
    {30930, -10820},  {30929, -10823},  {30928, -10826},  {30927, -10829},  {30926, -10832},  {30925, -10835},
    {30924, -10838},  {30923, -10841},  {30922, -10844},  {30921, -10847},  {30920, -10850},  {30919, -10853},
    {30918, -10856},  {30917, -10859},  {30916, -10862},  {30914, -10865},  {30913, -10867},  {30912, -10870},
    {30911, -10873},  {30910, -10876},  {30909, -10879},  {30908, -10882},  {30907, -10885},  {30906, -10888},
    {30905, -10891},  {30904, -10894},  {30903, -10897},  {30902, -10900},  {30901, -10903},  {30900, -10906},
    {30899, -10909},  {30898, -10912},  {30897, -10915},  {30896, -10918},  {30895, -10921},  {30894, -10924},
    {30893, -10927},  {30891, -10930},  {30890, -10933},  {30889, -10936},  {30888, -10939},  {30887, -10942},
    {30886, -10945},  {30885, -10947},  {30884, -10950},  {30883, -10953},  {30882, -10956},  {30881, -10959},
    {30880, -10962},  {30879, -10965},  {30878, -10968},  {30877, -10971},  {30876, -10974},  {30875, -10977},
    {30874, -10980},  {30873, -10983},  {30872, -10986},  {30870, -10989},  {30869, -10992},  {30868, -10995},
    {30867, -10998},  {30866, -11001},  {30865, -11004},  {30864, -11007},  {30863, -11010},  {30862, -11013},
    {30861, -11016},  {30860, -11018},  {30859, -11021},  {30858, -11024},  {30857, -11027},  {30856, -11030},
    {30855, -11033},  {30854, -11036},  {30853, -11039},  {30851, -11042},  {30850, -11045},  {30849, -11048},
    {30848, -11051},  {30847, -11054},  {30846, -11057},  {30845, -11060},  {30844, -11063},  {30843, -11066},
    {30842, -11069},  {30841, -11072},  {30840, -11075},  {30839, -11078},  {30838, -11081},  {30837, -11084},
    {30836, -11087},  {30834, -11089},  {30833, -11092},  {30832, -11095},  {30831, -11098},  {30830, -11101},
    {30829, -11104},  {30828, -11107},  {30827, -11110},  {30826, -11113},  {30825, -11116},  {30824, -11119},
    {30823, -11122},  {30822, -11125},  {30821, -11128},  {30820, -11131},  {30819, -11134},  {30817, -11137},
    {30816, -11140},  {30815, -11143},  {30814, -11146},  {30813, -11149},  {30812, -11152},  {30811, -11154},
    {30810, -11157},  {30809, -11160},  {30808, -11163},  {30807, -11166},  {30806, -11169},  {30805, -11172},
    {30804, -11175},  {30802, -11178},  {30801, -11181},  {30800, -11184},  {30799, -11187},  {30798, -11190},
    {30797, -11193},  {30796, -11196},  {30795, -11199},  {30794, -11202},  {30793, -11205},  {30792, -11208},
    {30791, -11211},  {30790, -11214},  {30789, -11216},  {30787, -11219},  {30786, -11222},  {30785, -11225},
    {30784, -11228},  {30783, -11231},  {30782, -11234},  {30781, -11237},  {30780, -11240},  {30779, -11243},
    {30778, -11246},  {30777, -11249},  {30776, -11252},  {30774, -11255},  {30773, -11258},  {30772, -11261},
    {30771, -11264},  {30770, -11267},  {30769, -11270},  {30768, -11273},  {30767, -11276},  {30766, -11278},
    {30765, -11281},  {30764, -11284},  {30763, -11287},  {30762, -11290},  {30760, -11293},  {30759, -11296},
    {30758, -11299},  {30757, -11302},  {30756, -11305},  {30755, -11308},  {30754, -11311},  {30753, -11314},
    {30752, -11317},  {30751, -11320},  {30750, -11323},  {30749, -11326},  {30747, -11329},  {30746, -11332},
    {30745, -11334},  {30744, -11337},  {30743, -11340},  {30742, -11343},  {30741, -11346},  {30740, -11349},
    {30739, -11352},  {30738, -11355},  {30737, -11358},  {30735, -11361},  {30734, -11364},  {30733, -11367},
    {30732, -11370},  {30731, -11373},  {30730, -11376},  {30729, -11379},  {30728, -11382},  {30727, -11385},
    {30726, -11388},  {30725, -11390},  {30723, -11393},  {30722, -11396},  {30721, -11399},  {30720, -11402},
    {30719, -11405},  {30718, -11408},  {30717, -11411},  {30716, -11414},  {30715, -11417},  {30714, -11420},
    {30713, -11423},  {30711, -11426},  {30710, -11429},  {30709, -11432},  {30708, -11435},  {30707, -11438},
    {30706, -11441},  {30705, -11443},  {30704, -11446},  {30703, -11449},  {30702, -11452},  {30700, -11455},
    {30699, -11458},  {30698, -11461},  {30697, -11464},  {30696, -11467},  {30695, -11470},  {30694, -11473},
    {30693, -11476},  {30692, -11479},  {30691, -11482},  {30689, -11485},  {30688, -11488},  {30687, -11491},
    {30686, -11494},  {30685, -11496},  {30684, -11499},  {30683, -11502},  {30682, -11505},  {30681, -11508},
    {30680, -11511},  {30678, -11514},  {30677, -11517},  {30676, -11520},  {30675, -11523},  {30674, -11526},
    {30673, -11529},  {30672, -11532},  {30671, -11535},  {30670, -11538},  {30669, -11541},  {30667, -11544},
    {30666, -11546},  {30665, -11549},  {30664, -11552},  {30663, -11555},  {30662, -11558},  {30661, -11561},
    {30660, -11564},  {30659, -11567},  {30657, -11570},  {30656, -11573},  {30655, -11576},  {30654, -11579},
    {30653, -11582},  {30652, -11585},  {30651, -11588},  {30650, -11591},  {30649, -11593},  {30647, -11596},
    {30646, -11599},  {30645, -11602},  {30644, -11605},  {30643, -11608},  {30642, -11611},  {30641, -11614},
    {30640, -11617},  {30639, -11620},  {30637, -11623},  {30636, -11626},  {30635, -11629},  {30634, -11632},
    {30633, -11635},  {30632, -11638},  {30631, -11640},  {30630, -11643},  {30628, -11646},  {30627, -11649},
    {30626, -11652},  {30625, -11655},  {30624, -11658},  {30623, -11661},  {30622, -11664},  {30621, -11667},
    {30620, -11670},  {30618, -11673},  {30617, -11676},  {30616, -11679},  {30615, -11682},  {30614, -11685},
    {30613, -11687},  {30612, -11690},  {30611, -11693},  {30609, -11696},  {30608, -11699},  {30607, -11702},
    {30606, -11705},  {30605, -11708},  {30604, -11711},  {30603, -11714},  {30602, -11717},  {30600, -11720},
    {30599, -11723},  {30598, -11726},  {30597, -11729},  {30596, -11731},  {30595, -11734},  {30594, -11737},
    {30593, -11740},  {30591, -11743},  {30590, -11746},  {30589, -11749},  {30588, -11752},  {30587, -11755},
    {30586, -11758},  {30585, -11761},  {30584, -11764},  {30582, -11767},  {30581, -11770},  {30580, -11773},
    {30579, -11775},  {30578, -11778},  {30577, -11781},  {30576, -11784},  {30575, -11787},  {30573, -11790},
    {30572, -11793},  {30571, -11796},  {30570, -11799},  {30569, -11802},  {30568, -11805},  {30567, -11808},
    {30566, -11811},  {30564, -11814},  {30563, -11816},  {30562, -11819},  {30561, -11822},  {30560, -11825},
    {30559, -11828},  {30558, -11831},  {30556, -11834},  {30555, -11837},  {30554, -11840},  {30553, -11843},
    {30552, -11846},  {30551, -11849},  {30550, -11852},  {30549, -11855},  {30547, -11857},  {30546, -11860},
    {30545, -11863},  {30544, -11866},  {30543, -11869},  {30542, -11872},  {30541, -11875},  {30539, -11878},
    {30538, -11881},  {30537, -11884},  {30536, -11887},  {30535, -11890},  {30534, -11893},  {30533, -11896},
    {30531, -11898},  {30530, -11901},  {30529, -11904},  {30528, -11907},  {30527, -11910},  {30526, -11913},
    {30525, -11916},  {30523, -11919},  {30522, -11922},  {30521, -11925},  {30520, -11928},  {30519, -11931},
    {30518, -11934},  {30517, -11937},  {30515, -11939},  {30514, -11942},  {30513, -11945},  {30512, -11948},
    {30511, -11951},  {30510, -11954},  {30509, -11957},  {30507, -11960},  {30506, -11963},  {30505, -11966},
    {30504, -11969},  {30503, -11972},  {30502, -11975},  {30501, -11977},  {30499, -11980},  {30498, -11983},
    {30497, -11986},  {30496, -11989},  {30495, -11992},  {30494, -11995},  {30492, -11998},  {30491, -12001},
    {30490, -12004},  {30489, -12007},  {30488, -12010},  {30487, -12013},  {30486, -12015},  {30484, -12018},
    {30483, -12021},  {30482, -12024},  {30481, -12027},  {30480, -12030},  {30479, -12033},  {30477, -12036},
    {30476, -12039},  {30475, -12042},  {30474, -12045},  {30473, -12048},  {30472, -12051},  {30471, -12053},
    {30469, -12056},  {30468, -12059},  {30467, -12062},  {30466, -12065},  {30465, -12068},  {30464, -12071},
    {30462, -12074},  {30461, -12077},  {30460, -12080},  {30459, -12083},  {30458, -12086},  {30457, -12089},
    {30456, -12091},  {30454, -12094},  {30453, -12097},  {30452, -12100},  {30451, -12103},  {30450, -12106},
    {30449, -12109},  {30447, -12112},  {30446, -12115},  {30445, -12118},  {30444, -12121},  {30443, -12124},
    {30442, -12126},  {30440, -12129},  {30439, -12132},  {30438, -12135},  {30437, -12138},  {30436, -12141},
    {30435, -12144},  {30433, -12147},  {30432, -12150},  {30431, -12153},  {30430, -12156},  {30429, -12159},
    {30428, -12161},  {30426, -12164},  {30425, -12167},  {30424, -12170},  {30423, -12173},  {30422, -12176},
    {30421, -12179},  {30419, -12182},  {30418, -12185},  {30417, -12188},  {30416, -12191},  {30415, -12194},
    {30414, -12196},  {30412, -12199},  {30411, -12202},  {30410, -12205},  {30409, -12208},  {30408, -12211},
    {30407, -12214},  {30405, -12217},  {30404, -12220},  {30403, -12223},  {30402, -12226},  {30401, -12229},
    {30400, -12231},  {30398, -12234},  {30397, -12237},  {30396, -12240},  {30395, -12243},  {30394, -12246},
    {30393, -12249},  {30391, -12252},  {30390, -12255},  {30389, -12258},  {30388, -12261},  {30387, -12264},
    {30385, -12266},  {30384, -12269},  {30383, -12272},  {30382, -12275},  {30381, -12278},  {30380, -12281},
    {30378, -12284},  {30377, -12287},  {30376, -12290},  {30375, -12293},  {30374, -12296},  {30373, -12298},
    {30371, -12301},  {30370, -12304},  {30369, -12307},  {30368, -12310},  {30367, -12313},  {30365, -12316},
    {30364, -12319},  {30363, -12322},  {30362, -12325},  {30361, -12328},  {30360, -12330},  {30358, -12333},
    {30357, -12336},  {30356, -12339},  {30355, -12342},  {30354, -12345},  {30352, -12348},  {30351, -12351},
    {30350, -12354},  {30349, -12357},  {30348, -12360},  {30347, -12363},  {30345, -12365},  {30344, -12368},
    {30343, -12371},  {30342, -12374},  {30341, -12377},  {30339, -12380},  {30338, -12383},  {30337, -12386},
    {30336, -12389},  {30335, -12392},  {30333, -12395},  {30332, -12397},  {30331, -12400},  {30330, -12403},
    {30329, -12406},  {30328, -12409},  {30326, -12412},  {30325, -12415},  {30324, -12418},  {30323, -12421},
    {30322, -12424},  {30320, -12426},  {30319, -12429},  {30318, -12432},  {30317, -12435},  {30316, -12438},
    {30314, -12441},  {30313, -12444},  {30312, -12447},  {30311, -12450},  {30310, -12453},  {30308, -12456},
    {30307, -12458},  {30306, -12461},  {30305, -12464},  {30304, -12467},  {30302, -12470},  {30301, -12473},
    {30300, -12476},  {30299, -12479},  {30298, -12482},  {30296, -12485},  {30295, -12488},  {30294, -12490},
    {30293, -12493},  {30292, -12496},  {30290, -12499},  {30289, -12502},  {30288, -12505},  {30287, -12508},
    {30286, -12511},  {30284, -12514},  {30283, -12517},  {30282, -12519},  {30281, -12522},  {30280, -12525},
    {30278, -12528},  {30277, -12531},  {30276, -12534},  {30275, -12537},  {30274, -12540},  {30272, -12543},
    {30271, -12546},  {30270, -12548},  {30269, -12551},  {30268, -12554},  {30266, -12557},  {30265, -12560},
    {30264, -12563},  {30263, -12566},  {30262, -12569},  {30260, -12572},  {30259, -12575},  {30258, -12577},
    {30257, -12580},  {30256, -12583},  {30254, -12586},  {30253, -12589},  {30252, -12592},  {30251, -12595},
    {30250, -12598},  {30248, -12601},  {30247, -12604},  {30246, -12606},  {30245, -12609},  {30244, -12612},
    {30242, -12615},  {30241, -12618},  {30240, -12621},  {30239, -12624},  {30237, -12627},  {30236, -12630},
    {30235, -12633},  {30234, -12635},  {30233, -12638},  {30231, -12641},  {30230, -12644},  {30229, -12647},
    {30228, -12650},  {30227, -12653},  {30225, -12656},  {30224, -12659},  {30223, -12662},  {30222, -12664},
    {30221, -12667},  {30219, -12670},  {30218, -12673},  {30217, -12676},  {30216, -12679},  {30214, -12682},
    {30213, -12685},  {30212, -12688},  {30211, -12691},  {30210, -12693},  {30208, -12696},  {30207, -12699},
    {30206, -12702},  {30205, -12705},  {30203, -12708},  {30202, -12711},  {30201, -12714},  {30200, -12717},
    {30199, -12720},  {30197, -12722},  {30196, -12725},  {30195, -12728},  {30194, -12731},  {30193, -12734},
    {30191, -12737},  {30190, -12740},  {30189, -12743},  {30188, -12746},  {30186, -12748},  {30185, -12751},
    {30184, -12754},  {30183, -12757},  {30182, -12760},  {30180, -12763},  {30179, -12766},  {30178, -12769},
    {30177, -12772},  {30175, -12774},  {30174, -12777},  {30173, -12780},  {30172, -12783},  {30170, -12786},
    {30169, -12789},  {30168, -12792},  {30167, -12795},  {30166, -12798},  {30164, -12801},  {30163, -12803},
    {30162, -12806},  {30161, -12809},  {30159, -12812},  {30158, -12815},  {30157, -12818},  {30156, -12821},
    {30155, -12824},  {30153, -12827},  {30152, -12829},  {30151, -12832},  {30150, -12835},  {30148, -12838},
    {30147, -12841},  {30146, -12844},  {30145, -12847},  {30143, -12850},  {30142, -12853},  {30141, -12855},
    {30140, -12858},  {30139, -12861},  {30137, -12864},  {30136, -12867},  {30135, -12870},  {30134, -12873},
    {30132, -12876},  {30131, -12879},  {30130, -12881},  {30129, -12884},  {30127, -12887},  {30126, -12890},
    {30125, -12893},  {30124, -12896},  {30122, -12899},  {30121, -12902},  {30120, -12905},  {30119, -12907},
    {30118, -12910},  {30116, -12913},  {30115, -12916},  {30114, -12919},  {30113, -12922},  {30111, -12925},
    {30110, -12928},  {30109, -12931},  {30108, -12933},  {30106, -12936},  {30105, -12939},  {30104, -12942},
    {30103, -12945},  {30101, -12948},  {30100, -12951},  {30099, -12954},  {30098, -12957},  {30096, -12959},
    {30095, -12962},  {30094, -12965},  {30093, -12968},  {30091, -12971},  {30090, -12974},  {30089, -12977},
    {30088, -12980},  {30086, -12982},  {30085, -12985},  {30084, -12988},  {30083, -12991},  {30082, -12994},
    {30080, -12997},  {30079, -13000},  {30078, -13003},  {30077, -13006},  {30075, -13008},  {30074, -13011},
    {30073, -13014},  {30072, -13017},  {30070, -13020},  {30069, -13023},  {30068, -13026},  {30067, -13029},
    {30065, -13032},  {30064, -13034},  {30063, -13037},  {30062, -13040},  {30060, -13043},  {30059, -13046},
    {30058, -13049},  {30057, -13052},  {30055, -13055},  {30054, -13057},  {30053, -13060},  {30052, -13063},
    {30050, -13066},  {30049, -13069},  {30048, -13072},  {30047, -13075},  {30045, -13078},  {30044, -13080},
    {30043, -13083},  {30042, -13086},  {30040, -13089},  {30039, -13092},  {30038, -13095},  {30036, -13098},
    {30035, -13101},  {30034, -13104},  {30033, -13106},  {30031, -13109},  {30030, -13112},  {30029, -13115},
    {30028, -13118},  {30026, -13121},  {30025, -13124},  {30024, -13127},  {30023, -13129},  {30021, -13132},
    {30020, -13135},  {30019, -13138},  {30018, -13141},  {30016, -13144},  {30015, -13147},  {30014, -13150},
    {30013, -13152},  {30011, -13155},  {30010, -13158},  {30009, -13161},  {30008, -13164},  {30006, -13167},
    {30005, -13170},  {30004, -13173},  {30002, -13175},  {30001, -13178},  {30000, -13181},  {29999, -13184},
    {29997, -13187},  {29996, -13190},  {29995, -13193},  {29994, -13196},  {29992, -13198},  {29991, -13201},
    {29990, -13204},  {29989, -13207},  {29987, -13210},  {29986, -13213},  {29985, -13216},  {29983, -13219},
    {29982, -13221},  {29981, -13224},  {29980, -13227},  {29978, -13230},  {29977, -13233},  {29976, -13236},
    {29975, -13239},  {29973, -13242},  {29972, -13244},  {29971, -13247},  {29970, -13250},  {29968, -13253},
    {29967, -13256},  {29966, -13259},  {29964, -13262},  {29963, -13265},  {29962, -13267},  {29961, -13270},
    {29959, -13273},  {29958, -13276},  {29957, -13279},  {29956, -13282},  {29954, -13285},  {29953, -13288},
    {29952, -13290},  {29950, -13293},  {29949, -13296},  {29948, -13299},  {29947, -13302},  {29945, -13305},
    {29944, -13308},  {29943, -13311},  {29942, -13313},  {29940, -13316},  {29939, -13319},  {29938, -13322},
    {29936, -13325},  {29935, -13328},  {29934, -13331},  {29933, -13333},  {29931, -13336},  {29930, -13339},
    {29929, -13342},  {29927, -13345},  {29926, -13348},  {29925, -13351},  {29924, -13354},  {29922, -13356},
    {29921, -13359},  {29920, -13362},  {29919, -13365},  {29917, -13368},  {29916, -13371},  {29915, -13374},
    {29913, -13377},  {29912, -13379},  {29911, -13382},  {29910, -13385},  {29908, -13388},  {29907, -13391},
    {29906, -13394},  {29904, -13397},  {29903, -13399},  {29902, -13402},  {29901, -13405},  {29899, -13408},
    {29898, -13411},  {29897, -13414},  {29895, -13417},  {29894, -13420},  {29893, -13422},  {29892, -13425},
    {29890, -13428},  {29889, -13431},  {29888, -13434},  {29886, -13437},  {29885, -13440},  {29884, -13442},
    {29883, -13445},  {29881, -13448},  {29880, -13451},  {29879, -13454},  {29877, -13457},  {29876, -13460},
    {29875, -13463},  {29873, -13465},  {29872, -13468},  {29871, -13471},  {29870, -13474},  {29868, -13477},
    {29867, -13480},  {29866, -13483},  {29864, -13485},  {29863, -13488},  {29862, -13491},  {29861, -13494},
    {29859, -13497},  {29858, -13500},  {29857, -13503},  {29855, -13505},  {29854, -13508},  {29853, -13511},
    {29852, -13514},  {29850, -13517},  {29849, -13520},  {29848, -13523},  {29846, -13525},  {29845, -13528},
    {29844, -13531},  {29842, -13534},  {29841, -13537},  {29840, -13540},  {29839, -13543},  {29837, -13546},
    {29836, -13548},  {29835, -13551},  {29833, -13554},  {29832, -13557},  {29831, -13560},  {29829, -13563},
    {29828, -13566},  {29827, -13568},  {29826, -13571},  {29824, -13574},  {29823, -13577},  {29822, -13580},
    {29820, -13583},  {29819, -13586},  {29818, -13588},  {29816, -13591},  {29815, -13594},  {29814, -13597},
    {29813, -13600},  {29811, -13603},  {29810, -13606},  {29809, -13608},  {29807, -13611},  {29806, -13614},
    {29805, -13617},  {29803, -13620},  {29802, -13623},  {29801, -13626},  {29799, -13628},  {29798, -13631},
    {29797, -13634},  {29796, -13637},  {29794, -13640},  {29793, -13643},  {29792, -13646},  {29790, -13648},
    {29789, -13651},  {29788, -13654},  {29786, -13657},  {29785, -13660},  {29784, -13663},  {29782, -13666},
    {29781, -13668},  {29780, -13671},  {29779, -13674},  {29777, -13677},  {29776, -13680},  {29775, -13683},
    {29773, -13686},  {29772, -13688},  {29771, -13691},  {29769, -13694},  {29768, -13697},  {29767, -13700},
    {29765, -13703},  {29764, -13706},  {29763, -13708},  {29761, -13711},  {29760, -13714},  {29759, -13717},
    {29758, -13720},  {29756, -13723},  {29755, -13725},  {29754, -13728},  {29752, -13731},  {29751, -13734},
    {29750, -13737},  {29748, -13740},  {29747, -13743},  {29746, -13745},  {29744, -13748},  {29743, -13751},
    {29742, -13754},  {29740, -13757},  {29739, -13760},  {29738, -13763},  {29736, -13765},  {29735, -13768},
    {29734, -13771},  {29732, -13774},  {29731, -13777},  {29730, -13780},  {29729, -13783},  {29727, -13785},
    {29726, -13788},  {29725, -13791},  {29723, -13794},  {29722, -13797},  {29721, -13800},  {29719, -13802},
    {29718, -13805},  {29717, -13808},  {29715, -13811},  {29714, -13814},  {29713, -13817},  {29711, -13820},
    {29710, -13822},  {29709, -13825},  {29707, -13828},  {29706, -13831},  {29705, -13834},  {29703, -13837},
    {29702, -13839},  {29701, -13842},  {29699, -13845},  {29698, -13848},  {29697, -13851},  {29695, -13854},
    {29694, -13857},  {29693, -13859},  {29691, -13862},  {29690, -13865},  {29689, -13868},  {29687, -13871},
    {29686, -13874},  {29685, -13877},  {29683, -13879},  {29682, -13882},  {29681, -13885},  {29679, -13888},
    {29678, -13891},  {29677, -13894},  {29675, -13896},  {29674, -13899},  {29673, -13902},  {29671, -13905},
    {29670, -13908},  {29669, -13911},  {29667, -13913},  {29666, -13916},  {29665, -13919},  {29663, -13922},
    {29662, -13925},  {29661, -13928},  {29659, -13931},  {29658, -13933},  {29657, -13936},  {29655, -13939},
    {29654, -13942},  {29653, -13945},  {29651, -13948},  {29650, -13950},  {29649, -13953},  {29647, -13956},
    {29646, -13959},  {29645, -13962},  {29643, -13965},  {29642, -13968},  {29641, -13970},  {29639, -13973},
    {29638, -13976},  {29637, -13979},  {29635, -13982},  {29634, -13985},  {29633, -13987},  {29631, -13990},
    {29630, -13993},  {29629, -13996},  {29627, -13999},  {29626, -14002},  {29625, -14004},  {29623, -14007},
    {29622, -14010},  {29621, -14013},  {29619, -14016},  {29618, -14019},  {29617, -14021},  {29615, -14024},
    {29614, -14027},  {29613, -14030},  {29611, -14033},  {29610, -14036},  {29608, -14039},  {29607, -14041},
    {29606, -14044},  {29604, -14047},  {29603, -14050},  {29602, -14053},  {29600, -14056},  {29599, -14058},
    {29598, -14061},  {29596, -14064},  {29595, -14067},  {29594, -14070},  {29592, -14073},  {29591, -14075},
    {29590, -14078},  {29588, -14081},  {29587, -14084},  {29586, -14087},  {29584, -14090},  {29583, -14092},
    {29582, -14095},  {29580, -14098},  {29579, -14101},  {29577, -14104},  {29576, -14107},  {29575, -14109},
    {29573, -14112},  {29572, -14115},  {29571, -14118},  {29569, -14121},  {29568, -14124},  {29567, -14126},
    {29565, -14129},  {29564, -14132},  {29563, -14135},  {29561, -14138},  {29560, -14141},  {29558, -14143},
    {29557, -14146},  {29556, -14149},  {29554, -14152},  {29553, -14155},  {29552, -14158},  {29550, -14160},
    {29549, -14163},  {29548, -14166},  {29546, -14169},  {29545, -14172},  {29544, -14175},  {29542, -14177},
    {29541, -14180},  {29539, -14183},  {29538, -14186},  {29537, -14189},  {29535, -14192},  {29534, -14194},
    {29533, -14197},  {29531, -14200},  {29530, -14203},  {29529, -14206},  {29527, -14209},  {29526, -14211},
    {29525, -14214},  {29523, -14217},  {29522, -14220},  {29520, -14223},  {29519, -14226},  {29518, -14228},
    {29516, -14231},  {29515, -14234},  {29514, -14237},  {29512, -14240},  {29511, -14243},  {29509, -14245},
    {29508, -14248},  {29507, -14251},  {29505, -14254},  {29504, -14257},  {29503, -14260},  {29501, -14262},
    {29500, -14265},  {29499, -14268},  {29497, -14271},  {29496, -14274},  {29494, -14277},  {29493, -14279},
    {29492, -14282},  {29490, -14285},  {29489, -14288},  {29488, -14291},  {29486, -14293},  {29485, -14296},
    {29484, -14299},  {29482, -14302},  {29481, -14305},  {29479, -14308},  {29478, -14310},  {29477, -14313},
    {29475, -14316},  {29474, -14319},  {29473, -14322},  {29471, -14325},  {29470, -14327},  {29468, -14330},
    {29467, -14333},  {29466, -14336},  {29464, -14339},  {29463, -14342},  {29462, -14344},  {29460, -14347},
    {29459, -14350},  {29457, -14353},  {29456, -14356},  {29455, -14358},  {29453, -14361},  {29452, -14364},
    {29451, -14367},  {29449, -14370},  {29448, -14373},  {29446, -14375},  {29445, -14378},  {29444, -14381},
    {29442, -14384},  {29441, -14387},  {29439, -14390},  {29438, -14392},  {29437, -14395},  {29435, -14398},
    {29434, -14401},  {29433, -14404},  {29431, -14406},  {29430, -14409},  {29428, -14412},  {29427, -14415},
    {29426, -14418},  {29424, -14421},  {29423, -14423},  {29422, -14426},  {29420, -14429},  {29419, -14432},
    {29417, -14435},  {29416, -14437},  {29415, -14440},  {29413, -14443},  {29412, -14446},  {29410, -14449},
    {29409, -14452},  {29408, -14454},  {29406, -14457},  {29405, -14460},  {29404, -14463},  {29402, -14466},
    {29401, -14468},  {29399, -14471},  {29398, -14474},  {29397, -14477},  {29395, -14480},  {29394, -14483},
    {29392, -14485},  {29391, -14488},  {29390, -14491},  {29388, -14494},  {29387, -14497},  {29385, -14499},
    {29384, -14502},  {29383, -14505},  {29381, -14508},  {29380, -14511},  {29379, -14514},  {29377, -14516},
    {29376, -14519},  {29374, -14522},  {29373, -14525},  {29372, -14528},  {29370, -14530},  {29369, -14533},
    {29367, -14536},  {29366, -14539},  {29365, -14542},  {29363, -14545},  {29362, -14547},  {29360, -14550},
    {29359, -14553},  {29358, -14556},  {29356, -14559},  {29355, -14561},  {29353, -14564},  {29352, -14567},
    {29351, -14570},  {29349, -14573},  {29348, -14576},  {29346, -14578},  {29345, -14581},  {29344, -14584},
    {29342, -14587},  {29341, -14590},  {29339, -14592},  {29338, -14595},  {29337, -14598},  {29335, -14601},
    {29334, -14604},  {29332, -14606},  {29331, -14609},  {29330, -14612},  {29328, -14615},  {29327, -14618},
    {29325, -14621},  {29324, -14623},  {29323, -14626},  {29321, -14629},  {29320, -14632},  {29318, -14635},
    {29317, -14637},  {29316, -14640},  {29314, -14643},  {29313, -14646},  {29311, -14649},  {29310, -14651},
    {29309, -14654},  {29307, -14657},  {29306, -14660},  {29304, -14663},  {29303, -14665},  {29302, -14668},
    {29300, -14671},  {29299, -14674},  {29297, -14677},  {29296, -14680},  {29295, -14682},  {29293, -14685},
    {29292, -14688},  {29290, -14691},  {29289, -14694},  {29288, -14696},  {29286, -14699},  {29285, -14702},
    {29283, -14705},  {29282, -14708},  {29280, -14710},  {29279, -14713},  {29278, -14716},  {29276, -14719},
    {29275, -14722},  {29273, -14724},  {29272, -14727},  {29271, -14730},  {29269, -14733},  {29268, -14736},
    {29266, -14738},  {29265, -14741},  {29264, -14744},  {29262, -14747},  {29261, -14750},  {29259, -14753},
    {29258, -14755},  {29256, -14758},  {29255, -14761},  {29254, -14764},  {29252, -14767},  {29251, -14769},
    {29249, -14772},  {29248, -14775},  {29247, -14778},  {29245, -14781},  {29244, -14783},  {29242, -14786},
    {29241, -14789},  {29239, -14792},  {29238, -14795},  {29237, -14797},  {29235, -14800},  {29234, -14803},
    {29232, -14806},  {29231, -14809},  {29230, -14811},  {29228, -14814},  {29227, -14817},  {29225, -14820},
    {29224, -14823},  {29222, -14825},  {29221, -14828},  {29220, -14831},  {29218, -14834},  {29217, -14837},
    {29215, -14839},  {29214, -14842},  {29212, -14845},  {29211, -14848},  {29210, -14851},  {29208, -14853},
    {29207, -14856},  {29205, -14859},  {29204, -14862},  {29202, -14865},  {29201, -14867},  {29200, -14870},
    {29198, -14873},  {29197, -14876},  {29195, -14879},  {29194, -14881},  {29193, -14884},  {29191, -14887},
    {29190, -14890},  {29188, -14893},  {29187, -14895},  {29185, -14898},  {29184, -14901},  {29183, -14904},
    {29181, -14907},  {29180, -14909},  {29178, -14912},  {29177, -14915},  {29175, -14918},  {29174, -14921},
    {29173, -14923},  {29171, -14926},  {29170, -14929},  {29168, -14932},  {29167, -14935},  {29165, -14937},
    {29164, -14940},  {29162, -14943},  {29161, -14946},  {29160, -14949},  {29158, -14951},  {29157, -14954},
    {29155, -14957},  {29154, -14960},  {29152, -14963},  {29151, -14965},  {29150, -14968},  {29148, -14971},
    {29147, -14974},  {29145, -14976},  {29144, -14979},  {29142, -14982},  {29141, -14985},  {29140, -14988},
    {29138, -14990},  {29137, -14993},  {29135, -14996},  {29134, -14999},  {29132, -15002},  {29131, -15004},
    {29129, -15007},  {29128, -15010},  {29127, -15013},  {29125, -15016},  {29124, -15018},  {29122, -15021},
    {29121, -15024},  {29119, -15027},  {29118, -15030},  {29116, -15032},  {29115, -15035},  {29114, -15038},
    {29112, -15041},  {29111, -15044},  {29109, -15046},  {29108, -15049},  {29106, -15052},  {29105, -15055},
    {29104, -15057},  {29102, -15060},  {29101, -15063},  {29099, -15066},  {29098, -15069},  {29096, -15071},
    {29095, -15074},  {29093, -15077},  {29092, -15080},  {29091, -15083},  {29089, -15085},  {29088, -15088},
    {29086, -15091},  {29085, -15094},  {29083, -15097},  {29082, -15099},  {29080, -15102},  {29079, -15105},
    {29077, -15108},  {29076, -15110},  {29075, -15113},  {29073, -15116},  {29072, -15119},  {29070, -15122},
    {29069, -15124},  {29067, -15127},  {29066, -15130},  {29064, -15133},  {29063, -15136},  {29062, -15138},
    {29060, -15141},  {29059, -15144},  {29057, -15147},  {29056, -15149},  {29054, -15152},  {29053, -15155},
    {29051, -15158},  {29050, -15161},  {29048, -15163},  {29047, -15166},  {29046, -15169},  {29044, -15172},
    {29043, -15175},  {29041, -15177},  {29040, -15180},  {29038, -15183},  {29037, -15186},  {29035, -15188},
    {29034, -15191},  {29032, -15194},  {29031, -15197},  {29030, -15200},  {29028, -15202},  {29027, -15205},
    {29025, -15208},  {29024, -15211},  {29022, -15213},  {29021, -15216},  {29019, -15219},  {29018, -15222},
    {29016, -15225},  {29015, -15227},  {29013, -15230},  {29012, -15233},  {29011, -15236},  {29009, -15239},
    {29008, -15241},  {29006, -15244},  {29005, -15247},  {29003, -15250},  {29002, -15252},  {29000, -15255},
    {28999, -15258},  {28997, -15261},  {28996, -15264},  {28994, -15266},  {28993, -15269},  {28992, -15272},
    {28990, -15275},  {28989, -15277},  {28987, -15280},  {28986, -15283},  {28984, -15286},  {28983, -15289},
    {28981, -15291},  {28980, -15294},  {28978, -15297},  {28977, -15300},  {28975, -15302},  {28974, -15305},
    {28973, -15308},  {28971, -15311},  {28970, -15314},  {28968, -15316},  {28967, -15319},  {28965, -15322},
    {28964, -15325},  {28962, -15327},  {28961, -15330},  {28959, -15333},  {28958, -15336},  {28956, -15339},
    {28955, -15341},  {28953, -15344},  {28952, -15347},  {28950, -15350},  {28949, -15352},  {28948, -15355},
    {28946, -15358},  {28945, -15361},  {28943, -15364},  {28942, -15366},  {28940, -15369},  {28939, -15372},
    {28937, -15375},  {28936, -15377},  {28934, -15380},  {28933, -15383},  {28931, -15386},  {28930, -15389},
    {28928, -15391},  {28927, -15394},  {28925, -15397},  {28924, -15400},  {28922, -15402},  {28921, -15405},
    {28920, -15408},  {28918, -15411},  {28917, -15413},  {28915, -15416},  {28914, -15419},  {28912, -15422},
    {28911, -15425},  {28909, -15427},  {28908, -15430},  {28906, -15433},  {28905, -15436},  {28903, -15438},
    {28902, -15441},  {28900, -15444},  {28899, -15447},  {28897, -15449},  {28896, -15452},  {28894, -15455},
    {28893, -15458},  {28891, -15461},  {28890, -15463},  {28888, -15466},  {28887, -15469},  {28885, -15472},
    {28884, -15474},  {28882, -15477},  {28881, -15480},  {28880, -15483},  {28878, -15486},  {28877, -15488},
    {28875, -15491},  {28874, -15494},  {28872, -15497},  {28871, -15499},  {28869, -15502},  {28868, -15505},
    {28866, -15508},  {28865, -15510},  {28863, -15513},  {28862, -15516},  {28860, -15519},  {28859, -15521},
    {28857, -15524},  {28856, -15527},  {28854, -15530},  {28853, -15533},  {28851, -15535},  {28850, -15538},
    {28848, -15541},  {28847, -15544},  {28845, -15546},  {28844, -15549},  {28842, -15552},  {28841, -15555},
    {28839, -15557},  {28838, -15560},  {28836, -15563},  {28835, -15566},  {28833, -15568},  {28832, -15571},
    {28830, -15574},  {28829, -15577},  {28827, -15580},  {28826, -15582},  {28824, -15585},  {28823, -15588},
    {28821, -15591},  {28820, -15593},  {28818, -15596},  {28817, -15599},  {28815, -15602},  {28814, -15604},
    {28812, -15607},  {28811, -15610},  {28809, -15613},  {28808, -15615},  {28806, -15618},  {28805, -15621},
    {28803, -15624},  {28802, -15627},  {28800, -15629},  {28799, -15632},  {28797, -15635},  {28796, -15638},
    {28794, -15640},  {28793, -15643},  {28791, -15646},  {28790, -15649},  {28788, -15651},  {28787, -15654},
    {28785, -15657},  {28784, -15660},  {28782, -15662},  {28781, -15665},  {28779, -15668},  {28778, -15671},
    {28776, -15673},  {28775, -15676},  {28773, -15679},  {28772, -15682},  {28770, -15684},  {28769, -15687},
    {28767, -15690},  {28766, -15693},  {28764, -15696},  {28763, -15698},  {28761, -15701},  {28760, -15704},
    {28758, -15707},  {28757, -15709},  {28755, -15712},  {28754, -15715},  {28752, -15718},  {28751, -15720},
    {28749, -15723},  {28748, -15726},  {28746, -15729},  {28745, -15731},  {28743, -15734},  {28742, -15737},
    {28740, -15740},  {28739, -15742},  {28737, -15745},  {28736, -15748},  {28734, -15751},  {28733, -15753},
    {28731, -15756},  {28730, -15759},  {28728, -15762},  {28727, -15764},  {28725, -15767},  {28724, -15770},
    {28722, -15773},  {28721, -15775},  {28719, -15778},  {28718, -15781},  {28716, -15784},  {28715, -15786},
    {28713, -15789},  {28712, -15792},  {28710, -15795},  {28709, -15797},  {28707, -15800},  {28706, -15803},
    {28704, -15806},  {28703, -15808},  {28701, -15811},  {28699, -15814},  {28698, -15817},  {28696, -15819},
    {28695, -15822},  {28693, -15825},  {28692, -15828},  {28690, -15830},  {28689, -15833},  {28687, -15836},
    {28686, -15839},  {28684, -15841},  {28683, -15844},  {28681, -15847},  {28680, -15850},  {28678, -15852},
    {28677, -15855},  {28675, -15858},  {28674, -15861},  {28672, -15863},  {28671, -15866},  {28669, -15869},
    {28668, -15872},  {28666, -15874},  {28665, -15877},  {28663, -15880},  {28662, -15883},  {28660, -15885},
    {28658, -15888},  {28657, -15891},  {28655, -15894},  {28654, -15896},  {28652, -15899},  {28651, -15902},
    {28649, -15905},  {28648, -15907},  {28646, -15910},  {28645, -15913},  {28643, -15916},  {28642, -15918},
    {28640, -15921},  {28639, -15924},  {28637, -15927},  {28636, -15929},  {28634, -15932},  {28633, -15935},
    {28631, -15938},  {28629, -15940},  {28628, -15943},  {28626, -15946},  {28625, -15949},  {28623, -15951},
    {28622, -15954},  {28620, -15957},  {28619, -15960},  {28617, -15962},  {28616, -15965},  {28614, -15968},
    {28613, -15971},  {28611, -15973},  {28610, -15976},  {28608, -15979},  {28607, -15982},  {28605, -15984},
    {28603, -15987},  {28602, -15990},  {28600, -15992},  {28599, -15995},  {28597, -15998},  {28596, -16001},
    {28594, -16003},  {28593, -16006},  {28591, -16009},  {28590, -16012},  {28588, -16014},  {28587, -16017},
    {28585, -16020},  {28583, -16023},  {28582, -16025},  {28580, -16028},  {28579, -16031},  {28577, -16034},
    {28576, -16036},  {28574, -16039},  {28573, -16042},  {28571, -16045},  {28570, -16047},  {28568, -16050},
    {28567, -16053},  {28565, -16056},  {28564, -16058},  {28562, -16061},  {28560, -16064},  {28559, -16066},
    {28557, -16069},  {28556, -16072},  {28554, -16075},  {28553, -16077},  {28551, -16080},  {28550, -16083},
    {28548, -16086},  {28547, -16088},  {28545, -16091},  {28543, -16094},  {28542, -16097},  {28540, -16099},
    {28539, -16102},  {28537, -16105},  {28536, -16108},  {28534, -16110},  {28533, -16113},  {28531, -16116},
    {28530, -16118},  {28528, -16121},  {28526, -16124},  {28525, -16127},  {28523, -16129},  {28522, -16132},
    {28520, -16135},  {28519, -16138},  {28517, -16140},  {28516, -16143},  {28514, -16146},  {28513, -16149},
    {28511, -16151},  {28509, -16154},  {28508, -16157},  {28506, -16159},  {28505, -16162},  {28503, -16165},
    {28502, -16168},  {28500, -16170},  {28499, -16173},  {28497, -16176},  {28496, -16179},  {28494, -16181},
    {28492, -16184},  {28491, -16187},  {28489, -16190},  {28488, -16192},  {28486, -16195},  {28485, -16198},
    {28483, -16200},  {28482, -16203},  {28480, -16206},  {28478, -16209},  {28477, -16211},  {28475, -16214},
    {28474, -16217},  {28472, -16220},  {28471, -16222},  {28469, -16225},  {28468, -16228},  {28466, -16230},
    {28464, -16233},  {28463, -16236},  {28461, -16239},  {28460, -16241},  {28458, -16244},  {28457, -16247},
    {28455, -16250},  {28454, -16252},  {28452, -16255},  {28450, -16258},  {28449, -16261},  {28447, -16263},
    {28446, -16266},  {28444, -16269},  {28443, -16271},  {28441, -16274},  {28440, -16277},  {28438, -16280},
    {28436, -16282},  {28435, -16285},  {28433, -16288},  {28432, -16291},  {28430, -16293},  {28429, -16296},
    {28427, -16299},  {28425, -16301},  {28424, -16304},  {28422, -16307},  {28421, -16310},  {28419, -16312},
    {28418, -16315},  {28416, -16318},  {28415, -16320},  {28413, -16323},  {28411, -16326},  {28410, -16329},
    {28408, -16331},  {28407, -16334},  {28405, -16337},  {28404, -16340},  {28402, -16342},  {28400, -16345},
    {28399, -16348},  {28397, -16350},  {28396, -16353},  {28394, -16356},  {28393, -16359},  {28391, -16361},
    {28389, -16364},  {28388, -16367},  {28386, -16369},  {28385, -16372},  {28383, -16375},  {28382, -16378},
    {28380, -16380},  {28378, -16383},  {28377, -16386},  {28375, -16389},  {28374, -16391},  {28372, -16394},
    {28371, -16397},  {28369, -16399},  {28367, -16402},  {28366, -16405},  {28364, -16408},  {28363, -16410},
    {28361, -16413},  {28360, -16416},  {28358, -16418},  {28356, -16421},  {28355, -16424},  {28353, -16427},
    {28352, -16429},  {28350, -16432},  {28349, -16435},  {28347, -16437},  {28345, -16440},  {28344, -16443},
    {28342, -16446},  {28341, -16448},  {28339, -16451},  {28338, -16454},  {28336, -16456},  {28334, -16459},
    {28333, -16462},  {28331, -16465},  {28330, -16467},  {28328, -16470},  {28326, -16473},  {28325, -16476},
    {28323, -16478},  {28322, -16481},  {28320, -16484},  {28319, -16486},  {28317, -16489},  {28315, -16492},
    {28314, -16495},  {28312, -16497},  {28311, -16500},  {28309, -16503},  {28307, -16505},  {28306, -16508},
    {28304, -16511},  {28303, -16514},  {28301, -16516},  {28300, -16519},  {28298, -16522},  {28296, -16524},
    {28295, -16527},  {28293, -16530},  {28292, -16533},  {28290, -16535},  {28288, -16538},  {28287, -16541},
    {28285, -16543},  {28284, -16546},  {28282, -16549},  {28281, -16551},  {28279, -16554},  {28277, -16557},
    {28276, -16560},  {28274, -16562},  {28273, -16565},  {28271, -16568},  {28269, -16570},  {28268, -16573},
    {28266, -16576},  {28265, -16579},  {28263, -16581},  {28261, -16584},  {28260, -16587},  {28258, -16589},
    {28257, -16592},  {28255, -16595},  {28254, -16598},  {28252, -16600},  {28250, -16603},  {28249, -16606},
    {28247, -16608},  {28246, -16611},  {28244, -16614},  {28242, -16617},  {28241, -16619},  {28239, -16622},
    {28238, -16625},  {28236, -16627},  {28234, -16630},  {28233, -16633},  {28231, -16635},  {28230, -16638},
    {28228, -16641},  {28226, -16644},  {28225, -16646},  {28223, -16649},  {28222, -16652},  {28220, -16654},
    {28218, -16657},  {28217, -16660},  {28215, -16663},  {28214, -16665},  {28212, -16668},  {28210, -16671},
    {28209, -16673},  {28207, -16676},  {28206, -16679},  {28204, -16681},  {28202, -16684},  {28201, -16687},
    {28199, -16690},  {28198, -16692},  {28196, -16695},  {28194, -16698},  {28193, -16700},  {28191, -16703},
    {28190, -16706},  {28188, -16708},  {28186, -16711},  {28185, -16714},  {28183, -16717},  {28182, -16719},
    {28180, -16722},  {28178, -16725},  {28177, -16727},  {28175, -16730},  {28174, -16733},  {28172, -16736},
    {28170, -16738},  {28169, -16741},  {28167, -16744},  {28166, -16746},  {28164, -16749},  {28162, -16752},
    {28161, -16754},  {28159, -16757},  {28158, -16760},  {28156, -16763},  {28154, -16765},  {28153, -16768},
    {28151, -16771},  {28150, -16773},  {28148, -16776},  {28146, -16779},  {28145, -16781},  {28143, -16784},
    {28142, -16787},  {28140, -16789},  {28138, -16792},  {28137, -16795},  {28135, -16798},  {28133, -16800},
    {28132, -16803},  {28130, -16806},  {28129, -16808},  {28127, -16811},  {28125, -16814},  {28124, -16816},
    {28122, -16819},  {28121, -16822},  {28119, -16825},  {28117, -16827},  {28116, -16830},  {28114, -16833},
    {28113, -16835},  {28111, -16838},  {28109, -16841},  {28108, -16843},  {28106, -16846},  {28104, -16849},
    {28103, -16852},  {28101, -16854},  {28100, -16857},  {28098, -16860},  {28096, -16862},  {28095, -16865},
    {28093, -16868},  {28092, -16870},  {28090, -16873},  {28088, -16876},  {28087, -16878},  {28085, -16881},
    {28083, -16884},  {28082, -16887},  {28080, -16889},  {28079, -16892},  {28077, -16895},  {28075, -16897},
    {28074, -16900},  {28072, -16903},  {28070, -16905},  {28069, -16908},  {28067, -16911},  {28066, -16913},
    {28064, -16916},  {28062, -16919},  {28061, -16922},  {28059, -16924},  {28057, -16927},  {28056, -16930},
    {28054, -16932},  {28053, -16935},  {28051, -16938},  {28049, -16940},  {28048, -16943},  {28046, -16946},
    {28044, -16948},  {28043, -16951},  {28041, -16954},  {28040, -16956},  {28038, -16959},  {28036, -16962},
    {28035, -16965},  {28033, -16967},  {28031, -16970},  {28030, -16973},  {28028, -16975},  {28027, -16978},
    {28025, -16981},  {28023, -16983},  {28022, -16986},  {28020, -16989},  {28018, -16991},  {28017, -16994},
    {28015, -16997},  {28014, -16999},  {28012, -17002},  {28010, -17005},  {28009, -17008},  {28007, -17010},
    {28005, -17013},  {28004, -17016},  {28002, -17018},  {28001, -17021},  {27999, -17024},  {27997, -17026},
    {27996, -17029},  {27994, -17032},  {27992, -17034},  {27991, -17037},  {27989, -17040},  {27987, -17042},
    {27986, -17045},  {27984, -17048},  {27983, -17050},  {27981, -17053},  {27979, -17056},  {27978, -17059},
    {27976, -17061},  {27974, -17064},  {27973, -17067},  {27971, -17069},  {27969, -17072},  {27968, -17075},
    {27966, -17077},  {27965, -17080},  {27963, -17083},  {27961, -17085},  {27960, -17088},  {27958, -17091},
    {27956, -17093},  {27955, -17096},  {27953, -17099},  {27951, -17101},  {27950, -17104},  {27948, -17107},
    {27947, -17109},  {27945, -17112},  {27943, -17115},  {27942, -17117},  {27940, -17120},  {27938, -17123},
    {27937, -17126},  {27935, -17128},  {27933, -17131},  {27932, -17134},  {27930, -17136},  {27928, -17139},
    {27927, -17142},  {27925, -17144},  {27924, -17147},  {27922, -17150},  {27920, -17152},  {27919, -17155},
    {27917, -17158},  {27915, -17160},  {27914, -17163},  {27912, -17166},  {27910, -17168},  {27909, -17171},
    {27907, -17174},  {27905, -17176},  {27904, -17179},  {27902, -17182},  {27901, -17184},  {27899, -17187},
    {27897, -17190},  {27896, -17192},  {27894, -17195},  {27892, -17198},  {27891, -17200},  {27889, -17203},
    {27887, -17206},  {27886, -17208},  {27884, -17211},  {27882, -17214},  {27881, -17216},  {27879, -17219},
    {27877, -17222},  {27876, -17225},  {27874, -17227},  {27872, -17230},  {27871, -17233},  {27869, -17235},
    {27868, -17238},  {27866, -17241},  {27864, -17243},  {27863, -17246},  {27861, -17249},  {27859, -17251},
    {27858, -17254},  {27856, -17257},  {27854, -17259},  {27853, -17262},  {27851, -17265},  {27849, -17267},
    {27848, -17270},  {27846, -17273},  {27844, -17275},  {27843, -17278},  {27841, -17281},  {27839, -17283},
    {27838, -17286},  {27836, -17289},  {27834, -17291},  {27833, -17294},  {27831, -17297},  {27829, -17299},
    {27828, -17302},  {27826, -17305},  {27824, -17307},  {27823, -17310},  {27821, -17313},  {27819, -17315},
    {27818, -17318},  {27816, -17321},  {27814, -17323},  {27813, -17326},  {27811, -17329},  {27810, -17331},
    {27808, -17334},  {27806, -17337},  {27805, -17339},  {27803, -17342},  {27801, -17345},  {27800, -17347},
    {27798, -17350},  {27796, -17353},  {27795, -17355},  {27793, -17358},  {27791, -17361},  {27790, -17363},
    {27788, -17366},  {27786, -17369},  {27785, -17371},  {27783, -17374},  {27781, -17377},  {27780, -17379},
    {27778, -17382},  {27776, -17385},  {27775, -17387},  {27773, -17390},  {27771, -17393},  {27770, -17395},
    {27768, -17398},  {27766, -17401},  {27765, -17403},  {27763, -17406},  {27761, -17409},  {27760, -17411},
    {27758, -17414},  {27756, -17417},  {27755, -17419},  {27753, -17422},  {27751, -17425},  {27750, -17427},
    {27748, -17430},  {27746, -17432},  {27745, -17435},  {27743, -17438},  {27741, -17440},  {27739, -17443},
    {27738, -17446},  {27736, -17448},  {27734, -17451},  {27733, -17454},  {27731, -17456},  {27729, -17459},
    {27728, -17462},  {27726, -17464},  {27724, -17467},  {27723, -17470},  {27721, -17472},  {27719, -17475},
    {27718, -17478},  {27716, -17480},  {27714, -17483},  {27713, -17486},  {27711, -17488},  {27709, -17491},
    {27708, -17494},  {27706, -17496},  {27704, -17499},  {27703, -17502},  {27701, -17504},  {27699, -17507},
    {27698, -17510},  {27696, -17512},  {27694, -17515},  {27693, -17518},  {27691, -17520},  {27689, -17523},
    {27688, -17525},  {27686, -17528},  {27684, -17531},  {27682, -17533},  {27681, -17536},  {27679, -17539},
    {27677, -17541},  {27676, -17544},  {27674, -17547},  {27672, -17549},  {27671, -17552},  {27669, -17555},
    {27667, -17557},  {27666, -17560},  {27664, -17563},  {27662, -17565},  {27661, -17568},  {27659, -17571},
    {27657, -17573},  {27656, -17576},  {27654, -17579},  {27652, -17581},  {27650, -17584},  {27649, -17587},
    {27647, -17589},  {27645, -17592},  {27644, -17594},  {27642, -17597},  {27640, -17600},  {27639, -17602},
    {27637, -17605},  {27635, -17608},  {27634, -17610},  {27632, -17613},  {27630, -17616},  {27629, -17618},
    {27627, -17621},  {27625, -17624},  {27623, -17626},  {27622, -17629},  {27620, -17632},  {27618, -17634},
    {27617, -17637},  {27615, -17639},  {27613, -17642},  {27612, -17645},  {27610, -17647},  {27608, -17650},
    {27607, -17653},  {27605, -17655},  {27603, -17658},  {27601, -17661},  {27600, -17663},  {27598, -17666},
    {27596, -17669},  {27595, -17671},  {27593, -17674},  {27591, -17677},  {27590, -17679},  {27588, -17682},
    {27586, -17684},  {27585, -17687},  {27583, -17690},  {27581, -17692},  {27579, -17695},  {27578, -17698},
    {27576, -17700},  {27574, -17703},  {27573, -17706},  {27571, -17708},  {27569, -17711},  {27568, -17714},
    {27566, -17716},  {27564, -17719},  {27562, -17721},  {27561, -17724},  {27559, -17727},  {27557, -17729},
    {27556, -17732},  {27554, -17735},  {27552, -17737},  {27551, -17740},  {27549, -17743},  {27547, -17745},
    {27545, -17748},  {27544, -17751},  {27542, -17753},  {27540, -17756},  {27539, -17758},  {27537, -17761},
    {27535, -17764},  {27534, -17766},  {27532, -17769},  {27530, -17772},  {27528, -17774},  {27527, -17777},
    {27525, -17780},  {27523, -17782},  {27522, -17785},  {27520, -17787},  {27518, -17790},  {27517, -17793},
    {27515, -17795},  {27513, -17798},  {27511, -17801},  {27510, -17803},  {27508, -17806},  {27506, -17809},
    {27505, -17811},  {27503, -17814},  {27501, -17817},  {27499, -17819},  {27498, -17822},  {27496, -17824},
    {27494, -17827},  {27493, -17830},  {27491, -17832},  {27489, -17835},  {27487, -17838},  {27486, -17840},
    {27484, -17843},  {27482, -17846},  {27481, -17848},  {27479, -17851},  {27477, -17853},  {27476, -17856},
    {27474, -17859},  {27472, -17861},  {27470, -17864},  {27469, -17867},  {27467, -17869},  {27465, -17872},
    {27464, -17874},  {27462, -17877},  {27460, -17880},  {27458, -17882},  {27457, -17885},  {27455, -17888},
    {27453, -17890},  {27452, -17893},  {27450, -17896},  {27448, -17898},  {27446, -17901},  {27445, -17903},
    {27443, -17906},  {27441, -17909},  {27440, -17911},  {27438, -17914},  {27436, -17917},  {27434, -17919},
    {27433, -17922},  {27431, -17924},  {27429, -17927},  {27427, -17930},  {27426, -17932},  {27424, -17935},
    {27422, -17938},  {27421, -17940},  {27419, -17943},  {27417, -17946},  {27415, -17948},  {27414, -17951},
    {27412, -17953},  {27410, -17956},  {27409, -17959},  {27407, -17961},  {27405, -17964},  {27403, -17967},
    {27402, -17969},  {27400, -17972},  {27398, -17974},  {27396, -17977},  {27395, -17980},  {27393, -17982},
    {27391, -17985},  {27390, -17988},  {27388, -17990},  {27386, -17993},  {27384, -17995},  {27383, -17998},
    {27381, -18001},  {27379, -18003},  {27378, -18006},  {27376, -18009},  {27374, -18011},  {27372, -18014},
    {27371, -18016},  {27369, -18019},  {27367, -18022},  {27365, -18024},  {27364, -18027},  {27362, -18030},
    {27360, -18032},  {27359, -18035},  {27357, -18037},  {27355, -18040},  {27353, -18043},  {27352, -18045},
    {27350, -18048},  {27348, -18051},  {27346, -18053},  {27345, -18056},  {27343, -18058},  {27341, -18061},
    {27339, -18064},  {27338, -18066},  {27336, -18069},  {27334, -18071},  {27333, -18074},  {27331, -18077},
    {27329, -18079},  {27327, -18082},  {27326, -18085},  {27324, -18087},  {27322, -18090},  {27320, -18092},
    {27319, -18095},  {27317, -18098},  {27315, -18100},  {27313, -18103},  {27312, -18106},  {27310, -18108},
    {27308, -18111},  {27307, -18113},  {27305, -18116},  {27303, -18119},  {27301, -18121},  {27300, -18124},
    {27298, -18126},  {27296, -18129},  {27294, -18132},  {27293, -18134},  {27291, -18137},  {27289, -18140},
    {27287, -18142},  {27286, -18145},  {27284, -18147},  {27282, -18150},  {27280, -18153},  {27279, -18155},
    {27277, -18158},  {27275, -18160},  {27273, -18163},  {27272, -18166},  {27270, -18168},  {27268, -18171},
    {27267, -18174},  {27265, -18176},  {27263, -18179},  {27261, -18181},  {27260, -18184},  {27258, -18187},
    {27256, -18189},  {27254, -18192},  {27253, -18194},  {27251, -18197},  {27249, -18200},  {27247, -18202},
    {27246, -18205},  {27244, -18208},  {27242, -18210},  {27240, -18213},  {27239, -18215},  {27237, -18218},
    {27235, -18221},  {27233, -18223},  {27232, -18226},  {27230, -18228},  {27228, -18231},  {27226, -18234},
    {27225, -18236},  {27223, -18239},  {27221, -18241},  {27219, -18244},  {27218, -18247},  {27216, -18249},
    {27214, -18252},  {27212, -18255},  {27211, -18257},  {27209, -18260},  {27207, -18262},  {27205, -18265},
    {27204, -18268},  {27202, -18270},  {27200, -18273},  {27198, -18275},  {27197, -18278},  {27195, -18281},
    {27193, -18283},  {27191, -18286},  {27190, -18288},  {27188, -18291},  {27186, -18294},  {27184, -18296},
    {27183, -18299},  {27181, -18301},  {27179, -18304},  {27177, -18307},  {27176, -18309},  {27174, -18312},
    {27172, -18314},  {27170, -18317},  {27169, -18320},  {27167, -18322},  {27165, -18325},  {27163, -18328},
    {27162, -18330},  {27160, -18333},  {27158, -18335},  {27156, -18338},  {27154, -18341},  {27153, -18343},
    {27151, -18346},  {27149, -18348},  {27147, -18351},  {27146, -18354},  {27144, -18356},  {27142, -18359},
    {27140, -18361},  {27139, -18364},  {27137, -18367},  {27135, -18369},  {27133, -18372},  {27132, -18374},
    {27130, -18377},  {27128, -18380},  {27126, -18382},  {27125, -18385},  {27123, -18387},  {27121, -18390},
    {27119, -18393},  {27118, -18395},  {27116, -18398},  {27114, -18400},  {27112, -18403},  {27110, -18406},
    {27109, -18408},  {27107, -18411},  {27105, -18413},  {27103, -18416},  {27102, -18419},  {27100, -18421},
    {27098, -18424},  {27096, -18426},  {27095, -18429},  {27093, -18432},  {27091, -18434},  {27089, -18437},
    {27088, -18439},  {27086, -18442},  {27084, -18445},  {27082, -18447},  {27080, -18450},  {27079, -18452},
    {27077, -18455},  {27075, -18458},  {27073, -18460},  {27072, -18463},  {27070, -18465},  {27068, -18468},
    {27066, -18470},  {27064, -18473},  {27063, -18476},  {27061, -18478},  {27059, -18481},  {27057, -18483},
    {27056, -18486},  {27054, -18489},  {27052, -18491},  {27050, -18494},  {27049, -18496},  {27047, -18499},
    {27045, -18502},  {27043, -18504},  {27041, -18507},  {27040, -18509},  {27038, -18512},  {27036, -18515},
    {27034, -18517},  {27033, -18520},  {27031, -18522},  {27029, -18525},  {27027, -18528},  {27025, -18530},
    {27024, -18533},  {27022, -18535},  {27020, -18538},  {27018, -18540},  {27017, -18543},  {27015, -18546},
    {27013, -18548},  {27011, -18551},  {27009, -18553},  {27008, -18556},  {27006, -18559},  {27004, -18561},
    {27002, -18564},  {27001, -18566},  {26999, -18569},  {26997, -18572},  {26995, -18574},  {26993, -18577},
    {26992, -18579},  {26990, -18582},  {26988, -18585},  {26986, -18587},  {26985, -18590},  {26983, -18592},
    {26981, -18595},  {26979, -18597},  {26977, -18600},  {26976, -18603},  {26974, -18605},  {26972, -18608},
    {26970, -18610},  {26968, -18613},  {26967, -18616},  {26965, -18618},  {26963, -18621},  {26961, -18623},
    {26960, -18626},  {26958, -18628},  {26956, -18631},  {26954, -18634},  {26952, -18636},  {26951, -18639},
    {26949, -18641},  {26947, -18644},  {26945, -18647},  {26943, -18649},  {26942, -18652},  {26940, -18654},
    {26938, -18657},  {26936, -18659},  {26935, -18662},  {26933, -18665},  {26931, -18667},  {26929, -18670},
    {26927, -18672},  {26926, -18675},  {26924, -18678},  {26922, -18680},  {26920, -18683},  {26918, -18685},
    {26917, -18688},  {26915, -18690},  {26913, -18693},  {26911, -18696},  {26909, -18698},  {26908, -18701},
    {26906, -18703},  {26904, -18706},  {26902, -18709},  {26901, -18711},  {26899, -18714},  {26897, -18716},
    {26895, -18719},  {26893, -18721},  {26892, -18724},  {26890, -18727},  {26888, -18729},  {26886, -18732},
    {26884, -18734},  {26883, -18737},  {26881, -18739},  {26879, -18742},  {26877, -18745},  {26875, -18747},
    {26874, -18750},  {26872, -18752},  {26870, -18755},  {26868, -18757},  {26866, -18760},  {26865, -18763},
    {26863, -18765},  {26861, -18768},  {26859, -18770},  {26857, -18773},  {26856, -18776},  {26854, -18778},
    {26852, -18781},  {26850, -18783},  {26848, -18786},  {26847, -18788},  {26845, -18791},  {26843, -18794},
    {26841, -18796},  {26839, -18799},  {26838, -18801},  {26836, -18804},  {26834, -18806},  {26832, -18809},
    {26830, -18812},  {26829, -18814},  {26827, -18817},  {26825, -18819},  {26823, -18822},  {26821, -18824},
    {26820, -18827},  {26818, -18830},  {26816, -18832},  {26814, -18835},  {26812, -18837},  {26811, -18840},
    {26809, -18842},  {26807, -18845},  {26805, -18848},  {26803, -18850},  {26801, -18853},  {26800, -18855},
    {26798, -18858},  {26796, -18860},  {26794, -18863},  {26792, -18866},  {26791, -18868},  {26789, -18871},
    {26787, -18873},  {26785, -18876},  {26783, -18878},  {26782, -18881},  {26780, -18883},  {26778, -18886},
    {26776, -18889},  {26774, -18891},  {26773, -18894},  {26771, -18896},  {26769, -18899},  {26767, -18901},
    {26765, -18904},  {26763, -18907},  {26762, -18909},  {26760, -18912},  {26758, -18914},  {26756, -18917},
    {26754, -18919},  {26753, -18922},  {26751, -18925},  {26749, -18927},  {26747, -18930},  {26745, -18932},
    {26744, -18935},  {26742, -18937},  {26740, -18940},  {26738, -18942},  {26736, -18945},  {26734, -18948},
    {26733, -18950},  {26731, -18953},  {26729, -18955},  {26727, -18958},  {26725, -18960},  {26724, -18963},
    {26722, -18966},  {26720, -18968},  {26718, -18971},  {26716, -18973},  {26714, -18976},  {26713, -18978},
    {26711, -18981},  {26709, -18983},  {26707, -18986},  {26705, -18989},  {26704, -18991},  {26702, -18994},
    {26700, -18996},  {26698, -18999},  {26696, -19001},  {26694, -19004},  {26693, -19007},  {26691, -19009},
    {26689, -19012},  {26687, -19014},  {26685, -19017},  {26683, -19019},  {26682, -19022},  {26680, -19024},
    {26678, -19027},  {26676, -19030},  {26674, -19032},  {26673, -19035},  {26671, -19037},  {26669, -19040},
    {26667, -19042},  {26665, -19045},  {26663, -19047},  {26662, -19050},  {26660, -19053},  {26658, -19055},
    {26656, -19058},  {26654, -19060},  {26652, -19063},  {26651, -19065},  {26649, -19068},  {26647, -19070},
    {26645, -19073},  {26643, -19076},  {26641, -19078},  {26640, -19081},  {26638, -19083},  {26636, -19086},
    {26634, -19088},  {26632, -19091},  {26630, -19093},  {26629, -19096},  {26627, -19099},  {26625, -19101},
    {26623, -19104},  {26621, -19106},  {26619, -19109},  {26618, -19111},  {26616, -19114},  {26614, -19116},
    {26612, -19119},  {26610, -19122},  {26608, -19124},  {26607, -19127},  {26605, -19129},  {26603, -19132},
    {26601, -19134},  {26599, -19137},  {26597, -19139},  {26596, -19142},  {26594, -19144},  {26592, -19147},
    {26590, -19150},  {26588, -19152},  {26586, -19155},  {26585, -19157},  {26583, -19160},  {26581, -19162},
    {26579, -19165},  {26577, -19167},  {26575, -19170},  {26574, -19173},  {26572, -19175},  {26570, -19178},
    {26568, -19180},  {26566, -19183},  {26564, -19185},  {26563, -19188},  {26561, -19190},  {26559, -19193},
    {26557, -19195},  {26555, -19198},  {26553, -19201},  {26552, -19203},  {26550, -19206},  {26548, -19208},
    {26546, -19211},  {26544, -19213},  {26542, -19216},  {26540, -19218},  {26539, -19221},  {26537, -19223},
    {26535, -19226},  {26533, -19229},  {26531, -19231},  {26529, -19234},  {26528, -19236},  {26526, -19239},
    {26524, -19241},  {26522, -19244},  {26520, -19246},  {26518, -19249},  {26517, -19251},  {26515, -19254},
    {26513, -19256},  {26511, -19259},  {26509, -19262},  {26507, -19264},  {26505, -19267},  {26504, -19269},
    {26502, -19272},  {26500, -19274},  {26498, -19277},  {26496, -19279},  {26494, -19282},  {26493, -19284},
    {26491, -19287},  {26489, -19290},  {26487, -19292},  {26485, -19295},  {26483, -19297},  {26481, -19300},
    {26480, -19302},  {26478, -19305},  {26476, -19307},  {26474, -19310},  {26472, -19312},  {26470, -19315},
    {26468, -19317},  {26467, -19320},  {26465, -19323},  {26463, -19325},  {26461, -19328},  {26459, -19330},
    {26457, -19333},  {26455, -19335},  {26454, -19338},  {26452, -19340},  {26450, -19343},  {26448, -19345},
    {26446, -19348},  {26444, -19350},  {26442, -19353},  {26441, -19355},  {26439, -19358},  {26437, -19361},
    {26435, -19363},  {26433, -19366},  {26431, -19368},  {26429, -19371},  {26428, -19373},  {26426, -19376},
    {26424, -19378},  {26422, -19381},  {26420, -19383},  {26418, -19386},  {26416, -19388},  {26415, -19391},
    {26413, -19393},  {26411, -19396},  {26409, -19399},  {26407, -19401},  {26405, -19404},  {26403, -19406},
    {26402, -19409},  {26400, -19411},  {26398, -19414},  {26396, -19416},  {26394, -19419},  {26392, -19421},
    {26390, -19424},  {26389, -19426},  {26387, -19429},  {26385, -19431},  {26383, -19434},  {26381, -19437},
    {26379, -19439},  {26377, -19442},  {26376, -19444},  {26374, -19447},  {26372, -19449},  {26370, -19452},
    {26368, -19454},  {26366, -19457},  {26364, -19459},  {26362, -19462},  {26361, -19464},  {26359, -19467},
    {26357, -19469},  {26355, -19472},  {26353, -19474},  {26351, -19477},  {26349, -19479},  {26348, -19482},
    {26346, -19485},  {26344, -19487},  {26342, -19490},  {26340, -19492},  {26338, -19495},  {26336, -19497},
    {26334, -19500},  {26333, -19502},  {26331, -19505},  {26329, -19507},  {26327, -19510},  {26325, -19512},
    {26323, -19515},  {26321, -19517},  {26320, -19520},  {26318, -19522},  {26316, -19525},  {26314, -19527},
    {26312, -19530},  {26310, -19532},  {26308, -19535},  {26306, -19538},  {26305, -19540},  {26303, -19543},
    {26301, -19545},  {26299, -19548},  {26297, -19550},  {26295, -19553},  {26293, -19555},  {26291, -19558},
    {26290, -19560},  {26288, -19563},  {26286, -19565},  {26284, -19568},  {26282, -19570},  {26280, -19573},
    {26278, -19575},  {26276, -19578},  {26275, -19580},  {26273, -19583},  {26271, -19585},  {26269, -19588},
    {26267, -19590},  {26265, -19593},  {26263, -19595},  {26261, -19598},  {26259, -19601},  {26258, -19603},
    {26256, -19606},  {26254, -19608},  {26252, -19611},  {26250, -19613},  {26248, -19616},  {26246, -19618},
    {26244, -19621},  {26243, -19623},  {26241, -19626},  {26239, -19628},  {26237, -19631},  {26235, -19633},
    {26233, -19636},  {26231, -19638},  {26229, -19641},  {26228, -19643},  {26226, -19646},  {26224, -19648},
    {26222, -19651},  {26220, -19653},  {26218, -19656},  {26216, -19658},  {26214, -19661},  {26212, -19663},
    {26211, -19666},  {26209, -19668},  {26207, -19671},  {26205, -19673},  {26203, -19676},  {26201, -19678},
    {26199, -19681},  {26197, -19684},  {26195, -19686},  {26194, -19689},  {26192, -19691},  {26190, -19694},
    {26188, -19696},  {26186, -19699},  {26184, -19701},  {26182, -19704},  {26180, -19706},  {26178, -19709},
    {26177, -19711},  {26175, -19714},  {26173, -19716},  {26171, -19719},  {26169, -19721},  {26167, -19724},
    {26165, -19726},  {26163, -19729},  {26161, -19731},  {26160, -19734},  {26158, -19736},  {26156, -19739},
    {26154, -19741},  {26152, -19744},  {26150, -19746},  {26148, -19749},  {26146, -19751},  {26144, -19754},
    {26143, -19756},  {26141, -19759},  {26139, -19761},  {26137, -19764},  {26135, -19766},  {26133, -19769},
    {26131, -19771},  {26129, -19774},  {26127, -19776},  {26125, -19779},  {26124, -19781},  {26122, -19784},
    {26120, -19786},  {26118, -19789},  {26116, -19791},  {26114, -19794},  {26112, -19796},  {26110, -19799},
    {26108, -19801},  {26106, -19804},  {26105, -19806},  {26103, -19809},  {26101, -19811},  {26099, -19814},
    {26097, -19816},  {26095, -19819},  {26093, -19821},  {26091, -19824},  {26089, -19826},  {26087, -19829},
    {26086, -19831},  {26084, -19834},  {26082, -19836},  {26080, -19839},  {26078, -19841},  {26076, -19844},
    {26074, -19846},  {26072, -19849},  {26070, -19851},  {26068, -19854},  {26067, -19856},  {26065, -19859},
    {26063, -19861},  {26061, -19864},  {26059, -19866},  {26057, -19869},  {26055, -19871},  {26053, -19874},
    {26051, -19876},  {26049, -19879},  {26048, -19881},  {26046, -19884},  {26044, -19886},  {26042, -19889},
    {26040, -19891},  {26038, -19894},  {26036, -19896},  {26034, -19899},  {26032, -19901},  {26030, -19904},
    {26028, -19906},  {26027, -19909},  {26025, -19911},  {26023, -19914},  {26021, -19916},  {26019, -19919},
    {26017, -19921},  {26015, -19924},  {26013, -19926},  {26011, -19929},  {26009, -19931},  {26007, -19934},
    {26006, -19936},  {26004, -19939},  {26002, -19941},  {26000, -19944},  {25998, -19946},  {25996, -19949},
    {25994, -19951},  {25992, -19954},  {25990, -19956},  {25988, -19959},  {25986, -19961},  {25984, -19964},
    {25983, -19966},  {25981, -19969},  {25979, -19971},  {25977, -19974},  {25975, -19976},  {25973, -19979},
    {25971, -19981},  {25969, -19984},  {25967, -19986},  {25965, -19989},  {25963, -19991},  {25961, -19994},
    {25960, -19996},  {25958, -19999},  {25956, -20001},  {25954, -20004},  {25952, -20006},  {25950, -20008},
    {25948, -20011},  {25946, -20013},  {25944, -20016},  {25942, -20018},  {25940, -20021},  {25938, -20023},
    {25937, -20026},  {25935, -20028},  {25933, -20031},  {25931, -20033},  {25929, -20036},  {25927, -20038},
    {25925, -20041},  {25923, -20043},  {25921, -20046},  {25919, -20048},  {25917, -20051},  {25915, -20053},
    {25914, -20056},  {25912, -20058},  {25910, -20061},  {25908, -20063},  {25906, -20066},  {25904, -20068},
    {25902, -20071},  {25900, -20073},  {25898, -20076},  {25896, -20078},  {25894, -20081},  {25892, -20083},
    {25890, -20086},  {25888, -20088},  {25887, -20090},  {25885, -20093},  {25883, -20095},  {25881, -20098},
    {25879, -20100},  {25877, -20103},  {25875, -20105},  {25873, -20108},  {25871, -20110},  {25869, -20113},
    {25867, -20115},  {25865, -20118},  {25863, -20120},  {25862, -20123},  {25860, -20125},  {25858, -20128},
    {25856, -20130},  {25854, -20133},  {25852, -20135},  {25850, -20138},  {25848, -20140},  {25846, -20143},
    {25844, -20145},  {25842, -20148},  {25840, -20150},  {25838, -20152},  {25836, -20155},  {25834, -20157},
    {25833, -20160},  {25831, -20162},  {25829, -20165},  {25827, -20167},  {25825, -20170},  {25823, -20172},
    {25821, -20175},  {25819, -20177},  {25817, -20180},  {25815, -20182},  {25813, -20185},  {25811, -20187},
    {25809, -20190},  {25807, -20192},  {25805, -20195},  {25804, -20197},  {25802, -20200},  {25800, -20202},
    {25798, -20204},  {25796, -20207},  {25794, -20209},  {25792, -20212},  {25790, -20214},  {25788, -20217},
    {25786, -20219},  {25784, -20222},  {25782, -20224},  {25780, -20227},  {25778, -20229},  {25776, -20232},
    {25774, -20234},  {25773, -20237},  {25771, -20239},  {25769, -20242},  {25767, -20244},  {25765, -20246},
    {25763, -20249},  {25761, -20251},  {25759, -20254},  {25757, -20256},  {25755, -20259},  {25753, -20261},
    {25751, -20264},  {25749, -20266},  {25747, -20269},  {25745, -20271},  {25743, -20274},  {25741, -20276},
    {25739, -20279},  {25738, -20281},  {25736, -20284},  {25734, -20286},  {25732, -20288},  {25730, -20291},
    {25728, -20293},  {25726, -20296},  {25724, -20298},  {25722, -20301},  {25720, -20303},  {25718, -20306},
    {25716, -20308},  {25714, -20311},  {25712, -20313},  {25710, -20316},  {25708, -20318},  {25706, -20320},
    {25704, -20323},  {25703, -20325},  {25701, -20328},  {25699, -20330},  {25697, -20333},  {25695, -20335},
    {25693, -20338},  {25691, -20340},  {25689, -20343},  {25687, -20345},  {25685, -20348},  {25683, -20350},
    {25681, -20353},  {25679, -20355},  {25677, -20357},  {25675, -20360},  {25673, -20362},  {25671, -20365},
    {25669, -20367},  {25667, -20370},  {25665, -20372},  {25663, -20375},  {25662, -20377},  {25660, -20380},
    {25658, -20382},  {25656, -20385},  {25654, -20387},  {25652, -20389},  {25650, -20392},  {25648, -20394},
    {25646, -20397},  {25644, -20399},  {25642, -20402},  {25640, -20404},  {25638, -20407},  {25636, -20409},
    {25634, -20412},  {25632, -20414},  {25630, -20416},  {25628, -20419},  {25626, -20421},  {25624, -20424},
    {25622, -20426},  {25620, -20429},  {25618, -20431},  {25617, -20434},  {25615, -20436},  {25613, -20439},
    {25611, -20441},  {25609, -20443},  {25607, -20446},  {25605, -20448},  {25603, -20451},  {25601, -20453},
    {25599, -20456},  {25597, -20458},  {25595, -20461},  {25593, -20463},  {25591, -20466},  {25589, -20468},
    {25587, -20470},  {25585, -20473},  {25583, -20475},  {25581, -20478},  {25579, -20480},  {25577, -20483},
    {25575, -20485},  {25573, -20488},  {25571, -20490},  {25569, -20493},  {25567, -20495},  {25566, -20497},
    {25564, -20500},  {25562, -20502},  {25560, -20505},  {25558, -20507},  {25556, -20510},  {25554, -20512},
    {25552, -20515},  {25550, -20517},  {25548, -20520},  {25546, -20522},  {25544, -20524},  {25542, -20527},
    {25540, -20529},  {25538, -20532},  {25536, -20534},  {25534, -20537},  {25532, -20539},  {25530, -20542},
    {25528, -20544},  {25526, -20546},  {25524, -20549},  {25522, -20551},  {25520, -20554},  {25518, -20556},
    {25516, -20559},  {25514, -20561},  {25512, -20564},  {25510, -20566},  {25508, -20568},  {25506, -20571},
    {25504, -20573},  {25503, -20576},  {25501, -20578},  {25499, -20581},  {25497, -20583},  {25495, -20586},
    {25493, -20588},  {25491, -20590},  {25489, -20593},  {25487, -20595},  {25485, -20598},  {25483, -20600},
    {25481, -20603},  {25479, -20605},  {25477, -20608},  {25475, -20610},  {25473, -20612},  {25471, -20615},
    {25469, -20617},  {25467, -20620},  {25465, -20622},  {25463, -20625},  {25461, -20627},  {25459, -20630},
    {25457, -20632},  {25455, -20634},  {25453, -20637},  {25451, -20639},  {25449, -20642},  {25447, -20644},
    {25445, -20647},  {25443, -20649},  {25441, -20652},  {25439, -20654},  {25437, -20656},  {25435, -20659},
    {25433, -20661},  {25431, -20664},  {25429, -20666},  {25427, -20669},  {25425, -20671},  {25423, -20673},
    {25421, -20676},  {25419, -20678},  {25417, -20681},  {25415, -20683},  {25414, -20686},  {25412, -20688},
    {25410, -20691},  {25408, -20693},  {25406, -20695},  {25404, -20698},  {25402, -20700},  {25400, -20703},
    {25398, -20705},  {25396, -20708},  {25394, -20710},  {25392, -20712},  {25390, -20715},  {25388, -20717},
    {25386, -20720},  {25384, -20722},  {25382, -20725},  {25380, -20727},  {25378, -20729},  {25376, -20732},
    {25374, -20734},  {25372, -20737},  {25370, -20739},  {25368, -20742},  {25366, -20744},  {25364, -20746},
    {25362, -20749},  {25360, -20751},  {25358, -20754},  {25356, -20756},  {25354, -20759},  {25352, -20761},
    {25350, -20764},  {25348, -20766},  {25346, -20768},  {25344, -20771},  {25342, -20773},  {25340, -20776},
    {25338, -20778},  {25336, -20781},  {25334, -20783},  {25332, -20785},  {25330, -20788},  {25328, -20790},
    {25326, -20793},  {25324, -20795},  {25322, -20798},  {25320, -20800},  {25318, -20802},  {25316, -20805},
    {25314, -20807},  {25312, -20810},  {25310, -20812},  {25308, -20815},  {25306, -20817},  {25304, -20819},
    {25302, -20822},  {25300, -20824},  {25298, -20827},  {25296, -20829},  {25294, -20831},  {25292, -20834},
    {25290, -20836},  {25288, -20839},  {25286, -20841},  {25284, -20844},  {25282, -20846},  {25280, -20848},
    {25278, -20851},  {25276, -20853},  {25274, -20856},  {25272, -20858},  {25270, -20861},  {25268, -20863},
    {25266, -20865},  {25264, -20868},  {25262, -20870},  {25260, -20873},  {25258, -20875},  {25256, -20878},
    {25254, -20880},  {25252, -20882},  {25250, -20885},  {25248, -20887},  {25246, -20890},  {25244, -20892},
    {25242, -20894},  {25240, -20897},  {25238, -20899},  {25236, -20902},  {25234, -20904},  {25232, -20907},
    {25230, -20909},  {25228, -20911},  {25226, -20914},  {25224, -20916},  {25222, -20919},  {25220, -20921},
    {25218, -20923},  {25216, -20926},  {25214, -20928},  {25212, -20931},  {25210, -20933},  {25208, -20936},
    {25206, -20938},  {25204, -20940},  {25202, -20943},  {25200, -20945},  {25198, -20948},  {25196, -20950},
    {25194, -20952},  {25192, -20955},  {25190, -20957},  {25188, -20960},  {25186, -20962},  {25184, -20965},
    {25182, -20967},  {25180, -20969},  {25178, -20972},  {25176, -20974},  {25174, -20977},  {25172, -20979},
    {25170, -20981},  {25168, -20984},  {25166, -20986},  {25164, -20989},  {25162, -20991},  {25160, -20994},
    {25158, -20996},  {25156, -20998},  {25154, -21001},  {25152, -21003},  {25150, -21006},  {25148, -21008},
    {25146, -21010},  {25144, -21013},  {25142, -21015},  {25140, -21018},  {25138, -21020},  {25136, -21022},
    {25134, -21025},  {25132, -21027},  {25130, -21030},  {25128, -21032},  {25126, -21035},  {25123, -21037},
    {25121, -21039},  {25119, -21042},  {25117, -21044},  {25115, -21047},  {25113, -21049},  {25111, -21051},
    {25109, -21054},  {25107, -21056},  {25105, -21059},  {25103, -21061},  {25101, -21063},  {25099, -21066},
    {25097, -21068},  {25095, -21071},  {25093, -21073},  {25091, -21075},  {25089, -21078},  {25087, -21080},
    {25085, -21083},  {25083, -21085},  {25081, -21087},  {25079, -21090},  {25077, -21092},  {25075, -21095},
    {25073, -21097},  {25071, -21099},  {25069, -21102},  {25067, -21104},  {25065, -21107},  {25063, -21109},
    {25061, -21111},  {25059, -21114},  {25057, -21116},  {25055, -21119},  {25053, -21121},  {25051, -21124},
    {25049, -21126},  {25047, -21128},  {25045, -21131},  {25043, -21133},  {25041, -21136},  {25039, -21138},
    {25037, -21140},  {25035, -21143},  {25033, -21145},  {25030, -21148},  {25028, -21150},  {25026, -21152},
    {25024, -21155},  {25022, -21157},  {25020, -21160},  {25018, -21162},  {25016, -21164},  {25014, -21167},
    {25012, -21169},  {25010, -21171},  {25008, -21174},  {25006, -21176},  {25004, -21179},  {25002, -21181},
    {25000, -21183},  {24998, -21186},  {24996, -21188},  {24994, -21191},  {24992, -21193},  {24990, -21195},
    {24988, -21198},  {24986, -21200},  {24984, -21203},  {24982, -21205},  {24980, -21207},  {24978, -21210},
    {24976, -21212},  {24974, -21215},  {24972, -21217},  {24970, -21219},  {24968, -21222},  {24965, -21224},
    {24963, -21227},  {24961, -21229},  {24959, -21231},  {24957, -21234},  {24955, -21236},  {24953, -21239},
    {24951, -21241},  {24949, -21243},  {24947, -21246},  {24945, -21248},  {24943, -21251},  {24941, -21253},
    {24939, -21255},  {24937, -21258},  {24935, -21260},  {24933, -21262},  {24931, -21265},  {24929, -21267},
    {24927, -21270},  {24925, -21272},  {24923, -21274},  {24921, -21277},  {24919, -21279},  {24917, -21282},
    {24915, -21284},  {24912, -21286},  {24910, -21289},  {24908, -21291},  {24906, -21294},  {24904, -21296},
    {24902, -21298},  {24900, -21301},  {24898, -21303},  {24896, -21305},  {24894, -21308},  {24892, -21310},
    {24890, -21313},  {24888, -21315},  {24886, -21317},  {24884, -21320},  {24882, -21322},  {24880, -21325},
    {24878, -21327},  {24876, -21329},  {24874, -21332},  {24872, -21334},  {24870, -21336},  {24868, -21339},
    {24865, -21341},  {24863, -21344},  {24861, -21346},  {24859, -21348},  {24857, -21351},  {24855, -21353},
    {24853, -21356},  {24851, -21358},  {24849, -21360},  {24847, -21363},  {24845, -21365},  {24843, -21367},
    {24841, -21370},  {24839, -21372},  {24837, -21375},  {24835, -21377},  {24833, -21379},  {24831, -21382},
    {24829, -21384},  {24827, -21387},  {24825, -21389},  {24822, -21391},  {24820, -21394},  {24818, -21396},
    {24816, -21398},  {24814, -21401},  {24812, -21403},  {24810, -21406},  {24808, -21408},  {24806, -21410},
    {24804, -21413},  {24802, -21415},  {24800, -21417},  {24798, -21420},  {24796, -21422},  {24794, -21425},
    {24792, -21427},  {24790, -21429},  {24788, -21432},  {24786, -21434},  {24783, -21436},  {24781, -21439},
    {24779, -21441},  {24777, -21444},  {24775, -21446},  {24773, -21448},  {24771, -21451},  {24769, -21453},
    {24767, -21455},  {24765, -21458},  {24763, -21460},  {24761, -21463},  {24759, -21465},  {24757, -21467},
    {24755, -21470},  {24753, -21472},  {24751, -21474},  {24748, -21477},  {24746, -21479},  {24744, -21482},
    {24742, -21484},  {24740, -21486},  {24738, -21489},  {24736, -21491},  {24734, -21493},  {24732, -21496},
    {24730, -21498},  {24728, -21501},  {24726, -21503},  {24724, -21505},  {24722, -21508},  {24720, -21510},
    {24718, -21512},  {24716, -21515},  {24713, -21517},  {24711, -21519},  {24709, -21522},  {24707, -21524},
    {24705, -21527},  {24703, -21529},  {24701, -21531},  {24699, -21534},  {24697, -21536},  {24695, -21538},
    {24693, -21541},  {24691, -21543},  {24689, -21546},  {24687, -21548},  {24685, -21550},  {24682, -21553},
    {24680, -21555},  {24678, -21557},  {24676, -21560},  {24674, -21562},  {24672, -21564},  {24670, -21567},
    {24668, -21569},  {24666, -21572},  {24664, -21574},  {24662, -21576},  {24660, -21579},  {24658, -21581},
    {24656, -21583},  {24654, -21586},  {24651, -21588},  {24649, -21590},  {24647, -21593},  {24645, -21595},
    {24643, -21598},  {24641, -21600},  {24639, -21602},  {24637, -21605},  {24635, -21607},  {24633, -21609},
    {24631, -21612},  {24629, -21614},  {24627, -21616},  {24625, -21619},  {24622, -21621},  {24620, -21624},
    {24618, -21626},  {24616, -21628},  {24614, -21631},  {24612, -21633},  {24610, -21635},  {24608, -21638},
    {24606, -21640},  {24604, -21642},  {24602, -21645},  {24600, -21647},  {24598, -21649},  {24596, -21652},
    {24593, -21654},  {24591, -21657},  {24589, -21659},  {24587, -21661},  {24585, -21664},  {24583, -21666},
    {24581, -21668},  {24579, -21671},  {24577, -21673},  {24575, -21675},  {24573, -21678},  {24571, -21680},
    {24569, -21682},  {24566, -21685},  {24564, -21687},  {24562, -21690},  {24560, -21692},  {24558, -21694},
    {24556, -21697},  {24554, -21699},  {24552, -21701},  {24550, -21704},  {24548, -21706},  {24546, -21708},
    {24544, -21711},  {24541, -21713},  {24539, -21715},  {24537, -21718},  {24535, -21720},  {24533, -21723},
    {24531, -21725},  {24529, -21727},  {24527, -21730},  {24525, -21732},  {24523, -21734},  {24521, -21737},
    {24519, -21739},  {24516, -21741},  {24514, -21744},  {24512, -21746},  {24510, -21748},  {24508, -21751},
    {24506, -21753},  {24504, -21755},  {24502, -21758},  {24500, -21760},  {24498, -21762},  {24496, -21765},
    {24494, -21767},  {24491, -21770},  {24489, -21772},  {24487, -21774},  {24485, -21777},  {24483, -21779},
    {24481, -21781},  {24479, -21784},  {24477, -21786},  {24475, -21788},  {24473, -21791},  {24471, -21793},
    {24468, -21795},  {24466, -21798},  {24464, -21800},  {24462, -21802},  {24460, -21805},  {24458, -21807},
    {24456, -21809},  {24454, -21812},  {24452, -21814},  {24450, -21816},  {24448, -21819},  {24445, -21821},
    {24443, -21823},  {24441, -21826},  {24439, -21828},  {24437, -21830},  {24435, -21833},  {24433, -21835},
    {24431, -21838},  {24429, -21840},  {24427, -21842},  {24425, -21845},  {24422, -21847},  {24420, -21849},
    {24418, -21852},  {24416, -21854},  {24414, -21856},  {24412, -21859},  {24410, -21861},  {24408, -21863},
    {24406, -21866},  {24404, -21868},  {24401, -21870},  {24399, -21873},  {24397, -21875},  {24395, -21877},
    {24393, -21880},  {24391, -21882},  {24389, -21884},  {24387, -21887},  {24385, -21889},  {24383, -21891},
    {24380, -21894},  {24378, -21896},  {24376, -21898},  {24374, -21901},  {24372, -21903},  {24370, -21905},
    {24368, -21908},  {24366, -21910},  {24364, -21912},  {24362, -21915},  {24359, -21917},  {24357, -21919},
    {24355, -21922},  {24353, -21924},  {24351, -21926},  {24349, -21929},  {24347, -21931},  {24345, -21933},
    {24343, -21936},  {24341, -21938},  {24338, -21940},  {24336, -21943},  {24334, -21945},  {24332, -21947},
    {24330, -21950},  {24328, -21952},  {24326, -21954},  {24324, -21957},  {24322, -21959},  {24320, -21961},
    {24317, -21964},  {24315, -21966},  {24313, -21968},  {24311, -21971},  {24309, -21973},  {24307, -21975},
    {24305, -21978},  {24303, -21980},  {24301, -21982},  {24298, -21985},  {24296, -21987},  {24294, -21989},
    {24292, -21992},  {24290, -21994},  {24288, -21996},  {24286, -21999},  {24284, -22001},  {24282, -22003},
    {24279, -22006},  {24277, -22008},  {24275, -22010},  {24273, -22013},  {24271, -22015},  {24269, -22017},
    {24267, -22020},  {24265, -22022},  {24263, -22024},  {24260, -22027},  {24258, -22029},  {24256, -22031},
    {24254, -22034},  {24252, -22036},  {24250, -22038},  {24248, -22041},  {24246, -22043},  {24244, -22045},
    {24241, -22048},  {24239, -22050},  {24237, -22052},  {24235, -22054},  {24233, -22057},  {24231, -22059},
    {24229, -22061},  {24227, -22064},  {24225, -22066},  {24222, -22068},  {24220, -22071},  {24218, -22073},
    {24216, -22075},  {24214, -22078},  {24212, -22080},  {24210, -22082},  {24208, -22085},  {24206, -22087},
    {24203, -22089},  {24201, -22092},  {24199, -22094},  {24197, -22096},  {24195, -22099},  {24193, -22101},
    {24191, -22103},  {24189, -22106},  {24186, -22108},  {24184, -22110},  {24182, -22113},  {24180, -22115},
    {24178, -22117},  {24176, -22119},  {24174, -22122},  {24172, -22124},  {24169, -22126},  {24167, -22129},
    {24165, -22131},  {24163, -22133},  {24161, -22136},  {24159, -22138},  {24157, -22140},  {24155, -22143},
    {24152, -22145},  {24150, -22147},  {24148, -22150},  {24146, -22152},  {24144, -22154},  {24142, -22157},
    {24140, -22159},  {24138, -22161},  {24136, -22163},  {24133, -22166},  {24131, -22168},  {24129, -22170},
    {24127, -22173},  {24125, -22175},  {24123, -22177},  {24121, -22180},  {24119, -22182},  {24116, -22184},
    {24114, -22187},  {24112, -22189},  {24110, -22191},  {24108, -22194},  {24106, -22196},  {24104, -22198},
    {24101, -22200},  {24099, -22203},  {24097, -22205},  {24095, -22207},  {24093, -22210},  {24091, -22212},
    {24089, -22214},  {24087, -22217},  {24084, -22219},  {24082, -22221},  {24080, -22224},  {24078, -22226},
    {24076, -22228},  {24074, -22230},  {24072, -22233},  {24070, -22235},  {24067, -22237},  {24065, -22240},
    {24063, -22242},  {24061, -22244},  {24059, -22247},  {24057, -22249},  {24055, -22251},  {24052, -22254},
    {24050, -22256},  {24048, -22258},  {24046, -22260},  {24044, -22263},  {24042, -22265},  {24040, -22267},
    {24038, -22270},  {24035, -22272},  {24033, -22274},  {24031, -22277},  {24029, -22279},  {24027, -22281},
    {24025, -22284},  {24023, -22286},  {24020, -22288},  {24018, -22290},  {24016, -22293},  {24014, -22295},
    {24012, -22297},  {24010, -22300},  {24008, -22302},  {24005, -22304},  {24003, -22307},  {24001, -22309},
    {23999, -22311},  {23997, -22313},  {23995, -22316},  {23993, -22318},  {23991, -22320},  {23988, -22323},
    {23986, -22325},  {23984, -22327},  {23982, -22330},  {23980, -22332},  {23978, -22334},  {23976, -22336},
    {23973, -22339},  {23971, -22341},  {23969, -22343},  {23967, -22346},  {23965, -22348},  {23963, -22350},
    {23961, -22353},  {23958, -22355},  {23956, -22357},  {23954, -22359},  {23952, -22362},  {23950, -22364},
    {23948, -22366},  {23946, -22369},  {23943, -22371},  {23941, -22373},  {23939, -22375},  {23937, -22378},
    {23935, -22380},  {23933, -22382},  {23930, -22385},  {23928, -22387},  {23926, -22389},  {23924, -22392},
    {23922, -22394},  {23920, -22396},  {23918, -22398},  {23915, -22401},  {23913, -22403},  {23911, -22405},
    {23909, -22408},  {23907, -22410},  {23905, -22412},  {23903, -22414},  {23900, -22417},  {23898, -22419},
    {23896, -22421},  {23894, -22424},  {23892, -22426},  {23890, -22428},  {23888, -22431},  {23885, -22433},
    {23883, -22435},  {23881, -22437},  {23879, -22440},  {23877, -22442},  {23875, -22444},  {23872, -22447},
    {23870, -22449},  {23868, -22451},  {23866, -22453},  {23864, -22456},  {23862, -22458},  {23860, -22460},
    {23857, -22463},  {23855, -22465},  {23853, -22467},  {23851, -22469},  {23849, -22472},  {23847, -22474},
    {23844, -22476},  {23842, -22479},  {23840, -22481},  {23838, -22483},  {23836, -22485},  {23834, -22488},
    {23832, -22490},  {23829, -22492},  {23827, -22495},  {23825, -22497},  {23823, -22499},  {23821, -22501},
    {23819, -22504},  {23816, -22506},  {23814, -22508},  {23812, -22511},  {23810, -22513},  {23808, -22515},
    {23806, -22517},  {23803, -22520},  {23801, -22522},  {23799, -22524},  {23797, -22527},  {23795, -22529},
    {23793, -22531},  {23791, -22533},  {23788, -22536},  {23786, -22538},  {23784, -22540},  {23782, -22542},
    {23780, -22545},  {23778, -22547},  {23775, -22549},  {23773, -22552},  {23771, -22554},  {23769, -22556},
    {23767, -22558},  {23765, -22561},  {23762, -22563},  {23760, -22565},  {23758, -22568},  {23756, -22570},
    {23754, -22572},  {23752, -22574},  {23749, -22577},  {23747, -22579},  {23745, -22581},  {23743, -22583},
    {23741, -22586},  {23739, -22588},  {23736, -22590},  {23734, -22593},  {23732, -22595},  {23730, -22597},
    {23728, -22599},  {23726, -22602},  {23723, -22604},  {23721, -22606},  {23719, -22609},  {23717, -22611},
    {23715, -22613},  {23713, -22615},  {23710, -22618},  {23708, -22620},  {23706, -22622},  {23704, -22624},
    {23702, -22627},  {23700, -22629},  {23697, -22631},  {23695, -22634},  {23693, -22636},  {23691, -22638},
    {23689, -22640},  {23687, -22643},  {23684, -22645},  {23682, -22647},  {23680, -22649},  {23678, -22652},
    {23676, -22654},  {23674, -22656},  {23671, -22658},  {23669, -22661},  {23667, -22663},  {23665, -22665},
    {23663, -22668},  {23661, -22670},  {23658, -22672},  {23656, -22674},  {23654, -22677},  {23652, -22679},
    {23650, -22681},  {23647, -22683},  {23645, -22686},  {23643, -22688},  {23641, -22690},  {23639, -22693},
    {23637, -22695},  {23634, -22697},  {23632, -22699},  {23630, -22702},  {23628, -22704},  {23626, -22706},
    {23624, -22708},  {23621, -22711},  {23619, -22713},  {23617, -22715},  {23615, -22717},  {23613, -22720},
    {23610, -22722},  {23608, -22724},  {23606, -22726},  {23604, -22729},  {23602, -22731},  {23600, -22733},
    {23597, -22736},  {23595, -22738},  {23593, -22740},  {23591, -22742},  {23589, -22745},  {23587, -22747},
    {23584, -22749},  {23582, -22751},  {23580, -22754},  {23578, -22756},  {23576, -22758},  {23573, -22760},
    {23571, -22763},  {23569, -22765},  {23567, -22767},  {23565, -22769},  {23562, -22772},  {23560, -22774},
    {23558, -22776},  {23556, -22778},  {23554, -22781},  {23552, -22783},  {23549, -22785},  {23547, -22788},
    {23545, -22790},  {23543, -22792},  {23541, -22794},  {23538, -22797},  {23536, -22799},  {23534, -22801},
    {23532, -22803},  {23530, -22806},  {23528, -22808},  {23525, -22810},  {23523, -22812},  {23521, -22815},
    {23519, -22817},  {23517, -22819},  {23514, -22821},  {23512, -22824},  {23510, -22826},  {23508, -22828},
    {23506, -22830},  {23503, -22833},  {23501, -22835},  {23499, -22837},  {23497, -22839},  {23495, -22842},
    {23493, -22844},  {23490, -22846},  {23488, -22848},  {23486, -22851},  {23484, -22853},  {23482, -22855},
    {23479, -22857},  {23477, -22860},  {23475, -22862},  {23473, -22864},  {23471, -22866},  {23468, -22869},
    {23466, -22871},  {23464, -22873},  {23462, -22875},  {23460, -22878},  {23457, -22880},  {23455, -22882},
    {23453, -22884},  {23451, -22887},  {23449, -22889},  {23446, -22891},  {23444, -22893},  {23442, -22896},
    {23440, -22898},  {23438, -22900},  {23436, -22902},  {23433, -22905},  {23431, -22907},  {23429, -22909},
    {23427, -22911},  {23425, -22914},  {23422, -22916},  {23420, -22918},  {23418, -22920},  {23416, -22923},
    {23414, -22925},  {23411, -22927},  {23409, -22929},  {23407, -22932},  {23405, -22934},  {23403, -22936},
    {23400, -22938},  {23398, -22941},  {23396, -22943},  {23394, -22945},  {23392, -22947},  {23389, -22950},
    {23387, -22952},  {23385, -22954},  {23383, -22956},  {23381, -22958},  {23378, -22961},  {23376, -22963},
    {23374, -22965},  {23372, -22967},  {23370, -22970},  {23367, -22972},  {23365, -22974},  {23363, -22976},
    {23361, -22979},  {23359, -22981},  {23356, -22983},  {23354, -22985},  {23352, -22988},  {23350, -22990},
    {23348, -22992},  {23345, -22994},  {23343, -22997},  {23341, -22999},  {23339, -23001},  {23336, -23003},
    {23334, -23006},  {23332, -23008},  {23330, -23010},  {23328, -23012},  {23325, -23014},  {23323, -23017},
    {23321, -23019},  {23319, -23021},  {23317, -23023},  {23314, -23026},  {23312, -23028},  {23310, -23030},
    {23308, -23032},  {23306, -23035},  {23303, -23037},  {23301, -23039},  {23299, -23041},  {23297, -23044},
    {23295, -23046},  {23292, -23048},  {23290, -23050},  {23288, -23052},  {23286, -23055},  {23283, -23057},
    {23281, -23059},  {23279, -23061},  {23277, -23064},  {23275, -23066},  {23272, -23068},  {23270, -23070},
    {23268, -23073},  {23266, -23075},  {23264, -23077},  {23261, -23079},  {23259, -23081},  {23257, -23084},
    {23255, -23086},  {23253, -23088},  {23250, -23090},  {23248, -23093},  {23246, -23095},  {23244, -23097},
    {23241, -23099},  {23239, -23102},  {23237, -23104},  {23235, -23106},  {23233, -23108},  {23230, -23110},
    {23228, -23113},  {23226, -23115},  {23224, -23117},  {23222, -23119},  {23219, -23122},  {23217, -23124},
    {23215, -23126},  {23213, -23128},  {23210, -23130},  {23208, -23133},  {23206, -23135},  {23204, -23137},
    {23202, -23139},  {23199, -23142},  {23197, -23144},  {23195, -23146},  {23193, -23148},  {23190, -23150},
    {23188, -23153},  {23186, -23155},  {23184, -23157},  {23182, -23159},  {23179, -23162},  {23177, -23164},
    {23175, -23166},  {23173, -23168},  {23170, -23170},  {23168, -23173},  {23166, -23175},  {23164, -23177},
    {23162, -23179},  {23159, -23182},  {23157, -23184},  {23155, -23186},  {23153, -23188},  {23150, -23190},
    {23148, -23193},  {23146, -23195},  {23144, -23197},  {23142, -23199},  {23139, -23202},  {23137, -23204},
    {23135, -23206},  {23133, -23208},  {23130, -23210},  {23128, -23213},  {23126, -23215},  {23124, -23217},
    {23122, -23219},  {23119, -23222},  {23117, -23224},  {23115, -23226},  {23113, -23228},  {23110, -23230},
    {23108, -23233},  {23106, -23235},  {23104, -23237},  {23102, -23239},  {23099, -23241},  {23097, -23244},
    {23095, -23246},  {23093, -23248},  {23090, -23250},  {23088, -23253},  {23086, -23255},  {23084, -23257},
    {23081, -23259},  {23079, -23261},  {23077, -23264},  {23075, -23266},  {23073, -23268},  {23070, -23270},
    {23068, -23272},  {23066, -23275},  {23064, -23277},  {23061, -23279},  {23059, -23281},  {23057, -23283},
    {23055, -23286},  {23052, -23288},  {23050, -23290},  {23048, -23292},  {23046, -23295},  {23044, -23297},
    {23041, -23299},  {23039, -23301},  {23037, -23303},  {23035, -23306},  {23032, -23308},  {23030, -23310},
    {23028, -23312},  {23026, -23314},  {23023, -23317},  {23021, -23319},  {23019, -23321},  {23017, -23323},
    {23014, -23325},  {23012, -23328},  {23010, -23330},  {23008, -23332},  {23006, -23334},  {23003, -23336},
    {23001, -23339},  {22999, -23341},  {22997, -23343},  {22994, -23345},  {22992, -23348},  {22990, -23350},
    {22988, -23352},  {22985, -23354},  {22983, -23356},  {22981, -23359},  {22979, -23361},  {22976, -23363},
    {22974, -23365},  {22972, -23367},  {22970, -23370},  {22967, -23372},  {22965, -23374},  {22963, -23376},
    {22961, -23378},  {22958, -23381},  {22956, -23383},  {22954, -23385},  {22952, -23387},  {22950, -23389},
    {22947, -23392},  {22945, -23394},  {22943, -23396},  {22941, -23398},  {22938, -23400},  {22936, -23403},
    {22934, -23405},  {22932, -23407},  {22929, -23409},  {22927, -23411},  {22925, -23414},  {22923, -23416},
    {22920, -23418},  {22918, -23420},  {22916, -23422},  {22914, -23425},  {22911, -23427},  {22909, -23429},
    {22907, -23431},  {22905, -23433},  {22902, -23436},  {22900, -23438},  {22898, -23440},  {22896, -23442},
    {22893, -23444},  {22891, -23446},  {22889, -23449},  {22887, -23451},  {22884, -23453},  {22882, -23455},
    {22880, -23457},  {22878, -23460},  {22875, -23462},  {22873, -23464},  {22871, -23466},  {22869, -23468},
    {22866, -23471},  {22864, -23473},  {22862, -23475},  {22860, -23477},  {22857, -23479},  {22855, -23482},
    {22853, -23484},  {22851, -23486},  {22848, -23488},  {22846, -23490},  {22844, -23493},  {22842, -23495},
    {22839, -23497},  {22837, -23499},  {22835, -23501},  {22833, -23503},  {22830, -23506},  {22828, -23508},
    {22826, -23510},  {22824, -23512},  {22821, -23514},  {22819, -23517},  {22817, -23519},  {22815, -23521},
    {22812, -23523},  {22810, -23525},  {22808, -23528},  {22806, -23530},  {22803, -23532},  {22801, -23534},
    {22799, -23536},  {22797, -23538},  {22794, -23541},  {22792, -23543},  {22790, -23545},  {22788, -23547},
    {22785, -23549},  {22783, -23552},  {22781, -23554},  {22778, -23556},  {22776, -23558},  {22774, -23560},
    {22772, -23562},  {22769, -23565},  {22767, -23567},  {22765, -23569},  {22763, -23571},  {22760, -23573},
    {22758, -23576},  {22756, -23578},  {22754, -23580},  {22751, -23582},  {22749, -23584},  {22747, -23587},
    {22745, -23589},  {22742, -23591},  {22740, -23593},  {22738, -23595},  {22736, -23597},  {22733, -23600},
    {22731, -23602},  {22729, -23604},  {22726, -23606},  {22724, -23608},  {22722, -23610},  {22720, -23613},
    {22717, -23615},  {22715, -23617},  {22713, -23619},  {22711, -23621},  {22708, -23624},  {22706, -23626},
    {22704, -23628},  {22702, -23630},  {22699, -23632},  {22697, -23634},  {22695, -23637},  {22693, -23639},
    {22690, -23641},  {22688, -23643},  {22686, -23645},  {22683, -23647},  {22681, -23650},  {22679, -23652},
    {22677, -23654},  {22674, -23656},  {22672, -23658},  {22670, -23661},  {22668, -23663},  {22665, -23665},
    {22663, -23667},  {22661, -23669},  {22658, -23671},  {22656, -23674},  {22654, -23676},  {22652, -23678},
    {22649, -23680},  {22647, -23682},  {22645, -23684},  {22643, -23687},  {22640, -23689},  {22638, -23691},
    {22636, -23693},  {22634, -23695},  {22631, -23697},  {22629, -23700},  {22627, -23702},  {22624, -23704},
    {22622, -23706},  {22620, -23708},  {22618, -23710},  {22615, -23713},  {22613, -23715},  {22611, -23717},
    {22609, -23719},  {22606, -23721},  {22604, -23723},  {22602, -23726},  {22599, -23728},  {22597, -23730},
    {22595, -23732},  {22593, -23734},  {22590, -23736},  {22588, -23739},  {22586, -23741},  {22583, -23743},
    {22581, -23745},  {22579, -23747},  {22577, -23749},  {22574, -23752},  {22572, -23754},  {22570, -23756},
    {22568, -23758},  {22565, -23760},  {22563, -23762},  {22561, -23765},  {22558, -23767},  {22556, -23769},
    {22554, -23771},  {22552, -23773},  {22549, -23775},  {22547, -23778},  {22545, -23780},  {22542, -23782},
    {22540, -23784},  {22538, -23786},  {22536, -23788},  {22533, -23791},  {22531, -23793},  {22529, -23795},
    {22527, -23797},  {22524, -23799},  {22522, -23801},  {22520, -23803},  {22517, -23806},  {22515, -23808},
    {22513, -23810},  {22511, -23812},  {22508, -23814},  {22506, -23816},  {22504, -23819},  {22501, -23821},
    {22499, -23823},  {22497, -23825},  {22495, -23827},  {22492, -23829},  {22490, -23832},  {22488, -23834},
    {22485, -23836},  {22483, -23838},  {22481, -23840},  {22479, -23842},  {22476, -23844},  {22474, -23847},
    {22472, -23849},  {22469, -23851},  {22467, -23853},  {22465, -23855},  {22463, -23857},  {22460, -23860},
    {22458, -23862},  {22456, -23864},  {22453, -23866},  {22451, -23868},  {22449, -23870},  {22447, -23872},
    {22444, -23875},  {22442, -23877},  {22440, -23879},  {22437, -23881},  {22435, -23883},  {22433, -23885},
    {22431, -23888},  {22428, -23890},  {22426, -23892},  {22424, -23894},  {22421, -23896},  {22419, -23898},
    {22417, -23900},  {22414, -23903},  {22412, -23905},  {22410, -23907},  {22408, -23909},  {22405, -23911},
    {22403, -23913},  {22401, -23915},  {22398, -23918},  {22396, -23920},  {22394, -23922},  {22392, -23924},
    {22389, -23926},  {22387, -23928},  {22385, -23930},  {22382, -23933},  {22380, -23935},  {22378, -23937},
    {22375, -23939},  {22373, -23941},  {22371, -23943},  {22369, -23946},  {22366, -23948},  {22364, -23950},
    {22362, -23952},  {22359, -23954},  {22357, -23956},  {22355, -23958},  {22353, -23961},  {22350, -23963},
    {22348, -23965},  {22346, -23967},  {22343, -23969},  {22341, -23971},  {22339, -23973},  {22336, -23976},
    {22334, -23978},  {22332, -23980},  {22330, -23982},  {22327, -23984},  {22325, -23986},  {22323, -23988},
    {22320, -23991},  {22318, -23993},  {22316, -23995},  {22313, -23997},  {22311, -23999},  {22309, -24001},
    {22307, -24003},  {22304, -24005},  {22302, -24008},  {22300, -24010},  {22297, -24012},  {22295, -24014},
    {22293, -24016},  {22290, -24018},  {22288, -24020},  {22286, -24023},  {22284, -24025},  {22281, -24027},
    {22279, -24029},  {22277, -24031},  {22274, -24033},  {22272, -24035},  {22270, -24038},  {22267, -24040},
    {22265, -24042},  {22263, -24044},  {22260, -24046},  {22258, -24048},  {22256, -24050},  {22254, -24052},
    {22251, -24055},  {22249, -24057},  {22247, -24059},  {22244, -24061},  {22242, -24063},  {22240, -24065},
    {22237, -24067},  {22235, -24070},  {22233, -24072},  {22230, -24074},  {22228, -24076},  {22226, -24078},
    {22224, -24080},  {22221, -24082},  {22219, -24084},  {22217, -24087},  {22214, -24089},  {22212, -24091},
    {22210, -24093},  {22207, -24095},  {22205, -24097},  {22203, -24099},  {22200, -24101},  {22198, -24104},
    {22196, -24106},  {22194, -24108},  {22191, -24110},  {22189, -24112},  {22187, -24114},  {22184, -24116},
    {22182, -24119},  {22180, -24121},  {22177, -24123},  {22175, -24125},  {22173, -24127},  {22170, -24129},
    {22168, -24131},  {22166, -24133},  {22163, -24136},  {22161, -24138},  {22159, -24140},  {22157, -24142},
    {22154, -24144},  {22152, -24146},  {22150, -24148},  {22147, -24150},  {22145, -24152},  {22143, -24155},
    {22140, -24157},  {22138, -24159},  {22136, -24161},  {22133, -24163},  {22131, -24165},  {22129, -24167},
    {22126, -24169},  {22124, -24172},  {22122, -24174},  {22119, -24176},  {22117, -24178},  {22115, -24180},
    {22113, -24182},  {22110, -24184},  {22108, -24186},  {22106, -24189},  {22103, -24191},  {22101, -24193},
    {22099, -24195},  {22096, -24197},  {22094, -24199},  {22092, -24201},  {22089, -24203},  {22087, -24206},
    {22085, -24208},  {22082, -24210},  {22080, -24212},  {22078, -24214},  {22075, -24216},  {22073, -24218},
    {22071, -24220},  {22068, -24222},  {22066, -24225},  {22064, -24227},  {22061, -24229},  {22059, -24231},
    {22057, -24233},  {22054, -24235},  {22052, -24237},  {22050, -24239},  {22048, -24241},  {22045, -24244},
    {22043, -24246},  {22041, -24248},  {22038, -24250},  {22036, -24252},  {22034, -24254},  {22031, -24256},
    {22029, -24258},  {22027, -24260},  {22024, -24263},  {22022, -24265},  {22020, -24267},  {22017, -24269},
    {22015, -24271},  {22013, -24273},  {22010, -24275},  {22008, -24277},  {22006, -24279},  {22003, -24282},
    {22001, -24284},  {21999, -24286},  {21996, -24288},  {21994, -24290},  {21992, -24292},  {21989, -24294},
    {21987, -24296},  {21985, -24298},  {21982, -24301},  {21980, -24303},  {21978, -24305},  {21975, -24307},
    {21973, -24309},  {21971, -24311},  {21968, -24313},  {21966, -24315},  {21964, -24317},  {21961, -24320},
    {21959, -24322},  {21957, -24324},  {21954, -24326},  {21952, -24328},  {21950, -24330},  {21947, -24332},
    {21945, -24334},  {21943, -24336},  {21940, -24338},  {21938, -24341},  {21936, -24343},  {21933, -24345},
    {21931, -24347},  {21929, -24349},  {21926, -24351},  {21924, -24353},  {21922, -24355},  {21919, -24357},
    {21917, -24359},  {21915, -24362},  {21912, -24364},  {21910, -24366},  {21908, -24368},  {21905, -24370},
    {21903, -24372},  {21901, -24374},  {21898, -24376},  {21896, -24378},  {21894, -24380},  {21891, -24383},
    {21889, -24385},  {21887, -24387},  {21884, -24389},  {21882, -24391},  {21880, -24393},  {21877, -24395},
    {21875, -24397},  {21873, -24399},  {21870, -24401},  {21868, -24404},  {21866, -24406},  {21863, -24408},
    {21861, -24410},  {21859, -24412},  {21856, -24414},  {21854, -24416},  {21852, -24418},  {21849, -24420},
    {21847, -24422},  {21845, -24425},  {21842, -24427},  {21840, -24429},  {21838, -24431},  {21835, -24433},
    {21833, -24435},  {21830, -24437},  {21828, -24439},  {21826, -24441},  {21823, -24443},  {21821, -24445},
    {21819, -24448},  {21816, -24450},  {21814, -24452},  {21812, -24454},  {21809, -24456},  {21807, -24458},
    {21805, -24460},  {21802, -24462},  {21800, -24464},  {21798, -24466},  {21795, -24468},  {21793, -24471},
    {21791, -24473},  {21788, -24475},  {21786, -24477},  {21784, -24479},  {21781, -24481},  {21779, -24483},
    {21777, -24485},  {21774, -24487},  {21772, -24489},  {21770, -24491},  {21767, -24494},  {21765, -24496},
    {21762, -24498},  {21760, -24500},  {21758, -24502},  {21755, -24504},  {21753, -24506},  {21751, -24508},
    {21748, -24510},  {21746, -24512},  {21744, -24514},  {21741, -24516},  {21739, -24519},  {21737, -24521},
    {21734, -24523},  {21732, -24525},  {21730, -24527},  {21727, -24529},  {21725, -24531},  {21723, -24533},
    {21720, -24535},  {21718, -24537},  {21715, -24539},  {21713, -24541},  {21711, -24544},  {21708, -24546},
    {21706, -24548},  {21704, -24550},  {21701, -24552},  {21699, -24554},  {21697, -24556},  {21694, -24558},
    {21692, -24560},  {21690, -24562},  {21687, -24564},  {21685, -24566},  {21682, -24569},  {21680, -24571},
    {21678, -24573},  {21675, -24575},  {21673, -24577},  {21671, -24579},  {21668, -24581},  {21666, -24583},
    {21664, -24585},  {21661, -24587},  {21659, -24589},  {21657, -24591},  {21654, -24593},  {21652, -24596},
    {21649, -24598},  {21647, -24600},  {21645, -24602},  {21642, -24604},  {21640, -24606},  {21638, -24608},
    {21635, -24610},  {21633, -24612},  {21631, -24614},  {21628, -24616},  {21626, -24618},  {21624, -24620},
    {21621, -24622},  {21619, -24625},  {21616, -24627},  {21614, -24629},  {21612, -24631},  {21609, -24633},
    {21607, -24635},  {21605, -24637},  {21602, -24639},  {21600, -24641},  {21598, -24643},  {21595, -24645},
    {21593, -24647},  {21590, -24649},  {21588, -24651},  {21586, -24654},  {21583, -24656},  {21581, -24658},
    {21579, -24660},  {21576, -24662},  {21574, -24664},  {21572, -24666},  {21569, -24668},  {21567, -24670},
    {21564, -24672},  {21562, -24674},  {21560, -24676},  {21557, -24678},  {21555, -24680},  {21553, -24682},
    {21550, -24685},  {21548, -24687},  {21546, -24689},  {21543, -24691},  {21541, -24693},  {21538, -24695},
    {21536, -24697},  {21534, -24699},  {21531, -24701},  {21529, -24703},  {21527, -24705},  {21524, -24707},
    {21522, -24709},  {21519, -24711},  {21517, -24713},  {21515, -24716},  {21512, -24718},  {21510, -24720},
    {21508, -24722},  {21505, -24724},  {21503, -24726},  {21501, -24728},  {21498, -24730},  {21496, -24732},
    {21493, -24734},  {21491, -24736},  {21489, -24738},  {21486, -24740},  {21484, -24742},  {21482, -24744},
    {21479, -24746},  {21477, -24748},  {21474, -24751},  {21472, -24753},  {21470, -24755},  {21467, -24757},
    {21465, -24759},  {21463, -24761},  {21460, -24763},  {21458, -24765},  {21455, -24767},  {21453, -24769},
    {21451, -24771},  {21448, -24773},  {21446, -24775},  {21444, -24777},  {21441, -24779},  {21439, -24781},
    {21436, -24783},  {21434, -24786},  {21432, -24788},  {21429, -24790},  {21427, -24792},  {21425, -24794},
    {21422, -24796},  {21420, -24798},  {21417, -24800},  {21415, -24802},  {21413, -24804},  {21410, -24806},
    {21408, -24808},  {21406, -24810},  {21403, -24812},  {21401, -24814},  {21398, -24816},  {21396, -24818},
    {21394, -24820},  {21391, -24822},  {21389, -24825},  {21387, -24827},  {21384, -24829},  {21382, -24831},
    {21379, -24833},  {21377, -24835},  {21375, -24837},  {21372, -24839},  {21370, -24841},  {21367, -24843},
    {21365, -24845},  {21363, -24847},  {21360, -24849},  {21358, -24851},  {21356, -24853},  {21353, -24855},
    {21351, -24857},  {21348, -24859},  {21346, -24861},  {21344, -24863},  {21341, -24865},  {21339, -24868},
    {21336, -24870},  {21334, -24872},  {21332, -24874},  {21329, -24876},  {21327, -24878},  {21325, -24880},
    {21322, -24882},  {21320, -24884},  {21317, -24886},  {21315, -24888},  {21313, -24890},  {21310, -24892},
    {21308, -24894},  {21305, -24896},  {21303, -24898},  {21301, -24900},  {21298, -24902},  {21296, -24904},
    {21294, -24906},  {21291, -24908},  {21289, -24910},  {21286, -24912},  {21284, -24915},  {21282, -24917},
    {21279, -24919},  {21277, -24921},  {21274, -24923},  {21272, -24925},  {21270, -24927},  {21267, -24929},
    {21265, -24931},  {21262, -24933},  {21260, -24935},  {21258, -24937},  {21255, -24939},  {21253, -24941},
    {21251, -24943},  {21248, -24945},  {21246, -24947},  {21243, -24949},  {21241, -24951},  {21239, -24953},
    {21236, -24955},  {21234, -24957},  {21231, -24959},  {21229, -24961},  {21227, -24963},  {21224, -24965},
    {21222, -24968},  {21219, -24970},  {21217, -24972},  {21215, -24974},  {21212, -24976},  {21210, -24978},
    {21207, -24980},  {21205, -24982},  {21203, -24984},  {21200, -24986},  {21198, -24988},  {21195, -24990},
    {21193, -24992},  {21191, -24994},  {21188, -24996},  {21186, -24998},  {21183, -25000},  {21181, -25002},
    {21179, -25004},  {21176, -25006},  {21174, -25008},  {21171, -25010},  {21169, -25012},  {21167, -25014},
    {21164, -25016},  {21162, -25018},  {21160, -25020},  {21157, -25022},  {21155, -25024},  {21152, -25026},
    {21150, -25028},  {21148, -25030},  {21145, -25033},  {21143, -25035},  {21140, -25037},  {21138, -25039},
    {21136, -25041},  {21133, -25043},  {21131, -25045},  {21128, -25047},  {21126, -25049},  {21124, -25051},
    {21121, -25053},  {21119, -25055},  {21116, -25057},  {21114, -25059},  {21111, -25061},  {21109, -25063},
    {21107, -25065},  {21104, -25067},  {21102, -25069},  {21099, -25071},  {21097, -25073},  {21095, -25075},
    {21092, -25077},  {21090, -25079},  {21087, -25081},  {21085, -25083},  {21083, -25085},  {21080, -25087},
    {21078, -25089},  {21075, -25091},  {21073, -25093},  {21071, -25095},  {21068, -25097},  {21066, -25099},
    {21063, -25101},  {21061, -25103},  {21059, -25105},  {21056, -25107},  {21054, -25109},  {21051, -25111},
    {21049, -25113},  {21047, -25115},  {21044, -25117},  {21042, -25119},  {21039, -25121},  {21037, -25123},
    {21035, -25126},  {21032, -25128},  {21030, -25130},  {21027, -25132},  {21025, -25134},  {21022, -25136},
    {21020, -25138},  {21018, -25140},  {21015, -25142},  {21013, -25144},  {21010, -25146},  {21008, -25148},
    {21006, -25150},  {21003, -25152},  {21001, -25154},  {20998, -25156},  {20996, -25158},  {20994, -25160},
    {20991, -25162},  {20989, -25164},  {20986, -25166},  {20984, -25168},  {20981, -25170},  {20979, -25172},
    {20977, -25174},  {20974, -25176},  {20972, -25178},  {20969, -25180},  {20967, -25182},  {20965, -25184},
    {20962, -25186},  {20960, -25188},  {20957, -25190},  {20955, -25192},  {20952, -25194},  {20950, -25196},
    {20948, -25198},  {20945, -25200},  {20943, -25202},  {20940, -25204},  {20938, -25206},  {20936, -25208},
    {20933, -25210},  {20931, -25212},  {20928, -25214},  {20926, -25216},  {20923, -25218},  {20921, -25220},
    {20919, -25222},  {20916, -25224},  {20914, -25226},  {20911, -25228},  {20909, -25230},  {20907, -25232},
    {20904, -25234},  {20902, -25236},  {20899, -25238},  {20897, -25240},  {20894, -25242},  {20892, -25244},
    {20890, -25246},  {20887, -25248},  {20885, -25250},  {20882, -25252},  {20880, -25254},  {20878, -25256},
    {20875, -25258},  {20873, -25260},  {20870, -25262},  {20868, -25264},  {20865, -25266},  {20863, -25268},
    {20861, -25270},  {20858, -25272},  {20856, -25274},  {20853, -25276},  {20851, -25278},  {20848, -25280},
    {20846, -25282},  {20844, -25284},  {20841, -25286},  {20839, -25288},  {20836, -25290},  {20834, -25292},
    {20831, -25294},  {20829, -25296},  {20827, -25298},  {20824, -25300},  {20822, -25302},  {20819, -25304},
    {20817, -25306},  {20815, -25308},  {20812, -25310},  {20810, -25312},  {20807, -25314},  {20805, -25316},
    {20802, -25318},  {20800, -25320},  {20798, -25322},  {20795, -25324},  {20793, -25326},  {20790, -25328},
    {20788, -25330},  {20785, -25332},  {20783, -25334},  {20781, -25336},  {20778, -25338},  {20776, -25340},
    {20773, -25342},  {20771, -25344},  {20768, -25346},  {20766, -25348},  {20764, -25350},  {20761, -25352},
    {20759, -25354},  {20756, -25356},  {20754, -25358},  {20751, -25360},  {20749, -25362},  {20746, -25364},
    {20744, -25366},  {20742, -25368},  {20739, -25370},  {20737, -25372},  {20734, -25374},  {20732, -25376},
    {20729, -25378},  {20727, -25380},  {20725, -25382},  {20722, -25384},  {20720, -25386},  {20717, -25388},
    {20715, -25390},  {20712, -25392},  {20710, -25394},  {20708, -25396},  {20705, -25398},  {20703, -25400},
    {20700, -25402},  {20698, -25404},  {20695, -25406},  {20693, -25408},  {20691, -25410},  {20688, -25412},
    {20686, -25414},  {20683, -25415},  {20681, -25417},  {20678, -25419},  {20676, -25421},  {20673, -25423},
    {20671, -25425},  {20669, -25427},  {20666, -25429},  {20664, -25431},  {20661, -25433},  {20659, -25435},
    {20656, -25437},  {20654, -25439},  {20652, -25441},  {20649, -25443},  {20647, -25445},  {20644, -25447},
    {20642, -25449},  {20639, -25451},  {20637, -25453},  {20634, -25455},  {20632, -25457},  {20630, -25459},
    {20627, -25461},  {20625, -25463},  {20622, -25465},  {20620, -25467},  {20617, -25469},  {20615, -25471},
    {20612, -25473},  {20610, -25475},  {20608, -25477},  {20605, -25479},  {20603, -25481},  {20600, -25483},
    {20598, -25485},  {20595, -25487},  {20593, -25489},  {20590, -25491},  {20588, -25493},  {20586, -25495},
    {20583, -25497},  {20581, -25499},  {20578, -25501},  {20576, -25503},  {20573, -25504},  {20571, -25506},
    {20568, -25508},  {20566, -25510},  {20564, -25512},  {20561, -25514},  {20559, -25516},  {20556, -25518},
    {20554, -25520},  {20551, -25522},  {20549, -25524},  {20546, -25526},  {20544, -25528},  {20542, -25530},
    {20539, -25532},  {20537, -25534},  {20534, -25536},  {20532, -25538},  {20529, -25540},  {20527, -25542},
    {20524, -25544},  {20522, -25546},  {20520, -25548},  {20517, -25550},  {20515, -25552},  {20512, -25554},
    {20510, -25556},  {20507, -25558},  {20505, -25560},  {20502, -25562},  {20500, -25564},  {20497, -25566},
    {20495, -25567},  {20493, -25569},  {20490, -25571},  {20488, -25573},  {20485, -25575},  {20483, -25577},
    {20480, -25579},  {20478, -25581},  {20475, -25583},  {20473, -25585},  {20470, -25587},  {20468, -25589},
    {20466, -25591},  {20463, -25593},  {20461, -25595},  {20458, -25597},  {20456, -25599},  {20453, -25601},
    {20451, -25603},  {20448, -25605},  {20446, -25607},  {20443, -25609},  {20441, -25611},  {20439, -25613},
    {20436, -25615},  {20434, -25617},  {20431, -25618},  {20429, -25620},  {20426, -25622},  {20424, -25624},
    {20421, -25626},  {20419, -25628},  {20416, -25630},  {20414, -25632},  {20412, -25634},  {20409, -25636},
    {20407, -25638},  {20404, -25640},  {20402, -25642},  {20399, -25644},  {20397, -25646},  {20394, -25648},
    {20392, -25650},  {20389, -25652},  {20387, -25654},  {20385, -25656},  {20382, -25658},  {20380, -25660},
    {20377, -25662},  {20375, -25663},  {20372, -25665},  {20370, -25667},  {20367, -25669},  {20365, -25671},
    {20362, -25673},  {20360, -25675},  {20357, -25677},  {20355, -25679},  {20353, -25681},  {20350, -25683},
    {20348, -25685},  {20345, -25687},  {20343, -25689},  {20340, -25691},  {20338, -25693},  {20335, -25695},
    {20333, -25697},  {20330, -25699},  {20328, -25701},  {20325, -25703},  {20323, -25704},  {20320, -25706},
    {20318, -25708},  {20316, -25710},  {20313, -25712},  {20311, -25714},  {20308, -25716},  {20306, -25718},
    {20303, -25720},  {20301, -25722},  {20298, -25724},  {20296, -25726},  {20293, -25728},  {20291, -25730},
    {20288, -25732},  {20286, -25734},  {20284, -25736},  {20281, -25738},  {20279, -25739},  {20276, -25741},
    {20274, -25743},  {20271, -25745},  {20269, -25747},  {20266, -25749},  {20264, -25751},  {20261, -25753},
    {20259, -25755},  {20256, -25757},  {20254, -25759},  {20251, -25761},  {20249, -25763},  {20246, -25765},
    {20244, -25767},  {20242, -25769},  {20239, -25771},  {20237, -25773},  {20234, -25774},  {20232, -25776},
    {20229, -25778},  {20227, -25780},  {20224, -25782},  {20222, -25784},  {20219, -25786},  {20217, -25788},
    {20214, -25790},  {20212, -25792},  {20209, -25794},  {20207, -25796},  {20204, -25798},  {20202, -25800},
    {20200, -25802},  {20197, -25804},  {20195, -25805},  {20192, -25807},  {20190, -25809},  {20187, -25811},
    {20185, -25813},  {20182, -25815},  {20180, -25817},  {20177, -25819},  {20175, -25821},  {20172, -25823},
    {20170, -25825},  {20167, -25827},  {20165, -25829},  {20162, -25831},  {20160, -25833},  {20157, -25834},
    {20155, -25836},  {20152, -25838},  {20150, -25840},  {20148, -25842},  {20145, -25844},  {20143, -25846},
    {20140, -25848},  {20138, -25850},  {20135, -25852},  {20133, -25854},  {20130, -25856},  {20128, -25858},
    {20125, -25860},  {20123, -25862},  {20120, -25863},  {20118, -25865},  {20115, -25867},  {20113, -25869},
    {20110, -25871},  {20108, -25873},  {20105, -25875},  {20103, -25877},  {20100, -25879},  {20098, -25881},
    {20095, -25883},  {20093, -25885},  {20090, -25887},  {20088, -25888},  {20086, -25890},  {20083, -25892},
    {20081, -25894},  {20078, -25896},  {20076, -25898},  {20073, -25900},  {20071, -25902},  {20068, -25904},
    {20066, -25906},  {20063, -25908},  {20061, -25910},  {20058, -25912},  {20056, -25914},  {20053, -25915},
    {20051, -25917},  {20048, -25919},  {20046, -25921},  {20043, -25923},  {20041, -25925},  {20038, -25927},
    {20036, -25929},  {20033, -25931},  {20031, -25933},  {20028, -25935},  {20026, -25937},  {20023, -25938},
    {20021, -25940},  {20018, -25942},  {20016, -25944},  {20013, -25946},  {20011, -25948},  {20008, -25950},
    {20006, -25952},  {20004, -25954},  {20001, -25956},  {19999, -25958},  {19996, -25960},  {19994, -25961},
    {19991, -25963},  {19989, -25965},  {19986, -25967},  {19984, -25969},  {19981, -25971},  {19979, -25973},
    {19976, -25975},  {19974, -25977},  {19971, -25979},  {19969, -25981},  {19966, -25983},  {19964, -25984},
    {19961, -25986},  {19959, -25988},  {19956, -25990},  {19954, -25992},  {19951, -25994},  {19949, -25996},
    {19946, -25998},  {19944, -26000},  {19941, -26002},  {19939, -26004},  {19936, -26006},  {19934, -26007},
    {19931, -26009},  {19929, -26011},  {19926, -26013},  {19924, -26015},  {19921, -26017},  {19919, -26019},
    {19916, -26021},  {19914, -26023},  {19911, -26025},  {19909, -26027},  {19906, -26028},  {19904, -26030},
    {19901, -26032},  {19899, -26034},  {19896, -26036},  {19894, -26038},  {19891, -26040},  {19889, -26042},
    {19886, -26044},  {19884, -26046},  {19881, -26048},  {19879, -26049},  {19876, -26051},  {19874, -26053},
    {19871, -26055},  {19869, -26057},  {19866, -26059},  {19864, -26061},  {19861, -26063},  {19859, -26065},
    {19856, -26067},  {19854, -26068},  {19851, -26070},  {19849, -26072},  {19846, -26074},  {19844, -26076},
    {19841, -26078},  {19839, -26080},  {19836, -26082},  {19834, -26084},  {19831, -26086},  {19829, -26087},
    {19826, -26089},  {19824, -26091},  {19821, -26093},  {19819, -26095},  {19816, -26097},  {19814, -26099},
    {19811, -26101},  {19809, -26103},  {19806, -26105},  {19804, -26106},  {19801, -26108},  {19799, -26110},
    {19796, -26112},  {19794, -26114},  {19791, -26116},  {19789, -26118},  {19786, -26120},  {19784, -26122},
    {19781, -26124},  {19779, -26125},  {19776, -26127},  {19774, -26129},  {19771, -26131},  {19769, -26133},
    {19766, -26135},  {19764, -26137},  {19761, -26139},  {19759, -26141},  {19756, -26143},  {19754, -26144},
    {19751, -26146},  {19749, -26148},  {19746, -26150},  {19744, -26152},  {19741, -26154},  {19739, -26156},
    {19736, -26158},  {19734, -26160},  {19731, -26161},  {19729, -26163},  {19726, -26165},  {19724, -26167},
    {19721, -26169},  {19719, -26171},  {19716, -26173},  {19714, -26175},  {19711, -26177},  {19709, -26178},
    {19706, -26180},  {19704, -26182},  {19701, -26184},  {19699, -26186},  {19696, -26188},  {19694, -26190},
    {19691, -26192},  {19689, -26194},  {19686, -26195},  {19684, -26197},  {19681, -26199},  {19678, -26201},
    {19676, -26203},  {19673, -26205},  {19671, -26207},  {19668, -26209},  {19666, -26211},  {19663, -26212},
    {19661, -26214},  {19658, -26216},  {19656, -26218},  {19653, -26220},  {19651, -26222},  {19648, -26224},
    {19646, -26226},  {19643, -26228},  {19641, -26229},  {19638, -26231},  {19636, -26233},  {19633, -26235},
    {19631, -26237},  {19628, -26239},  {19626, -26241},  {19623, -26243},  {19621, -26244},  {19618, -26246},
    {19616, -26248},  {19613, -26250},  {19611, -26252},  {19608, -26254},  {19606, -26256},  {19603, -26258},
    {19601, -26259},  {19598, -26261},  {19595, -26263},  {19593, -26265},  {19590, -26267},  {19588, -26269},
    {19585, -26271},  {19583, -26273},  {19580, -26275},  {19578, -26276},  {19575, -26278},  {19573, -26280},
    {19570, -26282},  {19568, -26284},  {19565, -26286},  {19563, -26288},  {19560, -26290},  {19558, -26291},
    {19555, -26293},  {19553, -26295},  {19550, -26297},  {19548, -26299},  {19545, -26301},  {19543, -26303},
    {19540, -26305},  {19538, -26306},  {19535, -26308},  {19532, -26310},  {19530, -26312},  {19527, -26314},
    {19525, -26316},  {19522, -26318},  {19520, -26320},  {19517, -26321},  {19515, -26323},  {19512, -26325},
    {19510, -26327},  {19507, -26329},  {19505, -26331},  {19502, -26333},  {19500, -26334},  {19497, -26336},
    {19495, -26338},  {19492, -26340},  {19490, -26342},  {19487, -26344},  {19485, -26346},  {19482, -26348},
    {19479, -26349},  {19477, -26351},  {19474, -26353},  {19472, -26355},  {19469, -26357},  {19467, -26359},
    {19464, -26361},  {19462, -26362},  {19459, -26364},  {19457, -26366},  {19454, -26368},  {19452, -26370},
    {19449, -26372},  {19447, -26374},  {19444, -26376},  {19442, -26377},  {19439, -26379},  {19437, -26381},
    {19434, -26383},  {19431, -26385},  {19429, -26387},  {19426, -26389},  {19424, -26390},  {19421, -26392},
    {19419, -26394},  {19416, -26396},  {19414, -26398},  {19411, -26400},  {19409, -26402},  {19406, -26403},
    {19404, -26405},  {19401, -26407},  {19399, -26409},  {19396, -26411},  {19393, -26413},  {19391, -26415},
    {19388, -26416},  {19386, -26418},  {19383, -26420},  {19381, -26422},  {19378, -26424},  {19376, -26426},
    {19373, -26428},  {19371, -26429},  {19368, -26431},  {19366, -26433},  {19363, -26435},  {19361, -26437},
    {19358, -26439},  {19355, -26441},  {19353, -26442},  {19350, -26444},  {19348, -26446},  {19345, -26448},
    {19343, -26450},  {19340, -26452},  {19338, -26454},  {19335, -26455},  {19333, -26457},  {19330, -26459},
    {19328, -26461},  {19325, -26463},  {19323, -26465},  {19320, -26467},  {19317, -26468},  {19315, -26470},
    {19312, -26472},  {19310, -26474},  {19307, -26476},  {19305, -26478},  {19302, -26480},  {19300, -26481},
    {19297, -26483},  {19295, -26485},  {19292, -26487},  {19290, -26489},  {19287, -26491},  {19284, -26493},
    {19282, -26494},  {19279, -26496},  {19277, -26498},  {19274, -26500},  {19272, -26502},  {19269, -26504},
    {19267, -26505},  {19264, -26507},  {19262, -26509},  {19259, -26511},  {19256, -26513},  {19254, -26515},
    {19251, -26517},  {19249, -26518},  {19246, -26520},  {19244, -26522},  {19241, -26524},  {19239, -26526},
    {19236, -26528},  {19234, -26529},  {19231, -26531},  {19229, -26533},  {19226, -26535},  {19223, -26537},
    {19221, -26539},  {19218, -26540},  {19216, -26542},  {19213, -26544},  {19211, -26546},  {19208, -26548},
    {19206, -26550},  {19203, -26552},  {19201, -26553},  {19198, -26555},  {19195, -26557},  {19193, -26559},
    {19190, -26561},  {19188, -26563},  {19185, -26564},  {19183, -26566},  {19180, -26568},  {19178, -26570},
    {19175, -26572},  {19173, -26574},  {19170, -26575},  {19167, -26577},  {19165, -26579},  {19162, -26581},
    {19160, -26583},  {19157, -26585},  {19155, -26586},  {19152, -26588},  {19150, -26590},  {19147, -26592},
    {19144, -26594},  {19142, -26596},  {19139, -26597},  {19137, -26599},  {19134, -26601},  {19132, -26603},
    {19129, -26605},  {19127, -26607},  {19124, -26608},  {19122, -26610},  {19119, -26612},  {19116, -26614},
    {19114, -26616},  {19111, -26618},  {19109, -26619},  {19106, -26621},  {19104, -26623},  {19101, -26625},
    {19099, -26627},  {19096, -26629},  {19093, -26630},  {19091, -26632},  {19088, -26634},  {19086, -26636},
    {19083, -26638},  {19081, -26640},  {19078, -26641},  {19076, -26643},  {19073, -26645},  {19070, -26647},
    {19068, -26649},  {19065, -26651},  {19063, -26652},  {19060, -26654},  {19058, -26656},  {19055, -26658},
    {19053, -26660},  {19050, -26662},  {19047, -26663},  {19045, -26665},  {19042, -26667},  {19040, -26669},
    {19037, -26671},  {19035, -26673},  {19032, -26674},  {19030, -26676},  {19027, -26678},  {19024, -26680},
    {19022, -26682},  {19019, -26683},  {19017, -26685},  {19014, -26687},  {19012, -26689},  {19009, -26691},
    {19007, -26693},  {19004, -26694},  {19001, -26696},  {18999, -26698},  {18996, -26700},  {18994, -26702},
    {18991, -26704},  {18989, -26705},  {18986, -26707},  {18983, -26709},  {18981, -26711},  {18978, -26713},
    {18976, -26714},  {18973, -26716},  {18971, -26718},  {18968, -26720},  {18966, -26722},  {18963, -26724},
    {18960, -26725},  {18958, -26727},  {18955, -26729},  {18953, -26731},  {18950, -26733},  {18948, -26734},
    {18945, -26736},  {18942, -26738},  {18940, -26740},  {18937, -26742},  {18935, -26744},  {18932, -26745},
    {18930, -26747},  {18927, -26749},  {18925, -26751},  {18922, -26753},  {18919, -26754},  {18917, -26756},
    {18914, -26758},  {18912, -26760},  {18909, -26762},  {18907, -26763},  {18904, -26765},  {18901, -26767},
    {18899, -26769},  {18896, -26771},  {18894, -26773},  {18891, -26774},  {18889, -26776},  {18886, -26778},
    {18883, -26780},  {18881, -26782},  {18878, -26783},  {18876, -26785},  {18873, -26787},  {18871, -26789},
    {18868, -26791},  {18866, -26792},  {18863, -26794},  {18860, -26796},  {18858, -26798},  {18855, -26800},
    {18853, -26801},  {18850, -26803},  {18848, -26805},  {18845, -26807},  {18842, -26809},  {18840, -26811},
    {18837, -26812},  {18835, -26814},  {18832, -26816},  {18830, -26818},  {18827, -26820},  {18824, -26821},
    {18822, -26823},  {18819, -26825},  {18817, -26827},  {18814, -26829},  {18812, -26830},  {18809, -26832},
    {18806, -26834},  {18804, -26836},  {18801, -26838},  {18799, -26839},  {18796, -26841},  {18794, -26843},
    {18791, -26845},  {18788, -26847},  {18786, -26848},  {18783, -26850},  {18781, -26852},  {18778, -26854},
    {18776, -26856},  {18773, -26857},  {18770, -26859},  {18768, -26861},  {18765, -26863},  {18763, -26865},
    {18760, -26866},  {18757, -26868},  {18755, -26870},  {18752, -26872},  {18750, -26874},  {18747, -26875},
    {18745, -26877},  {18742, -26879},  {18739, -26881},  {18737, -26883},  {18734, -26884},  {18732, -26886},
    {18729, -26888},  {18727, -26890},  {18724, -26892},  {18721, -26893},  {18719, -26895},  {18716, -26897},
    {18714, -26899},  {18711, -26901},  {18709, -26902},  {18706, -26904},  {18703, -26906},  {18701, -26908},
    {18698, -26909},  {18696, -26911},  {18693, -26913},  {18690, -26915},  {18688, -26917},  {18685, -26918},
    {18683, -26920},  {18680, -26922},  {18678, -26924},  {18675, -26926},  {18672, -26927},  {18670, -26929},
    {18667, -26931},  {18665, -26933},  {18662, -26935},  {18659, -26936},  {18657, -26938},  {18654, -26940},
    {18652, -26942},  {18649, -26943},  {18647, -26945},  {18644, -26947},  {18641, -26949},  {18639, -26951},
    {18636, -26952},  {18634, -26954},  {18631, -26956},  {18628, -26958},  {18626, -26960},  {18623, -26961},
    {18621, -26963},  {18618, -26965},  {18616, -26967},  {18613, -26968},  {18610, -26970},  {18608, -26972},
    {18605, -26974},  {18603, -26976},  {18600, -26977},  {18597, -26979},  {18595, -26981},  {18592, -26983},
    {18590, -26985},  {18587, -26986},  {18585, -26988},  {18582, -26990},  {18579, -26992},  {18577, -26993},
    {18574, -26995},  {18572, -26997},  {18569, -26999},  {18566, -27001},  {18564, -27002},  {18561, -27004},
    {18559, -27006},  {18556, -27008},  {18553, -27009},  {18551, -27011},  {18548, -27013},  {18546, -27015},
    {18543, -27017},  {18540, -27018},  {18538, -27020},  {18535, -27022},  {18533, -27024},  {18530, -27025},
    {18528, -27027},  {18525, -27029},  {18522, -27031},  {18520, -27033},  {18517, -27034},  {18515, -27036},
    {18512, -27038},  {18509, -27040},  {18507, -27041},  {18504, -27043},  {18502, -27045},  {18499, -27047},
    {18496, -27049},  {18494, -27050},  {18491, -27052},  {18489, -27054},  {18486, -27056},  {18483, -27057},
    {18481, -27059},  {18478, -27061},  {18476, -27063},  {18473, -27064},  {18470, -27066},  {18468, -27068},
    {18465, -27070},  {18463, -27072},  {18460, -27073},  {18458, -27075},  {18455, -27077},  {18452, -27079},
    {18450, -27080},  {18447, -27082},  {18445, -27084},  {18442, -27086},  {18439, -27088},  {18437, -27089},
    {18434, -27091},  {18432, -27093},  {18429, -27095},  {18426, -27096},  {18424, -27098},  {18421, -27100},
    {18419, -27102},  {18416, -27103},  {18413, -27105},  {18411, -27107},  {18408, -27109},  {18406, -27110},
    {18403, -27112},  {18400, -27114},  {18398, -27116},  {18395, -27118},  {18393, -27119},  {18390, -27121},
    {18387, -27123},  {18385, -27125},  {18382, -27126},  {18380, -27128},  {18377, -27130},  {18374, -27132},
    {18372, -27133},  {18369, -27135},  {18367, -27137},  {18364, -27139},  {18361, -27140},  {18359, -27142},
    {18356, -27144},  {18354, -27146},  {18351, -27147},  {18348, -27149},  {18346, -27151},  {18343, -27153},
    {18341, -27154},  {18338, -27156},  {18335, -27158},  {18333, -27160},  {18330, -27162},  {18328, -27163},
    {18325, -27165},  {18322, -27167},  {18320, -27169},  {18317, -27170},  {18314, -27172},  {18312, -27174},
    {18309, -27176},  {18307, -27177},  {18304, -27179},  {18301, -27181},  {18299, -27183},  {18296, -27184},
    {18294, -27186},  {18291, -27188},  {18288, -27190},  {18286, -27191},  {18283, -27193},  {18281, -27195},
    {18278, -27197},  {18275, -27198},  {18273, -27200},  {18270, -27202},  {18268, -27204},  {18265, -27205},
    {18262, -27207},  {18260, -27209},  {18257, -27211},  {18255, -27212},  {18252, -27214},  {18249, -27216},
    {18247, -27218},  {18244, -27219},  {18241, -27221},  {18239, -27223},  {18236, -27225},  {18234, -27226},
    {18231, -27228},  {18228, -27230},  {18226, -27232},  {18223, -27233},  {18221, -27235},  {18218, -27237},
    {18215, -27239},  {18213, -27240},  {18210, -27242},  {18208, -27244},  {18205, -27246},  {18202, -27247},
    {18200, -27249},  {18197, -27251},  {18194, -27253},  {18192, -27254},  {18189, -27256},  {18187, -27258},
    {18184, -27260},  {18181, -27261},  {18179, -27263},  {18176, -27265},  {18174, -27267},  {18171, -27268},
    {18168, -27270},  {18166, -27272},  {18163, -27273},  {18160, -27275},  {18158, -27277},  {18155, -27279},
    {18153, -27280},  {18150, -27282},  {18147, -27284},  {18145, -27286},  {18142, -27287},  {18140, -27289},
    {18137, -27291},  {18134, -27293},  {18132, -27294},  {18129, -27296},  {18126, -27298},  {18124, -27300},
    {18121, -27301},  {18119, -27303},  {18116, -27305},  {18113, -27307},  {18111, -27308},  {18108, -27310},
    {18106, -27312},  {18103, -27313},  {18100, -27315},  {18098, -27317},  {18095, -27319},  {18092, -27320},
    {18090, -27322},  {18087, -27324},  {18085, -27326},  {18082, -27327},  {18079, -27329},  {18077, -27331},
    {18074, -27333},  {18071, -27334},  {18069, -27336},  {18066, -27338},  {18064, -27339},  {18061, -27341},
    {18058, -27343},  {18056, -27345},  {18053, -27346},  {18051, -27348},  {18048, -27350},  {18045, -27352},
    {18043, -27353},  {18040, -27355},  {18037, -27357},  {18035, -27359},  {18032, -27360},  {18030, -27362},
    {18027, -27364},  {18024, -27365},  {18022, -27367},  {18019, -27369},  {18016, -27371},  {18014, -27372},
    {18011, -27374},  {18009, -27376},  {18006, -27378},  {18003, -27379},  {18001, -27381},  {17998, -27383},
    {17995, -27384},  {17993, -27386},  {17990, -27388},  {17988, -27390},  {17985, -27391},  {17982, -27393},
    {17980, -27395},  {17977, -27396},  {17974, -27398},  {17972, -27400},  {17969, -27402},  {17967, -27403},
    {17964, -27405},  {17961, -27407},  {17959, -27409},  {17956, -27410},  {17953, -27412},  {17951, -27414},
    {17948, -27415},  {17946, -27417},  {17943, -27419},  {17940, -27421},  {17938, -27422},  {17935, -27424},
    {17932, -27426},  {17930, -27427},  {17927, -27429},  {17924, -27431},  {17922, -27433},  {17919, -27434},
    {17917, -27436},  {17914, -27438},  {17911, -27440},  {17909, -27441},  {17906, -27443},  {17903, -27445},
    {17901, -27446},  {17898, -27448},  {17896, -27450},  {17893, -27452},  {17890, -27453},  {17888, -27455},
    {17885, -27457},  {17882, -27458},  {17880, -27460},  {17877, -27462},  {17874, -27464},  {17872, -27465},
    {17869, -27467},  {17867, -27469},  {17864, -27470},  {17861, -27472},  {17859, -27474},  {17856, -27476},
    {17853, -27477},  {17851, -27479},  {17848, -27481},  {17846, -27482},  {17843, -27484},  {17840, -27486},
    {17838, -27487},  {17835, -27489},  {17832, -27491},  {17830, -27493},  {17827, -27494},  {17824, -27496},
    {17822, -27498},  {17819, -27499},  {17817, -27501},  {17814, -27503},  {17811, -27505},  {17809, -27506},
    {17806, -27508},  {17803, -27510},  {17801, -27511},  {17798, -27513},  {17795, -27515},  {17793, -27517},
    {17790, -27518},  {17787, -27520},  {17785, -27522},  {17782, -27523},  {17780, -27525},  {17777, -27527},
    {17774, -27528},  {17772, -27530},  {17769, -27532},  {17766, -27534},  {17764, -27535},  {17761, -27537},
    {17758, -27539},  {17756, -27540},  {17753, -27542},  {17751, -27544},  {17748, -27545},  {17745, -27547},
    {17743, -27549},  {17740, -27551},  {17737, -27552},  {17735, -27554},  {17732, -27556},  {17729, -27557},
    {17727, -27559},  {17724, -27561},  {17721, -27562},  {17719, -27564},  {17716, -27566},  {17714, -27568},
    {17711, -27569},  {17708, -27571},  {17706, -27573},  {17703, -27574},  {17700, -27576},  {17698, -27578},
    {17695, -27579},  {17692, -27581},  {17690, -27583},  {17687, -27585},  {17684, -27586},  {17682, -27588},
    {17679, -27590},  {17677, -27591},  {17674, -27593},  {17671, -27595},  {17669, -27596},  {17666, -27598},
    {17663, -27600},  {17661, -27601},  {17658, -27603},  {17655, -27605},  {17653, -27607},  {17650, -27608},
    {17647, -27610},  {17645, -27612},  {17642, -27613},  {17639, -27615},  {17637, -27617},  {17634, -27618},
    {17632, -27620},  {17629, -27622},  {17626, -27623},  {17624, -27625},  {17621, -27627},  {17618, -27629},
    {17616, -27630},  {17613, -27632},  {17610, -27634},  {17608, -27635},  {17605, -27637},  {17602, -27639},
    {17600, -27640},  {17597, -27642},  {17594, -27644},  {17592, -27645},  {17589, -27647},  {17587, -27649},
    {17584, -27650},  {17581, -27652},  {17579, -27654},  {17576, -27656},  {17573, -27657},  {17571, -27659},
    {17568, -27661},  {17565, -27662},  {17563, -27664},  {17560, -27666},  {17557, -27667},  {17555, -27669},
    {17552, -27671},  {17549, -27672},  {17547, -27674},  {17544, -27676},  {17541, -27677},  {17539, -27679},
    {17536, -27681},  {17533, -27682},  {17531, -27684},  {17528, -27686},  {17525, -27688},  {17523, -27689},
    {17520, -27691},  {17518, -27693},  {17515, -27694},  {17512, -27696},  {17510, -27698},  {17507, -27699},
    {17504, -27701},  {17502, -27703},  {17499, -27704},  {17496, -27706},  {17494, -27708},  {17491, -27709},
    {17488, -27711},  {17486, -27713},  {17483, -27714},  {17480, -27716},  {17478, -27718},  {17475, -27719},
    {17472, -27721},  {17470, -27723},  {17467, -27724},  {17464, -27726},  {17462, -27728},  {17459, -27729},
    {17456, -27731},  {17454, -27733},  {17451, -27734},  {17448, -27736},  {17446, -27738},  {17443, -27739},
    {17440, -27741},  {17438, -27743},  {17435, -27745},  {17432, -27746},  {17430, -27748},  {17427, -27750},
    {17425, -27751},  {17422, -27753},  {17419, -27755},  {17417, -27756},  {17414, -27758},  {17411, -27760},
    {17409, -27761},  {17406, -27763},  {17403, -27765},  {17401, -27766},  {17398, -27768},  {17395, -27770},
    {17393, -27771},  {17390, -27773},  {17387, -27775},  {17385, -27776},  {17382, -27778},  {17379, -27780},
    {17377, -27781},  {17374, -27783},  {17371, -27785},  {17369, -27786},  {17366, -27788},  {17363, -27790},
    {17361, -27791},  {17358, -27793},  {17355, -27795},  {17353, -27796},  {17350, -27798},  {17347, -27800},
    {17345, -27801},  {17342, -27803},  {17339, -27805},  {17337, -27806},  {17334, -27808},  {17331, -27810},
    {17329, -27811},  {17326, -27813},  {17323, -27814},  {17321, -27816},  {17318, -27818},  {17315, -27819},
    {17313, -27821},  {17310, -27823},  {17307, -27824},  {17305, -27826},  {17302, -27828},  {17299, -27829},
    {17297, -27831},  {17294, -27833},  {17291, -27834},  {17289, -27836},  {17286, -27838},  {17283, -27839},
    {17281, -27841},  {17278, -27843},  {17275, -27844},  {17273, -27846},  {17270, -27848},  {17267, -27849},
    {17265, -27851},  {17262, -27853},  {17259, -27854},  {17257, -27856},  {17254, -27858},  {17251, -27859},
    {17249, -27861},  {17246, -27863},  {17243, -27864},  {17241, -27866},  {17238, -27868},  {17235, -27869},
    {17233, -27871},  {17230, -27872},  {17227, -27874},  {17225, -27876},  {17222, -27877},  {17219, -27879},
    {17216, -27881},  {17214, -27882},  {17211, -27884},  {17208, -27886},  {17206, -27887},  {17203, -27889},
    {17200, -27891},  {17198, -27892},  {17195, -27894},  {17192, -27896},  {17190, -27897},  {17187, -27899},
    {17184, -27901},  {17182, -27902},  {17179, -27904},  {17176, -27905},  {17174, -27907},  {17171, -27909},
    {17168, -27910},  {17166, -27912},  {17163, -27914},  {17160, -27915},  {17158, -27917},  {17155, -27919},
    {17152, -27920},  {17150, -27922},  {17147, -27924},  {17144, -27925},  {17142, -27927},  {17139, -27928},
    {17136, -27930},  {17134, -27932},  {17131, -27933},  {17128, -27935},  {17126, -27937},  {17123, -27938},
    {17120, -27940},  {17117, -27942},  {17115, -27943},  {17112, -27945},  {17109, -27947},  {17107, -27948},
    {17104, -27950},  {17101, -27951},  {17099, -27953},  {17096, -27955},  {17093, -27956},  {17091, -27958},
    {17088, -27960},  {17085, -27961},  {17083, -27963},  {17080, -27965},  {17077, -27966},  {17075, -27968},
    {17072, -27969},  {17069, -27971},  {17067, -27973},  {17064, -27974},  {17061, -27976},  {17059, -27978},
    {17056, -27979},  {17053, -27981},  {17050, -27983},  {17048, -27984},  {17045, -27986},  {17042, -27987},
    {17040, -27989},  {17037, -27991},  {17034, -27992},  {17032, -27994},  {17029, -27996},  {17026, -27997},
    {17024, -27999},  {17021, -28001},  {17018, -28002},  {17016, -28004},  {17013, -28005},  {17010, -28007},
    {17008, -28009},  {17005, -28010},  {17002, -28012},  {16999, -28014},  {16997, -28015},  {16994, -28017},
    {16991, -28018},  {16989, -28020},  {16986, -28022},  {16983, -28023},  {16981, -28025},  {16978, -28027},
    {16975, -28028},  {16973, -28030},  {16970, -28031},  {16967, -28033},  {16965, -28035},  {16962, -28036},
    {16959, -28038},  {16956, -28040},  {16954, -28041},  {16951, -28043},  {16948, -28044},  {16946, -28046},
    {16943, -28048},  {16940, -28049},  {16938, -28051},  {16935, -28053},  {16932, -28054},  {16930, -28056},
    {16927, -28057},  {16924, -28059},  {16922, -28061},  {16919, -28062},  {16916, -28064},  {16913, -28066},
    {16911, -28067},  {16908, -28069},  {16905, -28070},  {16903, -28072},  {16900, -28074},  {16897, -28075},
    {16895, -28077},  {16892, -28079},  {16889, -28080},  {16887, -28082},  {16884, -28083},  {16881, -28085},
    {16878, -28087},  {16876, -28088},  {16873, -28090},  {16870, -28092},  {16868, -28093},  {16865, -28095},
    {16862, -28096},  {16860, -28098},  {16857, -28100},  {16854, -28101},  {16852, -28103},  {16849, -28104},
    {16846, -28106},  {16843, -28108},  {16841, -28109},  {16838, -28111},  {16835, -28113},  {16833, -28114},
    {16830, -28116},  {16827, -28117},  {16825, -28119},  {16822, -28121},  {16819, -28122},  {16816, -28124},
    {16814, -28125},  {16811, -28127},  {16808, -28129},  {16806, -28130},  {16803, -28132},  {16800, -28133},
    {16798, -28135},  {16795, -28137},  {16792, -28138},  {16789, -28140},  {16787, -28142},  {16784, -28143},
    {16781, -28145},  {16779, -28146},  {16776, -28148},  {16773, -28150},  {16771, -28151},  {16768, -28153},
    {16765, -28154},  {16763, -28156},  {16760, -28158},  {16757, -28159},  {16754, -28161},  {16752, -28162},
    {16749, -28164},  {16746, -28166},  {16744, -28167},  {16741, -28169},  {16738, -28170},  {16736, -28172},
    {16733, -28174},  {16730, -28175},  {16727, -28177},  {16725, -28178},  {16722, -28180},  {16719, -28182},
    {16717, -28183},  {16714, -28185},  {16711, -28186},  {16708, -28188},  {16706, -28190},  {16703, -28191},
    {16700, -28193},  {16698, -28194},  {16695, -28196},  {16692, -28198},  {16690, -28199},  {16687, -28201},
    {16684, -28202},  {16681, -28204},  {16679, -28206},  {16676, -28207},  {16673, -28209},  {16671, -28210},
    {16668, -28212},  {16665, -28214},  {16663, -28215},  {16660, -28217},  {16657, -28218},  {16654, -28220},
    {16652, -28222},  {16649, -28223},  {16646, -28225},  {16644, -28226},  {16641, -28228},  {16638, -28230},
    {16635, -28231},  {16633, -28233},  {16630, -28234},  {16627, -28236},  {16625, -28238},  {16622, -28239},
    {16619, -28241},  {16617, -28242},  {16614, -28244},  {16611, -28246},  {16608, -28247},  {16606, -28249},
    {16603, -28250},  {16600, -28252},  {16598, -28254},  {16595, -28255},  {16592, -28257},  {16589, -28258},
    {16587, -28260},  {16584, -28261},  {16581, -28263},  {16579, -28265},  {16576, -28266},  {16573, -28268},
    {16570, -28269},  {16568, -28271},  {16565, -28273},  {16562, -28274},  {16560, -28276},  {16557, -28277},
    {16554, -28279},  {16551, -28281},  {16549, -28282},  {16546, -28284},  {16543, -28285},  {16541, -28287},
    {16538, -28288},  {16535, -28290},  {16533, -28292},  {16530, -28293},  {16527, -28295},  {16524, -28296},
    {16522, -28298},  {16519, -28300},  {16516, -28301},  {16514, -28303},  {16511, -28304},  {16508, -28306},
    {16505, -28307},  {16503, -28309},  {16500, -28311},  {16497, -28312},  {16495, -28314},  {16492, -28315},
    {16489, -28317},  {16486, -28319},  {16484, -28320},  {16481, -28322},  {16478, -28323},  {16476, -28325},
    {16473, -28326},  {16470, -28328},  {16467, -28330},  {16465, -28331},  {16462, -28333},  {16459, -28334},
    {16456, -28336},  {16454, -28338},  {16451, -28339},  {16448, -28341},  {16446, -28342},  {16443, -28344},
    {16440, -28345},  {16437, -28347},  {16435, -28349},  {16432, -28350},  {16429, -28352},  {16427, -28353},
    {16424, -28355},  {16421, -28356},  {16418, -28358},  {16416, -28360},  {16413, -28361},  {16410, -28363},
    {16408, -28364},  {16405, -28366},  {16402, -28367},  {16399, -28369},  {16397, -28371},  {16394, -28372},
    {16391, -28374},  {16389, -28375},  {16386, -28377},  {16383, -28378},  {16380, -28380},  {16378, -28382},
    {16375, -28383},  {16372, -28385},  {16369, -28386},  {16367, -28388},  {16364, -28389},  {16361, -28391},
    {16359, -28393},  {16356, -28394},  {16353, -28396},  {16350, -28397},  {16348, -28399},  {16345, -28400},
    {16342, -28402},  {16340, -28404},  {16337, -28405},  {16334, -28407},  {16331, -28408},  {16329, -28410},
    {16326, -28411},  {16323, -28413},  {16320, -28415},  {16318, -28416},  {16315, -28418},  {16312, -28419},
    {16310, -28421},  {16307, -28422},  {16304, -28424},  {16301, -28425},  {16299, -28427},  {16296, -28429},
    {16293, -28430},  {16291, -28432},  {16288, -28433},  {16285, -28435},  {16282, -28436},  {16280, -28438},
    {16277, -28440},  {16274, -28441},  {16271, -28443},  {16269, -28444},  {16266, -28446},  {16263, -28447},
    {16261, -28449},  {16258, -28450},  {16255, -28452},  {16252, -28454},  {16250, -28455},  {16247, -28457},
    {16244, -28458},  {16241, -28460},  {16239, -28461},  {16236, -28463},  {16233, -28464},  {16230, -28466},
    {16228, -28468},  {16225, -28469},  {16222, -28471},  {16220, -28472},  {16217, -28474},  {16214, -28475},
    {16211, -28477},  {16209, -28478},  {16206, -28480},  {16203, -28482},  {16200, -28483},  {16198, -28485},
    {16195, -28486},  {16192, -28488},  {16190, -28489},  {16187, -28491},  {16184, -28492},  {16181, -28494},
    {16179, -28496},  {16176, -28497},  {16173, -28499},  {16170, -28500},  {16168, -28502},  {16165, -28503},
    {16162, -28505},  {16159, -28506},  {16157, -28508},  {16154, -28509},  {16151, -28511},  {16149, -28513},
    {16146, -28514},  {16143, -28516},  {16140, -28517},  {16138, -28519},  {16135, -28520},  {16132, -28522},
    {16129, -28523},  {16127, -28525},  {16124, -28526},  {16121, -28528},  {16118, -28530},  {16116, -28531},
    {16113, -28533},  {16110, -28534},  {16108, -28536},  {16105, -28537},  {16102, -28539},  {16099, -28540},
    {16097, -28542},  {16094, -28543},  {16091, -28545},  {16088, -28547},  {16086, -28548},  {16083, -28550},
    {16080, -28551},  {16077, -28553},  {16075, -28554},  {16072, -28556},  {16069, -28557},  {16066, -28559},
    {16064, -28560},  {16061, -28562},  {16058, -28564},  {16056, -28565},  {16053, -28567},  {16050, -28568},
    {16047, -28570},  {16045, -28571},  {16042, -28573},  {16039, -28574},  {16036, -28576},  {16034, -28577},
    {16031, -28579},  {16028, -28580},  {16025, -28582},  {16023, -28583},  {16020, -28585},  {16017, -28587},
    {16014, -28588},  {16012, -28590},  {16009, -28591},  {16006, -28593},  {16003, -28594},  {16001, -28596},
    {15998, -28597},  {15995, -28599},  {15992, -28600},  {15990, -28602},  {15987, -28603},  {15984, -28605},
    {15982, -28607},  {15979, -28608},  {15976, -28610},  {15973, -28611},  {15971, -28613},  {15968, -28614},
    {15965, -28616},  {15962, -28617},  {15960, -28619},  {15957, -28620},  {15954, -28622},  {15951, -28623},
    {15949, -28625},  {15946, -28626},  {15943, -28628},  {15940, -28629},  {15938, -28631},  {15935, -28633},
    {15932, -28634},  {15929, -28636},  {15927, -28637},  {15924, -28639},  {15921, -28640},  {15918, -28642},
    {15916, -28643},  {15913, -28645},  {15910, -28646},  {15907, -28648},  {15905, -28649},  {15902, -28651},
    {15899, -28652},  {15896, -28654},  {15894, -28655},  {15891, -28657},  {15888, -28658},  {15885, -28660},
    {15883, -28662},  {15880, -28663},  {15877, -28665},  {15874, -28666},  {15872, -28668},  {15869, -28669},
    {15866, -28671},  {15863, -28672},  {15861, -28674},  {15858, -28675},  {15855, -28677},  {15852, -28678},
    {15850, -28680},  {15847, -28681},  {15844, -28683},  {15841, -28684},  {15839, -28686},  {15836, -28687},
    {15833, -28689},  {15830, -28690},  {15828, -28692},  {15825, -28693},  {15822, -28695},  {15819, -28696},
    {15817, -28698},  {15814, -28699},  {15811, -28701},  {15808, -28703},  {15806, -28704},  {15803, -28706},
    {15800, -28707},  {15797, -28709},  {15795, -28710},  {15792, -28712},  {15789, -28713},  {15786, -28715},
    {15784, -28716},  {15781, -28718},  {15778, -28719},  {15775, -28721},  {15773, -28722},  {15770, -28724},
    {15767, -28725},  {15764, -28727},  {15762, -28728},  {15759, -28730},  {15756, -28731},  {15753, -28733},
    {15751, -28734},  {15748, -28736},  {15745, -28737},  {15742, -28739},  {15740, -28740},  {15737, -28742},
    {15734, -28743},  {15731, -28745},  {15729, -28746},  {15726, -28748},  {15723, -28749},  {15720, -28751},
    {15718, -28752},  {15715, -28754},  {15712, -28755},  {15709, -28757},  {15707, -28758},  {15704, -28760},
    {15701, -28761},  {15698, -28763},  {15696, -28764},  {15693, -28766},  {15690, -28767},  {15687, -28769},
    {15684, -28770},  {15682, -28772},  {15679, -28773},  {15676, -28775},  {15673, -28776},  {15671, -28778},
    {15668, -28779},  {15665, -28781},  {15662, -28782},  {15660, -28784},  {15657, -28785},  {15654, -28787},
    {15651, -28788},  {15649, -28790},  {15646, -28791},  {15643, -28793},  {15640, -28794},  {15638, -28796},
    {15635, -28797},  {15632, -28799},  {15629, -28800},  {15627, -28802},  {15624, -28803},  {15621, -28805},
    {15618, -28806},  {15615, -28808},  {15613, -28809},  {15610, -28811},  {15607, -28812},  {15604, -28814},
    {15602, -28815},  {15599, -28817},  {15596, -28818},  {15593, -28820},  {15591, -28821},  {15588, -28823},
    {15585, -28824},  {15582, -28826},  {15580, -28827},  {15577, -28829},  {15574, -28830},  {15571, -28832},
    {15568, -28833},  {15566, -28835},  {15563, -28836},  {15560, -28838},  {15557, -28839},  {15555, -28841},
    {15552, -28842},  {15549, -28844},  {15546, -28845},  {15544, -28847},  {15541, -28848},  {15538, -28850},
    {15535, -28851},  {15533, -28853},  {15530, -28854},  {15527, -28856},  {15524, -28857},  {15521, -28859},
    {15519, -28860},  {15516, -28862},  {15513, -28863},  {15510, -28865},  {15508, -28866},  {15505, -28868},
    {15502, -28869},  {15499, -28871},  {15497, -28872},  {15494, -28874},  {15491, -28875},  {15488, -28877},
    {15486, -28878},  {15483, -28880},  {15480, -28881},  {15477, -28882},  {15474, -28884},  {15472, -28885},
    {15469, -28887},  {15466, -28888},  {15463, -28890},  {15461, -28891},  {15458, -28893},  {15455, -28894},
    {15452, -28896},  {15449, -28897},  {15447, -28899},  {15444, -28900},  {15441, -28902},  {15438, -28903},
    {15436, -28905},  {15433, -28906},  {15430, -28908},  {15427, -28909},  {15425, -28911},  {15422, -28912},
    {15419, -28914},  {15416, -28915},  {15413, -28917},  {15411, -28918},  {15408, -28920},  {15405, -28921},
    {15402, -28922},  {15400, -28924},  {15397, -28925},  {15394, -28927},  {15391, -28928},  {15389, -28930},
    {15386, -28931},  {15383, -28933},  {15380, -28934},  {15377, -28936},  {15375, -28937},  {15372, -28939},
    {15369, -28940},  {15366, -28942},  {15364, -28943},  {15361, -28945},  {15358, -28946},  {15355, -28948},
    {15352, -28949},  {15350, -28950},  {15347, -28952},  {15344, -28953},  {15341, -28955},  {15339, -28956},
    {15336, -28958},  {15333, -28959},  {15330, -28961},  {15327, -28962},  {15325, -28964},  {15322, -28965},
    {15319, -28967},  {15316, -28968},  {15314, -28970},  {15311, -28971},  {15308, -28973},  {15305, -28974},
    {15302, -28975},  {15300, -28977},  {15297, -28978},  {15294, -28980},  {15291, -28981},  {15289, -28983},
    {15286, -28984},  {15283, -28986},  {15280, -28987},  {15277, -28989},  {15275, -28990},  {15272, -28992},
    {15269, -28993},  {15266, -28994},  {15264, -28996},  {15261, -28997},  {15258, -28999},  {15255, -29000},
    {15252, -29002},  {15250, -29003},  {15247, -29005},  {15244, -29006},  {15241, -29008},  {15239, -29009},
    {15236, -29011},  {15233, -29012},  {15230, -29013},  {15227, -29015},  {15225, -29016},  {15222, -29018},
    {15219, -29019},  {15216, -29021},  {15213, -29022},  {15211, -29024},  {15208, -29025},  {15205, -29027},
    {15202, -29028},  {15200, -29030},  {15197, -29031},  {15194, -29032},  {15191, -29034},  {15188, -29035},
    {15186, -29037},  {15183, -29038},  {15180, -29040},  {15177, -29041},  {15175, -29043},  {15172, -29044},
    {15169, -29046},  {15166, -29047},  {15163, -29048},  {15161, -29050},  {15158, -29051},  {15155, -29053},
    {15152, -29054},  {15149, -29056},  {15147, -29057},  {15144, -29059},  {15141, -29060},  {15138, -29062},
    {15136, -29063},  {15133, -29064},  {15130, -29066},  {15127, -29067},  {15124, -29069},  {15122, -29070},
    {15119, -29072},  {15116, -29073},  {15113, -29075},  {15110, -29076},  {15108, -29077},  {15105, -29079},
    {15102, -29080},  {15099, -29082},  {15097, -29083},  {15094, -29085},  {15091, -29086},  {15088, -29088},
    {15085, -29089},  {15083, -29091},  {15080, -29092},  {15077, -29093},  {15074, -29095},  {15071, -29096},
    {15069, -29098},  {15066, -29099},  {15063, -29101},  {15060, -29102},  {15057, -29104},  {15055, -29105},
    {15052, -29106},  {15049, -29108},  {15046, -29109},  {15044, -29111},  {15041, -29112},  {15038, -29114},
    {15035, -29115},  {15032, -29116},  {15030, -29118},  {15027, -29119},  {15024, -29121},  {15021, -29122},
    {15018, -29124},  {15016, -29125},  {15013, -29127},  {15010, -29128},  {15007, -29129},  {15004, -29131},
    {15002, -29132},  {14999, -29134},  {14996, -29135},  {14993, -29137},  {14990, -29138},  {14988, -29140},
    {14985, -29141},  {14982, -29142},  {14979, -29144},  {14976, -29145},  {14974, -29147},  {14971, -29148},
    {14968, -29150},  {14965, -29151},  {14963, -29152},  {14960, -29154},  {14957, -29155},  {14954, -29157},
    {14951, -29158},  {14949, -29160},  {14946, -29161},  {14943, -29162},  {14940, -29164},  {14937, -29165},
    {14935, -29167},  {14932, -29168},  {14929, -29170},  {14926, -29171},  {14923, -29173},  {14921, -29174},
    {14918, -29175},  {14915, -29177},  {14912, -29178},  {14909, -29180},  {14907, -29181},  {14904, -29183},
    {14901, -29184},  {14898, -29185},  {14895, -29187},  {14893, -29188},  {14890, -29190},  {14887, -29191},
    {14884, -29193},  {14881, -29194},  {14879, -29195},  {14876, -29197},  {14873, -29198},  {14870, -29200},
    {14867, -29201},  {14865, -29202},  {14862, -29204},  {14859, -29205},  {14856, -29207},  {14853, -29208},
    {14851, -29210},  {14848, -29211},  {14845, -29212},  {14842, -29214},  {14839, -29215},  {14837, -29217},
    {14834, -29218},  {14831, -29220},  {14828, -29221},  {14825, -29222},  {14823, -29224},  {14820, -29225},
    {14817, -29227},  {14814, -29228},  {14811, -29230},  {14809, -29231},  {14806, -29232},  {14803, -29234},
    {14800, -29235},  {14797, -29237},  {14795, -29238},  {14792, -29239},  {14789, -29241},  {14786, -29242},
    {14783, -29244},  {14781, -29245},  {14778, -29247},  {14775, -29248},  {14772, -29249},  {14769, -29251},
    {14767, -29252},  {14764, -29254},  {14761, -29255},  {14758, -29256},  {14755, -29258},  {14753, -29259},
    {14750, -29261},  {14747, -29262},  {14744, -29264},  {14741, -29265},  {14738, -29266},  {14736, -29268},
    {14733, -29269},  {14730, -29271},  {14727, -29272},  {14724, -29273},  {14722, -29275},  {14719, -29276},
    {14716, -29278},  {14713, -29279},  {14710, -29280},  {14708, -29282},  {14705, -29283},  {14702, -29285},
    {14699, -29286},  {14696, -29288},  {14694, -29289},  {14691, -29290},  {14688, -29292},  {14685, -29293},
    {14682, -29295},  {14680, -29296},  {14677, -29297},  {14674, -29299},  {14671, -29300},  {14668, -29302},
    {14665, -29303},  {14663, -29304},  {14660, -29306},  {14657, -29307},  {14654, -29309},  {14651, -29310},
    {14649, -29311},  {14646, -29313},  {14643, -29314},  {14640, -29316},  {14637, -29317},  {14635, -29318},
    {14632, -29320},  {14629, -29321},  {14626, -29323},  {14623, -29324},  {14621, -29325},  {14618, -29327},
    {14615, -29328},  {14612, -29330},  {14609, -29331},  {14606, -29332},  {14604, -29334},  {14601, -29335},
    {14598, -29337},  {14595, -29338},  {14592, -29339},  {14590, -29341},  {14587, -29342},  {14584, -29344},
    {14581, -29345},  {14578, -29346},  {14576, -29348},  {14573, -29349},  {14570, -29351},  {14567, -29352},
    {14564, -29353},  {14561, -29355},  {14559, -29356},  {14556, -29358},  {14553, -29359},  {14550, -29360},
    {14547, -29362},  {14545, -29363},  {14542, -29365},  {14539, -29366},  {14536, -29367},  {14533, -29369},
    {14530, -29370},  {14528, -29372},  {14525, -29373},  {14522, -29374},  {14519, -29376},  {14516, -29377},
    {14514, -29379},  {14511, -29380},  {14508, -29381},  {14505, -29383},  {14502, -29384},  {14499, -29385},
    {14497, -29387},  {14494, -29388},  {14491, -29390},  {14488, -29391},  {14485, -29392},  {14483, -29394},
    {14480, -29395},  {14477, -29397},  {14474, -29398},  {14471, -29399},  {14468, -29401},  {14466, -29402},
    {14463, -29404},  {14460, -29405},  {14457, -29406},  {14454, -29408},  {14452, -29409},  {14449, -29410},
    {14446, -29412},  {14443, -29413},  {14440, -29415},  {14437, -29416},  {14435, -29417},  {14432, -29419},
    {14429, -29420},  {14426, -29422},  {14423, -29423},  {14421, -29424},  {14418, -29426},  {14415, -29427},
    {14412, -29428},  {14409, -29430},  {14406, -29431},  {14404, -29433},  {14401, -29434},  {14398, -29435},
    {14395, -29437},  {14392, -29438},  {14390, -29439},  {14387, -29441},  {14384, -29442},  {14381, -29444},
    {14378, -29445},  {14375, -29446},  {14373, -29448},  {14370, -29449},  {14367, -29451},  {14364, -29452},
    {14361, -29453},  {14358, -29455},  {14356, -29456},  {14353, -29457},  {14350, -29459},  {14347, -29460},
    {14344, -29462},  {14342, -29463},  {14339, -29464},  {14336, -29466},  {14333, -29467},  {14330, -29468},
    {14327, -29470},  {14325, -29471},  {14322, -29473},  {14319, -29474},  {14316, -29475},  {14313, -29477},
    {14310, -29478},  {14308, -29479},  {14305, -29481},  {14302, -29482},  {14299, -29484},  {14296, -29485},
    {14293, -29486},  {14291, -29488},  {14288, -29489},  {14285, -29490},  {14282, -29492},  {14279, -29493},
    {14277, -29494},  {14274, -29496},  {14271, -29497},  {14268, -29499},  {14265, -29500},  {14262, -29501},
    {14260, -29503},  {14257, -29504},  {14254, -29505},  {14251, -29507},  {14248, -29508},  {14245, -29509},
    {14243, -29511},  {14240, -29512},  {14237, -29514},  {14234, -29515},  {14231, -29516},  {14228, -29518},
    {14226, -29519},  {14223, -29520},  {14220, -29522},  {14217, -29523},  {14214, -29525},  {14211, -29526},
    {14209, -29527},  {14206, -29529},  {14203, -29530},  {14200, -29531},  {14197, -29533},  {14194, -29534},
    {14192, -29535},  {14189, -29537},  {14186, -29538},  {14183, -29539},  {14180, -29541},  {14177, -29542},
    {14175, -29544},  {14172, -29545},  {14169, -29546},  {14166, -29548},  {14163, -29549},  {14160, -29550},
    {14158, -29552},  {14155, -29553},  {14152, -29554},  {14149, -29556},  {14146, -29557},  {14143, -29558},
    {14141, -29560},  {14138, -29561},  {14135, -29563},  {14132, -29564},  {14129, -29565},  {14126, -29567},
    {14124, -29568},  {14121, -29569},  {14118, -29571},  {14115, -29572},  {14112, -29573},  {14109, -29575},
    {14107, -29576},  {14104, -29577},  {14101, -29579},  {14098, -29580},  {14095, -29582},  {14092, -29583},
    {14090, -29584},  {14087, -29586},  {14084, -29587},  {14081, -29588},  {14078, -29590},  {14075, -29591},
    {14073, -29592},  {14070, -29594},  {14067, -29595},  {14064, -29596},  {14061, -29598},  {14058, -29599},
    {14056, -29600},  {14053, -29602},  {14050, -29603},  {14047, -29604},  {14044, -29606},  {14041, -29607},
    {14039, -29608},  {14036, -29610},  {14033, -29611},  {14030, -29613},  {14027, -29614},  {14024, -29615},
    {14021, -29617},  {14019, -29618},  {14016, -29619},  {14013, -29621},  {14010, -29622},  {14007, -29623},
    {14004, -29625},  {14002, -29626},  {13999, -29627},  {13996, -29629},  {13993, -29630},  {13990, -29631},
    {13987, -29633},  {13985, -29634},  {13982, -29635},  {13979, -29637},  {13976, -29638},  {13973, -29639},
    {13970, -29641},  {13968, -29642},  {13965, -29643},  {13962, -29645},  {13959, -29646},  {13956, -29647},
    {13953, -29649},  {13950, -29650},  {13948, -29651},  {13945, -29653},  {13942, -29654},  {13939, -29655},
    {13936, -29657},  {13933, -29658},  {13931, -29659},  {13928, -29661},  {13925, -29662},  {13922, -29663},
    {13919, -29665},  {13916, -29666},  {13913, -29667},  {13911, -29669},  {13908, -29670},  {13905, -29671},
    {13902, -29673},  {13899, -29674},  {13896, -29675},  {13894, -29677},  {13891, -29678},  {13888, -29679},
    {13885, -29681},  {13882, -29682},  {13879, -29683},  {13877, -29685},  {13874, -29686},  {13871, -29687},
    {13868, -29689},  {13865, -29690},  {13862, -29691},  {13859, -29693},  {13857, -29694},  {13854, -29695},
    {13851, -29697},  {13848, -29698},  {13845, -29699},  {13842, -29701},  {13839, -29702},  {13837, -29703},
    {13834, -29705},  {13831, -29706},  {13828, -29707},  {13825, -29709},  {13822, -29710},  {13820, -29711},
    {13817, -29713},  {13814, -29714},  {13811, -29715},  {13808, -29717},  {13805, -29718},  {13802, -29719},
    {13800, -29721},  {13797, -29722},  {13794, -29723},  {13791, -29725},  {13788, -29726},  {13785, -29727},
    {13783, -29729},  {13780, -29730},  {13777, -29731},  {13774, -29732},  {13771, -29734},  {13768, -29735},
    {13765, -29736},  {13763, -29738},  {13760, -29739},  {13757, -29740},  {13754, -29742},  {13751, -29743},
    {13748, -29744},  {13745, -29746},  {13743, -29747},  {13740, -29748},  {13737, -29750},  {13734, -29751},
    {13731, -29752},  {13728, -29754},  {13725, -29755},  {13723, -29756},  {13720, -29758},  {13717, -29759},
    {13714, -29760},  {13711, -29761},  {13708, -29763},  {13706, -29764},  {13703, -29765},  {13700, -29767},
    {13697, -29768},  {13694, -29769},  {13691, -29771},  {13688, -29772},  {13686, -29773},  {13683, -29775},
    {13680, -29776},  {13677, -29777},  {13674, -29779},  {13671, -29780},  {13668, -29781},  {13666, -29782},
    {13663, -29784},  {13660, -29785},  {13657, -29786},  {13654, -29788},  {13651, -29789},  {13648, -29790},
    {13646, -29792},  {13643, -29793},  {13640, -29794},  {13637, -29796},  {13634, -29797},  {13631, -29798},
    {13628, -29799},  {13626, -29801},  {13623, -29802},  {13620, -29803},  {13617, -29805},  {13614, -29806},
    {13611, -29807},  {13608, -29809},  {13606, -29810},  {13603, -29811},  {13600, -29813},  {13597, -29814},
    {13594, -29815},  {13591, -29816},  {13588, -29818},  {13586, -29819},  {13583, -29820},  {13580, -29822},
    {13577, -29823},  {13574, -29824},  {13571, -29826},  {13568, -29827},  {13566, -29828},  {13563, -29829},
    {13560, -29831},  {13557, -29832},  {13554, -29833},  {13551, -29835},  {13548, -29836},  {13546, -29837},
    {13543, -29839},  {13540, -29840},  {13537, -29841},  {13534, -29842},  {13531, -29844},  {13528, -29845},
    {13525, -29846},  {13523, -29848},  {13520, -29849},  {13517, -29850},  {13514, -29852},  {13511, -29853},
    {13508, -29854},  {13505, -29855},  {13503, -29857},  {13500, -29858},  {13497, -29859},  {13494, -29861},
    {13491, -29862},  {13488, -29863},  {13485, -29864},  {13483, -29866},  {13480, -29867},  {13477, -29868},
    {13474, -29870},  {13471, -29871},  {13468, -29872},  {13465, -29873},  {13463, -29875},  {13460, -29876},
    {13457, -29877},  {13454, -29879},  {13451, -29880},  {13448, -29881},  {13445, -29883},  {13442, -29884},
    {13440, -29885},  {13437, -29886},  {13434, -29888},  {13431, -29889},  {13428, -29890},  {13425, -29892},
    {13422, -29893},  {13420, -29894},  {13417, -29895},  {13414, -29897},  {13411, -29898},  {13408, -29899},
    {13405, -29901},  {13402, -29902},  {13399, -29903},  {13397, -29904},  {13394, -29906},  {13391, -29907},
    {13388, -29908},  {13385, -29910},  {13382, -29911},  {13379, -29912},  {13377, -29913},  {13374, -29915},
    {13371, -29916},  {13368, -29917},  {13365, -29919},  {13362, -29920},  {13359, -29921},  {13356, -29922},
    {13354, -29924},  {13351, -29925},  {13348, -29926},  {13345, -29927},  {13342, -29929},  {13339, -29930},
    {13336, -29931},  {13333, -29933},  {13331, -29934},  {13328, -29935},  {13325, -29936},  {13322, -29938},
    {13319, -29939},  {13316, -29940},  {13313, -29942},  {13311, -29943},  {13308, -29944},  {13305, -29945},
    {13302, -29947},  {13299, -29948},  {13296, -29949},  {13293, -29950},  {13290, -29952},  {13288, -29953},
    {13285, -29954},  {13282, -29956},  {13279, -29957},  {13276, -29958},  {13273, -29959},  {13270, -29961},
    {13267, -29962},  {13265, -29963},  {13262, -29964},  {13259, -29966},  {13256, -29967},  {13253, -29968},
    {13250, -29970},  {13247, -29971},  {13244, -29972},  {13242, -29973},  {13239, -29975},  {13236, -29976},
    {13233, -29977},  {13230, -29978},  {13227, -29980},  {13224, -29981},  {13221, -29982},  {13219, -29983},
    {13216, -29985},  {13213, -29986},  {13210, -29987},  {13207, -29989},  {13204, -29990},  {13201, -29991},
    {13198, -29992},  {13196, -29994},  {13193, -29995},  {13190, -29996},  {13187, -29997},  {13184, -29999},
    {13181, -30000},  {13178, -30001},  {13175, -30002},  {13173, -30004},  {13170, -30005},  {13167, -30006},
    {13164, -30008},  {13161, -30009},  {13158, -30010},  {13155, -30011},  {13152, -30013},  {13150, -30014},
    {13147, -30015},  {13144, -30016},  {13141, -30018},  {13138, -30019},  {13135, -30020},  {13132, -30021},
    {13129, -30023},  {13127, -30024},  {13124, -30025},  {13121, -30026},  {13118, -30028},  {13115, -30029},
    {13112, -30030},  {13109, -30031},  {13106, -30033},  {13104, -30034},  {13101, -30035},  {13098, -30036},
    {13095, -30038},  {13092, -30039},  {13089, -30040},  {13086, -30042},  {13083, -30043},  {13080, -30044},
    {13078, -30045},  {13075, -30047},  {13072, -30048},  {13069, -30049},  {13066, -30050},  {13063, -30052},
    {13060, -30053},  {13057, -30054},  {13055, -30055},  {13052, -30057},  {13049, -30058},  {13046, -30059},
    {13043, -30060},  {13040, -30062},  {13037, -30063},  {13034, -30064},  {13032, -30065},  {13029, -30067},
    {13026, -30068},  {13023, -30069},  {13020, -30070},  {13017, -30072},  {13014, -30073},  {13011, -30074},
    {13008, -30075},  {13006, -30077},  {13003, -30078},  {13000, -30079},  {12997, -30080},  {12994, -30082},
    {12991, -30083},  {12988, -30084},  {12985, -30085},  {12982, -30086},  {12980, -30088},  {12977, -30089},
    {12974, -30090},  {12971, -30091},  {12968, -30093},  {12965, -30094},  {12962, -30095},  {12959, -30096},
    {12957, -30098},  {12954, -30099},  {12951, -30100},  {12948, -30101},  {12945, -30103},  {12942, -30104},
    {12939, -30105},  {12936, -30106},  {12933, -30108},  {12931, -30109},  {12928, -30110},  {12925, -30111},
    {12922, -30113},  {12919, -30114},  {12916, -30115},  {12913, -30116},  {12910, -30118},  {12907, -30119},
    {12905, -30120},  {12902, -30121},  {12899, -30122},  {12896, -30124},  {12893, -30125},  {12890, -30126},
    {12887, -30127},  {12884, -30129},  {12881, -30130},  {12879, -30131},  {12876, -30132},  {12873, -30134},
    {12870, -30135},  {12867, -30136},  {12864, -30137},  {12861, -30139},  {12858, -30140},  {12855, -30141},
    {12853, -30142},  {12850, -30143},  {12847, -30145},  {12844, -30146},  {12841, -30147},  {12838, -30148},
    {12835, -30150},  {12832, -30151},  {12829, -30152},  {12827, -30153},  {12824, -30155},  {12821, -30156},
    {12818, -30157},  {12815, -30158},  {12812, -30159},  {12809, -30161},  {12806, -30162},  {12803, -30163},
    {12801, -30164},  {12798, -30166},  {12795, -30167},  {12792, -30168},  {12789, -30169},  {12786, -30170},
    {12783, -30172},  {12780, -30173},  {12777, -30174},  {12774, -30175},  {12772, -30177},  {12769, -30178},
    {12766, -30179},  {12763, -30180},  {12760, -30182},  {12757, -30183},  {12754, -30184},  {12751, -30185},
    {12748, -30186},  {12746, -30188},  {12743, -30189},  {12740, -30190},  {12737, -30191},  {12734, -30193},
    {12731, -30194},  {12728, -30195},  {12725, -30196},  {12722, -30197},  {12720, -30199},  {12717, -30200},
    {12714, -30201},  {12711, -30202},  {12708, -30203},  {12705, -30205},  {12702, -30206},  {12699, -30207},
    {12696, -30208},  {12693, -30210},  {12691, -30211},  {12688, -30212},  {12685, -30213},  {12682, -30214},
    {12679, -30216},  {12676, -30217},  {12673, -30218},  {12670, -30219},  {12667, -30221},  {12664, -30222},
    {12662, -30223},  {12659, -30224},  {12656, -30225},  {12653, -30227},  {12650, -30228},  {12647, -30229},
    {12644, -30230},  {12641, -30231},  {12638, -30233},  {12635, -30234},  {12633, -30235},  {12630, -30236},
    {12627, -30237},  {12624, -30239},  {12621, -30240},  {12618, -30241},  {12615, -30242},  {12612, -30244},
    {12609, -30245},  {12606, -30246},  {12604, -30247},  {12601, -30248},  {12598, -30250},  {12595, -30251},
    {12592, -30252},  {12589, -30253},  {12586, -30254},  {12583, -30256},  {12580, -30257},  {12577, -30258},
    {12575, -30259},  {12572, -30260},  {12569, -30262},  {12566, -30263},  {12563, -30264},  {12560, -30265},
    {12557, -30266},  {12554, -30268},  {12551, -30269},  {12548, -30270},  {12546, -30271},  {12543, -30272},
    {12540, -30274},  {12537, -30275},  {12534, -30276},  {12531, -30277},  {12528, -30278},  {12525, -30280},
    {12522, -30281},  {12519, -30282},  {12517, -30283},  {12514, -30284},  {12511, -30286},  {12508, -30287},
    {12505, -30288},  {12502, -30289},  {12499, -30290},  {12496, -30292},  {12493, -30293},  {12490, -30294},
    {12488, -30295},  {12485, -30296},  {12482, -30298},  {12479, -30299},  {12476, -30300},  {12473, -30301},
    {12470, -30302},  {12467, -30304},  {12464, -30305},  {12461, -30306},  {12458, -30307},  {12456, -30308},
    {12453, -30310},  {12450, -30311},  {12447, -30312},  {12444, -30313},  {12441, -30314},  {12438, -30316},
    {12435, -30317},  {12432, -30318},  {12429, -30319},  {12426, -30320},  {12424, -30322},  {12421, -30323},
    {12418, -30324},  {12415, -30325},  {12412, -30326},  {12409, -30328},  {12406, -30329},  {12403, -30330},
    {12400, -30331},  {12397, -30332},  {12395, -30333},  {12392, -30335},  {12389, -30336},  {12386, -30337},
    {12383, -30338},  {12380, -30339},  {12377, -30341},  {12374, -30342},  {12371, -30343},  {12368, -30344},
    {12365, -30345},  {12363, -30347},  {12360, -30348},  {12357, -30349},  {12354, -30350},  {12351, -30351},
    {12348, -30352},  {12345, -30354},  {12342, -30355},  {12339, -30356},  {12336, -30357},  {12333, -30358},
    {12330, -30360},  {12328, -30361},  {12325, -30362},  {12322, -30363},  {12319, -30364},  {12316, -30365},
    {12313, -30367},  {12310, -30368},  {12307, -30369},  {12304, -30370},  {12301, -30371},  {12298, -30373},
    {12296, -30374},  {12293, -30375},  {12290, -30376},  {12287, -30377},  {12284, -30378},  {12281, -30380},
    {12278, -30381},  {12275, -30382},  {12272, -30383},  {12269, -30384},  {12266, -30385},  {12264, -30387},
    {12261, -30388},  {12258, -30389},  {12255, -30390},  {12252, -30391},  {12249, -30393},  {12246, -30394},
    {12243, -30395},  {12240, -30396},  {12237, -30397},  {12234, -30398},  {12231, -30400},  {12229, -30401},
    {12226, -30402},  {12223, -30403},  {12220, -30404},  {12217, -30405},  {12214, -30407},  {12211, -30408},
    {12208, -30409},  {12205, -30410},  {12202, -30411},  {12199, -30412},  {12196, -30414},  {12194, -30415},
    {12191, -30416},  {12188, -30417},  {12185, -30418},  {12182, -30419},  {12179, -30421},  {12176, -30422},
    {12173, -30423},  {12170, -30424},  {12167, -30425},  {12164, -30426},  {12161, -30428},  {12159, -30429},
    {12156, -30430},  {12153, -30431},  {12150, -30432},  {12147, -30433},  {12144, -30435},  {12141, -30436},
    {12138, -30437},  {12135, -30438},  {12132, -30439},  {12129, -30440},  {12126, -30442},  {12124, -30443},
    {12121, -30444},  {12118, -30445},  {12115, -30446},  {12112, -30447},  {12109, -30449},  {12106, -30450},
    {12103, -30451},  {12100, -30452},  {12097, -30453},  {12094, -30454},  {12091, -30456},  {12089, -30457},
    {12086, -30458},  {12083, -30459},  {12080, -30460},  {12077, -30461},  {12074, -30462},  {12071, -30464},
    {12068, -30465},  {12065, -30466},  {12062, -30467},  {12059, -30468},  {12056, -30469},  {12053, -30471},
    {12051, -30472},  {12048, -30473},  {12045, -30474},  {12042, -30475},  {12039, -30476},  {12036, -30477},
    {12033, -30479},  {12030, -30480},  {12027, -30481},  {12024, -30482},  {12021, -30483},  {12018, -30484},
    {12015, -30486},  {12013, -30487},  {12010, -30488},  {12007, -30489},  {12004, -30490},  {12001, -30491},
    {11998, -30492},  {11995, -30494},  {11992, -30495},  {11989, -30496},  {11986, -30497},  {11983, -30498},
    {11980, -30499},  {11977, -30501},  {11975, -30502},  {11972, -30503},  {11969, -30504},  {11966, -30505},
    {11963, -30506},  {11960, -30507},  {11957, -30509},  {11954, -30510},  {11951, -30511},  {11948, -30512},
    {11945, -30513},  {11942, -30514},  {11939, -30515},  {11937, -30517},  {11934, -30518},  {11931, -30519},
    {11928, -30520},  {11925, -30521},  {11922, -30522},  {11919, -30523},  {11916, -30525},  {11913, -30526},
    {11910, -30527},  {11907, -30528},  {11904, -30529},  {11901, -30530},  {11898, -30531},  {11896, -30533},
    {11893, -30534},  {11890, -30535},  {11887, -30536},  {11884, -30537},  {11881, -30538},  {11878, -30539},
    {11875, -30541},  {11872, -30542},  {11869, -30543},  {11866, -30544},  {11863, -30545},  {11860, -30546},
    {11857, -30547},  {11855, -30549},  {11852, -30550},  {11849, -30551},  {11846, -30552},  {11843, -30553},
    {11840, -30554},  {11837, -30555},  {11834, -30556},  {11831, -30558},  {11828, -30559},  {11825, -30560},
    {11822, -30561},  {11819, -30562},  {11816, -30563},  {11814, -30564},  {11811, -30566},  {11808, -30567},
    {11805, -30568},  {11802, -30569},  {11799, -30570},  {11796, -30571},  {11793, -30572},  {11790, -30573},
    {11787, -30575},  {11784, -30576},  {11781, -30577},  {11778, -30578},  {11775, -30579},  {11773, -30580},
    {11770, -30581},  {11767, -30582},  {11764, -30584},  {11761, -30585},  {11758, -30586},  {11755, -30587},
    {11752, -30588},  {11749, -30589},  {11746, -30590},  {11743, -30591},  {11740, -30593},  {11737, -30594},
    {11734, -30595},  {11731, -30596},  {11729, -30597},  {11726, -30598},  {11723, -30599},  {11720, -30600},
    {11717, -30602},  {11714, -30603},  {11711, -30604},  {11708, -30605},  {11705, -30606},  {11702, -30607},
    {11699, -30608},  {11696, -30609},  {11693, -30611},  {11690, -30612},  {11687, -30613},  {11685, -30614},
    {11682, -30615},  {11679, -30616},  {11676, -30617},  {11673, -30618},  {11670, -30620},  {11667, -30621},
    {11664, -30622},  {11661, -30623},  {11658, -30624},  {11655, -30625},  {11652, -30626},  {11649, -30627},
    {11646, -30628},  {11643, -30630},  {11640, -30631},  {11638, -30632},  {11635, -30633},  {11632, -30634},
    {11629, -30635},  {11626, -30636},  {11623, -30637},  {11620, -30639},  {11617, -30640},  {11614, -30641},
    {11611, -30642},  {11608, -30643},  {11605, -30644},  {11602, -30645},  {11599, -30646},  {11596, -30647},
    {11593, -30649},  {11591, -30650},  {11588, -30651},  {11585, -30652},  {11582, -30653},  {11579, -30654},
    {11576, -30655},  {11573, -30656},  {11570, -30657},  {11567, -30659},  {11564, -30660},  {11561, -30661},
    {11558, -30662},  {11555, -30663},  {11552, -30664},  {11549, -30665},  {11546, -30666},  {11544, -30667},
    {11541, -30669},  {11538, -30670},  {11535, -30671},  {11532, -30672},  {11529, -30673},  {11526, -30674},
    {11523, -30675},  {11520, -30676},  {11517, -30677},  {11514, -30678},  {11511, -30680},  {11508, -30681},
    {11505, -30682},  {11502, -30683},  {11499, -30684},  {11496, -30685},  {11494, -30686},  {11491, -30687},
    {11488, -30688},  {11485, -30689},  {11482, -30691},  {11479, -30692},  {11476, -30693},  {11473, -30694},
    {11470, -30695},  {11467, -30696},  {11464, -30697},  {11461, -30698},  {11458, -30699},  {11455, -30700},
    {11452, -30702},  {11449, -30703},  {11446, -30704},  {11443, -30705},  {11441, -30706},  {11438, -30707},
    {11435, -30708},  {11432, -30709},  {11429, -30710},  {11426, -30711},  {11423, -30713},  {11420, -30714},
    {11417, -30715},  {11414, -30716},  {11411, -30717},  {11408, -30718},  {11405, -30719},  {11402, -30720},
    {11399, -30721},  {11396, -30722},  {11393, -30723},  {11390, -30725},  {11388, -30726},  {11385, -30727},
    {11382, -30728},  {11379, -30729},  {11376, -30730},  {11373, -30731},  {11370, -30732},  {11367, -30733},
    {11364, -30734},  {11361, -30735},  {11358, -30737},  {11355, -30738},  {11352, -30739},  {11349, -30740},
    {11346, -30741},  {11343, -30742},  {11340, -30743},  {11337, -30744},  {11334, -30745},  {11332, -30746},
    {11329, -30747},  {11326, -30749},  {11323, -30750},  {11320, -30751},  {11317, -30752},  {11314, -30753},
    {11311, -30754},  {11308, -30755},  {11305, -30756},  {11302, -30757},  {11299, -30758},  {11296, -30759},
    {11293, -30760},  {11290, -30762},  {11287, -30763},  {11284, -30764},  {11281, -30765},  {11278, -30766},
    {11276, -30767},  {11273, -30768},  {11270, -30769},  {11267, -30770},  {11264, -30771},  {11261, -30772},
    {11258, -30773},  {11255, -30774},  {11252, -30776},  {11249, -30777},  {11246, -30778},  {11243, -30779},
    {11240, -30780},  {11237, -30781},  {11234, -30782},  {11231, -30783},  {11228, -30784},  {11225, -30785},
    {11222, -30786},  {11219, -30787},  {11216, -30789},  {11214, -30790},  {11211, -30791},  {11208, -30792},
    {11205, -30793},  {11202, -30794},  {11199, -30795},  {11196, -30796},  {11193, -30797},  {11190, -30798},
    {11187, -30799},  {11184, -30800},  {11181, -30801},  {11178, -30802},  {11175, -30804},  {11172, -30805},
    {11169, -30806},  {11166, -30807},  {11163, -30808},  {11160, -30809},  {11157, -30810},  {11154, -30811},
    {11152, -30812},  {11149, -30813},  {11146, -30814},  {11143, -30815},  {11140, -30816},  {11137, -30817},
    {11134, -30819},  {11131, -30820},  {11128, -30821},  {11125, -30822},  {11122, -30823},  {11119, -30824},
    {11116, -30825},  {11113, -30826},  {11110, -30827},  {11107, -30828},  {11104, -30829},  {11101, -30830},
    {11098, -30831},  {11095, -30832},  {11092, -30833},  {11089, -30834},  {11087, -30836},  {11084, -30837},
    {11081, -30838},  {11078, -30839},  {11075, -30840},  {11072, -30841},  {11069, -30842},  {11066, -30843},
    {11063, -30844},  {11060, -30845},  {11057, -30846},  {11054, -30847},  {11051, -30848},  {11048, -30849},
    {11045, -30850},  {11042, -30851},  {11039, -30853},  {11036, -30854},  {11033, -30855},  {11030, -30856},
    {11027, -30857},  {11024, -30858},  {11021, -30859},  {11018, -30860},  {11016, -30861},  {11013, -30862},
    {11010, -30863},  {11007, -30864},  {11004, -30865},  {11001, -30866},  {10998, -30867},  {10995, -30868},
    {10992, -30869},  {10989, -30870},  {10986, -30872},  {10983, -30873},  {10980, -30874},  {10977, -30875},
    {10974, -30876},  {10971, -30877},  {10968, -30878},  {10965, -30879},  {10962, -30880},  {10959, -30881},
    {10956, -30882},  {10953, -30883},  {10950, -30884},  {10947, -30885},  {10945, -30886},  {10942, -30887},
    {10939, -30888},  {10936, -30889},  {10933, -30890},  {10930, -30891},  {10927, -30893},  {10924, -30894},
    {10921, -30895},  {10918, -30896},  {10915, -30897},  {10912, -30898},  {10909, -30899},  {10906, -30900},
    {10903, -30901},  {10900, -30902},  {10897, -30903},  {10894, -30904},  {10891, -30905},  {10888, -30906},
    {10885, -30907},  {10882, -30908},  {10879, -30909},  {10876, -30910},  {10873, -30911},  {10870, -30912},
    {10867, -30913},  {10865, -30914},  {10862, -30916},  {10859, -30917},  {10856, -30918},  {10853, -30919},
    {10850, -30920},  {10847, -30921},  {10844, -30922},  {10841, -30923},  {10838, -30924},  {10835, -30925},
    {10832, -30926},  {10829, -30927},  {10826, -30928},  {10823, -30929},  {10820, -30930},  {10817, -30931},
    {10814, -30932},  {10811, -30933},  {10808, -30934},  {10805, -30935},  {10802, -30936},  {10799, -30937},
    {10796, -30938},  {10793, -30939},  {10790, -30940},  {10787, -30941},  {10784, -30942},  {10781, -30944},
    {10779, -30945},  {10776, -30946},  {10773, -30947},  {10770, -30948},  {10767, -30949},  {10764, -30950},
    {10761, -30951},  {10758, -30952},  {10755, -30953},  {10752, -30954},  {10749, -30955},  {10746, -30956},
    {10743, -30957},  {10740, -30958},  {10737, -30959},  {10734, -30960},  {10731, -30961},  {10728, -30962},
    {10725, -30963},  {10722, -30964},  {10719, -30965},  {10716, -30966},  {10713, -30967},  {10710, -30968},
    {10707, -30969},  {10704, -30970},  {10701, -30971},  {10698, -30972},  {10695, -30973},  {10692, -30974},
    {10689, -30975},  {10687, -30976},  {10684, -30977},  {10681, -30978},  {10678, -30980},  {10675, -30981},
    {10672, -30982},  {10669, -30983},  {10666, -30984},  {10663, -30985},  {10660, -30986},  {10657, -30987},
    {10654, -30988},  {10651, -30989},  {10648, -30990},  {10645, -30991},  {10642, -30992},  {10639, -30993},
    {10636, -30994},  {10633, -30995},  {10630, -30996},  {10627, -30997},  {10624, -30998},  {10621, -30999},
    {10618, -31000},  {10615, -31001},  {10612, -31002},  {10609, -31003},  {10606, -31004},  {10603, -31005},
    {10600, -31006},  {10597, -31007},  {10594, -31008},  {10591, -31009},  {10588, -31010},  {10585, -31011},
    {10582, -31012},  {10580, -31013},  {10577, -31014},  {10574, -31015},  {10571, -31016},  {10568, -31017},
    {10565, -31018},  {10562, -31019},  {10559, -31020},  {10556, -31021},  {10553, -31022},  {10550, -31023},
    {10547, -31024},  {10544, -31025},  {10541, -31026},  {10538, -31027},  {10535, -31028},  {10532, -31029},
    {10529, -31030},  {10526, -31031},  {10523, -31032},  {10520, -31033},  {10517, -31034},  {10514, -31035},
    {10511, -31036},  {10508, -31037},  {10505, -31038},  {10502, -31039},  {10499, -31040},  {10496, -31041},
    {10493, -31042},  {10490, -31043},  {10487, -31044},  {10484, -31045},  {10481, -31046},  {10478, -31047},
    {10475, -31048},  {10472, -31049},  {10469, -31050},  {10466, -31051},  {10463, -31052},  {10461, -31053},
    {10458, -31054},  {10455, -31055},  {10452, -31057},  {10449, -31058},  {10446, -31059},  {10443, -31060},
    {10440, -31061},  {10437, -31062},  {10434, -31063},  {10431, -31064},  {10428, -31065},  {10425, -31066},
    {10422, -31067},  {10419, -31068},  {10416, -31069},  {10413, -31070},  {10410, -31071},  {10407, -31072},
    {10404, -31072},  {10401, -31073},  {10398, -31074},  {10395, -31075},  {10392, -31076},  {10389, -31077},
    {10386, -31078},  {10383, -31079},  {10380, -31080},  {10377, -31081},  {10374, -31082},  {10371, -31083},
    {10368, -31084},  {10365, -31085},  {10362, -31086},  {10359, -31087},  {10356, -31088},  {10353, -31089},
    {10350, -31090},  {10347, -31091},  {10344, -31092},  {10341, -31093},  {10338, -31094},  {10335, -31095},
    {10332, -31096},  {10329, -31097},  {10326, -31098},  {10323, -31099},  {10320, -31100},  {10317, -31101},
    {10315, -31102},  {10312, -31103},  {10309, -31104},  {10306, -31105},  {10303, -31106},  {10300, -31107},
    {10297, -31108},  {10294, -31109},  {10291, -31110},  {10288, -31111},  {10285, -31112},  {10282, -31113},
    {10279, -31114},  {10276, -31115},  {10273, -31116},  {10270, -31117},  {10267, -31118},  {10264, -31119},
    {10261, -31120},  {10258, -31121},  {10255, -31122},  {10252, -31123},  {10249, -31124},  {10246, -31125},
    {10243, -31126},  {10240, -31127},  {10237, -31128},  {10234, -31129},  {10231, -31130},  {10228, -31131},
    {10225, -31132},  {10222, -31133},  {10219, -31134},  {10216, -31135},  {10213, -31136},  {10210, -31137},
    {10207, -31138},  {10204, -31139},  {10201, -31140},  {10198, -31141},  {10195, -31142},  {10192, -31143},
    {10189, -31144},  {10186, -31145},  {10183, -31146},  {10180, -31147},  {10177, -31147},  {10174, -31148},
    {10171, -31149},  {10168, -31150},  {10165, -31151},  {10162, -31152},  {10159, -31153},  {10156, -31154},
    {10153, -31155},  {10150, -31156},  {10147, -31157},  {10144, -31158},  {10141, -31159},  {10138, -31160},
    {10135, -31161},  {10132, -31162},  {10129, -31163},  {10126, -31164},  {10123, -31165},  {10120, -31166},
    {10118, -31167},  {10115, -31168},  {10112, -31169},  {10109, -31170},  {10106, -31171},  {10103, -31172},
    {10100, -31173},  {10097, -31174},  {10094, -31175},  {10091, -31176},  {10088, -31177},  {10085, -31178},
    {10082, -31179},  {10079, -31180},  {10076, -31180},  {10073, -31181},  {10070, -31182},  {10067, -31183},
    {10064, -31184},  {10061, -31185},  {10058, -31186},  {10055, -31187},  {10052, -31188},  {10049, -31189},
    {10046, -31190},  {10043, -31191},  {10040, -31192},  {10037, -31193},  {10034, -31194},  {10031, -31195},
    {10028, -31196},  {10025, -31197},  {10022, -31198},  {10019, -31199},  {10016, -31200},  {10013, -31201},
    {10010, -31202},  {10007, -31203},  {10004, -31204},  {10001, -31205},  {9998, -31206},   {9995, -31206},
    {9992, -31207},   {9989, -31208},   {9986, -31209},   {9983, -31210},   {9980, -31211},   {9977, -31212},
    {9974, -31213},   {9971, -31214},   {9968, -31215},   {9965, -31216},   {9962, -31217},   {9959, -31218},
    {9956, -31219},   {9953, -31220},   {9950, -31221},   {9947, -31222},   {9944, -31223},   {9941, -31224},
    {9938, -31225},   {9935, -31226},   {9932, -31227},   {9929, -31227},   {9926, -31228},   {9923, -31229},
    {9920, -31230},   {9917, -31231},   {9914, -31232},   {9911, -31233},   {9908, -31234},   {9905, -31235},
    {9902, -31236},   {9899, -31237},   {9896, -31238},   {9893, -31239},   {9890, -31240},   {9887, -31241},
    {9884, -31242},   {9881, -31243},   {9878, -31244},   {9875, -31245},   {9872, -31246},   {9869, -31246},
    {9866, -31247},   {9863, -31248},   {9860, -31249},   {9857, -31250},   {9854, -31251},   {9851, -31252},
    {9848, -31253},   {9845, -31254},   {9842, -31255},   {9839, -31256},   {9836, -31257},   {9833, -31258},
    {9830, -31259},   {9827, -31260},   {9824, -31261},   {9821, -31262},   {9818, -31263},   {9815, -31263},
    {9812, -31264},   {9809, -31265},   {9806, -31266},   {9803, -31267},   {9800, -31268},   {9797, -31269},
    {9794, -31270},   {9791, -31271},   {9788, -31272},   {9785, -31273},   {9782, -31274},   {9779, -31275},
    {9776, -31276},   {9773, -31277},   {9770, -31278},   {9767, -31278},   {9764, -31279},   {9761, -31280},
    {9758, -31281},   {9755, -31282},   {9752, -31283},   {9749, -31284},   {9746, -31285},   {9743, -31286},
    {9740, -31287},   {9737, -31288},   {9734, -31289},   {9731, -31290},   {9728, -31291},   {9725, -31292},
    {9722, -31292},   {9719, -31293},   {9716, -31294},   {9713, -31295},   {9710, -31296},   {9707, -31297},
    {9704, -31298},   {9701, -31299},   {9698, -31300},   {9695, -31301},   {9692, -31302},   {9689, -31303},
    {9686, -31304},   {9683, -31305},   {9680, -31305},   {9677, -31306},   {9674, -31307},   {9671, -31308},
    {9668, -31309},   {9665, -31310},   {9662, -31311},   {9659, -31312},   {9656, -31313},   {9653, -31314},
    {9650, -31315},   {9647, -31316},   {9644, -31317},   {9641, -31318},   {9638, -31318},   {9635, -31319},
    {9632, -31320},   {9629, -31321},   {9626, -31322},   {9623, -31323},   {9620, -31324},   {9617, -31325},
    {9614, -31326},   {9611, -31327},   {9608, -31328},   {9605, -31329},   {9602, -31330},   {9599, -31330},
    {9596, -31331},   {9593, -31332},   {9590, -31333},   {9587, -31334},   {9584, -31335},   {9581, -31336},
    {9578, -31337},   {9575, -31338},   {9572, -31339},   {9569, -31340},   {9566, -31341},   {9563, -31341},
    {9560, -31342},   {9557, -31343},   {9554, -31344},   {9551, -31345},   {9548, -31346},   {9545, -31347},
    {9542, -31348},   {9539, -31349},   {9536, -31350},   {9533, -31351},   {9530, -31352},   {9527, -31352},
    {9524, -31353},   {9521, -31354},   {9518, -31355},   {9515, -31356},   {9512, -31357},   {9509, -31358},
    {9506, -31359},   {9503, -31360},   {9500, -31361},   {9497, -31362},   {9494, -31362},   {9491, -31363},
    {9488, -31364},   {9485, -31365},   {9482, -31366},   {9479, -31367},   {9476, -31368},   {9473, -31369},
    {9470, -31370},   {9467, -31371},   {9464, -31372},   {9461, -31372},   {9458, -31373},   {9455, -31374},
    {9452, -31375},   {9449, -31376},   {9446, -31377},   {9443, -31378},   {9440, -31379},   {9437, -31380},
    {9434, -31381},   {9431, -31382},   {9428, -31382},   {9425, -31383},   {9422, -31384},   {9419, -31385},
    {9416, -31386},   {9413, -31387},   {9410, -31388},   {9407, -31389},   {9404, -31390},   {9401, -31391},
    {9398, -31391},   {9395, -31392},   {9392, -31393},   {9389, -31394},   {9386, -31395},   {9383, -31396},
    {9380, -31397},   {9377, -31398},   {9374, -31399},   {9371, -31400},   {9368, -31400},   {9365, -31401},
    {9362, -31402},   {9359, -31403},   {9356, -31404},   {9353, -31405},   {9350, -31406},   {9347, -31407},
    {9344, -31408},   {9341, -31409},   {9338, -31409},   {9335, -31410},   {9332, -31411},   {9329, -31412},
    {9325, -31413},   {9322, -31414},   {9319, -31415},   {9316, -31416},   {9313, -31417},   {9310, -31417},
    {9307, -31418},   {9304, -31419},   {9301, -31420},   {9298, -31421},   {9295, -31422},   {9292, -31423},
    {9289, -31424},   {9286, -31425},   {9283, -31425},   {9280, -31426},   {9277, -31427},   {9274, -31428},
    {9271, -31429},   {9268, -31430},   {9265, -31431},   {9262, -31432},   {9259, -31433},   {9256, -31433},
    {9253, -31434},   {9250, -31435},   {9247, -31436},   {9244, -31437},   {9241, -31438},   {9238, -31439},
    {9235, -31440},   {9232, -31441},   {9229, -31441},   {9226, -31442},   {9223, -31443},   {9220, -31444},
    {9217, -31445},   {9214, -31446},   {9211, -31447},   {9208, -31448},   {9205, -31449},   {9202, -31449},
    {9199, -31450},   {9196, -31451},   {9193, -31452},   {9190, -31453},   {9187, -31454},   {9184, -31455},
    {9181, -31456},   {9178, -31456},   {9175, -31457},   {9172, -31458},   {9169, -31459},   {9166, -31460},
    {9163, -31461},   {9160, -31462},   {9157, -31463},   {9154, -31464},   {9151, -31464},   {9148, -31465},
    {9145, -31466},   {9142, -31467},   {9139, -31468},   {9136, -31469},   {9133, -31470},   {9130, -31471},
    {9127, -31471},   {9124, -31472},   {9120, -31473},   {9117, -31474},   {9114, -31475},   {9111, -31476},
    {9108, -31477},   {9105, -31478},   {9102, -31478},   {9099, -31479},   {9096, -31480},   {9093, -31481},
    {9090, -31482},   {9087, -31483},   {9084, -31484},   {9081, -31484},   {9078, -31485},   {9075, -31486},
    {9072, -31487},   {9069, -31488},   {9066, -31489},   {9063, -31490},   {9060, -31491},   {9057, -31491},
    {9054, -31492},   {9051, -31493},   {9048, -31494},   {9045, -31495},   {9042, -31496},   {9039, -31497},
    {9036, -31498},   {9033, -31498},   {9030, -31499},   {9027, -31500},   {9024, -31501},   {9021, -31502},
    {9018, -31503},   {9015, -31504},   {9012, -31504},   {9009, -31505},   {9006, -31506},   {9003, -31507},
    {9000, -31508},   {8997, -31509},   {8994, -31510},   {8991, -31510},   {8988, -31511},   {8985, -31512},
    {8982, -31513},   {8979, -31514},   {8976, -31515},   {8973, -31516},   {8970, -31516},   {8967, -31517},
    {8963, -31518},   {8960, -31519},   {8957, -31520},   {8954, -31521},   {8951, -31522},   {8948, -31523},
    {8945, -31523},   {8942, -31524},   {8939, -31525},   {8936, -31526},   {8933, -31527},   {8930, -31528},
    {8927, -31529},   {8924, -31529},   {8921, -31530},   {8918, -31531},   {8915, -31532},   {8912, -31533},
    {8909, -31534},   {8906, -31534},   {8903, -31535},   {8900, -31536},   {8897, -31537},   {8894, -31538},
    {8891, -31539},   {8888, -31540},   {8885, -31540},   {8882, -31541},   {8879, -31542},   {8876, -31543},
    {8873, -31544},   {8870, -31545},   {8867, -31546},   {8864, -31546},   {8861, -31547},   {8858, -31548},
    {8855, -31549},   {8852, -31550},   {8849, -31551},   {8846, -31552},   {8843, -31552},   {8840, -31553},
    {8836, -31554},   {8833, -31555},   {8830, -31556},   {8827, -31557},   {8824, -31557},   {8821, -31558},
    {8818, -31559},   {8815, -31560},   {8812, -31561},   {8809, -31562},   {8806, -31563},   {8803, -31563},
    {8800, -31564},   {8797, -31565},   {8794, -31566},   {8791, -31567},   {8788, -31568},   {8785, -31568},
    {8782, -31569},   {8779, -31570},   {8776, -31571},   {8773, -31572},   {8770, -31573},   {8767, -31573},
    {8764, -31574},   {8761, -31575},   {8758, -31576},   {8755, -31577},   {8752, -31578},   {8749, -31578},
    {8746, -31579},   {8743, -31580},   {8740, -31581},   {8737, -31582},   {8734, -31583},   {8731, -31584},
    {8728, -31584},   {8725, -31585},   {8721, -31586},   {8718, -31587},   {8715, -31588},   {8712, -31589},
    {8709, -31589},   {8706, -31590},   {8703, -31591},   {8700, -31592},   {8697, -31593},   {8694, -31594},
    {8691, -31594},   {8688, -31595},   {8685, -31596},   {8682, -31597},   {8679, -31598},   {8676, -31599},
    {8673, -31599},   {8670, -31600},   {8667, -31601},   {8664, -31602},   {8661, -31603},   {8658, -31604},
    {8655, -31604},   {8652, -31605},   {8649, -31606},   {8646, -31607},   {8643, -31608},   {8640, -31609},
    {8637, -31609},   {8634, -31610},   {8631, -31611},   {8628, -31612},   {8625, -31613},   {8621, -31613},
    {8618, -31614},   {8615, -31615},   {8612, -31616},   {8609, -31617},   {8606, -31618},   {8603, -31618},
    {8600, -31619},   {8597, -31620},   {8594, -31621},   {8591, -31622},   {8588, -31623},   {8585, -31623},
    {8582, -31624},   {8579, -31625},   {8576, -31626},   {8573, -31627},   {8570, -31627},   {8567, -31628},
    {8564, -31629},   {8561, -31630},   {8558, -31631},   {8555, -31632},   {8552, -31632},   {8549, -31633},
    {8546, -31634},   {8543, -31635},   {8540, -31636},   {8537, -31637},   {8534, -31637},   {8531, -31638},
    {8528, -31639},   {8524, -31640},   {8521, -31641},   {8518, -31641},   {8515, -31642},   {8512, -31643},
    {8509, -31644},   {8506, -31645},   {8503, -31645},   {8500, -31646},   {8497, -31647},   {8494, -31648},
    {8491, -31649},   {8488, -31650},   {8485, -31650},   {8482, -31651},   {8479, -31652},   {8476, -31653},
    {8473, -31654},   {8470, -31654},   {8467, -31655},   {8464, -31656},   {8461, -31657},   {8458, -31658},
    {8455, -31658},   {8452, -31659},   {8449, -31660},   {8446, -31661},   {8443, -31662},   {8440, -31663},
    {8436, -31663},   {8433, -31664},   {8430, -31665},   {8427, -31666},   {8424, -31667},   {8421, -31667},
    {8418, -31668},   {8415, -31669},   {8412, -31670},   {8409, -31671},   {8406, -31671},   {8403, -31672},
    {8400, -31673},   {8397, -31674},   {8394, -31675},   {8391, -31675},   {8388, -31676},   {8385, -31677},
    {8382, -31678},   {8379, -31679},   {8376, -31679},   {8373, -31680},   {8370, -31681},   {8367, -31682},
    {8364, -31683},   {8361, -31683},   {8358, -31684},   {8354, -31685},   {8351, -31686},   {8348, -31687},
    {8345, -31687},   {8342, -31688},   {8339, -31689},   {8336, -31690},   {8333, -31691},   {8330, -31691},
    {8327, -31692},   {8324, -31693},   {8321, -31694},   {8318, -31695},   {8315, -31695},   {8312, -31696},
    {8309, -31697},   {8306, -31698},   {8303, -31699},   {8300, -31699},   {8297, -31700},   {8294, -31701},
    {8291, -31702},   {8288, -31703},   {8285, -31703},   {8282, -31704},   {8279, -31705},   {8275, -31706},
    {8272, -31707},   {8269, -31707},   {8266, -31708},   {8263, -31709},   {8260, -31710},   {8257, -31711},
    {8254, -31711},   {8251, -31712},   {8248, -31713},   {8245, -31714},   {8242, -31715},   {8239, -31715},
    {8236, -31716},   {8233, -31717},   {8230, -31718},   {8227, -31718},   {8224, -31719},   {8221, -31720},
    {8218, -31721},   {8215, -31722},   {8212, -31722},   {8209, -31723},   {8206, -31724},   {8202, -31725},
    {8199, -31726},   {8196, -31726},   {8193, -31727},   {8190, -31728},   {8187, -31729},   {8184, -31729},
    {8181, -31730},   {8178, -31731},   {8175, -31732},   {8172, -31733},   {8169, -31733},   {8166, -31734},
    {8163, -31735},   {8160, -31736},   {8157, -31737},   {8154, -31737},   {8151, -31738},   {8148, -31739},
    {8145, -31740},   {8142, -31740},   {8139, -31741},   {8136, -31742},   {8133, -31743},   {8129, -31744},
    {8126, -31744},   {8123, -31745},   {8120, -31746},   {8117, -31747},   {8114, -31747},   {8111, -31748},
    {8108, -31749},   {8105, -31750},   {8102, -31751},   {8099, -31751},   {8096, -31752},   {8093, -31753},
    {8090, -31754},   {8087, -31754},   {8084, -31755},   {8081, -31756},   {8078, -31757},   {8075, -31758},
    {8072, -31758},   {8069, -31759},   {8066, -31760},   {8063, -31761},   {8059, -31761},   {8056, -31762},
    {8053, -31763},   {8050, -31764},   {8047, -31764},   {8044, -31765},   {8041, -31766},   {8038, -31767},
    {8035, -31768},   {8032, -31768},   {8029, -31769},   {8026, -31770},   {8023, -31771},   {8020, -31771},
    {8017, -31772},   {8014, -31773},   {8011, -31774},   {8008, -31775},   {8005, -31775},   {8002, -31776},
    {7999, -31777},   {7995, -31778},   {7992, -31778},   {7989, -31779},   {7986, -31780},   {7983, -31781},
    {7980, -31781},   {7977, -31782},   {7974, -31783},   {7971, -31784},   {7968, -31784},   {7965, -31785},
    {7962, -31786},   {7959, -31787},   {7956, -31788},   {7953, -31788},   {7950, -31789},   {7947, -31790},
    {7944, -31791},   {7941, -31791},   {7938, -31792},   {7935, -31793},   {7931, -31794},   {7928, -31794},
    {7925, -31795},   {7922, -31796},   {7919, -31797},   {7916, -31797},   {7913, -31798},   {7910, -31799},
    {7907, -31800},   {7904, -31800},   {7901, -31801},   {7898, -31802},   {7895, -31803},   {7892, -31803},
    {7889, -31804},   {7886, -31805},   {7883, -31806},   {7880, -31806},   {7877, -31807},   {7874, -31808},
    {7871, -31809},   {7867, -31810},   {7864, -31810},   {7861, -31811},   {7858, -31812},   {7855, -31813},
    {7852, -31813},   {7849, -31814},   {7846, -31815},   {7843, -31816},   {7840, -31816},   {7837, -31817},
    {7834, -31818},   {7831, -31819},   {7828, -31819},   {7825, -31820},   {7822, -31821},   {7819, -31822},
    {7816, -31822},   {7813, -31823},   {7810, -31824},   {7806, -31825},   {7803, -31825},   {7800, -31826},
    {7797, -31827},   {7794, -31828},   {7791, -31828},   {7788, -31829},   {7785, -31830},   {7782, -31831},
    {7779, -31831},   {7776, -31832},   {7773, -31833},   {7770, -31833},   {7767, -31834},   {7764, -31835},
    {7761, -31836},   {7758, -31836},   {7755, -31837},   {7752, -31838},   {7748, -31839},   {7745, -31839},
    {7742, -31840},   {7739, -31841},   {7736, -31842},   {7733, -31842},   {7730, -31843},   {7727, -31844},
    {7724, -31845},   {7721, -31845},   {7718, -31846},   {7715, -31847},   {7712, -31848},   {7709, -31848},
    {7706, -31849},   {7703, -31850},   {7700, -31851},   {7697, -31851},   {7694, -31852},   {7690, -31853},
    {7687, -31854},   {7684, -31854},   {7681, -31855},   {7678, -31856},   {7675, -31856},   {7672, -31857},
    {7669, -31858},   {7666, -31859},   {7663, -31859},   {7660, -31860},   {7657, -31861},   {7654, -31862},
    {7651, -31862},   {7648, -31863},   {7645, -31864},   {7642, -31865},   {7639, -31865},   {7635, -31866},
    {7632, -31867},   {7629, -31867},   {7626, -31868},   {7623, -31869},   {7620, -31870},   {7617, -31870},
    {7614, -31871},   {7611, -31872},   {7608, -31873},   {7605, -31873},   {7602, -31874},   {7599, -31875},
    {7596, -31875},   {7593, -31876},   {7590, -31877},   {7587, -31878},   {7584, -31878},   {7580, -31879},
    {7577, -31880},   {7574, -31881},   {7571, -31881},   {7568, -31882},   {7565, -31883},   {7562, -31883},
    {7559, -31884},   {7556, -31885},   {7553, -31886},   {7550, -31886},   {7547, -31887},   {7544, -31888},
    {7541, -31889},   {7538, -31889},   {7535, -31890},   {7532, -31891},   {7529, -31891},   {7525, -31892},
    {7522, -31893},   {7519, -31894},   {7516, -31894},   {7513, -31895},   {7510, -31896},   {7507, -31896},
    {7504, -31897},   {7501, -31898},   {7498, -31899},   {7495, -31899},   {7492, -31900},   {7489, -31901},
    {7486, -31902},   {7483, -31902},   {7480, -31903},   {7477, -31904},   {7473, -31904},   {7470, -31905},
    {7467, -31906},   {7464, -31907},   {7461, -31907},   {7458, -31908},   {7455, -31909},   {7452, -31909},
    {7449, -31910},   {7446, -31911},   {7443, -31912},   {7440, -31912},   {7437, -31913},   {7434, -31914},
    {7431, -31914},   {7428, -31915},   {7425, -31916},   {7421, -31917},   {7418, -31917},   {7415, -31918},
    {7412, -31919},   {7409, -31919},   {7406, -31920},   {7403, -31921},   {7400, -31921},   {7397, -31922},
    {7394, -31923},   {7391, -31924},   {7388, -31924},   {7385, -31925},   {7382, -31926},   {7379, -31926},
    {7376, -31927},   {7372, -31928},   {7369, -31929},   {7366, -31929},   {7363, -31930},   {7360, -31931},
    {7357, -31931},   {7354, -31932},   {7351, -31933},   {7348, -31934},   {7345, -31934},   {7342, -31935},
    {7339, -31936},   {7336, -31936},   {7333, -31937},   {7330, -31938},   {7327, -31938},   {7324, -31939},
    {7320, -31940},   {7317, -31941},   {7314, -31941},   {7311, -31942},   {7308, -31943},   {7305, -31943},
    {7302, -31944},   {7299, -31945},   {7296, -31945},   {7293, -31946},   {7290, -31947},   {7287, -31948},
    {7284, -31948},   {7281, -31949},   {7278, -31950},   {7275, -31950},   {7271, -31951},   {7268, -31952},
    {7265, -31952},   {7262, -31953},   {7259, -31954},   {7256, -31955},   {7253, -31955},   {7250, -31956},
    {7247, -31957},   {7244, -31957},   {7241, -31958},   {7238, -31959},   {7235, -31959},   {7232, -31960},
    {7229, -31961},   {7225, -31961},   {7222, -31962},   {7219, -31963},   {7216, -31964},   {7213, -31964},
    {7210, -31965},   {7207, -31966},   {7204, -31966},   {7201, -31967},   {7198, -31968},   {7195, -31968},
    {7192, -31969},   {7189, -31970},   {7186, -31970},   {7183, -31971},   {7180, -31972},   {7176, -31972},
    {7173, -31973},   {7170, -31974},   {7167, -31975},   {7164, -31975},   {7161, -31976},   {7158, -31977},
    {7155, -31977},   {7152, -31978},   {7149, -31979},   {7146, -31979},   {7143, -31980},   {7140, -31981},
    {7137, -31981},   {7134, -31982},   {7130, -31983},   {7127, -31983},   {7124, -31984},   {7121, -31985},
    {7118, -31986},   {7115, -31986},   {7112, -31987},   {7109, -31988},   {7106, -31988},   {7103, -31989},
    {7100, -31990},   {7097, -31990},   {7094, -31991},   {7091, -31992},   {7088, -31992},   {7084, -31993},
    {7081, -31994},   {7078, -31994},   {7075, -31995},   {7072, -31996},   {7069, -31996},   {7066, -31997},
    {7063, -31998},   {7060, -31998},   {7057, -31999},   {7054, -32000},   {7051, -32000},   {7048, -32001},
    {7045, -32002},   {7042, -32002},   {7038, -32003},   {7035, -32004},   {7032, -32005},   {7029, -32005},
    {7026, -32006},   {7023, -32007},   {7020, -32007},   {7017, -32008},   {7014, -32009},   {7011, -32009},
    {7008, -32010},   {7005, -32011},   {7002, -32011},   {6999, -32012},   {6995, -32013},   {6992, -32013},
    {6989, -32014},   {6986, -32015},   {6983, -32015},   {6980, -32016},   {6977, -32017},   {6974, -32017},
    {6971, -32018},   {6968, -32019},   {6965, -32019},   {6962, -32020},   {6959, -32021},   {6956, -32021},
    {6953, -32022},   {6949, -32023},   {6946, -32023},   {6943, -32024},   {6940, -32025},   {6937, -32025},
    {6934, -32026},   {6931, -32027},   {6928, -32027},   {6925, -32028},   {6922, -32029},   {6919, -32029},
    {6916, -32030},   {6913, -32031},   {6910, -32031},   {6906, -32032},   {6903, -32033},   {6900, -32033},
    {6897, -32034},   {6894, -32035},   {6891, -32035},   {6888, -32036},   {6885, -32037},   {6882, -32037},
    {6879, -32038},   {6876, -32039},   {6873, -32039},   {6870, -32040},   {6867, -32040},   {6863, -32041},
    {6860, -32042},   {6857, -32042},   {6854, -32043},   {6851, -32044},   {6848, -32044},   {6845, -32045},
    {6842, -32046},   {6839, -32046},   {6836, -32047},   {6833, -32048},   {6830, -32048},   {6827, -32049},
    {6824, -32050},   {6820, -32050},   {6817, -32051},   {6814, -32052},   {6811, -32052},   {6808, -32053},
    {6805, -32054},   {6802, -32054},   {6799, -32055},   {6796, -32056},   {6793, -32056},   {6790, -32057},
    {6787, -32058},   {6784, -32058},   {6780, -32059},   {6777, -32059},   {6774, -32060},   {6771, -32061},
    {6768, -32061},   {6765, -32062},   {6762, -32063},   {6759, -32063},   {6756, -32064},   {6753, -32065},
    {6750, -32065},   {6747, -32066},   {6744, -32067},   {6741, -32067},   {6737, -32068},   {6734, -32069},
    {6731, -32069},   {6728, -32070},   {6725, -32070},   {6722, -32071},   {6719, -32072},   {6716, -32072},
    {6713, -32073},   {6710, -32074},   {6707, -32074},   {6704, -32075},   {6701, -32076},   {6697, -32076},
    {6694, -32077},   {6691, -32078},   {6688, -32078},   {6685, -32079},   {6682, -32079},   {6679, -32080},
    {6676, -32081},   {6673, -32081},   {6670, -32082},   {6667, -32083},   {6664, -32083},   {6661, -32084},
    {6657, -32085},   {6654, -32085},   {6651, -32086},   {6648, -32086},   {6645, -32087},   {6642, -32088},
    {6639, -32088},   {6636, -32089},   {6633, -32090},   {6630, -32090},   {6627, -32091},   {6624, -32092},
    {6621, -32092},   {6617, -32093},   {6614, -32093},   {6611, -32094},   {6608, -32095},   {6605, -32095},
    {6602, -32096},   {6599, -32097},   {6596, -32097},   {6593, -32098},   {6590, -32099},   {6587, -32099},
    {6584, -32100},   {6581, -32100},   {6577, -32101},   {6574, -32102},   {6571, -32102},   {6568, -32103},
    {6565, -32104},   {6562, -32104},   {6559, -32105},   {6556, -32105},   {6553, -32106},   {6550, -32107},
    {6547, -32107},   {6544, -32108},   {6541, -32109},   {6537, -32109},   {6534, -32110},   {6531, -32110},
    {6528, -32111},   {6525, -32112},   {6522, -32112},   {6519, -32113},   {6516, -32114},   {6513, -32114},
    {6510, -32115},   {6507, -32115},   {6504, -32116},   {6501, -32117},   {6497, -32117},   {6494, -32118},
    {6491, -32119},   {6488, -32119},   {6485, -32120},   {6482, -32120},   {6479, -32121},   {6476, -32122},
    {6473, -32122},   {6470, -32123},   {6467, -32124},   {6464, -32124},   {6460, -32125},   {6457, -32125},
    {6454, -32126},   {6451, -32127},   {6448, -32127},   {6445, -32128},   {6442, -32129},   {6439, -32129},
    {6436, -32130},   {6433, -32130},   {6430, -32131},   {6427, -32132},   {6424, -32132},   {6420, -32133},
    {6417, -32133},   {6414, -32134},   {6411, -32135},   {6408, -32135},   {6405, -32136},   {6402, -32137},
    {6399, -32137},   {6396, -32138},   {6393, -32138},   {6390, -32139},   {6387, -32140},   {6383, -32140},
    {6380, -32141},   {6377, -32141},   {6374, -32142},   {6371, -32143},   {6368, -32143},   {6365, -32144},
    {6362, -32144},   {6359, -32145},   {6356, -32146},   {6353, -32146},   {6350, -32147},   {6346, -32148},
    {6343, -32148},   {6340, -32149},   {6337, -32149},   {6334, -32150},   {6331, -32151},   {6328, -32151},
    {6325, -32152},   {6322, -32152},   {6319, -32153},   {6316, -32154},   {6313, -32154},   {6310, -32155},
    {6306, -32155},   {6303, -32156},   {6300, -32157},   {6297, -32157},   {6294, -32158},   {6291, -32158},
    {6288, -32159},   {6285, -32160},   {6282, -32160},   {6279, -32161},   {6276, -32161},   {6273, -32162},
    {6269, -32163},   {6266, -32163},   {6263, -32164},   {6260, -32164},   {6257, -32165},   {6254, -32166},
    {6251, -32166},   {6248, -32167},   {6245, -32167},   {6242, -32168},   {6239, -32169},   {6236, -32169},
    {6232, -32170},   {6229, -32170},   {6226, -32171},   {6223, -32172},   {6220, -32172},   {6217, -32173},
    {6214, -32173},   {6211, -32174},   {6208, -32175},   {6205, -32175},   {6202, -32176},   {6198, -32176},
    {6195, -32177},   {6192, -32178},   {6189, -32178},   {6186, -32179},   {6183, -32179},   {6180, -32180},
    {6177, -32181},   {6174, -32181},   {6171, -32182},   {6168, -32182},   {6165, -32183},   {6161, -32184},
    {6158, -32184},   {6155, -32185},   {6152, -32185},   {6149, -32186},   {6146, -32186},   {6143, -32187},
    {6140, -32188},   {6137, -32188},   {6134, -32189},   {6131, -32189},   {6128, -32190},   {6124, -32191},
    {6121, -32191},   {6118, -32192},   {6115, -32192},   {6112, -32193},   {6109, -32194},   {6106, -32194},
    {6103, -32195},   {6100, -32195},   {6097, -32196},   {6094, -32196},   {6090, -32197},   {6087, -32198},
    {6084, -32198},   {6081, -32199},   {6078, -32199},   {6075, -32200},   {6072, -32201},   {6069, -32201},
    {6066, -32202},   {6063, -32202},   {6060, -32203},   {6057, -32203},   {6053, -32204},   {6050, -32205},
    {6047, -32205},   {6044, -32206},   {6041, -32206},   {6038, -32207},   {6035, -32207},   {6032, -32208},
    {6029, -32209},   {6026, -32209},   {6023, -32210},   {6019, -32210},   {6016, -32211},   {6013, -32212},
    {6010, -32212},   {6007, -32213},   {6004, -32213},   {6001, -32214},   {5998, -32214},   {5995, -32215},
    {5992, -32216},   {5989, -32216},   {5985, -32217},   {5982, -32217},   {5979, -32218},   {5976, -32218},
    {5973, -32219},   {5970, -32220},   {5967, -32220},   {5964, -32221},   {5961, -32221},   {5958, -32222},
    {5955, -32222},   {5952, -32223},   {5948, -32224},   {5945, -32224},   {5942, -32225},   {5939, -32225},
    {5936, -32226},   {5933, -32226},   {5930, -32227},   {5927, -32228},   {5924, -32228},   {5921, -32229},
    {5918, -32229},   {5914, -32230},   {5911, -32230},   {5908, -32231},   {5905, -32232},   {5902, -32232},
    {5899, -32233},   {5896, -32233},   {5893, -32234},   {5890, -32234},   {5887, -32235},   {5884, -32235},
    {5880, -32236},   {5877, -32237},   {5874, -32237},   {5871, -32238},   {5868, -32238},   {5865, -32239},
    {5862, -32239},   {5859, -32240},   {5856, -32241},   {5853, -32241},   {5850, -32242},   {5846, -32242},
    {5843, -32243},   {5840, -32243},   {5837, -32244},   {5834, -32244},   {5831, -32245},   {5828, -32246},
    {5825, -32246},   {5822, -32247},   {5819, -32247},   {5816, -32248},   {5812, -32248},   {5809, -32249},
    {5806, -32249},   {5803, -32250},   {5800, -32251},   {5797, -32251},   {5794, -32252},   {5791, -32252},
    {5788, -32253},   {5785, -32253},   {5782, -32254},   {5778, -32254},   {5775, -32255},   {5772, -32256},
    {5769, -32256},   {5766, -32257},   {5763, -32257},   {5760, -32258},   {5757, -32258},   {5754, -32259},
    {5751, -32259},   {5748, -32260},   {5744, -32261},   {5741, -32261},   {5738, -32262},   {5735, -32262},
    {5732, -32263},   {5729, -32263},   {5726, -32264},   {5723, -32264},   {5720, -32265},   {5717, -32266},
    {5713, -32266},   {5710, -32267},   {5707, -32267},   {5704, -32268},   {5701, -32268},   {5698, -32269},
    {5695, -32269},   {5692, -32270},   {5689, -32270},   {5686, -32271},   {5683, -32272},   {5679, -32272},
    {5676, -32273},   {5673, -32273},   {5670, -32274},   {5667, -32274},   {5664, -32275},   {5661, -32275},
    {5658, -32276},   {5655, -32276},   {5652, -32277},   {5649, -32277},   {5645, -32278},   {5642, -32279},
    {5639, -32279},   {5636, -32280},   {5633, -32280},   {5630, -32281},   {5627, -32281},   {5624, -32282},
    {5621, -32282},   {5618, -32283},   {5614, -32283},   {5611, -32284},   {5608, -32285},   {5605, -32285},
    {5602, -32286},   {5599, -32286},   {5596, -32287},   {5593, -32287},   {5590, -32288},   {5587, -32288},
    {5584, -32289},   {5580, -32289},   {5577, -32290},   {5574, -32290},   {5571, -32291},   {5568, -32291},
    {5565, -32292},   {5562, -32293},   {5559, -32293},   {5556, -32294},   {5553, -32294},   {5549, -32295},
    {5546, -32295},   {5543, -32296},   {5540, -32296},   {5537, -32297},   {5534, -32297},   {5531, -32298},
    {5528, -32298},   {5525, -32299},   {5522, -32299},   {5518, -32300},   {5515, -32301},   {5512, -32301},
    {5509, -32302},   {5506, -32302},   {5503, -32303},   {5500, -32303},   {5497, -32304},   {5494, -32304},
    {5491, -32305},   {5488, -32305},   {5484, -32306},   {5481, -32306},   {5478, -32307},   {5475, -32307},
    {5472, -32308},   {5469, -32308},   {5466, -32309},   {5463, -32309},   {5460, -32310},   {5457, -32310},
    {5453, -32311},   {5450, -32312},   {5447, -32312},   {5444, -32313},   {5441, -32313},   {5438, -32314},
    {5435, -32314},   {5432, -32315},   {5429, -32315},   {5426, -32316},   {5422, -32316},   {5419, -32317},
    {5416, -32317},   {5413, -32318},   {5410, -32318},   {5407, -32319},   {5404, -32319},   {5401, -32320},
    {5398, -32320},   {5395, -32321},   {5391, -32321},   {5388, -32322},   {5385, -32322},   {5382, -32323},
    {5379, -32323},   {5376, -32324},   {5373, -32325},   {5370, -32325},   {5367, -32326},   {5364, -32326},
    {5360, -32327},   {5357, -32327},   {5354, -32328},   {5351, -32328},   {5348, -32329},   {5345, -32329},
    {5342, -32330},   {5339, -32330},   {5336, -32331},   {5333, -32331},   {5329, -32332},   {5326, -32332},
    {5323, -32333},   {5320, -32333},   {5317, -32334},   {5314, -32334},   {5311, -32335},   {5308, -32335},
    {5305, -32336},   {5302, -32336},   {5298, -32337},   {5295, -32337},   {5292, -32338},   {5289, -32338},
    {5286, -32339},   {5283, -32339},   {5280, -32340},   {5277, -32340},   {5274, -32341},   {5271, -32341},
    {5267, -32342},   {5264, -32342},   {5261, -32343},   {5258, -32343},   {5255, -32344},   {5252, -32344},
    {5249, -32345},   {5246, -32345},   {5243, -32346},   {5240, -32346},   {5236, -32347},   {5233, -32347},
    {5230, -32348},   {5227, -32348},   {5224, -32349},   {5221, -32349},   {5218, -32350},   {5215, -32350},
    {5212, -32351},   {5209, -32351},   {5205, -32352},   {5202, -32352},   {5199, -32353},   {5196, -32353},
    {5193, -32354},   {5190, -32354},   {5187, -32355},   {5184, -32355},   {5181, -32356},   {5178, -32356},
    {5174, -32357},   {5171, -32357},   {5168, -32358},   {5165, -32358},   {5162, -32359},   {5159, -32359},
    {5156, -32360},   {5153, -32360},   {5150, -32361},   {5147, -32361},   {5143, -32362},   {5140, -32362},
    {5137, -32363},   {5134, -32363},   {5131, -32364},   {5128, -32364},   {5125, -32365},   {5122, -32365},
    {5119, -32366},   {5115, -32366},   {5112, -32367},   {5109, -32367},   {5106, -32368},   {5103, -32368},
    {5100, -32369},   {5097, -32369},   {5094, -32370},   {5091, -32370},   {5088, -32371},   {5084, -32371},
    {5081, -32372},   {5078, -32372},   {5075, -32373},   {5072, -32373},   {5069, -32374},   {5066, -32374},
    {5063, -32375},   {5060, -32375},   {5057, -32376},   {5053, -32376},   {5050, -32376},   {5047, -32377},
    {5044, -32377},   {5041, -32378},   {5038, -32378},   {5035, -32379},   {5032, -32379},   {5029, -32380},
    {5025, -32380},   {5022, -32381},   {5019, -32381},   {5016, -32382},   {5013, -32382},   {5010, -32383},
    {5007, -32383},   {5004, -32384},   {5001, -32384},   {4998, -32385},   {4994, -32385},   {4991, -32386},
    {4988, -32386},   {4985, -32387},   {4982, -32387},   {4979, -32388},   {4976, -32388},   {4973, -32388},
    {4970, -32389},   {4966, -32389},   {4963, -32390},   {4960, -32390},   {4957, -32391},   {4954, -32391},
    {4951, -32392},   {4948, -32392},   {4945, -32393},   {4942, -32393},   {4939, -32394},   {4935, -32394},
    {4932, -32395},   {4929, -32395},   {4926, -32396},   {4923, -32396},   {4920, -32397},   {4917, -32397},
    {4914, -32397},   {4911, -32398},   {4907, -32398},   {4904, -32399},   {4901, -32399},   {4898, -32400},
    {4895, -32400},   {4892, -32401},   {4889, -32401},   {4886, -32402},   {4883, -32402},   {4880, -32403},
    {4876, -32403},   {4873, -32404},   {4870, -32404},   {4867, -32405},   {4864, -32405},   {4861, -32405},
    {4858, -32406},   {4855, -32406},   {4852, -32407},   {4848, -32407},   {4845, -32408},   {4842, -32408},
    {4839, -32409},   {4836, -32409},   {4833, -32410},   {4830, -32410},   {4827, -32411},   {4824, -32411},
    {4820, -32411},   {4817, -32412},   {4814, -32412},   {4811, -32413},   {4808, -32413},   {4805, -32414},
    {4802, -32414},   {4799, -32415},   {4796, -32415},   {4793, -32416},   {4789, -32416},   {4786, -32417},
    {4783, -32417},   {4780, -32417},   {4777, -32418},   {4774, -32418},   {4771, -32419},   {4768, -32419},
    {4765, -32420},   {4761, -32420},   {4758, -32421},   {4755, -32421},   {4752, -32422},   {4749, -32422},
    {4746, -32422},   {4743, -32423},   {4740, -32423},   {4737, -32424},   {4733, -32424},   {4730, -32425},
    {4727, -32425},   {4724, -32426},   {4721, -32426},   {4718, -32427},   {4715, -32427},   {4712, -32427},
    {4709, -32428},   {4705, -32428},   {4702, -32429},   {4699, -32429},   {4696, -32430},   {4693, -32430},
    {4690, -32431},   {4687, -32431},   {4684, -32432},   {4681, -32432},   {4678, -32432},   {4674, -32433},
    {4671, -32433},   {4668, -32434},   {4665, -32434},   {4662, -32435},   {4659, -32435},   {4656, -32436},
    {4653, -32436},   {4650, -32436},   {4646, -32437},   {4643, -32437},   {4640, -32438},   {4637, -32438},
    {4634, -32439},   {4631, -32439},   {4628, -32440},   {4625, -32440},   {4622, -32440},   {4618, -32441},
    {4615, -32441},   {4612, -32442},   {4609, -32442},   {4606, -32443},   {4603, -32443},   {4600, -32444},
    {4597, -32444},   {4594, -32444},   {4590, -32445},   {4587, -32445},   {4584, -32446},   {4581, -32446},
    {4578, -32447},   {4575, -32447},   {4572, -32448},   {4569, -32448},   {4566, -32448},   {4562, -32449},
    {4559, -32449},   {4556, -32450},   {4553, -32450},   {4550, -32451},   {4547, -32451},   {4544, -32451},
    {4541, -32452},   {4538, -32452},   {4534, -32453},   {4531, -32453},   {4528, -32454},   {4525, -32454},
    {4522, -32454},   {4519, -32455},   {4516, -32455},   {4513, -32456},   {4510, -32456},   {4506, -32457},
    {4503, -32457},   {4500, -32458},   {4497, -32458},   {4494, -32458},   {4491, -32459},   {4488, -32459},
    {4485, -32460},   {4482, -32460},   {4478, -32461},   {4475, -32461},   {4472, -32461},   {4469, -32462},
    {4466, -32462},   {4463, -32463},   {4460, -32463},   {4457, -32464},   {4454, -32464},   {4450, -32464},
    {4447, -32465},   {4444, -32465},   {4441, -32466},   {4438, -32466},   {4435, -32467},   {4432, -32467},
    {4429, -32467},   {4426, -32468},   {4422, -32468},   {4419, -32469},   {4416, -32469},   {4413, -32469},
    {4410, -32470},   {4407, -32470},   {4404, -32471},   {4401, -32471},   {4397, -32472},   {4394, -32472},
    {4391, -32472},   {4388, -32473},   {4385, -32473},   {4382, -32474},   {4379, -32474},   {4376, -32475},
    {4373, -32475},   {4369, -32475},   {4366, -32476},   {4363, -32476},   {4360, -32477},   {4357, -32477},
    {4354, -32477},   {4351, -32478},   {4348, -32478},   {4345, -32479},   {4341, -32479},   {4338, -32480},
    {4335, -32480},   {4332, -32480},   {4329, -32481},   {4326, -32481},   {4323, -32482},   {4320, -32482},
    {4317, -32482},   {4313, -32483},   {4310, -32483},   {4307, -32484},   {4304, -32484},   {4301, -32485},
    {4298, -32485},   {4295, -32485},   {4292, -32486},   {4289, -32486},   {4285, -32487},   {4282, -32487},
    {4279, -32487},   {4276, -32488},   {4273, -32488},   {4270, -32489},   {4267, -32489},   {4264, -32489},
    {4260, -32490},   {4257, -32490},   {4254, -32491},   {4251, -32491},   {4248, -32491},   {4245, -32492},
    {4242, -32492},   {4239, -32493},   {4236, -32493},   {4232, -32494},   {4229, -32494},   {4226, -32494},
    {4223, -32495},   {4220, -32495},   {4217, -32496},   {4214, -32496},   {4211, -32496},   {4208, -32497},
    {4204, -32497},   {4201, -32498},   {4198, -32498},   {4195, -32498},   {4192, -32499},   {4189, -32499},
    {4186, -32500},   {4183, -32500},   {4179, -32500},   {4176, -32501},   {4173, -32501},   {4170, -32502},
    {4167, -32502},   {4164, -32502},   {4161, -32503},   {4158, -32503},   {4155, -32504},   {4151, -32504},
    {4148, -32504},   {4145, -32505},   {4142, -32505},   {4139, -32506},   {4136, -32506},   {4133, -32506},
    {4130, -32507},   {4126, -32507},   {4123, -32508},   {4120, -32508},   {4117, -32508},   {4114, -32509},
    {4111, -32509},   {4108, -32510},   {4105, -32510},   {4102, -32510},   {4098, -32511},   {4095, -32511},
    {4092, -32511},   {4089, -32512},   {4086, -32512},   {4083, -32513},   {4080, -32513},   {4077, -32513},
    {4074, -32514},   {4070, -32514},   {4067, -32515},   {4064, -32515},   {4061, -32515},   {4058, -32516},
    {4055, -32516},   {4052, -32517},   {4049, -32517},   {4045, -32517},   {4042, -32518},   {4039, -32518},
    {4036, -32518},   {4033, -32519},   {4030, -32519},   {4027, -32520},   {4024, -32520},   {4021, -32520},
    {4017, -32521},   {4014, -32521},   {4011, -32522},   {4008, -32522},   {4005, -32522},   {4002, -32523},
    {3999, -32523},   {3996, -32523},   {3992, -32524},   {3989, -32524},   {3986, -32525},   {3983, -32525},
    {3980, -32525},   {3977, -32526},   {3974, -32526},   {3971, -32527},   {3967, -32527},   {3964, -32527},
    {3961, -32528},   {3958, -32528},   {3955, -32528},   {3952, -32529},   {3949, -32529},   {3946, -32530},
    {3943, -32530},   {3939, -32530},   {3936, -32531},   {3933, -32531},   {3930, -32531},   {3927, -32532},
    {3924, -32532},   {3921, -32533},   {3918, -32533},   {3914, -32533},   {3911, -32534},   {3908, -32534},
    {3905, -32534},   {3902, -32535},   {3899, -32535},   {3896, -32536},   {3893, -32536},   {3890, -32536},
    {3886, -32537},   {3883, -32537},   {3880, -32537},   {3877, -32538},   {3874, -32538},   {3871, -32539},
    {3868, -32539},   {3865, -32539},   {3861, -32540},   {3858, -32540},   {3855, -32540},   {3852, -32541},
    {3849, -32541},   {3846, -32542},   {3843, -32542},   {3840, -32542},   {3836, -32543},   {3833, -32543},
    {3830, -32543},   {3827, -32544},   {3824, -32544},   {3821, -32544},   {3818, -32545},   {3815, -32545},
    {3812, -32546},   {3808, -32546},   {3805, -32546},   {3802, -32547},   {3799, -32547},   {3796, -32547},
    {3793, -32548},   {3790, -32548},   {3787, -32548},   {3783, -32549},   {3780, -32549},   {3777, -32550},
    {3774, -32550},   {3771, -32550},   {3768, -32551},   {3765, -32551},   {3762, -32551},   {3758, -32552},
    {3755, -32552},   {3752, -32552},   {3749, -32553},   {3746, -32553},   {3743, -32554},   {3740, -32554},
    {3737, -32554},   {3734, -32555},   {3730, -32555},   {3727, -32555},   {3724, -32556},   {3721, -32556},
    {3718, -32556},   {3715, -32557},   {3712, -32557},   {3709, -32557},   {3705, -32558},   {3702, -32558},
    {3699, -32559},   {3696, -32559},   {3693, -32559},   {3690, -32560},   {3687, -32560},   {3684, -32560},
    {3680, -32561},   {3677, -32561},   {3674, -32561},   {3671, -32562},   {3668, -32562},   {3665, -32562},
    {3662, -32563},   {3659, -32563},   {3655, -32563},   {3652, -32564},   {3649, -32564},   {3646, -32565},
    {3643, -32565},   {3640, -32565},   {3637, -32566},   {3634, -32566},   {3630, -32566},   {3627, -32567},
    {3624, -32567},   {3621, -32567},   {3618, -32568},   {3615, -32568},   {3612, -32568},   {3609, -32569},
    {3606, -32569},   {3602, -32569},   {3599, -32570},   {3596, -32570},   {3593, -32570},   {3590, -32571},
    {3587, -32571},   {3584, -32571},   {3581, -32572},   {3577, -32572},   {3574, -32572},   {3571, -32573},
    {3568, -32573},   {3565, -32574},   {3562, -32574},   {3559, -32574},   {3556, -32575},   {3552, -32575},
    {3549, -32575},   {3546, -32576},   {3543, -32576},   {3540, -32576},   {3537, -32577},   {3534, -32577},
    {3531, -32577},   {3527, -32578},   {3524, -32578},   {3521, -32578},   {3518, -32579},   {3515, -32579},
    {3512, -32579},   {3509, -32580},   {3506, -32580},   {3502, -32580},   {3499, -32581},   {3496, -32581},
    {3493, -32581},   {3490, -32582},   {3487, -32582},   {3484, -32582},   {3481, -32583},   {3477, -32583},
    {3474, -32583},   {3471, -32584},   {3468, -32584},   {3465, -32584},   {3462, -32585},   {3459, -32585},
    {3456, -32585},   {3452, -32586},   {3449, -32586},   {3446, -32586},   {3443, -32587},   {3440, -32587},
    {3437, -32587},   {3434, -32588},   {3431, -32588},   {3427, -32588},   {3424, -32589},   {3421, -32589},
    {3418, -32589},   {3415, -32590},   {3412, -32590},   {3409, -32590},   {3406, -32591},   {3402, -32591},
    {3399, -32591},   {3396, -32592},   {3393, -32592},   {3390, -32592},   {3387, -32592},   {3384, -32593},
    {3381, -32593},   {3377, -32593},   {3374, -32594},   {3371, -32594},   {3368, -32594},   {3365, -32595},
    {3362, -32595},   {3359, -32595},   {3356, -32596},   {3352, -32596},   {3349, -32596},   {3346, -32597},
    {3343, -32597},   {3340, -32597},   {3337, -32598},   {3334, -32598},   {3331, -32598},   {3327, -32599},
    {3324, -32599},   {3321, -32599},   {3318, -32600},   {3315, -32600},   {3312, -32600},   {3309, -32601},
    {3306, -32601},   {3302, -32601},   {3299, -32601},   {3296, -32602},   {3293, -32602},   {3290, -32602},
    {3287, -32603},   {3284, -32603},   {3281, -32603},   {3277, -32604},   {3274, -32604},   {3271, -32604},
    {3268, -32605},   {3265, -32605},   {3262, -32605},   {3259, -32606},   {3256, -32606},   {3252, -32606},
    {3249, -32606},   {3246, -32607},   {3243, -32607},   {3240, -32607},   {3237, -32608},   {3234, -32608},
    {3231, -32608},   {3227, -32609},   {3224, -32609},   {3221, -32609},   {3218, -32610},   {3215, -32610},
    {3212, -32610},   {3209, -32611},   {3206, -32611},   {3202, -32611},   {3199, -32611},   {3196, -32612},
    {3193, -32612},   {3190, -32612},   {3187, -32613},   {3184, -32613},   {3181, -32613},   {3177, -32614},
    {3174, -32614},   {3171, -32614},   {3168, -32614},   {3165, -32615},   {3162, -32615},   {3159, -32615},
    {3156, -32616},   {3152, -32616},   {3149, -32616},   {3146, -32617},   {3143, -32617},   {3140, -32617},
    {3137, -32618},   {3134, -32618},   {3131, -32618},   {3127, -32618},   {3124, -32619},   {3121, -32619},
    {3118, -32619},   {3115, -32620},   {3112, -32620},   {3109, -32620},   {3106, -32621},   {3102, -32621},
    {3099, -32621},   {3096, -32621},   {3093, -32622},   {3090, -32622},   {3087, -32622},   {3084, -32623},
    {3080, -32623},   {3077, -32623},   {3074, -32623},   {3071, -32624},   {3068, -32624},   {3065, -32624},
    {3062, -32625},   {3059, -32625},   {3055, -32625},   {3052, -32626},   {3049, -32626},   {3046, -32626},
    {3043, -32626},   {3040, -32627},   {3037, -32627},   {3034, -32627},   {3030, -32628},   {3027, -32628},
    {3024, -32628},   {3021, -32628},   {3018, -32629},   {3015, -32629},   {3012, -32629},   {3009, -32630},
    {3005, -32630},   {3002, -32630},   {2999, -32630},   {2996, -32631},   {2993, -32631},   {2990, -32631},
    {2987, -32632},   {2984, -32632},   {2980, -32632},   {2977, -32632},   {2974, -32633},   {2971, -32633},
    {2968, -32633},   {2965, -32634},   {2962, -32634},   {2958, -32634},   {2955, -32634},   {2952, -32635},
    {2949, -32635},   {2946, -32635},   {2943, -32636},   {2940, -32636},   {2937, -32636},   {2933, -32636},
    {2930, -32637},   {2927, -32637},   {2924, -32637},   {2921, -32638},   {2918, -32638},   {2915, -32638},
    {2912, -32638},   {2908, -32639},   {2905, -32639},   {2902, -32639},   {2899, -32640},   {2896, -32640},
    {2893, -32640},   {2890, -32640},   {2887, -32641},   {2883, -32641},   {2880, -32641},   {2877, -32641},
    {2874, -32642},   {2871, -32642},   {2868, -32642},   {2865, -32643},   {2861, -32643},   {2858, -32643},
    {2855, -32643},   {2852, -32644},   {2849, -32644},   {2846, -32644},   {2843, -32644},   {2840, -32645},
    {2836, -32645},   {2833, -32645},   {2830, -32646},   {2827, -32646},   {2824, -32646},   {2821, -32646},
    {2818, -32647},   {2815, -32647},   {2811, -32647},   {2808, -32647},   {2805, -32648},   {2802, -32648},
    {2799, -32648},   {2796, -32649},   {2793, -32649},   {2789, -32649},   {2786, -32649},   {2783, -32650},
    {2780, -32650},   {2777, -32650},   {2774, -32650},   {2771, -32651},   {2768, -32651},   {2764, -32651},
    {2761, -32651},   {2758, -32652},   {2755, -32652},   {2752, -32652},   {2749, -32653},   {2746, -32653},
    {2743, -32653},   {2739, -32653},   {2736, -32654},   {2733, -32654},   {2730, -32654},   {2727, -32654},
    {2724, -32655},   {2721, -32655},   {2717, -32655},   {2714, -32655},   {2711, -32656},   {2708, -32656},
    {2705, -32656},   {2702, -32656},   {2699, -32657},   {2696, -32657},   {2692, -32657},   {2689, -32657},
    {2686, -32658},   {2683, -32658},   {2680, -32658},   {2677, -32658},   {2674, -32659},   {2671, -32659},
    {2667, -32659},   {2664, -32660},   {2661, -32660},   {2658, -32660},   {2655, -32660},   {2652, -32661},
    {2649, -32661},   {2645, -32661},   {2642, -32661},   {2639, -32662},   {2636, -32662},   {2633, -32662},
    {2630, -32662},   {2627, -32663},   {2624, -32663},   {2620, -32663},   {2617, -32663},   {2614, -32664},
    {2611, -32664},   {2608, -32664},   {2605, -32664},   {2602, -32665},   {2599, -32665},   {2595, -32665},
    {2592, -32665},   {2589, -32666},   {2586, -32666},   {2583, -32666},   {2580, -32666},   {2577, -32667},
    {2573, -32667},   {2570, -32667},   {2567, -32667},   {2564, -32668},   {2561, -32668},   {2558, -32668},
    {2555, -32668},   {2552, -32669},   {2548, -32669},   {2545, -32669},   {2542, -32669},   {2539, -32669},
    {2536, -32670},   {2533, -32670},   {2530, -32670},   {2526, -32670},   {2523, -32671},   {2520, -32671},
    {2517, -32671},   {2514, -32671},   {2511, -32672},   {2508, -32672},   {2505, -32672},   {2501, -32672},
    {2498, -32673},   {2495, -32673},   {2492, -32673},   {2489, -32673},   {2486, -32674},   {2483, -32674},
    {2479, -32674},   {2476, -32674},   {2473, -32675},   {2470, -32675},   {2467, -32675},   {2464, -32675},
    {2461, -32675},   {2458, -32676},   {2454, -32676},   {2451, -32676},   {2448, -32676},   {2445, -32677},
    {2442, -32677},   {2439, -32677},   {2436, -32677},   {2432, -32678},   {2429, -32678},   {2426, -32678},
    {2423, -32678},   {2420, -32679},   {2417, -32679},   {2414, -32679},   {2411, -32679},   {2407, -32679},
    {2404, -32680},   {2401, -32680},   {2398, -32680},   {2395, -32680},   {2392, -32681},   {2389, -32681},
    {2385, -32681},   {2382, -32681},   {2379, -32682},   {2376, -32682},   {2373, -32682},   {2370, -32682},
    {2367, -32682},   {2364, -32683},   {2360, -32683},   {2357, -32683},   {2354, -32683},   {2351, -32684},
    {2348, -32684},   {2345, -32684},   {2342, -32684},   {2338, -32684},   {2335, -32685},   {2332, -32685},
    {2329, -32685},   {2326, -32685},   {2323, -32686},   {2320, -32686},   {2317, -32686},   {2313, -32686},
    {2310, -32686},   {2307, -32687},   {2304, -32687},   {2301, -32687},   {2298, -32687},   {2295, -32688},
    {2291, -32688},   {2288, -32688},   {2285, -32688},   {2282, -32688},   {2279, -32689},   {2276, -32689},
    {2273, -32689},   {2270, -32689},   {2266, -32690},   {2263, -32690},   {2260, -32690},   {2257, -32690},
    {2254, -32690},   {2251, -32691},   {2248, -32691},   {2244, -32691},   {2241, -32691},   {2238, -32691},
    {2235, -32692},   {2232, -32692},   {2229, -32692},   {2226, -32692},   {2223, -32693},   {2219, -32693},
    {2216, -32693},   {2213, -32693},   {2210, -32693},   {2207, -32694},   {2204, -32694},   {2201, -32694},
    {2197, -32694},   {2194, -32694},   {2191, -32695},   {2188, -32695},   {2185, -32695},   {2182, -32695},
    {2179, -32695},   {2176, -32696},   {2172, -32696},   {2169, -32696},   {2166, -32696},   {2163, -32697},
    {2160, -32697},   {2157, -32697},   {2154, -32697},   {2150, -32697},   {2147, -32698},   {2144, -32698},
    {2141, -32698},   {2138, -32698},   {2135, -32698},   {2132, -32699},   {2129, -32699},   {2125, -32699},
    {2122, -32699},   {2119, -32699},   {2116, -32700},   {2113, -32700},   {2110, -32700},   {2107, -32700},
    {2103, -32700},   {2100, -32701},   {2097, -32701},   {2094, -32701},   {2091, -32701},   {2088, -32701},
    {2085, -32702},   {2081, -32702},   {2078, -32702},   {2075, -32702},   {2072, -32702},   {2069, -32703},
    {2066, -32703},   {2063, -32703},   {2060, -32703},   {2056, -32703},   {2053, -32704},   {2050, -32704},
    {2047, -32704},   {2044, -32704},   {2041, -32704},   {2038, -32705},   {2034, -32705},   {2031, -32705},
    {2028, -32705},   {2025, -32705},   {2022, -32706},   {2019, -32706},   {2016, -32706},   {2012, -32706},
    {2009, -32706},   {2006, -32707},   {2003, -32707},   {2000, -32707},   {1997, -32707},   {1994, -32707},
    {1991, -32707},   {1987, -32708},   {1984, -32708},   {1981, -32708},   {1978, -32708},   {1975, -32708},
    {1972, -32709},   {1969, -32709},   {1965, -32709},   {1962, -32709},   {1959, -32709},   {1956, -32710},
    {1953, -32710},   {1950, -32710},   {1947, -32710},   {1944, -32710},   {1940, -32710},   {1937, -32711},
    {1934, -32711},   {1931, -32711},   {1928, -32711},   {1925, -32711},   {1922, -32712},   {1918, -32712},
    {1915, -32712},   {1912, -32712},   {1909, -32712},   {1906, -32713},   {1903, -32713},   {1900, -32713},
    {1896, -32713},   {1893, -32713},   {1890, -32713},   {1887, -32714},   {1884, -32714},   {1881, -32714},
    {1878, -32714},   {1875, -32714},   {1871, -32715},   {1868, -32715},   {1865, -32715},   {1862, -32715},
    {1859, -32715},   {1856, -32715},   {1853, -32716},   {1849, -32716},   {1846, -32716},   {1843, -32716},
    {1840, -32716},   {1837, -32716},   {1834, -32717},   {1831, -32717},   {1827, -32717},   {1824, -32717},
    {1821, -32717},   {1818, -32718},   {1815, -32718},   {1812, -32718},   {1809, -32718},   {1806, -32718},
    {1802, -32718},   {1799, -32719},   {1796, -32719},   {1793, -32719},   {1790, -32719},   {1787, -32719},
    {1784, -32719},   {1780, -32720},   {1777, -32720},   {1774, -32720},   {1771, -32720},   {1768, -32720},
    {1765, -32720},   {1762, -32721},   {1758, -32721},   {1755, -32721},   {1752, -32721},   {1749, -32721},
    {1746, -32721},   {1743, -32722},   {1740, -32722},   {1736, -32722},   {1733, -32722},   {1730, -32722},
    {1727, -32722},   {1724, -32723},   {1721, -32723},   {1718, -32723},   {1715, -32723},   {1711, -32723},
    {1708, -32723},   {1705, -32724},   {1702, -32724},   {1699, -32724},   {1696, -32724},   {1693, -32724},
    {1689, -32724},   {1686, -32725},   {1683, -32725},   {1680, -32725},   {1677, -32725},   {1674, -32725},
    {1671, -32725},   {1667, -32726},   {1664, -32726},   {1661, -32726},   {1658, -32726},   {1655, -32726},
    {1652, -32726},   {1649, -32727},   {1646, -32727},   {1642, -32727},   {1639, -32727},   {1636, -32727},
    {1633, -32727},   {1630, -32727},   {1627, -32728},   {1624, -32728},   {1620, -32728},   {1617, -32728},
    {1614, -32728},   {1611, -32728},   {1608, -32729},   {1605, -32729},   {1602, -32729},   {1598, -32729},
    {1595, -32729},   {1592, -32729},   {1589, -32729},   {1586, -32730},   {1583, -32730},   {1580, -32730},
    {1576, -32730},   {1573, -32730},   {1570, -32730},   {1567, -32731},   {1564, -32731},   {1561, -32731},
    {1558, -32731},   {1555, -32731},   {1551, -32731},   {1548, -32731},   {1545, -32732},   {1542, -32732},
    {1539, -32732},   {1536, -32732},   {1533, -32732},   {1529, -32732},   {1526, -32732},   {1523, -32733},
    {1520, -32733},   {1517, -32733},   {1514, -32733},   {1511, -32733},   {1507, -32733},   {1504, -32733},
    {1501, -32734},   {1498, -32734},   {1495, -32734},   {1492, -32734},   {1489, -32734},   {1485, -32734},
    {1482, -32734},   {1479, -32735},   {1476, -32735},   {1473, -32735},   {1470, -32735},   {1467, -32735},
    {1463, -32735},   {1460, -32735},   {1457, -32736},   {1454, -32736},   {1451, -32736},   {1448, -32736},
    {1445, -32736},   {1442, -32736},   {1438, -32736},   {1435, -32737},   {1432, -32737},   {1429, -32737},
    {1426, -32737},   {1423, -32737},   {1420, -32737},   {1416, -32737},   {1413, -32738},   {1410, -32738},
    {1407, -32738},   {1404, -32738},   {1401, -32738},   {1398, -32738},   {1394, -32738},   {1391, -32738},
    {1388, -32739},   {1385, -32739},   {1382, -32739},   {1379, -32739},   {1376, -32739},   {1372, -32739},
    {1369, -32739},   {1366, -32740},   {1363, -32740},   {1360, -32740},   {1357, -32740},   {1354, -32740},
    {1351, -32740},   {1347, -32740},   {1344, -32740},   {1341, -32741},   {1338, -32741},   {1335, -32741},
    {1332, -32741},   {1329, -32741},   {1325, -32741},   {1322, -32741},   {1319, -32741},   {1316, -32742},
    {1313, -32742},   {1310, -32742},   {1307, -32742},   {1303, -32742},   {1300, -32742},   {1297, -32742},
    {1294, -32742},   {1291, -32743},   {1288, -32743},   {1285, -32743},   {1281, -32743},   {1278, -32743},
    {1275, -32743},   {1272, -32743},   {1269, -32743},   {1266, -32744},   {1263, -32744},   {1259, -32744},
    {1256, -32744},   {1253, -32744},   {1250, -32744},   {1247, -32744},   {1244, -32744},   {1241, -32745},
    {1237, -32745},   {1234, -32745},   {1231, -32745},   {1228, -32745},   {1225, -32745},   {1222, -32745},
    {1219, -32745},   {1216, -32745},   {1212, -32746},   {1209, -32746},   {1206, -32746},   {1203, -32746},
    {1200, -32746},   {1197, -32746},   {1194, -32746},   {1190, -32746},   {1187, -32746},   {1184, -32747},
    {1181, -32747},   {1178, -32747},   {1175, -32747},   {1172, -32747},   {1168, -32747},   {1165, -32747},
    {1162, -32747},   {1159, -32747},   {1156, -32748},   {1153, -32748},   {1150, -32748},   {1146, -32748},
    {1143, -32748},   {1140, -32748},   {1137, -32748},   {1134, -32748},   {1131, -32748},   {1128, -32749},
    {1124, -32749},   {1121, -32749},   {1118, -32749},   {1115, -32749},   {1112, -32749},   {1109, -32749},
    {1106, -32749},   {1102, -32749},   {1099, -32750},   {1096, -32750},   {1093, -32750},   {1090, -32750},
    {1087, -32750},   {1084, -32750},   {1081, -32750},   {1077, -32750},   {1074, -32750},   {1071, -32750},
    {1068, -32751},   {1065, -32751},   {1062, -32751},   {1059, -32751},   {1055, -32751},   {1052, -32751},
    {1049, -32751},   {1046, -32751},   {1043, -32751},   {1040, -32752},   {1037, -32752},   {1033, -32752},
    {1030, -32752},   {1027, -32752},   {1024, -32752},   {1021, -32752},   {1018, -32752},   {1015, -32752},
    {1011, -32752},   {1008, -32752},   {1005, -32753},   {1002, -32753},   {999, -32753},    {996, -32753},
    {993, -32753},    {989, -32753},    {986, -32753},    {983, -32753},    {980, -32753},    {977, -32753},
    {974, -32754},    {971, -32754},    {967, -32754},    {964, -32754},    {961, -32754},    {958, -32754},
    {955, -32754},    {952, -32754},    {949, -32754},    {945, -32754},    {942, -32754},    {939, -32755},
    {936, -32755},    {933, -32755},    {930, -32755},    {927, -32755},    {924, -32755},    {920, -32755},
    {917, -32755},    {914, -32755},    {911, -32755},    {908, -32755},    {905, -32756},    {902, -32756},
    {898, -32756},    {895, -32756},    {892, -32756},    {889, -32756},    {886, -32756},    {883, -32756},
    {880, -32756},    {876, -32756},    {873, -32756},    {870, -32756},    {867, -32757},    {864, -32757},
    {861, -32757},    {858, -32757},    {854, -32757},    {851, -32757},    {848, -32757},    {845, -32757},
    {842, -32757},    {839, -32757},    {836, -32757},    {832, -32757},    {829, -32758},    {826, -32758},
    {823, -32758},    {820, -32758},    {817, -32758},    {814, -32758},    {810, -32758},    {807, -32758},
    {804, -32758},    {801, -32758},    {798, -32758},    {795, -32758},    {792, -32758},    {788, -32759},
    {785, -32759},    {782, -32759},    {779, -32759},    {776, -32759},    {773, -32759},    {770, -32759},
    {766, -32759},    {763, -32759},    {760, -32759},    {757, -32759},    {754, -32759},    {751, -32759},
    {748, -32759},    {744, -32760},    {741, -32760},    {738, -32760},    {735, -32760},    {732, -32760},
    {729, -32760},    {726, -32760},    {723, -32760},    {719, -32760},    {716, -32760},    {713, -32760},
    {710, -32760},    {707, -32760},    {704, -32760},    {701, -32761},    {697, -32761},    {694, -32761},
    {691, -32761},    {688, -32761},    {685, -32761},    {682, -32761},    {679, -32761},    {675, -32761},
    {672, -32761},    {669, -32761},    {666, -32761},    {663, -32761},    {660, -32761},    {657, -32761},
    {653, -32761},    {650, -32762},    {647, -32762},    {644, -32762},    {641, -32762},    {638, -32762},
    {635, -32762},    {631, -32762},    {628, -32762},    {625, -32762},    {622, -32762},    {619, -32762},
    {616, -32762},    {613, -32762},    {609, -32762},    {606, -32762},    {603, -32762},    {600, -32763},
    {597, -32763},    {594, -32763},    {591, -32763},    {587, -32763},    {584, -32763},    {581, -32763},
    {578, -32763},    {575, -32763},    {572, -32763},    {569, -32763},    {565, -32763},    {562, -32763},
    {559, -32763},    {556, -32763},    {553, -32763},    {550, -32763},    {547, -32763},    {543, -32763},
    {540, -32764},    {537, -32764},    {534, -32764},    {531, -32764},    {528, -32764},    {525, -32764},
    {521, -32764},    {518, -32764},    {515, -32764},    {512, -32764},    {509, -32764},    {506, -32764},
    {503, -32764},    {499, -32764},    {496, -32764},    {493, -32764},    {490, -32764},    {487, -32764},
    {484, -32764},    {481, -32764},    {478, -32765},    {474, -32765},    {471, -32765},    {468, -32765},
    {465, -32765},    {462, -32765},    {459, -32765},    {456, -32765},    {452, -32765},    {449, -32765},
    {446, -32765},    {443, -32765},    {440, -32765},    {437, -32765},    {434, -32765},    {430, -32765},
    {427, -32765},    {424, -32765},    {421, -32765},    {418, -32765},    {415, -32765},    {412, -32765},
    {408, -32765},    {405, -32765},    {402, -32766},    {399, -32766},    {396, -32766},    {393, -32766},
    {390, -32766},    {386, -32766},    {383, -32766},    {380, -32766},    {377, -32766},    {374, -32766},
    {371, -32766},    {368, -32766},    {364, -32766},    {361, -32766},    {358, -32766},    {355, -32766},
    {352, -32766},    {349, -32766},    {346, -32766},    {342, -32766},    {339, -32766},    {336, -32766},
    {333, -32766},    {330, -32766},    {327, -32766},    {324, -32766},    {320, -32766},    {317, -32766},
    {314, -32766},    {311, -32767},    {308, -32767},    {305, -32767},    {302, -32767},    {298, -32767},
    {295, -32767},    {292, -32767},    {289, -32767},    {286, -32767},    {283, -32767},    {280, -32767},
    {276, -32767},    {273, -32767},    {270, -32767},    {267, -32767},    {264, -32767},    {261, -32767},
    {258, -32767},    {254, -32767},    {251, -32767},    {248, -32767},    {245, -32767},    {242, -32767},
    {239, -32767},    {236, -32767},    {232, -32767},    {229, -32767},    {226, -32767},    {223, -32767},
    {220, -32767},    {217, -32767},    {214, -32767},    {210, -32767},    {207, -32767},    {204, -32767},
    {201, -32767},    {198, -32767},    {195, -32767},    {192, -32767},    {188, -32767},    {185, -32767},
    {182, -32767},    {179, -32768},    {176, -32768},    {173, -32768},    {170, -32768},    {167, -32768},
    {163, -32768},    {160, -32768},    {157, -32768},    {154, -32768},    {151, -32768},    {148, -32768},
    {145, -32768},    {141, -32768},    {138, -32768},    {135, -32768},    {132, -32768},    {129, -32768},
    {126, -32768},    {123, -32768},    {119, -32768},    {116, -32768},    {113, -32768},    {110, -32768},
    {107, -32768},    {104, -32768},    {101, -32768},    {97, -32768},     {94, -32768},     {91, -32768},
    {88, -32768},     {85, -32768},     {82, -32768},     {79, -32768},     {75, -32768},     {72, -32768},
    {69, -32768},     {66, -32768},     {63, -32768},     {60, -32768},     {57, -32768},     {53, -32768},
    {50, -32768},     {47, -32768},     {44, -32768},     {41, -32768},     {38, -32768},     {35, -32768},
    {31, -32768},     {28, -32768},     {25, -32768},     {22, -32768},     {19, -32768},     {16, -32768},
    {13, -32768},     {9, -32768},      {6, -32768},      {3, -32768},      {0, -32768},      {-3, -32768},
    {-6, -32768},     {-9, -32768},     {-13, -32768},    {-16, -32768},    {-19, -32768},    {-22, -32768},
    {-25, -32768},    {-28, -32768},    {-31, -32768},    {-35, -32768},    {-38, -32768},    {-41, -32768},
    {-44, -32768},    {-47, -32768},    {-50, -32768},    {-53, -32768},    {-57, -32768},    {-60, -32768},
    {-63, -32768},    {-66, -32768},    {-69, -32768},    {-72, -32768},    {-75, -32768},    {-79, -32768},
    {-82, -32768},    {-85, -32768},    {-88, -32768},    {-91, -32768},    {-94, -32768},    {-97, -32768},
    {-101, -32768},   {-104, -32768},   {-107, -32768},   {-110, -32768},   {-113, -32768},   {-116, -32768},
    {-119, -32768},   {-123, -32768},   {-126, -32768},   {-129, -32768},   {-132, -32768},   {-135, -32768},
    {-138, -32768},   {-141, -32768},   {-145, -32768},   {-148, -32768},   {-151, -32768},   {-154, -32768},
    {-157, -32768},   {-160, -32768},   {-163, -32768},   {-167, -32768},   {-170, -32768},   {-173, -32768},
    {-176, -32768},   {-179, -32768},   {-182, -32767},   {-185, -32767},   {-188, -32767},   {-192, -32767},
    {-195, -32767},   {-198, -32767},   {-201, -32767},   {-204, -32767},   {-207, -32767},   {-210, -32767},
    {-214, -32767},   {-217, -32767},   {-220, -32767},   {-223, -32767},   {-226, -32767},   {-229, -32767},
    {-232, -32767},   {-236, -32767},   {-239, -32767},   {-242, -32767},   {-245, -32767},   {-248, -32767},
    {-251, -32767},   {-254, -32767},   {-258, -32767},   {-261, -32767},   {-264, -32767},   {-267, -32767},
    {-270, -32767},   {-273, -32767},   {-276, -32767},   {-280, -32767},   {-283, -32767},   {-286, -32767},
    {-289, -32767},   {-292, -32767},   {-295, -32767},   {-298, -32767},   {-302, -32767},   {-305, -32767},
    {-308, -32767},   {-311, -32767},   {-314, -32766},   {-317, -32766},   {-320, -32766},   {-324, -32766},
    {-327, -32766},   {-330, -32766},   {-333, -32766},   {-336, -32766},   {-339, -32766},   {-342, -32766},
    {-346, -32766},   {-349, -32766},   {-352, -32766},   {-355, -32766},   {-358, -32766},   {-361, -32766},
    {-364, -32766},   {-368, -32766},   {-371, -32766},   {-374, -32766},   {-377, -32766},   {-380, -32766},
    {-383, -32766},   {-386, -32766},   {-390, -32766},   {-393, -32766},   {-396, -32766},   {-399, -32766},
    {-402, -32766},   {-405, -32765},   {-408, -32765},   {-412, -32765},   {-415, -32765},   {-418, -32765},
    {-421, -32765},   {-424, -32765},   {-427, -32765},   {-430, -32765},   {-434, -32765},   {-437, -32765},
    {-440, -32765},   {-443, -32765},   {-446, -32765},   {-449, -32765},   {-452, -32765},   {-456, -32765},
    {-459, -32765},   {-462, -32765},   {-465, -32765},   {-468, -32765},   {-471, -32765},   {-474, -32765},
    {-478, -32765},   {-481, -32764},   {-484, -32764},   {-487, -32764},   {-490, -32764},   {-493, -32764},
    {-496, -32764},   {-499, -32764},   {-503, -32764},   {-506, -32764},   {-509, -32764},   {-512, -32764},
    {-515, -32764},   {-518, -32764},   {-521, -32764},   {-525, -32764},   {-528, -32764},   {-531, -32764},
    {-534, -32764},   {-537, -32764},   {-540, -32764},   {-543, -32763},   {-547, -32763},   {-550, -32763},
    {-553, -32763},   {-556, -32763},   {-559, -32763},   {-562, -32763},   {-565, -32763},   {-569, -32763},
    {-572, -32763},   {-575, -32763},   {-578, -32763},   {-581, -32763},   {-584, -32763},   {-587, -32763},
    {-591, -32763},   {-594, -32763},   {-597, -32763},   {-600, -32763},   {-603, -32762},   {-606, -32762},
    {-609, -32762},   {-613, -32762},   {-616, -32762},   {-619, -32762},   {-622, -32762},   {-625, -32762},
    {-628, -32762},   {-631, -32762},   {-635, -32762},   {-638, -32762},   {-641, -32762},   {-644, -32762},
    {-647, -32762},   {-650, -32762},   {-653, -32761},   {-657, -32761},   {-660, -32761},   {-663, -32761},
    {-666, -32761},   {-669, -32761},   {-672, -32761},   {-675, -32761},   {-679, -32761},   {-682, -32761},
    {-685, -32761},   {-688, -32761},   {-691, -32761},   {-694, -32761},   {-697, -32761},   {-701, -32761},
    {-704, -32760},   {-707, -32760},   {-710, -32760},   {-713, -32760},   {-716, -32760},   {-719, -32760},
    {-723, -32760},   {-726, -32760},   {-729, -32760},   {-732, -32760},   {-735, -32760},   {-738, -32760},
    {-741, -32760},   {-744, -32760},   {-748, -32759},   {-751, -32759},   {-754, -32759},   {-757, -32759},
    {-760, -32759},   {-763, -32759},   {-766, -32759},   {-770, -32759},   {-773, -32759},   {-776, -32759},
    {-779, -32759},   {-782, -32759},   {-785, -32759},   {-788, -32759},   {-792, -32758},   {-795, -32758},
    {-798, -32758},   {-801, -32758},   {-804, -32758},   {-807, -32758},   {-810, -32758},   {-814, -32758},
    {-817, -32758},   {-820, -32758},   {-823, -32758},   {-826, -32758},   {-829, -32758},   {-832, -32757},
    {-836, -32757},   {-839, -32757},   {-842, -32757},   {-845, -32757},   {-848, -32757},   {-851, -32757},
    {-854, -32757},   {-858, -32757},   {-861, -32757},   {-864, -32757},   {-867, -32757},   {-870, -32756},
    {-873, -32756},   {-876, -32756},   {-880, -32756},   {-883, -32756},   {-886, -32756},   {-889, -32756},
    {-892, -32756},   {-895, -32756},   {-898, -32756},   {-902, -32756},   {-905, -32756},   {-908, -32755},
    {-911, -32755},   {-914, -32755},   {-917, -32755},   {-920, -32755},   {-924, -32755},   {-927, -32755},
    {-930, -32755},   {-933, -32755},   {-936, -32755},   {-939, -32755},   {-942, -32754},   {-945, -32754},
    {-949, -32754},   {-952, -32754},   {-955, -32754},   {-958, -32754},   {-961, -32754},   {-964, -32754},
    {-967, -32754},   {-971, -32754},   {-974, -32754},   {-977, -32753},   {-980, -32753},   {-983, -32753},
    {-986, -32753},   {-989, -32753},   {-993, -32753},   {-996, -32753},   {-999, -32753},   {-1002, -32753},
    {-1005, -32753},  {-1008, -32752},  {-1011, -32752},  {-1015, -32752},  {-1018, -32752},  {-1021, -32752},
    {-1024, -32752},  {-1027, -32752},  {-1030, -32752},  {-1033, -32752},  {-1037, -32752},  {-1040, -32752},
    {-1043, -32751},  {-1046, -32751},  {-1049, -32751},  {-1052, -32751},  {-1055, -32751},  {-1059, -32751},
    {-1062, -32751},  {-1065, -32751},  {-1068, -32751},  {-1071, -32750},  {-1074, -32750},  {-1077, -32750},
    {-1081, -32750},  {-1084, -32750},  {-1087, -32750},  {-1090, -32750},  {-1093, -32750},  {-1096, -32750},
    {-1099, -32750},  {-1102, -32749},  {-1106, -32749},  {-1109, -32749},  {-1112, -32749},  {-1115, -32749},
    {-1118, -32749},  {-1121, -32749},  {-1124, -32749},  {-1128, -32749},  {-1131, -32748},  {-1134, -32748},
    {-1137, -32748},  {-1140, -32748},  {-1143, -32748},  {-1146, -32748},  {-1150, -32748},  {-1153, -32748},
    {-1156, -32748},  {-1159, -32747},  {-1162, -32747},  {-1165, -32747},  {-1168, -32747},  {-1172, -32747},
    {-1175, -32747},  {-1178, -32747},  {-1181, -32747},  {-1184, -32747},  {-1187, -32746},  {-1190, -32746},
    {-1194, -32746},  {-1197, -32746},  {-1200, -32746},  {-1203, -32746},  {-1206, -32746},  {-1209, -32746},
    {-1212, -32746},  {-1216, -32745},  {-1219, -32745},  {-1222, -32745},  {-1225, -32745},  {-1228, -32745},
    {-1231, -32745},  {-1234, -32745},  {-1237, -32745},  {-1241, -32745},  {-1244, -32744},  {-1247, -32744},
    {-1250, -32744},  {-1253, -32744},  {-1256, -32744},  {-1259, -32744},  {-1263, -32744},  {-1266, -32744},
    {-1269, -32743},  {-1272, -32743},  {-1275, -32743},  {-1278, -32743},  {-1281, -32743},  {-1285, -32743},
    {-1288, -32743},  {-1291, -32743},  {-1294, -32742},  {-1297, -32742},  {-1300, -32742},  {-1303, -32742},
    {-1307, -32742},  {-1310, -32742},  {-1313, -32742},  {-1316, -32742},  {-1319, -32741},  {-1322, -32741},
    {-1325, -32741},  {-1329, -32741},  {-1332, -32741},  {-1335, -32741},  {-1338, -32741},  {-1341, -32741},
    {-1344, -32740},  {-1347, -32740},  {-1351, -32740},  {-1354, -32740},  {-1357, -32740},  {-1360, -32740},
    {-1363, -32740},  {-1366, -32740},  {-1369, -32739},  {-1372, -32739},  {-1376, -32739},  {-1379, -32739},
    {-1382, -32739},  {-1385, -32739},  {-1388, -32739},  {-1391, -32738},  {-1394, -32738},  {-1398, -32738},
    {-1401, -32738},  {-1404, -32738},  {-1407, -32738},  {-1410, -32738},  {-1413, -32738},  {-1416, -32737},
    {-1420, -32737},  {-1423, -32737},  {-1426, -32737},  {-1429, -32737},  {-1432, -32737},  {-1435, -32737},
    {-1438, -32736},  {-1442, -32736},  {-1445, -32736},  {-1448, -32736},  {-1451, -32736},  {-1454, -32736},
    {-1457, -32736},  {-1460, -32735},  {-1463, -32735},  {-1467, -32735},  {-1470, -32735},  {-1473, -32735},
    {-1476, -32735},  {-1479, -32735},  {-1482, -32734},  {-1485, -32734},  {-1489, -32734},  {-1492, -32734},
    {-1495, -32734},  {-1498, -32734},  {-1501, -32734},  {-1504, -32733},  {-1507, -32733},  {-1511, -32733},
    {-1514, -32733},  {-1517, -32733},  {-1520, -32733},  {-1523, -32733},  {-1526, -32732},  {-1529, -32732},
    {-1533, -32732},  {-1536, -32732},  {-1539, -32732},  {-1542, -32732},  {-1545, -32732},  {-1548, -32731},
    {-1551, -32731},  {-1555, -32731},  {-1558, -32731},  {-1561, -32731},  {-1564, -32731},  {-1567, -32731},
    {-1570, -32730},  {-1573, -32730},  {-1576, -32730},  {-1580, -32730},  {-1583, -32730},  {-1586, -32730},
    {-1589, -32729},  {-1592, -32729},  {-1595, -32729},  {-1598, -32729},  {-1602, -32729},  {-1605, -32729},
    {-1608, -32729},  {-1611, -32728},  {-1614, -32728},  {-1617, -32728},  {-1620, -32728},  {-1624, -32728},
    {-1627, -32728},  {-1630, -32727},  {-1633, -32727},  {-1636, -32727},  {-1639, -32727},  {-1642, -32727},
    {-1646, -32727},  {-1649, -32727},  {-1652, -32726},  {-1655, -32726},  {-1658, -32726},  {-1661, -32726},
    {-1664, -32726},  {-1667, -32726},  {-1671, -32725},  {-1674, -32725},  {-1677, -32725},  {-1680, -32725},
    {-1683, -32725},  {-1686, -32725},  {-1689, -32724},  {-1693, -32724},  {-1696, -32724},  {-1699, -32724},
    {-1702, -32724},  {-1705, -32724},  {-1708, -32723},  {-1711, -32723},  {-1715, -32723},  {-1718, -32723},
    {-1721, -32723},  {-1724, -32723},  {-1727, -32722},  {-1730, -32722},  {-1733, -32722},  {-1736, -32722},
    {-1740, -32722},  {-1743, -32722},  {-1746, -32721},  {-1749, -32721},  {-1752, -32721},  {-1755, -32721},
    {-1758, -32721},  {-1762, -32721},  {-1765, -32720},  {-1768, -32720},  {-1771, -32720},  {-1774, -32720},
    {-1777, -32720},  {-1780, -32720},  {-1784, -32719},  {-1787, -32719},  {-1790, -32719},  {-1793, -32719},
    {-1796, -32719},  {-1799, -32719},  {-1802, -32718},  {-1806, -32718},  {-1809, -32718},  {-1812, -32718},
    {-1815, -32718},  {-1818, -32718},  {-1821, -32717},  {-1824, -32717},  {-1827, -32717},  {-1831, -32717},
    {-1834, -32717},  {-1837, -32716},  {-1840, -32716},  {-1843, -32716},  {-1846, -32716},  {-1849, -32716},
    {-1853, -32716},  {-1856, -32715},  {-1859, -32715},  {-1862, -32715},  {-1865, -32715},  {-1868, -32715},
    {-1871, -32715},  {-1875, -32714},  {-1878, -32714},  {-1881, -32714},  {-1884, -32714},  {-1887, -32714},
    {-1890, -32713},  {-1893, -32713},  {-1896, -32713},  {-1900, -32713},  {-1903, -32713},  {-1906, -32713},
    {-1909, -32712},  {-1912, -32712},  {-1915, -32712},  {-1918, -32712},  {-1922, -32712},  {-1925, -32711},
    {-1928, -32711},  {-1931, -32711},  {-1934, -32711},  {-1937, -32711},  {-1940, -32710},  {-1944, -32710},
    {-1947, -32710},  {-1950, -32710},  {-1953, -32710},  {-1956, -32710},  {-1959, -32709},  {-1962, -32709},
    {-1965, -32709},  {-1969, -32709},  {-1972, -32709},  {-1975, -32708},  {-1978, -32708},  {-1981, -32708},
    {-1984, -32708},  {-1987, -32708},  {-1991, -32707},  {-1994, -32707},  {-1997, -32707},  {-2000, -32707},
    {-2003, -32707},  {-2006, -32707},  {-2009, -32706},  {-2012, -32706},  {-2016, -32706},  {-2019, -32706},
    {-2022, -32706},  {-2025, -32705},  {-2028, -32705},  {-2031, -32705},  {-2034, -32705},  {-2038, -32705},
    {-2041, -32704},  {-2044, -32704},  {-2047, -32704},  {-2050, -32704},  {-2053, -32704},  {-2056, -32703},
    {-2060, -32703},  {-2063, -32703},  {-2066, -32703},  {-2069, -32703},  {-2072, -32702},  {-2075, -32702},
    {-2078, -32702},  {-2081, -32702},  {-2085, -32702},  {-2088, -32701},  {-2091, -32701},  {-2094, -32701},
    {-2097, -32701},  {-2100, -32701},  {-2103, -32700},  {-2107, -32700},  {-2110, -32700},  {-2113, -32700},
    {-2116, -32700},  {-2119, -32699},  {-2122, -32699},  {-2125, -32699},  {-2129, -32699},  {-2132, -32699},
    {-2135, -32698},  {-2138, -32698},  {-2141, -32698},  {-2144, -32698},  {-2147, -32698},  {-2150, -32697},
    {-2154, -32697},  {-2157, -32697},  {-2160, -32697},  {-2163, -32697},  {-2166, -32696},  {-2169, -32696},
    {-2172, -32696},  {-2176, -32696},  {-2179, -32695},  {-2182, -32695},  {-2185, -32695},  {-2188, -32695},
    {-2191, -32695},  {-2194, -32694},  {-2197, -32694},  {-2201, -32694},  {-2204, -32694},  {-2207, -32694},
    {-2210, -32693},  {-2213, -32693},  {-2216, -32693},  {-2219, -32693},  {-2223, -32693},  {-2226, -32692},
    {-2229, -32692},  {-2232, -32692},  {-2235, -32692},  {-2238, -32691},  {-2241, -32691},  {-2244, -32691},
    {-2248, -32691},  {-2251, -32691},  {-2254, -32690},  {-2257, -32690},  {-2260, -32690},  {-2263, -32690},
    {-2266, -32690},  {-2270, -32689},  {-2273, -32689},  {-2276, -32689},  {-2279, -32689},  {-2282, -32688},
    {-2285, -32688},  {-2288, -32688},  {-2291, -32688},  {-2295, -32688},  {-2298, -32687},  {-2301, -32687},
    {-2304, -32687},  {-2307, -32687},  {-2310, -32686},  {-2313, -32686},  {-2317, -32686},  {-2320, -32686},
    {-2323, -32686},  {-2326, -32685},  {-2329, -32685},  {-2332, -32685},  {-2335, -32685},  {-2338, -32684},
    {-2342, -32684},  {-2345, -32684},  {-2348, -32684},  {-2351, -32684},  {-2354, -32683},  {-2357, -32683},
    {-2360, -32683},  {-2364, -32683},  {-2367, -32682},  {-2370, -32682},  {-2373, -32682},  {-2376, -32682},
    {-2379, -32682},  {-2382, -32681},  {-2385, -32681},  {-2389, -32681},  {-2392, -32681},  {-2395, -32680},
    {-2398, -32680},  {-2401, -32680},  {-2404, -32680},  {-2407, -32679},  {-2411, -32679},  {-2414, -32679},
    {-2417, -32679},  {-2420, -32679},  {-2423, -32678},  {-2426, -32678},  {-2429, -32678},  {-2432, -32678},
    {-2436, -32677},  {-2439, -32677},  {-2442, -32677},  {-2445, -32677},  {-2448, -32676},  {-2451, -32676},
    {-2454, -32676},  {-2458, -32676},  {-2461, -32675},  {-2464, -32675},  {-2467, -32675},  {-2470, -32675},
    {-2473, -32675},  {-2476, -32674},  {-2479, -32674},  {-2483, -32674},  {-2486, -32674},  {-2489, -32673},
    {-2492, -32673},  {-2495, -32673},  {-2498, -32673},  {-2501, -32672},  {-2505, -32672},  {-2508, -32672},
    {-2511, -32672},  {-2514, -32671},  {-2517, -32671},  {-2520, -32671},  {-2523, -32671},  {-2526, -32670},
    {-2530, -32670},  {-2533, -32670},  {-2536, -32670},  {-2539, -32669},  {-2542, -32669},  {-2545, -32669},
    {-2548, -32669},  {-2552, -32669},  {-2555, -32668},  {-2558, -32668},  {-2561, -32668},  {-2564, -32668},
    {-2567, -32667},  {-2570, -32667},  {-2573, -32667},  {-2577, -32667},  {-2580, -32666},  {-2583, -32666},
    {-2586, -32666},  {-2589, -32666},  {-2592, -32665},  {-2595, -32665},  {-2599, -32665},  {-2602, -32665},
    {-2605, -32664},  {-2608, -32664},  {-2611, -32664},  {-2614, -32664},  {-2617, -32663},  {-2620, -32663},
    {-2624, -32663},  {-2627, -32663},  {-2630, -32662},  {-2633, -32662},  {-2636, -32662},  {-2639, -32662},
    {-2642, -32661},  {-2645, -32661},  {-2649, -32661},  {-2652, -32661},  {-2655, -32660},  {-2658, -32660},
    {-2661, -32660},  {-2664, -32660},  {-2667, -32659},  {-2671, -32659},  {-2674, -32659},  {-2677, -32658},
    {-2680, -32658},  {-2683, -32658},  {-2686, -32658},  {-2689, -32657},  {-2692, -32657},  {-2696, -32657},
    {-2699, -32657},  {-2702, -32656},  {-2705, -32656},  {-2708, -32656},  {-2711, -32656},  {-2714, -32655},
    {-2717, -32655},  {-2721, -32655},  {-2724, -32655},  {-2727, -32654},  {-2730, -32654},  {-2733, -32654},
    {-2736, -32654},  {-2739, -32653},  {-2743, -32653},  {-2746, -32653},  {-2749, -32653},  {-2752, -32652},
    {-2755, -32652},  {-2758, -32652},  {-2761, -32651},  {-2764, -32651},  {-2768, -32651},  {-2771, -32651},
    {-2774, -32650},  {-2777, -32650},  {-2780, -32650},  {-2783, -32650},  {-2786, -32649},  {-2789, -32649},
    {-2793, -32649},  {-2796, -32649},  {-2799, -32648},  {-2802, -32648},  {-2805, -32648},  {-2808, -32647},
    {-2811, -32647},  {-2815, -32647},  {-2818, -32647},  {-2821, -32646},  {-2824, -32646},  {-2827, -32646},
    {-2830, -32646},  {-2833, -32645},  {-2836, -32645},  {-2840, -32645},  {-2843, -32644},  {-2846, -32644},
    {-2849, -32644},  {-2852, -32644},  {-2855, -32643},  {-2858, -32643},  {-2861, -32643},  {-2865, -32643},
    {-2868, -32642},  {-2871, -32642},  {-2874, -32642},  {-2877, -32641},  {-2880, -32641},  {-2883, -32641},
    {-2887, -32641},  {-2890, -32640},  {-2893, -32640},  {-2896, -32640},  {-2899, -32640},  {-2902, -32639},
    {-2905, -32639},  {-2908, -32639},  {-2912, -32638},  {-2915, -32638},  {-2918, -32638},  {-2921, -32638},
    {-2924, -32637},  {-2927, -32637},  {-2930, -32637},  {-2933, -32636},  {-2937, -32636},  {-2940, -32636},
    {-2943, -32636},  {-2946, -32635},  {-2949, -32635},  {-2952, -32635},  {-2955, -32634},  {-2958, -32634},
    {-2962, -32634},  {-2965, -32634},  {-2968, -32633},  {-2971, -32633},  {-2974, -32633},  {-2977, -32632},
    {-2980, -32632},  {-2984, -32632},  {-2987, -32632},  {-2990, -32631},  {-2993, -32631},  {-2996, -32631},
    {-2999, -32630},  {-3002, -32630},  {-3005, -32630},  {-3009, -32630},  {-3012, -32629},  {-3015, -32629},
    {-3018, -32629},  {-3021, -32628},  {-3024, -32628},  {-3027, -32628},  {-3030, -32628},  {-3034, -32627},
    {-3037, -32627},  {-3040, -32627},  {-3043, -32626},  {-3046, -32626},  {-3049, -32626},  {-3052, -32626},
    {-3055, -32625},  {-3059, -32625},  {-3062, -32625},  {-3065, -32624},  {-3068, -32624},  {-3071, -32624},
    {-3074, -32623},  {-3077, -32623},  {-3080, -32623},  {-3084, -32623},  {-3087, -32622},  {-3090, -32622},
    {-3093, -32622},  {-3096, -32621},  {-3099, -32621},  {-3102, -32621},  {-3106, -32621},  {-3109, -32620},
    {-3112, -32620},  {-3115, -32620},  {-3118, -32619},  {-3121, -32619},  {-3124, -32619},  {-3127, -32618},
    {-3131, -32618},  {-3134, -32618},  {-3137, -32618},  {-3140, -32617},  {-3143, -32617},  {-3146, -32617},
    {-3149, -32616},  {-3152, -32616},  {-3156, -32616},  {-3159, -32615},  {-3162, -32615},  {-3165, -32615},
    {-3168, -32614},  {-3171, -32614},  {-3174, -32614},  {-3177, -32614},  {-3181, -32613},  {-3184, -32613},
    {-3187, -32613},  {-3190, -32612},  {-3193, -32612},  {-3196, -32612},  {-3199, -32611},  {-3202, -32611},
    {-3206, -32611},  {-3209, -32611},  {-3212, -32610},  {-3215, -32610},  {-3218, -32610},  {-3221, -32609},
    {-3224, -32609},  {-3227, -32609},  {-3231, -32608},  {-3234, -32608},  {-3237, -32608},  {-3240, -32607},
    {-3243, -32607},  {-3246, -32607},  {-3249, -32606},  {-3252, -32606},  {-3256, -32606},  {-3259, -32606},
    {-3262, -32605},  {-3265, -32605},  {-3268, -32605},  {-3271, -32604},  {-3274, -32604},  {-3277, -32604},
    {-3281, -32603},  {-3284, -32603},  {-3287, -32603},  {-3290, -32602},  {-3293, -32602},  {-3296, -32602},
    {-3299, -32601},  {-3302, -32601},  {-3306, -32601},  {-3309, -32601},  {-3312, -32600},  {-3315, -32600},
    {-3318, -32600},  {-3321, -32599},  {-3324, -32599},  {-3327, -32599},  {-3331, -32598},  {-3334, -32598},
    {-3337, -32598},  {-3340, -32597},  {-3343, -32597},  {-3346, -32597},  {-3349, -32596},  {-3352, -32596},
    {-3356, -32596},  {-3359, -32595},  {-3362, -32595},  {-3365, -32595},  {-3368, -32594},  {-3371, -32594},
    {-3374, -32594},  {-3377, -32593},  {-3381, -32593},  {-3384, -32593},  {-3387, -32592},  {-3390, -32592},
    {-3393, -32592},  {-3396, -32592},  {-3399, -32591},  {-3402, -32591},  {-3406, -32591},  {-3409, -32590},
    {-3412, -32590},  {-3415, -32590},  {-3418, -32589},  {-3421, -32589},  {-3424, -32589},  {-3427, -32588},
    {-3431, -32588},  {-3434, -32588},  {-3437, -32587},  {-3440, -32587},  {-3443, -32587},  {-3446, -32586},
    {-3449, -32586},  {-3452, -32586},  {-3456, -32585},  {-3459, -32585},  {-3462, -32585},  {-3465, -32584},
    {-3468, -32584},  {-3471, -32584},  {-3474, -32583},  {-3477, -32583},  {-3481, -32583},  {-3484, -32582},
    {-3487, -32582},  {-3490, -32582},  {-3493, -32581},  {-3496, -32581},  {-3499, -32581},  {-3502, -32580},
    {-3506, -32580},  {-3509, -32580},  {-3512, -32579},  {-3515, -32579},  {-3518, -32579},  {-3521, -32578},
    {-3524, -32578},  {-3527, -32578},  {-3531, -32577},  {-3534, -32577},  {-3537, -32577},  {-3540, -32576},
    {-3543, -32576},  {-3546, -32576},  {-3549, -32575},  {-3552, -32575},  {-3556, -32575},  {-3559, -32574},
    {-3562, -32574},  {-3565, -32574},  {-3568, -32573},  {-3571, -32573},  {-3574, -32572},  {-3577, -32572},
    {-3581, -32572},  {-3584, -32571},  {-3587, -32571},  {-3590, -32571},  {-3593, -32570},  {-3596, -32570},
    {-3599, -32570},  {-3602, -32569},  {-3606, -32569},  {-3609, -32569},  {-3612, -32568},  {-3615, -32568},
    {-3618, -32568},  {-3621, -32567},  {-3624, -32567},  {-3627, -32567},  {-3630, -32566},  {-3634, -32566},
    {-3637, -32566},  {-3640, -32565},  {-3643, -32565},  {-3646, -32565},  {-3649, -32564},  {-3652, -32564},
    {-3655, -32563},  {-3659, -32563},  {-3662, -32563},  {-3665, -32562},  {-3668, -32562},  {-3671, -32562},
    {-3674, -32561},  {-3677, -32561},  {-3680, -32561},  {-3684, -32560},  {-3687, -32560},  {-3690, -32560},
    {-3693, -32559},  {-3696, -32559},  {-3699, -32559},  {-3702, -32558},  {-3705, -32558},  {-3709, -32557},
    {-3712, -32557},  {-3715, -32557},  {-3718, -32556},  {-3721, -32556},  {-3724, -32556},  {-3727, -32555},
    {-3730, -32555},  {-3734, -32555},  {-3737, -32554},  {-3740, -32554},  {-3743, -32554},  {-3746, -32553},
    {-3749, -32553},  {-3752, -32552},  {-3755, -32552},  {-3758, -32552},  {-3762, -32551},  {-3765, -32551},
    {-3768, -32551},  {-3771, -32550},  {-3774, -32550},  {-3777, -32550},  {-3780, -32549},  {-3783, -32549},
    {-3787, -32548},  {-3790, -32548},  {-3793, -32548},  {-3796, -32547},  {-3799, -32547},  {-3802, -32547},
    {-3805, -32546},  {-3808, -32546},  {-3812, -32546},  {-3815, -32545},  {-3818, -32545},  {-3821, -32544},
    {-3824, -32544},  {-3827, -32544},  {-3830, -32543},  {-3833, -32543},  {-3836, -32543},  {-3840, -32542},
    {-3843, -32542},  {-3846, -32542},  {-3849, -32541},  {-3852, -32541},  {-3855, -32540},  {-3858, -32540},
    {-3861, -32540},  {-3865, -32539},  {-3868, -32539},  {-3871, -32539},  {-3874, -32538},  {-3877, -32538},
    {-3880, -32537},  {-3883, -32537},  {-3886, -32537},  {-3890, -32536},  {-3893, -32536},  {-3896, -32536},
    {-3899, -32535},  {-3902, -32535},  {-3905, -32534},  {-3908, -32534},  {-3911, -32534},  {-3914, -32533},
    {-3918, -32533},  {-3921, -32533},  {-3924, -32532},  {-3927, -32532},  {-3930, -32531},  {-3933, -32531},
    {-3936, -32531},  {-3939, -32530},  {-3943, -32530},  {-3946, -32530},  {-3949, -32529},  {-3952, -32529},
    {-3955, -32528},  {-3958, -32528},  {-3961, -32528},  {-3964, -32527},  {-3967, -32527},  {-3971, -32527},
    {-3974, -32526},  {-3977, -32526},  {-3980, -32525},  {-3983, -32525},  {-3986, -32525},  {-3989, -32524},
    {-3992, -32524},  {-3996, -32523},  {-3999, -32523},  {-4002, -32523},  {-4005, -32522},  {-4008, -32522},
    {-4011, -32522},  {-4014, -32521},  {-4017, -32521},  {-4021, -32520},  {-4024, -32520},  {-4027, -32520},
    {-4030, -32519},  {-4033, -32519},  {-4036, -32518},  {-4039, -32518},  {-4042, -32518},  {-4045, -32517},
    {-4049, -32517},  {-4052, -32517},  {-4055, -32516},  {-4058, -32516},  {-4061, -32515},  {-4064, -32515},
    {-4067, -32515},  {-4070, -32514},  {-4074, -32514},  {-4077, -32513},  {-4080, -32513},  {-4083, -32513},
    {-4086, -32512},  {-4089, -32512},  {-4092, -32511},  {-4095, -32511},  {-4098, -32511},  {-4102, -32510},
    {-4105, -32510},  {-4108, -32510},  {-4111, -32509},  {-4114, -32509},  {-4117, -32508},  {-4120, -32508},
    {-4123, -32508},  {-4126, -32507},  {-4130, -32507},  {-4133, -32506},  {-4136, -32506},  {-4139, -32506},
    {-4142, -32505},  {-4145, -32505},  {-4148, -32504},  {-4151, -32504},  {-4155, -32504},  {-4158, -32503},
    {-4161, -32503},  {-4164, -32502},  {-4167, -32502},  {-4170, -32502},  {-4173, -32501},  {-4176, -32501},
    {-4179, -32500},  {-4183, -32500},  {-4186, -32500},  {-4189, -32499},  {-4192, -32499},  {-4195, -32498},
    {-4198, -32498},  {-4201, -32498},  {-4204, -32497},  {-4208, -32497},  {-4211, -32496},  {-4214, -32496},
    {-4217, -32496},  {-4220, -32495},  {-4223, -32495},  {-4226, -32494},  {-4229, -32494},  {-4232, -32494},
    {-4236, -32493},  {-4239, -32493},  {-4242, -32492},  {-4245, -32492},  {-4248, -32491},  {-4251, -32491},
    {-4254, -32491},  {-4257, -32490},  {-4260, -32490},  {-4264, -32489},  {-4267, -32489},  {-4270, -32489},
    {-4273, -32488},  {-4276, -32488},  {-4279, -32487},  {-4282, -32487},  {-4285, -32487},  {-4289, -32486},
    {-4292, -32486},  {-4295, -32485},  {-4298, -32485},  {-4301, -32485},  {-4304, -32484},  {-4307, -32484},
    {-4310, -32483},  {-4313, -32483},  {-4317, -32482},  {-4320, -32482},  {-4323, -32482},  {-4326, -32481},
    {-4329, -32481},  {-4332, -32480},  {-4335, -32480},  {-4338, -32480},  {-4341, -32479},  {-4345, -32479},
    {-4348, -32478},  {-4351, -32478},  {-4354, -32477},  {-4357, -32477},  {-4360, -32477},  {-4363, -32476},
    {-4366, -32476},  {-4369, -32475},  {-4373, -32475},  {-4376, -32475},  {-4379, -32474},  {-4382, -32474},
    {-4385, -32473},  {-4388, -32473},  {-4391, -32472},  {-4394, -32472},  {-4397, -32472},  {-4401, -32471},
    {-4404, -32471},  {-4407, -32470},  {-4410, -32470},  {-4413, -32469},  {-4416, -32469},  {-4419, -32469},
    {-4422, -32468},  {-4426, -32468},  {-4429, -32467},  {-4432, -32467},  {-4435, -32467},  {-4438, -32466},
    {-4441, -32466},  {-4444, -32465},  {-4447, -32465},  {-4450, -32464},  {-4454, -32464},  {-4457, -32464},
    {-4460, -32463},  {-4463, -32463},  {-4466, -32462},  {-4469, -32462},  {-4472, -32461},  {-4475, -32461},
    {-4478, -32461},  {-4482, -32460},  {-4485, -32460},  {-4488, -32459},  {-4491, -32459},  {-4494, -32458},
    {-4497, -32458},  {-4500, -32458},  {-4503, -32457},  {-4506, -32457},  {-4510, -32456},  {-4513, -32456},
    {-4516, -32455},  {-4519, -32455},  {-4522, -32454},  {-4525, -32454},  {-4528, -32454},  {-4531, -32453},
    {-4534, -32453},  {-4538, -32452},  {-4541, -32452},  {-4544, -32451},  {-4547, -32451},  {-4550, -32451},
    {-4553, -32450},  {-4556, -32450},  {-4559, -32449},  {-4562, -32449},  {-4566, -32448},  {-4569, -32448},
    {-4572, -32448},  {-4575, -32447},  {-4578, -32447},  {-4581, -32446},  {-4584, -32446},  {-4587, -32445},
    {-4590, -32445},  {-4594, -32444},  {-4597, -32444},  {-4600, -32444},  {-4603, -32443},  {-4606, -32443},
    {-4609, -32442},  {-4612, -32442},  {-4615, -32441},  {-4618, -32441},  {-4622, -32440},  {-4625, -32440},
    {-4628, -32440},  {-4631, -32439},  {-4634, -32439},  {-4637, -32438},  {-4640, -32438},  {-4643, -32437},
    {-4646, -32437},  {-4650, -32436},  {-4653, -32436},  {-4656, -32436},  {-4659, -32435},  {-4662, -32435},
    {-4665, -32434},  {-4668, -32434},  {-4671, -32433},  {-4674, -32433},  {-4678, -32432},  {-4681, -32432},
    {-4684, -32432},  {-4687, -32431},  {-4690, -32431},  {-4693, -32430},  {-4696, -32430},  {-4699, -32429},
    {-4702, -32429},  {-4705, -32428},  {-4709, -32428},  {-4712, -32427},  {-4715, -32427},  {-4718, -32427},
    {-4721, -32426},  {-4724, -32426},  {-4727, -32425},  {-4730, -32425},  {-4733, -32424},  {-4737, -32424},
    {-4740, -32423},  {-4743, -32423},  {-4746, -32422},  {-4749, -32422},  {-4752, -32422},  {-4755, -32421},
    {-4758, -32421},  {-4761, -32420},  {-4765, -32420},  {-4768, -32419},  {-4771, -32419},  {-4774, -32418},
    {-4777, -32418},  {-4780, -32417},  {-4783, -32417},  {-4786, -32417},  {-4789, -32416},  {-4793, -32416},
    {-4796, -32415},  {-4799, -32415},  {-4802, -32414},  {-4805, -32414},  {-4808, -32413},  {-4811, -32413},
    {-4814, -32412},  {-4817, -32412},  {-4820, -32411},  {-4824, -32411},  {-4827, -32411},  {-4830, -32410},
    {-4833, -32410},  {-4836, -32409},  {-4839, -32409},  {-4842, -32408},  {-4845, -32408},  {-4848, -32407},
    {-4852, -32407},  {-4855, -32406},  {-4858, -32406},  {-4861, -32405},  {-4864, -32405},  {-4867, -32405},
    {-4870, -32404},  {-4873, -32404},  {-4876, -32403},  {-4880, -32403},  {-4883, -32402},  {-4886, -32402},
    {-4889, -32401},  {-4892, -32401},  {-4895, -32400},  {-4898, -32400},  {-4901, -32399},  {-4904, -32399},
    {-4907, -32398},  {-4911, -32398},  {-4914, -32397},  {-4917, -32397},  {-4920, -32397},  {-4923, -32396},
    {-4926, -32396},  {-4929, -32395},  {-4932, -32395},  {-4935, -32394},  {-4939, -32394},  {-4942, -32393},
    {-4945, -32393},  {-4948, -32392},  {-4951, -32392},  {-4954, -32391},  {-4957, -32391},  {-4960, -32390},
    {-4963, -32390},  {-4966, -32389},  {-4970, -32389},  {-4973, -32388},  {-4976, -32388},  {-4979, -32388},
    {-4982, -32387},  {-4985, -32387},  {-4988, -32386},  {-4991, -32386},  {-4994, -32385},  {-4998, -32385},
    {-5001, -32384},  {-5004, -32384},  {-5007, -32383},  {-5010, -32383},  {-5013, -32382},  {-5016, -32382},
    {-5019, -32381},  {-5022, -32381},  {-5025, -32380},  {-5029, -32380},  {-5032, -32379},  {-5035, -32379},
    {-5038, -32378},  {-5041, -32378},  {-5044, -32377},  {-5047, -32377},  {-5050, -32376},  {-5053, -32376},
    {-5057, -32376},  {-5060, -32375},  {-5063, -32375},  {-5066, -32374},  {-5069, -32374},  {-5072, -32373},
    {-5075, -32373},  {-5078, -32372},  {-5081, -32372},  {-5084, -32371},  {-5088, -32371},  {-5091, -32370},
    {-5094, -32370},  {-5097, -32369},  {-5100, -32369},  {-5103, -32368},  {-5106, -32368},  {-5109, -32367},
    {-5112, -32367},  {-5115, -32366},  {-5119, -32366},  {-5122, -32365},  {-5125, -32365},  {-5128, -32364},
    {-5131, -32364},  {-5134, -32363},  {-5137, -32363},  {-5140, -32362},  {-5143, -32362},  {-5147, -32361},
    {-5150, -32361},  {-5153, -32360},  {-5156, -32360},  {-5159, -32359},  {-5162, -32359},  {-5165, -32358},
    {-5168, -32358},  {-5171, -32357},  {-5174, -32357},  {-5178, -32356},  {-5181, -32356},  {-5184, -32355},
    {-5187, -32355},  {-5190, -32354},  {-5193, -32354},  {-5196, -32353},  {-5199, -32353},  {-5202, -32352},
    {-5205, -32352},  {-5209, -32351},  {-5212, -32351},  {-5215, -32350},  {-5218, -32350},  {-5221, -32349},
    {-5224, -32349},  {-5227, -32348},  {-5230, -32348},  {-5233, -32347},  {-5236, -32347},  {-5240, -32346},
    {-5243, -32346},  {-5246, -32345},  {-5249, -32345},  {-5252, -32344},  {-5255, -32344},  {-5258, -32343},
    {-5261, -32343},  {-5264, -32342},  {-5267, -32342},  {-5271, -32341},  {-5274, -32341},  {-5277, -32340},
    {-5280, -32340},  {-5283, -32339},  {-5286, -32339},  {-5289, -32338},  {-5292, -32338},  {-5295, -32337},
    {-5298, -32337},  {-5302, -32336},  {-5305, -32336},  {-5308, -32335},  {-5311, -32335},  {-5314, -32334},
    {-5317, -32334},  {-5320, -32333},  {-5323, -32333},  {-5326, -32332},  {-5329, -32332},  {-5333, -32331},
    {-5336, -32331},  {-5339, -32330},  {-5342, -32330},  {-5345, -32329},  {-5348, -32329},  {-5351, -32328},
    {-5354, -32328},  {-5357, -32327},  {-5360, -32327},  {-5364, -32326},  {-5367, -32326},  {-5370, -32325},
    {-5373, -32325},  {-5376, -32324},  {-5379, -32323},  {-5382, -32323},  {-5385, -32322},  {-5388, -32322},
    {-5391, -32321},  {-5395, -32321},  {-5398, -32320},  {-5401, -32320},  {-5404, -32319},  {-5407, -32319},
    {-5410, -32318},  {-5413, -32318},  {-5416, -32317},  {-5419, -32317},  {-5422, -32316},  {-5426, -32316},
    {-5429, -32315},  {-5432, -32315},  {-5435, -32314},  {-5438, -32314},  {-5441, -32313},  {-5444, -32313},
    {-5447, -32312},  {-5450, -32312},  {-5453, -32311},  {-5457, -32310},  {-5460, -32310},  {-5463, -32309},
    {-5466, -32309},  {-5469, -32308},  {-5472, -32308},  {-5475, -32307},  {-5478, -32307},  {-5481, -32306},
    {-5484, -32306},  {-5488, -32305},  {-5491, -32305},  {-5494, -32304},  {-5497, -32304},  {-5500, -32303},
    {-5503, -32303},  {-5506, -32302},  {-5509, -32302},  {-5512, -32301},  {-5515, -32301},  {-5518, -32300},
    {-5522, -32299},  {-5525, -32299},  {-5528, -32298},  {-5531, -32298},  {-5534, -32297},  {-5537, -32297},
    {-5540, -32296},  {-5543, -32296},  {-5546, -32295},  {-5549, -32295},  {-5553, -32294},  {-5556, -32294},
    {-5559, -32293},  {-5562, -32293},  {-5565, -32292},  {-5568, -32291},  {-5571, -32291},  {-5574, -32290},
    {-5577, -32290},  {-5580, -32289},  {-5584, -32289},  {-5587, -32288},  {-5590, -32288},  {-5593, -32287},
    {-5596, -32287},  {-5599, -32286},  {-5602, -32286},  {-5605, -32285},  {-5608, -32285},  {-5611, -32284},
    {-5614, -32283},  {-5618, -32283},  {-5621, -32282},  {-5624, -32282},  {-5627, -32281},  {-5630, -32281},
    {-5633, -32280},  {-5636, -32280},  {-5639, -32279},  {-5642, -32279},  {-5645, -32278},  {-5649, -32277},
    {-5652, -32277},  {-5655, -32276},  {-5658, -32276},  {-5661, -32275},  {-5664, -32275},  {-5667, -32274},
    {-5670, -32274},  {-5673, -32273},  {-5676, -32273},  {-5679, -32272},  {-5683, -32272},  {-5686, -32271},
    {-5689, -32270},  {-5692, -32270},  {-5695, -32269},  {-5698, -32269},  {-5701, -32268},  {-5704, -32268},
    {-5707, -32267},  {-5710, -32267},  {-5713, -32266},  {-5717, -32266},  {-5720, -32265},  {-5723, -32264},
    {-5726, -32264},  {-5729, -32263},  {-5732, -32263},  {-5735, -32262},  {-5738, -32262},  {-5741, -32261},
    {-5744, -32261},  {-5748, -32260},  {-5751, -32259},  {-5754, -32259},  {-5757, -32258},  {-5760, -32258},
    {-5763, -32257},  {-5766, -32257},  {-5769, -32256},  {-5772, -32256},  {-5775, -32255},  {-5778, -32254},
    {-5782, -32254},  {-5785, -32253},  {-5788, -32253},  {-5791, -32252},  {-5794, -32252},  {-5797, -32251},
    {-5800, -32251},  {-5803, -32250},  {-5806, -32249},  {-5809, -32249},  {-5812, -32248},  {-5816, -32248},
    {-5819, -32247},  {-5822, -32247},  {-5825, -32246},  {-5828, -32246},  {-5831, -32245},  {-5834, -32244},
    {-5837, -32244},  {-5840, -32243},  {-5843, -32243},  {-5846, -32242},  {-5850, -32242},  {-5853, -32241},
    {-5856, -32241},  {-5859, -32240},  {-5862, -32239},  {-5865, -32239},  {-5868, -32238},  {-5871, -32238},
    {-5874, -32237},  {-5877, -32237},  {-5880, -32236},  {-5884, -32235},  {-5887, -32235},  {-5890, -32234},
    {-5893, -32234},  {-5896, -32233},  {-5899, -32233},  {-5902, -32232},  {-5905, -32232},  {-5908, -32231},
    {-5911, -32230},  {-5914, -32230},  {-5918, -32229},  {-5921, -32229},  {-5924, -32228},  {-5927, -32228},
    {-5930, -32227},  {-5933, -32226},  {-5936, -32226},  {-5939, -32225},  {-5942, -32225},  {-5945, -32224},
    {-5948, -32224},  {-5952, -32223},  {-5955, -32222},  {-5958, -32222},  {-5961, -32221},  {-5964, -32221},
    {-5967, -32220},  {-5970, -32220},  {-5973, -32219},  {-5976, -32218},  {-5979, -32218},  {-5982, -32217},
    {-5985, -32217},  {-5989, -32216},  {-5992, -32216},  {-5995, -32215},  {-5998, -32214},  {-6001, -32214},
    {-6004, -32213},  {-6007, -32213},  {-6010, -32212},  {-6013, -32212},  {-6016, -32211},  {-6019, -32210},
    {-6023, -32210},  {-6026, -32209},  {-6029, -32209},  {-6032, -32208},  {-6035, -32207},  {-6038, -32207},
    {-6041, -32206},  {-6044, -32206},  {-6047, -32205},  {-6050, -32205},  {-6053, -32204},  {-6057, -32203},
    {-6060, -32203},  {-6063, -32202},  {-6066, -32202},  {-6069, -32201},  {-6072, -32201},  {-6075, -32200},
    {-6078, -32199},  {-6081, -32199},  {-6084, -32198},  {-6087, -32198},  {-6090, -32197},  {-6094, -32196},
    {-6097, -32196},  {-6100, -32195},  {-6103, -32195},  {-6106, -32194},  {-6109, -32194},  {-6112, -32193},
    {-6115, -32192},  {-6118, -32192},  {-6121, -32191},  {-6124, -32191},  {-6128, -32190},  {-6131, -32189},
    {-6134, -32189},  {-6137, -32188},  {-6140, -32188},  {-6143, -32187},  {-6146, -32186},  {-6149, -32186},
    {-6152, -32185},  {-6155, -32185},  {-6158, -32184},  {-6161, -32184},  {-6165, -32183},  {-6168, -32182},
    {-6171, -32182},  {-6174, -32181},  {-6177, -32181},  {-6180, -32180},  {-6183, -32179},  {-6186, -32179},
    {-6189, -32178},  {-6192, -32178},  {-6195, -32177},  {-6198, -32176},  {-6202, -32176},  {-6205, -32175},
    {-6208, -32175},  {-6211, -32174},  {-6214, -32173},  {-6217, -32173},  {-6220, -32172},  {-6223, -32172},
    {-6226, -32171},  {-6229, -32170},  {-6232, -32170},  {-6236, -32169},  {-6239, -32169},  {-6242, -32168},
    {-6245, -32167},  {-6248, -32167},  {-6251, -32166},  {-6254, -32166},  {-6257, -32165},  {-6260, -32164},
    {-6263, -32164},  {-6266, -32163},  {-6269, -32163},  {-6273, -32162},  {-6276, -32161},  {-6279, -32161},
    {-6282, -32160},  {-6285, -32160},  {-6288, -32159},  {-6291, -32158},  {-6294, -32158},  {-6297, -32157},
    {-6300, -32157},  {-6303, -32156},  {-6306, -32155},  {-6310, -32155},  {-6313, -32154},  {-6316, -32154},
    {-6319, -32153},  {-6322, -32152},  {-6325, -32152},  {-6328, -32151},  {-6331, -32151},  {-6334, -32150},
    {-6337, -32149},  {-6340, -32149},  {-6343, -32148},  {-6346, -32148},  {-6350, -32147},  {-6353, -32146},
    {-6356, -32146},  {-6359, -32145},  {-6362, -32144},  {-6365, -32144},  {-6368, -32143},  {-6371, -32143},
    {-6374, -32142},  {-6377, -32141},  {-6380, -32141},  {-6383, -32140},  {-6387, -32140},  {-6390, -32139},
    {-6393, -32138},  {-6396, -32138},  {-6399, -32137},  {-6402, -32137},  {-6405, -32136},  {-6408, -32135},
    {-6411, -32135},  {-6414, -32134},  {-6417, -32133},  {-6420, -32133},  {-6424, -32132},  {-6427, -32132},
    {-6430, -32131},  {-6433, -32130},  {-6436, -32130},  {-6439, -32129},  {-6442, -32129},  {-6445, -32128},
    {-6448, -32127},  {-6451, -32127},  {-6454, -32126},  {-6457, -32125},  {-6460, -32125},  {-6464, -32124},
    {-6467, -32124},  {-6470, -32123},  {-6473, -32122},  {-6476, -32122},  {-6479, -32121},  {-6482, -32120},
    {-6485, -32120},  {-6488, -32119},  {-6491, -32119},  {-6494, -32118},  {-6497, -32117},  {-6501, -32117},
    {-6504, -32116},  {-6507, -32115},  {-6510, -32115},  {-6513, -32114},  {-6516, -32114},  {-6519, -32113},
    {-6522, -32112},  {-6525, -32112},  {-6528, -32111},  {-6531, -32110},  {-6534, -32110},  {-6537, -32109},
    {-6541, -32109},  {-6544, -32108},  {-6547, -32107},  {-6550, -32107},  {-6553, -32106},  {-6556, -32105},
    {-6559, -32105},  {-6562, -32104},  {-6565, -32104},  {-6568, -32103},  {-6571, -32102},  {-6574, -32102},
    {-6577, -32101},  {-6581, -32100},  {-6584, -32100},  {-6587, -32099},  {-6590, -32099},  {-6593, -32098},
    {-6596, -32097},  {-6599, -32097},  {-6602, -32096},  {-6605, -32095},  {-6608, -32095},  {-6611, -32094},
    {-6614, -32093},  {-6617, -32093},  {-6621, -32092},  {-6624, -32092},  {-6627, -32091},  {-6630, -32090},
    {-6633, -32090},  {-6636, -32089},  {-6639, -32088},  {-6642, -32088},  {-6645, -32087},  {-6648, -32086},
    {-6651, -32086},  {-6654, -32085},  {-6657, -32085},  {-6661, -32084},  {-6664, -32083},  {-6667, -32083},
    {-6670, -32082},  {-6673, -32081},  {-6676, -32081},  {-6679, -32080},  {-6682, -32079},  {-6685, -32079},
    {-6688, -32078},  {-6691, -32078},  {-6694, -32077},  {-6697, -32076},  {-6701, -32076},  {-6704, -32075},
    {-6707, -32074},  {-6710, -32074},  {-6713, -32073},  {-6716, -32072},  {-6719, -32072},  {-6722, -32071},
    {-6725, -32070},  {-6728, -32070},  {-6731, -32069},  {-6734, -32069},  {-6737, -32068},  {-6741, -32067},
    {-6744, -32067},  {-6747, -32066},  {-6750, -32065},  {-6753, -32065},  {-6756, -32064},  {-6759, -32063},
    {-6762, -32063},  {-6765, -32062},  {-6768, -32061},  {-6771, -32061},  {-6774, -32060},  {-6777, -32059},
    {-6780, -32059},  {-6784, -32058},  {-6787, -32058},  {-6790, -32057},  {-6793, -32056},  {-6796, -32056},
    {-6799, -32055},  {-6802, -32054},  {-6805, -32054},  {-6808, -32053},  {-6811, -32052},  {-6814, -32052},
    {-6817, -32051},  {-6820, -32050},  {-6824, -32050},  {-6827, -32049},  {-6830, -32048},  {-6833, -32048},
    {-6836, -32047},  {-6839, -32046},  {-6842, -32046},  {-6845, -32045},  {-6848, -32044},  {-6851, -32044},
    {-6854, -32043},  {-6857, -32042},  {-6860, -32042},  {-6863, -32041},  {-6867, -32040},  {-6870, -32040},
    {-6873, -32039},  {-6876, -32039},  {-6879, -32038},  {-6882, -32037},  {-6885, -32037},  {-6888, -32036},
    {-6891, -32035},  {-6894, -32035},  {-6897, -32034},  {-6900, -32033},  {-6903, -32033},  {-6906, -32032},
    {-6910, -32031},  {-6913, -32031},  {-6916, -32030},  {-6919, -32029},  {-6922, -32029},  {-6925, -32028},
    {-6928, -32027},  {-6931, -32027},  {-6934, -32026},  {-6937, -32025},  {-6940, -32025},  {-6943, -32024},
    {-6946, -32023},  {-6949, -32023},  {-6953, -32022},  {-6956, -32021},  {-6959, -32021},  {-6962, -32020},
    {-6965, -32019},  {-6968, -32019},  {-6971, -32018},  {-6974, -32017},  {-6977, -32017},  {-6980, -32016},
    {-6983, -32015},  {-6986, -32015},  {-6989, -32014},  {-6992, -32013},  {-6995, -32013},  {-6999, -32012},
    {-7002, -32011},  {-7005, -32011},  {-7008, -32010},  {-7011, -32009},  {-7014, -32009},  {-7017, -32008},
    {-7020, -32007},  {-7023, -32007},  {-7026, -32006},  {-7029, -32005},  {-7032, -32005},  {-7035, -32004},
    {-7038, -32003},  {-7042, -32002},  {-7045, -32002},  {-7048, -32001},  {-7051, -32000},  {-7054, -32000},
    {-7057, -31999},  {-7060, -31998},  {-7063, -31998},  {-7066, -31997},  {-7069, -31996},  {-7072, -31996},
    {-7075, -31995},  {-7078, -31994},  {-7081, -31994},  {-7084, -31993},  {-7088, -31992},  {-7091, -31992},
    {-7094, -31991},  {-7097, -31990},  {-7100, -31990},  {-7103, -31989},  {-7106, -31988},  {-7109, -31988},
    {-7112, -31987},  {-7115, -31986},  {-7118, -31986},  {-7121, -31985},  {-7124, -31984},  {-7127, -31983},
    {-7130, -31983},  {-7134, -31982},  {-7137, -31981},  {-7140, -31981},  {-7143, -31980},  {-7146, -31979},
    {-7149, -31979},  {-7152, -31978},  {-7155, -31977},  {-7158, -31977},  {-7161, -31976},  {-7164, -31975},
    {-7167, -31975},  {-7170, -31974},  {-7173, -31973},  {-7176, -31972},  {-7180, -31972},  {-7183, -31971},
    {-7186, -31970},  {-7189, -31970},  {-7192, -31969},  {-7195, -31968},  {-7198, -31968},  {-7201, -31967},
    {-7204, -31966},  {-7207, -31966},  {-7210, -31965},  {-7213, -31964},  {-7216, -31964},  {-7219, -31963},
    {-7222, -31962},  {-7225, -31961},  {-7229, -31961},  {-7232, -31960},  {-7235, -31959},  {-7238, -31959},
    {-7241, -31958},  {-7244, -31957},  {-7247, -31957},  {-7250, -31956},  {-7253, -31955},  {-7256, -31955},
    {-7259, -31954},  {-7262, -31953},  {-7265, -31952},  {-7268, -31952},  {-7271, -31951},  {-7275, -31950},
    {-7278, -31950},  {-7281, -31949},  {-7284, -31948},  {-7287, -31948},  {-7290, -31947},  {-7293, -31946},
    {-7296, -31945},  {-7299, -31945},  {-7302, -31944},  {-7305, -31943},  {-7308, -31943},  {-7311, -31942},
    {-7314, -31941},  {-7317, -31941},  {-7320, -31940},  {-7324, -31939},  {-7327, -31938},  {-7330, -31938},
    {-7333, -31937},  {-7336, -31936},  {-7339, -31936},  {-7342, -31935},  {-7345, -31934},  {-7348, -31934},
    {-7351, -31933},  {-7354, -31932},  {-7357, -31931},  {-7360, -31931},  {-7363, -31930},  {-7366, -31929},
    {-7369, -31929},  {-7372, -31928},  {-7376, -31927},  {-7379, -31926},  {-7382, -31926},  {-7385, -31925},
    {-7388, -31924},  {-7391, -31924},  {-7394, -31923},  {-7397, -31922},  {-7400, -31921},  {-7403, -31921},
    {-7406, -31920},  {-7409, -31919},  {-7412, -31919},  {-7415, -31918},  {-7418, -31917},  {-7421, -31917},
    {-7425, -31916},  {-7428, -31915},  {-7431, -31914},  {-7434, -31914},  {-7437, -31913},  {-7440, -31912},
    {-7443, -31912},  {-7446, -31911},  {-7449, -31910},  {-7452, -31909},  {-7455, -31909},  {-7458, -31908},
    {-7461, -31907},  {-7464, -31907},  {-7467, -31906},  {-7470, -31905},  {-7473, -31904},  {-7477, -31904},
    {-7480, -31903},  {-7483, -31902},  {-7486, -31902},  {-7489, -31901},  {-7492, -31900},  {-7495, -31899},
    {-7498, -31899},  {-7501, -31898},  {-7504, -31897},  {-7507, -31896},  {-7510, -31896},  {-7513, -31895},
    {-7516, -31894},  {-7519, -31894},  {-7522, -31893},  {-7525, -31892},  {-7529, -31891},  {-7532, -31891},
    {-7535, -31890},  {-7538, -31889},  {-7541, -31889},  {-7544, -31888},  {-7547, -31887},  {-7550, -31886},
    {-7553, -31886},  {-7556, -31885},  {-7559, -31884},  {-7562, -31883},  {-7565, -31883},  {-7568, -31882},
    {-7571, -31881},  {-7574, -31881},  {-7577, -31880},  {-7580, -31879},  {-7584, -31878},  {-7587, -31878},
    {-7590, -31877},  {-7593, -31876},  {-7596, -31875},  {-7599, -31875},  {-7602, -31874},  {-7605, -31873},
    {-7608, -31873},  {-7611, -31872},  {-7614, -31871},  {-7617, -31870},  {-7620, -31870},  {-7623, -31869},
    {-7626, -31868},  {-7629, -31867},  {-7632, -31867},  {-7635, -31866},  {-7639, -31865},  {-7642, -31865},
    {-7645, -31864},  {-7648, -31863},  {-7651, -31862},  {-7654, -31862},  {-7657, -31861},  {-7660, -31860},
    {-7663, -31859},  {-7666, -31859},  {-7669, -31858},  {-7672, -31857},  {-7675, -31856},  {-7678, -31856},
    {-7681, -31855},  {-7684, -31854},  {-7687, -31854},  {-7690, -31853},  {-7694, -31852},  {-7697, -31851},
    {-7700, -31851},  {-7703, -31850},  {-7706, -31849},  {-7709, -31848},  {-7712, -31848},  {-7715, -31847},
    {-7718, -31846},  {-7721, -31845},  {-7724, -31845},  {-7727, -31844},  {-7730, -31843},  {-7733, -31842},
    {-7736, -31842},  {-7739, -31841},  {-7742, -31840},  {-7745, -31839},  {-7748, -31839},  {-7752, -31838},
    {-7755, -31837},  {-7758, -31836},  {-7761, -31836},  {-7764, -31835},  {-7767, -31834},  {-7770, -31833},
    {-7773, -31833},  {-7776, -31832},  {-7779, -31831},  {-7782, -31831},  {-7785, -31830},  {-7788, -31829},
    {-7791, -31828},  {-7794, -31828},  {-7797, -31827},  {-7800, -31826},  {-7803, -31825},  {-7806, -31825},
    {-7810, -31824},  {-7813, -31823},  {-7816, -31822},  {-7819, -31822},  {-7822, -31821},  {-7825, -31820},
    {-7828, -31819},  {-7831, -31819},  {-7834, -31818},  {-7837, -31817},  {-7840, -31816},  {-7843, -31816},
    {-7846, -31815},  {-7849, -31814},  {-7852, -31813},  {-7855, -31813},  {-7858, -31812},  {-7861, -31811},
    {-7864, -31810},  {-7867, -31810},  {-7871, -31809},  {-7874, -31808},  {-7877, -31807},  {-7880, -31806},
    {-7883, -31806},  {-7886, -31805},  {-7889, -31804},  {-7892, -31803},  {-7895, -31803},  {-7898, -31802},
    {-7901, -31801},  {-7904, -31800},  {-7907, -31800},  {-7910, -31799},  {-7913, -31798},  {-7916, -31797},
    {-7919, -31797},  {-7922, -31796},  {-7925, -31795},  {-7928, -31794},  {-7931, -31794},  {-7935, -31793},
    {-7938, -31792},  {-7941, -31791},  {-7944, -31791},  {-7947, -31790},  {-7950, -31789},  {-7953, -31788},
    {-7956, -31788},  {-7959, -31787},  {-7962, -31786},  {-7965, -31785},  {-7968, -31784},  {-7971, -31784},
    {-7974, -31783},  {-7977, -31782},  {-7980, -31781},  {-7983, -31781},  {-7986, -31780},  {-7989, -31779},
    {-7992, -31778},  {-7995, -31778},  {-7999, -31777},  {-8002, -31776},  {-8005, -31775},  {-8008, -31775},
    {-8011, -31774},  {-8014, -31773},  {-8017, -31772},  {-8020, -31771},  {-8023, -31771},  {-8026, -31770},
    {-8029, -31769},  {-8032, -31768},  {-8035, -31768},  {-8038, -31767},  {-8041, -31766},  {-8044, -31765},
    {-8047, -31764},  {-8050, -31764},  {-8053, -31763},  {-8056, -31762},  {-8059, -31761},  {-8063, -31761},
    {-8066, -31760},  {-8069, -31759},  {-8072, -31758},  {-8075, -31758},  {-8078, -31757},  {-8081, -31756},
    {-8084, -31755},  {-8087, -31754},  {-8090, -31754},  {-8093, -31753},  {-8096, -31752},  {-8099, -31751},
    {-8102, -31751},  {-8105, -31750},  {-8108, -31749},  {-8111, -31748},  {-8114, -31747},  {-8117, -31747},
    {-8120, -31746},  {-8123, -31745},  {-8126, -31744},  {-8129, -31744},  {-8133, -31743},  {-8136, -31742},
    {-8139, -31741},  {-8142, -31740},  {-8145, -31740},  {-8148, -31739},  {-8151, -31738},  {-8154, -31737},
    {-8157, -31737},  {-8160, -31736},  {-8163, -31735},  {-8166, -31734},  {-8169, -31733},  {-8172, -31733},
    {-8175, -31732},  {-8178, -31731},  {-8181, -31730},  {-8184, -31729},  {-8187, -31729},  {-8190, -31728},
    {-8193, -31727},  {-8196, -31726},  {-8199, -31726},  {-8202, -31725},  {-8206, -31724},  {-8209, -31723},
    {-8212, -31722},  {-8215, -31722},  {-8218, -31721},  {-8221, -31720},  {-8224, -31719},  {-8227, -31718},
    {-8230, -31718},  {-8233, -31717},  {-8236, -31716},  {-8239, -31715},  {-8242, -31715},  {-8245, -31714},
    {-8248, -31713},  {-8251, -31712},  {-8254, -31711},  {-8257, -31711},  {-8260, -31710},  {-8263, -31709},
    {-8266, -31708},  {-8269, -31707},  {-8272, -31707},  {-8275, -31706},  {-8279, -31705},  {-8282, -31704},
    {-8285, -31703},  {-8288, -31703},  {-8291, -31702},  {-8294, -31701},  {-8297, -31700},  {-8300, -31699},
    {-8303, -31699},  {-8306, -31698},  {-8309, -31697},  {-8312, -31696},  {-8315, -31695},  {-8318, -31695},
    {-8321, -31694},  {-8324, -31693},  {-8327, -31692},  {-8330, -31691},  {-8333, -31691},  {-8336, -31690},
    {-8339, -31689},  {-8342, -31688},  {-8345, -31687},  {-8348, -31687},  {-8351, -31686},  {-8354, -31685},
    {-8358, -31684},  {-8361, -31683},  {-8364, -31683},  {-8367, -31682},  {-8370, -31681},  {-8373, -31680},
    {-8376, -31679},  {-8379, -31679},  {-8382, -31678},  {-8385, -31677},  {-8388, -31676},  {-8391, -31675},
    {-8394, -31675},  {-8397, -31674},  {-8400, -31673},  {-8403, -31672},  {-8406, -31671},  {-8409, -31671},
    {-8412, -31670},  {-8415, -31669},  {-8418, -31668},  {-8421, -31667},  {-8424, -31667},  {-8427, -31666},
    {-8430, -31665},  {-8433, -31664},  {-8436, -31663},  {-8440, -31663},  {-8443, -31662},  {-8446, -31661},
    {-8449, -31660},  {-8452, -31659},  {-8455, -31658},  {-8458, -31658},  {-8461, -31657},  {-8464, -31656},
    {-8467, -31655},  {-8470, -31654},  {-8473, -31654},  {-8476, -31653},  {-8479, -31652},  {-8482, -31651},
    {-8485, -31650},  {-8488, -31650},  {-8491, -31649},  {-8494, -31648},  {-8497, -31647},  {-8500, -31646},
    {-8503, -31645},  {-8506, -31645},  {-8509, -31644},  {-8512, -31643},  {-8515, -31642},  {-8518, -31641},
    {-8521, -31641},  {-8524, -31640},  {-8528, -31639},  {-8531, -31638},  {-8534, -31637},  {-8537, -31637},
    {-8540, -31636},  {-8543, -31635},  {-8546, -31634},  {-8549, -31633},  {-8552, -31632},  {-8555, -31632},
    {-8558, -31631},  {-8561, -31630},  {-8564, -31629},  {-8567, -31628},  {-8570, -31627},  {-8573, -31627},
    {-8576, -31626},  {-8579, -31625},  {-8582, -31624},  {-8585, -31623},  {-8588, -31623},  {-8591, -31622},
    {-8594, -31621},  {-8597, -31620},  {-8600, -31619},  {-8603, -31618},  {-8606, -31618},  {-8609, -31617},
    {-8612, -31616},  {-8615, -31615},  {-8618, -31614},  {-8621, -31613},  {-8625, -31613},  {-8628, -31612},
    {-8631, -31611},  {-8634, -31610},  {-8637, -31609},  {-8640, -31609},  {-8643, -31608},  {-8646, -31607},
    {-8649, -31606},  {-8652, -31605},  {-8655, -31604},  {-8658, -31604},  {-8661, -31603},  {-8664, -31602},
    {-8667, -31601},  {-8670, -31600},  {-8673, -31599},  {-8676, -31599},  {-8679, -31598},  {-8682, -31597},
    {-8685, -31596},  {-8688, -31595},  {-8691, -31594},  {-8694, -31594},  {-8697, -31593},  {-8700, -31592},
    {-8703, -31591},  {-8706, -31590},  {-8709, -31589},  {-8712, -31589},  {-8715, -31588},  {-8718, -31587},
    {-8721, -31586},  {-8725, -31585},  {-8728, -31584},  {-8731, -31584},  {-8734, -31583},  {-8737, -31582},
    {-8740, -31581},  {-8743, -31580},  {-8746, -31579},  {-8749, -31578},  {-8752, -31578},  {-8755, -31577},
    {-8758, -31576},  {-8761, -31575},  {-8764, -31574},  {-8767, -31573},  {-8770, -31573},  {-8773, -31572},
    {-8776, -31571},  {-8779, -31570},  {-8782, -31569},  {-8785, -31568},  {-8788, -31568},  {-8791, -31567},
    {-8794, -31566},  {-8797, -31565},  {-8800, -31564},  {-8803, -31563},  {-8806, -31563},  {-8809, -31562},
    {-8812, -31561},  {-8815, -31560},  {-8818, -31559},  {-8821, -31558},  {-8824, -31557},  {-8827, -31557},
    {-8830, -31556},  {-8833, -31555},  {-8836, -31554},  {-8840, -31553},  {-8843, -31552},  {-8846, -31552},
    {-8849, -31551},  {-8852, -31550},  {-8855, -31549},  {-8858, -31548},  {-8861, -31547},  {-8864, -31546},
    {-8867, -31546},  {-8870, -31545},  {-8873, -31544},  {-8876, -31543},  {-8879, -31542},  {-8882, -31541},
    {-8885, -31540},  {-8888, -31540},  {-8891, -31539},  {-8894, -31538},  {-8897, -31537},  {-8900, -31536},
    {-8903, -31535},  {-8906, -31534},  {-8909, -31534},  {-8912, -31533},  {-8915, -31532},  {-8918, -31531},
    {-8921, -31530},  {-8924, -31529},  {-8927, -31529},  {-8930, -31528},  {-8933, -31527},  {-8936, -31526},
    {-8939, -31525},  {-8942, -31524},  {-8945, -31523},  {-8948, -31523},  {-8951, -31522},  {-8954, -31521},
    {-8957, -31520},  {-8960, -31519},  {-8963, -31518},  {-8967, -31517},  {-8970, -31516},  {-8973, -31516},
    {-8976, -31515},  {-8979, -31514},  {-8982, -31513},  {-8985, -31512},  {-8988, -31511},  {-8991, -31510},
    {-8994, -31510},  {-8997, -31509},  {-9000, -31508},  {-9003, -31507},  {-9006, -31506},  {-9009, -31505},
    {-9012, -31504},  {-9015, -31504},  {-9018, -31503},  {-9021, -31502},  {-9024, -31501},  {-9027, -31500},
    {-9030, -31499},  {-9033, -31498},  {-9036, -31498},  {-9039, -31497},  {-9042, -31496},  {-9045, -31495},
    {-9048, -31494},  {-9051, -31493},  {-9054, -31492},  {-9057, -31491},  {-9060, -31491},  {-9063, -31490},
    {-9066, -31489},  {-9069, -31488},  {-9072, -31487},  {-9075, -31486},  {-9078, -31485},  {-9081, -31484},
    {-9084, -31484},  {-9087, -31483},  {-9090, -31482},  {-9093, -31481},  {-9096, -31480},  {-9099, -31479},
    {-9102, -31478},  {-9105, -31478},  {-9108, -31477},  {-9111, -31476},  {-9114, -31475},  {-9117, -31474},
    {-9120, -31473},  {-9124, -31472},  {-9127, -31471},  {-9130, -31471},  {-9133, -31470},  {-9136, -31469},
    {-9139, -31468},  {-9142, -31467},  {-9145, -31466},  {-9148, -31465},  {-9151, -31464},  {-9154, -31464},
    {-9157, -31463},  {-9160, -31462},  {-9163, -31461},  {-9166, -31460},  {-9169, -31459},  {-9172, -31458},
    {-9175, -31457},  {-9178, -31456},  {-9181, -31456},  {-9184, -31455},  {-9187, -31454},  {-9190, -31453},
    {-9193, -31452},  {-9196, -31451},  {-9199, -31450},  {-9202, -31449},  {-9205, -31449},  {-9208, -31448},
    {-9211, -31447},  {-9214, -31446},  {-9217, -31445},  {-9220, -31444},  {-9223, -31443},  {-9226, -31442},
    {-9229, -31441},  {-9232, -31441},  {-9235, -31440},  {-9238, -31439},  {-9241, -31438},  {-9244, -31437},
    {-9247, -31436},  {-9250, -31435},  {-9253, -31434},  {-9256, -31433},  {-9259, -31433},  {-9262, -31432},
    {-9265, -31431},  {-9268, -31430},  {-9271, -31429},  {-9274, -31428},  {-9277, -31427},  {-9280, -31426},
    {-9283, -31425},  {-9286, -31425},  {-9289, -31424},  {-9292, -31423},  {-9295, -31422},  {-9298, -31421},
    {-9301, -31420},  {-9304, -31419},  {-9307, -31418},  {-9310, -31417},  {-9313, -31417},  {-9316, -31416},
    {-9319, -31415},  {-9322, -31414},  {-9325, -31413},  {-9329, -31412},  {-9332, -31411},  {-9335, -31410},
    {-9338, -31409},  {-9341, -31409},  {-9344, -31408},  {-9347, -31407},  {-9350, -31406},  {-9353, -31405},
    {-9356, -31404},  {-9359, -31403},  {-9362, -31402},  {-9365, -31401},  {-9368, -31400},  {-9371, -31400},
    {-9374, -31399},  {-9377, -31398},  {-9380, -31397},  {-9383, -31396},  {-9386, -31395},  {-9389, -31394},
    {-9392, -31393},  {-9395, -31392},  {-9398, -31391},  {-9401, -31391},  {-9404, -31390},  {-9407, -31389},
    {-9410, -31388},  {-9413, -31387},  {-9416, -31386},  {-9419, -31385},  {-9422, -31384},  {-9425, -31383},
    {-9428, -31382},  {-9431, -31382},  {-9434, -31381},  {-9437, -31380},  {-9440, -31379},  {-9443, -31378},
    {-9446, -31377},  {-9449, -31376},  {-9452, -31375},  {-9455, -31374},  {-9458, -31373},  {-9461, -31372},
    {-9464, -31372},  {-9467, -31371},  {-9470, -31370},  {-9473, -31369},  {-9476, -31368},  {-9479, -31367},
    {-9482, -31366},  {-9485, -31365},  {-9488, -31364},  {-9491, -31363},  {-9494, -31362},  {-9497, -31362},
    {-9500, -31361},  {-9503, -31360},  {-9506, -31359},  {-9509, -31358},  {-9512, -31357},  {-9515, -31356},
    {-9518, -31355},  {-9521, -31354},  {-9524, -31353},  {-9527, -31352},  {-9530, -31352},  {-9533, -31351},
    {-9536, -31350},  {-9539, -31349},  {-9542, -31348},  {-9545, -31347},  {-9548, -31346},  {-9551, -31345},
    {-9554, -31344},  {-9557, -31343},  {-9560, -31342},  {-9563, -31341},  {-9566, -31341},  {-9569, -31340},
    {-9572, -31339},  {-9575, -31338},  {-9578, -31337},  {-9581, -31336},  {-9584, -31335},  {-9587, -31334},
    {-9590, -31333},  {-9593, -31332},  {-9596, -31331},  {-9599, -31330},  {-9602, -31330},  {-9605, -31329},
    {-9608, -31328},  {-9611, -31327},  {-9614, -31326},  {-9617, -31325},  {-9620, -31324},  {-9623, -31323},
    {-9626, -31322},  {-9629, -31321},  {-9632, -31320},  {-9635, -31319},  {-9638, -31318},  {-9641, -31318},
    {-9644, -31317},  {-9647, -31316},  {-9650, -31315},  {-9653, -31314},  {-9656, -31313},  {-9659, -31312},
    {-9662, -31311},  {-9665, -31310},  {-9668, -31309},  {-9671, -31308},  {-9674, -31307},  {-9677, -31306},
    {-9680, -31305},  {-9683, -31305},  {-9686, -31304},  {-9689, -31303},  {-9692, -31302},  {-9695, -31301},
    {-9698, -31300},  {-9701, -31299},  {-9704, -31298},  {-9707, -31297},  {-9710, -31296},  {-9713, -31295},
    {-9716, -31294},  {-9719, -31293},  {-9722, -31292},  {-9725, -31292},  {-9728, -31291},  {-9731, -31290},
    {-9734, -31289},  {-9737, -31288},  {-9740, -31287},  {-9743, -31286},  {-9746, -31285},  {-9749, -31284},
    {-9752, -31283},  {-9755, -31282},  {-9758, -31281},  {-9761, -31280},  {-9764, -31279},  {-9767, -31278},
    {-9770, -31278},  {-9773, -31277},  {-9776, -31276},  {-9779, -31275},  {-9782, -31274},  {-9785, -31273},
    {-9788, -31272},  {-9791, -31271},  {-9794, -31270},  {-9797, -31269},  {-9800, -31268},  {-9803, -31267},
    {-9806, -31266},  {-9809, -31265},  {-9812, -31264},  {-9815, -31263},  {-9818, -31263},  {-9821, -31262},
    {-9824, -31261},  {-9827, -31260},  {-9830, -31259},  {-9833, -31258},  {-9836, -31257},  {-9839, -31256},
    {-9842, -31255},  {-9845, -31254},  {-9848, -31253},  {-9851, -31252},  {-9854, -31251},  {-9857, -31250},
    {-9860, -31249},  {-9863, -31248},  {-9866, -31247},  {-9869, -31246},  {-9872, -31246},  {-9875, -31245},
    {-9878, -31244},  {-9881, -31243},  {-9884, -31242},  {-9887, -31241},  {-9890, -31240},  {-9893, -31239},
    {-9896, -31238},  {-9899, -31237},  {-9902, -31236},  {-9905, -31235},  {-9908, -31234},  {-9911, -31233},
    {-9914, -31232},  {-9917, -31231},  {-9920, -31230},  {-9923, -31229},  {-9926, -31228},  {-9929, -31227},
    {-9932, -31227},  {-9935, -31226},  {-9938, -31225},  {-9941, -31224},  {-9944, -31223},  {-9947, -31222},
    {-9950, -31221},  {-9953, -31220},  {-9956, -31219},  {-9959, -31218},  {-9962, -31217},  {-9965, -31216},
    {-9968, -31215},  {-9971, -31214},  {-9974, -31213},  {-9977, -31212},  {-9980, -31211},  {-9983, -31210},
    {-9986, -31209},  {-9989, -31208},  {-9992, -31207},  {-9995, -31206},  {-9998, -31206},  {-10001, -31205},
    {-10004, -31204}, {-10007, -31203}, {-10010, -31202}, {-10013, -31201}, {-10016, -31200}, {-10019, -31199},
    {-10022, -31198}, {-10025, -31197}, {-10028, -31196}, {-10031, -31195}, {-10034, -31194}, {-10037, -31193},
    {-10040, -31192}, {-10043, -31191}, {-10046, -31190}, {-10049, -31189}, {-10052, -31188}, {-10055, -31187},
    {-10058, -31186}, {-10061, -31185}, {-10064, -31184}, {-10067, -31183}, {-10070, -31182}, {-10073, -31181},
    {-10076, -31180}, {-10079, -31180}, {-10082, -31179}, {-10085, -31178}, {-10088, -31177}, {-10091, -31176},
    {-10094, -31175}, {-10097, -31174}, {-10100, -31173}, {-10103, -31172}, {-10106, -31171}, {-10109, -31170},
    {-10112, -31169}, {-10115, -31168}, {-10118, -31167}, {-10120, -31166}, {-10123, -31165}, {-10126, -31164},
    {-10129, -31163}, {-10132, -31162}, {-10135, -31161}, {-10138, -31160}, {-10141, -31159}, {-10144, -31158},
    {-10147, -31157}, {-10150, -31156}, {-10153, -31155}, {-10156, -31154}, {-10159, -31153}, {-10162, -31152},
    {-10165, -31151}, {-10168, -31150}, {-10171, -31149}, {-10174, -31148}, {-10177, -31147}, {-10180, -31147},
    {-10183, -31146}, {-10186, -31145}, {-10189, -31144}, {-10192, -31143}, {-10195, -31142}, {-10198, -31141},
    {-10201, -31140}, {-10204, -31139}, {-10207, -31138}, {-10210, -31137}, {-10213, -31136}, {-10216, -31135},
    {-10219, -31134}, {-10222, -31133}, {-10225, -31132}, {-10228, -31131}, {-10231, -31130}, {-10234, -31129},
    {-10237, -31128}, {-10240, -31127}, {-10243, -31126}, {-10246, -31125}, {-10249, -31124}, {-10252, -31123},
    {-10255, -31122}, {-10258, -31121}, {-10261, -31120}, {-10264, -31119}, {-10267, -31118}, {-10270, -31117},
    {-10273, -31116}, {-10276, -31115}, {-10279, -31114}, {-10282, -31113}, {-10285, -31112}, {-10288, -31111},
    {-10291, -31110}, {-10294, -31109}, {-10297, -31108}, {-10300, -31107}, {-10303, -31106}, {-10306, -31105},
    {-10309, -31104}, {-10312, -31103}, {-10315, -31102}, {-10317, -31101}, {-10320, -31100}, {-10323, -31099},
    {-10326, -31098}, {-10329, -31097}, {-10332, -31096}, {-10335, -31095}, {-10338, -31094}, {-10341, -31093},
    {-10344, -31092}, {-10347, -31091}, {-10350, -31090}, {-10353, -31089}, {-10356, -31088}, {-10359, -31087},
    {-10362, -31086}, {-10365, -31085}, {-10368, -31084}, {-10371, -31083}, {-10374, -31082}, {-10377, -31081},
    {-10380, -31080}, {-10383, -31079}, {-10386, -31078}, {-10389, -31077}, {-10392, -31076}, {-10395, -31075},
    {-10398, -31074}, {-10401, -31073}, {-10404, -31072}, {-10407, -31072}, {-10410, -31071}, {-10413, -31070},
    {-10416, -31069}, {-10419, -31068}, {-10422, -31067}, {-10425, -31066}, {-10428, -31065}, {-10431, -31064},
    {-10434, -31063}, {-10437, -31062}, {-10440, -31061}, {-10443, -31060}, {-10446, -31059}, {-10449, -31058},
    {-10452, -31057}, {-10455, -31055}, {-10458, -31054}, {-10461, -31053}, {-10463, -31052}, {-10466, -31051},
    {-10469, -31050}, {-10472, -31049}, {-10475, -31048}, {-10478, -31047}, {-10481, -31046}, {-10484, -31045},
    {-10487, -31044}, {-10490, -31043}, {-10493, -31042}, {-10496, -31041}, {-10499, -31040}, {-10502, -31039},
    {-10505, -31038}, {-10508, -31037}, {-10511, -31036}, {-10514, -31035}, {-10517, -31034}, {-10520, -31033},
    {-10523, -31032}, {-10526, -31031}, {-10529, -31030}, {-10532, -31029}, {-10535, -31028}, {-10538, -31027},
    {-10541, -31026}, {-10544, -31025}, {-10547, -31024}, {-10550, -31023}, {-10553, -31022}, {-10556, -31021},
    {-10559, -31020}, {-10562, -31019}, {-10565, -31018}, {-10568, -31017}, {-10571, -31016}, {-10574, -31015},
    {-10577, -31014}, {-10580, -31013}, {-10582, -31012}, {-10585, -31011}, {-10588, -31010}, {-10591, -31009},
    {-10594, -31008}, {-10597, -31007}, {-10600, -31006}, {-10603, -31005}, {-10606, -31004}, {-10609, -31003},
    {-10612, -31002}, {-10615, -31001}, {-10618, -31000}, {-10621, -30999}, {-10624, -30998}, {-10627, -30997},
    {-10630, -30996}, {-10633, -30995}, {-10636, -30994}, {-10639, -30993}, {-10642, -30992}, {-10645, -30991},
    {-10648, -30990}, {-10651, -30989}, {-10654, -30988}, {-10657, -30987}, {-10660, -30986}, {-10663, -30985},
    {-10666, -30984}, {-10669, -30983}, {-10672, -30982}, {-10675, -30981}, {-10678, -30980}, {-10681, -30978},
    {-10684, -30977}, {-10687, -30976}, {-10689, -30975}, {-10692, -30974}, {-10695, -30973}, {-10698, -30972},
    {-10701, -30971}, {-10704, -30970}, {-10707, -30969}, {-10710, -30968}, {-10713, -30967}, {-10716, -30966},
    {-10719, -30965}, {-10722, -30964}, {-10725, -30963}, {-10728, -30962}, {-10731, -30961}, {-10734, -30960},
    {-10737, -30959}, {-10740, -30958}, {-10743, -30957}, {-10746, -30956}, {-10749, -30955}, {-10752, -30954},
    {-10755, -30953}, {-10758, -30952}, {-10761, -30951}, {-10764, -30950}, {-10767, -30949}, {-10770, -30948},
    {-10773, -30947}, {-10776, -30946}, {-10779, -30945}, {-10781, -30944}, {-10784, -30942}, {-10787, -30941},
    {-10790, -30940}, {-10793, -30939}, {-10796, -30938}, {-10799, -30937}, {-10802, -30936}, {-10805, -30935},
    {-10808, -30934}, {-10811, -30933}, {-10814, -30932}, {-10817, -30931}, {-10820, -30930}, {-10823, -30929},
    {-10826, -30928}, {-10829, -30927}, {-10832, -30926}, {-10835, -30925}, {-10838, -30924}, {-10841, -30923},
    {-10844, -30922}, {-10847, -30921}, {-10850, -30920}, {-10853, -30919}, {-10856, -30918}, {-10859, -30917},
    {-10862, -30916}, {-10865, -30914}, {-10867, -30913}, {-10870, -30912}, {-10873, -30911}, {-10876, -30910},
    {-10879, -30909}, {-10882, -30908}, {-10885, -30907}, {-10888, -30906}, {-10891, -30905}, {-10894, -30904},
    {-10897, -30903}, {-10900, -30902}, {-10903, -30901}, {-10906, -30900}, {-10909, -30899}, {-10912, -30898},
    {-10915, -30897}, {-10918, -30896}, {-10921, -30895}, {-10924, -30894}, {-10927, -30893}, {-10930, -30891},
    {-10933, -30890}, {-10936, -30889}, {-10939, -30888}, {-10942, -30887}, {-10945, -30886}, {-10947, -30885},
    {-10950, -30884}, {-10953, -30883}, {-10956, -30882}, {-10959, -30881}, {-10962, -30880}, {-10965, -30879},
    {-10968, -30878}, {-10971, -30877}, {-10974, -30876}, {-10977, -30875}, {-10980, -30874}, {-10983, -30873},
    {-10986, -30872}, {-10989, -30870}, {-10992, -30869}, {-10995, -30868}, {-10998, -30867}, {-11001, -30866},
    {-11004, -30865}, {-11007, -30864}, {-11010, -30863}, {-11013, -30862}, {-11016, -30861}, {-11018, -30860},
    {-11021, -30859}, {-11024, -30858}, {-11027, -30857}, {-11030, -30856}, {-11033, -30855}, {-11036, -30854},
    {-11039, -30853}, {-11042, -30851}, {-11045, -30850}, {-11048, -30849}, {-11051, -30848}, {-11054, -30847},
    {-11057, -30846}, {-11060, -30845}, {-11063, -30844}, {-11066, -30843}, {-11069, -30842}, {-11072, -30841},
    {-11075, -30840}, {-11078, -30839}, {-11081, -30838}, {-11084, -30837}, {-11087, -30836}, {-11089, -30834},
    {-11092, -30833}, {-11095, -30832}, {-11098, -30831}, {-11101, -30830}, {-11104, -30829}, {-11107, -30828},
    {-11110, -30827}, {-11113, -30826}, {-11116, -30825}, {-11119, -30824}, {-11122, -30823}, {-11125, -30822},
    {-11128, -30821}, {-11131, -30820}, {-11134, -30819}, {-11137, -30817}, {-11140, -30816}, {-11143, -30815},
    {-11146, -30814}, {-11149, -30813}, {-11152, -30812}, {-11154, -30811}, {-11157, -30810}, {-11160, -30809},
    {-11163, -30808}, {-11166, -30807}, {-11169, -30806}, {-11172, -30805}, {-11175, -30804}, {-11178, -30802},
    {-11181, -30801}, {-11184, -30800}, {-11187, -30799}, {-11190, -30798}, {-11193, -30797}, {-11196, -30796},
    {-11199, -30795}, {-11202, -30794}, {-11205, -30793}, {-11208, -30792}, {-11211, -30791}, {-11214, -30790},
    {-11216, -30789}, {-11219, -30787}, {-11222, -30786}, {-11225, -30785}, {-11228, -30784}, {-11231, -30783},
    {-11234, -30782}, {-11237, -30781}, {-11240, -30780}, {-11243, -30779}, {-11246, -30778}, {-11249, -30777},
    {-11252, -30776}, {-11255, -30774}, {-11258, -30773}, {-11261, -30772}, {-11264, -30771}, {-11267, -30770},
    {-11270, -30769}, {-11273, -30768}, {-11276, -30767}, {-11278, -30766}, {-11281, -30765}, {-11284, -30764},
    {-11287, -30763}, {-11290, -30762}, {-11293, -30760}, {-11296, -30759}, {-11299, -30758}, {-11302, -30757},
    {-11305, -30756}, {-11308, -30755}, {-11311, -30754}, {-11314, -30753}, {-11317, -30752}, {-11320, -30751},
    {-11323, -30750}, {-11326, -30749}, {-11329, -30747}, {-11332, -30746}, {-11334, -30745}, {-11337, -30744},
    {-11340, -30743}, {-11343, -30742}, {-11346, -30741}, {-11349, -30740}, {-11352, -30739}, {-11355, -30738},
    {-11358, -30737}, {-11361, -30735}, {-11364, -30734}, {-11367, -30733}, {-11370, -30732}, {-11373, -30731},
    {-11376, -30730}, {-11379, -30729}, {-11382, -30728}, {-11385, -30727}, {-11388, -30726}, {-11390, -30725},
    {-11393, -30723}, {-11396, -30722}, {-11399, -30721}, {-11402, -30720}, {-11405, -30719}, {-11408, -30718},
    {-11411, -30717}, {-11414, -30716}, {-11417, -30715}, {-11420, -30714}, {-11423, -30713}, {-11426, -30711},
    {-11429, -30710}, {-11432, -30709}, {-11435, -30708}, {-11438, -30707}, {-11441, -30706}, {-11443, -30705},
    {-11446, -30704}, {-11449, -30703}, {-11452, -30702}, {-11455, -30700}, {-11458, -30699}, {-11461, -30698},
    {-11464, -30697}, {-11467, -30696}, {-11470, -30695}, {-11473, -30694}, {-11476, -30693}, {-11479, -30692},
    {-11482, -30691}, {-11485, -30689}, {-11488, -30688}, {-11491, -30687}, {-11494, -30686}, {-11496, -30685},
    {-11499, -30684}, {-11502, -30683}, {-11505, -30682}, {-11508, -30681}, {-11511, -30680}, {-11514, -30678},
    {-11517, -30677}, {-11520, -30676}, {-11523, -30675}, {-11526, -30674}, {-11529, -30673}, {-11532, -30672},
    {-11535, -30671}, {-11538, -30670}, {-11541, -30669}, {-11544, -30667}, {-11546, -30666}, {-11549, -30665},
    {-11552, -30664}, {-11555, -30663}, {-11558, -30662}, {-11561, -30661}, {-11564, -30660}, {-11567, -30659},
    {-11570, -30657}, {-11573, -30656}, {-11576, -30655}, {-11579, -30654}, {-11582, -30653}, {-11585, -30652},
    {-11588, -30651}, {-11591, -30650}, {-11593, -30649}, {-11596, -30647}, {-11599, -30646}, {-11602, -30645},
    {-11605, -30644}, {-11608, -30643}, {-11611, -30642}, {-11614, -30641}, {-11617, -30640}, {-11620, -30639},
    {-11623, -30637}, {-11626, -30636}, {-11629, -30635}, {-11632, -30634}, {-11635, -30633}, {-11638, -30632},
    {-11640, -30631}, {-11643, -30630}, {-11646, -30628}, {-11649, -30627}, {-11652, -30626}, {-11655, -30625},
    {-11658, -30624}, {-11661, -30623}, {-11664, -30622}, {-11667, -30621}, {-11670, -30620}, {-11673, -30618},
    {-11676, -30617}, {-11679, -30616}, {-11682, -30615}, {-11685, -30614}, {-11687, -30613}, {-11690, -30612},
    {-11693, -30611}, {-11696, -30609}, {-11699, -30608}, {-11702, -30607}, {-11705, -30606}, {-11708, -30605},
    {-11711, -30604}, {-11714, -30603}, {-11717, -30602}, {-11720, -30600}, {-11723, -30599}, {-11726, -30598},
    {-11729, -30597}, {-11731, -30596}, {-11734, -30595}, {-11737, -30594}, {-11740, -30593}, {-11743, -30591},
    {-11746, -30590}, {-11749, -30589}, {-11752, -30588}, {-11755, -30587}, {-11758, -30586}, {-11761, -30585},
    {-11764, -30584}, {-11767, -30582}, {-11770, -30581}, {-11773, -30580}, {-11775, -30579}, {-11778, -30578},
    {-11781, -30577}, {-11784, -30576}, {-11787, -30575}, {-11790, -30573}, {-11793, -30572}, {-11796, -30571},
    {-11799, -30570}, {-11802, -30569}, {-11805, -30568}, {-11808, -30567}, {-11811, -30566}, {-11814, -30564},
    {-11816, -30563}, {-11819, -30562}, {-11822, -30561}, {-11825, -30560}, {-11828, -30559}, {-11831, -30558},
    {-11834, -30556}, {-11837, -30555}, {-11840, -30554}, {-11843, -30553}, {-11846, -30552}, {-11849, -30551},
    {-11852, -30550}, {-11855, -30549}, {-11857, -30547}, {-11860, -30546}, {-11863, -30545}, {-11866, -30544},
    {-11869, -30543}, {-11872, -30542}, {-11875, -30541}, {-11878, -30539}, {-11881, -30538}, {-11884, -30537},
    {-11887, -30536}, {-11890, -30535}, {-11893, -30534}, {-11896, -30533}, {-11898, -30531}, {-11901, -30530},
    {-11904, -30529}, {-11907, -30528}, {-11910, -30527}, {-11913, -30526}, {-11916, -30525}, {-11919, -30523},
    {-11922, -30522}, {-11925, -30521}, {-11928, -30520}, {-11931, -30519}, {-11934, -30518}, {-11937, -30517},
    {-11939, -30515}, {-11942, -30514}, {-11945, -30513}, {-11948, -30512}, {-11951, -30511}, {-11954, -30510},
    {-11957, -30509}, {-11960, -30507}, {-11963, -30506}, {-11966, -30505}, {-11969, -30504}, {-11972, -30503},
    {-11975, -30502}, {-11977, -30501}, {-11980, -30499}, {-11983, -30498}, {-11986, -30497}, {-11989, -30496},
    {-11992, -30495}, {-11995, -30494}, {-11998, -30492}, {-12001, -30491}, {-12004, -30490}, {-12007, -30489},
    {-12010, -30488}, {-12013, -30487}, {-12015, -30486}, {-12018, -30484}, {-12021, -30483}, {-12024, -30482},
    {-12027, -30481}, {-12030, -30480}, {-12033, -30479}, {-12036, -30477}, {-12039, -30476}, {-12042, -30475},
    {-12045, -30474}, {-12048, -30473}, {-12051, -30472}, {-12053, -30471}, {-12056, -30469}, {-12059, -30468},
    {-12062, -30467}, {-12065, -30466}, {-12068, -30465}, {-12071, -30464}, {-12074, -30462}, {-12077, -30461},
    {-12080, -30460}, {-12083, -30459}, {-12086, -30458}, {-12089, -30457}, {-12091, -30456}, {-12094, -30454},
    {-12097, -30453}, {-12100, -30452}, {-12103, -30451}, {-12106, -30450}, {-12109, -30449}, {-12112, -30447},
    {-12115, -30446}, {-12118, -30445}, {-12121, -30444}, {-12124, -30443}, {-12126, -30442}, {-12129, -30440},
    {-12132, -30439}, {-12135, -30438}, {-12138, -30437}, {-12141, -30436}, {-12144, -30435}, {-12147, -30433},
    {-12150, -30432}, {-12153, -30431}, {-12156, -30430}, {-12159, -30429}, {-12161, -30428}, {-12164, -30426},
    {-12167, -30425}, {-12170, -30424}, {-12173, -30423}, {-12176, -30422}, {-12179, -30421}, {-12182, -30419},
    {-12185, -30418}, {-12188, -30417}, {-12191, -30416}, {-12194, -30415}, {-12196, -30414}, {-12199, -30412},
    {-12202, -30411}, {-12205, -30410}, {-12208, -30409}, {-12211, -30408}, {-12214, -30407}, {-12217, -30405},
    {-12220, -30404}, {-12223, -30403}, {-12226, -30402}, {-12229, -30401}, {-12231, -30400}, {-12234, -30398},
    {-12237, -30397}, {-12240, -30396}, {-12243, -30395}, {-12246, -30394}, {-12249, -30393}, {-12252, -30391},
    {-12255, -30390}, {-12258, -30389}, {-12261, -30388}, {-12264, -30387}, {-12266, -30385}, {-12269, -30384},
    {-12272, -30383}, {-12275, -30382}, {-12278, -30381}, {-12281, -30380}, {-12284, -30378}, {-12287, -30377},
    {-12290, -30376}, {-12293, -30375}, {-12296, -30374}, {-12298, -30373}, {-12301, -30371}, {-12304, -30370},
    {-12307, -30369}, {-12310, -30368}, {-12313, -30367}, {-12316, -30365}, {-12319, -30364}, {-12322, -30363},
    {-12325, -30362}, {-12328, -30361}, {-12330, -30360}, {-12333, -30358}, {-12336, -30357}, {-12339, -30356},
    {-12342, -30355}, {-12345, -30354}, {-12348, -30352}, {-12351, -30351}, {-12354, -30350}, {-12357, -30349},
    {-12360, -30348}, {-12363, -30347}, {-12365, -30345}, {-12368, -30344}, {-12371, -30343}, {-12374, -30342},
    {-12377, -30341}, {-12380, -30339}, {-12383, -30338}, {-12386, -30337}, {-12389, -30336}, {-12392, -30335},
    {-12395, -30333}, {-12397, -30332}, {-12400, -30331}, {-12403, -30330}, {-12406, -30329}, {-12409, -30328},
    {-12412, -30326}, {-12415, -30325}, {-12418, -30324}, {-12421, -30323}, {-12424, -30322}, {-12426, -30320},
    {-12429, -30319}, {-12432, -30318}, {-12435, -30317}, {-12438, -30316}, {-12441, -30314}, {-12444, -30313},
    {-12447, -30312}, {-12450, -30311}, {-12453, -30310}, {-12456, -30308}, {-12458, -30307}, {-12461, -30306},
    {-12464, -30305}, {-12467, -30304}, {-12470, -30302}, {-12473, -30301}, {-12476, -30300}, {-12479, -30299},
    {-12482, -30298}, {-12485, -30296}, {-12488, -30295}, {-12490, -30294}, {-12493, -30293}, {-12496, -30292},
    {-12499, -30290}, {-12502, -30289}, {-12505, -30288}, {-12508, -30287}, {-12511, -30286}, {-12514, -30284},
    {-12517, -30283}, {-12519, -30282}, {-12522, -30281}, {-12525, -30280}, {-12528, -30278}, {-12531, -30277},
    {-12534, -30276}, {-12537, -30275}, {-12540, -30274}, {-12543, -30272}, {-12546, -30271}, {-12548, -30270},
    {-12551, -30269}, {-12554, -30268}, {-12557, -30266}, {-12560, -30265}, {-12563, -30264}, {-12566, -30263},
    {-12569, -30262}, {-12572, -30260}, {-12575, -30259}, {-12577, -30258}, {-12580, -30257}, {-12583, -30256},
    {-12586, -30254}, {-12589, -30253}, {-12592, -30252}, {-12595, -30251}, {-12598, -30250}, {-12601, -30248},
    {-12604, -30247}, {-12606, -30246}, {-12609, -30245}, {-12612, -30244}, {-12615, -30242}, {-12618, -30241},
    {-12621, -30240}, {-12624, -30239}, {-12627, -30237}, {-12630, -30236}, {-12633, -30235}, {-12635, -30234},
    {-12638, -30233}, {-12641, -30231}, {-12644, -30230}, {-12647, -30229}, {-12650, -30228}, {-12653, -30227},
    {-12656, -30225}, {-12659, -30224}, {-12662, -30223}, {-12664, -30222}, {-12667, -30221}, {-12670, -30219},
    {-12673, -30218}, {-12676, -30217}, {-12679, -30216}, {-12682, -30214}, {-12685, -30213}, {-12688, -30212},
    {-12691, -30211}, {-12693, -30210}, {-12696, -30208}, {-12699, -30207}, {-12702, -30206}, {-12705, -30205},
    {-12708, -30203}, {-12711, -30202}, {-12714, -30201}, {-12717, -30200}, {-12720, -30199}, {-12722, -30197},
    {-12725, -30196}, {-12728, -30195}, {-12731, -30194}, {-12734, -30193}, {-12737, -30191}, {-12740, -30190},
    {-12743, -30189}, {-12746, -30188}, {-12748, -30186}, {-12751, -30185}, {-12754, -30184}, {-12757, -30183},
    {-12760, -30182}, {-12763, -30180}, {-12766, -30179}, {-12769, -30178}, {-12772, -30177}, {-12774, -30175},
    {-12777, -30174}, {-12780, -30173}, {-12783, -30172}, {-12786, -30170}, {-12789, -30169}, {-12792, -30168},
    {-12795, -30167}, {-12798, -30166}, {-12801, -30164}, {-12803, -30163}, {-12806, -30162}, {-12809, -30161},
    {-12812, -30159}, {-12815, -30158}, {-12818, -30157}, {-12821, -30156}, {-12824, -30155}, {-12827, -30153},
    {-12829, -30152}, {-12832, -30151}, {-12835, -30150}, {-12838, -30148}, {-12841, -30147}, {-12844, -30146},
    {-12847, -30145}, {-12850, -30143}, {-12853, -30142}, {-12855, -30141}, {-12858, -30140}, {-12861, -30139},
    {-12864, -30137}, {-12867, -30136}, {-12870, -30135}, {-12873, -30134}, {-12876, -30132}, {-12879, -30131},
    {-12881, -30130}, {-12884, -30129}, {-12887, -30127}, {-12890, -30126}, {-12893, -30125}, {-12896, -30124},
    {-12899, -30122}, {-12902, -30121}, {-12905, -30120}, {-12907, -30119}, {-12910, -30118}, {-12913, -30116},
    {-12916, -30115}, {-12919, -30114}, {-12922, -30113}, {-12925, -30111}, {-12928, -30110}, {-12931, -30109},
    {-12933, -30108}, {-12936, -30106}, {-12939, -30105}, {-12942, -30104}, {-12945, -30103}, {-12948, -30101},
    {-12951, -30100}, {-12954, -30099}, {-12957, -30098}, {-12959, -30096}, {-12962, -30095}, {-12965, -30094},
    {-12968, -30093}, {-12971, -30091}, {-12974, -30090}, {-12977, -30089}, {-12980, -30088}, {-12982, -30086},
    {-12985, -30085}, {-12988, -30084}, {-12991, -30083}, {-12994, -30082}, {-12997, -30080}, {-13000, -30079},
    {-13003, -30078}, {-13006, -30077}, {-13008, -30075}, {-13011, -30074}, {-13014, -30073}, {-13017, -30072},
    {-13020, -30070}, {-13023, -30069}, {-13026, -30068}, {-13029, -30067}, {-13032, -30065}, {-13034, -30064},
    {-13037, -30063}, {-13040, -30062}, {-13043, -30060}, {-13046, -30059}, {-13049, -30058}, {-13052, -30057},
    {-13055, -30055}, {-13057, -30054}, {-13060, -30053}, {-13063, -30052}, {-13066, -30050}, {-13069, -30049},
    {-13072, -30048}, {-13075, -30047}, {-13078, -30045}, {-13080, -30044}, {-13083, -30043}, {-13086, -30042},
    {-13089, -30040}, {-13092, -30039}, {-13095, -30038}, {-13098, -30036}, {-13101, -30035}, {-13104, -30034},
    {-13106, -30033}, {-13109, -30031}, {-13112, -30030}, {-13115, -30029}, {-13118, -30028}, {-13121, -30026},
    {-13124, -30025}, {-13127, -30024}, {-13129, -30023}, {-13132, -30021}, {-13135, -30020}, {-13138, -30019},
    {-13141, -30018}, {-13144, -30016}, {-13147, -30015}, {-13150, -30014}, {-13152, -30013}, {-13155, -30011},
    {-13158, -30010}, {-13161, -30009}, {-13164, -30008}, {-13167, -30006}, {-13170, -30005}, {-13173, -30004},
    {-13175, -30002}, {-13178, -30001}, {-13181, -30000}, {-13184, -29999}, {-13187, -29997}, {-13190, -29996},
    {-13193, -29995}, {-13196, -29994}, {-13198, -29992}, {-13201, -29991}, {-13204, -29990}, {-13207, -29989},
    {-13210, -29987}, {-13213, -29986}, {-13216, -29985}, {-13219, -29983}, {-13221, -29982}, {-13224, -29981},
    {-13227, -29980}, {-13230, -29978}, {-13233, -29977}, {-13236, -29976}, {-13239, -29975}, {-13242, -29973},
    {-13244, -29972}, {-13247, -29971}, {-13250, -29970}, {-13253, -29968}, {-13256, -29967}, {-13259, -29966},
    {-13262, -29964}, {-13265, -29963}, {-13267, -29962}, {-13270, -29961}, {-13273, -29959}, {-13276, -29958},
    {-13279, -29957}, {-13282, -29956}, {-13285, -29954}, {-13288, -29953}, {-13290, -29952}, {-13293, -29950},
    {-13296, -29949}, {-13299, -29948}, {-13302, -29947}, {-13305, -29945}, {-13308, -29944}, {-13311, -29943},
    {-13313, -29942}, {-13316, -29940}, {-13319, -29939}, {-13322, -29938}, {-13325, -29936}, {-13328, -29935},
    {-13331, -29934}, {-13333, -29933}, {-13336, -29931}, {-13339, -29930}, {-13342, -29929}, {-13345, -29927},
    {-13348, -29926}, {-13351, -29925}, {-13354, -29924}, {-13356, -29922}, {-13359, -29921}, {-13362, -29920},
    {-13365, -29919}, {-13368, -29917}, {-13371, -29916}, {-13374, -29915}, {-13377, -29913}, {-13379, -29912},
    {-13382, -29911}, {-13385, -29910}, {-13388, -29908}, {-13391, -29907}, {-13394, -29906}, {-13397, -29904},
    {-13399, -29903}, {-13402, -29902}, {-13405, -29901}, {-13408, -29899}, {-13411, -29898}, {-13414, -29897},
    {-13417, -29895}, {-13420, -29894}, {-13422, -29893}, {-13425, -29892}, {-13428, -29890}, {-13431, -29889},
    {-13434, -29888}, {-13437, -29886}, {-13440, -29885}, {-13442, -29884}, {-13445, -29883}, {-13448, -29881},
    {-13451, -29880}, {-13454, -29879}, {-13457, -29877}, {-13460, -29876}, {-13463, -29875}, {-13465, -29873},
    {-13468, -29872}, {-13471, -29871}, {-13474, -29870}, {-13477, -29868}, {-13480, -29867}, {-13483, -29866},
    {-13485, -29864}, {-13488, -29863}, {-13491, -29862}, {-13494, -29861}, {-13497, -29859}, {-13500, -29858},
    {-13503, -29857}, {-13505, -29855}, {-13508, -29854}, {-13511, -29853}, {-13514, -29852}, {-13517, -29850},
    {-13520, -29849}, {-13523, -29848}, {-13525, -29846}, {-13528, -29845}, {-13531, -29844}, {-13534, -29842},
    {-13537, -29841}, {-13540, -29840}, {-13543, -29839}, {-13546, -29837}, {-13548, -29836}, {-13551, -29835},
    {-13554, -29833}, {-13557, -29832}, {-13560, -29831}, {-13563, -29829}, {-13566, -29828}, {-13568, -29827},
    {-13571, -29826}, {-13574, -29824}, {-13577, -29823}, {-13580, -29822}, {-13583, -29820}, {-13586, -29819},
    {-13588, -29818}, {-13591, -29816}, {-13594, -29815}, {-13597, -29814}, {-13600, -29813}, {-13603, -29811},
    {-13606, -29810}, {-13608, -29809}, {-13611, -29807}, {-13614, -29806}, {-13617, -29805}, {-13620, -29803},
    {-13623, -29802}, {-13626, -29801}, {-13628, -29799}, {-13631, -29798}, {-13634, -29797}, {-13637, -29796},
    {-13640, -29794}, {-13643, -29793}, {-13646, -29792}, {-13648, -29790}, {-13651, -29789}, {-13654, -29788},
    {-13657, -29786}, {-13660, -29785}, {-13663, -29784}, {-13666, -29782}, {-13668, -29781}, {-13671, -29780},
    {-13674, -29779}, {-13677, -29777}, {-13680, -29776}, {-13683, -29775}, {-13686, -29773}, {-13688, -29772},
    {-13691, -29771}, {-13694, -29769}, {-13697, -29768}, {-13700, -29767}, {-13703, -29765}, {-13706, -29764},
    {-13708, -29763}, {-13711, -29761}, {-13714, -29760}, {-13717, -29759}, {-13720, -29758}, {-13723, -29756},
    {-13725, -29755}, {-13728, -29754}, {-13731, -29752}, {-13734, -29751}, {-13737, -29750}, {-13740, -29748},
    {-13743, -29747}, {-13745, -29746}, {-13748, -29744}, {-13751, -29743}, {-13754, -29742}, {-13757, -29740},
    {-13760, -29739}, {-13763, -29738}, {-13765, -29736}, {-13768, -29735}, {-13771, -29734}, {-13774, -29732},
    {-13777, -29731}, {-13780, -29730}, {-13783, -29729}, {-13785, -29727}, {-13788, -29726}, {-13791, -29725},
    {-13794, -29723}, {-13797, -29722}, {-13800, -29721}, {-13802, -29719}, {-13805, -29718}, {-13808, -29717},
    {-13811, -29715}, {-13814, -29714}, {-13817, -29713}, {-13820, -29711}, {-13822, -29710}, {-13825, -29709},
    {-13828, -29707}, {-13831, -29706}, {-13834, -29705}, {-13837, -29703}, {-13839, -29702}, {-13842, -29701},
    {-13845, -29699}, {-13848, -29698}, {-13851, -29697}, {-13854, -29695}, {-13857, -29694}, {-13859, -29693},
    {-13862, -29691}, {-13865, -29690}, {-13868, -29689}, {-13871, -29687}, {-13874, -29686}, {-13877, -29685},
    {-13879, -29683}, {-13882, -29682}, {-13885, -29681}, {-13888, -29679}, {-13891, -29678}, {-13894, -29677},
    {-13896, -29675}, {-13899, -29674}, {-13902, -29673}, {-13905, -29671}, {-13908, -29670}, {-13911, -29669},
    {-13913, -29667}, {-13916, -29666}, {-13919, -29665}, {-13922, -29663}, {-13925, -29662}, {-13928, -29661},
    {-13931, -29659}, {-13933, -29658}, {-13936, -29657}, {-13939, -29655}, {-13942, -29654}, {-13945, -29653},
    {-13948, -29651}, {-13950, -29650}, {-13953, -29649}, {-13956, -29647}, {-13959, -29646}, {-13962, -29645},
    {-13965, -29643}, {-13968, -29642}, {-13970, -29641}, {-13973, -29639}, {-13976, -29638}, {-13979, -29637},
    {-13982, -29635}, {-13985, -29634}, {-13987, -29633}, {-13990, -29631}, {-13993, -29630}, {-13996, -29629},
    {-13999, -29627}, {-14002, -29626}, {-14004, -29625}, {-14007, -29623}, {-14010, -29622}, {-14013, -29621},
    {-14016, -29619}, {-14019, -29618}, {-14021, -29617}, {-14024, -29615}, {-14027, -29614}, {-14030, -29613},
    {-14033, -29611}, {-14036, -29610}, {-14039, -29608}, {-14041, -29607}, {-14044, -29606}, {-14047, -29604},
    {-14050, -29603}, {-14053, -29602}, {-14056, -29600}, {-14058, -29599}, {-14061, -29598}, {-14064, -29596},
    {-14067, -29595}, {-14070, -29594}, {-14073, -29592}, {-14075, -29591}, {-14078, -29590}, {-14081, -29588},
    {-14084, -29587}, {-14087, -29586}, {-14090, -29584}, {-14092, -29583}, {-14095, -29582}, {-14098, -29580},
    {-14101, -29579}, {-14104, -29577}, {-14107, -29576}, {-14109, -29575}, {-14112, -29573}, {-14115, -29572},
    {-14118, -29571}, {-14121, -29569}, {-14124, -29568}, {-14126, -29567}, {-14129, -29565}, {-14132, -29564},
    {-14135, -29563}, {-14138, -29561}, {-14141, -29560}, {-14143, -29558}, {-14146, -29557}, {-14149, -29556},
    {-14152, -29554}, {-14155, -29553}, {-14158, -29552}, {-14160, -29550}, {-14163, -29549}, {-14166, -29548},
    {-14169, -29546}, {-14172, -29545}, {-14175, -29544}, {-14177, -29542}, {-14180, -29541}, {-14183, -29539},
    {-14186, -29538}, {-14189, -29537}, {-14192, -29535}, {-14194, -29534}, {-14197, -29533}, {-14200, -29531},
    {-14203, -29530}, {-14206, -29529}, {-14209, -29527}, {-14211, -29526}, {-14214, -29525}, {-14217, -29523},
    {-14220, -29522}, {-14223, -29520}, {-14226, -29519}, {-14228, -29518}, {-14231, -29516}, {-14234, -29515},
    {-14237, -29514}, {-14240, -29512}, {-14243, -29511}, {-14245, -29509}, {-14248, -29508}, {-14251, -29507},
    {-14254, -29505}, {-14257, -29504}, {-14260, -29503}, {-14262, -29501}, {-14265, -29500}, {-14268, -29499},
    {-14271, -29497}, {-14274, -29496}, {-14277, -29494}, {-14279, -29493}, {-14282, -29492}, {-14285, -29490},
    {-14288, -29489}, {-14291, -29488}, {-14293, -29486}, {-14296, -29485}, {-14299, -29484}, {-14302, -29482},
    {-14305, -29481}, {-14308, -29479}, {-14310, -29478}, {-14313, -29477}, {-14316, -29475}, {-14319, -29474},
    {-14322, -29473}, {-14325, -29471}, {-14327, -29470}, {-14330, -29468}, {-14333, -29467}, {-14336, -29466},
    {-14339, -29464}, {-14342, -29463}, {-14344, -29462}, {-14347, -29460}, {-14350, -29459}, {-14353, -29457},
    {-14356, -29456}, {-14358, -29455}, {-14361, -29453}, {-14364, -29452}, {-14367, -29451}, {-14370, -29449},
    {-14373, -29448}, {-14375, -29446}, {-14378, -29445}, {-14381, -29444}, {-14384, -29442}, {-14387, -29441},
    {-14390, -29439}, {-14392, -29438}, {-14395, -29437}, {-14398, -29435}, {-14401, -29434}, {-14404, -29433},
    {-14406, -29431}, {-14409, -29430}, {-14412, -29428}, {-14415, -29427}, {-14418, -29426}, {-14421, -29424},
    {-14423, -29423}, {-14426, -29422}, {-14429, -29420}, {-14432, -29419}, {-14435, -29417}, {-14437, -29416},
    {-14440, -29415}, {-14443, -29413}, {-14446, -29412}, {-14449, -29410}, {-14452, -29409}, {-14454, -29408},
    {-14457, -29406}, {-14460, -29405}, {-14463, -29404}, {-14466, -29402}, {-14468, -29401}, {-14471, -29399},
    {-14474, -29398}, {-14477, -29397}, {-14480, -29395}, {-14483, -29394}, {-14485, -29392}, {-14488, -29391},
    {-14491, -29390}, {-14494, -29388}, {-14497, -29387}, {-14499, -29385}, {-14502, -29384}, {-14505, -29383},
    {-14508, -29381}, {-14511, -29380}, {-14514, -29379}, {-14516, -29377}, {-14519, -29376}, {-14522, -29374},
    {-14525, -29373}, {-14528, -29372}, {-14530, -29370}, {-14533, -29369}, {-14536, -29367}, {-14539, -29366},
    {-14542, -29365}, {-14545, -29363}, {-14547, -29362}, {-14550, -29360}, {-14553, -29359}, {-14556, -29358},
    {-14559, -29356}, {-14561, -29355}, {-14564, -29353}, {-14567, -29352}, {-14570, -29351}, {-14573, -29349},
    {-14576, -29348}, {-14578, -29346}, {-14581, -29345}, {-14584, -29344}, {-14587, -29342}, {-14590, -29341},
    {-14592, -29339}, {-14595, -29338}, {-14598, -29337}, {-14601, -29335}, {-14604, -29334}, {-14606, -29332},
    {-14609, -29331}, {-14612, -29330}, {-14615, -29328}, {-14618, -29327}, {-14621, -29325}, {-14623, -29324},
    {-14626, -29323}, {-14629, -29321}, {-14632, -29320}, {-14635, -29318}, {-14637, -29317}, {-14640, -29316},
    {-14643, -29314}, {-14646, -29313}, {-14649, -29311}, {-14651, -29310}, {-14654, -29309}, {-14657, -29307},
    {-14660, -29306}, {-14663, -29304}, {-14665, -29303}, {-14668, -29302}, {-14671, -29300}, {-14674, -29299},
    {-14677, -29297}, {-14680, -29296}, {-14682, -29295}, {-14685, -29293}, {-14688, -29292}, {-14691, -29290},
    {-14694, -29289}, {-14696, -29288}, {-14699, -29286}, {-14702, -29285}, {-14705, -29283}, {-14708, -29282},
    {-14710, -29280}, {-14713, -29279}, {-14716, -29278}, {-14719, -29276}, {-14722, -29275}, {-14724, -29273},
    {-14727, -29272}, {-14730, -29271}, {-14733, -29269}, {-14736, -29268}, {-14738, -29266}, {-14741, -29265},
    {-14744, -29264}, {-14747, -29262}, {-14750, -29261}, {-14753, -29259}, {-14755, -29258}, {-14758, -29256},
    {-14761, -29255}, {-14764, -29254}, {-14767, -29252}, {-14769, -29251}, {-14772, -29249}, {-14775, -29248},
    {-14778, -29247}, {-14781, -29245}, {-14783, -29244}, {-14786, -29242}, {-14789, -29241}, {-14792, -29239},
    {-14795, -29238}, {-14797, -29237}, {-14800, -29235}, {-14803, -29234}, {-14806, -29232}, {-14809, -29231},
    {-14811, -29230}, {-14814, -29228}, {-14817, -29227}, {-14820, -29225}, {-14823, -29224}, {-14825, -29222},
    {-14828, -29221}, {-14831, -29220}, {-14834, -29218}, {-14837, -29217}, {-14839, -29215}, {-14842, -29214},
    {-14845, -29212}, {-14848, -29211}, {-14851, -29210}, {-14853, -29208}, {-14856, -29207}, {-14859, -29205},
    {-14862, -29204}, {-14865, -29202}, {-14867, -29201}, {-14870, -29200}, {-14873, -29198}, {-14876, -29197},
    {-14879, -29195}, {-14881, -29194}, {-14884, -29193}, {-14887, -29191}, {-14890, -29190}, {-14893, -29188},
    {-14895, -29187}, {-14898, -29185}, {-14901, -29184}, {-14904, -29183}, {-14907, -29181}, {-14909, -29180},
    {-14912, -29178}, {-14915, -29177}, {-14918, -29175}, {-14921, -29174}, {-14923, -29173}, {-14926, -29171},
    {-14929, -29170}, {-14932, -29168}, {-14935, -29167}, {-14937, -29165}, {-14940, -29164}, {-14943, -29162},
    {-14946, -29161}, {-14949, -29160}, {-14951, -29158}, {-14954, -29157}, {-14957, -29155}, {-14960, -29154},
    {-14963, -29152}, {-14965, -29151}, {-14968, -29150}, {-14971, -29148}, {-14974, -29147}, {-14976, -29145},
    {-14979, -29144}, {-14982, -29142}, {-14985, -29141}, {-14988, -29140}, {-14990, -29138}, {-14993, -29137},
    {-14996, -29135}, {-14999, -29134}, {-15002, -29132}, {-15004, -29131}, {-15007, -29129}, {-15010, -29128},
    {-15013, -29127}, {-15016, -29125}, {-15018, -29124}, {-15021, -29122}, {-15024, -29121}, {-15027, -29119},
    {-15030, -29118}, {-15032, -29116}, {-15035, -29115}, {-15038, -29114}, {-15041, -29112}, {-15044, -29111},
    {-15046, -29109}, {-15049, -29108}, {-15052, -29106}, {-15055, -29105}, {-15057, -29104}, {-15060, -29102},
    {-15063, -29101}, {-15066, -29099}, {-15069, -29098}, {-15071, -29096}, {-15074, -29095}, {-15077, -29093},
    {-15080, -29092}, {-15083, -29091}, {-15085, -29089}, {-15088, -29088}, {-15091, -29086}, {-15094, -29085},
    {-15097, -29083}, {-15099, -29082}, {-15102, -29080}, {-15105, -29079}, {-15108, -29077}, {-15110, -29076},
    {-15113, -29075}, {-15116, -29073}, {-15119, -29072}, {-15122, -29070}, {-15124, -29069}, {-15127, -29067},
    {-15130, -29066}, {-15133, -29064}, {-15136, -29063}, {-15138, -29062}, {-15141, -29060}, {-15144, -29059},
    {-15147, -29057}, {-15149, -29056}, {-15152, -29054}, {-15155, -29053}, {-15158, -29051}, {-15161, -29050},
    {-15163, -29048}, {-15166, -29047}, {-15169, -29046}, {-15172, -29044}, {-15175, -29043}, {-15177, -29041},
    {-15180, -29040}, {-15183, -29038}, {-15186, -29037}, {-15188, -29035}, {-15191, -29034}, {-15194, -29032},
    {-15197, -29031}, {-15200, -29030}, {-15202, -29028}, {-15205, -29027}, {-15208, -29025}, {-15211, -29024},
    {-15213, -29022}, {-15216, -29021}, {-15219, -29019}, {-15222, -29018}, {-15225, -29016}, {-15227, -29015},
    {-15230, -29013}, {-15233, -29012}, {-15236, -29011}, {-15239, -29009}, {-15241, -29008}, {-15244, -29006},
    {-15247, -29005}, {-15250, -29003}, {-15252, -29002}, {-15255, -29000}, {-15258, -28999}, {-15261, -28997},
    {-15264, -28996}, {-15266, -28994}, {-15269, -28993}, {-15272, -28992}, {-15275, -28990}, {-15277, -28989},
    {-15280, -28987}, {-15283, -28986}, {-15286, -28984}, {-15289, -28983}, {-15291, -28981}, {-15294, -28980},
    {-15297, -28978}, {-15300, -28977}, {-15302, -28975}, {-15305, -28974}, {-15308, -28973}, {-15311, -28971},
    {-15314, -28970}, {-15316, -28968}, {-15319, -28967}, {-15322, -28965}, {-15325, -28964}, {-15327, -28962},
    {-15330, -28961}, {-15333, -28959}, {-15336, -28958}, {-15339, -28956}, {-15341, -28955}, {-15344, -28953},
    {-15347, -28952}, {-15350, -28950}, {-15352, -28949}, {-15355, -28948}, {-15358, -28946}, {-15361, -28945},
    {-15364, -28943}, {-15366, -28942}, {-15369, -28940}, {-15372, -28939}, {-15375, -28937}, {-15377, -28936},
    {-15380, -28934}, {-15383, -28933}, {-15386, -28931}, {-15389, -28930}, {-15391, -28928}, {-15394, -28927},
    {-15397, -28925}, {-15400, -28924}, {-15402, -28922}, {-15405, -28921}, {-15408, -28920}, {-15411, -28918},
    {-15413, -28917}, {-15416, -28915}, {-15419, -28914}, {-15422, -28912}, {-15425, -28911}, {-15427, -28909},
    {-15430, -28908}, {-15433, -28906}, {-15436, -28905}, {-15438, -28903}, {-15441, -28902}, {-15444, -28900},
    {-15447, -28899}, {-15449, -28897}, {-15452, -28896}, {-15455, -28894}, {-15458, -28893}, {-15461, -28891},
    {-15463, -28890}, {-15466, -28888}, {-15469, -28887}, {-15472, -28885}, {-15474, -28884}, {-15477, -28882},
    {-15480, -28881}, {-15483, -28880}, {-15486, -28878}, {-15488, -28877}, {-15491, -28875}, {-15494, -28874},
    {-15497, -28872}, {-15499, -28871}, {-15502, -28869}, {-15505, -28868}, {-15508, -28866}, {-15510, -28865},
    {-15513, -28863}, {-15516, -28862}, {-15519, -28860}, {-15521, -28859}, {-15524, -28857}, {-15527, -28856},
    {-15530, -28854}, {-15533, -28853}, {-15535, -28851}, {-15538, -28850}, {-15541, -28848}, {-15544, -28847},
    {-15546, -28845}, {-15549, -28844}, {-15552, -28842}, {-15555, -28841}, {-15557, -28839}, {-15560, -28838},
    {-15563, -28836}, {-15566, -28835}, {-15568, -28833}, {-15571, -28832}, {-15574, -28830}, {-15577, -28829},
    {-15580, -28827}, {-15582, -28826}, {-15585, -28824}, {-15588, -28823}, {-15591, -28821}, {-15593, -28820},
    {-15596, -28818}, {-15599, -28817}, {-15602, -28815}, {-15604, -28814}, {-15607, -28812}, {-15610, -28811},
    {-15613, -28809}, {-15615, -28808}, {-15618, -28806}, {-15621, -28805}, {-15624, -28803}, {-15627, -28802},
    {-15629, -28800}, {-15632, -28799}, {-15635, -28797}, {-15638, -28796}, {-15640, -28794}, {-15643, -28793},
    {-15646, -28791}, {-15649, -28790}, {-15651, -28788}, {-15654, -28787}, {-15657, -28785}, {-15660, -28784},
    {-15662, -28782}, {-15665, -28781}, {-15668, -28779}, {-15671, -28778}, {-15673, -28776}, {-15676, -28775},
    {-15679, -28773}, {-15682, -28772}, {-15684, -28770}, {-15687, -28769}, {-15690, -28767}, {-15693, -28766},
    {-15696, -28764}, {-15698, -28763}, {-15701, -28761}, {-15704, -28760}, {-15707, -28758}, {-15709, -28757},
    {-15712, -28755}, {-15715, -28754}, {-15718, -28752}, {-15720, -28751}, {-15723, -28749}, {-15726, -28748},
    {-15729, -28746}, {-15731, -28745}, {-15734, -28743}, {-15737, -28742}, {-15740, -28740}, {-15742, -28739},
    {-15745, -28737}, {-15748, -28736}, {-15751, -28734}, {-15753, -28733}, {-15756, -28731}, {-15759, -28730},
    {-15762, -28728}, {-15764, -28727}, {-15767, -28725}, {-15770, -28724}, {-15773, -28722}, {-15775, -28721},
    {-15778, -28719}, {-15781, -28718}, {-15784, -28716}, {-15786, -28715}, {-15789, -28713}, {-15792, -28712},
    {-15795, -28710}, {-15797, -28709}, {-15800, -28707}, {-15803, -28706}, {-15806, -28704}, {-15808, -28703},
    {-15811, -28701}, {-15814, -28699}, {-15817, -28698}, {-15819, -28696}, {-15822, -28695}, {-15825, -28693},
    {-15828, -28692}, {-15830, -28690}, {-15833, -28689}, {-15836, -28687}, {-15839, -28686}, {-15841, -28684},
    {-15844, -28683}, {-15847, -28681}, {-15850, -28680}, {-15852, -28678}, {-15855, -28677}, {-15858, -28675},
    {-15861, -28674}, {-15863, -28672}, {-15866, -28671}, {-15869, -28669}, {-15872, -28668}, {-15874, -28666},
    {-15877, -28665}, {-15880, -28663}, {-15883, -28662}, {-15885, -28660}, {-15888, -28658}, {-15891, -28657},
    {-15894, -28655}, {-15896, -28654}, {-15899, -28652}, {-15902, -28651}, {-15905, -28649}, {-15907, -28648},
    {-15910, -28646}, {-15913, -28645}, {-15916, -28643}, {-15918, -28642}, {-15921, -28640}, {-15924, -28639},
    {-15927, -28637}, {-15929, -28636}, {-15932, -28634}, {-15935, -28633}, {-15938, -28631}, {-15940, -28629},
    {-15943, -28628}, {-15946, -28626}, {-15949, -28625}, {-15951, -28623}, {-15954, -28622}, {-15957, -28620},
    {-15960, -28619}, {-15962, -28617}, {-15965, -28616}, {-15968, -28614}, {-15971, -28613}, {-15973, -28611},
    {-15976, -28610}, {-15979, -28608}, {-15982, -28607}, {-15984, -28605}, {-15987, -28603}, {-15990, -28602},
    {-15992, -28600}, {-15995, -28599}, {-15998, -28597}, {-16001, -28596}, {-16003, -28594}, {-16006, -28593},
    {-16009, -28591}, {-16012, -28590}, {-16014, -28588}, {-16017, -28587}, {-16020, -28585}, {-16023, -28583},
    {-16025, -28582}, {-16028, -28580}, {-16031, -28579}, {-16034, -28577}, {-16036, -28576}, {-16039, -28574},
    {-16042, -28573}, {-16045, -28571}, {-16047, -28570}, {-16050, -28568}, {-16053, -28567}, {-16056, -28565},
    {-16058, -28564}, {-16061, -28562}, {-16064, -28560}, {-16066, -28559}, {-16069, -28557}, {-16072, -28556},
    {-16075, -28554}, {-16077, -28553}, {-16080, -28551}, {-16083, -28550}, {-16086, -28548}, {-16088, -28547},
    {-16091, -28545}, {-16094, -28543}, {-16097, -28542}, {-16099, -28540}, {-16102, -28539}, {-16105, -28537},
    {-16108, -28536}, {-16110, -28534}, {-16113, -28533}, {-16116, -28531}, {-16118, -28530}, {-16121, -28528},
    {-16124, -28526}, {-16127, -28525}, {-16129, -28523}, {-16132, -28522}, {-16135, -28520}, {-16138, -28519},
    {-16140, -28517}, {-16143, -28516}, {-16146, -28514}, {-16149, -28513}, {-16151, -28511}, {-16154, -28509},
    {-16157, -28508}, {-16159, -28506}, {-16162, -28505}, {-16165, -28503}, {-16168, -28502}, {-16170, -28500},
    {-16173, -28499}, {-16176, -28497}, {-16179, -28496}, {-16181, -28494}, {-16184, -28492}, {-16187, -28491},
    {-16190, -28489}, {-16192, -28488}, {-16195, -28486}, {-16198, -28485}, {-16200, -28483}, {-16203, -28482},
    {-16206, -28480}, {-16209, -28478}, {-16211, -28477}, {-16214, -28475}, {-16217, -28474}, {-16220, -28472},
    {-16222, -28471}, {-16225, -28469}, {-16228, -28468}, {-16230, -28466}, {-16233, -28464}, {-16236, -28463},
    {-16239, -28461}, {-16241, -28460}, {-16244, -28458}, {-16247, -28457}, {-16250, -28455}, {-16252, -28454},
    {-16255, -28452}, {-16258, -28450}, {-16261, -28449}, {-16263, -28447}, {-16266, -28446}, {-16269, -28444},
    {-16271, -28443}, {-16274, -28441}, {-16277, -28440}, {-16280, -28438}, {-16282, -28436}, {-16285, -28435},
    {-16288, -28433}, {-16291, -28432}, {-16293, -28430}, {-16296, -28429}, {-16299, -28427}, {-16301, -28425},
    {-16304, -28424}, {-16307, -28422}, {-16310, -28421}, {-16312, -28419}, {-16315, -28418}, {-16318, -28416},
    {-16320, -28415}, {-16323, -28413}, {-16326, -28411}, {-16329, -28410}, {-16331, -28408}, {-16334, -28407},
    {-16337, -28405}, {-16340, -28404}, {-16342, -28402}, {-16345, -28400}, {-16348, -28399}, {-16350, -28397},
    {-16353, -28396}, {-16356, -28394}, {-16359, -28393}, {-16361, -28391}, {-16364, -28389}, {-16367, -28388},
    {-16369, -28386}, {-16372, -28385}, {-16375, -28383}, {-16378, -28382}, {-16380, -28380}, {-16383, -28378},
    {-16386, -28377}, {-16389, -28375}, {-16391, -28374}, {-16394, -28372}, {-16397, -28371}, {-16399, -28369},
    {-16402, -28367}, {-16405, -28366}, {-16408, -28364}, {-16410, -28363}, {-16413, -28361}, {-16416, -28360},
    {-16418, -28358}, {-16421, -28356}, {-16424, -28355}, {-16427, -28353}, {-16429, -28352}, {-16432, -28350},
    {-16435, -28349}, {-16437, -28347}, {-16440, -28345}, {-16443, -28344}, {-16446, -28342}, {-16448, -28341},
    {-16451, -28339}, {-16454, -28338}, {-16456, -28336}, {-16459, -28334}, {-16462, -28333}, {-16465, -28331},
    {-16467, -28330}, {-16470, -28328}, {-16473, -28326}, {-16476, -28325}, {-16478, -28323}, {-16481, -28322},
    {-16484, -28320}, {-16486, -28319}, {-16489, -28317}, {-16492, -28315}, {-16495, -28314}, {-16497, -28312},
    {-16500, -28311}, {-16503, -28309}, {-16505, -28307}, {-16508, -28306}, {-16511, -28304}, {-16514, -28303},
    {-16516, -28301}, {-16519, -28300}, {-16522, -28298}, {-16524, -28296}, {-16527, -28295}, {-16530, -28293},
    {-16533, -28292}, {-16535, -28290}, {-16538, -28288}, {-16541, -28287}, {-16543, -28285}, {-16546, -28284},
    {-16549, -28282}, {-16551, -28281}, {-16554, -28279}, {-16557, -28277}, {-16560, -28276}, {-16562, -28274},
    {-16565, -28273}, {-16568, -28271}, {-16570, -28269}, {-16573, -28268}, {-16576, -28266}, {-16579, -28265},
    {-16581, -28263}, {-16584, -28261}, {-16587, -28260}, {-16589, -28258}, {-16592, -28257}, {-16595, -28255},
    {-16598, -28254}, {-16600, -28252}, {-16603, -28250}, {-16606, -28249}, {-16608, -28247}, {-16611, -28246},
    {-16614, -28244}, {-16617, -28242}, {-16619, -28241}, {-16622, -28239}, {-16625, -28238}, {-16627, -28236},
    {-16630, -28234}, {-16633, -28233}, {-16635, -28231}, {-16638, -28230}, {-16641, -28228}, {-16644, -28226},
    {-16646, -28225}, {-16649, -28223}, {-16652, -28222}, {-16654, -28220}, {-16657, -28218}, {-16660, -28217},
    {-16663, -28215}, {-16665, -28214}, {-16668, -28212}, {-16671, -28210}, {-16673, -28209}, {-16676, -28207},
    {-16679, -28206}, {-16681, -28204}, {-16684, -28202}, {-16687, -28201}, {-16690, -28199}, {-16692, -28198},
    {-16695, -28196}, {-16698, -28194}, {-16700, -28193}, {-16703, -28191}, {-16706, -28190}, {-16708, -28188},
    {-16711, -28186}, {-16714, -28185}, {-16717, -28183}, {-16719, -28182}, {-16722, -28180}, {-16725, -28178},
    {-16727, -28177}, {-16730, -28175}, {-16733, -28174}, {-16736, -28172}, {-16738, -28170}, {-16741, -28169},
    {-16744, -28167}, {-16746, -28166}, {-16749, -28164}, {-16752, -28162}, {-16754, -28161}, {-16757, -28159},
    {-16760, -28158}, {-16763, -28156}, {-16765, -28154}, {-16768, -28153}, {-16771, -28151}, {-16773, -28150},
    {-16776, -28148}, {-16779, -28146}, {-16781, -28145}, {-16784, -28143}, {-16787, -28142}, {-16789, -28140},
    {-16792, -28138}, {-16795, -28137}, {-16798, -28135}, {-16800, -28133}, {-16803, -28132}, {-16806, -28130},
    {-16808, -28129}, {-16811, -28127}, {-16814, -28125}, {-16816, -28124}, {-16819, -28122}, {-16822, -28121},
    {-16825, -28119}, {-16827, -28117}, {-16830, -28116}, {-16833, -28114}, {-16835, -28113}, {-16838, -28111},
    {-16841, -28109}, {-16843, -28108}, {-16846, -28106}, {-16849, -28104}, {-16852, -28103}, {-16854, -28101},
    {-16857, -28100}, {-16860, -28098}, {-16862, -28096}, {-16865, -28095}, {-16868, -28093}, {-16870, -28092},
    {-16873, -28090}, {-16876, -28088}, {-16878, -28087}, {-16881, -28085}, {-16884, -28083}, {-16887, -28082},
    {-16889, -28080}, {-16892, -28079}, {-16895, -28077}, {-16897, -28075}, {-16900, -28074}, {-16903, -28072},
    {-16905, -28070}, {-16908, -28069}, {-16911, -28067}, {-16913, -28066}, {-16916, -28064}, {-16919, -28062},
    {-16922, -28061}, {-16924, -28059}, {-16927, -28057}, {-16930, -28056}, {-16932, -28054}, {-16935, -28053},
    {-16938, -28051}, {-16940, -28049}, {-16943, -28048}, {-16946, -28046}, {-16948, -28044}, {-16951, -28043},
    {-16954, -28041}, {-16956, -28040}, {-16959, -28038}, {-16962, -28036}, {-16965, -28035}, {-16967, -28033},
    {-16970, -28031}, {-16973, -28030}, {-16975, -28028}, {-16978, -28027}, {-16981, -28025}, {-16983, -28023},
    {-16986, -28022}, {-16989, -28020}, {-16991, -28018}, {-16994, -28017}, {-16997, -28015}, {-16999, -28014},
    {-17002, -28012}, {-17005, -28010}, {-17008, -28009}, {-17010, -28007}, {-17013, -28005}, {-17016, -28004},
    {-17018, -28002}, {-17021, -28001}, {-17024, -27999}, {-17026, -27997}, {-17029, -27996}, {-17032, -27994},
    {-17034, -27992}, {-17037, -27991}, {-17040, -27989}, {-17042, -27987}, {-17045, -27986}, {-17048, -27984},
    {-17050, -27983}, {-17053, -27981}, {-17056, -27979}, {-17059, -27978}, {-17061, -27976}, {-17064, -27974},
    {-17067, -27973}, {-17069, -27971}, {-17072, -27969}, {-17075, -27968}, {-17077, -27966}, {-17080, -27965},
    {-17083, -27963}, {-17085, -27961}, {-17088, -27960}, {-17091, -27958}, {-17093, -27956}, {-17096, -27955},
    {-17099, -27953}, {-17101, -27951}, {-17104, -27950}, {-17107, -27948}, {-17109, -27947}, {-17112, -27945},
    {-17115, -27943}, {-17117, -27942}, {-17120, -27940}, {-17123, -27938}, {-17126, -27937}, {-17128, -27935},
    {-17131, -27933}, {-17134, -27932}, {-17136, -27930}, {-17139, -27928}, {-17142, -27927}, {-17144, -27925},
    {-17147, -27924}, {-17150, -27922}, {-17152, -27920}, {-17155, -27919}, {-17158, -27917}, {-17160, -27915},
    {-17163, -27914}, {-17166, -27912}, {-17168, -27910}, {-17171, -27909}, {-17174, -27907}, {-17176, -27905},
    {-17179, -27904}, {-17182, -27902}, {-17184, -27901}, {-17187, -27899}, {-17190, -27897}, {-17192, -27896},
    {-17195, -27894}, {-17198, -27892}, {-17200, -27891}, {-17203, -27889}, {-17206, -27887}, {-17208, -27886},
    {-17211, -27884}, {-17214, -27882}, {-17216, -27881}, {-17219, -27879}, {-17222, -27877}, {-17225, -27876},
    {-17227, -27874}, {-17230, -27872}, {-17233, -27871}, {-17235, -27869}, {-17238, -27868}, {-17241, -27866},
    {-17243, -27864}, {-17246, -27863}, {-17249, -27861}, {-17251, -27859}, {-17254, -27858}, {-17257, -27856},
    {-17259, -27854}, {-17262, -27853}, {-17265, -27851}, {-17267, -27849}, {-17270, -27848}, {-17273, -27846},
    {-17275, -27844}, {-17278, -27843}, {-17281, -27841}, {-17283, -27839}, {-17286, -27838}, {-17289, -27836},
    {-17291, -27834}, {-17294, -27833}, {-17297, -27831}, {-17299, -27829}, {-17302, -27828}, {-17305, -27826},
    {-17307, -27824}, {-17310, -27823}, {-17313, -27821}, {-17315, -27819}, {-17318, -27818}, {-17321, -27816},
    {-17323, -27814}, {-17326, -27813}, {-17329, -27811}, {-17331, -27810}, {-17334, -27808}, {-17337, -27806},
    {-17339, -27805}, {-17342, -27803}, {-17345, -27801}, {-17347, -27800}, {-17350, -27798}, {-17353, -27796},
    {-17355, -27795}, {-17358, -27793}, {-17361, -27791}, {-17363, -27790}, {-17366, -27788}, {-17369, -27786},
    {-17371, -27785}, {-17374, -27783}, {-17377, -27781}, {-17379, -27780}, {-17382, -27778}, {-17385, -27776},
    {-17387, -27775}, {-17390, -27773}, {-17393, -27771}, {-17395, -27770}, {-17398, -27768}, {-17401, -27766},
    {-17403, -27765}, {-17406, -27763}, {-17409, -27761}, {-17411, -27760}, {-17414, -27758}, {-17417, -27756},
    {-17419, -27755}, {-17422, -27753}, {-17425, -27751}, {-17427, -27750}, {-17430, -27748}, {-17432, -27746},
    {-17435, -27745}, {-17438, -27743}, {-17440, -27741}, {-17443, -27739}, {-17446, -27738}, {-17448, -27736},
    {-17451, -27734}, {-17454, -27733}, {-17456, -27731}, {-17459, -27729}, {-17462, -27728}, {-17464, -27726},
    {-17467, -27724}, {-17470, -27723}, {-17472, -27721}, {-17475, -27719}, {-17478, -27718}, {-17480, -27716},
    {-17483, -27714}, {-17486, -27713}, {-17488, -27711}, {-17491, -27709}, {-17494, -27708}, {-17496, -27706},
    {-17499, -27704}, {-17502, -27703}, {-17504, -27701}, {-17507, -27699}, {-17510, -27698}, {-17512, -27696},
    {-17515, -27694}, {-17518, -27693}, {-17520, -27691}, {-17523, -27689}, {-17525, -27688}, {-17528, -27686},
    {-17531, -27684}, {-17533, -27682}, {-17536, -27681}, {-17539, -27679}, {-17541, -27677}, {-17544, -27676},
    {-17547, -27674}, {-17549, -27672}, {-17552, -27671}, {-17555, -27669}, {-17557, -27667}, {-17560, -27666},
    {-17563, -27664}, {-17565, -27662}, {-17568, -27661}, {-17571, -27659}, {-17573, -27657}, {-17576, -27656},
    {-17579, -27654}, {-17581, -27652}, {-17584, -27650}, {-17587, -27649}, {-17589, -27647}, {-17592, -27645},
    {-17594, -27644}, {-17597, -27642}, {-17600, -27640}, {-17602, -27639}, {-17605, -27637}, {-17608, -27635},
    {-17610, -27634}, {-17613, -27632}, {-17616, -27630}, {-17618, -27629}, {-17621, -27627}, {-17624, -27625},
    {-17626, -27623}, {-17629, -27622}, {-17632, -27620}, {-17634, -27618}, {-17637, -27617}, {-17639, -27615},
    {-17642, -27613}, {-17645, -27612}, {-17647, -27610}, {-17650, -27608}, {-17653, -27607}, {-17655, -27605},
    {-17658, -27603}, {-17661, -27601}, {-17663, -27600}, {-17666, -27598}, {-17669, -27596}, {-17671, -27595},
    {-17674, -27593}, {-17677, -27591}, {-17679, -27590}, {-17682, -27588}, {-17684, -27586}, {-17687, -27585},
    {-17690, -27583}, {-17692, -27581}, {-17695, -27579}, {-17698, -27578}, {-17700, -27576}, {-17703, -27574},
    {-17706, -27573}, {-17708, -27571}, {-17711, -27569}, {-17714, -27568}, {-17716, -27566}, {-17719, -27564},
    {-17721, -27562}, {-17724, -27561}, {-17727, -27559}, {-17729, -27557}, {-17732, -27556}, {-17735, -27554},
    {-17737, -27552}, {-17740, -27551}, {-17743, -27549}, {-17745, -27547}, {-17748, -27545}, {-17751, -27544},
    {-17753, -27542}, {-17756, -27540}, {-17758, -27539}, {-17761, -27537}, {-17764, -27535}, {-17766, -27534},
    {-17769, -27532}, {-17772, -27530}, {-17774, -27528}, {-17777, -27527}, {-17780, -27525}, {-17782, -27523},
    {-17785, -27522}, {-17787, -27520}, {-17790, -27518}, {-17793, -27517}, {-17795, -27515}, {-17798, -27513},
    {-17801, -27511}, {-17803, -27510}, {-17806, -27508}, {-17809, -27506}, {-17811, -27505}, {-17814, -27503},
    {-17817, -27501}, {-17819, -27499}, {-17822, -27498}, {-17824, -27496}, {-17827, -27494}, {-17830, -27493},
    {-17832, -27491}, {-17835, -27489}, {-17838, -27487}, {-17840, -27486}, {-17843, -27484}, {-17846, -27482},
    {-17848, -27481}, {-17851, -27479}, {-17853, -27477}, {-17856, -27476}, {-17859, -27474}, {-17861, -27472},
    {-17864, -27470}, {-17867, -27469}, {-17869, -27467}, {-17872, -27465}, {-17874, -27464}, {-17877, -27462},
    {-17880, -27460}, {-17882, -27458}, {-17885, -27457}, {-17888, -27455}, {-17890, -27453}, {-17893, -27452},
    {-17896, -27450}, {-17898, -27448}, {-17901, -27446}, {-17903, -27445}, {-17906, -27443}, {-17909, -27441},
    {-17911, -27440}, {-17914, -27438}, {-17917, -27436}, {-17919, -27434}, {-17922, -27433}, {-17924, -27431},
    {-17927, -27429}, {-17930, -27427}, {-17932, -27426}, {-17935, -27424}, {-17938, -27422}, {-17940, -27421},
    {-17943, -27419}, {-17946, -27417}, {-17948, -27415}, {-17951, -27414}, {-17953, -27412}, {-17956, -27410},
    {-17959, -27409}, {-17961, -27407}, {-17964, -27405}, {-17967, -27403}, {-17969, -27402}, {-17972, -27400},
    {-17974, -27398}, {-17977, -27396}, {-17980, -27395}, {-17982, -27393}, {-17985, -27391}, {-17988, -27390},
    {-17990, -27388}, {-17993, -27386}, {-17995, -27384}, {-17998, -27383}, {-18001, -27381}, {-18003, -27379},
    {-18006, -27378}, {-18009, -27376}, {-18011, -27374}, {-18014, -27372}, {-18016, -27371}, {-18019, -27369},
    {-18022, -27367}, {-18024, -27365}, {-18027, -27364}, {-18030, -27362}, {-18032, -27360}, {-18035, -27359},
    {-18037, -27357}, {-18040, -27355}, {-18043, -27353}, {-18045, -27352}, {-18048, -27350}, {-18051, -27348},
    {-18053, -27346}, {-18056, -27345}, {-18058, -27343}, {-18061, -27341}, {-18064, -27339}, {-18066, -27338},
    {-18069, -27336}, {-18071, -27334}, {-18074, -27333}, {-18077, -27331}, {-18079, -27329}, {-18082, -27327},
    {-18085, -27326}, {-18087, -27324}, {-18090, -27322}, {-18092, -27320}, {-18095, -27319}, {-18098, -27317},
    {-18100, -27315}, {-18103, -27313}, {-18106, -27312}, {-18108, -27310}, {-18111, -27308}, {-18113, -27307},
    {-18116, -27305}, {-18119, -27303}, {-18121, -27301}, {-18124, -27300}, {-18126, -27298}, {-18129, -27296},
    {-18132, -27294}, {-18134, -27293}, {-18137, -27291}, {-18140, -27289}, {-18142, -27287}, {-18145, -27286},
    {-18147, -27284}, {-18150, -27282}, {-18153, -27280}, {-18155, -27279}, {-18158, -27277}, {-18160, -27275},
    {-18163, -27273}, {-18166, -27272}, {-18168, -27270}, {-18171, -27268}, {-18174, -27267}, {-18176, -27265},
    {-18179, -27263}, {-18181, -27261}, {-18184, -27260}, {-18187, -27258}, {-18189, -27256}, {-18192, -27254},
    {-18194, -27253}, {-18197, -27251}, {-18200, -27249}, {-18202, -27247}, {-18205, -27246}, {-18208, -27244},
    {-18210, -27242}, {-18213, -27240}, {-18215, -27239}, {-18218, -27237}, {-18221, -27235}, {-18223, -27233},
    {-18226, -27232}, {-18228, -27230}, {-18231, -27228}, {-18234, -27226}, {-18236, -27225}, {-18239, -27223},
    {-18241, -27221}, {-18244, -27219}, {-18247, -27218}, {-18249, -27216}, {-18252, -27214}, {-18255, -27212},
    {-18257, -27211}, {-18260, -27209}, {-18262, -27207}, {-18265, -27205}, {-18268, -27204}, {-18270, -27202},
    {-18273, -27200}, {-18275, -27198}, {-18278, -27197}, {-18281, -27195}, {-18283, -27193}, {-18286, -27191},
    {-18288, -27190}, {-18291, -27188}, {-18294, -27186}, {-18296, -27184}, {-18299, -27183}, {-18301, -27181},
    {-18304, -27179}, {-18307, -27177}, {-18309, -27176}, {-18312, -27174}, {-18314, -27172}, {-18317, -27170},
    {-18320, -27169}, {-18322, -27167}, {-18325, -27165}, {-18328, -27163}, {-18330, -27162}, {-18333, -27160},
    {-18335, -27158}, {-18338, -27156}, {-18341, -27154}, {-18343, -27153}, {-18346, -27151}, {-18348, -27149},
    {-18351, -27147}, {-18354, -27146}, {-18356, -27144}, {-18359, -27142}, {-18361, -27140}, {-18364, -27139},
    {-18367, -27137}, {-18369, -27135}, {-18372, -27133}, {-18374, -27132}, {-18377, -27130}, {-18380, -27128},
    {-18382, -27126}, {-18385, -27125}, {-18387, -27123}, {-18390, -27121}, {-18393, -27119}, {-18395, -27118},
    {-18398, -27116}, {-18400, -27114}, {-18403, -27112}, {-18406, -27110}, {-18408, -27109}, {-18411, -27107},
    {-18413, -27105}, {-18416, -27103}, {-18419, -27102}, {-18421, -27100}, {-18424, -27098}, {-18426, -27096},
    {-18429, -27095}, {-18432, -27093}, {-18434, -27091}, {-18437, -27089}, {-18439, -27088}, {-18442, -27086},
    {-18445, -27084}, {-18447, -27082}, {-18450, -27080}, {-18452, -27079}, {-18455, -27077}, {-18458, -27075},
    {-18460, -27073}, {-18463, -27072}, {-18465, -27070}, {-18468, -27068}, {-18470, -27066}, {-18473, -27064},
    {-18476, -27063}, {-18478, -27061}, {-18481, -27059}, {-18483, -27057}, {-18486, -27056}, {-18489, -27054},
    {-18491, -27052}, {-18494, -27050}, {-18496, -27049}, {-18499, -27047}, {-18502, -27045}, {-18504, -27043},
    {-18507, -27041}, {-18509, -27040}, {-18512, -27038}, {-18515, -27036}, {-18517, -27034}, {-18520, -27033},
    {-18522, -27031}, {-18525, -27029}, {-18528, -27027}, {-18530, -27025}, {-18533, -27024}, {-18535, -27022},
    {-18538, -27020}, {-18540, -27018}, {-18543, -27017}, {-18546, -27015}, {-18548, -27013}, {-18551, -27011},
    {-18553, -27009}, {-18556, -27008}, {-18559, -27006}, {-18561, -27004}, {-18564, -27002}, {-18566, -27001},
    {-18569, -26999}, {-18572, -26997}, {-18574, -26995}, {-18577, -26993}, {-18579, -26992}, {-18582, -26990},
    {-18585, -26988}, {-18587, -26986}, {-18590, -26985}, {-18592, -26983}, {-18595, -26981}, {-18597, -26979},
    {-18600, -26977}, {-18603, -26976}, {-18605, -26974}, {-18608, -26972}, {-18610, -26970}, {-18613, -26968},
    {-18616, -26967}, {-18618, -26965}, {-18621, -26963}, {-18623, -26961}, {-18626, -26960}, {-18628, -26958},
    {-18631, -26956}, {-18634, -26954}, {-18636, -26952}, {-18639, -26951}, {-18641, -26949}, {-18644, -26947},
    {-18647, -26945}, {-18649, -26943}, {-18652, -26942}, {-18654, -26940}, {-18657, -26938}, {-18659, -26936},
    {-18662, -26935}, {-18665, -26933}, {-18667, -26931}, {-18670, -26929}, {-18672, -26927}, {-18675, -26926},
    {-18678, -26924}, {-18680, -26922}, {-18683, -26920}, {-18685, -26918}, {-18688, -26917}, {-18690, -26915},
    {-18693, -26913}, {-18696, -26911}, {-18698, -26909}, {-18701, -26908}, {-18703, -26906}, {-18706, -26904},
    {-18709, -26902}, {-18711, -26901}, {-18714, -26899}, {-18716, -26897}, {-18719, -26895}, {-18721, -26893},
    {-18724, -26892}, {-18727, -26890}, {-18729, -26888}, {-18732, -26886}, {-18734, -26884}, {-18737, -26883},
    {-18739, -26881}, {-18742, -26879}, {-18745, -26877}, {-18747, -26875}, {-18750, -26874}, {-18752, -26872},
    {-18755, -26870}, {-18757, -26868}, {-18760, -26866}, {-18763, -26865}, {-18765, -26863}, {-18768, -26861},
    {-18770, -26859}, {-18773, -26857}, {-18776, -26856}, {-18778, -26854}, {-18781, -26852}, {-18783, -26850},
    {-18786, -26848}, {-18788, -26847}, {-18791, -26845}, {-18794, -26843}, {-18796, -26841}, {-18799, -26839},
    {-18801, -26838}, {-18804, -26836}, {-18806, -26834}, {-18809, -26832}, {-18812, -26830}, {-18814, -26829},
    {-18817, -26827}, {-18819, -26825}, {-18822, -26823}, {-18824, -26821}, {-18827, -26820}, {-18830, -26818},
    {-18832, -26816}, {-18835, -26814}, {-18837, -26812}, {-18840, -26811}, {-18842, -26809}, {-18845, -26807},
    {-18848, -26805}, {-18850, -26803}, {-18853, -26801}, {-18855, -26800}, {-18858, -26798}, {-18860, -26796},
    {-18863, -26794}, {-18866, -26792}, {-18868, -26791}, {-18871, -26789}, {-18873, -26787}, {-18876, -26785},
    {-18878, -26783}, {-18881, -26782}, {-18883, -26780}, {-18886, -26778}, {-18889, -26776}, {-18891, -26774},
    {-18894, -26773}, {-18896, -26771}, {-18899, -26769}, {-18901, -26767}, {-18904, -26765}, {-18907, -26763},
    {-18909, -26762}, {-18912, -26760}, {-18914, -26758}, {-18917, -26756}, {-18919, -26754}, {-18922, -26753},
    {-18925, -26751}, {-18927, -26749}, {-18930, -26747}, {-18932, -26745}, {-18935, -26744}, {-18937, -26742},
    {-18940, -26740}, {-18942, -26738}, {-18945, -26736}, {-18948, -26734}, {-18950, -26733}, {-18953, -26731},
    {-18955, -26729}, {-18958, -26727}, {-18960, -26725}, {-18963, -26724}, {-18966, -26722}, {-18968, -26720},
    {-18971, -26718}, {-18973, -26716}, {-18976, -26714}, {-18978, -26713}, {-18981, -26711}, {-18983, -26709},
    {-18986, -26707}, {-18989, -26705}, {-18991, -26704}, {-18994, -26702}, {-18996, -26700}, {-18999, -26698},
    {-19001, -26696}, {-19004, -26694}, {-19007, -26693}, {-19009, -26691}, {-19012, -26689}, {-19014, -26687},
    {-19017, -26685}, {-19019, -26683}, {-19022, -26682}, {-19024, -26680}, {-19027, -26678}, {-19030, -26676},
    {-19032, -26674}, {-19035, -26673}, {-19037, -26671}, {-19040, -26669}, {-19042, -26667}, {-19045, -26665},
    {-19047, -26663}, {-19050, -26662}, {-19053, -26660}, {-19055, -26658}, {-19058, -26656}, {-19060, -26654},
    {-19063, -26652}, {-19065, -26651}, {-19068, -26649}, {-19070, -26647}, {-19073, -26645}, {-19076, -26643},
    {-19078, -26641}, {-19081, -26640}, {-19083, -26638}, {-19086, -26636}, {-19088, -26634}, {-19091, -26632},
    {-19093, -26630}, {-19096, -26629}, {-19099, -26627}, {-19101, -26625}, {-19104, -26623}, {-19106, -26621},
    {-19109, -26619}, {-19111, -26618}, {-19114, -26616}, {-19116, -26614}, {-19119, -26612}, {-19122, -26610},
    {-19124, -26608}, {-19127, -26607}, {-19129, -26605}, {-19132, -26603}, {-19134, -26601}, {-19137, -26599},
    {-19139, -26597}, {-19142, -26596}, {-19144, -26594}, {-19147, -26592}, {-19150, -26590}, {-19152, -26588},
    {-19155, -26586}, {-19157, -26585}, {-19160, -26583}, {-19162, -26581}, {-19165, -26579}, {-19167, -26577},
    {-19170, -26575}, {-19173, -26574}, {-19175, -26572}, {-19178, -26570}, {-19180, -26568}, {-19183, -26566},
    {-19185, -26564}, {-19188, -26563}, {-19190, -26561}, {-19193, -26559}, {-19195, -26557}, {-19198, -26555},
    {-19201, -26553}, {-19203, -26552}, {-19206, -26550}, {-19208, -26548}, {-19211, -26546}, {-19213, -26544},
    {-19216, -26542}, {-19218, -26540}, {-19221, -26539}, {-19223, -26537}, {-19226, -26535}, {-19229, -26533},
    {-19231, -26531}, {-19234, -26529}, {-19236, -26528}, {-19239, -26526}, {-19241, -26524}, {-19244, -26522},
    {-19246, -26520}, {-19249, -26518}, {-19251, -26517}, {-19254, -26515}, {-19256, -26513}, {-19259, -26511},
    {-19262, -26509}, {-19264, -26507}, {-19267, -26505}, {-19269, -26504}, {-19272, -26502}, {-19274, -26500},
    {-19277, -26498}, {-19279, -26496}, {-19282, -26494}, {-19284, -26493}, {-19287, -26491}, {-19290, -26489},
    {-19292, -26487}, {-19295, -26485}, {-19297, -26483}, {-19300, -26481}, {-19302, -26480}, {-19305, -26478},
    {-19307, -26476}, {-19310, -26474}, {-19312, -26472}, {-19315, -26470}, {-19317, -26468}, {-19320, -26467},
    {-19323, -26465}, {-19325, -26463}, {-19328, -26461}, {-19330, -26459}, {-19333, -26457}, {-19335, -26455},
    {-19338, -26454}, {-19340, -26452}, {-19343, -26450}, {-19345, -26448}, {-19348, -26446}, {-19350, -26444},
    {-19353, -26442}, {-19355, -26441}, {-19358, -26439}, {-19361, -26437}, {-19363, -26435}, {-19366, -26433},
    {-19368, -26431}, {-19371, -26429}, {-19373, -26428}, {-19376, -26426}, {-19378, -26424}, {-19381, -26422},
    {-19383, -26420}, {-19386, -26418}, {-19388, -26416}, {-19391, -26415}, {-19393, -26413}, {-19396, -26411},
    {-19399, -26409}, {-19401, -26407}, {-19404, -26405}, {-19406, -26403}, {-19409, -26402}, {-19411, -26400},
    {-19414, -26398}, {-19416, -26396}, {-19419, -26394}, {-19421, -26392}, {-19424, -26390}, {-19426, -26389},
    {-19429, -26387}, {-19431, -26385}, {-19434, -26383}, {-19437, -26381}, {-19439, -26379}, {-19442, -26377},
    {-19444, -26376}, {-19447, -26374}, {-19449, -26372}, {-19452, -26370}, {-19454, -26368}, {-19457, -26366},
    {-19459, -26364}, {-19462, -26362}, {-19464, -26361}, {-19467, -26359}, {-19469, -26357}, {-19472, -26355},
    {-19474, -26353}, {-19477, -26351}, {-19479, -26349}, {-19482, -26348}, {-19485, -26346}, {-19487, -26344},
    {-19490, -26342}, {-19492, -26340}, {-19495, -26338}, {-19497, -26336}, {-19500, -26334}, {-19502, -26333},
    {-19505, -26331}, {-19507, -26329}, {-19510, -26327}, {-19512, -26325}, {-19515, -26323}, {-19517, -26321},
    {-19520, -26320}, {-19522, -26318}, {-19525, -26316}, {-19527, -26314}, {-19530, -26312}, {-19532, -26310},
    {-19535, -26308}, {-19538, -26306}, {-19540, -26305}, {-19543, -26303}, {-19545, -26301}, {-19548, -26299},
    {-19550, -26297}, {-19553, -26295}, {-19555, -26293}, {-19558, -26291}, {-19560, -26290}, {-19563, -26288},
    {-19565, -26286}, {-19568, -26284}, {-19570, -26282}, {-19573, -26280}, {-19575, -26278}, {-19578, -26276},
    {-19580, -26275}, {-19583, -26273}, {-19585, -26271}, {-19588, -26269}, {-19590, -26267}, {-19593, -26265},
    {-19595, -26263}, {-19598, -26261}, {-19601, -26259}, {-19603, -26258}, {-19606, -26256}, {-19608, -26254},
    {-19611, -26252}, {-19613, -26250}, {-19616, -26248}, {-19618, -26246}, {-19621, -26244}, {-19623, -26243},
    {-19626, -26241}, {-19628, -26239}, {-19631, -26237}, {-19633, -26235}, {-19636, -26233}, {-19638, -26231},
    {-19641, -26229}, {-19643, -26228}, {-19646, -26226}, {-19648, -26224}, {-19651, -26222}, {-19653, -26220},
    {-19656, -26218}, {-19658, -26216}, {-19661, -26214}, {-19663, -26212}, {-19666, -26211}, {-19668, -26209},
    {-19671, -26207}, {-19673, -26205}, {-19676, -26203}, {-19678, -26201}, {-19681, -26199}, {-19684, -26197},
    {-19686, -26195}, {-19689, -26194}, {-19691, -26192}, {-19694, -26190}, {-19696, -26188}, {-19699, -26186},
    {-19701, -26184}, {-19704, -26182}, {-19706, -26180}, {-19709, -26178}, {-19711, -26177}, {-19714, -26175},
    {-19716, -26173}, {-19719, -26171}, {-19721, -26169}, {-19724, -26167}, {-19726, -26165}, {-19729, -26163},
    {-19731, -26161}, {-19734, -26160}, {-19736, -26158}, {-19739, -26156}, {-19741, -26154}, {-19744, -26152},
    {-19746, -26150}, {-19749, -26148}, {-19751, -26146}, {-19754, -26144}, {-19756, -26143}, {-19759, -26141},
    {-19761, -26139}, {-19764, -26137}, {-19766, -26135}, {-19769, -26133}, {-19771, -26131}, {-19774, -26129},
    {-19776, -26127}, {-19779, -26125}, {-19781, -26124}, {-19784, -26122}, {-19786, -26120}, {-19789, -26118},
    {-19791, -26116}, {-19794, -26114}, {-19796, -26112}, {-19799, -26110}, {-19801, -26108}, {-19804, -26106},
    {-19806, -26105}, {-19809, -26103}, {-19811, -26101}, {-19814, -26099}, {-19816, -26097}, {-19819, -26095},
    {-19821, -26093}, {-19824, -26091}, {-19826, -26089}, {-19829, -26087}, {-19831, -26086}, {-19834, -26084},
    {-19836, -26082}, {-19839, -26080}, {-19841, -26078}, {-19844, -26076}, {-19846, -26074}, {-19849, -26072},
    {-19851, -26070}, {-19854, -26068}, {-19856, -26067}, {-19859, -26065}, {-19861, -26063}, {-19864, -26061},
    {-19866, -26059}, {-19869, -26057}, {-19871, -26055}, {-19874, -26053}, {-19876, -26051}, {-19879, -26049},
    {-19881, -26048}, {-19884, -26046}, {-19886, -26044}, {-19889, -26042}, {-19891, -26040}, {-19894, -26038},
    {-19896, -26036}, {-19899, -26034}, {-19901, -26032}, {-19904, -26030}, {-19906, -26028}, {-19909, -26027},
    {-19911, -26025}, {-19914, -26023}, {-19916, -26021}, {-19919, -26019}, {-19921, -26017}, {-19924, -26015},
    {-19926, -26013}, {-19929, -26011}, {-19931, -26009}, {-19934, -26007}, {-19936, -26006}, {-19939, -26004},
    {-19941, -26002}, {-19944, -26000}, {-19946, -25998}, {-19949, -25996}, {-19951, -25994}, {-19954, -25992},
    {-19956, -25990}, {-19959, -25988}, {-19961, -25986}, {-19964, -25984}, {-19966, -25983}, {-19969, -25981},
    {-19971, -25979}, {-19974, -25977}, {-19976, -25975}, {-19979, -25973}, {-19981, -25971}, {-19984, -25969},
    {-19986, -25967}, {-19989, -25965}, {-19991, -25963}, {-19994, -25961}, {-19996, -25960}, {-19999, -25958},
    {-20001, -25956}, {-20004, -25954}, {-20006, -25952}, {-20008, -25950}, {-20011, -25948}, {-20013, -25946},
    {-20016, -25944}, {-20018, -25942}, {-20021, -25940}, {-20023, -25938}, {-20026, -25937}, {-20028, -25935},
    {-20031, -25933}, {-20033, -25931}, {-20036, -25929}, {-20038, -25927}, {-20041, -25925}, {-20043, -25923},
    {-20046, -25921}, {-20048, -25919}, {-20051, -25917}, {-20053, -25915}, {-20056, -25914}, {-20058, -25912},
    {-20061, -25910}, {-20063, -25908}, {-20066, -25906}, {-20068, -25904}, {-20071, -25902}, {-20073, -25900},
    {-20076, -25898}, {-20078, -25896}, {-20081, -25894}, {-20083, -25892}, {-20086, -25890}, {-20088, -25888},
    {-20090, -25887}, {-20093, -25885}, {-20095, -25883}, {-20098, -25881}, {-20100, -25879}, {-20103, -25877},
    {-20105, -25875}, {-20108, -25873}, {-20110, -25871}, {-20113, -25869}, {-20115, -25867}, {-20118, -25865},
    {-20120, -25863}, {-20123, -25862}, {-20125, -25860}, {-20128, -25858}, {-20130, -25856}, {-20133, -25854},
    {-20135, -25852}, {-20138, -25850}, {-20140, -25848}, {-20143, -25846}, {-20145, -25844}, {-20148, -25842},
    {-20150, -25840}, {-20152, -25838}, {-20155, -25836}, {-20157, -25834}, {-20160, -25833}, {-20162, -25831},
    {-20165, -25829}, {-20167, -25827}, {-20170, -25825}, {-20172, -25823}, {-20175, -25821}, {-20177, -25819},
    {-20180, -25817}, {-20182, -25815}, {-20185, -25813}, {-20187, -25811}, {-20190, -25809}, {-20192, -25807},
    {-20195, -25805}, {-20197, -25804}, {-20200, -25802}, {-20202, -25800}, {-20204, -25798}, {-20207, -25796},
    {-20209, -25794}, {-20212, -25792}, {-20214, -25790}, {-20217, -25788}, {-20219, -25786}, {-20222, -25784},
    {-20224, -25782}, {-20227, -25780}, {-20229, -25778}, {-20232, -25776}, {-20234, -25774}, {-20237, -25773},
    {-20239, -25771}, {-20242, -25769}, {-20244, -25767}, {-20246, -25765}, {-20249, -25763}, {-20251, -25761},
    {-20254, -25759}, {-20256, -25757}, {-20259, -25755}, {-20261, -25753}, {-20264, -25751}, {-20266, -25749},
    {-20269, -25747}, {-20271, -25745}, {-20274, -25743}, {-20276, -25741}, {-20279, -25739}, {-20281, -25738},
    {-20284, -25736}, {-20286, -25734}, {-20288, -25732}, {-20291, -25730}, {-20293, -25728}, {-20296, -25726},
    {-20298, -25724}, {-20301, -25722}, {-20303, -25720}, {-20306, -25718}, {-20308, -25716}, {-20311, -25714},
    {-20313, -25712}, {-20316, -25710}, {-20318, -25708}, {-20320, -25706}, {-20323, -25704}, {-20325, -25703},
    {-20328, -25701}, {-20330, -25699}, {-20333, -25697}, {-20335, -25695}, {-20338, -25693}, {-20340, -25691},
    {-20343, -25689}, {-20345, -25687}, {-20348, -25685}, {-20350, -25683}, {-20353, -25681}, {-20355, -25679},
    {-20357, -25677}, {-20360, -25675}, {-20362, -25673}, {-20365, -25671}, {-20367, -25669}, {-20370, -25667},
    {-20372, -25665}, {-20375, -25663}, {-20377, -25662}, {-20380, -25660}, {-20382, -25658}, {-20385, -25656},
    {-20387, -25654}, {-20389, -25652}, {-20392, -25650}, {-20394, -25648}, {-20397, -25646}, {-20399, -25644},
    {-20402, -25642}, {-20404, -25640}, {-20407, -25638}, {-20409, -25636}, {-20412, -25634}, {-20414, -25632},
    {-20416, -25630}, {-20419, -25628}, {-20421, -25626}, {-20424, -25624}, {-20426, -25622}, {-20429, -25620},
    {-20431, -25618}, {-20434, -25617}, {-20436, -25615}, {-20439, -25613}, {-20441, -25611}, {-20443, -25609},
    {-20446, -25607}, {-20448, -25605}, {-20451, -25603}, {-20453, -25601}, {-20456, -25599}, {-20458, -25597},
    {-20461, -25595}, {-20463, -25593}, {-20466, -25591}, {-20468, -25589}, {-20470, -25587}, {-20473, -25585},
    {-20475, -25583}, {-20478, -25581}, {-20480, -25579}, {-20483, -25577}, {-20485, -25575}, {-20488, -25573},
    {-20490, -25571}, {-20493, -25569}, {-20495, -25567}, {-20497, -25566}, {-20500, -25564}, {-20502, -25562},
    {-20505, -25560}, {-20507, -25558}, {-20510, -25556}, {-20512, -25554}, {-20515, -25552}, {-20517, -25550},
    {-20520, -25548}, {-20522, -25546}, {-20524, -25544}, {-20527, -25542}, {-20529, -25540}, {-20532, -25538},
    {-20534, -25536}, {-20537, -25534}, {-20539, -25532}, {-20542, -25530}, {-20544, -25528}, {-20546, -25526},
    {-20549, -25524}, {-20551, -25522}, {-20554, -25520}, {-20556, -25518}, {-20559, -25516}, {-20561, -25514},
    {-20564, -25512}, {-20566, -25510}, {-20568, -25508}, {-20571, -25506}, {-20573, -25504}, {-20576, -25503},
    {-20578, -25501}, {-20581, -25499}, {-20583, -25497}, {-20586, -25495}, {-20588, -25493}, {-20590, -25491},
    {-20593, -25489}, {-20595, -25487}, {-20598, -25485}, {-20600, -25483}, {-20603, -25481}, {-20605, -25479},
    {-20608, -25477}, {-20610, -25475}, {-20612, -25473}, {-20615, -25471}, {-20617, -25469}, {-20620, -25467},
    {-20622, -25465}, {-20625, -25463}, {-20627, -25461}, {-20630, -25459}, {-20632, -25457}, {-20634, -25455},
    {-20637, -25453}, {-20639, -25451}, {-20642, -25449}, {-20644, -25447}, {-20647, -25445}, {-20649, -25443},
    {-20652, -25441}, {-20654, -25439}, {-20656, -25437}, {-20659, -25435}, {-20661, -25433}, {-20664, -25431},
    {-20666, -25429}, {-20669, -25427}, {-20671, -25425}, {-20673, -25423}, {-20676, -25421}, {-20678, -25419},
    {-20681, -25417}, {-20683, -25415}, {-20686, -25414}, {-20688, -25412}, {-20691, -25410}, {-20693, -25408},
    {-20695, -25406}, {-20698, -25404}, {-20700, -25402}, {-20703, -25400}, {-20705, -25398}, {-20708, -25396},
    {-20710, -25394}, {-20712, -25392}, {-20715, -25390}, {-20717, -25388}, {-20720, -25386}, {-20722, -25384},
    {-20725, -25382}, {-20727, -25380}, {-20729, -25378}, {-20732, -25376}, {-20734, -25374}, {-20737, -25372},
    {-20739, -25370}, {-20742, -25368}, {-20744, -25366}, {-20746, -25364}, {-20749, -25362}, {-20751, -25360},
    {-20754, -25358}, {-20756, -25356}, {-20759, -25354}, {-20761, -25352}, {-20764, -25350}, {-20766, -25348},
    {-20768, -25346}, {-20771, -25344}, {-20773, -25342}, {-20776, -25340}, {-20778, -25338}, {-20781, -25336},
    {-20783, -25334}, {-20785, -25332}, {-20788, -25330}, {-20790, -25328}, {-20793, -25326}, {-20795, -25324},
    {-20798, -25322}, {-20800, -25320}, {-20802, -25318}, {-20805, -25316}, {-20807, -25314}, {-20810, -25312},
    {-20812, -25310}, {-20815, -25308}, {-20817, -25306}, {-20819, -25304}, {-20822, -25302}, {-20824, -25300},
    {-20827, -25298}, {-20829, -25296}, {-20831, -25294}, {-20834, -25292}, {-20836, -25290}, {-20839, -25288},
    {-20841, -25286}, {-20844, -25284}, {-20846, -25282}, {-20848, -25280}, {-20851, -25278}, {-20853, -25276},
    {-20856, -25274}, {-20858, -25272}, {-20861, -25270}, {-20863, -25268}, {-20865, -25266}, {-20868, -25264},
    {-20870, -25262}, {-20873, -25260}, {-20875, -25258}, {-20878, -25256}, {-20880, -25254}, {-20882, -25252},
    {-20885, -25250}, {-20887, -25248}, {-20890, -25246}, {-20892, -25244}, {-20894, -25242}, {-20897, -25240},
    {-20899, -25238}, {-20902, -25236}, {-20904, -25234}, {-20907, -25232}, {-20909, -25230}, {-20911, -25228},
    {-20914, -25226}, {-20916, -25224}, {-20919, -25222}, {-20921, -25220}, {-20923, -25218}, {-20926, -25216},
    {-20928, -25214}, {-20931, -25212}, {-20933, -25210}, {-20936, -25208}, {-20938, -25206}, {-20940, -25204},
    {-20943, -25202}, {-20945, -25200}, {-20948, -25198}, {-20950, -25196}, {-20952, -25194}, {-20955, -25192},
    {-20957, -25190}, {-20960, -25188}, {-20962, -25186}, {-20965, -25184}, {-20967, -25182}, {-20969, -25180},
    {-20972, -25178}, {-20974, -25176}, {-20977, -25174}, {-20979, -25172}, {-20981, -25170}, {-20984, -25168},
    {-20986, -25166}, {-20989, -25164}, {-20991, -25162}, {-20994, -25160}, {-20996, -25158}, {-20998, -25156},
    {-21001, -25154}, {-21003, -25152}, {-21006, -25150}, {-21008, -25148}, {-21010, -25146}, {-21013, -25144},
    {-21015, -25142}, {-21018, -25140}, {-21020, -25138}, {-21022, -25136}, {-21025, -25134}, {-21027, -25132},
    {-21030, -25130}, {-21032, -25128}, {-21035, -25126}, {-21037, -25123}, {-21039, -25121}, {-21042, -25119},
    {-21044, -25117}, {-21047, -25115}, {-21049, -25113}, {-21051, -25111}, {-21054, -25109}, {-21056, -25107},
    {-21059, -25105}, {-21061, -25103}, {-21063, -25101}, {-21066, -25099}, {-21068, -25097}, {-21071, -25095},
    {-21073, -25093}, {-21075, -25091}, {-21078, -25089}, {-21080, -25087}, {-21083, -25085}, {-21085, -25083},
    {-21087, -25081}, {-21090, -25079}, {-21092, -25077}, {-21095, -25075}, {-21097, -25073}, {-21099, -25071},
    {-21102, -25069}, {-21104, -25067}, {-21107, -25065}, {-21109, -25063}, {-21111, -25061}, {-21114, -25059},
    {-21116, -25057}, {-21119, -25055}, {-21121, -25053}, {-21124, -25051}, {-21126, -25049}, {-21128, -25047},
    {-21131, -25045}, {-21133, -25043}, {-21136, -25041}, {-21138, -25039}, {-21140, -25037}, {-21143, -25035},
    {-21145, -25033}, {-21148, -25030}, {-21150, -25028}, {-21152, -25026}, {-21155, -25024}, {-21157, -25022},
    {-21160, -25020}, {-21162, -25018}, {-21164, -25016}, {-21167, -25014}, {-21169, -25012}, {-21171, -25010},
    {-21174, -25008}, {-21176, -25006}, {-21179, -25004}, {-21181, -25002}, {-21183, -25000}, {-21186, -24998},
    {-21188, -24996}, {-21191, -24994}, {-21193, -24992}, {-21195, -24990}, {-21198, -24988}, {-21200, -24986},
    {-21203, -24984}, {-21205, -24982}, {-21207, -24980}, {-21210, -24978}, {-21212, -24976}, {-21215, -24974},
    {-21217, -24972}, {-21219, -24970}, {-21222, -24968}, {-21224, -24965}, {-21227, -24963}, {-21229, -24961},
    {-21231, -24959}, {-21234, -24957}, {-21236, -24955}, {-21239, -24953}, {-21241, -24951}, {-21243, -24949},
    {-21246, -24947}, {-21248, -24945}, {-21251, -24943}, {-21253, -24941}, {-21255, -24939}, {-21258, -24937},
    {-21260, -24935}, {-21262, -24933}, {-21265, -24931}, {-21267, -24929}, {-21270, -24927}, {-21272, -24925},
    {-21274, -24923}, {-21277, -24921}, {-21279, -24919}, {-21282, -24917}, {-21284, -24915}, {-21286, -24912},
    {-21289, -24910}, {-21291, -24908}, {-21294, -24906}, {-21296, -24904}, {-21298, -24902}, {-21301, -24900},
    {-21303, -24898}, {-21305, -24896}, {-21308, -24894}, {-21310, -24892}, {-21313, -24890}, {-21315, -24888},
    {-21317, -24886}, {-21320, -24884}, {-21322, -24882}, {-21325, -24880}, {-21327, -24878}, {-21329, -24876},
    {-21332, -24874}, {-21334, -24872}, {-21336, -24870}, {-21339, -24868}, {-21341, -24865}, {-21344, -24863},
    {-21346, -24861}, {-21348, -24859}, {-21351, -24857}, {-21353, -24855}, {-21356, -24853}, {-21358, -24851},
    {-21360, -24849}, {-21363, -24847}, {-21365, -24845}, {-21367, -24843}, {-21370, -24841}, {-21372, -24839},
    {-21375, -24837}, {-21377, -24835}, {-21379, -24833}, {-21382, -24831}, {-21384, -24829}, {-21387, -24827},
    {-21389, -24825}, {-21391, -24822}, {-21394, -24820}, {-21396, -24818}, {-21398, -24816}, {-21401, -24814},
    {-21403, -24812}, {-21406, -24810}, {-21408, -24808}, {-21410, -24806}, {-21413, -24804}, {-21415, -24802},
    {-21417, -24800}, {-21420, -24798}, {-21422, -24796}, {-21425, -24794}, {-21427, -24792}, {-21429, -24790},
    {-21432, -24788}, {-21434, -24786}, {-21436, -24783}, {-21439, -24781}, {-21441, -24779}, {-21444, -24777},
    {-21446, -24775}, {-21448, -24773}, {-21451, -24771}, {-21453, -24769}, {-21455, -24767}, {-21458, -24765},
    {-21460, -24763}, {-21463, -24761}, {-21465, -24759}, {-21467, -24757}, {-21470, -24755}, {-21472, -24753},
    {-21474, -24751}, {-21477, -24748}, {-21479, -24746}, {-21482, -24744}, {-21484, -24742}, {-21486, -24740},
    {-21489, -24738}, {-21491, -24736}, {-21493, -24734}, {-21496, -24732}, {-21498, -24730}, {-21501, -24728},
    {-21503, -24726}, {-21505, -24724}, {-21508, -24722}, {-21510, -24720}, {-21512, -24718}, {-21515, -24716},
    {-21517, -24713}, {-21519, -24711}, {-21522, -24709}, {-21524, -24707}, {-21527, -24705}, {-21529, -24703},
    {-21531, -24701}, {-21534, -24699}, {-21536, -24697}, {-21538, -24695}, {-21541, -24693}, {-21543, -24691},
    {-21546, -24689}, {-21548, -24687}, {-21550, -24685}, {-21553, -24682}, {-21555, -24680}, {-21557, -24678},
    {-21560, -24676}, {-21562, -24674}, {-21564, -24672}, {-21567, -24670}, {-21569, -24668}, {-21572, -24666},
    {-21574, -24664}, {-21576, -24662}, {-21579, -24660}, {-21581, -24658}, {-21583, -24656}, {-21586, -24654},
    {-21588, -24651}, {-21590, -24649}, {-21593, -24647}, {-21595, -24645}, {-21598, -24643}, {-21600, -24641},
    {-21602, -24639}, {-21605, -24637}, {-21607, -24635}, {-21609, -24633}, {-21612, -24631}, {-21614, -24629},
    {-21616, -24627}, {-21619, -24625}, {-21621, -24622}, {-21624, -24620}, {-21626, -24618}, {-21628, -24616},
    {-21631, -24614}, {-21633, -24612}, {-21635, -24610}, {-21638, -24608}, {-21640, -24606}, {-21642, -24604},
    {-21645, -24602}, {-21647, -24600}, {-21649, -24598}, {-21652, -24596}, {-21654, -24593}, {-21657, -24591},
    {-21659, -24589}, {-21661, -24587}, {-21664, -24585}, {-21666, -24583}, {-21668, -24581}, {-21671, -24579},
    {-21673, -24577}, {-21675, -24575}, {-21678, -24573}, {-21680, -24571}, {-21682, -24569}, {-21685, -24566},
    {-21687, -24564}, {-21690, -24562}, {-21692, -24560}, {-21694, -24558}, {-21697, -24556}, {-21699, -24554},
    {-21701, -24552}, {-21704, -24550}, {-21706, -24548}, {-21708, -24546}, {-21711, -24544}, {-21713, -24541},
    {-21715, -24539}, {-21718, -24537}, {-21720, -24535}, {-21723, -24533}, {-21725, -24531}, {-21727, -24529},
    {-21730, -24527}, {-21732, -24525}, {-21734, -24523}, {-21737, -24521}, {-21739, -24519}, {-21741, -24516},
    {-21744, -24514}, {-21746, -24512}, {-21748, -24510}, {-21751, -24508}, {-21753, -24506}, {-21755, -24504},
    {-21758, -24502}, {-21760, -24500}, {-21762, -24498}, {-21765, -24496}, {-21767, -24494}, {-21770, -24491},
    {-21772, -24489}, {-21774, -24487}, {-21777, -24485}, {-21779, -24483}, {-21781, -24481}, {-21784, -24479},
    {-21786, -24477}, {-21788, -24475}, {-21791, -24473}, {-21793, -24471}, {-21795, -24468}, {-21798, -24466},
    {-21800, -24464}, {-21802, -24462}, {-21805, -24460}, {-21807, -24458}, {-21809, -24456}, {-21812, -24454},
    {-21814, -24452}, {-21816, -24450}, {-21819, -24448}, {-21821, -24445}, {-21823, -24443}, {-21826, -24441},
    {-21828, -24439}, {-21830, -24437}, {-21833, -24435}, {-21835, -24433}, {-21838, -24431}, {-21840, -24429},
    {-21842, -24427}, {-21845, -24425}, {-21847, -24422}, {-21849, -24420}, {-21852, -24418}, {-21854, -24416},
    {-21856, -24414}, {-21859, -24412}, {-21861, -24410}, {-21863, -24408}, {-21866, -24406}, {-21868, -24404},
    {-21870, -24401}, {-21873, -24399}, {-21875, -24397}, {-21877, -24395}, {-21880, -24393}, {-21882, -24391},
    {-21884, -24389}, {-21887, -24387}, {-21889, -24385}, {-21891, -24383}, {-21894, -24380}, {-21896, -24378},
    {-21898, -24376}, {-21901, -24374}, {-21903, -24372}, {-21905, -24370}, {-21908, -24368}, {-21910, -24366},
    {-21912, -24364}, {-21915, -24362}, {-21917, -24359}, {-21919, -24357}, {-21922, -24355}, {-21924, -24353},
    {-21926, -24351}, {-21929, -24349}, {-21931, -24347}, {-21933, -24345}, {-21936, -24343}, {-21938, -24341},
    {-21940, -24338}, {-21943, -24336}, {-21945, -24334}, {-21947, -24332}, {-21950, -24330}, {-21952, -24328},
    {-21954, -24326}, {-21957, -24324}, {-21959, -24322}, {-21961, -24320}, {-21964, -24317}, {-21966, -24315},
    {-21968, -24313}, {-21971, -24311}, {-21973, -24309}, {-21975, -24307}, {-21978, -24305}, {-21980, -24303},
    {-21982, -24301}, {-21985, -24298}, {-21987, -24296}, {-21989, -24294}, {-21992, -24292}, {-21994, -24290},
    {-21996, -24288}, {-21999, -24286}, {-22001, -24284}, {-22003, -24282}, {-22006, -24279}, {-22008, -24277},
    {-22010, -24275}, {-22013, -24273}, {-22015, -24271}, {-22017, -24269}, {-22020, -24267}, {-22022, -24265},
    {-22024, -24263}, {-22027, -24260}, {-22029, -24258}, {-22031, -24256}, {-22034, -24254}, {-22036, -24252},
    {-22038, -24250}, {-22041, -24248}, {-22043, -24246}, {-22045, -24244}, {-22048, -24241}, {-22050, -24239},
    {-22052, -24237}, {-22054, -24235}, {-22057, -24233}, {-22059, -24231}, {-22061, -24229}, {-22064, -24227},
    {-22066, -24225}, {-22068, -24222}, {-22071, -24220}, {-22073, -24218}, {-22075, -24216}, {-22078, -24214},
    {-22080, -24212}, {-22082, -24210}, {-22085, -24208}, {-22087, -24206}, {-22089, -24203}, {-22092, -24201},
    {-22094, -24199}, {-22096, -24197}, {-22099, -24195}, {-22101, -24193}, {-22103, -24191}, {-22106, -24189},
    {-22108, -24186}, {-22110, -24184}, {-22113, -24182}, {-22115, -24180}, {-22117, -24178}, {-22119, -24176},
    {-22122, -24174}, {-22124, -24172}, {-22126, -24169}, {-22129, -24167}, {-22131, -24165}, {-22133, -24163},
    {-22136, -24161}, {-22138, -24159}, {-22140, -24157}, {-22143, -24155}, {-22145, -24152}, {-22147, -24150},
    {-22150, -24148}, {-22152, -24146}, {-22154, -24144}, {-22157, -24142}, {-22159, -24140}, {-22161, -24138},
    {-22163, -24136}, {-22166, -24133}, {-22168, -24131}, {-22170, -24129}, {-22173, -24127}, {-22175, -24125},
    {-22177, -24123}, {-22180, -24121}, {-22182, -24119}, {-22184, -24116}, {-22187, -24114}, {-22189, -24112},
    {-22191, -24110}, {-22194, -24108}, {-22196, -24106}, {-22198, -24104}, {-22200, -24101}, {-22203, -24099},
    {-22205, -24097}, {-22207, -24095}, {-22210, -24093}, {-22212, -24091}, {-22214, -24089}, {-22217, -24087},
    {-22219, -24084}, {-22221, -24082}, {-22224, -24080}, {-22226, -24078}, {-22228, -24076}, {-22230, -24074},
    {-22233, -24072}, {-22235, -24070}, {-22237, -24067}, {-22240, -24065}, {-22242, -24063}, {-22244, -24061},
    {-22247, -24059}, {-22249, -24057}, {-22251, -24055}, {-22254, -24052}, {-22256, -24050}, {-22258, -24048},
    {-22260, -24046}, {-22263, -24044}, {-22265, -24042}, {-22267, -24040}, {-22270, -24038}, {-22272, -24035},
    {-22274, -24033}, {-22277, -24031}, {-22279, -24029}, {-22281, -24027}, {-22284, -24025}, {-22286, -24023},
    {-22288, -24020}, {-22290, -24018}, {-22293, -24016}, {-22295, -24014}, {-22297, -24012}, {-22300, -24010},
    {-22302, -24008}, {-22304, -24005}, {-22307, -24003}, {-22309, -24001}, {-22311, -23999}, {-22313, -23997},
    {-22316, -23995}, {-22318, -23993}, {-22320, -23991}, {-22323, -23988}, {-22325, -23986}, {-22327, -23984},
    {-22330, -23982}, {-22332, -23980}, {-22334, -23978}, {-22336, -23976}, {-22339, -23973}, {-22341, -23971},
    {-22343, -23969}, {-22346, -23967}, {-22348, -23965}, {-22350, -23963}, {-22353, -23961}, {-22355, -23958},
    {-22357, -23956}, {-22359, -23954}, {-22362, -23952}, {-22364, -23950}, {-22366, -23948}, {-22369, -23946},
    {-22371, -23943}, {-22373, -23941}, {-22375, -23939}, {-22378, -23937}, {-22380, -23935}, {-22382, -23933},
    {-22385, -23930}, {-22387, -23928}, {-22389, -23926}, {-22392, -23924}, {-22394, -23922}, {-22396, -23920},
    {-22398, -23918}, {-22401, -23915}, {-22403, -23913}, {-22405, -23911}, {-22408, -23909}, {-22410, -23907},
    {-22412, -23905}, {-22414, -23903}, {-22417, -23900}, {-22419, -23898}, {-22421, -23896}, {-22424, -23894},
    {-22426, -23892}, {-22428, -23890}, {-22431, -23888}, {-22433, -23885}, {-22435, -23883}, {-22437, -23881},
    {-22440, -23879}, {-22442, -23877}, {-22444, -23875}, {-22447, -23872}, {-22449, -23870}, {-22451, -23868},
    {-22453, -23866}, {-22456, -23864}, {-22458, -23862}, {-22460, -23860}, {-22463, -23857}, {-22465, -23855},
    {-22467, -23853}, {-22469, -23851}, {-22472, -23849}, {-22474, -23847}, {-22476, -23844}, {-22479, -23842},
    {-22481, -23840}, {-22483, -23838}, {-22485, -23836}, {-22488, -23834}, {-22490, -23832}, {-22492, -23829},
    {-22495, -23827}, {-22497, -23825}, {-22499, -23823}, {-22501, -23821}, {-22504, -23819}, {-22506, -23816},
    {-22508, -23814}, {-22511, -23812}, {-22513, -23810}, {-22515, -23808}, {-22517, -23806}, {-22520, -23803},
    {-22522, -23801}, {-22524, -23799}, {-22527, -23797}, {-22529, -23795}, {-22531, -23793}, {-22533, -23791},
    {-22536, -23788}, {-22538, -23786}, {-22540, -23784}, {-22542, -23782}, {-22545, -23780}, {-22547, -23778},
    {-22549, -23775}, {-22552, -23773}, {-22554, -23771}, {-22556, -23769}, {-22558, -23767}, {-22561, -23765},
    {-22563, -23762}, {-22565, -23760}, {-22568, -23758}, {-22570, -23756}, {-22572, -23754}, {-22574, -23752},
    {-22577, -23749}, {-22579, -23747}, {-22581, -23745}, {-22583, -23743}, {-22586, -23741}, {-22588, -23739},
    {-22590, -23736}, {-22593, -23734}, {-22595, -23732}, {-22597, -23730}, {-22599, -23728}, {-22602, -23726},
    {-22604, -23723}, {-22606, -23721}, {-22609, -23719}, {-22611, -23717}, {-22613, -23715}, {-22615, -23713},
    {-22618, -23710}, {-22620, -23708}, {-22622, -23706}, {-22624, -23704}, {-22627, -23702}, {-22629, -23700},
    {-22631, -23697}, {-22634, -23695}, {-22636, -23693}, {-22638, -23691}, {-22640, -23689}, {-22643, -23687},
    {-22645, -23684}, {-22647, -23682}, {-22649, -23680}, {-22652, -23678}, {-22654, -23676}, {-22656, -23674},
    {-22658, -23671}, {-22661, -23669}, {-22663, -23667}, {-22665, -23665}, {-22668, -23663}, {-22670, -23661},
    {-22672, -23658}, {-22674, -23656}, {-22677, -23654}, {-22679, -23652}, {-22681, -23650}, {-22683, -23647},
    {-22686, -23645}, {-22688, -23643}, {-22690, -23641}, {-22693, -23639}, {-22695, -23637}, {-22697, -23634},
    {-22699, -23632}, {-22702, -23630}, {-22704, -23628}, {-22706, -23626}, {-22708, -23624}, {-22711, -23621},
    {-22713, -23619}, {-22715, -23617}, {-22717, -23615}, {-22720, -23613}, {-22722, -23610}, {-22724, -23608},
    {-22726, -23606}, {-22729, -23604}, {-22731, -23602}, {-22733, -23600}, {-22736, -23597}, {-22738, -23595},
    {-22740, -23593}, {-22742, -23591}, {-22745, -23589}, {-22747, -23587}, {-22749, -23584}, {-22751, -23582},
    {-22754, -23580}, {-22756, -23578}, {-22758, -23576}, {-22760, -23573}, {-22763, -23571}, {-22765, -23569},
    {-22767, -23567}, {-22769, -23565}, {-22772, -23562}, {-22774, -23560}, {-22776, -23558}, {-22778, -23556},
    {-22781, -23554}, {-22783, -23552}, {-22785, -23549}, {-22788, -23547}, {-22790, -23545}, {-22792, -23543},
    {-22794, -23541}, {-22797, -23538}, {-22799, -23536}, {-22801, -23534}, {-22803, -23532}, {-22806, -23530},
    {-22808, -23528}, {-22810, -23525}, {-22812, -23523}, {-22815, -23521}, {-22817, -23519}, {-22819, -23517},
    {-22821, -23514}, {-22824, -23512}, {-22826, -23510}, {-22828, -23508}, {-22830, -23506}, {-22833, -23503},
    {-22835, -23501}, {-22837, -23499}, {-22839, -23497}, {-22842, -23495}, {-22844, -23493}, {-22846, -23490},
    {-22848, -23488}, {-22851, -23486}, {-22853, -23484}, {-22855, -23482}, {-22857, -23479}, {-22860, -23477},
    {-22862, -23475}, {-22864, -23473}, {-22866, -23471}, {-22869, -23468}, {-22871, -23466}, {-22873, -23464},
    {-22875, -23462}, {-22878, -23460}, {-22880, -23457}, {-22882, -23455}, {-22884, -23453}, {-22887, -23451},
    {-22889, -23449}, {-22891, -23446}, {-22893, -23444}, {-22896, -23442}, {-22898, -23440}, {-22900, -23438},
    {-22902, -23436}, {-22905, -23433}, {-22907, -23431}, {-22909, -23429}, {-22911, -23427}, {-22914, -23425},
    {-22916, -23422}, {-22918, -23420}, {-22920, -23418}, {-22923, -23416}, {-22925, -23414}, {-22927, -23411},
    {-22929, -23409}, {-22932, -23407}, {-22934, -23405}, {-22936, -23403}, {-22938, -23400}, {-22941, -23398},
    {-22943, -23396}, {-22945, -23394}, {-22947, -23392}, {-22950, -23389}, {-22952, -23387}, {-22954, -23385},
    {-22956, -23383}, {-22958, -23381}, {-22961, -23378}, {-22963, -23376}, {-22965, -23374}, {-22967, -23372},
    {-22970, -23370}, {-22972, -23367}, {-22974, -23365}, {-22976, -23363}, {-22979, -23361}, {-22981, -23359},
    {-22983, -23356}, {-22985, -23354}, {-22988, -23352}, {-22990, -23350}, {-22992, -23348}, {-22994, -23345},
    {-22997, -23343}, {-22999, -23341}, {-23001, -23339}, {-23003, -23336}, {-23006, -23334}, {-23008, -23332},
    {-23010, -23330}, {-23012, -23328}, {-23014, -23325}, {-23017, -23323}, {-23019, -23321}, {-23021, -23319},
    {-23023, -23317}, {-23026, -23314}, {-23028, -23312}, {-23030, -23310}, {-23032, -23308}, {-23035, -23306},
    {-23037, -23303}, {-23039, -23301}, {-23041, -23299}, {-23044, -23297}, {-23046, -23295}, {-23048, -23292},
    {-23050, -23290}, {-23052, -23288}, {-23055, -23286}, {-23057, -23283}, {-23059, -23281}, {-23061, -23279},
    {-23064, -23277}, {-23066, -23275}, {-23068, -23272}, {-23070, -23270}, {-23073, -23268}, {-23075, -23266},
    {-23077, -23264}, {-23079, -23261}, {-23081, -23259}, {-23084, -23257}, {-23086, -23255}, {-23088, -23253},
    {-23090, -23250}, {-23093, -23248}, {-23095, -23246}, {-23097, -23244}, {-23099, -23241}, {-23102, -23239},
    {-23104, -23237}, {-23106, -23235}, {-23108, -23233}, {-23110, -23230}, {-23113, -23228}, {-23115, -23226},
    {-23117, -23224}, {-23119, -23222}, {-23122, -23219}, {-23124, -23217}, {-23126, -23215}, {-23128, -23213},
    {-23130, -23210}, {-23133, -23208}, {-23135, -23206}, {-23137, -23204}, {-23139, -23202}, {-23142, -23199},
    {-23144, -23197}, {-23146, -23195}, {-23148, -23193}, {-23150, -23190}, {-23153, -23188}, {-23155, -23186},
    {-23157, -23184}, {-23159, -23182}, {-23162, -23179}, {-23164, -23177}, {-23166, -23175}, {-23168, -23173},
    {-23170, -23170}, {-23173, -23168}, {-23175, -23166}, {-23177, -23164}, {-23179, -23162}, {-23182, -23159},
    {-23184, -23157}, {-23186, -23155}, {-23188, -23153}, {-23190, -23150}, {-23193, -23148}, {-23195, -23146},
    {-23197, -23144}, {-23199, -23142}, {-23202, -23139}, {-23204, -23137}, {-23206, -23135}, {-23208, -23133},
    {-23210, -23130}, {-23213, -23128}, {-23215, -23126}, {-23217, -23124}, {-23219, -23122}, {-23222, -23119},
    {-23224, -23117}, {-23226, -23115}, {-23228, -23113}, {-23230, -23110}, {-23233, -23108}, {-23235, -23106},
    {-23237, -23104}, {-23239, -23102}, {-23241, -23099}, {-23244, -23097}, {-23246, -23095}, {-23248, -23093},
    {-23250, -23090}, {-23253, -23088}, {-23255, -23086}, {-23257, -23084}, {-23259, -23081}, {-23261, -23079},
    {-23264, -23077}, {-23266, -23075}, {-23268, -23073}, {-23270, -23070}, {-23272, -23068}, {-23275, -23066},
    {-23277, -23064}, {-23279, -23061}, {-23281, -23059}, {-23283, -23057}, {-23286, -23055}, {-23288, -23052},
    {-23290, -23050}, {-23292, -23048}, {-23295, -23046}, {-23297, -23044}, {-23299, -23041}, {-23301, -23039},
    {-23303, -23037}, {-23306, -23035}, {-23308, -23032}, {-23310, -23030}, {-23312, -23028}, {-23314, -23026},
    {-23317, -23023}, {-23319, -23021}, {-23321, -23019}, {-23323, -23017}, {-23325, -23014}, {-23328, -23012},
    {-23330, -23010}, {-23332, -23008}, {-23334, -23006}, {-23336, -23003}, {-23339, -23001}, {-23341, -22999},
    {-23343, -22997}, {-23345, -22994}, {-23348, -22992}, {-23350, -22990}, {-23352, -22988}, {-23354, -22985},
    {-23356, -22983}, {-23359, -22981}, {-23361, -22979}, {-23363, -22976}, {-23365, -22974}, {-23367, -22972},
    {-23370, -22970}, {-23372, -22967}, {-23374, -22965}, {-23376, -22963}, {-23378, -22961}, {-23381, -22958},
    {-23383, -22956}, {-23385, -22954}, {-23387, -22952}, {-23389, -22950}, {-23392, -22947}, {-23394, -22945},
    {-23396, -22943}, {-23398, -22941}, {-23400, -22938}, {-23403, -22936}, {-23405, -22934}, {-23407, -22932},
    {-23409, -22929}, {-23411, -22927}, {-23414, -22925}, {-23416, -22923}, {-23418, -22920}, {-23420, -22918},
    {-23422, -22916}, {-23425, -22914}, {-23427, -22911}, {-23429, -22909}, {-23431, -22907}, {-23433, -22905},
    {-23436, -22902}, {-23438, -22900}, {-23440, -22898}, {-23442, -22896}, {-23444, -22893}, {-23446, -22891},
    {-23449, -22889}, {-23451, -22887}, {-23453, -22884}, {-23455, -22882}, {-23457, -22880}, {-23460, -22878},
    {-23462, -22875}, {-23464, -22873}, {-23466, -22871}, {-23468, -22869}, {-23471, -22866}, {-23473, -22864},
    {-23475, -22862}, {-23477, -22860}, {-23479, -22857}, {-23482, -22855}, {-23484, -22853}, {-23486, -22851},
    {-23488, -22848}, {-23490, -22846}, {-23493, -22844}, {-23495, -22842}, {-23497, -22839}, {-23499, -22837},
    {-23501, -22835}, {-23503, -22833}, {-23506, -22830}, {-23508, -22828}, {-23510, -22826}, {-23512, -22824},
    {-23514, -22821}, {-23517, -22819}, {-23519, -22817}, {-23521, -22815}, {-23523, -22812}, {-23525, -22810},
    {-23528, -22808}, {-23530, -22806}, {-23532, -22803}, {-23534, -22801}, {-23536, -22799}, {-23538, -22797},
    {-23541, -22794}, {-23543, -22792}, {-23545, -22790}, {-23547, -22788}, {-23549, -22785}, {-23552, -22783},
    {-23554, -22781}, {-23556, -22778}, {-23558, -22776}, {-23560, -22774}, {-23562, -22772}, {-23565, -22769},
    {-23567, -22767}, {-23569, -22765}, {-23571, -22763}, {-23573, -22760}, {-23576, -22758}, {-23578, -22756},
    {-23580, -22754}, {-23582, -22751}, {-23584, -22749}, {-23587, -22747}, {-23589, -22745}, {-23591, -22742},
    {-23593, -22740}, {-23595, -22738}, {-23597, -22736}, {-23600, -22733}, {-23602, -22731}, {-23604, -22729},
    {-23606, -22726}, {-23608, -22724}, {-23610, -22722}, {-23613, -22720}, {-23615, -22717}, {-23617, -22715},
    {-23619, -22713}, {-23621, -22711}, {-23624, -22708}, {-23626, -22706}, {-23628, -22704}, {-23630, -22702},
    {-23632, -22699}, {-23634, -22697}, {-23637, -22695}, {-23639, -22693}, {-23641, -22690}, {-23643, -22688},
    {-23645, -22686}, {-23647, -22683}, {-23650, -22681}, {-23652, -22679}, {-23654, -22677}, {-23656, -22674},
    {-23658, -22672}, {-23661, -22670}, {-23663, -22668}, {-23665, -22665}, {-23667, -22663}, {-23669, -22661},
    {-23671, -22658}, {-23674, -22656}, {-23676, -22654}, {-23678, -22652}, {-23680, -22649}, {-23682, -22647},
    {-23684, -22645}, {-23687, -22643}, {-23689, -22640}, {-23691, -22638}, {-23693, -22636}, {-23695, -22634},
    {-23697, -22631}, {-23700, -22629}, {-23702, -22627}, {-23704, -22624}, {-23706, -22622}, {-23708, -22620},
    {-23710, -22618}, {-23713, -22615}, {-23715, -22613}, {-23717, -22611}, {-23719, -22609}, {-23721, -22606},
    {-23723, -22604}, {-23726, -22602}, {-23728, -22599}, {-23730, -22597}, {-23732, -22595}, {-23734, -22593},
    {-23736, -22590}, {-23739, -22588}, {-23741, -22586}, {-23743, -22583}, {-23745, -22581}, {-23747, -22579},
    {-23749, -22577}, {-23752, -22574}, {-23754, -22572}, {-23756, -22570}, {-23758, -22568}, {-23760, -22565},
    {-23762, -22563}, {-23765, -22561}, {-23767, -22558}, {-23769, -22556}, {-23771, -22554}, {-23773, -22552},
    {-23775, -22549}, {-23778, -22547}, {-23780, -22545}, {-23782, -22542}, {-23784, -22540}, {-23786, -22538},
    {-23788, -22536}, {-23791, -22533}, {-23793, -22531}, {-23795, -22529}, {-23797, -22527}, {-23799, -22524},
    {-23801, -22522}, {-23803, -22520}, {-23806, -22517}, {-23808, -22515}, {-23810, -22513}, {-23812, -22511},
    {-23814, -22508}, {-23816, -22506}, {-23819, -22504}, {-23821, -22501}, {-23823, -22499}, {-23825, -22497},
    {-23827, -22495}, {-23829, -22492}, {-23832, -22490}, {-23834, -22488}, {-23836, -22485}, {-23838, -22483},
    {-23840, -22481}, {-23842, -22479}, {-23844, -22476}, {-23847, -22474}, {-23849, -22472}, {-23851, -22469},
    {-23853, -22467}, {-23855, -22465}, {-23857, -22463}, {-23860, -22460}, {-23862, -22458}, {-23864, -22456},
    {-23866, -22453}, {-23868, -22451}, {-23870, -22449}, {-23872, -22447}, {-23875, -22444}, {-23877, -22442},
    {-23879, -22440}, {-23881, -22437}, {-23883, -22435}, {-23885, -22433}, {-23888, -22431}, {-23890, -22428},
    {-23892, -22426}, {-23894, -22424}, {-23896, -22421}, {-23898, -22419}, {-23900, -22417}, {-23903, -22414},
    {-23905, -22412}, {-23907, -22410}, {-23909, -22408}, {-23911, -22405}, {-23913, -22403}, {-23915, -22401},
    {-23918, -22398}, {-23920, -22396}, {-23922, -22394}, {-23924, -22392}, {-23926, -22389}, {-23928, -22387},
    {-23930, -22385}, {-23933, -22382}, {-23935, -22380}, {-23937, -22378}, {-23939, -22375}, {-23941, -22373},
    {-23943, -22371}, {-23946, -22369}, {-23948, -22366}, {-23950, -22364}, {-23952, -22362}, {-23954, -22359},
    {-23956, -22357}, {-23958, -22355}, {-23961, -22353}, {-23963, -22350}, {-23965, -22348}, {-23967, -22346},
    {-23969, -22343}, {-23971, -22341}, {-23973, -22339}, {-23976, -22336}, {-23978, -22334}, {-23980, -22332},
    {-23982, -22330}, {-23984, -22327}, {-23986, -22325}, {-23988, -22323}, {-23991, -22320}, {-23993, -22318},
    {-23995, -22316}, {-23997, -22313}, {-23999, -22311}, {-24001, -22309}, {-24003, -22307}, {-24005, -22304},
    {-24008, -22302}, {-24010, -22300}, {-24012, -22297}, {-24014, -22295}, {-24016, -22293}, {-24018, -22290},
    {-24020, -22288}, {-24023, -22286}, {-24025, -22284}, {-24027, -22281}, {-24029, -22279}, {-24031, -22277},
    {-24033, -22274}, {-24035, -22272}, {-24038, -22270}, {-24040, -22267}, {-24042, -22265}, {-24044, -22263},
    {-24046, -22260}, {-24048, -22258}, {-24050, -22256}, {-24052, -22254}, {-24055, -22251}, {-24057, -22249},
    {-24059, -22247}, {-24061, -22244}, {-24063, -22242}, {-24065, -22240}, {-24067, -22237}, {-24070, -22235},
    {-24072, -22233}, {-24074, -22230}, {-24076, -22228}, {-24078, -22226}, {-24080, -22224}, {-24082, -22221},
    {-24084, -22219}, {-24087, -22217}, {-24089, -22214}, {-24091, -22212}, {-24093, -22210}, {-24095, -22207},
    {-24097, -22205}, {-24099, -22203}, {-24101, -22200}, {-24104, -22198}, {-24106, -22196}, {-24108, -22194},
    {-24110, -22191}, {-24112, -22189}, {-24114, -22187}, {-24116, -22184}, {-24119, -22182}, {-24121, -22180},
    {-24123, -22177}, {-24125, -22175}, {-24127, -22173}, {-24129, -22170}, {-24131, -22168}, {-24133, -22166},
    {-24136, -22163}, {-24138, -22161}, {-24140, -22159}, {-24142, -22157}, {-24144, -22154}, {-24146, -22152},
    {-24148, -22150}, {-24150, -22147}, {-24152, -22145}, {-24155, -22143}, {-24157, -22140}, {-24159, -22138},
    {-24161, -22136}, {-24163, -22133}, {-24165, -22131}, {-24167, -22129}, {-24169, -22126}, {-24172, -22124},
    {-24174, -22122}, {-24176, -22119}, {-24178, -22117}, {-24180, -22115}, {-24182, -22113}, {-24184, -22110},
    {-24186, -22108}, {-24189, -22106}, {-24191, -22103}, {-24193, -22101}, {-24195, -22099}, {-24197, -22096},
    {-24199, -22094}, {-24201, -22092}, {-24203, -22089}, {-24206, -22087}, {-24208, -22085}, {-24210, -22082},
    {-24212, -22080}, {-24214, -22078}, {-24216, -22075}, {-24218, -22073}, {-24220, -22071}, {-24222, -22068},
    {-24225, -22066}, {-24227, -22064}, {-24229, -22061}, {-24231, -22059}, {-24233, -22057}, {-24235, -22054},
    {-24237, -22052}, {-24239, -22050}, {-24241, -22048}, {-24244, -22045}, {-24246, -22043}, {-24248, -22041},
    {-24250, -22038}, {-24252, -22036}, {-24254, -22034}, {-24256, -22031}, {-24258, -22029}, {-24260, -22027},
    {-24263, -22024}, {-24265, -22022}, {-24267, -22020}, {-24269, -22017}, {-24271, -22015}, {-24273, -22013},
    {-24275, -22010}, {-24277, -22008}, {-24279, -22006}, {-24282, -22003}, {-24284, -22001}, {-24286, -21999},
    {-24288, -21996}, {-24290, -21994}, {-24292, -21992}, {-24294, -21989}, {-24296, -21987}, {-24298, -21985},
    {-24301, -21982}, {-24303, -21980}, {-24305, -21978}, {-24307, -21975}, {-24309, -21973}, {-24311, -21971},
    {-24313, -21968}, {-24315, -21966}, {-24317, -21964}, {-24320, -21961}, {-24322, -21959}, {-24324, -21957},
    {-24326, -21954}, {-24328, -21952}, {-24330, -21950}, {-24332, -21947}, {-24334, -21945}, {-24336, -21943},
    {-24338, -21940}, {-24341, -21938}, {-24343, -21936}, {-24345, -21933}, {-24347, -21931}, {-24349, -21929},
    {-24351, -21926}, {-24353, -21924}, {-24355, -21922}, {-24357, -21919}, {-24359, -21917}, {-24362, -21915},
    {-24364, -21912}, {-24366, -21910}, {-24368, -21908}, {-24370, -21905}, {-24372, -21903}, {-24374, -21901},
    {-24376, -21898}, {-24378, -21896}, {-24380, -21894}, {-24383, -21891}, {-24385, -21889}, {-24387, -21887},
    {-24389, -21884}, {-24391, -21882}, {-24393, -21880}, {-24395, -21877}, {-24397, -21875}, {-24399, -21873},
    {-24401, -21870}, {-24404, -21868}, {-24406, -21866}, {-24408, -21863}, {-24410, -21861}, {-24412, -21859},
    {-24414, -21856}, {-24416, -21854}, {-24418, -21852}, {-24420, -21849}, {-24422, -21847}, {-24425, -21845},
    {-24427, -21842}, {-24429, -21840}, {-24431, -21838}, {-24433, -21835}, {-24435, -21833}, {-24437, -21830},
    {-24439, -21828}, {-24441, -21826}, {-24443, -21823}, {-24445, -21821}, {-24448, -21819}, {-24450, -21816},
    {-24452, -21814}, {-24454, -21812}, {-24456, -21809}, {-24458, -21807}, {-24460, -21805}, {-24462, -21802},
    {-24464, -21800}, {-24466, -21798}, {-24468, -21795}, {-24471, -21793}, {-24473, -21791}, {-24475, -21788},
    {-24477, -21786}, {-24479, -21784}, {-24481, -21781}, {-24483, -21779}, {-24485, -21777}, {-24487, -21774},
    {-24489, -21772}, {-24491, -21770}, {-24494, -21767}, {-24496, -21765}, {-24498, -21762}, {-24500, -21760},
    {-24502, -21758}, {-24504, -21755}, {-24506, -21753}, {-24508, -21751}, {-24510, -21748}, {-24512, -21746},
    {-24514, -21744}, {-24516, -21741}, {-24519, -21739}, {-24521, -21737}, {-24523, -21734}, {-24525, -21732},
    {-24527, -21730}, {-24529, -21727}, {-24531, -21725}, {-24533, -21723}, {-24535, -21720}, {-24537, -21718},
    {-24539, -21715}, {-24541, -21713}, {-24544, -21711}, {-24546, -21708}, {-24548, -21706}, {-24550, -21704},
    {-24552, -21701}, {-24554, -21699}, {-24556, -21697}, {-24558, -21694}, {-24560, -21692}, {-24562, -21690},
    {-24564, -21687}, {-24566, -21685}, {-24569, -21682}, {-24571, -21680}, {-24573, -21678}, {-24575, -21675},
    {-24577, -21673}, {-24579, -21671}, {-24581, -21668}, {-24583, -21666}, {-24585, -21664}, {-24587, -21661},
    {-24589, -21659}, {-24591, -21657}, {-24593, -21654}, {-24596, -21652}, {-24598, -21649}, {-24600, -21647},
    {-24602, -21645}, {-24604, -21642}, {-24606, -21640}, {-24608, -21638}, {-24610, -21635}, {-24612, -21633},
    {-24614, -21631}, {-24616, -21628}, {-24618, -21626}, {-24620, -21624}, {-24622, -21621}, {-24625, -21619},
    {-24627, -21616}, {-24629, -21614}, {-24631, -21612}, {-24633, -21609}, {-24635, -21607}, {-24637, -21605},
    {-24639, -21602}, {-24641, -21600}, {-24643, -21598}, {-24645, -21595}, {-24647, -21593}, {-24649, -21590},
    {-24651, -21588}, {-24654, -21586}, {-24656, -21583}, {-24658, -21581}, {-24660, -21579}, {-24662, -21576},
    {-24664, -21574}, {-24666, -21572}, {-24668, -21569}, {-24670, -21567}, {-24672, -21564}, {-24674, -21562},
    {-24676, -21560}, {-24678, -21557}, {-24680, -21555}, {-24682, -21553}, {-24685, -21550}, {-24687, -21548},
    {-24689, -21546}, {-24691, -21543}, {-24693, -21541}, {-24695, -21538}, {-24697, -21536}, {-24699, -21534},
    {-24701, -21531}, {-24703, -21529}, {-24705, -21527}, {-24707, -21524}, {-24709, -21522}, {-24711, -21519},
    {-24713, -21517}, {-24716, -21515}, {-24718, -21512}, {-24720, -21510}, {-24722, -21508}, {-24724, -21505},
    {-24726, -21503}, {-24728, -21501}, {-24730, -21498}, {-24732, -21496}, {-24734, -21493}, {-24736, -21491},
    {-24738, -21489}, {-24740, -21486}, {-24742, -21484}, {-24744, -21482}, {-24746, -21479}, {-24748, -21477},
    {-24751, -21474}, {-24753, -21472}, {-24755, -21470}, {-24757, -21467}, {-24759, -21465}, {-24761, -21463},
    {-24763, -21460}, {-24765, -21458}, {-24767, -21455}, {-24769, -21453}, {-24771, -21451}, {-24773, -21448},
    {-24775, -21446}, {-24777, -21444}, {-24779, -21441}, {-24781, -21439}, {-24783, -21436}, {-24786, -21434},
    {-24788, -21432}, {-24790, -21429}, {-24792, -21427}, {-24794, -21425}, {-24796, -21422}, {-24798, -21420},
    {-24800, -21417}, {-24802, -21415}, {-24804, -21413}, {-24806, -21410}, {-24808, -21408}, {-24810, -21406},
    {-24812, -21403}, {-24814, -21401}, {-24816, -21398}, {-24818, -21396}, {-24820, -21394}, {-24822, -21391},
    {-24825, -21389}, {-24827, -21387}, {-24829, -21384}, {-24831, -21382}, {-24833, -21379}, {-24835, -21377},
    {-24837, -21375}, {-24839, -21372}, {-24841, -21370}, {-24843, -21367}, {-24845, -21365}, {-24847, -21363},
    {-24849, -21360}, {-24851, -21358}, {-24853, -21356}, {-24855, -21353}, {-24857, -21351}, {-24859, -21348},
    {-24861, -21346}, {-24863, -21344}, {-24865, -21341}, {-24868, -21339}, {-24870, -21336}, {-24872, -21334},
    {-24874, -21332}, {-24876, -21329}, {-24878, -21327}, {-24880, -21325}, {-24882, -21322}, {-24884, -21320},
    {-24886, -21317}, {-24888, -21315}, {-24890, -21313}, {-24892, -21310}, {-24894, -21308}, {-24896, -21305},
    {-24898, -21303}, {-24900, -21301}, {-24902, -21298}, {-24904, -21296}, {-24906, -21294}, {-24908, -21291},
    {-24910, -21289}, {-24912, -21286}, {-24915, -21284}, {-24917, -21282}, {-24919, -21279}, {-24921, -21277},
    {-24923, -21274}, {-24925, -21272}, {-24927, -21270}, {-24929, -21267}, {-24931, -21265}, {-24933, -21262},
    {-24935, -21260}, {-24937, -21258}, {-24939, -21255}, {-24941, -21253}, {-24943, -21251}, {-24945, -21248},
    {-24947, -21246}, {-24949, -21243}, {-24951, -21241}, {-24953, -21239}, {-24955, -21236}, {-24957, -21234},
    {-24959, -21231}, {-24961, -21229}, {-24963, -21227}, {-24965, -21224}, {-24968, -21222}, {-24970, -21219},
    {-24972, -21217}, {-24974, -21215}, {-24976, -21212}, {-24978, -21210}, {-24980, -21207}, {-24982, -21205},
    {-24984, -21203}, {-24986, -21200}, {-24988, -21198}, {-24990, -21195}, {-24992, -21193}, {-24994, -21191},
    {-24996, -21188}, {-24998, -21186}, {-25000, -21183}, {-25002, -21181}, {-25004, -21179}, {-25006, -21176},
    {-25008, -21174}, {-25010, -21171}, {-25012, -21169}, {-25014, -21167}, {-25016, -21164}, {-25018, -21162},
    {-25020, -21160}, {-25022, -21157}, {-25024, -21155}, {-25026, -21152}, {-25028, -21150}, {-25030, -21148},
    {-25033, -21145}, {-25035, -21143}, {-25037, -21140}, {-25039, -21138}, {-25041, -21136}, {-25043, -21133},
    {-25045, -21131}, {-25047, -21128}, {-25049, -21126}, {-25051, -21124}, {-25053, -21121}, {-25055, -21119},
    {-25057, -21116}, {-25059, -21114}, {-25061, -21111}, {-25063, -21109}, {-25065, -21107}, {-25067, -21104},
    {-25069, -21102}, {-25071, -21099}, {-25073, -21097}, {-25075, -21095}, {-25077, -21092}, {-25079, -21090},
    {-25081, -21087}, {-25083, -21085}, {-25085, -21083}, {-25087, -21080}, {-25089, -21078}, {-25091, -21075},
    {-25093, -21073}, {-25095, -21071}, {-25097, -21068}, {-25099, -21066}, {-25101, -21063}, {-25103, -21061},
    {-25105, -21059}, {-25107, -21056}, {-25109, -21054}, {-25111, -21051}, {-25113, -21049}, {-25115, -21047},
    {-25117, -21044}, {-25119, -21042}, {-25121, -21039}, {-25123, -21037}, {-25126, -21035}, {-25128, -21032},
    {-25130, -21030}, {-25132, -21027}, {-25134, -21025}, {-25136, -21022}, {-25138, -21020}, {-25140, -21018},
    {-25142, -21015}, {-25144, -21013}, {-25146, -21010}, {-25148, -21008}, {-25150, -21006}, {-25152, -21003},
    {-25154, -21001}, {-25156, -20998}, {-25158, -20996}, {-25160, -20994}, {-25162, -20991}, {-25164, -20989},
    {-25166, -20986}, {-25168, -20984}, {-25170, -20981}, {-25172, -20979}, {-25174, -20977}, {-25176, -20974},
    {-25178, -20972}, {-25180, -20969}, {-25182, -20967}, {-25184, -20965}, {-25186, -20962}, {-25188, -20960},
    {-25190, -20957}, {-25192, -20955}, {-25194, -20952}, {-25196, -20950}, {-25198, -20948}, {-25200, -20945},
    {-25202, -20943}, {-25204, -20940}, {-25206, -20938}, {-25208, -20936}, {-25210, -20933}, {-25212, -20931},
    {-25214, -20928}, {-25216, -20926}, {-25218, -20923}, {-25220, -20921}, {-25222, -20919}, {-25224, -20916},
    {-25226, -20914}, {-25228, -20911}, {-25230, -20909}, {-25232, -20907}, {-25234, -20904}, {-25236, -20902},
    {-25238, -20899}, {-25240, -20897}, {-25242, -20894}, {-25244, -20892}, {-25246, -20890}, {-25248, -20887},
    {-25250, -20885}, {-25252, -20882}, {-25254, -20880}, {-25256, -20878}, {-25258, -20875}, {-25260, -20873},
    {-25262, -20870}, {-25264, -20868}, {-25266, -20865}, {-25268, -20863}, {-25270, -20861}, {-25272, -20858},
    {-25274, -20856}, {-25276, -20853}, {-25278, -20851}, {-25280, -20848}, {-25282, -20846}, {-25284, -20844},
    {-25286, -20841}, {-25288, -20839}, {-25290, -20836}, {-25292, -20834}, {-25294, -20831}, {-25296, -20829},
    {-25298, -20827}, {-25300, -20824}, {-25302, -20822}, {-25304, -20819}, {-25306, -20817}, {-25308, -20815},
    {-25310, -20812}, {-25312, -20810}, {-25314, -20807}, {-25316, -20805}, {-25318, -20802}, {-25320, -20800},
    {-25322, -20798}, {-25324, -20795}, {-25326, -20793}, {-25328, -20790}, {-25330, -20788}, {-25332, -20785},
    {-25334, -20783}, {-25336, -20781}, {-25338, -20778}, {-25340, -20776}, {-25342, -20773}, {-25344, -20771},
    {-25346, -20768}, {-25348, -20766}, {-25350, -20764}, {-25352, -20761}, {-25354, -20759}, {-25356, -20756},
    {-25358, -20754}, {-25360, -20751}, {-25362, -20749}, {-25364, -20746}, {-25366, -20744}, {-25368, -20742},
    {-25370, -20739}, {-25372, -20737}, {-25374, -20734}, {-25376, -20732}, {-25378, -20729}, {-25380, -20727},
    {-25382, -20725}, {-25384, -20722}, {-25386, -20720}, {-25388, -20717}, {-25390, -20715}, {-25392, -20712},
    {-25394, -20710}, {-25396, -20708}, {-25398, -20705}, {-25400, -20703}, {-25402, -20700}, {-25404, -20698},
    {-25406, -20695}, {-25408, -20693}, {-25410, -20691}, {-25412, -20688}, {-25414, -20686}, {-25415, -20683},
    {-25417, -20681}, {-25419, -20678}, {-25421, -20676}, {-25423, -20673}, {-25425, -20671}, {-25427, -20669},
    {-25429, -20666}, {-25431, -20664}, {-25433, -20661}, {-25435, -20659}, {-25437, -20656}, {-25439, -20654},
    {-25441, -20652}, {-25443, -20649}, {-25445, -20647}, {-25447, -20644}, {-25449, -20642}, {-25451, -20639},
    {-25453, -20637}, {-25455, -20634}, {-25457, -20632}, {-25459, -20630}, {-25461, -20627}, {-25463, -20625},
    {-25465, -20622}, {-25467, -20620}, {-25469, -20617}, {-25471, -20615}, {-25473, -20612}, {-25475, -20610},
    {-25477, -20608}, {-25479, -20605}, {-25481, -20603}, {-25483, -20600}, {-25485, -20598}, {-25487, -20595},
    {-25489, -20593}, {-25491, -20590}, {-25493, -20588}, {-25495, -20586}, {-25497, -20583}, {-25499, -20581},
    {-25501, -20578}, {-25503, -20576}, {-25504, -20573}, {-25506, -20571}, {-25508, -20568}, {-25510, -20566},
    {-25512, -20564}, {-25514, -20561}, {-25516, -20559}, {-25518, -20556}, {-25520, -20554}, {-25522, -20551},
    {-25524, -20549}, {-25526, -20546}, {-25528, -20544}, {-25530, -20542}, {-25532, -20539}, {-25534, -20537},
    {-25536, -20534}, {-25538, -20532}, {-25540, -20529}, {-25542, -20527}, {-25544, -20524}, {-25546, -20522},
    {-25548, -20520}, {-25550, -20517}, {-25552, -20515}, {-25554, -20512}, {-25556, -20510}, {-25558, -20507},
    {-25560, -20505}, {-25562, -20502}, {-25564, -20500}, {-25566, -20497}, {-25567, -20495}, {-25569, -20493},
    {-25571, -20490}, {-25573, -20488}, {-25575, -20485}, {-25577, -20483}, {-25579, -20480}, {-25581, -20478},
    {-25583, -20475}, {-25585, -20473}, {-25587, -20470}, {-25589, -20468}, {-25591, -20466}, {-25593, -20463},
    {-25595, -20461}, {-25597, -20458}, {-25599, -20456}, {-25601, -20453}, {-25603, -20451}, {-25605, -20448},
    {-25607, -20446}, {-25609, -20443}, {-25611, -20441}, {-25613, -20439}, {-25615, -20436}, {-25617, -20434},
    {-25618, -20431}, {-25620, -20429}, {-25622, -20426}, {-25624, -20424}, {-25626, -20421}, {-25628, -20419},
    {-25630, -20416}, {-25632, -20414}, {-25634, -20412}, {-25636, -20409}, {-25638, -20407}, {-25640, -20404},
    {-25642, -20402}, {-25644, -20399}, {-25646, -20397}, {-25648, -20394}, {-25650, -20392}, {-25652, -20389},
    {-25654, -20387}, {-25656, -20385}, {-25658, -20382}, {-25660, -20380}, {-25662, -20377}, {-25663, -20375},
    {-25665, -20372}, {-25667, -20370}, {-25669, -20367}, {-25671, -20365}, {-25673, -20362}, {-25675, -20360},
    {-25677, -20357}, {-25679, -20355}, {-25681, -20353}, {-25683, -20350}, {-25685, -20348}, {-25687, -20345},
    {-25689, -20343}, {-25691, -20340}, {-25693, -20338}, {-25695, -20335}, {-25697, -20333}, {-25699, -20330},
    {-25701, -20328}, {-25703, -20325}, {-25704, -20323}, {-25706, -20320}, {-25708, -20318}, {-25710, -20316},
    {-25712, -20313}, {-25714, -20311}, {-25716, -20308}, {-25718, -20306}, {-25720, -20303}, {-25722, -20301},
    {-25724, -20298}, {-25726, -20296}, {-25728, -20293}, {-25730, -20291}, {-25732, -20288}, {-25734, -20286},
    {-25736, -20284}, {-25738, -20281}, {-25739, -20279}, {-25741, -20276}, {-25743, -20274}, {-25745, -20271},
    {-25747, -20269}, {-25749, -20266}, {-25751, -20264}, {-25753, -20261}, {-25755, -20259}, {-25757, -20256},
    {-25759, -20254}, {-25761, -20251}, {-25763, -20249}, {-25765, -20246}, {-25767, -20244}, {-25769, -20242},
    {-25771, -20239}, {-25773, -20237}, {-25774, -20234}, {-25776, -20232}, {-25778, -20229}, {-25780, -20227},
    {-25782, -20224}, {-25784, -20222}, {-25786, -20219}, {-25788, -20217}, {-25790, -20214}, {-25792, -20212},
    {-25794, -20209}, {-25796, -20207}, {-25798, -20204}, {-25800, -20202}, {-25802, -20200}, {-25804, -20197},
    {-25805, -20195}, {-25807, -20192}, {-25809, -20190}, {-25811, -20187}, {-25813, -20185}, {-25815, -20182},
    {-25817, -20180}, {-25819, -20177}, {-25821, -20175}, {-25823, -20172}, {-25825, -20170}, {-25827, -20167},
    {-25829, -20165}, {-25831, -20162}, {-25833, -20160}, {-25834, -20157}, {-25836, -20155}, {-25838, -20152},
    {-25840, -20150}, {-25842, -20148}, {-25844, -20145}, {-25846, -20143}, {-25848, -20140}, {-25850, -20138},
    {-25852, -20135}, {-25854, -20133}, {-25856, -20130}, {-25858, -20128}, {-25860, -20125}, {-25862, -20123},
    {-25863, -20120}, {-25865, -20118}, {-25867, -20115}, {-25869, -20113}, {-25871, -20110}, {-25873, -20108},
    {-25875, -20105}, {-25877, -20103}, {-25879, -20100}, {-25881, -20098}, {-25883, -20095}, {-25885, -20093},
    {-25887, -20090}, {-25888, -20088}, {-25890, -20086}, {-25892, -20083}, {-25894, -20081}, {-25896, -20078},
    {-25898, -20076}, {-25900, -20073}, {-25902, -20071}, {-25904, -20068}, {-25906, -20066}, {-25908, -20063},
    {-25910, -20061}, {-25912, -20058}, {-25914, -20056}, {-25915, -20053}, {-25917, -20051}, {-25919, -20048},
    {-25921, -20046}, {-25923, -20043}, {-25925, -20041}, {-25927, -20038}, {-25929, -20036}, {-25931, -20033},
    {-25933, -20031}, {-25935, -20028}, {-25937, -20026}, {-25938, -20023}, {-25940, -20021}, {-25942, -20018},
    {-25944, -20016}, {-25946, -20013}, {-25948, -20011}, {-25950, -20008}, {-25952, -20006}, {-25954, -20004},
    {-25956, -20001}, {-25958, -19999}, {-25960, -19996}, {-25961, -19994}, {-25963, -19991}, {-25965, -19989},
    {-25967, -19986}, {-25969, -19984}, {-25971, -19981}, {-25973, -19979}, {-25975, -19976}, {-25977, -19974},
    {-25979, -19971}, {-25981, -19969}, {-25983, -19966}, {-25984, -19964}, {-25986, -19961}, {-25988, -19959},
    {-25990, -19956}, {-25992, -19954}, {-25994, -19951}, {-25996, -19949}, {-25998, -19946}, {-26000, -19944},
    {-26002, -19941}, {-26004, -19939}, {-26006, -19936}, {-26007, -19934}, {-26009, -19931}, {-26011, -19929},
    {-26013, -19926}, {-26015, -19924}, {-26017, -19921}, {-26019, -19919}, {-26021, -19916}, {-26023, -19914},
    {-26025, -19911}, {-26027, -19909}, {-26028, -19906}, {-26030, -19904}, {-26032, -19901}, {-26034, -19899},
    {-26036, -19896}, {-26038, -19894}, {-26040, -19891}, {-26042, -19889}, {-26044, -19886}, {-26046, -19884},
    {-26048, -19881}, {-26049, -19879}, {-26051, -19876}, {-26053, -19874}, {-26055, -19871}, {-26057, -19869},
    {-26059, -19866}, {-26061, -19864}, {-26063, -19861}, {-26065, -19859}, {-26067, -19856}, {-26068, -19854},
    {-26070, -19851}, {-26072, -19849}, {-26074, -19846}, {-26076, -19844}, {-26078, -19841}, {-26080, -19839},
    {-26082, -19836}, {-26084, -19834}, {-26086, -19831}, {-26087, -19829}, {-26089, -19826}, {-26091, -19824},
    {-26093, -19821}, {-26095, -19819}, {-26097, -19816}, {-26099, -19814}, {-26101, -19811}, {-26103, -19809},
    {-26105, -19806}, {-26106, -19804}, {-26108, -19801}, {-26110, -19799}, {-26112, -19796}, {-26114, -19794},
    {-26116, -19791}, {-26118, -19789}, {-26120, -19786}, {-26122, -19784}, {-26124, -19781}, {-26125, -19779},
    {-26127, -19776}, {-26129, -19774}, {-26131, -19771}, {-26133, -19769}, {-26135, -19766}, {-26137, -19764},
    {-26139, -19761}, {-26141, -19759}, {-26143, -19756}, {-26144, -19754}, {-26146, -19751}, {-26148, -19749},
    {-26150, -19746}, {-26152, -19744}, {-26154, -19741}, {-26156, -19739}, {-26158, -19736}, {-26160, -19734},
    {-26161, -19731}, {-26163, -19729}, {-26165, -19726}, {-26167, -19724}, {-26169, -19721}, {-26171, -19719},
    {-26173, -19716}, {-26175, -19714}, {-26177, -19711}, {-26178, -19709}, {-26180, -19706}, {-26182, -19704},
    {-26184, -19701}, {-26186, -19699}, {-26188, -19696}, {-26190, -19694}, {-26192, -19691}, {-26194, -19689},
    {-26195, -19686}, {-26197, -19684}, {-26199, -19681}, {-26201, -19678}, {-26203, -19676}, {-26205, -19673},
    {-26207, -19671}, {-26209, -19668}, {-26211, -19666}, {-26212, -19663}, {-26214, -19661}, {-26216, -19658},
    {-26218, -19656}, {-26220, -19653}, {-26222, -19651}, {-26224, -19648}, {-26226, -19646}, {-26228, -19643},
    {-26229, -19641}, {-26231, -19638}, {-26233, -19636}, {-26235, -19633}, {-26237, -19631}, {-26239, -19628},
    {-26241, -19626}, {-26243, -19623}, {-26244, -19621}, {-26246, -19618}, {-26248, -19616}, {-26250, -19613},
    {-26252, -19611}, {-26254, -19608}, {-26256, -19606}, {-26258, -19603}, {-26259, -19601}, {-26261, -19598},
    {-26263, -19595}, {-26265, -19593}, {-26267, -19590}, {-26269, -19588}, {-26271, -19585}, {-26273, -19583},
    {-26275, -19580}, {-26276, -19578}, {-26278, -19575}, {-26280, -19573}, {-26282, -19570}, {-26284, -19568},
    {-26286, -19565}, {-26288, -19563}, {-26290, -19560}, {-26291, -19558}, {-26293, -19555}, {-26295, -19553},
    {-26297, -19550}, {-26299, -19548}, {-26301, -19545}, {-26303, -19543}, {-26305, -19540}, {-26306, -19538},
    {-26308, -19535}, {-26310, -19532}, {-26312, -19530}, {-26314, -19527}, {-26316, -19525}, {-26318, -19522},
    {-26320, -19520}, {-26321, -19517}, {-26323, -19515}, {-26325, -19512}, {-26327, -19510}, {-26329, -19507},
    {-26331, -19505}, {-26333, -19502}, {-26334, -19500}, {-26336, -19497}, {-26338, -19495}, {-26340, -19492},
    {-26342, -19490}, {-26344, -19487}, {-26346, -19485}, {-26348, -19482}, {-26349, -19479}, {-26351, -19477},
    {-26353, -19474}, {-26355, -19472}, {-26357, -19469}, {-26359, -19467}, {-26361, -19464}, {-26362, -19462},
    {-26364, -19459}, {-26366, -19457}, {-26368, -19454}, {-26370, -19452}, {-26372, -19449}, {-26374, -19447},
    {-26376, -19444}, {-26377, -19442}, {-26379, -19439}, {-26381, -19437}, {-26383, -19434}, {-26385, -19431},
    {-26387, -19429}, {-26389, -19426}, {-26390, -19424}, {-26392, -19421}, {-26394, -19419}, {-26396, -19416},
    {-26398, -19414}, {-26400, -19411}, {-26402, -19409}, {-26403, -19406}, {-26405, -19404}, {-26407, -19401},
    {-26409, -19399}, {-26411, -19396}, {-26413, -19393}, {-26415, -19391}, {-26416, -19388}, {-26418, -19386},
    {-26420, -19383}, {-26422, -19381}, {-26424, -19378}, {-26426, -19376}, {-26428, -19373}, {-26429, -19371},
    {-26431, -19368}, {-26433, -19366}, {-26435, -19363}, {-26437, -19361}, {-26439, -19358}, {-26441, -19355},
    {-26442, -19353}, {-26444, -19350}, {-26446, -19348}, {-26448, -19345}, {-26450, -19343}, {-26452, -19340},
    {-26454, -19338}, {-26455, -19335}, {-26457, -19333}, {-26459, -19330}, {-26461, -19328}, {-26463, -19325},
    {-26465, -19323}, {-26467, -19320}, {-26468, -19317}, {-26470, -19315}, {-26472, -19312}, {-26474, -19310},
    {-26476, -19307}, {-26478, -19305}, {-26480, -19302}, {-26481, -19300}, {-26483, -19297}, {-26485, -19295},
    {-26487, -19292}, {-26489, -19290}, {-26491, -19287}, {-26493, -19284}, {-26494, -19282}, {-26496, -19279},
    {-26498, -19277}, {-26500, -19274}, {-26502, -19272}, {-26504, -19269}, {-26505, -19267}, {-26507, -19264},
    {-26509, -19262}, {-26511, -19259}, {-26513, -19256}, {-26515, -19254}, {-26517, -19251}, {-26518, -19249},
    {-26520, -19246}, {-26522, -19244}, {-26524, -19241}, {-26526, -19239}, {-26528, -19236}, {-26529, -19234},
    {-26531, -19231}, {-26533, -19229}, {-26535, -19226}, {-26537, -19223}, {-26539, -19221}, {-26540, -19218},
    {-26542, -19216}, {-26544, -19213}, {-26546, -19211}, {-26548, -19208}, {-26550, -19206}, {-26552, -19203},
    {-26553, -19201}, {-26555, -19198}, {-26557, -19195}, {-26559, -19193}, {-26561, -19190}, {-26563, -19188},
    {-26564, -19185}, {-26566, -19183}, {-26568, -19180}, {-26570, -19178}, {-26572, -19175}, {-26574, -19173},
    {-26575, -19170}, {-26577, -19167}, {-26579, -19165}, {-26581, -19162}, {-26583, -19160}, {-26585, -19157},
    {-26586, -19155}, {-26588, -19152}, {-26590, -19150}, {-26592, -19147}, {-26594, -19144}, {-26596, -19142},
    {-26597, -19139}, {-26599, -19137}, {-26601, -19134}, {-26603, -19132}, {-26605, -19129}, {-26607, -19127},
    {-26608, -19124}, {-26610, -19122}, {-26612, -19119}, {-26614, -19116}, {-26616, -19114}, {-26618, -19111},
    {-26619, -19109}, {-26621, -19106}, {-26623, -19104}, {-26625, -19101}, {-26627, -19099}, {-26629, -19096},
    {-26630, -19093}, {-26632, -19091}, {-26634, -19088}, {-26636, -19086}, {-26638, -19083}, {-26640, -19081},
    {-26641, -19078}, {-26643, -19076}, {-26645, -19073}, {-26647, -19070}, {-26649, -19068}, {-26651, -19065},
    {-26652, -19063}, {-26654, -19060}, {-26656, -19058}, {-26658, -19055}, {-26660, -19053}, {-26662, -19050},
    {-26663, -19047}, {-26665, -19045}, {-26667, -19042}, {-26669, -19040}, {-26671, -19037}, {-26673, -19035},
    {-26674, -19032}, {-26676, -19030}, {-26678, -19027}, {-26680, -19024}, {-26682, -19022}, {-26683, -19019},
    {-26685, -19017}, {-26687, -19014}, {-26689, -19012}, {-26691, -19009}, {-26693, -19007}, {-26694, -19004},
    {-26696, -19001}, {-26698, -18999}, {-26700, -18996}, {-26702, -18994}, {-26704, -18991}, {-26705, -18989},
    {-26707, -18986}, {-26709, -18983}, {-26711, -18981}, {-26713, -18978}, {-26714, -18976}, {-26716, -18973},
    {-26718, -18971}, {-26720, -18968}, {-26722, -18966}, {-26724, -18963}, {-26725, -18960}, {-26727, -18958},
    {-26729, -18955}, {-26731, -18953}, {-26733, -18950}, {-26734, -18948}, {-26736, -18945}, {-26738, -18942},
    {-26740, -18940}, {-26742, -18937}, {-26744, -18935}, {-26745, -18932}, {-26747, -18930}, {-26749, -18927},
    {-26751, -18925}, {-26753, -18922}, {-26754, -18919}, {-26756, -18917}, {-26758, -18914}, {-26760, -18912},
    {-26762, -18909}, {-26763, -18907}, {-26765, -18904}, {-26767, -18901}, {-26769, -18899}, {-26771, -18896},
    {-26773, -18894}, {-26774, -18891}, {-26776, -18889}, {-26778, -18886}, {-26780, -18883}, {-26782, -18881},
    {-26783, -18878}, {-26785, -18876}, {-26787, -18873}, {-26789, -18871}, {-26791, -18868}, {-26792, -18866},
    {-26794, -18863}, {-26796, -18860}, {-26798, -18858}, {-26800, -18855}, {-26801, -18853}, {-26803, -18850},
    {-26805, -18848}, {-26807, -18845}, {-26809, -18842}, {-26811, -18840}, {-26812, -18837}, {-26814, -18835},
    {-26816, -18832}, {-26818, -18830}, {-26820, -18827}, {-26821, -18824}, {-26823, -18822}, {-26825, -18819},
    {-26827, -18817}, {-26829, -18814}, {-26830, -18812}, {-26832, -18809}, {-26834, -18806}, {-26836, -18804},
    {-26838, -18801}, {-26839, -18799}, {-26841, -18796}, {-26843, -18794}, {-26845, -18791}, {-26847, -18788},
    {-26848, -18786}, {-26850, -18783}, {-26852, -18781}, {-26854, -18778}, {-26856, -18776}, {-26857, -18773},
    {-26859, -18770}, {-26861, -18768}, {-26863, -18765}, {-26865, -18763}, {-26866, -18760}, {-26868, -18757},
    {-26870, -18755}, {-26872, -18752}, {-26874, -18750}, {-26875, -18747}, {-26877, -18745}, {-26879, -18742},
    {-26881, -18739}, {-26883, -18737}, {-26884, -18734}, {-26886, -18732}, {-26888, -18729}, {-26890, -18727},
    {-26892, -18724}, {-26893, -18721}, {-26895, -18719}, {-26897, -18716}, {-26899, -18714}, {-26901, -18711},
    {-26902, -18709}, {-26904, -18706}, {-26906, -18703}, {-26908, -18701}, {-26909, -18698}, {-26911, -18696},
    {-26913, -18693}, {-26915, -18690}, {-26917, -18688}, {-26918, -18685}, {-26920, -18683}, {-26922, -18680},
    {-26924, -18678}, {-26926, -18675}, {-26927, -18672}, {-26929, -18670}, {-26931, -18667}, {-26933, -18665},
    {-26935, -18662}, {-26936, -18659}, {-26938, -18657}, {-26940, -18654}, {-26942, -18652}, {-26943, -18649},
    {-26945, -18647}, {-26947, -18644}, {-26949, -18641}, {-26951, -18639}, {-26952, -18636}, {-26954, -18634},
    {-26956, -18631}, {-26958, -18628}, {-26960, -18626}, {-26961, -18623}, {-26963, -18621}, {-26965, -18618},
    {-26967, -18616}, {-26968, -18613}, {-26970, -18610}, {-26972, -18608}, {-26974, -18605}, {-26976, -18603},
    {-26977, -18600}, {-26979, -18597}, {-26981, -18595}, {-26983, -18592}, {-26985, -18590}, {-26986, -18587},
    {-26988, -18585}, {-26990, -18582}, {-26992, -18579}, {-26993, -18577}, {-26995, -18574}, {-26997, -18572},
    {-26999, -18569}, {-27001, -18566}, {-27002, -18564}, {-27004, -18561}, {-27006, -18559}, {-27008, -18556},
    {-27009, -18553}, {-27011, -18551}, {-27013, -18548}, {-27015, -18546}, {-27017, -18543}, {-27018, -18540},
    {-27020, -18538}, {-27022, -18535}, {-27024, -18533}, {-27025, -18530}, {-27027, -18528}, {-27029, -18525},
    {-27031, -18522}, {-27033, -18520}, {-27034, -18517}, {-27036, -18515}, {-27038, -18512}, {-27040, -18509},
    {-27041, -18507}, {-27043, -18504}, {-27045, -18502}, {-27047, -18499}, {-27049, -18496}, {-27050, -18494},
    {-27052, -18491}, {-27054, -18489}, {-27056, -18486}, {-27057, -18483}, {-27059, -18481}, {-27061, -18478},
    {-27063, -18476}, {-27064, -18473}, {-27066, -18470}, {-27068, -18468}, {-27070, -18465}, {-27072, -18463},
    {-27073, -18460}, {-27075, -18458}, {-27077, -18455}, {-27079, -18452}, {-27080, -18450}, {-27082, -18447},
    {-27084, -18445}, {-27086, -18442}, {-27088, -18439}, {-27089, -18437}, {-27091, -18434}, {-27093, -18432},
    {-27095, -18429}, {-27096, -18426}, {-27098, -18424}, {-27100, -18421}, {-27102, -18419}, {-27103, -18416},
    {-27105, -18413}, {-27107, -18411}, {-27109, -18408}, {-27110, -18406}, {-27112, -18403}, {-27114, -18400},
    {-27116, -18398}, {-27118, -18395}, {-27119, -18393}, {-27121, -18390}, {-27123, -18387}, {-27125, -18385},
    {-27126, -18382}, {-27128, -18380}, {-27130, -18377}, {-27132, -18374}, {-27133, -18372}, {-27135, -18369},
    {-27137, -18367}, {-27139, -18364}, {-27140, -18361}, {-27142, -18359}, {-27144, -18356}, {-27146, -18354},
    {-27147, -18351}, {-27149, -18348}, {-27151, -18346}, {-27153, -18343}, {-27154, -18341}, {-27156, -18338},
    {-27158, -18335}, {-27160, -18333}, {-27162, -18330}, {-27163, -18328}, {-27165, -18325}, {-27167, -18322},
    {-27169, -18320}, {-27170, -18317}, {-27172, -18314}, {-27174, -18312}, {-27176, -18309}, {-27177, -18307},
    {-27179, -18304}, {-27181, -18301}, {-27183, -18299}, {-27184, -18296}, {-27186, -18294}, {-27188, -18291},
    {-27190, -18288}, {-27191, -18286}, {-27193, -18283}, {-27195, -18281}, {-27197, -18278}, {-27198, -18275},
    {-27200, -18273}, {-27202, -18270}, {-27204, -18268}, {-27205, -18265}, {-27207, -18262}, {-27209, -18260},
    {-27211, -18257}, {-27212, -18255}, {-27214, -18252}, {-27216, -18249}, {-27218, -18247}, {-27219, -18244},
    {-27221, -18241}, {-27223, -18239}, {-27225, -18236}, {-27226, -18234}, {-27228, -18231}, {-27230, -18228},
    {-27232, -18226}, {-27233, -18223}, {-27235, -18221}, {-27237, -18218}, {-27239, -18215}, {-27240, -18213},
    {-27242, -18210}, {-27244, -18208}, {-27246, -18205}, {-27247, -18202}, {-27249, -18200}, {-27251, -18197},
    {-27253, -18194}, {-27254, -18192}, {-27256, -18189}, {-27258, -18187}, {-27260, -18184}, {-27261, -18181},
    {-27263, -18179}, {-27265, -18176}, {-27267, -18174}, {-27268, -18171}, {-27270, -18168}, {-27272, -18166},
    {-27273, -18163}, {-27275, -18160}, {-27277, -18158}, {-27279, -18155}, {-27280, -18153}, {-27282, -18150},
    {-27284, -18147}, {-27286, -18145}, {-27287, -18142}, {-27289, -18140}, {-27291, -18137}, {-27293, -18134},
    {-27294, -18132}, {-27296, -18129}, {-27298, -18126}, {-27300, -18124}, {-27301, -18121}, {-27303, -18119},
    {-27305, -18116}, {-27307, -18113}, {-27308, -18111}, {-27310, -18108}, {-27312, -18106}, {-27313, -18103},
    {-27315, -18100}, {-27317, -18098}, {-27319, -18095}, {-27320, -18092}, {-27322, -18090}, {-27324, -18087},
    {-27326, -18085}, {-27327, -18082}, {-27329, -18079}, {-27331, -18077}, {-27333, -18074}, {-27334, -18071},
    {-27336, -18069}, {-27338, -18066}, {-27339, -18064}, {-27341, -18061}, {-27343, -18058}, {-27345, -18056},
    {-27346, -18053}, {-27348, -18051}, {-27350, -18048}, {-27352, -18045}, {-27353, -18043}, {-27355, -18040},
    {-27357, -18037}, {-27359, -18035}, {-27360, -18032}, {-27362, -18030}, {-27364, -18027}, {-27365, -18024},
    {-27367, -18022}, {-27369, -18019}, {-27371, -18016}, {-27372, -18014}, {-27374, -18011}, {-27376, -18009},
    {-27378, -18006}, {-27379, -18003}, {-27381, -18001}, {-27383, -17998}, {-27384, -17995}, {-27386, -17993},
    {-27388, -17990}, {-27390, -17988}, {-27391, -17985}, {-27393, -17982}, {-27395, -17980}, {-27396, -17977},
    {-27398, -17974}, {-27400, -17972}, {-27402, -17969}, {-27403, -17967}, {-27405, -17964}, {-27407, -17961},
    {-27409, -17959}, {-27410, -17956}, {-27412, -17953}, {-27414, -17951}, {-27415, -17948}, {-27417, -17946},
    {-27419, -17943}, {-27421, -17940}, {-27422, -17938}, {-27424, -17935}, {-27426, -17932}, {-27427, -17930},
    {-27429, -17927}, {-27431, -17924}, {-27433, -17922}, {-27434, -17919}, {-27436, -17917}, {-27438, -17914},
    {-27440, -17911}, {-27441, -17909}, {-27443, -17906}, {-27445, -17903}, {-27446, -17901}, {-27448, -17898},
    {-27450, -17896}, {-27452, -17893}, {-27453, -17890}, {-27455, -17888}, {-27457, -17885}, {-27458, -17882},
    {-27460, -17880}, {-27462, -17877}, {-27464, -17874}, {-27465, -17872}, {-27467, -17869}, {-27469, -17867},
    {-27470, -17864}, {-27472, -17861}, {-27474, -17859}, {-27476, -17856}, {-27477, -17853}, {-27479, -17851},
    {-27481, -17848}, {-27482, -17846}, {-27484, -17843}, {-27486, -17840}, {-27487, -17838}, {-27489, -17835},
    {-27491, -17832}, {-27493, -17830}, {-27494, -17827}, {-27496, -17824}, {-27498, -17822}, {-27499, -17819},
    {-27501, -17817}, {-27503, -17814}, {-27505, -17811}, {-27506, -17809}, {-27508, -17806}, {-27510, -17803},
    {-27511, -17801}, {-27513, -17798}, {-27515, -17795}, {-27517, -17793}, {-27518, -17790}, {-27520, -17787},
    {-27522, -17785}, {-27523, -17782}, {-27525, -17780}, {-27527, -17777}, {-27528, -17774}, {-27530, -17772},
    {-27532, -17769}, {-27534, -17766}, {-27535, -17764}, {-27537, -17761}, {-27539, -17758}, {-27540, -17756},
    {-27542, -17753}, {-27544, -17751}, {-27545, -17748}, {-27547, -17745}, {-27549, -17743}, {-27551, -17740},
    {-27552, -17737}, {-27554, -17735}, {-27556, -17732}, {-27557, -17729}, {-27559, -17727}, {-27561, -17724},
    {-27562, -17721}, {-27564, -17719}, {-27566, -17716}, {-27568, -17714}, {-27569, -17711}, {-27571, -17708},
    {-27573, -17706}, {-27574, -17703}, {-27576, -17700}, {-27578, -17698}, {-27579, -17695}, {-27581, -17692},
    {-27583, -17690}, {-27585, -17687}, {-27586, -17684}, {-27588, -17682}, {-27590, -17679}, {-27591, -17677},
    {-27593, -17674}, {-27595, -17671}, {-27596, -17669}, {-27598, -17666}, {-27600, -17663}, {-27601, -17661},
    {-27603, -17658}, {-27605, -17655}, {-27607, -17653}, {-27608, -17650}, {-27610, -17647}, {-27612, -17645},
    {-27613, -17642}, {-27615, -17639}, {-27617, -17637}, {-27618, -17634}, {-27620, -17632}, {-27622, -17629},
    {-27623, -17626}, {-27625, -17624}, {-27627, -17621}, {-27629, -17618}, {-27630, -17616}, {-27632, -17613},
    {-27634, -17610}, {-27635, -17608}, {-27637, -17605}, {-27639, -17602}, {-27640, -17600}, {-27642, -17597},
    {-27644, -17594}, {-27645, -17592}, {-27647, -17589}, {-27649, -17587}, {-27650, -17584}, {-27652, -17581},
    {-27654, -17579}, {-27656, -17576}, {-27657, -17573}, {-27659, -17571}, {-27661, -17568}, {-27662, -17565},
    {-27664, -17563}, {-27666, -17560}, {-27667, -17557}, {-27669, -17555}, {-27671, -17552}, {-27672, -17549},
    {-27674, -17547}, {-27676, -17544}, {-27677, -17541}, {-27679, -17539}, {-27681, -17536}, {-27682, -17533},
    {-27684, -17531}, {-27686, -17528}, {-27688, -17525}, {-27689, -17523}, {-27691, -17520}, {-27693, -17518},
    {-27694, -17515}, {-27696, -17512}, {-27698, -17510}, {-27699, -17507}, {-27701, -17504}, {-27703, -17502},
    {-27704, -17499}, {-27706, -17496}, {-27708, -17494}, {-27709, -17491}, {-27711, -17488}, {-27713, -17486},
    {-27714, -17483}, {-27716, -17480}, {-27718, -17478}, {-27719, -17475}, {-27721, -17472}, {-27723, -17470},
    {-27724, -17467}, {-27726, -17464}, {-27728, -17462}, {-27729, -17459}, {-27731, -17456}, {-27733, -17454},
    {-27734, -17451}, {-27736, -17448}, {-27738, -17446}, {-27739, -17443}, {-27741, -17440}, {-27743, -17438},
    {-27745, -17435}, {-27746, -17432}, {-27748, -17430}, {-27750, -17427}, {-27751, -17425}, {-27753, -17422},
    {-27755, -17419}, {-27756, -17417}, {-27758, -17414}, {-27760, -17411}, {-27761, -17409}, {-27763, -17406},
    {-27765, -17403}, {-27766, -17401}, {-27768, -17398}, {-27770, -17395}, {-27771, -17393}, {-27773, -17390},
    {-27775, -17387}, {-27776, -17385}, {-27778, -17382}, {-27780, -17379}, {-27781, -17377}, {-27783, -17374},
    {-27785, -17371}, {-27786, -17369}, {-27788, -17366}, {-27790, -17363}, {-27791, -17361}, {-27793, -17358},
    {-27795, -17355}, {-27796, -17353}, {-27798, -17350}, {-27800, -17347}, {-27801, -17345}, {-27803, -17342},
    {-27805, -17339}, {-27806, -17337}, {-27808, -17334}, {-27810, -17331}, {-27811, -17329}, {-27813, -17326},
    {-27814, -17323}, {-27816, -17321}, {-27818, -17318}, {-27819, -17315}, {-27821, -17313}, {-27823, -17310},
    {-27824, -17307}, {-27826, -17305}, {-27828, -17302}, {-27829, -17299}, {-27831, -17297}, {-27833, -17294},
    {-27834, -17291}, {-27836, -17289}, {-27838, -17286}, {-27839, -17283}, {-27841, -17281}, {-27843, -17278},
    {-27844, -17275}, {-27846, -17273}, {-27848, -17270}, {-27849, -17267}, {-27851, -17265}, {-27853, -17262},
    {-27854, -17259}, {-27856, -17257}, {-27858, -17254}, {-27859, -17251}, {-27861, -17249}, {-27863, -17246},
    {-27864, -17243}, {-27866, -17241}, {-27868, -17238}, {-27869, -17235}, {-27871, -17233}, {-27872, -17230},
    {-27874, -17227}, {-27876, -17225}, {-27877, -17222}, {-27879, -17219}, {-27881, -17216}, {-27882, -17214},
    {-27884, -17211}, {-27886, -17208}, {-27887, -17206}, {-27889, -17203}, {-27891, -17200}, {-27892, -17198},
    {-27894, -17195}, {-27896, -17192}, {-27897, -17190}, {-27899, -17187}, {-27901, -17184}, {-27902, -17182},
    {-27904, -17179}, {-27905, -17176}, {-27907, -17174}, {-27909, -17171}, {-27910, -17168}, {-27912, -17166},
    {-27914, -17163}, {-27915, -17160}, {-27917, -17158}, {-27919, -17155}, {-27920, -17152}, {-27922, -17150},
    {-27924, -17147}, {-27925, -17144}, {-27927, -17142}, {-27928, -17139}, {-27930, -17136}, {-27932, -17134},
    {-27933, -17131}, {-27935, -17128}, {-27937, -17126}, {-27938, -17123}, {-27940, -17120}, {-27942, -17117},
    {-27943, -17115}, {-27945, -17112}, {-27947, -17109}, {-27948, -17107}, {-27950, -17104}, {-27951, -17101},
    {-27953, -17099}, {-27955, -17096}, {-27956, -17093}, {-27958, -17091}, {-27960, -17088}, {-27961, -17085},
    {-27963, -17083}, {-27965, -17080}, {-27966, -17077}, {-27968, -17075}, {-27969, -17072}, {-27971, -17069},
    {-27973, -17067}, {-27974, -17064}, {-27976, -17061}, {-27978, -17059}, {-27979, -17056}, {-27981, -17053},
    {-27983, -17050}, {-27984, -17048}, {-27986, -17045}, {-27987, -17042}, {-27989, -17040}, {-27991, -17037},
    {-27992, -17034}, {-27994, -17032}, {-27996, -17029}, {-27997, -17026}, {-27999, -17024}, {-28001, -17021},
    {-28002, -17018}, {-28004, -17016}, {-28005, -17013}, {-28007, -17010}, {-28009, -17008}, {-28010, -17005},
    {-28012, -17002}, {-28014, -16999}, {-28015, -16997}, {-28017, -16994}, {-28018, -16991}, {-28020, -16989},
    {-28022, -16986}, {-28023, -16983}, {-28025, -16981}, {-28027, -16978}, {-28028, -16975}, {-28030, -16973},
    {-28031, -16970}, {-28033, -16967}, {-28035, -16965}, {-28036, -16962}, {-28038, -16959}, {-28040, -16956},
    {-28041, -16954}, {-28043, -16951}, {-28044, -16948}, {-28046, -16946}, {-28048, -16943}, {-28049, -16940},
    {-28051, -16938}, {-28053, -16935}, {-28054, -16932}, {-28056, -16930}, {-28057, -16927}, {-28059, -16924},
    {-28061, -16922}, {-28062, -16919}, {-28064, -16916}, {-28066, -16913}, {-28067, -16911}, {-28069, -16908},
    {-28070, -16905}, {-28072, -16903}, {-28074, -16900}, {-28075, -16897}, {-28077, -16895}, {-28079, -16892},
    {-28080, -16889}, {-28082, -16887}, {-28083, -16884}, {-28085, -16881}, {-28087, -16878}, {-28088, -16876},
    {-28090, -16873}, {-28092, -16870}, {-28093, -16868}, {-28095, -16865}, {-28096, -16862}, {-28098, -16860},
    {-28100, -16857}, {-28101, -16854}, {-28103, -16852}, {-28104, -16849}, {-28106, -16846}, {-28108, -16843},
    {-28109, -16841}, {-28111, -16838}, {-28113, -16835}, {-28114, -16833}, {-28116, -16830}, {-28117, -16827},
    {-28119, -16825}, {-28121, -16822}, {-28122, -16819}, {-28124, -16816}, {-28125, -16814}, {-28127, -16811},
    {-28129, -16808}, {-28130, -16806}, {-28132, -16803}, {-28133, -16800}, {-28135, -16798}, {-28137, -16795},
    {-28138, -16792}, {-28140, -16789}, {-28142, -16787}, {-28143, -16784}, {-28145, -16781}, {-28146, -16779},
    {-28148, -16776}, {-28150, -16773}, {-28151, -16771}, {-28153, -16768}, {-28154, -16765}, {-28156, -16763},
    {-28158, -16760}, {-28159, -16757}, {-28161, -16754}, {-28162, -16752}, {-28164, -16749}, {-28166, -16746},
    {-28167, -16744}, {-28169, -16741}, {-28170, -16738}, {-28172, -16736}, {-28174, -16733}, {-28175, -16730},
    {-28177, -16727}, {-28178, -16725}, {-28180, -16722}, {-28182, -16719}, {-28183, -16717}, {-28185, -16714},
    {-28186, -16711}, {-28188, -16708}, {-28190, -16706}, {-28191, -16703}, {-28193, -16700}, {-28194, -16698},
    {-28196, -16695}, {-28198, -16692}, {-28199, -16690}, {-28201, -16687}, {-28202, -16684}, {-28204, -16681},
    {-28206, -16679}, {-28207, -16676}, {-28209, -16673}, {-28210, -16671}, {-28212, -16668}, {-28214, -16665},
    {-28215, -16663}, {-28217, -16660}, {-28218, -16657}, {-28220, -16654}, {-28222, -16652}, {-28223, -16649},
    {-28225, -16646}, {-28226, -16644}, {-28228, -16641}, {-28230, -16638}, {-28231, -16635}, {-28233, -16633},
    {-28234, -16630}, {-28236, -16627}, {-28238, -16625}, {-28239, -16622}, {-28241, -16619}, {-28242, -16617},
    {-28244, -16614}, {-28246, -16611}, {-28247, -16608}, {-28249, -16606}, {-28250, -16603}, {-28252, -16600},
    {-28254, -16598}, {-28255, -16595}, {-28257, -16592}, {-28258, -16589}, {-28260, -16587}, {-28261, -16584},
    {-28263, -16581}, {-28265, -16579}, {-28266, -16576}, {-28268, -16573}, {-28269, -16570}, {-28271, -16568},
    {-28273, -16565}, {-28274, -16562}, {-28276, -16560}, {-28277, -16557}, {-28279, -16554}, {-28281, -16551},
    {-28282, -16549}, {-28284, -16546}, {-28285, -16543}, {-28287, -16541}, {-28288, -16538}, {-28290, -16535},
    {-28292, -16533}, {-28293, -16530}, {-28295, -16527}, {-28296, -16524}, {-28298, -16522}, {-28300, -16519},
    {-28301, -16516}, {-28303, -16514}, {-28304, -16511}, {-28306, -16508}, {-28307, -16505}, {-28309, -16503},
    {-28311, -16500}, {-28312, -16497}, {-28314, -16495}, {-28315, -16492}, {-28317, -16489}, {-28319, -16486},
    {-28320, -16484}, {-28322, -16481}, {-28323, -16478}, {-28325, -16476}, {-28326, -16473}, {-28328, -16470},
    {-28330, -16467}, {-28331, -16465}, {-28333, -16462}, {-28334, -16459}, {-28336, -16456}, {-28338, -16454},
    {-28339, -16451}, {-28341, -16448}, {-28342, -16446}, {-28344, -16443}, {-28345, -16440}, {-28347, -16437},
    {-28349, -16435}, {-28350, -16432}, {-28352, -16429}, {-28353, -16427}, {-28355, -16424}, {-28356, -16421},
    {-28358, -16418}, {-28360, -16416}, {-28361, -16413}, {-28363, -16410}, {-28364, -16408}, {-28366, -16405},
    {-28367, -16402}, {-28369, -16399}, {-28371, -16397}, {-28372, -16394}, {-28374, -16391}, {-28375, -16389},
    {-28377, -16386}, {-28378, -16383}, {-28380, -16380}, {-28382, -16378}, {-28383, -16375}, {-28385, -16372},
    {-28386, -16369}, {-28388, -16367}, {-28389, -16364}, {-28391, -16361}, {-28393, -16359}, {-28394, -16356},
    {-28396, -16353}, {-28397, -16350}, {-28399, -16348}, {-28400, -16345}, {-28402, -16342}, {-28404, -16340},
    {-28405, -16337}, {-28407, -16334}, {-28408, -16331}, {-28410, -16329}, {-28411, -16326}, {-28413, -16323},
    {-28415, -16320}, {-28416, -16318}, {-28418, -16315}, {-28419, -16312}, {-28421, -16310}, {-28422, -16307},
    {-28424, -16304}, {-28425, -16301}, {-28427, -16299}, {-28429, -16296}, {-28430, -16293}, {-28432, -16291},
    {-28433, -16288}, {-28435, -16285}, {-28436, -16282}, {-28438, -16280}, {-28440, -16277}, {-28441, -16274},
    {-28443, -16271}, {-28444, -16269}, {-28446, -16266}, {-28447, -16263}, {-28449, -16261}, {-28450, -16258},
    {-28452, -16255}, {-28454, -16252}, {-28455, -16250}, {-28457, -16247}, {-28458, -16244}, {-28460, -16241},
    {-28461, -16239}, {-28463, -16236}, {-28464, -16233}, {-28466, -16230}, {-28468, -16228}, {-28469, -16225},
    {-28471, -16222}, {-28472, -16220}, {-28474, -16217}, {-28475, -16214}, {-28477, -16211}, {-28478, -16209},
    {-28480, -16206}, {-28482, -16203}, {-28483, -16200}, {-28485, -16198}, {-28486, -16195}, {-28488, -16192},
    {-28489, -16190}, {-28491, -16187}, {-28492, -16184}, {-28494, -16181}, {-28496, -16179}, {-28497, -16176},
    {-28499, -16173}, {-28500, -16170}, {-28502, -16168}, {-28503, -16165}, {-28505, -16162}, {-28506, -16159},
    {-28508, -16157}, {-28509, -16154}, {-28511, -16151}, {-28513, -16149}, {-28514, -16146}, {-28516, -16143},
    {-28517, -16140}, {-28519, -16138}, {-28520, -16135}, {-28522, -16132}, {-28523, -16129}, {-28525, -16127},
    {-28526, -16124}, {-28528, -16121}, {-28530, -16118}, {-28531, -16116}, {-28533, -16113}, {-28534, -16110},
    {-28536, -16108}, {-28537, -16105}, {-28539, -16102}, {-28540, -16099}, {-28542, -16097}, {-28543, -16094},
    {-28545, -16091}, {-28547, -16088}, {-28548, -16086}, {-28550, -16083}, {-28551, -16080}, {-28553, -16077},
    {-28554, -16075}, {-28556, -16072}, {-28557, -16069}, {-28559, -16066}, {-28560, -16064}, {-28562, -16061},
    {-28564, -16058}, {-28565, -16056}, {-28567, -16053}, {-28568, -16050}, {-28570, -16047}, {-28571, -16045},
    {-28573, -16042}, {-28574, -16039}, {-28576, -16036}, {-28577, -16034}, {-28579, -16031}, {-28580, -16028},
    {-28582, -16025}, {-28583, -16023}, {-28585, -16020}, {-28587, -16017}, {-28588, -16014}, {-28590, -16012},
    {-28591, -16009}, {-28593, -16006}, {-28594, -16003}, {-28596, -16001}, {-28597, -15998}, {-28599, -15995},
    {-28600, -15992}, {-28602, -15990}, {-28603, -15987}, {-28605, -15984}, {-28607, -15982}, {-28608, -15979},
    {-28610, -15976}, {-28611, -15973}, {-28613, -15971}, {-28614, -15968}, {-28616, -15965}, {-28617, -15962},
    {-28619, -15960}, {-28620, -15957}, {-28622, -15954}, {-28623, -15951}, {-28625, -15949}, {-28626, -15946},
    {-28628, -15943}, {-28629, -15940}, {-28631, -15938}, {-28633, -15935}, {-28634, -15932}, {-28636, -15929},
    {-28637, -15927}, {-28639, -15924}, {-28640, -15921}, {-28642, -15918}, {-28643, -15916}, {-28645, -15913},
    {-28646, -15910}, {-28648, -15907}, {-28649, -15905}, {-28651, -15902}, {-28652, -15899}, {-28654, -15896},
    {-28655, -15894}, {-28657, -15891}, {-28658, -15888}, {-28660, -15885}, {-28662, -15883}, {-28663, -15880},
    {-28665, -15877}, {-28666, -15874}, {-28668, -15872}, {-28669, -15869}, {-28671, -15866}, {-28672, -15863},
    {-28674, -15861}, {-28675, -15858}, {-28677, -15855}, {-28678, -15852}, {-28680, -15850}, {-28681, -15847},
    {-28683, -15844}, {-28684, -15841}, {-28686, -15839}, {-28687, -15836}, {-28689, -15833}, {-28690, -15830},
    {-28692, -15828}, {-28693, -15825}, {-28695, -15822}, {-28696, -15819}, {-28698, -15817}, {-28699, -15814},
    {-28701, -15811}, {-28703, -15808}, {-28704, -15806}, {-28706, -15803}, {-28707, -15800}, {-28709, -15797},
    {-28710, -15795}, {-28712, -15792}, {-28713, -15789}, {-28715, -15786}, {-28716, -15784}, {-28718, -15781},
    {-28719, -15778}, {-28721, -15775}, {-28722, -15773}, {-28724, -15770}, {-28725, -15767}, {-28727, -15764},
    {-28728, -15762}, {-28730, -15759}, {-28731, -15756}, {-28733, -15753}, {-28734, -15751}, {-28736, -15748},
    {-28737, -15745}, {-28739, -15742}, {-28740, -15740}, {-28742, -15737}, {-28743, -15734}, {-28745, -15731},
    {-28746, -15729}, {-28748, -15726}, {-28749, -15723}, {-28751, -15720}, {-28752, -15718}, {-28754, -15715},
    {-28755, -15712}, {-28757, -15709}, {-28758, -15707}, {-28760, -15704}, {-28761, -15701}, {-28763, -15698},
    {-28764, -15696}, {-28766, -15693}, {-28767, -15690}, {-28769, -15687}, {-28770, -15684}, {-28772, -15682},
    {-28773, -15679}, {-28775, -15676}, {-28776, -15673}, {-28778, -15671}, {-28779, -15668}, {-28781, -15665},
    {-28782, -15662}, {-28784, -15660}, {-28785, -15657}, {-28787, -15654}, {-28788, -15651}, {-28790, -15649},
    {-28791, -15646}, {-28793, -15643}, {-28794, -15640}, {-28796, -15638}, {-28797, -15635}, {-28799, -15632},
    {-28800, -15629}, {-28802, -15627}, {-28803, -15624}, {-28805, -15621}, {-28806, -15618}, {-28808, -15615},
    {-28809, -15613}, {-28811, -15610}, {-28812, -15607}, {-28814, -15604}, {-28815, -15602}, {-28817, -15599},
    {-28818, -15596}, {-28820, -15593}, {-28821, -15591}, {-28823, -15588}, {-28824, -15585}, {-28826, -15582},
    {-28827, -15580}, {-28829, -15577}, {-28830, -15574}, {-28832, -15571}, {-28833, -15568}, {-28835, -15566},
    {-28836, -15563}, {-28838, -15560}, {-28839, -15557}, {-28841, -15555}, {-28842, -15552}, {-28844, -15549},
    {-28845, -15546}, {-28847, -15544}, {-28848, -15541}, {-28850, -15538}, {-28851, -15535}, {-28853, -15533},
    {-28854, -15530}, {-28856, -15527}, {-28857, -15524}, {-28859, -15521}, {-28860, -15519}, {-28862, -15516},
    {-28863, -15513}, {-28865, -15510}, {-28866, -15508}, {-28868, -15505}, {-28869, -15502}, {-28871, -15499},
    {-28872, -15497}, {-28874, -15494}, {-28875, -15491}, {-28877, -15488}, {-28878, -15486}, {-28880, -15483},
    {-28881, -15480}, {-28882, -15477}, {-28884, -15474}, {-28885, -15472}, {-28887, -15469}, {-28888, -15466},
    {-28890, -15463}, {-28891, -15461}, {-28893, -15458}, {-28894, -15455}, {-28896, -15452}, {-28897, -15449},
    {-28899, -15447}, {-28900, -15444}, {-28902, -15441}, {-28903, -15438}, {-28905, -15436}, {-28906, -15433},
    {-28908, -15430}, {-28909, -15427}, {-28911, -15425}, {-28912, -15422}, {-28914, -15419}, {-28915, -15416},
    {-28917, -15413}, {-28918, -15411}, {-28920, -15408}, {-28921, -15405}, {-28922, -15402}, {-28924, -15400},
    {-28925, -15397}, {-28927, -15394}, {-28928, -15391}, {-28930, -15389}, {-28931, -15386}, {-28933, -15383},
    {-28934, -15380}, {-28936, -15377}, {-28937, -15375}, {-28939, -15372}, {-28940, -15369}, {-28942, -15366},
    {-28943, -15364}, {-28945, -15361}, {-28946, -15358}, {-28948, -15355}, {-28949, -15352}, {-28950, -15350},
    {-28952, -15347}, {-28953, -15344}, {-28955, -15341}, {-28956, -15339}, {-28958, -15336}, {-28959, -15333},
    {-28961, -15330}, {-28962, -15327}, {-28964, -15325}, {-28965, -15322}, {-28967, -15319}, {-28968, -15316},
    {-28970, -15314}, {-28971, -15311}, {-28973, -15308}, {-28974, -15305}, {-28975, -15302}, {-28977, -15300},
    {-28978, -15297}, {-28980, -15294}, {-28981, -15291}, {-28983, -15289}, {-28984, -15286}, {-28986, -15283},
    {-28987, -15280}, {-28989, -15277}, {-28990, -15275}, {-28992, -15272}, {-28993, -15269}, {-28994, -15266},
    {-28996, -15264}, {-28997, -15261}, {-28999, -15258}, {-29000, -15255}, {-29002, -15252}, {-29003, -15250},
    {-29005, -15247}, {-29006, -15244}, {-29008, -15241}, {-29009, -15239}, {-29011, -15236}, {-29012, -15233},
    {-29013, -15230}, {-29015, -15227}, {-29016, -15225}, {-29018, -15222}, {-29019, -15219}, {-29021, -15216},
    {-29022, -15213}, {-29024, -15211}, {-29025, -15208}, {-29027, -15205}, {-29028, -15202}, {-29030, -15200},
    {-29031, -15197}, {-29032, -15194}, {-29034, -15191}, {-29035, -15188}, {-29037, -15186}, {-29038, -15183},
    {-29040, -15180}, {-29041, -15177}, {-29043, -15175}, {-29044, -15172}, {-29046, -15169}, {-29047, -15166},
    {-29048, -15163}, {-29050, -15161}, {-29051, -15158}, {-29053, -15155}, {-29054, -15152}, {-29056, -15149},
    {-29057, -15147}, {-29059, -15144}, {-29060, -15141}, {-29062, -15138}, {-29063, -15136}, {-29064, -15133},
    {-29066, -15130}, {-29067, -15127}, {-29069, -15124}, {-29070, -15122}, {-29072, -15119}, {-29073, -15116},
    {-29075, -15113}, {-29076, -15110}, {-29077, -15108}, {-29079, -15105}, {-29080, -15102}, {-29082, -15099},
    {-29083, -15097}, {-29085, -15094}, {-29086, -15091}, {-29088, -15088}, {-29089, -15085}, {-29091, -15083},
    {-29092, -15080}, {-29093, -15077}, {-29095, -15074}, {-29096, -15071}, {-29098, -15069}, {-29099, -15066},
    {-29101, -15063}, {-29102, -15060}, {-29104, -15057}, {-29105, -15055}, {-29106, -15052}, {-29108, -15049},
    {-29109, -15046}, {-29111, -15044}, {-29112, -15041}, {-29114, -15038}, {-29115, -15035}, {-29116, -15032},
    {-29118, -15030}, {-29119, -15027}, {-29121, -15024}, {-29122, -15021}, {-29124, -15018}, {-29125, -15016},
    {-29127, -15013}, {-29128, -15010}, {-29129, -15007}, {-29131, -15004}, {-29132, -15002}, {-29134, -14999},
    {-29135, -14996}, {-29137, -14993}, {-29138, -14990}, {-29140, -14988}, {-29141, -14985}, {-29142, -14982},
    {-29144, -14979}, {-29145, -14976}, {-29147, -14974}, {-29148, -14971}, {-29150, -14968}, {-29151, -14965},
    {-29152, -14963}, {-29154, -14960}, {-29155, -14957}, {-29157, -14954}, {-29158, -14951}, {-29160, -14949},
    {-29161, -14946}, {-29162, -14943}, {-29164, -14940}, {-29165, -14937}, {-29167, -14935}, {-29168, -14932},
    {-29170, -14929}, {-29171, -14926}, {-29173, -14923}, {-29174, -14921}, {-29175, -14918}, {-29177, -14915},
    {-29178, -14912}, {-29180, -14909}, {-29181, -14907}, {-29183, -14904}, {-29184, -14901}, {-29185, -14898},
    {-29187, -14895}, {-29188, -14893}, {-29190, -14890}, {-29191, -14887}, {-29193, -14884}, {-29194, -14881},
    {-29195, -14879}, {-29197, -14876}, {-29198, -14873}, {-29200, -14870}, {-29201, -14867}, {-29202, -14865},
    {-29204, -14862}, {-29205, -14859}, {-29207, -14856}, {-29208, -14853}, {-29210, -14851}, {-29211, -14848},
    {-29212, -14845}, {-29214, -14842}, {-29215, -14839}, {-29217, -14837}, {-29218, -14834}, {-29220, -14831},
    {-29221, -14828}, {-29222, -14825}, {-29224, -14823}, {-29225, -14820}, {-29227, -14817}, {-29228, -14814},
    {-29230, -14811}, {-29231, -14809}, {-29232, -14806}, {-29234, -14803}, {-29235, -14800}, {-29237, -14797},
    {-29238, -14795}, {-29239, -14792}, {-29241, -14789}, {-29242, -14786}, {-29244, -14783}, {-29245, -14781},
    {-29247, -14778}, {-29248, -14775}, {-29249, -14772}, {-29251, -14769}, {-29252, -14767}, {-29254, -14764},
    {-29255, -14761}, {-29256, -14758}, {-29258, -14755}, {-29259, -14753}, {-29261, -14750}, {-29262, -14747},
    {-29264, -14744}, {-29265, -14741}, {-29266, -14738}, {-29268, -14736}, {-29269, -14733}, {-29271, -14730},
    {-29272, -14727}, {-29273, -14724}, {-29275, -14722}, {-29276, -14719}, {-29278, -14716}, {-29279, -14713},
    {-29280, -14710}, {-29282, -14708}, {-29283, -14705}, {-29285, -14702}, {-29286, -14699}, {-29288, -14696},
    {-29289, -14694}, {-29290, -14691}, {-29292, -14688}, {-29293, -14685}, {-29295, -14682}, {-29296, -14680},
    {-29297, -14677}, {-29299, -14674}, {-29300, -14671}, {-29302, -14668}, {-29303, -14665}, {-29304, -14663},
    {-29306, -14660}, {-29307, -14657}, {-29309, -14654}, {-29310, -14651}, {-29311, -14649}, {-29313, -14646},
    {-29314, -14643}, {-29316, -14640}, {-29317, -14637}, {-29318, -14635}, {-29320, -14632}, {-29321, -14629},
    {-29323, -14626}, {-29324, -14623}, {-29325, -14621}, {-29327, -14618}, {-29328, -14615}, {-29330, -14612},
    {-29331, -14609}, {-29332, -14606}, {-29334, -14604}, {-29335, -14601}, {-29337, -14598}, {-29338, -14595},
    {-29339, -14592}, {-29341, -14590}, {-29342, -14587}, {-29344, -14584}, {-29345, -14581}, {-29346, -14578},
    {-29348, -14576}, {-29349, -14573}, {-29351, -14570}, {-29352, -14567}, {-29353, -14564}, {-29355, -14561},
    {-29356, -14559}, {-29358, -14556}, {-29359, -14553}, {-29360, -14550}, {-29362, -14547}, {-29363, -14545},
    {-29365, -14542}, {-29366, -14539}, {-29367, -14536}, {-29369, -14533}, {-29370, -14530}, {-29372, -14528},
    {-29373, -14525}, {-29374, -14522}, {-29376, -14519}, {-29377, -14516}, {-29379, -14514}, {-29380, -14511},
    {-29381, -14508}, {-29383, -14505}, {-29384, -14502}, {-29385, -14499}, {-29387, -14497}, {-29388, -14494},
    {-29390, -14491}, {-29391, -14488}, {-29392, -14485}, {-29394, -14483}, {-29395, -14480}, {-29397, -14477},
    {-29398, -14474}, {-29399, -14471}, {-29401, -14468}, {-29402, -14466}, {-29404, -14463}, {-29405, -14460},
    {-29406, -14457}, {-29408, -14454}, {-29409, -14452}, {-29410, -14449}, {-29412, -14446}, {-29413, -14443},
    {-29415, -14440}, {-29416, -14437}, {-29417, -14435}, {-29419, -14432}, {-29420, -14429}, {-29422, -14426},
    {-29423, -14423}, {-29424, -14421}, {-29426, -14418}, {-29427, -14415}, {-29428, -14412}, {-29430, -14409},
    {-29431, -14406}, {-29433, -14404}, {-29434, -14401}, {-29435, -14398}, {-29437, -14395}, {-29438, -14392},
    {-29439, -14390}, {-29441, -14387}, {-29442, -14384}, {-29444, -14381}, {-29445, -14378}, {-29446, -14375},
    {-29448, -14373}, {-29449, -14370}, {-29451, -14367}, {-29452, -14364}, {-29453, -14361}, {-29455, -14358},
    {-29456, -14356}, {-29457, -14353}, {-29459, -14350}, {-29460, -14347}, {-29462, -14344}, {-29463, -14342},
    {-29464, -14339}, {-29466, -14336}, {-29467, -14333}, {-29468, -14330}, {-29470, -14327}, {-29471, -14325},
    {-29473, -14322}, {-29474, -14319}, {-29475, -14316}, {-29477, -14313}, {-29478, -14310}, {-29479, -14308},
    {-29481, -14305}, {-29482, -14302}, {-29484, -14299}, {-29485, -14296}, {-29486, -14293}, {-29488, -14291},
    {-29489, -14288}, {-29490, -14285}, {-29492, -14282}, {-29493, -14279}, {-29494, -14277}, {-29496, -14274},
    {-29497, -14271}, {-29499, -14268}, {-29500, -14265}, {-29501, -14262}, {-29503, -14260}, {-29504, -14257},
    {-29505, -14254}, {-29507, -14251}, {-29508, -14248}, {-29509, -14245}, {-29511, -14243}, {-29512, -14240},
    {-29514, -14237}, {-29515, -14234}, {-29516, -14231}, {-29518, -14228}, {-29519, -14226}, {-29520, -14223},
    {-29522, -14220}, {-29523, -14217}, {-29525, -14214}, {-29526, -14211}, {-29527, -14209}, {-29529, -14206},
    {-29530, -14203}, {-29531, -14200}, {-29533, -14197}, {-29534, -14194}, {-29535, -14192}, {-29537, -14189},
    {-29538, -14186}, {-29539, -14183}, {-29541, -14180}, {-29542, -14177}, {-29544, -14175}, {-29545, -14172},
    {-29546, -14169}, {-29548, -14166}, {-29549, -14163}, {-29550, -14160}, {-29552, -14158}, {-29553, -14155},
    {-29554, -14152}, {-29556, -14149}, {-29557, -14146}, {-29558, -14143}, {-29560, -14141}, {-29561, -14138},
    {-29563, -14135}, {-29564, -14132}, {-29565, -14129}, {-29567, -14126}, {-29568, -14124}, {-29569, -14121},
    {-29571, -14118}, {-29572, -14115}, {-29573, -14112}, {-29575, -14109}, {-29576, -14107}, {-29577, -14104},
    {-29579, -14101}, {-29580, -14098}, {-29582, -14095}, {-29583, -14092}, {-29584, -14090}, {-29586, -14087},
    {-29587, -14084}, {-29588, -14081}, {-29590, -14078}, {-29591, -14075}, {-29592, -14073}, {-29594, -14070},
    {-29595, -14067}, {-29596, -14064}, {-29598, -14061}, {-29599, -14058}, {-29600, -14056}, {-29602, -14053},
    {-29603, -14050}, {-29604, -14047}, {-29606, -14044}, {-29607, -14041}, {-29608, -14039}, {-29610, -14036},
    {-29611, -14033}, {-29613, -14030}, {-29614, -14027}, {-29615, -14024}, {-29617, -14021}, {-29618, -14019},
    {-29619, -14016}, {-29621, -14013}, {-29622, -14010}, {-29623, -14007}, {-29625, -14004}, {-29626, -14002},
    {-29627, -13999}, {-29629, -13996}, {-29630, -13993}, {-29631, -13990}, {-29633, -13987}, {-29634, -13985},
    {-29635, -13982}, {-29637, -13979}, {-29638, -13976}, {-29639, -13973}, {-29641, -13970}, {-29642, -13968},
    {-29643, -13965}, {-29645, -13962}, {-29646, -13959}, {-29647, -13956}, {-29649, -13953}, {-29650, -13950},
    {-29651, -13948}, {-29653, -13945}, {-29654, -13942}, {-29655, -13939}, {-29657, -13936}, {-29658, -13933},
    {-29659, -13931}, {-29661, -13928}, {-29662, -13925}, {-29663, -13922}, {-29665, -13919}, {-29666, -13916},
    {-29667, -13913}, {-29669, -13911}, {-29670, -13908}, {-29671, -13905}, {-29673, -13902}, {-29674, -13899},
    {-29675, -13896}, {-29677, -13894}, {-29678, -13891}, {-29679, -13888}, {-29681, -13885}, {-29682, -13882},
    {-29683, -13879}, {-29685, -13877}, {-29686, -13874}, {-29687, -13871}, {-29689, -13868}, {-29690, -13865},
    {-29691, -13862}, {-29693, -13859}, {-29694, -13857}, {-29695, -13854}, {-29697, -13851}, {-29698, -13848},
    {-29699, -13845}, {-29701, -13842}, {-29702, -13839}, {-29703, -13837}, {-29705, -13834}, {-29706, -13831},
    {-29707, -13828}, {-29709, -13825}, {-29710, -13822}, {-29711, -13820}, {-29713, -13817}, {-29714, -13814},
    {-29715, -13811}, {-29717, -13808}, {-29718, -13805}, {-29719, -13802}, {-29721, -13800}, {-29722, -13797},
    {-29723, -13794}, {-29725, -13791}, {-29726, -13788}, {-29727, -13785}, {-29729, -13783}, {-29730, -13780},
    {-29731, -13777}, {-29732, -13774}, {-29734, -13771}, {-29735, -13768}, {-29736, -13765}, {-29738, -13763},
    {-29739, -13760}, {-29740, -13757}, {-29742, -13754}, {-29743, -13751}, {-29744, -13748}, {-29746, -13745},
    {-29747, -13743}, {-29748, -13740}, {-29750, -13737}, {-29751, -13734}, {-29752, -13731}, {-29754, -13728},
    {-29755, -13725}, {-29756, -13723}, {-29758, -13720}, {-29759, -13717}, {-29760, -13714}, {-29761, -13711},
    {-29763, -13708}, {-29764, -13706}, {-29765, -13703}, {-29767, -13700}, {-29768, -13697}, {-29769, -13694},
    {-29771, -13691}, {-29772, -13688}, {-29773, -13686}, {-29775, -13683}, {-29776, -13680}, {-29777, -13677},
    {-29779, -13674}, {-29780, -13671}, {-29781, -13668}, {-29782, -13666}, {-29784, -13663}, {-29785, -13660},
    {-29786, -13657}, {-29788, -13654}, {-29789, -13651}, {-29790, -13648}, {-29792, -13646}, {-29793, -13643},
    {-29794, -13640}, {-29796, -13637}, {-29797, -13634}, {-29798, -13631}, {-29799, -13628}, {-29801, -13626},
    {-29802, -13623}, {-29803, -13620}, {-29805, -13617}, {-29806, -13614}, {-29807, -13611}, {-29809, -13608},
    {-29810, -13606}, {-29811, -13603}, {-29813, -13600}, {-29814, -13597}, {-29815, -13594}, {-29816, -13591},
    {-29818, -13588}, {-29819, -13586}, {-29820, -13583}, {-29822, -13580}, {-29823, -13577}, {-29824, -13574},
    {-29826, -13571}, {-29827, -13568}, {-29828, -13566}, {-29829, -13563}, {-29831, -13560}, {-29832, -13557},
    {-29833, -13554}, {-29835, -13551}, {-29836, -13548}, {-29837, -13546}, {-29839, -13543}, {-29840, -13540},
    {-29841, -13537}, {-29842, -13534}, {-29844, -13531}, {-29845, -13528}, {-29846, -13525}, {-29848, -13523},
    {-29849, -13520}, {-29850, -13517}, {-29852, -13514}, {-29853, -13511}, {-29854, -13508}, {-29855, -13505},
    {-29857, -13503}, {-29858, -13500}, {-29859, -13497}, {-29861, -13494}, {-29862, -13491}, {-29863, -13488},
    {-29864, -13485}, {-29866, -13483}, {-29867, -13480}, {-29868, -13477}, {-29870, -13474}, {-29871, -13471},
    {-29872, -13468}, {-29873, -13465}, {-29875, -13463}, {-29876, -13460}, {-29877, -13457}, {-29879, -13454},
    {-29880, -13451}, {-29881, -13448}, {-29883, -13445}, {-29884, -13442}, {-29885, -13440}, {-29886, -13437},
    {-29888, -13434}, {-29889, -13431}, {-29890, -13428}, {-29892, -13425}, {-29893, -13422}, {-29894, -13420},
    {-29895, -13417}, {-29897, -13414}, {-29898, -13411}, {-29899, -13408}, {-29901, -13405}, {-29902, -13402},
    {-29903, -13399}, {-29904, -13397}, {-29906, -13394}, {-29907, -13391}, {-29908, -13388}, {-29910, -13385},
    {-29911, -13382}, {-29912, -13379}, {-29913, -13377}, {-29915, -13374}, {-29916, -13371}, {-29917, -13368},
    {-29919, -13365}, {-29920, -13362}, {-29921, -13359}, {-29922, -13356}, {-29924, -13354}, {-29925, -13351},
    {-29926, -13348}, {-29927, -13345}, {-29929, -13342}, {-29930, -13339}, {-29931, -13336}, {-29933, -13333},
    {-29934, -13331}, {-29935, -13328}, {-29936, -13325}, {-29938, -13322}, {-29939, -13319}, {-29940, -13316},
    {-29942, -13313}, {-29943, -13311}, {-29944, -13308}, {-29945, -13305}, {-29947, -13302}, {-29948, -13299},
    {-29949, -13296}, {-29950, -13293}, {-29952, -13290}, {-29953, -13288}, {-29954, -13285}, {-29956, -13282},
    {-29957, -13279}, {-29958, -13276}, {-29959, -13273}, {-29961, -13270}, {-29962, -13267}, {-29963, -13265},
    {-29964, -13262}, {-29966, -13259}, {-29967, -13256}, {-29968, -13253}, {-29970, -13250}, {-29971, -13247},
    {-29972, -13244}, {-29973, -13242}, {-29975, -13239}, {-29976, -13236}, {-29977, -13233}, {-29978, -13230},
    {-29980, -13227}, {-29981, -13224}, {-29982, -13221}, {-29983, -13219}, {-29985, -13216}, {-29986, -13213},
    {-29987, -13210}, {-29989, -13207}, {-29990, -13204}, {-29991, -13201}, {-29992, -13198}, {-29994, -13196},
    {-29995, -13193}, {-29996, -13190}, {-29997, -13187}, {-29999, -13184}, {-30000, -13181}, {-30001, -13178},
    {-30002, -13175}, {-30004, -13173}, {-30005, -13170}, {-30006, -13167}, {-30008, -13164}, {-30009, -13161},
    {-30010, -13158}, {-30011, -13155}, {-30013, -13152}, {-30014, -13150}, {-30015, -13147}, {-30016, -13144},
    {-30018, -13141}, {-30019, -13138}, {-30020, -13135}, {-30021, -13132}, {-30023, -13129}, {-30024, -13127},
    {-30025, -13124}, {-30026, -13121}, {-30028, -13118}, {-30029, -13115}, {-30030, -13112}, {-30031, -13109},
    {-30033, -13106}, {-30034, -13104}, {-30035, -13101}, {-30036, -13098}, {-30038, -13095}, {-30039, -13092},
    {-30040, -13089}, {-30042, -13086}, {-30043, -13083}, {-30044, -13080}, {-30045, -13078}, {-30047, -13075},
    {-30048, -13072}, {-30049, -13069}, {-30050, -13066}, {-30052, -13063}, {-30053, -13060}, {-30054, -13057},
    {-30055, -13055}, {-30057, -13052}, {-30058, -13049}, {-30059, -13046}, {-30060, -13043}, {-30062, -13040},
    {-30063, -13037}, {-30064, -13034}, {-30065, -13032}, {-30067, -13029}, {-30068, -13026}, {-30069, -13023},
    {-30070, -13020}, {-30072, -13017}, {-30073, -13014}, {-30074, -13011}, {-30075, -13008}, {-30077, -13006},
    {-30078, -13003}, {-30079, -13000}, {-30080, -12997}, {-30082, -12994}, {-30083, -12991}, {-30084, -12988},
    {-30085, -12985}, {-30086, -12982}, {-30088, -12980}, {-30089, -12977}, {-30090, -12974}, {-30091, -12971},
    {-30093, -12968}, {-30094, -12965}, {-30095, -12962}, {-30096, -12959}, {-30098, -12957}, {-30099, -12954},
    {-30100, -12951}, {-30101, -12948}, {-30103, -12945}, {-30104, -12942}, {-30105, -12939}, {-30106, -12936},
    {-30108, -12933}, {-30109, -12931}, {-30110, -12928}, {-30111, -12925}, {-30113, -12922}, {-30114, -12919},
    {-30115, -12916}, {-30116, -12913}, {-30118, -12910}, {-30119, -12907}, {-30120, -12905}, {-30121, -12902},
    {-30122, -12899}, {-30124, -12896}, {-30125, -12893}, {-30126, -12890}, {-30127, -12887}, {-30129, -12884},
    {-30130, -12881}, {-30131, -12879}, {-30132, -12876}, {-30134, -12873}, {-30135, -12870}, {-30136, -12867},
    {-30137, -12864}, {-30139, -12861}, {-30140, -12858}, {-30141, -12855}, {-30142, -12853}, {-30143, -12850},
    {-30145, -12847}, {-30146, -12844}, {-30147, -12841}, {-30148, -12838}, {-30150, -12835}, {-30151, -12832},
    {-30152, -12829}, {-30153, -12827}, {-30155, -12824}, {-30156, -12821}, {-30157, -12818}, {-30158, -12815},
    {-30159, -12812}, {-30161, -12809}, {-30162, -12806}, {-30163, -12803}, {-30164, -12801}, {-30166, -12798},
    {-30167, -12795}, {-30168, -12792}, {-30169, -12789}, {-30170, -12786}, {-30172, -12783}, {-30173, -12780},
    {-30174, -12777}, {-30175, -12774}, {-30177, -12772}, {-30178, -12769}, {-30179, -12766}, {-30180, -12763},
    {-30182, -12760}, {-30183, -12757}, {-30184, -12754}, {-30185, -12751}, {-30186, -12748}, {-30188, -12746},
    {-30189, -12743}, {-30190, -12740}, {-30191, -12737}, {-30193, -12734}, {-30194, -12731}, {-30195, -12728},
    {-30196, -12725}, {-30197, -12722}, {-30199, -12720}, {-30200, -12717}, {-30201, -12714}, {-30202, -12711},
    {-30203, -12708}, {-30205, -12705}, {-30206, -12702}, {-30207, -12699}, {-30208, -12696}, {-30210, -12693},
    {-30211, -12691}, {-30212, -12688}, {-30213, -12685}, {-30214, -12682}, {-30216, -12679}, {-30217, -12676},
    {-30218, -12673}, {-30219, -12670}, {-30221, -12667}, {-30222, -12664}, {-30223, -12662}, {-30224, -12659},
    {-30225, -12656}, {-30227, -12653}, {-30228, -12650}, {-30229, -12647}, {-30230, -12644}, {-30231, -12641},
    {-30233, -12638}, {-30234, -12635}, {-30235, -12633}, {-30236, -12630}, {-30237, -12627}, {-30239, -12624},
    {-30240, -12621}, {-30241, -12618}, {-30242, -12615}, {-30244, -12612}, {-30245, -12609}, {-30246, -12606},
    {-30247, -12604}, {-30248, -12601}, {-30250, -12598}, {-30251, -12595}, {-30252, -12592}, {-30253, -12589},
    {-30254, -12586}, {-30256, -12583}, {-30257, -12580}, {-30258, -12577}, {-30259, -12575}, {-30260, -12572},
    {-30262, -12569}, {-30263, -12566}, {-30264, -12563}, {-30265, -12560}, {-30266, -12557}, {-30268, -12554},
    {-30269, -12551}, {-30270, -12548}, {-30271, -12546}, {-30272, -12543}, {-30274, -12540}, {-30275, -12537},
    {-30276, -12534}, {-30277, -12531}, {-30278, -12528}, {-30280, -12525}, {-30281, -12522}, {-30282, -12519},
    {-30283, -12517}, {-30284, -12514}, {-30286, -12511}, {-30287, -12508}, {-30288, -12505}, {-30289, -12502},
    {-30290, -12499}, {-30292, -12496}, {-30293, -12493}, {-30294, -12490}, {-30295, -12488}, {-30296, -12485},
    {-30298, -12482}, {-30299, -12479}, {-30300, -12476}, {-30301, -12473}, {-30302, -12470}, {-30304, -12467},
    {-30305, -12464}, {-30306, -12461}, {-30307, -12458}, {-30308, -12456}, {-30310, -12453}, {-30311, -12450},
    {-30312, -12447}, {-30313, -12444}, {-30314, -12441}, {-30316, -12438}, {-30317, -12435}, {-30318, -12432},
    {-30319, -12429}, {-30320, -12426}, {-30322, -12424}, {-30323, -12421}, {-30324, -12418}, {-30325, -12415},
    {-30326, -12412}, {-30328, -12409}, {-30329, -12406}, {-30330, -12403}, {-30331, -12400}, {-30332, -12397},
    {-30333, -12395}, {-30335, -12392}, {-30336, -12389}, {-30337, -12386}, {-30338, -12383}, {-30339, -12380},
    {-30341, -12377}, {-30342, -12374}, {-30343, -12371}, {-30344, -12368}, {-30345, -12365}, {-30347, -12363},
    {-30348, -12360}, {-30349, -12357}, {-30350, -12354}, {-30351, -12351}, {-30352, -12348}, {-30354, -12345},
    {-30355, -12342}, {-30356, -12339}, {-30357, -12336}, {-30358, -12333}, {-30360, -12330}, {-30361, -12328},
    {-30362, -12325}, {-30363, -12322}, {-30364, -12319}, {-30365, -12316}, {-30367, -12313}, {-30368, -12310},
    {-30369, -12307}, {-30370, -12304}, {-30371, -12301}, {-30373, -12298}, {-30374, -12296}, {-30375, -12293},
    {-30376, -12290}, {-30377, -12287}, {-30378, -12284}, {-30380, -12281}, {-30381, -12278}, {-30382, -12275},
    {-30383, -12272}, {-30384, -12269}, {-30385, -12266}, {-30387, -12264}, {-30388, -12261}, {-30389, -12258},
    {-30390, -12255}, {-30391, -12252}, {-30393, -12249}, {-30394, -12246}, {-30395, -12243}, {-30396, -12240},
    {-30397, -12237}, {-30398, -12234}, {-30400, -12231}, {-30401, -12229}, {-30402, -12226}, {-30403, -12223},
    {-30404, -12220}, {-30405, -12217}, {-30407, -12214}, {-30408, -12211}, {-30409, -12208}, {-30410, -12205},
    {-30411, -12202}, {-30412, -12199}, {-30414, -12196}, {-30415, -12194}, {-30416, -12191}, {-30417, -12188},
    {-30418, -12185}, {-30419, -12182}, {-30421, -12179}, {-30422, -12176}, {-30423, -12173}, {-30424, -12170},
    {-30425, -12167}, {-30426, -12164}, {-30428, -12161}, {-30429, -12159}, {-30430, -12156}, {-30431, -12153},
    {-30432, -12150}, {-30433, -12147}, {-30435, -12144}, {-30436, -12141}, {-30437, -12138}, {-30438, -12135},
    {-30439, -12132}, {-30440, -12129}, {-30442, -12126}, {-30443, -12124}, {-30444, -12121}, {-30445, -12118},
    {-30446, -12115}, {-30447, -12112}, {-30449, -12109}, {-30450, -12106}, {-30451, -12103}, {-30452, -12100},
    {-30453, -12097}, {-30454, -12094}, {-30456, -12091}, {-30457, -12089}, {-30458, -12086}, {-30459, -12083},
    {-30460, -12080}, {-30461, -12077}, {-30462, -12074}, {-30464, -12071}, {-30465, -12068}, {-30466, -12065},
    {-30467, -12062}, {-30468, -12059}, {-30469, -12056}, {-30471, -12053}, {-30472, -12051}, {-30473, -12048},
    {-30474, -12045}, {-30475, -12042}, {-30476, -12039}, {-30477, -12036}, {-30479, -12033}, {-30480, -12030},
    {-30481, -12027}, {-30482, -12024}, {-30483, -12021}, {-30484, -12018}, {-30486, -12015}, {-30487, -12013},
    {-30488, -12010}, {-30489, -12007}, {-30490, -12004}, {-30491, -12001}, {-30492, -11998}, {-30494, -11995},
    {-30495, -11992}, {-30496, -11989}, {-30497, -11986}, {-30498, -11983}, {-30499, -11980}, {-30501, -11977},
    {-30502, -11975}, {-30503, -11972}, {-30504, -11969}, {-30505, -11966}, {-30506, -11963}, {-30507, -11960},
    {-30509, -11957}, {-30510, -11954}, {-30511, -11951}, {-30512, -11948}, {-30513, -11945}, {-30514, -11942},
    {-30515, -11939}, {-30517, -11937}, {-30518, -11934}, {-30519, -11931}, {-30520, -11928}, {-30521, -11925},
    {-30522, -11922}, {-30523, -11919}, {-30525, -11916}, {-30526, -11913}, {-30527, -11910}, {-30528, -11907},
    {-30529, -11904}, {-30530, -11901}, {-30531, -11898}, {-30533, -11896}, {-30534, -11893}, {-30535, -11890},
    {-30536, -11887}, {-30537, -11884}, {-30538, -11881}, {-30539, -11878}, {-30541, -11875}, {-30542, -11872},
    {-30543, -11869}, {-30544, -11866}, {-30545, -11863}, {-30546, -11860}, {-30547, -11857}, {-30549, -11855},
    {-30550, -11852}, {-30551, -11849}, {-30552, -11846}, {-30553, -11843}, {-30554, -11840}, {-30555, -11837},
    {-30556, -11834}, {-30558, -11831}, {-30559, -11828}, {-30560, -11825}, {-30561, -11822}, {-30562, -11819},
    {-30563, -11816}, {-30564, -11814}, {-30566, -11811}, {-30567, -11808}, {-30568, -11805}, {-30569, -11802},
    {-30570, -11799}, {-30571, -11796}, {-30572, -11793}, {-30573, -11790}, {-30575, -11787}, {-30576, -11784},
    {-30577, -11781}, {-30578, -11778}, {-30579, -11775}, {-30580, -11773}, {-30581, -11770}, {-30582, -11767},
    {-30584, -11764}, {-30585, -11761}, {-30586, -11758}, {-30587, -11755}, {-30588, -11752}, {-30589, -11749},
    {-30590, -11746}, {-30591, -11743}, {-30593, -11740}, {-30594, -11737}, {-30595, -11734}, {-30596, -11731},
    {-30597, -11729}, {-30598, -11726}, {-30599, -11723}, {-30600, -11720}, {-30602, -11717}, {-30603, -11714},
    {-30604, -11711}, {-30605, -11708}, {-30606, -11705}, {-30607, -11702}, {-30608, -11699}, {-30609, -11696},
    {-30611, -11693}, {-30612, -11690}, {-30613, -11687}, {-30614, -11685}, {-30615, -11682}, {-30616, -11679},
    {-30617, -11676}, {-30618, -11673}, {-30620, -11670}, {-30621, -11667}, {-30622, -11664}, {-30623, -11661},
    {-30624, -11658}, {-30625, -11655}, {-30626, -11652}, {-30627, -11649}, {-30628, -11646}, {-30630, -11643},
    {-30631, -11640}, {-30632, -11638}, {-30633, -11635}, {-30634, -11632}, {-30635, -11629}, {-30636, -11626},
    {-30637, -11623}, {-30639, -11620}, {-30640, -11617}, {-30641, -11614}, {-30642, -11611}, {-30643, -11608},
    {-30644, -11605}, {-30645, -11602}, {-30646, -11599}, {-30647, -11596}, {-30649, -11593}, {-30650, -11591},
    {-30651, -11588}, {-30652, -11585}, {-30653, -11582}, {-30654, -11579}, {-30655, -11576}, {-30656, -11573},
    {-30657, -11570}, {-30659, -11567}, {-30660, -11564}, {-30661, -11561}, {-30662, -11558}, {-30663, -11555},
    {-30664, -11552}, {-30665, -11549}, {-30666, -11546}, {-30667, -11544}, {-30669, -11541}, {-30670, -11538},
    {-30671, -11535}, {-30672, -11532}, {-30673, -11529}, {-30674, -11526}, {-30675, -11523}, {-30676, -11520},
    {-30677, -11517}, {-30678, -11514}, {-30680, -11511}, {-30681, -11508}, {-30682, -11505}, {-30683, -11502},
    {-30684, -11499}, {-30685, -11496}, {-30686, -11494}, {-30687, -11491}, {-30688, -11488}, {-30689, -11485},
    {-30691, -11482}, {-30692, -11479}, {-30693, -11476}, {-30694, -11473}, {-30695, -11470}, {-30696, -11467},
    {-30697, -11464}, {-30698, -11461}, {-30699, -11458}, {-30700, -11455}, {-30702, -11452}, {-30703, -11449},
    {-30704, -11446}, {-30705, -11443}, {-30706, -11441}, {-30707, -11438}, {-30708, -11435}, {-30709, -11432},
    {-30710, -11429}, {-30711, -11426}, {-30713, -11423}, {-30714, -11420}, {-30715, -11417}, {-30716, -11414},
    {-30717, -11411}, {-30718, -11408}, {-30719, -11405}, {-30720, -11402}, {-30721, -11399}, {-30722, -11396},
    {-30723, -11393}, {-30725, -11390}, {-30726, -11388}, {-30727, -11385}, {-30728, -11382}, {-30729, -11379},
    {-30730, -11376}, {-30731, -11373}, {-30732, -11370}, {-30733, -11367}, {-30734, -11364}, {-30735, -11361},
    {-30737, -11358}, {-30738, -11355}, {-30739, -11352}, {-30740, -11349}, {-30741, -11346}, {-30742, -11343},
    {-30743, -11340}, {-30744, -11337}, {-30745, -11334}, {-30746, -11332}, {-30747, -11329}, {-30749, -11326},
    {-30750, -11323}, {-30751, -11320}, {-30752, -11317}, {-30753, -11314}, {-30754, -11311}, {-30755, -11308},
    {-30756, -11305}, {-30757, -11302}, {-30758, -11299}, {-30759, -11296}, {-30760, -11293}, {-30762, -11290},
    {-30763, -11287}, {-30764, -11284}, {-30765, -11281}, {-30766, -11278}, {-30767, -11276}, {-30768, -11273},
    {-30769, -11270}, {-30770, -11267}, {-30771, -11264}, {-30772, -11261}, {-30773, -11258}, {-30774, -11255},
    {-30776, -11252}, {-30777, -11249}, {-30778, -11246}, {-30779, -11243}, {-30780, -11240}, {-30781, -11237},
    {-30782, -11234}, {-30783, -11231}, {-30784, -11228}, {-30785, -11225}, {-30786, -11222}, {-30787, -11219},
    {-30789, -11216}, {-30790, -11214}, {-30791, -11211}, {-30792, -11208}, {-30793, -11205}, {-30794, -11202},
    {-30795, -11199}, {-30796, -11196}, {-30797, -11193}, {-30798, -11190}, {-30799, -11187}, {-30800, -11184},
    {-30801, -11181}, {-30802, -11178}, {-30804, -11175}, {-30805, -11172}, {-30806, -11169}, {-30807, -11166},
    {-30808, -11163}, {-30809, -11160}, {-30810, -11157}, {-30811, -11154}, {-30812, -11152}, {-30813, -11149},
    {-30814, -11146}, {-30815, -11143}, {-30816, -11140}, {-30817, -11137}, {-30819, -11134}, {-30820, -11131},
    {-30821, -11128}, {-30822, -11125}, {-30823, -11122}, {-30824, -11119}, {-30825, -11116}, {-30826, -11113},
    {-30827, -11110}, {-30828, -11107}, {-30829, -11104}, {-30830, -11101}, {-30831, -11098}, {-30832, -11095},
    {-30833, -11092}, {-30834, -11089}, {-30836, -11087}, {-30837, -11084}, {-30838, -11081}, {-30839, -11078},
    {-30840, -11075}, {-30841, -11072}, {-30842, -11069}, {-30843, -11066}, {-30844, -11063}, {-30845, -11060},
    {-30846, -11057}, {-30847, -11054}, {-30848, -11051}, {-30849, -11048}, {-30850, -11045}, {-30851, -11042},
    {-30853, -11039}, {-30854, -11036}, {-30855, -11033}, {-30856, -11030}, {-30857, -11027}, {-30858, -11024},
    {-30859, -11021}, {-30860, -11018}, {-30861, -11016}, {-30862, -11013}, {-30863, -11010}, {-30864, -11007},
    {-30865, -11004}, {-30866, -11001}, {-30867, -10998}, {-30868, -10995}, {-30869, -10992}, {-30870, -10989},
    {-30872, -10986}, {-30873, -10983}, {-30874, -10980}, {-30875, -10977}, {-30876, -10974}, {-30877, -10971},
    {-30878, -10968}, {-30879, -10965}, {-30880, -10962}, {-30881, -10959}, {-30882, -10956}, {-30883, -10953},
    {-30884, -10950}, {-30885, -10947}, {-30886, -10945}, {-30887, -10942}, {-30888, -10939}, {-30889, -10936},
    {-30890, -10933}, {-30891, -10930}, {-30893, -10927}, {-30894, -10924}, {-30895, -10921}, {-30896, -10918},
    {-30897, -10915}, {-30898, -10912}, {-30899, -10909}, {-30900, -10906}, {-30901, -10903}, {-30902, -10900},
    {-30903, -10897}, {-30904, -10894}, {-30905, -10891}, {-30906, -10888}, {-30907, -10885}, {-30908, -10882},
    {-30909, -10879}, {-30910, -10876}, {-30911, -10873}, {-30912, -10870}, {-30913, -10867}, {-30914, -10865},
    {-30916, -10862}, {-30917, -10859}, {-30918, -10856}, {-30919, -10853}, {-30920, -10850}, {-30921, -10847},
    {-30922, -10844}, {-30923, -10841}, {-30924, -10838}, {-30925, -10835}, {-30926, -10832}, {-30927, -10829},
    {-30928, -10826}, {-30929, -10823}, {-30930, -10820}, {-30931, -10817}, {-30932, -10814}, {-30933, -10811},
    {-30934, -10808}, {-30935, -10805}, {-30936, -10802}, {-30937, -10799}, {-30938, -10796}, {-30939, -10793},
    {-30940, -10790}, {-30941, -10787}, {-30942, -10784}, {-30944, -10781}, {-30945, -10779}, {-30946, -10776},
    {-30947, -10773}, {-30948, -10770}, {-30949, -10767}, {-30950, -10764}, {-30951, -10761}, {-30952, -10758},
    {-30953, -10755}, {-30954, -10752}, {-30955, -10749}, {-30956, -10746}, {-30957, -10743}, {-30958, -10740},
    {-30959, -10737}, {-30960, -10734}, {-30961, -10731}, {-30962, -10728}, {-30963, -10725}, {-30964, -10722},
    {-30965, -10719}, {-30966, -10716}, {-30967, -10713}, {-30968, -10710}, {-30969, -10707}, {-30970, -10704},
    {-30971, -10701}, {-30972, -10698}, {-30973, -10695}, {-30974, -10692}, {-30975, -10689}, {-30976, -10687},
    {-30977, -10684}, {-30978, -10681}, {-30980, -10678}, {-30981, -10675}, {-30982, -10672}, {-30983, -10669},
    {-30984, -10666}, {-30985, -10663}, {-30986, -10660}, {-30987, -10657}, {-30988, -10654}, {-30989, -10651},
    {-30990, -10648}, {-30991, -10645}, {-30992, -10642}, {-30993, -10639}, {-30994, -10636}, {-30995, -10633},
    {-30996, -10630}, {-30997, -10627}, {-30998, -10624}, {-30999, -10621}, {-31000, -10618}, {-31001, -10615},
    {-31002, -10612}, {-31003, -10609}, {-31004, -10606}, {-31005, -10603}, {-31006, -10600}, {-31007, -10597},
    {-31008, -10594}, {-31009, -10591}, {-31010, -10588}, {-31011, -10585}, {-31012, -10582}, {-31013, -10580},
    {-31014, -10577}, {-31015, -10574}, {-31016, -10571}, {-31017, -10568}, {-31018, -10565}, {-31019, -10562},
    {-31020, -10559}, {-31021, -10556}, {-31022, -10553}, {-31023, -10550}, {-31024, -10547}, {-31025, -10544},
    {-31026, -10541}, {-31027, -10538}, {-31028, -10535}, {-31029, -10532}, {-31030, -10529}, {-31031, -10526},
    {-31032, -10523}, {-31033, -10520}, {-31034, -10517}, {-31035, -10514}, {-31036, -10511}, {-31037, -10508},
    {-31038, -10505}, {-31039, -10502}, {-31040, -10499}, {-31041, -10496}, {-31042, -10493}, {-31043, -10490},
    {-31044, -10487}, {-31045, -10484}, {-31046, -10481}, {-31047, -10478}, {-31048, -10475}, {-31049, -10472},
    {-31050, -10469}, {-31051, -10466}, {-31052, -10463}, {-31053, -10461}, {-31054, -10458}, {-31055, -10455},
    {-31057, -10452}, {-31058, -10449}, {-31059, -10446}, {-31060, -10443}, {-31061, -10440}, {-31062, -10437},
    {-31063, -10434}, {-31064, -10431}, {-31065, -10428}, {-31066, -10425}, {-31067, -10422}, {-31068, -10419},
    {-31069, -10416}, {-31070, -10413}, {-31071, -10410}, {-31072, -10407}, {-31072, -10404}, {-31073, -10401},
    {-31074, -10398}, {-31075, -10395}, {-31076, -10392}, {-31077, -10389}, {-31078, -10386}, {-31079, -10383},
    {-31080, -10380}, {-31081, -10377}, {-31082, -10374}, {-31083, -10371}, {-31084, -10368}, {-31085, -10365},
    {-31086, -10362}, {-31087, -10359}, {-31088, -10356}, {-31089, -10353}, {-31090, -10350}, {-31091, -10347},
    {-31092, -10344}, {-31093, -10341}, {-31094, -10338}, {-31095, -10335}, {-31096, -10332}, {-31097, -10329},
    {-31098, -10326}, {-31099, -10323}, {-31100, -10320}, {-31101, -10317}, {-31102, -10315}, {-31103, -10312},
    {-31104, -10309}, {-31105, -10306}, {-31106, -10303}, {-31107, -10300}, {-31108, -10297}, {-31109, -10294},
    {-31110, -10291}, {-31111, -10288}, {-31112, -10285}, {-31113, -10282}, {-31114, -10279}, {-31115, -10276},
    {-31116, -10273}, {-31117, -10270}, {-31118, -10267}, {-31119, -10264}, {-31120, -10261}, {-31121, -10258},
    {-31122, -10255}, {-31123, -10252}, {-31124, -10249}, {-31125, -10246}, {-31126, -10243}, {-31127, -10240},
    {-31128, -10237}, {-31129, -10234}, {-31130, -10231}, {-31131, -10228}, {-31132, -10225}, {-31133, -10222},
    {-31134, -10219}, {-31135, -10216}, {-31136, -10213}, {-31137, -10210}, {-31138, -10207}, {-31139, -10204},
    {-31140, -10201}, {-31141, -10198}, {-31142, -10195}, {-31143, -10192}, {-31144, -10189}, {-31145, -10186},
    {-31146, -10183}, {-31147, -10180}, {-31147, -10177}, {-31148, -10174}, {-31149, -10171}, {-31150, -10168},
    {-31151, -10165}, {-31152, -10162}, {-31153, -10159}, {-31154, -10156}, {-31155, -10153}, {-31156, -10150},
    {-31157, -10147}, {-31158, -10144}, {-31159, -10141}, {-31160, -10138}, {-31161, -10135}, {-31162, -10132},
    {-31163, -10129}, {-31164, -10126}, {-31165, -10123}, {-31166, -10120}, {-31167, -10118}, {-31168, -10115},
    {-31169, -10112}, {-31170, -10109}, {-31171, -10106}, {-31172, -10103}, {-31173, -10100}, {-31174, -10097},
    {-31175, -10094}, {-31176, -10091}, {-31177, -10088}, {-31178, -10085}, {-31179, -10082}, {-31180, -10079},
    {-31180, -10076}, {-31181, -10073}, {-31182, -10070}, {-31183, -10067}, {-31184, -10064}, {-31185, -10061},
    {-31186, -10058}, {-31187, -10055}, {-31188, -10052}, {-31189, -10049}, {-31190, -10046}, {-31191, -10043},
    {-31192, -10040}, {-31193, -10037}, {-31194, -10034}, {-31195, -10031}, {-31196, -10028}, {-31197, -10025},
    {-31198, -10022}, {-31199, -10019}, {-31200, -10016}, {-31201, -10013}, {-31202, -10010}, {-31203, -10007},
    {-31204, -10004}, {-31205, -10001}, {-31206, -9998},  {-31206, -9995},  {-31207, -9992},  {-31208, -9989},
    {-31209, -9986},  {-31210, -9983},  {-31211, -9980},  {-31212, -9977},  {-31213, -9974},  {-31214, -9971},
    {-31215, -9968},  {-31216, -9965},  {-31217, -9962},  {-31218, -9959},  {-31219, -9956},  {-31220, -9953},
    {-31221, -9950},  {-31222, -9947},  {-31223, -9944},  {-31224, -9941},  {-31225, -9938},  {-31226, -9935},
    {-31227, -9932},  {-31227, -9929},  {-31228, -9926},  {-31229, -9923},  {-31230, -9920},  {-31231, -9917},
    {-31232, -9914},  {-31233, -9911},  {-31234, -9908},  {-31235, -9905},  {-31236, -9902},  {-31237, -9899},
    {-31238, -9896},  {-31239, -9893},  {-31240, -9890},  {-31241, -9887},  {-31242, -9884},  {-31243, -9881},
    {-31244, -9878},  {-31245, -9875},  {-31246, -9872},  {-31246, -9869},  {-31247, -9866},  {-31248, -9863},
    {-31249, -9860},  {-31250, -9857},  {-31251, -9854},  {-31252, -9851},  {-31253, -9848},  {-31254, -9845},
    {-31255, -9842},  {-31256, -9839},  {-31257, -9836},  {-31258, -9833},  {-31259, -9830},  {-31260, -9827},
    {-31261, -9824},  {-31262, -9821},  {-31263, -9818},  {-31263, -9815},  {-31264, -9812},  {-31265, -9809},
    {-31266, -9806},  {-31267, -9803},  {-31268, -9800},  {-31269, -9797},  {-31270, -9794},  {-31271, -9791},
    {-31272, -9788},  {-31273, -9785},  {-31274, -9782},  {-31275, -9779},  {-31276, -9776},  {-31277, -9773},
    {-31278, -9770},  {-31278, -9767},  {-31279, -9764},  {-31280, -9761},  {-31281, -9758},  {-31282, -9755},
    {-31283, -9752},  {-31284, -9749},  {-31285, -9746},  {-31286, -9743},  {-31287, -9740},  {-31288, -9737},
    {-31289, -9734},  {-31290, -9731},  {-31291, -9728},  {-31292, -9725},  {-31292, -9722},  {-31293, -9719},
    {-31294, -9716},  {-31295, -9713},  {-31296, -9710},  {-31297, -9707},  {-31298, -9704},  {-31299, -9701},
    {-31300, -9698},  {-31301, -9695},  {-31302, -9692},  {-31303, -9689},  {-31304, -9686},  {-31305, -9683},
    {-31305, -9680},  {-31306, -9677},  {-31307, -9674},  {-31308, -9671},  {-31309, -9668},  {-31310, -9665},
    {-31311, -9662},  {-31312, -9659},  {-31313, -9656},  {-31314, -9653},  {-31315, -9650},  {-31316, -9647},
    {-31317, -9644},  {-31318, -9641},  {-31318, -9638},  {-31319, -9635},  {-31320, -9632},  {-31321, -9629},
    {-31322, -9626},  {-31323, -9623},  {-31324, -9620},  {-31325, -9617},  {-31326, -9614},  {-31327, -9611},
    {-31328, -9608},  {-31329, -9605},  {-31330, -9602},  {-31330, -9599},  {-31331, -9596},  {-31332, -9593},
    {-31333, -9590},  {-31334, -9587},  {-31335, -9584},  {-31336, -9581},  {-31337, -9578},  {-31338, -9575},
    {-31339, -9572},  {-31340, -9569},  {-31341, -9566},  {-31341, -9563},  {-31342, -9560},  {-31343, -9557},
    {-31344, -9554},  {-31345, -9551},  {-31346, -9548},  {-31347, -9545},  {-31348, -9542},  {-31349, -9539},
    {-31350, -9536},  {-31351, -9533},  {-31352, -9530},  {-31352, -9527},  {-31353, -9524},  {-31354, -9521},
    {-31355, -9518},  {-31356, -9515},  {-31357, -9512},  {-31358, -9509},  {-31359, -9506},  {-31360, -9503},
    {-31361, -9500},  {-31362, -9497},  {-31362, -9494},  {-31363, -9491},  {-31364, -9488},  {-31365, -9485},
    {-31366, -9482},  {-31367, -9479},  {-31368, -9476},  {-31369, -9473},  {-31370, -9470},  {-31371, -9467},
    {-31372, -9464},  {-31372, -9461},  {-31373, -9458},  {-31374, -9455},  {-31375, -9452},  {-31376, -9449},
    {-31377, -9446},  {-31378, -9443},  {-31379, -9440},  {-31380, -9437},  {-31381, -9434},  {-31382, -9431},
    {-31382, -9428},  {-31383, -9425},  {-31384, -9422},  {-31385, -9419},  {-31386, -9416},  {-31387, -9413},
    {-31388, -9410},  {-31389, -9407},  {-31390, -9404},  {-31391, -9401},  {-31391, -9398},  {-31392, -9395},
    {-31393, -9392},  {-31394, -9389},  {-31395, -9386},  {-31396, -9383},  {-31397, -9380},  {-31398, -9377},
    {-31399, -9374},  {-31400, -9371},  {-31400, -9368},  {-31401, -9365},  {-31402, -9362},  {-31403, -9359},
    {-31404, -9356},  {-31405, -9353},  {-31406, -9350},  {-31407, -9347},  {-31408, -9344},  {-31409, -9341},
    {-31409, -9338},  {-31410, -9335},  {-31411, -9332},  {-31412, -9329},  {-31413, -9325},  {-31414, -9322},
    {-31415, -9319},  {-31416, -9316},  {-31417, -9313},  {-31417, -9310},  {-31418, -9307},  {-31419, -9304},
    {-31420, -9301},  {-31421, -9298},  {-31422, -9295},  {-31423, -9292},  {-31424, -9289},  {-31425, -9286},
    {-31425, -9283},  {-31426, -9280},  {-31427, -9277},  {-31428, -9274},  {-31429, -9271},  {-31430, -9268},
    {-31431, -9265},  {-31432, -9262},  {-31433, -9259},  {-31433, -9256},  {-31434, -9253},  {-31435, -9250},
    {-31436, -9247},  {-31437, -9244},  {-31438, -9241},  {-31439, -9238},  {-31440, -9235},  {-31441, -9232},
    {-31441, -9229},  {-31442, -9226},  {-31443, -9223},  {-31444, -9220},  {-31445, -9217},  {-31446, -9214},
    {-31447, -9211},  {-31448, -9208},  {-31449, -9205},  {-31449, -9202},  {-31450, -9199},  {-31451, -9196},
    {-31452, -9193},  {-31453, -9190},  {-31454, -9187},  {-31455, -9184},  {-31456, -9181},  {-31456, -9178},
    {-31457, -9175},  {-31458, -9172},  {-31459, -9169},  {-31460, -9166},  {-31461, -9163},  {-31462, -9160},
    {-31463, -9157},  {-31464, -9154},  {-31464, -9151},  {-31465, -9148},  {-31466, -9145},  {-31467, -9142},
    {-31468, -9139},  {-31469, -9136},  {-31470, -9133},  {-31471, -9130},  {-31471, -9127},  {-31472, -9124},
    {-31473, -9120},  {-31474, -9117},  {-31475, -9114},  {-31476, -9111},  {-31477, -9108},  {-31478, -9105},
    {-31478, -9102},  {-31479, -9099},  {-31480, -9096},  {-31481, -9093},  {-31482, -9090},  {-31483, -9087},
    {-31484, -9084},  {-31484, -9081},  {-31485, -9078},  {-31486, -9075},  {-31487, -9072},  {-31488, -9069},
    {-31489, -9066},  {-31490, -9063},  {-31491, -9060},  {-31491, -9057},  {-31492, -9054},  {-31493, -9051},
    {-31494, -9048},  {-31495, -9045},  {-31496, -9042},  {-31497, -9039},  {-31498, -9036},  {-31498, -9033},
    {-31499, -9030},  {-31500, -9027},  {-31501, -9024},  {-31502, -9021},  {-31503, -9018},  {-31504, -9015},
    {-31504, -9012},  {-31505, -9009},  {-31506, -9006},  {-31507, -9003},  {-31508, -9000},  {-31509, -8997},
    {-31510, -8994},  {-31510, -8991},  {-31511, -8988},  {-31512, -8985},  {-31513, -8982},  {-31514, -8979},
    {-31515, -8976},  {-31516, -8973},  {-31516, -8970},  {-31517, -8967},  {-31518, -8963},  {-31519, -8960},
    {-31520, -8957},  {-31521, -8954},  {-31522, -8951},  {-31523, -8948},  {-31523, -8945},  {-31524, -8942},
    {-31525, -8939},  {-31526, -8936},  {-31527, -8933},  {-31528, -8930},  {-31529, -8927},  {-31529, -8924},
    {-31530, -8921},  {-31531, -8918},  {-31532, -8915},  {-31533, -8912},  {-31534, -8909},  {-31534, -8906},
    {-31535, -8903},  {-31536, -8900},  {-31537, -8897},  {-31538, -8894},  {-31539, -8891},  {-31540, -8888},
    {-31540, -8885},  {-31541, -8882},  {-31542, -8879},  {-31543, -8876},  {-31544, -8873},  {-31545, -8870},
    {-31546, -8867},  {-31546, -8864},  {-31547, -8861},  {-31548, -8858},  {-31549, -8855},  {-31550, -8852},
    {-31551, -8849},  {-31552, -8846},  {-31552, -8843},  {-31553, -8840},  {-31554, -8836},  {-31555, -8833},
    {-31556, -8830},  {-31557, -8827},  {-31557, -8824},  {-31558, -8821},  {-31559, -8818},  {-31560, -8815},
    {-31561, -8812},  {-31562, -8809},  {-31563, -8806},  {-31563, -8803},  {-31564, -8800},  {-31565, -8797},
    {-31566, -8794},  {-31567, -8791},  {-31568, -8788},  {-31568, -8785},  {-31569, -8782},  {-31570, -8779},
    {-31571, -8776},  {-31572, -8773},  {-31573, -8770},  {-31573, -8767},  {-31574, -8764},  {-31575, -8761},
    {-31576, -8758},  {-31577, -8755},  {-31578, -8752},  {-31578, -8749},  {-31579, -8746},  {-31580, -8743},
    {-31581, -8740},  {-31582, -8737},  {-31583, -8734},  {-31584, -8731},  {-31584, -8728},  {-31585, -8725},
    {-31586, -8721},  {-31587, -8718},  {-31588, -8715},  {-31589, -8712},  {-31589, -8709},  {-31590, -8706},
    {-31591, -8703},  {-31592, -8700},  {-31593, -8697},  {-31594, -8694},  {-31594, -8691},  {-31595, -8688},
    {-31596, -8685},  {-31597, -8682},  {-31598, -8679},  {-31599, -8676},  {-31599, -8673},  {-31600, -8670},
    {-31601, -8667},  {-31602, -8664},  {-31603, -8661},  {-31604, -8658},  {-31604, -8655},  {-31605, -8652},
    {-31606, -8649},  {-31607, -8646},  {-31608, -8643},  {-31609, -8640},  {-31609, -8637},  {-31610, -8634},
    {-31611, -8631},  {-31612, -8628},  {-31613, -8625},  {-31613, -8621},  {-31614, -8618},  {-31615, -8615},
    {-31616, -8612},  {-31617, -8609},  {-31618, -8606},  {-31618, -8603},  {-31619, -8600},  {-31620, -8597},
    {-31621, -8594},  {-31622, -8591},  {-31623, -8588},  {-31623, -8585},  {-31624, -8582},  {-31625, -8579},
    {-31626, -8576},  {-31627, -8573},  {-31627, -8570},  {-31628, -8567},  {-31629, -8564},  {-31630, -8561},
    {-31631, -8558},  {-31632, -8555},  {-31632, -8552},  {-31633, -8549},  {-31634, -8546},  {-31635, -8543},
    {-31636, -8540},  {-31637, -8537},  {-31637, -8534},  {-31638, -8531},  {-31639, -8528},  {-31640, -8524},
    {-31641, -8521},  {-31641, -8518},  {-31642, -8515},  {-31643, -8512},  {-31644, -8509},  {-31645, -8506},
    {-31645, -8503},  {-31646, -8500},  {-31647, -8497},  {-31648, -8494},  {-31649, -8491},  {-31650, -8488},
    {-31650, -8485},  {-31651, -8482},  {-31652, -8479},  {-31653, -8476},  {-31654, -8473},  {-31654, -8470},
    {-31655, -8467},  {-31656, -8464},  {-31657, -8461},  {-31658, -8458},  {-31658, -8455},  {-31659, -8452},
    {-31660, -8449},  {-31661, -8446},  {-31662, -8443},  {-31663, -8440},  {-31663, -8436},  {-31664, -8433},
    {-31665, -8430},  {-31666, -8427},  {-31667, -8424},  {-31667, -8421},  {-31668, -8418},  {-31669, -8415},
    {-31670, -8412},  {-31671, -8409},  {-31671, -8406},  {-31672, -8403},  {-31673, -8400},  {-31674, -8397},
    {-31675, -8394},  {-31675, -8391},  {-31676, -8388},  {-31677, -8385},  {-31678, -8382},  {-31679, -8379},
    {-31679, -8376},  {-31680, -8373},  {-31681, -8370},  {-31682, -8367},  {-31683, -8364},  {-31683, -8361},
    {-31684, -8358},  {-31685, -8354},  {-31686, -8351},  {-31687, -8348},  {-31687, -8345},  {-31688, -8342},
    {-31689, -8339},  {-31690, -8336},  {-31691, -8333},  {-31691, -8330},  {-31692, -8327},  {-31693, -8324},
    {-31694, -8321},  {-31695, -8318},  {-31695, -8315},  {-31696, -8312},  {-31697, -8309},  {-31698, -8306},
    {-31699, -8303},  {-31699, -8300},  {-31700, -8297},  {-31701, -8294},  {-31702, -8291},  {-31703, -8288},
    {-31703, -8285},  {-31704, -8282},  {-31705, -8279},  {-31706, -8275},  {-31707, -8272},  {-31707, -8269},
    {-31708, -8266},  {-31709, -8263},  {-31710, -8260},  {-31711, -8257},  {-31711, -8254},  {-31712, -8251},
    {-31713, -8248},  {-31714, -8245},  {-31715, -8242},  {-31715, -8239},  {-31716, -8236},  {-31717, -8233},
    {-31718, -8230},  {-31718, -8227},  {-31719, -8224},  {-31720, -8221},  {-31721, -8218},  {-31722, -8215},
    {-31722, -8212},  {-31723, -8209},  {-31724, -8206},  {-31725, -8202},  {-31726, -8199},  {-31726, -8196},
    {-31727, -8193},  {-31728, -8190},  {-31729, -8187},  {-31729, -8184},  {-31730, -8181},  {-31731, -8178},
    {-31732, -8175},  {-31733, -8172},  {-31733, -8169},  {-31734, -8166},  {-31735, -8163},  {-31736, -8160},
    {-31737, -8157},  {-31737, -8154},  {-31738, -8151},  {-31739, -8148},  {-31740, -8145},  {-31740, -8142},
    {-31741, -8139},  {-31742, -8136},  {-31743, -8133},  {-31744, -8129},  {-31744, -8126},  {-31745, -8123},
    {-31746, -8120},  {-31747, -8117},  {-31747, -8114},  {-31748, -8111},  {-31749, -8108},  {-31750, -8105},
    {-31751, -8102},  {-31751, -8099},  {-31752, -8096},  {-31753, -8093},  {-31754, -8090},  {-31754, -8087},
    {-31755, -8084},  {-31756, -8081},  {-31757, -8078},  {-31758, -8075},  {-31758, -8072},  {-31759, -8069},
    {-31760, -8066},  {-31761, -8063},  {-31761, -8059},  {-31762, -8056},  {-31763, -8053},  {-31764, -8050},
    {-31764, -8047},  {-31765, -8044},  {-31766, -8041},  {-31767, -8038},  {-31768, -8035},  {-31768, -8032},
    {-31769, -8029},  {-31770, -8026},  {-31771, -8023},  {-31771, -8020},  {-31772, -8017},  {-31773, -8014},
    {-31774, -8011},  {-31775, -8008},  {-31775, -8005},  {-31776, -8002},  {-31777, -7999},  {-31778, -7995},
    {-31778, -7992},  {-31779, -7989},  {-31780, -7986},  {-31781, -7983},  {-31781, -7980},  {-31782, -7977},
    {-31783, -7974},  {-31784, -7971},  {-31784, -7968},  {-31785, -7965},  {-31786, -7962},  {-31787, -7959},
    {-31788, -7956},  {-31788, -7953},  {-31789, -7950},  {-31790, -7947},  {-31791, -7944},  {-31791, -7941},
    {-31792, -7938},  {-31793, -7935},  {-31794, -7931},  {-31794, -7928},  {-31795, -7925},  {-31796, -7922},
    {-31797, -7919},  {-31797, -7916},  {-31798, -7913},  {-31799, -7910},  {-31800, -7907},  {-31800, -7904},
    {-31801, -7901},  {-31802, -7898},  {-31803, -7895},  {-31803, -7892},  {-31804, -7889},  {-31805, -7886},
    {-31806, -7883},  {-31806, -7880},  {-31807, -7877},  {-31808, -7874},  {-31809, -7871},  {-31810, -7867},
    {-31810, -7864},  {-31811, -7861},  {-31812, -7858},  {-31813, -7855},  {-31813, -7852},  {-31814, -7849},
    {-31815, -7846},  {-31816, -7843},  {-31816, -7840},  {-31817, -7837},  {-31818, -7834},  {-31819, -7831},
    {-31819, -7828},  {-31820, -7825},  {-31821, -7822},  {-31822, -7819},  {-31822, -7816},  {-31823, -7813},
    {-31824, -7810},  {-31825, -7806},  {-31825, -7803},  {-31826, -7800},  {-31827, -7797},  {-31828, -7794},
    {-31828, -7791},  {-31829, -7788},  {-31830, -7785},  {-31831, -7782},  {-31831, -7779},  {-31832, -7776},
    {-31833, -7773},  {-31833, -7770},  {-31834, -7767},  {-31835, -7764},  {-31836, -7761},  {-31836, -7758},
    {-31837, -7755},  {-31838, -7752},  {-31839, -7748},  {-31839, -7745},  {-31840, -7742},  {-31841, -7739},
    {-31842, -7736},  {-31842, -7733},  {-31843, -7730},  {-31844, -7727},  {-31845, -7724},  {-31845, -7721},
    {-31846, -7718},  {-31847, -7715},  {-31848, -7712},  {-31848, -7709},  {-31849, -7706},  {-31850, -7703},
    {-31851, -7700},  {-31851, -7697},  {-31852, -7694},  {-31853, -7690},  {-31854, -7687},  {-31854, -7684},
    {-31855, -7681},  {-31856, -7678},  {-31856, -7675},  {-31857, -7672},  {-31858, -7669},  {-31859, -7666},
    {-31859, -7663},  {-31860, -7660},  {-31861, -7657},  {-31862, -7654},  {-31862, -7651},  {-31863, -7648},
    {-31864, -7645},  {-31865, -7642},  {-31865, -7639},  {-31866, -7635},  {-31867, -7632},  {-31867, -7629},
    {-31868, -7626},  {-31869, -7623},  {-31870, -7620},  {-31870, -7617},  {-31871, -7614},  {-31872, -7611},
    {-31873, -7608},  {-31873, -7605},  {-31874, -7602},  {-31875, -7599},  {-31875, -7596},  {-31876, -7593},
    {-31877, -7590},  {-31878, -7587},  {-31878, -7584},  {-31879, -7580},  {-31880, -7577},  {-31881, -7574},
    {-31881, -7571},  {-31882, -7568},  {-31883, -7565},  {-31883, -7562},  {-31884, -7559},  {-31885, -7556},
    {-31886, -7553},  {-31886, -7550},  {-31887, -7547},  {-31888, -7544},  {-31889, -7541},  {-31889, -7538},
    {-31890, -7535},  {-31891, -7532},  {-31891, -7529},  {-31892, -7525},  {-31893, -7522},  {-31894, -7519},
    {-31894, -7516},  {-31895, -7513},  {-31896, -7510},  {-31896, -7507},  {-31897, -7504},  {-31898, -7501},
    {-31899, -7498},  {-31899, -7495},  {-31900, -7492},  {-31901, -7489},  {-31902, -7486},  {-31902, -7483},
    {-31903, -7480},  {-31904, -7477},  {-31904, -7473},  {-31905, -7470},  {-31906, -7467},  {-31907, -7464},
    {-31907, -7461},  {-31908, -7458},  {-31909, -7455},  {-31909, -7452},  {-31910, -7449},  {-31911, -7446},
    {-31912, -7443},  {-31912, -7440},  {-31913, -7437},  {-31914, -7434},  {-31914, -7431},  {-31915, -7428},
    {-31916, -7425},  {-31917, -7421},  {-31917, -7418},  {-31918, -7415},  {-31919, -7412},  {-31919, -7409},
    {-31920, -7406},  {-31921, -7403},  {-31921, -7400},  {-31922, -7397},  {-31923, -7394},  {-31924, -7391},
    {-31924, -7388},  {-31925, -7385},  {-31926, -7382},  {-31926, -7379},  {-31927, -7376},  {-31928, -7372},
    {-31929, -7369},  {-31929, -7366},  {-31930, -7363},  {-31931, -7360},  {-31931, -7357},  {-31932, -7354},
    {-31933, -7351},  {-31934, -7348},  {-31934, -7345},  {-31935, -7342},  {-31936, -7339},  {-31936, -7336},
    {-31937, -7333},  {-31938, -7330},  {-31938, -7327},  {-31939, -7324},  {-31940, -7320},  {-31941, -7317},
    {-31941, -7314},  {-31942, -7311},  {-31943, -7308},  {-31943, -7305},  {-31944, -7302},  {-31945, -7299},
    {-31945, -7296},  {-31946, -7293},  {-31947, -7290},  {-31948, -7287},  {-31948, -7284},  {-31949, -7281},
    {-31950, -7278},  {-31950, -7275},  {-31951, -7271},  {-31952, -7268},  {-31952, -7265},  {-31953, -7262},
    {-31954, -7259},  {-31955, -7256},  {-31955, -7253},  {-31956, -7250},  {-31957, -7247},  {-31957, -7244},
    {-31958, -7241},  {-31959, -7238},  {-31959, -7235},  {-31960, -7232},  {-31961, -7229},  {-31961, -7225},
    {-31962, -7222},  {-31963, -7219},  {-31964, -7216},  {-31964, -7213},  {-31965, -7210},  {-31966, -7207},
    {-31966, -7204},  {-31967, -7201},  {-31968, -7198},  {-31968, -7195},  {-31969, -7192},  {-31970, -7189},
    {-31970, -7186},  {-31971, -7183},  {-31972, -7180},  {-31972, -7176},  {-31973, -7173},  {-31974, -7170},
    {-31975, -7167},  {-31975, -7164},  {-31976, -7161},  {-31977, -7158},  {-31977, -7155},  {-31978, -7152},
    {-31979, -7149},  {-31979, -7146},  {-31980, -7143},  {-31981, -7140},  {-31981, -7137},  {-31982, -7134},
    {-31983, -7130},  {-31983, -7127},  {-31984, -7124},  {-31985, -7121},  {-31986, -7118},  {-31986, -7115},
    {-31987, -7112},  {-31988, -7109},  {-31988, -7106},  {-31989, -7103},  {-31990, -7100},  {-31990, -7097},
    {-31991, -7094},  {-31992, -7091},  {-31992, -7088},  {-31993, -7084},  {-31994, -7081},  {-31994, -7078},
    {-31995, -7075},  {-31996, -7072},  {-31996, -7069},  {-31997, -7066},  {-31998, -7063},  {-31998, -7060},
    {-31999, -7057},  {-32000, -7054},  {-32000, -7051},  {-32001, -7048},  {-32002, -7045},  {-32002, -7042},
    {-32003, -7038},  {-32004, -7035},  {-32005, -7032},  {-32005, -7029},  {-32006, -7026},  {-32007, -7023},
    {-32007, -7020},  {-32008, -7017},  {-32009, -7014},  {-32009, -7011},  {-32010, -7008},  {-32011, -7005},
    {-32011, -7002},  {-32012, -6999},  {-32013, -6995},  {-32013, -6992},  {-32014, -6989},  {-32015, -6986},
    {-32015, -6983},  {-32016, -6980},  {-32017, -6977},  {-32017, -6974},  {-32018, -6971},  {-32019, -6968},
    {-32019, -6965},  {-32020, -6962},  {-32021, -6959},  {-32021, -6956},  {-32022, -6953},  {-32023, -6949},
    {-32023, -6946},  {-32024, -6943},  {-32025, -6940},  {-32025, -6937},  {-32026, -6934},  {-32027, -6931},
    {-32027, -6928},  {-32028, -6925},  {-32029, -6922},  {-32029, -6919},  {-32030, -6916},  {-32031, -6913},
    {-32031, -6910},  {-32032, -6906},  {-32033, -6903},  {-32033, -6900},  {-32034, -6897},  {-32035, -6894},
    {-32035, -6891},  {-32036, -6888},  {-32037, -6885},  {-32037, -6882},  {-32038, -6879},  {-32039, -6876},
    {-32039, -6873},  {-32040, -6870},  {-32040, -6867},  {-32041, -6863},  {-32042, -6860},  {-32042, -6857},
    {-32043, -6854},  {-32044, -6851},  {-32044, -6848},  {-32045, -6845},  {-32046, -6842},  {-32046, -6839},
    {-32047, -6836},  {-32048, -6833},  {-32048, -6830},  {-32049, -6827},  {-32050, -6824},  {-32050, -6820},
    {-32051, -6817},  {-32052, -6814},  {-32052, -6811},  {-32053, -6808},  {-32054, -6805},  {-32054, -6802},
    {-32055, -6799},  {-32056, -6796},  {-32056, -6793},  {-32057, -6790},  {-32058, -6787},  {-32058, -6784},
    {-32059, -6780},  {-32059, -6777},  {-32060, -6774},  {-32061, -6771},  {-32061, -6768},  {-32062, -6765},
    {-32063, -6762},  {-32063, -6759},  {-32064, -6756},  {-32065, -6753},  {-32065, -6750},  {-32066, -6747},
    {-32067, -6744},  {-32067, -6741},  {-32068, -6737},  {-32069, -6734},  {-32069, -6731},  {-32070, -6728},
    {-32070, -6725},  {-32071, -6722},  {-32072, -6719},  {-32072, -6716},  {-32073, -6713},  {-32074, -6710},
    {-32074, -6707},  {-32075, -6704},  {-32076, -6701},  {-32076, -6697},  {-32077, -6694},  {-32078, -6691},
    {-32078, -6688},  {-32079, -6685},  {-32079, -6682},  {-32080, -6679},  {-32081, -6676},  {-32081, -6673},
    {-32082, -6670},  {-32083, -6667},  {-32083, -6664},  {-32084, -6661},  {-32085, -6657},  {-32085, -6654},
    {-32086, -6651},  {-32086, -6648},  {-32087, -6645},  {-32088, -6642},  {-32088, -6639},  {-32089, -6636},
    {-32090, -6633},  {-32090, -6630},  {-32091, -6627},  {-32092, -6624},  {-32092, -6621},  {-32093, -6617},
    {-32093, -6614},  {-32094, -6611},  {-32095, -6608},  {-32095, -6605},  {-32096, -6602},  {-32097, -6599},
    {-32097, -6596},  {-32098, -6593},  {-32099, -6590},  {-32099, -6587},  {-32100, -6584},  {-32100, -6581},
    {-32101, -6577},  {-32102, -6574},  {-32102, -6571},  {-32103, -6568},  {-32104, -6565},  {-32104, -6562},
    {-32105, -6559},  {-32105, -6556},  {-32106, -6553},  {-32107, -6550},  {-32107, -6547},  {-32108, -6544},
    {-32109, -6541},  {-32109, -6537},  {-32110, -6534},  {-32110, -6531},  {-32111, -6528},  {-32112, -6525},
    {-32112, -6522},  {-32113, -6519},  {-32114, -6516},  {-32114, -6513},  {-32115, -6510},  {-32115, -6507},
    {-32116, -6504},  {-32117, -6501},  {-32117, -6497},  {-32118, -6494},  {-32119, -6491},  {-32119, -6488},
    {-32120, -6485},  {-32120, -6482},  {-32121, -6479},  {-32122, -6476},  {-32122, -6473},  {-32123, -6470},
    {-32124, -6467},  {-32124, -6464},  {-32125, -6460},  {-32125, -6457},  {-32126, -6454},  {-32127, -6451},
    {-32127, -6448},  {-32128, -6445},  {-32129, -6442},  {-32129, -6439},  {-32130, -6436},  {-32130, -6433},
    {-32131, -6430},  {-32132, -6427},  {-32132, -6424},  {-32133, -6420},  {-32133, -6417},  {-32134, -6414},
    {-32135, -6411},  {-32135, -6408},  {-32136, -6405},  {-32137, -6402},  {-32137, -6399},  {-32138, -6396},
    {-32138, -6393},  {-32139, -6390},  {-32140, -6387},  {-32140, -6383},  {-32141, -6380},  {-32141, -6377},
    {-32142, -6374},  {-32143, -6371},  {-32143, -6368},  {-32144, -6365},  {-32144, -6362},  {-32145, -6359},
    {-32146, -6356},  {-32146, -6353},  {-32147, -6350},  {-32148, -6346},  {-32148, -6343},  {-32149, -6340},
    {-32149, -6337},  {-32150, -6334},  {-32151, -6331},  {-32151, -6328},  {-32152, -6325},  {-32152, -6322},
    {-32153, -6319},  {-32154, -6316},  {-32154, -6313},  {-32155, -6310},  {-32155, -6306},  {-32156, -6303},
    {-32157, -6300},  {-32157, -6297},  {-32158, -6294},  {-32158, -6291},  {-32159, -6288},  {-32160, -6285},
    {-32160, -6282},  {-32161, -6279},  {-32161, -6276},  {-32162, -6273},  {-32163, -6269},  {-32163, -6266},
    {-32164, -6263},  {-32164, -6260},  {-32165, -6257},  {-32166, -6254},  {-32166, -6251},  {-32167, -6248},
    {-32167, -6245},  {-32168, -6242},  {-32169, -6239},  {-32169, -6236},  {-32170, -6232},  {-32170, -6229},
    {-32171, -6226},  {-32172, -6223},  {-32172, -6220},  {-32173, -6217},  {-32173, -6214},  {-32174, -6211},
    {-32175, -6208},  {-32175, -6205},  {-32176, -6202},  {-32176, -6198},  {-32177, -6195},  {-32178, -6192},
    {-32178, -6189},  {-32179, -6186},  {-32179, -6183},  {-32180, -6180},  {-32181, -6177},  {-32181, -6174},
    {-32182, -6171},  {-32182, -6168},  {-32183, -6165},  {-32184, -6161},  {-32184, -6158},  {-32185, -6155},
    {-32185, -6152},  {-32186, -6149},  {-32186, -6146},  {-32187, -6143},  {-32188, -6140},  {-32188, -6137},
    {-32189, -6134},  {-32189, -6131},  {-32190, -6128},  {-32191, -6124},  {-32191, -6121},  {-32192, -6118},
    {-32192, -6115},  {-32193, -6112},  {-32194, -6109},  {-32194, -6106},  {-32195, -6103},  {-32195, -6100},
    {-32196, -6097},  {-32196, -6094},  {-32197, -6090},  {-32198, -6087},  {-32198, -6084},  {-32199, -6081},
    {-32199, -6078},  {-32200, -6075},  {-32201, -6072},  {-32201, -6069},  {-32202, -6066},  {-32202, -6063},
    {-32203, -6060},  {-32203, -6057},  {-32204, -6053},  {-32205, -6050},  {-32205, -6047},  {-32206, -6044},
    {-32206, -6041},  {-32207, -6038},  {-32207, -6035},  {-32208, -6032},  {-32209, -6029},  {-32209, -6026},
    {-32210, -6023},  {-32210, -6019},  {-32211, -6016},  {-32212, -6013},  {-32212, -6010},  {-32213, -6007},
    {-32213, -6004},  {-32214, -6001},  {-32214, -5998},  {-32215, -5995},  {-32216, -5992},  {-32216, -5989},
    {-32217, -5985},  {-32217, -5982},  {-32218, -5979},  {-32218, -5976},  {-32219, -5973},  {-32220, -5970},
    {-32220, -5967},  {-32221, -5964},  {-32221, -5961},  {-32222, -5958},  {-32222, -5955},  {-32223, -5952},
    {-32224, -5948},  {-32224, -5945},  {-32225, -5942},  {-32225, -5939},  {-32226, -5936},  {-32226, -5933},
    {-32227, -5930},  {-32228, -5927},  {-32228, -5924},  {-32229, -5921},  {-32229, -5918},  {-32230, -5914},
    {-32230, -5911},  {-32231, -5908},  {-32232, -5905},  {-32232, -5902},  {-32233, -5899},  {-32233, -5896},
    {-32234, -5893},  {-32234, -5890},  {-32235, -5887},  {-32235, -5884},  {-32236, -5880},  {-32237, -5877},
    {-32237, -5874},  {-32238, -5871},  {-32238, -5868},  {-32239, -5865},  {-32239, -5862},  {-32240, -5859},
    {-32241, -5856},  {-32241, -5853},  {-32242, -5850},  {-32242, -5846},  {-32243, -5843},  {-32243, -5840},
    {-32244, -5837},  {-32244, -5834},  {-32245, -5831},  {-32246, -5828},  {-32246, -5825},  {-32247, -5822},
    {-32247, -5819},  {-32248, -5816},  {-32248, -5812},  {-32249, -5809},  {-32249, -5806},  {-32250, -5803},
    {-32251, -5800},  {-32251, -5797},  {-32252, -5794},  {-32252, -5791},  {-32253, -5788},  {-32253, -5785},
    {-32254, -5782},  {-32254, -5778},  {-32255, -5775},  {-32256, -5772},  {-32256, -5769},  {-32257, -5766},
    {-32257, -5763},  {-32258, -5760},  {-32258, -5757},  {-32259, -5754},  {-32259, -5751},  {-32260, -5748},
    {-32261, -5744},  {-32261, -5741},  {-32262, -5738},  {-32262, -5735},  {-32263, -5732},  {-32263, -5729},
    {-32264, -5726},  {-32264, -5723},  {-32265, -5720},  {-32266, -5717},  {-32266, -5713},  {-32267, -5710},
    {-32267, -5707},  {-32268, -5704},  {-32268, -5701},  {-32269, -5698},  {-32269, -5695},  {-32270, -5692},
    {-32270, -5689},  {-32271, -5686},  {-32272, -5683},  {-32272, -5679},  {-32273, -5676},  {-32273, -5673},
    {-32274, -5670},  {-32274, -5667},  {-32275, -5664},  {-32275, -5661},  {-32276, -5658},  {-32276, -5655},
    {-32277, -5652},  {-32277, -5649},  {-32278, -5645},  {-32279, -5642},  {-32279, -5639},  {-32280, -5636},
    {-32280, -5633},  {-32281, -5630},  {-32281, -5627},  {-32282, -5624},  {-32282, -5621},  {-32283, -5618},
    {-32283, -5614},  {-32284, -5611},  {-32285, -5608},  {-32285, -5605},  {-32286, -5602},  {-32286, -5599},
    {-32287, -5596},  {-32287, -5593},  {-32288, -5590},  {-32288, -5587},  {-32289, -5584},  {-32289, -5580},
    {-32290, -5577},  {-32290, -5574},  {-32291, -5571},  {-32291, -5568},  {-32292, -5565},  {-32293, -5562},
    {-32293, -5559},  {-32294, -5556},  {-32294, -5553},  {-32295, -5549},  {-32295, -5546},  {-32296, -5543},
    {-32296, -5540},  {-32297, -5537},  {-32297, -5534},  {-32298, -5531},  {-32298, -5528},  {-32299, -5525},
    {-32299, -5522},  {-32300, -5518},  {-32301, -5515},  {-32301, -5512},  {-32302, -5509},  {-32302, -5506},
    {-32303, -5503},  {-32303, -5500},  {-32304, -5497},  {-32304, -5494},  {-32305, -5491},  {-32305, -5488},
    {-32306, -5484},  {-32306, -5481},  {-32307, -5478},  {-32307, -5475},  {-32308, -5472},  {-32308, -5469},
    {-32309, -5466},  {-32309, -5463},  {-32310, -5460},  {-32310, -5457},  {-32311, -5453},  {-32312, -5450},
    {-32312, -5447},  {-32313, -5444},  {-32313, -5441},  {-32314, -5438},  {-32314, -5435},  {-32315, -5432},
    {-32315, -5429},  {-32316, -5426},  {-32316, -5422},  {-32317, -5419},  {-32317, -5416},  {-32318, -5413},
    {-32318, -5410},  {-32319, -5407},  {-32319, -5404},  {-32320, -5401},  {-32320, -5398},  {-32321, -5395},
    {-32321, -5391},  {-32322, -5388},  {-32322, -5385},  {-32323, -5382},  {-32323, -5379},  {-32324, -5376},
    {-32325, -5373},  {-32325, -5370},  {-32326, -5367},  {-32326, -5364},  {-32327, -5360},  {-32327, -5357},
    {-32328, -5354},  {-32328, -5351},  {-32329, -5348},  {-32329, -5345},  {-32330, -5342},  {-32330, -5339},
    {-32331, -5336},  {-32331, -5333},  {-32332, -5329},  {-32332, -5326},  {-32333, -5323},  {-32333, -5320},
    {-32334, -5317},  {-32334, -5314},  {-32335, -5311},  {-32335, -5308},  {-32336, -5305},  {-32336, -5302},
    {-32337, -5298},  {-32337, -5295},  {-32338, -5292},  {-32338, -5289},  {-32339, -5286},  {-32339, -5283},
    {-32340, -5280},  {-32340, -5277},  {-32341, -5274},  {-32341, -5271},  {-32342, -5267},  {-32342, -5264},
    {-32343, -5261},  {-32343, -5258},  {-32344, -5255},  {-32344, -5252},  {-32345, -5249},  {-32345, -5246},
    {-32346, -5243},  {-32346, -5240},  {-32347, -5236},  {-32347, -5233},  {-32348, -5230},  {-32348, -5227},
    {-32349, -5224},  {-32349, -5221},  {-32350, -5218},  {-32350, -5215},  {-32351, -5212},  {-32351, -5209},
    {-32352, -5205},  {-32352, -5202},  {-32353, -5199},  {-32353, -5196},  {-32354, -5193},  {-32354, -5190},
    {-32355, -5187},  {-32355, -5184},  {-32356, -5181},  {-32356, -5178},  {-32357, -5174},  {-32357, -5171},
    {-32358, -5168},  {-32358, -5165},  {-32359, -5162},  {-32359, -5159},  {-32360, -5156},  {-32360, -5153},
    {-32361, -5150},  {-32361, -5147},  {-32362, -5143},  {-32362, -5140},  {-32363, -5137},  {-32363, -5134},
    {-32364, -5131},  {-32364, -5128},  {-32365, -5125},  {-32365, -5122},  {-32366, -5119},  {-32366, -5115},
    {-32367, -5112},  {-32367, -5109},  {-32368, -5106},  {-32368, -5103},  {-32369, -5100},  {-32369, -5097},
    {-32370, -5094},  {-32370, -5091},  {-32371, -5088},  {-32371, -5084},  {-32372, -5081},  {-32372, -5078},
    {-32373, -5075},  {-32373, -5072},  {-32374, -5069},  {-32374, -5066},  {-32375, -5063},  {-32375, -5060},
    {-32376, -5057},  {-32376, -5053},  {-32376, -5050},  {-32377, -5047},  {-32377, -5044},  {-32378, -5041},
    {-32378, -5038},  {-32379, -5035},  {-32379, -5032},  {-32380, -5029},  {-32380, -5025},  {-32381, -5022},
    {-32381, -5019},  {-32382, -5016},  {-32382, -5013},  {-32383, -5010},  {-32383, -5007},  {-32384, -5004},
    {-32384, -5001},  {-32385, -4998},  {-32385, -4994},  {-32386, -4991},  {-32386, -4988},  {-32387, -4985},
    {-32387, -4982},  {-32388, -4979},  {-32388, -4976},  {-32388, -4973},  {-32389, -4970},  {-32389, -4966},
    {-32390, -4963},  {-32390, -4960},  {-32391, -4957},  {-32391, -4954},  {-32392, -4951},  {-32392, -4948},
    {-32393, -4945},  {-32393, -4942},  {-32394, -4939},  {-32394, -4935},  {-32395, -4932},  {-32395, -4929},
    {-32396, -4926},  {-32396, -4923},  {-32397, -4920},  {-32397, -4917},  {-32397, -4914},  {-32398, -4911},
    {-32398, -4907},  {-32399, -4904},  {-32399, -4901},  {-32400, -4898},  {-32400, -4895},  {-32401, -4892},
    {-32401, -4889},  {-32402, -4886},  {-32402, -4883},  {-32403, -4880},  {-32403, -4876},  {-32404, -4873},
    {-32404, -4870},  {-32405, -4867},  {-32405, -4864},  {-32405, -4861},  {-32406, -4858},  {-32406, -4855},
    {-32407, -4852},  {-32407, -4848},  {-32408, -4845},  {-32408, -4842},  {-32409, -4839},  {-32409, -4836},
    {-32410, -4833},  {-32410, -4830},  {-32411, -4827},  {-32411, -4824},  {-32411, -4820},  {-32412, -4817},
    {-32412, -4814},  {-32413, -4811},  {-32413, -4808},  {-32414, -4805},  {-32414, -4802},  {-32415, -4799},
    {-32415, -4796},  {-32416, -4793},  {-32416, -4789},  {-32417, -4786},  {-32417, -4783},  {-32417, -4780},
    {-32418, -4777},  {-32418, -4774},  {-32419, -4771},  {-32419, -4768},  {-32420, -4765},  {-32420, -4761},
    {-32421, -4758},  {-32421, -4755},  {-32422, -4752},  {-32422, -4749},  {-32422, -4746},  {-32423, -4743},
    {-32423, -4740},  {-32424, -4737},  {-32424, -4733},  {-32425, -4730},  {-32425, -4727},  {-32426, -4724},
    {-32426, -4721},  {-32427, -4718},  {-32427, -4715},  {-32427, -4712},  {-32428, -4709},  {-32428, -4705},
    {-32429, -4702},  {-32429, -4699},  {-32430, -4696},  {-32430, -4693},  {-32431, -4690},  {-32431, -4687},
    {-32432, -4684},  {-32432, -4681},  {-32432, -4678},  {-32433, -4674},  {-32433, -4671},  {-32434, -4668},
    {-32434, -4665},  {-32435, -4662},  {-32435, -4659},  {-32436, -4656},  {-32436, -4653},  {-32436, -4650},
    {-32437, -4646},  {-32437, -4643},  {-32438, -4640},  {-32438, -4637},  {-32439, -4634},  {-32439, -4631},
    {-32440, -4628},  {-32440, -4625},  {-32440, -4622},  {-32441, -4618},  {-32441, -4615},  {-32442, -4612},
    {-32442, -4609},  {-32443, -4606},  {-32443, -4603},  {-32444, -4600},  {-32444, -4597},  {-32444, -4594},
    {-32445, -4590},  {-32445, -4587},  {-32446, -4584},  {-32446, -4581},  {-32447, -4578},  {-32447, -4575},
    {-32448, -4572},  {-32448, -4569},  {-32448, -4566},  {-32449, -4562},  {-32449, -4559},  {-32450, -4556},
    {-32450, -4553},  {-32451, -4550},  {-32451, -4547},  {-32451, -4544},  {-32452, -4541},  {-32452, -4538},
    {-32453, -4534},  {-32453, -4531},  {-32454, -4528},  {-32454, -4525},  {-32454, -4522},  {-32455, -4519},
    {-32455, -4516},  {-32456, -4513},  {-32456, -4510},  {-32457, -4506},  {-32457, -4503},  {-32458, -4500},
    {-32458, -4497},  {-32458, -4494},  {-32459, -4491},  {-32459, -4488},  {-32460, -4485},  {-32460, -4482},
    {-32461, -4478},  {-32461, -4475},  {-32461, -4472},  {-32462, -4469},  {-32462, -4466},  {-32463, -4463},
    {-32463, -4460},  {-32464, -4457},  {-32464, -4454},  {-32464, -4450},  {-32465, -4447},  {-32465, -4444},
    {-32466, -4441},  {-32466, -4438},  {-32467, -4435},  {-32467, -4432},  {-32467, -4429},  {-32468, -4426},
    {-32468, -4422},  {-32469, -4419},  {-32469, -4416},  {-32469, -4413},  {-32470, -4410},  {-32470, -4407},
    {-32471, -4404},  {-32471, -4401},  {-32472, -4397},  {-32472, -4394},  {-32472, -4391},  {-32473, -4388},
    {-32473, -4385},  {-32474, -4382},  {-32474, -4379},  {-32475, -4376},  {-32475, -4373},  {-32475, -4369},
    {-32476, -4366},  {-32476, -4363},  {-32477, -4360},  {-32477, -4357},  {-32477, -4354},  {-32478, -4351},
    {-32478, -4348},  {-32479, -4345},  {-32479, -4341},  {-32480, -4338},  {-32480, -4335},  {-32480, -4332},
    {-32481, -4329},  {-32481, -4326},  {-32482, -4323},  {-32482, -4320},  {-32482, -4317},  {-32483, -4313},
    {-32483, -4310},  {-32484, -4307},  {-32484, -4304},  {-32485, -4301},  {-32485, -4298},  {-32485, -4295},
    {-32486, -4292},  {-32486, -4289},  {-32487, -4285},  {-32487, -4282},  {-32487, -4279},  {-32488, -4276},
    {-32488, -4273},  {-32489, -4270},  {-32489, -4267},  {-32489, -4264},  {-32490, -4260},  {-32490, -4257},
    {-32491, -4254},  {-32491, -4251},  {-32491, -4248},  {-32492, -4245},  {-32492, -4242},  {-32493, -4239},
    {-32493, -4236},  {-32494, -4232},  {-32494, -4229},  {-32494, -4226},  {-32495, -4223},  {-32495, -4220},
    {-32496, -4217},  {-32496, -4214},  {-32496, -4211},  {-32497, -4208},  {-32497, -4204},  {-32498, -4201},
    {-32498, -4198},  {-32498, -4195},  {-32499, -4192},  {-32499, -4189},  {-32500, -4186},  {-32500, -4183},
    {-32500, -4179},  {-32501, -4176},  {-32501, -4173},  {-32502, -4170},  {-32502, -4167},  {-32502, -4164},
    {-32503, -4161},  {-32503, -4158},  {-32504, -4155},  {-32504, -4151},  {-32504, -4148},  {-32505, -4145},
    {-32505, -4142},  {-32506, -4139},  {-32506, -4136},  {-32506, -4133},  {-32507, -4130},  {-32507, -4126},
    {-32508, -4123},  {-32508, -4120},  {-32508, -4117},  {-32509, -4114},  {-32509, -4111},  {-32510, -4108},
    {-32510, -4105},  {-32510, -4102},  {-32511, -4098},  {-32511, -4095},  {-32511, -4092},  {-32512, -4089},
    {-32512, -4086},  {-32513, -4083},  {-32513, -4080},  {-32513, -4077},  {-32514, -4074},  {-32514, -4070},
    {-32515, -4067},  {-32515, -4064},  {-32515, -4061},  {-32516, -4058},  {-32516, -4055},  {-32517, -4052},
    {-32517, -4049},  {-32517, -4045},  {-32518, -4042},  {-32518, -4039},  {-32518, -4036},  {-32519, -4033},
    {-32519, -4030},  {-32520, -4027},  {-32520, -4024},  {-32520, -4021},  {-32521, -4017},  {-32521, -4014},
    {-32522, -4011},  {-32522, -4008},  {-32522, -4005},  {-32523, -4002},  {-32523, -3999},  {-32523, -3996},
    {-32524, -3992},  {-32524, -3989},  {-32525, -3986},  {-32525, -3983},  {-32525, -3980},  {-32526, -3977},
    {-32526, -3974},  {-32527, -3971},  {-32527, -3967},  {-32527, -3964},  {-32528, -3961},  {-32528, -3958},
    {-32528, -3955},  {-32529, -3952},  {-32529, -3949},  {-32530, -3946},  {-32530, -3943},  {-32530, -3939},
    {-32531, -3936},  {-32531, -3933},  {-32531, -3930},  {-32532, -3927},  {-32532, -3924},  {-32533, -3921},
    {-32533, -3918},  {-32533, -3914},  {-32534, -3911},  {-32534, -3908},  {-32534, -3905},  {-32535, -3902},
    {-32535, -3899},  {-32536, -3896},  {-32536, -3893},  {-32536, -3890},  {-32537, -3886},  {-32537, -3883},
    {-32537, -3880},  {-32538, -3877},  {-32538, -3874},  {-32539, -3871},  {-32539, -3868},  {-32539, -3865},
    {-32540, -3861},  {-32540, -3858},  {-32540, -3855},  {-32541, -3852},  {-32541, -3849},  {-32542, -3846},
    {-32542, -3843},  {-32542, -3840},  {-32543, -3836},  {-32543, -3833},  {-32543, -3830},  {-32544, -3827},
    {-32544, -3824},  {-32544, -3821},  {-32545, -3818},  {-32545, -3815},  {-32546, -3812},  {-32546, -3808},
    {-32546, -3805},  {-32547, -3802},  {-32547, -3799},  {-32547, -3796},  {-32548, -3793},  {-32548, -3790},
    {-32548, -3787},  {-32549, -3783},  {-32549, -3780},  {-32550, -3777},  {-32550, -3774},  {-32550, -3771},
    {-32551, -3768},  {-32551, -3765},  {-32551, -3762},  {-32552, -3758},  {-32552, -3755},  {-32552, -3752},
    {-32553, -3749},  {-32553, -3746},  {-32554, -3743},  {-32554, -3740},  {-32554, -3737},  {-32555, -3734},
    {-32555, -3730},  {-32555, -3727},  {-32556, -3724},  {-32556, -3721},  {-32556, -3718},  {-32557, -3715},
    {-32557, -3712},  {-32557, -3709},  {-32558, -3705},  {-32558, -3702},  {-32559, -3699},  {-32559, -3696},
    {-32559, -3693},  {-32560, -3690},  {-32560, -3687},  {-32560, -3684},  {-32561, -3680},  {-32561, -3677},
    {-32561, -3674},  {-32562, -3671},  {-32562, -3668},  {-32562, -3665},  {-32563, -3662},  {-32563, -3659},
    {-32563, -3655},  {-32564, -3652},  {-32564, -3649},  {-32565, -3646},  {-32565, -3643},  {-32565, -3640},
    {-32566, -3637},  {-32566, -3634},  {-32566, -3630},  {-32567, -3627},  {-32567, -3624},  {-32567, -3621},
    {-32568, -3618},  {-32568, -3615},  {-32568, -3612},  {-32569, -3609},  {-32569, -3606},  {-32569, -3602},
    {-32570, -3599},  {-32570, -3596},  {-32570, -3593},  {-32571, -3590},  {-32571, -3587},  {-32571, -3584},
    {-32572, -3581},  {-32572, -3577},  {-32572, -3574},  {-32573, -3571},  {-32573, -3568},  {-32574, -3565},
    {-32574, -3562},  {-32574, -3559},  {-32575, -3556},  {-32575, -3552},  {-32575, -3549},  {-32576, -3546},
    {-32576, -3543},  {-32576, -3540},  {-32577, -3537},  {-32577, -3534},  {-32577, -3531},  {-32578, -3527},
    {-32578, -3524},  {-32578, -3521},  {-32579, -3518},  {-32579, -3515},  {-32579, -3512},  {-32580, -3509},
    {-32580, -3506},  {-32580, -3502},  {-32581, -3499},  {-32581, -3496},  {-32581, -3493},  {-32582, -3490},
    {-32582, -3487},  {-32582, -3484},  {-32583, -3481},  {-32583, -3477},  {-32583, -3474},  {-32584, -3471},
    {-32584, -3468},  {-32584, -3465},  {-32585, -3462},  {-32585, -3459},  {-32585, -3456},  {-32586, -3452},
    {-32586, -3449},  {-32586, -3446},  {-32587, -3443},  {-32587, -3440},  {-32587, -3437},  {-32588, -3434},
    {-32588, -3431},  {-32588, -3427},  {-32589, -3424},  {-32589, -3421},  {-32589, -3418},  {-32590, -3415},
    {-32590, -3412},  {-32590, -3409},  {-32591, -3406},  {-32591, -3402},  {-32591, -3399},  {-32592, -3396},
    {-32592, -3393},  {-32592, -3390},  {-32592, -3387},  {-32593, -3384},  {-32593, -3381},  {-32593, -3377},
    {-32594, -3374},  {-32594, -3371},  {-32594, -3368},  {-32595, -3365},  {-32595, -3362},  {-32595, -3359},
    {-32596, -3356},  {-32596, -3352},  {-32596, -3349},  {-32597, -3346},  {-32597, -3343},  {-32597, -3340},
    {-32598, -3337},  {-32598, -3334},  {-32598, -3331},  {-32599, -3327},  {-32599, -3324},  {-32599, -3321},
    {-32600, -3318},  {-32600, -3315},  {-32600, -3312},  {-32601, -3309},  {-32601, -3306},  {-32601, -3302},
    {-32601, -3299},  {-32602, -3296},  {-32602, -3293},  {-32602, -3290},  {-32603, -3287},  {-32603, -3284},
    {-32603, -3281},  {-32604, -3277},  {-32604, -3274},  {-32604, -3271},  {-32605, -3268},  {-32605, -3265},
    {-32605, -3262},  {-32606, -3259},  {-32606, -3256},  {-32606, -3252},  {-32606, -3249},  {-32607, -3246},
    {-32607, -3243},  {-32607, -3240},  {-32608, -3237},  {-32608, -3234},  {-32608, -3231},  {-32609, -3227},
    {-32609, -3224},  {-32609, -3221},  {-32610, -3218},  {-32610, -3215},  {-32610, -3212},  {-32611, -3209},
    {-32611, -3206},  {-32611, -3202},  {-32611, -3199},  {-32612, -3196},  {-32612, -3193},  {-32612, -3190},
    {-32613, -3187},  {-32613, -3184},  {-32613, -3181},  {-32614, -3177},  {-32614, -3174},  {-32614, -3171},
    {-32614, -3168},  {-32615, -3165},  {-32615, -3162},  {-32615, -3159},  {-32616, -3156},  {-32616, -3152},
    {-32616, -3149},  {-32617, -3146},  {-32617, -3143},  {-32617, -3140},  {-32618, -3137},  {-32618, -3134},
    {-32618, -3131},  {-32618, -3127},  {-32619, -3124},  {-32619, -3121},  {-32619, -3118},  {-32620, -3115},
    {-32620, -3112},  {-32620, -3109},  {-32621, -3106},  {-32621, -3102},  {-32621, -3099},  {-32621, -3096},
    {-32622, -3093},  {-32622, -3090},  {-32622, -3087},  {-32623, -3084},  {-32623, -3080},  {-32623, -3077},
    {-32623, -3074},  {-32624, -3071},  {-32624, -3068},  {-32624, -3065},  {-32625, -3062},  {-32625, -3059},
    {-32625, -3055},  {-32626, -3052},  {-32626, -3049},  {-32626, -3046},  {-32626, -3043},  {-32627, -3040},
    {-32627, -3037},  {-32627, -3034},  {-32628, -3030},  {-32628, -3027},  {-32628, -3024},  {-32628, -3021},
    {-32629, -3018},  {-32629, -3015},  {-32629, -3012},  {-32630, -3009},  {-32630, -3005},  {-32630, -3002},
    {-32630, -2999},  {-32631, -2996},  {-32631, -2993},  {-32631, -2990},  {-32632, -2987},  {-32632, -2984},
    {-32632, -2980},  {-32632, -2977},  {-32633, -2974},  {-32633, -2971},  {-32633, -2968},  {-32634, -2965},
    {-32634, -2962},  {-32634, -2958},  {-32634, -2955},  {-32635, -2952},  {-32635, -2949},  {-32635, -2946},
    {-32636, -2943},  {-32636, -2940},  {-32636, -2937},  {-32636, -2933},  {-32637, -2930},  {-32637, -2927},
    {-32637, -2924},  {-32638, -2921},  {-32638, -2918},  {-32638, -2915},  {-32638, -2912},  {-32639, -2908},
    {-32639, -2905},  {-32639, -2902},  {-32640, -2899},  {-32640, -2896},  {-32640, -2893},  {-32640, -2890},
    {-32641, -2887},  {-32641, -2883},  {-32641, -2880},  {-32641, -2877},  {-32642, -2874},  {-32642, -2871},
    {-32642, -2868},  {-32643, -2865},  {-32643, -2861},  {-32643, -2858},  {-32643, -2855},  {-32644, -2852},
    {-32644, -2849},  {-32644, -2846},  {-32644, -2843},  {-32645, -2840},  {-32645, -2836},  {-32645, -2833},
    {-32646, -2830},  {-32646, -2827},  {-32646, -2824},  {-32646, -2821},  {-32647, -2818},  {-32647, -2815},
    {-32647, -2811},  {-32647, -2808},  {-32648, -2805},  {-32648, -2802},  {-32648, -2799},  {-32649, -2796},
    {-32649, -2793},  {-32649, -2789},  {-32649, -2786},  {-32650, -2783},  {-32650, -2780},  {-32650, -2777},
    {-32650, -2774},  {-32651, -2771},  {-32651, -2768},  {-32651, -2764},  {-32651, -2761},  {-32652, -2758},
    {-32652, -2755},  {-32652, -2752},  {-32653, -2749},  {-32653, -2746},  {-32653, -2743},  {-32653, -2739},
    {-32654, -2736},  {-32654, -2733},  {-32654, -2730},  {-32654, -2727},  {-32655, -2724},  {-32655, -2721},
    {-32655, -2717},  {-32655, -2714},  {-32656, -2711},  {-32656, -2708},  {-32656, -2705},  {-32656, -2702},
    {-32657, -2699},  {-32657, -2696},  {-32657, -2692},  {-32657, -2689},  {-32658, -2686},  {-32658, -2683},
    {-32658, -2680},  {-32658, -2677},  {-32659, -2674},  {-32659, -2671},  {-32659, -2667},  {-32660, -2664},
    {-32660, -2661},  {-32660, -2658},  {-32660, -2655},  {-32661, -2652},  {-32661, -2649},  {-32661, -2645},
    {-32661, -2642},  {-32662, -2639},  {-32662, -2636},  {-32662, -2633},  {-32662, -2630},  {-32663, -2627},
    {-32663, -2624},  {-32663, -2620},  {-32663, -2617},  {-32664, -2614},  {-32664, -2611},  {-32664, -2608},
    {-32664, -2605},  {-32665, -2602},  {-32665, -2599},  {-32665, -2595},  {-32665, -2592},  {-32666, -2589},
    {-32666, -2586},  {-32666, -2583},  {-32666, -2580},  {-32667, -2577},  {-32667, -2573},  {-32667, -2570},
    {-32667, -2567},  {-32668, -2564},  {-32668, -2561},  {-32668, -2558},  {-32668, -2555},  {-32669, -2552},
    {-32669, -2548},  {-32669, -2545},  {-32669, -2542},  {-32669, -2539},  {-32670, -2536},  {-32670, -2533},
    {-32670, -2530},  {-32670, -2526},  {-32671, -2523},  {-32671, -2520},  {-32671, -2517},  {-32671, -2514},
    {-32672, -2511},  {-32672, -2508},  {-32672, -2505},  {-32672, -2501},  {-32673, -2498},  {-32673, -2495},
    {-32673, -2492},  {-32673, -2489},  {-32674, -2486},  {-32674, -2483},  {-32674, -2479},  {-32674, -2476},
    {-32675, -2473},  {-32675, -2470},  {-32675, -2467},  {-32675, -2464},  {-32675, -2461},  {-32676, -2458},
    {-32676, -2454},  {-32676, -2451},  {-32676, -2448},  {-32677, -2445},  {-32677, -2442},  {-32677, -2439},
    {-32677, -2436},  {-32678, -2432},  {-32678, -2429},  {-32678, -2426},  {-32678, -2423},  {-32679, -2420},
    {-32679, -2417},  {-32679, -2414},  {-32679, -2411},  {-32679, -2407},  {-32680, -2404},  {-32680, -2401},
    {-32680, -2398},  {-32680, -2395},  {-32681, -2392},  {-32681, -2389},  {-32681, -2385},  {-32681, -2382},
    {-32682, -2379},  {-32682, -2376},  {-32682, -2373},  {-32682, -2370},  {-32682, -2367},  {-32683, -2364},
    {-32683, -2360},  {-32683, -2357},  {-32683, -2354},  {-32684, -2351},  {-32684, -2348},  {-32684, -2345},
    {-32684, -2342},  {-32684, -2338},  {-32685, -2335},  {-32685, -2332},  {-32685, -2329},  {-32685, -2326},
    {-32686, -2323},  {-32686, -2320},  {-32686, -2317},  {-32686, -2313},  {-32686, -2310},  {-32687, -2307},
    {-32687, -2304},  {-32687, -2301},  {-32687, -2298},  {-32688, -2295},  {-32688, -2291},  {-32688, -2288},
    {-32688, -2285},  {-32688, -2282},  {-32689, -2279},  {-32689, -2276},  {-32689, -2273},  {-32689, -2270},
    {-32690, -2266},  {-32690, -2263},  {-32690, -2260},  {-32690, -2257},  {-32690, -2254},  {-32691, -2251},
    {-32691, -2248},  {-32691, -2244},  {-32691, -2241},  {-32691, -2238},  {-32692, -2235},  {-32692, -2232},
    {-32692, -2229},  {-32692, -2226},  {-32693, -2223},  {-32693, -2219},  {-32693, -2216},  {-32693, -2213},
    {-32693, -2210},  {-32694, -2207},  {-32694, -2204},  {-32694, -2201},  {-32694, -2197},  {-32694, -2194},
    {-32695, -2191},  {-32695, -2188},  {-32695, -2185},  {-32695, -2182},  {-32695, -2179},  {-32696, -2176},
    {-32696, -2172},  {-32696, -2169},  {-32696, -2166},  {-32697, -2163},  {-32697, -2160},  {-32697, -2157},
    {-32697, -2154},  {-32697, -2150},  {-32698, -2147},  {-32698, -2144},  {-32698, -2141},  {-32698, -2138},
    {-32698, -2135},  {-32699, -2132},  {-32699, -2129},  {-32699, -2125},  {-32699, -2122},  {-32699, -2119},
    {-32700, -2116},  {-32700, -2113},  {-32700, -2110},  {-32700, -2107},  {-32700, -2103},  {-32701, -2100},
    {-32701, -2097},  {-32701, -2094},  {-32701, -2091},  {-32701, -2088},  {-32702, -2085},  {-32702, -2081},
    {-32702, -2078},  {-32702, -2075},  {-32702, -2072},  {-32703, -2069},  {-32703, -2066},  {-32703, -2063},
    {-32703, -2060},  {-32703, -2056},  {-32704, -2053},  {-32704, -2050},  {-32704, -2047},  {-32704, -2044},
    {-32704, -2041},  {-32705, -2038},  {-32705, -2034},  {-32705, -2031},  {-32705, -2028},  {-32705, -2025},
    {-32706, -2022},  {-32706, -2019},  {-32706, -2016},  {-32706, -2012},  {-32706, -2009},  {-32707, -2006},
    {-32707, -2003},  {-32707, -2000},  {-32707, -1997},  {-32707, -1994},  {-32707, -1991},  {-32708, -1987},
    {-32708, -1984},  {-32708, -1981},  {-32708, -1978},  {-32708, -1975},  {-32709, -1972},  {-32709, -1969},
    {-32709, -1965},  {-32709, -1962},  {-32709, -1959},  {-32710, -1956},  {-32710, -1953},  {-32710, -1950},
    {-32710, -1947},  {-32710, -1944},  {-32710, -1940},  {-32711, -1937},  {-32711, -1934},  {-32711, -1931},
    {-32711, -1928},  {-32711, -1925},  {-32712, -1922},  {-32712, -1918},  {-32712, -1915},  {-32712, -1912},
    {-32712, -1909},  {-32713, -1906},  {-32713, -1903},  {-32713, -1900},  {-32713, -1896},  {-32713, -1893},
    {-32713, -1890},  {-32714, -1887},  {-32714, -1884},  {-32714, -1881},  {-32714, -1878},  {-32714, -1875},
    {-32715, -1871},  {-32715, -1868},  {-32715, -1865},  {-32715, -1862},  {-32715, -1859},  {-32715, -1856},
    {-32716, -1853},  {-32716, -1849},  {-32716, -1846},  {-32716, -1843},  {-32716, -1840},  {-32716, -1837},
    {-32717, -1834},  {-32717, -1831},  {-32717, -1827},  {-32717, -1824},  {-32717, -1821},  {-32718, -1818},
    {-32718, -1815},  {-32718, -1812},  {-32718, -1809},  {-32718, -1806},  {-32718, -1802},  {-32719, -1799},
    {-32719, -1796},  {-32719, -1793},  {-32719, -1790},  {-32719, -1787},  {-32719, -1784},  {-32720, -1780},
    {-32720, -1777},  {-32720, -1774},  {-32720, -1771},  {-32720, -1768},  {-32720, -1765},  {-32721, -1762},
    {-32721, -1758},  {-32721, -1755},  {-32721, -1752},  {-32721, -1749},  {-32721, -1746},  {-32722, -1743},
    {-32722, -1740},  {-32722, -1736},  {-32722, -1733},  {-32722, -1730},  {-32722, -1727},  {-32723, -1724},
    {-32723, -1721},  {-32723, -1718},  {-32723, -1715},  {-32723, -1711},  {-32723, -1708},  {-32724, -1705},
    {-32724, -1702},  {-32724, -1699},  {-32724, -1696},  {-32724, -1693},  {-32724, -1689},  {-32725, -1686},
    {-32725, -1683},  {-32725, -1680},  {-32725, -1677},  {-32725, -1674},  {-32725, -1671},  {-32726, -1667},
    {-32726, -1664},  {-32726, -1661},  {-32726, -1658},  {-32726, -1655},  {-32726, -1652},  {-32727, -1649},
    {-32727, -1646},  {-32727, -1642},  {-32727, -1639},  {-32727, -1636},  {-32727, -1633},  {-32727, -1630},
    {-32728, -1627},  {-32728, -1624},  {-32728, -1620},  {-32728, -1617},  {-32728, -1614},  {-32728, -1611},
    {-32729, -1608},  {-32729, -1605},  {-32729, -1602},  {-32729, -1598},  {-32729, -1595},  {-32729, -1592},
    {-32729, -1589},  {-32730, -1586},  {-32730, -1583},  {-32730, -1580},  {-32730, -1576},  {-32730, -1573},
    {-32730, -1570},  {-32731, -1567},  {-32731, -1564},  {-32731, -1561},  {-32731, -1558},  {-32731, -1555},
    {-32731, -1551},  {-32731, -1548},  {-32732, -1545},  {-32732, -1542},  {-32732, -1539},  {-32732, -1536},
    {-32732, -1533},  {-32732, -1529},  {-32732, -1526},  {-32733, -1523},  {-32733, -1520},  {-32733, -1517},
    {-32733, -1514},  {-32733, -1511},  {-32733, -1507},  {-32733, -1504},  {-32734, -1501},  {-32734, -1498},
    {-32734, -1495},  {-32734, -1492},  {-32734, -1489},  {-32734, -1485},  {-32734, -1482},  {-32735, -1479},
    {-32735, -1476},  {-32735, -1473},  {-32735, -1470},  {-32735, -1467},  {-32735, -1463},  {-32735, -1460},
    {-32736, -1457},  {-32736, -1454},  {-32736, -1451},  {-32736, -1448},  {-32736, -1445},  {-32736, -1442},
    {-32736, -1438},  {-32737, -1435},  {-32737, -1432},  {-32737, -1429},  {-32737, -1426},  {-32737, -1423},
    {-32737, -1420},  {-32737, -1416},  {-32738, -1413},  {-32738, -1410},  {-32738, -1407},  {-32738, -1404},
    {-32738, -1401},  {-32738, -1398},  {-32738, -1394},  {-32738, -1391},  {-32739, -1388},  {-32739, -1385},
    {-32739, -1382},  {-32739, -1379},  {-32739, -1376},  {-32739, -1372},  {-32739, -1369},  {-32740, -1366},
    {-32740, -1363},  {-32740, -1360},  {-32740, -1357},  {-32740, -1354},  {-32740, -1351},  {-32740, -1347},
    {-32740, -1344},  {-32741, -1341},  {-32741, -1338},  {-32741, -1335},  {-32741, -1332},  {-32741, -1329},
    {-32741, -1325},  {-32741, -1322},  {-32741, -1319},  {-32742, -1316},  {-32742, -1313},  {-32742, -1310},
    {-32742, -1307},  {-32742, -1303},  {-32742, -1300},  {-32742, -1297},  {-32742, -1294},  {-32743, -1291},
    {-32743, -1288},  {-32743, -1285},  {-32743, -1281},  {-32743, -1278},  {-32743, -1275},  {-32743, -1272},
    {-32743, -1269},  {-32744, -1266},  {-32744, -1263},  {-32744, -1259},  {-32744, -1256},  {-32744, -1253},
    {-32744, -1250},  {-32744, -1247},  {-32744, -1244},  {-32745, -1241},  {-32745, -1237},  {-32745, -1234},
    {-32745, -1231},  {-32745, -1228},  {-32745, -1225},  {-32745, -1222},  {-32745, -1219},  {-32745, -1216},
    {-32746, -1212},  {-32746, -1209},  {-32746, -1206},  {-32746, -1203},  {-32746, -1200},  {-32746, -1197},
    {-32746, -1194},  {-32746, -1190},  {-32746, -1187},  {-32747, -1184},  {-32747, -1181},  {-32747, -1178},
    {-32747, -1175},  {-32747, -1172},  {-32747, -1168},  {-32747, -1165},  {-32747, -1162},  {-32747, -1159},
    {-32748, -1156},  {-32748, -1153},  {-32748, -1150},  {-32748, -1146},  {-32748, -1143},  {-32748, -1140},
    {-32748, -1137},  {-32748, -1134},  {-32748, -1131},  {-32749, -1128},  {-32749, -1124},  {-32749, -1121},
    {-32749, -1118},  {-32749, -1115},  {-32749, -1112},  {-32749, -1109},  {-32749, -1106},  {-32749, -1102},
    {-32750, -1099},  {-32750, -1096},  {-32750, -1093},  {-32750, -1090},  {-32750, -1087},  {-32750, -1084},
    {-32750, -1081},  {-32750, -1077},  {-32750, -1074},  {-32750, -1071},  {-32751, -1068},  {-32751, -1065},
    {-32751, -1062},  {-32751, -1059},  {-32751, -1055},  {-32751, -1052},  {-32751, -1049},  {-32751, -1046},
    {-32751, -1043},  {-32752, -1040},  {-32752, -1037},  {-32752, -1033},  {-32752, -1030},  {-32752, -1027},
    {-32752, -1024},  {-32752, -1021},  {-32752, -1018},  {-32752, -1015},  {-32752, -1011},  {-32752, -1008},
    {-32753, -1005},  {-32753, -1002},  {-32753, -999},   {-32753, -996},   {-32753, -993},   {-32753, -989},
    {-32753, -986},   {-32753, -983},   {-32753, -980},   {-32753, -977},   {-32754, -974},   {-32754, -971},
    {-32754, -967},   {-32754, -964},   {-32754, -961},   {-32754, -958},   {-32754, -955},   {-32754, -952},
    {-32754, -949},   {-32754, -945},   {-32754, -942},   {-32755, -939},   {-32755, -936},   {-32755, -933},
    {-32755, -930},   {-32755, -927},   {-32755, -924},   {-32755, -920},   {-32755, -917},   {-32755, -914},
    {-32755, -911},   {-32755, -908},   {-32756, -905},   {-32756, -902},   {-32756, -898},   {-32756, -895},
    {-32756, -892},   {-32756, -889},   {-32756, -886},   {-32756, -883},   {-32756, -880},   {-32756, -876},
    {-32756, -873},   {-32756, -870},   {-32757, -867},   {-32757, -864},   {-32757, -861},   {-32757, -858},
    {-32757, -854},   {-32757, -851},   {-32757, -848},   {-32757, -845},   {-32757, -842},   {-32757, -839},
    {-32757, -836},   {-32757, -832},   {-32758, -829},   {-32758, -826},   {-32758, -823},   {-32758, -820},
    {-32758, -817},   {-32758, -814},   {-32758, -810},   {-32758, -807},   {-32758, -804},   {-32758, -801},
    {-32758, -798},   {-32758, -795},   {-32758, -792},   {-32759, -788},   {-32759, -785},   {-32759, -782},
    {-32759, -779},   {-32759, -776},   {-32759, -773},   {-32759, -770},   {-32759, -766},   {-32759, -763},
    {-32759, -760},   {-32759, -757},   {-32759, -754},   {-32759, -751},   {-32759, -748},   {-32760, -744},
    {-32760, -741},   {-32760, -738},   {-32760, -735},   {-32760, -732},   {-32760, -729},   {-32760, -726},
    {-32760, -723},   {-32760, -719},   {-32760, -716},   {-32760, -713},   {-32760, -710},   {-32760, -707},
    {-32760, -704},   {-32761, -701},   {-32761, -697},   {-32761, -694},   {-32761, -691},   {-32761, -688},
    {-32761, -685},   {-32761, -682},   {-32761, -679},   {-32761, -675},   {-32761, -672},   {-32761, -669},
    {-32761, -666},   {-32761, -663},   {-32761, -660},   {-32761, -657},   {-32761, -653},   {-32762, -650},
    {-32762, -647},   {-32762, -644},   {-32762, -641},   {-32762, -638},   {-32762, -635},   {-32762, -631},
    {-32762, -628},   {-32762, -625},   {-32762, -622},   {-32762, -619},   {-32762, -616},   {-32762, -613},
    {-32762, -609},   {-32762, -606},   {-32762, -603},   {-32763, -600},   {-32763, -597},   {-32763, -594},
    {-32763, -591},   {-32763, -587},   {-32763, -584},   {-32763, -581},   {-32763, -578},   {-32763, -575},
    {-32763, -572},   {-32763, -569},   {-32763, -565},   {-32763, -562},   {-32763, -559},   {-32763, -556},
    {-32763, -553},   {-32763, -550},   {-32763, -547},   {-32763, -543},   {-32764, -540},   {-32764, -537},
    {-32764, -534},   {-32764, -531},   {-32764, -528},   {-32764, -525},   {-32764, -521},   {-32764, -518},
    {-32764, -515},   {-32764, -512},   {-32764, -509},   {-32764, -506},   {-32764, -503},   {-32764, -499},
    {-32764, -496},   {-32764, -493},   {-32764, -490},   {-32764, -487},   {-32764, -484},   {-32764, -481},
    {-32765, -478},   {-32765, -474},   {-32765, -471},   {-32765, -468},   {-32765, -465},   {-32765, -462},
    {-32765, -459},   {-32765, -456},   {-32765, -452},   {-32765, -449},   {-32765, -446},   {-32765, -443},
    {-32765, -440},   {-32765, -437},   {-32765, -434},   {-32765, -430},   {-32765, -427},   {-32765, -424},
    {-32765, -421},   {-32765, -418},   {-32765, -415},   {-32765, -412},   {-32765, -408},   {-32765, -405},
    {-32766, -402},   {-32766, -399},   {-32766, -396},   {-32766, -393},   {-32766, -390},   {-32766, -386},
    {-32766, -383},   {-32766, -380},   {-32766, -377},   {-32766, -374},   {-32766, -371},   {-32766, -368},
    {-32766, -364},   {-32766, -361},   {-32766, -358},   {-32766, -355},   {-32766, -352},   {-32766, -349},
    {-32766, -346},   {-32766, -342},   {-32766, -339},   {-32766, -336},   {-32766, -333},   {-32766, -330},
    {-32766, -327},   {-32766, -324},   {-32766, -320},   {-32766, -317},   {-32766, -314},   {-32767, -311},
    {-32767, -308},   {-32767, -305},   {-32767, -302},   {-32767, -298},   {-32767, -295},   {-32767, -292},
    {-32767, -289},   {-32767, -286},   {-32767, -283},   {-32767, -280},   {-32767, -276},   {-32767, -273},
    {-32767, -270},   {-32767, -267},   {-32767, -264},   {-32767, -261},   {-32767, -258},   {-32767, -254},
    {-32767, -251},   {-32767, -248},   {-32767, -245},   {-32767, -242},   {-32767, -239},   {-32767, -236},
    {-32767, -232},   {-32767, -229},   {-32767, -226},   {-32767, -223},   {-32767, -220},   {-32767, -217},
    {-32767, -214},   {-32767, -210},   {-32767, -207},   {-32767, -204},   {-32767, -201},   {-32767, -198},
    {-32767, -195},   {-32767, -192},   {-32767, -188},   {-32767, -185},   {-32767, -182},   {-32768, -179},
    {-32768, -176},   {-32768, -173},   {-32768, -170},   {-32768, -167},   {-32768, -163},   {-32768, -160},
    {-32768, -157},   {-32768, -154},   {-32768, -151},   {-32768, -148},   {-32768, -145},   {-32768, -141},
    {-32768, -138},   {-32768, -135},   {-32768, -132},   {-32768, -129},   {-32768, -126},   {-32768, -123},
    {-32768, -119},   {-32768, -116},   {-32768, -113},   {-32768, -110},   {-32768, -107},   {-32768, -104},
    {-32768, -101},   {-32768, -97},    {-32768, -94},    {-32768, -91},    {-32768, -88},    {-32768, -85},
    {-32768, -82},    {-32768, -79},    {-32768, -75},    {-32768, -72},    {-32768, -69},    {-32768, -66},
    {-32768, -63},    {-32768, -60},    {-32768, -57},    {-32768, -53},    {-32768, -50},    {-32768, -47},
    {-32768, -44},    {-32768, -41},    {-32768, -38},    {-32768, -35},    {-32768, -31},    {-32768, -28},
    {-32768, -25},    {-32768, -22},    {-32768, -19},    {-32768, -16},    {-32768, -13},    {-32768, -9},
    {-32768, -6},     {-32768, -3}};

static constexpr cint16 r2_twiddle_master_cint15[kR2MasterTableSize] = {
    {16384, 0},       {16384, -2},      {16384, -3},      {16384, -5},      {16384, -6},      {16384, -8},
    {16384, -9},      {16384, -11},     {16384, -13},     {16384, -14},     {16384, -16},     {16384, -17},
    {16384, -19},     {16384, -20},     {16384, -22},     {16384, -24},     {16384, -25},     {16384, -27},
    {16384, -28},     {16384, -30},     {16384, -31},     {16384, -33},     {16384, -35},     {16384, -36},
    {16384, -38},     {16384, -39},     {16384, -41},     {16384, -42},     {16384, -44},     {16384, -46},
    {16384, -47},     {16384, -49},     {16384, -50},     {16384, -52},     {16384, -53},     {16384, -55},
    {16384, -57},     {16384, -58},     {16384, -60},     {16384, -61},     {16384, -63},     {16384, -64},
    {16384, -66},     {16384, -68},     {16384, -69},     {16384, -71},     {16384, -72},     {16384, -74},
    {16384, -75},     {16384, -77},     {16384, -79},     {16384, -80},     {16384, -82},     {16384, -83},
    {16384, -85},     {16384, -86},     {16384, -88},     {16384, -90},     {16384, -91},     {16384, -93},
    {16384, -94},     {16384, -96},     {16384, -97},     {16384, -99},     {16384, -101},    {16384, -102},
    {16384, -104},    {16384, -105},    {16384, -107},    {16384, -108},    {16384, -110},    {16384, -112},
    {16384, -113},    {16384, -115},    {16384, -116},    {16384, -118},    {16384, -119},    {16384, -121},
    {16384, -123},    {16384, -124},    {16384, -126},    {16384, -127},    {16383, -129},    {16383, -130},
    {16383, -132},    {16383, -134},    {16383, -135},    {16383, -137},    {16383, -138},    {16383, -140},
    {16383, -141},    {16383, -143},    {16383, -145},    {16383, -146},    {16383, -148},    {16383, -149},
    {16383, -151},    {16383, -152},    {16383, -154},    {16383, -156},    {16383, -157},    {16383, -159},
    {16383, -160},    {16383, -162},    {16383, -163},    {16383, -165},    {16383, -167},    {16383, -168},
    {16383, -170},    {16383, -171},    {16383, -173},    {16383, -174},    {16383, -176},    {16383, -177},
    {16383, -179},    {16383, -181},    {16383, -182},    {16383, -184},    {16383, -185},    {16383, -187},
    {16383, -188},    {16383, -190},    {16383, -192},    {16383, -193},    {16383, -195},    {16383, -196},
    {16383, -198},    {16383, -199},    {16383, -201},    {16383, -203},    {16383, -204},    {16383, -206},
    {16383, -207},    {16383, -209},    {16383, -210},    {16383, -212},    {16383, -214},    {16383, -215},
    {16383, -217},    {16383, -218},    {16383, -220},    {16383, -221},    {16382, -223},    {16382, -225},
    {16382, -226},    {16382, -228},    {16382, -229},    {16382, -231},    {16382, -232},    {16382, -234},
    {16382, -236},    {16382, -237},    {16382, -239},    {16382, -240},    {16382, -242},    {16382, -243},
    {16382, -245},    {16382, -247},    {16382, -248},    {16382, -250},    {16382, -251},    {16382, -253},
    {16382, -254},    {16382, -256},    {16382, -258},    {16382, -259},    {16382, -261},    {16382, -262},
    {16382, -264},    {16382, -265},    {16382, -267},    {16382, -269},    {16382, -270},    {16382, -272},
    {16382, -273},    {16382, -275},    {16382, -276},    {16382, -278},    {16382, -280},    {16382, -281},
    {16382, -283},    {16382, -284},    {16382, -286},    {16381, -287},    {16381, -289},    {16381, -291},
    {16381, -292},    {16381, -294},    {16381, -295},    {16381, -297},    {16381, -298},    {16381, -300},
    {16381, -302},    {16381, -303},    {16381, -305},    {16381, -306},    {16381, -308},    {16381, -309},
    {16381, -311},    {16381, -313},    {16381, -314},    {16381, -316},    {16381, -317},    {16381, -319},
    {16381, -320},    {16381, -322},    {16381, -324},    {16381, -325},    {16381, -327},    {16381, -328},
    {16381, -330},    {16381, -331},    {16381, -333},    {16381, -335},    {16381, -336},    {16381, -338},
    {16380, -339},    {16380, -341},    {16380, -342},    {16380, -344},    {16380, -346},    {16380, -347},
    {16380, -349},    {16380, -350},    {16380, -352},    {16380, -353},    {16380, -355},    {16380, -357},
    {16380, -358},    {16380, -360},    {16380, -361},    {16380, -363},    {16380, -364},    {16380, -366},
    {16380, -368},    {16380, -369},    {16380, -371},    {16380, -372},    {16380, -374},    {16380, -375},
    {16380, -377},    {16380, -379},    {16380, -380},    {16380, -382},    {16380, -383},    {16379, -385},
    {16379, -386},    {16379, -388},    {16379, -390},    {16379, -391},    {16379, -393},    {16379, -394},
    {16379, -396},    {16379, -397},    {16379, -399},    {16379, -401},    {16379, -402},    {16379, -404},
    {16379, -405},    {16379, -407},    {16379, -408},    {16379, -410},    {16379, -412},    {16379, -413},
    {16379, -415},    {16379, -416},    {16379, -418},    {16379, -419},    {16379, -421},    {16379, -422},
    {16379, -424},    {16378, -426},    {16378, -427},    {16378, -429},    {16378, -430},    {16378, -432},
    {16378, -433},    {16378, -435},    {16378, -437},    {16378, -438},    {16378, -440},    {16378, -441},
    {16378, -443},    {16378, -444},    {16378, -446},    {16378, -448},    {16378, -449},    {16378, -451},
    {16378, -452},    {16378, -454},    {16378, -455},    {16378, -457},    {16378, -459},    {16378, -460},
    {16377, -462},    {16377, -463},    {16377, -465},    {16377, -466},    {16377, -468},    {16377, -470},
    {16377, -471},    {16377, -473},    {16377, -474},    {16377, -476},    {16377, -477},    {16377, -479},
    {16377, -481},    {16377, -482},    {16377, -484},    {16377, -485},    {16377, -487},    {16377, -488},
    {16377, -490},    {16377, -492},    {16377, -493},    {16377, -495},    {16376, -496},    {16376, -498},
    {16376, -499},    {16376, -501},    {16376, -503},    {16376, -504},    {16376, -506},    {16376, -507},
    {16376, -509},    {16376, -510},    {16376, -512},    {16376, -514},    {16376, -515},    {16376, -517},
    {16376, -518},    {16376, -520},    {16376, -521},    {16376, -523},    {16376, -525},    {16376, -526},
    {16375, -528},    {16375, -529},    {16375, -531},    {16375, -532},    {16375, -534},    {16375, -536},
    {16375, -537},    {16375, -539},    {16375, -540},    {16375, -542},    {16375, -543},    {16375, -545},
    {16375, -547},    {16375, -548},    {16375, -550},    {16375, -551},    {16375, -553},    {16375, -554},
    {16375, -556},    {16375, -558},    {16374, -559},    {16374, -561},    {16374, -562},    {16374, -564},
    {16374, -565},    {16374, -567},    {16374, -569},    {16374, -570},    {16374, -572},    {16374, -573},
    {16374, -575},    {16374, -576},    {16374, -578},    {16374, -580},    {16374, -581},    {16374, -583},
    {16374, -584},    {16374, -586},    {16373, -587},    {16373, -589},    {16373, -590},    {16373, -592},
    {16373, -594},    {16373, -595},    {16373, -597},    {16373, -598},    {16373, -600},    {16373, -601},
    {16373, -603},    {16373, -605},    {16373, -606},    {16373, -608},    {16373, -609},    {16373, -611},
    {16373, -612},    {16372, -614},    {16372, -616},    {16372, -617},    {16372, -619},    {16372, -620},
    {16372, -622},    {16372, -623},    {16372, -625},    {16372, -627},    {16372, -628},    {16372, -630},
    {16372, -631},    {16372, -633},    {16372, -634},    {16372, -636},    {16372, -638},    {16372, -639},
    {16371, -641},    {16371, -642},    {16371, -644},    {16371, -645},    {16371, -647},    {16371, -649},
    {16371, -650},    {16371, -652},    {16371, -653},    {16371, -655},    {16371, -656},    {16371, -658},
    {16371, -660},    {16371, -661},    {16371, -663},    {16371, -664},    {16370, -666},    {16370, -667},
    {16370, -669},    {16370, -671},    {16370, -672},    {16370, -674},    {16370, -675},    {16370, -677},
    {16370, -678},    {16370, -680},    {16370, -682},    {16370, -683},    {16370, -685},    {16370, -686},
    {16370, -688},    {16369, -689},    {16369, -691},    {16369, -693},    {16369, -694},    {16369, -696},
    {16369, -697},    {16369, -699},    {16369, -700},    {16369, -702},    {16369, -704},    {16369, -705},
    {16369, -707},    {16369, -708},    {16369, -710},    {16369, -711},    {16368, -713},    {16368, -714},
    {16368, -716},    {16368, -718},    {16368, -719},    {16368, -721},    {16368, -722},    {16368, -724},
    {16368, -725},    {16368, -727},    {16368, -729},    {16368, -730},    {16368, -732},    {16368, -733},
    {16368, -735},    {16367, -736},    {16367, -738},    {16367, -740},    {16367, -741},    {16367, -743},
    {16367, -744},    {16367, -746},    {16367, -747},    {16367, -749},    {16367, -751},    {16367, -752},
    {16367, -754},    {16367, -755},    {16367, -757},    {16366, -758},    {16366, -760},    {16366, -762},
    {16366, -763},    {16366, -765},    {16366, -766},    {16366, -768},    {16366, -769},    {16366, -771},
    {16366, -773},    {16366, -774},    {16366, -776},    {16366, -777},    {16365, -779},    {16365, -780},
    {16365, -782},    {16365, -784},    {16365, -785},    {16365, -787},    {16365, -788},    {16365, -790},
    {16365, -791},    {16365, -793},    {16365, -795},    {16365, -796},    {16365, -798},    {16364, -799},
    {16364, -801},    {16364, -802},    {16364, -804},    {16364, -805},    {16364, -807},    {16364, -809},
    {16364, -810},    {16364, -812},    {16364, -813},    {16364, -815},    {16364, -816},    {16364, -818},
    {16363, -820},    {16363, -821},    {16363, -823},    {16363, -824},    {16363, -826},    {16363, -827},
    {16363, -829},    {16363, -831},    {16363, -832},    {16363, -834},    {16363, -835},    {16363, -837},
    {16363, -838},    {16362, -840},    {16362, -842},    {16362, -843},    {16362, -845},    {16362, -846},
    {16362, -848},    {16362, -849},    {16362, -851},    {16362, -853},    {16362, -854},    {16362, -856},
    {16362, -857},    {16361, -859},    {16361, -860},    {16361, -862},    {16361, -864},    {16361, -865},
    {16361, -867},    {16361, -868},    {16361, -870},    {16361, -871},    {16361, -873},    {16361, -875},
    {16361, -876},    {16360, -878},    {16360, -879},    {16360, -881},    {16360, -882},    {16360, -884},
    {16360, -885},    {16360, -887},    {16360, -889},    {16360, -890},    {16360, -892},    {16360, -893},
    {16360, -895},    {16359, -896},    {16359, -898},    {16359, -900},    {16359, -901},    {16359, -903},
    {16359, -904},    {16359, -906},    {16359, -907},    {16359, -909},    {16359, -911},    {16359, -912},
    {16359, -914},    {16358, -915},    {16358, -917},    {16358, -918},    {16358, -920},    {16358, -922},
    {16358, -923},    {16358, -925},    {16358, -926},    {16358, -928},    {16358, -929},    {16358, -931},
    {16357, -933},    {16357, -934},    {16357, -936},    {16357, -937},    {16357, -939},    {16357, -940},
    {16357, -942},    {16357, -944},    {16357, -945},    {16357, -947},    {16357, -948},    {16356, -950},
    {16356, -951},    {16356, -953},    {16356, -955},    {16356, -956},    {16356, -958},    {16356, -959},
    {16356, -961},    {16356, -962},    {16356, -964},    {16356, -965},    {16355, -967},    {16355, -969},
    {16355, -970},    {16355, -972},    {16355, -973},    {16355, -975},    {16355, -976},    {16355, -978},
    {16355, -980},    {16355, -981},    {16355, -983},    {16354, -984},    {16354, -986},    {16354, -987},
    {16354, -989},    {16354, -991},    {16354, -992},    {16354, -994},    {16354, -995},    {16354, -997},
    {16354, -998},    {16353, -1000},   {16353, -1002},   {16353, -1003},   {16353, -1005},   {16353, -1006},
    {16353, -1008},   {16353, -1009},   {16353, -1011},   {16353, -1013},   {16353, -1014},   {16352, -1016},
    {16352, -1017},   {16352, -1019},   {16352, -1020},   {16352, -1022},   {16352, -1023},   {16352, -1025},
    {16352, -1027},   {16352, -1028},   {16352, -1030},   {16352, -1031},   {16351, -1033},   {16351, -1034},
    {16351, -1036},   {16351, -1038},   {16351, -1039},   {16351, -1041},   {16351, -1042},   {16351, -1044},
    {16351, -1045},   {16351, -1047},   {16350, -1049},   {16350, -1050},   {16350, -1052},   {16350, -1053},
    {16350, -1055},   {16350, -1056},   {16350, -1058},   {16350, -1060},   {16350, -1061},   {16350, -1063},
    {16349, -1064},   {16349, -1066},   {16349, -1067},   {16349, -1069},   {16349, -1071},   {16349, -1072},
    {16349, -1074},   {16349, -1075},   {16349, -1077},   {16348, -1078},   {16348, -1080},   {16348, -1081},
    {16348, -1083},   {16348, -1085},   {16348, -1086},   {16348, -1088},   {16348, -1089},   {16348, -1091},
    {16348, -1092},   {16347, -1094},   {16347, -1096},   {16347, -1097},   {16347, -1099},   {16347, -1100},
    {16347, -1102},   {16347, -1103},   {16347, -1105},   {16347, -1107},   {16346, -1108},   {16346, -1110},
    {16346, -1111},   {16346, -1113},   {16346, -1114},   {16346, -1116},   {16346, -1118},   {16346, -1119},
    {16346, -1121},   {16346, -1122},   {16345, -1124},   {16345, -1125},   {16345, -1127},   {16345, -1129},
    {16345, -1130},   {16345, -1132},   {16345, -1133},   {16345, -1135},   {16345, -1136},   {16344, -1138},
    {16344, -1139},   {16344, -1141},   {16344, -1143},   {16344, -1144},   {16344, -1146},   {16344, -1147},
    {16344, -1149},   {16344, -1150},   {16343, -1152},   {16343, -1154},   {16343, -1155},   {16343, -1157},
    {16343, -1158},   {16343, -1160},   {16343, -1161},   {16343, -1163},   {16343, -1165},   {16342, -1166},
    {16342, -1168},   {16342, -1169},   {16342, -1171},   {16342, -1172},   {16342, -1174},   {16342, -1176},
    {16342, -1177},   {16342, -1179},   {16341, -1180},   {16341, -1182},   {16341, -1183},   {16341, -1185},
    {16341, -1186},   {16341, -1188},   {16341, -1190},   {16341, -1191},   {16341, -1193},   {16340, -1194},
    {16340, -1196},   {16340, -1197},   {16340, -1199},   {16340, -1201},   {16340, -1202},   {16340, -1204},
    {16340, -1205},   {16339, -1207},   {16339, -1208},   {16339, -1210},   {16339, -1212},   {16339, -1213},
    {16339, -1215},   {16339, -1216},   {16339, -1218},   {16339, -1219},   {16338, -1221},   {16338, -1223},
    {16338, -1224},   {16338, -1226},   {16338, -1227},   {16338, -1229},   {16338, -1230},   {16338, -1232},
    {16338, -1233},   {16337, -1235},   {16337, -1237},   {16337, -1238},   {16337, -1240},   {16337, -1241},
    {16337, -1243},   {16337, -1244},   {16337, -1246},   {16336, -1248},   {16336, -1249},   {16336, -1251},
    {16336, -1252},   {16336, -1254},   {16336, -1255},   {16336, -1257},   {16336, -1259},   {16335, -1260},
    {16335, -1262},   {16335, -1263},   {16335, -1265},   {16335, -1266},   {16335, -1268},   {16335, -1270},
    {16335, -1271},   {16334, -1273},   {16334, -1274},   {16334, -1276},   {16334, -1277},   {16334, -1279},
    {16334, -1280},   {16334, -1282},   {16334, -1284},   {16334, -1285},   {16333, -1287},   {16333, -1288},
    {16333, -1290},   {16333, -1291},   {16333, -1293},   {16333, -1295},   {16333, -1296},   {16333, -1298},
    {16332, -1299},   {16332, -1301},   {16332, -1302},   {16332, -1304},   {16332, -1306},   {16332, -1307},
    {16332, -1309},   {16332, -1310},   {16331, -1312},   {16331, -1313},   {16331, -1315},   {16331, -1316},
    {16331, -1318},   {16331, -1320},   {16331, -1321},   {16331, -1323},   {16330, -1324},   {16330, -1326},
    {16330, -1327},   {16330, -1329},   {16330, -1331},   {16330, -1332},   {16330, -1334},   {16329, -1335},
    {16329, -1337},   {16329, -1338},   {16329, -1340},   {16329, -1342},   {16329, -1343},   {16329, -1345},
    {16329, -1346},   {16328, -1348},   {16328, -1349},   {16328, -1351},   {16328, -1352},   {16328, -1354},
    {16328, -1356},   {16328, -1357},   {16328, -1359},   {16327, -1360},   {16327, -1362},   {16327, -1363},
    {16327, -1365},   {16327, -1367},   {16327, -1368},   {16327, -1370},   {16327, -1371},   {16326, -1373},
    {16326, -1374},   {16326, -1376},   {16326, -1378},   {16326, -1379},   {16326, -1381},   {16326, -1382},
    {16325, -1384},   {16325, -1385},   {16325, -1387},   {16325, -1388},   {16325, -1390},   {16325, -1392},
    {16325, -1393},   {16325, -1395},   {16324, -1396},   {16324, -1398},   {16324, -1399},   {16324, -1401},
    {16324, -1403},   {16324, -1404},   {16324, -1406},   {16323, -1407},   {16323, -1409},   {16323, -1410},
    {16323, -1412},   {16323, -1414},   {16323, -1415},   {16323, -1417},   {16323, -1418},   {16322, -1420},
    {16322, -1421},   {16322, -1423},   {16322, -1424},   {16322, -1426},   {16322, -1428},   {16322, -1429},
    {16321, -1431},   {16321, -1432},   {16321, -1434},   {16321, -1435},   {16321, -1437},   {16321, -1439},
    {16321, -1440},   {16320, -1442},   {16320, -1443},   {16320, -1445},   {16320, -1446},   {16320, -1448},
    {16320, -1450},   {16320, -1451},   {16319, -1453},   {16319, -1454},   {16319, -1456},   {16319, -1457},
    {16319, -1459},   {16319, -1460},   {16319, -1462},   {16318, -1464},   {16318, -1465},   {16318, -1467},
    {16318, -1468},   {16318, -1470},   {16318, -1471},   {16318, -1473},   {16318, -1475},   {16317, -1476},
    {16317, -1478},   {16317, -1479},   {16317, -1481},   {16317, -1482},   {16317, -1484},   {16317, -1486},
    {16316, -1487},   {16316, -1489},   {16316, -1490},   {16316, -1492},   {16316, -1493},   {16316, -1495},
    {16316, -1496},   {16315, -1498},   {16315, -1500},   {16315, -1501},   {16315, -1503},   {16315, -1504},
    {16315, -1506},   {16315, -1507},   {16314, -1509},   {16314, -1511},   {16314, -1512},   {16314, -1514},
    {16314, -1515},   {16314, -1517},   {16313, -1518},   {16313, -1520},   {16313, -1521},   {16313, -1523},
    {16313, -1525},   {16313, -1526},   {16313, -1528},   {16312, -1529},   {16312, -1531},   {16312, -1532},
    {16312, -1534},   {16312, -1536},   {16312, -1537},   {16312, -1539},   {16311, -1540},   {16311, -1542},
    {16311, -1543},   {16311, -1545},   {16311, -1546},   {16311, -1548},   {16311, -1550},   {16310, -1551},
    {16310, -1553},   {16310, -1554},   {16310, -1556},   {16310, -1557},   {16310, -1559},   {16310, -1561},
    {16309, -1562},   {16309, -1564},   {16309, -1565},   {16309, -1567},   {16309, -1568},   {16309, -1570},
    {16308, -1572},   {16308, -1573},   {16308, -1575},   {16308, -1576},   {16308, -1578},   {16308, -1579},
    {16308, -1581},   {16307, -1582},   {16307, -1584},   {16307, -1586},   {16307, -1587},   {16307, -1589},
    {16307, -1590},   {16306, -1592},   {16306, -1593},   {16306, -1595},   {16306, -1597},   {16306, -1598},
    {16306, -1600},   {16306, -1601},   {16305, -1603},   {16305, -1604},   {16305, -1606},   {16305, -1607},
    {16305, -1609},   {16305, -1611},   {16304, -1612},   {16304, -1614},   {16304, -1615},   {16304, -1617},
    {16304, -1618},   {16304, -1620},   {16304, -1622},   {16303, -1623},   {16303, -1625},   {16303, -1626},
    {16303, -1628},   {16303, -1629},   {16303, -1631},   {16302, -1632},   {16302, -1634},   {16302, -1636},
    {16302, -1637},   {16302, -1639},   {16302, -1640},   {16302, -1642},   {16301, -1643},   {16301, -1645},
    {16301, -1647},   {16301, -1648},   {16301, -1650},   {16301, -1651},   {16300, -1653},   {16300, -1654},
    {16300, -1656},   {16300, -1657},   {16300, -1659},   {16300, -1661},   {16299, -1662},   {16299, -1664},
    {16299, -1665},   {16299, -1667},   {16299, -1668},   {16299, -1670},   {16299, -1672},   {16298, -1673},
    {16298, -1675},   {16298, -1676},   {16298, -1678},   {16298, -1679},   {16298, -1681},   {16297, -1682},
    {16297, -1684},   {16297, -1686},   {16297, -1687},   {16297, -1689},   {16297, -1690},   {16296, -1692},
    {16296, -1693},   {16296, -1695},   {16296, -1697},   {16296, -1698},   {16296, -1700},   {16295, -1701},
    {16295, -1703},   {16295, -1704},   {16295, -1706},   {16295, -1707},   {16295, -1709},   {16294, -1711},
    {16294, -1712},   {16294, -1714},   {16294, -1715},   {16294, -1717},   {16294, -1718},   {16293, -1720},
    {16293, -1722},   {16293, -1723},   {16293, -1725},   {16293, -1726},   {16293, -1728},   {16292, -1729},
    {16292, -1731},   {16292, -1732},   {16292, -1734},   {16292, -1736},   {16292, -1737},   {16291, -1739},
    {16291, -1740},   {16291, -1742},   {16291, -1743},   {16291, -1745},   {16291, -1747},   {16290, -1748},
    {16290, -1750},   {16290, -1751},   {16290, -1753},   {16290, -1754},   {16290, -1756},   {16289, -1757},
    {16289, -1759},   {16289, -1761},   {16289, -1762},   {16289, -1764},   {16289, -1765},   {16288, -1767},
    {16288, -1768},   {16288, -1770},   {16288, -1772},   {16288, -1773},   {16288, -1775},   {16287, -1776},
    {16287, -1778},   {16287, -1779},   {16287, -1781},   {16287, -1782},   {16287, -1784},   {16286, -1786},
    {16286, -1787},   {16286, -1789},   {16286, -1790},   {16286, -1792},   {16286, -1793},   {16285, -1795},
    {16285, -1797},   {16285, -1798},   {16285, -1800},   {16285, -1801},   {16285, -1803},   {16284, -1804},
    {16284, -1806},   {16284, -1807},   {16284, -1809},   {16284, -1811},   {16283, -1812},   {16283, -1814},
    {16283, -1815},   {16283, -1817},   {16283, -1818},   {16283, -1820},   {16282, -1821},   {16282, -1823},
    {16282, -1825},   {16282, -1826},   {16282, -1828},   {16282, -1829},   {16281, -1831},   {16281, -1832},
    {16281, -1834},   {16281, -1836},   {16281, -1837},   {16281, -1839},   {16280, -1840},   {16280, -1842},
    {16280, -1843},   {16280, -1845},   {16280, -1846},   {16279, -1848},   {16279, -1850},   {16279, -1851},
    {16279, -1853},   {16279, -1854},   {16279, -1856},   {16278, -1857},   {16278, -1859},   {16278, -1861},
    {16278, -1862},   {16278, -1864},   {16277, -1865},   {16277, -1867},   {16277, -1868},   {16277, -1870},
    {16277, -1871},   {16277, -1873},   {16276, -1875},   {16276, -1876},   {16276, -1878},   {16276, -1879},
    {16276, -1881},   {16276, -1882},   {16275, -1884},   {16275, -1885},   {16275, -1887},   {16275, -1889},
    {16275, -1890},   {16274, -1892},   {16274, -1893},   {16274, -1895},   {16274, -1896},   {16274, -1898},
    {16274, -1900},   {16273, -1901},   {16273, -1903},   {16273, -1904},   {16273, -1906},   {16273, -1907},
    {16272, -1909},   {16272, -1910},   {16272, -1912},   {16272, -1914},   {16272, -1915},   {16272, -1917},
    {16271, -1918},   {16271, -1920},   {16271, -1921},   {16271, -1923},   {16271, -1924},   {16270, -1926},
    {16270, -1928},   {16270, -1929},   {16270, -1931},   {16270, -1932},   {16269, -1934},   {16269, -1935},
    {16269, -1937},   {16269, -1939},   {16269, -1940},   {16269, -1942},   {16268, -1943},   {16268, -1945},
    {16268, -1946},   {16268, -1948},   {16268, -1949},   {16267, -1951},   {16267, -1953},   {16267, -1954},
    {16267, -1956},   {16267, -1957},   {16266, -1959},   {16266, -1960},   {16266, -1962},   {16266, -1963},
    {16266, -1965},   {16266, -1967},   {16265, -1968},   {16265, -1970},   {16265, -1971},   {16265, -1973},
    {16265, -1974},   {16264, -1976},   {16264, -1978},   {16264, -1979},   {16264, -1981},   {16264, -1982},
    {16263, -1984},   {16263, -1985},   {16263, -1987},   {16263, -1988},   {16263, -1990},   {16263, -1992},
    {16262, -1993},   {16262, -1995},   {16262, -1996},   {16262, -1998},   {16262, -1999},   {16261, -2001},
    {16261, -2002},   {16261, -2004},   {16261, -2006},   {16261, -2007},   {16260, -2009},   {16260, -2010},
    {16260, -2012},   {16260, -2013},   {16260, -2015},   {16259, -2016},   {16259, -2018},   {16259, -2020},
    {16259, -2021},   {16259, -2023},   {16258, -2024},   {16258, -2026},   {16258, -2027},   {16258, -2029},
    {16258, -2031},   {16257, -2032},   {16257, -2034},   {16257, -2035},   {16257, -2037},   {16257, -2038},
    {16257, -2040},   {16256, -2041},   {16256, -2043},   {16256, -2045},   {16256, -2046},   {16256, -2048},
    {16255, -2049},   {16255, -2051},   {16255, -2052},   {16255, -2054},   {16255, -2055},   {16254, -2057},
    {16254, -2059},   {16254, -2060},   {16254, -2062},   {16254, -2063},   {16253, -2065},   {16253, -2066},
    {16253, -2068},   {16253, -2069},   {16253, -2071},   {16252, -2073},   {16252, -2074},   {16252, -2076},
    {16252, -2077},   {16252, -2079},   {16251, -2080},   {16251, -2082},   {16251, -2084},   {16251, -2085},
    {16251, -2087},   {16250, -2088},   {16250, -2090},   {16250, -2091},   {16250, -2093},   {16250, -2094},
    {16249, -2096},   {16249, -2098},   {16249, -2099},   {16249, -2101},   {16249, -2102},   {16248, -2104},
    {16248, -2105},   {16248, -2107},   {16248, -2108},   {16248, -2110},   {16247, -2112},   {16247, -2113},
    {16247, -2115},   {16247, -2116},   {16247, -2118},   {16246, -2119},   {16246, -2121},   {16246, -2122},
    {16246, -2124},   {16246, -2126},   {16245, -2127},   {16245, -2129},   {16245, -2130},   {16245, -2132},
    {16245, -2133},   {16244, -2135},   {16244, -2136},   {16244, -2138},   {16244, -2140},   {16243, -2141},
    {16243, -2143},   {16243, -2144},   {16243, -2146},   {16243, -2147},   {16242, -2149},   {16242, -2150},
    {16242, -2152},   {16242, -2154},   {16242, -2155},   {16241, -2157},   {16241, -2158},   {16241, -2160},
    {16241, -2161},   {16241, -2163},   {16240, -2164},   {16240, -2166},   {16240, -2168},   {16240, -2169},
    {16240, -2171},   {16239, -2172},   {16239, -2174},   {16239, -2175},   {16239, -2177},   {16239, -2179},
    {16238, -2180},   {16238, -2182},   {16238, -2183},   {16238, -2185},   {16237, -2186},   {16237, -2188},
    {16237, -2189},   {16237, -2191},   {16237, -2193},   {16236, -2194},   {16236, -2196},   {16236, -2197},
    {16236, -2199},   {16236, -2200},   {16235, -2202},   {16235, -2203},   {16235, -2205},   {16235, -2207},
    {16235, -2208},   {16234, -2210},   {16234, -2211},   {16234, -2213},   {16234, -2214},   {16233, -2216},
    {16233, -2217},   {16233, -2219},   {16233, -2221},   {16233, -2222},   {16232, -2224},   {16232, -2225},
    {16232, -2227},   {16232, -2228},   {16232, -2230},   {16231, -2231},   {16231, -2233},   {16231, -2235},
    {16231, -2236},   {16230, -2238},   {16230, -2239},   {16230, -2241},   {16230, -2242},   {16230, -2244},
    {16229, -2245},   {16229, -2247},   {16229, -2249},   {16229, -2250},   {16229, -2252},   {16228, -2253},
    {16228, -2255},   {16228, -2256},   {16228, -2258},   {16227, -2259},   {16227, -2261},   {16227, -2263},
    {16227, -2264},   {16227, -2266},   {16226, -2267},   {16226, -2269},   {16226, -2270},   {16226, -2272},
    {16226, -2273},   {16225, -2275},   {16225, -2277},   {16225, -2278},   {16225, -2280},   {16224, -2281},
    {16224, -2283},   {16224, -2284},   {16224, -2286},   {16224, -2287},   {16223, -2289},   {16223, -2291},
    {16223, -2292},   {16223, -2294},   {16222, -2295},   {16222, -2297},   {16222, -2298},   {16222, -2300},
    {16222, -2301},   {16221, -2303},   {16221, -2305},   {16221, -2306},   {16221, -2308},   {16220, -2309},
    {16220, -2311},   {16220, -2312},   {16220, -2314},   {16220, -2315},   {16219, -2317},   {16219, -2319},
    {16219, -2320},   {16219, -2322},   {16218, -2323},   {16218, -2325},   {16218, -2326},   {16218, -2328},
    {16218, -2329},   {16217, -2331},   {16217, -2333},   {16217, -2334},   {16217, -2336},   {16216, -2337},
    {16216, -2339},   {16216, -2340},   {16216, -2342},   {16216, -2343},   {16215, -2345},   {16215, -2347},
    {16215, -2348},   {16215, -2350},   {16214, -2351},   {16214, -2353},   {16214, -2354},   {16214, -2356},
    {16214, -2357},   {16213, -2359},   {16213, -2361},   {16213, -2362},   {16213, -2364},   {16212, -2365},
    {16212, -2367},   {16212, -2368},   {16212, -2370},   {16211, -2371},   {16211, -2373},   {16211, -2375},
    {16211, -2376},   {16211, -2378},   {16210, -2379},   {16210, -2381},   {16210, -2382},   {16210, -2384},
    {16209, -2385},   {16209, -2387},   {16209, -2388},   {16209, -2390},   {16209, -2392},   {16208, -2393},
    {16208, -2395},   {16208, -2396},   {16208, -2398},   {16207, -2399},   {16207, -2401},   {16207, -2402},
    {16207, -2404},   {16206, -2406},   {16206, -2407},   {16206, -2409},   {16206, -2410},   {16206, -2412},
    {16205, -2413},   {16205, -2415},   {16205, -2416},   {16205, -2418},   {16204, -2420},   {16204, -2421},
    {16204, -2423},   {16204, -2424},   {16203, -2426},   {16203, -2427},   {16203, -2429},   {16203, -2430},
    {16202, -2432},   {16202, -2434},   {16202, -2435},   {16202, -2437},   {16202, -2438},   {16201, -2440},
    {16201, -2441},   {16201, -2443},   {16201, -2444},   {16200, -2446},   {16200, -2448},   {16200, -2449},
    {16200, -2451},   {16199, -2452},   {16199, -2454},   {16199, -2455},   {16199, -2457},   {16199, -2458},
    {16198, -2460},   {16198, -2462},   {16198, -2463},   {16198, -2465},   {16197, -2466},   {16197, -2468},
    {16197, -2469},   {16197, -2471},   {16196, -2472},   {16196, -2474},   {16196, -2475},   {16196, -2477},
    {16195, -2479},   {16195, -2480},   {16195, -2482},   {16195, -2483},   {16194, -2485},   {16194, -2486},
    {16194, -2488},   {16194, -2489},   {16194, -2491},   {16193, -2493},   {16193, -2494},   {16193, -2496},
    {16193, -2497},   {16192, -2499},   {16192, -2500},   {16192, -2502},   {16192, -2503},   {16191, -2505},
    {16191, -2507},   {16191, -2508},   {16191, -2510},   {16190, -2511},   {16190, -2513},   {16190, -2514},
    {16190, -2516},   {16189, -2517},   {16189, -2519},   {16189, -2521},   {16189, -2522},   {16188, -2524},
    {16188, -2525},   {16188, -2527},   {16188, -2528},   {16188, -2530},   {16187, -2531},   {16187, -2533},
    {16187, -2534},   {16187, -2536},   {16186, -2538},   {16186, -2539},   {16186, -2541},   {16186, -2542},
    {16185, -2544},   {16185, -2545},   {16185, -2547},   {16185, -2548},   {16184, -2550},   {16184, -2552},
    {16184, -2553},   {16184, -2555},   {16183, -2556},   {16183, -2558},   {16183, -2559},   {16183, -2561},
    {16182, -2562},   {16182, -2564},   {16182, -2566},   {16182, -2567},   {16181, -2569},   {16181, -2570},
    {16181, -2572},   {16181, -2573},   {16180, -2575},   {16180, -2576},   {16180, -2578},   {16180, -2579},
    {16179, -2581},   {16179, -2583},   {16179, -2584},   {16179, -2586},   {16178, -2587},   {16178, -2589},
    {16178, -2590},   {16178, -2592},   {16177, -2593},   {16177, -2595},   {16177, -2597},   {16177, -2598},
    {16176, -2600},   {16176, -2601},   {16176, -2603},   {16176, -2604},   {16175, -2606},   {16175, -2607},
    {16175, -2609},   {16175, -2610},   {16174, -2612},   {16174, -2614},   {16174, -2615},   {16174, -2617},
    {16173, -2618},   {16173, -2620},   {16173, -2621},   {16173, -2623},   {16172, -2624},   {16172, -2626},
    {16172, -2628},   {16172, -2629},   {16171, -2631},   {16171, -2632},   {16171, -2634},   {16171, -2635},
    {16170, -2637},   {16170, -2638},   {16170, -2640},   {16170, -2641},   {16169, -2643},   {16169, -2645},
    {16169, -2646},   {16169, -2648},   {16168, -2649},   {16168, -2651},   {16168, -2652},   {16168, -2654},
    {16167, -2655},   {16167, -2657},   {16167, -2659},   {16167, -2660},   {16166, -2662},   {16166, -2663},
    {16166, -2665},   {16166, -2666},   {16165, -2668},   {16165, -2669},   {16165, -2671},   {16165, -2672},
    {16164, -2674},   {16164, -2676},   {16164, -2677},   {16164, -2679},   {16163, -2680},   {16163, -2682},
    {16163, -2683},   {16163, -2685},   {16162, -2686},   {16162, -2688},   {16162, -2690},   {16161, -2691},
    {16161, -2693},   {16161, -2694},   {16161, -2696},   {16160, -2697},   {16160, -2699},   {16160, -2700},
    {16160, -2702},   {16159, -2703},   {16159, -2705},   {16159, -2707},   {16159, -2708},   {16158, -2710},
    {16158, -2711},   {16158, -2713},   {16158, -2714},   {16157, -2716},   {16157, -2717},   {16157, -2719},
    {16157, -2721},   {16156, -2722},   {16156, -2724},   {16156, -2725},   {16156, -2727},   {16155, -2728},
    {16155, -2730},   {16155, -2731},   {16154, -2733},   {16154, -2734},   {16154, -2736},   {16154, -2738},
    {16153, -2739},   {16153, -2741},   {16153, -2742},   {16153, -2744},   {16152, -2745},   {16152, -2747},
    {16152, -2748},   {16152, -2750},   {16151, -2752},   {16151, -2753},   {16151, -2755},   {16151, -2756},
    {16150, -2758},   {16150, -2759},   {16150, -2761},   {16149, -2762},   {16149, -2764},   {16149, -2765},
    {16149, -2767},   {16148, -2769},   {16148, -2770},   {16148, -2772},   {16148, -2773},   {16147, -2775},
    {16147, -2776},   {16147, -2778},   {16147, -2779},   {16146, -2781},   {16146, -2782},   {16146, -2784},
    {16145, -2786},   {16145, -2787},   {16145, -2789},   {16145, -2790},   {16144, -2792},   {16144, -2793},
    {16144, -2795},   {16144, -2796},   {16143, -2798},   {16143, -2799},   {16143, -2801},   {16143, -2803},
    {16142, -2804},   {16142, -2806},   {16142, -2807},   {16141, -2809},   {16141, -2810},   {16141, -2812},
    {16141, -2813},   {16140, -2815},   {16140, -2817},   {16140, -2818},   {16140, -2820},   {16139, -2821},
    {16139, -2823},   {16139, -2824},   {16138, -2826},   {16138, -2827},   {16138, -2829},   {16138, -2830},
    {16137, -2832},   {16137, -2834},   {16137, -2835},   {16137, -2837},   {16136, -2838},   {16136, -2840},
    {16136, -2841},   {16135, -2843},   {16135, -2844},   {16135, -2846},   {16135, -2847},   {16134, -2849},
    {16134, -2851},   {16134, -2852},   {16134, -2854},   {16133, -2855},   {16133, -2857},   {16133, -2858},
    {16132, -2860},   {16132, -2861},   {16132, -2863},   {16132, -2864},   {16131, -2866},   {16131, -2868},
    {16131, -2869},   {16131, -2871},   {16130, -2872},   {16130, -2874},   {16130, -2875},   {16129, -2877},
    {16129, -2878},   {16129, -2880},   {16129, -2881},   {16128, -2883},   {16128, -2885},   {16128, -2886},
    {16128, -2888},   {16127, -2889},   {16127, -2891},   {16127, -2892},   {16126, -2894},   {16126, -2895},
    {16126, -2897},   {16126, -2898},   {16125, -2900},   {16125, -2902},   {16125, -2903},   {16124, -2905},
    {16124, -2906},   {16124, -2908},   {16124, -2909},   {16123, -2911},   {16123, -2912},   {16123, -2914},
    {16123, -2915},   {16122, -2917},   {16122, -2919},   {16122, -2920},   {16121, -2922},   {16121, -2923},
    {16121, -2925},   {16121, -2926},   {16120, -2928},   {16120, -2929},   {16120, -2931},   {16119, -2932},
    {16119, -2934},   {16119, -2936},   {16119, -2937},   {16118, -2939},   {16118, -2940},   {16118, -2942},
    {16117, -2943},   {16117, -2945},   {16117, -2946},   {16117, -2948},   {16116, -2949},   {16116, -2951},
    {16116, -2953},   {16115, -2954},   {16115, -2956},   {16115, -2957},   {16115, -2959},   {16114, -2960},
    {16114, -2962},   {16114, -2963},   {16113, -2965},   {16113, -2966},   {16113, -2968},   {16113, -2970},
    {16112, -2971},   {16112, -2973},   {16112, -2974},   {16111, -2976},   {16111, -2977},   {16111, -2979},
    {16111, -2980},   {16110, -2982},   {16110, -2983},   {16110, -2985},   {16109, -2987},   {16109, -2988},
    {16109, -2990},   {16109, -2991},   {16108, -2993},   {16108, -2994},   {16108, -2996},   {16107, -2997},
    {16107, -2999},   {16107, -3000},   {16107, -3002},   {16106, -3004},   {16106, -3005},   {16106, -3007},
    {16105, -3008},   {16105, -3010},   {16105, -3011},   {16105, -3013},   {16104, -3014},   {16104, -3016},
    {16104, -3017},   {16103, -3019},   {16103, -3021},   {16103, -3022},   {16103, -3024},   {16102, -3025},
    {16102, -3027},   {16102, -3028},   {16101, -3030},   {16101, -3031},   {16101, -3033},   {16101, -3034},
    {16100, -3036},   {16100, -3038},   {16100, -3039},   {16099, -3041},   {16099, -3042},   {16099, -3044},
    {16099, -3045},   {16098, -3047},   {16098, -3048},   {16098, -3050},   {16097, -3051},   {16097, -3053},
    {16097, -3055},   {16096, -3056},   {16096, -3058},   {16096, -3059},   {16096, -3061},   {16095, -3062},
    {16095, -3064},   {16095, -3065},   {16094, -3067},   {16094, -3068},   {16094, -3070},   {16094, -3071},
    {16093, -3073},   {16093, -3075},   {16093, -3076},   {16092, -3078},   {16092, -3079},   {16092, -3081},
    {16091, -3082},   {16091, -3084},   {16091, -3085},   {16091, -3087},   {16090, -3088},   {16090, -3090},
    {16090, -3092},   {16089, -3093},   {16089, -3095},   {16089, -3096},   {16088, -3098},   {16088, -3099},
    {16088, -3101},   {16088, -3102},   {16087, -3104},   {16087, -3105},   {16087, -3107},   {16086, -3108},
    {16086, -3110},   {16086, -3112},   {16086, -3113},   {16085, -3115},   {16085, -3116},   {16085, -3118},
    {16084, -3119},   {16084, -3121},   {16084, -3122},   {16083, -3124},   {16083, -3125},   {16083, -3127},
    {16083, -3129},   {16082, -3130},   {16082, -3132},   {16082, -3133},   {16081, -3135},   {16081, -3136},
    {16081, -3138},   {16080, -3139},   {16080, -3141},   {16080, -3142},   {16080, -3144},   {16079, -3146},
    {16079, -3147},   {16079, -3149},   {16078, -3150},   {16078, -3152},   {16078, -3153},   {16077, -3155},
    {16077, -3156},   {16077, -3158},   {16076, -3159},   {16076, -3161},   {16076, -3162},   {16076, -3164},
    {16075, -3166},   {16075, -3167},   {16075, -3169},   {16074, -3170},   {16074, -3172},   {16074, -3173},
    {16073, -3175},   {16073, -3176},   {16073, -3178},   {16073, -3179},   {16072, -3181},   {16072, -3182},
    {16072, -3184},   {16071, -3186},   {16071, -3187},   {16071, -3189},   {16070, -3190},   {16070, -3192},
    {16070, -3193},   {16069, -3195},   {16069, -3196},   {16069, -3198},   {16069, -3199},   {16068, -3201},
    {16068, -3203},   {16068, -3204},   {16067, -3206},   {16067, -3207},   {16067, -3209},   {16066, -3210},
    {16066, -3212},   {16066, -3213},   {16065, -3215},   {16065, -3216},   {16065, -3218},   {16065, -3219},
    {16064, -3221},   {16064, -3223},   {16064, -3224},   {16063, -3226},   {16063, -3227},   {16063, -3229},
    {16062, -3230},   {16062, -3232},   {16062, -3233},   {16061, -3235},   {16061, -3236},   {16061, -3238},
    {16061, -3239},   {16060, -3241},   {16060, -3243},   {16060, -3244},   {16059, -3246},   {16059, -3247},
    {16059, -3249},   {16058, -3250},   {16058, -3252},   {16058, -3253},   {16057, -3255},   {16057, -3256},
    {16057, -3258},   {16056, -3260},   {16056, -3261},   {16056, -3263},   {16056, -3264},   {16055, -3266},
    {16055, -3267},   {16055, -3269},   {16054, -3270},   {16054, -3272},   {16054, -3273},   {16053, -3275},
    {16053, -3276},   {16053, -3278},   {16052, -3280},   {16052, -3281},   {16052, -3283},   {16051, -3284},
    {16051, -3286},   {16051, -3287},   {16051, -3289},   {16050, -3290},   {16050, -3292},   {16050, -3293},
    {16049, -3295},   {16049, -3296},   {16049, -3298},   {16048, -3300},   {16048, -3301},   {16048, -3303},
    {16047, -3304},   {16047, -3306},   {16047, -3307},   {16046, -3309},   {16046, -3310},   {16046, -3312},
    {16045, -3313},   {16045, -3315},   {16045, -3316},   {16045, -3318},   {16044, -3320},   {16044, -3321},
    {16044, -3323},   {16043, -3324},   {16043, -3326},   {16043, -3327},   {16042, -3329},   {16042, -3330},
    {16042, -3332},   {16041, -3333},   {16041, -3335},   {16041, -3336},   {16040, -3338},   {16040, -3340},
    {16040, -3341},   {16039, -3343},   {16039, -3344},   {16039, -3346},   {16038, -3347},   {16038, -3349},
    {16038, -3350},   {16037, -3352},   {16037, -3353},   {16037, -3355},   {16037, -3356},   {16036, -3358},
    {16036, -3359},   {16036, -3361},   {16035, -3363},   {16035, -3364},   {16035, -3366},   {16034, -3367},
    {16034, -3369},   {16034, -3370},   {16033, -3372},   {16033, -3373},   {16033, -3375},   {16032, -3376},
    {16032, -3378},   {16032, -3379},   {16031, -3381},   {16031, -3383},   {16031, -3384},   {16030, -3386},
    {16030, -3387},   {16030, -3389},   {16029, -3390},   {16029, -3392},   {16029, -3393},   {16028, -3395},
    {16028, -3396},   {16028, -3398},   {16027, -3399},   {16027, -3401},   {16027, -3403},   {16026, -3404},
    {16026, -3406},   {16026, -3407},   {16025, -3409},   {16025, -3410},   {16025, -3412},   {16025, -3413},
    {16024, -3415},   {16024, -3416},   {16024, -3418},   {16023, -3419},   {16023, -3421},   {16023, -3423},
    {16022, -3424},   {16022, -3426},   {16022, -3427},   {16021, -3429},   {16021, -3430},   {16021, -3432},
    {16020, -3433},   {16020, -3435},   {16020, -3436},   {16019, -3438},   {16019, -3439},   {16019, -3441},
    {16018, -3442},   {16018, -3444},   {16018, -3446},   {16017, -3447},   {16017, -3449},   {16017, -3450},
    {16016, -3452},   {16016, -3453},   {16016, -3455},   {16015, -3456},   {16015, -3458},   {16015, -3459},
    {16014, -3461},   {16014, -3462},   {16014, -3464},   {16013, -3466},   {16013, -3467},   {16013, -3469},
    {16012, -3470},   {16012, -3472},   {16012, -3473},   {16011, -3475},   {16011, -3476},   {16011, -3478},
    {16010, -3479},   {16010, -3481},   {16010, -3482},   {16009, -3484},   {16009, -3485},   {16009, -3487},
    {16008, -3489},   {16008, -3490},   {16008, -3492},   {16007, -3493},   {16007, -3495},   {16007, -3496},
    {16006, -3498},   {16006, -3499},   {16006, -3501},   {16005, -3502},   {16005, -3504},   {16005, -3505},
    {16004, -3507},   {16004, -3508},   {16004, -3510},   {16003, -3512},   {16003, -3513},   {16003, -3515},
    {16002, -3516},   {16002, -3518},   {16002, -3519},   {16001, -3521},   {16001, -3522},   {16001, -3524},
    {16000, -3525},   {16000, -3527},   {16000, -3528},   {15999, -3530},   {15999, -3531},   {15999, -3533},
    {15998, -3535},   {15998, -3536},   {15998, -3538},   {15997, -3539},   {15997, -3541},   {15997, -3542},
    {15996, -3544},   {15996, -3545},   {15995, -3547},   {15995, -3548},   {15995, -3550},   {15994, -3551},
    {15994, -3553},   {15994, -3554},   {15993, -3556},   {15993, -3558},   {15993, -3559},   {15992, -3561},
    {15992, -3562},   {15992, -3564},   {15991, -3565},   {15991, -3567},   {15991, -3568},   {15990, -3570},
    {15990, -3571},   {15990, -3573},   {15989, -3574},   {15989, -3576},   {15989, -3577},   {15988, -3579},
    {15988, -3581},   {15988, -3582},   {15987, -3584},   {15987, -3585},   {15987, -3587},   {15986, -3588},
    {15986, -3590},   {15986, -3591},   {15985, -3593},   {15985, -3594},   {15985, -3596},   {15984, -3597},
    {15984, -3599},   {15983, -3600},   {15983, -3602},   {15983, -3604},   {15982, -3605},   {15982, -3607},
    {15982, -3608},   {15981, -3610},   {15981, -3611},   {15981, -3613},   {15980, -3614},   {15980, -3616},
    {15980, -3617},   {15979, -3619},   {15979, -3620},   {15979, -3622},   {15978, -3623},   {15978, -3625},
    {15978, -3627},   {15977, -3628},   {15977, -3630},   {15977, -3631},   {15976, -3633},   {15976, -3634},
    {15976, -3636},   {15975, -3637},   {15975, -3639},   {15974, -3640},   {15974, -3642},   {15974, -3643},
    {15973, -3645},   {15973, -3646},   {15973, -3648},   {15972, -3650},   {15972, -3651},   {15972, -3653},
    {15971, -3654},   {15971, -3656},   {15971, -3657},   {15970, -3659},   {15970, -3660},   {15970, -3662},
    {15969, -3663},   {15969, -3665},   {15969, -3666},   {15968, -3668},   {15968, -3669},   {15967, -3671},
    {15967, -3672},   {15967, -3674},   {15966, -3676},   {15966, -3677},   {15966, -3679},   {15965, -3680},
    {15965, -3682},   {15965, -3683},   {15964, -3685},   {15964, -3686},   {15964, -3688},   {15963, -3689},
    {15963, -3691},   {15963, -3692},   {15962, -3694},   {15962, -3695},   {15961, -3697},   {15961, -3698},
    {15961, -3700},   {15960, -3702},   {15960, -3703},   {15960, -3705},   {15959, -3706},   {15959, -3708},
    {15959, -3709},   {15958, -3711},   {15958, -3712},   {15958, -3714},   {15957, -3715},   {15957, -3717},
    {15956, -3718},   {15956, -3720},   {15956, -3721},   {15955, -3723},   {15955, -3724},   {15955, -3726},
    {15954, -3728},   {15954, -3729},   {15954, -3731},   {15953, -3732},   {15953, -3734},   {15953, -3735},
    {15952, -3737},   {15952, -3738},   {15951, -3740},   {15951, -3741},   {15951, -3743},   {15950, -3744},
    {15950, -3746},   {15950, -3747},   {15949, -3749},   {15949, -3750},   {15949, -3752},   {15948, -3754},
    {15948, -3755},   {15948, -3757},   {15947, -3758},   {15947, -3760},   {15946, -3761},   {15946, -3763},
    {15946, -3764},   {15945, -3766},   {15945, -3767},   {15945, -3769},   {15944, -3770},   {15944, -3772},
    {15944, -3773},   {15943, -3775},   {15943, -3776},   {15942, -3778},   {15942, -3780},   {15942, -3781},
    {15941, -3783},   {15941, -3784},   {15941, -3786},   {15940, -3787},   {15940, -3789},   {15940, -3790},
    {15939, -3792},   {15939, -3793},   {15938, -3795},   {15938, -3796},   {15938, -3798},   {15937, -3799},
    {15937, -3801},   {15937, -3802},   {15936, -3804},   {15936, -3806},   {15936, -3807},   {15935, -3809},
    {15935, -3810},   {15934, -3812},   {15934, -3813},   {15934, -3815},   {15933, -3816},   {15933, -3818},
    {15933, -3819},   {15932, -3821},   {15932, -3822},   {15932, -3824},   {15931, -3825},   {15931, -3827},
    {15930, -3828},   {15930, -3830},   {15930, -3831},   {15929, -3833},   {15929, -3835},   {15929, -3836},
    {15928, -3838},   {15928, -3839},   {15927, -3841},   {15927, -3842},   {15927, -3844},   {15926, -3845},
    {15926, -3847},   {15926, -3848},   {15925, -3850},   {15925, -3851},   {15925, -3853},   {15924, -3854},
    {15924, -3856},   {15923, -3857},   {15923, -3859},   {15923, -3861},   {15922, -3862},   {15922, -3864},
    {15922, -3865},   {15921, -3867},   {15921, -3868},   {15920, -3870},   {15920, -3871},   {15920, -3873},
    {15919, -3874},   {15919, -3876},   {15919, -3877},   {15918, -3879},   {15918, -3880},   {15917, -3882},
    {15917, -3883},   {15917, -3885},   {15916, -3886},   {15916, -3888},   {15916, -3889},   {15915, -3891},
    {15915, -3893},   {15915, -3894},   {15914, -3896},   {15914, -3897},   {15913, -3899},   {15913, -3900},
    {15913, -3902},   {15912, -3903},   {15912, -3905},   {15912, -3906},   {15911, -3908},   {15911, -3909},
    {15910, -3911},   {15910, -3912},   {15910, -3914},   {15909, -3915},   {15909, -3917},   {15909, -3918},
    {15908, -3920},   {15908, -3922},   {15907, -3923},   {15907, -3925},   {15907, -3926},   {15906, -3928},
    {15906, -3929},   {15906, -3931},   {15905, -3932},   {15905, -3934},   {15904, -3935},   {15904, -3937},
    {15904, -3938},   {15903, -3940},   {15903, -3941},   {15902, -3943},   {15902, -3944},   {15902, -3946},
    {15901, -3947},   {15901, -3949},   {15901, -3951},   {15900, -3952},   {15900, -3954},   {15899, -3955},
    {15899, -3957},   {15899, -3958},   {15898, -3960},   {15898, -3961},   {15898, -3963},   {15897, -3964},
    {15897, -3966},   {15896, -3967},   {15896, -3969},   {15896, -3970},   {15895, -3972},   {15895, -3973},
    {15895, -3975},   {15894, -3976},   {15894, -3978},   {15893, -3979},   {15893, -3981},   {15893, -3983},
    {15892, -3984},   {15892, -3986},   {15891, -3987},   {15891, -3989},   {15891, -3990},   {15890, -3992},
    {15890, -3993},   {15890, -3995},   {15889, -3996},   {15889, -3998},   {15888, -3999},   {15888, -4001},
    {15888, -4002},   {15887, -4004},   {15887, -4005},   {15886, -4007},   {15886, -4008},   {15886, -4010},
    {15885, -4011},   {15885, -4013},   {15885, -4015},   {15884, -4016},   {15884, -4018},   {15883, -4019},
    {15883, -4021},   {15883, -4022},   {15882, -4024},   {15882, -4025},   {15881, -4027},   {15881, -4028},
    {15881, -4030},   {15880, -4031},   {15880, -4033},   {15880, -4034},   {15879, -4036},   {15879, -4037},
    {15878, -4039},   {15878, -4040},   {15878, -4042},   {15877, -4043},   {15877, -4045},   {15876, -4046},
    {15876, -4048},   {15876, -4050},   {15875, -4051},   {15875, -4053},   {15875, -4054},   {15874, -4056},
    {15874, -4057},   {15873, -4059},   {15873, -4060},   {15873, -4062},   {15872, -4063},   {15872, -4065},
    {15871, -4066},   {15871, -4068},   {15871, -4069},   {15870, -4071},   {15870, -4072},   {15869, -4074},
    {15869, -4075},   {15869, -4077},   {15868, -4078},   {15868, -4080},   {15867, -4081},   {15867, -4083},
    {15867, -4085},   {15866, -4086},   {15866, -4088},   {15866, -4089},   {15865, -4091},   {15865, -4092},
    {15864, -4094},   {15864, -4095},   {15864, -4097},   {15863, -4098},   {15863, -4100},   {15862, -4101},
    {15862, -4103},   {15862, -4104},   {15861, -4106},   {15861, -4107},   {15860, -4109},   {15860, -4110},
    {15860, -4112},   {15859, -4113},   {15859, -4115},   {15858, -4116},   {15858, -4118},   {15858, -4119},
    {15857, -4121},   {15857, -4123},   {15856, -4124},   {15856, -4126},   {15856, -4127},   {15855, -4129},
    {15855, -4130},   {15854, -4132},   {15854, -4133},   {15854, -4135},   {15853, -4136},   {15853, -4138},
    {15853, -4139},   {15852, -4141},   {15852, -4142},   {15851, -4144},   {15851, -4145},   {15851, -4147},
    {15850, -4148},   {15850, -4150},   {15849, -4151},   {15849, -4153},   {15849, -4154},   {15848, -4156},
    {15848, -4157},   {15847, -4159},   {15847, -4161},   {15847, -4162},   {15846, -4164},   {15846, -4165},
    {15845, -4167},   {15845, -4168},   {15845, -4170},   {15844, -4171},   {15844, -4173},   {15843, -4174},
    {15843, -4176},   {15843, -4177},   {15842, -4179},   {15842, -4180},   {15841, -4182},   {15841, -4183},
    {15841, -4185},   {15840, -4186},   {15840, -4188},   {15839, -4189},   {15839, -4191},   {15839, -4192},
    {15838, -4194},   {15838, -4195},   {15837, -4197},   {15837, -4198},   {15837, -4200},   {15836, -4202},
    {15836, -4203},   {15835, -4205},   {15835, -4206},   {15835, -4208},   {15834, -4209},   {15834, -4211},
    {15833, -4212},   {15833, -4214},   {15832, -4215},   {15832, -4217},   {15832, -4218},   {15831, -4220},
    {15831, -4221},   {15830, -4223},   {15830, -4224},   {15830, -4226},   {15829, -4227},   {15829, -4229},
    {15828, -4230},   {15828, -4232},   {15828, -4233},   {15827, -4235},   {15827, -4236},   {15826, -4238},
    {15826, -4239},   {15826, -4241},   {15825, -4243},   {15825, -4244},   {15824, -4246},   {15824, -4247},
    {15824, -4249},   {15823, -4250},   {15823, -4252},   {15822, -4253},   {15822, -4255},   {15822, -4256},
    {15821, -4258},   {15821, -4259},   {15820, -4261},   {15820, -4262},   {15819, -4264},   {15819, -4265},
    {15819, -4267},   {15818, -4268},   {15818, -4270},   {15817, -4271},   {15817, -4273},   {15817, -4274},
    {15816, -4276},   {15816, -4277},   {15815, -4279},   {15815, -4280},   {15815, -4282},   {15814, -4283},
    {15814, -4285},   {15813, -4286},   {15813, -4288},   {15813, -4290},   {15812, -4291},   {15812, -4293},
    {15811, -4294},   {15811, -4296},   {15810, -4297},   {15810, -4299},   {15810, -4300},   {15809, -4302},
    {15809, -4303},   {15808, -4305},   {15808, -4306},   {15808, -4308},   {15807, -4309},   {15807, -4311},
    {15806, -4312},   {15806, -4314},   {15805, -4315},   {15805, -4317},   {15805, -4318},   {15804, -4320},
    {15804, -4321},   {15803, -4323},   {15803, -4324},   {15803, -4326},   {15802, -4327},   {15802, -4329},
    {15801, -4330},   {15801, -4332},   {15801, -4333},   {15800, -4335},   {15800, -4337},   {15799, -4338},
    {15799, -4340},   {15798, -4341},   {15798, -4343},   {15798, -4344},   {15797, -4346},   {15797, -4347},
    {15796, -4349},   {15796, -4350},   {15796, -4352},   {15795, -4353},   {15795, -4355},   {15794, -4356},
    {15794, -4358},   {15793, -4359},   {15793, -4361},   {15793, -4362},   {15792, -4364},   {15792, -4365},
    {15791, -4367},   {15791, -4368},   {15791, -4370},   {15790, -4371},   {15790, -4373},   {15789, -4374},
    {15789, -4376},   {15788, -4377},   {15788, -4379},   {15788, -4380},   {15787, -4382},   {15787, -4383},
    {15786, -4385},   {15786, -4386},   {15785, -4388},   {15785, -4389},   {15785, -4391},   {15784, -4393},
    {15784, -4394},   {15783, -4396},   {15783, -4397},   {15783, -4399},   {15782, -4400},   {15782, -4402},
    {15781, -4403},   {15781, -4405},   {15780, -4406},   {15780, -4408},   {15780, -4409},   {15779, -4411},
    {15779, -4412},   {15778, -4414},   {15778, -4415},   {15777, -4417},   {15777, -4418},   {15777, -4420},
    {15776, -4421},   {15776, -4423},   {15775, -4424},   {15775, -4426},   {15774, -4427},   {15774, -4429},
    {15774, -4430},   {15773, -4432},   {15773, -4433},   {15772, -4435},   {15772, -4436},   {15772, -4438},
    {15771, -4439},   {15771, -4441},   {15770, -4442},   {15770, -4444},   {15769, -4445},   {15769, -4447},
    {15769, -4448},   {15768, -4450},   {15768, -4452},   {15767, -4453},   {15767, -4455},   {15766, -4456},
    {15766, -4458},   {15766, -4459},   {15765, -4461},   {15765, -4462},   {15764, -4464},   {15764, -4465},
    {15763, -4467},   {15763, -4468},   {15763, -4470},   {15762, -4471},   {15762, -4473},   {15761, -4474},
    {15761, -4476},   {15760, -4477},   {15760, -4479},   {15760, -4480},   {15759, -4482},   {15759, -4483},
    {15758, -4485},   {15758, -4486},   {15757, -4488},   {15757, -4489},   {15757, -4491},   {15756, -4492},
    {15756, -4494},   {15755, -4495},   {15755, -4497},   {15754, -4498},   {15754, -4500},   {15754, -4501},
    {15753, -4503},   {15753, -4504},   {15752, -4506},   {15752, -4507},   {15751, -4509},   {15751, -4510},
    {15750, -4512},   {15750, -4513},   {15750, -4515},   {15749, -4516},   {15749, -4518},   {15748, -4519},
    {15748, -4521},   {15747, -4523},   {15747, -4524},   {15747, -4526},   {15746, -4527},   {15746, -4529},
    {15745, -4530},   {15745, -4532},   {15744, -4533},   {15744, -4535},   {15744, -4536},   {15743, -4538},
    {15743, -4539},   {15742, -4541},   {15742, -4542},   {15741, -4544},   {15741, -4545},   {15740, -4547},
    {15740, -4548},   {15740, -4550},   {15739, -4551},   {15739, -4553},   {15738, -4554},   {15738, -4556},
    {15737, -4557},   {15737, -4559},   {15737, -4560},   {15736, -4562},   {15736, -4563},   {15735, -4565},
    {15735, -4566},   {15734, -4568},   {15734, -4569},   {15734, -4571},   {15733, -4572},   {15733, -4574},
    {15732, -4575},   {15732, -4577},   {15731, -4578},   {15731, -4580},   {15730, -4581},   {15730, -4583},
    {15730, -4584},   {15729, -4586},   {15729, -4587},   {15728, -4589},   {15728, -4590},   {15727, -4592},
    {15727, -4593},   {15726, -4595},   {15726, -4596},   {15726, -4598},   {15725, -4599},   {15725, -4601},
    {15724, -4602},   {15724, -4604},   {15723, -4605},   {15723, -4607},   {15723, -4609},   {15722, -4610},
    {15722, -4612},   {15721, -4613},   {15721, -4615},   {15720, -4616},   {15720, -4618},   {15719, -4619},
    {15719, -4621},   {15719, -4622},   {15718, -4624},   {15718, -4625},   {15717, -4627},   {15717, -4628},
    {15716, -4630},   {15716, -4631},   {15715, -4633},   {15715, -4634},   {15715, -4636},   {15714, -4637},
    {15714, -4639},   {15713, -4640},   {15713, -4642},   {15712, -4643},   {15712, -4645},   {15711, -4646},
    {15711, -4648},   {15711, -4649},   {15710, -4651},   {15710, -4652},   {15709, -4654},   {15709, -4655},
    {15708, -4657},   {15708, -4658},   {15707, -4660},   {15707, -4661},   {15707, -4663},   {15706, -4664},
    {15706, -4666},   {15705, -4667},   {15705, -4669},   {15704, -4670},   {15704, -4672},   {15703, -4673},
    {15703, -4675},   {15702, -4676},   {15702, -4678},   {15702, -4679},   {15701, -4681},   {15701, -4682},
    {15700, -4684},   {15700, -4685},   {15699, -4687},   {15699, -4688},   {15698, -4690},   {15698, -4691},
    {15698, -4693},   {15697, -4694},   {15697, -4696},   {15696, -4697},   {15696, -4699},   {15695, -4700},
    {15695, -4702},   {15694, -4703},   {15694, -4705},   {15693, -4706},   {15693, -4708},   {15693, -4709},
    {15692, -4711},   {15692, -4712},   {15691, -4714},   {15691, -4715},   {15690, -4717},   {15690, -4718},
    {15689, -4720},   {15689, -4721},   {15689, -4723},   {15688, -4724},   {15688, -4726},   {15687, -4727},
    {15687, -4729},   {15686, -4730},   {15686, -4732},   {15685, -4733},   {15685, -4735},   {15684, -4736},
    {15684, -4738},   {15684, -4739},   {15683, -4741},   {15683, -4742},   {15682, -4744},   {15682, -4746},
    {15681, -4747},   {15681, -4749},   {15680, -4750},   {15680, -4752},   {15679, -4753},   {15679, -4755},
    {15679, -4756},   {15678, -4758},   {15678, -4759},   {15677, -4761},   {15677, -4762},   {15676, -4764},
    {15676, -4765},   {15675, -4767},   {15675, -4768},   {15674, -4770},   {15674, -4771},   {15673, -4773},
    {15673, -4774},   {15673, -4776},   {15672, -4777},   {15672, -4779},   {15671, -4780},   {15671, -4782},
    {15670, -4783},   {15670, -4785},   {15669, -4786},   {15669, -4788},   {15668, -4789},   {15668, -4791},
    {15668, -4792},   {15667, -4794},   {15667, -4795},   {15666, -4797},   {15666, -4798},   {15665, -4800},
    {15665, -4801},   {15664, -4803},   {15664, -4804},   {15663, -4806},   {15663, -4807},   {15662, -4809},
    {15662, -4810},   {15662, -4812},   {15661, -4813},   {15661, -4815},   {15660, -4816},   {15660, -4818},
    {15659, -4819},   {15659, -4821},   {15658, -4822},   {15658, -4824},   {15657, -4825},   {15657, -4827},
    {15656, -4828},   {15656, -4830},   {15656, -4831},   {15655, -4833},   {15655, -4834},   {15654, -4836},
    {15654, -4837},   {15653, -4839},   {15653, -4840},   {15652, -4842},   {15652, -4843},   {15651, -4845},
    {15651, -4846},   {15650, -4848},   {15650, -4849},   {15649, -4851},   {15649, -4852},   {15649, -4854},
    {15648, -4855},   {15648, -4857},   {15647, -4858},   {15647, -4860},   {15646, -4861},   {15646, -4863},
    {15645, -4864},   {15645, -4866},   {15644, -4867},   {15644, -4869},   {15643, -4870},   {15643, -4872},
    {15643, -4873},   {15642, -4875},   {15642, -4876},   {15641, -4878},   {15641, -4879},   {15640, -4881},
    {15640, -4882},   {15639, -4884},   {15639, -4885},   {15638, -4887},   {15638, -4888},   {15637, -4890},
    {15637, -4891},   {15636, -4893},   {15636, -4894},   {15635, -4896},   {15635, -4897},   {15635, -4899},
    {15634, -4900},   {15634, -4902},   {15633, -4903},   {15633, -4905},   {15632, -4906},   {15632, -4908},
    {15631, -4909},   {15631, -4911},   {15630, -4912},   {15630, -4914},   {15629, -4915},   {15629, -4917},
    {15628, -4918},   {15628, -4920},   {15627, -4921},   {15627, -4923},   {15627, -4924},   {15626, -4926},
    {15626, -4927},   {15625, -4929},   {15625, -4930},   {15624, -4932},   {15624, -4933},   {15623, -4935},
    {15623, -4936},   {15622, -4938},   {15622, -4939},   {15621, -4941},   {15621, -4942},   {15620, -4944},
    {15620, -4945},   {15619, -4947},   {15619, -4948},   {15618, -4950},   {15618, -4951},   {15618, -4953},
    {15617, -4954},   {15617, -4956},   {15616, -4957},   {15616, -4959},   {15615, -4960},   {15615, -4962},
    {15614, -4963},   {15614, -4965},   {15613, -4966},   {15613, -4968},   {15612, -4969},   {15612, -4971},
    {15611, -4972},   {15611, -4974},   {15610, -4975},   {15610, -4977},   {15609, -4978},   {15609, -4980},
    {15608, -4981},   {15608, -4982},   {15608, -4984},   {15607, -4985},   {15607, -4987},   {15606, -4988},
    {15606, -4990},   {15605, -4991},   {15605, -4993},   {15604, -4994},   {15604, -4996},   {15603, -4997},
    {15603, -4999},   {15602, -5000},   {15602, -5002},   {15601, -5003},   {15601, -5005},   {15600, -5006},
    {15600, -5008},   {15599, -5009},   {15599, -5011},   {15598, -5012},   {15598, -5014},   {15597, -5015},
    {15597, -5017},   {15597, -5018},   {15596, -5020},   {15596, -5021},   {15595, -5023},   {15595, -5024},
    {15594, -5026},   {15594, -5027},   {15593, -5029},   {15593, -5030},   {15592, -5032},   {15592, -5033},
    {15591, -5035},   {15591, -5036},   {15590, -5038},   {15590, -5039},   {15589, -5041},   {15589, -5042},
    {15588, -5044},   {15588, -5045},   {15587, -5047},   {15587, -5048},   {15586, -5050},   {15586, -5051},
    {15585, -5053},   {15585, -5054},   {15584, -5056},   {15584, -5057},   {15583, -5059},   {15583, -5060},
    {15582, -5062},   {15582, -5063},   {15582, -5065},   {15581, -5066},   {15581, -5068},   {15580, -5069},
    {15580, -5071},   {15579, -5072},   {15579, -5074},   {15578, -5075},   {15578, -5077},   {15577, -5078},
    {15577, -5080},   {15576, -5081},   {15576, -5083},   {15575, -5084},   {15575, -5086},   {15574, -5087},
    {15574, -5089},   {15573, -5090},   {15573, -5092},   {15572, -5093},   {15572, -5095},   {15571, -5096},
    {15571, -5098},   {15570, -5099},   {15570, -5101},   {15569, -5102},   {15569, -5104},   {15568, -5105},
    {15568, -5107},   {15567, -5108},   {15567, -5110},   {15566, -5111},   {15566, -5113},   {15565, -5114},
    {15565, -5115},   {15564, -5117},   {15564, -5118},   {15563, -5120},   {15563, -5121},   {15562, -5123},
    {15562, -5124},   {15561, -5126},   {15561, -5127},   {15561, -5129},   {15560, -5130},   {15560, -5132},
    {15559, -5133},   {15559, -5135},   {15558, -5136},   {15558, -5138},   {15557, -5139},   {15557, -5141},
    {15556, -5142},   {15556, -5144},   {15555, -5145},   {15555, -5147},   {15554, -5148},   {15554, -5150},
    {15553, -5151},   {15553, -5153},   {15552, -5154},   {15552, -5156},   {15551, -5157},   {15551, -5159},
    {15550, -5160},   {15550, -5162},   {15549, -5163},   {15549, -5165},   {15548, -5166},   {15548, -5168},
    {15547, -5169},   {15547, -5171},   {15546, -5172},   {15546, -5174},   {15545, -5175},   {15545, -5177},
    {15544, -5178},   {15544, -5180},   {15543, -5181},   {15543, -5183},   {15542, -5184},   {15542, -5186},
    {15541, -5187},   {15541, -5189},   {15540, -5190},   {15540, -5192},   {15539, -5193},   {15539, -5195},
    {15538, -5196},   {15538, -5197},   {15537, -5199},   {15537, -5200},   {15536, -5202},   {15536, -5203},
    {15535, -5205},   {15535, -5206},   {15534, -5208},   {15534, -5209},   {15533, -5211},   {15533, -5212},
    {15532, -5214},   {15532, -5215},   {15531, -5217},   {15531, -5218},   {15530, -5220},   {15530, -5221},
    {15529, -5223},   {15529, -5224},   {15528, -5226},   {15528, -5227},   {15527, -5229},   {15527, -5230},
    {15526, -5232},   {15526, -5233},   {15525, -5235},   {15525, -5236},   {15524, -5238},   {15524, -5239},
    {15523, -5241},   {15523, -5242},   {15522, -5244},   {15522, -5245},   {15521, -5247},   {15521, -5248},
    {15520, -5250},   {15520, -5251},   {15519, -5253},   {15519, -5254},   {15518, -5256},   {15518, -5257},
    {15517, -5259},   {15517, -5260},   {15516, -5262},   {15516, -5263},   {15515, -5264},   {15515, -5266},
    {15514, -5267},   {15514, -5269},   {15513, -5270},   {15513, -5272},   {15512, -5273},   {15512, -5275},
    {15511, -5276},   {15511, -5278},   {15510, -5279},   {15510, -5281},   {15509, -5282},   {15509, -5284},
    {15508, -5285},   {15508, -5287},   {15507, -5288},   {15507, -5290},   {15506, -5291},   {15506, -5293},
    {15505, -5294},   {15505, -5296},   {15504, -5297},   {15504, -5299},   {15503, -5300},   {15503, -5302},
    {15502, -5303},   {15501, -5305},   {15501, -5306},   {15500, -5308},   {15500, -5309},   {15499, -5311},
    {15499, -5312},   {15498, -5314},   {15498, -5315},   {15497, -5317},   {15497, -5318},   {15496, -5319},
    {15496, -5321},   {15495, -5322},   {15495, -5324},   {15494, -5325},   {15494, -5327},   {15493, -5328},
    {15493, -5330},   {15492, -5331},   {15492, -5333},   {15491, -5334},   {15491, -5336},   {15490, -5337},
    {15490, -5339},   {15489, -5340},   {15489, -5342},   {15488, -5343},   {15488, -5345},   {15487, -5346},
    {15487, -5348},   {15486, -5349},   {15486, -5351},   {15485, -5352},   {15485, -5354},   {15484, -5355},
    {15484, -5357},   {15483, -5358},   {15483, -5360},   {15482, -5361},   {15482, -5363},   {15481, -5364},
    {15481, -5366},   {15480, -5367},   {15479, -5368},   {15479, -5370},   {15478, -5371},   {15478, -5373},
    {15477, -5374},   {15477, -5376},   {15476, -5377},   {15476, -5379},   {15475, -5380},   {15475, -5382},
    {15474, -5383},   {15474, -5385},   {15473, -5386},   {15473, -5388},   {15472, -5389},   {15472, -5391},
    {15471, -5392},   {15471, -5394},   {15470, -5395},   {15470, -5397},   {15469, -5398},   {15469, -5400},
    {15468, -5401},   {15468, -5403},   {15467, -5404},   {15467, -5406},   {15466, -5407},   {15466, -5409},
    {15465, -5410},   {15465, -5412},   {15464, -5413},   {15463, -5414},   {15463, -5416},   {15462, -5417},
    {15462, -5419},   {15461, -5420},   {15461, -5422},   {15460, -5423},   {15460, -5425},   {15459, -5426},
    {15459, -5428},   {15458, -5429},   {15458, -5431},   {15457, -5432},   {15457, -5434},   {15456, -5435},
    {15456, -5437},   {15455, -5438},   {15455, -5440},   {15454, -5441},   {15454, -5443},   {15453, -5444},
    {15453, -5446},   {15452, -5447},   {15451, -5449},   {15451, -5450},   {15450, -5452},   {15450, -5453},
    {15449, -5454},   {15449, -5456},   {15448, -5457},   {15448, -5459},   {15447, -5460},   {15447, -5462},
    {15446, -5463},   {15446, -5465},   {15445, -5466},   {15445, -5468},   {15444, -5469},   {15444, -5471},
    {15443, -5472},   {15443, -5474},   {15442, -5475},   {15442, -5477},   {15441, -5478},   {15440, -5480},
    {15440, -5481},   {15439, -5483},   {15439, -5484},   {15438, -5486},   {15438, -5487},   {15437, -5489},
    {15437, -5490},   {15436, -5491},   {15436, -5493},   {15435, -5494},   {15435, -5496},   {15434, -5497},
    {15434, -5499},   {15433, -5500},   {15433, -5502},   {15432, -5503},   {15432, -5505},   {15431, -5506},
    {15430, -5508},   {15430, -5509},   {15429, -5511},   {15429, -5512},   {15428, -5514},   {15428, -5515},
    {15427, -5517},   {15427, -5518},   {15426, -5520},   {15426, -5521},   {15425, -5523},   {15425, -5524},
    {15424, -5526},   {15424, -5527},   {15423, -5528},   {15423, -5530},   {15422, -5531},   {15421, -5533},
    {15421, -5534},   {15420, -5536},   {15420, -5537},   {15419, -5539},   {15419, -5540},   {15418, -5542},
    {15418, -5543},   {15417, -5545},   {15417, -5546},   {15416, -5548},   {15416, -5549},   {15415, -5551},
    {15415, -5552},   {15414, -5554},   {15414, -5555},   {15413, -5557},   {15412, -5558},   {15412, -5560},
    {15411, -5561},   {15411, -5562},   {15410, -5564},   {15410, -5565},   {15409, -5567},   {15409, -5568},
    {15408, -5570},   {15408, -5571},   {15407, -5573},   {15407, -5574},   {15406, -5576},   {15406, -5577},
    {15405, -5579},   {15404, -5580},   {15404, -5582},   {15403, -5583},   {15403, -5585},   {15402, -5586},
    {15402, -5588},   {15401, -5589},   {15401, -5591},   {15400, -5592},   {15400, -5593},   {15399, -5595},
    {15399, -5596},   {15398, -5598},   {15397, -5599},   {15397, -5601},   {15396, -5602},   {15396, -5604},
    {15395, -5605},   {15395, -5607},   {15394, -5608},   {15394, -5610},   {15393, -5611},   {15393, -5613},
    {15392, -5614},   {15392, -5616},   {15391, -5617},   {15390, -5619},   {15390, -5620},   {15389, -5622},
    {15389, -5623},   {15388, -5624},   {15388, -5626},   {15387, -5627},   {15387, -5629},   {15386, -5630},
    {15386, -5632},   {15385, -5633},   {15385, -5635},   {15384, -5636},   {15383, -5638},   {15383, -5639},
    {15382, -5641},   {15382, -5642},   {15381, -5644},   {15381, -5645},   {15380, -5647},   {15380, -5648},
    {15379, -5650},   {15379, -5651},   {15378, -5653},   {15378, -5654},   {15377, -5655},   {15376, -5657},
    {15376, -5658},   {15375, -5660},   {15375, -5661},   {15374, -5663},   {15374, -5664},   {15373, -5666},
    {15373, -5667},   {15372, -5669},   {15372, -5670},   {15371, -5672},   {15370, -5673},   {15370, -5675},
    {15369, -5676},   {15369, -5678},   {15368, -5679},   {15368, -5681},   {15367, -5682},   {15367, -5683},
    {15366, -5685},   {15366, -5686},   {15365, -5688},   {15364, -5689},   {15364, -5691},   {15363, -5692},
    {15363, -5694},   {15362, -5695},   {15362, -5697},   {15361, -5698},   {15361, -5700},   {15360, -5701},
    {15360, -5703},   {15359, -5704},   {15358, -5706},   {15358, -5707},   {15357, -5708},   {15357, -5710},
    {15356, -5711},   {15356, -5713},   {15355, -5714},   {15355, -5716},   {15354, -5717},   {15354, -5719},
    {15353, -5720},   {15352, -5722},   {15352, -5723},   {15351, -5725},   {15351, -5726},   {15350, -5728},
    {15350, -5729},   {15349, -5731},   {15349, -5732},   {15348, -5734},   {15347, -5735},   {15347, -5736},
    {15346, -5738},   {15346, -5739},   {15345, -5741},   {15345, -5742},   {15344, -5744},   {15344, -5745},
    {15343, -5747},   {15343, -5748},   {15342, -5750},   {15341, -5751},   {15341, -5753},   {15340, -5754},
    {15340, -5756},   {15339, -5757},   {15339, -5759},   {15338, -5760},   {15338, -5761},   {15337, -5763},
    {15336, -5764},   {15336, -5766},   {15335, -5767},   {15335, -5769},   {15334, -5770},   {15334, -5772},
    {15333, -5773},   {15333, -5775},   {15332, -5776},   {15331, -5778},   {15331, -5779},   {15330, -5781},
    {15330, -5782},   {15329, -5784},   {15329, -5785},   {15328, -5786},   {15328, -5788},   {15327, -5789},
    {15326, -5791},   {15326, -5792},   {15325, -5794},   {15325, -5795},   {15324, -5797},   {15324, -5798},
    {15323, -5800},   {15323, -5801},   {15322, -5803},   {15321, -5804},   {15321, -5806},   {15320, -5807},
    {15320, -5808},   {15319, -5810},   {15319, -5811},   {15318, -5813},   {15318, -5814},   {15317, -5816},
    {15316, -5817},   {15316, -5819},   {15315, -5820},   {15315, -5822},   {15314, -5823},   {15314, -5825},
    {15313, -5826},   {15313, -5828},   {15312, -5829},   {15311, -5831},   {15311, -5832},   {15310, -5833},
    {15310, -5835},   {15309, -5836},   {15309, -5838},   {15308, -5839},   {15308, -5841},   {15307, -5842},
    {15306, -5844},   {15306, -5845},   {15305, -5847},   {15305, -5848},   {15304, -5850},   {15304, -5851},
    {15303, -5853},   {15302, -5854},   {15302, -5855},   {15301, -5857},   {15301, -5858},   {15300, -5860},
    {15300, -5861},   {15299, -5863},   {15299, -5864},   {15298, -5866},   {15297, -5867},   {15297, -5869},
    {15296, -5870},   {15296, -5872},   {15295, -5873},   {15295, -5875},   {15294, -5876},   {15293, -5877},
    {15293, -5879},   {15292, -5880},   {15292, -5882},   {15291, -5883},   {15291, -5885},   {15290, -5886},
    {15290, -5888},   {15289, -5889},   {15288, -5891},   {15288, -5892},   {15287, -5894},   {15287, -5895},
    {15286, -5897},   {15286, -5898},   {15285, -5899},   {15284, -5901},   {15284, -5902},   {15283, -5904},
    {15283, -5905},   {15282, -5907},   {15282, -5908},   {15281, -5910},   {15280, -5911},   {15280, -5913},
    {15279, -5914},   {15279, -5916},   {15278, -5917},   {15278, -5918},   {15277, -5920},   {15277, -5921},
    {15276, -5923},   {15275, -5924},   {15275, -5926},   {15274, -5927},   {15274, -5929},   {15273, -5930},
    {15273, -5932},   {15272, -5933},   {15271, -5935},   {15271, -5936},   {15270, -5938},   {15270, -5939},
    {15269, -5940},   {15269, -5942},   {15268, -5943},   {15267, -5945},   {15267, -5946},   {15266, -5948},
    {15266, -5949},   {15265, -5951},   {15265, -5952},   {15264, -5954},   {15263, -5955},   {15263, -5957},
    {15262, -5958},   {15262, -5959},   {15261, -5961},   {15261, -5962},   {15260, -5964},   {15259, -5965},
    {15259, -5967},   {15258, -5968},   {15258, -5970},   {15257, -5971},   {15257, -5973},   {15256, -5974},
    {15255, -5976},   {15255, -5977},   {15254, -5979},   {15254, -5980},   {15253, -5981},   {15253, -5983},
    {15252, -5984},   {15251, -5986},   {15251, -5987},   {15250, -5989},   {15250, -5990},   {15249, -5992},
    {15249, -5993},   {15248, -5995},   {15247, -5996},   {15247, -5998},   {15246, -5999},   {15246, -6000},
    {15245, -6002},   {15245, -6003},   {15244, -6005},   {15243, -6006},   {15243, -6008},   {15242, -6009},
    {15242, -6011},   {15241, -6012},   {15240, -6014},   {15240, -6015},   {15239, -6017},   {15239, -6018},
    {15238, -6019},   {15238, -6021},   {15237, -6022},   {15236, -6024},   {15236, -6025},   {15235, -6027},
    {15235, -6028},   {15234, -6030},   {15234, -6031},   {15233, -6033},   {15232, -6034},   {15232, -6036},
    {15231, -6037},   {15231, -6038},   {15230, -6040},   {15229, -6041},   {15229, -6043},   {15228, -6044},
    {15228, -6046},   {15227, -6047},   {15227, -6049},   {15226, -6050},   {15225, -6052},   {15225, -6053},
    {15224, -6054},   {15224, -6056},   {15223, -6057},   {15223, -6059},   {15222, -6060},   {15221, -6062},
    {15221, -6063},   {15220, -6065},   {15220, -6066},   {15219, -6068},   {15218, -6069},   {15218, -6071},
    {15217, -6072},   {15217, -6073},   {15216, -6075},   {15216, -6076},   {15215, -6078},   {15214, -6079},
    {15214, -6081},   {15213, -6082},   {15213, -6084},   {15212, -6085},   {15211, -6087},   {15211, -6088},
    {15210, -6089},   {15210, -6091},   {15209, -6092},   {15209, -6094},   {15208, -6095},   {15207, -6097},
    {15207, -6098},   {15206, -6100},   {15206, -6101},   {15205, -6103},   {15204, -6104},   {15204, -6106},
    {15203, -6107},   {15203, -6108},   {15202, -6110},   {15202, -6111},   {15201, -6113},   {15200, -6114},
    {15200, -6116},   {15199, -6117},   {15199, -6119},   {15198, -6120},   {15197, -6122},   {15197, -6123},
    {15196, -6124},   {15196, -6126},   {15195, -6127},   {15194, -6129},   {15194, -6130},   {15193, -6132},
    {15193, -6133},   {15192, -6135},   {15192, -6136},   {15191, -6138},   {15190, -6139},   {15190, -6140},
    {15189, -6142},   {15189, -6143},   {15188, -6145},   {15187, -6146},   {15187, -6148},   {15186, -6149},
    {15186, -6151},   {15185, -6152},   {15184, -6154},   {15184, -6155},   {15183, -6157},   {15183, -6158},
    {15182, -6159},   {15182, -6161},   {15181, -6162},   {15180, -6164},   {15180, -6165},   {15179, -6167},
    {15179, -6168},   {15178, -6170},   {15177, -6171},   {15177, -6173},   {15176, -6174},   {15176, -6175},
    {15175, -6177},   {15174, -6178},   {15174, -6180},   {15173, -6181},   {15173, -6183},   {15172, -6184},
    {15171, -6186},   {15171, -6187},   {15170, -6189},   {15170, -6190},   {15169, -6191},   {15169, -6193},
    {15168, -6194},   {15167, -6196},   {15167, -6197},   {15166, -6199},   {15166, -6200},   {15165, -6202},
    {15164, -6203},   {15164, -6205},   {15163, -6206},   {15163, -6207},   {15162, -6209},   {15161, -6210},
    {15161, -6212},   {15160, -6213},   {15160, -6215},   {15159, -6216},   {15158, -6218},   {15158, -6219},
    {15157, -6221},   {15157, -6222},   {15156, -6223},   {15155, -6225},   {15155, -6226},   {15154, -6228},
    {15154, -6229},   {15153, -6231},   {15152, -6232},   {15152, -6234},   {15151, -6235},   {15151, -6236},
    {15150, -6238},   {15149, -6239},   {15149, -6241},   {15148, -6242},   {15148, -6244},   {15147, -6245},
    {15146, -6247},   {15146, -6248},   {15145, -6250},   {15145, -6251},   {15144, -6252},   {15143, -6254},
    {15143, -6255},   {15142, -6257},   {15142, -6258},   {15141, -6260},   {15140, -6261},   {15140, -6263},
    {15139, -6264},   {15139, -6266},   {15138, -6267},   {15137, -6268},   {15137, -6270},   {15136, -6271},
    {15136, -6273},   {15135, -6274},   {15134, -6276},   {15134, -6277},   {15133, -6279},   {15133, -6280},
    {15132, -6281},   {15131, -6283},   {15131, -6284},   {15130, -6286},   {15130, -6287},   {15129, -6289},
    {15128, -6290},   {15128, -6292},   {15127, -6293},   {15127, -6295},   {15126, -6296},   {15125, -6297},
    {15125, -6299},   {15124, -6300},   {15124, -6302},   {15123, -6303},   {15122, -6305},   {15122, -6306},
    {15121, -6308},   {15121, -6309},   {15120, -6310},   {15119, -6312},   {15119, -6313},   {15118, -6315},
    {15118, -6316},   {15117, -6318},   {15116, -6319},   {15116, -6321},   {15115, -6322},   {15115, -6324},
    {15114, -6325},   {15113, -6326},   {15113, -6328},   {15112, -6329},   {15111, -6331},   {15111, -6332},
    {15110, -6334},   {15110, -6335},   {15109, -6337},   {15108, -6338},   {15108, -6339},   {15107, -6341},
    {15107, -6342},   {15106, -6344},   {15105, -6345},   {15105, -6347},   {15104, -6348},   {15104, -6350},
    {15103, -6351},   {15102, -6353},   {15102, -6354},   {15101, -6355},   {15101, -6357},   {15100, -6358},
    {15099, -6360},   {15099, -6361},   {15098, -6363},   {15097, -6364},   {15097, -6366},   {15096, -6367},
    {15096, -6368},   {15095, -6370},   {15094, -6371},   {15094, -6373},   {15093, -6374},   {15093, -6376},
    {15092, -6377},   {15091, -6379},   {15091, -6380},   {15090, -6381},   {15090, -6383},   {15089, -6384},
    {15088, -6386},   {15088, -6387},   {15087, -6389},   {15086, -6390},   {15086, -6392},   {15085, -6393},
    {15085, -6394},   {15084, -6396},   {15083, -6397},   {15083, -6399},   {15082, -6400},   {15082, -6402},
    {15081, -6403},   {15080, -6405},   {15080, -6406},   {15079, -6407},   {15078, -6409},   {15078, -6410},
    {15077, -6412},   {15077, -6413},   {15076, -6415},   {15075, -6416},   {15075, -6418},   {15074, -6419},
    {15074, -6420},   {15073, -6422},   {15072, -6423},   {15072, -6425},   {15071, -6426},   {15070, -6428},
    {15070, -6429},   {15069, -6431},   {15069, -6432},   {15068, -6434},   {15067, -6435},   {15067, -6436},
    {15066, -6438},   {15066, -6439},   {15065, -6441},   {15064, -6442},   {15064, -6444},   {15063, -6445},
    {15062, -6447},   {15062, -6448},   {15061, -6449},   {15061, -6451},   {15060, -6452},   {15059, -6454},
    {15059, -6455},   {15058, -6457},   {15058, -6458},   {15057, -6459},   {15056, -6461},   {15056, -6462},
    {15055, -6464},   {15054, -6465},   {15054, -6467},   {15053, -6468},   {15053, -6470},   {15052, -6471},
    {15051, -6472},   {15051, -6474},   {15050, -6475},   {15049, -6477},   {15049, -6478},   {15048, -6480},
    {15048, -6481},   {15047, -6483},   {15046, -6484},   {15046, -6485},   {15045, -6487},   {15044, -6488},
    {15044, -6490},   {15043, -6491},   {15043, -6493},   {15042, -6494},   {15041, -6496},   {15041, -6497},
    {15040, -6498},   {15040, -6500},   {15039, -6501},   {15038, -6503},   {15038, -6504},   {15037, -6506},
    {15036, -6507},   {15036, -6509},   {15035, -6510},   {15035, -6511},   {15034, -6513},   {15033, -6514},
    {15033, -6516},   {15032, -6517},   {15031, -6519},   {15031, -6520},   {15030, -6522},   {15030, -6523},
    {15029, -6524},   {15028, -6526},   {15028, -6527},   {15027, -6529},   {15026, -6530},   {15026, -6532},
    {15025, -6533},   {15025, -6534},   {15024, -6536},   {15023, -6537},   {15023, -6539},   {15022, -6540},
    {15021, -6542},   {15021, -6543},   {15020, -6545},   {15019, -6546},   {15019, -6547},   {15018, -6549},
    {15018, -6550},   {15017, -6552},   {15016, -6553},   {15016, -6555},   {15015, -6556},   {15014, -6558},
    {15014, -6559},   {15013, -6560},   {15013, -6562},   {15012, -6563},   {15011, -6565},   {15011, -6566},
    {15010, -6568},   {15009, -6569},   {15009, -6570},   {15008, -6572},   {15008, -6573},   {15007, -6575},
    {15006, -6576},   {15006, -6578},   {15005, -6579},   {15004, -6581},   {15004, -6582},   {15003, -6583},
    {15003, -6585},   {15002, -6586},   {15001, -6588},   {15001, -6589},   {15000, -6591},   {14999, -6592},
    {14999, -6593},   {14998, -6595},   {14997, -6596},   {14997, -6598},   {14996, -6599},   {14996, -6601},
    {14995, -6602},   {14994, -6604},   {14994, -6605},   {14993, -6606},   {14992, -6608},   {14992, -6609},
    {14991, -6611},   {14990, -6612},   {14990, -6614},   {14989, -6615},   {14989, -6616},   {14988, -6618},
    {14987, -6619},   {14987, -6621},   {14986, -6622},   {14985, -6624},   {14985, -6625},   {14984, -6627},
    {14984, -6628},   {14983, -6629},   {14982, -6631},   {14982, -6632},   {14981, -6634},   {14980, -6635},
    {14980, -6637},   {14979, -6638},   {14978, -6639},   {14978, -6641},   {14977, -6642},   {14977, -6644},
    {14976, -6645},   {14975, -6647},   {14975, -6648},   {14974, -6650},   {14973, -6651},   {14973, -6652},
    {14972, -6654},   {14971, -6655},   {14971, -6657},   {14970, -6658},   {14969, -6660},   {14969, -6661},
    {14968, -6662},   {14968, -6664},   {14967, -6665},   {14966, -6667},   {14966, -6668},   {14965, -6670},
    {14964, -6671},   {14964, -6672},   {14963, -6674},   {14962, -6675},   {14962, -6677},   {14961, -6678},
    {14961, -6680},   {14960, -6681},   {14959, -6683},   {14959, -6684},   {14958, -6685},   {14957, -6687},
    {14957, -6688},   {14956, -6690},   {14955, -6691},   {14955, -6693},   {14954, -6694},   {14953, -6695},
    {14953, -6697},   {14952, -6698},   {14952, -6700},   {14951, -6701},   {14950, -6703},   {14950, -6704},
    {14949, -6705},   {14948, -6707},   {14948, -6708},   {14947, -6710},   {14946, -6711},   {14946, -6713},
    {14945, -6714},   {14944, -6715},   {14944, -6717},   {14943, -6718},   {14943, -6720},   {14942, -6721},
    {14941, -6723},   {14941, -6724},   {14940, -6726},   {14939, -6727},   {14939, -6728},   {14938, -6730},
    {14937, -6731},   {14937, -6733},   {14936, -6734},   {14935, -6736},   {14935, -6737},   {14934, -6738},
    {14934, -6740},   {14933, -6741},   {14932, -6743},   {14932, -6744},   {14931, -6746},   {14930, -6747},
    {14930, -6748},   {14929, -6750},   {14928, -6751},   {14928, -6753},   {14927, -6754},   {14926, -6756},
    {14926, -6757},   {14925, -6758},   {14924, -6760},   {14924, -6761},   {14923, -6763},   {14923, -6764},
    {14922, -6766},   {14921, -6767},   {14921, -6768},   {14920, -6770},   {14919, -6771},   {14919, -6773},
    {14918, -6774},   {14917, -6776},   {14917, -6777},   {14916, -6778},   {14915, -6780},   {14915, -6781},
    {14914, -6783},   {14913, -6784},   {14913, -6786},   {14912, -6787},   {14911, -6788},   {14911, -6790},
    {14910, -6791},   {14910, -6793},   {14909, -6794},   {14908, -6796},   {14908, -6797},   {14907, -6798},
    {14906, -6800},   {14906, -6801},   {14905, -6803},   {14904, -6804},   {14904, -6806},   {14903, -6807},
    {14902, -6808},   {14902, -6810},   {14901, -6811},   {14900, -6813},   {14900, -6814},   {14899, -6816},
    {14898, -6817},   {14898, -6818},   {14897, -6820},   {14896, -6821},   {14896, -6823},   {14895, -6824},
    {14894, -6826},   {14894, -6827},   {14893, -6828},   {14893, -6830},   {14892, -6831},   {14891, -6833},
    {14891, -6834},   {14890, -6836},   {14889, -6837},   {14889, -6838},   {14888, -6840},   {14887, -6841},
    {14887, -6843},   {14886, -6844},   {14885, -6846},   {14885, -6847},   {14884, -6848},   {14883, -6850},
    {14883, -6851},   {14882, -6853},   {14881, -6854},   {14881, -6856},   {14880, -6857},   {14879, -6858},
    {14879, -6860},   {14878, -6861},   {14877, -6863},   {14877, -6864},   {14876, -6866},   {14875, -6867},
    {14875, -6868},   {14874, -6870},   {14873, -6871},   {14873, -6873},   {14872, -6874},   {14872, -6876},
    {14871, -6877},   {14870, -6878},   {14870, -6880},   {14869, -6881},   {14868, -6883},   {14868, -6884},
    {14867, -6886},   {14866, -6887},   {14866, -6888},   {14865, -6890},   {14864, -6891},   {14864, -6893},
    {14863, -6894},   {14862, -6896},   {14862, -6897},   {14861, -6898},   {14860, -6900},   {14860, -6901},
    {14859, -6903},   {14858, -6904},   {14858, -6906},   {14857, -6907},   {14856, -6908},   {14856, -6910},
    {14855, -6911},   {14854, -6913},   {14854, -6914},   {14853, -6915},   {14852, -6917},   {14852, -6918},
    {14851, -6920},   {14850, -6921},   {14850, -6923},   {14849, -6924},   {14848, -6925},   {14848, -6927},
    {14847, -6928},   {14846, -6930},   {14846, -6931},   {14845, -6933},   {14844, -6934},   {14844, -6935},
    {14843, -6937},   {14842, -6938},   {14842, -6940},   {14841, -6941},   {14840, -6943},   {14840, -6944},
    {14839, -6945},   {14838, -6947},   {14838, -6948},   {14837, -6950},   {14836, -6951},   {14836, -6952},
    {14835, -6954},   {14834, -6955},   {14834, -6957},   {14833, -6958},   {14832, -6960},   {14832, -6961},
    {14831, -6962},   {14830, -6964},   {14830, -6965},   {14829, -6967},   {14828, -6968},   {14828, -6970},
    {14827, -6971},   {14826, -6972},   {14826, -6974},   {14825, -6975},   {14824, -6977},   {14824, -6978},
    {14823, -6979},   {14822, -6981},   {14822, -6982},   {14821, -6984},   {14820, -6985},   {14820, -6987},
    {14819, -6988},   {14818, -6989},   {14818, -6991},   {14817, -6992},   {14816, -6994},   {14816, -6995},
    {14815, -6997},   {14814, -6998},   {14814, -6999},   {14813, -7001},   {14812, -7002},   {14812, -7004},
    {14811, -7005},   {14810, -7006},   {14810, -7008},   {14809, -7009},   {14808, -7011},   {14808, -7012},
    {14807, -7014},   {14806, -7015},   {14806, -7016},   {14805, -7018},   {14804, -7019},   {14804, -7021},
    {14803, -7022},   {14802, -7024},   {14802, -7025},   {14801, -7026},   {14800, -7028},   {14800, -7029},
    {14799, -7031},   {14798, -7032},   {14798, -7033},   {14797, -7035},   {14796, -7036},   {14795, -7038},
    {14795, -7039},   {14794, -7041},   {14793, -7042},   {14793, -7043},   {14792, -7045},   {14791, -7046},
    {14791, -7048},   {14790, -7049},   {14789, -7050},   {14789, -7052},   {14788, -7053},   {14787, -7055},
    {14787, -7056},   {14786, -7058},   {14785, -7059},   {14785, -7060},   {14784, -7062},   {14783, -7063},
    {14783, -7065},   {14782, -7066},   {14781, -7067},   {14781, -7069},   {14780, -7070},   {14779, -7072},
    {14779, -7073},   {14778, -7075},   {14777, -7076},   {14777, -7077},   {14776, -7079},   {14775, -7080},
    {14774, -7082},   {14774, -7083},   {14773, -7084},   {14772, -7086},   {14772, -7087},   {14771, -7089},
    {14770, -7090},   {14770, -7092},   {14769, -7093},   {14768, -7094},   {14768, -7096},   {14767, -7097},
    {14766, -7099},   {14766, -7100},   {14765, -7101},   {14764, -7103},   {14764, -7104},   {14763, -7106},
    {14762, -7107},   {14762, -7109},   {14761, -7110},   {14760, -7111},   {14760, -7113},   {14759, -7114},
    {14758, -7116},   {14757, -7117},   {14757, -7118},   {14756, -7120},   {14755, -7121},   {14755, -7123},
    {14754, -7124},   {14753, -7126},   {14753, -7127},   {14752, -7128},   {14751, -7130},   {14751, -7131},
    {14750, -7133},   {14749, -7134},   {14749, -7135},   {14748, -7137},   {14747, -7138},   {14747, -7140},
    {14746, -7141},   {14745, -7142},   {14744, -7144},   {14744, -7145},   {14743, -7147},   {14742, -7148},
    {14742, -7150},   {14741, -7151},   {14740, -7152},   {14740, -7154},   {14739, -7155},   {14738, -7157},
    {14738, -7158},   {14737, -7159},   {14736, -7161},   {14736, -7162},   {14735, -7164},   {14734, -7165},
    {14734, -7167},   {14733, -7168},   {14732, -7169},   {14731, -7171},   {14731, -7172},   {14730, -7174},
    {14729, -7175},   {14729, -7176},   {14728, -7178},   {14727, -7179},   {14727, -7181},   {14726, -7182},
    {14725, -7183},   {14725, -7185},   {14724, -7186},   {14723, -7188},   {14723, -7189},   {14722, -7191},
    {14721, -7192},   {14720, -7193},   {14720, -7195},   {14719, -7196},   {14718, -7198},   {14718, -7199},
    {14717, -7200},   {14716, -7202},   {14716, -7203},   {14715, -7205},   {14714, -7206},   {14714, -7207},
    {14713, -7209},   {14712, -7210},   {14711, -7212},   {14711, -7213},   {14710, -7215},   {14709, -7216},
    {14709, -7217},   {14708, -7219},   {14707, -7220},   {14707, -7222},   {14706, -7223},   {14705, -7224},
    {14705, -7226},   {14704, -7227},   {14703, -7229},   {14702, -7230},   {14702, -7231},   {14701, -7233},
    {14700, -7234},   {14700, -7236},   {14699, -7237},   {14698, -7238},   {14698, -7240},   {14697, -7241},
    {14696, -7243},   {14696, -7244},   {14695, -7246},   {14694, -7247},   {14693, -7248},   {14693, -7250},
    {14692, -7251},   {14691, -7253},   {14691, -7254},   {14690, -7255},   {14689, -7257},   {14689, -7258},
    {14688, -7260},   {14687, -7261},   {14686, -7262},   {14686, -7264},   {14685, -7265},   {14684, -7267},
    {14684, -7268},   {14683, -7269},   {14682, -7271},   {14682, -7272},   {14681, -7274},   {14680, -7275},
    {14680, -7276},   {14679, -7278},   {14678, -7279},   {14677, -7281},   {14677, -7282},   {14676, -7284},
    {14675, -7285},   {14675, -7286},   {14674, -7288},   {14673, -7289},   {14673, -7291},   {14672, -7292},
    {14671, -7293},   {14670, -7295},   {14670, -7296},   {14669, -7298},   {14668, -7299},   {14668, -7300},
    {14667, -7302},   {14666, -7303},   {14666, -7305},   {14665, -7306},   {14664, -7307},   {14663, -7309},
    {14663, -7310},   {14662, -7312},   {14661, -7313},   {14661, -7314},   {14660, -7316},   {14659, -7317},
    {14659, -7319},   {14658, -7320},   {14657, -7321},   {14656, -7323},   {14656, -7324},   {14655, -7326},
    {14654, -7327},   {14654, -7329},   {14653, -7330},   {14652, -7331},   {14651, -7333},   {14651, -7334},
    {14650, -7336},   {14649, -7337},   {14649, -7338},   {14648, -7340},   {14647, -7341},   {14647, -7343},
    {14646, -7344},   {14645, -7345},   {14644, -7347},   {14644, -7348},   {14643, -7350},   {14642, -7351},
    {14642, -7352},   {14641, -7354},   {14640, -7355},   {14640, -7357},   {14639, -7358},   {14638, -7359},
    {14637, -7361},   {14637, -7362},   {14636, -7364},   {14635, -7365},   {14635, -7366},   {14634, -7368},
    {14633, -7369},   {14632, -7371},   {14632, -7372},   {14631, -7373},   {14630, -7375},   {14630, -7376},
    {14629, -7378},   {14628, -7379},   {14628, -7380},   {14627, -7382},   {14626, -7383},   {14625, -7385},
    {14625, -7386},   {14624, -7387},   {14623, -7389},   {14623, -7390},   {14622, -7392},   {14621, -7393},
    {14620, -7394},   {14620, -7396},   {14619, -7397},   {14618, -7399},   {14618, -7400},   {14617, -7401},
    {14616, -7403},   {14615, -7404},   {14615, -7406},   {14614, -7407},   {14613, -7408},   {14613, -7410},
    {14612, -7411},   {14611, -7413},   {14610, -7414},   {14610, -7415},   {14609, -7417},   {14608, -7418},
    {14608, -7420},   {14607, -7421},   {14606, -7423},   {14606, -7424},   {14605, -7425},   {14604, -7427},
    {14603, -7428},   {14603, -7430},   {14602, -7431},   {14601, -7432},   {14601, -7434},   {14600, -7435},
    {14599, -7437},   {14598, -7438},   {14598, -7439},   {14597, -7441},   {14596, -7442},   {14596, -7443},
    {14595, -7445},   {14594, -7446},   {14593, -7448},   {14593, -7449},   {14592, -7450},   {14591, -7452},
    {14591, -7453},   {14590, -7455},   {14589, -7456},   {14588, -7457},   {14588, -7459},   {14587, -7460},
    {14586, -7462},   {14586, -7463},   {14585, -7464},   {14584, -7466},   {14583, -7467},   {14583, -7469},
    {14582, -7470},   {14581, -7471},   {14581, -7473},   {14580, -7474},   {14579, -7476},   {14578, -7477},
    {14578, -7478},   {14577, -7480},   {14576, -7481},   {14576, -7483},   {14575, -7484},   {14574, -7485},
    {14573, -7487},   {14573, -7488},   {14572, -7490},   {14571, -7491},   {14570, -7492},   {14570, -7494},
    {14569, -7495},   {14568, -7497},   {14568, -7498},   {14567, -7499},   {14566, -7501},   {14565, -7502},
    {14565, -7504},   {14564, -7505},   {14563, -7506},   {14563, -7508},   {14562, -7509},   {14561, -7511},
    {14560, -7512},   {14560, -7513},   {14559, -7515},   {14558, -7516},   {14558, -7518},   {14557, -7519},
    {14556, -7520},   {14555, -7522},   {14555, -7523},   {14554, -7525},   {14553, -7526},   {14552, -7527},
    {14552, -7529},   {14551, -7530},   {14550, -7532},   {14550, -7533},   {14549, -7534},   {14548, -7536},
    {14547, -7537},   {14547, -7538},   {14546, -7540},   {14545, -7541},   {14545, -7543},   {14544, -7544},
    {14543, -7545},   {14542, -7547},   {14542, -7548},   {14541, -7550},   {14540, -7551},   {14539, -7552},
    {14539, -7554},   {14538, -7555},   {14537, -7557},   {14537, -7558},   {14536, -7559},   {14535, -7561},
    {14534, -7562},   {14534, -7564},   {14533, -7565},   {14532, -7566},   {14531, -7568},   {14531, -7569},
    {14530, -7571},   {14529, -7572},   {14529, -7573},   {14528, -7575},   {14527, -7576},   {14526, -7578},
    {14526, -7579},   {14525, -7580},   {14524, -7582},   {14524, -7583},   {14523, -7584},   {14522, -7586},
    {14521, -7587},   {14521, -7589},   {14520, -7590},   {14519, -7591},   {14518, -7593},   {14518, -7594},
    {14517, -7596},   {14516, -7597},   {14516, -7598},   {14515, -7600},   {14514, -7601},   {14513, -7603},
    {14513, -7604},   {14512, -7605},   {14511, -7607},   {14510, -7608},   {14510, -7610},   {14509, -7611},
    {14508, -7612},   {14507, -7614},   {14507, -7615},   {14506, -7616},   {14505, -7618},   {14505, -7619},
    {14504, -7621},   {14503, -7622},   {14502, -7623},   {14502, -7625},   {14501, -7626},   {14500, -7628},
    {14499, -7629},   {14499, -7630},   {14498, -7632},   {14497, -7633},   {14497, -7635},   {14496, -7636},
    {14495, -7637},   {14494, -7639},   {14494, -7640},   {14493, -7642},   {14492, -7643},   {14491, -7644},
    {14491, -7646},   {14490, -7647},   {14489, -7648},   {14488, -7650},   {14488, -7651},   {14487, -7653},
    {14486, -7654},   {14486, -7655},   {14485, -7657},   {14484, -7658},   {14483, -7660},   {14483, -7661},
    {14482, -7662},   {14481, -7664},   {14480, -7665},   {14480, -7667},   {14479, -7668},   {14478, -7669},
    {14477, -7671},   {14477, -7672},   {14476, -7673},   {14475, -7675},   {14474, -7676},   {14474, -7678},
    {14473, -7679},   {14472, -7680},   {14472, -7682},   {14471, -7683},   {14470, -7685},   {14469, -7686},
    {14469, -7687},   {14468, -7689},   {14467, -7690},   {14466, -7691},   {14466, -7693},   {14465, -7694},
    {14464, -7696},   {14463, -7697},   {14463, -7698},   {14462, -7700},   {14461, -7701},   {14460, -7703},
    {14460, -7704},   {14459, -7705},   {14458, -7707},   {14458, -7708},   {14457, -7710},   {14456, -7711},
    {14455, -7712},   {14455, -7714},   {14454, -7715},   {14453, -7716},   {14452, -7718},   {14452, -7719},
    {14451, -7721},   {14450, -7722},   {14449, -7723},   {14449, -7725},   {14448, -7726},   {14447, -7728},
    {14446, -7729},   {14446, -7730},   {14445, -7732},   {14444, -7733},   {14443, -7734},   {14443, -7736},
    {14442, -7737},   {14441, -7739},   {14441, -7740},   {14440, -7741},   {14439, -7743},   {14438, -7744},
    {14438, -7746},   {14437, -7747},   {14436, -7748},   {14435, -7750},   {14435, -7751},   {14434, -7752},
    {14433, -7754},   {14432, -7755},   {14432, -7757},   {14431, -7758},   {14430, -7759},   {14429, -7761},
    {14429, -7762},   {14428, -7764},   {14427, -7765},   {14426, -7766},   {14426, -7768},   {14425, -7769},
    {14424, -7770},   {14423, -7772},   {14423, -7773},   {14422, -7775},   {14421, -7776},   {14420, -7777},
    {14420, -7779},   {14419, -7780},   {14418, -7781},   {14417, -7783},   {14417, -7784},   {14416, -7786},
    {14415, -7787},   {14414, -7788},   {14414, -7790},   {14413, -7791},   {14412, -7793},   {14411, -7794},
    {14411, -7795},   {14410, -7797},   {14409, -7798},   {14408, -7799},   {14408, -7801},   {14407, -7802},
    {14406, -7804},   {14405, -7805},   {14405, -7806},   {14404, -7808},   {14403, -7809},   {14402, -7810},
    {14402, -7812},   {14401, -7813},   {14400, -7815},   {14399, -7816},   {14399, -7817},   {14398, -7819},
    {14397, -7820},   {14396, -7822},   {14396, -7823},   {14395, -7824},   {14394, -7826},   {14393, -7827},
    {14393, -7828},   {14392, -7830},   {14391, -7831},   {14390, -7833},   {14390, -7834},   {14389, -7835},
    {14388, -7837},   {14387, -7838},   {14387, -7839},   {14386, -7841},   {14385, -7842},   {14384, -7844},
    {14384, -7845},   {14383, -7846},   {14382, -7848},   {14381, -7849},   {14381, -7851},   {14380, -7852},
    {14379, -7853},   {14378, -7855},   {14378, -7856},   {14377, -7857},   {14376, -7859},   {14375, -7860},
    {14375, -7862},   {14374, -7863},   {14373, -7864},   {14372, -7866},   {14372, -7867},   {14371, -7868},
    {14370, -7870},   {14369, -7871},   {14369, -7873},   {14368, -7874},   {14367, -7875},   {14366, -7877},
    {14366, -7878},   {14365, -7879},   {14364, -7881},   {14363, -7882},   {14363, -7884},   {14362, -7885},
    {14361, -7886},   {14360, -7888},   {14360, -7889},   {14359, -7890},   {14358, -7892},   {14357, -7893},
    {14357, -7895},   {14356, -7896},   {14355, -7897},   {14354, -7899},   {14354, -7900},   {14353, -7901},
    {14352, -7903},   {14351, -7904},   {14351, -7906},   {14350, -7907},   {14349, -7908},   {14348, -7910},
    {14347, -7911},   {14347, -7912},   {14346, -7914},   {14345, -7915},   {14344, -7917},   {14344, -7918},
    {14343, -7919},   {14342, -7921},   {14341, -7922},   {14341, -7923},   {14340, -7925},   {14339, -7926},
    {14338, -7928},   {14338, -7929},   {14337, -7930},   {14336, -7932},   {14335, -7933},   {14335, -7934},
    {14334, -7936},   {14333, -7937},   {14332, -7939},   {14332, -7940},   {14331, -7941},   {14330, -7943},
    {14329, -7944},   {14328, -7945},   {14328, -7947},   {14327, -7948},   {14326, -7950},   {14325, -7951},
    {14325, -7952},   {14324, -7954},   {14323, -7955},   {14322, -7956},   {14322, -7958},   {14321, -7959},
    {14320, -7961},   {14319, -7962},   {14319, -7963},   {14318, -7965},   {14317, -7966},   {14316, -7967},
    {14315, -7969},   {14315, -7970},   {14314, -7972},   {14313, -7973},   {14312, -7974},   {14312, -7976},
    {14311, -7977},   {14310, -7978},   {14309, -7980},   {14309, -7981},   {14308, -7983},   {14307, -7984},
    {14306, -7985},   {14306, -7987},   {14305, -7988},   {14304, -7989},   {14303, -7991},   {14302, -7992},
    {14302, -7994},   {14301, -7995},   {14300, -7996},   {14299, -7998},   {14299, -7999},   {14298, -8000},
    {14297, -8002},   {14296, -8003},   {14296, -8004},   {14295, -8006},   {14294, -8007},   {14293, -8009},
    {14293, -8010},   {14292, -8011},   {14291, -8013},   {14290, -8014},   {14289, -8015},   {14289, -8017},
    {14288, -8018},   {14287, -8020},   {14286, -8021},   {14286, -8022},   {14285, -8024},   {14284, -8025},
    {14283, -8026},   {14283, -8028},   {14282, -8029},   {14281, -8031},   {14280, -8032},   {14279, -8033},
    {14279, -8035},   {14278, -8036},   {14277, -8037},   {14276, -8039},   {14276, -8040},   {14275, -8041},
    {14274, -8043},   {14273, -8044},   {14273, -8046},   {14272, -8047},   {14271, -8048},   {14270, -8050},
    {14269, -8051},   {14269, -8052},   {14268, -8054},   {14267, -8055},   {14266, -8057},   {14266, -8058},
    {14265, -8059},   {14264, -8061},   {14263, -8062},   {14262, -8063},   {14262, -8065},   {14261, -8066},
    {14260, -8067},   {14259, -8069},   {14259, -8070},   {14258, -8072},   {14257, -8073},   {14256, -8074},
    {14256, -8076},   {14255, -8077},   {14254, -8078},   {14253, -8080},   {14252, -8081},   {14252, -8082},
    {14251, -8084},   {14250, -8085},   {14249, -8087},   {14249, -8088},   {14248, -8089},   {14247, -8091},
    {14246, -8092},   {14245, -8093},   {14245, -8095},   {14244, -8096},   {14243, -8098},   {14242, -8099},
    {14242, -8100},   {14241, -8102},   {14240, -8103},   {14239, -8104},   {14238, -8106},   {14238, -8107},
    {14237, -8108},   {14236, -8110},   {14235, -8111},   {14235, -8113},   {14234, -8114},   {14233, -8115},
    {14232, -8117},   {14231, -8118},   {14231, -8119},   {14230, -8121},   {14229, -8122},   {14228, -8123},
    {14228, -8125},   {14227, -8126},   {14226, -8128},   {14225, -8129},   {14224, -8130},   {14224, -8132},
    {14223, -8133},   {14222, -8134},   {14221, -8136},   {14221, -8137},   {14220, -8138},   {14219, -8140},
    {14218, -8141},   {14217, -8143},   {14217, -8144},   {14216, -8145},   {14215, -8147},   {14214, -8148},
    {14214, -8149},   {14213, -8151},   {14212, -8152},   {14211, -8153},   {14210, -8155},   {14210, -8156},
    {14209, -8158},   {14208, -8159},   {14207, -8160},   {14206, -8162},   {14206, -8163},   {14205, -8164},
    {14204, -8166},   {14203, -8167},   {14203, -8168},   {14202, -8170},   {14201, -8171},   {14200, -8172},
    {14199, -8174},   {14199, -8175},   {14198, -8177},   {14197, -8178},   {14196, -8179},   {14196, -8181},
    {14195, -8182},   {14194, -8183},   {14193, -8185},   {14192, -8186},   {14192, -8187},   {14191, -8189},
    {14190, -8190},   {14189, -8192},   {14188, -8193},   {14188, -8194},   {14187, -8196},   {14186, -8197},
    {14185, -8198},   {14185, -8200},   {14184, -8201},   {14183, -8202},   {14182, -8204},   {14181, -8205},
    {14181, -8207},   {14180, -8208},   {14179, -8209},   {14178, -8211},   {14177, -8212},   {14177, -8213},
    {14176, -8215},   {14175, -8216},   {14174, -8217},   {14173, -8219},   {14173, -8220},   {14172, -8221},
    {14171, -8223},   {14170, -8224},   {14170, -8226},   {14169, -8227},   {14168, -8228},   {14167, -8230},
    {14166, -8231},   {14166, -8232},   {14165, -8234},   {14164, -8235},   {14163, -8236},   {14162, -8238},
    {14162, -8239},   {14161, -8240},   {14160, -8242},   {14159, -8243},   {14158, -8245},   {14158, -8246},
    {14157, -8247},   {14156, -8249},   {14155, -8250},   {14155, -8251},   {14154, -8253},   {14153, -8254},
    {14152, -8255},   {14151, -8257},   {14151, -8258},   {14150, -8259},   {14149, -8261},   {14148, -8262},
    {14147, -8264},   {14147, -8265},   {14146, -8266},   {14145, -8268},   {14144, -8269},   {14143, -8270},
    {14143, -8272},   {14142, -8273},   {14141, -8274},   {14140, -8276},   {14139, -8277},   {14139, -8278},
    {14138, -8280},   {14137, -8281},   {14136, -8283},   {14136, -8284},   {14135, -8285},   {14134, -8287},
    {14133, -8288},   {14132, -8289},   {14132, -8291},   {14131, -8292},   {14130, -8293},   {14129, -8295},
    {14128, -8296},   {14128, -8297},   {14127, -8299},   {14126, -8300},   {14125, -8301},   {14124, -8303},
    {14124, -8304},   {14123, -8306},   {14122, -8307},   {14121, -8308},   {14120, -8310},   {14120, -8311},
    {14119, -8312},   {14118, -8314},   {14117, -8315},   {14116, -8316},   {14116, -8318},   {14115, -8319},
    {14114, -8320},   {14113, -8322},   {14112, -8323},   {14112, -8324},   {14111, -8326},   {14110, -8327},
    {14109, -8329},   {14108, -8330},   {14108, -8331},   {14107, -8333},   {14106, -8334},   {14105, -8335},
    {14104, -8337},   {14104, -8338},   {14103, -8339},   {14102, -8341},   {14101, -8342},   {14100, -8343},
    {14100, -8345},   {14099, -8346},   {14098, -8347},   {14097, -8349},   {14096, -8350},   {14096, -8352},
    {14095, -8353},   {14094, -8354},   {14093, -8356},   {14092, -8357},   {14092, -8358},   {14091, -8360},
    {14090, -8361},   {14089, -8362},   {14088, -8364},   {14088, -8365},   {14087, -8366},   {14086, -8368},
    {14085, -8369},   {14084, -8370},   {14084, -8372},   {14083, -8373},   {14082, -8375},   {14081, -8376},
    {14080, -8377},   {14080, -8379},   {14079, -8380},   {14078, -8381},   {14077, -8383},   {14076, -8384},
    {14076, -8385},   {14075, -8387},   {14074, -8388},   {14073, -8389},   {14072, -8391},   {14072, -8392},
    {14071, -8393},   {14070, -8395},   {14069, -8396},   {14068, -8397},   {14068, -8399},   {14067, -8400},
    {14066, -8401},   {14065, -8403},   {14064, -8404},   {14064, -8406},   {14063, -8407},   {14062, -8408},
    {14061, -8410},   {14060, -8411},   {14059, -8412},   {14059, -8414},   {14058, -8415},   {14057, -8416},
    {14056, -8418},   {14055, -8419},   {14055, -8420},   {14054, -8422},   {14053, -8423},   {14052, -8424},
    {14051, -8426},   {14051, -8427},   {14050, -8428},   {14049, -8430},   {14048, -8431},   {14047, -8432},
    {14047, -8434},   {14046, -8435},   {14045, -8437},   {14044, -8438},   {14043, -8439},   {14043, -8441},
    {14042, -8442},   {14041, -8443},   {14040, -8445},   {14039, -8446},   {14038, -8447},   {14038, -8449},
    {14037, -8450},   {14036, -8451},   {14035, -8453},   {14034, -8454},   {14034, -8455},   {14033, -8457},
    {14032, -8458},   {14031, -8459},   {14030, -8461},   {14030, -8462},   {14029, -8463},   {14028, -8465},
    {14027, -8466},   {14026, -8467},   {14025, -8469},   {14025, -8470},   {14024, -8472},   {14023, -8473},
    {14022, -8474},   {14021, -8476},   {14021, -8477},   {14020, -8478},   {14019, -8480},   {14018, -8481},
    {14017, -8482},   {14017, -8484},   {14016, -8485},   {14015, -8486},   {14014, -8488},   {14013, -8489},
    {14012, -8490},   {14012, -8492},   {14011, -8493},   {14010, -8494},   {14009, -8496},   {14008, -8497},
    {14008, -8498},   {14007, -8500},   {14006, -8501},   {14005, -8502},   {14004, -8504},   {14004, -8505},
    {14003, -8506},   {14002, -8508},   {14001, -8509},   {14000, -8510},   {13999, -8512},   {13999, -8513},
    {13998, -8514},   {13997, -8516},   {13996, -8517},   {13995, -8519},   {13995, -8520},   {13994, -8521},
    {13993, -8523},   {13992, -8524},   {13991, -8525},   {13990, -8527},   {13990, -8528},   {13989, -8529},
    {13988, -8531},   {13987, -8532},   {13986, -8533},   {13986, -8535},   {13985, -8536},   {13984, -8537},
    {13983, -8539},   {13982, -8540},   {13981, -8541},   {13981, -8543},   {13980, -8544},   {13979, -8545},
    {13978, -8547},   {13977, -8548},   {13977, -8549},   {13976, -8551},   {13975, -8552},   {13974, -8553},
    {13973, -8555},   {13972, -8556},   {13972, -8557},   {13971, -8559},   {13970, -8560},   {13969, -8561},
    {13968, -8563},   {13968, -8564},   {13967, -8565},   {13966, -8567},   {13965, -8568},   {13964, -8569},
    {13963, -8571},   {13963, -8572},   {13962, -8573},   {13961, -8575},   {13960, -8576},   {13959, -8577},
    {13958, -8579},   {13958, -8580},   {13957, -8582},   {13956, -8583},   {13955, -8584},   {13954, -8586},
    {13954, -8587},   {13953, -8588},   {13952, -8590},   {13951, -8591},   {13950, -8592},   {13949, -8594},
    {13949, -8595},   {13948, -8596},   {13947, -8598},   {13946, -8599},   {13945, -8600},   {13944, -8602},
    {13944, -8603},   {13943, -8604},   {13942, -8606},   {13941, -8607},   {13940, -8608},   {13940, -8610},
    {13939, -8611},   {13938, -8612},   {13937, -8614},   {13936, -8615},   {13935, -8616},   {13935, -8618},
    {13934, -8619},   {13933, -8620},   {13932, -8622},   {13931, -8623},   {13930, -8624},   {13930, -8626},
    {13929, -8627},   {13928, -8628},   {13927, -8630},   {13926, -8631},   {13925, -8632},   {13925, -8634},
    {13924, -8635},   {13923, -8636},   {13922, -8638},   {13921, -8639},   {13921, -8640},   {13920, -8642},
    {13919, -8643},   {13918, -8644},   {13917, -8646},   {13916, -8647},   {13916, -8648},   {13915, -8650},
    {13914, -8651},   {13913, -8652},   {13912, -8654},   {13911, -8655},   {13911, -8656},   {13910, -8658},
    {13909, -8659},   {13908, -8660},   {13907, -8662},   {13906, -8663},   {13906, -8664},   {13905, -8666},
    {13904, -8667},   {13903, -8668},   {13902, -8670},   {13901, -8671},   {13901, -8672},   {13900, -8674},
    {13899, -8675},   {13898, -8676},   {13897, -8678},   {13896, -8679},   {13896, -8680},   {13895, -8682},
    {13894, -8683},   {13893, -8684},   {13892, -8686},   {13891, -8687},   {13891, -8688},   {13890, -8690},
    {13889, -8691},   {13888, -8692},   {13887, -8694},   {13886, -8695},   {13886, -8696},   {13885, -8698},
    {13884, -8699},   {13883, -8700},   {13882, -8702},   {13881, -8703},   {13881, -8704},   {13880, -8706},
    {13879, -8707},   {13878, -8708},   {13877, -8710},   {13876, -8711},   {13876, -8712},   {13875, -8714},
    {13874, -8715},   {13873, -8716},   {13872, -8718},   {13871, -8719},   {13871, -8720},   {13870, -8722},
    {13869, -8723},   {13868, -8724},   {13867, -8726},   {13866, -8727},   {13866, -8728},   {13865, -8730},
    {13864, -8731},   {13863, -8732},   {13862, -8734},   {13861, -8735},   {13861, -8736},   {13860, -8738},
    {13859, -8739},   {13858, -8740},   {13857, -8742},   {13856, -8743},   {13856, -8744},   {13855, -8745},
    {13854, -8747},   {13853, -8748},   {13852, -8749},   {13851, -8751},   {13850, -8752},   {13850, -8753},
    {13849, -8755},   {13848, -8756},   {13847, -8757},   {13846, -8759},   {13845, -8760},   {13845, -8761},
    {13844, -8763},   {13843, -8764},   {13842, -8765},   {13841, -8767},   {13840, -8768},   {13840, -8769},
    {13839, -8771},   {13838, -8772},   {13837, -8773},   {13836, -8775},   {13835, -8776},   {13835, -8777},
    {13834, -8779},   {13833, -8780},   {13832, -8781},   {13831, -8783},   {13830, -8784},   {13829, -8785},
    {13829, -8787},   {13828, -8788},   {13827, -8789},   {13826, -8791},   {13825, -8792},   {13824, -8793},
    {13824, -8795},   {13823, -8796},   {13822, -8797},   {13821, -8799},   {13820, -8800},   {13819, -8801},
    {13819, -8803},   {13818, -8804},   {13817, -8805},   {13816, -8807},   {13815, -8808},   {13814, -8809},
    {13813, -8810},   {13813, -8812},   {13812, -8813},   {13811, -8814},   {13810, -8816},   {13809, -8817},
    {13808, -8818},   {13808, -8820},   {13807, -8821},   {13806, -8822},   {13805, -8824},   {13804, -8825},
    {13803, -8826},   {13802, -8828},   {13802, -8829},   {13801, -8830},   {13800, -8832},   {13799, -8833},
    {13798, -8834},   {13797, -8836},   {13797, -8837},   {13796, -8838},   {13795, -8840},   {13794, -8841},
    {13793, -8842},   {13792, -8844},   {13791, -8845},   {13791, -8846},   {13790, -8848},   {13789, -8849},
    {13788, -8850},   {13787, -8851},   {13786, -8853},   {13785, -8854},   {13785, -8855},   {13784, -8857},
    {13783, -8858},   {13782, -8859},   {13781, -8861},   {13780, -8862},   {13780, -8863},   {13779, -8865},
    {13778, -8866},   {13777, -8867},   {13776, -8869},   {13775, -8870},   {13774, -8871},   {13774, -8873},
    {13773, -8874},   {13772, -8875},   {13771, -8877},   {13770, -8878},   {13769, -8879},   {13768, -8881},
    {13768, -8882},   {13767, -8883},   {13766, -8885},   {13765, -8886},   {13764, -8887},   {13763, -8888},
    {13763, -8890},   {13762, -8891},   {13761, -8892},   {13760, -8894},   {13759, -8895},   {13758, -8896},
    {13757, -8898},   {13757, -8899},   {13756, -8900},   {13755, -8902},   {13754, -8903},   {13753, -8904},
    {13752, -8906},   {13751, -8907},   {13751, -8908},   {13750, -8910},   {13749, -8911},   {13748, -8912},
    {13747, -8914},   {13746, -8915},   {13745, -8916},   {13745, -8917},   {13744, -8919},   {13743, -8920},
    {13742, -8921},   {13741, -8923},   {13740, -8924},   {13739, -8925},   {13739, -8927},   {13738, -8928},
    {13737, -8929},   {13736, -8931},   {13735, -8932},   {13734, -8933},   {13733, -8935},   {13733, -8936},
    {13732, -8937},   {13731, -8939},   {13730, -8940},   {13729, -8941},   {13728, -8943},   {13727, -8944},
    {13727, -8945},   {13726, -8946},   {13725, -8948},   {13724, -8949},   {13723, -8950},   {13722, -8952},
    {13721, -8953},   {13721, -8954},   {13720, -8956},   {13719, -8957},   {13718, -8958},   {13717, -8960},
    {13716, -8961},   {13715, -8962},   {13715, -8964},   {13714, -8965},   {13713, -8966},   {13712, -8967},
    {13711, -8969},   {13710, -8970},   {13709, -8971},   {13709, -8973},   {13708, -8974},   {13707, -8975},
    {13706, -8977},   {13705, -8978},   {13704, -8979},   {13703, -8981},   {13703, -8982},   {13702, -8983},
    {13701, -8985},   {13700, -8986},   {13699, -8987},   {13698, -8989},   {13697, -8990},   {13697, -8991},
    {13696, -8992},   {13695, -8994},   {13694, -8995},   {13693, -8996},   {13692, -8998},   {13691, -8999},
    {13690, -9000},   {13690, -9002},   {13689, -9003},   {13688, -9004},   {13687, -9006},   {13686, -9007},
    {13685, -9008},   {13684, -9010},   {13684, -9011},   {13683, -9012},   {13682, -9013},   {13681, -9015},
    {13680, -9016},   {13679, -9017},   {13678, -9019},   {13678, -9020},   {13677, -9021},   {13676, -9023},
    {13675, -9024},   {13674, -9025},   {13673, -9027},   {13672, -9028},   {13671, -9029},   {13671, -9031},
    {13670, -9032},   {13669, -9033},   {13668, -9034},   {13667, -9036},   {13666, -9037},   {13665, -9038},
    {13665, -9040},   {13664, -9041},   {13663, -9042},   {13662, -9044},   {13661, -9045},   {13660, -9046},
    {13659, -9048},   {13658, -9049},   {13658, -9050},   {13657, -9051},   {13656, -9053},   {13655, -9054},
    {13654, -9055},   {13653, -9057},   {13652, -9058},   {13652, -9059},   {13651, -9061},   {13650, -9062},
    {13649, -9063},   {13648, -9065},   {13647, -9066},   {13646, -9067},   {13645, -9068},   {13645, -9070},
    {13644, -9071},   {13643, -9072},   {13642, -9074},   {13641, -9075},   {13640, -9076},   {13639, -9078},
    {13638, -9079},   {13638, -9080},   {13637, -9082},   {13636, -9083},   {13635, -9084},   {13634, -9085},
    {13633, -9087},   {13632, -9088},   {13632, -9089},   {13631, -9091},   {13630, -9092},   {13629, -9093},
    {13628, -9095},   {13627, -9096},   {13626, -9097},   {13625, -9099},   {13625, -9100},   {13624, -9101},
    {13623, -9102},   {13622, -9104},   {13621, -9105},   {13620, -9106},   {13619, -9108},   {13618, -9109},
    {13618, -9110},   {13617, -9112},   {13616, -9113},   {13615, -9114},   {13614, -9116},   {13613, -9117},
    {13612, -9118},   {13611, -9119},   {13611, -9121},   {13610, -9122},   {13609, -9123},   {13608, -9125},
    {13607, -9126},   {13606, -9127},   {13605, -9129},   {13604, -9130},   {13604, -9131},   {13603, -9132},
    {13602, -9134},   {13601, -9135},   {13600, -9136},   {13599, -9138},   {13598, -9139},   {13597, -9140},
    {13597, -9142},   {13596, -9143},   {13595, -9144},   {13594, -9146},   {13593, -9147},   {13592, -9148},
    {13591, -9149},   {13590, -9151},   {13590, -9152},   {13589, -9153},   {13588, -9155},   {13587, -9156},
    {13586, -9157},   {13585, -9159},   {13584, -9160},   {13583, -9161},   {13583, -9162},   {13582, -9164},
    {13581, -9165},   {13580, -9166},   {13579, -9168},   {13578, -9169},   {13577, -9170},   {13576, -9172},
    {13575, -9173},   {13575, -9174},   {13574, -9175},   {13573, -9177},   {13572, -9178},   {13571, -9179},
    {13570, -9181},   {13569, -9182},   {13568, -9183},   {13568, -9185},   {13567, -9186},   {13566, -9187},
    {13565, -9188},   {13564, -9190},   {13563, -9191},   {13562, -9192},   {13561, -9194},   {13561, -9195},
    {13560, -9196},   {13559, -9198},   {13558, -9199},   {13557, -9200},   {13556, -9201},   {13555, -9203},
    {13554, -9204},   {13553, -9205},   {13553, -9207},   {13552, -9208},   {13551, -9209},   {13550, -9211},
    {13549, -9212},   {13548, -9213},   {13547, -9214},   {13546, -9216},   {13546, -9217},   {13545, -9218},
    {13544, -9220},   {13543, -9221},   {13542, -9222},   {13541, -9224},   {13540, -9225},   {13539, -9226},
    {13538, -9227},   {13538, -9229},   {13537, -9230},   {13536, -9231},   {13535, -9233},   {13534, -9234},
    {13533, -9235},   {13532, -9237},   {13531, -9238},   {13530, -9239},   {13530, -9240},   {13529, -9242},
    {13528, -9243},   {13527, -9244},   {13526, -9246},   {13525, -9247},   {13524, -9248},   {13523, -9250},
    {13523, -9251},   {13522, -9252},   {13521, -9253},   {13520, -9255},   {13519, -9256},   {13518, -9257},
    {13517, -9259},   {13516, -9260},   {13515, -9261},   {13515, -9262},   {13514, -9264},   {13513, -9265},
    {13512, -9266},   {13511, -9268},   {13510, -9269},   {13509, -9270},   {13508, -9272},   {13507, -9273},
    {13507, -9274},   {13506, -9275},   {13505, -9277},   {13504, -9278},   {13503, -9279},   {13502, -9281},
    {13501, -9282},   {13500, -9283},   {13499, -9284},   {13499, -9286},   {13498, -9287},   {13497, -9288},
    {13496, -9290},   {13495, -9291},   {13494, -9292},   {13493, -9294},   {13492, -9295},   {13491, -9296},
    {13490, -9297},   {13490, -9299},   {13489, -9300},   {13488, -9301},   {13487, -9303},   {13486, -9304},
    {13485, -9305},   {13484, -9306},   {13483, -9308},   {13482, -9309},   {13482, -9310},   {13481, -9312},
    {13480, -9313},   {13479, -9314},   {13478, -9316},   {13477, -9317},   {13476, -9318},   {13475, -9319},
    {13474, -9321},   {13474, -9322},   {13473, -9323},   {13472, -9325},   {13471, -9326},   {13470, -9327},
    {13469, -9328},   {13468, -9330},   {13467, -9331},   {13466, -9332},   {13465, -9334},   {13465, -9335},
    {13464, -9336},   {13463, -9337},   {13462, -9339},   {13461, -9340},   {13460, -9341},   {13459, -9343},
    {13458, -9344},   {13457, -9345},   {13457, -9347},   {13456, -9348},   {13455, -9349},   {13454, -9350},
    {13453, -9352},   {13452, -9353},   {13451, -9354},   {13450, -9356},   {13449, -9357},   {13448, -9358},
    {13448, -9359},   {13447, -9361},   {13446, -9362},   {13445, -9363},   {13444, -9365},   {13443, -9366},
    {13442, -9367},   {13441, -9368},   {13440, -9370},   {13439, -9371},   {13439, -9372},   {13438, -9374},
    {13437, -9375},   {13436, -9376},   {13435, -9377},   {13434, -9379},   {13433, -9380},   {13432, -9381},
    {13431, -9383},   {13430, -9384},   {13430, -9385},   {13429, -9386},   {13428, -9388},   {13427, -9389},
    {13426, -9390},   {13425, -9392},   {13424, -9393},   {13423, -9394},   {13422, -9395},   {13421, -9397},
    {13421, -9398},   {13420, -9399},   {13419, -9401},   {13418, -9402},   {13417, -9403},   {13416, -9404},
    {13415, -9406},   {13414, -9407},   {13413, -9408},   {13412, -9410},   {13412, -9411},   {13411, -9412},
    {13410, -9413},   {13409, -9415},   {13408, -9416},   {13407, -9417},   {13406, -9419},   {13405, -9420},
    {13404, -9421},   {13403, -9422},   {13403, -9424},   {13402, -9425},   {13401, -9426},   {13400, -9428},
    {13399, -9429},   {13398, -9430},   {13397, -9431},   {13396, -9433},   {13395, -9434},   {13394, -9435},
    {13394, -9437},   {13393, -9438},   {13392, -9439},   {13391, -9440},   {13390, -9442},   {13389, -9443},
    {13388, -9444},   {13387, -9446},   {13386, -9447},   {13385, -9448},   {13384, -9449},   {13384, -9451},
    {13383, -9452},   {13382, -9453},   {13381, -9455},   {13380, -9456},   {13379, -9457},   {13378, -9458},
    {13377, -9460},   {13376, -9461},   {13375, -9462},   {13374, -9464},   {13374, -9465},   {13373, -9466},
    {13372, -9467},   {13371, -9469},   {13370, -9470},   {13369, -9471},   {13368, -9473},   {13367, -9474},
    {13366, -9475},   {13365, -9476},   {13364, -9478},   {13364, -9479},   {13363, -9480},   {13362, -9481},
    {13361, -9483},   {13360, -9484},   {13359, -9485},   {13358, -9487},   {13357, -9488},   {13356, -9489},
    {13355, -9490},   {13354, -9492},   {13354, -9493},   {13353, -9494},   {13352, -9496},   {13351, -9497},
    {13350, -9498},   {13349, -9499},   {13348, -9501},   {13347, -9502},   {13346, -9503},   {13345, -9505},
    {13344, -9506},   {13344, -9507},   {13343, -9508},   {13342, -9510},   {13341, -9511},   {13340, -9512},
    {13339, -9513},   {13338, -9515},   {13337, -9516},   {13336, -9517},   {13335, -9519},   {13334, -9520},
    {13334, -9521},   {13333, -9522},   {13332, -9524},   {13331, -9525},   {13330, -9526},   {13329, -9528},
    {13328, -9529},   {13327, -9530},   {13326, -9531},   {13325, -9533},   {13324, -9534},   {13323, -9535},
    {13323, -9537},   {13322, -9538},   {13321, -9539},   {13320, -9540},   {13319, -9542},   {13318, -9543},
    {13317, -9544},   {13316, -9545},   {13315, -9547},   {13314, -9548},   {13313, -9549},   {13312, -9551},
    {13312, -9552},   {13311, -9553},   {13310, -9554},   {13309, -9556},   {13308, -9557},   {13307, -9558},
    {13306, -9559},   {13305, -9561},   {13304, -9562},   {13303, -9563},   {13302, -9565},   {13301, -9566},
    {13301, -9567},   {13300, -9568},   {13299, -9570},   {13298, -9571},   {13297, -9572},   {13296, -9574},
    {13295, -9575},   {13294, -9576},   {13293, -9577},   {13292, -9579},   {13291, -9580},   {13290, -9581},
    {13290, -9582},   {13289, -9584},   {13288, -9585},   {13287, -9586},   {13286, -9588},   {13285, -9589},
    {13284, -9590},   {13283, -9591},   {13282, -9593},   {13281, -9594},   {13280, -9595},   {13279, -9596},
    {13279, -9598},   {13278, -9599},   {13277, -9600},   {13276, -9602},   {13275, -9603},   {13274, -9604},
    {13273, -9605},   {13272, -9607},   {13271, -9608},   {13270, -9609},   {13269, -9610},   {13268, -9612},
    {13267, -9613},   {13267, -9614},   {13266, -9616},   {13265, -9617},   {13264, -9618},   {13263, -9619},
    {13262, -9621},   {13261, -9622},   {13260, -9623},   {13259, -9624},   {13258, -9626},   {13257, -9627},
    {13256, -9628},   {13255, -9630},   {13255, -9631},   {13254, -9632},   {13253, -9633},   {13252, -9635},
    {13251, -9636},   {13250, -9637},   {13249, -9638},   {13248, -9640},   {13247, -9641},   {13246, -9642},
    {13245, -9643},   {13244, -9645},   {13243, -9646},   {13243, -9647},   {13242, -9649},   {13241, -9650},
    {13240, -9651},   {13239, -9652},   {13238, -9654},   {13237, -9655},   {13236, -9656},   {13235, -9657},
    {13234, -9659},   {13233, -9660},   {13232, -9661},   {13231, -9663},   {13231, -9664},   {13230, -9665},
    {13229, -9666},   {13228, -9668},   {13227, -9669},   {13226, -9670},   {13225, -9671},   {13224, -9673},
    {13223, -9674},   {13222, -9675},   {13221, -9676},   {13220, -9678},   {13219, -9679},   {13218, -9680},
    {13218, -9682},   {13217, -9683},   {13216, -9684},   {13215, -9685},   {13214, -9687},   {13213, -9688},
    {13212, -9689},   {13211, -9690},   {13210, -9692},   {13209, -9693},   {13208, -9694},   {13207, -9695},
    {13206, -9697},   {13205, -9698},   {13205, -9699},   {13204, -9701},   {13203, -9702},   {13202, -9703},
    {13201, -9704},   {13200, -9706},   {13199, -9707},   {13198, -9708},   {13197, -9709},   {13196, -9711},
    {13195, -9712},   {13194, -9713},   {13193, -9714},   {13192, -9716},   {13191, -9717},   {13191, -9718},
    {13190, -9720},   {13189, -9721},   {13188, -9722},   {13187, -9723},   {13186, -9725},   {13185, -9726},
    {13184, -9727},   {13183, -9728},   {13182, -9730},   {13181, -9731},   {13180, -9732},   {13179, -9733},
    {13178, -9735},   {13178, -9736},   {13177, -9737},   {13176, -9738},   {13175, -9740},   {13174, -9741},
    {13173, -9742},   {13172, -9744},   {13171, -9745},   {13170, -9746},   {13169, -9747},   {13168, -9749},
    {13167, -9750},   {13166, -9751},   {13165, -9752},   {13164, -9754},   {13163, -9755},   {13163, -9756},
    {13162, -9757},   {13161, -9759},   {13160, -9760},   {13159, -9761},   {13158, -9762},   {13157, -9764},
    {13156, -9765},   {13155, -9766},   {13154, -9768},   {13153, -9769},   {13152, -9770},   {13151, -9771},
    {13150, -9773},   {13149, -9774},   {13149, -9775},   {13148, -9776},   {13147, -9778},   {13146, -9779},
    {13145, -9780},   {13144, -9781},   {13143, -9783},   {13142, -9784},   {13141, -9785},   {13140, -9786},
    {13139, -9788},   {13138, -9789},   {13137, -9790},   {13136, -9791},   {13135, -9793},   {13134, -9794},
    {13134, -9795},   {13133, -9796},   {13132, -9798},   {13131, -9799},   {13130, -9800},   {13129, -9802},
    {13128, -9803},   {13127, -9804},   {13126, -9805},   {13125, -9807},   {13124, -9808},   {13123, -9809},
    {13122, -9810},   {13121, -9812},   {13120, -9813},   {13119, -9814},   {13118, -9815},   {13118, -9817},
    {13117, -9818},   {13116, -9819},   {13115, -9820},   {13114, -9822},   {13113, -9823},   {13112, -9824},
    {13111, -9825},   {13110, -9827},   {13109, -9828},   {13108, -9829},   {13107, -9830},   {13106, -9832},
    {13105, -9833},   {13104, -9834},   {13103, -9835},   {13102, -9837},   {13102, -9838},   {13101, -9839},
    {13100, -9841},   {13099, -9842},   {13098, -9843},   {13097, -9844},   {13096, -9846},   {13095, -9847},
    {13094, -9848},   {13093, -9849},   {13092, -9851},   {13091, -9852},   {13090, -9853},   {13089, -9854},
    {13088, -9856},   {13087, -9857},   {13086, -9858},   {13085, -9859},   {13085, -9861},   {13084, -9862},
    {13083, -9863},   {13082, -9864},   {13081, -9866},   {13080, -9867},   {13079, -9868},   {13078, -9869},
    {13077, -9871},   {13076, -9872},   {13075, -9873},   {13074, -9874},   {13073, -9876},   {13072, -9877},
    {13071, -9878},   {13070, -9879},   {13069, -9881},   {13068, -9882},   {13067, -9883},   {13067, -9884},
    {13066, -9886},   {13065, -9887},   {13064, -9888},   {13063, -9889},   {13062, -9891},   {13061, -9892},
    {13060, -9893},   {13059, -9894},   {13058, -9896},   {13057, -9897},   {13056, -9898},   {13055, -9899},
    {13054, -9901},   {13053, -9902},   {13052, -9903},   {13051, -9904},   {13050, -9906},   {13049, -9907},
    {13048, -9908},   {13048, -9909},   {13047, -9911},   {13046, -9912},   {13045, -9913},   {13044, -9914},
    {13043, -9916},   {13042, -9917},   {13041, -9918},   {13040, -9919},   {13039, -9921},   {13038, -9922},
    {13037, -9923},   {13036, -9924},   {13035, -9926},   {13034, -9927},   {13033, -9928},   {13032, -9929},
    {13031, -9931},   {13030, -9932},   {13029, -9933},   {13029, -9934},   {13028, -9936},   {13027, -9937},
    {13026, -9938},   {13025, -9939},   {13024, -9941},   {13023, -9942},   {13022, -9943},   {13021, -9944},
    {13020, -9946},   {13019, -9947},   {13018, -9948},   {13017, -9949},   {13016, -9951},   {13015, -9952},
    {13014, -9953},   {13013, -9954},   {13012, -9956},   {13011, -9957},   {13010, -9958},   {13009, -9959},
    {13008, -9961},   {13008, -9962},   {13007, -9963},   {13006, -9964},   {13005, -9966},   {13004, -9967},
    {13003, -9968},   {13002, -9969},   {13001, -9971},   {13000, -9972},   {12999, -9973},   {12998, -9974},
    {12997, -9976},   {12996, -9977},   {12995, -9978},   {12994, -9979},   {12993, -9981},   {12992, -9982},
    {12991, -9983},   {12990, -9984},   {12989, -9986},   {12988, -9987},   {12987, -9988},   {12986, -9989},
    {12986, -9991},   {12985, -9992},   {12984, -9993},   {12983, -9994},   {12982, -9996},   {12981, -9997},
    {12980, -9998},   {12979, -9999},   {12978, -10001},  {12977, -10002},  {12976, -10003},  {12975, -10004},
    {12974, -10005},  {12973, -10007},  {12972, -10008},  {12971, -10009},  {12970, -10010},  {12969, -10012},
    {12968, -10013},  {12967, -10014},  {12966, -10015},  {12965, -10017},  {12964, -10018},  {12963, -10019},
    {12963, -10020},  {12962, -10022},  {12961, -10023},  {12960, -10024},  {12959, -10025},  {12958, -10027},
    {12957, -10028},  {12956, -10029},  {12955, -10030},  {12954, -10032},  {12953, -10033},  {12952, -10034},
    {12951, -10035},  {12950, -10037},  {12949, -10038},  {12948, -10039},  {12947, -10040},  {12946, -10042},
    {12945, -10043},  {12944, -10044},  {12943, -10045},  {12942, -10046},  {12941, -10048},  {12940, -10049},
    {12939, -10050},  {12938, -10051},  {12938, -10053},  {12937, -10054},  {12936, -10055},  {12935, -10056},
    {12934, -10058},  {12933, -10059},  {12932, -10060},  {12931, -10061},  {12930, -10063},  {12929, -10064},
    {12928, -10065},  {12927, -10066},  {12926, -10068},  {12925, -10069},  {12924, -10070},  {12923, -10071},
    {12922, -10073},  {12921, -10074},  {12920, -10075},  {12919, -10076},  {12918, -10077},  {12917, -10079},
    {12916, -10080},  {12915, -10081},  {12914, -10082},  {12913, -10084},  {12912, -10085},  {12911, -10086},
    {12910, -10087},  {12910, -10089},  {12909, -10090},  {12908, -10091},  {12907, -10092},  {12906, -10094},
    {12905, -10095},  {12904, -10096},  {12903, -10097},  {12902, -10099},  {12901, -10100},  {12900, -10101},
    {12899, -10102},  {12898, -10103},  {12897, -10105},  {12896, -10106},  {12895, -10107},  {12894, -10108},
    {12893, -10110},  {12892, -10111},  {12891, -10112},  {12890, -10113},  {12889, -10115},  {12888, -10116},
    {12887, -10117},  {12886, -10118},  {12885, -10120},  {12884, -10121},  {12883, -10122},  {12882, -10123},
    {12881, -10124},  {12880, -10126},  {12879, -10127},  {12878, -10128},  {12878, -10129},  {12877, -10131},
    {12876, -10132},  {12875, -10133},  {12874, -10134},  {12873, -10136},  {12872, -10137},  {12871, -10138},
    {12870, -10139},  {12869, -10141},  {12868, -10142},  {12867, -10143},  {12866, -10144},  {12865, -10145},
    {12864, -10147},  {12863, -10148},  {12862, -10149},  {12861, -10150},  {12860, -10152},  {12859, -10153},
    {12858, -10154},  {12857, -10155},  {12856, -10157},  {12855, -10158},  {12854, -10159},  {12853, -10160},
    {12852, -10161},  {12851, -10163},  {12850, -10164},  {12849, -10165},  {12848, -10166},  {12847, -10168},
    {12846, -10169},  {12845, -10170},  {12844, -10171},  {12843, -10173},  {12842, -10174},  {12842, -10175},
    {12841, -10176},  {12840, -10177},  {12839, -10179},  {12838, -10180},  {12837, -10181},  {12836, -10182},
    {12835, -10184},  {12834, -10185},  {12833, -10186},  {12832, -10187},  {12831, -10189},  {12830, -10190},
    {12829, -10191},  {12828, -10192},  {12827, -10193},  {12826, -10195},  {12825, -10196},  {12824, -10197},
    {12823, -10198},  {12822, -10200},  {12821, -10201},  {12820, -10202},  {12819, -10203},  {12818, -10205},
    {12817, -10206},  {12816, -10207},  {12815, -10208},  {12814, -10209},  {12813, -10211},  {12812, -10212},
    {12811, -10213},  {12810, -10214},  {12809, -10216},  {12808, -10217},  {12807, -10218},  {12806, -10219},
    {12805, -10221},  {12804, -10222},  {12803, -10223},  {12802, -10224},  {12801, -10225},  {12800, -10227},
    {12799, -10228},  {12798, -10229},  {12797, -10230},  {12797, -10232},  {12796, -10233},  {12795, -10234},
    {12794, -10235},  {12793, -10236},  {12792, -10238},  {12791, -10239},  {12790, -10240},  {12789, -10241},
    {12788, -10243},  {12787, -10244},  {12786, -10245},  {12785, -10246},  {12784, -10248},  {12783, -10249},
    {12782, -10250},  {12781, -10251},  {12780, -10252},  {12779, -10254},  {12778, -10255},  {12777, -10256},
    {12776, -10257},  {12775, -10259},  {12774, -10260},  {12773, -10261},  {12772, -10262},  {12771, -10263},
    {12770, -10265},  {12769, -10266},  {12768, -10267},  {12767, -10268},  {12766, -10270},  {12765, -10271},
    {12764, -10272},  {12763, -10273},  {12762, -10274},  {12761, -10276},  {12760, -10277},  {12759, -10278},
    {12758, -10279},  {12757, -10281},  {12756, -10282},  {12755, -10283},  {12754, -10284},  {12753, -10285},
    {12752, -10287},  {12751, -10288},  {12750, -10289},  {12749, -10290},  {12748, -10292},  {12747, -10293},
    {12746, -10294},  {12745, -10295},  {12744, -10296},  {12743, -10298},  {12742, -10299},  {12741, -10300},
    {12740, -10301},  {12739, -10303},  {12738, -10304},  {12737, -10305},  {12736, -10306},  {12735, -10307},
    {12734, -10309},  {12733, -10310},  {12732, -10311},  {12732, -10312},  {12731, -10314},  {12730, -10315},
    {12729, -10316},  {12728, -10317},  {12727, -10318},  {12726, -10320},  {12725, -10321},  {12724, -10322},
    {12723, -10323},  {12722, -10325},  {12721, -10326},  {12720, -10327},  {12719, -10328},  {12718, -10329},
    {12717, -10331},  {12716, -10332},  {12715, -10333},  {12714, -10334},  {12713, -10336},  {12712, -10337},
    {12711, -10338},  {12710, -10339},  {12709, -10340},  {12708, -10342},  {12707, -10343},  {12706, -10344},
    {12705, -10345},  {12704, -10346},  {12703, -10348},  {12702, -10349},  {12701, -10350},  {12700, -10351},
    {12699, -10353},  {12698, -10354},  {12697, -10355},  {12696, -10356},  {12695, -10357},  {12694, -10359},
    {12693, -10360},  {12692, -10361},  {12691, -10362},  {12690, -10364},  {12689, -10365},  {12688, -10366},
    {12687, -10367},  {12686, -10368},  {12685, -10370},  {12684, -10371},  {12683, -10372},  {12682, -10373},
    {12681, -10374},  {12680, -10376},  {12679, -10377},  {12678, -10378},  {12677, -10379},  {12676, -10381},
    {12675, -10382},  {12674, -10383},  {12673, -10384},  {12672, -10385},  {12671, -10387},  {12670, -10388},
    {12669, -10389},  {12668, -10390},  {12667, -10391},  {12666, -10393},  {12665, -10394},  {12664, -10395},
    {12663, -10396},  {12662, -10398},  {12661, -10399},  {12660, -10400},  {12659, -10401},  {12658, -10402},
    {12657, -10404},  {12656, -10405},  {12655, -10406},  {12654, -10407},  {12653, -10408},  {12652, -10410},
    {12651, -10411},  {12650, -10412},  {12649, -10413},  {12648, -10415},  {12647, -10416},  {12646, -10417},
    {12645, -10418},  {12644, -10419},  {12643, -10421},  {12642, -10422},  {12641, -10423},  {12640, -10424},
    {12639, -10425},  {12638, -10427},  {12637, -10428},  {12636, -10429},  {12635, -10430},  {12634, -10431},
    {12633, -10433},  {12632, -10434},  {12631, -10435},  {12630, -10436},  {12629, -10438},  {12628, -10439},
    {12627, -10440},  {12626, -10441},  {12625, -10442},  {12624, -10444},  {12623, -10445},  {12622, -10446},
    {12621, -10447},  {12620, -10448},  {12619, -10450},  {12618, -10451},  {12617, -10452},  {12616, -10453},
    {12615, -10454},  {12614, -10456},  {12613, -10457},  {12612, -10458},  {12611, -10459},  {12610, -10461},
    {12609, -10462},  {12608, -10463},  {12607, -10464},  {12606, -10465},  {12605, -10467},  {12604, -10468},
    {12603, -10469},  {12602, -10470},  {12601, -10471},  {12600, -10473},  {12599, -10474},  {12598, -10475},
    {12597, -10476},  {12596, -10477},  {12595, -10479},  {12594, -10480},  {12593, -10481},  {12592, -10482},
    {12591, -10483},  {12590, -10485},  {12589, -10486},  {12588, -10487},  {12587, -10488},  {12586, -10490},
    {12585, -10491},  {12584, -10492},  {12583, -10493},  {12582, -10494},  {12581, -10496},  {12580, -10497},
    {12579, -10498},  {12578, -10499},  {12577, -10500},  {12576, -10502},  {12575, -10503},  {12574, -10504},
    {12573, -10505},  {12572, -10506},  {12571, -10508},  {12570, -10509},  {12569, -10510},  {12568, -10511},
    {12567, -10512},  {12566, -10514},  {12565, -10515},  {12564, -10516},  {12563, -10517},  {12562, -10518},
    {12561, -10520},  {12560, -10521},  {12559, -10522},  {12558, -10523},  {12557, -10524},  {12556, -10526},
    {12555, -10527},  {12554, -10528},  {12553, -10529},  {12552, -10530},  {12551, -10532},  {12550, -10533},
    {12549, -10534},  {12548, -10535},  {12547, -10537},  {12546, -10538},  {12545, -10539},  {12544, -10540},
    {12543, -10541},  {12542, -10543},  {12541, -10544},  {12540, -10545},  {12539, -10546},  {12538, -10547},
    {12537, -10549},  {12535, -10550},  {12534, -10551},  {12533, -10552},  {12532, -10553},  {12531, -10555},
    {12530, -10556},  {12529, -10557},  {12528, -10558},  {12527, -10559},  {12526, -10561},  {12525, -10562},
    {12524, -10563},  {12523, -10564},  {12522, -10565},  {12521, -10567},  {12520, -10568},  {12519, -10569},
    {12518, -10570},  {12517, -10571},  {12516, -10573},  {12515, -10574},  {12514, -10575},  {12513, -10576},
    {12512, -10577},  {12511, -10579},  {12510, -10580},  {12509, -10581},  {12508, -10582},  {12507, -10583},
    {12506, -10585},  {12505, -10586},  {12504, -10587},  {12503, -10588},  {12502, -10589},  {12501, -10591},
    {12500, -10592},  {12499, -10593},  {12498, -10594},  {12497, -10595},  {12496, -10597},  {12495, -10598},
    {12494, -10599},  {12493, -10600},  {12492, -10601},  {12491, -10603},  {12490, -10604},  {12489, -10605},
    {12488, -10606},  {12487, -10607},  {12486, -10609},  {12485, -10610},  {12484, -10611},  {12483, -10612},
    {12482, -10613},  {12481, -10614},  {12480, -10616},  {12479, -10617},  {12478, -10618},  {12477, -10619},
    {12476, -10620},  {12475, -10622},  {12474, -10623},  {12473, -10624},  {12472, -10625},  {12471, -10626},
    {12470, -10628},  {12468, -10629},  {12467, -10630},  {12466, -10631},  {12465, -10632},  {12464, -10634},
    {12463, -10635},  {12462, -10636},  {12461, -10637},  {12460, -10638},  {12459, -10640},  {12458, -10641},
    {12457, -10642},  {12456, -10643},  {12455, -10644},  {12454, -10646},  {12453, -10647},  {12452, -10648},
    {12451, -10649},  {12450, -10650},  {12449, -10652},  {12448, -10653},  {12447, -10654},  {12446, -10655},
    {12445, -10656},  {12444, -10658},  {12443, -10659},  {12442, -10660},  {12441, -10661},  {12440, -10662},
    {12439, -10663},  {12438, -10665},  {12437, -10666},  {12436, -10667},  {12435, -10668},  {12434, -10669},
    {12433, -10671},  {12432, -10672},  {12431, -10673},  {12430, -10674},  {12429, -10675},  {12428, -10677},
    {12427, -10678},  {12426, -10679},  {12425, -10680},  {12424, -10681},  {12423, -10683},  {12421, -10684},
    {12420, -10685},  {12419, -10686},  {12418, -10687},  {12417, -10688},  {12416, -10690},  {12415, -10691},
    {12414, -10692},  {12413, -10693},  {12412, -10694},  {12411, -10696},  {12410, -10697},  {12409, -10698},
    {12408, -10699},  {12407, -10700},  {12406, -10702},  {12405, -10703},  {12404, -10704},  {12403, -10705},
    {12402, -10706},  {12401, -10708},  {12400, -10709},  {12399, -10710},  {12398, -10711},  {12397, -10712},
    {12396, -10713},  {12395, -10715},  {12394, -10716},  {12393, -10717},  {12392, -10718},  {12391, -10719},
    {12390, -10721},  {12389, -10722},  {12388, -10723},  {12387, -10724},  {12386, -10725},  {12385, -10727},
    {12384, -10728},  {12382, -10729},  {12381, -10730},  {12380, -10731},  {12379, -10732},  {12378, -10734},
    {12377, -10735},  {12376, -10736},  {12375, -10737},  {12374, -10738},  {12373, -10740},  {12372, -10741},
    {12371, -10742},  {12370, -10743},  {12369, -10744},  {12368, -10746},  {12367, -10747},  {12366, -10748},
    {12365, -10749},  {12364, -10750},  {12363, -10751},  {12362, -10753},  {12361, -10754},  {12360, -10755},
    {12359, -10756},  {12358, -10757},  {12357, -10759},  {12356, -10760},  {12355, -10761},  {12354, -10762},
    {12353, -10763},  {12352, -10764},  {12351, -10766},  {12350, -10767},  {12348, -10768},  {12347, -10769},
    {12346, -10770},  {12345, -10772},  {12344, -10773},  {12343, -10774},  {12342, -10775},  {12341, -10776},
    {12340, -10778},  {12339, -10779},  {12338, -10780},  {12337, -10781},  {12336, -10782},  {12335, -10783},
    {12334, -10785},  {12333, -10786},  {12332, -10787},  {12331, -10788},  {12330, -10789},  {12329, -10791},
    {12328, -10792},  {12327, -10793},  {12326, -10794},  {12325, -10795},  {12324, -10796},  {12323, -10798},
    {12322, -10799},  {12321, -10800},  {12320, -10801},  {12318, -10802},  {12317, -10804},  {12316, -10805},
    {12315, -10806},  {12314, -10807},  {12313, -10808},  {12312, -10809},  {12311, -10811},  {12310, -10812},
    {12309, -10813},  {12308, -10814},  {12307, -10815},  {12306, -10816},  {12305, -10818},  {12304, -10819},
    {12303, -10820},  {12302, -10821},  {12301, -10822},  {12300, -10824},  {12299, -10825},  {12298, -10826},
    {12297, -10827},  {12296, -10828},  {12295, -10829},  {12294, -10831},  {12293, -10832},  {12292, -10833},
    {12290, -10834},  {12289, -10835},  {12288, -10837},  {12287, -10838},  {12286, -10839},  {12285, -10840},
    {12284, -10841},  {12283, -10842},  {12282, -10844},  {12281, -10845},  {12280, -10846},  {12279, -10847},
    {12278, -10848},  {12277, -10849},  {12276, -10851},  {12275, -10852},  {12274, -10853},  {12273, -10854},
    {12272, -10855},  {12271, -10857},  {12270, -10858},  {12269, -10859},  {12268, -10860},  {12267, -10861},
    {12266, -10862},  {12264, -10864},  {12263, -10865},  {12262, -10866},  {12261, -10867},  {12260, -10868},
    {12259, -10869},  {12258, -10871},  {12257, -10872},  {12256, -10873},  {12255, -10874},  {12254, -10875},
    {12253, -10877},  {12252, -10878},  {12251, -10879},  {12250, -10880},  {12249, -10881},  {12248, -10882},
    {12247, -10884},  {12246, -10885},  {12245, -10886},  {12244, -10887},  {12243, -10888},  {12242, -10889},
    {12240, -10891},  {12239, -10892},  {12238, -10893},  {12237, -10894},  {12236, -10895},  {12235, -10896},
    {12234, -10898},  {12233, -10899},  {12232, -10900},  {12231, -10901},  {12230, -10902},  {12229, -10904},
    {12228, -10905},  {12227, -10906},  {12226, -10907},  {12225, -10908},  {12224, -10909},  {12223, -10911},
    {12222, -10912},  {12221, -10913},  {12220, -10914},  {12219, -10915},  {12217, -10916},  {12216, -10918},
    {12215, -10919},  {12214, -10920},  {12213, -10921},  {12212, -10922},  {12211, -10923},  {12210, -10925},
    {12209, -10926},  {12208, -10927},  {12207, -10928},  {12206, -10929},  {12205, -10930},  {12204, -10932},
    {12203, -10933},  {12202, -10934},  {12201, -10935},  {12200, -10936},  {12199, -10937},  {12198, -10939},
    {12197, -10940},  {12195, -10941},  {12194, -10942},  {12193, -10943},  {12192, -10945},  {12191, -10946},
    {12190, -10947},  {12189, -10948},  {12188, -10949},  {12187, -10950},  {12186, -10952},  {12185, -10953},
    {12184, -10954},  {12183, -10955},  {12182, -10956},  {12181, -10957},  {12180, -10959},  {12179, -10960},
    {12178, -10961},  {12177, -10962},  {12176, -10963},  {12174, -10964},  {12173, -10966},  {12172, -10967},
    {12171, -10968},  {12170, -10969},  {12169, -10970},  {12168, -10971},  {12167, -10973},  {12166, -10974},
    {12165, -10975},  {12164, -10976},  {12163, -10977},  {12162, -10978},  {12161, -10980},  {12160, -10981},
    {12159, -10982},  {12158, -10983},  {12157, -10984},  {12156, -10985},  {12155, -10987},  {12153, -10988},
    {12152, -10989},  {12151, -10990},  {12150, -10991},  {12149, -10992},  {12148, -10994},  {12147, -10995},
    {12146, -10996},  {12145, -10997},  {12144, -10998},  {12143, -10999},  {12142, -11000},  {12141, -11002},
    {12140, -11003},  {12139, -11004},  {12138, -11005},  {12137, -11006},  {12136, -11007},  {12134, -11009},
    {12133, -11010},  {12132, -11011},  {12131, -11012},  {12130, -11013},  {12129, -11014},  {12128, -11016},
    {12127, -11017},  {12126, -11018},  {12125, -11019},  {12124, -11020},  {12123, -11021},  {12122, -11023},
    {12121, -11024},  {12120, -11025},  {12119, -11026},  {12118, -11027},  {12117, -11028},  {12115, -11030},
    {12114, -11031},  {12113, -11032},  {12112, -11033},  {12111, -11034},  {12110, -11035},  {12109, -11037},
    {12108, -11038},  {12107, -11039},  {12106, -11040},  {12105, -11041},  {12104, -11042},  {12103, -11043},
    {12102, -11045},  {12101, -11046},  {12100, -11047},  {12099, -11048},  {12097, -11049},  {12096, -11050},
    {12095, -11052},  {12094, -11053},  {12093, -11054},  {12092, -11055},  {12091, -11056},  {12090, -11057},
    {12089, -11059},  {12088, -11060},  {12087, -11061},  {12086, -11062},  {12085, -11063},  {12084, -11064},
    {12083, -11066},  {12082, -11067},  {12080, -11068},  {12079, -11069},  {12078, -11070},  {12077, -11071},
    {12076, -11072},  {12075, -11074},  {12074, -11075},  {12073, -11076},  {12072, -11077},  {12071, -11078},
    {12070, -11079},  {12069, -11081},  {12068, -11082},  {12067, -11083},  {12066, -11084},  {12065, -11085},
    {12064, -11086},  {12062, -11088},  {12061, -11089},  {12060, -11090},  {12059, -11091},  {12058, -11092},
    {12057, -11093},  {12056, -11094},  {12055, -11096},  {12054, -11097},  {12053, -11098},  {12052, -11099},
    {12051, -11100},  {12050, -11101},  {12049, -11103},  {12048, -11104},  {12046, -11105},  {12045, -11106},
    {12044, -11107},  {12043, -11108},  {12042, -11109},  {12041, -11111},  {12040, -11112},  {12039, -11113},
    {12038, -11114},  {12037, -11115},  {12036, -11116},  {12035, -11118},  {12034, -11119},  {12033, -11120},
    {12032, -11121},  {12031, -11122},  {12029, -11123},  {12028, -11124},  {12027, -11126},  {12026, -11127},
    {12025, -11128},  {12024, -11129},  {12023, -11130},  {12022, -11131},  {12021, -11133},  {12020, -11134},
    {12019, -11135},  {12018, -11136},  {12017, -11137},  {12016, -11138},  {12014, -11139},  {12013, -11141},
    {12012, -11142},  {12011, -11143},  {12010, -11144},  {12009, -11145},  {12008, -11146},  {12007, -11148},
    {12006, -11149},  {12005, -11150},  {12004, -11151},  {12003, -11152},  {12002, -11153},  {12001, -11154},
    {12000, -11156},  {11998, -11157},  {11997, -11158},  {11996, -11159},  {11995, -11160},  {11994, -11161},
    {11993, -11162},  {11992, -11164},  {11991, -11165},  {11990, -11166},  {11989, -11167},  {11988, -11168},
    {11987, -11169},  {11986, -11171},  {11985, -11172},  {11983, -11173},  {11982, -11174},  {11981, -11175},
    {11980, -11176},  {11979, -11177},  {11978, -11179},  {11977, -11180},  {11976, -11181},  {11975, -11182},
    {11974, -11183},  {11973, -11184},  {11972, -11185},  {11971, -11187},  {11970, -11188},  {11968, -11189},
    {11967, -11190},  {11966, -11191},  {11965, -11192},  {11964, -11193},  {11963, -11195},  {11962, -11196},
    {11961, -11197},  {11960, -11198},  {11959, -11199},  {11958, -11200},  {11957, -11202},  {11956, -11203},
    {11955, -11204},  {11953, -11205},  {11952, -11206},  {11951, -11207},  {11950, -11208},  {11949, -11210},
    {11948, -11211},  {11947, -11212},  {11946, -11213},  {11945, -11214},  {11944, -11215},  {11943, -11216},
    {11942, -11218},  {11941, -11219},  {11939, -11220},  {11938, -11221},  {11937, -11222},  {11936, -11223},
    {11935, -11224},  {11934, -11226},  {11933, -11227},  {11932, -11228},  {11931, -11229},  {11930, -11230},
    {11929, -11231},  {11928, -11232},  {11927, -11234},  {11925, -11235},  {11924, -11236},  {11923, -11237},
    {11922, -11238},  {11921, -11239},  {11920, -11240},  {11919, -11242},  {11918, -11243},  {11917, -11244},
    {11916, -11245},  {11915, -11246},  {11914, -11247},  {11913, -11248},  {11911, -11250},  {11910, -11251},
    {11909, -11252},  {11908, -11253},  {11907, -11254},  {11906, -11255},  {11905, -11256},  {11904, -11258},
    {11903, -11259},  {11902, -11260},  {11901, -11261},  {11900, -11262},  {11899, -11263},  {11897, -11264},
    {11896, -11266},  {11895, -11267},  {11894, -11268},  {11893, -11269},  {11892, -11270},  {11891, -11271},
    {11890, -11272},  {11889, -11274},  {11888, -11275},  {11887, -11276},  {11886, -11277},  {11884, -11278},
    {11883, -11279},  {11882, -11280},  {11881, -11281},  {11880, -11283},  {11879, -11284},  {11878, -11285},
    {11877, -11286},  {11876, -11287},  {11875, -11288},  {11874, -11289},  {11873, -11291},  {11871, -11292},
    {11870, -11293},  {11869, -11294},  {11868, -11295},  {11867, -11296},  {11866, -11297},  {11865, -11299},
    {11864, -11300},  {11863, -11301},  {11862, -11302},  {11861, -11303},  {11860, -11304},  {11858, -11305},
    {11857, -11307},  {11856, -11308},  {11855, -11309},  {11854, -11310},  {11853, -11311},  {11852, -11312},
    {11851, -11313},  {11850, -11314},  {11849, -11316},  {11848, -11317},  {11847, -11318},  {11845, -11319},
    {11844, -11320},  {11843, -11321},  {11842, -11322},  {11841, -11324},  {11840, -11325},  {11839, -11326},
    {11838, -11327},  {11837, -11328},  {11836, -11329},  {11835, -11330},  {11834, -11332},  {11832, -11333},
    {11831, -11334},  {11830, -11335},  {11829, -11336},  {11828, -11337},  {11827, -11338},  {11826, -11339},
    {11825, -11341},  {11824, -11342},  {11823, -11343},  {11822, -11344},  {11820, -11345},  {11819, -11346},
    {11818, -11347},  {11817, -11349},  {11816, -11350},  {11815, -11351},  {11814, -11352},  {11813, -11353},
    {11812, -11354},  {11811, -11355},  {11810, -11356},  {11809, -11358},  {11807, -11359},  {11806, -11360},
    {11805, -11361},  {11804, -11362},  {11803, -11363},  {11802, -11364},  {11801, -11366},  {11800, -11367},
    {11799, -11368},  {11798, -11369},  {11797, -11370},  {11795, -11371},  {11794, -11372},  {11793, -11373},
    {11792, -11375},  {11791, -11376},  {11790, -11377},  {11789, -11378},  {11788, -11379},  {11787, -11380},
    {11786, -11381},  {11785, -11382},  {11783, -11384},  {11782, -11385},  {11781, -11386},  {11780, -11387},
    {11779, -11388},  {11778, -11389},  {11777, -11390},  {11776, -11391},  {11775, -11393},  {11774, -11394},
    {11773, -11395},  {11771, -11396},  {11770, -11397},  {11769, -11398},  {11768, -11399},  {11767, -11401},
    {11766, -11402},  {11765, -11403},  {11764, -11404},  {11763, -11405},  {11762, -11406},  {11760, -11407},
    {11759, -11408},  {11758, -11410},  {11757, -11411},  {11756, -11412},  {11755, -11413},  {11754, -11414},
    {11753, -11415},  {11752, -11416},  {11751, -11417},  {11750, -11419},  {11748, -11420},  {11747, -11421},
    {11746, -11422},  {11745, -11423},  {11744, -11424},  {11743, -11425},  {11742, -11426},  {11741, -11428},
    {11740, -11429},  {11739, -11430},  {11737, -11431},  {11736, -11432},  {11735, -11433},  {11734, -11434},
    {11733, -11435},  {11732, -11437},  {11731, -11438},  {11730, -11439},  {11729, -11440},  {11728, -11441},
    {11727, -11442},  {11725, -11443},  {11724, -11444},  {11723, -11446},  {11722, -11447},  {11721, -11448},
    {11720, -11449},  {11719, -11450},  {11718, -11451},  {11717, -11452},  {11716, -11453},  {11714, -11455},
    {11713, -11456},  {11712, -11457},  {11711, -11458},  {11710, -11459},  {11709, -11460},  {11708, -11461},
    {11707, -11462},  {11706, -11464},  {11705, -11465},  {11703, -11466},  {11702, -11467},  {11701, -11468},
    {11700, -11469},  {11699, -11470},  {11698, -11471},  {11697, -11473},  {11696, -11474},  {11695, -11475},
    {11694, -11476},  {11692, -11477},  {11691, -11478},  {11690, -11479},  {11689, -11480},  {11688, -11481},
    {11687, -11483},  {11686, -11484},  {11685, -11485},  {11684, -11486},  {11683, -11487},  {11681, -11488},
    {11680, -11489},  {11679, -11490},  {11678, -11492},  {11677, -11493},  {11676, -11494},  {11675, -11495},
    {11674, -11496},  {11673, -11497},  {11672, -11498},  {11670, -11499},  {11669, -11501},  {11668, -11502},
    {11667, -11503},  {11666, -11504},  {11665, -11505},  {11664, -11506},  {11663, -11507},  {11662, -11508},
    {11661, -11509},  {11659, -11511},  {11658, -11512},  {11657, -11513},  {11656, -11514},  {11655, -11515},
    {11654, -11516},  {11653, -11517},  {11652, -11518},  {11651, -11520},  {11649, -11521},  {11648, -11522},
    {11647, -11523},  {11646, -11524},  {11645, -11525},  {11644, -11526},  {11643, -11527},  {11642, -11528},
    {11641, -11530},  {11640, -11531},  {11638, -11532},  {11637, -11533},  {11636, -11534},  {11635, -11535},
    {11634, -11536},  {11633, -11537},  {11632, -11538},  {11631, -11540},  {11630, -11541},  {11628, -11542},
    {11627, -11543},  {11626, -11544},  {11625, -11545},  {11624, -11546},  {11623, -11547},  {11622, -11549},
    {11621, -11550},  {11620, -11551},  {11619, -11552},  {11617, -11553},  {11616, -11554},  {11615, -11555},
    {11614, -11556},  {11613, -11557},  {11612, -11559},  {11611, -11560},  {11610, -11561},  {11609, -11562},
    {11607, -11563},  {11606, -11564},  {11605, -11565},  {11604, -11566},  {11603, -11567},  {11602, -11569},
    {11601, -11570},  {11600, -11571},  {11599, -11572},  {11597, -11573},  {11596, -11574},  {11595, -11575},
    {11594, -11576},  {11593, -11577},  {11592, -11579},  {11591, -11580},  {11590, -11581},  {11589, -11582},
    {11587, -11583},  {11586, -11584},  {11585, -11585},  {11584, -11586},  {11583, -11587},  {11582, -11589},
    {11581, -11590},  {11580, -11591},  {11579, -11592},  {11577, -11593},  {11576, -11594},  {11575, -11595},
    {11574, -11596},  {11573, -11597},  {11572, -11599},  {11571, -11600},  {11570, -11601},  {11569, -11602},
    {11567, -11603},  {11566, -11604},  {11565, -11605},  {11564, -11606},  {11563, -11607},  {11562, -11609},
    {11561, -11610},  {11560, -11611},  {11559, -11612},  {11557, -11613},  {11556, -11614},  {11555, -11615},
    {11554, -11616},  {11553, -11617},  {11552, -11619},  {11551, -11620},  {11550, -11621},  {11549, -11622},
    {11547, -11623},  {11546, -11624},  {11545, -11625},  {11544, -11626},  {11543, -11627},  {11542, -11628},
    {11541, -11630},  {11540, -11631},  {11538, -11632},  {11537, -11633},  {11536, -11634},  {11535, -11635},
    {11534, -11636},  {11533, -11637},  {11532, -11638},  {11531, -11640},  {11530, -11641},  {11528, -11642},
    {11527, -11643},  {11526, -11644},  {11525, -11645},  {11524, -11646},  {11523, -11647},  {11522, -11648},
    {11521, -11649},  {11520, -11651},  {11518, -11652},  {11517, -11653},  {11516, -11654},  {11515, -11655},
    {11514, -11656},  {11513, -11657},  {11512, -11658},  {11511, -11659},  {11509, -11661},  {11508, -11662},
    {11507, -11663},  {11506, -11664},  {11505, -11665},  {11504, -11666},  {11503, -11667},  {11502, -11668},
    {11501, -11669},  {11499, -11670},  {11498, -11672},  {11497, -11673},  {11496, -11674},  {11495, -11675},
    {11494, -11676},  {11493, -11677},  {11492, -11678},  {11490, -11679},  {11489, -11680},  {11488, -11681},
    {11487, -11683},  {11486, -11684},  {11485, -11685},  {11484, -11686},  {11483, -11687},  {11481, -11688},
    {11480, -11689},  {11479, -11690},  {11478, -11691},  {11477, -11692},  {11476, -11694},  {11475, -11695},
    {11474, -11696},  {11473, -11697},  {11471, -11698},  {11470, -11699},  {11469, -11700},  {11468, -11701},
    {11467, -11702},  {11466, -11703},  {11465, -11705},  {11464, -11706},  {11462, -11707},  {11461, -11708},
    {11460, -11709},  {11459, -11710},  {11458, -11711},  {11457, -11712},  {11456, -11713},  {11455, -11714},
    {11453, -11716},  {11452, -11717},  {11451, -11718},  {11450, -11719},  {11449, -11720},  {11448, -11721},
    {11447, -11722},  {11446, -11723},  {11444, -11724},  {11443, -11725},  {11442, -11727},  {11441, -11728},
    {11440, -11729},  {11439, -11730},  {11438, -11731},  {11437, -11732},  {11435, -11733},  {11434, -11734},
    {11433, -11735},  {11432, -11736},  {11431, -11737},  {11430, -11739},  {11429, -11740},  {11428, -11741},
    {11426, -11742},  {11425, -11743},  {11424, -11744},  {11423, -11745},  {11422, -11746},  {11421, -11747},
    {11420, -11748},  {11419, -11750},  {11417, -11751},  {11416, -11752},  {11415, -11753},  {11414, -11754},
    {11413, -11755},  {11412, -11756},  {11411, -11757},  {11410, -11758},  {11408, -11759},  {11407, -11760},
    {11406, -11762},  {11405, -11763},  {11404, -11764},  {11403, -11765},  {11402, -11766},  {11401, -11767},
    {11399, -11768},  {11398, -11769},  {11397, -11770},  {11396, -11771},  {11395, -11773},  {11394, -11774},
    {11393, -11775},  {11391, -11776},  {11390, -11777},  {11389, -11778},  {11388, -11779},  {11387, -11780},
    {11386, -11781},  {11385, -11782},  {11384, -11783},  {11382, -11785},  {11381, -11786},  {11380, -11787},
    {11379, -11788},  {11378, -11789},  {11377, -11790},  {11376, -11791},  {11375, -11792},  {11373, -11793},
    {11372, -11794},  {11371, -11795},  {11370, -11797},  {11369, -11798},  {11368, -11799},  {11367, -11800},
    {11366, -11801},  {11364, -11802},  {11363, -11803},  {11362, -11804},  {11361, -11805},  {11360, -11806},
    {11359, -11807},  {11358, -11809},  {11356, -11810},  {11355, -11811},  {11354, -11812},  {11353, -11813},
    {11352, -11814},  {11351, -11815},  {11350, -11816},  {11349, -11817},  {11347, -11818},  {11346, -11819},
    {11345, -11820},  {11344, -11822},  {11343, -11823},  {11342, -11824},  {11341, -11825},  {11339, -11826},
    {11338, -11827},  {11337, -11828},  {11336, -11829},  {11335, -11830},  {11334, -11831},  {11333, -11832},
    {11332, -11834},  {11330, -11835},  {11329, -11836},  {11328, -11837},  {11327, -11838},  {11326, -11839},
    {11325, -11840},  {11324, -11841},  {11322, -11842},  {11321, -11843},  {11320, -11844},  {11319, -11845},
    {11318, -11847},  {11317, -11848},  {11316, -11849},  {11314, -11850},  {11313, -11851},  {11312, -11852},
    {11311, -11853},  {11310, -11854},  {11309, -11855},  {11308, -11856},  {11307, -11857},  {11305, -11858},
    {11304, -11860},  {11303, -11861},  {11302, -11862},  {11301, -11863},  {11300, -11864},  {11299, -11865},
    {11297, -11866},  {11296, -11867},  {11295, -11868},  {11294, -11869},  {11293, -11870},  {11292, -11871},
    {11291, -11873},  {11289, -11874},  {11288, -11875},  {11287, -11876},  {11286, -11877},  {11285, -11878},
    {11284, -11879},  {11283, -11880},  {11281, -11881},  {11280, -11882},  {11279, -11883},  {11278, -11884},
    {11277, -11886},  {11276, -11887},  {11275, -11888},  {11274, -11889},  {11272, -11890},  {11271, -11891},
    {11270, -11892},  {11269, -11893},  {11268, -11894},  {11267, -11895},  {11266, -11896},  {11264, -11897},
    {11263, -11899},  {11262, -11900},  {11261, -11901},  {11260, -11902},  {11259, -11903},  {11258, -11904},
    {11256, -11905},  {11255, -11906},  {11254, -11907},  {11253, -11908},  {11252, -11909},  {11251, -11910},
    {11250, -11911},  {11248, -11913},  {11247, -11914},  {11246, -11915},  {11245, -11916},  {11244, -11917},
    {11243, -11918},  {11242, -11919},  {11240, -11920},  {11239, -11921},  {11238, -11922},  {11237, -11923},
    {11236, -11924},  {11235, -11925},  {11234, -11927},  {11232, -11928},  {11231, -11929},  {11230, -11930},
    {11229, -11931},  {11228, -11932},  {11227, -11933},  {11226, -11934},  {11224, -11935},  {11223, -11936},
    {11222, -11937},  {11221, -11938},  {11220, -11939},  {11219, -11941},  {11218, -11942},  {11216, -11943},
    {11215, -11944},  {11214, -11945},  {11213, -11946},  {11212, -11947},  {11211, -11948},  {11210, -11949},
    {11208, -11950},  {11207, -11951},  {11206, -11952},  {11205, -11953},  {11204, -11955},  {11203, -11956},
    {11202, -11957},  {11200, -11958},  {11199, -11959},  {11198, -11960},  {11197, -11961},  {11196, -11962},
    {11195, -11963},  {11193, -11964},  {11192, -11965},  {11191, -11966},  {11190, -11967},  {11189, -11968},
    {11188, -11970},  {11187, -11971},  {11185, -11972},  {11184, -11973},  {11183, -11974},  {11182, -11975},
    {11181, -11976},  {11180, -11977},  {11179, -11978},  {11177, -11979},  {11176, -11980},  {11175, -11981},
    {11174, -11982},  {11173, -11983},  {11172, -11985},  {11171, -11986},  {11169, -11987},  {11168, -11988},
    {11167, -11989},  {11166, -11990},  {11165, -11991},  {11164, -11992},  {11162, -11993},  {11161, -11994},
    {11160, -11995},  {11159, -11996},  {11158, -11997},  {11157, -11998},  {11156, -12000},  {11154, -12001},
    {11153, -12002},  {11152, -12003},  {11151, -12004},  {11150, -12005},  {11149, -12006},  {11148, -12007},
    {11146, -12008},  {11145, -12009},  {11144, -12010},  {11143, -12011},  {11142, -12012},  {11141, -12013},
    {11139, -12014},  {11138, -12016},  {11137, -12017},  {11136, -12018},  {11135, -12019},  {11134, -12020},
    {11133, -12021},  {11131, -12022},  {11130, -12023},  {11129, -12024},  {11128, -12025},  {11127, -12026},
    {11126, -12027},  {11124, -12028},  {11123, -12029},  {11122, -12031},  {11121, -12032},  {11120, -12033},
    {11119, -12034},  {11118, -12035},  {11116, -12036},  {11115, -12037},  {11114, -12038},  {11113, -12039},
    {11112, -12040},  {11111, -12041},  {11109, -12042},  {11108, -12043},  {11107, -12044},  {11106, -12045},
    {11105, -12046},  {11104, -12048},  {11103, -12049},  {11101, -12050},  {11100, -12051},  {11099, -12052},
    {11098, -12053},  {11097, -12054},  {11096, -12055},  {11094, -12056},  {11093, -12057},  {11092, -12058},
    {11091, -12059},  {11090, -12060},  {11089, -12061},  {11088, -12062},  {11086, -12064},  {11085, -12065},
    {11084, -12066},  {11083, -12067},  {11082, -12068},  {11081, -12069},  {11079, -12070},  {11078, -12071},
    {11077, -12072},  {11076, -12073},  {11075, -12074},  {11074, -12075},  {11072, -12076},  {11071, -12077},
    {11070, -12078},  {11069, -12079},  {11068, -12080},  {11067, -12082},  {11066, -12083},  {11064, -12084},
    {11063, -12085},  {11062, -12086},  {11061, -12087},  {11060, -12088},  {11059, -12089},  {11057, -12090},
    {11056, -12091},  {11055, -12092},  {11054, -12093},  {11053, -12094},  {11052, -12095},  {11050, -12096},
    {11049, -12097},  {11048, -12099},  {11047, -12100},  {11046, -12101},  {11045, -12102},  {11043, -12103},
    {11042, -12104},  {11041, -12105},  {11040, -12106},  {11039, -12107},  {11038, -12108},  {11037, -12109},
    {11035, -12110},  {11034, -12111},  {11033, -12112},  {11032, -12113},  {11031, -12114},  {11030, -12115},
    {11028, -12117},  {11027, -12118},  {11026, -12119},  {11025, -12120},  {11024, -12121},  {11023, -12122},
    {11021, -12123},  {11020, -12124},  {11019, -12125},  {11018, -12126},  {11017, -12127},  {11016, -12128},
    {11014, -12129},  {11013, -12130},  {11012, -12131},  {11011, -12132},  {11010, -12133},  {11009, -12134},
    {11007, -12136},  {11006, -12137},  {11005, -12138},  {11004, -12139},  {11003, -12140},  {11002, -12141},
    {11000, -12142},  {10999, -12143},  {10998, -12144},  {10997, -12145},  {10996, -12146},  {10995, -12147},
    {10994, -12148},  {10992, -12149},  {10991, -12150},  {10990, -12151},  {10989, -12152},  {10988, -12153},
    {10987, -12155},  {10985, -12156},  {10984, -12157},  {10983, -12158},  {10982, -12159},  {10981, -12160},
    {10980, -12161},  {10978, -12162},  {10977, -12163},  {10976, -12164},  {10975, -12165},  {10974, -12166},
    {10973, -12167},  {10971, -12168},  {10970, -12169},  {10969, -12170},  {10968, -12171},  {10967, -12172},
    {10966, -12173},  {10964, -12174},  {10963, -12176},  {10962, -12177},  {10961, -12178},  {10960, -12179},
    {10959, -12180},  {10957, -12181},  {10956, -12182},  {10955, -12183},  {10954, -12184},  {10953, -12185},
    {10952, -12186},  {10950, -12187},  {10949, -12188},  {10948, -12189},  {10947, -12190},  {10946, -12191},
    {10945, -12192},  {10943, -12193},  {10942, -12194},  {10941, -12195},  {10940, -12197},  {10939, -12198},
    {10937, -12199},  {10936, -12200},  {10935, -12201},  {10934, -12202},  {10933, -12203},  {10932, -12204},
    {10930, -12205},  {10929, -12206},  {10928, -12207},  {10927, -12208},  {10926, -12209},  {10925, -12210},
    {10923, -12211},  {10922, -12212},  {10921, -12213},  {10920, -12214},  {10919, -12215},  {10918, -12216},
    {10916, -12217},  {10915, -12219},  {10914, -12220},  {10913, -12221},  {10912, -12222},  {10911, -12223},
    {10909, -12224},  {10908, -12225},  {10907, -12226},  {10906, -12227},  {10905, -12228},  {10904, -12229},
    {10902, -12230},  {10901, -12231},  {10900, -12232},  {10899, -12233},  {10898, -12234},  {10896, -12235},
    {10895, -12236},  {10894, -12237},  {10893, -12238},  {10892, -12239},  {10891, -12240},  {10889, -12242},
    {10888, -12243},  {10887, -12244},  {10886, -12245},  {10885, -12246},  {10884, -12247},  {10882, -12248},
    {10881, -12249},  {10880, -12250},  {10879, -12251},  {10878, -12252},  {10877, -12253},  {10875, -12254},
    {10874, -12255},  {10873, -12256},  {10872, -12257},  {10871, -12258},  {10869, -12259},  {10868, -12260},
    {10867, -12261},  {10866, -12262},  {10865, -12263},  {10864, -12264},  {10862, -12266},  {10861, -12267},
    {10860, -12268},  {10859, -12269},  {10858, -12270},  {10857, -12271},  {10855, -12272},  {10854, -12273},
    {10853, -12274},  {10852, -12275},  {10851, -12276},  {10849, -12277},  {10848, -12278},  {10847, -12279},
    {10846, -12280},  {10845, -12281},  {10844, -12282},  {10842, -12283},  {10841, -12284},  {10840, -12285},
    {10839, -12286},  {10838, -12287},  {10837, -12288},  {10835, -12289},  {10834, -12290},  {10833, -12292},
    {10832, -12293},  {10831, -12294},  {10829, -12295},  {10828, -12296},  {10827, -12297},  {10826, -12298},
    {10825, -12299},  {10824, -12300},  {10822, -12301},  {10821, -12302},  {10820, -12303},  {10819, -12304},
    {10818, -12305},  {10816, -12306},  {10815, -12307},  {10814, -12308},  {10813, -12309},  {10812, -12310},
    {10811, -12311},  {10809, -12312},  {10808, -12313},  {10807, -12314},  {10806, -12315},  {10805, -12316},
    {10804, -12317},  {10802, -12318},  {10801, -12320},  {10800, -12321},  {10799, -12322},  {10798, -12323},
    {10796, -12324},  {10795, -12325},  {10794, -12326},  {10793, -12327},  {10792, -12328},  {10791, -12329},
    {10789, -12330},  {10788, -12331},  {10787, -12332},  {10786, -12333},  {10785, -12334},  {10783, -12335},
    {10782, -12336},  {10781, -12337},  {10780, -12338},  {10779, -12339},  {10778, -12340},  {10776, -12341},
    {10775, -12342},  {10774, -12343},  {10773, -12344},  {10772, -12345},  {10770, -12346},  {10769, -12347},
    {10768, -12348},  {10767, -12350},  {10766, -12351},  {10764, -12352},  {10763, -12353},  {10762, -12354},
    {10761, -12355},  {10760, -12356},  {10759, -12357},  {10757, -12358},  {10756, -12359},  {10755, -12360},
    {10754, -12361},  {10753, -12362},  {10751, -12363},  {10750, -12364},  {10749, -12365},  {10748, -12366},
    {10747, -12367},  {10746, -12368},  {10744, -12369},  {10743, -12370},  {10742, -12371},  {10741, -12372},
    {10740, -12373},  {10738, -12374},  {10737, -12375},  {10736, -12376},  {10735, -12377},  {10734, -12378},
    {10732, -12379},  {10731, -12380},  {10730, -12381},  {10729, -12382},  {10728, -12384},  {10727, -12385},
    {10725, -12386},  {10724, -12387},  {10723, -12388},  {10722, -12389},  {10721, -12390},  {10719, -12391},
    {10718, -12392},  {10717, -12393},  {10716, -12394},  {10715, -12395},  {10713, -12396},  {10712, -12397},
    {10711, -12398},  {10710, -12399},  {10709, -12400},  {10708, -12401},  {10706, -12402},  {10705, -12403},
    {10704, -12404},  {10703, -12405},  {10702, -12406},  {10700, -12407},  {10699, -12408},  {10698, -12409},
    {10697, -12410},  {10696, -12411},  {10694, -12412},  {10693, -12413},  {10692, -12414},  {10691, -12415},
    {10690, -12416},  {10688, -12417},  {10687, -12418},  {10686, -12419},  {10685, -12420},  {10684, -12421},
    {10683, -12423},  {10681, -12424},  {10680, -12425},  {10679, -12426},  {10678, -12427},  {10677, -12428},
    {10675, -12429},  {10674, -12430},  {10673, -12431},  {10672, -12432},  {10671, -12433},  {10669, -12434},
    {10668, -12435},  {10667, -12436},  {10666, -12437},  {10665, -12438},  {10663, -12439},  {10662, -12440},
    {10661, -12441},  {10660, -12442},  {10659, -12443},  {10658, -12444},  {10656, -12445},  {10655, -12446},
    {10654, -12447},  {10653, -12448},  {10652, -12449},  {10650, -12450},  {10649, -12451},  {10648, -12452},
    {10647, -12453},  {10646, -12454},  {10644, -12455},  {10643, -12456},  {10642, -12457},  {10641, -12458},
    {10640, -12459},  {10638, -12460},  {10637, -12461},  {10636, -12462},  {10635, -12463},  {10634, -12464},
    {10632, -12465},  {10631, -12466},  {10630, -12467},  {10629, -12468},  {10628, -12470},  {10626, -12471},
    {10625, -12472},  {10624, -12473},  {10623, -12474},  {10622, -12475},  {10620, -12476},  {10619, -12477},
    {10618, -12478},  {10617, -12479},  {10616, -12480},  {10614, -12481},  {10613, -12482},  {10612, -12483},
    {10611, -12484},  {10610, -12485},  {10609, -12486},  {10607, -12487},  {10606, -12488},  {10605, -12489},
    {10604, -12490},  {10603, -12491},  {10601, -12492},  {10600, -12493},  {10599, -12494},  {10598, -12495},
    {10597, -12496},  {10595, -12497},  {10594, -12498},  {10593, -12499},  {10592, -12500},  {10591, -12501},
    {10589, -12502},  {10588, -12503},  {10587, -12504},  {10586, -12505},  {10585, -12506},  {10583, -12507},
    {10582, -12508},  {10581, -12509},  {10580, -12510},  {10579, -12511},  {10577, -12512},  {10576, -12513},
    {10575, -12514},  {10574, -12515},  {10573, -12516},  {10571, -12517},  {10570, -12518},  {10569, -12519},
    {10568, -12520},  {10567, -12521},  {10565, -12522},  {10564, -12523},  {10563, -12524},  {10562, -12525},
    {10561, -12526},  {10559, -12527},  {10558, -12528},  {10557, -12529},  {10556, -12530},  {10555, -12531},
    {10553, -12532},  {10552, -12533},  {10551, -12534},  {10550, -12535},  {10549, -12537},  {10547, -12538},
    {10546, -12539},  {10545, -12540},  {10544, -12541},  {10543, -12542},  {10541, -12543},  {10540, -12544},
    {10539, -12545},  {10538, -12546},  {10537, -12547},  {10535, -12548},  {10534, -12549},  {10533, -12550},
    {10532, -12551},  {10530, -12552},  {10529, -12553},  {10528, -12554},  {10527, -12555},  {10526, -12556},
    {10524, -12557},  {10523, -12558},  {10522, -12559},  {10521, -12560},  {10520, -12561},  {10518, -12562},
    {10517, -12563},  {10516, -12564},  {10515, -12565},  {10514, -12566},  {10512, -12567},  {10511, -12568},
    {10510, -12569},  {10509, -12570},  {10508, -12571},  {10506, -12572},  {10505, -12573},  {10504, -12574},
    {10503, -12575},  {10502, -12576},  {10500, -12577},  {10499, -12578},  {10498, -12579},  {10497, -12580},
    {10496, -12581},  {10494, -12582},  {10493, -12583},  {10492, -12584},  {10491, -12585},  {10490, -12586},
    {10488, -12587},  {10487, -12588},  {10486, -12589},  {10485, -12590},  {10483, -12591},  {10482, -12592},
    {10481, -12593},  {10480, -12594},  {10479, -12595},  {10477, -12596},  {10476, -12597},  {10475, -12598},
    {10474, -12599},  {10473, -12600},  {10471, -12601},  {10470, -12602},  {10469, -12603},  {10468, -12604},
    {10467, -12605},  {10465, -12606},  {10464, -12607},  {10463, -12608},  {10462, -12609},  {10461, -12610},
    {10459, -12611},  {10458, -12612},  {10457, -12613},  {10456, -12614},  {10454, -12615},  {10453, -12616},
    {10452, -12617},  {10451, -12618},  {10450, -12619},  {10448, -12620},  {10447, -12621},  {10446, -12622},
    {10445, -12623},  {10444, -12624},  {10442, -12625},  {10441, -12626},  {10440, -12627},  {10439, -12628},
    {10438, -12629},  {10436, -12630},  {10435, -12631},  {10434, -12632},  {10433, -12633},  {10431, -12634},
    {10430, -12635},  {10429, -12636},  {10428, -12637},  {10427, -12638},  {10425, -12639},  {10424, -12640},
    {10423, -12641},  {10422, -12642},  {10421, -12643},  {10419, -12644},  {10418, -12645},  {10417, -12646},
    {10416, -12647},  {10415, -12648},  {10413, -12649},  {10412, -12650},  {10411, -12651},  {10410, -12652},
    {10408, -12653},  {10407, -12654},  {10406, -12655},  {10405, -12656},  {10404, -12657},  {10402, -12658},
    {10401, -12659},  {10400, -12660},  {10399, -12661},  {10398, -12662},  {10396, -12663},  {10395, -12664},
    {10394, -12665},  {10393, -12666},  {10391, -12667},  {10390, -12668},  {10389, -12669},  {10388, -12670},
    {10387, -12671},  {10385, -12672},  {10384, -12673},  {10383, -12674},  {10382, -12675},  {10381, -12676},
    {10379, -12677},  {10378, -12678},  {10377, -12679},  {10376, -12680},  {10374, -12681},  {10373, -12682},
    {10372, -12683},  {10371, -12684},  {10370, -12685},  {10368, -12686},  {10367, -12687},  {10366, -12688},
    {10365, -12689},  {10364, -12690},  {10362, -12691},  {10361, -12692},  {10360, -12693},  {10359, -12694},
    {10357, -12695},  {10356, -12696},  {10355, -12697},  {10354, -12698},  {10353, -12699},  {10351, -12700},
    {10350, -12701},  {10349, -12702},  {10348, -12703},  {10346, -12704},  {10345, -12705},  {10344, -12706},
    {10343, -12707},  {10342, -12708},  {10340, -12709},  {10339, -12710},  {10338, -12711},  {10337, -12712},
    {10336, -12713},  {10334, -12714},  {10333, -12715},  {10332, -12716},  {10331, -12717},  {10329, -12718},
    {10328, -12719},  {10327, -12720},  {10326, -12721},  {10325, -12722},  {10323, -12723},  {10322, -12724},
    {10321, -12725},  {10320, -12726},  {10318, -12727},  {10317, -12728},  {10316, -12729},  {10315, -12730},
    {10314, -12731},  {10312, -12732},  {10311, -12732},  {10310, -12733},  {10309, -12734},  {10307, -12735},
    {10306, -12736},  {10305, -12737},  {10304, -12738},  {10303, -12739},  {10301, -12740},  {10300, -12741},
    {10299, -12742},  {10298, -12743},  {10296, -12744},  {10295, -12745},  {10294, -12746},  {10293, -12747},
    {10292, -12748},  {10290, -12749},  {10289, -12750},  {10288, -12751},  {10287, -12752},  {10285, -12753},
    {10284, -12754},  {10283, -12755},  {10282, -12756},  {10281, -12757},  {10279, -12758},  {10278, -12759},
    {10277, -12760},  {10276, -12761},  {10274, -12762},  {10273, -12763},  {10272, -12764},  {10271, -12765},
    {10270, -12766},  {10268, -12767},  {10267, -12768},  {10266, -12769},  {10265, -12770},  {10263, -12771},
    {10262, -12772},  {10261, -12773},  {10260, -12774},  {10259, -12775},  {10257, -12776},  {10256, -12777},
    {10255, -12778},  {10254, -12779},  {10252, -12780},  {10251, -12781},  {10250, -12782},  {10249, -12783},
    {10248, -12784},  {10246, -12785},  {10245, -12786},  {10244, -12787},  {10243, -12788},  {10241, -12789},
    {10240, -12790},  {10239, -12791},  {10238, -12792},  {10236, -12793},  {10235, -12794},  {10234, -12795},
    {10233, -12796},  {10232, -12797},  {10230, -12797},  {10229, -12798},  {10228, -12799},  {10227, -12800},
    {10225, -12801},  {10224, -12802},  {10223, -12803},  {10222, -12804},  {10221, -12805},  {10219, -12806},
    {10218, -12807},  {10217, -12808},  {10216, -12809},  {10214, -12810},  {10213, -12811},  {10212, -12812},
    {10211, -12813},  {10209, -12814},  {10208, -12815},  {10207, -12816},  {10206, -12817},  {10205, -12818},
    {10203, -12819},  {10202, -12820},  {10201, -12821},  {10200, -12822},  {10198, -12823},  {10197, -12824},
    {10196, -12825},  {10195, -12826},  {10193, -12827},  {10192, -12828},  {10191, -12829},  {10190, -12830},
    {10189, -12831},  {10187, -12832},  {10186, -12833},  {10185, -12834},  {10184, -12835},  {10182, -12836},
    {10181, -12837},  {10180, -12838},  {10179, -12839},  {10177, -12840},  {10176, -12841},  {10175, -12842},
    {10174, -12842},  {10173, -12843},  {10171, -12844},  {10170, -12845},  {10169, -12846},  {10168, -12847},
    {10166, -12848},  {10165, -12849},  {10164, -12850},  {10163, -12851},  {10161, -12852},  {10160, -12853},
    {10159, -12854},  {10158, -12855},  {10157, -12856},  {10155, -12857},  {10154, -12858},  {10153, -12859},
    {10152, -12860},  {10150, -12861},  {10149, -12862},  {10148, -12863},  {10147, -12864},  {10145, -12865},
    {10144, -12866},  {10143, -12867},  {10142, -12868},  {10141, -12869},  {10139, -12870},  {10138, -12871},
    {10137, -12872},  {10136, -12873},  {10134, -12874},  {10133, -12875},  {10132, -12876},  {10131, -12877},
    {10129, -12878},  {10128, -12878},  {10127, -12879},  {10126, -12880},  {10124, -12881},  {10123, -12882},
    {10122, -12883},  {10121, -12884},  {10120, -12885},  {10118, -12886},  {10117, -12887},  {10116, -12888},
    {10115, -12889},  {10113, -12890},  {10112, -12891},  {10111, -12892},  {10110, -12893},  {10108, -12894},
    {10107, -12895},  {10106, -12896},  {10105, -12897},  {10103, -12898},  {10102, -12899},  {10101, -12900},
    {10100, -12901},  {10099, -12902},  {10097, -12903},  {10096, -12904},  {10095, -12905},  {10094, -12906},
    {10092, -12907},  {10091, -12908},  {10090, -12909},  {10089, -12910},  {10087, -12910},  {10086, -12911},
    {10085, -12912},  {10084, -12913},  {10082, -12914},  {10081, -12915},  {10080, -12916},  {10079, -12917},
    {10077, -12918},  {10076, -12919},  {10075, -12920},  {10074, -12921},  {10073, -12922},  {10071, -12923},
    {10070, -12924},  {10069, -12925},  {10068, -12926},  {10066, -12927},  {10065, -12928},  {10064, -12929},
    {10063, -12930},  {10061, -12931},  {10060, -12932},  {10059, -12933},  {10058, -12934},  {10056, -12935},
    {10055, -12936},  {10054, -12937},  {10053, -12938},  {10051, -12938},  {10050, -12939},  {10049, -12940},
    {10048, -12941},  {10046, -12942},  {10045, -12943},  {10044, -12944},  {10043, -12945},  {10042, -12946},
    {10040, -12947},  {10039, -12948},  {10038, -12949},  {10037, -12950},  {10035, -12951},  {10034, -12952},
    {10033, -12953},  {10032, -12954},  {10030, -12955},  {10029, -12956},  {10028, -12957},  {10027, -12958},
    {10025, -12959},  {10024, -12960},  {10023, -12961},  {10022, -12962},  {10020, -12963},  {10019, -12963},
    {10018, -12964},  {10017, -12965},  {10015, -12966},  {10014, -12967},  {10013, -12968},  {10012, -12969},
    {10010, -12970},  {10009, -12971},  {10008, -12972},  {10007, -12973},  {10005, -12974},  {10004, -12975},
    {10003, -12976},  {10002, -12977},  {10001, -12978},  {9999, -12979},   {9998, -12980},   {9997, -12981},
    {9996, -12982},   {9994, -12983},   {9993, -12984},   {9992, -12985},   {9991, -12986},   {9989, -12986},
    {9988, -12987},   {9987, -12988},   {9986, -12989},   {9984, -12990},   {9983, -12991},   {9982, -12992},
    {9981, -12993},   {9979, -12994},   {9978, -12995},   {9977, -12996},   {9976, -12997},   {9974, -12998},
    {9973, -12999},   {9972, -13000},   {9971, -13001},   {9969, -13002},   {9968, -13003},   {9967, -13004},
    {9966, -13005},   {9964, -13006},   {9963, -13007},   {9962, -13008},   {9961, -13008},   {9959, -13009},
    {9958, -13010},   {9957, -13011},   {9956, -13012},   {9954, -13013},   {9953, -13014},   {9952, -13015},
    {9951, -13016},   {9949, -13017},   {9948, -13018},   {9947, -13019},   {9946, -13020},   {9944, -13021},
    {9943, -13022},   {9942, -13023},   {9941, -13024},   {9939, -13025},   {9938, -13026},   {9937, -13027},
    {9936, -13028},   {9934, -13029},   {9933, -13029},   {9932, -13030},   {9931, -13031},   {9929, -13032},
    {9928, -13033},   {9927, -13034},   {9926, -13035},   {9924, -13036},   {9923, -13037},   {9922, -13038},
    {9921, -13039},   {9919, -13040},   {9918, -13041},   {9917, -13042},   {9916, -13043},   {9914, -13044},
    {9913, -13045},   {9912, -13046},   {9911, -13047},   {9909, -13048},   {9908, -13048},   {9907, -13049},
    {9906, -13050},   {9904, -13051},   {9903, -13052},   {9902, -13053},   {9901, -13054},   {9899, -13055},
    {9898, -13056},   {9897, -13057},   {9896, -13058},   {9894, -13059},   {9893, -13060},   {9892, -13061},
    {9891, -13062},   {9889, -13063},   {9888, -13064},   {9887, -13065},   {9886, -13066},   {9884, -13067},
    {9883, -13067},   {9882, -13068},   {9881, -13069},   {9879, -13070},   {9878, -13071},   {9877, -13072},
    {9876, -13073},   {9874, -13074},   {9873, -13075},   {9872, -13076},   {9871, -13077},   {9869, -13078},
    {9868, -13079},   {9867, -13080},   {9866, -13081},   {9864, -13082},   {9863, -13083},   {9862, -13084},
    {9861, -13085},   {9859, -13085},   {9858, -13086},   {9857, -13087},   {9856, -13088},   {9854, -13089},
    {9853, -13090},   {9852, -13091},   {9851, -13092},   {9849, -13093},   {9848, -13094},   {9847, -13095},
    {9846, -13096},   {9844, -13097},   {9843, -13098},   {9842, -13099},   {9841, -13100},   {9839, -13101},
    {9838, -13102},   {9837, -13102},   {9835, -13103},   {9834, -13104},   {9833, -13105},   {9832, -13106},
    {9830, -13107},   {9829, -13108},   {9828, -13109},   {9827, -13110},   {9825, -13111},   {9824, -13112},
    {9823, -13113},   {9822, -13114},   {9820, -13115},   {9819, -13116},   {9818, -13117},   {9817, -13118},
    {9815, -13118},   {9814, -13119},   {9813, -13120},   {9812, -13121},   {9810, -13122},   {9809, -13123},
    {9808, -13124},   {9807, -13125},   {9805, -13126},   {9804, -13127},   {9803, -13128},   {9802, -13129},
    {9800, -13130},   {9799, -13131},   {9798, -13132},   {9796, -13133},   {9795, -13134},   {9794, -13134},
    {9793, -13135},   {9791, -13136},   {9790, -13137},   {9789, -13138},   {9788, -13139},   {9786, -13140},
    {9785, -13141},   {9784, -13142},   {9783, -13143},   {9781, -13144},   {9780, -13145},   {9779, -13146},
    {9778, -13147},   {9776, -13148},   {9775, -13149},   {9774, -13149},   {9773, -13150},   {9771, -13151},
    {9770, -13152},   {9769, -13153},   {9768, -13154},   {9766, -13155},   {9765, -13156},   {9764, -13157},
    {9762, -13158},   {9761, -13159},   {9760, -13160},   {9759, -13161},   {9757, -13162},   {9756, -13163},
    {9755, -13163},   {9754, -13164},   {9752, -13165},   {9751, -13166},   {9750, -13167},   {9749, -13168},
    {9747, -13169},   {9746, -13170},   {9745, -13171},   {9744, -13172},   {9742, -13173},   {9741, -13174},
    {9740, -13175},   {9738, -13176},   {9737, -13177},   {9736, -13178},   {9735, -13178},   {9733, -13179},
    {9732, -13180},   {9731, -13181},   {9730, -13182},   {9728, -13183},   {9727, -13184},   {9726, -13185},
    {9725, -13186},   {9723, -13187},   {9722, -13188},   {9721, -13189},   {9720, -13190},   {9718, -13191},
    {9717, -13191},   {9716, -13192},   {9714, -13193},   {9713, -13194},   {9712, -13195},   {9711, -13196},
    {9709, -13197},   {9708, -13198},   {9707, -13199},   {9706, -13200},   {9704, -13201},   {9703, -13202},
    {9702, -13203},   {9701, -13204},   {9699, -13205},   {9698, -13205},   {9697, -13206},   {9695, -13207},
    {9694, -13208},   {9693, -13209},   {9692, -13210},   {9690, -13211},   {9689, -13212},   {9688, -13213},
    {9687, -13214},   {9685, -13215},   {9684, -13216},   {9683, -13217},   {9682, -13218},   {9680, -13218},
    {9679, -13219},   {9678, -13220},   {9676, -13221},   {9675, -13222},   {9674, -13223},   {9673, -13224},
    {9671, -13225},   {9670, -13226},   {9669, -13227},   {9668, -13228},   {9666, -13229},   {9665, -13230},
    {9664, -13231},   {9663, -13231},   {9661, -13232},   {9660, -13233},   {9659, -13234},   {9657, -13235},
    {9656, -13236},   {9655, -13237},   {9654, -13238},   {9652, -13239},   {9651, -13240},   {9650, -13241},
    {9649, -13242},   {9647, -13243},   {9646, -13243},   {9645, -13244},   {9643, -13245},   {9642, -13246},
    {9641, -13247},   {9640, -13248},   {9638, -13249},   {9637, -13250},   {9636, -13251},   {9635, -13252},
    {9633, -13253},   {9632, -13254},   {9631, -13255},   {9630, -13255},   {9628, -13256},   {9627, -13257},
    {9626, -13258},   {9624, -13259},   {9623, -13260},   {9622, -13261},   {9621, -13262},   {9619, -13263},
    {9618, -13264},   {9617, -13265},   {9616, -13266},   {9614, -13267},   {9613, -13267},   {9612, -13268},
    {9610, -13269},   {9609, -13270},   {9608, -13271},   {9607, -13272},   {9605, -13273},   {9604, -13274},
    {9603, -13275},   {9602, -13276},   {9600, -13277},   {9599, -13278},   {9598, -13279},   {9596, -13279},
    {9595, -13280},   {9594, -13281},   {9593, -13282},   {9591, -13283},   {9590, -13284},   {9589, -13285},
    {9588, -13286},   {9586, -13287},   {9585, -13288},   {9584, -13289},   {9582, -13290},   {9581, -13290},
    {9580, -13291},   {9579, -13292},   {9577, -13293},   {9576, -13294},   {9575, -13295},   {9574, -13296},
    {9572, -13297},   {9571, -13298},   {9570, -13299},   {9568, -13300},   {9567, -13301},   {9566, -13301},
    {9565, -13302},   {9563, -13303},   {9562, -13304},   {9561, -13305},   {9559, -13306},   {9558, -13307},
    {9557, -13308},   {9556, -13309},   {9554, -13310},   {9553, -13311},   {9552, -13312},   {9551, -13312},
    {9549, -13313},   {9548, -13314},   {9547, -13315},   {9545, -13316},   {9544, -13317},   {9543, -13318},
    {9542, -13319},   {9540, -13320},   {9539, -13321},   {9538, -13322},   {9537, -13323},   {9535, -13323},
    {9534, -13324},   {9533, -13325},   {9531, -13326},   {9530, -13327},   {9529, -13328},   {9528, -13329},
    {9526, -13330},   {9525, -13331},   {9524, -13332},   {9522, -13333},   {9521, -13334},   {9520, -13334},
    {9519, -13335},   {9517, -13336},   {9516, -13337},   {9515, -13338},   {9513, -13339},   {9512, -13340},
    {9511, -13341},   {9510, -13342},   {9508, -13343},   {9507, -13344},   {9506, -13344},   {9505, -13345},
    {9503, -13346},   {9502, -13347},   {9501, -13348},   {9499, -13349},   {9498, -13350},   {9497, -13351},
    {9496, -13352},   {9494, -13353},   {9493, -13354},   {9492, -13354},   {9490, -13355},   {9489, -13356},
    {9488, -13357},   {9487, -13358},   {9485, -13359},   {9484, -13360},   {9483, -13361},   {9481, -13362},
    {9480, -13363},   {9479, -13364},   {9478, -13364},   {9476, -13365},   {9475, -13366},   {9474, -13367},
    {9473, -13368},   {9471, -13369},   {9470, -13370},   {9469, -13371},   {9467, -13372},   {9466, -13373},
    {9465, -13374},   {9464, -13374},   {9462, -13375},   {9461, -13376},   {9460, -13377},   {9458, -13378},
    {9457, -13379},   {9456, -13380},   {9455, -13381},   {9453, -13382},   {9452, -13383},   {9451, -13384},
    {9449, -13384},   {9448, -13385},   {9447, -13386},   {9446, -13387},   {9444, -13388},   {9443, -13389},
    {9442, -13390},   {9440, -13391},   {9439, -13392},   {9438, -13393},   {9437, -13394},   {9435, -13394},
    {9434, -13395},   {9433, -13396},   {9431, -13397},   {9430, -13398},   {9429, -13399},   {9428, -13400},
    {9426, -13401},   {9425, -13402},   {9424, -13403},   {9422, -13403},   {9421, -13404},   {9420, -13405},
    {9419, -13406},   {9417, -13407},   {9416, -13408},   {9415, -13409},   {9413, -13410},   {9412, -13411},
    {9411, -13412},   {9410, -13412},   {9408, -13413},   {9407, -13414},   {9406, -13415},   {9404, -13416},
    {9403, -13417},   {9402, -13418},   {9401, -13419},   {9399, -13420},   {9398, -13421},   {9397, -13421},
    {9395, -13422},   {9394, -13423},   {9393, -13424},   {9392, -13425},   {9390, -13426},   {9389, -13427},
    {9388, -13428},   {9386, -13429},   {9385, -13430},   {9384, -13430},   {9383, -13431},   {9381, -13432},
    {9380, -13433},   {9379, -13434},   {9377, -13435},   {9376, -13436},   {9375, -13437},   {9374, -13438},
    {9372, -13439},   {9371, -13439},   {9370, -13440},   {9368, -13441},   {9367, -13442},   {9366, -13443},
    {9365, -13444},   {9363, -13445},   {9362, -13446},   {9361, -13447},   {9359, -13448},   {9358, -13448},
    {9357, -13449},   {9356, -13450},   {9354, -13451},   {9353, -13452},   {9352, -13453},   {9350, -13454},
    {9349, -13455},   {9348, -13456},   {9347, -13457},   {9345, -13457},   {9344, -13458},   {9343, -13459},
    {9341, -13460},   {9340, -13461},   {9339, -13462},   {9337, -13463},   {9336, -13464},   {9335, -13465},
    {9334, -13465},   {9332, -13466},   {9331, -13467},   {9330, -13468},   {9328, -13469},   {9327, -13470},
    {9326, -13471},   {9325, -13472},   {9323, -13473},   {9322, -13474},   {9321, -13474},   {9319, -13475},
    {9318, -13476},   {9317, -13477},   {9316, -13478},   {9314, -13479},   {9313, -13480},   {9312, -13481},
    {9310, -13482},   {9309, -13482},   {9308, -13483},   {9306, -13484},   {9305, -13485},   {9304, -13486},
    {9303, -13487},   {9301, -13488},   {9300, -13489},   {9299, -13490},   {9297, -13490},   {9296, -13491},
    {9295, -13492},   {9294, -13493},   {9292, -13494},   {9291, -13495},   {9290, -13496},   {9288, -13497},
    {9287, -13498},   {9286, -13499},   {9284, -13499},   {9283, -13500},   {9282, -13501},   {9281, -13502},
    {9279, -13503},   {9278, -13504},   {9277, -13505},   {9275, -13506},   {9274, -13507},   {9273, -13507},
    {9272, -13508},   {9270, -13509},   {9269, -13510},   {9268, -13511},   {9266, -13512},   {9265, -13513},
    {9264, -13514},   {9262, -13515},   {9261, -13515},   {9260, -13516},   {9259, -13517},   {9257, -13518},
    {9256, -13519},   {9255, -13520},   {9253, -13521},   {9252, -13522},   {9251, -13523},   {9250, -13523},
    {9248, -13524},   {9247, -13525},   {9246, -13526},   {9244, -13527},   {9243, -13528},   {9242, -13529},
    {9240, -13530},   {9239, -13530},   {9238, -13531},   {9237, -13532},   {9235, -13533},   {9234, -13534},
    {9233, -13535},   {9231, -13536},   {9230, -13537},   {9229, -13538},   {9227, -13538},   {9226, -13539},
    {9225, -13540},   {9224, -13541},   {9222, -13542},   {9221, -13543},   {9220, -13544},   {9218, -13545},
    {9217, -13546},   {9216, -13546},   {9214, -13547},   {9213, -13548},   {9212, -13549},   {9211, -13550},
    {9209, -13551},   {9208, -13552},   {9207, -13553},   {9205, -13553},   {9204, -13554},   {9203, -13555},
    {9201, -13556},   {9200, -13557},   {9199, -13558},   {9198, -13559},   {9196, -13560},   {9195, -13561},
    {9194, -13561},   {9192, -13562},   {9191, -13563},   {9190, -13564},   {9188, -13565},   {9187, -13566},
    {9186, -13567},   {9185, -13568},   {9183, -13568},   {9182, -13569},   {9181, -13570},   {9179, -13571},
    {9178, -13572},   {9177, -13573},   {9175, -13574},   {9174, -13575},   {9173, -13575},   {9172, -13576},
    {9170, -13577},   {9169, -13578},   {9168, -13579},   {9166, -13580},   {9165, -13581},   {9164, -13582},
    {9162, -13583},   {9161, -13583},   {9160, -13584},   {9159, -13585},   {9157, -13586},   {9156, -13587},
    {9155, -13588},   {9153, -13589},   {9152, -13590},   {9151, -13590},   {9149, -13591},   {9148, -13592},
    {9147, -13593},   {9146, -13594},   {9144, -13595},   {9143, -13596},   {9142, -13597},   {9140, -13597},
    {9139, -13598},   {9138, -13599},   {9136, -13600},   {9135, -13601},   {9134, -13602},   {9132, -13603},
    {9131, -13604},   {9130, -13604},   {9129, -13605},   {9127, -13606},   {9126, -13607},   {9125, -13608},
    {9123, -13609},   {9122, -13610},   {9121, -13611},   {9119, -13611},   {9118, -13612},   {9117, -13613},
    {9116, -13614},   {9114, -13615},   {9113, -13616},   {9112, -13617},   {9110, -13618},   {9109, -13618},
    {9108, -13619},   {9106, -13620},   {9105, -13621},   {9104, -13622},   {9102, -13623},   {9101, -13624},
    {9100, -13625},   {9099, -13625},   {9097, -13626},   {9096, -13627},   {9095, -13628},   {9093, -13629},
    {9092, -13630},   {9091, -13631},   {9089, -13632},   {9088, -13632},   {9087, -13633},   {9085, -13634},
    {9084, -13635},   {9083, -13636},   {9082, -13637},   {9080, -13638},   {9079, -13638},   {9078, -13639},
    {9076, -13640},   {9075, -13641},   {9074, -13642},   {9072, -13643},   {9071, -13644},   {9070, -13645},
    {9068, -13645},   {9067, -13646},   {9066, -13647},   {9065, -13648},   {9063, -13649},   {9062, -13650},
    {9061, -13651},   {9059, -13652},   {9058, -13652},   {9057, -13653},   {9055, -13654},   {9054, -13655},
    {9053, -13656},   {9051, -13657},   {9050, -13658},   {9049, -13658},   {9048, -13659},   {9046, -13660},
    {9045, -13661},   {9044, -13662},   {9042, -13663},   {9041, -13664},   {9040, -13665},   {9038, -13665},
    {9037, -13666},   {9036, -13667},   {9034, -13668},   {9033, -13669},   {9032, -13670},   {9031, -13671},
    {9029, -13671},   {9028, -13672},   {9027, -13673},   {9025, -13674},   {9024, -13675},   {9023, -13676},
    {9021, -13677},   {9020, -13678},   {9019, -13678},   {9017, -13679},   {9016, -13680},   {9015, -13681},
    {9013, -13682},   {9012, -13683},   {9011, -13684},   {9010, -13684},   {9008, -13685},   {9007, -13686},
    {9006, -13687},   {9004, -13688},   {9003, -13689},   {9002, -13690},   {9000, -13690},   {8999, -13691},
    {8998, -13692},   {8996, -13693},   {8995, -13694},   {8994, -13695},   {8992, -13696},   {8991, -13697},
    {8990, -13697},   {8989, -13698},   {8987, -13699},   {8986, -13700},   {8985, -13701},   {8983, -13702},
    {8982, -13703},   {8981, -13703},   {8979, -13704},   {8978, -13705},   {8977, -13706},   {8975, -13707},
    {8974, -13708},   {8973, -13709},   {8971, -13709},   {8970, -13710},   {8969, -13711},   {8967, -13712},
    {8966, -13713},   {8965, -13714},   {8964, -13715},   {8962, -13715},   {8961, -13716},   {8960, -13717},
    {8958, -13718},   {8957, -13719},   {8956, -13720},   {8954, -13721},   {8953, -13721},   {8952, -13722},
    {8950, -13723},   {8949, -13724},   {8948, -13725},   {8946, -13726},   {8945, -13727},   {8944, -13727},
    {8943, -13728},   {8941, -13729},   {8940, -13730},   {8939, -13731},   {8937, -13732},   {8936, -13733},
    {8935, -13733},   {8933, -13734},   {8932, -13735},   {8931, -13736},   {8929, -13737},   {8928, -13738},
    {8927, -13739},   {8925, -13739},   {8924, -13740},   {8923, -13741},   {8921, -13742},   {8920, -13743},
    {8919, -13744},   {8917, -13745},   {8916, -13745},   {8915, -13746},   {8914, -13747},   {8912, -13748},
    {8911, -13749},   {8910, -13750},   {8908, -13751},   {8907, -13751},   {8906, -13752},   {8904, -13753},
    {8903, -13754},   {8902, -13755},   {8900, -13756},   {8899, -13757},   {8898, -13757},   {8896, -13758},
    {8895, -13759},   {8894, -13760},   {8892, -13761},   {8891, -13762},   {8890, -13763},   {8888, -13763},
    {8887, -13764},   {8886, -13765},   {8885, -13766},   {8883, -13767},   {8882, -13768},   {8881, -13768},
    {8879, -13769},   {8878, -13770},   {8877, -13771},   {8875, -13772},   {8874, -13773},   {8873, -13774},
    {8871, -13774},   {8870, -13775},   {8869, -13776},   {8867, -13777},   {8866, -13778},   {8865, -13779},
    {8863, -13780},   {8862, -13780},   {8861, -13781},   {8859, -13782},   {8858, -13783},   {8857, -13784},
    {8855, -13785},   {8854, -13785},   {8853, -13786},   {8851, -13787},   {8850, -13788},   {8849, -13789},
    {8848, -13790},   {8846, -13791},   {8845, -13791},   {8844, -13792},   {8842, -13793},   {8841, -13794},
    {8840, -13795},   {8838, -13796},   {8837, -13797},   {8836, -13797},   {8834, -13798},   {8833, -13799},
    {8832, -13800},   {8830, -13801},   {8829, -13802},   {8828, -13802},   {8826, -13803},   {8825, -13804},
    {8824, -13805},   {8822, -13806},   {8821, -13807},   {8820, -13808},   {8818, -13808},   {8817, -13809},
    {8816, -13810},   {8814, -13811},   {8813, -13812},   {8812, -13813},   {8810, -13813},   {8809, -13814},
    {8808, -13815},   {8807, -13816},   {8805, -13817},   {8804, -13818},   {8803, -13819},   {8801, -13819},
    {8800, -13820},   {8799, -13821},   {8797, -13822},   {8796, -13823},   {8795, -13824},   {8793, -13824},
    {8792, -13825},   {8791, -13826},   {8789, -13827},   {8788, -13828},   {8787, -13829},   {8785, -13829},
    {8784, -13830},   {8783, -13831},   {8781, -13832},   {8780, -13833},   {8779, -13834},   {8777, -13835},
    {8776, -13835},   {8775, -13836},   {8773, -13837},   {8772, -13838},   {8771, -13839},   {8769, -13840},
    {8768, -13840},   {8767, -13841},   {8765, -13842},   {8764, -13843},   {8763, -13844},   {8761, -13845},
    {8760, -13845},   {8759, -13846},   {8757, -13847},   {8756, -13848},   {8755, -13849},   {8753, -13850},
    {8752, -13850},   {8751, -13851},   {8749, -13852},   {8748, -13853},   {8747, -13854},   {8745, -13855},
    {8744, -13856},   {8743, -13856},   {8742, -13857},   {8740, -13858},   {8739, -13859},   {8738, -13860},
    {8736, -13861},   {8735, -13861},   {8734, -13862},   {8732, -13863},   {8731, -13864},   {8730, -13865},
    {8728, -13866},   {8727, -13866},   {8726, -13867},   {8724, -13868},   {8723, -13869},   {8722, -13870},
    {8720, -13871},   {8719, -13871},   {8718, -13872},   {8716, -13873},   {8715, -13874},   {8714, -13875},
    {8712, -13876},   {8711, -13876},   {8710, -13877},   {8708, -13878},   {8707, -13879},   {8706, -13880},
    {8704, -13881},   {8703, -13881},   {8702, -13882},   {8700, -13883},   {8699, -13884},   {8698, -13885},
    {8696, -13886},   {8695, -13886},   {8694, -13887},   {8692, -13888},   {8691, -13889},   {8690, -13890},
    {8688, -13891},   {8687, -13891},   {8686, -13892},   {8684, -13893},   {8683, -13894},   {8682, -13895},
    {8680, -13896},   {8679, -13896},   {8678, -13897},   {8676, -13898},   {8675, -13899},   {8674, -13900},
    {8672, -13901},   {8671, -13901},   {8670, -13902},   {8668, -13903},   {8667, -13904},   {8666, -13905},
    {8664, -13906},   {8663, -13906},   {8662, -13907},   {8660, -13908},   {8659, -13909},   {8658, -13910},
    {8656, -13911},   {8655, -13911},   {8654, -13912},   {8652, -13913},   {8651, -13914},   {8650, -13915},
    {8648, -13916},   {8647, -13916},   {8646, -13917},   {8644, -13918},   {8643, -13919},   {8642, -13920},
    {8640, -13921},   {8639, -13921},   {8638, -13922},   {8636, -13923},   {8635, -13924},   {8634, -13925},
    {8632, -13925},   {8631, -13926},   {8630, -13927},   {8628, -13928},   {8627, -13929},   {8626, -13930},
    {8624, -13930},   {8623, -13931},   {8622, -13932},   {8620, -13933},   {8619, -13934},   {8618, -13935},
    {8616, -13935},   {8615, -13936},   {8614, -13937},   {8612, -13938},   {8611, -13939},   {8610, -13940},
    {8608, -13940},   {8607, -13941},   {8606, -13942},   {8604, -13943},   {8603, -13944},   {8602, -13944},
    {8600, -13945},   {8599, -13946},   {8598, -13947},   {8596, -13948},   {8595, -13949},   {8594, -13949},
    {8592, -13950},   {8591, -13951},   {8590, -13952},   {8588, -13953},   {8587, -13954},   {8586, -13954},
    {8584, -13955},   {8583, -13956},   {8582, -13957},   {8580, -13958},   {8579, -13958},   {8577, -13959},
    {8576, -13960},   {8575, -13961},   {8573, -13962},   {8572, -13963},   {8571, -13963},   {8569, -13964},
    {8568, -13965},   {8567, -13966},   {8565, -13967},   {8564, -13968},   {8563, -13968},   {8561, -13969},
    {8560, -13970},   {8559, -13971},   {8557, -13972},   {8556, -13972},   {8555, -13973},   {8553, -13974},
    {8552, -13975},   {8551, -13976},   {8549, -13977},   {8548, -13977},   {8547, -13978},   {8545, -13979},
    {8544, -13980},   {8543, -13981},   {8541, -13981},   {8540, -13982},   {8539, -13983},   {8537, -13984},
    {8536, -13985},   {8535, -13986},   {8533, -13986},   {8532, -13987},   {8531, -13988},   {8529, -13989},
    {8528, -13990},   {8527, -13990},   {8525, -13991},   {8524, -13992},   {8523, -13993},   {8521, -13994},
    {8520, -13995},   {8519, -13995},   {8517, -13996},   {8516, -13997},   {8514, -13998},   {8513, -13999},
    {8512, -13999},   {8510, -14000},   {8509, -14001},   {8508, -14002},   {8506, -14003},   {8505, -14004},
    {8504, -14004},   {8502, -14005},   {8501, -14006},   {8500, -14007},   {8498, -14008},   {8497, -14008},
    {8496, -14009},   {8494, -14010},   {8493, -14011},   {8492, -14012},   {8490, -14012},   {8489, -14013},
    {8488, -14014},   {8486, -14015},   {8485, -14016},   {8484, -14017},   {8482, -14017},   {8481, -14018},
    {8480, -14019},   {8478, -14020},   {8477, -14021},   {8476, -14021},   {8474, -14022},   {8473, -14023},
    {8472, -14024},   {8470, -14025},   {8469, -14025},   {8467, -14026},   {8466, -14027},   {8465, -14028},
    {8463, -14029},   {8462, -14030},   {8461, -14030},   {8459, -14031},   {8458, -14032},   {8457, -14033},
    {8455, -14034},   {8454, -14034},   {8453, -14035},   {8451, -14036},   {8450, -14037},   {8449, -14038},
    {8447, -14038},   {8446, -14039},   {8445, -14040},   {8443, -14041},   {8442, -14042},   {8441, -14043},
    {8439, -14043},   {8438, -14044},   {8437, -14045},   {8435, -14046},   {8434, -14047},   {8432, -14047},
    {8431, -14048},   {8430, -14049},   {8428, -14050},   {8427, -14051},   {8426, -14051},   {8424, -14052},
    {8423, -14053},   {8422, -14054},   {8420, -14055},   {8419, -14055},   {8418, -14056},   {8416, -14057},
    {8415, -14058},   {8414, -14059},   {8412, -14059},   {8411, -14060},   {8410, -14061},   {8408, -14062},
    {8407, -14063},   {8406, -14064},   {8404, -14064},   {8403, -14065},   {8401, -14066},   {8400, -14067},
    {8399, -14068},   {8397, -14068},   {8396, -14069},   {8395, -14070},   {8393, -14071},   {8392, -14072},
    {8391, -14072},   {8389, -14073},   {8388, -14074},   {8387, -14075},   {8385, -14076},   {8384, -14076},
    {8383, -14077},   {8381, -14078},   {8380, -14079},   {8379, -14080},   {8377, -14080},   {8376, -14081},
    {8375, -14082},   {8373, -14083},   {8372, -14084},   {8370, -14084},   {8369, -14085},   {8368, -14086},
    {8366, -14087},   {8365, -14088},   {8364, -14088},   {8362, -14089},   {8361, -14090},   {8360, -14091},
    {8358, -14092},   {8357, -14092},   {8356, -14093},   {8354, -14094},   {8353, -14095},   {8352, -14096},
    {8350, -14096},   {8349, -14097},   {8347, -14098},   {8346, -14099},   {8345, -14100},   {8343, -14100},
    {8342, -14101},   {8341, -14102},   {8339, -14103},   {8338, -14104},   {8337, -14104},   {8335, -14105},
    {8334, -14106},   {8333, -14107},   {8331, -14108},   {8330, -14108},   {8329, -14109},   {8327, -14110},
    {8326, -14111},   {8324, -14112},   {8323, -14112},   {8322, -14113},   {8320, -14114},   {8319, -14115},
    {8318, -14116},   {8316, -14116},   {8315, -14117},   {8314, -14118},   {8312, -14119},   {8311, -14120},
    {8310, -14120},   {8308, -14121},   {8307, -14122},   {8306, -14123},   {8304, -14124},   {8303, -14124},
    {8301, -14125},   {8300, -14126},   {8299, -14127},   {8297, -14128},   {8296, -14128},   {8295, -14129},
    {8293, -14130},   {8292, -14131},   {8291, -14132},   {8289, -14132},   {8288, -14133},   {8287, -14134},
    {8285, -14135},   {8284, -14136},   {8283, -14136},   {8281, -14137},   {8280, -14138},   {8278, -14139},
    {8277, -14139},   {8276, -14140},   {8274, -14141},   {8273, -14142},   {8272, -14143},   {8270, -14143},
    {8269, -14144},   {8268, -14145},   {8266, -14146},   {8265, -14147},   {8264, -14147},   {8262, -14148},
    {8261, -14149},   {8259, -14150},   {8258, -14151},   {8257, -14151},   {8255, -14152},   {8254, -14153},
    {8253, -14154},   {8251, -14155},   {8250, -14155},   {8249, -14156},   {8247, -14157},   {8246, -14158},
    {8245, -14158},   {8243, -14159},   {8242, -14160},   {8240, -14161},   {8239, -14162},   {8238, -14162},
    {8236, -14163},   {8235, -14164},   {8234, -14165},   {8232, -14166},   {8231, -14166},   {8230, -14167},
    {8228, -14168},   {8227, -14169},   {8226, -14170},   {8224, -14170},   {8223, -14171},   {8221, -14172},
    {8220, -14173},   {8219, -14173},   {8217, -14174},   {8216, -14175},   {8215, -14176},   {8213, -14177},
    {8212, -14177},   {8211, -14178},   {8209, -14179},   {8208, -14180},   {8207, -14181},   {8205, -14181},
    {8204, -14182},   {8202, -14183},   {8201, -14184},   {8200, -14185},   {8198, -14185},   {8197, -14186},
    {8196, -14187},   {8194, -14188},   {8193, -14188},   {8192, -14189},   {8190, -14190},   {8189, -14191},
    {8187, -14192},   {8186, -14192},   {8185, -14193},   {8183, -14194},   {8182, -14195},   {8181, -14196},
    {8179, -14196},   {8178, -14197},   {8177, -14198},   {8175, -14199},   {8174, -14199},   {8172, -14200},
    {8171, -14201},   {8170, -14202},   {8168, -14203},   {8167, -14203},   {8166, -14204},   {8164, -14205},
    {8163, -14206},   {8162, -14206},   {8160, -14207},   {8159, -14208},   {8158, -14209},   {8156, -14210},
    {8155, -14210},   {8153, -14211},   {8152, -14212},   {8151, -14213},   {8149, -14214},   {8148, -14214},
    {8147, -14215},   {8145, -14216},   {8144, -14217},   {8143, -14217},   {8141, -14218},   {8140, -14219},
    {8138, -14220},   {8137, -14221},   {8136, -14221},   {8134, -14222},   {8133, -14223},   {8132, -14224},
    {8130, -14224},   {8129, -14225},   {8128, -14226},   {8126, -14227},   {8125, -14228},   {8123, -14228},
    {8122, -14229},   {8121, -14230},   {8119, -14231},   {8118, -14231},   {8117, -14232},   {8115, -14233},
    {8114, -14234},   {8113, -14235},   {8111, -14235},   {8110, -14236},   {8108, -14237},   {8107, -14238},
    {8106, -14238},   {8104, -14239},   {8103, -14240},   {8102, -14241},   {8100, -14242},   {8099, -14242},
    {8098, -14243},   {8096, -14244},   {8095, -14245},   {8093, -14245},   {8092, -14246},   {8091, -14247},
    {8089, -14248},   {8088, -14249},   {8087, -14249},   {8085, -14250},   {8084, -14251},   {8082, -14252},
    {8081, -14252},   {8080, -14253},   {8078, -14254},   {8077, -14255},   {8076, -14256},   {8074, -14256},
    {8073, -14257},   {8072, -14258},   {8070, -14259},   {8069, -14259},   {8067, -14260},   {8066, -14261},
    {8065, -14262},   {8063, -14262},   {8062, -14263},   {8061, -14264},   {8059, -14265},   {8058, -14266},
    {8057, -14266},   {8055, -14267},   {8054, -14268},   {8052, -14269},   {8051, -14269},   {8050, -14270},
    {8048, -14271},   {8047, -14272},   {8046, -14273},   {8044, -14273},   {8043, -14274},   {8041, -14275},
    {8040, -14276},   {8039, -14276},   {8037, -14277},   {8036, -14278},   {8035, -14279},   {8033, -14279},
    {8032, -14280},   {8031, -14281},   {8029, -14282},   {8028, -14283},   {8026, -14283},   {8025, -14284},
    {8024, -14285},   {8022, -14286},   {8021, -14286},   {8020, -14287},   {8018, -14288},   {8017, -14289},
    {8015, -14289},   {8014, -14290},   {8013, -14291},   {8011, -14292},   {8010, -14293},   {8009, -14293},
    {8007, -14294},   {8006, -14295},   {8004, -14296},   {8003, -14296},   {8002, -14297},   {8000, -14298},
    {7999, -14299},   {7998, -14299},   {7996, -14300},   {7995, -14301},   {7994, -14302},   {7992, -14302},
    {7991, -14303},   {7989, -14304},   {7988, -14305},   {7987, -14306},   {7985, -14306},   {7984, -14307},
    {7983, -14308},   {7981, -14309},   {7980, -14309},   {7978, -14310},   {7977, -14311},   {7976, -14312},
    {7974, -14312},   {7973, -14313},   {7972, -14314},   {7970, -14315},   {7969, -14315},   {7967, -14316},
    {7966, -14317},   {7965, -14318},   {7963, -14319},   {7962, -14319},   {7961, -14320},   {7959, -14321},
    {7958, -14322},   {7956, -14322},   {7955, -14323},   {7954, -14324},   {7952, -14325},   {7951, -14325},
    {7950, -14326},   {7948, -14327},   {7947, -14328},   {7945, -14328},   {7944, -14329},   {7943, -14330},
    {7941, -14331},   {7940, -14332},   {7939, -14332},   {7937, -14333},   {7936, -14334},   {7934, -14335},
    {7933, -14335},   {7932, -14336},   {7930, -14337},   {7929, -14338},   {7928, -14338},   {7926, -14339},
    {7925, -14340},   {7923, -14341},   {7922, -14341},   {7921, -14342},   {7919, -14343},   {7918, -14344},
    {7917, -14344},   {7915, -14345},   {7914, -14346},   {7912, -14347},   {7911, -14347},   {7910, -14348},
    {7908, -14349},   {7907, -14350},   {7906, -14351},   {7904, -14351},   {7903, -14352},   {7901, -14353},
    {7900, -14354},   {7899, -14354},   {7897, -14355},   {7896, -14356},   {7895, -14357},   {7893, -14357},
    {7892, -14358},   {7890, -14359},   {7889, -14360},   {7888, -14360},   {7886, -14361},   {7885, -14362},
    {7884, -14363},   {7882, -14363},   {7881, -14364},   {7879, -14365},   {7878, -14366},   {7877, -14366},
    {7875, -14367},   {7874, -14368},   {7873, -14369},   {7871, -14369},   {7870, -14370},   {7868, -14371},
    {7867, -14372},   {7866, -14372},   {7864, -14373},   {7863, -14374},   {7862, -14375},   {7860, -14375},
    {7859, -14376},   {7857, -14377},   {7856, -14378},   {7855, -14378},   {7853, -14379},   {7852, -14380},
    {7851, -14381},   {7849, -14381},   {7848, -14382},   {7846, -14383},   {7845, -14384},   {7844, -14384},
    {7842, -14385},   {7841, -14386},   {7839, -14387},   {7838, -14387},   {7837, -14388},   {7835, -14389},
    {7834, -14390},   {7833, -14390},   {7831, -14391},   {7830, -14392},   {7828, -14393},   {7827, -14393},
    {7826, -14394},   {7824, -14395},   {7823, -14396},   {7822, -14396},   {7820, -14397},   {7819, -14398},
    {7817, -14399},   {7816, -14399},   {7815, -14400},   {7813, -14401},   {7812, -14402},   {7810, -14402},
    {7809, -14403},   {7808, -14404},   {7806, -14405},   {7805, -14405},   {7804, -14406},   {7802, -14407},
    {7801, -14408},   {7799, -14408},   {7798, -14409},   {7797, -14410},   {7795, -14411},   {7794, -14411},
    {7793, -14412},   {7791, -14413},   {7790, -14414},   {7788, -14414},   {7787, -14415},   {7786, -14416},
    {7784, -14417},   {7783, -14417},   {7781, -14418},   {7780, -14419},   {7779, -14420},   {7777, -14420},
    {7776, -14421},   {7775, -14422},   {7773, -14423},   {7772, -14423},   {7770, -14424},   {7769, -14425},
    {7768, -14426},   {7766, -14426},   {7765, -14427},   {7764, -14428},   {7762, -14429},   {7761, -14429},
    {7759, -14430},   {7758, -14431},   {7757, -14432},   {7755, -14432},   {7754, -14433},   {7752, -14434},
    {7751, -14435},   {7750, -14435},   {7748, -14436},   {7747, -14437},   {7746, -14438},   {7744, -14438},
    {7743, -14439},   {7741, -14440},   {7740, -14441},   {7739, -14441},   {7737, -14442},   {7736, -14443},
    {7734, -14443},   {7733, -14444},   {7732, -14445},   {7730, -14446},   {7729, -14446},   {7728, -14447},
    {7726, -14448},   {7725, -14449},   {7723, -14449},   {7722, -14450},   {7721, -14451},   {7719, -14452},
    {7718, -14452},   {7716, -14453},   {7715, -14454},   {7714, -14455},   {7712, -14455},   {7711, -14456},
    {7710, -14457},   {7708, -14458},   {7707, -14458},   {7705, -14459},   {7704, -14460},   {7703, -14460},
    {7701, -14461},   {7700, -14462},   {7698, -14463},   {7697, -14463},   {7696, -14464},   {7694, -14465},
    {7693, -14466},   {7691, -14466},   {7690, -14467},   {7689, -14468},   {7687, -14469},   {7686, -14469},
    {7685, -14470},   {7683, -14471},   {7682, -14472},   {7680, -14472},   {7679, -14473},   {7678, -14474},
    {7676, -14474},   {7675, -14475},   {7673, -14476},   {7672, -14477},   {7671, -14477},   {7669, -14478},
    {7668, -14479},   {7667, -14480},   {7665, -14480},   {7664, -14481},   {7662, -14482},   {7661, -14483},
    {7660, -14483},   {7658, -14484},   {7657, -14485},   {7655, -14486},   {7654, -14486},   {7653, -14487},
    {7651, -14488},   {7650, -14488},   {7648, -14489},   {7647, -14490},   {7646, -14491},   {7644, -14491},
    {7643, -14492},   {7642, -14493},   {7640, -14494},   {7639, -14494},   {7637, -14495},   {7636, -14496},
    {7635, -14497},   {7633, -14497},   {7632, -14498},   {7630, -14499},   {7629, -14499},   {7628, -14500},
    {7626, -14501},   {7625, -14502},   {7623, -14502},   {7622, -14503},   {7621, -14504},   {7619, -14505},
    {7618, -14505},   {7616, -14506},   {7615, -14507},   {7614, -14507},   {7612, -14508},   {7611, -14509},
    {7610, -14510},   {7608, -14510},   {7607, -14511},   {7605, -14512},   {7604, -14513},   {7603, -14513},
    {7601, -14514},   {7600, -14515},   {7598, -14516},   {7597, -14516},   {7596, -14517},   {7594, -14518},
    {7593, -14518},   {7591, -14519},   {7590, -14520},   {7589, -14521},   {7587, -14521},   {7586, -14522},
    {7584, -14523},   {7583, -14524},   {7582, -14524},   {7580, -14525},   {7579, -14526},   {7578, -14526},
    {7576, -14527},   {7575, -14528},   {7573, -14529},   {7572, -14529},   {7571, -14530},   {7569, -14531},
    {7568, -14531},   {7566, -14532},   {7565, -14533},   {7564, -14534},   {7562, -14534},   {7561, -14535},
    {7559, -14536},   {7558, -14537},   {7557, -14537},   {7555, -14538},   {7554, -14539},   {7552, -14539},
    {7551, -14540},   {7550, -14541},   {7548, -14542},   {7547, -14542},   {7545, -14543},   {7544, -14544},
    {7543, -14545},   {7541, -14545},   {7540, -14546},   {7538, -14547},   {7537, -14547},   {7536, -14548},
    {7534, -14549},   {7533, -14550},   {7532, -14550},   {7530, -14551},   {7529, -14552},   {7527, -14552},
    {7526, -14553},   {7525, -14554},   {7523, -14555},   {7522, -14555},   {7520, -14556},   {7519, -14557},
    {7518, -14558},   {7516, -14558},   {7515, -14559},   {7513, -14560},   {7512, -14560},   {7511, -14561},
    {7509, -14562},   {7508, -14563},   {7506, -14563},   {7505, -14564},   {7504, -14565},   {7502, -14565},
    {7501, -14566},   {7499, -14567},   {7498, -14568},   {7497, -14568},   {7495, -14569},   {7494, -14570},
    {7492, -14570},   {7491, -14571},   {7490, -14572},   {7488, -14573},   {7487, -14573},   {7485, -14574},
    {7484, -14575},   {7483, -14576},   {7481, -14576},   {7480, -14577},   {7478, -14578},   {7477, -14578},
    {7476, -14579},   {7474, -14580},   {7473, -14581},   {7471, -14581},   {7470, -14582},   {7469, -14583},
    {7467, -14583},   {7466, -14584},   {7464, -14585},   {7463, -14586},   {7462, -14586},   {7460, -14587},
    {7459, -14588},   {7457, -14588},   {7456, -14589},   {7455, -14590},   {7453, -14591},   {7452, -14591},
    {7450, -14592},   {7449, -14593},   {7448, -14593},   {7446, -14594},   {7445, -14595},   {7443, -14596},
    {7442, -14596},   {7441, -14597},   {7439, -14598},   {7438, -14598},   {7437, -14599},   {7435, -14600},
    {7434, -14601},   {7432, -14601},   {7431, -14602},   {7430, -14603},   {7428, -14603},   {7427, -14604},
    {7425, -14605},   {7424, -14606},   {7423, -14606},   {7421, -14607},   {7420, -14608},   {7418, -14608},
    {7417, -14609},   {7415, -14610},   {7414, -14610},   {7413, -14611},   {7411, -14612},   {7410, -14613},
    {7408, -14613},   {7407, -14614},   {7406, -14615},   {7404, -14615},   {7403, -14616},   {7401, -14617},
    {7400, -14618},   {7399, -14618},   {7397, -14619},   {7396, -14620},   {7394, -14620},   {7393, -14621},
    {7392, -14622},   {7390, -14623},   {7389, -14623},   {7387, -14624},   {7386, -14625},   {7385, -14625},
    {7383, -14626},   {7382, -14627},   {7380, -14628},   {7379, -14628},   {7378, -14629},   {7376, -14630},
    {7375, -14630},   {7373, -14631},   {7372, -14632},   {7371, -14632},   {7369, -14633},   {7368, -14634},
    {7366, -14635},   {7365, -14635},   {7364, -14636},   {7362, -14637},   {7361, -14637},   {7359, -14638},
    {7358, -14639},   {7357, -14640},   {7355, -14640},   {7354, -14641},   {7352, -14642},   {7351, -14642},
    {7350, -14643},   {7348, -14644},   {7347, -14644},   {7345, -14645},   {7344, -14646},   {7343, -14647},
    {7341, -14647},   {7340, -14648},   {7338, -14649},   {7337, -14649},   {7336, -14650},   {7334, -14651},
    {7333, -14651},   {7331, -14652},   {7330, -14653},   {7329, -14654},   {7327, -14654},   {7326, -14655},
    {7324, -14656},   {7323, -14656},   {7321, -14657},   {7320, -14658},   {7319, -14659},   {7317, -14659},
    {7316, -14660},   {7314, -14661},   {7313, -14661},   {7312, -14662},   {7310, -14663},   {7309, -14663},
    {7307, -14664},   {7306, -14665},   {7305, -14666},   {7303, -14666},   {7302, -14667},   {7300, -14668},
    {7299, -14668},   {7298, -14669},   {7296, -14670},   {7295, -14670},   {7293, -14671},   {7292, -14672},
    {7291, -14673},   {7289, -14673},   {7288, -14674},   {7286, -14675},   {7285, -14675},   {7284, -14676},
    {7282, -14677},   {7281, -14677},   {7279, -14678},   {7278, -14679},   {7276, -14680},   {7275, -14680},
    {7274, -14681},   {7272, -14682},   {7271, -14682},   {7269, -14683},   {7268, -14684},   {7267, -14684},
    {7265, -14685},   {7264, -14686},   {7262, -14686},   {7261, -14687},   {7260, -14688},   {7258, -14689},
    {7257, -14689},   {7255, -14690},   {7254, -14691},   {7253, -14691},   {7251, -14692},   {7250, -14693},
    {7248, -14693},   {7247, -14694},   {7246, -14695},   {7244, -14696},   {7243, -14696},   {7241, -14697},
    {7240, -14698},   {7238, -14698},   {7237, -14699},   {7236, -14700},   {7234, -14700},   {7233, -14701},
    {7231, -14702},   {7230, -14702},   {7229, -14703},   {7227, -14704},   {7226, -14705},   {7224, -14705},
    {7223, -14706},   {7222, -14707},   {7220, -14707},   {7219, -14708},   {7217, -14709},   {7216, -14709},
    {7215, -14710},   {7213, -14711},   {7212, -14711},   {7210, -14712},   {7209, -14713},   {7207, -14714},
    {7206, -14714},   {7205, -14715},   {7203, -14716},   {7202, -14716},   {7200, -14717},   {7199, -14718},
    {7198, -14718},   {7196, -14719},   {7195, -14720},   {7193, -14720},   {7192, -14721},   {7191, -14722},
    {7189, -14723},   {7188, -14723},   {7186, -14724},   {7185, -14725},   {7183, -14725},   {7182, -14726},
    {7181, -14727},   {7179, -14727},   {7178, -14728},   {7176, -14729},   {7175, -14729},   {7174, -14730},
    {7172, -14731},   {7171, -14731},   {7169, -14732},   {7168, -14733},   {7167, -14734},   {7165, -14734},
    {7164, -14735},   {7162, -14736},   {7161, -14736},   {7159, -14737},   {7158, -14738},   {7157, -14738},
    {7155, -14739},   {7154, -14740},   {7152, -14740},   {7151, -14741},   {7150, -14742},   {7148, -14742},
    {7147, -14743},   {7145, -14744},   {7144, -14744},   {7142, -14745},   {7141, -14746},   {7140, -14747},
    {7138, -14747},   {7137, -14748},   {7135, -14749},   {7134, -14749},   {7133, -14750},   {7131, -14751},
    {7130, -14751},   {7128, -14752},   {7127, -14753},   {7126, -14753},   {7124, -14754},   {7123, -14755},
    {7121, -14755},   {7120, -14756},   {7118, -14757},   {7117, -14757},   {7116, -14758},   {7114, -14759},
    {7113, -14760},   {7111, -14760},   {7110, -14761},   {7109, -14762},   {7107, -14762},   {7106, -14763},
    {7104, -14764},   {7103, -14764},   {7101, -14765},   {7100, -14766},   {7099, -14766},   {7097, -14767},
    {7096, -14768},   {7094, -14768},   {7093, -14769},   {7092, -14770},   {7090, -14770},   {7089, -14771},
    {7087, -14772},   {7086, -14772},   {7084, -14773},   {7083, -14774},   {7082, -14774},   {7080, -14775},
    {7079, -14776},   {7077, -14777},   {7076, -14777},   {7075, -14778},   {7073, -14779},   {7072, -14779},
    {7070, -14780},   {7069, -14781},   {7067, -14781},   {7066, -14782},   {7065, -14783},   {7063, -14783},
    {7062, -14784},   {7060, -14785},   {7059, -14785},   {7058, -14786},   {7056, -14787},   {7055, -14787},
    {7053, -14788},   {7052, -14789},   {7050, -14789},   {7049, -14790},   {7048, -14791},   {7046, -14791},
    {7045, -14792},   {7043, -14793},   {7042, -14793},   {7041, -14794},   {7039, -14795},   {7038, -14795},
    {7036, -14796},   {7035, -14797},   {7033, -14798},   {7032, -14798},   {7031, -14799},   {7029, -14800},
    {7028, -14800},   {7026, -14801},   {7025, -14802},   {7024, -14802},   {7022, -14803},   {7021, -14804},
    {7019, -14804},   {7018, -14805},   {7016, -14806},   {7015, -14806},   {7014, -14807},   {7012, -14808},
    {7011, -14808},   {7009, -14809},   {7008, -14810},   {7006, -14810},   {7005, -14811},   {7004, -14812},
    {7002, -14812},   {7001, -14813},   {6999, -14814},   {6998, -14814},   {6997, -14815},   {6995, -14816},
    {6994, -14816},   {6992, -14817},   {6991, -14818},   {6989, -14818},   {6988, -14819},   {6987, -14820},
    {6985, -14820},   {6984, -14821},   {6982, -14822},   {6981, -14822},   {6979, -14823},   {6978, -14824},
    {6977, -14824},   {6975, -14825},   {6974, -14826},   {6972, -14826},   {6971, -14827},   {6970, -14828},
    {6968, -14828},   {6967, -14829},   {6965, -14830},   {6964, -14830},   {6962, -14831},   {6961, -14832},
    {6960, -14832},   {6958, -14833},   {6957, -14834},   {6955, -14834},   {6954, -14835},   {6952, -14836},
    {6951, -14836},   {6950, -14837},   {6948, -14838},   {6947, -14838},   {6945, -14839},   {6944, -14840},
    {6943, -14840},   {6941, -14841},   {6940, -14842},   {6938, -14842},   {6937, -14843},   {6935, -14844},
    {6934, -14844},   {6933, -14845},   {6931, -14846},   {6930, -14846},   {6928, -14847},   {6927, -14848},
    {6925, -14848},   {6924, -14849},   {6923, -14850},   {6921, -14850},   {6920, -14851},   {6918, -14852},
    {6917, -14852},   {6915, -14853},   {6914, -14854},   {6913, -14854},   {6911, -14855},   {6910, -14856},
    {6908, -14856},   {6907, -14857},   {6906, -14858},   {6904, -14858},   {6903, -14859},   {6901, -14860},
    {6900, -14860},   {6898, -14861},   {6897, -14862},   {6896, -14862},   {6894, -14863},   {6893, -14864},
    {6891, -14864},   {6890, -14865},   {6888, -14866},   {6887, -14866},   {6886, -14867},   {6884, -14868},
    {6883, -14868},   {6881, -14869},   {6880, -14870},   {6878, -14870},   {6877, -14871},   {6876, -14872},
    {6874, -14872},   {6873, -14873},   {6871, -14873},   {6870, -14874},   {6868, -14875},   {6867, -14875},
    {6866, -14876},   {6864, -14877},   {6863, -14877},   {6861, -14878},   {6860, -14879},   {6858, -14879},
    {6857, -14880},   {6856, -14881},   {6854, -14881},   {6853, -14882},   {6851, -14883},   {6850, -14883},
    {6848, -14884},   {6847, -14885},   {6846, -14885},   {6844, -14886},   {6843, -14887},   {6841, -14887},
    {6840, -14888},   {6838, -14889},   {6837, -14889},   {6836, -14890},   {6834, -14891},   {6833, -14891},
    {6831, -14892},   {6830, -14893},   {6828, -14893},   {6827, -14894},   {6826, -14894},   {6824, -14895},
    {6823, -14896},   {6821, -14896},   {6820, -14897},   {6818, -14898},   {6817, -14898},   {6816, -14899},
    {6814, -14900},   {6813, -14900},   {6811, -14901},   {6810, -14902},   {6808, -14902},   {6807, -14903},
    {6806, -14904},   {6804, -14904},   {6803, -14905},   {6801, -14906},   {6800, -14906},   {6798, -14907},
    {6797, -14908},   {6796, -14908},   {6794, -14909},   {6793, -14910},   {6791, -14910},   {6790, -14911},
    {6788, -14911},   {6787, -14912},   {6786, -14913},   {6784, -14913},   {6783, -14914},   {6781, -14915},
    {6780, -14915},   {6778, -14916},   {6777, -14917},   {6776, -14917},   {6774, -14918},   {6773, -14919},
    {6771, -14919},   {6770, -14920},   {6768, -14921},   {6767, -14921},   {6766, -14922},   {6764, -14923},
    {6763, -14923},   {6761, -14924},   {6760, -14924},   {6758, -14925},   {6757, -14926},   {6756, -14926},
    {6754, -14927},   {6753, -14928},   {6751, -14928},   {6750, -14929},   {6748, -14930},   {6747, -14930},
    {6746, -14931},   {6744, -14932},   {6743, -14932},   {6741, -14933},   {6740, -14934},   {6738, -14934},
    {6737, -14935},   {6736, -14935},   {6734, -14936},   {6733, -14937},   {6731, -14937},   {6730, -14938},
    {6728, -14939},   {6727, -14939},   {6726, -14940},   {6724, -14941},   {6723, -14941},   {6721, -14942},
    {6720, -14943},   {6718, -14943},   {6717, -14944},   {6715, -14944},   {6714, -14945},   {6713, -14946},
    {6711, -14946},   {6710, -14947},   {6708, -14948},   {6707, -14948},   {6705, -14949},   {6704, -14950},
    {6703, -14950},   {6701, -14951},   {6700, -14952},   {6698, -14952},   {6697, -14953},   {6695, -14953},
    {6694, -14954},   {6693, -14955},   {6691, -14955},   {6690, -14956},   {6688, -14957},   {6687, -14957},
    {6685, -14958},   {6684, -14959},   {6683, -14959},   {6681, -14960},   {6680, -14961},   {6678, -14961},
    {6677, -14962},   {6675, -14962},   {6674, -14963},   {6672, -14964},   {6671, -14964},   {6670, -14965},
    {6668, -14966},   {6667, -14966},   {6665, -14967},   {6664, -14968},   {6662, -14968},   {6661, -14969},
    {6660, -14969},   {6658, -14970},   {6657, -14971},   {6655, -14971},   {6654, -14972},   {6652, -14973},
    {6651, -14973},   {6650, -14974},   {6648, -14975},   {6647, -14975},   {6645, -14976},   {6644, -14977},
    {6642, -14977},   {6641, -14978},   {6639, -14978},   {6638, -14979},   {6637, -14980},   {6635, -14980},
    {6634, -14981},   {6632, -14982},   {6631, -14982},   {6629, -14983},   {6628, -14984},   {6627, -14984},
    {6625, -14985},   {6624, -14985},   {6622, -14986},   {6621, -14987},   {6619, -14987},   {6618, -14988},
    {6616, -14989},   {6615, -14989},   {6614, -14990},   {6612, -14990},   {6611, -14991},   {6609, -14992},
    {6608, -14992},   {6606, -14993},   {6605, -14994},   {6604, -14994},   {6602, -14995},   {6601, -14996},
    {6599, -14996},   {6598, -14997},   {6596, -14997},   {6595, -14998},   {6593, -14999},   {6592, -14999},
    {6591, -15000},   {6589, -15001},   {6588, -15001},   {6586, -15002},   {6585, -15003},   {6583, -15003},
    {6582, -15004},   {6581, -15004},   {6579, -15005},   {6578, -15006},   {6576, -15006},   {6575, -15007},
    {6573, -15008},   {6572, -15008},   {6570, -15009},   {6569, -15009},   {6568, -15010},   {6566, -15011},
    {6565, -15011},   {6563, -15012},   {6562, -15013},   {6560, -15013},   {6559, -15014},   {6558, -15014},
    {6556, -15015},   {6555, -15016},   {6553, -15016},   {6552, -15017},   {6550, -15018},   {6549, -15018},
    {6547, -15019},   {6546, -15019},   {6545, -15020},   {6543, -15021},   {6542, -15021},   {6540, -15022},
    {6539, -15023},   {6537, -15023},   {6536, -15024},   {6534, -15025},   {6533, -15025},   {6532, -15026},
    {6530, -15026},   {6529, -15027},   {6527, -15028},   {6526, -15028},   {6524, -15029},   {6523, -15030},
    {6522, -15030},   {6520, -15031},   {6519, -15031},   {6517, -15032},   {6516, -15033},   {6514, -15033},
    {6513, -15034},   {6511, -15035},   {6510, -15035},   {6509, -15036},   {6507, -15036},   {6506, -15037},
    {6504, -15038},   {6503, -15038},   {6501, -15039},   {6500, -15040},   {6498, -15040},   {6497, -15041},
    {6496, -15041},   {6494, -15042},   {6493, -15043},   {6491, -15043},   {6490, -15044},   {6488, -15044},
    {6487, -15045},   {6485, -15046},   {6484, -15046},   {6483, -15047},   {6481, -15048},   {6480, -15048},
    {6478, -15049},   {6477, -15049},   {6475, -15050},   {6474, -15051},   {6472, -15051},   {6471, -15052},
    {6470, -15053},   {6468, -15053},   {6467, -15054},   {6465, -15054},   {6464, -15055},   {6462, -15056},
    {6461, -15056},   {6459, -15057},   {6458, -15058},   {6457, -15058},   {6455, -15059},   {6454, -15059},
    {6452, -15060},   {6451, -15061},   {6449, -15061},   {6448, -15062},   {6447, -15062},   {6445, -15063},
    {6444, -15064},   {6442, -15064},   {6441, -15065},   {6439, -15066},   {6438, -15066},   {6436, -15067},
    {6435, -15067},   {6434, -15068},   {6432, -15069},   {6431, -15069},   {6429, -15070},   {6428, -15070},
    {6426, -15071},   {6425, -15072},   {6423, -15072},   {6422, -15073},   {6420, -15074},   {6419, -15074},
    {6418, -15075},   {6416, -15075},   {6415, -15076},   {6413, -15077},   {6412, -15077},   {6410, -15078},
    {6409, -15078},   {6407, -15079},   {6406, -15080},   {6405, -15080},   {6403, -15081},   {6402, -15082},
    {6400, -15082},   {6399, -15083},   {6397, -15083},   {6396, -15084},   {6394, -15085},   {6393, -15085},
    {6392, -15086},   {6390, -15086},   {6389, -15087},   {6387, -15088},   {6386, -15088},   {6384, -15089},
    {6383, -15090},   {6381, -15090},   {6380, -15091},   {6379, -15091},   {6377, -15092},   {6376, -15093},
    {6374, -15093},   {6373, -15094},   {6371, -15094},   {6370, -15095},   {6368, -15096},   {6367, -15096},
    {6366, -15097},   {6364, -15097},   {6363, -15098},   {6361, -15099},   {6360, -15099},   {6358, -15100},
    {6357, -15101},   {6355, -15101},   {6354, -15102},   {6353, -15102},   {6351, -15103},   {6350, -15104},
    {6348, -15104},   {6347, -15105},   {6345, -15105},   {6344, -15106},   {6342, -15107},   {6341, -15107},
    {6339, -15108},   {6338, -15108},   {6337, -15109},   {6335, -15110},   {6334, -15110},   {6332, -15111},
    {6331, -15111},   {6329, -15112},   {6328, -15113},   {6326, -15113},   {6325, -15114},   {6324, -15115},
    {6322, -15115},   {6321, -15116},   {6319, -15116},   {6318, -15117},   {6316, -15118},   {6315, -15118},
    {6313, -15119},   {6312, -15119},   {6310, -15120},   {6309, -15121},   {6308, -15121},   {6306, -15122},
    {6305, -15122},   {6303, -15123},   {6302, -15124},   {6300, -15124},   {6299, -15125},   {6297, -15125},
    {6296, -15126},   {6295, -15127},   {6293, -15127},   {6292, -15128},   {6290, -15128},   {6289, -15129},
    {6287, -15130},   {6286, -15130},   {6284, -15131},   {6283, -15131},   {6281, -15132},   {6280, -15133},
    {6279, -15133},   {6277, -15134},   {6276, -15134},   {6274, -15135},   {6273, -15136},   {6271, -15136},
    {6270, -15137},   {6268, -15137},   {6267, -15138},   {6266, -15139},   {6264, -15139},   {6263, -15140},
    {6261, -15140},   {6260, -15141},   {6258, -15142},   {6257, -15142},   {6255, -15143},   {6254, -15143},
    {6252, -15144},   {6251, -15145},   {6250, -15145},   {6248, -15146},   {6247, -15146},   {6245, -15147},
    {6244, -15148},   {6242, -15148},   {6241, -15149},   {6239, -15149},   {6238, -15150},   {6236, -15151},
    {6235, -15151},   {6234, -15152},   {6232, -15152},   {6231, -15153},   {6229, -15154},   {6228, -15154},
    {6226, -15155},   {6225, -15155},   {6223, -15156},   {6222, -15157},   {6221, -15157},   {6219, -15158},
    {6218, -15158},   {6216, -15159},   {6215, -15160},   {6213, -15160},   {6212, -15161},   {6210, -15161},
    {6209, -15162},   {6207, -15163},   {6206, -15163},   {6205, -15164},   {6203, -15164},   {6202, -15165},
    {6200, -15166},   {6199, -15166},   {6197, -15167},   {6196, -15167},   {6194, -15168},   {6193, -15169},
    {6191, -15169},   {6190, -15170},   {6189, -15170},   {6187, -15171},   {6186, -15171},   {6184, -15172},
    {6183, -15173},   {6181, -15173},   {6180, -15174},   {6178, -15174},   {6177, -15175},   {6175, -15176},
    {6174, -15176},   {6173, -15177},   {6171, -15177},   {6170, -15178},   {6168, -15179},   {6167, -15179},
    {6165, -15180},   {6164, -15180},   {6162, -15181},   {6161, -15182},   {6159, -15182},   {6158, -15183},
    {6157, -15183},   {6155, -15184},   {6154, -15184},   {6152, -15185},   {6151, -15186},   {6149, -15186},
    {6148, -15187},   {6146, -15187},   {6145, -15188},   {6143, -15189},   {6142, -15189},   {6140, -15190},
    {6139, -15190},   {6138, -15191},   {6136, -15192},   {6135, -15192},   {6133, -15193},   {6132, -15193},
    {6130, -15194},   {6129, -15194},   {6127, -15195},   {6126, -15196},   {6124, -15196},   {6123, -15197},
    {6122, -15197},   {6120, -15198},   {6119, -15199},   {6117, -15199},   {6116, -15200},   {6114, -15200},
    {6113, -15201},   {6111, -15202},   {6110, -15202},   {6108, -15203},   {6107, -15203},   {6106, -15204},
    {6104, -15204},   {6103, -15205},   {6101, -15206},   {6100, -15206},   {6098, -15207},   {6097, -15207},
    {6095, -15208},   {6094, -15209},   {6092, -15209},   {6091, -15210},   {6089, -15210},   {6088, -15211},
    {6087, -15211},   {6085, -15212},   {6084, -15213},   {6082, -15213},   {6081, -15214},   {6079, -15214},
    {6078, -15215},   {6076, -15216},   {6075, -15216},   {6073, -15217},   {6072, -15217},   {6071, -15218},
    {6069, -15218},   {6068, -15219},   {6066, -15220},   {6065, -15220},   {6063, -15221},   {6062, -15221},
    {6060, -15222},   {6059, -15223},   {6057, -15223},   {6056, -15224},   {6054, -15224},   {6053, -15225},
    {6052, -15225},   {6050, -15226},   {6049, -15227},   {6047, -15227},   {6046, -15228},   {6044, -15228},
    {6043, -15229},   {6041, -15229},   {6040, -15230},   {6038, -15231},   {6037, -15231},   {6036, -15232},
    {6034, -15232},   {6033, -15233},   {6031, -15234},   {6030, -15234},   {6028, -15235},   {6027, -15235},
    {6025, -15236},   {6024, -15236},   {6022, -15237},   {6021, -15238},   {6019, -15238},   {6018, -15239},
    {6017, -15239},   {6015, -15240},   {6014, -15240},   {6012, -15241},   {6011, -15242},   {6009, -15242},
    {6008, -15243},   {6006, -15243},   {6005, -15244},   {6003, -15245},   {6002, -15245},   {6000, -15246},
    {5999, -15246},   {5998, -15247},   {5996, -15247},   {5995, -15248},   {5993, -15249},   {5992, -15249},
    {5990, -15250},   {5989, -15250},   {5987, -15251},   {5986, -15251},   {5984, -15252},   {5983, -15253},
    {5981, -15253},   {5980, -15254},   {5979, -15254},   {5977, -15255},   {5976, -15255},   {5974, -15256},
    {5973, -15257},   {5971, -15257},   {5970, -15258},   {5968, -15258},   {5967, -15259},   {5965, -15259},
    {5964, -15260},   {5962, -15261},   {5961, -15261},   {5959, -15262},   {5958, -15262},   {5957, -15263},
    {5955, -15263},   {5954, -15264},   {5952, -15265},   {5951, -15265},   {5949, -15266},   {5948, -15266},
    {5946, -15267},   {5945, -15267},   {5943, -15268},   {5942, -15269},   {5940, -15269},   {5939, -15270},
    {5938, -15270},   {5936, -15271},   {5935, -15271},   {5933, -15272},   {5932, -15273},   {5930, -15273},
    {5929, -15274},   {5927, -15274},   {5926, -15275},   {5924, -15275},   {5923, -15276},   {5921, -15277},
    {5920, -15277},   {5918, -15278},   {5917, -15278},   {5916, -15279},   {5914, -15279},   {5913, -15280},
    {5911, -15280},   {5910, -15281},   {5908, -15282},   {5907, -15282},   {5905, -15283},   {5904, -15283},
    {5902, -15284},   {5901, -15284},   {5899, -15285},   {5898, -15286},   {5897, -15286},   {5895, -15287},
    {5894, -15287},   {5892, -15288},   {5891, -15288},   {5889, -15289},   {5888, -15290},   {5886, -15290},
    {5885, -15291},   {5883, -15291},   {5882, -15292},   {5880, -15292},   {5879, -15293},   {5877, -15293},
    {5876, -15294},   {5875, -15295},   {5873, -15295},   {5872, -15296},   {5870, -15296},   {5869, -15297},
    {5867, -15297},   {5866, -15298},   {5864, -15299},   {5863, -15299},   {5861, -15300},   {5860, -15300},
    {5858, -15301},   {5857, -15301},   {5855, -15302},   {5854, -15302},   {5853, -15303},   {5851, -15304},
    {5850, -15304},   {5848, -15305},   {5847, -15305},   {5845, -15306},   {5844, -15306},   {5842, -15307},
    {5841, -15308},   {5839, -15308},   {5838, -15309},   {5836, -15309},   {5835, -15310},   {5833, -15310},
    {5832, -15311},   {5831, -15311},   {5829, -15312},   {5828, -15313},   {5826, -15313},   {5825, -15314},
    {5823, -15314},   {5822, -15315},   {5820, -15315},   {5819, -15316},   {5817, -15316},   {5816, -15317},
    {5814, -15318},   {5813, -15318},   {5811, -15319},   {5810, -15319},   {5808, -15320},   {5807, -15320},
    {5806, -15321},   {5804, -15321},   {5803, -15322},   {5801, -15323},   {5800, -15323},   {5798, -15324},
    {5797, -15324},   {5795, -15325},   {5794, -15325},   {5792, -15326},   {5791, -15326},   {5789, -15327},
    {5788, -15328},   {5786, -15328},   {5785, -15329},   {5784, -15329},   {5782, -15330},   {5781, -15330},
    {5779, -15331},   {5778, -15331},   {5776, -15332},   {5775, -15333},   {5773, -15333},   {5772, -15334},
    {5770, -15334},   {5769, -15335},   {5767, -15335},   {5766, -15336},   {5764, -15336},   {5763, -15337},
    {5761, -15338},   {5760, -15338},   {5759, -15339},   {5757, -15339},   {5756, -15340},   {5754, -15340},
    {5753, -15341},   {5751, -15341},   {5750, -15342},   {5748, -15343},   {5747, -15343},   {5745, -15344},
    {5744, -15344},   {5742, -15345},   {5741, -15345},   {5739, -15346},   {5738, -15346},   {5736, -15347},
    {5735, -15347},   {5734, -15348},   {5732, -15349},   {5731, -15349},   {5729, -15350},   {5728, -15350},
    {5726, -15351},   {5725, -15351},   {5723, -15352},   {5722, -15352},   {5720, -15353},   {5719, -15354},
    {5717, -15354},   {5716, -15355},   {5714, -15355},   {5713, -15356},   {5711, -15356},   {5710, -15357},
    {5708, -15357},   {5707, -15358},   {5706, -15358},   {5704, -15359},   {5703, -15360},   {5701, -15360},
    {5700, -15361},   {5698, -15361},   {5697, -15362},   {5695, -15362},   {5694, -15363},   {5692, -15363},
    {5691, -15364},   {5689, -15364},   {5688, -15365},   {5686, -15366},   {5685, -15366},   {5683, -15367},
    {5682, -15367},   {5681, -15368},   {5679, -15368},   {5678, -15369},   {5676, -15369},   {5675, -15370},
    {5673, -15370},   {5672, -15371},   {5670, -15372},   {5669, -15372},   {5667, -15373},   {5666, -15373},
    {5664, -15374},   {5663, -15374},   {5661, -15375},   {5660, -15375},   {5658, -15376},   {5657, -15376},
    {5655, -15377},   {5654, -15378},   {5653, -15378},   {5651, -15379},   {5650, -15379},   {5648, -15380},
    {5647, -15380},   {5645, -15381},   {5644, -15381},   {5642, -15382},   {5641, -15382},   {5639, -15383},
    {5638, -15383},   {5636, -15384},   {5635, -15385},   {5633, -15385},   {5632, -15386},   {5630, -15386},
    {5629, -15387},   {5627, -15387},   {5626, -15388},   {5624, -15388},   {5623, -15389},   {5622, -15389},
    {5620, -15390},   {5619, -15390},   {5617, -15391},   {5616, -15392},   {5614, -15392},   {5613, -15393},
    {5611, -15393},   {5610, -15394},   {5608, -15394},   {5607, -15395},   {5605, -15395},   {5604, -15396},
    {5602, -15396},   {5601, -15397},   {5599, -15397},   {5598, -15398},   {5596, -15399},   {5595, -15399},
    {5593, -15400},   {5592, -15400},   {5591, -15401},   {5589, -15401},   {5588, -15402},   {5586, -15402},
    {5585, -15403},   {5583, -15403},   {5582, -15404},   {5580, -15404},   {5579, -15405},   {5577, -15406},
    {5576, -15406},   {5574, -15407},   {5573, -15407},   {5571, -15408},   {5570, -15408},   {5568, -15409},
    {5567, -15409},   {5565, -15410},   {5564, -15410},   {5562, -15411},   {5561, -15411},   {5560, -15412},
    {5558, -15412},   {5557, -15413},   {5555, -15414},   {5554, -15414},   {5552, -15415},   {5551, -15415},
    {5549, -15416},   {5548, -15416},   {5546, -15417},   {5545, -15417},   {5543, -15418},   {5542, -15418},
    {5540, -15419},   {5539, -15419},   {5537, -15420},   {5536, -15420},   {5534, -15421},   {5533, -15421},
    {5531, -15422},   {5530, -15423},   {5528, -15423},   {5527, -15424},   {5526, -15424},   {5524, -15425},
    {5523, -15425},   {5521, -15426},   {5520, -15426},   {5518, -15427},   {5517, -15427},   {5515, -15428},
    {5514, -15428},   {5512, -15429},   {5511, -15429},   {5509, -15430},   {5508, -15430},   {5506, -15431},
    {5505, -15432},   {5503, -15432},   {5502, -15433},   {5500, -15433},   {5499, -15434},   {5497, -15434},
    {5496, -15435},   {5494, -15435},   {5493, -15436},   {5491, -15436},   {5490, -15437},   {5489, -15437},
    {5487, -15438},   {5486, -15438},   {5484, -15439},   {5483, -15439},   {5481, -15440},   {5480, -15440},
    {5478, -15441},   {5477, -15442},   {5475, -15442},   {5474, -15443},   {5472, -15443},   {5471, -15444},
    {5469, -15444},   {5468, -15445},   {5466, -15445},   {5465, -15446},   {5463, -15446},   {5462, -15447},
    {5460, -15447},   {5459, -15448},   {5457, -15448},   {5456, -15449},   {5454, -15449},   {5453, -15450},
    {5452, -15450},   {5450, -15451},   {5449, -15451},   {5447, -15452},   {5446, -15453},   {5444, -15453},
    {5443, -15454},   {5441, -15454},   {5440, -15455},   {5438, -15455},   {5437, -15456},   {5435, -15456},
    {5434, -15457},   {5432, -15457},   {5431, -15458},   {5429, -15458},   {5428, -15459},   {5426, -15459},
    {5425, -15460},   {5423, -15460},   {5422, -15461},   {5420, -15461},   {5419, -15462},   {5417, -15462},
    {5416, -15463},   {5414, -15463},   {5413, -15464},   {5412, -15465},   {5410, -15465},   {5409, -15466},
    {5407, -15466},   {5406, -15467},   {5404, -15467},   {5403, -15468},   {5401, -15468},   {5400, -15469},
    {5398, -15469},   {5397, -15470},   {5395, -15470},   {5394, -15471},   {5392, -15471},   {5391, -15472},
    {5389, -15472},   {5388, -15473},   {5386, -15473},   {5385, -15474},   {5383, -15474},   {5382, -15475},
    {5380, -15475},   {5379, -15476},   {5377, -15476},   {5376, -15477},   {5374, -15477},   {5373, -15478},
    {5371, -15478},   {5370, -15479},   {5368, -15479},   {5367, -15480},   {5366, -15481},   {5364, -15481},
    {5363, -15482},   {5361, -15482},   {5360, -15483},   {5358, -15483},   {5357, -15484},   {5355, -15484},
    {5354, -15485},   {5352, -15485},   {5351, -15486},   {5349, -15486},   {5348, -15487},   {5346, -15487},
    {5345, -15488},   {5343, -15488},   {5342, -15489},   {5340, -15489},   {5339, -15490},   {5337, -15490},
    {5336, -15491},   {5334, -15491},   {5333, -15492},   {5331, -15492},   {5330, -15493},   {5328, -15493},
    {5327, -15494},   {5325, -15494},   {5324, -15495},   {5322, -15495},   {5321, -15496},   {5319, -15496},
    {5318, -15497},   {5317, -15497},   {5315, -15498},   {5314, -15498},   {5312, -15499},   {5311, -15499},
    {5309, -15500},   {5308, -15500},   {5306, -15501},   {5305, -15501},   {5303, -15502},   {5302, -15503},
    {5300, -15503},   {5299, -15504},   {5297, -15504},   {5296, -15505},   {5294, -15505},   {5293, -15506},
    {5291, -15506},   {5290, -15507},   {5288, -15507},   {5287, -15508},   {5285, -15508},   {5284, -15509},
    {5282, -15509},   {5281, -15510},   {5279, -15510},   {5278, -15511},   {5276, -15511},   {5275, -15512},
    {5273, -15512},   {5272, -15513},   {5270, -15513},   {5269, -15514},   {5267, -15514},   {5266, -15515},
    {5264, -15515},   {5263, -15516},   {5262, -15516},   {5260, -15517},   {5259, -15517},   {5257, -15518},
    {5256, -15518},   {5254, -15519},   {5253, -15519},   {5251, -15520},   {5250, -15520},   {5248, -15521},
    {5247, -15521},   {5245, -15522},   {5244, -15522},   {5242, -15523},   {5241, -15523},   {5239, -15524},
    {5238, -15524},   {5236, -15525},   {5235, -15525},   {5233, -15526},   {5232, -15526},   {5230, -15527},
    {5229, -15527},   {5227, -15528},   {5226, -15528},   {5224, -15529},   {5223, -15529},   {5221, -15530},
    {5220, -15530},   {5218, -15531},   {5217, -15531},   {5215, -15532},   {5214, -15532},   {5212, -15533},
    {5211, -15533},   {5209, -15534},   {5208, -15534},   {5206, -15535},   {5205, -15535},   {5203, -15536},
    {5202, -15536},   {5200, -15537},   {5199, -15537},   {5197, -15538},   {5196, -15538},   {5195, -15539},
    {5193, -15539},   {5192, -15540},   {5190, -15540},   {5189, -15541},   {5187, -15541},   {5186, -15542},
    {5184, -15542},   {5183, -15543},   {5181, -15543},   {5180, -15544},   {5178, -15544},   {5177, -15545},
    {5175, -15545},   {5174, -15546},   {5172, -15546},   {5171, -15547},   {5169, -15547},   {5168, -15548},
    {5166, -15548},   {5165, -15549},   {5163, -15549},   {5162, -15550},   {5160, -15550},   {5159, -15551},
    {5157, -15551},   {5156, -15552},   {5154, -15552},   {5153, -15553},   {5151, -15553},   {5150, -15554},
    {5148, -15554},   {5147, -15555},   {5145, -15555},   {5144, -15556},   {5142, -15556},   {5141, -15557},
    {5139, -15557},   {5138, -15558},   {5136, -15558},   {5135, -15559},   {5133, -15559},   {5132, -15560},
    {5130, -15560},   {5129, -15561},   {5127, -15561},   {5126, -15561},   {5124, -15562},   {5123, -15562},
    {5121, -15563},   {5120, -15563},   {5118, -15564},   {5117, -15564},   {5115, -15565},   {5114, -15565},
    {5113, -15566},   {5111, -15566},   {5110, -15567},   {5108, -15567},   {5107, -15568},   {5105, -15568},
    {5104, -15569},   {5102, -15569},   {5101, -15570},   {5099, -15570},   {5098, -15571},   {5096, -15571},
    {5095, -15572},   {5093, -15572},   {5092, -15573},   {5090, -15573},   {5089, -15574},   {5087, -15574},
    {5086, -15575},   {5084, -15575},   {5083, -15576},   {5081, -15576},   {5080, -15577},   {5078, -15577},
    {5077, -15578},   {5075, -15578},   {5074, -15579},   {5072, -15579},   {5071, -15580},   {5069, -15580},
    {5068, -15581},   {5066, -15581},   {5065, -15582},   {5063, -15582},   {5062, -15582},   {5060, -15583},
    {5059, -15583},   {5057, -15584},   {5056, -15584},   {5054, -15585},   {5053, -15585},   {5051, -15586},
    {5050, -15586},   {5048, -15587},   {5047, -15587},   {5045, -15588},   {5044, -15588},   {5042, -15589},
    {5041, -15589},   {5039, -15590},   {5038, -15590},   {5036, -15591},   {5035, -15591},   {5033, -15592},
    {5032, -15592},   {5030, -15593},   {5029, -15593},   {5027, -15594},   {5026, -15594},   {5024, -15595},
    {5023, -15595},   {5021, -15596},   {5020, -15596},   {5018, -15597},   {5017, -15597},   {5015, -15597},
    {5014, -15598},   {5012, -15598},   {5011, -15599},   {5009, -15599},   {5008, -15600},   {5006, -15600},
    {5005, -15601},   {5003, -15601},   {5002, -15602},   {5000, -15602},   {4999, -15603},   {4997, -15603},
    {4996, -15604},   {4994, -15604},   {4993, -15605},   {4991, -15605},   {4990, -15606},   {4988, -15606},
    {4987, -15607},   {4985, -15607},   {4984, -15608},   {4982, -15608},   {4981, -15608},   {4980, -15609},
    {4978, -15609},   {4977, -15610},   {4975, -15610},   {4974, -15611},   {4972, -15611},   {4971, -15612},
    {4969, -15612},   {4968, -15613},   {4966, -15613},   {4965, -15614},   {4963, -15614},   {4962, -15615},
    {4960, -15615},   {4959, -15616},   {4957, -15616},   {4956, -15617},   {4954, -15617},   {4953, -15618},
    {4951, -15618},   {4950, -15618},   {4948, -15619},   {4947, -15619},   {4945, -15620},   {4944, -15620},
    {4942, -15621},   {4941, -15621},   {4939, -15622},   {4938, -15622},   {4936, -15623},   {4935, -15623},
    {4933, -15624},   {4932, -15624},   {4930, -15625},   {4929, -15625},   {4927, -15626},   {4926, -15626},
    {4924, -15627},   {4923, -15627},   {4921, -15627},   {4920, -15628},   {4918, -15628},   {4917, -15629},
    {4915, -15629},   {4914, -15630},   {4912, -15630},   {4911, -15631},   {4909, -15631},   {4908, -15632},
    {4906, -15632},   {4905, -15633},   {4903, -15633},   {4902, -15634},   {4900, -15634},   {4899, -15635},
    {4897, -15635},   {4896, -15635},   {4894, -15636},   {4893, -15636},   {4891, -15637},   {4890, -15637},
    {4888, -15638},   {4887, -15638},   {4885, -15639},   {4884, -15639},   {4882, -15640},   {4881, -15640},
    {4879, -15641},   {4878, -15641},   {4876, -15642},   {4875, -15642},   {4873, -15643},   {4872, -15643},
    {4870, -15643},   {4869, -15644},   {4867, -15644},   {4866, -15645},   {4864, -15645},   {4863, -15646},
    {4861, -15646},   {4860, -15647},   {4858, -15647},   {4857, -15648},   {4855, -15648},   {4854, -15649},
    {4852, -15649},   {4851, -15649},   {4849, -15650},   {4848, -15650},   {4846, -15651},   {4845, -15651},
    {4843, -15652},   {4842, -15652},   {4840, -15653},   {4839, -15653},   {4837, -15654},   {4836, -15654},
    {4834, -15655},   {4833, -15655},   {4831, -15656},   {4830, -15656},   {4828, -15656},   {4827, -15657},
    {4825, -15657},   {4824, -15658},   {4822, -15658},   {4821, -15659},   {4819, -15659},   {4818, -15660},
    {4816, -15660},   {4815, -15661},   {4813, -15661},   {4812, -15662},   {4810, -15662},   {4809, -15662},
    {4807, -15663},   {4806, -15663},   {4804, -15664},   {4803, -15664},   {4801, -15665},   {4800, -15665},
    {4798, -15666},   {4797, -15666},   {4795, -15667},   {4794, -15667},   {4792, -15668},   {4791, -15668},
    {4789, -15668},   {4788, -15669},   {4786, -15669},   {4785, -15670},   {4783, -15670},   {4782, -15671},
    {4780, -15671},   {4779, -15672},   {4777, -15672},   {4776, -15673},   {4774, -15673},   {4773, -15673},
    {4771, -15674},   {4770, -15674},   {4768, -15675},   {4767, -15675},   {4765, -15676},   {4764, -15676},
    {4762, -15677},   {4761, -15677},   {4759, -15678},   {4758, -15678},   {4756, -15679},   {4755, -15679},
    {4753, -15679},   {4752, -15680},   {4750, -15680},   {4749, -15681},   {4747, -15681},   {4746, -15682},
    {4744, -15682},   {4742, -15683},   {4741, -15683},   {4739, -15684},   {4738, -15684},   {4736, -15684},
    {4735, -15685},   {4733, -15685},   {4732, -15686},   {4730, -15686},   {4729, -15687},   {4727, -15687},
    {4726, -15688},   {4724, -15688},   {4723, -15689},   {4721, -15689},   {4720, -15689},   {4718, -15690},
    {4717, -15690},   {4715, -15691},   {4714, -15691},   {4712, -15692},   {4711, -15692},   {4709, -15693},
    {4708, -15693},   {4706, -15693},   {4705, -15694},   {4703, -15694},   {4702, -15695},   {4700, -15695},
    {4699, -15696},   {4697, -15696},   {4696, -15697},   {4694, -15697},   {4693, -15698},   {4691, -15698},
    {4690, -15698},   {4688, -15699},   {4687, -15699},   {4685, -15700},   {4684, -15700},   {4682, -15701},
    {4681, -15701},   {4679, -15702},   {4678, -15702},   {4676, -15702},   {4675, -15703},   {4673, -15703},
    {4672, -15704},   {4670, -15704},   {4669, -15705},   {4667, -15705},   {4666, -15706},   {4664, -15706},
    {4663, -15707},   {4661, -15707},   {4660, -15707},   {4658, -15708},   {4657, -15708},   {4655, -15709},
    {4654, -15709},   {4652, -15710},   {4651, -15710},   {4649, -15711},   {4648, -15711},   {4646, -15711},
    {4645, -15712},   {4643, -15712},   {4642, -15713},   {4640, -15713},   {4639, -15714},   {4637, -15714},
    {4636, -15715},   {4634, -15715},   {4633, -15715},   {4631, -15716},   {4630, -15716},   {4628, -15717},
    {4627, -15717},   {4625, -15718},   {4624, -15718},   {4622, -15719},   {4621, -15719},   {4619, -15719},
    {4618, -15720},   {4616, -15720},   {4615, -15721},   {4613, -15721},   {4612, -15722},   {4610, -15722},
    {4609, -15723},   {4607, -15723},   {4605, -15723},   {4604, -15724},   {4602, -15724},   {4601, -15725},
    {4599, -15725},   {4598, -15726},   {4596, -15726},   {4595, -15726},   {4593, -15727},   {4592, -15727},
    {4590, -15728},   {4589, -15728},   {4587, -15729},   {4586, -15729},   {4584, -15730},   {4583, -15730},
    {4581, -15730},   {4580, -15731},   {4578, -15731},   {4577, -15732},   {4575, -15732},   {4574, -15733},
    {4572, -15733},   {4571, -15734},   {4569, -15734},   {4568, -15734},   {4566, -15735},   {4565, -15735},
    {4563, -15736},   {4562, -15736},   {4560, -15737},   {4559, -15737},   {4557, -15737},   {4556, -15738},
    {4554, -15738},   {4553, -15739},   {4551, -15739},   {4550, -15740},   {4548, -15740},   {4547, -15740},
    {4545, -15741},   {4544, -15741},   {4542, -15742},   {4541, -15742},   {4539, -15743},   {4538, -15743},
    {4536, -15744},   {4535, -15744},   {4533, -15744},   {4532, -15745},   {4530, -15745},   {4529, -15746},
    {4527, -15746},   {4526, -15747},   {4524, -15747},   {4523, -15747},   {4521, -15748},   {4519, -15748},
    {4518, -15749},   {4516, -15749},   {4515, -15750},   {4513, -15750},   {4512, -15750},   {4510, -15751},
    {4509, -15751},   {4507, -15752},   {4506, -15752},   {4504, -15753},   {4503, -15753},   {4501, -15754},
    {4500, -15754},   {4498, -15754},   {4497, -15755},   {4495, -15755},   {4494, -15756},   {4492, -15756},
    {4491, -15757},   {4489, -15757},   {4488, -15757},   {4486, -15758},   {4485, -15758},   {4483, -15759},
    {4482, -15759},   {4480, -15760},   {4479, -15760},   {4477, -15760},   {4476, -15761},   {4474, -15761},
    {4473, -15762},   {4471, -15762},   {4470, -15763},   {4468, -15763},   {4467, -15763},   {4465, -15764},
    {4464, -15764},   {4462, -15765},   {4461, -15765},   {4459, -15766},   {4458, -15766},   {4456, -15766},
    {4455, -15767},   {4453, -15767},   {4452, -15768},   {4450, -15768},   {4448, -15769},   {4447, -15769},
    {4445, -15769},   {4444, -15770},   {4442, -15770},   {4441, -15771},   {4439, -15771},   {4438, -15772},
    {4436, -15772},   {4435, -15772},   {4433, -15773},   {4432, -15773},   {4430, -15774},   {4429, -15774},
    {4427, -15774},   {4426, -15775},   {4424, -15775},   {4423, -15776},   {4421, -15776},   {4420, -15777},
    {4418, -15777},   {4417, -15777},   {4415, -15778},   {4414, -15778},   {4412, -15779},   {4411, -15779},
    {4409, -15780},   {4408, -15780},   {4406, -15780},   {4405, -15781},   {4403, -15781},   {4402, -15782},
    {4400, -15782},   {4399, -15783},   {4397, -15783},   {4396, -15783},   {4394, -15784},   {4393, -15784},
    {4391, -15785},   {4389, -15785},   {4388, -15785},   {4386, -15786},   {4385, -15786},   {4383, -15787},
    {4382, -15787},   {4380, -15788},   {4379, -15788},   {4377, -15788},   {4376, -15789},   {4374, -15789},
    {4373, -15790},   {4371, -15790},   {4370, -15791},   {4368, -15791},   {4367, -15791},   {4365, -15792},
    {4364, -15792},   {4362, -15793},   {4361, -15793},   {4359, -15793},   {4358, -15794},   {4356, -15794},
    {4355, -15795},   {4353, -15795},   {4352, -15796},   {4350, -15796},   {4349, -15796},   {4347, -15797},
    {4346, -15797},   {4344, -15798},   {4343, -15798},   {4341, -15798},   {4340, -15799},   {4338, -15799},
    {4337, -15800},   {4335, -15800},   {4333, -15801},   {4332, -15801},   {4330, -15801},   {4329, -15802},
    {4327, -15802},   {4326, -15803},   {4324, -15803},   {4323, -15803},   {4321, -15804},   {4320, -15804},
    {4318, -15805},   {4317, -15805},   {4315, -15805},   {4314, -15806},   {4312, -15806},   {4311, -15807},
    {4309, -15807},   {4308, -15808},   {4306, -15808},   {4305, -15808},   {4303, -15809},   {4302, -15809},
    {4300, -15810},   {4299, -15810},   {4297, -15810},   {4296, -15811},   {4294, -15811},   {4293, -15812},
    {4291, -15812},   {4290, -15813},   {4288, -15813},   {4286, -15813},   {4285, -15814},   {4283, -15814},
    {4282, -15815},   {4280, -15815},   {4279, -15815},   {4277, -15816},   {4276, -15816},   {4274, -15817},
    {4273, -15817},   {4271, -15817},   {4270, -15818},   {4268, -15818},   {4267, -15819},   {4265, -15819},
    {4264, -15819},   {4262, -15820},   {4261, -15820},   {4259, -15821},   {4258, -15821},   {4256, -15822},
    {4255, -15822},   {4253, -15822},   {4252, -15823},   {4250, -15823},   {4249, -15824},   {4247, -15824},
    {4246, -15824},   {4244, -15825},   {4243, -15825},   {4241, -15826},   {4239, -15826},   {4238, -15826},
    {4236, -15827},   {4235, -15827},   {4233, -15828},   {4232, -15828},   {4230, -15828},   {4229, -15829},
    {4227, -15829},   {4226, -15830},   {4224, -15830},   {4223, -15830},   {4221, -15831},   {4220, -15831},
    {4218, -15832},   {4217, -15832},   {4215, -15832},   {4214, -15833},   {4212, -15833},   {4211, -15834},
    {4209, -15834},   {4208, -15835},   {4206, -15835},   {4205, -15835},   {4203, -15836},   {4202, -15836},
    {4200, -15837},   {4198, -15837},   {4197, -15837},   {4195, -15838},   {4194, -15838},   {4192, -15839},
    {4191, -15839},   {4189, -15839},   {4188, -15840},   {4186, -15840},   {4185, -15841},   {4183, -15841},
    {4182, -15841},   {4180, -15842},   {4179, -15842},   {4177, -15843},   {4176, -15843},   {4174, -15843},
    {4173, -15844},   {4171, -15844},   {4170, -15845},   {4168, -15845},   {4167, -15845},   {4165, -15846},
    {4164, -15846},   {4162, -15847},   {4161, -15847},   {4159, -15847},   {4157, -15848},   {4156, -15848},
    {4154, -15849},   {4153, -15849},   {4151, -15849},   {4150, -15850},   {4148, -15850},   {4147, -15851},
    {4145, -15851},   {4144, -15851},   {4142, -15852},   {4141, -15852},   {4139, -15853},   {4138, -15853},
    {4136, -15853},   {4135, -15854},   {4133, -15854},   {4132, -15854},   {4130, -15855},   {4129, -15855},
    {4127, -15856},   {4126, -15856},   {4124, -15856},   {4123, -15857},   {4121, -15857},   {4119, -15858},
    {4118, -15858},   {4116, -15858},   {4115, -15859},   {4113, -15859},   {4112, -15860},   {4110, -15860},
    {4109, -15860},   {4107, -15861},   {4106, -15861},   {4104, -15862},   {4103, -15862},   {4101, -15862},
    {4100, -15863},   {4098, -15863},   {4097, -15864},   {4095, -15864},   {4094, -15864},   {4092, -15865},
    {4091, -15865},   {4089, -15866},   {4088, -15866},   {4086, -15866},   {4085, -15867},   {4083, -15867},
    {4081, -15867},   {4080, -15868},   {4078, -15868},   {4077, -15869},   {4075, -15869},   {4074, -15869},
    {4072, -15870},   {4071, -15870},   {4069, -15871},   {4068, -15871},   {4066, -15871},   {4065, -15872},
    {4063, -15872},   {4062, -15873},   {4060, -15873},   {4059, -15873},   {4057, -15874},   {4056, -15874},
    {4054, -15875},   {4053, -15875},   {4051, -15875},   {4050, -15876},   {4048, -15876},   {4046, -15876},
    {4045, -15877},   {4043, -15877},   {4042, -15878},   {4040, -15878},   {4039, -15878},   {4037, -15879},
    {4036, -15879},   {4034, -15880},   {4033, -15880},   {4031, -15880},   {4030, -15881},   {4028, -15881},
    {4027, -15881},   {4025, -15882},   {4024, -15882},   {4022, -15883},   {4021, -15883},   {4019, -15883},
    {4018, -15884},   {4016, -15884},   {4015, -15885},   {4013, -15885},   {4011, -15885},   {4010, -15886},
    {4008, -15886},   {4007, -15886},   {4005, -15887},   {4004, -15887},   {4002, -15888},   {4001, -15888},
    {3999, -15888},   {3998, -15889},   {3996, -15889},   {3995, -15890},   {3993, -15890},   {3992, -15890},
    {3990, -15891},   {3989, -15891},   {3987, -15891},   {3986, -15892},   {3984, -15892},   {3983, -15893},
    {3981, -15893},   {3979, -15893},   {3978, -15894},   {3976, -15894},   {3975, -15895},   {3973, -15895},
    {3972, -15895},   {3970, -15896},   {3969, -15896},   {3967, -15896},   {3966, -15897},   {3964, -15897},
    {3963, -15898},   {3961, -15898},   {3960, -15898},   {3958, -15899},   {3957, -15899},   {3955, -15899},
    {3954, -15900},   {3952, -15900},   {3951, -15901},   {3949, -15901},   {3947, -15901},   {3946, -15902},
    {3944, -15902},   {3943, -15902},   {3941, -15903},   {3940, -15903},   {3938, -15904},   {3937, -15904},
    {3935, -15904},   {3934, -15905},   {3932, -15905},   {3931, -15906},   {3929, -15906},   {3928, -15906},
    {3926, -15907},   {3925, -15907},   {3923, -15907},   {3922, -15908},   {3920, -15908},   {3918, -15909},
    {3917, -15909},   {3915, -15909},   {3914, -15910},   {3912, -15910},   {3911, -15910},   {3909, -15911},
    {3908, -15911},   {3906, -15912},   {3905, -15912},   {3903, -15912},   {3902, -15913},   {3900, -15913},
    {3899, -15913},   {3897, -15914},   {3896, -15914},   {3894, -15915},   {3893, -15915},   {3891, -15915},
    {3889, -15916},   {3888, -15916},   {3886, -15916},   {3885, -15917},   {3883, -15917},   {3882, -15917},
    {3880, -15918},   {3879, -15918},   {3877, -15919},   {3876, -15919},   {3874, -15919},   {3873, -15920},
    {3871, -15920},   {3870, -15920},   {3868, -15921},   {3867, -15921},   {3865, -15922},   {3864, -15922},
    {3862, -15922},   {3861, -15923},   {3859, -15923},   {3857, -15923},   {3856, -15924},   {3854, -15924},
    {3853, -15925},   {3851, -15925},   {3850, -15925},   {3848, -15926},   {3847, -15926},   {3845, -15926},
    {3844, -15927},   {3842, -15927},   {3841, -15927},   {3839, -15928},   {3838, -15928},   {3836, -15929},
    {3835, -15929},   {3833, -15929},   {3831, -15930},   {3830, -15930},   {3828, -15930},   {3827, -15931},
    {3825, -15931},   {3824, -15932},   {3822, -15932},   {3821, -15932},   {3819, -15933},   {3818, -15933},
    {3816, -15933},   {3815, -15934},   {3813, -15934},   {3812, -15934},   {3810, -15935},   {3809, -15935},
    {3807, -15936},   {3806, -15936},   {3804, -15936},   {3802, -15937},   {3801, -15937},   {3799, -15937},
    {3798, -15938},   {3796, -15938},   {3795, -15938},   {3793, -15939},   {3792, -15939},   {3790, -15940},
    {3789, -15940},   {3787, -15940},   {3786, -15941},   {3784, -15941},   {3783, -15941},   {3781, -15942},
    {3780, -15942},   {3778, -15942},   {3776, -15943},   {3775, -15943},   {3773, -15944},   {3772, -15944},
    {3770, -15944},   {3769, -15945},   {3767, -15945},   {3766, -15945},   {3764, -15946},   {3763, -15946},
    {3761, -15946},   {3760, -15947},   {3758, -15947},   {3757, -15948},   {3755, -15948},   {3754, -15948},
    {3752, -15949},   {3750, -15949},   {3749, -15949},   {3747, -15950},   {3746, -15950},   {3744, -15950},
    {3743, -15951},   {3741, -15951},   {3740, -15951},   {3738, -15952},   {3737, -15952},   {3735, -15953},
    {3734, -15953},   {3732, -15953},   {3731, -15954},   {3729, -15954},   {3728, -15954},   {3726, -15955},
    {3724, -15955},   {3723, -15955},   {3721, -15956},   {3720, -15956},   {3718, -15956},   {3717, -15957},
    {3715, -15957},   {3714, -15958},   {3712, -15958},   {3711, -15958},   {3709, -15959},   {3708, -15959},
    {3706, -15959},   {3705, -15960},   {3703, -15960},   {3702, -15960},   {3700, -15961},   {3698, -15961},
    {3697, -15961},   {3695, -15962},   {3694, -15962},   {3692, -15963},   {3691, -15963},   {3689, -15963},
    {3688, -15964},   {3686, -15964},   {3685, -15964},   {3683, -15965},   {3682, -15965},   {3680, -15965},
    {3679, -15966},   {3677, -15966},   {3676, -15966},   {3674, -15967},   {3672, -15967},   {3671, -15967},
    {3669, -15968},   {3668, -15968},   {3666, -15969},   {3665, -15969},   {3663, -15969},   {3662, -15970},
    {3660, -15970},   {3659, -15970},   {3657, -15971},   {3656, -15971},   {3654, -15971},   {3653, -15972},
    {3651, -15972},   {3650, -15972},   {3648, -15973},   {3646, -15973},   {3645, -15973},   {3643, -15974},
    {3642, -15974},   {3640, -15974},   {3639, -15975},   {3637, -15975},   {3636, -15976},   {3634, -15976},
    {3633, -15976},   {3631, -15977},   {3630, -15977},   {3628, -15977},   {3627, -15978},   {3625, -15978},
    {3623, -15978},   {3622, -15979},   {3620, -15979},   {3619, -15979},   {3617, -15980},   {3616, -15980},
    {3614, -15980},   {3613, -15981},   {3611, -15981},   {3610, -15981},   {3608, -15982},   {3607, -15982},
    {3605, -15982},   {3604, -15983},   {3602, -15983},   {3600, -15983},   {3599, -15984},   {3597, -15984},
    {3596, -15985},   {3594, -15985},   {3593, -15985},   {3591, -15986},   {3590, -15986},   {3588, -15986},
    {3587, -15987},   {3585, -15987},   {3584, -15987},   {3582, -15988},   {3581, -15988},   {3579, -15988},
    {3577, -15989},   {3576, -15989},   {3574, -15989},   {3573, -15990},   {3571, -15990},   {3570, -15990},
    {3568, -15991},   {3567, -15991},   {3565, -15991},   {3564, -15992},   {3562, -15992},   {3561, -15992},
    {3559, -15993},   {3558, -15993},   {3556, -15993},   {3554, -15994},   {3553, -15994},   {3551, -15994},
    {3550, -15995},   {3548, -15995},   {3547, -15995},   {3545, -15996},   {3544, -15996},   {3542, -15997},
    {3541, -15997},   {3539, -15997},   {3538, -15998},   {3536, -15998},   {3535, -15998},   {3533, -15999},
    {3531, -15999},   {3530, -15999},   {3528, -16000},   {3527, -16000},   {3525, -16000},   {3524, -16001},
    {3522, -16001},   {3521, -16001},   {3519, -16002},   {3518, -16002},   {3516, -16002},   {3515, -16003},
    {3513, -16003},   {3512, -16003},   {3510, -16004},   {3508, -16004},   {3507, -16004},   {3505, -16005},
    {3504, -16005},   {3502, -16005},   {3501, -16006},   {3499, -16006},   {3498, -16006},   {3496, -16007},
    {3495, -16007},   {3493, -16007},   {3492, -16008},   {3490, -16008},   {3489, -16008},   {3487, -16009},
    {3485, -16009},   {3484, -16009},   {3482, -16010},   {3481, -16010},   {3479, -16010},   {3478, -16011},
    {3476, -16011},   {3475, -16011},   {3473, -16012},   {3472, -16012},   {3470, -16012},   {3469, -16013},
    {3467, -16013},   {3466, -16013},   {3464, -16014},   {3462, -16014},   {3461, -16014},   {3459, -16015},
    {3458, -16015},   {3456, -16015},   {3455, -16016},   {3453, -16016},   {3452, -16016},   {3450, -16017},
    {3449, -16017},   {3447, -16017},   {3446, -16018},   {3444, -16018},   {3442, -16018},   {3441, -16019},
    {3439, -16019},   {3438, -16019},   {3436, -16020},   {3435, -16020},   {3433, -16020},   {3432, -16021},
    {3430, -16021},   {3429, -16021},   {3427, -16022},   {3426, -16022},   {3424, -16022},   {3423, -16023},
    {3421, -16023},   {3419, -16023},   {3418, -16024},   {3416, -16024},   {3415, -16024},   {3413, -16025},
    {3412, -16025},   {3410, -16025},   {3409, -16025},   {3407, -16026},   {3406, -16026},   {3404, -16026},
    {3403, -16027},   {3401, -16027},   {3399, -16027},   {3398, -16028},   {3396, -16028},   {3395, -16028},
    {3393, -16029},   {3392, -16029},   {3390, -16029},   {3389, -16030},   {3387, -16030},   {3386, -16030},
    {3384, -16031},   {3383, -16031},   {3381, -16031},   {3379, -16032},   {3378, -16032},   {3376, -16032},
    {3375, -16033},   {3373, -16033},   {3372, -16033},   {3370, -16034},   {3369, -16034},   {3367, -16034},
    {3366, -16035},   {3364, -16035},   {3363, -16035},   {3361, -16036},   {3359, -16036},   {3358, -16036},
    {3356, -16037},   {3355, -16037},   {3353, -16037},   {3352, -16037},   {3350, -16038},   {3349, -16038},
    {3347, -16038},   {3346, -16039},   {3344, -16039},   {3343, -16039},   {3341, -16040},   {3340, -16040},
    {3338, -16040},   {3336, -16041},   {3335, -16041},   {3333, -16041},   {3332, -16042},   {3330, -16042},
    {3329, -16042},   {3327, -16043},   {3326, -16043},   {3324, -16043},   {3323, -16044},   {3321, -16044},
    {3320, -16044},   {3318, -16045},   {3316, -16045},   {3315, -16045},   {3313, -16045},   {3312, -16046},
    {3310, -16046},   {3309, -16046},   {3307, -16047},   {3306, -16047},   {3304, -16047},   {3303, -16048},
    {3301, -16048},   {3300, -16048},   {3298, -16049},   {3296, -16049},   {3295, -16049},   {3293, -16050},
    {3292, -16050},   {3290, -16050},   {3289, -16051},   {3287, -16051},   {3286, -16051},   {3284, -16051},
    {3283, -16052},   {3281, -16052},   {3280, -16052},   {3278, -16053},   {3276, -16053},   {3275, -16053},
    {3273, -16054},   {3272, -16054},   {3270, -16054},   {3269, -16055},   {3267, -16055},   {3266, -16055},
    {3264, -16056},   {3263, -16056},   {3261, -16056},   {3260, -16056},   {3258, -16057},   {3256, -16057},
    {3255, -16057},   {3253, -16058},   {3252, -16058},   {3250, -16058},   {3249, -16059},   {3247, -16059},
    {3246, -16059},   {3244, -16060},   {3243, -16060},   {3241, -16060},   {3239, -16061},   {3238, -16061},
    {3236, -16061},   {3235, -16061},   {3233, -16062},   {3232, -16062},   {3230, -16062},   {3229, -16063},
    {3227, -16063},   {3226, -16063},   {3224, -16064},   {3223, -16064},   {3221, -16064},   {3219, -16065},
    {3218, -16065},   {3216, -16065},   {3215, -16065},   {3213, -16066},   {3212, -16066},   {3210, -16066},
    {3209, -16067},   {3207, -16067},   {3206, -16067},   {3204, -16068},   {3203, -16068},   {3201, -16068},
    {3199, -16069},   {3198, -16069},   {3196, -16069},   {3195, -16069},   {3193, -16070},   {3192, -16070},
    {3190, -16070},   {3189, -16071},   {3187, -16071},   {3186, -16071},   {3184, -16072},   {3182, -16072},
    {3181, -16072},   {3179, -16073},   {3178, -16073},   {3176, -16073},   {3175, -16073},   {3173, -16074},
    {3172, -16074},   {3170, -16074},   {3169, -16075},   {3167, -16075},   {3166, -16075},   {3164, -16076},
    {3162, -16076},   {3161, -16076},   {3159, -16076},   {3158, -16077},   {3156, -16077},   {3155, -16077},
    {3153, -16078},   {3152, -16078},   {3150, -16078},   {3149, -16079},   {3147, -16079},   {3146, -16079},
    {3144, -16080},   {3142, -16080},   {3141, -16080},   {3139, -16080},   {3138, -16081},   {3136, -16081},
    {3135, -16081},   {3133, -16082},   {3132, -16082},   {3130, -16082},   {3129, -16083},   {3127, -16083},
    {3125, -16083},   {3124, -16083},   {3122, -16084},   {3121, -16084},   {3119, -16084},   {3118, -16085},
    {3116, -16085},   {3115, -16085},   {3113, -16086},   {3112, -16086},   {3110, -16086},   {3108, -16086},
    {3107, -16087},   {3105, -16087},   {3104, -16087},   {3102, -16088},   {3101, -16088},   {3099, -16088},
    {3098, -16088},   {3096, -16089},   {3095, -16089},   {3093, -16089},   {3092, -16090},   {3090, -16090},
    {3088, -16090},   {3087, -16091},   {3085, -16091},   {3084, -16091},   {3082, -16091},   {3081, -16092},
    {3079, -16092},   {3078, -16092},   {3076, -16093},   {3075, -16093},   {3073, -16093},   {3071, -16094},
    {3070, -16094},   {3068, -16094},   {3067, -16094},   {3065, -16095},   {3064, -16095},   {3062, -16095},
    {3061, -16096},   {3059, -16096},   {3058, -16096},   {3056, -16096},   {3055, -16097},   {3053, -16097},
    {3051, -16097},   {3050, -16098},   {3048, -16098},   {3047, -16098},   {3045, -16099},   {3044, -16099},
    {3042, -16099},   {3041, -16099},   {3039, -16100},   {3038, -16100},   {3036, -16100},   {3034, -16101},
    {3033, -16101},   {3031, -16101},   {3030, -16101},   {3028, -16102},   {3027, -16102},   {3025, -16102},
    {3024, -16103},   {3022, -16103},   {3021, -16103},   {3019, -16103},   {3017, -16104},   {3016, -16104},
    {3014, -16104},   {3013, -16105},   {3011, -16105},   {3010, -16105},   {3008, -16105},   {3007, -16106},
    {3005, -16106},   {3004, -16106},   {3002, -16107},   {3000, -16107},   {2999, -16107},   {2997, -16107},
    {2996, -16108},   {2994, -16108},   {2993, -16108},   {2991, -16109},   {2990, -16109},   {2988, -16109},
    {2987, -16109},   {2985, -16110},   {2983, -16110},   {2982, -16110},   {2980, -16111},   {2979, -16111},
    {2977, -16111},   {2976, -16111},   {2974, -16112},   {2973, -16112},   {2971, -16112},   {2970, -16113},
    {2968, -16113},   {2966, -16113},   {2965, -16113},   {2963, -16114},   {2962, -16114},   {2960, -16114},
    {2959, -16115},   {2957, -16115},   {2956, -16115},   {2954, -16115},   {2953, -16116},   {2951, -16116},
    {2949, -16116},   {2948, -16117},   {2946, -16117},   {2945, -16117},   {2943, -16117},   {2942, -16118},
    {2940, -16118},   {2939, -16118},   {2937, -16119},   {2936, -16119},   {2934, -16119},   {2932, -16119},
    {2931, -16120},   {2929, -16120},   {2928, -16120},   {2926, -16121},   {2925, -16121},   {2923, -16121},
    {2922, -16121},   {2920, -16122},   {2919, -16122},   {2917, -16122},   {2915, -16123},   {2914, -16123},
    {2912, -16123},   {2911, -16123},   {2909, -16124},   {2908, -16124},   {2906, -16124},   {2905, -16124},
    {2903, -16125},   {2902, -16125},   {2900, -16125},   {2898, -16126},   {2897, -16126},   {2895, -16126},
    {2894, -16126},   {2892, -16127},   {2891, -16127},   {2889, -16127},   {2888, -16128},   {2886, -16128},
    {2885, -16128},   {2883, -16128},   {2881, -16129},   {2880, -16129},   {2878, -16129},   {2877, -16129},
    {2875, -16130},   {2874, -16130},   {2872, -16130},   {2871, -16131},   {2869, -16131},   {2868, -16131},
    {2866, -16131},   {2864, -16132},   {2863, -16132},   {2861, -16132},   {2860, -16132},   {2858, -16133},
    {2857, -16133},   {2855, -16133},   {2854, -16134},   {2852, -16134},   {2851, -16134},   {2849, -16134},
    {2847, -16135},   {2846, -16135},   {2844, -16135},   {2843, -16135},   {2841, -16136},   {2840, -16136},
    {2838, -16136},   {2837, -16137},   {2835, -16137},   {2834, -16137},   {2832, -16137},   {2830, -16138},
    {2829, -16138},   {2827, -16138},   {2826, -16138},   {2824, -16139},   {2823, -16139},   {2821, -16139},
    {2820, -16140},   {2818, -16140},   {2817, -16140},   {2815, -16140},   {2813, -16141},   {2812, -16141},
    {2810, -16141},   {2809, -16141},   {2807, -16142},   {2806, -16142},   {2804, -16142},   {2803, -16143},
    {2801, -16143},   {2799, -16143},   {2798, -16143},   {2796, -16144},   {2795, -16144},   {2793, -16144},
    {2792, -16144},   {2790, -16145},   {2789, -16145},   {2787, -16145},   {2786, -16145},   {2784, -16146},
    {2782, -16146},   {2781, -16146},   {2779, -16147},   {2778, -16147},   {2776, -16147},   {2775, -16147},
    {2773, -16148},   {2772, -16148},   {2770, -16148},   {2769, -16148},   {2767, -16149},   {2765, -16149},
    {2764, -16149},   {2762, -16149},   {2761, -16150},   {2759, -16150},   {2758, -16150},   {2756, -16151},
    {2755, -16151},   {2753, -16151},   {2752, -16151},   {2750, -16152},   {2748, -16152},   {2747, -16152},
    {2745, -16152},   {2744, -16153},   {2742, -16153},   {2741, -16153},   {2739, -16153},   {2738, -16154},
    {2736, -16154},   {2734, -16154},   {2733, -16154},   {2731, -16155},   {2730, -16155},   {2728, -16155},
    {2727, -16156},   {2725, -16156},   {2724, -16156},   {2722, -16156},   {2721, -16157},   {2719, -16157},
    {2717, -16157},   {2716, -16157},   {2714, -16158},   {2713, -16158},   {2711, -16158},   {2710, -16158},
    {2708, -16159},   {2707, -16159},   {2705, -16159},   {2703, -16159},   {2702, -16160},   {2700, -16160},
    {2699, -16160},   {2697, -16160},   {2696, -16161},   {2694, -16161},   {2693, -16161},   {2691, -16161},
    {2690, -16162},   {2688, -16162},   {2686, -16162},   {2685, -16163},   {2683, -16163},   {2682, -16163},
    {2680, -16163},   {2679, -16164},   {2677, -16164},   {2676, -16164},   {2674, -16164},   {2672, -16165},
    {2671, -16165},   {2669, -16165},   {2668, -16165},   {2666, -16166},   {2665, -16166},   {2663, -16166},
    {2662, -16166},   {2660, -16167},   {2659, -16167},   {2657, -16167},   {2655, -16167},   {2654, -16168},
    {2652, -16168},   {2651, -16168},   {2649, -16168},   {2648, -16169},   {2646, -16169},   {2645, -16169},
    {2643, -16169},   {2641, -16170},   {2640, -16170},   {2638, -16170},   {2637, -16170},   {2635, -16171},
    {2634, -16171},   {2632, -16171},   {2631, -16171},   {2629, -16172},   {2628, -16172},   {2626, -16172},
    {2624, -16172},   {2623, -16173},   {2621, -16173},   {2620, -16173},   {2618, -16173},   {2617, -16174},
    {2615, -16174},   {2614, -16174},   {2612, -16174},   {2610, -16175},   {2609, -16175},   {2607, -16175},
    {2606, -16175},   {2604, -16176},   {2603, -16176},   {2601, -16176},   {2600, -16176},   {2598, -16177},
    {2597, -16177},   {2595, -16177},   {2593, -16177},   {2592, -16178},   {2590, -16178},   {2589, -16178},
    {2587, -16178},   {2586, -16179},   {2584, -16179},   {2583, -16179},   {2581, -16179},   {2579, -16180},
    {2578, -16180},   {2576, -16180},   {2575, -16180},   {2573, -16181},   {2572, -16181},   {2570, -16181},
    {2569, -16181},   {2567, -16182},   {2566, -16182},   {2564, -16182},   {2562, -16182},   {2561, -16183},
    {2559, -16183},   {2558, -16183},   {2556, -16183},   {2555, -16184},   {2553, -16184},   {2552, -16184},
    {2550, -16184},   {2548, -16185},   {2547, -16185},   {2545, -16185},   {2544, -16185},   {2542, -16186},
    {2541, -16186},   {2539, -16186},   {2538, -16186},   {2536, -16187},   {2534, -16187},   {2533, -16187},
    {2531, -16187},   {2530, -16188},   {2528, -16188},   {2527, -16188},   {2525, -16188},   {2524, -16188},
    {2522, -16189},   {2521, -16189},   {2519, -16189},   {2517, -16189},   {2516, -16190},   {2514, -16190},
    {2513, -16190},   {2511, -16190},   {2510, -16191},   {2508, -16191},   {2507, -16191},   {2505, -16191},
    {2503, -16192},   {2502, -16192},   {2500, -16192},   {2499, -16192},   {2497, -16193},   {2496, -16193},
    {2494, -16193},   {2493, -16193},   {2491, -16194},   {2489, -16194},   {2488, -16194},   {2486, -16194},
    {2485, -16194},   {2483, -16195},   {2482, -16195},   {2480, -16195},   {2479, -16195},   {2477, -16196},
    {2475, -16196},   {2474, -16196},   {2472, -16196},   {2471, -16197},   {2469, -16197},   {2468, -16197},
    {2466, -16197},   {2465, -16198},   {2463, -16198},   {2462, -16198},   {2460, -16198},   {2458, -16199},
    {2457, -16199},   {2455, -16199},   {2454, -16199},   {2452, -16199},   {2451, -16200},   {2449, -16200},
    {2448, -16200},   {2446, -16200},   {2444, -16201},   {2443, -16201},   {2441, -16201},   {2440, -16201},
    {2438, -16202},   {2437, -16202},   {2435, -16202},   {2434, -16202},   {2432, -16202},   {2430, -16203},
    {2429, -16203},   {2427, -16203},   {2426, -16203},   {2424, -16204},   {2423, -16204},   {2421, -16204},
    {2420, -16204},   {2418, -16205},   {2416, -16205},   {2415, -16205},   {2413, -16205},   {2412, -16206},
    {2410, -16206},   {2409, -16206},   {2407, -16206},   {2406, -16206},   {2404, -16207},   {2402, -16207},
    {2401, -16207},   {2399, -16207},   {2398, -16208},   {2396, -16208},   {2395, -16208},   {2393, -16208},
    {2392, -16209},   {2390, -16209},   {2388, -16209},   {2387, -16209},   {2385, -16209},   {2384, -16210},
    {2382, -16210},   {2381, -16210},   {2379, -16210},   {2378, -16211},   {2376, -16211},   {2375, -16211},
    {2373, -16211},   {2371, -16211},   {2370, -16212},   {2368, -16212},   {2367, -16212},   {2365, -16212},
    {2364, -16213},   {2362, -16213},   {2361, -16213},   {2359, -16213},   {2357, -16214},   {2356, -16214},
    {2354, -16214},   {2353, -16214},   {2351, -16214},   {2350, -16215},   {2348, -16215},   {2347, -16215},
    {2345, -16215},   {2343, -16216},   {2342, -16216},   {2340, -16216},   {2339, -16216},   {2337, -16216},
    {2336, -16217},   {2334, -16217},   {2333, -16217},   {2331, -16217},   {2329, -16218},   {2328, -16218},
    {2326, -16218},   {2325, -16218},   {2323, -16218},   {2322, -16219},   {2320, -16219},   {2319, -16219},
    {2317, -16219},   {2315, -16220},   {2314, -16220},   {2312, -16220},   {2311, -16220},   {2309, -16220},
    {2308, -16221},   {2306, -16221},   {2305, -16221},   {2303, -16221},   {2301, -16222},   {2300, -16222},
    {2298, -16222},   {2297, -16222},   {2295, -16222},   {2294, -16223},   {2292, -16223},   {2291, -16223},
    {2289, -16223},   {2287, -16224},   {2286, -16224},   {2284, -16224},   {2283, -16224},   {2281, -16224},
    {2280, -16225},   {2278, -16225},   {2277, -16225},   {2275, -16225},   {2273, -16226},   {2272, -16226},
    {2270, -16226},   {2269, -16226},   {2267, -16226},   {2266, -16227},   {2264, -16227},   {2263, -16227},
    {2261, -16227},   {2259, -16227},   {2258, -16228},   {2256, -16228},   {2255, -16228},   {2253, -16228},
    {2252, -16229},   {2250, -16229},   {2249, -16229},   {2247, -16229},   {2245, -16229},   {2244, -16230},
    {2242, -16230},   {2241, -16230},   {2239, -16230},   {2238, -16230},   {2236, -16231},   {2235, -16231},
    {2233, -16231},   {2231, -16231},   {2230, -16232},   {2228, -16232},   {2227, -16232},   {2225, -16232},
    {2224, -16232},   {2222, -16233},   {2221, -16233},   {2219, -16233},   {2217, -16233},   {2216, -16233},
    {2214, -16234},   {2213, -16234},   {2211, -16234},   {2210, -16234},   {2208, -16235},   {2207, -16235},
    {2205, -16235},   {2203, -16235},   {2202, -16235},   {2200, -16236},   {2199, -16236},   {2197, -16236},
    {2196, -16236},   {2194, -16236},   {2193, -16237},   {2191, -16237},   {2189, -16237},   {2188, -16237},
    {2186, -16237},   {2185, -16238},   {2183, -16238},   {2182, -16238},   {2180, -16238},   {2179, -16239},
    {2177, -16239},   {2175, -16239},   {2174, -16239},   {2172, -16239},   {2171, -16240},   {2169, -16240},
    {2168, -16240},   {2166, -16240},   {2164, -16240},   {2163, -16241},   {2161, -16241},   {2160, -16241},
    {2158, -16241},   {2157, -16241},   {2155, -16242},   {2154, -16242},   {2152, -16242},   {2150, -16242},
    {2149, -16242},   {2147, -16243},   {2146, -16243},   {2144, -16243},   {2143, -16243},   {2141, -16243},
    {2140, -16244},   {2138, -16244},   {2136, -16244},   {2135, -16244},   {2133, -16245},   {2132, -16245},
    {2130, -16245},   {2129, -16245},   {2127, -16245},   {2126, -16246},   {2124, -16246},   {2122, -16246},
    {2121, -16246},   {2119, -16246},   {2118, -16247},   {2116, -16247},   {2115, -16247},   {2113, -16247},
    {2112, -16247},   {2110, -16248},   {2108, -16248},   {2107, -16248},   {2105, -16248},   {2104, -16248},
    {2102, -16249},   {2101, -16249},   {2099, -16249},   {2098, -16249},   {2096, -16249},   {2094, -16250},
    {2093, -16250},   {2091, -16250},   {2090, -16250},   {2088, -16250},   {2087, -16251},   {2085, -16251},
    {2084, -16251},   {2082, -16251},   {2080, -16251},   {2079, -16252},   {2077, -16252},   {2076, -16252},
    {2074, -16252},   {2073, -16252},   {2071, -16253},   {2069, -16253},   {2068, -16253},   {2066, -16253},
    {2065, -16253},   {2063, -16254},   {2062, -16254},   {2060, -16254},   {2059, -16254},   {2057, -16254},
    {2055, -16255},   {2054, -16255},   {2052, -16255},   {2051, -16255},   {2049, -16255},   {2048, -16256},
    {2046, -16256},   {2045, -16256},   {2043, -16256},   {2041, -16256},   {2040, -16257},   {2038, -16257},
    {2037, -16257},   {2035, -16257},   {2034, -16257},   {2032, -16257},   {2031, -16258},   {2029, -16258},
    {2027, -16258},   {2026, -16258},   {2024, -16258},   {2023, -16259},   {2021, -16259},   {2020, -16259},
    {2018, -16259},   {2016, -16259},   {2015, -16260},   {2013, -16260},   {2012, -16260},   {2010, -16260},
    {2009, -16260},   {2007, -16261},   {2006, -16261},   {2004, -16261},   {2002, -16261},   {2001, -16261},
    {1999, -16262},   {1998, -16262},   {1996, -16262},   {1995, -16262},   {1993, -16262},   {1992, -16263},
    {1990, -16263},   {1988, -16263},   {1987, -16263},   {1985, -16263},   {1984, -16263},   {1982, -16264},
    {1981, -16264},   {1979, -16264},   {1978, -16264},   {1976, -16264},   {1974, -16265},   {1973, -16265},
    {1971, -16265},   {1970, -16265},   {1968, -16265},   {1967, -16266},   {1965, -16266},   {1963, -16266},
    {1962, -16266},   {1960, -16266},   {1959, -16266},   {1957, -16267},   {1956, -16267},   {1954, -16267},
    {1953, -16267},   {1951, -16267},   {1949, -16268},   {1948, -16268},   {1946, -16268},   {1945, -16268},
    {1943, -16268},   {1942, -16269},   {1940, -16269},   {1939, -16269},   {1937, -16269},   {1935, -16269},
    {1934, -16269},   {1932, -16270},   {1931, -16270},   {1929, -16270},   {1928, -16270},   {1926, -16270},
    {1924, -16271},   {1923, -16271},   {1921, -16271},   {1920, -16271},   {1918, -16271},   {1917, -16272},
    {1915, -16272},   {1914, -16272},   {1912, -16272},   {1910, -16272},   {1909, -16272},   {1907, -16273},
    {1906, -16273},   {1904, -16273},   {1903, -16273},   {1901, -16273},   {1900, -16274},   {1898, -16274},
    {1896, -16274},   {1895, -16274},   {1893, -16274},   {1892, -16274},   {1890, -16275},   {1889, -16275},
    {1887, -16275},   {1885, -16275},   {1884, -16275},   {1882, -16276},   {1881, -16276},   {1879, -16276},
    {1878, -16276},   {1876, -16276},   {1875, -16276},   {1873, -16277},   {1871, -16277},   {1870, -16277},
    {1868, -16277},   {1867, -16277},   {1865, -16277},   {1864, -16278},   {1862, -16278},   {1861, -16278},
    {1859, -16278},   {1857, -16278},   {1856, -16279},   {1854, -16279},   {1853, -16279},   {1851, -16279},
    {1850, -16279},   {1848, -16279},   {1846, -16280},   {1845, -16280},   {1843, -16280},   {1842, -16280},
    {1840, -16280},   {1839, -16281},   {1837, -16281},   {1836, -16281},   {1834, -16281},   {1832, -16281},
    {1831, -16281},   {1829, -16282},   {1828, -16282},   {1826, -16282},   {1825, -16282},   {1823, -16282},
    {1821, -16282},   {1820, -16283},   {1818, -16283},   {1817, -16283},   {1815, -16283},   {1814, -16283},
    {1812, -16283},   {1811, -16284},   {1809, -16284},   {1807, -16284},   {1806, -16284},   {1804, -16284},
    {1803, -16285},   {1801, -16285},   {1800, -16285},   {1798, -16285},   {1797, -16285},   {1795, -16285},
    {1793, -16286},   {1792, -16286},   {1790, -16286},   {1789, -16286},   {1787, -16286},   {1786, -16286},
    {1784, -16287},   {1782, -16287},   {1781, -16287},   {1779, -16287},   {1778, -16287},   {1776, -16287},
    {1775, -16288},   {1773, -16288},   {1772, -16288},   {1770, -16288},   {1768, -16288},   {1767, -16288},
    {1765, -16289},   {1764, -16289},   {1762, -16289},   {1761, -16289},   {1759, -16289},   {1757, -16289},
    {1756, -16290},   {1754, -16290},   {1753, -16290},   {1751, -16290},   {1750, -16290},   {1748, -16290},
    {1747, -16291},   {1745, -16291},   {1743, -16291},   {1742, -16291},   {1740, -16291},   {1739, -16291},
    {1737, -16292},   {1736, -16292},   {1734, -16292},   {1732, -16292},   {1731, -16292},   {1729, -16292},
    {1728, -16293},   {1726, -16293},   {1725, -16293},   {1723, -16293},   {1722, -16293},   {1720, -16293},
    {1718, -16294},   {1717, -16294},   {1715, -16294},   {1714, -16294},   {1712, -16294},   {1711, -16294},
    {1709, -16295},   {1707, -16295},   {1706, -16295},   {1704, -16295},   {1703, -16295},   {1701, -16295},
    {1700, -16296},   {1698, -16296},   {1697, -16296},   {1695, -16296},   {1693, -16296},   {1692, -16296},
    {1690, -16297},   {1689, -16297},   {1687, -16297},   {1686, -16297},   {1684, -16297},   {1682, -16297},
    {1681, -16298},   {1679, -16298},   {1678, -16298},   {1676, -16298},   {1675, -16298},   {1673, -16298},
    {1672, -16299},   {1670, -16299},   {1668, -16299},   {1667, -16299},   {1665, -16299},   {1664, -16299},
    {1662, -16299},   {1661, -16300},   {1659, -16300},   {1657, -16300},   {1656, -16300},   {1654, -16300},
    {1653, -16300},   {1651, -16301},   {1650, -16301},   {1648, -16301},   {1647, -16301},   {1645, -16301},
    {1643, -16301},   {1642, -16302},   {1640, -16302},   {1639, -16302},   {1637, -16302},   {1636, -16302},
    {1634, -16302},   {1632, -16302},   {1631, -16303},   {1629, -16303},   {1628, -16303},   {1626, -16303},
    {1625, -16303},   {1623, -16303},   {1622, -16304},   {1620, -16304},   {1618, -16304},   {1617, -16304},
    {1615, -16304},   {1614, -16304},   {1612, -16304},   {1611, -16305},   {1609, -16305},   {1607, -16305},
    {1606, -16305},   {1604, -16305},   {1603, -16305},   {1601, -16306},   {1600, -16306},   {1598, -16306},
    {1597, -16306},   {1595, -16306},   {1593, -16306},   {1592, -16306},   {1590, -16307},   {1589, -16307},
    {1587, -16307},   {1586, -16307},   {1584, -16307},   {1582, -16307},   {1581, -16308},   {1579, -16308},
    {1578, -16308},   {1576, -16308},   {1575, -16308},   {1573, -16308},   {1572, -16308},   {1570, -16309},
    {1568, -16309},   {1567, -16309},   {1565, -16309},   {1564, -16309},   {1562, -16309},   {1561, -16310},
    {1559, -16310},   {1557, -16310},   {1556, -16310},   {1554, -16310},   {1553, -16310},   {1551, -16310},
    {1550, -16311},   {1548, -16311},   {1546, -16311},   {1545, -16311},   {1543, -16311},   {1542, -16311},
    {1540, -16311},   {1539, -16312},   {1537, -16312},   {1536, -16312},   {1534, -16312},   {1532, -16312},
    {1531, -16312},   {1529, -16312},   {1528, -16313},   {1526, -16313},   {1525, -16313},   {1523, -16313},
    {1521, -16313},   {1520, -16313},   {1518, -16313},   {1517, -16314},   {1515, -16314},   {1514, -16314},
    {1512, -16314},   {1511, -16314},   {1509, -16314},   {1507, -16315},   {1506, -16315},   {1504, -16315},
    {1503, -16315},   {1501, -16315},   {1500, -16315},   {1498, -16315},   {1496, -16316},   {1495, -16316},
    {1493, -16316},   {1492, -16316},   {1490, -16316},   {1489, -16316},   {1487, -16316},   {1486, -16317},
    {1484, -16317},   {1482, -16317},   {1481, -16317},   {1479, -16317},   {1478, -16317},   {1476, -16317},
    {1475, -16318},   {1473, -16318},   {1471, -16318},   {1470, -16318},   {1468, -16318},   {1467, -16318},
    {1465, -16318},   {1464, -16318},   {1462, -16319},   {1460, -16319},   {1459, -16319},   {1457, -16319},
    {1456, -16319},   {1454, -16319},   {1453, -16319},   {1451, -16320},   {1450, -16320},   {1448, -16320},
    {1446, -16320},   {1445, -16320},   {1443, -16320},   {1442, -16320},   {1440, -16321},   {1439, -16321},
    {1437, -16321},   {1435, -16321},   {1434, -16321},   {1432, -16321},   {1431, -16321},   {1429, -16322},
    {1428, -16322},   {1426, -16322},   {1424, -16322},   {1423, -16322},   {1421, -16322},   {1420, -16322},
    {1418, -16323},   {1417, -16323},   {1415, -16323},   {1414, -16323},   {1412, -16323},   {1410, -16323},
    {1409, -16323},   {1407, -16323},   {1406, -16324},   {1404, -16324},   {1403, -16324},   {1401, -16324},
    {1399, -16324},   {1398, -16324},   {1396, -16324},   {1395, -16325},   {1393, -16325},   {1392, -16325},
    {1390, -16325},   {1388, -16325},   {1387, -16325},   {1385, -16325},   {1384, -16325},   {1382, -16326},
    {1381, -16326},   {1379, -16326},   {1378, -16326},   {1376, -16326},   {1374, -16326},   {1373, -16326},
    {1371, -16327},   {1370, -16327},   {1368, -16327},   {1367, -16327},   {1365, -16327},   {1363, -16327},
    {1362, -16327},   {1360, -16327},   {1359, -16328},   {1357, -16328},   {1356, -16328},   {1354, -16328},
    {1352, -16328},   {1351, -16328},   {1349, -16328},   {1348, -16328},   {1346, -16329},   {1345, -16329},
    {1343, -16329},   {1342, -16329},   {1340, -16329},   {1338, -16329},   {1337, -16329},   {1335, -16329},
    {1334, -16330},   {1332, -16330},   {1331, -16330},   {1329, -16330},   {1327, -16330},   {1326, -16330},
    {1324, -16330},   {1323, -16331},   {1321, -16331},   {1320, -16331},   {1318, -16331},   {1316, -16331},
    {1315, -16331},   {1313, -16331},   {1312, -16331},   {1310, -16332},   {1309, -16332},   {1307, -16332},
    {1306, -16332},   {1304, -16332},   {1302, -16332},   {1301, -16332},   {1299, -16332},   {1298, -16333},
    {1296, -16333},   {1295, -16333},   {1293, -16333},   {1291, -16333},   {1290, -16333},   {1288, -16333},
    {1287, -16333},   {1285, -16334},   {1284, -16334},   {1282, -16334},   {1280, -16334},   {1279, -16334},
    {1277, -16334},   {1276, -16334},   {1274, -16334},   {1273, -16334},   {1271, -16335},   {1270, -16335},
    {1268, -16335},   {1266, -16335},   {1265, -16335},   {1263, -16335},   {1262, -16335},   {1260, -16335},
    {1259, -16336},   {1257, -16336},   {1255, -16336},   {1254, -16336},   {1252, -16336},   {1251, -16336},
    {1249, -16336},   {1248, -16336},   {1246, -16337},   {1244, -16337},   {1243, -16337},   {1241, -16337},
    {1240, -16337},   {1238, -16337},   {1237, -16337},   {1235, -16337},   {1233, -16338},   {1232, -16338},
    {1230, -16338},   {1229, -16338},   {1227, -16338},   {1226, -16338},   {1224, -16338},   {1223, -16338},
    {1221, -16338},   {1219, -16339},   {1218, -16339},   {1216, -16339},   {1215, -16339},   {1213, -16339},
    {1212, -16339},   {1210, -16339},   {1208, -16339},   {1207, -16339},   {1205, -16340},   {1204, -16340},
    {1202, -16340},   {1201, -16340},   {1199, -16340},   {1197, -16340},   {1196, -16340},   {1194, -16340},
    {1193, -16341},   {1191, -16341},   {1190, -16341},   {1188, -16341},   {1186, -16341},   {1185, -16341},
    {1183, -16341},   {1182, -16341},   {1180, -16341},   {1179, -16342},   {1177, -16342},   {1176, -16342},
    {1174, -16342},   {1172, -16342},   {1171, -16342},   {1169, -16342},   {1168, -16342},   {1166, -16342},
    {1165, -16343},   {1163, -16343},   {1161, -16343},   {1160, -16343},   {1158, -16343},   {1157, -16343},
    {1155, -16343},   {1154, -16343},   {1152, -16343},   {1150, -16344},   {1149, -16344},   {1147, -16344},
    {1146, -16344},   {1144, -16344},   {1143, -16344},   {1141, -16344},   {1139, -16344},   {1138, -16344},
    {1136, -16345},   {1135, -16345},   {1133, -16345},   {1132, -16345},   {1130, -16345},   {1129, -16345},
    {1127, -16345},   {1125, -16345},   {1124, -16345},   {1122, -16346},   {1121, -16346},   {1119, -16346},
    {1118, -16346},   {1116, -16346},   {1114, -16346},   {1113, -16346},   {1111, -16346},   {1110, -16346},
    {1108, -16346},   {1107, -16347},   {1105, -16347},   {1103, -16347},   {1102, -16347},   {1100, -16347},
    {1099, -16347},   {1097, -16347},   {1096, -16347},   {1094, -16347},   {1092, -16348},   {1091, -16348},
    {1089, -16348},   {1088, -16348},   {1086, -16348},   {1085, -16348},   {1083, -16348},   {1081, -16348},
    {1080, -16348},   {1078, -16348},   {1077, -16349},   {1075, -16349},   {1074, -16349},   {1072, -16349},
    {1071, -16349},   {1069, -16349},   {1067, -16349},   {1066, -16349},   {1064, -16349},   {1063, -16350},
    {1061, -16350},   {1060, -16350},   {1058, -16350},   {1056, -16350},   {1055, -16350},   {1053, -16350},
    {1052, -16350},   {1050, -16350},   {1049, -16350},   {1047, -16351},   {1045, -16351},   {1044, -16351},
    {1042, -16351},   {1041, -16351},   {1039, -16351},   {1038, -16351},   {1036, -16351},   {1034, -16351},
    {1033, -16351},   {1031, -16352},   {1030, -16352},   {1028, -16352},   {1027, -16352},   {1025, -16352},
    {1023, -16352},   {1022, -16352},   {1020, -16352},   {1019, -16352},   {1017, -16352},   {1016, -16352},
    {1014, -16353},   {1013, -16353},   {1011, -16353},   {1009, -16353},   {1008, -16353},   {1006, -16353},
    {1005, -16353},   {1003, -16353},   {1002, -16353},   {1000, -16353},   {998, -16354},    {997, -16354},
    {995, -16354},    {994, -16354},    {992, -16354},    {991, -16354},    {989, -16354},    {987, -16354},
    {986, -16354},    {984, -16354},    {983, -16355},    {981, -16355},    {980, -16355},    {978, -16355},
    {976, -16355},    {975, -16355},    {973, -16355},    {972, -16355},    {970, -16355},    {969, -16355},
    {967, -16355},    {965, -16356},    {964, -16356},    {962, -16356},    {961, -16356},    {959, -16356},
    {958, -16356},    {956, -16356},    {955, -16356},    {953, -16356},    {951, -16356},    {950, -16356},
    {948, -16357},    {947, -16357},    {945, -16357},    {944, -16357},    {942, -16357},    {940, -16357},
    {939, -16357},    {937, -16357},    {936, -16357},    {934, -16357},    {933, -16357},    {931, -16358},
    {929, -16358},    {928, -16358},    {926, -16358},    {925, -16358},    {923, -16358},    {922, -16358},
    {920, -16358},    {918, -16358},    {917, -16358},    {915, -16358},    {914, -16359},    {912, -16359},
    {911, -16359},    {909, -16359},    {907, -16359},    {906, -16359},    {904, -16359},    {903, -16359},
    {901, -16359},    {900, -16359},    {898, -16359},    {896, -16359},    {895, -16360},    {893, -16360},
    {892, -16360},    {890, -16360},    {889, -16360},    {887, -16360},    {885, -16360},    {884, -16360},
    {882, -16360},    {881, -16360},    {879, -16360},    {878, -16360},    {876, -16361},    {875, -16361},
    {873, -16361},    {871, -16361},    {870, -16361},    {868, -16361},    {867, -16361},    {865, -16361},
    {864, -16361},    {862, -16361},    {860, -16361},    {859, -16361},    {857, -16362},    {856, -16362},
    {854, -16362},    {853, -16362},    {851, -16362},    {849, -16362},    {848, -16362},    {846, -16362},
    {845, -16362},    {843, -16362},    {842, -16362},    {840, -16362},    {838, -16363},    {837, -16363},
    {835, -16363},    {834, -16363},    {832, -16363},    {831, -16363},    {829, -16363},    {827, -16363},
    {826, -16363},    {824, -16363},    {823, -16363},    {821, -16363},    {820, -16363},    {818, -16364},
    {816, -16364},    {815, -16364},    {813, -16364},    {812, -16364},    {810, -16364},    {809, -16364},
    {807, -16364},    {805, -16364},    {804, -16364},    {802, -16364},    {801, -16364},    {799, -16364},
    {798, -16365},    {796, -16365},    {795, -16365},    {793, -16365},    {791, -16365},    {790, -16365},
    {788, -16365},    {787, -16365},    {785, -16365},    {784, -16365},    {782, -16365},    {780, -16365},
    {779, -16365},    {777, -16366},    {776, -16366},    {774, -16366},    {773, -16366},    {771, -16366},
    {769, -16366},    {768, -16366},    {766, -16366},    {765, -16366},    {763, -16366},    {762, -16366},
    {760, -16366},    {758, -16366},    {757, -16367},    {755, -16367},    {754, -16367},    {752, -16367},
    {751, -16367},    {749, -16367},    {747, -16367},    {746, -16367},    {744, -16367},    {743, -16367},
    {741, -16367},    {740, -16367},    {738, -16367},    {736, -16367},    {735, -16368},    {733, -16368},
    {732, -16368},    {730, -16368},    {729, -16368},    {727, -16368},    {725, -16368},    {724, -16368},
    {722, -16368},    {721, -16368},    {719, -16368},    {718, -16368},    {716, -16368},    {714, -16368},
    {713, -16368},    {711, -16369},    {710, -16369},    {708, -16369},    {707, -16369},    {705, -16369},
    {704, -16369},    {702, -16369},    {700, -16369},    {699, -16369},    {697, -16369},    {696, -16369},
    {694, -16369},    {693, -16369},    {691, -16369},    {689, -16369},    {688, -16370},    {686, -16370},
    {685, -16370},    {683, -16370},    {682, -16370},    {680, -16370},    {678, -16370},    {677, -16370},
    {675, -16370},    {674, -16370},    {672, -16370},    {671, -16370},    {669, -16370},    {667, -16370},
    {666, -16370},    {664, -16371},    {663, -16371},    {661, -16371},    {660, -16371},    {658, -16371},
    {656, -16371},    {655, -16371},    {653, -16371},    {652, -16371},    {650, -16371},    {649, -16371},
    {647, -16371},    {645, -16371},    {644, -16371},    {642, -16371},    {641, -16371},    {639, -16372},
    {638, -16372},    {636, -16372},    {634, -16372},    {633, -16372},    {631, -16372},    {630, -16372},
    {628, -16372},    {627, -16372},    {625, -16372},    {623, -16372},    {622, -16372},    {620, -16372},
    {619, -16372},    {617, -16372},    {616, -16372},    {614, -16372},    {612, -16373},    {611, -16373},
    {609, -16373},    {608, -16373},    {606, -16373},    {605, -16373},    {603, -16373},    {601, -16373},
    {600, -16373},    {598, -16373},    {597, -16373},    {595, -16373},    {594, -16373},    {592, -16373},
    {590, -16373},    {589, -16373},    {587, -16373},    {586, -16374},    {584, -16374},    {583, -16374},
    {581, -16374},    {580, -16374},    {578, -16374},    {576, -16374},    {575, -16374},    {573, -16374},
    {572, -16374},    {570, -16374},    {569, -16374},    {567, -16374},    {565, -16374},    {564, -16374},
    {562, -16374},    {561, -16374},    {559, -16374},    {558, -16375},    {556, -16375},    {554, -16375},
    {553, -16375},    {551, -16375},    {550, -16375},    {548, -16375},    {547, -16375},    {545, -16375},
    {543, -16375},    {542, -16375},    {540, -16375},    {539, -16375},    {537, -16375},    {536, -16375},
    {534, -16375},    {532, -16375},    {531, -16375},    {529, -16375},    {528, -16375},    {526, -16376},
    {525, -16376},    {523, -16376},    {521, -16376},    {520, -16376},    {518, -16376},    {517, -16376},
    {515, -16376},    {514, -16376},    {512, -16376},    {510, -16376},    {509, -16376},    {507, -16376},
    {506, -16376},    {504, -16376},    {503, -16376},    {501, -16376},    {499, -16376},    {498, -16376},
    {496, -16376},    {495, -16377},    {493, -16377},    {492, -16377},    {490, -16377},    {488, -16377},
    {487, -16377},    {485, -16377},    {484, -16377},    {482, -16377},    {481, -16377},    {479, -16377},
    {477, -16377},    {476, -16377},    {474, -16377},    {473, -16377},    {471, -16377},    {470, -16377},
    {468, -16377},    {466, -16377},    {465, -16377},    {463, -16377},    {462, -16377},    {460, -16378},
    {459, -16378},    {457, -16378},    {455, -16378},    {454, -16378},    {452, -16378},    {451, -16378},
    {449, -16378},    {448, -16378},    {446, -16378},    {444, -16378},    {443, -16378},    {441, -16378},
    {440, -16378},    {438, -16378},    {437, -16378},    {435, -16378},    {433, -16378},    {432, -16378},
    {430, -16378},    {429, -16378},    {427, -16378},    {426, -16378},    {424, -16379},    {422, -16379},
    {421, -16379},    {419, -16379},    {418, -16379},    {416, -16379},    {415, -16379},    {413, -16379},
    {412, -16379},    {410, -16379},    {408, -16379},    {407, -16379},    {405, -16379},    {404, -16379},
    {402, -16379},    {401, -16379},    {399, -16379},    {397, -16379},    {396, -16379},    {394, -16379},
    {393, -16379},    {391, -16379},    {390, -16379},    {388, -16379},    {386, -16379},    {385, -16379},
    {383, -16380},    {382, -16380},    {380, -16380},    {379, -16380},    {377, -16380},    {375, -16380},
    {374, -16380},    {372, -16380},    {371, -16380},    {369, -16380},    {368, -16380},    {366, -16380},
    {364, -16380},    {363, -16380},    {361, -16380},    {360, -16380},    {358, -16380},    {357, -16380},
    {355, -16380},    {353, -16380},    {352, -16380},    {350, -16380},    {349, -16380},    {347, -16380},
    {346, -16380},    {344, -16380},    {342, -16380},    {341, -16380},    {339, -16380},    {338, -16381},
    {336, -16381},    {335, -16381},    {333, -16381},    {331, -16381},    {330, -16381},    {328, -16381},
    {327, -16381},    {325, -16381},    {324, -16381},    {322, -16381},    {320, -16381},    {319, -16381},
    {317, -16381},    {316, -16381},    {314, -16381},    {313, -16381},    {311, -16381},    {309, -16381},
    {308, -16381},    {306, -16381},    {305, -16381},    {303, -16381},    {302, -16381},    {300, -16381},
    {298, -16381},    {297, -16381},    {295, -16381},    {294, -16381},    {292, -16381},    {291, -16381},
    {289, -16381},    {287, -16381},    {286, -16382},    {284, -16382},    {283, -16382},    {281, -16382},
    {280, -16382},    {278, -16382},    {276, -16382},    {275, -16382},    {273, -16382},    {272, -16382},
    {270, -16382},    {269, -16382},    {267, -16382},    {265, -16382},    {264, -16382},    {262, -16382},
    {261, -16382},    {259, -16382},    {258, -16382},    {256, -16382},    {254, -16382},    {253, -16382},
    {251, -16382},    {250, -16382},    {248, -16382},    {247, -16382},    {245, -16382},    {243, -16382},
    {242, -16382},    {240, -16382},    {239, -16382},    {237, -16382},    {236, -16382},    {234, -16382},
    {232, -16382},    {231, -16382},    {229, -16382},    {228, -16382},    {226, -16382},    {225, -16382},
    {223, -16382},    {221, -16383},    {220, -16383},    {218, -16383},    {217, -16383},    {215, -16383},
    {214, -16383},    {212, -16383},    {210, -16383},    {209, -16383},    {207, -16383},    {206, -16383},
    {204, -16383},    {203, -16383},    {201, -16383},    {199, -16383},    {198, -16383},    {196, -16383},
    {195, -16383},    {193, -16383},    {192, -16383},    {190, -16383},    {188, -16383},    {187, -16383},
    {185, -16383},    {184, -16383},    {182, -16383},    {181, -16383},    {179, -16383},    {177, -16383},
    {176, -16383},    {174, -16383},    {173, -16383},    {171, -16383},    {170, -16383},    {168, -16383},
    {167, -16383},    {165, -16383},    {163, -16383},    {162, -16383},    {160, -16383},    {159, -16383},
    {157, -16383},    {156, -16383},    {154, -16383},    {152, -16383},    {151, -16383},    {149, -16383},
    {148, -16383},    {146, -16383},    {145, -16383},    {143, -16383},    {141, -16383},    {140, -16383},
    {138, -16383},    {137, -16383},    {135, -16383},    {134, -16383},    {132, -16383},    {130, -16383},
    {129, -16383},    {127, -16384},    {126, -16384},    {124, -16384},    {123, -16384},    {121, -16384},
    {119, -16384},    {118, -16384},    {116, -16384},    {115, -16384},    {113, -16384},    {112, -16384},
    {110, -16384},    {108, -16384},    {107, -16384},    {105, -16384},    {104, -16384},    {102, -16384},
    {101, -16384},    {99, -16384},     {97, -16384},     {96, -16384},     {94, -16384},     {93, -16384},
    {91, -16384},     {90, -16384},     {88, -16384},     {86, -16384},     {85, -16384},     {83, -16384},
    {82, -16384},     {80, -16384},     {79, -16384},     {77, -16384},     {75, -16384},     {74, -16384},
    {72, -16384},     {71, -16384},     {69, -16384},     {68, -16384},     {66, -16384},     {64, -16384},
    {63, -16384},     {61, -16384},     {60, -16384},     {58, -16384},     {57, -16384},     {55, -16384},
    {53, -16384},     {52, -16384},     {50, -16384},     {49, -16384},     {47, -16384},     {46, -16384},
    {44, -16384},     {42, -16384},     {41, -16384},     {39, -16384},     {38, -16384},     {36, -16384},
    {35, -16384},     {33, -16384},     {31, -16384},     {30, -16384},     {28, -16384},     {27, -16384},
    {25, -16384},     {24, -16384},     {22, -16384},     {20, -16384},     {19, -16384},     {17, -16384},
    {16, -16384},     {14, -16384},     {13, -16384},     {11, -16384},     {9, -16384},      {8, -16384},
    {6, -16384},      {5, -16384},      {3, -16384},      {2, -16384},      {0, -16384},      {-2, -16384},
    {-3, -16384},     {-5, -16384},     {-6, -16384},     {-8, -16384},     {-9, -16384},     {-11, -16384},
    {-13, -16384},    {-14, -16384},    {-16, -16384},    {-17, -16384},    {-19, -16384},    {-20, -16384},
    {-22, -16384},    {-24, -16384},    {-25, -16384},    {-27, -16384},    {-28, -16384},    {-30, -16384},
    {-31, -16384},    {-33, -16384},    {-35, -16384},    {-36, -16384},    {-38, -16384},    {-39, -16384},
    {-41, -16384},    {-42, -16384},    {-44, -16384},    {-46, -16384},    {-47, -16384},    {-49, -16384},
    {-50, -16384},    {-52, -16384},    {-53, -16384},    {-55, -16384},    {-57, -16384},    {-58, -16384},
    {-60, -16384},    {-61, -16384},    {-63, -16384},    {-64, -16384},    {-66, -16384},    {-68, -16384},
    {-69, -16384},    {-71, -16384},    {-72, -16384},    {-74, -16384},    {-75, -16384},    {-77, -16384},
    {-79, -16384},    {-80, -16384},    {-82, -16384},    {-83, -16384},    {-85, -16384},    {-86, -16384},
    {-88, -16384},    {-90, -16384},    {-91, -16384},    {-93, -16384},    {-94, -16384},    {-96, -16384},
    {-97, -16384},    {-99, -16384},    {-101, -16384},   {-102, -16384},   {-104, -16384},   {-105, -16384},
    {-107, -16384},   {-108, -16384},   {-110, -16384},   {-112, -16384},   {-113, -16384},   {-115, -16384},
    {-116, -16384},   {-118, -16384},   {-119, -16384},   {-121, -16384},   {-123, -16384},   {-124, -16384},
    {-126, -16384},   {-127, -16384},   {-129, -16383},   {-130, -16383},   {-132, -16383},   {-134, -16383},
    {-135, -16383},   {-137, -16383},   {-138, -16383},   {-140, -16383},   {-141, -16383},   {-143, -16383},
    {-145, -16383},   {-146, -16383},   {-148, -16383},   {-149, -16383},   {-151, -16383},   {-152, -16383},
    {-154, -16383},   {-156, -16383},   {-157, -16383},   {-159, -16383},   {-160, -16383},   {-162, -16383},
    {-163, -16383},   {-165, -16383},   {-167, -16383},   {-168, -16383},   {-170, -16383},   {-171, -16383},
    {-173, -16383},   {-174, -16383},   {-176, -16383},   {-177, -16383},   {-179, -16383},   {-181, -16383},
    {-182, -16383},   {-184, -16383},   {-185, -16383},   {-187, -16383},   {-188, -16383},   {-190, -16383},
    {-192, -16383},   {-193, -16383},   {-195, -16383},   {-196, -16383},   {-198, -16383},   {-199, -16383},
    {-201, -16383},   {-203, -16383},   {-204, -16383},   {-206, -16383},   {-207, -16383},   {-209, -16383},
    {-210, -16383},   {-212, -16383},   {-214, -16383},   {-215, -16383},   {-217, -16383},   {-218, -16383},
    {-220, -16383},   {-221, -16383},   {-223, -16382},   {-225, -16382},   {-226, -16382},   {-228, -16382},
    {-229, -16382},   {-231, -16382},   {-232, -16382},   {-234, -16382},   {-236, -16382},   {-237, -16382},
    {-239, -16382},   {-240, -16382},   {-242, -16382},   {-243, -16382},   {-245, -16382},   {-247, -16382},
    {-248, -16382},   {-250, -16382},   {-251, -16382},   {-253, -16382},   {-254, -16382},   {-256, -16382},
    {-258, -16382},   {-259, -16382},   {-261, -16382},   {-262, -16382},   {-264, -16382},   {-265, -16382},
    {-267, -16382},   {-269, -16382},   {-270, -16382},   {-272, -16382},   {-273, -16382},   {-275, -16382},
    {-276, -16382},   {-278, -16382},   {-280, -16382},   {-281, -16382},   {-283, -16382},   {-284, -16382},
    {-286, -16382},   {-287, -16381},   {-289, -16381},   {-291, -16381},   {-292, -16381},   {-294, -16381},
    {-295, -16381},   {-297, -16381},   {-298, -16381},   {-300, -16381},   {-302, -16381},   {-303, -16381},
    {-305, -16381},   {-306, -16381},   {-308, -16381},   {-309, -16381},   {-311, -16381},   {-313, -16381},
    {-314, -16381},   {-316, -16381},   {-317, -16381},   {-319, -16381},   {-320, -16381},   {-322, -16381},
    {-324, -16381},   {-325, -16381},   {-327, -16381},   {-328, -16381},   {-330, -16381},   {-331, -16381},
    {-333, -16381},   {-335, -16381},   {-336, -16381},   {-338, -16381},   {-339, -16380},   {-341, -16380},
    {-342, -16380},   {-344, -16380},   {-346, -16380},   {-347, -16380},   {-349, -16380},   {-350, -16380},
    {-352, -16380},   {-353, -16380},   {-355, -16380},   {-357, -16380},   {-358, -16380},   {-360, -16380},
    {-361, -16380},   {-363, -16380},   {-364, -16380},   {-366, -16380},   {-368, -16380},   {-369, -16380},
    {-371, -16380},   {-372, -16380},   {-374, -16380},   {-375, -16380},   {-377, -16380},   {-379, -16380},
    {-380, -16380},   {-382, -16380},   {-383, -16380},   {-385, -16379},   {-386, -16379},   {-388, -16379},
    {-390, -16379},   {-391, -16379},   {-393, -16379},   {-394, -16379},   {-396, -16379},   {-397, -16379},
    {-399, -16379},   {-401, -16379},   {-402, -16379},   {-404, -16379},   {-405, -16379},   {-407, -16379},
    {-408, -16379},   {-410, -16379},   {-412, -16379},   {-413, -16379},   {-415, -16379},   {-416, -16379},
    {-418, -16379},   {-419, -16379},   {-421, -16379},   {-422, -16379},   {-424, -16379},   {-426, -16378},
    {-427, -16378},   {-429, -16378},   {-430, -16378},   {-432, -16378},   {-433, -16378},   {-435, -16378},
    {-437, -16378},   {-438, -16378},   {-440, -16378},   {-441, -16378},   {-443, -16378},   {-444, -16378},
    {-446, -16378},   {-448, -16378},   {-449, -16378},   {-451, -16378},   {-452, -16378},   {-454, -16378},
    {-455, -16378},   {-457, -16378},   {-459, -16378},   {-460, -16378},   {-462, -16377},   {-463, -16377},
    {-465, -16377},   {-466, -16377},   {-468, -16377},   {-470, -16377},   {-471, -16377},   {-473, -16377},
    {-474, -16377},   {-476, -16377},   {-477, -16377},   {-479, -16377},   {-481, -16377},   {-482, -16377},
    {-484, -16377},   {-485, -16377},   {-487, -16377},   {-488, -16377},   {-490, -16377},   {-492, -16377},
    {-493, -16377},   {-495, -16377},   {-496, -16376},   {-498, -16376},   {-499, -16376},   {-501, -16376},
    {-503, -16376},   {-504, -16376},   {-506, -16376},   {-507, -16376},   {-509, -16376},   {-510, -16376},
    {-512, -16376},   {-514, -16376},   {-515, -16376},   {-517, -16376},   {-518, -16376},   {-520, -16376},
    {-521, -16376},   {-523, -16376},   {-525, -16376},   {-526, -16376},   {-528, -16375},   {-529, -16375},
    {-531, -16375},   {-532, -16375},   {-534, -16375},   {-536, -16375},   {-537, -16375},   {-539, -16375},
    {-540, -16375},   {-542, -16375},   {-543, -16375},   {-545, -16375},   {-547, -16375},   {-548, -16375},
    {-550, -16375},   {-551, -16375},   {-553, -16375},   {-554, -16375},   {-556, -16375},   {-558, -16375},
    {-559, -16374},   {-561, -16374},   {-562, -16374},   {-564, -16374},   {-565, -16374},   {-567, -16374},
    {-569, -16374},   {-570, -16374},   {-572, -16374},   {-573, -16374},   {-575, -16374},   {-576, -16374},
    {-578, -16374},   {-580, -16374},   {-581, -16374},   {-583, -16374},   {-584, -16374},   {-586, -16374},
    {-587, -16373},   {-589, -16373},   {-590, -16373},   {-592, -16373},   {-594, -16373},   {-595, -16373},
    {-597, -16373},   {-598, -16373},   {-600, -16373},   {-601, -16373},   {-603, -16373},   {-605, -16373},
    {-606, -16373},   {-608, -16373},   {-609, -16373},   {-611, -16373},   {-612, -16373},   {-614, -16372},
    {-616, -16372},   {-617, -16372},   {-619, -16372},   {-620, -16372},   {-622, -16372},   {-623, -16372},
    {-625, -16372},   {-627, -16372},   {-628, -16372},   {-630, -16372},   {-631, -16372},   {-633, -16372},
    {-634, -16372},   {-636, -16372},   {-638, -16372},   {-639, -16372},   {-641, -16371},   {-642, -16371},
    {-644, -16371},   {-645, -16371},   {-647, -16371},   {-649, -16371},   {-650, -16371},   {-652, -16371},
    {-653, -16371},   {-655, -16371},   {-656, -16371},   {-658, -16371},   {-660, -16371},   {-661, -16371},
    {-663, -16371},   {-664, -16371},   {-666, -16370},   {-667, -16370},   {-669, -16370},   {-671, -16370},
    {-672, -16370},   {-674, -16370},   {-675, -16370},   {-677, -16370},   {-678, -16370},   {-680, -16370},
    {-682, -16370},   {-683, -16370},   {-685, -16370},   {-686, -16370},   {-688, -16370},   {-689, -16369},
    {-691, -16369},   {-693, -16369},   {-694, -16369},   {-696, -16369},   {-697, -16369},   {-699, -16369},
    {-700, -16369},   {-702, -16369},   {-704, -16369},   {-705, -16369},   {-707, -16369},   {-708, -16369},
    {-710, -16369},   {-711, -16369},   {-713, -16368},   {-714, -16368},   {-716, -16368},   {-718, -16368},
    {-719, -16368},   {-721, -16368},   {-722, -16368},   {-724, -16368},   {-725, -16368},   {-727, -16368},
    {-729, -16368},   {-730, -16368},   {-732, -16368},   {-733, -16368},   {-735, -16368},   {-736, -16367},
    {-738, -16367},   {-740, -16367},   {-741, -16367},   {-743, -16367},   {-744, -16367},   {-746, -16367},
    {-747, -16367},   {-749, -16367},   {-751, -16367},   {-752, -16367},   {-754, -16367},   {-755, -16367},
    {-757, -16367},   {-758, -16366},   {-760, -16366},   {-762, -16366},   {-763, -16366},   {-765, -16366},
    {-766, -16366},   {-768, -16366},   {-769, -16366},   {-771, -16366},   {-773, -16366},   {-774, -16366},
    {-776, -16366},   {-777, -16366},   {-779, -16365},   {-780, -16365},   {-782, -16365},   {-784, -16365},
    {-785, -16365},   {-787, -16365},   {-788, -16365},   {-790, -16365},   {-791, -16365},   {-793, -16365},
    {-795, -16365},   {-796, -16365},   {-798, -16365},   {-799, -16364},   {-801, -16364},   {-802, -16364},
    {-804, -16364},   {-805, -16364},   {-807, -16364},   {-809, -16364},   {-810, -16364},   {-812, -16364},
    {-813, -16364},   {-815, -16364},   {-816, -16364},   {-818, -16364},   {-820, -16363},   {-821, -16363},
    {-823, -16363},   {-824, -16363},   {-826, -16363},   {-827, -16363},   {-829, -16363},   {-831, -16363},
    {-832, -16363},   {-834, -16363},   {-835, -16363},   {-837, -16363},   {-838, -16363},   {-840, -16362},
    {-842, -16362},   {-843, -16362},   {-845, -16362},   {-846, -16362},   {-848, -16362},   {-849, -16362},
    {-851, -16362},   {-853, -16362},   {-854, -16362},   {-856, -16362},   {-857, -16362},   {-859, -16361},
    {-860, -16361},   {-862, -16361},   {-864, -16361},   {-865, -16361},   {-867, -16361},   {-868, -16361},
    {-870, -16361},   {-871, -16361},   {-873, -16361},   {-875, -16361},   {-876, -16361},   {-878, -16360},
    {-879, -16360},   {-881, -16360},   {-882, -16360},   {-884, -16360},   {-885, -16360},   {-887, -16360},
    {-889, -16360},   {-890, -16360},   {-892, -16360},   {-893, -16360},   {-895, -16360},   {-896, -16359},
    {-898, -16359},   {-900, -16359},   {-901, -16359},   {-903, -16359},   {-904, -16359},   {-906, -16359},
    {-907, -16359},   {-909, -16359},   {-911, -16359},   {-912, -16359},   {-914, -16359},   {-915, -16358},
    {-917, -16358},   {-918, -16358},   {-920, -16358},   {-922, -16358},   {-923, -16358},   {-925, -16358},
    {-926, -16358},   {-928, -16358},   {-929, -16358},   {-931, -16358},   {-933, -16357},   {-934, -16357},
    {-936, -16357},   {-937, -16357},   {-939, -16357},   {-940, -16357},   {-942, -16357},   {-944, -16357},
    {-945, -16357},   {-947, -16357},   {-948, -16357},   {-950, -16356},   {-951, -16356},   {-953, -16356},
    {-955, -16356},   {-956, -16356},   {-958, -16356},   {-959, -16356},   {-961, -16356},   {-962, -16356},
    {-964, -16356},   {-965, -16356},   {-967, -16355},   {-969, -16355},   {-970, -16355},   {-972, -16355},
    {-973, -16355},   {-975, -16355},   {-976, -16355},   {-978, -16355},   {-980, -16355},   {-981, -16355},
    {-983, -16355},   {-984, -16354},   {-986, -16354},   {-987, -16354},   {-989, -16354},   {-991, -16354},
    {-992, -16354},   {-994, -16354},   {-995, -16354},   {-997, -16354},   {-998, -16354},   {-1000, -16353},
    {-1002, -16353},  {-1003, -16353},  {-1005, -16353},  {-1006, -16353},  {-1008, -16353},  {-1009, -16353},
    {-1011, -16353},  {-1013, -16353},  {-1014, -16353},  {-1016, -16352},  {-1017, -16352},  {-1019, -16352},
    {-1020, -16352},  {-1022, -16352},  {-1023, -16352},  {-1025, -16352},  {-1027, -16352},  {-1028, -16352},
    {-1030, -16352},  {-1031, -16352},  {-1033, -16351},  {-1034, -16351},  {-1036, -16351},  {-1038, -16351},
    {-1039, -16351},  {-1041, -16351},  {-1042, -16351},  {-1044, -16351},  {-1045, -16351},  {-1047, -16351},
    {-1049, -16350},  {-1050, -16350},  {-1052, -16350},  {-1053, -16350},  {-1055, -16350},  {-1056, -16350},
    {-1058, -16350},  {-1060, -16350},  {-1061, -16350},  {-1063, -16350},  {-1064, -16349},  {-1066, -16349},
    {-1067, -16349},  {-1069, -16349},  {-1071, -16349},  {-1072, -16349},  {-1074, -16349},  {-1075, -16349},
    {-1077, -16349},  {-1078, -16348},  {-1080, -16348},  {-1081, -16348},  {-1083, -16348},  {-1085, -16348},
    {-1086, -16348},  {-1088, -16348},  {-1089, -16348},  {-1091, -16348},  {-1092, -16348},  {-1094, -16347},
    {-1096, -16347},  {-1097, -16347},  {-1099, -16347},  {-1100, -16347},  {-1102, -16347},  {-1103, -16347},
    {-1105, -16347},  {-1107, -16347},  {-1108, -16346},  {-1110, -16346},  {-1111, -16346},  {-1113, -16346},
    {-1114, -16346},  {-1116, -16346},  {-1118, -16346},  {-1119, -16346},  {-1121, -16346},  {-1122, -16346},
    {-1124, -16345},  {-1125, -16345},  {-1127, -16345},  {-1129, -16345},  {-1130, -16345},  {-1132, -16345},
    {-1133, -16345},  {-1135, -16345},  {-1136, -16345},  {-1138, -16344},  {-1139, -16344},  {-1141, -16344},
    {-1143, -16344},  {-1144, -16344},  {-1146, -16344},  {-1147, -16344},  {-1149, -16344},  {-1150, -16344},
    {-1152, -16343},  {-1154, -16343},  {-1155, -16343},  {-1157, -16343},  {-1158, -16343},  {-1160, -16343},
    {-1161, -16343},  {-1163, -16343},  {-1165, -16343},  {-1166, -16342},  {-1168, -16342},  {-1169, -16342},
    {-1171, -16342},  {-1172, -16342},  {-1174, -16342},  {-1176, -16342},  {-1177, -16342},  {-1179, -16342},
    {-1180, -16341},  {-1182, -16341},  {-1183, -16341},  {-1185, -16341},  {-1186, -16341},  {-1188, -16341},
    {-1190, -16341},  {-1191, -16341},  {-1193, -16341},  {-1194, -16340},  {-1196, -16340},  {-1197, -16340},
    {-1199, -16340},  {-1201, -16340},  {-1202, -16340},  {-1204, -16340},  {-1205, -16340},  {-1207, -16339},
    {-1208, -16339},  {-1210, -16339},  {-1212, -16339},  {-1213, -16339},  {-1215, -16339},  {-1216, -16339},
    {-1218, -16339},  {-1219, -16339},  {-1221, -16338},  {-1223, -16338},  {-1224, -16338},  {-1226, -16338},
    {-1227, -16338},  {-1229, -16338},  {-1230, -16338},  {-1232, -16338},  {-1233, -16338},  {-1235, -16337},
    {-1237, -16337},  {-1238, -16337},  {-1240, -16337},  {-1241, -16337},  {-1243, -16337},  {-1244, -16337},
    {-1246, -16337},  {-1248, -16336},  {-1249, -16336},  {-1251, -16336},  {-1252, -16336},  {-1254, -16336},
    {-1255, -16336},  {-1257, -16336},  {-1259, -16336},  {-1260, -16335},  {-1262, -16335},  {-1263, -16335},
    {-1265, -16335},  {-1266, -16335},  {-1268, -16335},  {-1270, -16335},  {-1271, -16335},  {-1273, -16334},
    {-1274, -16334},  {-1276, -16334},  {-1277, -16334},  {-1279, -16334},  {-1280, -16334},  {-1282, -16334},
    {-1284, -16334},  {-1285, -16334},  {-1287, -16333},  {-1288, -16333},  {-1290, -16333},  {-1291, -16333},
    {-1293, -16333},  {-1295, -16333},  {-1296, -16333},  {-1298, -16333},  {-1299, -16332},  {-1301, -16332},
    {-1302, -16332},  {-1304, -16332},  {-1306, -16332},  {-1307, -16332},  {-1309, -16332},  {-1310, -16332},
    {-1312, -16331},  {-1313, -16331},  {-1315, -16331},  {-1316, -16331},  {-1318, -16331},  {-1320, -16331},
    {-1321, -16331},  {-1323, -16331},  {-1324, -16330},  {-1326, -16330},  {-1327, -16330},  {-1329, -16330},
    {-1331, -16330},  {-1332, -16330},  {-1334, -16330},  {-1335, -16329},  {-1337, -16329},  {-1338, -16329},
    {-1340, -16329},  {-1342, -16329},  {-1343, -16329},  {-1345, -16329},  {-1346, -16329},  {-1348, -16328},
    {-1349, -16328},  {-1351, -16328},  {-1352, -16328},  {-1354, -16328},  {-1356, -16328},  {-1357, -16328},
    {-1359, -16328},  {-1360, -16327},  {-1362, -16327},  {-1363, -16327},  {-1365, -16327},  {-1367, -16327},
    {-1368, -16327},  {-1370, -16327},  {-1371, -16327},  {-1373, -16326},  {-1374, -16326},  {-1376, -16326},
    {-1378, -16326},  {-1379, -16326},  {-1381, -16326},  {-1382, -16326},  {-1384, -16325},  {-1385, -16325},
    {-1387, -16325},  {-1388, -16325},  {-1390, -16325},  {-1392, -16325},  {-1393, -16325},  {-1395, -16325},
    {-1396, -16324},  {-1398, -16324},  {-1399, -16324},  {-1401, -16324},  {-1403, -16324},  {-1404, -16324},
    {-1406, -16324},  {-1407, -16323},  {-1409, -16323},  {-1410, -16323},  {-1412, -16323},  {-1414, -16323},
    {-1415, -16323},  {-1417, -16323},  {-1418, -16323},  {-1420, -16322},  {-1421, -16322},  {-1423, -16322},
    {-1424, -16322},  {-1426, -16322},  {-1428, -16322},  {-1429, -16322},  {-1431, -16321},  {-1432, -16321},
    {-1434, -16321},  {-1435, -16321},  {-1437, -16321},  {-1439, -16321},  {-1440, -16321},  {-1442, -16320},
    {-1443, -16320},  {-1445, -16320},  {-1446, -16320},  {-1448, -16320},  {-1450, -16320},  {-1451, -16320},
    {-1453, -16319},  {-1454, -16319},  {-1456, -16319},  {-1457, -16319},  {-1459, -16319},  {-1460, -16319},
    {-1462, -16319},  {-1464, -16318},  {-1465, -16318},  {-1467, -16318},  {-1468, -16318},  {-1470, -16318},
    {-1471, -16318},  {-1473, -16318},  {-1475, -16318},  {-1476, -16317},  {-1478, -16317},  {-1479, -16317},
    {-1481, -16317},  {-1482, -16317},  {-1484, -16317},  {-1486, -16317},  {-1487, -16316},  {-1489, -16316},
    {-1490, -16316},  {-1492, -16316},  {-1493, -16316},  {-1495, -16316},  {-1496, -16316},  {-1498, -16315},
    {-1500, -16315},  {-1501, -16315},  {-1503, -16315},  {-1504, -16315},  {-1506, -16315},  {-1507, -16315},
    {-1509, -16314},  {-1511, -16314},  {-1512, -16314},  {-1514, -16314},  {-1515, -16314},  {-1517, -16314},
    {-1518, -16313},  {-1520, -16313},  {-1521, -16313},  {-1523, -16313},  {-1525, -16313},  {-1526, -16313},
    {-1528, -16313},  {-1529, -16312},  {-1531, -16312},  {-1532, -16312},  {-1534, -16312},  {-1536, -16312},
    {-1537, -16312},  {-1539, -16312},  {-1540, -16311},  {-1542, -16311},  {-1543, -16311},  {-1545, -16311},
    {-1546, -16311},  {-1548, -16311},  {-1550, -16311},  {-1551, -16310},  {-1553, -16310},  {-1554, -16310},
    {-1556, -16310},  {-1557, -16310},  {-1559, -16310},  {-1561, -16310},  {-1562, -16309},  {-1564, -16309},
    {-1565, -16309},  {-1567, -16309},  {-1568, -16309},  {-1570, -16309},  {-1572, -16308},  {-1573, -16308},
    {-1575, -16308},  {-1576, -16308},  {-1578, -16308},  {-1579, -16308},  {-1581, -16308},  {-1582, -16307},
    {-1584, -16307},  {-1586, -16307},  {-1587, -16307},  {-1589, -16307},  {-1590, -16307},  {-1592, -16306},
    {-1593, -16306},  {-1595, -16306},  {-1597, -16306},  {-1598, -16306},  {-1600, -16306},  {-1601, -16306},
    {-1603, -16305},  {-1604, -16305},  {-1606, -16305},  {-1607, -16305},  {-1609, -16305},  {-1611, -16305},
    {-1612, -16304},  {-1614, -16304},  {-1615, -16304},  {-1617, -16304},  {-1618, -16304},  {-1620, -16304},
    {-1622, -16304},  {-1623, -16303},  {-1625, -16303},  {-1626, -16303},  {-1628, -16303},  {-1629, -16303},
    {-1631, -16303},  {-1632, -16302},  {-1634, -16302},  {-1636, -16302},  {-1637, -16302},  {-1639, -16302},
    {-1640, -16302},  {-1642, -16302},  {-1643, -16301},  {-1645, -16301},  {-1647, -16301},  {-1648, -16301},
    {-1650, -16301},  {-1651, -16301},  {-1653, -16300},  {-1654, -16300},  {-1656, -16300},  {-1657, -16300},
    {-1659, -16300},  {-1661, -16300},  {-1662, -16299},  {-1664, -16299},  {-1665, -16299},  {-1667, -16299},
    {-1668, -16299},  {-1670, -16299},  {-1672, -16299},  {-1673, -16298},  {-1675, -16298},  {-1676, -16298},
    {-1678, -16298},  {-1679, -16298},  {-1681, -16298},  {-1682, -16297},  {-1684, -16297},  {-1686, -16297},
    {-1687, -16297},  {-1689, -16297},  {-1690, -16297},  {-1692, -16296},  {-1693, -16296},  {-1695, -16296},
    {-1697, -16296},  {-1698, -16296},  {-1700, -16296},  {-1701, -16295},  {-1703, -16295},  {-1704, -16295},
    {-1706, -16295},  {-1707, -16295},  {-1709, -16295},  {-1711, -16294},  {-1712, -16294},  {-1714, -16294},
    {-1715, -16294},  {-1717, -16294},  {-1718, -16294},  {-1720, -16293},  {-1722, -16293},  {-1723, -16293},
    {-1725, -16293},  {-1726, -16293},  {-1728, -16293},  {-1729, -16292},  {-1731, -16292},  {-1732, -16292},
    {-1734, -16292},  {-1736, -16292},  {-1737, -16292},  {-1739, -16291},  {-1740, -16291},  {-1742, -16291},
    {-1743, -16291},  {-1745, -16291},  {-1747, -16291},  {-1748, -16290},  {-1750, -16290},  {-1751, -16290},
    {-1753, -16290},  {-1754, -16290},  {-1756, -16290},  {-1757, -16289},  {-1759, -16289},  {-1761, -16289},
    {-1762, -16289},  {-1764, -16289},  {-1765, -16289},  {-1767, -16288},  {-1768, -16288},  {-1770, -16288},
    {-1772, -16288},  {-1773, -16288},  {-1775, -16288},  {-1776, -16287},  {-1778, -16287},  {-1779, -16287},
    {-1781, -16287},  {-1782, -16287},  {-1784, -16287},  {-1786, -16286},  {-1787, -16286},  {-1789, -16286},
    {-1790, -16286},  {-1792, -16286},  {-1793, -16286},  {-1795, -16285},  {-1797, -16285},  {-1798, -16285},
    {-1800, -16285},  {-1801, -16285},  {-1803, -16285},  {-1804, -16284},  {-1806, -16284},  {-1807, -16284},
    {-1809, -16284},  {-1811, -16284},  {-1812, -16283},  {-1814, -16283},  {-1815, -16283},  {-1817, -16283},
    {-1818, -16283},  {-1820, -16283},  {-1821, -16282},  {-1823, -16282},  {-1825, -16282},  {-1826, -16282},
    {-1828, -16282},  {-1829, -16282},  {-1831, -16281},  {-1832, -16281},  {-1834, -16281},  {-1836, -16281},
    {-1837, -16281},  {-1839, -16281},  {-1840, -16280},  {-1842, -16280},  {-1843, -16280},  {-1845, -16280},
    {-1846, -16280},  {-1848, -16279},  {-1850, -16279},  {-1851, -16279},  {-1853, -16279},  {-1854, -16279},
    {-1856, -16279},  {-1857, -16278},  {-1859, -16278},  {-1861, -16278},  {-1862, -16278},  {-1864, -16278},
    {-1865, -16277},  {-1867, -16277},  {-1868, -16277},  {-1870, -16277},  {-1871, -16277},  {-1873, -16277},
    {-1875, -16276},  {-1876, -16276},  {-1878, -16276},  {-1879, -16276},  {-1881, -16276},  {-1882, -16276},
    {-1884, -16275},  {-1885, -16275},  {-1887, -16275},  {-1889, -16275},  {-1890, -16275},  {-1892, -16274},
    {-1893, -16274},  {-1895, -16274},  {-1896, -16274},  {-1898, -16274},  {-1900, -16274},  {-1901, -16273},
    {-1903, -16273},  {-1904, -16273},  {-1906, -16273},  {-1907, -16273},  {-1909, -16272},  {-1910, -16272},
    {-1912, -16272},  {-1914, -16272},  {-1915, -16272},  {-1917, -16272},  {-1918, -16271},  {-1920, -16271},
    {-1921, -16271},  {-1923, -16271},  {-1924, -16271},  {-1926, -16270},  {-1928, -16270},  {-1929, -16270},
    {-1931, -16270},  {-1932, -16270},  {-1934, -16269},  {-1935, -16269},  {-1937, -16269},  {-1939, -16269},
    {-1940, -16269},  {-1942, -16269},  {-1943, -16268},  {-1945, -16268},  {-1946, -16268},  {-1948, -16268},
    {-1949, -16268},  {-1951, -16267},  {-1953, -16267},  {-1954, -16267},  {-1956, -16267},  {-1957, -16267},
    {-1959, -16266},  {-1960, -16266},  {-1962, -16266},  {-1963, -16266},  {-1965, -16266},  {-1967, -16266},
    {-1968, -16265},  {-1970, -16265},  {-1971, -16265},  {-1973, -16265},  {-1974, -16265},  {-1976, -16264},
    {-1978, -16264},  {-1979, -16264},  {-1981, -16264},  {-1982, -16264},  {-1984, -16263},  {-1985, -16263},
    {-1987, -16263},  {-1988, -16263},  {-1990, -16263},  {-1992, -16263},  {-1993, -16262},  {-1995, -16262},
    {-1996, -16262},  {-1998, -16262},  {-1999, -16262},  {-2001, -16261},  {-2002, -16261},  {-2004, -16261},
    {-2006, -16261},  {-2007, -16261},  {-2009, -16260},  {-2010, -16260},  {-2012, -16260},  {-2013, -16260},
    {-2015, -16260},  {-2016, -16259},  {-2018, -16259},  {-2020, -16259},  {-2021, -16259},  {-2023, -16259},
    {-2024, -16258},  {-2026, -16258},  {-2027, -16258},  {-2029, -16258},  {-2031, -16258},  {-2032, -16257},
    {-2034, -16257},  {-2035, -16257},  {-2037, -16257},  {-2038, -16257},  {-2040, -16257},  {-2041, -16256},
    {-2043, -16256},  {-2045, -16256},  {-2046, -16256},  {-2048, -16256},  {-2049, -16255},  {-2051, -16255},
    {-2052, -16255},  {-2054, -16255},  {-2055, -16255},  {-2057, -16254},  {-2059, -16254},  {-2060, -16254},
    {-2062, -16254},  {-2063, -16254},  {-2065, -16253},  {-2066, -16253},  {-2068, -16253},  {-2069, -16253},
    {-2071, -16253},  {-2073, -16252},  {-2074, -16252},  {-2076, -16252},  {-2077, -16252},  {-2079, -16252},
    {-2080, -16251},  {-2082, -16251},  {-2084, -16251},  {-2085, -16251},  {-2087, -16251},  {-2088, -16250},
    {-2090, -16250},  {-2091, -16250},  {-2093, -16250},  {-2094, -16250},  {-2096, -16249},  {-2098, -16249},
    {-2099, -16249},  {-2101, -16249},  {-2102, -16249},  {-2104, -16248},  {-2105, -16248},  {-2107, -16248},
    {-2108, -16248},  {-2110, -16248},  {-2112, -16247},  {-2113, -16247},  {-2115, -16247},  {-2116, -16247},
    {-2118, -16247},  {-2119, -16246},  {-2121, -16246},  {-2122, -16246},  {-2124, -16246},  {-2126, -16246},
    {-2127, -16245},  {-2129, -16245},  {-2130, -16245},  {-2132, -16245},  {-2133, -16245},  {-2135, -16244},
    {-2136, -16244},  {-2138, -16244},  {-2140, -16244},  {-2141, -16243},  {-2143, -16243},  {-2144, -16243},
    {-2146, -16243},  {-2147, -16243},  {-2149, -16242},  {-2150, -16242},  {-2152, -16242},  {-2154, -16242},
    {-2155, -16242},  {-2157, -16241},  {-2158, -16241},  {-2160, -16241},  {-2161, -16241},  {-2163, -16241},
    {-2164, -16240},  {-2166, -16240},  {-2168, -16240},  {-2169, -16240},  {-2171, -16240},  {-2172, -16239},
    {-2174, -16239},  {-2175, -16239},  {-2177, -16239},  {-2179, -16239},  {-2180, -16238},  {-2182, -16238},
    {-2183, -16238},  {-2185, -16238},  {-2186, -16237},  {-2188, -16237},  {-2189, -16237},  {-2191, -16237},
    {-2193, -16237},  {-2194, -16236},  {-2196, -16236},  {-2197, -16236},  {-2199, -16236},  {-2200, -16236},
    {-2202, -16235},  {-2203, -16235},  {-2205, -16235},  {-2207, -16235},  {-2208, -16235},  {-2210, -16234},
    {-2211, -16234},  {-2213, -16234},  {-2214, -16234},  {-2216, -16233},  {-2217, -16233},  {-2219, -16233},
    {-2221, -16233},  {-2222, -16233},  {-2224, -16232},  {-2225, -16232},  {-2227, -16232},  {-2228, -16232},
    {-2230, -16232},  {-2231, -16231},  {-2233, -16231},  {-2235, -16231},  {-2236, -16231},  {-2238, -16230},
    {-2239, -16230},  {-2241, -16230},  {-2242, -16230},  {-2244, -16230},  {-2245, -16229},  {-2247, -16229},
    {-2249, -16229},  {-2250, -16229},  {-2252, -16229},  {-2253, -16228},  {-2255, -16228},  {-2256, -16228},
    {-2258, -16228},  {-2259, -16227},  {-2261, -16227},  {-2263, -16227},  {-2264, -16227},  {-2266, -16227},
    {-2267, -16226},  {-2269, -16226},  {-2270, -16226},  {-2272, -16226},  {-2273, -16226},  {-2275, -16225},
    {-2277, -16225},  {-2278, -16225},  {-2280, -16225},  {-2281, -16224},  {-2283, -16224},  {-2284, -16224},
    {-2286, -16224},  {-2287, -16224},  {-2289, -16223},  {-2291, -16223},  {-2292, -16223},  {-2294, -16223},
    {-2295, -16222},  {-2297, -16222},  {-2298, -16222},  {-2300, -16222},  {-2301, -16222},  {-2303, -16221},
    {-2305, -16221},  {-2306, -16221},  {-2308, -16221},  {-2309, -16220},  {-2311, -16220},  {-2312, -16220},
    {-2314, -16220},  {-2315, -16220},  {-2317, -16219},  {-2319, -16219},  {-2320, -16219},  {-2322, -16219},
    {-2323, -16218},  {-2325, -16218},  {-2326, -16218},  {-2328, -16218},  {-2329, -16218},  {-2331, -16217},
    {-2333, -16217},  {-2334, -16217},  {-2336, -16217},  {-2337, -16216},  {-2339, -16216},  {-2340, -16216},
    {-2342, -16216},  {-2343, -16216},  {-2345, -16215},  {-2347, -16215},  {-2348, -16215},  {-2350, -16215},
    {-2351, -16214},  {-2353, -16214},  {-2354, -16214},  {-2356, -16214},  {-2357, -16214},  {-2359, -16213},
    {-2361, -16213},  {-2362, -16213},  {-2364, -16213},  {-2365, -16212},  {-2367, -16212},  {-2368, -16212},
    {-2370, -16212},  {-2371, -16211},  {-2373, -16211},  {-2375, -16211},  {-2376, -16211},  {-2378, -16211},
    {-2379, -16210},  {-2381, -16210},  {-2382, -16210},  {-2384, -16210},  {-2385, -16209},  {-2387, -16209},
    {-2388, -16209},  {-2390, -16209},  {-2392, -16209},  {-2393, -16208},  {-2395, -16208},  {-2396, -16208},
    {-2398, -16208},  {-2399, -16207},  {-2401, -16207},  {-2402, -16207},  {-2404, -16207},  {-2406, -16206},
    {-2407, -16206},  {-2409, -16206},  {-2410, -16206},  {-2412, -16206},  {-2413, -16205},  {-2415, -16205},
    {-2416, -16205},  {-2418, -16205},  {-2420, -16204},  {-2421, -16204},  {-2423, -16204},  {-2424, -16204},
    {-2426, -16203},  {-2427, -16203},  {-2429, -16203},  {-2430, -16203},  {-2432, -16202},  {-2434, -16202},
    {-2435, -16202},  {-2437, -16202},  {-2438, -16202},  {-2440, -16201},  {-2441, -16201},  {-2443, -16201},
    {-2444, -16201},  {-2446, -16200},  {-2448, -16200},  {-2449, -16200},  {-2451, -16200},  {-2452, -16199},
    {-2454, -16199},  {-2455, -16199},  {-2457, -16199},  {-2458, -16199},  {-2460, -16198},  {-2462, -16198},
    {-2463, -16198},  {-2465, -16198},  {-2466, -16197},  {-2468, -16197},  {-2469, -16197},  {-2471, -16197},
    {-2472, -16196},  {-2474, -16196},  {-2475, -16196},  {-2477, -16196},  {-2479, -16195},  {-2480, -16195},
    {-2482, -16195},  {-2483, -16195},  {-2485, -16194},  {-2486, -16194},  {-2488, -16194},  {-2489, -16194},
    {-2491, -16194},  {-2493, -16193},  {-2494, -16193},  {-2496, -16193},  {-2497, -16193},  {-2499, -16192},
    {-2500, -16192},  {-2502, -16192},  {-2503, -16192},  {-2505, -16191},  {-2507, -16191},  {-2508, -16191},
    {-2510, -16191},  {-2511, -16190},  {-2513, -16190},  {-2514, -16190},  {-2516, -16190},  {-2517, -16189},
    {-2519, -16189},  {-2521, -16189},  {-2522, -16189},  {-2524, -16188},  {-2525, -16188},  {-2527, -16188},
    {-2528, -16188},  {-2530, -16188},  {-2531, -16187},  {-2533, -16187},  {-2534, -16187},  {-2536, -16187},
    {-2538, -16186},  {-2539, -16186},  {-2541, -16186},  {-2542, -16186},  {-2544, -16185},  {-2545, -16185},
    {-2547, -16185},  {-2548, -16185},  {-2550, -16184},  {-2552, -16184},  {-2553, -16184},  {-2555, -16184},
    {-2556, -16183},  {-2558, -16183},  {-2559, -16183},  {-2561, -16183},  {-2562, -16182},  {-2564, -16182},
    {-2566, -16182},  {-2567, -16182},  {-2569, -16181},  {-2570, -16181},  {-2572, -16181},  {-2573, -16181},
    {-2575, -16180},  {-2576, -16180},  {-2578, -16180},  {-2579, -16180},  {-2581, -16179},  {-2583, -16179},
    {-2584, -16179},  {-2586, -16179},  {-2587, -16178},  {-2589, -16178},  {-2590, -16178},  {-2592, -16178},
    {-2593, -16177},  {-2595, -16177},  {-2597, -16177},  {-2598, -16177},  {-2600, -16176},  {-2601, -16176},
    {-2603, -16176},  {-2604, -16176},  {-2606, -16175},  {-2607, -16175},  {-2609, -16175},  {-2610, -16175},
    {-2612, -16174},  {-2614, -16174},  {-2615, -16174},  {-2617, -16174},  {-2618, -16173},  {-2620, -16173},
    {-2621, -16173},  {-2623, -16173},  {-2624, -16172},  {-2626, -16172},  {-2628, -16172},  {-2629, -16172},
    {-2631, -16171},  {-2632, -16171},  {-2634, -16171},  {-2635, -16171},  {-2637, -16170},  {-2638, -16170},
    {-2640, -16170},  {-2641, -16170},  {-2643, -16169},  {-2645, -16169},  {-2646, -16169},  {-2648, -16169},
    {-2649, -16168},  {-2651, -16168},  {-2652, -16168},  {-2654, -16168},  {-2655, -16167},  {-2657, -16167},
    {-2659, -16167},  {-2660, -16167},  {-2662, -16166},  {-2663, -16166},  {-2665, -16166},  {-2666, -16166},
    {-2668, -16165},  {-2669, -16165},  {-2671, -16165},  {-2672, -16165},  {-2674, -16164},  {-2676, -16164},
    {-2677, -16164},  {-2679, -16164},  {-2680, -16163},  {-2682, -16163},  {-2683, -16163},  {-2685, -16163},
    {-2686, -16162},  {-2688, -16162},  {-2690, -16162},  {-2691, -16161},  {-2693, -16161},  {-2694, -16161},
    {-2696, -16161},  {-2697, -16160},  {-2699, -16160},  {-2700, -16160},  {-2702, -16160},  {-2703, -16159},
    {-2705, -16159},  {-2707, -16159},  {-2708, -16159},  {-2710, -16158},  {-2711, -16158},  {-2713, -16158},
    {-2714, -16158},  {-2716, -16157},  {-2717, -16157},  {-2719, -16157},  {-2721, -16157},  {-2722, -16156},
    {-2724, -16156},  {-2725, -16156},  {-2727, -16156},  {-2728, -16155},  {-2730, -16155},  {-2731, -16155},
    {-2733, -16154},  {-2734, -16154},  {-2736, -16154},  {-2738, -16154},  {-2739, -16153},  {-2741, -16153},
    {-2742, -16153},  {-2744, -16153},  {-2745, -16152},  {-2747, -16152},  {-2748, -16152},  {-2750, -16152},
    {-2752, -16151},  {-2753, -16151},  {-2755, -16151},  {-2756, -16151},  {-2758, -16150},  {-2759, -16150},
    {-2761, -16150},  {-2762, -16149},  {-2764, -16149},  {-2765, -16149},  {-2767, -16149},  {-2769, -16148},
    {-2770, -16148},  {-2772, -16148},  {-2773, -16148},  {-2775, -16147},  {-2776, -16147},  {-2778, -16147},
    {-2779, -16147},  {-2781, -16146},  {-2782, -16146},  {-2784, -16146},  {-2786, -16145},  {-2787, -16145},
    {-2789, -16145},  {-2790, -16145},  {-2792, -16144},  {-2793, -16144},  {-2795, -16144},  {-2796, -16144},
    {-2798, -16143},  {-2799, -16143},  {-2801, -16143},  {-2803, -16143},  {-2804, -16142},  {-2806, -16142},
    {-2807, -16142},  {-2809, -16141},  {-2810, -16141},  {-2812, -16141},  {-2813, -16141},  {-2815, -16140},
    {-2817, -16140},  {-2818, -16140},  {-2820, -16140},  {-2821, -16139},  {-2823, -16139},  {-2824, -16139},
    {-2826, -16138},  {-2827, -16138},  {-2829, -16138},  {-2830, -16138},  {-2832, -16137},  {-2834, -16137},
    {-2835, -16137},  {-2837, -16137},  {-2838, -16136},  {-2840, -16136},  {-2841, -16136},  {-2843, -16135},
    {-2844, -16135},  {-2846, -16135},  {-2847, -16135},  {-2849, -16134},  {-2851, -16134},  {-2852, -16134},
    {-2854, -16134},  {-2855, -16133},  {-2857, -16133},  {-2858, -16133},  {-2860, -16132},  {-2861, -16132},
    {-2863, -16132},  {-2864, -16132},  {-2866, -16131},  {-2868, -16131},  {-2869, -16131},  {-2871, -16131},
    {-2872, -16130},  {-2874, -16130},  {-2875, -16130},  {-2877, -16129},  {-2878, -16129},  {-2880, -16129},
    {-2881, -16129},  {-2883, -16128},  {-2885, -16128},  {-2886, -16128},  {-2888, -16128},  {-2889, -16127},
    {-2891, -16127},  {-2892, -16127},  {-2894, -16126},  {-2895, -16126},  {-2897, -16126},  {-2898, -16126},
    {-2900, -16125},  {-2902, -16125},  {-2903, -16125},  {-2905, -16124},  {-2906, -16124},  {-2908, -16124},
    {-2909, -16124},  {-2911, -16123},  {-2912, -16123},  {-2914, -16123},  {-2915, -16123},  {-2917, -16122},
    {-2919, -16122},  {-2920, -16122},  {-2922, -16121},  {-2923, -16121},  {-2925, -16121},  {-2926, -16121},
    {-2928, -16120},  {-2929, -16120},  {-2931, -16120},  {-2932, -16119},  {-2934, -16119},  {-2936, -16119},
    {-2937, -16119},  {-2939, -16118},  {-2940, -16118},  {-2942, -16118},  {-2943, -16117},  {-2945, -16117},
    {-2946, -16117},  {-2948, -16117},  {-2949, -16116},  {-2951, -16116},  {-2953, -16116},  {-2954, -16115},
    {-2956, -16115},  {-2957, -16115},  {-2959, -16115},  {-2960, -16114},  {-2962, -16114},  {-2963, -16114},
    {-2965, -16113},  {-2966, -16113},  {-2968, -16113},  {-2970, -16113},  {-2971, -16112},  {-2973, -16112},
    {-2974, -16112},  {-2976, -16111},  {-2977, -16111},  {-2979, -16111},  {-2980, -16111},  {-2982, -16110},
    {-2983, -16110},  {-2985, -16110},  {-2987, -16109},  {-2988, -16109},  {-2990, -16109},  {-2991, -16109},
    {-2993, -16108},  {-2994, -16108},  {-2996, -16108},  {-2997, -16107},  {-2999, -16107},  {-3000, -16107},
    {-3002, -16107},  {-3004, -16106},  {-3005, -16106},  {-3007, -16106},  {-3008, -16105},  {-3010, -16105},
    {-3011, -16105},  {-3013, -16105},  {-3014, -16104},  {-3016, -16104},  {-3017, -16104},  {-3019, -16103},
    {-3021, -16103},  {-3022, -16103},  {-3024, -16103},  {-3025, -16102},  {-3027, -16102},  {-3028, -16102},
    {-3030, -16101},  {-3031, -16101},  {-3033, -16101},  {-3034, -16101},  {-3036, -16100},  {-3038, -16100},
    {-3039, -16100},  {-3041, -16099},  {-3042, -16099},  {-3044, -16099},  {-3045, -16099},  {-3047, -16098},
    {-3048, -16098},  {-3050, -16098},  {-3051, -16097},  {-3053, -16097},  {-3055, -16097},  {-3056, -16096},
    {-3058, -16096},  {-3059, -16096},  {-3061, -16096},  {-3062, -16095},  {-3064, -16095},  {-3065, -16095},
    {-3067, -16094},  {-3068, -16094},  {-3070, -16094},  {-3071, -16094},  {-3073, -16093},  {-3075, -16093},
    {-3076, -16093},  {-3078, -16092},  {-3079, -16092},  {-3081, -16092},  {-3082, -16091},  {-3084, -16091},
    {-3085, -16091},  {-3087, -16091},  {-3088, -16090},  {-3090, -16090},  {-3092, -16090},  {-3093, -16089},
    {-3095, -16089},  {-3096, -16089},  {-3098, -16088},  {-3099, -16088},  {-3101, -16088},  {-3102, -16088},
    {-3104, -16087},  {-3105, -16087},  {-3107, -16087},  {-3108, -16086},  {-3110, -16086},  {-3112, -16086},
    {-3113, -16086},  {-3115, -16085},  {-3116, -16085},  {-3118, -16085},  {-3119, -16084},  {-3121, -16084},
    {-3122, -16084},  {-3124, -16083},  {-3125, -16083},  {-3127, -16083},  {-3129, -16083},  {-3130, -16082},
    {-3132, -16082},  {-3133, -16082},  {-3135, -16081},  {-3136, -16081},  {-3138, -16081},  {-3139, -16080},
    {-3141, -16080},  {-3142, -16080},  {-3144, -16080},  {-3146, -16079},  {-3147, -16079},  {-3149, -16079},
    {-3150, -16078},  {-3152, -16078},  {-3153, -16078},  {-3155, -16077},  {-3156, -16077},  {-3158, -16077},
    {-3159, -16076},  {-3161, -16076},  {-3162, -16076},  {-3164, -16076},  {-3166, -16075},  {-3167, -16075},
    {-3169, -16075},  {-3170, -16074},  {-3172, -16074},  {-3173, -16074},  {-3175, -16073},  {-3176, -16073},
    {-3178, -16073},  {-3179, -16073},  {-3181, -16072},  {-3182, -16072},  {-3184, -16072},  {-3186, -16071},
    {-3187, -16071},  {-3189, -16071},  {-3190, -16070},  {-3192, -16070},  {-3193, -16070},  {-3195, -16069},
    {-3196, -16069},  {-3198, -16069},  {-3199, -16069},  {-3201, -16068},  {-3203, -16068},  {-3204, -16068},
    {-3206, -16067},  {-3207, -16067},  {-3209, -16067},  {-3210, -16066},  {-3212, -16066},  {-3213, -16066},
    {-3215, -16065},  {-3216, -16065},  {-3218, -16065},  {-3219, -16065},  {-3221, -16064},  {-3223, -16064},
    {-3224, -16064},  {-3226, -16063},  {-3227, -16063},  {-3229, -16063},  {-3230, -16062},  {-3232, -16062},
    {-3233, -16062},  {-3235, -16061},  {-3236, -16061},  {-3238, -16061},  {-3239, -16061},  {-3241, -16060},
    {-3243, -16060},  {-3244, -16060},  {-3246, -16059},  {-3247, -16059},  {-3249, -16059},  {-3250, -16058},
    {-3252, -16058},  {-3253, -16058},  {-3255, -16057},  {-3256, -16057},  {-3258, -16057},  {-3260, -16056},
    {-3261, -16056},  {-3263, -16056},  {-3264, -16056},  {-3266, -16055},  {-3267, -16055},  {-3269, -16055},
    {-3270, -16054},  {-3272, -16054},  {-3273, -16054},  {-3275, -16053},  {-3276, -16053},  {-3278, -16053},
    {-3280, -16052},  {-3281, -16052},  {-3283, -16052},  {-3284, -16051},  {-3286, -16051},  {-3287, -16051},
    {-3289, -16051},  {-3290, -16050},  {-3292, -16050},  {-3293, -16050},  {-3295, -16049},  {-3296, -16049},
    {-3298, -16049},  {-3300, -16048},  {-3301, -16048},  {-3303, -16048},  {-3304, -16047},  {-3306, -16047},
    {-3307, -16047},  {-3309, -16046},  {-3310, -16046},  {-3312, -16046},  {-3313, -16045},  {-3315, -16045},
    {-3316, -16045},  {-3318, -16045},  {-3320, -16044},  {-3321, -16044},  {-3323, -16044},  {-3324, -16043},
    {-3326, -16043},  {-3327, -16043},  {-3329, -16042},  {-3330, -16042},  {-3332, -16042},  {-3333, -16041},
    {-3335, -16041},  {-3336, -16041},  {-3338, -16040},  {-3340, -16040},  {-3341, -16040},  {-3343, -16039},
    {-3344, -16039},  {-3346, -16039},  {-3347, -16038},  {-3349, -16038},  {-3350, -16038},  {-3352, -16037},
    {-3353, -16037},  {-3355, -16037},  {-3356, -16037},  {-3358, -16036},  {-3359, -16036},  {-3361, -16036},
    {-3363, -16035},  {-3364, -16035},  {-3366, -16035},  {-3367, -16034},  {-3369, -16034},  {-3370, -16034},
    {-3372, -16033},  {-3373, -16033},  {-3375, -16033},  {-3376, -16032},  {-3378, -16032},  {-3379, -16032},
    {-3381, -16031},  {-3383, -16031},  {-3384, -16031},  {-3386, -16030},  {-3387, -16030},  {-3389, -16030},
    {-3390, -16029},  {-3392, -16029},  {-3393, -16029},  {-3395, -16028},  {-3396, -16028},  {-3398, -16028},
    {-3399, -16027},  {-3401, -16027},  {-3403, -16027},  {-3404, -16026},  {-3406, -16026},  {-3407, -16026},
    {-3409, -16025},  {-3410, -16025},  {-3412, -16025},  {-3413, -16025},  {-3415, -16024},  {-3416, -16024},
    {-3418, -16024},  {-3419, -16023},  {-3421, -16023},  {-3423, -16023},  {-3424, -16022},  {-3426, -16022},
    {-3427, -16022},  {-3429, -16021},  {-3430, -16021},  {-3432, -16021},  {-3433, -16020},  {-3435, -16020},
    {-3436, -16020},  {-3438, -16019},  {-3439, -16019},  {-3441, -16019},  {-3442, -16018},  {-3444, -16018},
    {-3446, -16018},  {-3447, -16017},  {-3449, -16017},  {-3450, -16017},  {-3452, -16016},  {-3453, -16016},
    {-3455, -16016},  {-3456, -16015},  {-3458, -16015},  {-3459, -16015},  {-3461, -16014},  {-3462, -16014},
    {-3464, -16014},  {-3466, -16013},  {-3467, -16013},  {-3469, -16013},  {-3470, -16012},  {-3472, -16012},
    {-3473, -16012},  {-3475, -16011},  {-3476, -16011},  {-3478, -16011},  {-3479, -16010},  {-3481, -16010},
    {-3482, -16010},  {-3484, -16009},  {-3485, -16009},  {-3487, -16009},  {-3489, -16008},  {-3490, -16008},
    {-3492, -16008},  {-3493, -16007},  {-3495, -16007},  {-3496, -16007},  {-3498, -16006},  {-3499, -16006},
    {-3501, -16006},  {-3502, -16005},  {-3504, -16005},  {-3505, -16005},  {-3507, -16004},  {-3508, -16004},
    {-3510, -16004},  {-3512, -16003},  {-3513, -16003},  {-3515, -16003},  {-3516, -16002},  {-3518, -16002},
    {-3519, -16002},  {-3521, -16001},  {-3522, -16001},  {-3524, -16001},  {-3525, -16000},  {-3527, -16000},
    {-3528, -16000},  {-3530, -15999},  {-3531, -15999},  {-3533, -15999},  {-3535, -15998},  {-3536, -15998},
    {-3538, -15998},  {-3539, -15997},  {-3541, -15997},  {-3542, -15997},  {-3544, -15996},  {-3545, -15996},
    {-3547, -15995},  {-3548, -15995},  {-3550, -15995},  {-3551, -15994},  {-3553, -15994},  {-3554, -15994},
    {-3556, -15993},  {-3558, -15993},  {-3559, -15993},  {-3561, -15992},  {-3562, -15992},  {-3564, -15992},
    {-3565, -15991},  {-3567, -15991},  {-3568, -15991},  {-3570, -15990},  {-3571, -15990},  {-3573, -15990},
    {-3574, -15989},  {-3576, -15989},  {-3577, -15989},  {-3579, -15988},  {-3581, -15988},  {-3582, -15988},
    {-3584, -15987},  {-3585, -15987},  {-3587, -15987},  {-3588, -15986},  {-3590, -15986},  {-3591, -15986},
    {-3593, -15985},  {-3594, -15985},  {-3596, -15985},  {-3597, -15984},  {-3599, -15984},  {-3600, -15983},
    {-3602, -15983},  {-3604, -15983},  {-3605, -15982},  {-3607, -15982},  {-3608, -15982},  {-3610, -15981},
    {-3611, -15981},  {-3613, -15981},  {-3614, -15980},  {-3616, -15980},  {-3617, -15980},  {-3619, -15979},
    {-3620, -15979},  {-3622, -15979},  {-3623, -15978},  {-3625, -15978},  {-3627, -15978},  {-3628, -15977},
    {-3630, -15977},  {-3631, -15977},  {-3633, -15976},  {-3634, -15976},  {-3636, -15976},  {-3637, -15975},
    {-3639, -15975},  {-3640, -15974},  {-3642, -15974},  {-3643, -15974},  {-3645, -15973},  {-3646, -15973},
    {-3648, -15973},  {-3650, -15972},  {-3651, -15972},  {-3653, -15972},  {-3654, -15971},  {-3656, -15971},
    {-3657, -15971},  {-3659, -15970},  {-3660, -15970},  {-3662, -15970},  {-3663, -15969},  {-3665, -15969},
    {-3666, -15969},  {-3668, -15968},  {-3669, -15968},  {-3671, -15967},  {-3672, -15967},  {-3674, -15967},
    {-3676, -15966},  {-3677, -15966},  {-3679, -15966},  {-3680, -15965},  {-3682, -15965},  {-3683, -15965},
    {-3685, -15964},  {-3686, -15964},  {-3688, -15964},  {-3689, -15963},  {-3691, -15963},  {-3692, -15963},
    {-3694, -15962},  {-3695, -15962},  {-3697, -15961},  {-3698, -15961},  {-3700, -15961},  {-3702, -15960},
    {-3703, -15960},  {-3705, -15960},  {-3706, -15959},  {-3708, -15959},  {-3709, -15959},  {-3711, -15958},
    {-3712, -15958},  {-3714, -15958},  {-3715, -15957},  {-3717, -15957},  {-3718, -15956},  {-3720, -15956},
    {-3721, -15956},  {-3723, -15955},  {-3724, -15955},  {-3726, -15955},  {-3728, -15954},  {-3729, -15954},
    {-3731, -15954},  {-3732, -15953},  {-3734, -15953},  {-3735, -15953},  {-3737, -15952},  {-3738, -15952},
    {-3740, -15951},  {-3741, -15951},  {-3743, -15951},  {-3744, -15950},  {-3746, -15950},  {-3747, -15950},
    {-3749, -15949},  {-3750, -15949},  {-3752, -15949},  {-3754, -15948},  {-3755, -15948},  {-3757, -15948},
    {-3758, -15947},  {-3760, -15947},  {-3761, -15946},  {-3763, -15946},  {-3764, -15946},  {-3766, -15945},
    {-3767, -15945},  {-3769, -15945},  {-3770, -15944},  {-3772, -15944},  {-3773, -15944},  {-3775, -15943},
    {-3776, -15943},  {-3778, -15942},  {-3780, -15942},  {-3781, -15942},  {-3783, -15941},  {-3784, -15941},
    {-3786, -15941},  {-3787, -15940},  {-3789, -15940},  {-3790, -15940},  {-3792, -15939},  {-3793, -15939},
    {-3795, -15938},  {-3796, -15938},  {-3798, -15938},  {-3799, -15937},  {-3801, -15937},  {-3802, -15937},
    {-3804, -15936},  {-3806, -15936},  {-3807, -15936},  {-3809, -15935},  {-3810, -15935},  {-3812, -15934},
    {-3813, -15934},  {-3815, -15934},  {-3816, -15933},  {-3818, -15933},  {-3819, -15933},  {-3821, -15932},
    {-3822, -15932},  {-3824, -15932},  {-3825, -15931},  {-3827, -15931},  {-3828, -15930},  {-3830, -15930},
    {-3831, -15930},  {-3833, -15929},  {-3835, -15929},  {-3836, -15929},  {-3838, -15928},  {-3839, -15928},
    {-3841, -15927},  {-3842, -15927},  {-3844, -15927},  {-3845, -15926},  {-3847, -15926},  {-3848, -15926},
    {-3850, -15925},  {-3851, -15925},  {-3853, -15925},  {-3854, -15924},  {-3856, -15924},  {-3857, -15923},
    {-3859, -15923},  {-3861, -15923},  {-3862, -15922},  {-3864, -15922},  {-3865, -15922},  {-3867, -15921},
    {-3868, -15921},  {-3870, -15920},  {-3871, -15920},  {-3873, -15920},  {-3874, -15919},  {-3876, -15919},
    {-3877, -15919},  {-3879, -15918},  {-3880, -15918},  {-3882, -15917},  {-3883, -15917},  {-3885, -15917},
    {-3886, -15916},  {-3888, -15916},  {-3889, -15916},  {-3891, -15915},  {-3893, -15915},  {-3894, -15915},
    {-3896, -15914},  {-3897, -15914},  {-3899, -15913},  {-3900, -15913},  {-3902, -15913},  {-3903, -15912},
    {-3905, -15912},  {-3906, -15912},  {-3908, -15911},  {-3909, -15911},  {-3911, -15910},  {-3912, -15910},
    {-3914, -15910},  {-3915, -15909},  {-3917, -15909},  {-3918, -15909},  {-3920, -15908},  {-3922, -15908},
    {-3923, -15907},  {-3925, -15907},  {-3926, -15907},  {-3928, -15906},  {-3929, -15906},  {-3931, -15906},
    {-3932, -15905},  {-3934, -15905},  {-3935, -15904},  {-3937, -15904},  {-3938, -15904},  {-3940, -15903},
    {-3941, -15903},  {-3943, -15902},  {-3944, -15902},  {-3946, -15902},  {-3947, -15901},  {-3949, -15901},
    {-3951, -15901},  {-3952, -15900},  {-3954, -15900},  {-3955, -15899},  {-3957, -15899},  {-3958, -15899},
    {-3960, -15898},  {-3961, -15898},  {-3963, -15898},  {-3964, -15897},  {-3966, -15897},  {-3967, -15896},
    {-3969, -15896},  {-3970, -15896},  {-3972, -15895},  {-3973, -15895},  {-3975, -15895},  {-3976, -15894},
    {-3978, -15894},  {-3979, -15893},  {-3981, -15893},  {-3983, -15893},  {-3984, -15892},  {-3986, -15892},
    {-3987, -15891},  {-3989, -15891},  {-3990, -15891},  {-3992, -15890},  {-3993, -15890},  {-3995, -15890},
    {-3996, -15889},  {-3998, -15889},  {-3999, -15888},  {-4001, -15888},  {-4002, -15888},  {-4004, -15887},
    {-4005, -15887},  {-4007, -15886},  {-4008, -15886},  {-4010, -15886},  {-4011, -15885},  {-4013, -15885},
    {-4015, -15885},  {-4016, -15884},  {-4018, -15884},  {-4019, -15883},  {-4021, -15883},  {-4022, -15883},
    {-4024, -15882},  {-4025, -15882},  {-4027, -15881},  {-4028, -15881},  {-4030, -15881},  {-4031, -15880},
    {-4033, -15880},  {-4034, -15880},  {-4036, -15879},  {-4037, -15879},  {-4039, -15878},  {-4040, -15878},
    {-4042, -15878},  {-4043, -15877},  {-4045, -15877},  {-4046, -15876},  {-4048, -15876},  {-4050, -15876},
    {-4051, -15875},  {-4053, -15875},  {-4054, -15875},  {-4056, -15874},  {-4057, -15874},  {-4059, -15873},
    {-4060, -15873},  {-4062, -15873},  {-4063, -15872},  {-4065, -15872},  {-4066, -15871},  {-4068, -15871},
    {-4069, -15871},  {-4071, -15870},  {-4072, -15870},  {-4074, -15869},  {-4075, -15869},  {-4077, -15869},
    {-4078, -15868},  {-4080, -15868},  {-4081, -15867},  {-4083, -15867},  {-4085, -15867},  {-4086, -15866},
    {-4088, -15866},  {-4089, -15866},  {-4091, -15865},  {-4092, -15865},  {-4094, -15864},  {-4095, -15864},
    {-4097, -15864},  {-4098, -15863},  {-4100, -15863},  {-4101, -15862},  {-4103, -15862},  {-4104, -15862},
    {-4106, -15861},  {-4107, -15861},  {-4109, -15860},  {-4110, -15860},  {-4112, -15860},  {-4113, -15859},
    {-4115, -15859},  {-4116, -15858},  {-4118, -15858},  {-4119, -15858},  {-4121, -15857},  {-4123, -15857},
    {-4124, -15856},  {-4126, -15856},  {-4127, -15856},  {-4129, -15855},  {-4130, -15855},  {-4132, -15854},
    {-4133, -15854},  {-4135, -15854},  {-4136, -15853},  {-4138, -15853},  {-4139, -15853},  {-4141, -15852},
    {-4142, -15852},  {-4144, -15851},  {-4145, -15851},  {-4147, -15851},  {-4148, -15850},  {-4150, -15850},
    {-4151, -15849},  {-4153, -15849},  {-4154, -15849},  {-4156, -15848},  {-4157, -15848},  {-4159, -15847},
    {-4161, -15847},  {-4162, -15847},  {-4164, -15846},  {-4165, -15846},  {-4167, -15845},  {-4168, -15845},
    {-4170, -15845},  {-4171, -15844},  {-4173, -15844},  {-4174, -15843},  {-4176, -15843},  {-4177, -15843},
    {-4179, -15842},  {-4180, -15842},  {-4182, -15841},  {-4183, -15841},  {-4185, -15841},  {-4186, -15840},
    {-4188, -15840},  {-4189, -15839},  {-4191, -15839},  {-4192, -15839},  {-4194, -15838},  {-4195, -15838},
    {-4197, -15837},  {-4198, -15837},  {-4200, -15837},  {-4202, -15836},  {-4203, -15836},  {-4205, -15835},
    {-4206, -15835},  {-4208, -15835},  {-4209, -15834},  {-4211, -15834},  {-4212, -15833},  {-4214, -15833},
    {-4215, -15832},  {-4217, -15832},  {-4218, -15832},  {-4220, -15831},  {-4221, -15831},  {-4223, -15830},
    {-4224, -15830},  {-4226, -15830},  {-4227, -15829},  {-4229, -15829},  {-4230, -15828},  {-4232, -15828},
    {-4233, -15828},  {-4235, -15827},  {-4236, -15827},  {-4238, -15826},  {-4239, -15826},  {-4241, -15826},
    {-4243, -15825},  {-4244, -15825},  {-4246, -15824},  {-4247, -15824},  {-4249, -15824},  {-4250, -15823},
    {-4252, -15823},  {-4253, -15822},  {-4255, -15822},  {-4256, -15822},  {-4258, -15821},  {-4259, -15821},
    {-4261, -15820},  {-4262, -15820},  {-4264, -15819},  {-4265, -15819},  {-4267, -15819},  {-4268, -15818},
    {-4270, -15818},  {-4271, -15817},  {-4273, -15817},  {-4274, -15817},  {-4276, -15816},  {-4277, -15816},
    {-4279, -15815},  {-4280, -15815},  {-4282, -15815},  {-4283, -15814},  {-4285, -15814},  {-4286, -15813},
    {-4288, -15813},  {-4290, -15813},  {-4291, -15812},  {-4293, -15812},  {-4294, -15811},  {-4296, -15811},
    {-4297, -15810},  {-4299, -15810},  {-4300, -15810},  {-4302, -15809},  {-4303, -15809},  {-4305, -15808},
    {-4306, -15808},  {-4308, -15808},  {-4309, -15807},  {-4311, -15807},  {-4312, -15806},  {-4314, -15806},
    {-4315, -15805},  {-4317, -15805},  {-4318, -15805},  {-4320, -15804},  {-4321, -15804},  {-4323, -15803},
    {-4324, -15803},  {-4326, -15803},  {-4327, -15802},  {-4329, -15802},  {-4330, -15801},  {-4332, -15801},
    {-4333, -15801},  {-4335, -15800},  {-4337, -15800},  {-4338, -15799},  {-4340, -15799},  {-4341, -15798},
    {-4343, -15798},  {-4344, -15798},  {-4346, -15797},  {-4347, -15797},  {-4349, -15796},  {-4350, -15796},
    {-4352, -15796},  {-4353, -15795},  {-4355, -15795},  {-4356, -15794},  {-4358, -15794},  {-4359, -15793},
    {-4361, -15793},  {-4362, -15793},  {-4364, -15792},  {-4365, -15792},  {-4367, -15791},  {-4368, -15791},
    {-4370, -15791},  {-4371, -15790},  {-4373, -15790},  {-4374, -15789},  {-4376, -15789},  {-4377, -15788},
    {-4379, -15788},  {-4380, -15788},  {-4382, -15787},  {-4383, -15787},  {-4385, -15786},  {-4386, -15786},
    {-4388, -15785},  {-4389, -15785},  {-4391, -15785},  {-4393, -15784},  {-4394, -15784},  {-4396, -15783},
    {-4397, -15783},  {-4399, -15783},  {-4400, -15782},  {-4402, -15782},  {-4403, -15781},  {-4405, -15781},
    {-4406, -15780},  {-4408, -15780},  {-4409, -15780},  {-4411, -15779},  {-4412, -15779},  {-4414, -15778},
    {-4415, -15778},  {-4417, -15777},  {-4418, -15777},  {-4420, -15777},  {-4421, -15776},  {-4423, -15776},
    {-4424, -15775},  {-4426, -15775},  {-4427, -15774},  {-4429, -15774},  {-4430, -15774},  {-4432, -15773},
    {-4433, -15773},  {-4435, -15772},  {-4436, -15772},  {-4438, -15772},  {-4439, -15771},  {-4441, -15771},
    {-4442, -15770},  {-4444, -15770},  {-4445, -15769},  {-4447, -15769},  {-4448, -15769},  {-4450, -15768},
    {-4452, -15768},  {-4453, -15767},  {-4455, -15767},  {-4456, -15766},  {-4458, -15766},  {-4459, -15766},
    {-4461, -15765},  {-4462, -15765},  {-4464, -15764},  {-4465, -15764},  {-4467, -15763},  {-4468, -15763},
    {-4470, -15763},  {-4471, -15762},  {-4473, -15762},  {-4474, -15761},  {-4476, -15761},  {-4477, -15760},
    {-4479, -15760},  {-4480, -15760},  {-4482, -15759},  {-4483, -15759},  {-4485, -15758},  {-4486, -15758},
    {-4488, -15757},  {-4489, -15757},  {-4491, -15757},  {-4492, -15756},  {-4494, -15756},  {-4495, -15755},
    {-4497, -15755},  {-4498, -15754},  {-4500, -15754},  {-4501, -15754},  {-4503, -15753},  {-4504, -15753},
    {-4506, -15752},  {-4507, -15752},  {-4509, -15751},  {-4510, -15751},  {-4512, -15750},  {-4513, -15750},
    {-4515, -15750},  {-4516, -15749},  {-4518, -15749},  {-4519, -15748},  {-4521, -15748},  {-4523, -15747},
    {-4524, -15747},  {-4526, -15747},  {-4527, -15746},  {-4529, -15746},  {-4530, -15745},  {-4532, -15745},
    {-4533, -15744},  {-4535, -15744},  {-4536, -15744},  {-4538, -15743},  {-4539, -15743},  {-4541, -15742},
    {-4542, -15742},  {-4544, -15741},  {-4545, -15741},  {-4547, -15740},  {-4548, -15740},  {-4550, -15740},
    {-4551, -15739},  {-4553, -15739},  {-4554, -15738},  {-4556, -15738},  {-4557, -15737},  {-4559, -15737},
    {-4560, -15737},  {-4562, -15736},  {-4563, -15736},  {-4565, -15735},  {-4566, -15735},  {-4568, -15734},
    {-4569, -15734},  {-4571, -15734},  {-4572, -15733},  {-4574, -15733},  {-4575, -15732},  {-4577, -15732},
    {-4578, -15731},  {-4580, -15731},  {-4581, -15730},  {-4583, -15730},  {-4584, -15730},  {-4586, -15729},
    {-4587, -15729},  {-4589, -15728},  {-4590, -15728},  {-4592, -15727},  {-4593, -15727},  {-4595, -15726},
    {-4596, -15726},  {-4598, -15726},  {-4599, -15725},  {-4601, -15725},  {-4602, -15724},  {-4604, -15724},
    {-4605, -15723},  {-4607, -15723},  {-4609, -15723},  {-4610, -15722},  {-4612, -15722},  {-4613, -15721},
    {-4615, -15721},  {-4616, -15720},  {-4618, -15720},  {-4619, -15719},  {-4621, -15719},  {-4622, -15719},
    {-4624, -15718},  {-4625, -15718},  {-4627, -15717},  {-4628, -15717},  {-4630, -15716},  {-4631, -15716},
    {-4633, -15715},  {-4634, -15715},  {-4636, -15715},  {-4637, -15714},  {-4639, -15714},  {-4640, -15713},
    {-4642, -15713},  {-4643, -15712},  {-4645, -15712},  {-4646, -15711},  {-4648, -15711},  {-4649, -15711},
    {-4651, -15710},  {-4652, -15710},  {-4654, -15709},  {-4655, -15709},  {-4657, -15708},  {-4658, -15708},
    {-4660, -15707},  {-4661, -15707},  {-4663, -15707},  {-4664, -15706},  {-4666, -15706},  {-4667, -15705},
    {-4669, -15705},  {-4670, -15704},  {-4672, -15704},  {-4673, -15703},  {-4675, -15703},  {-4676, -15702},
    {-4678, -15702},  {-4679, -15702},  {-4681, -15701},  {-4682, -15701},  {-4684, -15700},  {-4685, -15700},
    {-4687, -15699},  {-4688, -15699},  {-4690, -15698},  {-4691, -15698},  {-4693, -15698},  {-4694, -15697},
    {-4696, -15697},  {-4697, -15696},  {-4699, -15696},  {-4700, -15695},  {-4702, -15695},  {-4703, -15694},
    {-4705, -15694},  {-4706, -15693},  {-4708, -15693},  {-4709, -15693},  {-4711, -15692},  {-4712, -15692},
    {-4714, -15691},  {-4715, -15691},  {-4717, -15690},  {-4718, -15690},  {-4720, -15689},  {-4721, -15689},
    {-4723, -15689},  {-4724, -15688},  {-4726, -15688},  {-4727, -15687},  {-4729, -15687},  {-4730, -15686},
    {-4732, -15686},  {-4733, -15685},  {-4735, -15685},  {-4736, -15684},  {-4738, -15684},  {-4739, -15684},
    {-4741, -15683},  {-4742, -15683},  {-4744, -15682},  {-4746, -15682},  {-4747, -15681},  {-4749, -15681},
    {-4750, -15680},  {-4752, -15680},  {-4753, -15679},  {-4755, -15679},  {-4756, -15679},  {-4758, -15678},
    {-4759, -15678},  {-4761, -15677},  {-4762, -15677},  {-4764, -15676},  {-4765, -15676},  {-4767, -15675},
    {-4768, -15675},  {-4770, -15674},  {-4771, -15674},  {-4773, -15673},  {-4774, -15673},  {-4776, -15673},
    {-4777, -15672},  {-4779, -15672},  {-4780, -15671},  {-4782, -15671},  {-4783, -15670},  {-4785, -15670},
    {-4786, -15669},  {-4788, -15669},  {-4789, -15668},  {-4791, -15668},  {-4792, -15668},  {-4794, -15667},
    {-4795, -15667},  {-4797, -15666},  {-4798, -15666},  {-4800, -15665},  {-4801, -15665},  {-4803, -15664},
    {-4804, -15664},  {-4806, -15663},  {-4807, -15663},  {-4809, -15662},  {-4810, -15662},  {-4812, -15662},
    {-4813, -15661},  {-4815, -15661},  {-4816, -15660},  {-4818, -15660},  {-4819, -15659},  {-4821, -15659},
    {-4822, -15658},  {-4824, -15658},  {-4825, -15657},  {-4827, -15657},  {-4828, -15656},  {-4830, -15656},
    {-4831, -15656},  {-4833, -15655},  {-4834, -15655},  {-4836, -15654},  {-4837, -15654},  {-4839, -15653},
    {-4840, -15653},  {-4842, -15652},  {-4843, -15652},  {-4845, -15651},  {-4846, -15651},  {-4848, -15650},
    {-4849, -15650},  {-4851, -15649},  {-4852, -15649},  {-4854, -15649},  {-4855, -15648},  {-4857, -15648},
    {-4858, -15647},  {-4860, -15647},  {-4861, -15646},  {-4863, -15646},  {-4864, -15645},  {-4866, -15645},
    {-4867, -15644},  {-4869, -15644},  {-4870, -15643},  {-4872, -15643},  {-4873, -15643},  {-4875, -15642},
    {-4876, -15642},  {-4878, -15641},  {-4879, -15641},  {-4881, -15640},  {-4882, -15640},  {-4884, -15639},
    {-4885, -15639},  {-4887, -15638},  {-4888, -15638},  {-4890, -15637},  {-4891, -15637},  {-4893, -15636},
    {-4894, -15636},  {-4896, -15635},  {-4897, -15635},  {-4899, -15635},  {-4900, -15634},  {-4902, -15634},
    {-4903, -15633},  {-4905, -15633},  {-4906, -15632},  {-4908, -15632},  {-4909, -15631},  {-4911, -15631},
    {-4912, -15630},  {-4914, -15630},  {-4915, -15629},  {-4917, -15629},  {-4918, -15628},  {-4920, -15628},
    {-4921, -15627},  {-4923, -15627},  {-4924, -15627},  {-4926, -15626},  {-4927, -15626},  {-4929, -15625},
    {-4930, -15625},  {-4932, -15624},  {-4933, -15624},  {-4935, -15623},  {-4936, -15623},  {-4938, -15622},
    {-4939, -15622},  {-4941, -15621},  {-4942, -15621},  {-4944, -15620},  {-4945, -15620},  {-4947, -15619},
    {-4948, -15619},  {-4950, -15618},  {-4951, -15618},  {-4953, -15618},  {-4954, -15617},  {-4956, -15617},
    {-4957, -15616},  {-4959, -15616},  {-4960, -15615},  {-4962, -15615},  {-4963, -15614},  {-4965, -15614},
    {-4966, -15613},  {-4968, -15613},  {-4969, -15612},  {-4971, -15612},  {-4972, -15611},  {-4974, -15611},
    {-4975, -15610},  {-4977, -15610},  {-4978, -15609},  {-4980, -15609},  {-4981, -15608},  {-4982, -15608},
    {-4984, -15608},  {-4985, -15607},  {-4987, -15607},  {-4988, -15606},  {-4990, -15606},  {-4991, -15605},
    {-4993, -15605},  {-4994, -15604},  {-4996, -15604},  {-4997, -15603},  {-4999, -15603},  {-5000, -15602},
    {-5002, -15602},  {-5003, -15601},  {-5005, -15601},  {-5006, -15600},  {-5008, -15600},  {-5009, -15599},
    {-5011, -15599},  {-5012, -15598},  {-5014, -15598},  {-5015, -15597},  {-5017, -15597},  {-5018, -15597},
    {-5020, -15596},  {-5021, -15596},  {-5023, -15595},  {-5024, -15595},  {-5026, -15594},  {-5027, -15594},
    {-5029, -15593},  {-5030, -15593},  {-5032, -15592},  {-5033, -15592},  {-5035, -15591},  {-5036, -15591},
    {-5038, -15590},  {-5039, -15590},  {-5041, -15589},  {-5042, -15589},  {-5044, -15588},  {-5045, -15588},
    {-5047, -15587},  {-5048, -15587},  {-5050, -15586},  {-5051, -15586},  {-5053, -15585},  {-5054, -15585},
    {-5056, -15584},  {-5057, -15584},  {-5059, -15583},  {-5060, -15583},  {-5062, -15582},  {-5063, -15582},
    {-5065, -15582},  {-5066, -15581},  {-5068, -15581},  {-5069, -15580},  {-5071, -15580},  {-5072, -15579},
    {-5074, -15579},  {-5075, -15578},  {-5077, -15578},  {-5078, -15577},  {-5080, -15577},  {-5081, -15576},
    {-5083, -15576},  {-5084, -15575},  {-5086, -15575},  {-5087, -15574},  {-5089, -15574},  {-5090, -15573},
    {-5092, -15573},  {-5093, -15572},  {-5095, -15572},  {-5096, -15571},  {-5098, -15571},  {-5099, -15570},
    {-5101, -15570},  {-5102, -15569},  {-5104, -15569},  {-5105, -15568},  {-5107, -15568},  {-5108, -15567},
    {-5110, -15567},  {-5111, -15566},  {-5113, -15566},  {-5114, -15565},  {-5115, -15565},  {-5117, -15564},
    {-5118, -15564},  {-5120, -15563},  {-5121, -15563},  {-5123, -15562},  {-5124, -15562},  {-5126, -15561},
    {-5127, -15561},  {-5129, -15561},  {-5130, -15560},  {-5132, -15560},  {-5133, -15559},  {-5135, -15559},
    {-5136, -15558},  {-5138, -15558},  {-5139, -15557},  {-5141, -15557},  {-5142, -15556},  {-5144, -15556},
    {-5145, -15555},  {-5147, -15555},  {-5148, -15554},  {-5150, -15554},  {-5151, -15553},  {-5153, -15553},
    {-5154, -15552},  {-5156, -15552},  {-5157, -15551},  {-5159, -15551},  {-5160, -15550},  {-5162, -15550},
    {-5163, -15549},  {-5165, -15549},  {-5166, -15548},  {-5168, -15548},  {-5169, -15547},  {-5171, -15547},
    {-5172, -15546},  {-5174, -15546},  {-5175, -15545},  {-5177, -15545},  {-5178, -15544},  {-5180, -15544},
    {-5181, -15543},  {-5183, -15543},  {-5184, -15542},  {-5186, -15542},  {-5187, -15541},  {-5189, -15541},
    {-5190, -15540},  {-5192, -15540},  {-5193, -15539},  {-5195, -15539},  {-5196, -15538},  {-5197, -15538},
    {-5199, -15537},  {-5200, -15537},  {-5202, -15536},  {-5203, -15536},  {-5205, -15535},  {-5206, -15535},
    {-5208, -15534},  {-5209, -15534},  {-5211, -15533},  {-5212, -15533},  {-5214, -15532},  {-5215, -15532},
    {-5217, -15531},  {-5218, -15531},  {-5220, -15530},  {-5221, -15530},  {-5223, -15529},  {-5224, -15529},
    {-5226, -15528},  {-5227, -15528},  {-5229, -15527},  {-5230, -15527},  {-5232, -15526},  {-5233, -15526},
    {-5235, -15525},  {-5236, -15525},  {-5238, -15524},  {-5239, -15524},  {-5241, -15523},  {-5242, -15523},
    {-5244, -15522},  {-5245, -15522},  {-5247, -15521},  {-5248, -15521},  {-5250, -15520},  {-5251, -15520},
    {-5253, -15519},  {-5254, -15519},  {-5256, -15518},  {-5257, -15518},  {-5259, -15517},  {-5260, -15517},
    {-5262, -15516},  {-5263, -15516},  {-5264, -15515},  {-5266, -15515},  {-5267, -15514},  {-5269, -15514},
    {-5270, -15513},  {-5272, -15513},  {-5273, -15512},  {-5275, -15512},  {-5276, -15511},  {-5278, -15511},
    {-5279, -15510},  {-5281, -15510},  {-5282, -15509},  {-5284, -15509},  {-5285, -15508},  {-5287, -15508},
    {-5288, -15507},  {-5290, -15507},  {-5291, -15506},  {-5293, -15506},  {-5294, -15505},  {-5296, -15505},
    {-5297, -15504},  {-5299, -15504},  {-5300, -15503},  {-5302, -15503},  {-5303, -15502},  {-5305, -15501},
    {-5306, -15501},  {-5308, -15500},  {-5309, -15500},  {-5311, -15499},  {-5312, -15499},  {-5314, -15498},
    {-5315, -15498},  {-5317, -15497},  {-5318, -15497},  {-5319, -15496},  {-5321, -15496},  {-5322, -15495},
    {-5324, -15495},  {-5325, -15494},  {-5327, -15494},  {-5328, -15493},  {-5330, -15493},  {-5331, -15492},
    {-5333, -15492},  {-5334, -15491},  {-5336, -15491},  {-5337, -15490},  {-5339, -15490},  {-5340, -15489},
    {-5342, -15489},  {-5343, -15488},  {-5345, -15488},  {-5346, -15487},  {-5348, -15487},  {-5349, -15486},
    {-5351, -15486},  {-5352, -15485},  {-5354, -15485},  {-5355, -15484},  {-5357, -15484},  {-5358, -15483},
    {-5360, -15483},  {-5361, -15482},  {-5363, -15482},  {-5364, -15481},  {-5366, -15481},  {-5367, -15480},
    {-5368, -15479},  {-5370, -15479},  {-5371, -15478},  {-5373, -15478},  {-5374, -15477},  {-5376, -15477},
    {-5377, -15476},  {-5379, -15476},  {-5380, -15475},  {-5382, -15475},  {-5383, -15474},  {-5385, -15474},
    {-5386, -15473},  {-5388, -15473},  {-5389, -15472},  {-5391, -15472},  {-5392, -15471},  {-5394, -15471},
    {-5395, -15470},  {-5397, -15470},  {-5398, -15469},  {-5400, -15469},  {-5401, -15468},  {-5403, -15468},
    {-5404, -15467},  {-5406, -15467},  {-5407, -15466},  {-5409, -15466},  {-5410, -15465},  {-5412, -15465},
    {-5413, -15464},  {-5414, -15463},  {-5416, -15463},  {-5417, -15462},  {-5419, -15462},  {-5420, -15461},
    {-5422, -15461},  {-5423, -15460},  {-5425, -15460},  {-5426, -15459},  {-5428, -15459},  {-5429, -15458},
    {-5431, -15458},  {-5432, -15457},  {-5434, -15457},  {-5435, -15456},  {-5437, -15456},  {-5438, -15455},
    {-5440, -15455},  {-5441, -15454},  {-5443, -15454},  {-5444, -15453},  {-5446, -15453},  {-5447, -15452},
    {-5449, -15451},  {-5450, -15451},  {-5452, -15450},  {-5453, -15450},  {-5454, -15449},  {-5456, -15449},
    {-5457, -15448},  {-5459, -15448},  {-5460, -15447},  {-5462, -15447},  {-5463, -15446},  {-5465, -15446},
    {-5466, -15445},  {-5468, -15445},  {-5469, -15444},  {-5471, -15444},  {-5472, -15443},  {-5474, -15443},
    {-5475, -15442},  {-5477, -15442},  {-5478, -15441},  {-5480, -15440},  {-5481, -15440},  {-5483, -15439},
    {-5484, -15439},  {-5486, -15438},  {-5487, -15438},  {-5489, -15437},  {-5490, -15437},  {-5491, -15436},
    {-5493, -15436},  {-5494, -15435},  {-5496, -15435},  {-5497, -15434},  {-5499, -15434},  {-5500, -15433},
    {-5502, -15433},  {-5503, -15432},  {-5505, -15432},  {-5506, -15431},  {-5508, -15430},  {-5509, -15430},
    {-5511, -15429},  {-5512, -15429},  {-5514, -15428},  {-5515, -15428},  {-5517, -15427},  {-5518, -15427},
    {-5520, -15426},  {-5521, -15426},  {-5523, -15425},  {-5524, -15425},  {-5526, -15424},  {-5527, -15424},
    {-5528, -15423},  {-5530, -15423},  {-5531, -15422},  {-5533, -15421},  {-5534, -15421},  {-5536, -15420},
    {-5537, -15420},  {-5539, -15419},  {-5540, -15419},  {-5542, -15418},  {-5543, -15418},  {-5545, -15417},
    {-5546, -15417},  {-5548, -15416},  {-5549, -15416},  {-5551, -15415},  {-5552, -15415},  {-5554, -15414},
    {-5555, -15414},  {-5557, -15413},  {-5558, -15412},  {-5560, -15412},  {-5561, -15411},  {-5562, -15411},
    {-5564, -15410},  {-5565, -15410},  {-5567, -15409},  {-5568, -15409},  {-5570, -15408},  {-5571, -15408},
    {-5573, -15407},  {-5574, -15407},  {-5576, -15406},  {-5577, -15406},  {-5579, -15405},  {-5580, -15404},
    {-5582, -15404},  {-5583, -15403},  {-5585, -15403},  {-5586, -15402},  {-5588, -15402},  {-5589, -15401},
    {-5591, -15401},  {-5592, -15400},  {-5593, -15400},  {-5595, -15399},  {-5596, -15399},  {-5598, -15398},
    {-5599, -15397},  {-5601, -15397},  {-5602, -15396},  {-5604, -15396},  {-5605, -15395},  {-5607, -15395},
    {-5608, -15394},  {-5610, -15394},  {-5611, -15393},  {-5613, -15393},  {-5614, -15392},  {-5616, -15392},
    {-5617, -15391},  {-5619, -15390},  {-5620, -15390},  {-5622, -15389},  {-5623, -15389},  {-5624, -15388},
    {-5626, -15388},  {-5627, -15387},  {-5629, -15387},  {-5630, -15386},  {-5632, -15386},  {-5633, -15385},
    {-5635, -15385},  {-5636, -15384},  {-5638, -15383},  {-5639, -15383},  {-5641, -15382},  {-5642, -15382},
    {-5644, -15381},  {-5645, -15381},  {-5647, -15380},  {-5648, -15380},  {-5650, -15379},  {-5651, -15379},
    {-5653, -15378},  {-5654, -15378},  {-5655, -15377},  {-5657, -15376},  {-5658, -15376},  {-5660, -15375},
    {-5661, -15375},  {-5663, -15374},  {-5664, -15374},  {-5666, -15373},  {-5667, -15373},  {-5669, -15372},
    {-5670, -15372},  {-5672, -15371},  {-5673, -15370},  {-5675, -15370},  {-5676, -15369},  {-5678, -15369},
    {-5679, -15368},  {-5681, -15368},  {-5682, -15367},  {-5683, -15367},  {-5685, -15366},  {-5686, -15366},
    {-5688, -15365},  {-5689, -15364},  {-5691, -15364},  {-5692, -15363},  {-5694, -15363},  {-5695, -15362},
    {-5697, -15362},  {-5698, -15361},  {-5700, -15361},  {-5701, -15360},  {-5703, -15360},  {-5704, -15359},
    {-5706, -15358},  {-5707, -15358},  {-5708, -15357},  {-5710, -15357},  {-5711, -15356},  {-5713, -15356},
    {-5714, -15355},  {-5716, -15355},  {-5717, -15354},  {-5719, -15354},  {-5720, -15353},  {-5722, -15352},
    {-5723, -15352},  {-5725, -15351},  {-5726, -15351},  {-5728, -15350},  {-5729, -15350},  {-5731, -15349},
    {-5732, -15349},  {-5734, -15348},  {-5735, -15347},  {-5736, -15347},  {-5738, -15346},  {-5739, -15346},
    {-5741, -15345},  {-5742, -15345},  {-5744, -15344},  {-5745, -15344},  {-5747, -15343},  {-5748, -15343},
    {-5750, -15342},  {-5751, -15341},  {-5753, -15341},  {-5754, -15340},  {-5756, -15340},  {-5757, -15339},
    {-5759, -15339},  {-5760, -15338},  {-5761, -15338},  {-5763, -15337},  {-5764, -15336},  {-5766, -15336},
    {-5767, -15335},  {-5769, -15335},  {-5770, -15334},  {-5772, -15334},  {-5773, -15333},  {-5775, -15333},
    {-5776, -15332},  {-5778, -15331},  {-5779, -15331},  {-5781, -15330},  {-5782, -15330},  {-5784, -15329},
    {-5785, -15329},  {-5786, -15328},  {-5788, -15328},  {-5789, -15327},  {-5791, -15326},  {-5792, -15326},
    {-5794, -15325},  {-5795, -15325},  {-5797, -15324},  {-5798, -15324},  {-5800, -15323},  {-5801, -15323},
    {-5803, -15322},  {-5804, -15321},  {-5806, -15321},  {-5807, -15320},  {-5808, -15320},  {-5810, -15319},
    {-5811, -15319},  {-5813, -15318},  {-5814, -15318},  {-5816, -15317},  {-5817, -15316},  {-5819, -15316},
    {-5820, -15315},  {-5822, -15315},  {-5823, -15314},  {-5825, -15314},  {-5826, -15313},  {-5828, -15313},
    {-5829, -15312},  {-5831, -15311},  {-5832, -15311},  {-5833, -15310},  {-5835, -15310},  {-5836, -15309},
    {-5838, -15309},  {-5839, -15308},  {-5841, -15308},  {-5842, -15307},  {-5844, -15306},  {-5845, -15306},
    {-5847, -15305},  {-5848, -15305},  {-5850, -15304},  {-5851, -15304},  {-5853, -15303},  {-5854, -15302},
    {-5855, -15302},  {-5857, -15301},  {-5858, -15301},  {-5860, -15300},  {-5861, -15300},  {-5863, -15299},
    {-5864, -15299},  {-5866, -15298},  {-5867, -15297},  {-5869, -15297},  {-5870, -15296},  {-5872, -15296},
    {-5873, -15295},  {-5875, -15295},  {-5876, -15294},  {-5877, -15293},  {-5879, -15293},  {-5880, -15292},
    {-5882, -15292},  {-5883, -15291},  {-5885, -15291},  {-5886, -15290},  {-5888, -15290},  {-5889, -15289},
    {-5891, -15288},  {-5892, -15288},  {-5894, -15287},  {-5895, -15287},  {-5897, -15286},  {-5898, -15286},
    {-5899, -15285},  {-5901, -15284},  {-5902, -15284},  {-5904, -15283},  {-5905, -15283},  {-5907, -15282},
    {-5908, -15282},  {-5910, -15281},  {-5911, -15280},  {-5913, -15280},  {-5914, -15279},  {-5916, -15279},
    {-5917, -15278},  {-5918, -15278},  {-5920, -15277},  {-5921, -15277},  {-5923, -15276},  {-5924, -15275},
    {-5926, -15275},  {-5927, -15274},  {-5929, -15274},  {-5930, -15273},  {-5932, -15273},  {-5933, -15272},
    {-5935, -15271},  {-5936, -15271},  {-5938, -15270},  {-5939, -15270},  {-5940, -15269},  {-5942, -15269},
    {-5943, -15268},  {-5945, -15267},  {-5946, -15267},  {-5948, -15266},  {-5949, -15266},  {-5951, -15265},
    {-5952, -15265},  {-5954, -15264},  {-5955, -15263},  {-5957, -15263},  {-5958, -15262},  {-5959, -15262},
    {-5961, -15261},  {-5962, -15261},  {-5964, -15260},  {-5965, -15259},  {-5967, -15259},  {-5968, -15258},
    {-5970, -15258},  {-5971, -15257},  {-5973, -15257},  {-5974, -15256},  {-5976, -15255},  {-5977, -15255},
    {-5979, -15254},  {-5980, -15254},  {-5981, -15253},  {-5983, -15253},  {-5984, -15252},  {-5986, -15251},
    {-5987, -15251},  {-5989, -15250},  {-5990, -15250},  {-5992, -15249},  {-5993, -15249},  {-5995, -15248},
    {-5996, -15247},  {-5998, -15247},  {-5999, -15246},  {-6000, -15246},  {-6002, -15245},  {-6003, -15245},
    {-6005, -15244},  {-6006, -15243},  {-6008, -15243},  {-6009, -15242},  {-6011, -15242},  {-6012, -15241},
    {-6014, -15240},  {-6015, -15240},  {-6017, -15239},  {-6018, -15239},  {-6019, -15238},  {-6021, -15238},
    {-6022, -15237},  {-6024, -15236},  {-6025, -15236},  {-6027, -15235},  {-6028, -15235},  {-6030, -15234},
    {-6031, -15234},  {-6033, -15233},  {-6034, -15232},  {-6036, -15232},  {-6037, -15231},  {-6038, -15231},
    {-6040, -15230},  {-6041, -15229},  {-6043, -15229},  {-6044, -15228},  {-6046, -15228},  {-6047, -15227},
    {-6049, -15227},  {-6050, -15226},  {-6052, -15225},  {-6053, -15225},  {-6054, -15224},  {-6056, -15224},
    {-6057, -15223},  {-6059, -15223},  {-6060, -15222},  {-6062, -15221},  {-6063, -15221},  {-6065, -15220},
    {-6066, -15220},  {-6068, -15219},  {-6069, -15218},  {-6071, -15218},  {-6072, -15217},  {-6073, -15217},
    {-6075, -15216},  {-6076, -15216},  {-6078, -15215},  {-6079, -15214},  {-6081, -15214},  {-6082, -15213},
    {-6084, -15213},  {-6085, -15212},  {-6087, -15211},  {-6088, -15211},  {-6089, -15210},  {-6091, -15210},
    {-6092, -15209},  {-6094, -15209},  {-6095, -15208},  {-6097, -15207},  {-6098, -15207},  {-6100, -15206},
    {-6101, -15206},  {-6103, -15205},  {-6104, -15204},  {-6106, -15204},  {-6107, -15203},  {-6108, -15203},
    {-6110, -15202},  {-6111, -15202},  {-6113, -15201},  {-6114, -15200},  {-6116, -15200},  {-6117, -15199},
    {-6119, -15199},  {-6120, -15198},  {-6122, -15197},  {-6123, -15197},  {-6124, -15196},  {-6126, -15196},
    {-6127, -15195},  {-6129, -15194},  {-6130, -15194},  {-6132, -15193},  {-6133, -15193},  {-6135, -15192},
    {-6136, -15192},  {-6138, -15191},  {-6139, -15190},  {-6140, -15190},  {-6142, -15189},  {-6143, -15189},
    {-6145, -15188},  {-6146, -15187},  {-6148, -15187},  {-6149, -15186},  {-6151, -15186},  {-6152, -15185},
    {-6154, -15184},  {-6155, -15184},  {-6157, -15183},  {-6158, -15183},  {-6159, -15182},  {-6161, -15182},
    {-6162, -15181},  {-6164, -15180},  {-6165, -15180},  {-6167, -15179},  {-6168, -15179},  {-6170, -15178},
    {-6171, -15177},  {-6173, -15177},  {-6174, -15176},  {-6175, -15176},  {-6177, -15175},  {-6178, -15174},
    {-6180, -15174},  {-6181, -15173},  {-6183, -15173},  {-6184, -15172},  {-6186, -15171},  {-6187, -15171},
    {-6189, -15170},  {-6190, -15170},  {-6191, -15169},  {-6193, -15169},  {-6194, -15168},  {-6196, -15167},
    {-6197, -15167},  {-6199, -15166},  {-6200, -15166},  {-6202, -15165},  {-6203, -15164},  {-6205, -15164},
    {-6206, -15163},  {-6207, -15163},  {-6209, -15162},  {-6210, -15161},  {-6212, -15161},  {-6213, -15160},
    {-6215, -15160},  {-6216, -15159},  {-6218, -15158},  {-6219, -15158},  {-6221, -15157},  {-6222, -15157},
    {-6223, -15156},  {-6225, -15155},  {-6226, -15155},  {-6228, -15154},  {-6229, -15154},  {-6231, -15153},
    {-6232, -15152},  {-6234, -15152},  {-6235, -15151},  {-6236, -15151},  {-6238, -15150},  {-6239, -15149},
    {-6241, -15149},  {-6242, -15148},  {-6244, -15148},  {-6245, -15147},  {-6247, -15146},  {-6248, -15146},
    {-6250, -15145},  {-6251, -15145},  {-6252, -15144},  {-6254, -15143},  {-6255, -15143},  {-6257, -15142},
    {-6258, -15142},  {-6260, -15141},  {-6261, -15140},  {-6263, -15140},  {-6264, -15139},  {-6266, -15139},
    {-6267, -15138},  {-6268, -15137},  {-6270, -15137},  {-6271, -15136},  {-6273, -15136},  {-6274, -15135},
    {-6276, -15134},  {-6277, -15134},  {-6279, -15133},  {-6280, -15133},  {-6281, -15132},  {-6283, -15131},
    {-6284, -15131},  {-6286, -15130},  {-6287, -15130},  {-6289, -15129},  {-6290, -15128},  {-6292, -15128},
    {-6293, -15127},  {-6295, -15127},  {-6296, -15126},  {-6297, -15125},  {-6299, -15125},  {-6300, -15124},
    {-6302, -15124},  {-6303, -15123},  {-6305, -15122},  {-6306, -15122},  {-6308, -15121},  {-6309, -15121},
    {-6310, -15120},  {-6312, -15119},  {-6313, -15119},  {-6315, -15118},  {-6316, -15118},  {-6318, -15117},
    {-6319, -15116},  {-6321, -15116},  {-6322, -15115},  {-6324, -15115},  {-6325, -15114},  {-6326, -15113},
    {-6328, -15113},  {-6329, -15112},  {-6331, -15111},  {-6332, -15111},  {-6334, -15110},  {-6335, -15110},
    {-6337, -15109},  {-6338, -15108},  {-6339, -15108},  {-6341, -15107},  {-6342, -15107},  {-6344, -15106},
    {-6345, -15105},  {-6347, -15105},  {-6348, -15104},  {-6350, -15104},  {-6351, -15103},  {-6353, -15102},
    {-6354, -15102},  {-6355, -15101},  {-6357, -15101},  {-6358, -15100},  {-6360, -15099},  {-6361, -15099},
    {-6363, -15098},  {-6364, -15097},  {-6366, -15097},  {-6367, -15096},  {-6368, -15096},  {-6370, -15095},
    {-6371, -15094},  {-6373, -15094},  {-6374, -15093},  {-6376, -15093},  {-6377, -15092},  {-6379, -15091},
    {-6380, -15091},  {-6381, -15090},  {-6383, -15090},  {-6384, -15089},  {-6386, -15088},  {-6387, -15088},
    {-6389, -15087},  {-6390, -15086},  {-6392, -15086},  {-6393, -15085},  {-6394, -15085},  {-6396, -15084},
    {-6397, -15083},  {-6399, -15083},  {-6400, -15082},  {-6402, -15082},  {-6403, -15081},  {-6405, -15080},
    {-6406, -15080},  {-6407, -15079},  {-6409, -15078},  {-6410, -15078},  {-6412, -15077},  {-6413, -15077},
    {-6415, -15076},  {-6416, -15075},  {-6418, -15075},  {-6419, -15074},  {-6420, -15074},  {-6422, -15073},
    {-6423, -15072},  {-6425, -15072},  {-6426, -15071},  {-6428, -15070},  {-6429, -15070},  {-6431, -15069},
    {-6432, -15069},  {-6434, -15068},  {-6435, -15067},  {-6436, -15067},  {-6438, -15066},  {-6439, -15066},
    {-6441, -15065},  {-6442, -15064},  {-6444, -15064},  {-6445, -15063},  {-6447, -15062},  {-6448, -15062},
    {-6449, -15061},  {-6451, -15061},  {-6452, -15060},  {-6454, -15059},  {-6455, -15059},  {-6457, -15058},
    {-6458, -15058},  {-6459, -15057},  {-6461, -15056},  {-6462, -15056},  {-6464, -15055},  {-6465, -15054},
    {-6467, -15054},  {-6468, -15053},  {-6470, -15053},  {-6471, -15052},  {-6472, -15051},  {-6474, -15051},
    {-6475, -15050},  {-6477, -15049},  {-6478, -15049},  {-6480, -15048},  {-6481, -15048},  {-6483, -15047},
    {-6484, -15046},  {-6485, -15046},  {-6487, -15045},  {-6488, -15044},  {-6490, -15044},  {-6491, -15043},
    {-6493, -15043},  {-6494, -15042},  {-6496, -15041},  {-6497, -15041},  {-6498, -15040},  {-6500, -15040},
    {-6501, -15039},  {-6503, -15038},  {-6504, -15038},  {-6506, -15037},  {-6507, -15036},  {-6509, -15036},
    {-6510, -15035},  {-6511, -15035},  {-6513, -15034},  {-6514, -15033},  {-6516, -15033},  {-6517, -15032},
    {-6519, -15031},  {-6520, -15031},  {-6522, -15030},  {-6523, -15030},  {-6524, -15029},  {-6526, -15028},
    {-6527, -15028},  {-6529, -15027},  {-6530, -15026},  {-6532, -15026},  {-6533, -15025},  {-6534, -15025},
    {-6536, -15024},  {-6537, -15023},  {-6539, -15023},  {-6540, -15022},  {-6542, -15021},  {-6543, -15021},
    {-6545, -15020},  {-6546, -15019},  {-6547, -15019},  {-6549, -15018},  {-6550, -15018},  {-6552, -15017},
    {-6553, -15016},  {-6555, -15016},  {-6556, -15015},  {-6558, -15014},  {-6559, -15014},  {-6560, -15013},
    {-6562, -15013},  {-6563, -15012},  {-6565, -15011},  {-6566, -15011},  {-6568, -15010},  {-6569, -15009},
    {-6570, -15009},  {-6572, -15008},  {-6573, -15008},  {-6575, -15007},  {-6576, -15006},  {-6578, -15006},
    {-6579, -15005},  {-6581, -15004},  {-6582, -15004},  {-6583, -15003},  {-6585, -15003},  {-6586, -15002},
    {-6588, -15001},  {-6589, -15001},  {-6591, -15000},  {-6592, -14999},  {-6593, -14999},  {-6595, -14998},
    {-6596, -14997},  {-6598, -14997},  {-6599, -14996},  {-6601, -14996},  {-6602, -14995},  {-6604, -14994},
    {-6605, -14994},  {-6606, -14993},  {-6608, -14992},  {-6609, -14992},  {-6611, -14991},  {-6612, -14990},
    {-6614, -14990},  {-6615, -14989},  {-6616, -14989},  {-6618, -14988},  {-6619, -14987},  {-6621, -14987},
    {-6622, -14986},  {-6624, -14985},  {-6625, -14985},  {-6627, -14984},  {-6628, -14984},  {-6629, -14983},
    {-6631, -14982},  {-6632, -14982},  {-6634, -14981},  {-6635, -14980},  {-6637, -14980},  {-6638, -14979},
    {-6639, -14978},  {-6641, -14978},  {-6642, -14977},  {-6644, -14977},  {-6645, -14976},  {-6647, -14975},
    {-6648, -14975},  {-6650, -14974},  {-6651, -14973},  {-6652, -14973},  {-6654, -14972},  {-6655, -14971},
    {-6657, -14971},  {-6658, -14970},  {-6660, -14969},  {-6661, -14969},  {-6662, -14968},  {-6664, -14968},
    {-6665, -14967},  {-6667, -14966},  {-6668, -14966},  {-6670, -14965},  {-6671, -14964},  {-6672, -14964},
    {-6674, -14963},  {-6675, -14962},  {-6677, -14962},  {-6678, -14961},  {-6680, -14961},  {-6681, -14960},
    {-6683, -14959},  {-6684, -14959},  {-6685, -14958},  {-6687, -14957},  {-6688, -14957},  {-6690, -14956},
    {-6691, -14955},  {-6693, -14955},  {-6694, -14954},  {-6695, -14953},  {-6697, -14953},  {-6698, -14952},
    {-6700, -14952},  {-6701, -14951},  {-6703, -14950},  {-6704, -14950},  {-6705, -14949},  {-6707, -14948},
    {-6708, -14948},  {-6710, -14947},  {-6711, -14946},  {-6713, -14946},  {-6714, -14945},  {-6715, -14944},
    {-6717, -14944},  {-6718, -14943},  {-6720, -14943},  {-6721, -14942},  {-6723, -14941},  {-6724, -14941},
    {-6726, -14940},  {-6727, -14939},  {-6728, -14939},  {-6730, -14938},  {-6731, -14937},  {-6733, -14937},
    {-6734, -14936},  {-6736, -14935},  {-6737, -14935},  {-6738, -14934},  {-6740, -14934},  {-6741, -14933},
    {-6743, -14932},  {-6744, -14932},  {-6746, -14931},  {-6747, -14930},  {-6748, -14930},  {-6750, -14929},
    {-6751, -14928},  {-6753, -14928},  {-6754, -14927},  {-6756, -14926},  {-6757, -14926},  {-6758, -14925},
    {-6760, -14924},  {-6761, -14924},  {-6763, -14923},  {-6764, -14923},  {-6766, -14922},  {-6767, -14921},
    {-6768, -14921},  {-6770, -14920},  {-6771, -14919},  {-6773, -14919},  {-6774, -14918},  {-6776, -14917},
    {-6777, -14917},  {-6778, -14916},  {-6780, -14915},  {-6781, -14915},  {-6783, -14914},  {-6784, -14913},
    {-6786, -14913},  {-6787, -14912},  {-6788, -14911},  {-6790, -14911},  {-6791, -14910},  {-6793, -14910},
    {-6794, -14909},  {-6796, -14908},  {-6797, -14908},  {-6798, -14907},  {-6800, -14906},  {-6801, -14906},
    {-6803, -14905},  {-6804, -14904},  {-6806, -14904},  {-6807, -14903},  {-6808, -14902},  {-6810, -14902},
    {-6811, -14901},  {-6813, -14900},  {-6814, -14900},  {-6816, -14899},  {-6817, -14898},  {-6818, -14898},
    {-6820, -14897},  {-6821, -14896},  {-6823, -14896},  {-6824, -14895},  {-6826, -14894},  {-6827, -14894},
    {-6828, -14893},  {-6830, -14893},  {-6831, -14892},  {-6833, -14891},  {-6834, -14891},  {-6836, -14890},
    {-6837, -14889},  {-6838, -14889},  {-6840, -14888},  {-6841, -14887},  {-6843, -14887},  {-6844, -14886},
    {-6846, -14885},  {-6847, -14885},  {-6848, -14884},  {-6850, -14883},  {-6851, -14883},  {-6853, -14882},
    {-6854, -14881},  {-6856, -14881},  {-6857, -14880},  {-6858, -14879},  {-6860, -14879},  {-6861, -14878},
    {-6863, -14877},  {-6864, -14877},  {-6866, -14876},  {-6867, -14875},  {-6868, -14875},  {-6870, -14874},
    {-6871, -14873},  {-6873, -14873},  {-6874, -14872},  {-6876, -14872},  {-6877, -14871},  {-6878, -14870},
    {-6880, -14870},  {-6881, -14869},  {-6883, -14868},  {-6884, -14868},  {-6886, -14867},  {-6887, -14866},
    {-6888, -14866},  {-6890, -14865},  {-6891, -14864},  {-6893, -14864},  {-6894, -14863},  {-6896, -14862},
    {-6897, -14862},  {-6898, -14861},  {-6900, -14860},  {-6901, -14860},  {-6903, -14859},  {-6904, -14858},
    {-6906, -14858},  {-6907, -14857},  {-6908, -14856},  {-6910, -14856},  {-6911, -14855},  {-6913, -14854},
    {-6914, -14854},  {-6915, -14853},  {-6917, -14852},  {-6918, -14852},  {-6920, -14851},  {-6921, -14850},
    {-6923, -14850},  {-6924, -14849},  {-6925, -14848},  {-6927, -14848},  {-6928, -14847},  {-6930, -14846},
    {-6931, -14846},  {-6933, -14845},  {-6934, -14844},  {-6935, -14844},  {-6937, -14843},  {-6938, -14842},
    {-6940, -14842},  {-6941, -14841},  {-6943, -14840},  {-6944, -14840},  {-6945, -14839},  {-6947, -14838},
    {-6948, -14838},  {-6950, -14837},  {-6951, -14836},  {-6952, -14836},  {-6954, -14835},  {-6955, -14834},
    {-6957, -14834},  {-6958, -14833},  {-6960, -14832},  {-6961, -14832},  {-6962, -14831},  {-6964, -14830},
    {-6965, -14830},  {-6967, -14829},  {-6968, -14828},  {-6970, -14828},  {-6971, -14827},  {-6972, -14826},
    {-6974, -14826},  {-6975, -14825},  {-6977, -14824},  {-6978, -14824},  {-6979, -14823},  {-6981, -14822},
    {-6982, -14822},  {-6984, -14821},  {-6985, -14820},  {-6987, -14820},  {-6988, -14819},  {-6989, -14818},
    {-6991, -14818},  {-6992, -14817},  {-6994, -14816},  {-6995, -14816},  {-6997, -14815},  {-6998, -14814},
    {-6999, -14814},  {-7001, -14813},  {-7002, -14812},  {-7004, -14812},  {-7005, -14811},  {-7006, -14810},
    {-7008, -14810},  {-7009, -14809},  {-7011, -14808},  {-7012, -14808},  {-7014, -14807},  {-7015, -14806},
    {-7016, -14806},  {-7018, -14805},  {-7019, -14804},  {-7021, -14804},  {-7022, -14803},  {-7024, -14802},
    {-7025, -14802},  {-7026, -14801},  {-7028, -14800},  {-7029, -14800},  {-7031, -14799},  {-7032, -14798},
    {-7033, -14798},  {-7035, -14797},  {-7036, -14796},  {-7038, -14795},  {-7039, -14795},  {-7041, -14794},
    {-7042, -14793},  {-7043, -14793},  {-7045, -14792},  {-7046, -14791},  {-7048, -14791},  {-7049, -14790},
    {-7050, -14789},  {-7052, -14789},  {-7053, -14788},  {-7055, -14787},  {-7056, -14787},  {-7058, -14786},
    {-7059, -14785},  {-7060, -14785},  {-7062, -14784},  {-7063, -14783},  {-7065, -14783},  {-7066, -14782},
    {-7067, -14781},  {-7069, -14781},  {-7070, -14780},  {-7072, -14779},  {-7073, -14779},  {-7075, -14778},
    {-7076, -14777},  {-7077, -14777},  {-7079, -14776},  {-7080, -14775},  {-7082, -14774},  {-7083, -14774},
    {-7084, -14773},  {-7086, -14772},  {-7087, -14772},  {-7089, -14771},  {-7090, -14770},  {-7092, -14770},
    {-7093, -14769},  {-7094, -14768},  {-7096, -14768},  {-7097, -14767},  {-7099, -14766},  {-7100, -14766},
    {-7101, -14765},  {-7103, -14764},  {-7104, -14764},  {-7106, -14763},  {-7107, -14762},  {-7109, -14762},
    {-7110, -14761},  {-7111, -14760},  {-7113, -14760},  {-7114, -14759},  {-7116, -14758},  {-7117, -14757},
    {-7118, -14757},  {-7120, -14756},  {-7121, -14755},  {-7123, -14755},  {-7124, -14754},  {-7126, -14753},
    {-7127, -14753},  {-7128, -14752},  {-7130, -14751},  {-7131, -14751},  {-7133, -14750},  {-7134, -14749},
    {-7135, -14749},  {-7137, -14748},  {-7138, -14747},  {-7140, -14747},  {-7141, -14746},  {-7142, -14745},
    {-7144, -14744},  {-7145, -14744},  {-7147, -14743},  {-7148, -14742},  {-7150, -14742},  {-7151, -14741},
    {-7152, -14740},  {-7154, -14740},  {-7155, -14739},  {-7157, -14738},  {-7158, -14738},  {-7159, -14737},
    {-7161, -14736},  {-7162, -14736},  {-7164, -14735},  {-7165, -14734},  {-7167, -14734},  {-7168, -14733},
    {-7169, -14732},  {-7171, -14731},  {-7172, -14731},  {-7174, -14730},  {-7175, -14729},  {-7176, -14729},
    {-7178, -14728},  {-7179, -14727},  {-7181, -14727},  {-7182, -14726},  {-7183, -14725},  {-7185, -14725},
    {-7186, -14724},  {-7188, -14723},  {-7189, -14723},  {-7191, -14722},  {-7192, -14721},  {-7193, -14720},
    {-7195, -14720},  {-7196, -14719},  {-7198, -14718},  {-7199, -14718},  {-7200, -14717},  {-7202, -14716},
    {-7203, -14716},  {-7205, -14715},  {-7206, -14714},  {-7207, -14714},  {-7209, -14713},  {-7210, -14712},
    {-7212, -14711},  {-7213, -14711},  {-7215, -14710},  {-7216, -14709},  {-7217, -14709},  {-7219, -14708},
    {-7220, -14707},  {-7222, -14707},  {-7223, -14706},  {-7224, -14705},  {-7226, -14705},  {-7227, -14704},
    {-7229, -14703},  {-7230, -14702},  {-7231, -14702},  {-7233, -14701},  {-7234, -14700},  {-7236, -14700},
    {-7237, -14699},  {-7238, -14698},  {-7240, -14698},  {-7241, -14697},  {-7243, -14696},  {-7244, -14696},
    {-7246, -14695},  {-7247, -14694},  {-7248, -14693},  {-7250, -14693},  {-7251, -14692},  {-7253, -14691},
    {-7254, -14691},  {-7255, -14690},  {-7257, -14689},  {-7258, -14689},  {-7260, -14688},  {-7261, -14687},
    {-7262, -14686},  {-7264, -14686},  {-7265, -14685},  {-7267, -14684},  {-7268, -14684},  {-7269, -14683},
    {-7271, -14682},  {-7272, -14682},  {-7274, -14681},  {-7275, -14680},  {-7276, -14680},  {-7278, -14679},
    {-7279, -14678},  {-7281, -14677},  {-7282, -14677},  {-7284, -14676},  {-7285, -14675},  {-7286, -14675},
    {-7288, -14674},  {-7289, -14673},  {-7291, -14673},  {-7292, -14672},  {-7293, -14671},  {-7295, -14670},
    {-7296, -14670},  {-7298, -14669},  {-7299, -14668},  {-7300, -14668},  {-7302, -14667},  {-7303, -14666},
    {-7305, -14666},  {-7306, -14665},  {-7307, -14664},  {-7309, -14663},  {-7310, -14663},  {-7312, -14662},
    {-7313, -14661},  {-7314, -14661},  {-7316, -14660},  {-7317, -14659},  {-7319, -14659},  {-7320, -14658},
    {-7321, -14657},  {-7323, -14656},  {-7324, -14656},  {-7326, -14655},  {-7327, -14654},  {-7329, -14654},
    {-7330, -14653},  {-7331, -14652},  {-7333, -14651},  {-7334, -14651},  {-7336, -14650},  {-7337, -14649},
    {-7338, -14649},  {-7340, -14648},  {-7341, -14647},  {-7343, -14647},  {-7344, -14646},  {-7345, -14645},
    {-7347, -14644},  {-7348, -14644},  {-7350, -14643},  {-7351, -14642},  {-7352, -14642},  {-7354, -14641},
    {-7355, -14640},  {-7357, -14640},  {-7358, -14639},  {-7359, -14638},  {-7361, -14637},  {-7362, -14637},
    {-7364, -14636},  {-7365, -14635},  {-7366, -14635},  {-7368, -14634},  {-7369, -14633},  {-7371, -14632},
    {-7372, -14632},  {-7373, -14631},  {-7375, -14630},  {-7376, -14630},  {-7378, -14629},  {-7379, -14628},
    {-7380, -14628},  {-7382, -14627},  {-7383, -14626},  {-7385, -14625},  {-7386, -14625},  {-7387, -14624},
    {-7389, -14623},  {-7390, -14623},  {-7392, -14622},  {-7393, -14621},  {-7394, -14620},  {-7396, -14620},
    {-7397, -14619},  {-7399, -14618},  {-7400, -14618},  {-7401, -14617},  {-7403, -14616},  {-7404, -14615},
    {-7406, -14615},  {-7407, -14614},  {-7408, -14613},  {-7410, -14613},  {-7411, -14612},  {-7413, -14611},
    {-7414, -14610},  {-7415, -14610},  {-7417, -14609},  {-7418, -14608},  {-7420, -14608},  {-7421, -14607},
    {-7423, -14606},  {-7424, -14606},  {-7425, -14605},  {-7427, -14604},  {-7428, -14603},  {-7430, -14603},
    {-7431, -14602},  {-7432, -14601},  {-7434, -14601},  {-7435, -14600},  {-7437, -14599},  {-7438, -14598},
    {-7439, -14598},  {-7441, -14597},  {-7442, -14596},  {-7443, -14596},  {-7445, -14595},  {-7446, -14594},
    {-7448, -14593},  {-7449, -14593},  {-7450, -14592},  {-7452, -14591},  {-7453, -14591},  {-7455, -14590},
    {-7456, -14589},  {-7457, -14588},  {-7459, -14588},  {-7460, -14587},  {-7462, -14586},  {-7463, -14586},
    {-7464, -14585},  {-7466, -14584},  {-7467, -14583},  {-7469, -14583},  {-7470, -14582},  {-7471, -14581},
    {-7473, -14581},  {-7474, -14580},  {-7476, -14579},  {-7477, -14578},  {-7478, -14578},  {-7480, -14577},
    {-7481, -14576},  {-7483, -14576},  {-7484, -14575},  {-7485, -14574},  {-7487, -14573},  {-7488, -14573},
    {-7490, -14572},  {-7491, -14571},  {-7492, -14570},  {-7494, -14570},  {-7495, -14569},  {-7497, -14568},
    {-7498, -14568},  {-7499, -14567},  {-7501, -14566},  {-7502, -1