/*
 * Copyright (C) 2019-2022, Xilinx, Inc.
 * Copyright (C) 2022-2025, Advanced Micro Devices, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __FFT_TWIDDLE_LUT_DIT_H__
#define __FFT_TWIDDLE_LUT_DIT_H__

#include "fft_com_inc.h"

/* LUTs for 4096pt FFT/IFFT */
alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw2048[FFT_2048] = {
    {32767, 0},       {32767, -50},     {32767, -101},    {32767, -151},    {32767, -201},    {32767, -251},
    {32767, -302},    {32766, -352},    {32766, -402},    {32765, -452},    {32764, -503},    {32763, -553},
    {32762, -603},    {32761, -653},    {32760, -704},    {32759, -754},    {32758, -804},    {32757, -854},
    {32756, -905},    {32754, -955},    {32753, -1005},   {32751, -1055},   {32749, -1106},   {32748, -1156},
    {32746, -1206},   {32744, -1256},   {32742, -1307},   {32740, -1357},   {32738, -1407},   {32736, -1457},
    {32733, -1507},   {32731, -1558},   {32729, -1608},   {32726, -1658},   {32723, -1708},   {32721, -1758},
    {32718, -1809},   {32715, -1859},   {32712, -1909},   {32709, -1959},   {32706, -2009},   {32703, -2060},
    {32700, -2110},   {32697, -2160},   {32693, -2210},   {32690, -2260},   {32686, -2310},   {32683, -2360},
    {32679, -2411},   {32675, -2461},   {32672, -2511},   {32668, -2561},   {32664, -2611},   {32660, -2661},
    {32656, -2711},   {32651, -2761},   {32647, -2811},   {32643, -2861},   {32638, -2912},   {32634, -2962},
    {32629, -3012},   {32625, -3062},   {32620, -3112},   {32615, -3162},   {32610, -3212},   {32605, -3262},
    {32600, -3312},   {32595, -3362},   {32590, -3412},   {32585, -3462},   {32579, -3512},   {32574, -3562},
    {32568, -3612},   {32563, -3662},   {32557, -3712},   {32551, -3762},   {32546, -3812},   {32540, -3861},
    {32534, -3911},   {32528, -3961},   {32522, -4011},   {32515, -4061},   {32509, -4111},   {32503, -4161},
    {32496, -4211},   {32490, -4260},   {32483, -4310},   {32477, -4360},   {32470, -4410},   {32463, -4460},
    {32456, -4510},   {32449, -4559},   {32442, -4609},   {32435, -4659},   {32428, -4709},   {32421, -4758},
    {32413, -4808},   {32406, -4858},   {32398, -4907},   {32391, -4957},   {32383, -5007},   {32376, -5057},
    {32368, -5106},   {32360, -5156},   {32352, -5205},   {32344, -5255},   {32336, -5305},   {32328, -5354},
    {32319, -5404},   {32311, -5453},   {32303, -5503},   {32294, -5553},   {32286, -5602},   {32277, -5652},
    {32268, -5701},   {32259, -5751},   {32251, -5800},   {32242, -5850},   {32233, -5899},   {32224, -5948},
    {32214, -5998},   {32205, -6047},   {32196, -6097},   {32186, -6146},   {32177, -6195},   {32167, -6245},
    {32158, -6294},   {32148, -6343},   {32138, -6393},   {32129, -6442},   {32119, -6491},   {32109, -6541},
    {32099, -6590},   {32088, -6639},   {32078, -6688},   {32068, -6737},   {32058, -6787},   {32047, -6836},
    {32037, -6885},   {32026, -6934},   {32015, -6983},   {32005, -7032},   {31994, -7081},   {31983, -7130},
    {31972, -7180},   {31961, -7229},   {31950, -7278},   {31938, -7327},   {31927, -7376},   {31916, -7425},
    {31904, -7473},   {31893, -7522},   {31881, -7571},   {31870, -7620},   {31858, -7669},   {31846, -7718},
    {31834, -7767},   {31822, -7816},   {31810, -7864},   {31798, -7913},   {31786, -7962},   {31774, -8011},
    {31761, -8059},   {31749, -8108},   {31737, -8157},   {31724, -8206},   {31711, -8254},   {31699, -8303},
    {31686, -8351},   {31673, -8400},   {31660, -8449},   {31647, -8497},   {31634, -8546},   {31621, -8594},
    {31608, -8643},   {31594, -8691},   {31581, -8740},   {31568, -8788},   {31554, -8836},   {31540, -8885},
    {31527, -8933},   {31513, -8982},   {31499, -9030},   {31485, -9078},   {31471, -9127},   {31457, -9175},
    {31443, -9223},   {31429, -9271},   {31415, -9319},   {31400, -9368},   {31386, -9416},   {31372, -9464},
    {31357, -9512},   {31342, -9560},   {31328, -9608},   {31313, -9656},   {31298, -9704},   {31283, -9752},
    {31268, -9800},   {31253, -9848},   {31238, -9896},   {31223, -9944},   {31207, -9992},   {31192, -10040},
    {31177, -10088},  {31161, -10135},  {31146, -10183},  {31130, -10231},  {31114, -10279},  {31098, -10326},
    {31082, -10374},  {31067, -10422},  {31050, -10469},  {31034, -10517},  {31018, -10565},  {31002, -10612},
    {30986, -10660},  {30969, -10707},  {30953, -10755},  {30936, -10802},  {30920, -10850},  {30903, -10897},
    {30886, -10945},  {30869, -10992},  {30853, -11039},  {30836, -11087},  {30819, -11134},  {30801, -11181},
    {30784, -11228},  {30767, -11276},  {30750, -11323},  {30732, -11370},  {30715, -11417},  {30697, -11464},
    {30680, -11511},  {30662, -11558},  {30644, -11605},  {30626, -11652},  {30608, -11699},  {30590, -11746},
    {30572, -11793},  {30554, -11840},  {30536, -11887},  {30518, -11934},  {30499, -11980},  {30481, -12027},
    {30462, -12074},  {30444, -12121},  {30425, -12167},  {30407, -12214},  {30388, -12261},  {30369, -12307},
    {30350, -12354},  {30331, -12400},  {30312, -12447},  {30293, -12493},  {30274, -12540},  {30254, -12586},
    {30235, -12633},  {30216, -12679},  {30196, -12725},  {30177, -12772},  {30157, -12818},  {30137, -12864},
    {30118, -12910},  {30098, -12957},  {30078, -13003},  {30058, -13049},  {30038, -13095},  {30018, -13141},
    {29997, -13187},  {29977, -13233},  {29957, -13279},  {29936, -13325},  {29916, -13371},  {29895, -13417},
    {29875, -13463},  {29854, -13508},  {29833, -13554},  {29813, -13600},  {29792, -13646},  {29771, -13691},
    {29750, -13737},  {29729, -13783},  {29707, -13828},  {29686, -13874},  {29665, -13919},  {29643, -13965},
    {29622, -14010},  {29600, -14056},  {29579, -14101},  {29557, -14146},  {29535, -14192},  {29514, -14237},
    {29492, -14282},  {29470, -14327},  {29448, -14373},  {29426, -14418},  {29404, -14463},  {29381, -14508},
    {29359, -14553},  {29337, -14598},  {29314, -14643},  {29292, -14688},  {29269, -14733},  {29247, -14778},
    {29224, -14823},  {29201, -14867},  {29178, -14912},  {29155, -14957},  {29132, -15002},  {29109, -15046},
    {29086, -15091},  {29063, -15136},  {29040, -15180},  {29016, -15225},  {28993, -15269},  {28970, -15314},
    {28946, -15358},  {28922, -15402},  {28899, -15447},  {28875, -15491},  {28851, -15535},  {28827, -15580},
    {28803, -15624},  {28779, -15668},  {28755, -15712},  {28731, -15756},  {28707, -15800},  {28683, -15844},
    {28658, -15888},  {28634, -15932},  {28610, -15976},  {28585, -16020},  {28560, -16064},  {28536, -16108},
    {28511, -16151},  {28486, -16195},  {28461, -16239},  {28436, -16282},  {28411, -16326},  {28386, -16369},
    {28361, -16413},  {28336, -16456},  {28311, -16500},  {28285, -16543},  {28260, -16587},  {28234, -16630},
    {28209, -16673},  {28183, -16717},  {28158, -16760},  {28132, -16803},  {28106, -16846},  {28080, -16889},
    {28054, -16932},  {28028, -16975},  {28002, -17018},  {27976, -17061},  {27950, -17104},  {27924, -17147},
    {27897, -17190},  {27871, -17233},  {27844, -17275},  {27818, -17318},  {27791, -17361},  {27765, -17403},
    {27738, -17446},  {27711, -17488},  {27684, -17531},  {27657, -17573},  {27630, -17616},  {27603, -17658},
    {27576, -17700},  {27549, -17743},  {27522, -17785},  {27494, -17827},  {27467, -17869},  {27440, -17911},
    {27412, -17953},  {27384, -17995},  {27357, -18037},  {27329, -18079},  {27301, -18121},  {27273, -18163},
    {27246, -18205},  {27218, -18247},  {27190, -18288},  {27162, -18330},  {27133, -18372},  {27105, -18413},
    {27077, -18455},  {27049, -18496},  {27020, -18538},  {26992, -18579},  {26963, -18621},  {26935, -18662},
    {26906, -18703},  {26877, -18745},  {26848, -18786},  {26820, -18827},  {26791, -18868},  {26762, -18909},
    {26733, -18950},  {26704, -18991},  {26674, -19032},  {26645, -19073},  {26616, -19114},  {26586, -19155},
    {26557, -19195},  {26528, -19236},  {26498, -19277},  {26468, -19317},  {26439, -19358},  {26409, -19399},
    {26379, -19439},  {26349, -19479},  {26320, -19520},  {26290, -19560},  {26259, -19601},  {26229, -19641},
    {26199, -19681},  {26169, -19721},  {26139, -19761},  {26108, -19801},  {26078, -19841},  {26048, -19881},
    {26017, -19921},  {25986, -19961},  {25956, -20001},  {25925, -20041},  {25894, -20081},  {25863, -20120},
    {25833, -20160},  {25802, -20200},  {25771, -20239},  {25739, -20279},  {25708, -20318},  {25677, -20357},
    {25646, -20397},  {25615, -20436},  {25583, -20475},  {25552, -20515},  {25520, -20554},  {25489, -20593},
    {25457, -20632},  {25425, -20671},  {25394, -20710},  {25362, -20749},  {25330, -20788},  {25298, -20827},
    {25266, -20865},  {25234, -20904},  {25202, -20943},  {25170, -20981},  {25138, -21020},  {25105, -21059},
    {25073, -21097},  {25041, -21136},  {25008, -21174},  {24976, -21212},  {24943, -21251},  {24910, -21289},
    {24878, -21327},  {24845, -21365},  {24812, -21403},  {24779, -21441},  {24746, -21479},  {24713, -21517},
    {24680, -21555},  {24647, -21593},  {24614, -21631},  {24581, -21668},  {24548, -21706},  {24514, -21744},
    {24481, -21781},  {24448, -21819},  {24414, -21856},  {24380, -21894},  {24347, -21931},  {24313, -21968},
    {24279, -22006},  {24246, -22043},  {24212, -22080},  {24178, -22117},  {24144, -22154},  {24110, -22191},
    {24076, -22228},  {24042, -22265},  {24008, -22302},  {23973, -22339},  {23939, -22375},  {23905, -22412},
    {23870, -22449},  {23836, -22485},  {23801, -22522},  {23767, -22558},  {23732, -22595},  {23697, -22631},
    {23663, -22668},  {23628, -22704},  {23593, -22740},  {23558, -22776},  {23523, -22812},  {23488, -22848},
    {23453, -22884},  {23418, -22920},  {23383, -22956},  {23348, -22992},  {23312, -23028},  {23277, -23064},
    {23241, -23099},  {23206, -23135},  {23170, -23170},  {23135, -23206},  {23099, -23241},  {23064, -23277},
    {23028, -23312},  {22992, -23348},  {22956, -23383},  {22920, -23418},  {22884, -23453},  {22848, -23488},
    {22812, -23523},  {22776, -23558},  {22740, -23593},  {22704, -23628},  {22668, -23663},  {22631, -23697},
    {22595, -23732},  {22558, -23767},  {22522, -23801},  {22485, -23836},  {22449, -23870},  {22412, -23905},
    {22375, -23939},  {22339, -23973},  {22302, -24008},  {22265, -24042},  {22228, -24076},  {22191, -24110},
    {22154, -24144},  {22117, -24178},  {22080, -24212},  {22043, -24246},  {22006, -24279},  {21968, -24313},
    {21931, -24347},  {21894, -24380},  {21856, -24414},  {21819, -24448},  {21781, -24481},  {21744, -24514},
    {21706, -24548},  {21668, -24581},  {21631, -24614},  {21593, -24647},  {21555, -24680},  {21517, -24713},
    {21479, -24746},  {21441, -24779},  {21403, -24812},  {21365, -24845},  {21327, -24878},  {21289, -24910},
    {21251, -24943},  {21212, -24976},  {21174, -25008},  {21136, -25041},  {21097, -25073},  {21059, -25105},
    {21020, -25138},  {20981, -25170},  {20943, -25202},  {20904, -25234},  {20865, -25266},  {20827, -25298},
    {20788, -25330},  {20749, -25362},  {20710, -25394},  {20671, -25425},  {20632, -25457},  {20593, -25489},
    {20554, -25520},  {20515, -25552},  {20475, -25583},  {20436, -25615},  {20397, -25646},  {20357, -25677},
    {20318, -25708},  {20279, -25739},  {20239, -25771},  {20200, -25802},  {20160, -25833},  {20120, -25863},
    {20081, -25894},  {20041, -25925},  {20001, -25956},  {19961, -25986},  {19921, -26017},  {19881, -26048},
    {19841, -26078},  {19801, -26108},  {19761, -26139},  {19721, -26169},  {19681, -26199},  {19641, -26229},
    {19601, -26259},  {19560, -26290},  {19520, -26320},  {19479, -26349},  {19439, -26379},  {19399, -26409},
    {19358, -26439},  {19317, -26468},  {19277, -26498},  {19236, -26528},  {19195, -26557},  {19155, -26586},
    {19114, -26616},  {19073, -26645},  {19032, -26674},  {18991, -26704},  {18950, -26733},  {18909, -26762},
    {18868, -26791},  {18827, -26820},  {18786, -26848},  {18745, -26877},  {18703, -26906},  {18662, -26935},
    {18621, -26963},  {18579, -26992},  {18538, -27020},  {18496, -27049},  {18455, -27077},  {18413, -27105},
    {18372, -27133},  {18330, -27162},  {18288, -27190},  {18247, -27218},  {18205, -27246},  {18163, -27273},
    {18121, -27301},  {18079, -27329},  {18037, -27357},  {17995, -27384},  {17953, -27412},  {17911, -27440},
    {17869, -27467},  {17827, -27494},  {17785, -27522},  {17743, -27549},  {17700, -27576},  {17658, -27603},
    {17616, -27630},  {17573, -27657},  {17531, -27684},  {17488, -27711},  {17446, -27738},  {17403, -27765},
    {17361, -27791},  {17318, -27818},  {17275, -27844},  {17233, -27871},  {17190, -27897},  {17147, -27924},
    {17104, -27950},  {17061, -27976},  {17018, -28002},  {16975, -28028},  {16932, -28054},  {16889, -28080},
    {16846, -28106},  {16803, -28132},  {16760, -28158},  {16717, -28183},  {16673, -28209},  {16630, -28234},
    {16587, -28260},  {16543, -28285},  {16500, -28311},  {16456, -28336},  {16413, -28361},  {16369, -28386},
    {16326, -28411},  {16282, -28436},  {16239, -28461},  {16195, -28486},  {16151, -28511},  {16108, -28536},
    {16064, -28560},  {16020, -28585},  {15976, -28610},  {15932, -28634},  {15888, -28658},  {15844, -28683},
    {15800, -28707},  {15756, -28731},  {15712, -28755},  {15668, -28779},  {15624, -28803},  {15580, -28827},
    {15535, -28851},  {15491, -28875},  {15447, -28899},  {15402, -28922},  {15358, -28946},  {15314, -28970},
    {15269, -28993},  {15225, -29016},  {15180, -29040},  {15136, -29063},  {15091, -29086},  {15046, -29109},
    {15002, -29132},  {14957, -29155},  {14912, -29178},  {14867, -29201},  {14823, -29224},  {14778, -29247},
    {14733, -29269},  {14688, -29292},  {14643, -29314},  {14598, -29337},  {14553, -29359},  {14508, -29381},
    {14463, -29404},  {14418, -29426},  {14373, -29448},  {14327, -29470},  {14282, -29492},  {14237, -29514},
    {14192, -29535},  {14146, -29557},  {14101, -29579},  {14056, -29600},  {14010, -29622},  {13965, -29643},
    {13919, -29665},  {13874, -29686},  {13828, -29707},  {13783, -29729},  {13737, -29750},  {13691, -29771},
    {13646, -29792},  {13600, -29813},  {13554, -29833},  {13508, -29854},  {13463, -29875},  {13417, -29895},
    {13371, -29916},  {13325, -29936},  {13279, -29957},  {13233, -29977},  {13187, -29997},  {13141, -30018},
    {13095, -30038},  {13049, -30058},  {13003, -30078},  {12957, -30098},  {12910, -30118},  {12864, -30137},
    {12818, -30157},  {12772, -30177},  {12725, -30196},  {12679, -30216},  {12633, -30235},  {12586, -30254},
    {12540, -30274},  {12493, -30293},  {12447, -30312},  {12400, -30331},  {12354, -30350},  {12307, -30369},
    {12261, -30388},  {12214, -30407},  {12167, -30425},  {12121, -30444},  {12074, -30462},  {12027, -30481},
    {11980, -30499},  {11934, -30518},  {11887, -30536},  {11840, -30554},  {11793, -30572},  {11746, -30590},
    {11699, -30608},  {11652, -30626},  {11605, -30644},  {11558, -30662},  {11511, -30680},  {11464, -30697},
    {11417, -30715},  {11370, -30732},  {11323, -30750},  {11276, -30767},  {11228, -30784},  {11181, -30801},
    {11134, -30819},  {11087, -30836},  {11039, -30853},  {10992, -30869},  {10945, -30886},  {10897, -30903},
    {10850, -30920},  {10802, -30936},  {10755, -30953},  {10707, -30969},  {10660, -30986},  {10612, -31002},
    {10565, -31018},  {10517, -31034},  {10469, -31050},  {10422, -31067},  {10374, -31082},  {10326, -31098},
    {10279, -31114},  {10231, -31130},  {10183, -31146},  {10135, -31161},  {10088, -31177},  {10040, -31192},
    {9992, -31207},   {9944, -31223},   {9896, -31238},   {9848, -31253},   {9800, -31268},   {9752, -31283},
    {9704, -31298},   {9656, -31313},   {9608, -31328},   {9560, -31342},   {9512, -31357},   {9464, -31372},
    {9416, -31386},   {9368, -31400},   {9319, -31415},   {9271, -31429},   {9223, -31443},   {9175, -31457},
    {9127, -31471},   {9078, -31485},   {9030, -31499},   {8982, -31513},   {8933, -31527},   {8885, -31540},
    {8836, -31554},   {8788, -31568},   {8740, -31581},   {8691, -31594},   {8643, -31608},   {8594, -31621},
    {8546, -31634},   {8497, -31647},   {8449, -31660},   {8400, -31673},   {8351, -31686},   {8303, -31699},
    {8254, -31711},   {8206, -31724},   {8157, -31737},   {8108, -31749},   {8059, -31761},   {8011, -31774},
    {7962, -31786},   {7913, -31798},   {7864, -31810},   {7816, -31822},   {7767, -31834},   {7718, -31846},
    {7669, -31858},   {7620, -31870},   {7571, -31881},   {7522, -31893},   {7473, -31904},   {7425, -31916},
    {7376, -31927},   {7327, -31938},   {7278, -31950},   {7229, -31961},   {7180, -31972},   {7130, -31983},
    {7081, -31994},   {7032, -32005},   {6983, -32015},   {6934, -32026},   {6885, -32037},   {6836, -32047},
    {6787, -32058},   {6737, -32068},   {6688, -32078},   {6639, -32088},   {6590, -32099},   {6541, -32109},
    {6491, -32119},   {6442, -32129},   {6393, -32138},   {6343, -32148},   {6294, -32158},   {6245, -32167},
    {6195, -32177},   {6146, -32186},   {6097, -32196},   {6047, -32205},   {5998, -32214},   {5948, -32224},
    {5899, -32233},   {5850, -32242},   {5800, -32251},   {5751, -32259},   {5701, -32268},   {5652, -32277},
    {5602, -32286},   {5553, -32294},   {5503, -32303},   {5453, -32311},   {5404, -32319},   {5354, -32328},
    {5305, -32336},   {5255, -32344},   {5205, -32352},   {5156, -32360},   {5106, -32368},   {5057, -32376},
    {5007, -32383},   {4957, -32391},   {4907, -32398},   {4858, -32406},   {4808, -32413},   {4758, -32421},
    {4709, -32428},   {4659, -32435},   {4609, -32442},   {4559, -32449},   {4510, -32456},   {4460, -32463},
    {4410, -32470},   {4360, -32477},   {4310, -32483},   {4260, -32490},   {4211, -32496},   {4161, -32503},
    {4111, -32509},   {4061, -32515},   {4011, -32522},   {3961, -32528},   {3911, -32534},   {3861, -32540},
    {3812, -32546},   {3762, -32551},   {3712, -32557},   {3662, -32563},   {3612, -32568},   {3562, -32574},
    {3512, -32579},   {3462, -32585},   {3412, -32590},   {3362, -32595},   {3312, -32600},   {3262, -32605},
    {3212, -32610},   {3162, -32615},   {3112, -32620},   {3062, -32625},   {3012, -32629},   {2962, -32634},
    {2912, -32638},   {2861, -32643},   {2811, -32647},   {2761, -32651},   {2711, -32656},   {2661, -32660},
    {2611, -32664},   {2561, -32668},   {2511, -32672},   {2461, -32675},   {2411, -32679},   {2360, -32683},
    {2310, -32686},   {2260, -32690},   {2210, -32693},   {2160, -32697},   {2110, -32700},   {2060, -32703},
    {2009, -32706},   {1959, -32709},   {1909, -32712},   {1859, -32715},   {1809, -32718},   {1758, -32721},
    {1708, -32723},   {1658, -32726},   {1608, -32729},   {1558, -32731},   {1507, -32733},   {1457, -32736},
    {1407, -32738},   {1357, -32740},   {1307, -32742},   {1256, -32744},   {1206, -32746},   {1156, -32748},
    {1106, -32749},   {1055, -32751},   {1005, -32753},   {955, -32754},    {905, -32756},    {854, -32757},
    {804, -32758},    {754, -32759},    {704, -32760},    {653, -32761},    {603, -32762},    {553, -32763},
    {503, -32764},    {452, -32765},    {402, -32766},    {352, -32766},    {302, -32767},    {251, -32767},
    {201, -32767},    {151, -32768},    {101, -32768},    {50, -32768},     {0, -32768},      {-50, -32768},
    {-101, -32768},   {-151, -32768},   {-201, -32767},   {-251, -32767},   {-302, -32767},   {-352, -32766},
    {-402, -32766},   {-452, -32765},   {-503, -32764},   {-553, -32763},   {-603, -32762},   {-653, -32761},
    {-704, -32760},   {-754, -32759},   {-804, -32758},   {-854, -32757},   {-905, -32756},   {-955, -32754},
    {-1005, -32753},  {-1055, -32751},  {-1106, -32749},  {-1156, -32748},  {-1206, -32746},  {-1256, -32744},
    {-1307, -32742},  {-1357, -32740},  {-1407, -32738},  {-1457, -32736},  {-1507, -32733},  {-1558, -32731},
    {-1608, -32729},  {-1658, -32726},  {-1708, -32723},  {-1758, -32721},  {-1809, -32718},  {-1859, -32715},
    {-1909, -32712},  {-1959, -32709},  {-2009, -32706},  {-2060, -32703},  {-2110, -32700},  {-2160, -32697},
    {-2210, -32693},  {-2260, -32690},  {-2310, -32686},  {-2360, -32683},  {-2411, -32679},  {-2461, -32675},
    {-2511, -32672},  {-2561, -32668},  {-2611, -32664},  {-2661, -32660},  {-2711, -32656},  {-2761, -32651},
    {-2811, -32647},  {-2861, -32643},  {-2912, -32638},  {-2962, -32634},  {-3012, -32629},  {-3062, -32625},
    {-3112, -32620},  {-3162, -32615},  {-3212, -32610},  {-3262, -32605},  {-3312, -32600},  {-3362, -32595},
    {-3412, -32590},  {-3462, -32585},  {-3512, -32579},  {-3562, -32574},  {-3612, -32568},  {-3662, -32563},
    {-3712, -32557},  {-3762, -32551},  {-3812, -32546},  {-3861, -32540},  {-3911, -32534},  {-3961, -32528},
    {-4011, -32522},  {-4061, -32515},  {-4111, -32509},  {-4161, -32503},  {-4211, -32496},  {-4260, -32490},
    {-4310, -32483},  {-4360, -32477},  {-4410, -32470},  {-4460, -32463},  {-4510, -32456},  {-4559, -32449},
    {-4609, -32442},  {-4659, -32435},  {-4709, -32428},  {-4758, -32421},  {-4808, -32413},  {-4858, -32406},
    {-4907, -32398},  {-4957, -32391},  {-5007, -32383},  {-5057, -32376},  {-5106, -32368},  {-5156, -32360},
    {-5205, -32352},  {-5255, -32344},  {-5305, -32336},  {-5354, -32328},  {-5404, -32319},  {-5453, -32311},
    {-5503, -32303},  {-5553, -32294},  {-5602, -32286},  {-5652, -32277},  {-5701, -32268},  {-5751, -32259},
    {-5800, -32251},  {-5850, -32242},  {-5899, -32233},  {-5948, -32224},  {-5998, -32214},  {-6047, -32205},
    {-6097, -32196},  {-6146, -32186},  {-6195, -32177},  {-6245, -32167},  {-6294, -32158},  {-6343, -32148},
    {-6393, -32138},  {-6442, -32129},  {-6491, -32119},  {-6541, -32109},  {-6590, -32099},  {-6639, -32088},
    {-6688, -32078},  {-6737, -32068},  {-6787, -32058},  {-6836, -32047},  {-6885, -32037},  {-6934, -32026},
    {-6983, -32015},  {-7032, -32005},  {-7081, -31994},  {-7130, -31983},  {-7180, -31972},  {-7229, -31961},
    {-7278, -31950},  {-7327, -31938},  {-7376, -31927},  {-7425, -31916},  {-7473, -31904},  {-7522, -31893},
    {-7571, -31881},  {-7620, -31870},  {-7669, -31858},  {-7718, -31846},  {-7767, -31834},  {-7816, -31822},
    {-7864, -31810},  {-7913, -31798},  {-7962, -31786},  {-8011, -31774},  {-8059, -31761},  {-8108, -31749},
    {-8157, -31737},  {-8206, -31724},  {-8254, -31711},  {-8303, -31699},  {-8351, -31686},  {-8400, -31673},
    {-8449, -31660},  {-8497, -31647},  {-8546, -31634},  {-8594, -31621},  {-8643, -31608},  {-8691, -31594},
    {-8740, -31581},  {-8788, -31568},  {-8836, -31554},  {-8885, -31540},  {-8933, -31527},  {-8982, -31513},
    {-9030, -31499},  {-9078, -31485},  {-9127, -31471},  {-9175, -31457},  {-9223, -31443},  {-9271, -31429},
    {-9319, -31415},  {-9368, -31400},  {-9416, -31386},  {-9464, -31372},  {-9512, -31357},  {-9560, -31342},
    {-9608, -31328},  {-9656, -31313},  {-9704, -31298},  {-9752, -31283},  {-9800, -31268},  {-9848, -31253},
    {-9896, -31238},  {-9944, -31223},  {-9992, -31207},  {-10040, -31192}, {-10088, -31177}, {-10135, -31161},
    {-10183, -31146}, {-10231, -31130}, {-10279, -31114}, {-10326, -31098}, {-10374, -31082}, {-10422, -31067},
    {-10469, -31050}, {-10517, -31034}, {-10565, -31018}, {-10612, -31002}, {-10660, -30986}, {-10707, -30969},
    {-10755, -30953}, {-10802, -30936}, {-10850, -30920}, {-10897, -30903}, {-10945, -30886}, {-10992, -30869},
    {-11039, -30853}, {-11087, -30836}, {-11134, -30819}, {-11181, -30801}, {-11228, -30784}, {-11276, -30767},
    {-11323, -30750}, {-11370, -30732}, {-11417, -30715}, {-11464, -30697}, {-11511, -30680}, {-11558, -30662},
    {-11605, -30644}, {-11652, -30626}, {-11699, -30608}, {-11746, -30590}, {-11793, -30572}, {-11840, -30554},
    {-11887, -30536}, {-11934, -30518}, {-11980, -30499}, {-12027, -30481}, {-12074, -30462}, {-12121, -30444},
    {-12167, -30425}, {-12214, -30407}, {-12261, -30388}, {-12307, -30369}, {-12354, -30350}, {-12400, -30331},
    {-12447, -30312}, {-12493, -30293}, {-12540, -30274}, {-12586, -30254}, {-12633, -30235}, {-12679, -30216},
    {-12725, -30196}, {-12772, -30177}, {-12818, -30157}, {-12864, -30137}, {-12910, -30118}, {-12957, -30098},
    {-13003, -30078}, {-13049, -30058}, {-13095, -30038}, {-13141, -30018}, {-13187, -29997}, {-13233, -29977},
    {-13279, -29957}, {-13325, -29936}, {-13371, -29916}, {-13417, -29895}, {-13463, -29875}, {-13508, -29854},
    {-13554, -29833}, {-13600, -29813}, {-13646, -29792}, {-13691, -29771}, {-13737, -29750}, {-13783, -29729},
    {-13828, -29707}, {-13874, -29686}, {-13919, -29665}, {-13965, -29643}, {-14010, -29622}, {-14056, -29600},
    {-14101, -29579}, {-14146, -29557}, {-14192, -29535}, {-14237, -29514}, {-14282, -29492}, {-14327, -29470},
    {-14373, -29448}, {-14418, -29426}, {-14463, -29404}, {-14508, -29381}, {-14553, -29359}, {-14598, -29337},
    {-14643, -29314}, {-14688, -29292}, {-14733, -29269}, {-14778, -29247}, {-14823, -29224}, {-14867, -29201},
    {-14912, -29178}, {-14957, -29155}, {-15002, -29132}, {-15046, -29109}, {-15091, -29086}, {-15136, -29063},
    {-15180, -29040}, {-15225, -29016}, {-15269, -28993}, {-15314, -28970}, {-15358, -28946}, {-15402, -28922},
    {-15447, -28899}, {-15491, -28875}, {-15535, -28851}, {-15580, -28827}, {-15624, -28803}, {-15668, -28779},
    {-15712, -28755}, {-15756, -28731}, {-15800, -28707}, {-15844, -28683}, {-15888, -28658}, {-15932, -28634},
    {-15976, -28610}, {-16020, -28585}, {-16064, -28560}, {-16108, -28536}, {-16151, -28511}, {-16195, -28486},
    {-16239, -28461}, {-16282, -28436}, {-16326, -28411}, {-16369, -28386}, {-16413, -28361}, {-16456, -28336},
    {-16500, -28311}, {-16543, -28285}, {-16587, -28260}, {-16630, -28234}, {-16673, -28209}, {-16717, -28183},
    {-16760, -28158}, {-16803, -28132}, {-16846, -28106}, {-16889, -28080}, {-16932, -28054}, {-16975, -28028},
    {-17018, -28002}, {-17061, -27976}, {-17104, -27950}, {-17147, -27924}, {-17190, -27897}, {-17233, -27871},
    {-17275, -27844}, {-17318, -27818}, {-17361, -27791}, {-17403, -27765}, {-17446, -27738}, {-17488, -27711},
    {-17531, -27684}, {-17573, -27657}, {-17616, -27630}, {-17658, -27603}, {-17700, -27576}, {-17743, -27549},
    {-17785, -27522}, {-17827, -27494}, {-17869, -27467}, {-17911, -27440}, {-17953, -27412}, {-17995, -27384},
    {-18037, -27357}, {-18079, -27329}, {-18121, -27301}, {-18163, -27273}, {-18205, -27246}, {-18247, -27218},
    {-18288, -27190}, {-18330, -27162}, {-18372, -27133}, {-18413, -27105}, {-18455, -27077}, {-18496, -27049},
    {-18538, -27020}, {-18579, -26992}, {-18621, -26963}, {-18662, -26935}, {-18703, -26906}, {-18745, -26877},
    {-18786, -26848}, {-18827, -26820}, {-18868, -26791}, {-18909, -26762}, {-18950, -26733}, {-18991, -26704},
    {-19032, -26674}, {-19073, -26645}, {-19114, -26616}, {-19155, -26586}, {-19195, -26557}, {-19236, -26528},
    {-19277, -26498}, {-19317, -26468}, {-19358, -26439}, {-19399, -26409}, {-19439, -26379}, {-19479, -26349},
    {-19520, -26320}, {-19560, -26290}, {-19601, -26259}, {-19641, -26229}, {-19681, -26199}, {-19721, -26169},
    {-19761, -26139}, {-19801, -26108}, {-19841, -26078}, {-19881, -26048}, {-19921, -26017}, {-19961, -25986},
    {-20001, -25956}, {-20041, -25925}, {-20081, -25894}, {-20120, -25863}, {-20160, -25833}, {-20200, -25802},
    {-20239, -25771}, {-20279, -25739}, {-20318, -25708}, {-20357, -25677}, {-20397, -25646}, {-20436, -25615},
    {-20475, -25583}, {-20515, -25552}, {-20554, -25520}, {-20593, -25489}, {-20632, -25457}, {-20671, -25425},
    {-20710, -25394}, {-20749, -25362}, {-20788, -25330}, {-20827, -25298}, {-20865, -25266}, {-20904, -25234},
    {-20943, -25202}, {-20981, -25170}, {-21020, -25138}, {-21059, -25105}, {-21097, -25073}, {-21136, -25041},
    {-21174, -25008}, {-21212, -24976}, {-21251, -24943}, {-21289, -24910}, {-21327, -24878}, {-21365, -24845},
    {-21403, -24812}, {-21441, -24779}, {-21479, -24746}, {-21517, -24713}, {-21555, -24680}, {-21593, -24647},
    {-21631, -24614}, {-21668, -24581}, {-21706, -24548}, {-21744, -24514}, {-21781, -24481}, {-21819, -24448},
    {-21856, -24414}, {-21894, -24380}, {-21931, -24347}, {-21968, -24313}, {-22006, -24279}, {-22043, -24246},
    {-22080, -24212}, {-22117, -24178}, {-22154, -24144}, {-22191, -24110}, {-22228, -24076}, {-22265, -24042},
    {-22302, -24008}, {-22339, -23973}, {-22375, -23939}, {-22412, -23905}, {-22449, -23870}, {-22485, -23836},
    {-22522, -23801}, {-22558, -23767}, {-22595, -23732}, {-22631, -23697}, {-22668, -23663}, {-22704, -23628},
    {-22740, -23593}, {-22776, -23558}, {-22812, -23523}, {-22848, -23488}, {-22884, -23453}, {-22920, -23418},
    {-22956, -23383}, {-22992, -23348}, {-23028, -23312}, {-23064, -23277}, {-23099, -23241}, {-23135, -23206},
    {-23170, -23170}, {-23206, -23135}, {-23241, -23099}, {-23277, -23064}, {-23312, -23028}, {-23348, -22992},
    {-23383, -22956}, {-23418, -22920}, {-23453, -22884}, {-23488, -22848}, {-23523, -22812}, {-23558, -22776},
    {-23593, -22740}, {-23628, -22704}, {-23663, -22668}, {-23697, -22631}, {-23732, -22595}, {-23767, -22558},
    {-23801, -22522}, {-23836, -22485}, {-23870, -22449}, {-23905, -22412}, {-23939, -22375}, {-23973, -22339},
    {-24008, -22302}, {-24042, -22265}, {-24076, -22228}, {-24110, -22191}, {-24144, -22154}, {-24178, -22117},
    {-24212, -22080}, {-24246, -22043}, {-24279, -22006}, {-24313, -21968}, {-24347, -21931}, {-24380, -21894},
    {-24414, -21856}, {-24448, -21819}, {-24481, -21781}, {-24514, -21744}, {-24548, -21706}, {-24581, -21668},
    {-24614, -21631}, {-24647, -21593}, {-24680, -21555}, {-24713, -21517}, {-24746, -21479}, {-24779, -21441},
    {-24812, -21403}, {-24845, -21365}, {-24878, -21327}, {-24910, -21289}, {-24943, -21251}, {-24976, -21212},
    {-25008, -21174}, {-25041, -21136}, {-25073, -21097}, {-25105, -21059}, {-25138, -21020}, {-25170, -20981},
    {-25202, -20943}, {-25234, -20904}, {-25266, -20865}, {-25298, -20827}, {-25330, -20788}, {-25362, -20749},
    {-25394, -20710}, {-25425, -20671}, {-25457, -20632}, {-25489, -20593}, {-25520, -20554}, {-25552, -20515},
    {-25583, -20475}, {-25615, -20436}, {-25646, -20397}, {-25677, -20357}, {-25708, -20318}, {-25739, -20279},
    {-25771, -20239}, {-25802, -20200}, {-25833, -20160}, {-25863, -20120}, {-25894, -20081}, {-25925, -20041},
    {-25956, -20001}, {-25986, -19961}, {-26017, -19921}, {-26048, -19881}, {-26078, -19841}, {-26108, -19801},
    {-26139, -19761}, {-26169, -19721}, {-26199, -19681}, {-26229, -19641}, {-26259, -19601}, {-26290, -19560},
    {-26320, -19520}, {-26349, -19479}, {-26379, -19439}, {-26409, -19399}, {-26439, -19358}, {-26468, -19317},
    {-26498, -19277}, {-26528, -19236}, {-26557, -19195}, {-26586, -19155}, {-26616, -19114}, {-26645, -19073},
    {-26674, -19032}, {-26704, -18991}, {-26733, -18950}, {-26762, -18909}, {-26791, -18868}, {-26820, -18827},
    {-26848, -18786}, {-26877, -18745}, {-26906, -18703}, {-26935, -18662}, {-26963, -18621}, {-26992, -18579},
    {-27020, -18538}, {-27049, -18496}, {-27077, -18455}, {-27105, -18413}, {-27133, -18372}, {-27162, -18330},
    {-27190, -18288}, {-27218, -18247}, {-27246, -18205}, {-27273, -18163}, {-27301, -18121}, {-27329, -18079},
    {-27357, -18037}, {-27384, -17995}, {-27412, -17953}, {-27440, -17911}, {-27467, -17869}, {-27494, -17827},
    {-27522, -17785}, {-27549, -17743}, {-27576, -17700}, {-27603, -17658}, {-27630, -17616}, {-27657, -17573},
    {-27684, -17531}, {-27711, -17488}, {-27738, -17446}, {-27765, -17403}, {-27791, -17361}, {-27818, -17318},
    {-27844, -17275}, {-27871, -17233}, {-27897, -17190}, {-27924, -17147}, {-27950, -17104}, {-27976, -17061},
    {-28002, -17018}, {-28028, -16975}, {-28054, -16932}, {-28080, -16889}, {-28106, -16846}, {-28132, -16803},
    {-28158, -16760}, {-28183, -16717}, {-28209, -16673}, {-28234, -16630}, {-28260, -16587}, {-28285, -16543},
    {-28311, -16500}, {-28336, -16456}, {-28361, -16413}, {-28386, -16369}, {-28411, -16326}, {-28436, -16282},
    {-28461, -16239}, {-28486, -16195}, {-28511, -16151}, {-28536, -16108}, {-28560, -16064}, {-28585, -16020},
    {-28610, -15976}, {-28634, -15932}, {-28658, -15888}, {-28683, -15844}, {-28707, -15800}, {-28731, -15756},
    {-28755, -15712}, {-28779, -15668}, {-28803, -15624}, {-28827, -15580}, {-28851, -15535}, {-28875, -15491},
    {-28899, -15447}, {-28922, -15402}, {-28946, -15358}, {-28970, -15314}, {-28993, -15269}, {-29016, -15225},
    {-29040, -15180}, {-29063, -15136}, {-29086, -15091}, {-29109, -15046}, {-29132, -15002}, {-29155, -14957},
    {-29178, -14912}, {-29201, -14867}, {-29224, -14823}, {-29247, -14778}, {-29269, -14733}, {-29292, -14688},
    {-29314, -14643}, {-29337, -14598}, {-29359, -14553}, {-29381, -14508}, {-29404, -14463}, {-29426, -14418},
    {-29448, -14373}, {-29470, -14327}, {-29492, -14282}, {-29514, -14237}, {-29535, -14192}, {-29557, -14146},
    {-29579, -14101}, {-29600, -14056}, {-29622, -14010}, {-29643, -13965}, {-29665, -13919}, {-29686, -13874},
    {-29707, -13828}, {-29729, -13783}, {-29750, -13737}, {-29771, -13691}, {-29792, -13646}, {-29813, -13600},
    {-29833, -13554}, {-29854, -13508}, {-29875, -13463}, {-29895, -13417}, {-29916, -13371}, {-29936, -13325},
    {-29957, -13279}, {-29977, -13233}, {-29997, -13187}, {-30018, -13141}, {-30038, -13095}, {-30058, -13049},
    {-30078, -13003}, {-30098, -12957}, {-30118, -12910}, {-30137, -12864}, {-30157, -12818}, {-30177, -12772},
    {-30196, -12725}, {-30216, -12679}, {-30235, -12633}, {-30254, -12586}, {-30274, -12540}, {-30293, -12493},
    {-30312, -12447}, {-30331, -12400}, {-30350, -12354}, {-30369, -12307}, {-30388, -12261}, {-30407, -12214},
    {-30425, -12167}, {-30444, -12121}, {-30462, -12074}, {-30481, -12027}, {-30499, -11980}, {-30518, -11934},
    {-30536, -11887}, {-30554, -11840}, {-30572, -11793}, {-30590, -11746}, {-30608, -11699}, {-30626, -11652},
    {-30644, -11605}, {-30662, -11558}, {-30680, -11511}, {-30697, -11464}, {-30715, -11417}, {-30732, -11370},
    {-30750, -11323}, {-30767, -11276}, {-30784, -11228}, {-30801, -11181}, {-30819, -11134}, {-30836, -11087},
    {-30853, -11039}, {-30869, -10992}, {-30886, -10945}, {-30903, -10897}, {-30920, -10850}, {-30936, -10802},
    {-30953, -10755}, {-30969, -10707}, {-30986, -10660}, {-31002, -10612}, {-31018, -10565}, {-31034, -10517},
    {-31050, -10469}, {-31067, -10422}, {-31082, -10374}, {-31098, -10326}, {-31114, -10279}, {-31130, -10231},
    {-31146, -10183}, {-31161, -10135}, {-31177, -10088}, {-31192, -10040}, {-31207, -9992},  {-31223, -9944},
    {-31238, -9896},  {-31253, -9848},  {-31268, -9800},  {-31283, -9752},  {-31298, -9704},  {-31313, -9656},
    {-31328, -9608},  {-31342, -9560},  {-31357, -9512},  {-31372, -9464},  {-31386, -9416},  {-31400, -9368},
    {-31415, -9319},  {-31429, -9271},  {-31443, -9223},  {-31457, -9175},  {-31471, -9127},  {-31485, -9078},
    {-31499, -9030},  {-31513, -8982},  {-31527, -8933},  {-31540, -8885},  {-31554, -8836},  {-31568, -8788},
    {-31581, -8740},  {-31594, -8691},  {-31608, -8643},  {-31621, -8594},  {-31634, -8546},  {-31647, -8497},
    {-31660, -8449},  {-31673, -8400},  {-31686, -8351},  {-31699, -8303},  {-31711, -8254},  {-31724, -8206},
    {-31737, -8157},  {-31749, -8108},  {-31761, -8059},  {-31774, -8011},  {-31786, -7962},  {-31798, -7913},
    {-31810, -7864},  {-31822, -7816},  {-31834, -7767},  {-31846, -7718},  {-31858, -7669},  {-31870, -7620},
    {-31881, -7571},  {-31893, -7522},  {-31904, -7473},  {-31916, -7425},  {-31927, -7376},  {-31938, -7327},
    {-31950, -7278},  {-31961, -7229},  {-31972, -7180},  {-31983, -7130},  {-31994, -7081},  {-32005, -7032},
    {-32015, -6983},  {-32026, -6934},  {-32037, -6885},  {-32047, -6836},  {-32058, -6787},  {-32068, -6737},
    {-32078, -6688},  {-32088, -6639},  {-32099, -6590},  {-32109, -6541},  {-32119, -6491},  {-32129, -6442},
    {-32138, -6393},  {-32148, -6343},  {-32158, -6294},  {-32167, -6245},  {-32177, -6195},  {-32186, -6146},
    {-32196, -6097},  {-32205, -6047},  {-32214, -5998},  {-32224, -5948},  {-32233, -5899},  {-32242, -5850},
    {-32251, -5800},  {-32259, -5751},  {-32268, -5701},  {-32277, -5652},  {-32286, -5602},  {-32294, -5553},
    {-32303, -5503},  {-32311, -5453},  {-32319, -5404},  {-32328, -5354},  {-32336, -5305},  {-32344, -5255},
    {-32352, -5205},  {-32360, -5156},  {-32368, -5106},  {-32376, -5057},  {-32383, -5007},  {-32391, -4957},
    {-32398, -4907},  {-32406, -4858},  {-32413, -4808},  {-32421, -4758},  {-32428, -4709},  {-32435, -4659},
    {-32442, -4609},  {-32449, -4559},  {-32456, -4510},  {-32463, -4460},  {-32470, -4410},  {-32477, -4360},
    {-32483, -4310},  {-32490, -4260},  {-32496, -4211},  {-32503, -4161},  {-32509, -4111},  {-32515, -4061},
    {-32522, -4011},  {-32528, -3961},  {-32534, -3911},  {-32540, -3861},  {-32546, -3812},  {-32551, -3762},
    {-32557, -3712},  {-32563, -3662},  {-32568, -3612},  {-32574, -3562},  {-32579, -3512},  {-32585, -3462},
    {-32590, -3412},  {-32595, -3362},  {-32600, -3312},  {-32605, -3262},  {-32610, -3212},  {-32615, -3162},
    {-32620, -3112},  {-32625, -3062},  {-32629, -3012},  {-32634, -2962},  {-32638, -2912},  {-32643, -2861},
    {-32647, -2811},  {-32651, -2761},  {-32656, -2711},  {-32660, -2661},  {-32664, -2611},  {-32668, -2561},
    {-32672, -2511},  {-32675, -2461},  {-32679, -2411},  {-32683, -2360},  {-32686, -2310},  {-32690, -2260},
    {-32693, -2210},  {-32697, -2160},  {-32700, -2110},  {-32703, -2060},  {-32706, -2009},  {-32709, -1959},
    {-32712, -1909},  {-32715, -1859},  {-32718, -1809},  {-32721, -1758},  {-32723, -1708},  {-32726, -1658},
    {-32729, -1608},  {-32731, -1558},  {-32733, -1507},  {-32736, -1457},  {-32738, -1407},  {-32740, -1357},
    {-32742, -1307},  {-32744, -1256},  {-32746, -1206},  {-32748, -1156},  {-32749, -1106},  {-32751, -1055},
    {-32753, -1005},  {-32754, -955},   {-32756, -905},   {-32757, -854},   {-32758, -804},   {-32759, -754},
    {-32760, -704},   {-32761, -653},   {-32762, -603},   {-32763, -553},   {-32764, -503},   {-32765, -452},
    {-32766, -402},   {-32766, -352},   {-32767, -302},   {-32767, -251},   {-32767, -201},   {-32768, -151},
    {-32768, -101},   {-32768, -50}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw2048_half[FFT_2048 / 2] = {
    {32767, 0},      {32767, -50},    {32767, -101},   {32767, -151},   {32767, -201},   {32767, -251},
    {32767, -302},   {32766, -352},   {32766, -402},   {32765, -452},   {32764, -503},   {32763, -553},
    {32762, -603},   {32761, -653},   {32760, -704},   {32759, -754},   {32758, -804},   {32757, -854},
    {32756, -905},   {32754, -955},   {32753, -1005},  {32751, -1055},  {32749, -1106},  {32748, -1156},
    {32746, -1206},  {32744, -1256},  {32742, -1307},  {32740, -1357},  {32738, -1407},  {32736, -1457},
    {32733, -1507},  {32731, -1558},  {32729, -1608},  {32726, -1658},  {32723, -1708},  {32721, -1758},
    {32718, -1809},  {32715, -1859},  {32712, -1909},  {32709, -1959},  {32706, -2009},  {32703, -2060},
    {32700, -2110},  {32697, -2160},  {32693, -2210},  {32690, -2260},  {32686, -2310},  {32683, -2360},
    {32679, -2411},  {32675, -2461},  {32672, -2511},  {32668, -2561},  {32664, -2611},  {32660, -2661},
    {32656, -2711},  {32651, -2761},  {32647, -2811},  {32643, -2861},  {32638, -2912},  {32634, -2962},
    {32629, -3012},  {32625, -3062},  {32620, -3112},  {32615, -3162},  {32610, -3212},  {32605, -3262},
    {32600, -3312},  {32595, -3362},  {32590, -3412},  {32585, -3462},  {32579, -3512},  {32574, -3562},
    {32568, -3612},  {32563, -3662},  {32557, -3712},  {32551, -3762},  {32546, -3812},  {32540, -3861},
    {32534, -3911},  {32528, -3961},  {32522, -4011},  {32515, -4061},  {32509, -4111},  {32503, -4161},
    {32496, -4211},  {32490, -4260},  {32483, -4310},  {32477, -4360},  {32470, -4410},  {32463, -4460},
    {32456, -4510},  {32449, -4559},  {32442, -4609},  {32435, -4659},  {32428, -4709},  {32421, -4758},
    {32413, -4808},  {32406, -4858},  {32398, -4907},  {32391, -4957},  {32383, -5007},  {32376, -5057},
    {32368, -5106},  {32360, -5156},  {32352, -5205},  {32344, -5255},  {32336, -5305},  {32328, -5354},
    {32319, -5404},  {32311, -5453},  {32303, -5503},  {32294, -5553},  {32286, -5602},  {32277, -5652},
    {32268, -5701},  {32259, -5751},  {32251, -5800},  {32242, -5850},  {32233, -5899},  {32224, -5948},
    {32214, -5998},  {32205, -6047},  {32196, -6097},  {32186, -6146},  {32177, -6195},  {32167, -6245},
    {32158, -6294},  {32148, -6343},  {32138, -6393},  {32129, -6442},  {32119, -6491},  {32109, -6541},
    {32099, -6590},  {32088, -6639},  {32078, -6688},  {32068, -6737},  {32058, -6787},  {32047, -6836},
    {32037, -6885},  {32026, -6934},  {32015, -6983},  {32005, -7032},  {31994, -7081},  {31983, -7130},
    {31972, -7180},  {31961, -7229},  {31950, -7278},  {31938, -7327},  {31927, -7376},  {31916, -7425},
    {31904, -7473},  {31893, -7522},  {31881, -7571},  {31870, -7620},  {31858, -7669},  {31846, -7718},
    {31834, -7767},  {31822, -7816},  {31810, -7864},  {31798, -7913},  {31786, -7962},  {31774, -8011},
    {31761, -8059},  {31749, -8108},  {31737, -8157},  {31724, -8206},  {31711, -8254},  {31699, -8303},
    {31686, -8351},  {31673, -8400},  {31660, -8449},  {31647, -8497},  {31634, -8546},  {31621, -8594},
    {31608, -8643},  {31594, -8691},  {31581, -8740},  {31568, -8788},  {31554, -8836},  {31540, -8885},
    {31527, -8933},  {31513, -8982},  {31499, -9030},  {31485, -9078},  {31471, -9127},  {31457, -9175},
    {31443, -9223},  {31429, -9271},  {31415, -9319},  {31400, -9368},  {31386, -9416},  {31372, -9464},
    {31357, -9512},  {31342, -9560},  {31328, -9608},  {31313, -9656},  {31298, -9704},  {31283, -9752},
    {31268, -9800},  {31253, -9848},  {31238, -9896},  {31223, -9944},  {31207, -9992},  {31192, -10040},
    {31177, -10088}, {31161, -10135}, {31146, -10183}, {31130, -10231}, {31114, -10279}, {31098, -10326},
    {31082, -10374}, {31067, -10422}, {31050, -10469}, {31034, -10517}, {31018, -10565}, {31002, -10612},
    {30986, -10660}, {30969, -10707}, {30953, -10755}, {30936, -10802}, {30920, -10850}, {30903, -10897},
    {30886, -10945}, {30869, -10992}, {30853, -11039}, {30836, -11087}, {30819, -11134}, {30801, -11181},
    {30784, -11228}, {30767, -11276}, {30750, -11323}, {30732, -11370}, {30715, -11417}, {30697, -11464},
    {30680, -11511}, {30662, -11558}, {30644, -11605}, {30626, -11652}, {30608, -11699}, {30590, -11746},
    {30572, -11793}, {30554, -11840}, {30536, -11887}, {30518, -11934}, {30499, -11980}, {30481, -12027},
    {30462, -12074}, {30444, -12121}, {30425, -12167}, {30407, -12214}, {30388, -12261}, {30369, -12307},
    {30350, -12354}, {30331, -12400}, {30312, -12447}, {30293, -12493}, {30274, -12540}, {30254, -12586},
    {30235, -12633}, {30216, -12679}, {30196, -12725}, {30177, -12772}, {30157, -12818}, {30137, -12864},
    {30118, -12910}, {30098, -12957}, {30078, -13003}, {30058, -13049}, {30038, -13095}, {30018, -13141},
    {29997, -13187}, {29977, -13233}, {29957, -13279}, {29936, -13325}, {29916, -13371}, {29895, -13417},
    {29875, -13463}, {29854, -13508}, {29833, -13554}, {29813, -13600}, {29792, -13646}, {29771, -13691},
    {29750, -13737}, {29729, -13783}, {29707, -13828}, {29686, -13874}, {29665, -13919}, {29643, -13965},
    {29622, -14010}, {29600, -14056}, {29579, -14101}, {29557, -14146}, {29535, -14192}, {29514, -14237},
    {29492, -14282}, {29470, -14327}, {29448, -14373}, {29426, -14418}, {29404, -14463}, {29381, -14508},
    {29359, -14553}, {29337, -14598}, {29314, -14643}, {29292, -14688}, {29269, -14733}, {29247, -14778},
    {29224, -14823}, {29201, -14867}, {29178, -14912}, {29155, -14957}, {29132, -15002}, {29109, -15046},
    {29086, -15091}, {29063, -15136}, {29040, -15180}, {29016, -15225}, {28993, -15269}, {28970, -15314},
    {28946, -15358}, {28922, -15402}, {28899, -15447}, {28875, -15491}, {28851, -15535}, {28827, -15580},
    {28803, -15624}, {28779, -15668}, {28755, -15712}, {28731, -15756}, {28707, -15800}, {28683, -15844},
    {28658, -15888}, {28634, -15932}, {28610, -15976}, {28585, -16020}, {28560, -16064}, {28536, -16108},
    {28511, -16151}, {28486, -16195}, {28461, -16239}, {28436, -16282}, {28411, -16326}, {28386, -16369},
    {28361, -16413}, {28336, -16456}, {28311, -16500}, {28285, -16543}, {28260, -16587}, {28234, -16630},
    {28209, -16673}, {28183, -16717}, {28158, -16760}, {28132, -16803}, {28106, -16846}, {28080, -16889},
    {28054, -16932}, {28028, -16975}, {28002, -17018}, {27976, -17061}, {27950, -17104}, {27924, -17147},
    {27897, -17190}, {27871, -17233}, {27844, -17275}, {27818, -17318}, {27791, -17361}, {27765, -17403},
    {27738, -17446}, {27711, -17488}, {27684, -17531}, {27657, -17573}, {27630, -17616}, {27603, -17658},
    {27576, -17700}, {27549, -17743}, {27522, -17785}, {27494, -17827}, {27467, -17869}, {27440, -17911},
    {27412, -17953}, {27384, -17995}, {27357, -18037}, {27329, -18079}, {27301, -18121}, {27273, -18163},
    {27246, -18205}, {27218, -18247}, {27190, -18288}, {27162, -18330}, {27133, -18372}, {27105, -18413},
    {27077, -18455}, {27049, -18496}, {27020, -18538}, {26992, -18579}, {26963, -18621}, {26935, -18662},
    {26906, -18703}, {26877, -18745}, {26848, -18786}, {26820, -18827}, {26791, -18868}, {26762, -18909},
    {26733, -18950}, {26704, -18991}, {26674, -19032}, {26645, -19073}, {26616, -19114}, {26586, -19155},
    {26557, -19195}, {26528, -19236}, {26498, -19277}, {26468, -19317}, {26439, -19358}, {26409, -19399},
    {26379, -19439}, {26349, -19479}, {26320, -19520}, {26290, -19560}, {26259, -19601}, {26229, -19641},
    {26199, -19681}, {26169, -19721}, {26139, -19761}, {26108, -19801}, {26078, -19841}, {26048, -19881},
    {26017, -19921}, {25986, -19961}, {25956, -20001}, {25925, -20041}, {25894, -20081}, {25863, -20120},
    {25833, -20160}, {25802, -20200}, {25771, -20239}, {25739, -20279}, {25708, -20318}, {25677, -20357},
    {25646, -20397}, {25615, -20436}, {25583, -20475}, {25552, -20515}, {25520, -20554}, {25489, -20593},
    {25457, -20632}, {25425, -20671}, {25394, -20710}, {25362, -20749}, {25330, -20788}, {25298, -20827},
    {25266, -20865}, {25234, -20904}, {25202, -20943}, {25170, -20981}, {25138, -21020}, {25105, -21059},
    {25073, -21097}, {25041, -21136}, {25008, -21174}, {24976, -21212}, {24943, -21251}, {24910, -21289},
    {24878, -21327}, {24845, -21365}, {24812, -21403}, {24779, -21441}, {24746, -21479}, {24713, -21517},
    {24680, -21555}, {24647, -21593}, {24614, -21631}, {24581, -21668}, {24548, -21706}, {24514, -21744},
    {24481, -21781}, {24448, -21819}, {24414, -21856}, {24380, -21894}, {24347, -21931}, {24313, -21968},
    {24279, -22006}, {24246, -22043}, {24212, -22080}, {24178, -22117}, {24144, -22154}, {24110, -22191},
    {24076, -22228}, {24042, -22265}, {24008, -22302}, {23973, -22339}, {23939, -22375}, {23905, -22412},
    {23870, -22449}, {23836, -22485}, {23801, -22522}, {23767, -22558}, {23732, -22595}, {23697, -22631},
    {23663, -22668}, {23628, -22704}, {23593, -22740}, {23558, -22776}, {23523, -22812}, {23488, -22848},
    {23453, -22884}, {23418, -22920}, {23383, -22956}, {23348, -22992}, {23312, -23028}, {23277, -23064},
    {23241, -23099}, {23206, -23135}, {23170, -23170}, {23135, -23206}, {23099, -23241}, {23064, -23277},
    {23028, -23312}, {22992, -23348}, {22956, -23383}, {22920, -23418}, {22884, -23453}, {22848, -23488},
    {22812, -23523}, {22776, -23558}, {22740, -23593}, {22704, -23628}, {22668, -23663}, {22631, -23697},
    {22595, -23732}, {22558, -23767}, {22522, -23801}, {22485, -23836}, {22449, -23870}, {22412, -23905},
    {22375, -23939}, {22339, -23973}, {22302, -24008}, {22265, -24042}, {22228, -24076}, {22191, -24110},
    {22154, -24144}, {22117, -24178}, {22080, -24212}, {22043, -24246}, {22006, -24279}, {21968, -24313},
    {21931, -24347}, {21894, -24380}, {21856, -24414}, {21819, -24448}, {21781, -24481}, {21744, -24514},
    {21706, -24548}, {21668, -24581}, {21631, -24614}, {21593, -24647}, {21555, -24680}, {21517, -24713},
    {21479, -24746}, {21441, -24779}, {21403, -24812}, {21365, -24845}, {21327, -24878}, {21289, -24910},
    {21251, -24943}, {21212, -24976}, {21174, -25008}, {21136, -25041}, {21097, -25073}, {21059, -25105},
    {21020, -25138}, {20981, -25170}, {20943, -25202}, {20904, -25234}, {20865, -25266}, {20827, -25298},
    {20788, -25330}, {20749, -25362}, {20710, -25394}, {20671, -25425}, {20632, -25457}, {20593, -25489},
    {20554, -25520}, {20515, -25552}, {20475, -25583}, {20436, -25615}, {20397, -25646}, {20357, -25677},
    {20318, -25708}, {20279, -25739}, {20239, -25771}, {20200, -25802}, {20160, -25833}, {20120, -25863},
    {20081, -25894}, {20041, -25925}, {20001, -25956}, {19961, -25986}, {19921, -26017}, {19881, -26048},
    {19841, -26078}, {19801, -26108}, {19761, -26139}, {19721, -26169}, {19681, -26199}, {19641, -26229},
    {19601, -26259}, {19560, -26290}, {19520, -26320}, {19479, -26349}, {19439, -26379}, {19399, -26409},
    {19358, -26439}, {19317, -26468}, {19277, -26498}, {19236, -26528}, {19195, -26557}, {19155, -26586},
    {19114, -26616}, {19073, -26645}, {19032, -26674}, {18991, -26704}, {18950, -26733}, {18909, -26762},
    {18868, -26791}, {18827, -26820}, {18786, -26848}, {18745, -26877}, {18703, -26906}, {18662, -26935},
    {18621, -26963}, {18579, -26992}, {18538, -27020}, {18496, -27049}, {18455, -27077}, {18413, -27105},
    {18372, -27133}, {18330, -27162}, {18288, -27190}, {18247, -27218}, {18205, -27246}, {18163, -27273},
    {18121, -27301}, {18079, -27329}, {18037, -27357}, {17995, -27384}, {17953, -27412}, {17911, -27440},
    {17869, -27467}, {17827, -27494}, {17785, -27522}, {17743, -27549}, {17700, -27576}, {17658, -27603},
    {17616, -27630}, {17573, -27657}, {17531, -27684}, {17488, -27711}, {17446, -27738}, {17403, -27765},
    {17361, -27791}, {17318, -27818}, {17275, -27844}, {17233, -27871}, {17190, -27897}, {17147, -27924},
    {17104, -27950}, {17061, -27976}, {17018, -28002}, {16975, -28028}, {16932, -28054}, {16889, -28080},
    {16846, -28106}, {16803, -28132}, {16760, -28158}, {16717, -28183}, {16673, -28209}, {16630, -28234},
    {16587, -28260}, {16543, -28285}, {16500, -28311}, {16456, -28336}, {16413, -28361}, {16369, -28386},
    {16326, -28411}, {16282, -28436}, {16239, -28461}, {16195, -28486}, {16151, -28511}, {16108, -28536},
    {16064, -28560}, {16020, -28585}, {15976, -28610}, {15932, -28634}, {15888, -28658}, {15844, -28683},
    {15800, -28707}, {15756, -28731}, {15712, -28755}, {15668, -28779}, {15624, -28803}, {15580, -28827},
    {15535, -28851}, {15491, -28875}, {15447, -28899}, {15402, -28922}, {15358, -28946}, {15314, -28970},
    {15269, -28993}, {15225, -29016}, {15180, -29040}, {15136, -29063}, {15091, -29086}, {15046, -29109},
    {15002, -29132}, {14957, -29155}, {14912, -29178}, {14867, -29201}, {14823, -29224}, {14778, -29247},
    {14733, -29269}, {14688, -29292}, {14643, -29314}, {14598, -29337}, {14553, -29359}, {14508, -29381},
    {14463, -29404}, {14418, -29426}, {14373, -29448}, {14327, -29470}, {14282, -29492}, {14237, -29514},
    {14192, -29535}, {14146, -29557}, {14101, -29579}, {14056, -29600}, {14010, -29622}, {13965, -29643},
    {13919, -29665}, {13874, -29686}, {13828, -29707}, {13783, -29729}, {13737, -29750}, {13691, -29771},
    {13646, -29792}, {13600, -29813}, {13554, -29833}, {13508, -29854}, {13463, -29875}, {13417, -29895},
    {13371, -29916}, {13325, -29936}, {13279, -29957}, {13233, -29977}, {13187, -29997}, {13141, -30018},
    {13095, -30038}, {13049, -30058}, {13003, -30078}, {12957, -30098}, {12910, -30118}, {12864, -30137},
    {12818, -30157}, {12772, -30177}, {12725, -30196}, {12679, -30216}, {12633, -30235}, {12586, -30254},
    {12540, -30274}, {12493, -30293}, {12447, -30312}, {12400, -30331}, {12354, -30350}, {12307, -30369},
    {12261, -30388}, {12214, -30407}, {12167, -30425}, {12121, -30444}, {12074, -30462}, {12027, -30481},
    {11980, -30499}, {11934, -30518}, {11887, -30536}, {11840, -30554}, {11793, -30572}, {11746, -30590},
    {11699, -30608}, {11652, -30626}, {11605, -30644}, {11558, -30662}, {11511, -30680}, {11464, -30697},
    {11417, -30715}, {11370, -30732}, {11323, -30750}, {11276, -30767}, {11228, -30784}, {11181, -30801},
    {11134, -30819}, {11087, -30836}, {11039, -30853}, {10992, -30869}, {10945, -30886}, {10897, -30903},
    {10850, -30920}, {10802, -30936}, {10755, -30953}, {10707, -30969}, {10660, -30986}, {10612, -31002},
    {10565, -31018}, {10517, -31034}, {10469, -31050}, {10422, -31067}, {10374, -31082}, {10326, -31098},
    {10279, -31114}, {10231, -31130}, {10183, -31146}, {10135, -31161}, {10088, -31177}, {10040, -31192},
    {9992, -31207},  {9944, -31223},  {9896, -31238},  {9848, -31253},  {9800, -31268},  {9752, -31283},
    {9704, -31298},  {9656, -31313},  {9608, -31328},  {9560, -31342},  {9512, -31357},  {9464, -31372},
    {9416, -31386},  {9368, -31400},  {9319, -31415},  {9271, -31429},  {9223, -31443},  {9175, -31457},
    {9127, -31471},  {9078, -31485},  {9030, -31499},  {8982, -31513},  {8933, -31527},  {8885, -31540},
    {8836, -31554},  {8788, -31568},  {8740, -31581},  {8691, -31594},  {8643, -31608},  {8594, -31621},
    {8546, -31634},  {8497, -31647},  {8449, -31660},  {8400, -31673},  {8351, -31686},  {8303, -31699},
    {8254, -31711},  {8206, -31724},  {8157, -31737},  {8108, -31749},  {8059, -31761},  {8011, -31774},
    {7962, -31786},  {7913, -31798},  {7864, -31810},  {7816, -31822},  {7767, -31834},  {7718, -31846},
    {7669, -31858},  {7620, -31870},  {7571, -31881},  {7522, -31893},  {7473, -31904},  {7425, -31916},
    {7376, -31927},  {7327, -31938},  {7278, -31950},  {7229, -31961},  {7180, -31972},  {7130, -31983},
    {7081, -31994},  {7032, -32005},  {6983, -32015},  {6934, -32026},  {6885, -32037},  {6836, -32047},
    {6787, -32058},  {6737, -32068},  {6688, -32078},  {6639, -32088},  {6590, -32099},  {6541, -32109},
    {6491, -32119},  {6442, -32129},  {6393, -32138},  {6343, -32148},  {6294, -32158},  {6245, -32167},
    {6195, -32177},  {6146, -32186},  {6097, -32196},  {6047, -32205},  {5998, -32214},  {5948, -32224},
    {5899, -32233},  {5850, -32242},  {5800, -32251},  {5751, -32259},  {5701, -32268},  {5652, -32277},
    {5602, -32286},  {5553, -32294},  {5503, -32303},  {5453, -32311},  {5404, -32319},  {5354, -32328},
    {5305, -32336},  {5255, -32344},  {5205, -32352},  {5156, -32360},  {5106, -32368},  {5057, -32376},
    {5007, -32383},  {4957, -32391},  {4907, -32398},  {4858, -32406},  {4808, -32413},  {4758, -32421},
    {4709, -32428},  {4659, -32435},  {4609, -32442},  {4559, -32449},  {4510, -32456},  {4460, -32463},
    {4410, -32470},  {4360, -32477},  {4310, -32483},  {4260, -32490},  {4211, -32496},  {4161, -32503},
    {4111, -32509},  {4061, -32515},  {4011, -32522},  {3961, -32528},  {3911, -32534},  {3861, -32540},
    {3812, -32546},  {3762, -32551},  {3712, -32557},  {3662, -32563},  {3612, -32568},  {3562, -32574},
    {3512, -32579},  {3462, -32585},  {3412, -32590},  {3362, -32595},  {3312, -32600},  {3262, -32605},
    {3212, -32610},  {3162, -32615},  {3112, -32620},  {3062, -32625},  {3012, -32629},  {2962, -32634},
    {2912, -32638},  {2861, -32643},  {2811, -32647},  {2761, -32651},  {2711, -32656},  {2661, -32660},
    {2611, -32664},  {2561, -32668},  {2511, -32672},  {2461, -32675},  {2411, -32679},  {2360, -32683},
    {2310, -32686},  {2260, -32690},  {2210, -32693},  {2160, -32697},  {2110, -32700},  {2060, -32703},
    {2009, -32706},  {1959, -32709},  {1909, -32712},  {1859, -32715},  {1809, -32718},  {1758, -32721},
    {1708, -32723},  {1658, -32726},  {1608, -32729},  {1558, -32731},  {1507, -32733},  {1457, -32736},
    {1407, -32738},  {1357, -32740},  {1307, -32742},  {1256, -32744},  {1206, -32746},  {1156, -32748},
    {1106, -32749},  {1055, -32751},  {1005, -32753},  {955, -32754},   {905, -32756},   {854, -32757},
    {804, -32758},   {754, -32759},   {704, -32760},   {653, -32761},   {603, -32762},   {553, -32763},
    {503, -32764},   {452, -32765},   {402, -32766},   {352, -32766},   {302, -32767},   {251, -32767},
    {201, -32767},   {151, -32768},   {101, -32768},   {50, -32768}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw1024[FFT_1024] = {
    {32767, 0},       {32767, -101},    {32767, -201},    {32767, -302},    {32766, -402},    {32764, -503},
    {32762, -603},    {32760, -704},    {32758, -804},    {32756, -905},    {32753, -1005},   {32749, -1106},
    {32746, -1206},   {32742, -1307},   {32738, -1407},   {32733, -1507},   {32729, -1608},   {32723, -1708},
    {32718, -1809},   {32712, -1909},   {32706, -2009},   {32700, -2110},   {32693, -2210},   {32686, -2310},
    {32679, -2411},   {32672, -2511},   {32664, -2611},   {32656, -2711},   {32647, -2811},   {32638, -2912},
    {32629, -3012},   {32620, -3112},   {32610, -3212},   {32600, -3312},   {32590, -3412},   {32579, -3512},
    {32568, -3612},   {32557, -3712},   {32546, -3812},   {32534, -3911},   {32522, -4011},   {32509, -4111},
    {32496, -4211},   {32483, -4310},   {32470, -4410},   {32456, -4510},   {32442, -4609},   {32428, -4709},
    {32413, -4808},   {32398, -4907},   {32383, -5007},   {32368, -5106},   {32352, -5205},   {32336, -5305},
    {32319, -5404},   {32303, -5503},   {32286, -5602},   {32268, -5701},   {32251, -5800},   {32233, -5899},
    {32214, -5998},   {32196, -6097},   {32177, -6195},   {32158, -6294},   {32138, -6393},   {32119, -6491},
    {32099, -6590},   {32078, -6688},   {32058, -6787},   {32037, -6885},   {32015, -6983},   {31994, -7081},
    {31972, -7180},   {31950, -7278},   {31927, -7376},   {31904, -7473},   {31881, -7571},   {31858, -7669},
    {31834, -7767},   {31810, -7864},   {31786, -7962},   {31761, -8059},   {31737, -8157},   {31711, -8254},
    {31686, -8351},   {31660, -8449},   {31634, -8546},   {31608, -8643},   {31581, -8740},   {31554, -8836},
    {31527, -8933},   {31499, -9030},   {31471, -9127},   {31443, -9223},   {31415, -9319},   {31386, -9416},
    {31357, -9512},   {31328, -9608},   {31298, -9704},   {31268, -9800},   {31238, -9896},   {31207, -9992},
    {31177, -10088},  {31146, -10183},  {31114, -10279},  {31082, -10374},  {31050, -10469},  {31018, -10565},
    {30986, -10660},  {30953, -10755},  {30920, -10850},  {30886, -10945},  {30853, -11039},  {30819, -11134},
    {30784, -11228},  {30750, -11323},  {30715, -11417},  {30680, -11511},  {30644, -11605},  {30608, -11699},
    {30572, -11793},  {30536, -11887},  {30499, -11980},  {30462, -12074},  {30425, -12167},  {30388, -12261},
    {30350, -12354},  {30312, -12447},  {30274, -12540},  {30235, -12633},  {30196, -12725},  {30157, -12818},
    {30118, -12910},  {30078, -13003},  {30038, -13095},  {29997, -13187},  {29957, -13279},  {29916, -13371},
    {29875, -13463},  {29833, -13554},  {29792, -13646},  {29750, -13737},  {29707, -13828},  {29665, -13919},
    {29622, -14010},  {29579, -14101},  {29535, -14192},  {29492, -14282},  {29448, -14373},  {29404, -14463},
    {29359, -14553},  {29314, -14643},  {29269, -14733},  {29224, -14823},  {29178, -14912},  {29132, -15002},
    {29086, -15091},  {29040, -15180},  {28993, -15269},  {28946, -15358},  {28899, -15447},  {28851, -15535},
    {28803, -15624},  {28755, -15712},  {28707, -15800},  {28658, -15888},  {28610, -15976},  {28560, -16064},
    {28511, -16151},  {28461, -16239},  {28411, -16326},  {28361, -16413},  {28311, -16500},  {28260, -16587},
    {28209, -16673},  {28158, -16760},  {28106, -16846},  {28054, -16932},  {28002, -17018},  {27950, -17104},
    {27897, -17190},  {27844, -17275},  {27791, -17361},  {27738, -17446},  {27684, -17531},  {27630, -17616},
    {27576, -17700},  {27522, -17785},  {27467, -17869},  {27412, -17953},  {27357, -18037},  {27301, -18121},
    {27246, -18205},  {27190, -18288},  {27133, -18372},  {27077, -18455},  {27020, -18538},  {26963, -18621},
    {26906, -18703},  {26848, -18786},  {26791, -18868},  {26733, -18950},  {26674, -19032},  {26616, -19114},
    {26557, -19195},  {26498, -19277},  {26439, -19358},  {26379, -19439},  {26320, -19520},  {26259, -19601},
    {26199, -19681},  {26139, -19761},  {26078, -19841},  {26017, -19921},  {25956, -20001},  {25894, -20081},
    {25833, -20160},  {25771, -20239},  {25708, -20318},  {25646, -20397},  {25583, -20475},  {25520, -20554},
    {25457, -20632},  {25394, -20710},  {25330, -20788},  {25266, -20865},  {25202, -20943},  {25138, -21020},
    {25073, -21097},  {25008, -21174},  {24943, -21251},  {24878, -21327},  {24812, -21403},  {24746, -21479},
    {24680, -21555},  {24614, -21631},  {24548, -21706},  {24481, -21781},  {24414, -21856},  {24347, -21931},
    {24279, -22006},  {24212, -22080},  {24144, -22154},  {24076, -22228},  {24008, -22302},  {23939, -22375},
    {23870, -22449},  {23801, -22522},  {23732, -22595},  {23663, -22668},  {23593, -22740},  {23523, -22812},
    {23453, -22884},  {23383, -22956},  {23312, -23028},  {23241, -23099},  {23170, -23170},  {23099, -23241},
    {23028, -23312},  {22956, -23383},  {22884, -23453},  {22812, -23523},  {22740, -23593},  {22668, -23663},
    {22595, -23732},  {22522, -23801},  {22449, -23870},  {22375, -23939},  {22302, -24008},  {22228, -24076},
    {22154, -24144},  {22080, -24212},  {22006, -24279},  {21931, -24347},  {21856, -24414},  {21781, -24481},
    {21706, -24548},  {21631, -24614},  {21555, -24680},  {21479, -24746},  {21403, -24812},  {21327, -24878},
    {21251, -24943},  {21174, -25008},  {21097, -25073},  {21020, -25138},  {20943, -25202},  {20865, -25266},
    {20788, -25330},  {20710, -25394},  {20632, -25457},  {20554, -25520},  {20475, -25583},  {20397, -25646},
    {20318, -25708},  {20239, -25771},  {20160, -25833},  {20081, -25894},  {20001, -25956},  {19921, -26017},
    {19841, -26078},  {19761, -26139},  {19681, -26199},  {19601, -26259},  {19520, -26320},  {19439, -26379},
    {19358, -26439},  {19277, -26498},  {19195, -26557},  {19114, -26616},  {19032, -26674},  {18950, -26733},
    {18868, -26791},  {18786, -26848},  {18703, -26906},  {18621, -26963},  {18538, -27020},  {18455, -27077},
    {18372, -27133},  {18288, -27190},  {18205, -27246},  {18121, -27301},  {18037, -27357},  {17953, -27412},
    {17869, -27467},  {17785, -27522},  {17700, -27576},  {17616, -27630},  {17531, -27684},  {17446, -27738},
    {17361, -27791},  {17275, -27844},  {17190, -27897},  {17104, -27950},  {17018, -28002},  {16932, -28054},
    {16846, -28106},  {16760, -28158},  {16673, -28209},  {16587, -28260},  {16500, -28311},  {16413, -28361},
    {16326, -28411},  {16239, -28461},  {16151, -28511},  {16064, -28560},  {15976, -28610},  {15888, -28658},
    {15800, -28707},  {15712, -28755},  {15624, -28803},  {15535, -28851},  {15447, -28899},  {15358, -28946},
    {15269, -28993},  {15180, -29040},  {15091, -29086},  {15002, -29132},  {14912, -29178},  {14823, -29224},
    {14733, -29269},  {14643, -29314},  {14553, -29359},  {14463, -29404},  {14373, -29448},  {14282, -29492},
    {14192, -29535},  {14101, -29579},  {14010, -29622},  {13919, -29665},  {13828, -29707},  {13737, -29750},
    {13646, -29792},  {13554, -29833},  {13463, -29875},  {13371, -29916},  {13279, -29957},  {13187, -29997},
    {13095, -30038},  {13003, -30078},  {12910, -30118},  {12818, -30157},  {12725, -30196},  {12633, -30235},
    {12540, -30274},  {12447, -30312},  {12354, -30350},  {12261, -30388},  {12167, -30425},  {12074, -30462},
    {11980, -30499},  {11887, -30536},  {11793, -30572},  {11699, -30608},  {11605, -30644},  {11511, -30680},
    {11417, -30715},  {11323, -30750},  {11228, -30784},  {11134, -30819},  {11039, -30853},  {10945, -30886},
    {10850, -30920},  {10755, -30953},  {10660, -30986},  {10565, -31018},  {10469, -31050},  {10374, -31082},
    {10279, -31114},  {10183, -31146},  {10088, -31177},  {9992, -31207},   {9896, -31238},   {9800, -31268},
    {9704, -31298},   {9608, -31328},   {9512, -31357},   {9416, -31386},   {9319, -31415},   {9223, -31443},
    {9127, -31471},   {9030, -31499},   {8933, -31527},   {8836, -31554},   {8740, -31581},   {8643, -31608},
    {8546, -31634},   {8449, -31660},   {8351, -31686},   {8254, -31711},   {8157, -31737},   {8059, -31761},
    {7962, -31786},   {7864, -31810},   {7767, -31834},   {7669, -31858},   {7571, -31881},   {7473, -31904},
    {7376, -31927},   {7278, -31950},   {7180, -31972},   {7081, -31994},   {6983, -32015},   {6885, -32037},
    {6787, -32058},   {6688, -32078},   {6590, -32099},   {6491, -32119},   {6393, -32138},   {6294, -32158},
    {6195, -32177},   {6097, -32196},   {5998, -32214},   {5899, -32233},   {5800, -32251},   {5701, -32268},
    {5602, -32286},   {5503, -32303},   {5404, -32319},   {5305, -32336},   {5205, -32352},   {5106, -32368},
    {5007, -32383},   {4907, -32398},   {4808, -32413},   {4709, -32428},   {4609, -32442},   {4510, -32456},
    {4410, -32470},   {4310, -32483},   {4211, -32496},   {4111, -32509},   {4011, -32522},   {3911, -32534},
    {3812, -32546},   {3712, -32557},   {3612, -32568},   {3512, -32579},   {3412, -32590},   {3312, -32600},
    {3212, -32610},   {3112, -32620},   {3012, -32629},   {2912, -32638},   {2811, -32647},   {2711, -32656},
    {2611, -32664},   {2511, -32672},   {2411, -32679},   {2310, -32686},   {2210, -32693},   {2110, -32700},
    {2009, -32706},   {1909, -32712},   {1809, -32718},   {1708, -32723},   {1608, -32729},   {1507, -32733},
    {1407, -32738},   {1307, -32742},   {1206, -32746},   {1106, -32749},   {1005, -32753},   {905, -32756},
    {804, -32758},    {704, -32760},    {603, -32762},    {503, -32764},    {402, -32766},    {302, -32767},
    {201, -32767},    {101, -32768},    {0, -32768},      {-101, -32768},   {-201, -32767},   {-302, -32767},
    {-402, -32766},   {-503, -32764},   {-603, -32762},   {-704, -32760},   {-804, -32758},   {-905, -32756},
    {-1005, -32753},  {-1106, -32749},  {-1206, -32746},  {-1307, -32742},  {-1407, -32738},  {-1507, -32733},
    {-1608, -32729},  {-1708, -32723},  {-1809, -32718},  {-1909, -32712},  {-2009, -32706},  {-2110, -32700},
    {-2210, -32693},  {-2310, -32686},  {-2411, -32679},  {-2511, -32672},  {-2611, -32664},  {-2711, -32656},
    {-2811, -32647},  {-2912, -32638},  {-3012, -32629},  {-3112, -32620},  {-3212, -32610},  {-3312, -32600},
    {-3412, -32590},  {-3512, -32579},  {-3612, -32568},  {-3712, -32557},  {-3812, -32546},  {-3911, -32534},
    {-4011, -32522},  {-4111, -32509},  {-4211, -32496},  {-4310, -32483},  {-4410, -32470},  {-4510, -32456},
    {-4609, -32442},  {-4709, -32428},  {-4808, -32413},  {-4907, -32398},  {-5007, -32383},  {-5106, -32368},
    {-5205, -32352},  {-5305, -32336},  {-5404, -32319},  {-5503, -32303},  {-5602, -32286},  {-5701, -32268},
    {-5800, -32251},  {-5899, -32233},  {-5998, -32214},  {-6097, -32196},  {-6195, -32177},  {-6294, -32158},
    {-6393, -32138},  {-6491, -32119},  {-6590, -32099},  {-6688, -32078},  {-6787, -32058},  {-6885, -32037},
    {-6983, -32015},  {-7081, -31994},  {-7180, -31972},  {-7278, -31950},  {-7376, -31927},  {-7473, -31904},
    {-7571, -31881},  {-7669, -31858},  {-7767, -31834},  {-7864, -31810},  {-7962, -31786},  {-8059, -31761},
    {-8157, -31737},  {-8254, -31711},  {-8351, -31686},  {-8449, -31660},  {-8546, -31634},  {-8643, -31608},
    {-8740, -31581},  {-8836, -31554},  {-8933, -31527},  {-9030, -31499},  {-9127, -31471},  {-9223, -31443},
    {-9319, -31415},  {-9416, -31386},  {-9512, -31357},  {-9608, -31328},  {-9704, -31298},  {-9800, -31268},
    {-9896, -31238},  {-9992, -31207},  {-10088, -31177}, {-10183, -31146}, {-10279, -31114}, {-10374, -31082},
    {-10469, -31050}, {-10565, -31018}, {-10660, -30986}, {-10755, -30953}, {-10850, -30920}, {-10945, -30886},
    {-11039, -30853}, {-11134, -30819}, {-11228, -30784}, {-11323, -30750}, {-11417, -30715}, {-11511, -30680},
    {-11605, -30644}, {-11699, -30608}, {-11793, -30572}, {-11887, -30536}, {-11980, -30499}, {-12074, -30462},
    {-12167, -30425}, {-12261, -30388}, {-12354, -30350}, {-12447, -30312}, {-12540, -30274}, {-12633, -30235},
    {-12725, -30196}, {-12818, -30157}, {-12910, -30118}, {-13003, -30078}, {-13095, -30038}, {-13187, -29997},
    {-13279, -29957}, {-13371, -29916}, {-13463, -29875}, {-13554, -29833}, {-13646, -29792}, {-13737, -29750},
    {-13828, -29707}, {-13919, -29665}, {-14010, -29622}, {-14101, -29579}, {-14192, -29535}, {-14282, -29492},
    {-14373, -29448}, {-14463, -29404}, {-14553, -29359}, {-14643, -29314}, {-14733, -29269}, {-14823, -29224},
    {-14912, -29178}, {-15002, -29132}, {-15091, -29086}, {-15180, -29040}, {-15269, -28993}, {-15358, -28946},
    {-15447, -28899}, {-15535, -28851}, {-15624, -28803}, {-15712, -28755}, {-15800, -28707}, {-15888, -28658},
    {-15976, -28610}, {-16064, -28560}, {-16151, -28511}, {-16239, -28461}, {-16326, -28411}, {-16413, -28361},
    {-16500, -28311}, {-16587, -28260}, {-16673, -28209}, {-16760, -28158}, {-16846, -28106}, {-16932, -28054},
    {-17018, -28002}, {-17104, -27950}, {-17190, -27897}, {-17275, -27844}, {-17361, -27791}, {-17446, -27738},
    {-17531, -27684}, {-17616, -27630}, {-17700, -27576}, {-17785, -27522}, {-17869, -27467}, {-17953, -27412},
    {-18037, -27357}, {-18121, -27301}, {-18205, -27246}, {-18288, -27190}, {-18372, -27133}, {-18455, -27077},
    {-18538, -27020}, {-18621, -26963}, {-18703, -26906}, {-18786, -26848}, {-18868, -26791}, {-18950, -26733},
    {-19032, -26674}, {-19114, -26616}, {-19195, -26557}, {-19277, -26498}, {-19358, -26439}, {-19439, -26379},
    {-19520, -26320}, {-19601, -26259}, {-19681, -26199}, {-19761, -26139}, {-19841, -26078}, {-19921, -26017},
    {-20001, -25956}, {-20081, -25894}, {-20160, -25833}, {-20239, -25771}, {-20318, -25708}, {-20397, -25646},
    {-20475, -25583}, {-20554, -25520}, {-20632, -25457}, {-20710, -25394}, {-20788, -25330}, {-20865, -25266},
    {-20943, -25202}, {-21020, -25138}, {-21097, -25073}, {-21174, -25008}, {-21251, -24943}, {-21327, -24878},
    {-21403, -24812}, {-21479, -24746}, {-21555, -24680}, {-21631, -24614}, {-21706, -24548}, {-21781, -24481},
    {-21856, -24414}, {-21931, -24347}, {-22006, -24279}, {-22080, -24212}, {-22154, -24144}, {-22228, -24076},
    {-22302, -24008}, {-22375, -23939}, {-22449, -23870}, {-22522, -23801}, {-22595, -23732}, {-22668, -23663},
    {-22740, -23593}, {-22812, -23523}, {-22884, -23453}, {-22956, -23383}, {-23028, -23312}, {-23099, -23241},
    {-23170, -23170}, {-23241, -23099}, {-23312, -23028}, {-23383, -22956}, {-23453, -22884}, {-23523, -22812},
    {-23593, -22740}, {-23663, -22668}, {-23732, -22595}, {-23801, -22522}, {-23870, -22449}, {-23939, -22375},
    {-24008, -22302}, {-24076, -22228}, {-24144, -22154}, {-24212, -22080}, {-24279, -22006}, {-24347, -21931},
    {-24414, -21856}, {-24481, -21781}, {-24548, -21706}, {-24614, -21631}, {-24680, -21555}, {-24746, -21479},
    {-24812, -21403}, {-24878, -21327}, {-24943, -21251}, {-25008, -21174}, {-25073, -21097}, {-25138, -21020},
    {-25202, -20943}, {-25266, -20865}, {-25330, -20788}, {-25394, -20710}, {-25457, -20632}, {-25520, -20554},
    {-25583, -20475}, {-25646, -20397}, {-25708, -20318}, {-25771, -20239}, {-25833, -20160}, {-25894, -20081},
    {-25956, -20001}, {-26017, -19921}, {-26078, -19841}, {-26139, -19761}, {-26199, -19681}, {-26259, -19601},
    {-26320, -19520}, {-26379, -19439}, {-26439, -19358}, {-26498, -19277}, {-26557, -19195}, {-26616, -19114},
    {-26674, -19032}, {-26733, -18950}, {-26791, -18868}, {-26848, -18786}, {-26906, -18703}, {-26963, -18621},
    {-27020, -18538}, {-27077, -18455}, {-27133, -18372}, {-27190, -18288}, {-27246, -18205}, {-27301, -18121},
    {-27357, -18037}, {-27412, -17953}, {-27467, -17869}, {-27522, -17785}, {-27576, -17700}, {-27630, -17616},
    {-27684, -17531}, {-27738, -17446}, {-27791, -17361}, {-27844, -17275}, {-27897, -17190}, {-27950, -17104},
    {-28002, -17018}, {-28054, -16932}, {-28106, -16846}, {-28158, -16760}, {-28209, -16673}, {-28260, -16587},
    {-28311, -16500}, {-28361, -16413}, {-28411, -16326}, {-28461, -16239}, {-28511, -16151}, {-28560, -16064},
    {-28610, -15976}, {-28658, -15888}, {-28707, -15800}, {-28755, -15712}, {-28803, -15624}, {-28851, -15535},
    {-28899, -15447}, {-28946, -15358}, {-28993, -15269}, {-29040, -15180}, {-29086, -15091}, {-29132, -15002},
    {-29178, -14912}, {-29224, -14823}, {-29269, -14733}, {-29314, -14643}, {-29359, -14553}, {-29404, -14463},
    {-29448, -14373}, {-29492, -14282}, {-29535, -14192}, {-29579, -14101}, {-29622, -14010}, {-29665, -13919},
    {-29707, -13828}, {-29750, -13737}, {-29792, -13646}, {-29833, -13554}, {-29875, -13463}, {-29916, -13371},
    {-29957, -13279}, {-29997, -13187}, {-30038, -13095}, {-30078, -13003}, {-30118, -12910}, {-30157, -12818},
    {-30196, -12725}, {-30235, -12633}, {-30274, -12540}, {-30312, -12447}, {-30350, -12354}, {-30388, -12261},
    {-30425, -12167}, {-30462, -12074}, {-30499, -11980}, {-30536, -11887}, {-30572, -11793}, {-30608, -11699},
    {-30644, -11605}, {-30680, -11511}, {-30715, -11417}, {-30750, -11323}, {-30784, -11228}, {-30819, -11134},
    {-30853, -11039}, {-30886, -10945}, {-30920, -10850}, {-30953, -10755}, {-30986, -10660}, {-31018, -10565},
    {-31050, -10469}, {-31082, -10374}, {-31114, -10279}, {-31146, -10183}, {-31177, -10088}, {-31207, -9992},
    {-31238, -9896},  {-31268, -9800},  {-31298, -9704},  {-31328, -9608},  {-31357, -9512},  {-31386, -9416},
    {-31415, -9319},  {-31443, -9223},  {-31471, -9127},  {-31499, -9030},  {-31527, -8933},  {-31554, -8836},
    {-31581, -8740},  {-31608, -8643},  {-31634, -8546},  {-31660, -8449},  {-31686, -8351},  {-31711, -8254},
    {-31737, -8157},  {-31761, -8059},  {-31786, -7962},  {-31810, -7864},  {-31834, -7767},  {-31858, -7669},
    {-31881, -7571},  {-31904, -7473},  {-31927, -7376},  {-31950, -7278},  {-31972, -7180},  {-31994, -7081},
    {-32015, -6983},  {-32037, -6885},  {-32058, -6787},  {-32078, -6688},  {-32099, -6590},  {-32119, -6491},
    {-32138, -6393},  {-32158, -6294},  {-32177, -6195},  {-32196, -6097},  {-32214, -5998},  {-32233, -5899},
    {-32251, -5800},  {-32268, -5701},  {-32286, -5602},  {-32303, -5503},  {-32319, -5404},  {-32336, -5305},
    {-32352, -5205},  {-32368, -5106},  {-32383, -5007},  {-32398, -4907},  {-32413, -4808},  {-32428, -4709},
    {-32442, -4609},  {-32456, -4510},  {-32470, -4410},  {-32483, -4310},  {-32496, -4211},  {-32509, -4111},
    {-32522, -4011},  {-32534, -3911},  {-32546, -3812},  {-32557, -3712},  {-32568, -3612},  {-32579, -3512},
    {-32590, -3412},  {-32600, -3312},  {-32610, -3212},  {-32620, -3112},  {-32629, -3012},  {-32638, -2912},
    {-32647, -2811},  {-32656, -2711},  {-32664, -2611},  {-32672, -2511},  {-32679, -2411},  {-32686, -2310},
    {-32693, -2210},  {-32700, -2110},  {-32706, -2009},  {-32712, -1909},  {-32718, -1809},  {-32723, -1708},
    {-32729, -1608},  {-32733, -1507},  {-32738, -1407},  {-32742, -1307},  {-32746, -1206},  {-32749, -1106},
    {-32753, -1005},  {-32756, -905},   {-32758, -804},   {-32760, -704},   {-32762, -603},   {-32764, -503},
    {-32766, -402},   {-32767, -302},   {-32767, -201},   {-32768, -101}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw1024_half[FFT_1024 / 2] = {
    {32767, 0},      {32767, -101},   {32767, -201},   {32767, -302},   {32766, -402},   {32764, -503},
    {32762, -603},   {32760, -704},   {32758, -804},   {32756, -905},   {32753, -1005},  {32749, -1106},
    {32746, -1206},  {32742, -1307},  {32738, -1407},  {32733, -1507},  {32729, -1608},  {32723, -1708},
    {32718, -1809},  {32712, -1909},  {32706, -2009},  {32700, -2110},  {32693, -2210},  {32686, -2310},
    {32679, -2411},  {32672, -2511},  {32664, -2611},  {32656, -2711},  {32647, -2811},  {32638, -2912},
    {32629, -3012},  {32620, -3112},  {32610, -3212},  {32600, -3312},  {32590, -3412},  {32579, -3512},
    {32568, -3612},  {32557, -3712},  {32546, -3812},  {32534, -3911},  {32522, -4011},  {32509, -4111},
    {32496, -4211},  {32483, -4310},  {32470, -4410},  {32456, -4510},  {32442, -4609},  {32428, -4709},
    {32413, -4808},  {32398, -4907},  {32383, -5007},  {32368, -5106},  {32352, -5205},  {32336, -5305},
    {32319, -5404},  {32303, -5503},  {32286, -5602},  {32268, -5701},  {32251, -5800},  {32233, -5899},
    {32214, -5998},  {32196, -6097},  {32177, -6195},  {32158, -6294},  {32138, -6393},  {32119, -6491},
    {32099, -6590},  {32078, -6688},  {32058, -6787},  {32037, -6885},  {32015, -6983},  {31994, -7081},
    {31972, -7180},  {31950, -7278},  {31927, -7376},  {31904, -7473},  {31881, -7571},  {31858, -7669},
    {31834, -7767},  {31810, -7864},  {31786, -7962},  {31761, -8059},  {31737, -8157},  {31711, -8254},
    {31686, -8351},  {31660, -8449},  {31634, -8546},  {31608, -8643},  {31581, -8740},  {31554, -8836},
    {31527, -8933},  {31499, -9030},  {31471, -9127},  {31443, -9223},  {31415, -9319},  {31386, -9416},
    {31357, -9512},  {31328, -9608},  {31298, -9704},  {31268, -9800},  {31238, -9896},  {31207, -9992},
    {31177, -10088}, {31146, -10183}, {31114, -10279}, {31082, -10374}, {31050, -10469}, {31018, -10565},
    {30986, -10660}, {30953, -10755}, {30920, -10850}, {30886, -10945}, {30853, -11039}, {30819, -11134},
    {30784, -11228}, {30750, -11323}, {30715, -11417}, {30680, -11511}, {30644, -11605}, {30608, -11699},
    {30572, -11793}, {30536, -11887}, {30499, -11980}, {30462, -12074}, {30425, -12167}, {30388, -12261},
    {30350, -12354}, {30312, -12447}, {30274, -12540}, {30235, -12633}, {30196, -12725}, {30157, -12818},
    {30118, -12910}, {30078, -13003}, {30038, -13095}, {29997, -13187}, {29957, -13279}, {29916, -13371},
    {29875, -13463}, {29833, -13554}, {29792, -13646}, {29750, -13737}, {29707, -13828}, {29665, -13919},
    {29622, -14010}, {29579, -14101}, {29535, -14192}, {29492, -14282}, {29448, -14373}, {29404, -14463},
    {29359, -14553}, {29314, -14643}, {29269, -14733}, {29224, -14823}, {29178, -14912}, {29132, -15002},
    {29086, -15091}, {29040, -15180}, {28993, -15269}, {28946, -15358}, {28899, -15447}, {28851, -15535},
    {28803, -15624}, {28755, -15712}, {28707, -15800}, {28658, -15888}, {28610, -15976}, {28560, -16064},
    {28511, -16151}, {28461, -16239}, {28411, -16326}, {28361, -16413}, {28311, -16500}, {28260, -16587},
    {28209, -16673}, {28158, -16760}, {28106, -16846}, {28054, -16932}, {28002, -17018}, {27950, -17104},
    {27897, -17190}, {27844, -17275}, {27791, -17361}, {27738, -17446}, {27684, -17531}, {27630, -17616},
    {27576, -17700}, {27522, -17785}, {27467, -17869}, {27412, -17953}, {27357, -18037}, {27301, -18121},
    {27246, -18205}, {27190, -18288}, {27133, -18372}, {27077, -18455}, {27020, -18538}, {26963, -18621},
    {26906, -18703}, {26848, -18786}, {26791, -18868}, {26733, -18950}, {26674, -19032}, {26616, -19114},
    {26557, -19195}, {26498, -19277}, {26439, -19358}, {26379, -19439}, {26320, -19520}, {26259, -19601},
    {26199, -19681}, {26139, -19761}, {26078, -19841}, {26017, -19921}, {25956, -20001}, {25894, -20081},
    {25833, -20160}, {25771, -20239}, {25708, -20318}, {25646, -20397}, {25583, -20475}, {25520, -20554},
    {25457, -20632}, {25394, -20710}, {25330, -20788}, {25266, -20865}, {25202, -20943}, {25138, -21020},
    {25073, -21097}, {25008, -21174}, {24943, -21251}, {24878, -21327}, {24812, -21403}, {24746, -21479},
    {24680, -21555}, {24614, -21631}, {24548, -21706}, {24481, -21781}, {24414, -21856}, {24347, -21931},
    {24279, -22006}, {24212, -22080}, {24144, -22154}, {24076, -22228}, {24008, -22302}, {23939, -22375},
    {23870, -22449}, {23801, -22522}, {23732, -22595}, {23663, -22668}, {23593, -22740}, {23523, -22812},
    {23453, -22884}, {23383, -22956}, {23312, -23028}, {23241, -23099}, {23170, -23170}, {23099, -23241},
    {23028, -23312}, {22956, -23383}, {22884, -23453}, {22812, -23523}, {22740, -23593}, {22668, -23663},
    {22595, -23732}, {22522, -23801}, {22449, -23870}, {22375, -23939}, {22302, -24008}, {22228, -24076},
    {22154, -24144}, {22080, -24212}, {22006, -24279}, {21931, -24347}, {21856, -24414}, {21781, -24481},
    {21706, -24548}, {21631, -24614}, {21555, -24680}, {21479, -24746}, {21403, -24812}, {21327, -24878},
    {21251, -24943}, {21174, -25008}, {21097, -25073}, {21020, -25138}, {20943, -25202}, {20865, -25266},
    {20788, -25330}, {20710, -25394}, {20632, -25457}, {20554, -25520}, {20475, -25583}, {20397, -25646},
    {20318, -25708}, {20239, -25771}, {20160, -25833}, {20081, -25894}, {20001, -25956}, {19921, -26017},
    {19841, -26078}, {19761, -26139}, {19681, -26199}, {19601, -26259}, {19520, -26320}, {19439, -26379},
    {19358, -26439}, {19277, -26498}, {19195, -26557}, {19114, -26616}, {19032, -26674}, {18950, -26733},
    {18868, -26791}, {18786, -26848}, {18703, -26906}, {18621, -26963}, {18538, -27020}, {18455, -27077},
    {18372, -27133}, {18288, -27190}, {18205, -27246}, {18121, -27301}, {18037, -27357}, {17953, -27412},
    {17869, -27467}, {17785, -27522}, {17700, -27576}, {17616, -27630}, {17531, -27684}, {17446, -27738},
    {17361, -27791}, {17275, -27844}, {17190, -27897}, {17104, -27950}, {17018, -28002}, {16932, -28054},
    {16846, -28106}, {16760, -28158}, {16673, -28209}, {16587, -28260}, {16500, -28311}, {16413, -28361},
    {16326, -28411}, {16239, -28461}, {16151, -28511}, {16064, -28560}, {15976, -28610}, {15888, -28658},
    {15800, -28707}, {15712, -28755}, {15624, -28803}, {15535, -28851}, {15447, -28899}, {15358, -28946},
    {15269, -28993}, {15180, -29040}, {15091, -29086}, {15002, -29132}, {14912, -29178}, {14823, -29224},
    {14733, -29269}, {14643, -29314}, {14553, -29359}, {14463, -29404}, {14373, -29448}, {14282, -29492},
    {14192, -29535}, {14101, -29579}, {14010, -29622}, {13919, -29665}, {13828, -29707}, {13737, -29750},
    {13646, -29792}, {13554, -29833}, {13463, -29875}, {13371, -29916}, {13279, -29957}, {13187, -29997},
    {13095, -30038}, {13003, -30078}, {12910, -30118}, {12818, -30157}, {12725, -30196}, {12633, -30235},
    {12540, -30274}, {12447, -30312}, {12354, -30350}, {12261, -30388}, {12167, -30425}, {12074, -30462},
    {11980, -30499}, {11887, -30536}, {11793, -30572}, {11699, -30608}, {11605, -30644}, {11511, -30680},
    {11417, -30715}, {11323, -30750}, {11228, -30784}, {11134, -30819}, {11039, -30853}, {10945, -30886},
    {10850, -30920}, {10755, -30953}, {10660, -30986}, {10565, -31018}, {10469, -31050}, {10374, -31082},
    {10279, -31114}, {10183, -31146}, {10088, -31177}, {9992, -31207},  {9896, -31238},  {9800, -31268},
    {9704, -31298},  {9608, -31328},  {9512, -31357},  {9416, -31386},  {9319, -31415},  {9223, -31443},
    {9127, -31471},  {9030, -31499},  {8933, -31527},  {8836, -31554},  {8740, -31581},  {8643, -31608},
    {8546, -31634},  {8449, -31660},  {8351, -31686},  {8254, -31711},  {8157, -31737},  {8059, -31761},
    {7962, -31786},  {7864, -31810},  {7767, -31834},  {7669, -31858},  {7571, -31881},  {7473, -31904},
    {7376, -31927},  {7278, -31950},  {7180, -31972},  {7081, -31994},  {6983, -32015},  {6885, -32037},
    {6787, -32058},  {6688, -32078},  {6590, -32099},  {6491, -32119},  {6393, -32138},  {6294, -32158},
    {6195, -32177},  {6097, -32196},  {5998, -32214},  {5899, -32233},  {5800, -32251},  {5701, -32268},
    {5602, -32286},  {5503, -32303},  {5404, -32319},  {5305, -32336},  {5205, -32352},  {5106, -32368},
    {5007, -32383},  {4907, -32398},  {4808, -32413},  {4709, -32428},  {4609, -32442},  {4510, -32456},
    {4410, -32470},  {4310, -32483},  {4211, -32496},  {4111, -32509},  {4011, -32522},  {3911, -32534},
    {3812, -32546},  {3712, -32557},  {3612, -32568},  {3512, -32579},  {3412, -32590},  {3312, -32600},
    {3212, -32610},  {3112, -32620},  {3012, -32629},  {2912, -32638},  {2811, -32647},  {2711, -32656},
    {2611, -32664},  {2511, -32672},  {2411, -32679},  {2310, -32686},  {2210, -32693},  {2110, -32700},
    {2009, -32706},  {1909, -32712},  {1809, -32718},  {1708, -32723},  {1608, -32729},  {1507, -32733},
    {1407, -32738},  {1307, -32742},  {1206, -32746},  {1106, -32749},  {1005, -32753},  {905, -32756},
    {804, -32758},   {704, -32760},   {603, -32762},   {503, -32764},   {402, -32766},   {302, -32767},
    {201, -32767},   {101, -32768}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw512[FFT_512] = {
    {32767, 0},       {32767, -201},    {32766, -402},    {32762, -603},    {32758, -804},    {32753, -1005},
    {32746, -1206},   {32738, -1407},   {32729, -1608},   {32718, -1809},   {32706, -2009},   {32693, -2210},
    {32679, -2411},   {32664, -2611},   {32647, -2811},   {32629, -3012},   {32610, -3212},   {32590, -3412},
    {32568, -3612},   {32546, -3812},   {32522, -4011},   {32496, -4211},   {32470, -4410},   {32442, -4609},
    {32413, -4808},   {32383, -5007},   {32352, -5205},   {32319, -5404},   {32286, -5602},   {32251, -5800},
    {32214, -5998},   {32177, -6195},   {32138, -6393},   {32099, -6590},   {32058, -6787},   {32015, -6983},
    {31972, -7180},   {31927, -7376},   {31881, -7571},   {31834, -7767},   {31786, -7962},   {31737, -8157},
    {31686, -8351},   {31634, -8546},   {31581, -8740},   {31527, -8933},   {31471, -9127},   {31415, -9319},
    {31357, -9512},   {31298, -9704},   {31238, -9896},   {31177, -10088},  {31114, -10279},  {31050, -10469},
    {30986, -10660},  {30920, -10850},  {30853, -11039},  {30784, -11228},  {30715, -11417},  {30644, -11605},
    {30572, -11793},  {30499, -11980},  {30425, -12167},  {30350, -12354},  {30274, -12540},  {30196, -12725},
    {30118, -12910},  {30038, -13095},  {29957, -13279},  {29875, -13463},  {29792, -13646},  {29707, -13828},
    {29622, -14010},  {29535, -14192},  {29448, -14373},  {29359, -14553},  {29269, -14733},  {29178, -14912},
    {29086, -15091},  {28993, -15269},  {28899, -15447},  {28803, -15624},  {28707, -15800},  {28610, -15976},
    {28511, -16151},  {28411, -16326},  {28311, -16500},  {28209, -16673},  {28106, -16846},  {28002, -17018},
    {27897, -17190},  {27791, -17361},  {27684, -17531},  {27576, -17700},  {27467, -17869},  {27357, -18037},
    {27246, -18205},  {27133, -18372},  {27020, -18538},  {26906, -18703},  {26791, -18868},  {26674, -19032},
    {26557, -19195},  {26439, -19358},  {26320, -19520},  {26199, -19681},  {26078, -19841},  {25956, -20001},
    {25833, -20160},  {25708, -20318},  {25583, -20475},  {25457, -20632},  {25330, -20788},  {25202, -20943},
    {25073, -21097},  {24943, -21251},  {24812, -21403},  {24680, -21555},  {24548, -21706},  {24414, -21856},
    {24279, -22006},  {24144, -22154},  {24008, -22302},  {23870, -22449},  {23732, -22595},  {23593, -22740},
    {23453, -22884},  {23312, -23028},  {23170, -23170},  {23028, -23312},  {22884, -23453},  {22740, -23593},
    {22595, -23732},  {22449, -23870},  {22302, -24008},  {22154, -24144},  {22006, -24279},  {21856, -24414},
    {21706, -24548},  {21555, -24680},  {21403, -24812},  {21251, -24943},  {21097, -25073},  {20943, -25202},
    {20788, -25330},  {20632, -25457},  {20475, -25583},  {20318, -25708},  {20160, -25833},  {20001, -25956},
    {19841, -26078},  {19681, -26199},  {19520, -26320},  {19358, -26439},  {19195, -26557},  {19032, -26674},
    {18868, -26791},  {18703, -26906},  {18538, -27020},  {18372, -27133},  {18205, -27246},  {18037, -27357},
    {17869, -27467},  {17700, -27576},  {17531, -27684},  {17361, -27791},  {17190, -27897},  {17018, -28002},
    {16846, -28106},  {16673, -28209},  {16500, -28311},  {16326, -28411},  {16151, -28511},  {15976, -28610},
    {15800, -28707},  {15624, -28803},  {15447, -28899},  {15269, -28993},  {15091, -29086},  {14912, -29178},
    {14733, -29269},  {14553, -29359},  {14373, -29448},  {14192, -29535},  {14010, -29622},  {13828, -29707},
    {13646, -29792},  {13463, -29875},  {13279, -29957},  {13095, -30038},  {12910, -30118},  {12725, -30196},
    {12540, -30274},  {12354, -30350},  {12167, -30425},  {11980, -30499},  {11793, -30572},  {11605, -30644},
    {11417, -30715},  {11228, -30784},  {11039, -30853},  {10850, -30920},  {10660, -30986},  {10469, -31050},
    {10279, -31114},  {10088, -31177},  {9896, -31238},   {9704, -31298},   {9512, -31357},   {9319, -31415},
    {9127, -31471},   {8933, -31527},   {8740, -31581},   {8546, -31634},   {8351, -31686},   {8157, -31737},
    {7962, -31786},   {7767, -31834},   {7571, -31881},   {7376, -31927},   {7180, -31972},   {6983, -32015},
    {6787, -32058},   {6590, -32099},   {6393, -32138},   {6195, -32177},   {5998, -32214},   {5800, -32251},
    {5602, -32286},   {5404, -32319},   {5205, -32352},   {5007, -32383},   {4808, -32413},   {4609, -32442},
    {4410, -32470},   {4211, -32496},   {4011, -32522},   {3812, -32546},   {3612, -32568},   {3412, -32590},
    {3212, -32610},   {3012, -32629},   {2811, -32647},   {2611, -32664},   {2411, -32679},   {2210, -32693},
    {2009, -32706},   {1809, -32718},   {1608, -32729},   {1407, -32738},   {1206, -32746},   {1005, -32753},
    {804, -32758},    {603, -32762},    {402, -32766},    {201, -32767},    {0, -32768},      {-201, -32767},
    {-402, -32766},   {-603, -32762},   {-804, -32758},   {-1005, -32753},  {-1206, -32746},  {-1407, -32738},
    {-1608, -32729},  {-1809, -32718},  {-2009, -32706},  {-2210, -32693},  {-2411, -32679},  {-2611, -32664},
    {-2811, -32647},  {-3012, -32629},  {-3212, -32610},  {-3412, -32590},  {-3612, -32568},  {-3812, -32546},
    {-4011, -32522},  {-4211, -32496},  {-4410, -32470},  {-4609, -32442},  {-4808, -32413},  {-5007, -32383},
    {-5205, -32352},  {-5404, -32319},  {-5602, -32286},  {-5800, -32251},  {-5998, -32214},  {-6195, -32177},
    {-6393, -32138},  {-6590, -32099},  {-6787, -32058},  {-6983, -32015},  {-7180, -31972},  {-7376, -31927},
    {-7571, -31881},  {-7767, -31834},  {-7962, -31786},  {-8157, -31737},  {-8351, -31686},  {-8546, -31634},
    {-8740, -31581},  {-8933, -31527},  {-9127, -31471},  {-9319, -31415},  {-9512, -31357},  {-9704, -31298},
    {-9896, -31238},  {-10088, -31177}, {-10279, -31114}, {-10469, -31050}, {-10660, -30986}, {-10850, -30920},
    {-11039, -30853}, {-11228, -30784}, {-11417, -30715}, {-11605, -30644}, {-11793, -30572}, {-11980, -30499},
    {-12167, -30425}, {-12354, -30350}, {-12540, -30274}, {-12725, -30196}, {-12910, -30118}, {-13095, -30038},
    {-13279, -29957}, {-13463, -29875}, {-13646, -29792}, {-13828, -29707}, {-14010, -29622}, {-14192, -29535},
    {-14373, -29448}, {-14553, -29359}, {-14733, -29269}, {-14912, -29178}, {-15091, -29086}, {-15269, -28993},
    {-15447, -28899}, {-15624, -28803}, {-15800, -28707}, {-15976, -28610}, {-16151, -28511}, {-16326, -28411},
    {-16500, -28311}, {-16673, -28209}, {-16846, -28106}, {-17018, -28002}, {-17190, -27897}, {-17361, -27791},
    {-17531, -27684}, {-17700, -27576}, {-17869, -27467}, {-18037, -27357}, {-18205, -27246}, {-18372, -27133},
    {-18538, -27020}, {-18703, -26906}, {-18868, -26791}, {-19032, -26674}, {-19195, -26557}, {-19358, -26439},
    {-19520, -26320}, {-19681, -26199}, {-19841, -26078}, {-20001, -25956}, {-20160, -25833}, {-20318, -25708},
    {-20475, -25583}, {-20632, -25457}, {-20788, -25330}, {-20943, -25202}, {-21097, -25073}, {-21251, -24943},
    {-21403, -24812}, {-21555, -24680}, {-21706, -24548}, {-21856, -24414}, {-22006, -24279}, {-22154, -24144},
    {-22302, -24008}, {-22449, -23870}, {-22595, -23732}, {-22740, -23593}, {-22884, -23453}, {-23028, -23312},
    {-23170, -23170}, {-23312, -23028}, {-23453, -22884}, {-23593, -22740}, {-23732, -22595}, {-23870, -22449},
    {-24008, -22302}, {-24144, -22154}, {-24279, -22006}, {-24414, -21856}, {-24548, -21706}, {-24680, -21555},
    {-24812, -21403}, {-24943, -21251}, {-25073, -21097}, {-25202, -20943}, {-25330, -20788}, {-25457, -20632},
    {-25583, -20475}, {-25708, -20318}, {-25833, -20160}, {-25956, -20001}, {-26078, -19841}, {-26199, -19681},
    {-26320, -19520}, {-26439, -19358}, {-26557, -19195}, {-26674, -19032}, {-26791, -18868}, {-26906, -18703},
    {-27020, -18538}, {-27133, -18372}, {-27246, -18205}, {-27357, -18037}, {-27467, -17869}, {-27576, -17700},
    {-27684, -17531}, {-27791, -17361}, {-27897, -17190}, {-28002, -17018}, {-28106, -16846}, {-28209, -16673},
    {-28311, -16500}, {-28411, -16326}, {-28511, -16151}, {-28610, -15976}, {-28707, -15800}, {-28803, -15624},
    {-28899, -15447}, {-28993, -15269}, {-29086, -15091}, {-29178, -14912}, {-29269, -14733}, {-29359, -14553},
    {-29448, -14373}, {-29535, -14192}, {-29622, -14010}, {-29707, -13828}, {-29792, -13646}, {-29875, -13463},
    {-29957, -13279}, {-30038, -13095}, {-30118, -12910}, {-30196, -12725}, {-30274, -12540}, {-30350, -12354},
    {-30425, -12167}, {-30499, -11980}, {-30572, -11793}, {-30644, -11605}, {-30715, -11417}, {-30784, -11228},
    {-30853, -11039}, {-30920, -10850}, {-30986, -10660}, {-31050, -10469}, {-31114, -10279}, {-31177, -10088},
    {-31238, -9896},  {-31298, -9704},  {-31357, -9512},  {-31415, -9319},  {-31471, -9127},  {-31527, -8933},
    {-31581, -8740},  {-31634, -8546},  {-31686, -8351},  {-31737, -8157},  {-31786, -7962},  {-31834, -7767},
    {-31881, -7571},  {-31927, -7376},  {-31972, -7180},  {-32015, -6983},  {-32058, -6787},  {-32099, -6590},
    {-32138, -6393},  {-32177, -6195},  {-32214, -5998},  {-32251, -5800},  {-32286, -5602},  {-32319, -5404},
    {-32352, -5205},  {-32383, -5007},  {-32413, -4808},  {-32442, -4609},  {-32470, -4410},  {-32496, -4211},
    {-32522, -4011},  {-32546, -3812},  {-32568, -3612},  {-32590, -3412},  {-32610, -3212},  {-32629, -3012},
    {-32647, -2811},  {-32664, -2611},  {-32679, -2411},  {-32693, -2210},  {-32706, -2009},  {-32718, -1809},
    {-32729, -1608},  {-32738, -1407},  {-32746, -1206},  {-32753, -1005},  {-32758, -804},   {-32762, -603},
    {-32766, -402},   {-32767, -201}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw512_half[FFT_512 / 2] = {
    {32767, 0},      {32767, -201},   {32766, -402},   {32762, -603},   {32758, -804},   {32753, -1005},
    {32746, -1206},  {32738, -1407},  {32729, -1608},  {32718, -1809},  {32706, -2009},  {32693, -2210},
    {32679, -2411},  {32664, -2611},  {32647, -2811},  {32629, -3012},  {32610, -3212},  {32590, -3412},
    {32568, -3612},  {32546, -3812},  {32522, -4011},  {32496, -4211},  {32470, -4410},  {32442, -4609},
    {32413, -4808},  {32383, -5007},  {32352, -5205},  {32319, -5404},  {32286, -5602},  {32251, -5800},
    {32214, -5998},  {32177, -6195},  {32138, -6393},  {32099, -6590},  {32058, -6787},  {32015, -6983},
    {31972, -7180},  {31927, -7376},  {31881, -7571},  {31834, -7767},  {31786, -7962},  {31737, -8157},
    {31686, -8351},  {31634, -8546},  {31581, -8740},  {31527, -8933},  {31471, -9127},  {31415, -9319},
    {31357, -9512},  {31298, -9704},  {31238, -9896},  {31177, -10088}, {31114, -10279}, {31050, -10469},
    {30986, -10660}, {30920, -10850}, {30853, -11039}, {30784, -11228}, {30715, -11417}, {30644, -11605},
    {30572, -11793}, {30499, -11980}, {30425, -12167}, {30350, -12354}, {30274, -12540}, {30196, -12725},
    {30118, -12910}, {30038, -13095}, {29957, -13279}, {29875, -13463}, {29792, -13646}, {29707, -13828},
    {29622, -14010}, {29535, -14192}, {29448, -14373}, {29359, -14553}, {29269, -14733}, {29178, -14912},
    {29086, -15091}, {28993, -15269}, {28899, -15447}, {28803, -15624}, {28707, -15800}, {28610, -15976},
    {28511, -16151}, {28411, -16326}, {28311, -16500}, {28209, -16673}, {28106, -16846}, {28002, -17018},
    {27897, -17190}, {27791, -17361}, {27684, -17531}, {27576, -17700}, {27467, -17869}, {27357, -18037},
    {27246, -18205}, {27133, -18372}, {27020, -18538}, {26906, -18703}, {26791, -18868}, {26674, -19032},
    {26557, -19195}, {26439, -19358}, {26320, -19520}, {26199, -19681}, {26078, -19841}, {25956, -20001},
    {25833, -20160}, {25708, -20318}, {25583, -20475}, {25457, -20632}, {25330, -20788}, {25202, -20943},
    {25073, -21097}, {24943, -21251}, {24812, -21403}, {24680, -21555}, {24548, -21706}, {24414, -21856},
    {24279, -22006}, {24144, -22154}, {24008, -22302}, {23870, -22449}, {23732, -22595}, {23593, -22740},
    {23453, -22884}, {23312, -23028}, {23170, -23170}, {23028, -23312}, {22884, -23453}, {22740, -23593},
    {22595, -23732}, {22449, -23870}, {22302, -24008}, {22154, -24144}, {22006, -24279}, {21856, -24414},
    {21706, -24548}, {21555, -24680}, {21403, -24812}, {21251, -24943}, {21097, -25073}, {20943, -25202},
    {20788, -25330}, {20632, -25457}, {20475, -25583}, {20318, -25708}, {20160, -25833}, {20001, -25956},
    {19841, -26078}, {19681, -26199}, {19520, -26320}, {19358, -26439}, {19195, -26557}, {19032, -26674},
    {18868, -26791}, {18703, -26906}, {18538, -27020}, {18372, -27133}, {18205, -27246}, {18037, -27357},
    {17869, -27467}, {17700, -27576}, {17531, -27684}, {17361, -27791}, {17190, -27897}, {17018, -28002},
    {16846, -28106}, {16673, -28209}, {16500, -28311}, {16326, -28411}, {16151, -28511}, {15976, -28610},
    {15800, -28707}, {15624, -28803}, {15447, -28899}, {15269, -28993}, {15091, -29086}, {14912, -29178},
    {14733, -29269}, {14553, -29359}, {14373, -29448}, {14192, -29535}, {14010, -29622}, {13828, -29707},
    {13646, -29792}, {13463, -29875}, {13279, -29957}, {13095, -30038}, {12910, -30118}, {12725, -30196},
    {12540, -30274}, {12354, -30350}, {12167, -30425}, {11980, -30499}, {11793, -30572}, {11605, -30644},
    {11417, -30715}, {11228, -30784}, {11039, -30853}, {10850, -30920}, {10660, -30986}, {10469, -31050},
    {10279, -31114}, {10088, -31177}, {9896, -31238},  {9704, -31298},  {9512, -31357},  {9319, -31415},
    {9127, -31471},  {8933, -31527},  {8740, -31581},  {8546, -31634},  {8351, -31686},  {8157, -31737},
    {7962, -31786},  {7767, -31834},  {7571, -31881},  {7376, -31927},  {7180, -31972},  {6983, -32015},
    {6787, -32058},  {6590, -32099},  {6393, -32138},  {6195, -32177},  {5998, -32214},  {5800, -32251},
    {5602, -32286},  {5404, -32319},  {5205, -32352},  {5007, -32383},  {4808, -32413},  {4609, -32442},
    {4410, -32470},  {4211, -32496},  {4011, -32522},  {3812, -32546},  {3612, -32568},  {3412, -32590},
    {3212, -32610},  {3012, -32629},  {2811, -32647},  {2611, -32664},  {2411, -32679},  {2210, -32693},
    {2009, -32706},  {1809, -32718},  {1608, -32729},  {1407, -32738},  {1206, -32746},  {1005, -32753},
    {804, -32758},   {603, -32762},   {402, -32766},   {201, -32767}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw256[FFT_256] = {
    {32767, 0},       {32766, -402},    {32758, -804},    {32746, -1206},   {32729, -1608},   {32706, -2009},
    {32679, -2411},   {32647, -2811},   {32610, -3212},   {32568, -3612},   {32522, -4011},   {32470, -4410},
    {32413, -4808},   {32352, -5205},   {32286, -5602},   {32214, -5998},   {32138, -6393},   {32058, -6787},
    {31972, -7180},   {31881, -7571},   {31786, -7962},   {31686, -8351},   {31581, -8740},   {31471, -9127},
    {31357, -9512},   {31238, -9896},   {31114, -10279},  {30986, -10660},  {30853, -11039},  {30715, -11417},
    {30572, -11793},  {30425, -12167},  {30274, -12540},  {30118, -12910},  {29957, -13279},  {29792, -13646},
    {29622, -14010},  {29448, -14373},  {29269, -14733},  {29086, -15091},  {28899, -15447},  {28707, -15800},
    {28511, -16151},  {28311, -16500},  {28106, -16846},  {27897, -17190},  {27684, -17531},  {27467, -17869},
    {27246, -18205},  {27020, -18538},  {26791, -18868},  {26557, -19195},  {26320, -19520},  {26078, -19841},
    {25833, -20160},  {25583, -20475},  {25330, -20788},  {25073, -21097},  {24812, -21403},  {24548, -21706},
    {24279, -22006},  {24008, -22302},  {23732, -22595},  {23453, -22884},  {23170, -23170},  {22884, -23453},
    {22595, -23732},  {22302, -24008},  {22006, -24279},  {21706, -24548},  {21403, -24812},  {21097, -25073},
    {20788, -25330},  {20475, -25583},  {20160, -25833},  {19841, -26078},  {19520, -26320},  {19195, -26557},
    {18868, -26791},  {18538, -27020},  {18205, -27246},  {17869, -27467},  {17531, -27684},  {17190, -27897},
    {16846, -28106},  {16500, -28311},  {16151, -28511},  {15800, -28707},  {15447, -28899},  {15091, -29086},
    {14733, -29269},  {14373, -29448},  {14010, -29622},  {13646, -29792},  {13279, -29957},  {12910, -30118},
    {12540, -30274},  {12167, -30425},  {11793, -30572},  {11417, -30715},  {11039, -30853},  {10660, -30986},
    {10279, -31114},  {9896, -31238},   {9512, -31357},   {9127, -31471},   {8740, -31581},   {8351, -31686},
    {7962, -31786},   {7571, -31881},   {7180, -31972},   {6787, -32058},   {6393, -32138},   {5998, -32214},
    {5602, -32286},   {5205, -32352},   {4808, -32413},   {4410, -32470},   {4011, -32522},   {3612, -32568},
    {3212, -32610},   {2811, -32647},   {2411, -32679},   {2009, -32706},   {1608, -32729},   {1206, -32746},
    {804, -32758},    {402, -32766},    {0, -32768},      {-402, -32766},   {-804, -32758},   {-1206, -32746},
    {-1608, -32729},  {-2009, -32706},  {-2411, -32679},  {-2811, -32647},  {-3212, -32610},  {-3612, -32568},
    {-4011, -32522},  {-4410, -32470},  {-4808, -32413},  {-5205, -32352},  {-5602, -32286},  {-5998, -32214},
    {-6393, -32138},  {-6787, -32058},  {-7180, -31972},  {-7571, -31881},  {-7962, -31786},  {-8351, -31686},
    {-8740, -31581},  {-9127, -31471},  {-9512, -31357},  {-9896, -31238},  {-10279, -31114}, {-10660, -30986},
    {-11039, -30853}, {-11417, -30715}, {-11793, -30572}, {-12167, -30425}, {-12540, -30274}, {-12910, -30118},
    {-13279, -29957}, {-13646, -29792}, {-14010, -29622}, {-14373, -29448}, {-14733, -29269}, {-15091, -29086},
    {-15447, -28899}, {-15800, -28707}, {-16151, -28511}, {-16500, -28311}, {-16846, -28106}, {-17190, -27897},
    {-17531, -27684}, {-17869, -27467}, {-18205, -27246}, {-18538, -27020}, {-18868, -26791}, {-19195, -26557},
    {-19520, -26320}, {-19841, -26078}, {-20160, -25833}, {-20475, -25583}, {-20788, -25330}, {-21097, -25073},
    {-21403, -24812}, {-21706, -24548}, {-22006, -24279}, {-22302, -24008}, {-22595, -23732}, {-22884, -23453},
    {-23170, -23170}, {-23453, -22884}, {-23732, -22595}, {-24008, -22302}, {-24279, -22006}, {-24548, -21706},
    {-24812, -21403}, {-25073, -21097}, {-25330, -20788}, {-25583, -20475}, {-25833, -20160}, {-26078, -19841},
    {-26320, -19520}, {-26557, -19195}, {-26791, -18868}, {-27020, -18538}, {-27246, -18205}, {-27467, -17869},
    {-27684, -17531}, {-27897, -17190}, {-28106, -16846}, {-28311, -16500}, {-28511, -16151}, {-28707, -15800},
    {-28899, -15447}, {-29086, -15091}, {-29269, -14733}, {-29448, -14373}, {-29622, -14010}, {-29792, -13646},
    {-29957, -13279}, {-30118, -12910}, {-30274, -12540}, {-30425, -12167}, {-30572, -11793}, {-30715, -11417},
    {-30853, -11039}, {-30986, -10660}, {-31114, -10279}, {-31238, -9896},  {-31357, -9512},  {-31471, -9127},
    {-31581, -8740},  {-31686, -8351},  {-31786, -7962},  {-31881, -7571},  {-31972, -7180},  {-32058, -6787},
    {-32138, -6393},  {-32214, -5998},  {-32286, -5602},  {-32352, -5205},  {-32413, -4808},  {-32470, -4410},
    {-32522, -4011},  {-32568, -3612},  {-32610, -3212},  {-32647, -2811},  {-32679, -2411},  {-32706, -2009},
    {-32729, -1608},  {-32746, -1206},  {-32758, -804},   {-32766, -402}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw256_half[FFT_256 / 2] = {
    {32767, 0},      {32766, -402},   {32758, -804},   {32746, -1206},  {32729, -1608},  {32706, -2009},
    {32679, -2411},  {32647, -2811},  {32610, -3212},  {32568, -3612},  {32522, -4011},  {32470, -4410},
    {32413, -4808},  {32352, -5205},  {32286, -5602},  {32214, -5998},  {32138, -6393},  {32058, -6787},
    {31972, -7180},  {31881, -7571},  {31786, -7962},  {31686, -8351},  {31581, -8740},  {31471, -9127},
    {31357, -9512},  {31238, -9896},  {31114, -10279}, {30986, -10660}, {30853, -11039}, {30715, -11417},
    {30572, -11793}, {30425, -12167}, {30274, -12540}, {30118, -12910}, {29957, -13279}, {29792, -13646},
    {29622, -14010}, {29448, -14373}, {29269, -14733}, {29086, -15091}, {28899, -15447}, {28707, -15800},
    {28511, -16151}, {28311, -16500}, {28106, -16846}, {27897, -17190}, {27684, -17531}, {27467, -17869},
    {27246, -18205}, {27020, -18538}, {26791, -18868}, {26557, -19195}, {26320, -19520}, {26078, -19841},
    {25833, -20160}, {25583, -20475}, {25330, -20788}, {25073, -21097}, {24812, -21403}, {24548, -21706},
    {24279, -22006}, {24008, -22302}, {23732, -22595}, {23453, -22884}, {23170, -23170}, {22884, -23453},
    {22595, -23732}, {22302, -24008}, {22006, -24279}, {21706, -24548}, {21403, -24812}, {21097, -25073},
    {20788, -25330}, {20475, -25583}, {20160, -25833}, {19841, -26078}, {19520, -26320}, {19195, -26557},
    {18868, -26791}, {18538, -27020}, {18205, -27246}, {17869, -27467}, {17531, -27684}, {17190, -27897},
    {16846, -28106}, {16500, -28311}, {16151, -28511}, {15800, -28707}, {15447, -28899}, {15091, -29086},
    {14733, -29269}, {14373, -29448}, {14010, -29622}, {13646, -29792}, {13279, -29957}, {12910, -30118},
    {12540, -30274}, {12167, -30425}, {11793, -30572}, {11417, -30715}, {11039, -30853}, {10660, -30986},
    {10279, -31114}, {9896, -31238},  {9512, -31357},  {9127, -31471},  {8740, -31581},  {8351, -31686},
    {7962, -31786},  {7571, -31881},  {7180, -31972},  {6787, -32058},  {6393, -32138},  {5998, -32214},
    {5602, -32286},  {5205, -32352},  {4808, -32413},  {4410, -32470},  {4011, -32522},  {3612, -32568},
    {3212, -32610},  {2811, -32647},  {2411, -32679},  {2009, -32706},  {1608, -32729},  {1206, -32746},
    {804, -32758},   {402, -32766}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw128[FFT_128] = {
    {32767, 0},       {32758, -804},    {32729, -1608},   {32679, -2411},   {32610, -3212},   {32522, -4011},
    {32413, -4808},   {32286, -5602},   {32138, -6393},   {31972, -7180},   {31786, -7962},   {31581, -8740},
    {31357, -9512},   {31114, -10279},  {30853, -11039},  {30572, -11793},  {30274, -12540},  {29957, -13279},
    {29622, -14010},  {29269, -14733},  {28899, -15447},  {28511, -16151},  {28106, -16846},  {27684, -17531},
    {27246, -18205},  {26791, -18868},  {26320, -19520},  {25833, -20160},  {25330, -20788},  {24812, -21403},
    {24279, -22006},  {23732, -22595},  {23170, -23170},  {22595, -23732},  {22006, -24279},  {21403, -24812},
    {20788, -25330},  {20160, -25833},  {19520, -26320},  {18868, -26791},  {18205, -27246},  {17531, -27684},
    {16846, -28106},  {16151, -28511},  {15447, -28899},  {14733, -29269},  {14010, -29622},  {13279, -29957},
    {12540, -30274},  {11793, -30572},  {11039, -30853},  {10279, -31114},  {9512, -31357},   {8740, -31581},
    {7962, -31786},   {7180, -31972},   {6393, -32138},   {5602, -32286},   {4808, -32413},   {4011, -32522},
    {3212, -32610},   {2411, -32679},   {1608, -32729},   {804, -32758},    {0, -32768},      {-804, -32758},
    {-1608, -32729},  {-2411, -32679},  {-3212, -32610},  {-4011, -32522},  {-4808, -32413},  {-5602, -32286},
    {-6393, -32138},  {-7180, -31972},  {-7962, -31786},  {-8740, -31581},  {-9512, -31357},  {-10279, -31114},
    {-11039, -30853}, {-11793, -30572}, {-12540, -30274}, {-13279, -29957}, {-14010, -29622}, {-14733, -29269},
    {-15447, -28899}, {-16151, -28511}, {-16846, -28106}, {-17531, -27684}, {-18205, -27246}, {-18868, -26791},
    {-19520, -26320}, {-20160, -25833}, {-20788, -25330}, {-21403, -24812}, {-22006, -24279}, {-22595, -23732},
    {-23170, -23170}, {-23732, -22595}, {-24279, -22006}, {-24812, -21403}, {-25330, -20788}, {-25833, -20160},
    {-26320, -19520}, {-26791, -18868}, {-27246, -18205}, {-27684, -17531}, {-28106, -16846}, {-28511, -16151},
    {-28899, -15447}, {-29269, -14733}, {-29622, -14010}, {-29957, -13279}, {-30274, -12540}, {-30572, -11793},
    {-30853, -11039}, {-31114, -10279}, {-31357, -9512},  {-31581, -8740},  {-31786, -7962},  {-31972, -7180},
    {-32138, -6393},  {-32286, -5602},  {-32413, -4808},  {-32522, -4011},  {-32610, -3212},  {-32679, -2411},
    {-32729, -1608},  {-32758, -804}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw128_half[FFT_128 / 2] = {
    {32767, 0},      {32758, -804},   {32729, -1608},  {32679, -2411},  {32610, -3212},  {32522, -4011},
    {32413, -4808},  {32286, -5602},  {32138, -6393},  {31972, -7180},  {31786, -7962},  {31581, -8740},
    {31357, -9512},  {31114, -10279}, {30853, -11039}, {30572, -11793}, {30274, -12540}, {29957, -13279},
    {29622, -14010}, {29269, -14733}, {28899, -15447}, {28511, -16151}, {28106, -16846}, {27684, -17531},
    {27246, -18205}, {26791, -18868}, {26320, -19520}, {25833, -20160}, {25330, -20788}, {24812, -21403},
    {24279, -22006}, {23732, -22595}, {23170, -23170}, {22595, -23732}, {22006, -24279}, {21403, -24812},
    {20788, -25330}, {20160, -25833}, {19520, -26320}, {18868, -26791}, {18205, -27246}, {17531, -27684},
    {16846, -28106}, {16151, -28511}, {15447, -28899}, {14733, -29269}, {14010, -29622}, {13279, -29957},
    {12540, -30274}, {11793, -30572}, {11039, -30853}, {10279, -31114}, {9512, -31357},  {8740, -31581},
    {7962, -31786},  {7180, -31972},  {6393, -32138},  {5602, -32286},  {4808, -32413},  {4011, -32522},
    {3212, -32610},  {2411, -32679},  {1608, -32729},  {804, -32758}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw64[FFT_64] = {
    {32767, 0},       {32729, -1608},   {32610, -3212},   {32413, -4808},   {32138, -6393},   {31786, -7962},
    {31357, -9512},   {30853, -11039},  {30274, -12540},  {29622, -14010},  {28899, -15447},  {28106, -16846},
    {27246, -18205},  {26320, -19520},  {25330, -20788},  {24279, -22006},  {23170, -23170},  {22006, -24279},
    {20788, -25330},  {19520, -26320},  {18205, -27246},  {16846, -28106},  {15447, -28899},  {14010, -29622},
    {12540, -30274},  {11039, -30853},  {9512, -31357},   {7962, -31786},   {6393, -32138},   {4808, -32413},
    {3212, -32610},   {1608, -32729},   {0, -32768},      {-1608, -32729},  {-3212, -32610},  {-4808, -32413},
    {-6393, -32138},  {-7962, -31786},  {-9512, -31357},  {-11039, -30853}, {-12540, -30274}, {-14010, -29622},
    {-15447, -28899}, {-16846, -28106}, {-18205, -27246}, {-19520, -26320}, {-20788, -25330}, {-22006, -24279},
    {-23170, -23170}, {-24279, -22006}, {-25330, -20788}, {-26320, -19520}, {-27246, -18205}, {-28106, -16846},
    {-28899, -15447}, {-29622, -14010}, {-30274, -12540}, {-30853, -11039}, {-31357, -9512},  {-31786, -7962},
    {-32138, -6393},  {-32413, -4808},  {-32610, -3212},  {-32729, -1608}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw64_half[FFT_64 / 2] = {
    {32767, 0},      {32729, -1608},  {32610, -3212},  {32413, -4808},  {32138, -6393},  {31786, -7962},
    {31357, -9512},  {30853, -11039}, {30274, -12540}, {29622, -14010}, {28899, -15447}, {28106, -16846},
    {27246, -18205}, {26320, -19520}, {25330, -20788}, {24279, -22006}, {23170, -23170}, {22006, -24279},
    {20788, -25330}, {19520, -26320}, {18205, -27246}, {16846, -28106}, {15447, -28899}, {14010, -29622},
    {12540, -30274}, {11039, -30853}, {9512, -31357},  {7962, -31786},  {6393, -32138},  {4808, -32413},
    {3212, -32610},  {1608, -32729}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw32[FFT_32] = {
    {32767, 0},       {32610, -3212},   {32138, -6393},   {31357, -9512},   {30274, -12540},  {28899, -15447},
    {27246, -18205},  {25330, -20788},  {23170, -23170},  {20788, -25330},  {18205, -27246},  {15447, -28899},
    {12540, -30274},  {9512, -31357},   {6393, -32138},   {3212, -32610},   {0, -32768},      {-3212, -32610},
    {-6393, -32138},  {-9512, -31357},  {-12540, -30274}, {-15447, -28899}, {-18205, -27246}, {-20788, -25330},
    {-23170, -23170}, {-25330, -20788}, {-27246, -18205}, {-28899, -15447}, {-30274, -12540}, {-31357, -9512},
    {-32138, -6393},  {-32610, -3212}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw32_half[FFT_32 / 2] = {
    {32767, 0},      {32610, -3212},  {32138, -6393},  {31357, -9512},  {30274, -12540}, {28899, -15447},
    {27246, -18205}, {25330, -20788}, {23170, -23170}, {20788, -25330}, {18205, -27246}, {15447, -28899},
    {12540, -30274}, {9512, -31357},  {6393, -32138},  {3212, -32610}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw16[FFT_16] = {
    {32767, 0},       {32138, -6393},   {30274, -12540},  {27246, -18205}, {23170, -23170},  {18205, -27246},
    {12540, -30274},  {6393, -32138},   {0, -32768},      {-6393, -32138}, {-12540, -30274}, {-18205, -27246},
    {-23170, -23170}, {-27246, -18205}, {-30274, -12540}, {-32138, -6393}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw16_half[FFT_16 / 2] = {
    {32767, 0},      {32138, -6393},  {30274, -12540}, {27246, -18205},
    {23170, -23170}, {18205, -27246}, {12540, -30274}, {6393, -32138}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw8[FFT_8] = {{32767, 0},       {30274, -12540}, {23170, -23170},
                                                                  {12540, -30274},  {0, -32768},     {-12540, -30274},
                                                                  {-23170, -23170}, {-30274, -12540}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw8_half[FFT_8 / 2] = {
    {32767, 0}, {30274, -12540}, {23170, -23170}, {12540, -30274}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw4[FFT_4] = {
    {32767, 0}, {23170, -23170}, {0, -32768}, {-23170, -23170}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw4_half[FFT_4 / 2] = {{32767, 0}, {23170, -23170}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw2[FFT_2] = {{32767, 0}, {0, -32768}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw2_half[FFT_2 / 2] = {{32767, 0}};

alignas(__ALIGN_BYTE_SIZE__) const cint16_t fft_lut_tw1[FFT_1] = {{32767, 0}};

/* LUTs for 640pt FFT/IFFT */
/*    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw160[FFT_160] = {{32767, 0},
        {32762, -643},{32743, -1286},{32711, -1929},{32667, -2571},{32610, -3212},{32541, -3851},{32459, -4490},{32365,
-5126},{32258, -5760},{32138, -6393},
        {32007, -7022},{31863, -7650},{31706, -8274},{31538, -8895},{31357, -9512},{31164, -10126},{30959,
-10736},{30743, -11342},{30514, -11943},{30274, -12540},
        {30022, -13132},{29758, -13719},{29483, -14300},{29197, -14876},{28899, -15447},{28590, -16011},{28270,
-16569},{27939, -17121},{27598, -17666},{27246, -18205},
        {26883, -18736},{26510, -19261},{26127, -19777},{25733, -20286},{25330, -20788},{24917, -21281},{24494,
-21766},{24062, -22243},{23621, -22711},{23170, -23170},
        {22711, -23621},{22243, -24062},{21766, -24494},{21281, -24917},{20788, -25330},{20286, -25733},{19777,
-26127},{19261, -26510},{18736, -26883},{18205, -27246},
        {17666, -27598},{17121, -27939},{16569, -28270},{16011, -28590},{15447, -28899},{14876, -29197},{14300,
-29483},{13719, -29758},{13132, -30022},{12540, -30274},
        {11943, -30514},{11342, -30743},{10736, -30959},{10126, -31164},{9512, -31357},{8895, -31538},{8274,
-31706},{7650, -31863},{7022, -32007},{6393, -32138},
        {5760, -32258},{5126, -32365},{4490, -32459},{3851, -32541},{3212, -32610},{2571, -32667},{1929, -32711},{1286,
-32743},{643, -32762},{0, -32768},
        {-643, -32762},{-1286, -32743},{-1929, -32711},{-2571, -32667},{-3212, -32610},{-3851, -32541},{-4490,
-32459},{-5126, -32365},{-5760, -32258},{-6393, -32138},
        {-7022, -32007},{-7650, -31863},{-8274, -31706},{-8895, -31538},{-9512, -31357},{-10126, -31164},{-10736,
-30959},{-11342, -30743},{-11943, -30514},{-12540, -30274},
        {-13132, -30022},{-13719, -29758},{-14300, -29483},{-14876, -29197},{-15447, -28899},{-16011, -28590},{-16569,
-28270},{-17121, -27939},{-17666, -27598},{-18205, -27246},
        {-18736, -26883},{-19261, -26510},{-19777, -26127},{-20286, -25733},{-20788, -25330},{-21281, -24917},{-21766,
-24494},{-22243, -24062},{-22711, -23621},{-23170, -23170},
        {-23621, -22711},{-24062, -22243},{-24494, -21766},{-24917, -21281},{-25330, -20788},{-25733, -20286},{-26127,
-19777},{-26510, -19261},{-26883, -18736},{-27246, -18205},
        {-27598, -17666},{-27939, -17121},{-28270, -16569},{-28590, -16011},{-28899, -15447},{-29197, -14876},{-29483,
-14300},{-29758, -13719},{-30022, -13132},{-30274, -12540},
        {-30514, -11943},{-30743, -11342},{-30959, -10736},{-31164, -10126},{-31357, -9512},{-31538, -8895},{-31706,
-8274},{-31863, -7650},{-32007, -7022},{-32138, -6393},
        {-32258, -5760},{-32365, -5126},{-32459, -4490},{-32541, -3851},{-32610, -3212},{-32667, -2571},{-32711,
-1929},{-32743, -1286},{-32762, -643}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw320[FFT_320] = {{32767, 0},
        {32766, -322},{32762, -643},{32754, -965},{32743, -1286},{32729, -1608},{32711, -1929},{32691, -2250},{32667,
-2571},{32640, -2892},{32610, -3212},
        {32577, -3532},{32541, -3851},{32501, -4171},{32459, -4490},{32413, -4808},{32365, -5126},{32313, -5444},{32258,
-5760},{32200, -6077},{32138, -6393},
        {32074, -6708},{32007, -7022},{31936, -7336},{31863, -7650},{31786, -7962},{31706, -8274},{31624, -8585},{31538,
-8895},{31449, -9204},{31357, -9512},
        {31262, -9819},{31164, -10126},{31063, -10431},{30959, -10736},{30853, -11039},{30743, -11342},{30630,
-11643},{30514, -11943},{30395, -12242},{30274, -12540},
        {30149, -12836},{30022, -13132},{29891, -13426},{29758, -13719},{29622, -14010},{29483, -14300},{29341,
-14589},{29197, -14876},{29049, -15162},{28899, -15447},
        {28746, -15730},{28590, -16011},{28431, -16291},{28270, -16569},{28106, -16846},{27939, -17121},{27770,
-17395},{27598, -17666},{27423, -17937},{27246, -18205},
        {27066, -18472},{26883, -18736},{26698, -18999},{26510, -19261},{26320, -19520},{26127, -19777},{25931,
-20033},{25733, -20286},{25533, -20538},{25330, -20788},
        {25125, -21035},{24917, -21281},{24707, -21525},{24494, -21766},{24279, -22006},{24062, -22243},{23843,
-22478},{23621, -22711},{23397, -22942},{23170, -23170},
        {22942, -23397},{22711, -23621},{22478, -23843},{22243, -24062},{22006, -24279},{21766, -24494},{21525,
-24707},{21281, -24917},{21035, -25125},{20788, -25330},
        {20538, -25533},{20286, -25733},{20033, -25931},{19777, -26127},{19520, -26320},{19261, -26510},{18999,
-26698},{18736, -26883},{18472, -27066},{18205, -27246},
        {17937, -27423},{17666, -27598},{17395, -27770},{17121, -27939},{16846, -28106},{16569, -28270},{16291,
-28431},{16011, -28590},{15730, -28746},{15447, -28899},
        {15162, -29049},{14876, -29197},{14589, -29341},{14300, -29483},{14010, -29622},{13719, -29758},{13426,
-29891},{13132, -30022},{12836, -30149},{12540, -30274},
        {12242, -30395},{11943, -30514},{11643, -30630},{11342, -30743},{11039, -30853},{10736, -30959},{10431,
-31063},{10126, -31164},{9819, -31262},{9512, -31357},
        {9204, -31449},{8895, -31538},{8585, -31624},{8274, -31706},{7962, -31786},{7650, -31863},{7336, -31936},{7022,
-32007},{6708, -32074},{6393, -32138},
        {6077, -32200},{5760, -32258},{5444, -32313},{5126, -32365},{4808, -32413},{4490, -32459},{4171, -32501},{3851,
-32541},{3532, -32577},{3212, -32610},
        {2892, -32640},{2571, -32667},{2250, -32691},{1929, -32711},{1608, -32729},{1286, -32743},{965, -32754},{643,
-32762},{322, -32766},{0, -32768},
        {-322, -32766},{-643, -32762},{-965, -32754},{-1286, -32743},{-1608, -32729},{-1929, -32711},{-2250,
-32691},{-2571, -32667},{-2892, -32640},{-3212, -32610},
        {-3532, -32577},{-3851, -32541},{-4171, -32501},{-4490, -32459},{-4808, -32413},{-5126, -32365},{-5444,
-32313},{-5760, -32258},{-6077, -32200},{-6393, -32138},
        {-6708, -32074},{-7022, -32007},{-7336, -31936},{-7650, -31863},{-7962, -31786},{-8274, -31706},{-8585,
-31624},{-8895, -31538},{-9204, -31449},{-9512, -31357},
        {-9819, -31262},{-10126, -31164},{-10431, -31063},{-10736, -30959},{-11039, -30853},{-11342, -30743},{-11643,
-30630},{-11943, -30514},{-12242, -30395},{-12540, -30274},
        {-12836, -30149},{-13132, -30022},{-13426, -29891},{-13719, -29758},{-14010, -29622},{-14300, -29483},{-14589,
-29341},{-14876, -29197},{-15162, -29049},{-15447, -28899},
        {-15730, -28746},{-16011, -28590},{-16291, -28431},{-16569, -28270},{-16846, -28106},{-17121, -27939},{-17395,
-27770},{-17666, -27598},{-17937, -27423},{-18205, -27246},
        {-18472, -27066},{-18736, -26883},{-18999, -26698},{-19261, -26510},{-19520, -26320},{-19777, -26127},{-20033,
-25931},{-20286, -25733},{-20538, -25533},{-20788, -25330},
        {-21035, -25125},{-21281, -24917},{-21525, -24707},{-21766, -24494},{-22006, -24279},{-22243, -24062},{-22478,
-23843},{-22711, -23621},{-22942, -23397},{-23170, -23170},
        {-23397, -22942},{-23621, -22711},{-23843, -22478},{-24062, -22243},{-24279, -22006},{-24494, -21766},{-24707,
-21525},{-24917, -21281},{-25125, -21035},{-25330, -20788},
        {-25533, -20538},{-25733, -20286},{-25931, -20033},{-26127, -19777},{-26320, -19520},{-26510, -19261},{-26698,
-18999},{-26883, -18736},{-27066, -18472},{-27246, -18205},
        {-27423, -17937},{-27598, -17666},{-27770, -17395},{-27939, -17121},{-28106, -16846},{-28270, -16569},{-28431,
-16291},{-28590, -16011},{-28746, -15730},{-28899, -15447},
        {-29049, -15162},{-29197, -14876},{-29341, -14589},{-29483, -14300},{-29622, -14010},{-29758, -13719},{-29891,
-13426},{-30022, -13132},{-30149, -12836},{-30274, -12540},
        {-30395, -12242},{-30514, -11943},{-30630, -11643},{-30743, -11342},{-30853, -11039},{-30959, -10736},{-31063,
-10431},{-31164, -10126},{-31262, -9819},{-31357, -9512},
        {-31449, -9204},{-31538, -8895},{-31624, -8585},{-31706, -8274},{-31786, -7962},{-31863, -7650},{-31936,
-7336},{-32007, -7022},{-32074, -6708},{-32138, -6393},
        {-32200, -6077},{-32258, -5760},{-32313, -5444},{-32365, -5126},{-32413, -4808},{-32459, -4490},{-32501,
-4171},{-32541, -3851},{-32577, -3532},{-32610, -3212},
        {-32640, -2892},{-32667, -2571},{-32691, -2250},{-32711, -1929},{-32729, -1608},{-32743, -1286},{-32754,
-965},{-32762, -643},{-32766, -322}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw20[FFT_20] = {{32767, 0},
        {32365, -5126},{31164, -10126},{29197, -14876},{26510, -19261},{23170, -23170},{19261, -26510},{14876,
-29197},{10126, -31164},{5126, -32365},{0, -32768},
        {-5126, -32365},{-10126, -31164},{-14876, -29197},{-19261, -26510},{-23170, -23170},{-26510, -19261},{-29197,
-14876},{-31164, -10126},{-32365, -5126}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw40[FFT_40] = {{32767, 0},
        {32667, -2571},{32365, -5126},{31863, -7650},{31164, -10126},{30274, -12540},{29197, -14876},{27939,
-17121},{26510, -19261},{24917, -21281},{23170, -23170},
        {21281, -24917},{19261, -26510},{17121, -27939},{14876, -29197},{12540, -30274},{10126, -31164},{7650,
-31863},{5126, -32365},{2571, -32667},{0, -32768},
        {-2571, -32667},{-5126, -32365},{-7650, -31863},{-10126, -31164},{-12540, -30274},{-14876, -29197},{-17121,
-27939},{-19261, -26510},{-21281, -24917},{-23170, -23170},
        {-24917, -21281},{-26510, -19261},{-27939, -17121},{-29197, -14876},{-30274, -12540},{-31164, -10126},{-31863,
-7650},{-32365, -5126},{-32667, -2571}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw80[FFT_80] = {{32767, 0},
        {32743, -1286},{32667, -2571},{32541, -3851},{32365, -5126},{32138, -6393},{31863, -7650},{31538, -8895},{31164,
-10126},{30743, -11342},{30274, -12540},
        {29758, -13719},{29197, -14876},{28590, -16011},{27939, -17121},{27246, -18205},{26510, -19261},{25733,
-20286},{24917, -21281},{24062, -22243},{23170, -23170},
        {22243, -24062},{21281, -24917},{20286, -25733},{19261, -26510},{18205, -27246},{17121, -27939},{16011,
-28590},{14876, -29197},{13719, -29758},{12540, -30274},
        {11342, -30743},{10126, -31164},{8895, -31538},{7650, -31863},{6393, -32138},{5126, -32365},{3851,
-32541},{2571, -32667},{1286, -32743},{0, -32768},
        {-1286, -32743},{-2571, -32667},{-3851, -32541},{-5126, -32365},{-6393, -32138},{-7650, -31863},{-8895,
-31538},{-10126, -31164},{-11342, -30743},{-12540, -30274},
        {-13719, -29758},{-14876, -29197},{-16011, -28590},{-17121, -27939},{-18205, -27246},{-19261, -26510},{-20286,
-25733},{-21281, -24917},{-22243, -24062},{-23170, -23170},
        {-24062, -22243},{-24917, -21281},{-25733, -20286},{-26510, -19261},{-27246, -18205},{-27939, -17121},{-28590,
-16011},{-29197, -14876},{-29758, -13719},{-30274, -12540},
        {-30743, -11342},{-31164, -10126},{-31538, -8895},{-31863, -7650},{-32138, -6393},{-32365, -5126},{-32541,
-3851},{-32667, -2571},{-32743, -1286}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw5[FFT_5] = {{32767, 0},{26510, -19261},{10126, -31164},{-10126,
-31164},{-26510,
-19261}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw10[FFT_10] = {{32767, 0},{31164, -10126},{26510, -19261},{19261,
-26510},{10126,
-31164},{0, -32768},{-10126, -31164},{-19261, -26510},{-26510, -19261},{-31164, -10126}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw10o2[FFT_10] = {{32767, 0},{26510, -19261},{10126, -31164},{-10126,
-31164},{-26510,
-19261},{-32768, 0},{-26510, 19261},{-10126, 31164},{10126, 31164},{26510, 19261}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw10o4[FFT_10] = {{32767, 0},{10126, -31164},{-26510,
-19261},{-26510, 19261},{10126,
31164},{32767, 0},{10126, -31164},{-26510, -19261},{-26510, 19261},{10126, 31164}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw10o6[FFT_10] = {{32767, 0},{-10126, -31164},{-26510, 19261},{26510,
19261},{10126,
-31164},{-32768, 0},{10126, 31164},{26510, -19261},{-26510, -19261},{-10126, 31164}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw10o8[FFT_10] = {{32767, 0},{-26510, -19261},{10126, 31164},{10126,
-31164},{-26510,
19261},{32767, 0},{-26510, -19261},{10126, 31164},{10126, -31164},{-26510, 19261}};

// LUTs for 384pt FFT/IFFT
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw192[FFT_192] = {{32767, 0},
        {32764, -536},{32750, -1072},{32729, -1608},{32698, -2143},{32658, -2678},{32610, -3212},{32553, -3745},{32488,
-4277},{32413, -4808},{32330, -5338},
        {32239, -5866},{32138, -6393},{32029, -6918},{31912, -7441},{31786, -7962},{31651, -8481},{31508, -8998},{31357,
-9512},{31197, -10024},{31029, -10533},
        {30853, -11039},{30668, -11543},{30475, -12043},{30274, -12540},{30064, -13033},{29847, -13524},{29622,
-14010},{29389, -14493},{29148, -14972},{28899, -15447},
        {28642, -15917},{28378, -16384},{28106, -16846},{27827, -17304},{27540, -17757},{27246, -18205},{26944,
-18648},{26635, -19087},{26320, -19520},{25997, -19948},
        {25667, -20371},{25330, -20788},{24986, -21199},{24636, -21605},{24279, -22006},{23916, -22400},{23546,
-22788},{23170, -23170},{22788, -23546},{22400, -23916},
        {22006, -24279},{21605, -24636},{21199, -24986},{20788, -25330},{20371, -25667},{19948, -25997},{19520,
-26320},{19087, -26635},{18648, -26944},{18205, -27246},
        {17757, -27540},{17304, -27827},{16846, -28106},{16384, -28378},{15917, -28642},{15447, -28899},{14972,
-29148},{14493, -29389},{14010, -29622},{13524, -29847},
        {13033, -30064},{12540, -30274},{12043, -30475},{11543, -30668},{11039, -30853},{10533, -31029},{10024,
-31197},{9512, -31357},{8998, -31508},{8481, -31651},
        {7962, -31786},{7441, -31912},{6918, -32029},{6393, -32138},{5866, -32239},{5338, -32330},{4808, -32413},{4277,
-32488},{3745, -32553},{3212, -32610},
        {2678, -32658},{2143, -32698},{1608, -32729},{1072, -32750},{536, -32764},{0, -32768},{-536, -32764},{-1072,
-32750},{-1608, -32729},{-2143, -32698},
        {-2678, -32658},{-3212, -32610},{-3745, -32553},{-4277, -32488},{-4808, -32413},{-5338, -32330},{-5866,
-32239},{-6393, -32138},{-6918, -32029},{-7441, -31912},
        {-7962, -31786},{-8481, -31651},{-8998, -31508},{-9512, -31357},{-10024, -31197},{-10533, -31029},{-11039,
-30853},{-11543, -30668},{-12043, -30475},{-12540, -30274},
        {-13033, -30064},{-13524, -29847},{-14010, -29622},{-14493, -29389},{-14972, -29148},{-15447, -28899},{-15917,
-28642},{-16384, -28378},{-16846, -28106},{-17304, -27827},
        {-17757, -27540},{-18205, -27246},{-18648, -26944},{-19087, -26635},{-19520, -26320},{-19948, -25997},{-20371,
-25667},{-20788, -25330},{-21199, -24986},{-21605, -24636},
        {-22006, -24279},{-22400, -23916},{-22788, -23546},{-23170, -23170},{-23546, -22788},{-23916, -22400},{-24279,
-22006},{-24636, -21605},{-24986, -21199},{-25330, -20788},
        {-25667, -20371},{-25997, -19948},{-26320, -19520},{-26635, -19087},{-26944, -18648},{-27246, -18205},{-27540,
-17757},{-27827, -17304},{-28106, -16846},{-28378, -16384},
        {-28642, -15917},{-28899, -15447},{-29148, -14972},{-29389, -14493},{-29622, -14010},{-29847, -13524},{-30064,
-13033},{-30274, -12540},{-30475, -12043},{-30668, -11543},
        {-30853, -11039},{-31029, -10533},{-31197, -10024},{-31357, -9512},{-31508, -8998},{-31651, -8481},{-31786,
-7962},{-31912, -7441},{-32029, -6918},{-32138, -6393},
        {-32239, -5866},{-32330, -5338},{-32413, -4808},{-32488, -4277},{-32553, -3745},{-32610, -3212},{-32658,
-2678},{-32698, -2143},{-32729, -1608},{-32750, -1072},
        {-32764, -536}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw6o2[FFT_6] = {{32767, 0},{16384, -28378},{-16384, -28378},{-32768,
0},{-16384,
28378},{16384, 28378}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw6o4[FFT_6] = {{32767, 0},{-16384, -28378},{-16384, 28378},{32767,
0},{-16384,
-28378},{-16384, 28378}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw6[FFT_6] = {{32767, 0},{28378, -16384},{16384, -28378},{0,
-32768},{-16384,
-28378},{-28378, -16384}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw12[FFT_12] = {{32767, 0},{31651, -8481},{28378, -16384},{23170,
-23170},{16384,
-28378},{8481, -31651},
        {0, -32768},{-8481, -31651},{-16384, -28378},{-23170, -23170},{-28378, -16384},{-31651, -8481}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw24[FFT_24] = {{32767, 0},{32488, -4277},{31651, -8481},{30274,
-12540},{28378,
-16384},{25997, -19948},
        {23170, -23170},{19948, -25997},{16384, -28378},{12540, -30274},{8481, -31651},{4277, -32488},{0,
-32768},{-4277, -32488},{-8481, -31651},{-12540, -30274},
        {-16384, -28378},{-19948, -25997},{-23170, -23170},{-25997, -19948},{-28378, -16384},{-30274, -12540},{-31651,
-8481},{-32488, -4277}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw48[FFT_48] = {{32767, 0},
        {32698, -2143},{32488, -4277},{32138, -6393},{31651, -8481},{31029, -10533},{30274, -12540},{29389,
-14493},{28378, -16384},{27246, -18205},{25997, -19948},
        {24636, -21605},{23170, -23170},{21605, -24636},{19948, -25997},{18205, -27246},{16384, -28378},{14493,
-29389},{12540, -30274},{10533, -31029},{8481, -31651},
        {6393, -32138},{4277, -32488},{2143, -32698},{0, -32768},{-2143, -32698},{-4277, -32488},{-6393, -32138},{-8481,
-31651},{-10533, -31029},{-12540, -30274},
        {-14493, -29389},{-16384, -28378},{-18205, -27246},{-19948, -25997},{-21605, -24636},{-23170, -23170},{-24636,
-21605},{-25997, -19948},{-27246, -18205},{-28378, -16384},
        {-29389, -14493},{-30274, -12540},{-31029, -10533},{-31651, -8481},{-32138, -6393},{-32488, -4277},{-32698,
-2143}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw96[FFT_96] = {{32767, 0},
        {32750, -1072},{32698, -2143},{32610, -3212},{32488, -4277},{32330, -5338},{32138, -6393},{31912, -7441},{31651,
-8481},{31357, -9512},{31029, -10533},
        {30668, -11543},{30274, -12540},{29847, -13524},{29389, -14493},{28899, -15447},{28378, -16384},{27827,
-17304},{27246, -18205},{26635, -19087},{25997, -19948},
        {25330, -20788},{24636, -21605},{23916, -22400},{23170, -23170},{22400, -23916},{21605, -24636},{20788,
-25330},{19948, -25997},{19087, -26635},{18205, -27246},
        {17304, -27827},{16384, -28378},{15447, -28899},{14493, -29389},{13524, -29847},{12540, -30274},{11543,
-30668},{10533, -31029},{9512, -31357},{8481, -31651},
        {7441, -31912},{6393, -32138},{5338, -32330},{4277, -32488},{3212, -32610},{2143, -32698},{1072, -32750},{0,
-32768},{-1072, -32750},{-2143, -32698},
        {-3212, -32610},{-4277, -32488},{-5338, -32330},{-6393, -32138},{-7441, -31912},{-8481, -31651},{-9512,
-31357},{-10533, -31029},{-11543, -30668},{-12540, -30274},
        {-13524, -29847},{-14493, -29389},{-15447, -28899},{-16384, -28378},{-17304, -27827},{-18205, -27246},{-19087,
-26635},{-19948, -25997},{-20788, -25330},{-21605, -24636},
        {-22400, -23916},{-23170, -23170},{-23916, -22400},{-24636, -21605},{-25330, -20788},{-25997, -19948},{-26635,
-19087},{-27246, -18205},{-27827, -17304},{-28378, -16384},
        {-28899, -15447},{-29389, -14493},{-29847, -13524},{-30274, -12540},{-30668, -11543},{-31029, -10533},{-31357,
-9512},{-31651, -8481},{-31912, -7441},{-32138, -6393},
        {-32330, -5338},{-32488, -4277},{-32610, -3212},{-32698, -2143},{-32750, -1072}};

    // LUTs for 1200pt FFT/IFFT
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw300o2[FFT_300] =
        {{32767, 0},{32761, -686},{32739, -1372},{32703, -2058},{32653, -2742},{32588, -3425},{32510, -4107},{32416,
-4787},{32309, -5465},
        {32188, -6140},{32052, -6813},{31902, -7483},{31739, -8149},{31561, -8812},{31369, -9471},{31164,
-10126},{30945, -10776},{30713, -11422},{30467, -12063},
        {30208, -12698},{29935, -13328},{29649, -13952},{29351, -14570},{29039, -15181},{28715, -15786},{28378,
-16384},{28029, -16975},{27667, -17558},{27293, -18134},
        {26907, -18701},{26510, -19261},{26101, -19812},{25680, -20354},{25248, -20887},{24805, -21411},{24351,
-21926},{23887, -22431},{23412, -22927},{22927, -23412},
        {22431, -23887},{21926, -24351},{21411, -24805},{20887, -25248},{20354, -25680},{19812, -26101},{19261,
-26510},{18701, -26907},{18134, -27293},{17558, -27667},
        {16975, -28029},{16384, -28378},{15786, -28715},{15181, -29039},{14570, -29351},{13952, -29649},{13328,
-29935},{12698, -30208},{12063, -30467},{11422, -30713},
        {10776, -30945},{10126, -31164},{9471, -31369},{8812, -31561},{8149, -31739},{7483, -31902},{6813,
-32052},{6140, -32188},{5465, -32309},{4787, -32416},
        {4107, -32510},{3425, -32588},{2742, -32653},{2058, -32703},{1372, -32739},{686, -32761},{0, -32768},{-686,
-32761},{-1372, -32739},{-2058, -32703},
        {-2742, -32653},{-3425, -32588},{-4107, -32510},{-4787, -32416},{-5465, -32309},{-6140, -32188},{-6813,
-32052},{-7483, -31902},{-8149, -31739},{-8812, -31561},
        {-9471, -31369},{-10126, -31164},{-10776, -30945},{-11422, -30713},{-12063, -30467},{-12698, -30208},{-13328,
-29935},{-13952, -29649},{-14570, -29351},{-15181, -29039},
        {-15786, -28715},{-16384, -28378},{-16975, -28029},{-17558, -27667},{-18134, -27293},{-18701, -26907},{-19261,
-26510},{-19812, -26101},{-20354, -25680},{-20887, -25248},
        {-21411, -24805},{-21926, -24351},{-22431, -23887},{-22927, -23412},{-23412, -22927},{-23887, -22431},{-24351,
-21926},{-24805, -21411},{-25248, -20887},{-25680, -20354},
        {-26101, -19812},{-26510, -19261},{-26907, -18701},{-27293, -18134},{-27667, -17558},{-28029, -16975},{-28378,
-16384},{-28715, -15786},{-29039, -15181},{-29351, -14570},
        {-29649, -13952},{-29935, -13328},{-30208, -12698},{-30467, -12063},{-30713, -11422},{-30945, -10776},{-31164,
-10126},{-31369, -9471},{-31561, -8812},{-31739, -8149},
        {-31902, -7483},{-32052, -6813},{-32188, -6140},{-32309, -5465},{-32416, -4787},{-32510, -4107},{-32588,
-3425},{-32653, -2742},{-32703, -2058},{-32739, -1372},
        {-32761, -686},{-32768, 0},{-32761, 686},{-32739, 1372},{-32703, 2058},{-32653, 2742},{-32588, 3425},{-32510,
4107},{-32416, 4787},{-32309, 5465},
        {-32188, 6140},{-32052, 6813},{-31902, 7483},{-31739, 8149},{-31561, 8812},{-31369, 9471},{-31164,
10126},{-30945, 10776},{-30713, 11422},{-30467, 12063},
        {-30208, 12698},{-29935, 13328},{-29649, 13952},{-29351, 14570},{-29039, 15181},{-28715, 15786},{-28378,
16384},{-28029, 16975},{-27667, 17558},{-27293, 18134},
        {-26907, 18701},{-26510, 19261},{-26101, 19812},{-25680, 20354},{-25248, 20887},{-24805, 21411},{-24351,
21926},{-23887, 22431},{-23412, 22927},{-22927, 23412},
        {-22431, 23887},{-21926, 24351},{-21411, 24805},{-20887, 25248},{-20354, 25680},{-19812, 26101},{-19261,
26510},{-18701, 26907},{-18134, 27293},{-17558, 27667},
        {-16975, 28029},{-16384, 28378},{-15786, 28715},{-15181, 29039},{-14570, 29351},{-13952, 29649},{-13328,
29935},{-12698, 30208},{-12063, 30467},{-11422, 30713},
        {-10776, 30945},{-10126, 31164},{-9471, 31369},{-8812, 31561},{-8149, 31739},{-7483, 31902},{-6813,
32052},{-6140, 32188},{-5465, 32309},{-4787, 32416},
        {-4107, 32510},{-3425, 32588},{-2742, 32653},{-2058, 32703},{-1372, 32739},{-686, 32761},{0, 32767},{686,
32761},{1372, 32739},{2058, 32703},
        {2742, 32653},{3425, 32588},{4107, 32510},{4787, 32416},{5465, 32309},{6140, 32188},{6813, 32052},{7483,
31902},{8149, 31739},{8812, 31561},
        {9471, 31369},{10126, 31164},{10776, 30945},{11422, 30713},{12063, 30467},{12698, 30208},{13328, 29935},{13952,
29649},{14570, 29351},{15181, 29039},
        {15786, 28715},{16384, 28378},{16975, 28029},{17558, 27667},{18134, 27293},{18701, 26907},{19261, 26510},{19812,
26101},{20354, 25680},{20887, 25248},
        {21411, 24805},{21926, 24351},{22431, 23887},{22927, 23412},{23412, 22927},{23887, 22431},{24351, 21926},{24805,
21411},{25248, 20887},{25680, 20354},
        {26101, 19812},{26510, 19261},{26907, 18701},{27293, 18134},{27667, 17558},{28029, 16975},{28378, 16384},{28715,
15786},{29039, 15181},{29351, 14570},
        {29649, 13952},{29935, 13328},{30208, 12698},{30467, 12063},{30713, 11422},{30945, 10776},{31164, 10126},{31369,
9471},{31561, 8812},{31739, 8149},
        {31902, 7483},{32052, 6813},{32188, 6140},{32309, 5465},{32416, 4787},{32510, 4107},{32588, 3425},{32653,
2742},{32703, 2058},{32739, 1372},
        {32761, 686}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw300o4[FFT_300] =
        {{32767, 0},{32739, -1372},{32653, -2742},{32510, -4107},{32309, -5465},{32052, -6813},{31739, -8149},{31369,
-9471},{30945, -10776},
        {30467, -12063},{29935, -13328},{29351, -14570},{28715, -15786},{28029, -16975},{27293, -18134},{26510,
-19261},{25680, -20354},{24805, -21411},{23887, -22431},
        {22927, -23412},{21926, -24351},{20887, -25248},{19812, -26101},{18701, -26907},{17558, -27667},{16384,
-28378},{15181, -29039},{13952, -29649},{12698, -30208},
        {11422, -30713},{10126, -31164},{8812, -31561},{7483, -31902},{6140, -32188},{4787, -32416},{3425,
-32588},{2058, -32703},{686, -32761},{-686, -32761},
        {-2058, -32703},{-3425, -32588},{-4787, -32416},{-6140, -32188},{-7483, -31902},{-8812, -31561},{-10126,
-31164},{-11422, -30713},{-12698, -30208},{-13952, -29649},
        {-15181, -29039},{-16384, -28378},{-17558, -27667},{-18701, -26907},{-19812, -26101},{-20887, -25248},{-21926,
-24351},{-22927, -23412},{-23887, -22431},{-24805, -21411},
        {-25680, -20354},{-26510, -19261},{-27293, -18134},{-28029, -16975},{-28715, -15786},{-29351, -14570},{-29935,
-13328},{-30467, -12063},{-30945, -10776},{-31369, -9471},
        {-31739, -8149},{-32052, -6813},{-32309, -5465},{-32510, -4107},{-32653, -2742},{-32739, -1372},{-32768,
0},{-32739, 1372},{-32653, 2742},{-32510, 4107},
        {-32309, 5465},{-32052, 6813},{-31739, 8149},{-31369, 9471},{-30945, 10776},{-30467, 12063},{-29935,
13328},{-29351, 14570},{-28715, 15786},{-28029, 16975},
        {-27293, 18134},{-26510, 19261},{-25680, 20354},{-24805, 21411},{-23887, 22431},{-22927, 23412},{-21926,
24351},{-20887, 25248},{-19812, 26101},{-18701, 26907},
        {-17558, 27667},{-16384, 28378},{-15181, 29039},{-13952, 29649},{-12698, 30208},{-11422, 30713},{-10126,
31164},{-8812, 31561},{-7483, 31902},{-6140, 32188},
        {-4787, 32416},{-3425, 32588},{-2058, 32703},{-686, 32761},{686, 32761},{2058, 32703},{3425, 32588},{4787,
32416},{6140, 32188},{7483, 31902},
        {8812, 31561},{10126, 31164},{11422, 30713},{12698, 30208},{13952, 29649},{15181, 29039},{16384, 28378},{17558,
27667},{18701, 26907},{19812, 26101},
        {20887, 25248},{21926, 24351},{22927, 23412},{23887, 22431},{24805, 21411},{25680, 20354},{26510, 19261},{27293,
18134},{28029, 16975},{28715, 15786},
        {29351, 14570},{29935, 13328},{30467, 12063},{30945, 10776},{31369, 9471},{31739, 8149},{32052, 6813},{32309,
5465},{32510, 4107},{32653, 2742},
        {32739, 1372},{32767, 0},{32739, -1372},{32653, -2742},{32510, -4107},{32309, -5465},{32052, -6813},{31739,
-8149},{31369, -9471},{30945, -10776},
        {30467, -12063},{29935, -13328},{29351, -14570},{28715, -15786},{28029, -16975},{27293, -18134},{26510,
-19261},{25680, -20354},{24805, -21411},{23887, -22431},
        {22927, -23412},{21926, -24351},{20887, -25248},{19812, -26101},{18701, -26907},{17558, -27667},{16384,
-28378},{15181, -29039},{13952, -29649},{12698, -30208},
        {11422, -30713},{10126, -31164},{8812, -31561},{7483, -31902},{6140, -32188},{4787, -32416},{3425,
-32588},{2058, -32703},{686, -32761},{-686, -32761},
        {-2058, -32703},{-3425, -32588},{-4787, -32416},{-6140, -32188},{-7483, -31902},{-8812, -31561},{-10126,
-31164},{-11422, -30713},{-12698, -30208},{-13952, -29649},
        {-15181, -29039},{-16384, -28378},{-17558, -27667},{-18701, -26907},{-19812, -26101},{-20887, -25248},{-21926,
-24351},{-22927, -23412},{-23887, -22431},{-24805, -21411},
        {-25680, -20354},{-26510, -19261},{-27293, -18134},{-28029, -16975},{-28715, -15786},{-29351, -14570},{-29935,
-13328},{-30467, -12063},{-30945, -10776},{-31369, -9471},
        {-31739, -8149},{-32052, -6813},{-32309, -5465},{-32510, -4107},{-32653, -2742},{-32739, -1372},{-32768,
0},{-32739, 1372},{-32653, 2742},{-32510, 4107},
        {-32309, 5465},{-32052, 6813},{-31739, 8149},{-31369, 9471},{-30945, 10776},{-30467, 12063},{-29935,
13328},{-29351, 14570},{-28715, 15786},{-28029, 16975},
        {-27293, 18134},{-26510, 19261},{-25680, 20354},{-24805, 21411},{-23887, 22431},{-22927, 23412},{-21926,
24351},{-20887, 25248},{-19812, 26101},{-18701, 26907},
        {-17558, 27667},{-16384, 28378},{-15181, 29039},{-13952, 29649},{-12698, 30208},{-11422, 30713},{-10126,
31164},{-8812, 31561},{-7483, 31902},{-6140, 32188},
        {-4787, 32416},{-3425, 32588},{-2058, 32703},{-686, 32761},{686, 32761},{2058, 32703},{3425, 32588},{4787,
32416},{6140, 32188},{7483, 31902},
        {8812, 31561},{10126, 31164},{11422, 30713},{12698, 30208},{13952, 29649},{15181, 29039},{16384, 28378},{17558,
27667},{18701, 26907},{19812, 26101},
        {20887, 25248},{21926, 24351},{22927, 23412},{23887, 22431},{24805, 21411},{25680, 20354},{26510, 19261},{27293,
18134},{28029, 16975},{28715, 15786},
        {29351, 14570},{29935, 13328},{30467, 12063},{30945, 10776},{31369, 9471},{31739, 8149},{32052, 6813},{32309,
5465},{32510, 4107},{32653, 2742},
        {32739, 1372}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw300[FFT_300] =
        {{32767, 0},{32766, -343},{32761, -686},{32752, -1029},{32739, -1372},{32723, -1715},{32703, -2058},{32680,
-2400},{32653, -2742},
        {32623, -3084},{32588, -3425},{32551, -3766},{32510, -4107},{32465, -4447},{32416, -4787},{32365, -5126},{32309,
-5465},{32250, -5803},{32188, -6140},
        {32122, -6477},{32052, -6813},{31979, -7148},{31902, -7483},{31822, -7816},{31739, -8149},{31651, -8481},{31561,
-8812},{31467, -9142},{31369, -9471},
        {31269, -9799},{31164, -10126},{31056, -10452},{30945, -10776},{30831, -11100},{30713, -11422},{30592,
-11743},{30467, -12063},{30339, -12381},{30208, -12698},
        {30073, -13014},{29935, -13328},{29794, -13641},{29649, -13952},{29502, -14262},{29351, -14570},{29197,
-14876},{29039, -15181},{28879, -15485},{28715, -15786},
        {28548, -16086},{28378, -16384},{28205, -16680},{28029, -16975},{27849, -17267},{27667, -17558},{27482,
-17847},{27293, -18134},{27102, -18418},{26907, -18701},
        {26710, -18982},{26510, -19261},{26307, -19537},{26101, -19812},{25892, -20084},{25680, -20354},{25466,
-20622},{25248, -20887},{25028, -21150},{24805, -21411},
        {24580, -21670},{24351, -21926},{24120, -22180},{23887, -22431},{23651, -22680},{23412, -22927},{23170,
-23170},{22927, -23412},{22680, -23651},{22431, -23887},
        {22180, -24120},{21926, -24351},{21670, -24580},{21411, -24805},{21150, -25028},{20887, -25248},{20622,
-25466},{20354, -25680},{20084, -25892},{19812, -26101},
        {19537, -26307},{19261, -26510},{18982, -26710},{18701, -26907},{18418, -27102},{18134, -27293},{17847,
-27482},{17558, -27667},{17267, -27849},{16975, -28029},
        {16680, -28205},{16384, -28378},{16086, -28548},{15786, -28715},{15485, -28879},{15181, -29039},{14876,
-29197},{14570, -29351},{14262, -29502},{13952, -29649},
        {13641, -29794},{13328, -29935},{13014, -30073},{12698, -30208},{12381, -30339},{12063, -30467},{11743,
-30592},{11422, -30713},{11100, -30831},{10776, -30945},
        {10452, -31056},{10126, -31164},{9799, -31269},{9471, -31369},{9142, -31467},{8812, -31561},{8481,
-31651},{8149, -31739},{7816, -31822},{7483, -31902},
        {7148, -31979},{6813, -32052},{6477, -32122},{6140, -32188},{5803, -32250},{5465, -32309},{5126, -32365},{4787,
-32416},{4447, -32465},{4107, -32510},
        {3766, -32551},{3425, -32588},{3084, -32623},{2742, -32653},{2400, -32680},{2058, -32703},{1715, -32723},{1372,
-32739},{1029, -32752},{686, -32761},
        {343, -32766},{0, -32768},{-343, -32766},{-686, -32761},{-1029, -32752},{-1372, -32739},{-1715, -32723},{-2058,
-32703},{-2400, -32680},{-2742, -32653},
        {-3084, -32623},{-3425, -32588},{-3766, -32551},{-4107, -32510},{-4447, -32465},{-4787, -32416},{-5126,
-32365},{-5465, -32309},{-5803, -32250},{-6140, -32188},
        {-6477, -32122},{-6813, -32052},{-7148, -31979},{-7483, -31902},{-7816, -31822},{-8149, -31739},{-8481,
-31651},{-8812, -31561},{-9142, -31467},{-9471, -31369},
        {-9799, -31269},{-10126, -31164},{-10452, -31056},{-10776, -30945},{-11100, -30831},{-11422, -30713},{-11743,
-30592},{-12063, -30467},{-12381, -30339},{-12698, -30208},
        {-13014, -30073},{-13328, -29935},{-13641, -29794},{-13952, -29649},{-14262, -29502},{-14570, -29351},{-14876,
-29197},{-15181, -29039},{-15485, -28879},{-15786, -28715},
        {-16086, -28548},{-16384, -28378},{-16680, -28205},{-16975, -28029},{-17267, -27849},{-17558, -27667},{-17847,
-27482},{-18134, -27293},{-18418, -27102},{-18701, -26907},
        {-18982, -26710},{-19261, -26510},{-19537, -26307},{-19812, -26101},{-20084, -25892},{-20354, -25680},{-20622,
-25466},{-20887, -25248},{-21150, -25028},{-21411, -24805},
        {-21670, -24580},{-21926, -24351},{-22180, -24120},{-22431, -23887},{-22680, -23651},{-22927, -23412},{-23170,
-23170},{-23412, -22927},{-23651, -22680},{-23887, -22431},
        {-24120, -22180},{-24351, -21926},{-24580, -21670},{-24805, -21411},{-25028, -21150},{-25248, -20887},{-25466,
-20622},{-25680, -20354},{-25892, -20084},{-26101, -19812},
        {-26307, -19537},{-26510, -19261},{-26710, -18982},{-26907, -18701},{-27102, -18418},{-27293, -18134},{-27482,
-17847},{-27667, -17558},{-27849, -17267},{-28029, -16975},
        {-28205, -16680},{-28378, -16384},{-28548, -16086},{-28715, -15786},{-28879, -15485},{-29039, -15181},{-29197,
-14876},{-29351, -14570},{-29502, -14262},{-29649, -13952},
        {-29794, -13641},{-29935, -13328},{-30073, -13014},{-30208, -12698},{-30339, -12381},{-30467, -12063},{-30592,
-11743},{-30713, -11422},{-30831, -11100},{-30945, -10776},
        {-31056, -10452},{-31164, -10126},{-31269, -9799},{-31369, -9471},{-31467, -9142},{-31561, -8812},{-31651,
-8481},{-31739, -8149},{-31822, -7816},{-31902, -7483},
        {-31979, -7148},{-32052, -6813},{-32122, -6477},{-32188, -6140},{-32250, -5803},{-32309, -5465},{-32365,
-5126},{-32416, -4787},{-32465, -4447},{-32510, -4107},
        {-32551, -3766},{-32588, -3425},{-32623, -3084},{-32653, -2742},{-32680, -2400},{-32703, -2058},{-32723,
-1715},{-32739, -1372},{-32752, -1029},{-32761, -686},
        {-32766, -343}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw600[FFT_600] =
        {{32767, 0},{32767, -172},{32766, -343},{32764, -515},{32761, -686},{32757, -858},{32752, -1029},{32746,
-1201},{32739, -1372},
        {32732, -1544},{32723, -1715},{32714, -1886},{32703, -2058},{32692, -2229},{32680, -2400},{32667, -2571},{32653,
-2742},{32638, -2913},{32623, -3084},
        {32606, -3255},{32588, -3425},{32570, -3596},{32551, -3766},{32531, -3937},{32510, -4107},{32488, -4277},{32465,
-4447},{32441, -4617},{32416, -4787},
        {32391, -4957},{32365, -5126},{32337, -5295},{32309, -5465},{32280, -5634},{32250, -5803},{32219, -5971},{32188,
-6140},{32155, -6309},{32122, -6477},
        {32087, -6645},{32052, -6813},{32016, -6981},{31979, -7148},{31941, -7315},{31902, -7483},{31863, -7650},{31822,
-7816},{31781, -7983},{31739, -8149},
        {31695, -8315},{31651, -8481},{31607, -8647},{31561, -8812},{31514, -8977},{31467, -9142},{31419, -9307},{31369,
-9471},{31319, -9635},{31269, -9799},
        {31217, -9963},{31164, -10126},{31111, -10289},{31056, -10452},{31001, -10614},{30945, -10776},{30888,
-10938},{30831, -11100},{30772, -11261},{30713, -11422},
        {30653, -11583},{30592, -11743},{30530, -11903},{30467, -12063},{30403, -12222},{30339, -12381},{30274,
-12540},{30208, -12698},{30141, -12856},{30073, -13014},
        {30004, -13171},{29935, -13328},{29865, -13485},{29794, -13641},{29722, -13797},{29649, -13952},{29576,
-14107},{29502, -14262},{29427, -14416},{29351, -14570},
        {29274, -14723},{29197, -14876},{29118, -15029},{29039, -15181},{28959, -15333},{28879, -15485},{28797,
-15636},{28715, -15786},{28632, -15936},{28548, -16086},
        {28463, -16235},{28378, -16384},{28292, -16532},{28205, -16680},{28117, -16828},{28029, -16975},{27939,
-17121},{27849, -17267},{27758, -17413},{27667, -17558},
        {27575, -17703},{27482, -17847},{27388, -17990},{27293, -18134},{27198, -18276},{27102, -18418},{27005,
-18560},{26907, -18701},{26809, -18842},{26710, -18982},
        {26610, -19121},{26510, -19261},{26409, -19399},{26307, -19537},{26204, -19675},{26101, -19812},{25997,
-19948},{25892, -20084},{25786, -20219},{25680, -20354},
        {25573, -20488},{25466, -20622},{25357, -20755},{25248, -20887},{25138, -21019},{25028, -21150},{24917,
-21281},{24805, -21411},{24693, -21541},{24580, -21670},
        {24466, -21798},{24351, -21926},{24236, -22053},{24120, -22180},{24004, -22306},{23887, -22431},{23769,
-22556},{23651, -22680},{23532, -22804},{23412, -22927},
        {23291, -23049},{23170, -23170},{23049, -23291},{22927, -23412},{22804, -23532},{22680, -23651},{22556,
-23769},{22431, -23887},{22306, -24004},{22180, -24120},
        {22053, -24236},{21926, -24351},{21798, -24466},{21670, -24580},{21541, -24693},{21411, -24805},{21281,
-24917},{21150, -25028},{21019, -25138},{20887, -25248},
        {20755, -25357},{20622, -25466},{20488, -25573},{20354, -25680},{20219, -25786},{20084, -25892},{19948,
-25997},{19812, -26101},{19675, -26204},{19537, -26307},
        {19399, -26409},{19261, -26510},{19121, -26610},{18982, -26710},{18842, -26809},{18701, -26907},{18560,
-27005},{18418, -27102},{18276, -27198},{18134, -27293},
        {17990, -27388},{17847, -27482},{17703, -27575},{17558, -27667},{17413, -27758},{17267, -27849},{17121,
-27939},{16975, -28029},{16828, -28117},{16680, -28205},
        {16532, -28292},{16384, -28378},{16235, -28463},{16086, -28548},{15936, -28632},{15786, -28715},{15636,
-28797},{15485, -28879},{15333, -28959},{15181, -29039},
        {15029, -29118},{14876, -29197},{14723, -29274},{14570, -29351},{14416, -29427},{14262, -29502},{14107,
-29576},{13952, -29649},{13797, -29722},{13641, -29794},
        {13485, -29865},{13328, -29935},{13171, -30004},{13014, -30073},{12856, -30141},{12698, -30208},{12540,
-30274},{12381, -30339},{12222, -30403},{12063, -30467},
        {11903, -30530},{11743, -30592},{11583, -30653},{11422, -30713},{11261, -30772},{11100, -30831},{10938,
-30888},{10776, -30945},{10614, -31001},{10452, -31056},
        {10289, -31111},{10126, -31164},{9963, -31217},{9799, -31269},{9635, -31319},{9471, -31369},{9307,
-31419},{9142, -31467},{8977, -31514},{8812, -31561},
        {8647, -31607},{8481, -31651},{8315, -31695},{8149, -31739},{7983, -31781},{7816, -31822},{7650, -31863},{7483,
-31902},{7315, -31941},{7148, -31979},
        {6981, -32016},{6813, -32052},{6645, -32087},{6477, -32122},{6309, -32155},{6140, -32188},{5971, -32219},{5803,
-32250},{5634, -32280},{5465, -32309},
        {5295, -32337},{5126, -32365},{4957, -32391},{4787, -32416},{4617, -32441},{4447, -32465},{4277, -32488},{4107,
-32510},{3937, -32531},{3766, -32551},
        {3596, -32570},{3425, -32588},{3255, -32606},{3084, -32623},{2913, -32638},{2742, -32653},{2571, -32667},{2400,
-32680},{2229, -32692},{2058, -32703},
        {1886, -32714},{1715, -32723},{1544, -32732},{1372, -32739},{1201, -32746},{1029, -32752},{858, -32757},{686,
-32761},{515, -32764},{343, -32766},
        {172, -32768},{0, -32768},{-172, -32768},{-343, -32766},{-515, -32764},{-686, -32761},{-858, -32757},{-1029,
-32752},{-1201, -32746},{-1372, -32739},
        {-1544, -32732},{-1715, -32723},{-1886, -32714},{-2058, -32703},{-2229, -32692},{-2400, -32680},{-2571,
-32667},{-2742, -32653},{-2913, -32638},{-3084, -32623},
        {-3255, -32606},{-3425, -32588},{-3596, -32570},{-3766, -32551},{-3937, -32531},{-4107, -32510},{-4277,
-32488},{-4447, -32465},{-4617, -32441},{-4787, -32416},
        {-4957, -32391},{-5126, -32365},{-5295, -32337},{-5465, -32309},{-5634, -32280},{-5803, -32250},{-5971,
-32219},{-6140, -32188},{-6309, -32155},{-6477, -32122},
        {-6645, -32087},{-6813, -32052},{-6981, -32016},{-7148, -31979},{-7315, -31941},{-7483, -31902},{-7650,
-31863},{-7816, -31822},{-7983, -31781},{-8149, -31739},
        {-8315, -31695},{-8481, -31651},{-8647, -31607},{-8812, -31561},{-8977, -31514},{-9142, -31467},{-9307,
-31419},{-9471, -31369},{-9635, -31319},{-9799, -31269},
        {-9963, -31217},{-10126, -31164},{-10289, -31111},{-10452, -31056},{-10614, -31001},{-10776, -30945},{-10938,
-30888},{-11100, -30831},{-11261, -30772},{-11422, -30713},
        {-11583, -30653},{-11743, -30592},{-11903, -30530},{-12063, -30467},{-12222, -30403},{-12381, -30339},{-12540,
-30274},{-12698, -30208},{-12856, -30141},{-13014, -30073},
        {-13171, -30004},{-13328, -29935},{-13485, -29865},{-13641, -29794},{-13797, -29722},{-13952, -29649},{-14107,
-29576},{-14262, -29502},{-14416, -29427},{-14570, -29351},
        {-14723, -29274},{-14876, -29197},{-15029, -29118},{-15181, -29039},{-15333, -28959},{-15485, -28879},{-15636,
-28797},{-15786, -28715},{-15936, -28632},{-16086, -28548},
        {-16235, -28463},{-16384, -28378},{-16532, -28292},{-16680, -28205},{-16828, -28117},{-16975, -28029},{-17121,
-27939},{-17267, -27849},{-17413, -27758},{-17558, -27667},
        {-17703, -27575},{-17847, -27482},{-17990, -27388},{-18134, -27293},{-18276, -27198},{-18418, -27102},{-18560,
-27005},{-18701, -26907},{-18842, -26809},{-18982, -26710},
        {-19121, -26610},{-19261, -26510},{-19399, -26409},{-19537, -26307},{-19675, -26204},{-19812, -26101},{-19948,
-25997},{-20084, -25892},{-20219, -25786},{-20354, -25680},
        {-20488, -25573},{-20622, -25466},{-20755, -25357},{-20887, -25248},{-21019, -25138},{-21150, -25028},{-21281,
-24917},{-21411, -24805},{-21541, -24693},{-21670, -24580},
        {-21798, -24466},{-21926, -24351},{-22053, -24236},{-22180, -24120},{-22306, -24004},{-22431, -23887},{-22556,
-23769},{-22680, -23651},{-22804, -23532},{-22927, -23412},
        {-23049, -23291},{-23170, -23170},{-23291, -23049},{-23412, -22927},{-23532, -22804},{-23651, -22680},{-23769,
-22556},{-23887, -22431},{-24004, -22306},{-24120, -22180},
        {-24236, -22053},{-24351, -21926},{-24466, -21798},{-24580, -21670},{-24693, -21541},{-24805, -21411},{-24917,
-21281},{-25028, -21150},{-25138, -21019},{-25248, -20887},
        {-25357, -20755},{-25466, -20622},{-25573, -20488},{-25680, -20354},{-25786, -20219},{-25892, -20084},{-25997,
-19948},{-26101, -19812},{-26204, -19675},{-26307, -19537},
        {-26409, -19399},{-26510, -19261},{-26610, -19121},{-26710, -18982},{-26809, -18842},{-26907, -18701},{-27005,
-18560},{-27102, -18418},{-27198, -18276},{-27293, -18134},
        {-27388, -17990},{-27482, -17847},{-27575, -17703},{-27667, -17558},{-27758, -17413},{-27849, -17267},{-27939,
-17121},{-28029, -16975},{-28117, -16828},{-28205, -16680},
        {-28292, -16532},{-28378, -16384},{-28463, -16235},{-28548, -16086},{-28632, -15936},{-28715, -15786},{-28797,
-15636},{-28879, -15485},{-28959, -15333},{-29039, -15181},
        {-29118, -15029},{-29197, -14876},{-29274, -14723},{-29351, -14570},{-29427, -14416},{-29502, -14262},{-29576,
-14107},{-29649, -13952},{-29722, -13797},{-29794, -13641},
        {-29865, -13485},{-29935, -13328},{-30004, -13171},{-30073, -13014},{-30141, -12856},{-30208, -12698},{-30274,
-12540},{-30339, -12381},{-30403, -12222},{-30467, -12063},
        {-30530, -11903},{-30592, -11743},{-30653, -11583},{-30713, -11422},{-30772, -11261},{-30831, -11100},{-30888,
-10938},{-30945, -10776},{-31001, -10614},{-31056, -10452},
        {-31111, -10289},{-31164, -10126},{-31217, -9963},{-31269, -9799},{-31319, -9635},{-31369, -9471},{-31419,
-9307},{-31467, -9142},{-31514, -8977},{-31561, -8812},
        {-31607, -8647},{-31651, -8481},{-31695, -8315},{-31739, -8149},{-31781, -7983},{-31822, -7816},{-31863,
-7650},{-31902, -7483},{-31941, -7315},{-31979, -7148},
        {-32016, -6981},{-32052, -6813},{-32087, -6645},{-32122, -6477},{-32155, -6309},{-32188, -6140},{-32219,
-5971},{-32250, -5803},{-32280, -5634},{-32309, -5465},
        {-32337, -5295},{-32365, -5126},{-32391, -4957},{-32416, -4787},{-32441, -4617},{-32465, -4447},{-32488,
-4277},{-32510, -4107},{-32531, -3937},{-32551, -3766},
        {-32570, -3596},{-32588, -3425},{-32606, -3255},{-32623, -3084},{-32638, -2913},{-32653, -2742},{-32667,
-2571},{-32680, -2400},{-32692, -2229},{-32703, -2058},
        {-32714, -1886},{-32723, -1715},{-32732, -1544},{-32739, -1372},{-32746, -1201},{-32752, -1029},{-32757,
-858},{-32761, -686},{-32764, -515},{-32766, -343},
        {-32768, -172}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw20o2[FFT_20] =
        {{32767, 0},{31164, -10126},{26510, -19261},{19261, -26510},{10126, -31164},{0, -32768},{-10126,
-31164},{-19261, -26510},{-26510, -19261},
        {-31164, -10126},{-32768, 0},{-31164, 10126},{-26510, 19261},{-19261, 26510},{-10126, 31164},{0, 32767},{10126,
31164},{19261, 26510},{26510, 19261},
        {31164, 10126}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw20o4[FFT_20] =
        {{32767, 0},{26510, -19261},{10126, -31164},{-10126, -31164},{-26510, -19261},{-32768, 0},{-26510,
19261},{-10126, 31164},{10126, 31164},
        {26510, 19261},{32767, 0},{26510, -19261},{10126, -31164},{-10126, -31164},{-26510, -19261},{-32768, 0},{-26510,
19261},{-10126, 31164},{10126, 31164},
        {26510, 19261}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw20o6[FFT_20] =
        {{32767, 0},{19261, -26510},{-10126, -31164},{-31164, -10126},{-26510, 19261},{0, 32767},{26510, 19261},{31164,
-10126},{10126, -31164},
        {-19261, -26510},{-32768, 0},{-19261, 26510},{10126, 31164},{31164, 10126},{26510, -19261},{0, -32768},{-26510,
-19261},{-31164, 10126},{-10126, 31164},
        {19261, 26510}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw20o8[FFT_20] =
        {{32767, 0},{10126, -31164},{-26510, -19261},{-26510, 19261},{10126, 31164},{32767, 0},{10126, -31164},{-26510,
-19261},{-26510, 19261},
        {10126, 31164},{32767, 0},{10126, -31164},{-26510, -19261},{-26510, 19261},{10126, 31164},{32767, 0},{10126,
-31164},{-26510, -19261},{-26510, 19261},
        {10126, 31164}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw100o2[FFT_100] =
        {{32767, 0},{32703, -2058},{32510, -4107},{32188, -6140},{31739, -8149},{31164, -10126},{30467, -12063},{29649,
-13952},{28715, -15786},
        {27667, -17558},{26510, -19261},{25248, -20887},{23887, -22431},{22431, -23887},{20887, -25248},{19261,
-26510},{17558, -27667},{15786, -28715},{13952, -29649},
        {12063, -30467},{10126, -31164},{8149, -31739},{6140, -32188},{4107, -32510},{2058, -32703},{0, -32768},{-2058,
-32703},{-4107, -32510},{-6140, -32188},
        {-8149, -31739},{-10126, -31164},{-12063, -30467},{-13952, -29649},{-15786, -28715},{-17558, -27667},{-19261,
-26510},{-20887, -25248},{-22431, -23887},{-23887, -22431},
        {-25248, -20887},{-26510, -19261},{-27667, -17558},{-28715, -15786},{-29649, -13952},{-30467, -12063},{-31164,
-10126},{-31739, -8149},{-32188, -6140},{-32510, -4107},
        {-32703, -2058},{-32768, 0},{-32703, 2058},{-32510, 4107},{-32188, 6140},{-31739, 8149},{-31164, 10126},{-30467,
12063},{-29649, 13952},{-28715, 15786},
        {-27667, 17558},{-26510, 19261},{-25248, 20887},{-23887, 22431},{-22431, 23887},{-20887, 25248},{-19261,
26510},{-17558, 27667},{-15786, 28715},{-13952, 29649},
        {-12063, 30467},{-10126, 31164},{-8149, 31739},{-6140, 32188},{-4107, 32510},{-2058, 32703},{0, 32767},{2058,
32703},{4107, 32510},{6140, 32188},
        {8149, 31739},{10126, 31164},{12063, 30467},{13952, 29649},{15786, 28715},{17558, 27667},{19261, 26510},{20887,
25248},{22431, 23887},{23887, 22431},
        {25248, 20887},{26510, 19261},{27667, 17558},{28715, 15786},{29649, 13952},{30467, 12063},{31164, 10126},{31739,
8149},{32188, 6140},{32510, 4107},
        {32703, 2058}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw100o4[FFT_100] =
        {{32767, 0},{32510, -4107},{31739, -8149},{30467, -12063},{28715, -15786},{26510, -19261},{23887,
-22431},{20887, -25248},{17558, -27667},
        {13952, -29649},{10126, -31164},{6140, -32188},{2058, -32703},{-2058, -32703},{-6140, -32188},{-10126,
-31164},{-13952, -29649},{-17558, -27667},{-20887, -25248},
        {-23887, -22431},{-26510, -19261},{-28715, -15786},{-30467, -12063},{-31739, -8149},{-32510, -4107},{-32768,
0},{-32510, 4107},{-31739, 8149},{-30467, 12063},
        {-28715, 15786},{-26510, 19261},{-23887, 22431},{-20887, 25248},{-17558, 27667},{-13952, 29649},{-10126,
31164},{-6140, 32188},{-2058, 32703},{2058, 32703},
        {6140, 32188},{10126, 31164},{13952, 29649},{17558, 27667},{20887, 25248},{23887, 22431},{26510, 19261},{28715,
15786},{30467, 12063},{31739, 8149},
        {32510, 4107},{32767, 0},{32510, -4107},{31739, -8149},{30467, -12063},{28715, -15786},{26510, -19261},{23887,
-22431},{20887, -25248},{17558, -27667},
        {13952, -29649},{10126, -31164},{6140, -32188},{2058, -32703},{-2058, -32703},{-6140, -32188},{-10126,
-31164},{-13952, -29649},{-17558, -27667},{-20887, -25248},
        {-23887, -22431},{-26510, -19261},{-28715, -15786},{-30467, -12063},{-31739, -8149},{-32510, -4107},{-32768,
0},{-32510, 4107},{-31739, 8149},{-30467, 12063},
        {-28715, 15786},{-26510, 19261},{-23887, 22431},{-20887, 25248},{-17558, 27667},{-13952, 29649},{-10126,
31164},{-6140, 32188},{-2058, 32703},{2058, 32703},
        {6140, 32188},{10126, 31164},{13952, 29649},{17558, 27667},{20887, 25248},{23887, 22431},{26510, 19261},{28715,
15786},{30467, 12063},{31739, 8149},
        {32510, 4107}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw100o6[FFT_100] =
        {{32767, 0},{32188, -6140},{30467, -12063},{27667, -17558},{23887, -22431},{19261, -26510},{13952,
-29649},{8149, -31739},{2058, -32703},
        {-4107, -32510},{-10126, -31164},{-15786, -28715},{-20887, -25248},{-25248, -20887},{-28715, -15786},{-31164,
-10126},{-32510, -4107},{-32703, 2058},{-31739, 8149},
        {-29649, 13952},{-26510, 19261},{-22431, 23887},{-17558, 27667},{-12063, 30467},{-6140, 32188},{0, 32767},{6140,
32188},{12063, 30467},{17558, 27667},
        {22431, 23887},{26510, 19261},{29649, 13952},{31739, 8149},{32703, 2058},{32510, -4107},{31164, -10126},{28715,
-15786},{25248, -20887},{20887, -25248},
        {15786, -28715},{10126, -31164},{4107, -32510},{-2058, -32703},{-8149, -31739},{-13952, -29649},{-19261,
-26510},{-23887, -22431},{-27667, -17558},{-30467, -12063},
        {-32188, -6140},{-32768, 0},{-32188, 6140},{-30467, 12063},{-27667, 17558},{-23887, 22431},{-19261,
26510},{-13952, 29649},{-8149, 31739},{-2058, 32703},
        {4107, 32510},{10126, 31164},{15786, 28715},{20887, 25248},{25248, 20887},{28715, 15786},{31164, 10126},{32510,
4107},{32703, -2058},{31739, -8149},
        {29649, -13952},{26510, -19261},{22431, -23887},{17558, -27667},{12063, -30467},{6140, -32188},{0,
-32768},{-6140, -32188},{-12063, -30467},{-17558, -27667},
        {-22431, -23887},{-26510, -19261},{-29649, -13952},{-31739, -8149},{-32703, -2058},{-32510, 4107},{-31164,
10126},{-28715, 15786},{-25248, 20887},{-20887, 25248},
        {-15786, 28715},{-10126, 31164},{-4107, 32510},{2058, 32703},{8149, 31739},{13952, 29649},{19261, 26510},{23887,
22431},{27667, 17558},{30467, 12063},
        {32188, 6140}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw100o8[FFT_100] =
        {{32767, 0},{31739, -8149},{28715, -15786},{23887, -22431},{17558, -27667},{10126, -31164},{2058,
-32703},{-6140, -32188},{-13952, -29649},
        {-20887, -25248},{-26510, -19261},{-30467, -12063},{-32510, -4107},{-32510, 4107},{-30467, 12063},{-26510,
19261},{-20887, 25248},{-13952, 29649},{-6140, 32188},
        {2058, 32703},{10126, 31164},{17558, 27667},{23887, 22431},{28715, 15786},{31739, 8149},{32767, 0},{31739,
-8149},{28715, -15786},{23887, -22431},
        {17558, -27667},{10126, -31164},{2058, -32703},{-6140, -32188},{-13952, -29649},{-20887, -25248},{-26510,
-19261},{-30467, -12063},{-32510, -4107},{-32510, 4107},
        {-30467, 12063},{-26510, 19261},{-20887, 25248},{-13952, 29649},{-6140, 32188},{2058, 32703},{10126,
31164},{17558, 27667},{23887, 22431},{28715, 15786},
        {31739, 8149},{32767, 0},{31739, -8149},{28715, -15786},{23887, -22431},{17558, -27667},{10126, -31164},{2058,
-32703},{-6140, -32188},{-13952, -29649},
        {-20887, -25248},{-26510, -19261},{-30467, -12063},{-32510, -4107},{-32510, 4107},{-30467, 12063},{-26510,
19261},{-20887, 25248},{-13952, 29649},{-6140, 32188},
        {2058, 32703},{10126, 31164},{17558, 27667},{23887, 22431},{28715, 15786},{31739, 8149},{32767, 0},{31739,
-8149},{28715, -15786},{23887, -22431},
        {17558, -27667},{10126, -31164},{2058, -32703},{-6140, -32188},{-13952, -29649},{-20887, -25248},{-26510,
-19261},{-30467, -12063},{-32510, -4107},{-32510, 4107},
        {-30467, 12063},{-26510, 19261},{-20887, 25248},{-13952, 29649},{-6140, 32188},{2058, 32703},{10126,
31164},{17558, 27667},{23887, 22431},{28715, 15786},
        {31739, 8149}};

    // LUTs for 1536pt FFT/IFFT
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw384[FFT_384] =
        {{32767, 0},{32767, -268},{32764, -536},{32758, -804},{32750, -1072},{32741, -1340},{32729, -1608},{32714,
-1876},{32698, -2143},
        {32679, -2411},{32658, -2678},{32635, -2945},{32610, -3212},{32583, -3479},{32553, -3745},{32522, -4011},{32488,
-4277},{32452, -4543},{32413, -4808},
        {32373, -5073},{32330, -5338},{32286, -5602},{32239, -5866},{32190, -6130},{32138, -6393},{32085, -6655},{32029,
-6918},{31972, -7180},{31912, -7441},
        {31850, -7702},{31786, -7962},{31720, -8222},{31651, -8481},{31581, -8740},{31508, -8998},{31434, -9255},{31357,
-9512},{31278, -9768},{31197, -10024},
        {31114, -10279},{31029, -10533},{30942, -10786},{30853, -11039},{30761, -11291},{30668, -11543},{30572,
-11793},{30475, -12043},{30375, -12292},{30274, -12540},
        {30170, -12787},{30064, -13033},{29957, -13279},{29847, -13524},{29736, -13767},{29622, -14010},{29506,
-14252},{29389, -14493},{29269, -14733},{29148, -14972},
        {29024, -15210},{28899, -15447},{28771, -15683},{28642, -15917},{28511, -16151},{28378, -16384},{28243,
-16616},{28106, -16846},{27967, -17075},{27827, -17304},
        {27684, -17531},{27540, -17757},{27394, -17981},{27246, -18205},{27096, -18427},{26944, -18648},{26791,
-18868},{26635, -19087},{26478, -19304},{26320, -19520},
        {26159, -19735},{25997, -19948},{25833, -20160},{25667, -20371},{25499, -20580},{25330, -20788},{25159,
-20994},{24986, -21199},{24812, -21403},{24636, -21605},
        {24459, -21806},{24279, -22006},{24099, -22204},{23916, -22400},{23732, -22595},{23546, -22788},{23359,
-22980},{23170, -23170},{22980, -23359},{22788, -23546},
        {22595, -23732},{22400, -23916},{22204, -24099},{22006, -24279},{21806, -24459},{21605, -24636},{21403,
-24812},{21199, -24986},{20994, -25159},{20788, -25330},
        {20580, -25499},{20371, -25667},{20160, -25833},{19948, -25997},{19735, -26159},{19520, -26320},{19304,
-26478},{19087, -26635},{18868, -26791},{18648, -26944},
        {18427, -27096},{18205, -27246},{17981, -27394},{17757, -27540},{17531, -27684},{17304, -27827},{17075,
-27967},{16846, -28106},{16616, -28243},{16384, -28378},
        {16151, -28511},{15917, -28642},{15683, -28771},{15447, -28899},{15210, -29024},{14972, -29148},{14733,
-29269},{14493, -29389},{14252, -29506},{14010, -29622},
        {13767, -29736},{13524, -29847},{13279, -29957},{13033, -30064},{12787, -30170},{12540, -30274},{12292,
-30375},{12043, -30475},{11793, -30572},{11543, -30668},
        {11291, -30761},{11039, -30853},{10786, -30942},{10533, -31029},{10279, -31114},{10024, -31197},{9768,
-31278},{9512, -31357},{9255, -31434},{8998, -31508},
        {8740, -31581},{8481, -31651},{8222, -31720},{7962, -31786},{7702, -31850},{7441, -31912},{7180, -31972},{6918,
-32029},{6655, -32085},{6393, -32138},
        {6130, -32190},{5866, -32239},{5602, -32286},{5338, -32330},{5073, -32373},{4808, -32413},{4543, -32452},{4277,
-32488},{4011, -32522},{3745, -32553},
        {3479, -32583},{3212, -32610},{2945, -32635},{2678, -32658},{2411, -32679},{2143, -32698},{1876, -32714},{1608,
-32729},{1340, -32741},{1072, -32750},
        {804, -32758},{536, -32764},{268, -32767},{0, -32768},{-268, -32767},{-536, -32764},{-804, -32758},{-1072,
-32750},{-1340, -32741},{-1608, -32729},
        {-1876, -32714},{-2143, -32698},{-2411, -32679},{-2678, -32658},{-2945, -32635},{-3212, -32610},{-3479,
-32583},{-3745, -32553},{-4011, -32522},{-4277, -32488},
        {-4543, -32452},{-4808, -32413},{-5073, -32373},{-5338, -32330},{-5602, -32286},{-5866, -32239},{-6130,
-32190},{-6393, -32138},{-6655, -32085},{-6918, -32029},
        {-7180, -31972},{-7441, -31912},{-7702, -31850},{-7962, -31786},{-8222, -31720},{-8481, -31651},{-8740,
-31581},{-8998, -31508},{-9255, -31434},{-9512, -31357},
        {-9768, -31278},{-10024, -31197},{-10279, -31114},{-10533, -31029},{-10786, -30942},{-11039, -30853},{-11291,
-30761},{-11543, -30668},{-11793, -30572},{-12043, -30475},
        {-12292, -30375},{-12540, -30274},{-12787, -30170},{-13033, -30064},{-13279, -29957},{-13524, -29847},{-13767,
-29736},{-14010, -29622},{-14252, -29506},{-14493, -29389},
        {-14733, -29269},{-14972, -29148},{-15210, -29024},{-15447, -28899},{-15683, -28771},{-15917, -28642},{-16151,
-28511},{-16384, -28378},{-16616, -28243},{-16846, -28106},
        {-17075, -27967},{-17304, -27827},{-17531, -27684},{-17757, -27540},{-17981, -27394},{-18205, -27246},{-18427,
-27096},{-18648, -26944},{-18868, -26791},{-19087, -26635},
        {-19304, -26478},{-19520, -26320},{-19735, -26159},{-19948, -25997},{-20160, -25833},{-20371, -25667},{-20580,
-25499},{-20788, -25330},{-20994, -25159},{-21199, -24986},
        {-21403, -24812},{-21605, -24636},{-21806, -24459},{-22006, -24279},{-22204, -24099},{-22400, -23916},{-22595,
-23732},{-22788, -23546},{-22980, -23359},{-23170, -23170},
        {-23359, -22980},{-23546, -22788},{-23732, -22595},{-23916, -22400},{-24099, -22204},{-24279, -22006},{-24459,
-21806},{-24636, -21605},{-24812, -21403},{-24986, -21199},
        {-25159, -20994},{-25330, -20788},{-25499, -20580},{-25667, -20371},{-25833, -20160},{-25997, -19948},{-26159,
-19735},{-26320, -19520},{-26478, -19304},{-26635, -19087},
        {-26791, -18868},{-26944, -18648},{-27096, -18427},{-27246, -18205},{-27394, -17981},{-27540, -17757},{-27684,
-17531},{-27827, -17304},{-27967, -17075},{-28106, -16846},
        {-28243, -16616},{-28378, -16384},{-28511, -16151},{-28642, -15917},{-28771, -15683},{-28899, -15447},{-29024,
-15210},{-29148, -14972},{-29269, -14733},{-29389, -14493},
        {-29506, -14252},{-29622, -14010},{-29736, -13767},{-29847, -13524},{-29957, -13279},{-30064, -13033},{-30170,
-12787},{-30274, -12540},{-30375, -12292},{-30475, -12043},
        {-30572, -11793},{-30668, -11543},{-30761, -11291},{-30853, -11039},{-30942, -10786},{-31029, -10533},{-31114,
-10279},{-31197, -10024},{-31278, -9768},{-31357, -9512},
        {-31434, -9255},{-31508, -8998},{-31581, -8740},{-31651, -8481},{-31720, -8222},{-31786, -7962},{-31850,
-7702},{-31912, -7441},{-31972, -7180},{-32029, -6918},
        {-32085, -6655},{-32138, -6393},{-32190, -6130},{-32239, -5866},{-32286, -5602},{-32330, -5338},{-32373,
-5073},{-32413, -4808},{-32452, -4543},{-32488, -4277},
        {-32522, -4011},{-32553, -3745},{-32583, -3479},{-32610, -3212},{-32635, -2945},{-32658, -2678},{-32679,
-2411},{-32698, -2143},{-32714, -1876},{-32729, -1608},
        {-32741, -1340},{-32750, -1072},{-32758, -804},{-32764, -536},{-32767, -268}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw768[FFT_768] =
        {{32767, 0},{32767, -134},{32767, -268},{32766, -402},{32764, -536},{32761, -670},{32758, -804},{32755,
-938},{32750, -1072},
        {32746, -1206},{32741, -1340},{32735, -1474},{32729, -1608},{32722, -1742},{32714, -1876},{32706, -2009},{32698,
-2143},{32689, -2277},{32679, -2411},
        {32669, -2544},{32658, -2678},{32647, -2811},{32635, -2945},{32623, -3078},{32610, -3212},{32597, -3345},{32583,
-3479},{32568, -3612},{32553, -3745},
        {32538, -3878},{32522, -4011},{32505, -4144},{32488, -4277},{32470, -4410},{32452, -4543},{32433, -4675},{32413,
-4808},{32393, -4941},{32373, -5073},
        {32352, -5205},{32330, -5338},{32308, -5470},{32286, -5602},{32262, -5734},{32239, -5866},{32214, -5998},{32190,
-6130},{32164, -6261},{32138, -6393},
        {32112, -6524},{32085, -6655},{32058, -6787},{32029, -6918},{32001, -7049},{31972, -7180},{31942, -7310},{31912,
-7441},{31881, -7571},{31850, -7702},
        {31818, -7832},{31786, -7962},{31753, -8092},{31720, -8222},{31686, -8351},{31651, -8481},{31617, -8610},{31581,
-8740},{31545, -8869},{31508, -8998},
        {31471, -9127},{31434, -9255},{31396, -9384},{31357, -9512},{31318, -9640},{31278, -9768},{31238, -9896},{31197,
-10024},{31156, -10151},{31114, -10279},
        {31072, -10406},{31029, -10533},{30986, -10660},{30942, -10786},{30897, -10913},{30853, -11039},{30807,
-11165},{30761, -11291},{30715, -11417},{30668, -11543},
        {30620, -11668},{30572, -11793},{30524, -11918},{30475, -12043},{30425, -12167},{30375, -12292},{30325,
-12416},{30274, -12540},{30222, -12664},{30170, -12787},
        {30118, -12910},{30064, -13033},{30011, -13156},{29957, -13279},{29902, -13401},{29847, -13524},{29792,
-13646},{29736, -13767},{29679, -13889},{29622, -14010},
        {29564, -14131},{29506, -14252},{29448, -14373},{29389, -14493},{29329, -14613},{29269, -14733},{29209,
-14852},{29148, -14972},{29086, -15091},{29024, -15210},
        {28962, -15328},{28899, -15447},{28835, -15565},{28771, -15683},{28707, -15800},{28642, -15917},{28577,
-16035},{28511, -16151},{28445, -16268},{28378, -16384},
        {28311, -16500},{28243, -16616},{28175, -16731},{28106, -16846},{28037, -16961},{27967, -17075},{27897,
-17190},{27827, -17304},{27756, -17417},{27684, -17531},
        {27612, -17644},{27540, -17757},{27467, -17869},{27394, -17981},{27320, -18093},{27246, -18205},{27171,
-18316},{27096, -18427},{27020, -18538},{26944, -18648},
        {26868, -18758},{26791, -18868},{26713, -18978},{26635, -19087},{26557, -19195},{26478, -19304},{26399,
-19412},{26320, -19520},{26239, -19627},{26159, -19735},
        {26078, -19841},{25997, -19948},{25915, -20054},{25833, -20160},{25750, -20265},{25667, -20371},{25583,
-20475},{25499, -20580},{25415, -20684},{25330, -20788},
        {25245, -20891},{25159, -20994},{25073, -21097},{24986, -21199},{24900, -21301},{24812, -21403},{24724,
-21504},{24636, -21605},{24548, -21706},{24459, -21806},
        {24369, -21906},{24279, -22006},{24189, -22105},{24099, -22204},{24008, -22302},{23916, -22400},{23824,
-22498},{23732, -22595},{23640, -22692},{23546, -22788},
        {23453, -22884},{23359, -22980},{23265, -23075},{23170, -23170},{23075, -23265},{22980, -23359},{22884,
-23453},{22788, -23546},{22692, -23640},{22595, -23732},
        {22498, -23824},{22400, -23916},{22302, -24008},{22204, -24099},{22105, -24189},{22006, -24279},{21906,
-24369},{21806, -24459},{21706, -24548},{21605, -24636},
        {21504, -24724},{21403, -24812},{21301, -24900},{21199, -24986},{21097, -25073},{20994, -25159},{20891,
-25245},{20788, -25330},{20684, -25415},{20580, -25499},
        {20475, -25583},{20371, -25667},{20265, -25750},{20160, -25833},{20054, -25915},{19948, -25997},{19841,
-26078},{19735, -26159},{19627, -26239},{19520, -26320},
        {19412, -26399},{19304, -26478},{19195, -26557},{19087, -26635},{18978, -26713},{18868, -26791},{18758,
-26868},{18648, -26944},{18538, -27020},{18427, -27096},
        {18316, -27171},{18205, -27246},{18093, -27320},{17981, -27394},{17869, -27467},{17757, -27540},{17644,
-27612},{17531, -27684},{17417, -27756},{17304, -27827},
        {17190, -27897},{17075, -27967},{16961, -28037},{16846, -28106},{16731, -28175},{16616, -28243},{16500,
-28311},{16384, -28378},{16268, -28445},{16151, -28511},
        {16035, -28577},{15917, -28642},{15800, -28707},{15683, -28771},{15565, -28835},{15447, -28899},{15328,
-28962},{15210, -29024},{15091, -29086},{14972, -29148},
        {14852, -29209},{14733, -29269},{14613, -29329},{14493, -29389},{14373, -29448},{14252, -29506},{14131,
-29564},{14010, -29622},{13889, -29679},{13767, -29736},
        {13646, -29792},{13524, -29847},{13401, -29902},{13279, -29957},{13156, -30011},{13033, -30064},{12910,
-30118},{12787, -30170},{12664, -30222},{12540, -30274},
        {12416, -30325},{12292, -30375},{12167, -30425},{12043, -30475},{11918, -30524},{11793, -30572},{11668,
-30620},{11543, -30668},{11417, -30715},{11291, -30761},
        {11165, -30807},{11039, -30853},{10913, -30897},{10786, -30942},{10660, -30986},{10533, -31029},{10406,
-31072},{10279, -31114},{10151, -31156},{10024, -31197},
        {9896, -31238},{9768, -31278},{9640, -31318},{9512, -31357},{9384, -31396},{9255, -31434},{9127, -31471},{8998,
-31508},{8869, -31545},{8740, -31581},
        {8610, -31617},{8481, -31651},{8351, -31686},{8222, -31720},{8092, -31753},{7962, -31786},{7832, -31818},{7702,
-31850},{7571, -31881},{7441, -31912},
        {7310, -31942},{7180, -31972},{7049, -32001},{6918, -32029},{6787, -32058},{6655, -32085},{6524, -32112},{6393,
-32138},{6261, -32164},{6130, -32190},
        {5998, -32214},{5866, -32239},{5734, -32262},{5602, -32286},{5470, -32308},{5338, -32330},{5205, -32352},{5073,
-32373},{4941, -32393},{4808, -32413},
        {4675, -32433},{4543, -32452},{4410, -32470},{4277, -32488},{4144, -32505},{4011, -32522},{3878, -32538},{3745,
-32553},{3612, -32568},{3479, -32583},
        {3345, -32597},{3212, -32610},{3078, -32623},{2945, -32635},{2811, -32647},{2678, -32658},{2544, -32669},{2411,
-32679},{2277, -32689},{2143, -32698},
        {2009, -32706},{1876, -32714},{1742, -32722},{1608, -32729},{1474, -32735},{1340, -32741},{1206, -32746},{1072,
-32750},{938, -32755},{804, -32758},
        {670, -32761},{536, -32764},{402, -32766},{268, -32767},{134, -32768},{0, -32768},{-134, -32768},{-268,
-32767},{-402, -32766},{-536, -32764},
        {-670, -32761},{-804, -32758},{-938, -32755},{-1072, -32750},{-1206, -32746},{-1340, -32741},{-1474,
-32735},{-1608, -32729},{-1742, -32722},{-1876, -32714},
        {-2009, -32706},{-2143, -32698},{-2277, -32689},{-2411, -32679},{-2544, -32669},{-2678, -32658},{-2811,
-32647},{-2945, -32635},{-3078, -32623},{-3212, -32610},
        {-3345, -32597},{-3479, -32583},{-3612, -32568},{-3745, -32553},{-3878, -32538},{-4011, -32522},{-4144,
-32505},{-4277, -32488},{-4410, -32470},{-4543, -32452},
        {-4675, -32433},{-4808, -32413},{-4941, -32393},{-5073, -32373},{-5205, -32352},{-5338, -32330},{-5470,
-32308},{-5602, -32286},{-5734, -32262},{-5866, -32239},
        {-5998, -32214},{-6130, -32190},{-6261, -32164},{-6393, -32138},{-6524, -32112},{-6655, -32085},{-6787,
-32058},{-6918, -32029},{-7049, -32001},{-7180, -31972},
        {-7310, -31942},{-7441, -31912},{-7571, -31881},{-7702, -31850},{-7832, -31818},{-7962, -31786},{-8092,
-31753},{-8222, -31720},{-8351, -31686},{-8481, -31651},
        {-8610, -31617},{-8740, -31581},{-8869, -31545},{-8998, -31508},{-9127, -31471},{-9255, -31434},{-9384,
-31396},{-9512, -31357},{-9640, -31318},{-9768, -31278},
        {-9896, -31238},{-10024, -31197},{-10151, -31156},{-10279, -31114},{-10406, -31072},{-10533, -31029},{-10660,
-30986},{-10786, -30942},{-10913, -30897},{-11039, -30853},
        {-11165, -30807},{-11291, -30761},{-11417, -30715},{-11543, -30668},{-11668, -30620},{-11793, -30572},{-11918,
-30524},{-12043, -30475},{-12167, -30425},{-12292, -30375},
        {-12416, -30325},{-12540, -30274},{-12664, -30222},{-12787, -30170},{-12910, -30118},{-13033, -30064},{-13156,
-30011},{-13279, -29957},{-13401, -29902},{-13524, -29847},
        {-13646, -29792},{-13767, -29736},{-13889, -29679},{-14010, -29622},{-14131, -29564},{-14252, -29506},{-14373,
-29448},{-14493, -29389},{-14613, -29329},{-14733, -29269},
        {-14852, -29209},{-14972, -29148},{-15091, -29086},{-15210, -29024},{-15328, -28962},{-15447, -28899},{-15565,
-28835},{-15683, -28771},{-15800, -28707},{-15917, -28642},
        {-16035, -28577},{-16151, -28511},{-16268, -28445},{-16384, -28378},{-16500, -28311},{-16616, -28243},{-16731,
-28175},{-16846, -28106},{-16961, -28037},{-17075, -27967},
        {-17190, -27897},{-17304, -27827},{-17417, -27756},{-17531, -27684},{-17644, -27612},{-17757, -27540},{-17869,
-27467},{-17981, -27394},{-18093, -27320},{-18205, -27246},
        {-18316, -27171},{-18427, -27096},{-18538, -27020},{-18648, -26944},{-18758, -26868},{-18868, -26791},{-18978,
-26713},{-19087, -26635},{-19195, -26557},{-19304, -26478},
        {-19412, -26399},{-19520, -26320},{-19627, -26239},{-19735, -26159},{-19841, -26078},{-19948, -25997},{-20054,
-25915},{-20160, -25833},{-20265, -25750},{-20371, -25667},
        {-20475, -25583},{-20580, -25499},{-20684, -25415},{-20788, -25330},{-20891, -25245},{-20994, -25159},{-21097,
-25073},{-21199, -24986},{-21301, -24900},{-21403, -24812},
        {-21504, -24724},{-21605, -24636},{-21706, -24548},{-21806, -24459},{-21906, -24369},{-22006, -24279},{-22105,
-24189},{-22204, -24099},{-22302, -24008},{-22400, -23916},
        {-22498, -23824},{-22595, -23732},{-22692, -23640},{-22788, -23546},{-22884, -23453},{-22980, -23359},{-23075,
-23265},{-23170, -23170},{-23265, -23075},{-23359, -22980},
        {-23453, -22884},{-23546, -22788},{-23640, -22692},{-23732, -22595},{-23824, -22498},{-23916, -22400},{-24008,
-22302},{-24099, -22204},{-24189, -22105},{-24279, -22006},
        {-24369, -21906},{-24459, -21806},{-24548, -21706},{-24636, -21605},{-24724, -21504},{-24812, -21403},{-24900,
-21301},{-24986, -21199},{-25073, -21097},{-25159, -20994},
        {-25245, -20891},{-25330, -20788},{-25415, -20684},{-25499, -20580},{-25583, -20475},{-25667, -20371},{-25750,
-20265},{-25833, -20160},{-25915, -20054},{-25997, -19948},
        {-26078, -19841},{-26159, -19735},{-26239, -19627},{-26320, -19520},{-26399, -19412},{-26478, -19304},{-26557,
-19195},{-26635, -19087},{-26713, -18978},{-26791, -18868},
        {-26868, -18758},{-26944, -18648},{-27020, -18538},{-27096, -18427},{-27171, -18316},{-27246, -18205},{-27320,
-18093},{-27394, -17981},{-27467, -17869},{-27540, -17757},
        {-27612, -17644},{-27684, -17531},{-27756, -17417},{-27827, -17304},{-27897, -17190},{-27967, -17075},{-28037,
-16961},{-28106, -16846},{-28175, -16731},{-28243, -16616},
        {-28311, -16500},{-28378, -16384},{-28445, -16268},{-28511, -16151},{-28577, -16035},{-28642, -15917},{-28707,
-15800},{-28771, -15683},{-28835, -15565},{-28899, -15447},
        {-28962, -15328},{-29024, -15210},{-29086, -15091},{-29148, -14972},{-29209, -14852},{-29269, -14733},{-29329,
-14613},{-29389, -14493},{-29448, -14373},{-29506, -14252},
        {-29564, -14131},{-29622, -14010},{-29679, -13889},{-29736, -13767},{-29792, -13646},{-29847, -13524},{-29902,
-13401},{-29957, -13279},{-30011, -13156},{-30064, -13033},
        {-30118, -12910},{-30170, -12787},{-30222, -12664},{-30274, -12540},{-30325, -12416},{-30375, -12292},{-30425,
-12167},{-30475, -12043},{-30524, -11918},{-30572, -11793},
        {-30620, -11668},{-30668, -11543},{-30715, -11417},{-30761, -11291},{-30807, -11165},{-30853, -11039},{-30897,
-10913},{-30942, -10786},{-30986, -10660},{-31029, -10533},
        {-31072, -10406},{-31114, -10279},{-31156, -10151},{-31197, -10024},{-31238, -9896},{-31278, -9768},{-31318,
-9640},{-31357, -9512},{-31396, -9384},{-31434, -9255},
        {-31471, -9127},{-31508, -8998},{-31545, -8869},{-31581, -8740},{-31617, -8610},{-31651, -8481},{-31686,
-8351},{-31720, -8222},{-31753, -8092},{-31786, -7962},
        {-31818, -7832},{-31850, -7702},{-31881, -7571},{-31912, -7441},{-31942, -7310},{-31972, -7180},{-32001,
-7049},{-32029, -6918},{-32058, -6787},{-32085, -6655},
        {-32112, -6524},{-32138, -6393},{-32164, -6261},{-32190, -6130},{-32214, -5998},{-32239, -5866},{-32262,
-5734},{-32286, -5602},{-32308, -5470},{-32330, -5338},
        {-32352, -5205},{-32373, -5073},{-32393, -4941},{-32413, -4808},{-32433, -4675},{-32452, -4543},{-32470,
-4410},{-32488, -4277},{-32505, -4144},{-32522, -4011},
        {-32538, -3878},{-32553, -3745},{-32568, -3612},{-32583, -3479},{-32597, -3345},{-32610, -3212},{-32623,
-3078},{-32635, -2945},{-32647, -2811},{-32658, -2678},
        {-32669, -2544},{-32679, -2411},{-32689, -2277},{-32698, -2143},{-32706, -2009},{-32714, -1876},{-32722,
-1742},{-32729, -1608},{-32735, -1474},{-32741, -1340},
        {-32746, -1206},{-32750, -1072},{-32755, -938},{-32758, -804},{-32761, -670},{-32764, -536},{-32766,
-402},{-32767, -268},{-32768, -134}};

    // LUTs for 896pt FFT/IFFT
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw448[FFT_448] =
        {{32767, 0},{32767, -230},{32765, -460},{32761, -689},{32755, -919},{32748, -1149},{32739, -1378},{32729,
-1608},{32716, -1837},
        {32703, -2067},{32687, -2296},{32671, -2525},{32652, -2754},{32632, -2983},{32610, -3212},{32587, -3440},{32562,
-3669},{32535, -3897},{32507, -4125},
        {32478, -4353},{32446, -4581},{32413, -4808},{32379, -5035},{32343, -5262},{32305, -5489},{32266, -5715},{32225,
-5941},{32182, -6167},{32138, -6393},
        {32093, -6618},{32046, -6843},{31997, -7067},{31946, -7292},{31895, -7515},{31841, -7739},{31786, -7962},{31729,
-8185},{31671, -8407},{31611, -8629},
        {31550, -8850},{31487, -9071},{31423, -9292},{31357, -9512},{31290, -9732},{31221, -9951},{31150,
-10170},{31078, -10388},{31004, -10605},{30929, -10823},
        {30853, -11039},{30774, -11255},{30695, -11471},{30613, -11686},{30531, -11900},{30447, -12114},{30361,
-12327},{30274, -12540},{30185, -12752},{30095, -12963},
        {30003, -13174},{29910, -13384},{29815, -13593},{29719, -13802},{29622, -14010},{29523, -14218},{29423,
-14424},{29321, -14630},{29217, -14835},{29113, -15040},
        {29006, -15244},{28899, -15447},{28790, -15649},{28679, -15851},{28567, -16051},{28454, -16251},{28340,
-16450},{28223, -16649},{28106, -16846},{27987, -17043},
        {27867, -17239},{27745, -17434},{27623, -17628},{27498, -17821},{27373, -18013},{27246, -18205},{27117,
-18396},{26988, -18585},{26857, -18774},{26724, -18962},
        {26591, -19149},{26456, -19335},{26320, -19520},{26182, -19704},{26043, -19887},{25903, -20069},{25762,
-20250},{25619, -20431},{25475, -20610},{25330, -20788},
        {25184, -20965},{25036, -21141},{24887, -21316},{24737, -21490},{24586, -21663},{24433, -21835},{24279,
-22006},{24125, -22175},{23968, -22344},{23811, -22512},
        {23653, -22678},{23493, -22843},{23332, -23007},{23170, -23170},{23007, -23332},{22843, -23493},{22678,
-23653},{22512, -23811},{22344, -23968},{22175, -24125},
        {22006, -24279},{21835, -24433},{21663, -24586},{21490, -24737},{21316, -24887},{21141, -25036},{20965,
-25184},{20788, -25330},{20610, -25475},{20431, -25619},
        {20250, -25762},{20069, -25903},{19887, -26043},{19704, -26182},{19520, -26320},{19335, -26456},{19149,
-26591},{18962, -26724},{18774, -26857},{18585, -26988},
        {18396, -27117},{18205, -27246},{18013, -27373},{17821, -27498},{17628, -27623},{17434, -27745},{17239,
-27867},{17043, -27987},{16846, -28106},{16649, -28223},
        {16450, -28340},{16251, -28454},{16051, -28567},{15851, -28679},{15649, -28790},{15447, -28899},{15244,
-29006},{15040, -29113},{14835, -29217},{14630, -29321},
        {14424, -29423},{14218, -29523},{14010, -29622},{13802, -29719},{13593, -29815},{13384, -29910},{13174,
-30003},{12963, -30095},{12752, -30185},{12540, -30274},
        {12327, -30361},{12114, -30447},{11900, -30531},{11686, -30613},{11471, -30695},{11255, -30774},{11039,
-30853},{10823, -30929},{10605, -31004},{10388, -31078},
        {10170, -31150},{9951, -31221},{9732, -31290},{9512, -31357},{9292, -31423},{9071, -31487},{8850, -31550},{8629,
-31611},{8407, -31671},{8185, -31729},
        {7962, -31786},{7739, -31841},{7515, -31895},{7292, -31946},{7067, -31997},{6843, -32046},{6618, -32093},{6393,
-32138},{6167, -32182},{5941, -32225},
        {5715, -32266},{5489, -32305},{5262, -32343},{5035, -32379},{4808, -32413},{4581, -32446},{4353, -32478},{4125,
-32507},{3897, -32535},{3669, -32562},
        {3440, -32587},{3212, -32610},{2983, -32632},{2754, -32652},{2525, -32671},{2296, -32687},{2067, -32703},{1837,
-32716},{1608, -32729},{1378, -32739},
        {1149, -32748},{919, -32755},{689, -32761},{460, -32765},{230, -32767},{0, -32768},{-230, -32767},{-460,
-32765},{-689, -32761},{-919, -32755},
        {-1149, -32748},{-1378, -32739},{-1608, -32729},{-1837, -32716},{-2067, -32703},{-2296, -32687},{-2525,
-32671},{-2754, -32652},{-2983, -32632},{-3212, -32610},
        {-3440, -32587},{-3669, -32562},{-3897, -32535},{-4125, -32507},{-4353, -32478},{-4581, -32446},{-4808,
-32413},{-5035, -32379},{-5262, -32343},{-5489, -32305},
        {-5715, -32266},{-5941, -32225},{-6167, -32182},{-6393, -32138},{-6618, -32093},{-6843, -32046},{-7067,
-31997},{-7292, -31946},{-7515, -31895},{-7739, -31841},
        {-7962, -31786},{-8185, -31729},{-8407, -31671},{-8629, -31611},{-8850, -31550},{-9071, -31487},{-9292,
-31423},{-9512, -31357},{-9732, -31290},{-9951, -31221},
        {-10170, -31150},{-10388, -31078},{-10605, -31004},{-10823, -30929},{-11039, -30853},{-11255, -30774},{-11471,
-30695},{-11686, -30613},{-11900, -30531},{-12114, -30447},
        {-12327, -30361},{-12540, -30274},{-12752, -30185},{-12963, -30095},{-13174, -30003},{-13384, -29910},{-13593,
-29815},{-13802, -29719},{-14010, -29622},{-14218, -29523},
        {-14424, -29423},{-14630, -29321},{-14835, -29217},{-15040, -29113},{-15244, -29006},{-15447, -28899},{-15649,
-28790},{-15851, -28679},{-16051, -28567},{-16251, -28454},
        {-16450, -28340},{-16649, -28223},{-16846, -28106},{-17043, -27987},{-17239, -27867},{-17434, -27745},{-17628,
-27623},{-17821, -27498},{-18013, -27373},{-18205, -27246},
        {-18396, -27117},{-18585, -26988},{-18774, -26857},{-18962, -26724},{-19149, -26591},{-19335, -26456},{-19520,
-26320},{-19704, -26182},{-19887, -26043},{-20069, -25903},
        {-20250, -25762},{-20431, -25619},{-20610, -25475},{-20788, -25330},{-20965, -25184},{-21141, -25036},{-21316,
-24887},{-21490, -24737},{-21663, -24586},{-21835, -24433},
        {-22006, -24279},{-22175, -24125},{-22344, -23968},{-22512, -23811},{-22678, -23653},{-22843, -23493},{-23007,
-23332},{-23170, -23170},{-23332, -23007},{-23493, -22843},
        {-23653, -22678},{-23811, -22512},{-23968, -22344},{-24125, -22175},{-24279, -22006},{-24433, -21835},{-24586,
-21663},{-24737, -21490},{-24887, -21316},{-25036, -21141},
        {-25184, -20965},{-25330, -20788},{-25475, -20610},{-25619, -20431},{-25762, -20250},{-25903, -20069},{-26043,
-19887},{-26182, -19704},{-26320, -19520},{-26456, -19335},
        {-26591, -19149},{-26724, -18962},{-26857, -18774},{-26988, -18585},{-27117, -18396},{-27246, -18205},{-27373,
-18013},{-27498, -17821},{-27623, -17628},{-27745, -17434},
        {-27867, -17239},{-27987, -17043},{-28106, -16846},{-28223, -16649},{-28340, -16450},{-28454, -16251},{-28567,
-16051},{-28679, -15851},{-28790, -15649},{-28899, -15447},
        {-29006, -15244},{-29113, -15040},{-29217, -14835},{-29321, -14630},{-29423, -14424},{-29523, -14218},{-29622,
-14010},{-29719, -13802},{-29815, -13593},{-29910, -13384},
        {-30003, -13174},{-30095, -12963},{-30185, -12752},{-30274, -12540},{-30361, -12327},{-30447, -12114},{-30531,
-11900},{-30613, -11686},{-30695, -11471},{-30774, -11255},
        {-30853, -11039},{-30929, -10823},{-31004, -10605},{-31078, -10388},{-31150, -10170},{-31221, -9951},{-31290,
-9732},{-31357, -9512},{-31423, -9292},{-31487, -9071},
        {-31550, -8850},{-31611, -8629},{-31671, -8407},{-31729, -8185},{-31786, -7962},{-31841, -7739},{-31895,
-7515},{-31946, -7292},{-31997, -7067},{-32046, -6843},
        {-32093, -6618},{-32138, -6393},{-32182, -6167},{-32225, -5941},{-32266, -5715},{-32305, -5489},{-32343,
-5262},{-32379, -5035},{-32413, -4808},{-32446, -4581},
        {-32478, -4353},{-32507, -4125},{-32535, -3897},{-32562, -3669},{-32587, -3440},{-32610, -3212},{-32632,
-2983},{-32652, -2754},{-32671, -2525},{-32687, -2296},
        {-32703, -2067},{-32716, -1837},{-32729, -1608},{-32739, -1378},{-32748, -1149},{-32755, -919},{-32761,
-689},{-32765, -460},{-32767, -230}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw224[FFT_224] = {{32767, 0},{32765, -460},{32755, -919},{32739,
-1378},{32716,
-1837},{32687, -2296},{32652, -2754},{32610, -3212},{32562, -3669},
        {32507, -4125},{32446, -4581},{32379, -5035},{32305, -5489},{32225, -5941},{32138, -6393},{32046, -6843},{31946,
-7292},{31841, -7739},{31729, -8185},
        {31611, -8629},{31487, -9071},{31357, -9512},{31221, -9951},{31078, -10388},{30929, -10823},{30774,
-11255},{30613, -11686},{30447, -12114},{30274, -12540},
        {30095, -12963},{29910, -13384},{29719, -13802},{29523, -14218},{29321, -14630},{29113, -15040},{28899,
-15447},{28679, -15851},{28454, -16251},{28223, -16649},
        {27987, -17043},{27745, -17434},{27498, -17821},{27246, -18205},{26988, -18585},{26724, -18962},{26456,
-19335},{26182, -19704},{25903, -20069},{25619, -20431},
        {25330, -20788},{25036, -21141},{24737, -21490},{24433, -21835},{24125, -22175},{23811, -22512},{23493,
-22843},{23170, -23170},{22843, -23493},{22512, -23811},
        {22175, -24125},{21835, -24433},{21490, -24737},{21141, -25036},{20788, -25330},{20431, -25619},{20069,
-25903},{19704, -26182},{19335, -26456},{18962, -26724},
        {18585, -26988},{18205, -27246},{17821, -27498},{17434, -27745},{17043, -27987},{16649, -28223},{16251,
-28454},{15851, -28679},{15447, -28899},{15040, -29113},
        {14630, -29321},{14218, -29523},{13802, -29719},{13384, -29910},{12963, -30095},{12540, -30274},{12114,
-30447},{11686, -30613},{11255, -30774},{10823, -30929},
        {10388, -31078},{9951, -31221},{9512, -31357},{9071, -31487},{8629, -31611},{8185, -31729},{7739, -31841},{7292,
-31946},{6843, -32046},{6393, -32138},
        {5941, -32225},{5489, -32305},{5035, -32379},{4581, -32446},{4125, -32507},{3669, -32562},{3212, -32610},{2754,
-32652},{2296, -32687},{1837, -32716},
        {1378, -32739},{919, -32755},{460, -32765},{0, -32768},{-460, -32765},{-919, -32755},{-1378, -32739},{-1837,
-32716},{-2296, -32687},{-2754, -32652},
        {-3212, -32610},{-3669, -32562},{-4125, -32507},{-4581, -32446},{-5035, -32379},{-5489, -32305},{-5941,
-32225},{-6393, -32138},{-6843, -32046},{-7292, -31946},
        {-7739, -31841},{-8185, -31729},{-8629, -31611},{-9071, -31487},{-9512, -31357},{-9951, -31221},{-10388,
-31078},{-10823, -30929},{-11255, -30774},{-11686, -30613},
        {-12114, -30447},{-12540, -30274},{-12963, -30095},{-13384, -29910},{-13802, -29719},{-14218, -29523},{-14630,
-29321},{-15040, -29113},{-15447, -28899},{-15851, -28679},
        {-16251, -28454},{-16649, -28223},{-17043, -27987},{-17434, -27745},{-17821, -27498},{-18205, -27246},{-18585,
-26988},{-18962, -26724},{-19335, -26456},{-19704, -26182},
        {-20069, -25903},{-20431, -25619},{-20788, -25330},{-21141, -25036},{-21490, -24737},{-21835, -24433},{-22175,
-24125},{-22512, -23811},{-22843, -23493},{-23170, -23170},
        {-23493, -22843},{-23811, -22512},{-24125, -22175},{-24433, -21835},{-24737, -21490},{-25036, -21141},{-25330,
-20788},{-25619, -20431},{-25903, -20069},{-26182, -19704},
        {-26456, -19335},{-26724, -18962},{-26988, -18585},{-27246, -18205},{-27498, -17821},{-27745, -17434},{-27987,
-17043},{-28223, -16649},{-28454, -16251},{-28679, -15851},
        {-28899, -15447},{-29113, -15040},{-29321, -14630},{-29523, -14218},{-29719, -13802},{-29910, -13384},{-30095,
-12963},{-30274, -12540},{-30447, -12114},{-30613, -11686},
        {-30774, -11255},{-30929, -10823},{-31078, -10388},{-31221, -9951},{-31357, -9512},{-31487, -9071},{-31611,
-8629},{-31729, -8185},{-31841, -7739},{-31946, -7292},
        {-32046, -6843},{-32138, -6393},{-32225, -5941},{-32305, -5489},{-32379, -5035},{-32446, -4581},{-32507,
-4125},{-32562, -3669},{-32610, -3212},{-32652, -2754},
        {-32687, -2296},{-32716, -1837},{-32739, -1378},{-32755, -919},{-32765, -460}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw112[FFT_112] = {{32767, 0},{32755, -919},{32716, -1837},{32652,
-2754},{32562,
-3669},{32446, -4581},{32305, -5489},{32138, -6393},{31946, -7292},
        {31729, -8185},{31487, -9071},{31221, -9951},{30929, -10823},{30613, -11686},{30274, -12540},{29910,
-13384},{29523, -14218},{29113, -15040},{28679, -15851},
        {28223, -16649},{27745, -17434},{27246, -18205},{26724, -18962},{26182, -19704},{25619, -20431},{25036,
-21141},{24433, -21835},{23811, -22512},{23170, -23170},
        {22512, -23811},{21835, -24433},{21141, -25036},{20431, -25619},{19704, -26182},{18962, -26724},{18205,
-27246},{17434, -27745},{16649, -28223},{15851, -28679},
        {15040, -29113},{14218, -29523},{13384, -29910},{12540, -30274},{11686, -30613},{10823, -30929},{9951,
-31221},{9071, -31487},{8185, -31729},{7292, -31946},
        {6393, -32138},{5489, -32305},{4581, -32446},{3669, -32562},{2754, -32652},{1837, -32716},{919, -32755},{0,
-32768},{-919, -32755},{-1837, -32716},
        {-2754, -32652},{-3669, -32562},{-4581, -32446},{-5489, -32305},{-6393, -32138},{-7292, -31946},{-8185,
-31729},{-9071, -31487},{-9951, -31221},{-10823, -30929},
        {-11686, -30613},{-12540, -30274},{-13384, -29910},{-14218, -29523},{-15040, -29113},{-15851, -28679},{-16649,
-28223},{-17434, -27745},{-18205, -27246},{-18962, -26724},
        {-19704, -26182},{-20431, -25619},{-21141, -25036},{-21835, -24433},{-22512, -23811},{-23170, -23170},{-23811,
-22512},{-24433, -21835},{-25036, -21141},{-25619, -20431},
        {-26182, -19704},{-26724, -18962},{-27246, -18205},{-27745, -17434},{-28223, -16649},{-28679, -15851},{-29113,
-15040},{-29523, -14218},{-29910, -13384},{-30274, -12540},
        {-30613, -11686},{-30929, -10823},{-31221, -9951},{-31487, -9071},{-31729, -8185},{-31946, -7292},{-32138,
-6393},{-32305, -5489},{-32446, -4581},{-32562, -3669},
        {-32652, -2754},{-32716, -1837},{-32755, -919}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw28[FFT_28] = {{32767, 0},{32562, -3669},{31946, -7292},{30929,
-10823},{29523,
-14218},{27745, -17434},{25619, -20431},{23170, -23170},{20431, -25619},
        {17434, -27745},{14218, -29523},{10823, -30929},{7292, -31946},{3669, -32562},{0, -32768},{-3669,
-32562},{-7292, -31946},{-10823, -30929},{-14218, -29523},
        {-17434, -27745},{-20431, -25619},{-23170, -23170},{-25619, -20431},{-27745, -17434},{-29523, -14218},{-30929,
-10823},{-31946, -7292},{-32562, -3669}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw56[FFT_56] = {{32767, 0},{32716, -1837},{32562, -3669},{32305,
-5489},{31946,
-7292},{31487, -9071},{30929, -10823},{30274, -12540},{29523, -14218},
        {28679, -15851},{27745, -17434},{26724, -18962},{25619, -20431},{24433, -21835},{23170, -23170},{21835,
-24433},{20431, -25619},{18962, -26724},{17434, -27745},
        {15851, -28679},{14218, -29523},{12540, -30274},{10823, -30929},{9071, -31487},{7292, -31946},{5489,
-32305},{3669, -32562},{1837, -32716},{0, -32768},
        {-1837, -32716},{-3669, -32562},{-5489, -32305},{-7292, -31946},{-9071, -31487},{-10823, -30929},{-12540,
-30274},{-14218, -29523},{-15851, -28679},{-17434, -27745},
        {-18962, -26724},{-20431, -25619},{-21835, -24433},{-23170, -23170},{-24433, -21835},{-25619, -20431},{-26724,
-18962},{-27745, -17434},{-28679, -15851},{-29523, -14218},
        {-30274, -12540},{-30929, -10823},{-31487, -9071},{-31946, -7292},{-32305, -5489},{-32562, -3669},{-32716,
-1837}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw14[FFT_14] = {{32767, 0},{31946, -7292},{29523, -14218},{25619,
-20431},{20431,
-25619},{14218, -29523},{7292, -31946},{0, -32768},{-7292, -31946},
        {-14218, -29523},{-20431, -25619},{-25619, -20431},{-29523, -14218},{-31946, -7292}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw14o2[FFT_14] = {{32767, 0},{29523, -14218},{20431, -25619},{7292,
-31946},{-7292,
-31946},{-20431, -25619},{-29523, -14218},{-32768, 0},{-29523, 14218},
        {-20431, 25619},{-7292, 31946},{7292, 31946},{20431, 25619},{29523, 14218}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw14o4[FFT_14] = {{32767, 0},{20431, -25619},{-7292, -31946},{-29523,
-14218},{-29523,
14218},{-7292, 31946},{20431, 25619},{32767, 0},{20431, -25619},
        {-7292, -31946},{-29523, -14218},{-29523, 14218},{-7292, 31946},{20431, 25619}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw14o6[FFT_14] = {{32767, 0},{7292, -31946},{-29523, -14218},{-20431,
25619},{20431,
25619},{29523, -14218},{-7292, -31946},{-32768, 0},{-7292, 31946},
        {29523, 14218},{20431, -25619},{-20431, -25619},{-29523, 14218},{7292, 31946}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw14o8[FFT_14] = {{32767, 0},{-7292, -31946},{-29523, 14218},{20431,
25619},{20431,
-25619},{-29523, -14218},{-7292, 31946},{32767, 0},{-7292, -31946},
        {-29523, 14218},{20431, 25619},{20431, -25619},{-29523, -14218},{-7292, 31946}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw14o10[FFT_14] = {{32767, 0},{-20431, -25619},{-7292, 31946},{29523,
-14218},{-29523,
-14218},{7292, 31946},{20431, -25619},{-32768, 0},{20431, 25619},
        {7292, -31946},{-29523, 14218},{29523, 14218},{-7292, -31946},{-20431, 25619}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw14o12[FFT_14] = {{32767, 0},{-29523, -14218},{20431, 25619},{-7292,
-31946},{-7292,
31946},{20431, -25619},{-29523, 14218},{32767, 0},{-29523, -14218},
        {20431, 25619},{-7292, -31946},{-7292, 31946},{20431, -25619},{-29523, 14218}};

    // LUT for 3072pt FFT/IFFT
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw1536[FFT_1536] = {
        {32767, 0},{32767, -67},{32767, -134},{32767, -201},{32767, -268},{32766, -335},{32766, -402},{32765,
-469},{32764, -536},
        {32762, -603},{32761, -670},{32760, -737},{32758, -804},{32756, -871},{32755, -938},{32753, -1005},{32750,
-1072},{32748, -1139},{32746, -1206},
        {32743, -1273},{32741, -1340},{32738, -1407},{32735, -1474},{32732, -1541},{32729, -1608},{32725, -1675},{32722,
-1742},{32718, -1809},{32714, -1876},
        {32710, -1942},{32706, -2009},{32702, -2076},{32698, -2143},{32693, -2210},{32689, -2277},{32684, -2344},{32679,
-2411},{32674, -2477},{32669, -2544},
        {32664, -2611},{32658, -2678},{32653, -2745},{32647, -2811},{32641, -2878},{32635, -2945},{32629, -3012},{32623,
-3078},{32617, -3145},{32610, -3212},
        {32604, -3279},{32597, -3345},{32590, -3412},{32583, -3479},{32576, -3545},{32568, -3612},{32561, -3678},{32553,
-3745},{32546, -3812},{32538, -3878},
        {32530, -3945},{32522, -4011},{32513, -4078},{32505, -4144},{32496, -4211},{32488, -4277},{32479, -4344},{32470,
-4410},{32461, -4476},{32452, -4543},
        {32442, -4609},{32433, -4675},{32423, -4742},{32413, -4808},{32403, -4874},{32393, -4941},{32383, -5007},{32373,
-5073},{32362, -5139},{32352, -5205},
        {32341, -5272},{32330, -5338},{32319, -5404},{32308, -5470},{32297, -5536},{32286, -5602},{32274, -5668},{32262,
-5734},{32251, -5800},{32239, -5866},
        {32227, -5932},{32214, -5998},{32202, -6064},{32190, -6130},{32177, -6195},{32164, -6261},{32151, -6327},{32138,
-6393},{32125, -6458},{32112, -6524},
        {32099, -6590},{32085, -6655},{32071, -6721},{32058, -6787},{32044, -6852},{32029, -6918},{32015, -6983},{32001,
-7049},{31986, -7114},{31972, -7180},
        {31957, -7245},{31942, -7310},{31927, -7376},{31912, -7441},{31897, -7506},{31881, -7571},{31866, -7637},{31850,
-7702},{31834, -7767},{31818, -7832},
        {31802, -7897},{31786, -7962},{31770, -8027},{31753, -8092},{31737, -8157},{31720, -8222},{31703, -8287},{31686,
-8351},{31669, -8416},{31651, -8481},
        {31634, -8546},{31617, -8610},{31599, -8675},{31581, -8740},{31563, -8804},{31545, -8869},{31527, -8933},{31508,
-8998},{31490, -9062},{31471, -9127},
        {31453, -9191},{31434, -9255},{31415, -9319},{31396, -9384},{31376, -9448},{31357, -9512},{31338, -9576},{31318,
-9640},{31298, -9704},{31278, -9768},
        {31258, -9832},{31238, -9896},{31218, -9960},{31197, -10024},{31177, -10088},{31156, -10151},{31135,
-10215},{31114, -10279},{31093, -10342},{31072, -10406},
        {31050, -10469},{31029, -10533},{31007, -10596},{30986, -10660},{30964, -10723},{30942, -10786},{30920,
-10850},{30897, -10913},{30875, -10976},{30853, -11039},
        {30830, -11102},{30807, -11165},{30784, -11228},{30761, -11291},{30738, -11354},{30715, -11417},{30691,
-11480},{30668, -11543},{30644, -11605},{30620, -11668},
        {30596, -11730},{30572, -11793},{30548, -11856},{30524, -11918},{30499, -11980},{30475, -12043},{30450,
-12105},{30425, -12167},{30400, -12230},{30375, -12292},
        {30350, -12354},{30325, -12416},{30299, -12478},{30274, -12540},{30248, -12602},{30222, -12664},{30196,
-12725},{30170, -12787},{30144, -12849},{30118, -12910},
        {30091, -12972},{30064, -13033},{30038, -13095},{30011, -13156},{29984, -13218},{29957, -13279},{29930,
-13340},{29902, -13401},{29875, -13463},{29847, -13524},
        {29819, -13585},{29792, -13646},{29764, -13706},{29736, -13767},{29707, -13828},{29679, -13889},{29651,
-13950},{29622, -14010},{29593, -14071},{29564, -14131},
        {29535, -14192},{29506, -14252},{29477, -14312},{29448, -14373},{29418, -14433},{29389, -14493},{29359,
-14553},{29329, -14613},{29299, -14673},{29269, -14733},
        {29239, -14793},{29209, -14852},{29178, -14912},{29148, -14972},{29117, -15031},{29086, -15091},{29055,
-15150},{29024, -15210},{28993, -15269},{28962, -15328},
        {28930, -15388},{28899, -15447},{28867, -15506},{28835, -15565},{28803, -15624},{28771, -15683},{28739,
-15741},{28707, -15800},{28675, -15859},{28642, -15917},
        {28610, -15976},{28577, -16035},{28544, -16093},{28511, -16151},{28478, -16210},{28445, -16268},{28411,
-16326},{28378, -16384},{28344, -16442},{28311, -16500},
        {28277, -16558},{28243, -16616},{28209, -16673},{28175, -16731},{28140, -16789},{28106, -16846},{28072,
-16904},{28037, -16961},{28002, -17018},{27967, -17075},
        {27932, -17133},{27897, -17190},{27862, -17247},{27827, -17304},{27791, -17361},{27756, -17417},{27720,
-17474},{27684, -17531},{27648, -17587},{27612, -17644},
        {27576, -17700},{27540, -17757},{27503, -17813},{27467, -17869},{27430, -17925},{27394, -17981},{27357,
-18037},{27320, -18093},{27283, -18149},{27246, -18205},
        {27208, -18261},{27171, -18316},{27133, -18372},{27096, -18427},{27058, -18483},{27020, -18538},{26982,
-18593},{26944, -18648},{26906, -18703},{26868, -18758},
        {26829, -18813},{26791, -18868},{26752, -18923},{26713, -18978},{26674, -19032},{26635, -19087},{26596,
-19141},{26557, -19195},{26518, -19250},{26478, -19304},
        {26439, -19358},{26399, -19412},{26359, -19466},{26320, -19520},{26280, -19574},{26239, -19627},{26199,
-19681},{26159, -19735},{26119, -19788},{26078, -19841},
        {26037, -19895},{25997, -19948},{25956, -20001},{25915, -20054},{25874, -20107},{25833, -20160},{25791,
-20213},{25750, -20265},{25708, -20318},{25667, -20371},
        {25625, -20423},{25583, -20475},{25541, -20528},{25499, -20580},{25457, -20632},{25415, -20684},{25372,
-20736},{25330, -20788},{25287, -20840},{25245, -20891},
        {25202, -20943},{25159, -20994},{25116, -21046},{25073, -21097},{25030, -21148},{24986, -21199},{24943,
-21251},{24900, -21301},{24856, -21352},{24812, -21403},
        {24768, -21454},{24724, -21504},{24680, -21555},{24636, -21605},{24592, -21656},{24548, -21706},{24503,
-21756},{24459, -21806},{24414, -21856},{24369, -21906},
        {24324, -21956},{24279, -22006},{24234, -22055},{24189, -22105},{24144, -22154},{24099, -22204},{24053,
-22253},{24008, -22302},{23962, -22351},{23916, -22400},
        {23870, -22449},{23824, -22498},{23778, -22546},{23732, -22595},{23686, -22643},{23640, -22692},{23593,
-22740},{23546, -22788},{23500, -22836},{23453, -22884},
        {23406, -22932},{23359, -22980},{23312, -23028},{23265, -23075},{23218, -23123},{23170, -23170},{23123,
-23218},{23075, -23265},{23028, -23312},{22980, -23359},
        {22932, -23406},{22884, -23453},{22836, -23500},{22788, -23546},{22740, -23593},{22692, -23640},{22643,
-23686},{22595, -23732},{22546, -23778},{22498, -23824},
        {22449, -23870},{22400, -23916},{22351, -23962},{22302, -24008},{22253, -24053},{22204, -24099},{22154,
-24144},{22105, -24189},{22055, -24234},{22006, -24279},
        {21956, -24324},{21906, -24369},{21856, -24414},{21806, -24459},{21756, -24503},{21706, -24548},{21656,
-24592},{21605, -24636},{21555, -24680},{21504, -24724},
        {21454, -24768},{21403, -24812},{21352, -24856},{21301, -24900},{21251, -24943},{21199, -24986},{21148,
-25030},{21097, -25073},{21046, -25116},{20994, -25159},
        {20943, -25202},{20891, -25245},{20840, -25287},{20788, -25330},{20736, -25372},{20684, -25415},{20632,
-25457},{20580, -25499},{20528, -25541},{20475, -25583},
        {20423, -25625},{20371, -25667},{20318, -25708},{20265, -25750},{20213, -25791},{20160, -25833},{20107,
-25874},{20054, -25915},{20001, -25956},{19948, -25997},
        {19895, -26037},{19841, -26078},{19788, -26119},{19735, -26159},{19681, -26199},{19627, -26239},{19574,
-26280},{19520, -26320},{19466, -26359},{19412, -26399},
        {19358, -26439},{19304, -26478},{19250, -26518},{19195, -26557},{19141, -26596},{19087, -26635},{19032,
-26674},{18978, -26713},{18923, -26752},{18868, -26791},
        {18813, -26829},{18758, -26868},{18703, -26906},{18648, -26944},{18593, -26982},{18538, -27020},{18483,
-27058},{18427, -27096},{18372, -27133},{18316, -27171},
        {18261, -27208},{18205, -27246},{18149, -27283},{18093, -27320},{18037, -27357},{17981, -27394},{17925,
-27430},{17869, -27467},{17813, -27503},{17757, -27540},
        {17700, -27576},{17644, -27612},{17587, -27648},{17531, -27684},{17474, -27720},{17417, -27756},{17361,
-27791},{17304, -27827},{17247, -27862},{17190, -27897},
        {17133, -27932},{17075, -27967},{17018, -28002},{16961, -28037},{16904, -28072},{16846, -28106},{16789,
-28140},{16731, -28175},{16673, -28209},{16616, -28243},
        {16558, -28277},{16500, -28311},{16442, -28344},{16384, -28378},{16326, -28411},{16268, -28445},{16210,
-28478},{16151, -28511},{16093, -28544},{16035, -28577},
        {15976, -28610},{15917, -28642},{15859, -28675},{15800, -28707},{15741, -28739},{15683, -28771},{15624,
-28803},{15565, -28835},{15506, -28867},{15447, -28899},
        {15388, -28930},{15328, -28962},{15269, -28993},{15210, -29024},{15150, -29055},{15091, -29086},{15031,
-29117},{14972, -29148},{14912, -29178},{14852, -29209},
        {14793, -29239},{14733, -29269},{14673, -29299},{14613, -29329},{14553, -29359},{14493, -29389},{14433,
-29418},{14373, -29448},{14312, -29477},{14252, -29506},
        {14192, -29535},{14131, -29564},{14071, -29593},{14010, -29622},{13950, -29651},{13889, -29679},{13828,
-29707},{13767, -29736},{13706, -29764},{13646, -29792},
        {13585, -29819},{13524, -29847},{13463, -29875},{13401, -29902},{13340, -29930},{13279, -29957},{13218,
-29984},{13156, -30011},{13095, -30038},{13033, -30064},
        {12972, -30091},{12910, -30118},{12849, -30144},{12787, -30170},{12725, -30196},{12664, -30222},{12602,
-30248},{12540, -30274},{12478, -30299},{12416, -30325},
        {12354, -30350},{12292, -30375},{12230, -30400},{12167, -30425},{12105, -30450},{12043, -30475},{11980,
-30499},{11918, -30524},{11856, -30548},{11793, -30572},
        {11730, -30596},{11668, -30620},{11605, -30644},{11543, -30668},{11480, -30691},{11417, -30715},{11354,
-30738},{11291, -30761},{11228, -30784},{11165, -30807},
        {11102, -30830},{11039, -30853},{10976, -30875},{10913, -30897},{10850, -30920},{10786, -30942},{10723,
-30964},{10660, -30986},{10596, -31007},{10533, -31029},
        {10469, -31050},{10406, -31072},{10342, -31093},{10279, -31114},{10215, -31135},{10151, -31156},{10088,
-31177},{10024, -31197},{9960, -31218},{9896, -31238},
        {9832, -31258},{9768, -31278},{9704, -31298},{9640, -31318},{9576, -31338},{9512, -31357},{9448, -31376},{9384,
-31396},{9319, -31415},{9255, -31434},
        {9191, -31453},{9127, -31471},{9062, -31490},{8998, -31508},{8933, -31527},{8869, -31545},{8804, -31563},{8740,
-31581},{8675, -31599},{8610, -31617},
        {8546, -31634},{8481, -31651},{8416, -31669},{8351, -31686},{8287, -31703},{8222, -31720},{8157, -31737},{8092,
-31753},{8027, -31770},{7962, -31786},
        {7897, -31802},{7832, -31818},{7767, -31834},{7702, -31850},{7637, -31866},{7571, -31881},{7506, -31897},{7441,
-31912},{7376, -31927},{7310, -31942},
        {7245, -31957},{7180, -31972},{7114, -31986},{7049, -32001},{6983, -32015},{6918, -32029},{6852, -32044},{6787,
-32058},{6721, -32071},{6655, -32085},
        {6590, -32099},{6524, -32112},{6458, -32125},{6393, -32138},{6327, -32151},{6261, -32164},{6195, -32177},{6130,
-32190},{6064, -32202},{5998, -32214},
        {5932, -32227},{5866, -32239},{5800, -32251},{5734, -32262},{5668, -32274},{5602, -32286},{5536, -32297},{5470,
-32308},{5404, -32319},{5338, -32330},
        {5272, -32341},{5205, -32352},{5139, -32362},{5073, -32373},{5007, -32383},{4941, -32393},{4874, -32403},{4808,
-32413},{4742, -32423},{4675, -32433},
        {4609, -32442},{4543, -32452},{4476, -32461},{4410, -32470},{4344, -32479},{4277, -32488},{4211, -32496},{4144,
-32505},{4078, -32513},{4011, -32522},
        {3945, -32530},{3878, -32538},{3812, -32546},{3745, -32553},{3678, -32561},{3612, -32568},{3545, -32576},{3479,
-32583},{3412, -32590},{3345, -32597},
        {3279, -32604},{3212, -32610},{3145, -32617},{3078, -32623},{3012, -32629},{2945, -32635},{2878, -32641},{2811,
-32647},{2745, -32653},{2678, -32658},
        {2611, -32664},{2544, -32669},{2477, -32674},{2411, -32679},{2344, -32684},{2277, -32689},{2210, -32693},{2143,
-32698},{2076, -32702},{2009, -32706},
        {1942, -32710},{1876, -32714},{1809, -32718},{1742, -32722},{1675, -32725},{1608, -32729},{1541, -32732},{1474,
-32735},{1407, -32738},{1340, -32741},
        {1273, -32743},{1206, -32746},{1139, -32748},{1072, -32750},{1005, -32753},{938, -32755},{871, -32756},{804,
-32758},{737, -32760},{670, -32761},
        {603, -32762},{536, -32764},{469, -32765},{402, -32766},{335, -32766},{268, -32767},{201, -32767},{134,
-32768},{67, -32768},{0, -32768},
        {-67, -32768},{-134, -32768},{-201, -32767},{-268, -32767},{-335, -32766},{-402, -32766},{-469, -32765},{-536,
-32764},{-603, -32762},{-670, -32761},
        {-737, -32760},{-804, -32758},{-871, -32756},{-938, -32755},{-1005, -32753},{-1072, -32750},{-1139,
-32748},{-1206, -32746},{-1273, -32743},{-1340, -32741},
        {-1407, -32738},{-1474, -32735},{-1541, -32732},{-1608, -32729},{-1675, -32725},{-1742, -32722},{-1809,
-32718},{-1876, -32714},{-1942, -32710},{-2009, -32706},
        {-2076, -32702},{-2143, -32698},{-2210, -32693},{-2277, -32689},{-2344, -32684},{-2411, -32679},{-2477,
-32674},{-2544, -32669},{-2611, -32664},{-2678, -32658},
        {-2745, -32653},{-2811, -32647},{-2878, -32641},{-2945, -32635},{-3012, -32629},{-3078, -32623},{-3145,
-32617},{-3212, -32610},{-3279, -32604},{-3345, -32597},
        {-3412, -32590},{-3479, -32583},{-3545, -32576},{-3612, -32568},{-3678, -32561},{-3745, -32553},{-3812,
-32546},{-3878, -32538},{-3945, -32530},{-4011, -32522},
        {-4078, -32513},{-4144, -32505},{-4211, -32496},{-4277, -32488},{-4344, -32479},{-4410, -32470},{-4476,
-32461},{-4543, -32452},{-4609, -32442},{-4675, -32433},
        {-4742, -32423},{-4808, -32413},{-4874, -32403},{-4941, -32393},{-5007, -32383},{-5073, -32373},{-5139,
-32362},{-5205, -32352},{-5272, -32341},{-5338, -32330},
        {-5404, -32319},{-5470, -32308},{-5536, -32297},{-5602, -32286},{-5668, -32274},{-5734, -32262},{-5800,
-32251},{-5866, -32239},{-5932, -32227},{-5998, -32214},
        {-6064, -32202},{-6130, -32190},{-6195, -32177},{-6261, -32164},{-6327, -32151},{-6393, -32138},{-6458,
-32125},{-6524, -32112},{-6590, -32099},{-6655, -32085},
        {-6721, -32071},{-6787, -32058},{-6852, -32044},{-6918, -32029},{-6983, -32015},{-7049, -32001},{-7114,
-31986},{-7180, -31972},{-7245, -31957},{-7310, -31942},
        {-7376, -31927},{-7441, -31912},{-7506, -31897},{-7571, -31881},{-7637, -31866},{-7702, -31850},{-7767,
-31834},{-7832, -31818},{-7897, -31802},{-7962, -31786},
        {-8027, -31770},{-8092, -31753},{-8157, -31737},{-8222, -31720},{-8287, -31703},{-8351, -31686},{-8416,
-31669},{-8481, -31651},{-8546, -31634},{-8610, -31617},
        {-8675, -31599},{-8740, -31581},{-8804, -31563},{-8869, -31545},{-8933, -31527},{-8998, -31508},{-9062,
-31490},{-9127, -31471},{-9191, -31453},{-9255, -31434},
        {-9319, -31415},{-9384, -31396},{-9448, -31376},{-9512, -31357},{-9576, -31338},{-9640, -31318},{-9704,
-31298},{-9768, -31278},{-9832, -31258},{-9896, -31238},
        {-9960, -31218},{-10024, -31197},{-10088, -31177},{-10151, -31156},{-10215, -31135},{-10279, -31114},{-10342,
-31093},{-10406, -31072},{-10469, -31050},{-10533, -31029},
        {-10596, -31007},{-10660, -30986},{-10723, -30964},{-10786, -30942},{-10850, -30920},{-10913, -30897},{-10976,
-30875},{-11039, -30853},{-11102, -30830},{-11165, -30807},
        {-11228, -30784},{-11291, -30761},{-11354, -30738},{-11417, -30715},{-11480, -30691},{-11543, -30668},{-11605,
-30644},{-11668, -30620},{-11730, -30596},{-11793, -30572},
        {-11856, -30548},{-11918, -30524},{-11980, -30499},{-12043, -30475},{-12105, -30450},{-12167, -30425},{-12230,
-30400},{-12292, -30375},{-12354, -30350},{-12416, -30325},
        {-12478, -30299},{-12540, -30274},{-12602, -30248},{-12664, -30222},{-12725, -30196},{-12787, -30170},{-12849,
-30144},{-12910, -30118},{-12972, -30091},{-13033, -30064},
        {-13095, -30038},{-13156, -30011},{-13218, -29984},{-13279, -29957},{-13340, -29930},{-13401, -29902},{-13463,
-29875},{-13524, -29847},{-13585, -29819},{-13646, -29792},
        {-13706, -29764},{-13767, -29736},{-13828, -29707},{-13889, -29679},{-13950, -29651},{-14010, -29622},{-14071,
-29593},{-14131, -29564},{-14192, -29535},{-14252, -29506},
        {-14312, -29477},{-14373, -29448},{-14433, -29418},{-14493, -29389},{-14553, -29359},{-14613, -29329},{-14673,
-29299},{-14733, -29269},{-14793, -29239},{-14852, -29209},
        {-14912, -29178},{-14972, -29148},{-15031, -29117},{-15091, -29086},{-15150, -29055},{-15210, -29024},{-15269,
-28993},{-15328, -28962},{-15388, -28930},{-15447, -28899},
        {-15506, -28867},{-15565, -28835},{-15624, -28803},{-15683, -28771},{-15741, -28739},{-15800, -28707},{-15859,
-28675},{-15917, -28642},{-15976, -28610},{-16035, -28577},
        {-16093, -28544},{-16151, -28511},{-16210, -28478},{-16268, -28445},{-16326, -28411},{-16384, -28378},{-16442,
-28344},{-16500, -28311},{-16558, -28277},{-16616, -28243},
        {-16673, -28209},{-16731, -28175},{-16789, -28140},{-16846, -28106},{-16904, -28072},{-16961, -28037},{-17018,
-28002},{-17075, -27967},{-17133, -27932},{-17190, -27897},
        {-17247, -27862},{-17304, -27827},{-17361, -27791},{-17417, -27756},{-17474, -27720},{-17531, -27684},{-17587,
-27648},{-17644, -27612},{-17700, -27576},{-17757, -27540},
        {-17813, -27503},{-17869, -27467},{-17925, -27430},{-17981, -27394},{-18037, -27357},{-18093, -27320},{-18149,
-27283},{-18205, -27246},{-18261, -27208},{-18316, -27171},
        {-18372, -27133},{-18427, -27096},{-18483, -27058},{-18538, -27020},{-18593, -26982},{-18648, -26944},{-18703,
-26906},{-18758, -26868},{-18813, -26829},{-18868, -26791},
        {-18923, -26752},{-18978, -26713},{-19032, -26674},{-19087, -26635},{-19141, -26596},{-19195, -26557},{-19250,
-26518},{-19304, -26478},{-19358, -26439},{-19412, -26399},
        {-19466, -26359},{-19520, -26320},{-19574, -26280},{-19627, -26239},{-19681, -26199},{-19735, -26159},{-19788,
-26119},{-19841, -26078},{-19895, -26037},{-19948, -25997},
        {-20001, -25956},{-20054, -25915},{-20107, -25874},{-20160, -25833},{-20213, -25791},{-20265, -25750},{-20318,
-25708},{-20371, -25667},{-20423, -25625},{-20475, -25583},
        {-20528, -25541},{-20580, -25499},{-20632, -25457},{-20684, -25415},{-20736, -25372},{-20788, -25330},{-20840,
-25287},{-20891, -25245},{-20943, -25202},{-20994, -25159},
        {-21046, -25116},{-21097, -25073},{-21148, -25030},{-21199, -24986},{-21251, -24943},{-21301, -24900},{-21352,
-24856},{-21403, -24812},{-21454, -24768},{-21504, -24724},
        {-21555, -24680},{-21605, -24636},{-21656, -24592},{-21706, -24548},{-21756, -24503},{-21806, -24459},{-21856,
-24414},{-21906, -24369},{-21956, -24324},{-22006, -24279},
        {-22055, -24234},{-22105, -24189},{-22154, -24144},{-22204, -24099},{-22253, -24053},{-22302, -24008},{-22351,
-23962},{-22400, -23916},{-22449, -23870},{-22498, -23824},
        {-22546, -23778},{-22595, -23732},{-22643, -23686},{-22692, -23640},{-22740, -23593},{-22788, -23546},{-22836,
-23500},{-22884, -23453},{-22932, -23406},{-22980, -23359},
        {-23028, -23312},{-23075, -23265},{-23123, -23218},{-23170, -23170},{-23218, -23123},{-23265, -23075},{-23312,
-23028},{-23359, -22980},{-23406, -22932},{-23453, -22884},
        {-23500, -22836},{-23546, -22788},{-23593, -22740},{-23640, -22692},{-23686, -22643},{-23732, -22595},{-23778,
-22546},{-23824, -22498},{-23870, -22449},{-23916, -22400},
        {-23962, -22351},{-24008, -22302},{-24053, -22253},{-24099, -22204},{-24144, -22154},{-24189, -22105},{-24234,
-22055},{-24279, -22006},{-24324, -21956},{-24369, -21906},
        {-24414, -21856},{-24459, -21806},{-24503, -21756},{-24548, -21706},{-24592, -21656},{-24636, -21605},{-24680,
-21555},{-24724, -21504},{-24768, -21454},{-24812, -21403},
        {-24856, -21352},{-24900, -21301},{-24943, -21251},{-24986, -21199},{-25030, -21148},{-25073, -21097},{-25116,
-21046},{-25159, -20994},{-25202, -20943},{-25245, -20891},
        {-25287, -20840},{-25330, -20788},{-25372, -20736},{-25415, -20684},{-25457, -20632},{-25499, -20580},{-25541,
-20528},{-25583, -20475},{-25625, -20423},{-25667, -20371},
        {-25708, -20318},{-25750, -20265},{-25791, -20213},{-25833, -20160},{-25874, -20107},{-25915, -20054},{-25956,
-20001},{-25997, -19948},{-26037, -19895},{-26078, -19841},
        {-26119, -19788},{-26159, -19735},{-26199, -19681},{-26239, -19627},{-26280, -19574},{-26320, -19520},{-26359,
-19466},{-26399, -19412},{-26439, -19358},{-26478, -19304},
        {-26518, -19250},{-26557, -19195},{-26596, -19141},{-26635, -19087},{-26674, -19032},{-26713, -18978},{-26752,
-18923},{-26791, -18868},{-26829, -18813},{-26868, -18758},
        {-26906, -18703},{-26944, -18648},{-26982, -18593},{-27020, -18538},{-27058, -18483},{-27096, -18427},{-27133,
-18372},{-27171, -18316},{-27208, -18261},{-27246, -18205},
        {-27283, -18149},{-27320, -18093},{-27357, -18037},{-27394, -17981},{-27430, -17925},{-27467, -17869},{-27503,
-17813},{-27540, -17757},{-27576, -17700},{-27612, -17644},
        {-27648, -17587},{-27684, -17531},{-27720, -17474},{-27756, -17417},{-27791, -17361},{-27827, -17304},{-27862,
-17247},{-27897, -17190},{-27932, -17133},{-27967, -17075},
        {-28002, -17018},{-28037, -16961},{-28072, -16904},{-28106, -16846},{-28140, -16789},{-28175, -16731},{-28209,
-16673},{-28243, -16616},{-28277, -16558},{-28311, -16500},
        {-28344, -16442},{-28378, -16384},{-28411, -16326},{-28445, -16268},{-28478, -16210},{-28511, -16151},{-28544,
-16093},{-28577, -16035},{-28610, -15976},{-28642, -15917},
        {-28675, -15859},{-28707, -15800},{-28739, -15741},{-28771, -15683},{-28803, -15624},{-28835, -15565},{-28867,
-15506},{-28899, -15447},{-28930, -15388},{-28962, -15328},
        {-28993, -15269},{-29024, -15210},{-29055, -15150},{-29086, -15091},{-29117, -15031},{-29148, -14972},{-29178,
-14912},{-29209, -14852},{-29239, -14793},{-29269, -14733},
        {-29299, -14673},{-29329, -14613},{-29359, -14553},{-29389, -14493},{-29418, -14433},{-29448, -14373},{-29477,
-14312},{-29506, -14252},{-29535, -14192},{-29564, -14131},
        {-29593, -14071},{-29622, -14010},{-29651, -13950},{-29679, -13889},{-29707, -13828},{-29736, -13767},{-29764,
-13706},{-29792, -13646},{-29819, -13585},{-29847, -13524},
        {-29875, -13463},{-29902, -13401},{-29930, -13340},{-29957, -13279},{-29984, -13218},{-30011, -13156},{-30038,
-13095},{-30064, -13033},{-30091, -12972},{-30118, -12910},
        {-30144, -12849},{-30170, -12787},{-30196, -12725},{-30222, -12664},{-30248, -12602},{-30274, -12540},{-30299,
-12478},{-30325, -12416},{-30350, -12354},{-30375, -12292},
        {-30400, -12230},{-30425, -12167},{-30450, -12105},{-30475, -12043},{-30499, -11980},{-30524, -11918},{-30548,
-11856},{-30572, -11793},{-30596, -11730},{-30620, -11668},
        {-30644, -11605},{-30668, -11543},{-30691, -11480},{-30715, -11417},{-30738, -11354},{-30761, -11291},{-30784,
-11228},{-30807, -11165},{-30830, -11102},{-30853, -11039},
        {-30875, -10976},{-30897, -10913},{-30920, -10850},{-30942, -10786},{-30964, -10723},{-30986, -10660},{-31007,
-10596},{-31029, -10533},{-31050, -10469},{-31072, -10406},
        {-31093, -10342},{-31114, -10279},{-31135, -10215},{-31156, -10151},{-31177, -10088},{-31197, -10024},{-31218,
-9960},{-31238, -9896},{-31258, -9832},{-31278, -9768},
        {-31298, -9704},{-31318, -9640},{-31338, -9576},{-31357, -9512},{-31376, -9448},{-31396, -9384},{-31415,
-9319},{-31434, -9255},{-31453, -9191},{-31471, -9127},
        {-31490, -9062},{-31508, -8998},{-31527, -8933},{-31545, -8869},{-31563, -8804},{-31581, -8740},{-31599,
-8675},{-31617, -8610},{-31634, -8546},{-31651, -8481},
        {-31669, -8416},{-31686, -8351},{-31703, -8287},{-31720, -8222},{-31737, -8157},{-31753, -8092},{-31770,
-8027},{-31786, -7962},{-31802, -7897},{-31818, -7832},
        {-31834, -7767},{-31850, -7702},{-31866, -7637},{-31881, -7571},{-31897, -7506},{-31912, -7441},{-31927,
-7376},{-31942, -7310},{-31957, -7245},{-31972, -7180},
        {-31986, -7114},{-32001, -7049},{-32015, -6983},{-32029, -6918},{-32044, -6852},{-32058, -6787},{-32071,
-6721},{-32085, -6655},{-32099, -6590},{-32112, -6524},
        {-32125, -6458},{-32138, -6393},{-32151, -6327},{-32164, -6261},{-32177, -6195},{-32190, -6130},{-32202,
-6064},{-32214, -5998},{-32227, -5932},{-32239, -5866},
        {-32251, -5800},{-32262, -5734},{-32274, -5668},{-32286, -5602},{-32297, -5536},{-32308, -5470},{-32319,
-5404},{-32330, -5338},{-32341, -5272},{-32352, -5205},
        {-32362, -5139},{-32373, -5073},{-32383, -5007},{-32393, -4941},{-32403, -4874},{-32413, -4808},{-32423,
-4742},{-32433, -4675},{-32442, -4609},{-32452, -4543},
        {-32461, -4476},{-32470, -4410},{-32479, -4344},{-32488, -4277},{-32496, -4211},{-32505, -4144},{-32513,
-4078},{-32522, -4011},{-32530, -3945},{-32538, -3878},
        {-32546, -3812},{-32553, -3745},{-32561, -3678},{-32568, -3612},{-32576, -3545},{-32583, -3479},{-32590,
-3412},{-32597, -3345},{-32604, -3279},{-32610, -3212},
        {-32617, -3145},{-32623, -3078},{-32629, -3012},{-32635, -2945},{-32641, -2878},{-32647, -2811},{-32653,
-2745},{-32658, -2678},{-32664, -2611},{-32669, -2544},
        {-32674, -2477},{-32679, -2411},{-32684, -2344},{-32689, -2277},{-32693, -2210},{-32698, -2143},{-32702,
-2076},{-32706, -2009},{-32710, -1942},{-32714, -1876},
        {-32718, -1809},{-32722, -1742},{-32725, -1675},{-32729, -1608},{-32732, -1541},{-32735, -1474},{-32738,
-1407},{-32741, -1340},{-32743, -1273},{-32746, -1206},
        {-32748, -1139},{-32750, -1072},{-32753, -1005},{-32755, -938},{-32756, -871},{-32758, -804},{-32760,
-737},{-32761, -670},{-32762, -603},{-32764, -536},
        {-32765, -469},{-32766, -402},{-32766, -335},{-32767, -268},{-32767, -201},{-32768, -134},{-32768, -67}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw12o2[FFT_12] = {{32767, 0},{28378, -16384},{16384, -28378},{0,
-32768},{-16384,
-28378},{-28378, -16384},
        {-32768, 0},{-28378, 16384},{-16384, 28378},{0, 32767},{16384, 28378},{28378, 16384}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw12o4[FFT_12] = {{32767, 0},{16384, -28378},{-16384,
-28378},{-32768, 0},{-16384,
28378},{16384, 28378},
        {32767, 0},{16384, -28378},{-16384, -28378},{-32768, 0},{-16384, 28378},{16384, 28378}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw3[FFT_3] = {{32767, 0},{16384, -28378},{-16384, -28378}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw3o2[FFT_3] = {{32767, 0},{-16384, -28378},{-16384, 28378}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw3o4[FFT_3] = {{32767, 0},{-16384, 28378},{-16384, -28378}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw9[FFT_9] = {{32767, 0},{30792, -11207},{25102, -21063},{16384,
-28378},{5690,
-32270},{-5690, -32270},
        {-16384, -28378},{-25102, -21063},{-30792, -11207}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw9o2[FFT_9] = {{32767, 0},{25102, -21063},{5690, -32270},{-16384,
-28378},{-30792,
-11207},{-30792, 11207},
        {-16384, 28378},{5690, 32270},{25102, 21063}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw9o4[FFT_9] = {{32767, 0},{5690, -32270},{-30792, -11207},{-16384,
28378},{25102,
21063},{25102, -21063},
        {-16384, -28378},{-30792, 11207},{5690, 32270}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw18[FFT_18] = {{32767, 0},{32270, -5690},{30792, -11207},{28378,
-16384},{25102,
-21063},{21063, -25102},
        {16384, -28378},{11207, -30792},{5690, -32270},{0, -32768},{-5690, -32270},{-11207, -30792},{-16384,
-28378},{-21063, -25102},{-25102, -21063},{-28378, -16384},
        {-30792, -11207},{-32270, -5690}};


    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw15o2[FFT_15] = {{32767, 0},{29935, -13328},{21926, -24351},{10126,
-31164},{-3425,
-32588},{-16384, -28378},{-26510, -19261},{-32052, -6813},{-32052, 6813},
        {-26510, 19261},{-16384, 28378},{-3425, 32588},{10126, 31164},{21926, 24351},{29935, 13328}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw15o4[FFT_15] = {{32767, 0},{21926, -24351},{-3425, -32588},{-26510,
-19261},{-32052,
6813},{-16384, 28378},{10126, 31164},{29935, 13328},{29935, -13328},
        {10126, -31164},{-16384, -28378},{-32052, -6813},{-26510, 19261},{-3425, 32588},{21926, 24351}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw15o6[FFT_15] = {{32767, 0},{10126, -31164},{-26510,
-19261},{-26510, 19261},{10126,
31164},{32767, 0},{10126, -31164},{-26510, -19261},{-26510, 19261},
        {10126, 31164},{32767, 0},{10126, -31164},{-26510, -19261},{-26510, 19261},{10126, 31164}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw15o8[FFT_15] = {{32767, 0},{-3425, -32588},{-32052, 6813},{10126,
31164},{29935,
-13328},{-16384, -28378},{-26510, 19261},{21926, 24351},{21926, -24351},
        {-26510, -19261},{-16384, 28378},{29935, 13328},{10126, -31164},{-32052, -6813},{-3425, 32588}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw150[FFT_150] = {{32767, 0},{32761, -686},{32739, -1372},{32703,
-2058},{32653,
-2742},{32588, -3425},{32510, -4107},{32416, -4787},{32309, -5465},
        {32188, -6140},{32052, -6813},{31902, -7483},{31739, -8149},{31561, -8812},{31369, -9471},{31164,
-10126},{30945, -10776},{30713, -11422},{30467, -12063},
        {30208, -12698},{29935, -13328},{29649, -13952},{29351, -14570},{29039, -15181},{28715, -15786},{28378,
-16384},{28029, -16975},{27667, -17558},{27293, -18134},
        {26907, -18701},{26510, -19261},{26101, -19812},{25680, -20354},{25248, -20887},{24805, -21411},{24351,
-21926},{23887, -22431},{23412, -22927},{22927, -23412},
        {22431, -23887},{21926, -24351},{21411, -24805},{20887, -25248},{20354, -25680},{19812, -26101},{19261,
-26510},{18701, -26907},{18134, -27293},{17558, -27667},
        {16975, -28029},{16384, -28378},{15786, -28715},{15181, -29039},{14570, -29351},{13952, -29649},{13328,
-29935},{12698, -30208},{12063, -30467},{11422, -30713},
        {10776, -30945},{10126, -31164},{9471, -31369},{8812, -31561},{8149, -31739},{7483, -31902},{6813,
-32052},{6140, -32188},{5465, -32309},{4787, -32416},
        {4107, -32510},{3425, -32588},{2742, -32653},{2058, -32703},{1372, -32739},{686, -32761},{0, -32768},{-686,
-32761},{-1372, -32739},{-2058, -32703},
        {-2742, -32653},{-3425, -32588},{-4107, -32510},{-4787, -32416},{-5465, -32309},{-6140, -32188},{-6813,
-32052},{-7483, -31902},{-8149, -31739},{-8812, -31561},
        {-9471, -31369},{-10126, -31164},{-10776, -30945},{-11422, -30713},{-12063, -30467},{-12698, -30208},{-13328,
-29935},{-13952, -29649},{-14570, -29351},{-15181, -29039},
        {-15786, -28715},{-16384, -28378},{-16975, -28029},{-17558, -27667},{-18134, -27293},{-18701, -26907},{-19261,
-26510},{-19812, -26101},{-20354, -25680},{-20887, -25248},
        {-21411, -24805},{-21926, -24351},{-22431, -23887},{-22927, -23412},{-23412, -22927},{-23887, -22431},{-24351,
-21926},{-24805, -21411},{-25248, -20887},{-25680, -20354},
        {-26101, -19812},{-26510, -19261},{-26907, -18701},{-27293, -18134},{-27667, -17558},{-28029, -16975},{-28378,
-16384},{-28715, -15786},{-29039, -15181},{-29351, -14570},
        {-29649, -13952},{-29935, -13328},{-30208, -12698},{-30467, -12063},{-30713, -11422},{-30945, -10776},{-31164,
-10126},{-31369, -9471},{-31561, -8812},{-31739, -8149},
        {-31902, -7483},{-32052, -6813},{-32188, -6140},{-32309, -5465},{-32416, -4787},{-32510, -4107},{-32588,
-3425},{-32653, -2742},{-32703, -2058},{-32739, -1372},
        {-32761, -686}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw75[FFT_75] = {{32767, 0},{32739, -1372},{32653, -2742},{32510,
-4107},{32309,
-5465},{32052, -6813},{31739, -8149},{31369, -9471},{30945, -10776},
        {30467, -12063},{29935, -13328},{29351, -14570},{28715, -15786},{28029, -16975},{27293, -18134},{26510,
-19261},{25680, -20354},{24805, -21411},{23887, -22431},
        {22927, -23412},{21926, -24351},{20887, -25248},{19812, -26101},{18701, -26907},{17558, -27667},{16384,
-28378},{15181, -29039},{13952, -29649},{12698, -30208},
        {11422, -30713},{10126, -31164},{8812, -31561},{7483, -31902},{6140, -32188},{4787, -32416},{3425,
-32588},{2058, -32703},{686, -32761},{-686, -32761},
        {-2058, -32703},{-3425, -32588},{-4787, -32416},{-6140, -32188},{-7483, -31902},{-8812, -31561},{-10126,
-31164},{-11422, -30713},{-12698, -30208},{-13952, -29649},
        {-15181, -29039},{-16384, -28378},{-17558, -27667},{-18701, -26907},{-19812, -26101},{-20887, -25248},{-21926,
-24351},{-22927, -23412},{-23887, -22431},{-24805, -21411},
        {-25680, -20354},{-26510, -19261},{-27293, -18134},{-28029, -16975},{-28715, -15786},{-29351, -14570},{-29935,
-13328},{-30467, -12063},{-30945, -10776},{-31369, -9471},
        {-31739, -8149},{-32052, -6813},{-32309, -5465},{-32510, -4107},{-32653, -2742},{-32739, -1372}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw75o2[FFT_75] = {{32767, 0},{32653, -2742},{32309, -5465},{31739,
-8149},{30945,
-10776},{29935, -13328},{28715, -15786},{27293, -18134},{25680, -20354},
        {23887, -22431},{21926, -24351},{19812, -26101},{17558, -27667},{15181, -29039},{12698, -30208},{10126,
-31164},{7483, -31902},{4787, -32416},{2058, -32703},
        {-686, -32761},{-3425, -32588},{-6140, -32188},{-8812, -31561},{-11422, -30713},{-13952, -29649},{-16384,
-28378},{-18701, -26907},{-20887, -25248},{-22927, -23412},
        {-24805, -21411},{-26510, -19261},{-28029, -16975},{-29351, -14570},{-30467, -12063},{-31369, -9471},{-32052,
-6813},{-32510, -4107},{-32739, -1372},{-32739, 1372},
        {-32510, 4107},{-32052, 6813},{-31369, 9471},{-30467, 12063},{-29351, 14570},{-28029, 16975},{-26510,
19261},{-24805, 21411},{-22927, 23412},{-20887, 25248},
        {-18701, 26907},{-16384, 28378},{-13952, 29649},{-11422, 30713},{-8812, 31561},{-6140, 32188},{-3425,
32588},{-686, 32761},{2058, 32703},{4787, 32416},
        {7483, 31902},{10126, 31164},{12698, 30208},{15181, 29039},{17558, 27667},{19812, 26101},{21926, 24351},{23887,
22431},{25680, 20354},{27293, 18134},
        {28715, 15786},{29935, 13328},{30945, 10776},{31739, 8149},{32309, 5465},{32653, 2742}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw75o4[FFT_75] = {{32767, 0},{32309, -5465},{30945, -10776},{28715,
-15786},{25680,
-20354},{21926, -24351},{17558, -27667},{12698, -30208},{7483, -31902},
        {2058, -32703},{-3425, -32588},{-8812, -31561},{-13952, -29649},{-18701, -26907},{-22927, -23412},{-26510,
-19261},{-29351, -14570},{-31369, -9471},{-32510, -4107},
        {-32739, 1372},{-32052, 6813},{-30467, 12063},{-28029, 16975},{-24805, 21411},{-20887, 25248},{-16384,
28378},{-11422, 30713},{-6140, 32188},{-686, 32761},
        {4787, 32416},{10126, 31164},{15181, 29039},{19812, 26101},{23887, 22431},{27293, 18134},{29935, 13328},{31739,
8149},{32653, 2742},{32653, -2742},
        {31739, -8149},{29935, -13328},{27293, -18134},{23887, -22431},{19812, -26101},{15181, -29039},{10126,
-31164},{4787, -32416},{-686, -32761},{-6140, -32188},
        {-11422, -30713},{-16384, -28378},{-20887, -25248},{-24805, -21411},{-28029, -16975},{-30467, -12063},{-32052,
-6813},{-32739, -1372},{-32510, 4107},{-31369, 9471},
        {-29351, 14570},{-26510, 19261},{-22927, 23412},{-18701, 26907},{-13952, 29649},{-8812, 31561},{-3425,
32588},{2058, 32703},{7483, 31902},{12698, 30208},
        {17558, 27667},{21926, 24351},{25680, 20354},{28715, 15786},{30945, 10776},{32309, 5465}};
    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw75o6[FFT_75] = {{32767, 0},{31739, -8149},{28715, -15786},{23887,
-22431},{17558,
-27667},{10126, -31164},{2058, -32703},{-6140, -32188},{-13952, -29649},
        {-20887, -25248},{-26510, -19261},{-30467, -12063},{-32510, -4107},{-32510, 4107},{-30467, 12063},{-26510,
19261},{-20887, 25248},{-13952, 29649},{-6140, 32188},
        {2058, 32703},{10126, 31164},{17558, 27667},{23887, 22431},{28715, 15786},{31739, 8149},{32767, 0},{31739,
-8149},{28715, -15786},{23887, -22431},
        {17558, -27667},{10126, -31164},{2058, -32703},{-6140, -32188},{-13952, -29649},{-20887, -25248},{-26510,
-19261},{-30467, -12063},{-32510, -4107},{-32510, 4107},
        {-30467, 12063},{-26510, 19261},{-20887, 25248},{-13952, 29649},{-6140, 32188},{2058, 32703},{10126,
31164},{17558, 27667},{23887, 22431},{28715, 15786},
        {31739, 8149},{32767, 0},{31739, -8149},{28715, -15786},{23887, -22431},{17558, -27667},{10126, -31164},{2058,
-32703},{-6140, -32188},{-13952, -29649},
        {-20887, -25248},{-26510, -19261},{-30467, -12063},{-32510, -4107},{-32510, 4107},{-30467, 12063},{-26510,
19261},{-20887, 25248},{-13952, 29649},{-6140, 32188},
        {2058, 32703},{10126, 31164},{17558, 27667},{23887, 22431},{28715, 15786},{31739, 8149}};

    cint16_t alignas(__ALIGN_BYTE_SIZE__)  fft_lut_tw75o8[FFT_75] = {{32767, 0},{30945, -10776},{25680, -20354},{17558,
-27667},{7483,
-31902},{-3425, -32588},{-13952, -29649},{-22927, -23412},{-29351, -14570},
        {-32510, -4107},{-32052, 6813},{-28029, 16975},{-20887, 25248},{-11422, 30713},{-686, 32761},{10126,
31164},{19812, 26101},{27293, 18134},{31739, 8149},
        {32653, -2742},{29935, -13328},{23887, -22431},{15181, -29039},{4787, -32416},{-6140, -32188},{-16384,
-28378},{-24805, -21411},{-30467, -12063},{-32739, -1372},
        {-31369, 9471},{-26510, 19261},{-18701, 26907},{-8812, 31561},{2058, 32703},{12698, 30208},{21926,
24351},{28715, 15786},{32309, 5465},{32309, -5465},
        {28715, -15786},{21926, -24351},{12698, -30208},{2058, -32703},{-8812, -31561},{-18701, -26907},{-26510,
-19261},{-31369, -9471},{-32739, 1372},{-30467, 12063},
        {-24805, 21411},{-16384, 28378},{-6140, 32188},{4787, 32416},{15181, 29039},{23887, 22431},{29935,
13328},{32653, 2742},{31739, -8149},{27293, -18134},
        {19812, -26101},{10126, -31164},{-686, -32761},{-11422, -30713},{-20887, -25248},{-28029, -16975},{-32052,
-6813},{-32510, 4107},{-29351, 14570},{-22927, 23412},
        {-13952, 29649},{-3425, 32588},{7483, 31902},{17558, 27667},{25680, 20354},{30945, 10776}};
*/

#endif // __FFT_TWIDDLE_LUT_DIT_H__
